"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.messages = exports.ruleName = undefined;

exports.default = function (blacklistInput) {
  var blacklist = [].concat(blacklistInput);
  return function (root, result) {
    var validOptions = (0, _utils.validateOptions)(result, ruleName, {
      actual: blacklist,
      possible: [_lodash.isString]
    });
    if (!validOptions) {
      return;
    }

    root.walkRules(function (rule) {
      if (!(0, _utils.isStandardRule)(rule)) {
        return;
      }
      if (rule.selector.indexOf("[") === -1 || rule.selector.indexOf("=") === -1) {
        return;
      }

      (0, _utils.parseSelector)(rule.selector, result, rule, function (selectorTree) {
        selectorTree.walkAttributes(function (attributeNode) {
          var operator = attributeNode.operator;

          if (!operator) {
            return;
          }

          if (!operator || operator && blacklist.indexOf(operator) === -1) {
            return;
          }

          (0, _utils.report)({
            message: messages.rejected(operator),
            node: rule,
            index: attributeNode.attribute.length + 1,
            result: result,
            ruleName: ruleName
          });
        });
      });
    });
  };
};

var _lodash = require("lodash");

var _utils = require("../../utils");

var ruleName = exports.ruleName = "selector-attribute-operator-blacklist";

var messages = exports.messages = (0, _utils.ruleMessages)(ruleName, {
  rejected: function rejected(operator) {
    return "Unexpected operator \"" + operator + "\"";
  }
});