"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.messages = exports.ruleName = undefined;

exports.default = function (expectation) {
  return function (root, result) {
    var checker = (0, _utils.whitespaceChecker)("space", expectation, messages);
    var validOptions = (0, _utils.validateOptions)(result, ruleName, {
      actual: expectation,
      possible: ["always", "never"]
    });
    if (!validOptions) {
      return;
    }

    selectorAttributeOperatorSpaceChecker({
      root: root,
      result: result,
      locationChecker: checker.after,
      checkedRuleName: ruleName,
      checkBeforeOperator: false
    });
  };
};

exports.selectorAttributeOperatorSpaceChecker = selectorAttributeOperatorSpaceChecker;

var _utils = require("../../utils");

var ruleName = exports.ruleName = "selector-attribute-operator-space-after";

var messages = exports.messages = (0, _utils.ruleMessages)(ruleName, {
  expectedAfter: function expectedAfter(operator) {
    return "Expected single space after \"" + operator + "\"";
  },
  rejectedAfter: function rejectedAfter(operator) {
    return "Unexpected whitespace after \"" + operator + "\"";
  }
});

function selectorAttributeOperatorSpaceChecker(_ref) {
  var locationChecker = _ref.locationChecker;
  var root = _ref.root;
  var result = _ref.result;
  var checkedRuleName = _ref.checkedRuleName;
  var checkBeforeOperator = _ref.checkBeforeOperator;

  root.walkRules(function (rule) {
    if (!(0, _utils.isStandardRule)(rule)) {
      return;
    }
    if (rule.selector.indexOf("[") === -1 || rule.selector.indexOf("=") === -1) {
      return;
    }

    (0, _utils.parseSelector)(rule.selector, result, rule, function (selectorTree) {
      selectorTree.walkAttributes(function (attributeNode) {
        var operator = attributeNode.operator;

        if (!operator) {
          return;
        }

        var attributeNodeString = attributeNode.toString();

        (0, _utils.styleSearch)({ source: attributeNodeString, target: operator }, function (match) {
          var index = checkBeforeOperator ? match.startIndex : match.endIndex - 1;
          checkOperator(attributeNodeString, index, rule, attributeNode.sourceIndex, operator);
        });
      });
    });

    function checkOperator(source, index, node, attributeIndex, operator) {
      locationChecker({
        source: source,
        index: index,
        err: function err(m) {
          return (0, _utils.report)({
            message: m.replace(checkBeforeOperator ? operator[0] : operator[operator.length - 1], operator),
            node: node,
            index: attributeIndex + index,
            result: result,
            ruleName: checkedRuleName
          });
        }
      });
    }
  });
}