"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.messages = exports.ruleName = undefined;

exports.default = function (expectation) {
  var checker = (0, _utils.whitespaceChecker)("space", expectation, messages);
  return function (root, result) {
    var validOptions = (0, _utils.validateOptions)(result, ruleName, {
      actual: expectation,
      possible: ["always", "never"]
    });
    if (!validOptions) {
      return;
    }

    (0, _selectorAttributeOperatorSpaceAfter.selectorAttributeOperatorSpaceChecker)({
      root: root,
      result: result,
      locationChecker: checker.before,
      checkedRuleName: ruleName,
      checkBeforeOperator: true
    });
  };
};

var _utils = require("../../utils");

var _selectorAttributeOperatorSpaceAfter = require("../selector-attribute-operator-space-after");

var ruleName = exports.ruleName = "selector-attribute-operator-space-before";

var messages = exports.messages = (0, _utils.ruleMessages)(ruleName, {
  expectedBefore: function expectedBefore(operator) {
    return "Expected single space before \"" + operator + "\"";
  },
  rejectedBefore: function rejectedBefore(operator) {
    return "Unexpected whitespace before \"" + operator + "\"";
  }
});