"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.messages = exports.ruleName = undefined;

exports.default = function (pattern) {
  return function (root, result) {
    var validOptions = (0, _utils.validateOptions)(result, ruleName, {
      actual: pattern,
      possible: [_lodash.isRegExp, _lodash.isString]
    });
    if (!validOptions) {
      return;
    }

    var normalizedPattern = (0, _lodash.isString)(pattern) ? new RegExp(pattern) : pattern;

    root.walkRules(function (rule) {
      if (!(0, _utils.isStandardRule)(rule)) {
        return;
      }

      var selector = rule.selector;

      if (!(0, _utils.isStandardSelector)(selector)) {
        return;
      }

      (0, _utils.parseSelector)(selector, result, rule, function (fullSelector) {
        fullSelector.walk(function (selectorNode) {
          if (selectorNode.type !== "id") {
            return;
          }
          var value = selectorNode.value;
          var sourceIndex = selectorNode.sourceIndex;


          if (normalizedPattern.test(value)) {
            return;
          }

          (0, _utils.report)({
            result: result,
            ruleName: ruleName,
            message: messages.expected(value),
            node: rule,
            index: sourceIndex
          });
        });
      });
    });
  };
};

var _lodash = require("lodash");

var _utils = require("../../utils");

var ruleName = exports.ruleName = "selector-id-pattern";

var messages = exports.messages = (0, _utils.ruleMessages)(ruleName, {
  expected: function expected(selectorValue) {
    return "Expected id selector \"#" + selectorValue + "\" to match specified pattern";
  }
});