"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.messages = exports.ruleName = undefined;

exports.default = function (max) {
  var maxAdjacentNewlines = max + 1;

  return function (root, result) {
    var validOptions = (0, _utils.validateOptions)(result, ruleName, {
      actual: max,
      possible: _lodash.isNumber
    });
    if (!validOptions) {
      return;
    }

    root.walkRules(function (rule) {
      var selector = rule.raws.selector ? rule.raws.selector.raw : rule.selector;
      var repeatLFNewLines = (0, _lodash.repeat)("\n", maxAdjacentNewlines);
      var repeatCRLFNewLines = (0, _lodash.repeat)("\r\n", maxAdjacentNewlines);

      (0, _utils.styleSearch)({ source: selector, target: "\n" }, function (match) {
        if (selector.substr(match.startIndex + 1, maxAdjacentNewlines) === repeatLFNewLines || selector.substr(match.startIndex + 1, maxAdjacentNewlines * 2) === repeatCRLFNewLines) {
          // Put index at `\r` if it's CRLF, otherwise leave it at `\n`
          var index = match.startIndex;
          if (selector[index - 1] === "\r") {
            index -= 1;
          }

          (0, _utils.report)({
            message: messages.rejected,
            node: rule,
            index: index,
            result: result,
            ruleName: ruleName
          });
        }
      });
    });
  };
};

var _lodash = require("lodash");

var _utils = require("../../utils");

var ruleName = exports.ruleName = "selector-max-empty-lines";

var messages = exports.messages = (0, _utils.ruleMessages)(ruleName, {
  rejected: "Unexpected empty line within selector"
});