"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.messages = exports.ruleName = undefined;

exports.default = function (on, options) {
  return function (root, result) {
    var validOptions = (0, _utils.validateOptions)(result, ruleName, { actual: on }, {
      actual: options,
      possible: {
        ignore: ["descendant", "compounded"]
      },
      optional: true
    });
    if (!validOptions) {
      return;
    }

    var ignoreDescendant = (0, _utils.optionsHaveIgnored)(options, "descendant");
    var ignoreCompounded = (0, _utils.optionsHaveIgnored)(options, "compounded");

    root.walkRules(function (rule) {

      if (!(0, _utils.isStandardRule)(rule)) {
        return;
      }
      if ((0, _utils.isKeyframeRule)(rule)) {
        return;
      }
      var selector = rule.selector;

      if (!(0, _utils.isStandardSelector)(selector)) {
        return;
      }

      (0, _utils.parseSelector)(selector, result, rule, function (selectorAST) {
        selectorAST.walkTags(function (tag) {

          if (!(0, _utils.isStandardTypeSelector)(tag)) {
            return;
          }

          if (ignoreDescendant && hasCombinatorBefore(tag)) {
            return;
          }

          if (ignoreCompounded && isCompounded(tag)) {
            return;
          }

          (0, _utils.report)({
            message: messages.rejected,
            node: rule,
            index: tag.sourceIndex,
            ruleName: ruleName,
            result: result
          });
        });
      });
    });
  };
};

var _lodash = require("lodash");

var _utils = require("../../utils");

var ruleName = exports.ruleName = "selector-no-type";

var messages = exports.messages = (0, _utils.ruleMessages)(ruleName, {
  rejected: "Unexpected type selector"
});

function hasCombinatorBefore(node) {
  return node.parent.nodes.slice(0, node.parent.nodes.indexOf(node)).some(isCombinator);
}

function isCompounded(node) {
  if (node.prev() && !isCombinator(node.prev())) {
    return true;
  }
  if (node.next() && !isCombinator(node.next())) {
    return true;
  }
  return false;
}

function isCombinator(node) {
  if (!node) return false;
  return (0, _lodash.get)(node, "type") === "combinator";
}