"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.messages = exports.ruleName = undefined;

exports.default = function (actual) {
  return function (root, result) {
    var validOptions = (0, _utils.validateOptions)(result, ruleName, { actual: actual });
    if (!validOptions) {
      return;
    }

    root.walkRules(function (rule) {
      if (!(0, _utils.isStandardRule)(rule)) {
        return;
      }
      var selector = rule.selector;

      if (!(0, _utils.isStandardSelector)(selector)) {
        return;
      }
      (0, _utils.parseSelector)(selector, result, rule, function (selectorAST) {
        selectorAST.walkUniversals(function (universal) {
          (0, _utils.report)({
            message: messages.rejected,
            node: rule,
            index: universal.sourceIndex,
            ruleName: ruleName,
            result: result
          });
        });
      });
    });
  };
};

var _utils = require("../../utils");

var ruleName = exports.ruleName = "selector-no-universal";

var messages = exports.messages = (0, _utils.ruleMessages)(ruleName, {
  rejected: "Unexpected universal selector"
});