"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.messages = exports.ruleName = undefined;

exports.default = function (expectation) {
  return function (root, result) {
    var validOptions = (0, _utils.validateOptions)(result, ruleName, {
      actual: expectation,
      possible: ["lower", "upper"]
    });
    if (!validOptions) {
      return;
    }

    root.walkRules(function (rule) {
      if (!(0, _utils.isStandardRule)(rule)) {
        return;
      }
      var selector = rule.selector;
      var startIndexPseudo = selector.indexOf(":");

      if (startIndexPseudo === -1) {
        return;
      }

      (0, _utils.parseSelector)(selector, result, rule, function (selectorTree) {
        selectorTree.walkPseudos(function (pseudoNode) {
          var pseudo = pseudoNode.value;

          if (!(0, _utils.isStandardSelector)(pseudo)) {
            return;
          }

          if (pseudo.indexOf("::") !== -1 || _keywordSets.levelOneAndTwoPseudoElements.has(pseudo.toLowerCase().slice(1))) {
            return;
          }

          var expectedPseudo = expectation === "lower" ? pseudo.toLowerCase() : pseudo.toUpperCase();

          if (pseudo === expectedPseudo) {
            return;
          }

          (0, _utils.report)({
            message: messages.expected(pseudo, expectedPseudo),
            node: rule,
            index: pseudoNode.sourceIndex,
            ruleName: ruleName,
            result: result
          });
        });
      });
    });
  };
};

var _utils = require("../../utils");

var _keywordSets = require("../../reference/keywordSets");

var ruleName = exports.ruleName = "selector-pseudo-class-case";

var messages = (0, _utils.ruleMessages)(ruleName, {
  expected: function expected(actual, _expected) {
    return "Expected \"" + actual + "\" to be \"" + _expected + "\"";
  }
});

exports.messages = messages;