"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.messages = exports.ruleName = undefined;

exports.default = function (actual, options) {
  return function (root, result) {
    var validOptions = (0, _utils.validateOptions)(result, ruleName, { actual: actual }, {
      actual: options,
      possible: {
        ignorePseudoClasses: [_lodash.isString]
      },
      optional: true
    });
    if (!validOptions) {
      return;
    }

    root.walkRules(function (rule) {
      if (!(0, _utils.isStandardRule)(rule)) {
        return;
      }
      var selector = rule.selector;

      if (selector.indexOf(":") === -1) {
        return;
      }

      (0, _utils.parseSelector)(selector, result, rule, function (selectorTree) {
        selectorTree.walkPseudos(function (pseudoNode) {
          var pseudoClass = pseudoNode.value;

          if (!(0, _utils.isStandardSelector)(pseudoClass)) {
            return;
          }

          // Ignore pseudo-elements
          if (pseudoClass.indexOf("::") !== -1) {
            return;
          }

          var pseudoClassName = pseudoClass.replace(/:+/, "");

          if (_postcss.vendor.prefix(pseudoClassName) || _keywordSets.pseudoClasses.has(pseudoClassName.toLowerCase()) || _keywordSets.pseudoElements.has(pseudoClassName.toLowerCase())) {
            return;
          }

          var ignorePseudoElements = options && options.ignorePseudoClasses || [];

          if (ignorePseudoElements.indexOf(pseudoClassName.toLowerCase()) !== -1) {
            return;
          }

          (0, _utils.report)({
            message: messages.rejected(pseudoClass),
            node: rule,
            index: pseudoNode.sourceIndex,
            ruleName: ruleName,
            result: result
          });
        });
      });
    });
  };
};

var _lodash = require("lodash");

var _postcss = require("postcss");

var _utils = require("../../utils");

var _keywordSets = require("../../reference/keywordSets");

var ruleName = exports.ruleName = "selector-pseudo-class-no-unknown";

var messages = exports.messages = (0, _utils.ruleMessages)(ruleName, {
  rejected: function rejected(selector) {
    return "Unexpected unknown pseudo-class selector \"" + selector + "\"";
  }
});