"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.messages = exports.ruleName = undefined;

exports.default = function (expectation) {
  return function (root, result) {
    var validOptions = (0, _utils.validateOptions)(result, ruleName, {
      actual: expectation,
      possible: ["always", "never"]
    });
    if (!validOptions) {
      return;
    }

    root.walkRules(function (rule) {
      if (!(0, _utils.isStandardRule)(rule)) {
        return;
      }
      if (rule.selector.indexOf("(") === -1) {
        return;
      }

      (0, _utils.parseSelector)(rule.selector, result, rule, function (selectorTree) {
        selectorTree.walkPseudos(function (pseudoNode) {
          if (_lodash2.default.get(pseudoNode, "parent.parent.type") === "pseudo") {
            return;
          }

          var pseudoSelectorString = pseudoNode.toString();

          (0, _utils.styleSearch)({ source: pseudoSelectorString, target: "(" }, function (match) {
            var nextCharIsSpace = pseudoSelectorString[match.startIndex + 1] === " ";
            var index = pseudoNode.sourceIndex + match.startIndex + 1;
            if (nextCharIsSpace && expectation === "never") {
              complain(messages.rejectedOpening, index);
            }
            if (!nextCharIsSpace && expectation === "always") {
              complain(messages.expectedOpening, index);
            }
          });

          (0, _utils.styleSearch)({ source: pseudoSelectorString, target: ")" }, function (match) {
            var prevCharIsSpace = pseudoSelectorString[match.startIndex - 1] === " ";
            var index = pseudoNode.sourceIndex + match.startIndex - 1;
            if (prevCharIsSpace && expectation === "never") {
              complain(messages.rejectedClosing, index);
            }
            if (!prevCharIsSpace && expectation === "always") {
              complain(messages.expectedClosing, index);
            }
          });
        });
      });

      function complain(message, index) {
        (0, _utils.report)({
          message: message,
          index: index,
          result: result,
          ruleName: ruleName,
          node: rule
        });
      }
    });
  };
};

var _lodash = require("lodash");

var _lodash2 = _interopRequireDefault(_lodash);

var _utils = require("../../utils");

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var ruleName = exports.ruleName = "selector-pseudo-class-parentheses-space-inside";

var messages = exports.messages = (0, _utils.ruleMessages)(ruleName, {
  expectedOpening: "Expected single space after \"(\"",
  rejectedOpening: "Unexpected whitespace after \"(\"",
  expectedClosing: "Expected single space before \")\"",
  rejectedClosing: "Unexpected whitespace before \")\""
});