"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.messages = exports.ruleName = undefined;

exports.default = function (expectation) {
  return function (root, result) {
    var validOptions = (0, _utils.validateOptions)(result, ruleName, {
      actual: expectation,
      possible: ["lower", "upper"]
    });
    if (!validOptions) {
      return;
    }

    root.walkRules(function (rule) {
      if (!(0, _utils.isStandardRule)(rule)) {
        return;
      }
      var selector = rule.selector;
      var startIndexPseudoElement = selector.indexOf(":");

      if (startIndexPseudoElement === -1) {
        return;
      }

      (0, _utils.parseSelector)(selector, result, rule, function (selectorTree) {
        selectorTree.walkPseudos(function (pseudoNode) {
          var pseudoElement = pseudoNode.value;

          if (!(0, _utils.isStandardSelector)(pseudoElement)) {
            return;
          }

          if (pseudoElement.indexOf("::") === -1 && !_keywordSets.levelOneAndTwoPseudoElements.has(pseudoElement.toLowerCase().slice(1))) {
            return;
          }

          var expectedPseudoElement = expectation === "lower" ? pseudoElement.toLowerCase() : pseudoElement.toUpperCase();

          if (pseudoElement === expectedPseudoElement) {
            return;
          }

          (0, _utils.report)({
            message: messages.expected(pseudoElement, expectedPseudoElement),
            node: rule,
            index: pseudoNode.sourceIndex,
            ruleName: ruleName,
            result: result
          });
        });
      });
    });
  };
};

var _utils = require("../../utils");

var _keywordSets = require("../../reference/keywordSets");

var ruleName = exports.ruleName = "selector-pseudo-element-case";

var messages = (0, _utils.ruleMessages)(ruleName, {
  expected: function expected(actual, _expected) {
    return "Expected \"" + actual + "\" to be \"" + _expected + "\"";
  }
});

exports.messages = messages;