"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.messages = exports.ruleName = undefined;

exports.default = function (expectation) {

  return function (root, result) {
    var validOptions = (0, _utils.validateOptions)(result, ruleName, {
      actual: expectation,
      possible: ["single", "double"]
    });
    if (!validOptions) {
      return;
    }

    root.walkRules(function (rule) {
      if (!(0, _utils.isStandardRule)(rule)) {
        return;
      }
      var selector = rule.selector;

      // get out early if no pseudo elements or classes
      if (selector.indexOf(":") === -1) {
        return;
      }

      // match only level 1 and 2 pseudo elements
      var pseudoElementsWithColons = _lodash2.default.toArray(_keywordSets.levelOneAndTwoPseudoElements).map(function (x) {
        return ":" + x;
      });
      (0, _utils.styleSearch)({ source: selector.toLowerCase(), target: pseudoElementsWithColons }, function (match) {
        var prevCharIsColon = selector[match.startIndex - 1] === ":";

        if (expectation === "single" && !prevCharIsColon) {
          return;
        }
        if (expectation === "double" && prevCharIsColon) {
          return;
        }

        (0, _utils.report)({
          message: messages.expected(expectation),
          node: rule,
          index: match.startIndex,
          result: result,
          ruleName: ruleName
        });
      });
    });
  };
};

var _lodash = require("lodash");

var _lodash2 = _interopRequireDefault(_lodash);

var _utils = require("../../utils");

var _keywordSets = require("../../reference/keywordSets");

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var ruleName = exports.ruleName = "selector-pseudo-element-colon-notation";

var messages = exports.messages = (0, _utils.ruleMessages)(ruleName, {
  expected: function expected(q) {
    return "Expected " + q + " colon pseudo-element notation";
  }
});