"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.messages = exports.ruleName = undefined;

exports.default = function (actual, options) {
  return function (root, result) {
    var validOptions = (0, _utils.validateOptions)(result, ruleName, { actual: actual }, {
      actual: options,
      possible: {
        ignorePseudoElements: [_lodash.isString]
      },
      optional: true
    });
    if (!validOptions) {
      return;
    }

    root.walkRules(function (rule) {
      if (!(0, _utils.isStandardRule)(rule)) {
        return;
      }
      var selector = rule.selector;

      if (selector.indexOf("::") === -1) {
        return;
      }

      (0, _utils.parseSelector)(selector, result, rule, function (selectorTree) {
        selectorTree.walkPseudos(function (pseudoNode) {
          var pseudoElement = pseudoNode.value;

          if (!(0, _utils.isStandardSelector)(pseudoElement)) {
            return;
          }

          // Ignore pseudo-classes
          if (pseudoElement.indexOf("::") === -1) {
            return;
          }

          var pseudoElementName = pseudoElement.replace(/:+/, "");

          if (_postcss.vendor.prefix(pseudoElementName) || _keywordSets.pseudoElements.has(pseudoElementName.toLowerCase())) {
            return;
          }

          var ignorePseudoElements = options && options.ignorePseudoElements || [];

          if (ignorePseudoElements.indexOf(pseudoElementName.toLowerCase()) !== -1) {
            return;
          }

          (0, _utils.report)({
            message: messages.rejected(pseudoElement),
            node: rule,
            index: pseudoNode.sourceIndex,
            ruleName: ruleName,
            result: result
          });
        });
      });
    });
  };
};

var _lodash = require("lodash");

var _postcss = require("postcss");

var _utils = require("../../utils");

var _keywordSets = require("../../reference/keywordSets");

var ruleName = exports.ruleName = "selector-pseudo-element-no-unknown";

var messages = exports.messages = (0, _utils.ruleMessages)(ruleName, {
  rejected: function rejected(selector) {
    return "Unexpected unknown pseudo-element selector \"" + selector + "\"";
  }
});