"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.messages = exports.ruleName = undefined;

exports.default = function (expectation) {
  return function (root, result) {
    var validOptions = (0, _utils.validateOptions)(result, ruleName, {
      actual: expectation,
      possible: ["lower", "upper"]
    });
    if (!validOptions) {
      return;
    }

    root.walkRules(function (rule) {

      if (!(0, _utils.isStandardRule)(rule)) {
        return;
      }
      if ((0, _utils.isKeyframeRule)(rule)) {
        return;
      }
      var selector = rule.selector;

      if (!(0, _utils.isStandardSelector)(selector)) {
        return;
      }

      (0, _utils.parseSelector)(selector, result, rule, function (selectorAST) {
        selectorAST.walkTags(function (tag) {

          if (!(0, _utils.isStandardTypeSelector)(tag)) {
            return;
          }

          var sourceIndex = tag.sourceIndex;
          var value = tag.value;

          var expectedValue = expectation === "lower" ? value.toLowerCase() : value.toUpperCase();

          if (value === expectedValue) {
            return;
          }

          (0, _utils.report)({
            message: messages.expected(value, expectedValue),
            node: rule,
            index: sourceIndex,
            ruleName: ruleName,
            result: result
          });
        });
      });
    });
  };
};

var _utils = require("../../utils");

var ruleName = exports.ruleName = "selector-type-case";

var messages = (0, _utils.ruleMessages)(ruleName, {
  expected: function expected(actual, _expected) {
    return "Expected \"" + actual + "\" to be \"" + _expected + "\"";
  }
});

exports.messages = messages;