"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.messages = exports.ruleName = undefined;

exports.default = function (actual, options) {
  return function (root, result) {
    var validOptions = (0, _utils.validateOptions)(result, ruleName, { actual: actual }, {
      actual: options,
      possible: {
        ignoreTypes: [_lodash.isString]
      },
      optional: true
    });
    if (!validOptions) {
      return;
    }

    root.walkRules(function (rule) {
      if (!(0, _utils.isStandardRule)(rule)) {
        return;
      }
      if ((0, _utils.isKeyframeRule)(rule)) {
        return;
      }
      var selector = rule.selector;

      if (!(0, _utils.isStandardSelector)(selector)) {
        return;
      }

      (0, _utils.parseSelector)(selector, result, rule, function (selectorTree) {
        selectorTree.walkTags(function (tagNode) {
          if (!(0, _utils.isStandardTypeSelector)(tagNode)) {
            return;
          }

          var tagName = tagNode.value;
          var tagNameLowerCase = tagName.toLowerCase();

          if (_htmlTags2.default.indexOf(tagNameLowerCase) !== -1 || _svgTags2.default.indexOf(tagNameLowerCase) !== -1 || nonStandardHtmlTags.has(tagNameLowerCase)) {
            return;
          }

          var ignoreTypes = options && options.ignoreTypes || [];

          if (ignoreTypes.indexOf(tagNameLowerCase) !== -1) {
            return;
          }

          (0, _utils.report)({
            message: messages.rejected(tagName),
            node: rule,
            index: tagNode.sourceIndex,
            ruleName: ruleName,
            result: result
          });
        });
      });
    });
  };
};

var _lodash = require("lodash");

var _htmlTags = require("html-tags");

var _htmlTags2 = _interopRequireDefault(_htmlTags);

var _svgTags = require("svg-tags");

var _svgTags2 = _interopRequireDefault(_svgTags);

var _utils = require("../../utils");

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var ruleName = exports.ruleName = "selector-type-no-unknown";

var messages = exports.messages = (0, _utils.ruleMessages)(ruleName, {
  rejected: function rejected(selector) {
    return "Unexpected unknown type selector \"" + selector + "\"";
  }
});

// htmlTags includes only "standard" tags. So we augment it with older tags etc.
var nonStandardHtmlTags = new Set(["acronym", "applet", "basefont", "big", "blink", "center", "content", "dir", "font", "frame", "frameset", "hgroup", "isindex", "keygen", "listing", "marquee", "noembed", "plaintext", "spacer", "strike", "tt", "xmp"]);