"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.messages = exports.ruleName = undefined;

exports.default = function (actual) {
  return function (root, result) {
    var validOptions = (0, _utils.validateOptions)(result, ruleName, { actual: actual });
    if (!validOptions) {
      return;
    }

    root.walkDecls(function (decl) {
      if (!(0, _utils.isStandardDeclaration)(decl) || !(0, _utils.isStandardProperty)(decl.prop)) {
        return;
      }

      var prop = decl.prop;
      var value = decl.value;

      var normalizedProp = _postcss.vendor.unprefixed(prop.toLowerCase());

      // Ignore not shorthandable properties, and math operations
      if (isIgnoredCharacters(value) || !shorthandableProperties.has(normalizedProp) || ignoredShorthandProperties.has(normalizedProp)) {
        return;
      }

      var valuesToShorthand = [];

      (0, _postcssValueParser2.default)(value).walk(function (valueNode) {
        if (valueNode.type !== "word") {
          return;
        }

        valuesToShorthand.push(_postcssValueParser2.default.stringify(valueNode));
      });

      if (valuesToShorthand.length <= 1 || valuesToShorthand.length > 4) {
        return;
      }

      var shortestForm = canCondense.apply(undefined, valuesToShorthand);
      var shortestFormString = shortestForm.filter(function (value) {
        return value;
      }).join(" ");
      var valuesFormString = valuesToShorthand.join(" ");

      if (shortestFormString.toLowerCase() === valuesFormString.toLowerCase()) {
        return;
      }

      (0, _utils.report)({
        message: messages.rejected(value, shortestFormString),
        node: decl,
        result: result,
        ruleName: ruleName
      });
    });
  };
};

var _postcssValueParser = require("postcss-value-parser");

var _postcssValueParser2 = _interopRequireDefault(_postcssValueParser);

var _postcss = require("postcss");

var _utils = require("../../utils");

var _shorthandData = require("../../reference/shorthandData");

var _shorthandData2 = _interopRequireDefault(_shorthandData);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var ruleName = exports.ruleName = "shorthand-property-no-redundant-values";

var messages = exports.messages = (0, _utils.ruleMessages)(ruleName, {
  rejected: function rejected(unexpected, expected) {
    return "Unexpected longhand value '" + unexpected + "' instead of '" + expected + "'";
  }
});

var shorthandableProperties = new Set(Object.keys(_shorthandData2.default));

var ignoredCharacters = ["+", "-", "*", "/", "(", ")", "$", "@", "--", "var("];

var ignoredShorthandProperties = new Set(["background", "font", "border", "border-top", "border-bottom", "border-left", "border-right", "list-style", "transition"]);

function isIgnoredCharacters(value) {
  return ignoredCharacters.some(function (char) {
    return value.indexOf(char) !== -1;
  });
}

function canCondense(top, right) {
  var bottom = arguments.length <= 2 || arguments[2] === undefined ? null : arguments[2];
  var left = arguments.length <= 3 || arguments[3] === undefined ? null : arguments[3];

  var lowerTop = top.toLowerCase();
  var lowerRight = right.toLowerCase();
  var lowerBottom = bottom && bottom.toLowerCase();
  var lowerLeft = left && left.toLowerCase();

  if (canCondenseToOneValue(lowerTop, lowerRight, lowerBottom, lowerLeft)) {
    return [top];
  } else if (canCondenseToTwoValues(lowerTop, lowerRight, lowerBottom, lowerLeft)) {
    return [top, right];
  } else if (canCondenseToThreeValues(lowerTop, lowerRight, lowerBottom, lowerLeft)) {
    return [top, right, bottom];
  } else {
    return [top, right, bottom, left];
  }
}

function canCondenseToOneValue(top, right, bottom, left) {
  if (top !== right) {
    return false;
  }

  return top === bottom && (bottom === left || !left) || !bottom && !left;
}

function canCondenseToTwoValues(top, right, bottom, left) {
  return top === bottom && right === left || top === bottom && !left && top !== right;
}

function canCondenseToThreeValues(top, right, bottom, left) {
  return right === left;
}