"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.messages = exports.ruleName = undefined;

exports.default = function (actual) {
  return function (root, result) {
    var validOptions = (0, _utils.validateOptions)(result, ruleName, { actual: actual });
    if (!validOptions) {
      return;
    }

    var cssString = root.toString();
    (0, _utils.styleSearch)({ source: cssString, target: "\n", withinStrings: true }, function (match) {
      var charBefore = cssString[match.startIndex - 1];
      var index = match.startIndex;
      if (charBefore === "\\") {
        return;
      }
      if (charBefore === "\r") index -= 1;
      (0, _utils.report)({
        message: messages.rejected,
        node: root,
        index: index,
        result: result,
        ruleName: ruleName
      });
    });
  };
};

var _utils = require("../../utils");

var ruleName = exports.ruleName = "string-no-newline";

var messages = exports.messages = (0, _utils.ruleMessages)(ruleName, {
  rejected: "Unexpected newline in string"
});