"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.messages = exports.ruleName = undefined;

exports.default = function (expectation) {

  var erroneousQuote = expectation === "single" ? "\"" : "'";

  return function (root, result) {
    var validOptions = (0, _utils.validateOptions)(result, ruleName, {
      actual: expectation,
      possible: ["single", "double"]
    });
    if (!validOptions) {
      return;
    }

    var cssString = root.toString();
    (0, _utils.styleSearch)({ source: cssString, target: erroneousQuote }, function (match) {
      (0, _utils.report)({
        message: messages.expected(expectation),
        node: root,
        index: match.startIndex,
        result: result,
        ruleName: ruleName
      });
    });
  };
};

var _utils = require("../../utils");

var ruleName = exports.ruleName = "string-quotes";

var messages = exports.messages = (0, _utils.ruleMessages)(ruleName, {
  expected: function expected(q) {
    return "Expected " + q + " quotes";
  }
});