"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.messages = exports.ruleName = undefined;

exports.default = function (actual) {
  return function (root, result) {
    var validOptions = (0, _utils.validateOptions)(result, ruleName, { actual: actual });
    if (!validOptions) {
      return;
    }

    root.walkDecls(function (decl) {
      if (_keywordSets.longhandTimeProperties.has(decl.prop.toLowerCase())) {
        if (isImperceptibleTime(decl.value)) {
          complain(messages.rejected(decl.value), decl);
        }
      }

      if (_keywordSets.shorthandTimeProperties.has(decl.prop.toLowerCase())) {
        var valueList = _postcss2.default.list.space(decl.value);
        var _iteratorNormalCompletion = true;
        var _didIteratorError = false;
        var _iteratorError = undefined;

        try {
          for (var _iterator = valueList[Symbol.iterator](), _step; !(_iteratorNormalCompletion = (_step = _iterator.next()).done); _iteratorNormalCompletion = true) {
            var value = _step.value;

            if (isImperceptibleTime(value)) {
              complain(messages.rejected(value), decl, decl.value.indexOf(value));
            }
          }
        } catch (err) {
          _didIteratorError = true;
          _iteratorError = err;
        } finally {
          try {
            if (!_iteratorNormalCompletion && _iterator.return) {
              _iterator.return();
            }
          } finally {
            if (_didIteratorError) {
              throw _iteratorError;
            }
          }
        }
      }
    });

    function isImperceptibleTime(time) {
      var parsedTime = _postcssValueParser2.default.unit(time);
      if (!parsedTime) return false;
      if (parsedTime.unit.toLowerCase() === "ms" && parsedTime.number <= MINIMUM_MILLISECONDS) {
        return true;
      }
      if (parsedTime.unit.toLowerCase() === "s" && parsedTime.number * 1000 <= MINIMUM_MILLISECONDS) {
        return true;
      }
      return false;
    }

    function complain(message, decl) {
      var offset = arguments.length <= 2 || arguments[2] === undefined ? 0 : arguments[2];

      (0, _utils.report)({
        result: result,
        ruleName: ruleName,
        message: message,
        index: (0, _utils.declarationValueIndex)(decl) + offset,
        node: decl
      });
    }
  };
};

var _postcss = require("postcss");

var _postcss2 = _interopRequireDefault(_postcss);

var _postcssValueParser = require("postcss-value-parser");

var _postcssValueParser2 = _interopRequireDefault(_postcssValueParser);

var _utils = require("../../utils");

var _keywordSets = require("../../reference/keywordSets");

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var ruleName = exports.ruleName = "time-no-imperceptible";

var messages = exports.messages = (0, _utils.ruleMessages)(ruleName, {
  rejected: function rejected(time) {
    return "Unexpected time value \"" + time + "\" less than or equal to 100ms";
  }
});

var MINIMUM_MILLISECONDS = 100;