"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.messages = exports.ruleName = undefined;

exports.default = function (actual, options) {
  return function (root, result) {
    var validOptions = (0, _utils.validateOptions)(result, ruleName, { actual: actual }, {
      actual: options,
      possible: {
        ignoreUnits: [_lodash.isString]
      },
      optional: true
    });

    if (!validOptions) {
      return;
    }

    root.walkDecls(function (decl) {
      (0, _postcssValueParser2.default)(decl.value).walk(function (node) {
        // Ignore wrong units within `url` function
        if (node.type === "function" && node.value.toLowerCase() === "url") {
          return false;
        }

        var unit = (0, _utils.getUnitFromValueNode)(node);

        if (!unit || unit && _keywordSets.units.has(unit.toLowerCase())) {
          return;
        }

        var ignoreUnits = options && options.ignoreUnits || [];

        if (ignoreUnits.indexOf(unit.toLowerCase()) !== -1) {
          return;
        }

        (0, _utils.report)({
          message: messages.rejected(unit),
          node: decl,
          index: (0, _utils.declarationValueIndex)(decl) + node.sourceIndex,
          result: result,
          ruleName: ruleName
        });
      });
    });
  };
};

var _lodash = require("lodash");

var _postcssValueParser = require("postcss-value-parser");

var _postcssValueParser2 = _interopRequireDefault(_postcssValueParser);

var _utils = require("../../utils");

var _keywordSets = require("../../reference/keywordSets");

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var ruleName = exports.ruleName = "unit-no-unknown";

var messages = exports.messages = (0, _utils.ruleMessages)(ruleName, {
  rejected: function rejected(unit) {
    return "Unexpected unknown unit \"" + unit + "\"";
  }
});