"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.messages = exports.ruleName = undefined;

exports.default = function (whitelistInput) {
  var whitelist = [].concat(whitelistInput);
  return function (root, result) {
    var validOptions = (0, _utils.validateOptions)(result, ruleName, {
      actual: whitelist,
      possible: [_lodash.isString]
    });
    if (!validOptions) {
      return;
    }

    root.walkDecls(function (decl) {
      (0, _postcssValueParser2.default)(decl.value).walk(function (node) {
        // Ignore wrong units within `url` function
        if (node.type === "function" && node.value.toLowerCase() === "url") {
          return false;
        }

        var unit = (0, _utils.getUnitFromValueNode)(node);

        if (!unit || unit && whitelist.indexOf(unit.toLowerCase()) !== -1) {
          return;
        }

        (0, _utils.report)({
          message: messages.rejected(unit),
          node: decl,
          index: (0, _utils.declarationValueIndex)(decl) + node.sourceIndex,
          result: result,
          ruleName: ruleName
        });
      });
    });
  };
};

var _lodash = require("lodash");

var _postcssValueParser = require("postcss-value-parser");

var _postcssValueParser2 = _interopRequireDefault(_postcssValueParser);

var _utils = require("../../utils");

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var ruleName = exports.ruleName = "unit-whitelist";

var messages = exports.messages = (0, _utils.ruleMessages)(ruleName, {
  rejected: function rejected(unit) {
    return "Unexpected unit \"" + unit + "\"";
  }
});