"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.messages = exports.ruleName = undefined;

exports.default = function (expectation, options) {
  return function (root, result) {
    var validOptions = (0, _utils.validateOptions)(result, ruleName, {
      actual: expectation,
      possible: ["lower", "upper"]
    }, {
      actual: options,
      possible: {
        ignoreKeywords: [_lodash.isString]
      },
      optional: true
    });
    if (!validOptions) {
      return;
    }

    root.walkDecls(function (decl) {
      var prop = decl.prop;
      var value = decl.value;


      (0, _postcssValueParser2.default)(value).walk(function (node) {
        // Ignore keywords within `url` and `var` function
        var valueLowerCase = node.value.toLowerCase();
        if (node.type === "function" && (valueLowerCase === "url" || valueLowerCase === "var")) {
          return false;
        }

        var keyword = node.value;

        // Ignore css variables, and hex values, and math operators, and sass interpolation
        if (node.type !== "word" || !(0, _utils.isStandardValue)(node.value) || value.indexOf("#") !== -1 || ignoredCharacters.has(keyword)) {
          return;
        }

        if (prop === "animation-name" && !_keywordSets.animationNameKeywords.has(valueLowerCase)) {
          return;
        }
        if (prop === "font-family" && !_keywordSets.fontFamilyKeywords.has(valueLowerCase)) {
          return;
        }
        if (prop === "counter-increment" && (0, _utils.isCustomIdentPropertyCounterIncrement)(valueLowerCase)) {
          return;
        }
        if (prop === "grid-row" && !_keywordSets.gridRowKeywords.has(valueLowerCase)) {
          return;
        }
        if (prop === "grid-column" && !_keywordSets.gridColumnKeywords.has(valueLowerCase)) {
          return;
        }
        if (prop === "grid-area" && !_keywordSets.gridAreaKeywords.has(valueLowerCase)) {
          return;
        }
        if (prop === "list-style-type" && !_keywordSets.listStyleTypeKeywords.has(valueLowerCase)) {
          return;
        }
        if ((0, _utils.getUnitFromValueNode)(node)) {
          return;
        }

        var ignoreKeywords = options && options.ignoreKeywords || [];

        if (ignoreKeywords.length > 0 && (0, _utils.matchesStringOrRegExp)(keyword, ignoreKeywords)) {
          return;
        }

        var keywordLowerCase = keyword.toLocaleLowerCase();
        var expectedKeyword = null;

        if (expectation === "lower" && mapLowercaseKeywordsToCamelCase.has(keywordLowerCase)) {
          expectedKeyword = mapLowercaseKeywordsToCamelCase.get(keywordLowerCase);
        } else if (expectation === "lower") {
          expectedKeyword = keyword.toLowerCase();
        } else {
          expectedKeyword = keyword.toUpperCase();
        }

        if (keyword === expectedKeyword) {
          return;
        }

        (0, _utils.report)({
          message: messages.expected(keyword, expectedKeyword),
          node: decl,
          index: (0, _utils.declarationValueIndex)(decl) + node.sourceIndex,
          result: result,
          ruleName: ruleName
        });
      });
    });
  };
};

var _postcssValueParser = require("postcss-value-parser");

var _postcssValueParser2 = _interopRequireDefault(_postcssValueParser);

var _lodash = require("lodash");

var _utils = require("../../utils");

var _keywordSets = require("../../reference/keywordSets");

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var ruleName = exports.ruleName = "value-keyword-case";

var messages = (0, _utils.ruleMessages)(ruleName, {
  expected: function expected(actual, _expected) {
    return "Expected \"" + actual + "\" to be \"" + _expected + "\"";
  }
});

// Operators are interpreted as "words" by the value parser, so we want to make sure to ignore them.
exports.messages = messages;
var ignoredCharacters = new Set(["+", "-", "/", "*", "%"]);

var mapLowercaseKeywordsToCamelCase = new Map();
_keywordSets.camelCaseKeywords.forEach(function (func) {
  mapLowercaseKeywordsToCamelCase.set(func.toLowerCase(), func);
});