"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.messages = exports.ruleName = undefined;

exports.default = function (actual) {
  return function (root, result) {
    var validOptions = (0, _utils.validateOptions)(result, ruleName, { actual: actual });
    if (!validOptions) {
      return;
    }

    root.walkDecls(function (decl) {
      if (!(0, _utils.isStandardDeclaration)(decl) || !(0, _utils.isStandardProperty)(decl.prop) || decl.value[0] !== "-") {
        return;
      }

      var prop = decl.prop;
      var value = decl.value;

      // Search the full declaration in order to get an accurate index

      (0, _utils.styleSearch)({ source: value.toLowerCase(), target: valuePrefixes }, function (match) {
        var fullIdentifier = /^(-[a-z-]+)\b/i.exec(value.slice(match.startIndex))[1];
        if (!_utils.isAutoprefixable.propertyValue(prop, fullIdentifier)) {
          return;
        }

        (0, _utils.report)({
          message: messages.rejected(fullIdentifier),
          node: decl,
          index: prop.length + decl.raws.between.length + match.startIndex,
          result: result,
          ruleName: ruleName
        });
      });
    });
  };
};

var _utils = require("../../utils");

var ruleName = exports.ruleName = "value-no-vendor-prefix";

var messages = exports.messages = (0, _utils.ruleMessages)(ruleName, {
  rejected: function rejected(property) {
    return "Unexpected vendor-prefixed value \"" + property + "\"";
  }
});

var valuePrefixes = ["-webkit-", "-moz-", "-ms-", "-o-"];