"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});

var _createRuleTester = require("./createRuleTester");

var _createRuleTester2 = _interopRequireDefault(_createRuleTester);

var _tape = require("tape");

var _tape2 = _interopRequireDefault(_tape);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

// This code is included here instead of using stylelint-test-rule-tape
// because tests performs significantly faster this way
function assertEquality(processCss, context) {
  var testFn = context.only ? _tape2.default.only : _tape2.default;
  testFn(context.caseDescription, function (t) {
    t.plan(context.comparisonCount);
    processCss.then(function (comparisons) {
      comparisons.forEach(function (_ref) {
        var actual = _ref.actual;
        var expected = _ref.expected;
        var description = _ref.description;

        t.equal(actual, expected, description);
      });
    });
  });
}

exports.default = (0, _createRuleTester2.default)(assertEquality);