"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});

exports.default = function (node) {
  if (!node || node && !node.value) {
    return null;
  }

  var value = (0, _blurInterpolation2.default)(node.value, "");

  if (node.type !== "word" || !(0, _isStandardValue2.default)(value) || !(0, _lodash.isFinite)(parseInt(value)) || node.value[0] === "#") {
    return null;
  }

  var parsedUnit = _postcssValueParser2.default.unit(value);

  if (!parsedUnit) {
    return null;
  }

  return parsedUnit.unit;
};

var _blurInterpolation = require("./blurInterpolation");

var _blurInterpolation2 = _interopRequireDefault(_blurInterpolation);

var _isStandardValue = require("./isStandardValue");

var _isStandardValue2 = _interopRequireDefault(_isStandardValue);

var _postcssValueParser = require("postcss-value-parser");

var _postcssValueParser2 = _interopRequireDefault(_postcssValueParser);

var _lodash = require("lodash");

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }