"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});

exports.default = function (node) {

  // postcss-selector-parser includes the arguments to nth-child() functions
  // as "tags", so we need to ignore them ourselves.
  // The fake-tag's "parent" is actually a selector node, whose parent
  // should be the :nth-child pseudo node.
  var _node$parent$parent = node.parent.parent;
  var parentType = _node$parent$parent.type;
  var parentValue = _node$parent$parent.value;

  if (parentValue) {
    var normalisedParentName = parentValue.toLowerCase().replace(/:+/, "");
    if (parentType === "pseudo" && (_keywordSets.aNPlusBNotationPseudoClasses.has(normalisedParentName) || _keywordSets.linguisticPseudoClasses.has(normalisedParentName))) {
      return false;
    }
  }

  // &-bar is a nesting selector combined with a suffix
  if (node.prev() && node.prev().type === "nesting") {
    return false;
  }

  return true;
};

var _keywordSets = require("../reference/keywordSets");