"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});

exports.default = function (value) {

  // SCSS variable
  if (value[0] === "$") {
    return false;
  }

  // Less variable
  if (value[0] === "@") {
    return false;
  }

  // SCSS or Less interpolation
  if (/#{.+?}|@{.+?}|\$\(.+?\)/.test(value)) {
    return false;
  }

  return true;
};