"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = nextNonCommentNode;
/**
 * Get the next non-comment node in a PostCSS AST
 * at or after a given node.
 *
 * @param {Node} node
 * @return {undefined|Node} The next non-comment node,
 *   or `null` if that doesn't not exist.
 */
function nextNonCommentNode(startNode) {
  if (!startNode || !startNode.next) return null;

  if (startNode.type === "comment") {
    return nextNonCommentNode(startNode.next());
  }

  return startNode;
}