# Example config

This example config lists all of the [rules](/docs/user-guide/rules.md) and their primary options. You can remove ([or turn off](/docs/user-guide/configuration.md#rules)) the rules you don't want and edit the primary option of each rule to your liking.

You might want to learn a little about [how rules are named and how they work together](/docs/user-guide/about-rules.md), to get a better idea of what each rule does.

```json
{
  "rules": {
    "at-rule-empty-line-before": "always"|"never",
    "at-rule-name-case": "lower"|"upper",
    "at-rule-name-space-after": "always"|"always-single-line",
    "at-rule-no-vendor-prefix": true,
    "at-rule-semicolon-newline-after": "always",
    "block-closing-brace-newline-after": "always"|"always-single-line"|"never-single-line"|"always-multi-line"|"never-multi-line",
    "block-closing-brace-newline-before": "always"|"always-multi-line"|"never-multi-line",
    "block-closing-brace-space-after": "always"|"always-single-line"|"never-single-line"|"always-multi-line"|"never-multi-line",
    "block-closing-brace-space-before": "always"|"never"|"always-single-line"|"never-single-line"|"always-multi-line"|"never-multi-line",
    "block-no-empty": true,
    "block-no-single-line": true,
    "block-opening-brace-newline-after": "always"|"always-multi-line"|"never-multi-line",
    "block-opening-brace-newline-before": "always"|"always-single-line"|"never-single-line"|"always-multi-line"|"never-multi-line",
    "block-opening-brace-space-after": "always"|"always-single-line"|"never-single-line"|"always-multi-line"|"never-multi-line",
    "block-opening-brace-space-before": "always"|"always-single-line"|"never-single-line"|"always-multi-line"|"never-multi-line",
    "color-hex-case": "lower"|"upper",
    "color-hex-length": "short"|"long",
    "color-named": "always-where-possible"|"never",
    "color-no-hex": true,
    "color-no-invalid-hex": true,
    "comment-empty-line-before": "always"|"never",
    "comment-whitespace-inside": "always"|"never",
    "comment-word-blacklist": string|[],
    "custom-media-pattern": string,
    "custom-property-no-outside-root": true,
    "custom-property-pattern": string,
    "declaration-bang-space-after": "always"|"never",
    "declaration-bang-space-before": "always"|"never",
    "declaration-block-no-duplicate-properties": true,
    "declaration-block-no-ignored-properties": true,
    "declaration-block-no-shorthand-property-overrides": true,
    "declaration-block-properties-order": "alphabetical"|[],
    "declaration-block-semicolon-newline-after": "always"|"always-multi-line"|"never-multi-line",
    "declaration-block-semicolon-newline-before": "always"|"always-multi-line"|"never-multi-line",
    "declaration-block-semicolon-space-after": "always"|"never"|"always-single-line"|"never-single-line",
    "declaration-block-semicolon-space-before": "always"|"never"|"always-single-line"|"never-single-line",
    "declaration-block-single-line-max-declarations": int,
    "declaration-block-trailing-semicolon": "always"|"never",
    "declaration-colon-newline-after": "always"|"always-multi-line",
    "declaration-colon-space-after": "always"|"never"|"always-single-line",
    "declaration-colon-space-before": "always"|"never",
    "declaration-no-important": true,
    "font-family-name-quotes": "always-where-required"|"always-where-recommended"|"always-unless-keyword",
    "font-weight-notation": "numeric"|"named",
    "function-blacklist": string|[],
    "function-calc-no-unspaced-operator": true,
    "function-comma-newline-after": "always"|"always-multi-line"|"never-multi-line",
    "function-comma-newline-before": "always"|"always-multi-line"|"never-multi-line",
    "function-comma-space-after": "always"|"never"|"always-single-line"|"never-single-line",
    "function-comma-space-before": "always"|"never"|"always-single-line"|"never-single-line",
    "function-linear-gradient-no-nonstandard-direction": true,
    "function-max-empty-lines": int,
    "function-name-case": "lower"|"upper",
    "function-parentheses-newline-inside": "always"|"always-multi-line"|"never-multi-line",
    "function-parentheses-space-inside": "always"|"never"|"always-single-line"|"never-single-line",
    "function-url-data-uris": "always"|"never",
    "function-url-quotes": "always"|"never",
    "function-whitelist": string|[],
    "function-whitespace-after": "always"|"never",
    "indentation": int|"tab",
    "keyframe-declaration-no-important": true,
    "max-empty-lines": int,
    "max-line-length": int,
    "max-nesting-depth": int,
    "media-feature-colon-space-after": "always"|"never",
    "media-feature-colon-space-before": "always"|"never",
    "media-feature-name-no-vendor-prefix": true,
    "media-feature-no-missing-punctuation": true,
    "media-feature-range-operator-space-after": "always"|"never",
    "media-feature-range-operator-space-before": "always"|"never",
    "media-query-list-comma-newline-after": "always"|"always-multi-line"|"never-multi-line",
    "media-query-list-comma-newline-before": "always"|"always-multi-line"|"never-multi-line",
    "media-query-list-comma-space-after": "always"|"never"|"always-single-line"|"never-single-line",
    "media-query-list-comma-space-before": "always"|"never"|"always-single-line"|"never-single-line",
    "media-query-parentheses-space-inside": "always"|"never",
    "no-browser-hacks": true,
    "no-descending-specificity": true,
    "no-duplicate-selectors": true,
    "no-eol-whitespace": true,
    "no-extra-semicolons": true,
    "no-indistinguishable-colors": true,
    "no-invalid-double-slash-comments": true,
    "no-missing-eof-newline": true,
    "no-unknown-animations": true,
    "no-unsupported-browser-features": true,
    "number-leading-zero": "always"|"never",
    "number-max-precision": int,
    "number-no-trailing-zeros": true,
    "number-zero-length-no-unit": true,
    "property-blacklist": string|[],
    "property-case": "lower"|"upper",
    "property-no-vendor-prefix": true,
    "property-unit-blacklist": {},
    "property-unit-whitelist": {},
    "property-value-blacklist": {},
    "property-value-whitelist": {},
    "property-whitelist": string|[],
    "root-no-standard-properties": true,
    "rule-nested-empty-line-before": "always"|"never",
    "rule-non-nested-empty-line-before": "always"|"never",
    "selector-attribute-brackets-space-inside": "always"|"never",
    "selector-attribute-operator-blacklist": string|[],
    "selector-attribute-operator-space-after": "always"|"never",
    "selector-attribute-operator-space-before": "always"|"never",
    "selector-attribute-operator-whitelist": string|[],
    "selector-class-pattern": string,
    "selector-combinator-space-after": "always"|"never",
    "selector-combinator-space-before": "always"|"never",
    "selector-id-pattern": string,
    "selector-list-comma-newline-after": "always"|"always-multi-line"|"never-multi-line",
    "selector-list-comma-newline-before": "always"|"always-multi-line"|"never-multi-line",
    "selector-list-comma-space-after": "always"|"never"|"always-single-line"|"never-single-line",
    "selector-list-comma-space-before": "always"|"never"|"always-single-line"|"never-single-line",
    "selector-max-empty-lines": int,
    "selector-max-compound-selectors": int,
    "selector-max-specificity": string,
    "selector-no-attribute": true,
    "selector-no-combinator": true,
    "selector-no-id": true,
    "selector-no-qualifying-type": true,
    "selector-no-type": true,
    "selector-no-universal": true,
    "selector-no-vendor-prefix": true,
    "selector-pseudo-class-case": "lower"|"upper",
    "selector-pseudo-class-no-unknown": true,
    "selector-pseudo-class-parentheses-space-inside": "always"|"never",
    "selector-pseudo-element-case": "lower"|"upper",
    "selector-pseudo-element-colon-notation": "single"|"double",
    "selector-pseudo-element-no-unknown": true,
    "selector-root-no-composition": true,
    "selector-type-case": "lower"|"upper",
    "selector-type-no-unknown": true,
    "shorthand-property-no-redundant-values": true,
    "string-no-newline": true,
    "string-quotes": "single"|"double",
    "stylelint-disable-reason": "always-before"|"always-after",
    "time-no-imperceptible": true,
    "unit-blacklist": string|[],
    "unit-case": "lower"|"upper",
    "unit-no-unknown": true,
    "unit-whitelist": string|[],
    "value-keyword-case": "lower"|"upper",
    "value-list-comma-newline-after": "always"|"always-multi-line"|"never-multi-line",
    "value-list-comma-newline-before": "always"|"always-multi-line"|"never-multi-line",
    "value-list-comma-space-after": "always"|"never"|"always-single-line"|"never-single-line",
    "value-list-comma-space-before": "always"|"never"|"always-single-line"|"never-single-line",
    "value-no-vendor-prefix": true
  }
}
```
