# property-whitelist

Specify a whitelist of allowed properties.

```css
a { display: block; }
/** ↑
 * These properties */
```

This rule ignores variables (`$sass`, `@less`, `--custom-property`).

## Options

`array`: `"["array", "of", "unprefixed", "properties"]`

### `["array", "of", "unprefixed", properties"]`

Whitelisted properties are the only *allowed* properties.

If a string in the array is surrounded with `"/"` (e.g. `"/^background/"`),
it is interpreted as a regular expression. This allows, for example,
easy targeting of shorthands: `/^background/` will match `background`,
`background-size`, `background-color`, etc.

Given:

```js
["display", "animation", "/^background/"]
```

The following patterns are considered warnings:

```css
a { color: pink; }
```

```css
a {
  animation: my-animation 2s;
  color: pink;
}
```

```css
a { borkgrund: orange; }
```

The following patterns are *not* considered warnings:

```css
a { display: block; }
```

```css
a { -webkit-animation: my-animation 2s; }
```

```css
a {
  animation: my-animation 2s;
  -webkit-animation: my-animation 2s;
  display: block;
}
```

```css
a { background: pink; }
```

```css
a { background-color: pink; }
```
