# selector-type-no-unknown

Disallow unknown type selectors.

```css
    unknown {}
/** ↑
 * This type selector */
```

The following patterns are considered warnings:

```css
unknown { }
```

```css
tag { }
```

The following patterns are *not* considered warnings:

```css
input { }
```

```css
ul li { }
```

```css
li > a { }
```

## Optional options

### `ignoreTypes: ["array", "of", "types"]`

Allow unknown type selectors.

For example, given:

```js
["unknown"]
```

The following patterns are considered warnings:

```css
tag
```

The following patterns are *not* considered warnings:

```css
unknown { }
```

```css
UNKNOWN { }
```

```css
unknown > a { }
```
