'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});

var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; };

exports.default = substyle;

var _invariant = require('invariant');

var _invariant2 = _interopRequireDefault(_invariant);

var _keys = require('lodash/keys');

var _keys2 = _interopRequireDefault(_keys);

var _values = require('lodash/values');

var _values2 = _interopRequireDefault(_values);

var _negate = require('lodash/negate');

var _negate2 = _interopRequireDefault(_negate);

var _identity = require('lodash/identity');

var _identity2 = _interopRequireDefault(_identity);

var _flatten = require('lodash/flatten');

var _flatten2 = _interopRequireDefault(_flatten);

var _merge = require('lodash/merge');

var _merge2 = _interopRequireDefault(_merge);

var _filter = require('lodash/fp/filter');

var _filter2 = _interopRequireDefault(_filter);

var _map = require('lodash/fp/map');

var _map2 = _interopRequireDefault(_map);

var _mapValues = require('lodash/mapValues');

var _mapValues2 = _interopRequireDefault(_mapValues);

var _compose = require('lodash/fp/compose');

var _compose2 = _interopRequireDefault(_compose);

var _isPlainObject = require('lodash/isPlainObject');

var _isPlainObject2 = _interopRequireDefault(_isPlainObject);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _objectWithoutProperties(obj, keys) { var target = {}; for (var i in obj) { if (keys.indexOf(i) >= 0) continue; if (!Object.prototype.hasOwnProperty.call(obj, i)) continue; target[i] = obj[i]; } return target; }

function _toConsumableArray(arr) { if (Array.isArray(arr)) { for (var i = 0, arr2 = Array(arr.length); i < arr.length; i++) { arr2[i] = arr[i]; } return arr2; } else { return Array.from(arr); } }

function substyle(_ref, selectedKeys) {
  var style = _ref.style;
  var className = _ref.className;


  if (!selectedKeys) {
    selectedKeys = [];
  } else if (typeof selectedKeys === 'string') {
    selectedKeys = [selectedKeys];
  } else if (Object.prototype.toString.call(selectedKeys) === '[object Object]') {
    selectedKeys = (0, _keys2.default)(selectedKeys).reduce(function (keys, key) {
      return keys.concat(selectedKeys[key] ? [key] : []);
    }, []);
  }

  (0, _invariant2.default)(Array.isArray(selectedKeys), 'Second parameter must be a string, an array of strings, a plain object with boolean values, or a falsy value');

  var baseClassName = className && className.split(' ')[0];
  var toElementClassNames = (0, _map2.default)(function (key) {
    return baseClassName + '__' + key;
  });
  var toModifierClassNames = (0, _map2.default)(function (key) {
    return baseClassName + '--' + key.substring(1);
  });

  var modifierKeys = (0, _filter2.default)(isModifier, selectedKeys);
  var elementKeys = (0, _filter2.default)(isElement, selectedKeys);

  var hoistElementStyles = function hoistElementStyles(style) {
    return (0, _values2.default)(pickNestedStyles(style, elementKeys));
  };
  var hoistModifierStyles = function hoistModifierStyles(style) {
    return (0, _values2.default)(pickNestedStyles(style, modifierKeys));
  };
  var hoistElementStylesFromEach = elementKeys.length > 0 ? (0, _compose2.default)(_flatten2.default, (0, _map2.default)(hoistElementStyles)) : _identity2.default;

  return _extends({}, style && {
    style: attachToStringToObjects(_merge2.default.apply(undefined, [{}].concat(_toConsumableArray(hoistElementStylesFromEach([style].concat(_toConsumableArray(hoistModifierStyles(style))))))))
  }, className && {
    className: (elementKeys.length === 0 ? [className].concat(_toConsumableArray(toModifierClassNames(modifierKeys))) : toElementClassNames(elementKeys)).join(' ')
  });
}

var isModifier = function isModifier(key) {
  return key[0] === '&';
};
var isPseudoOrMedia = function isPseudoOrMedia(key) {
  return key[0] === ':' || key[0] === '@';
};
var isElement = (0, _negate2.default)(isModifier);

var pickNestedStyles = function pickNestedStyles(style, keysToPick) {
  var camelizedKeysToPick = (0, _map2.default)(camelize, keysToPick);
  var styleKeys = (0, _keys2.default)(style);
  var result = {};
  for (var i = 0, l = styleKeys.length; i < l; ++i) {
    var key = styleKeys[i];
    if (keysToPick.indexOf(key) >= 0 || camelizedKeysToPick.indexOf(camelize(key)) >= 0) {
      result[key] = style[key];
    }
  }
  return result;
};

var camelize = function camelize(key) {
  return key.replace(/-(\w)/g, function (m, c) {
    return c.toUpperCase();
  });
};

var attachToStringToObjects = function attachToStringToObjects(_ref2) {
  var toString = _ref2.toString;

  var styles = _objectWithoutProperties(_ref2, ['toString']);

  return (0, _mapValues2.default)(styles, function (value, key) {
    if (!isPseudoOrMedia(key) && Object.prototype.toString.call(value) === '[object Object]') {
      value = _extends({}, value);
      value.toString = function () {
        return undefined;
      };
    }
    return value;
  });
};
module.exports = exports['default'];