'use strict';

var Sugar = require('sugar-core'),
    coercePositiveInteger = require('../common/internal/coercePositiveInteger');

Sugar.Array.defineStatic({

  'construct': function(n, fn) {
    n = coercePositiveInteger(n);
    return Array.from(new Array(n), function(el, i) {
      return fn && fn(i);
    });
  }

});

module.exports = Sugar.Array.construct;