'use strict';

var Sugar = require('sugar-core'),
    classChecks = require('../../common/var/classChecks'),
    mathAliases = require('../../common/var/mathAliases'),
    sameValueZero = require('../../es7/internal/sameValueZero');

var isString = classChecks.isString,
    max = mathAliases.max;

Sugar.Array.defineInstancePolyfill({

  'includes': function(search) {
    // Force compiler to respect argument length.
    var argLen = arguments.length, fromIndex = arguments[1];
    var arr = this, len;
    if (isString(arr)) return arr.includes(search, fromIndex);
    fromIndex = fromIndex ? fromIndex.valueOf() : 0;
    len = arr.length;
    if (fromIndex < 0) {
      fromIndex = max(0, fromIndex + len);
    }
    for (var i = fromIndex; i < len; i++) {
      if (sameValueZero(search, arr[i])) {
        return true;
      }
    }
    return false;
  }

});

// This package does not export anything as it is mapping a
// polyfill to Array.prototype which cannot be called statically.