'use strict';

var CAMELIZE_REG = require('../var/CAMELIZE_REG'),
    getAcronym = require('../../common/internal/getAcronym'),
    stringUnderscore = require('./stringUnderscore'),
    stringCapitalize = require('./stringCapitalize');

function stringCamelize(str, upper) {
  str = stringUnderscore(str);
  return str.replace(CAMELIZE_REG, function(match, pre, word, index) {
    var cap = upper !== false || index > 0, acronym;
    acronym = getAcronym(word);
    if (acronym && cap) {
      return acronym;
    }
    return cap ? stringCapitalize(word, true) : word;
  });
}

module.exports = stringCamelize;