'use strict';

var NO_KEYS_IN_STRING_OBJECTS = require('../var/NO_KEYS_IN_STRING_OBJECTS'),
    isPrimitive = require('./isPrimitive'),
    classChecks = require('../var/classChecks'),
    forceStringCoercion = require('./forceStringCoercion');

var isString = classChecks.isString;

function coercePrimitiveToObject(obj) {
  if (isPrimitive(obj)) {
    obj = Object(obj);
  }
  // istanbul ignore next
  if (NO_KEYS_IN_STRING_OBJECTS && isString(obj)) {
    forceStringCoercion(obj);
  }
  return obj;
}

module.exports = coercePrimitiveToObject;