'use strict';

var Sugar = require('sugar-core'),
    trim = require('../common/internal/trim'),
    stringEach = require('./internal/stringEach');

Sugar.String.defineInstance({

  'words': function(str, eachWordFn) {
    return stringEach(trim(str), /\S+/g, eachWordFn);
  }

});

module.exports = Sugar.String.words;