export declare type Provider = 'azure' | 'bitbucket' | 'facebook' | 'github' | 'gitlab' | 'google' | 'twitter' | 'apple' | 'discord' | 'twitch';
export declare type AuthChangeEvent = 'SIGNED_IN' | 'SIGNED_OUT' | 'USER_UPDATED' | 'USER_DELETED' | 'PASSWORD_RECOVERY';
export interface Session {
    provider_token?: string | null;
    access_token: string;
    /**
     * The number of seconds until the token expires (since it was issued). Returned when a login is confirmed.
     */
    expires_in?: number;
    /**
     * A timestamp of when the token will expire. Returned when a login is confirmed.
     */
    expires_at?: number;
    refresh_token?: string;
    token_type: string;
    user: User | null;
}
export interface User {
    id: string;
    app_metadata: {
        provider?: string;
        [key: string]: any;
    };
    user_metadata: {
        [key: string]: any;
    };
    aud: string;
    confirmation_sent_at?: string;
    recovery_sent_at?: string;
    action_link?: string;
    email?: string;
    phone?: string;
    created_at: string;
    confirmed_at?: string;
    email_confirmed_at?: string;
    phone_confirmed_at?: string;
    last_sign_in_at?: string;
    role?: string;
    updated_at?: string;
}
export interface UserAttributes {
    /**
     * The user's email.
     */
    email?: string;
    /**
     * The user's password.
     */
    password?: string;
    /**
     * An email change token.
     */
    email_change_token?: string;
    /**
     * A custom data object. Can be any JSON.
     */
    data?: object;
}
export interface Subscription {
    /**
     * The subscriber UUID. This will be set by the client.
     */
    id: string;
    /**
     * The function to call every time there is an event. eg: (eventName) => {}
     */
    callback: (event: AuthChangeEvent, session: Session | null) => void;
    /**
     * Call this to remove the listener.
     */
    unsubscribe: () => void;
}
export interface CookieOptions {
    name?: string;
    lifetime?: number;
    domain?: string;
    path?: string;
    sameSite?: string;
}
export interface UserCredentials {
    email?: string;
    phone?: string;
    password?: string;
    refreshToken?: string;
    provider?: Provider;
}
export interface VerifyOTPParams {
    phone: string;
    token: string;
}
//# sourceMappingURL=types.d.ts.map