"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.SupabaseStorageClient = void 0;
const lib_1 = require("./lib");
class SupabaseStorageClient extends lib_1.StorageBucketApi {
    constructor(url, headers = {}) {
        super(url, headers);
    }
    /**
     * Perform file operation in a bucket.
     *
     * @param id The bucket id to operate on.
     */
    from(id) {
        return new lib_1.StorageFileApi(this.url, this.headers, id);
    }
}
exports.SupabaseStorageClient = SupabaseStorageClient;
//# sourceMappingURL=SupabaseStorageClient.js.map