import { Color } from './../math/Color';
import { LightShadow } from './LightShadow';
import { Object3D } from './../core/Object3D';

// Lights //////////////////////////////////////////////////////////////////////////////////

/**
 * Abstract base class for lights.
 */
export class Light extends Object3D {
  constructor(hex?: number | string, intensity?: number);

  color: Color;
  intensity: number;
  receiveShadow: boolean;
  shadow: LightShadow;
  /**
   * @deprecated Use shadow.camera.fov instead.
   */
  shadowCameraFov: any;
  /**
   * @deprecated Use shadow.camera.left instead.
   */
  shadowCameraLeft: any;
  /**
   * @deprecated Use shadow.camera.right instead.
   */
  shadowCameraRight: any;
  /**
   * @deprecated Use shadow.camera.top instead.
   */
  shadowCameraTop: any;
  /**
   * @deprecated Use shadow.camera.bottom instead.
   */
  shadowCameraBottom: any;
  /**
   * @deprecated Use shadow.camera.near instead.
   */
  shadowCameraNear: any;
  /**
   * @deprecated Use shadow.camera.far instead.
   */
  shadowCameraFar: any;
  /**
   * @deprecated Use shadow.bias instead.
   */
  shadowBias: any;
  /**
   * @deprecated Use shadow.mapSize.width instead.
   */
  shadowMapWidth: any;
  /**
   * @deprecated Use shadow.mapSize.height instead.
   */
  shadowMapHeight: any;
}
