﻿import {SuperMap} from '../SuperMap';
import {Util} from '../commontypes/Util';

/**
 * @class SuperMap.TransportationAnalystResultSetting
 * @classdesc 交通网络分析结果参数类。
 * @description 通过该类设置交通网络分析返回的结果，包括是否返回图片、是否返回弧段空间信息、是否返回结点空间信息等。
 * @param options - {Object} 可选参数。如:</br>
 *        returnEdgeFeatures - {boolean} 是否在分析结果中包含弧段要素集合。</br>
 *        returnEdgeGeometry - {boolean} 返回的弧段要素集合中是否包含几何对象信息。默认为 false。</br>
 *        returnEdgeIDs - {boolean} 返回结果中是否包含经过弧段 ID 集合。默认为 false。</br>
 *        returnNodeFeatures - {boolean} 是否在分析结果中包含结点要素集合。</br>
 *        returnNodeGeometry - {boolean} 返回的结点要素集合中是否包含几何对象信息。默认为 false。</br>
 *        returnNodeIDs - {boolean} 返回结果中是否包含经过结点 ID 集合。默认为 false。</br>
 *        returnPathGuides - {boolean} 返回分析结果中是否包含行驶导引集合。</br>
 *        returnRoutes - {boolean} 返回分析结果中是否包含路由对象的集合。
 */
export class TransportationAnalystResultSetting {

    constructor(options) {
        if (!options) {
            return;
        }

        /**
         * @member SuperMap.TransportationAnalystResultSetting.prototype.returnEdgeFeatures -{boolean}
         * @description 是否在分析结果中包含弧段要素集合。弧段要素包括弧段的空间信息和属性信息。
         */
        this.returnEdgeFeatures = false;

        /**
         * @member SuperMap.TransportationAnalystResultSetting.prototype.returnEdgeGeometry -{boolean}
         * @description 返回的弧段要素集合中是否包含几何对象信息。默认为 false。
         */
        this.returnEdgeGeometry = false;

        /**
         * @member SuperMap.TransportationAnalystResultSetting.prototype.returnEdgeIDs -{boolean}
         * @description 返回结果中是否包含经过弧段 ID 集合。默认为 false。
         */
        this.returnEdgeIDs = false;

        /**
         * @member SuperMap.TransportationAnalystResultSetting.prototype.returnNodeFeatures -{boolean}
         * @description 是否在分析结果中包含结点要素集合。
         * 结点要素包括结点的空间信息和属性信息。其中返回的结点要素是否包含空间信息可通过 returnNodeGeometry 字段设置。默认为 false。
         */
        this.returnNodeFeatures = false;

        /**
         * @member SuperMap.TransportationAnalystResultSetting.prototype.returnNodeGeometry -{boolean}
         * @description 返回的结点要素集合中是否包含几何对象信息。默认为 false。
         */
        this.returnNodeGeometry = false;

        /**
         * @member SuperMap.TransportationAnalystResultSetting.prototype.returnNodeIDs -{boolean}
         * @description 返回结果中是否包含经过结点 ID 集合。默认为 false。
         */
        this.returnNodeIDs = false;

        /**
         * @member SuperMap.TransportationAnalystResultSetting.prototype.returnPathGuides -{boolean}
         * @description 返回分析结果中是否包含行驶导引集合。
         */
        this.returnPathGuides = false;

        /**
         * @member SuperMap.TransportationAnalystResultSetting.prototype.returnRoutes -{boolean}
         * @description 返回分析结果中是否包含路由对象的集合。
         */
        this.returnRoutes = false;

        Util.extend(this, options);

        this.CLASS_NAME = "SuperMap.TransportationAnalystResultSetting";
    }

    /**
     * @function SuperMap.TransportationAnalystResultSetting.prototype.destroy
     * @description 释放资源，将引用资源的属性置空。
     */
    destroy() {
        var me = this;
        me.returnEdgeFeatures = null;
        me.returnEdgeGeometry = null;
        me.returnEdgeIDs = null;
        me.returnNodeFeatures = null;
        me.returnNodeGeometry = null;
        me.returnNodeIDs = null;
        me.returnPathGuides = null;
        me.returnRoutes = null;
    }

}

SuperMap.TransportationAnalystResultSetting = TransportationAnalystResultSetting;