/*!
 * surveyjs - Survey JavaScript library v1.12.22
 * Copyright (c) 2015-2025 Devsoft Baltic OÜ  - http://surveyjs.io/
 * License: MIT (http://www.opensource.org/licenses/mit-license.php)
 */
(function webpackUniversalModuleDefinition(root, factory) {
	if(typeof exports === 'object' && typeof module === 'object')
		module.exports = factory();
	else if(typeof define === 'function' && define.amd)
		define("survey-core", [], factory);
	else if(typeof exports === 'object')
		exports["survey-core"] = factory();
	else
		root["Survey"] = factory();
})(this, function() {
return /******/ (function(modules) { // webpackBootstrap
/******/ 	// The module cache
/******/ 	var installedModules = {};
/******/
/******/ 	// The require function
/******/ 	function __webpack_require__(moduleId) {
/******/
/******/ 		// Check if module is in cache
/******/ 		if(installedModules[moduleId]) {
/******/ 			return installedModules[moduleId].exports;
/******/ 		}
/******/ 		// Create a new module (and put it into the cache)
/******/ 		var module = installedModules[moduleId] = {
/******/ 			i: moduleId,
/******/ 			l: false,
/******/ 			exports: {}
/******/ 		};
/******/
/******/ 		// Execute the module function
/******/ 		modules[moduleId].call(module.exports, module, module.exports, __webpack_require__);
/******/
/******/ 		// Flag the module as loaded
/******/ 		module.l = true;
/******/
/******/ 		// Return the exports of the module
/******/ 		return module.exports;
/******/ 	}
/******/
/******/
/******/ 	// expose the modules object (__webpack_modules__)
/******/ 	__webpack_require__.m = modules;
/******/
/******/ 	// expose the module cache
/******/ 	__webpack_require__.c = installedModules;
/******/
/******/ 	// define getter function for harmony exports
/******/ 	__webpack_require__.d = function(exports, name, getter) {
/******/ 		if(!__webpack_require__.o(exports, name)) {
/******/ 			Object.defineProperty(exports, name, { enumerable: true, get: getter });
/******/ 		}
/******/ 	};
/******/
/******/ 	// define __esModule on exports
/******/ 	__webpack_require__.r = function(exports) {
/******/ 		if(typeof Symbol !== 'undefined' && Symbol.toStringTag) {
/******/ 			Object.defineProperty(exports, Symbol.toStringTag, { value: 'Module' });
/******/ 		}
/******/ 		Object.defineProperty(exports, '__esModule', { value: true });
/******/ 	};
/******/
/******/ 	// create a fake namespace object
/******/ 	// mode & 1: value is a module id, require it
/******/ 	// mode & 2: merge all properties of value into the ns
/******/ 	// mode & 4: return value when already ns object
/******/ 	// mode & 8|1: behave like require
/******/ 	__webpack_require__.t = function(value, mode) {
/******/ 		if(mode & 1) value = __webpack_require__(value);
/******/ 		if(mode & 8) return value;
/******/ 		if((mode & 4) && typeof value === 'object' && value && value.__esModule) return value;
/******/ 		var ns = Object.create(null);
/******/ 		__webpack_require__.r(ns);
/******/ 		Object.defineProperty(ns, 'default', { enumerable: true, value: value });
/******/ 		if(mode & 2 && typeof value != 'string') for(var key in value) __webpack_require__.d(ns, key, function(key) { return value[key]; }.bind(null, key));
/******/ 		return ns;
/******/ 	};
/******/
/******/ 	// getDefaultExport function for compatibility with non-harmony modules
/******/ 	__webpack_require__.n = function(module) {
/******/ 		var getter = module && module.__esModule ?
/******/ 			function getDefault() { return module['default']; } :
/******/ 			function getModuleExports() { return module; };
/******/ 		__webpack_require__.d(getter, 'a', getter);
/******/ 		return getter;
/******/ 	};
/******/
/******/ 	// Object.prototype.hasOwnProperty.call
/******/ 	__webpack_require__.o = function(object, property) { return Object.prototype.hasOwnProperty.call(object, property); };
/******/
/******/ 	// __webpack_public_path__
/******/ 	__webpack_require__.p = "";
/******/
/******/
/******/ 	// Load entry module and return exports
/******/ 	return __webpack_require__(__webpack_require__.s = "./src/entries/core.ts");
/******/ })
/************************************************************************/
/******/ ({

/***/ "./src/entries/core.ts":
/*!*******************************************!*\
  !*** ./src/entries/core.ts + 127 modules ***!
  \*******************************************/
/*! exports provided: Version, ReleaseDate, checkLibraryVersion, setLicenseKey, slk, hasLicense, settings, Helpers, AnswerCountValidator, EmailValidator, NumericValidator, RegexValidator, SurveyValidator, TextValidator, ValidatorResult, ExpressionValidator, ValidatorRunner, ItemValue, Base, Event, EventBase, ArrayChanges, ComputedUpdater, SurveyError, SurveyElementCore, SurveyElement, DragTypeOverMeEnum, CalculatedValue, CustomError, AnswerRequiredError, OneAnswerRequiredError, RequreNumericError, ExceedSizeError, LocalizableString, LocalizableStrings, HtmlConditionItem, UrlConditionItem, ChoicesRestful, ChoicesRestfull, FunctionFactory, registerFunction, ConditionRunner, ExpressionRunner, ExpressionExecutor, Operand, Const, BinaryOperand, Variable, FunctionOperand, ArrayOperand, UnaryOperand, ConditionsParser, ProcessValue, JsonError, JsonIncorrectTypeError, JsonMetadata, JsonMetadataClass, JsonMissingTypeError, JsonMissingTypeErrorBase, JsonObject, JsonObjectProperty, JsonRequiredPropertyError, JsonUnknownPropertyError, Serializer, property, propertyArray, MatrixDropdownCell, MatrixDropdownRowModelBase, QuestionMatrixDropdownModelBase, MatrixDropdownColumn, matrixDropdownColumnTypes, QuestionMatrixDropdownRenderedCell, QuestionMatrixDropdownRenderedRow, QuestionMatrixDropdownRenderedErrorRow, QuestionMatrixDropdownRenderedTable, MatrixDropdownRowModel, QuestionMatrixDropdownModel, MatrixDynamicRowModel, QuestionMatrixDynamicModel, MatrixRowModel, MatrixCells, QuestionMatrixModel, QuestionMatrixBaseModel, MultipleTextItemModel, MultipleTextCell, MultipleTextErrorCell, MutlipleTextErrorRow, MutlipleTextRow, QuestionMultipleTextModel, MultipleTextEditorModel, PanelModel, PanelModelBase, QuestionRowModel, FlowPanelModel, PageModel, DefaultTitleModel, Question, QuestionNonValue, QuestionEmptyModel, QuestionCheckboxBase, QuestionSelectBase, QuestionCheckboxModel, QuestionTagboxModel, QuestionRankingModel, QuestionCommentModel, QuestionDropdownModel, QuestionFactory, ElementFactory, QuestionFileModel, QuestionFilePage, QuestionHtmlModel, QuestionRadiogroupModel, QuestionRatingModel, RenderedRatingItem, QuestionExpressionModel, QuestionTextBase, CharacterCounter, QuestionTextModel, QuestionBooleanModel, QuestionImagePickerModel, ImageItemValue, QuestionImageModel, QuestionSignaturePadModel, QuestionPanelDynamicModel, QuestionPanelDynamicItem, SurveyTimer, SurveyTimerModel, tryFocusPage, createTOCListModel, getTocRootCss, TOCModel, SurveyProgressModel, ProgressButtons, ProgressButtonsResponsivityManager, SurveyModel, SurveyTrigger, SurveyTriggerComplete, SurveyTriggerSetValue, SurveyTriggerVisible, SurveyTriggerCopyValue, SurveyTriggerRunExpression, SurveyTriggerSkip, Trigger, PopupSurveyModel, SurveyWindowModel, TextPreProcessor, Notifier, Cover, CoverCell, dxSurveyService, englishStrings, surveyLocalization, surveyStrings, getLocaleString, getLocaleStrings, setupLocale, QuestionCustomWidget, CustomWidgetCollection, QuestionCustomModel, QuestionCompositeModel, ComponentQuestionJSON, ComponentCollection, ListModel, MultiSelectListModel, PopupModel, createDialogOptions, PopupBaseViewModel, PopupDropdownViewModel, PopupModalViewModel, createPopupViewModel, createPopupModalViewModel, DropdownListModel, DropdownMultiSelectListModel, QuestionButtonGroupModel, ButtonGroupItemModel, ButtonGroupItemValue, IsMobile, IsTouch, _setIsTouch, confirmAction, confirmActionAsync, detectIEOrEdge, doKey2ClickUp, doKey2ClickDown, doKey2ClickBlur, loadFileFromBase64, increaseHeightByContent, createSvg, chooseFiles, sanitizeEditableContent, prepareElementForVerticalAnimation, cleanHtmlElementAfterAnimation, classesToSelector, renamedIcons, getIconNameFromProxy, InputMaskBase, InputMaskPattern, InputMaskNumeric, InputMaskDateTime, InputMaskCurrency, CssClassBuilder, TextAreaModel, surveyCss, defaultV2Css, defaultV2ThemeName, DragDropCore, DragDropChoices, DragDropRankingSelectToRank, StylesManager, defaultStandardCss, modernCss, SvgIconRegistry, SvgRegistry, SvgThemeSets, addIconsToThemeSet, RendererFactory, ResponsivityManager, VerticalResponsivityManager, unwrap, getOriginalEvent, getElement, activateLazyRenderingChecks, createDropdownActionModel, createDropdownActionModelAdvanced, createPopupModelWithListModel, getActionDropdownButtonTarget, BaseAction, Action, ActionDropdownViewModel, AnimationUtils, AnimationPropertyUtils, AnimationGroupUtils, AnimationProperty, AnimationBoolean, AnimationGroup, AnimationTab, AdaptiveActionContainer, defaultActionBarCss, ActionContainer, DragOrClickHelper, Model */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
// ESM COMPAT FLAG
__webpack_require__.r(__webpack_exports__);

// EXPORTS
__webpack_require__.d(__webpack_exports__, "Version", function() { return /* reexport */ Version; });
__webpack_require__.d(__webpack_exports__, "ReleaseDate", function() { return /* reexport */ ReleaseDate; });
__webpack_require__.d(__webpack_exports__, "checkLibraryVersion", function() { return /* reexport */ checkLibraryVersion; });
__webpack_require__.d(__webpack_exports__, "setLicenseKey", function() { return /* reexport */ setLicenseKey; });
__webpack_require__.d(__webpack_exports__, "slk", function() { return /* reexport */ slk; });
__webpack_require__.d(__webpack_exports__, "hasLicense", function() { return /* reexport */ hasLicense; });
__webpack_require__.d(__webpack_exports__, "settings", function() { return /* reexport */ settings; });
__webpack_require__.d(__webpack_exports__, "Helpers", function() { return /* reexport */ helpers_Helpers; });
__webpack_require__.d(__webpack_exports__, "AnswerCountValidator", function() { return /* reexport */ AnswerCountValidator; });
__webpack_require__.d(__webpack_exports__, "EmailValidator", function() { return /* reexport */ EmailValidator; });
__webpack_require__.d(__webpack_exports__, "NumericValidator", function() { return /* reexport */ validator_NumericValidator; });
__webpack_require__.d(__webpack_exports__, "RegexValidator", function() { return /* reexport */ RegexValidator; });
__webpack_require__.d(__webpack_exports__, "SurveyValidator", function() { return /* reexport */ validator_SurveyValidator; });
__webpack_require__.d(__webpack_exports__, "TextValidator", function() { return /* reexport */ TextValidator; });
__webpack_require__.d(__webpack_exports__, "ValidatorResult", function() { return /* reexport */ ValidatorResult; });
__webpack_require__.d(__webpack_exports__, "ExpressionValidator", function() { return /* reexport */ validator_ExpressionValidator; });
__webpack_require__.d(__webpack_exports__, "ValidatorRunner", function() { return /* reexport */ ValidatorRunner; });
__webpack_require__.d(__webpack_exports__, "ItemValue", function() { return /* reexport */ itemvalue_ItemValue; });
__webpack_require__.d(__webpack_exports__, "Base", function() { return /* reexport */ base_Base; });
__webpack_require__.d(__webpack_exports__, "Event", function() { return /* reexport */ Event; });
__webpack_require__.d(__webpack_exports__, "EventBase", function() { return /* reexport */ EventBase; });
__webpack_require__.d(__webpack_exports__, "ArrayChanges", function() { return /* reexport */ ArrayChanges; });
__webpack_require__.d(__webpack_exports__, "ComputedUpdater", function() { return /* reexport */ ComputedUpdater; });
__webpack_require__.d(__webpack_exports__, "SurveyError", function() { return /* reexport */ survey_error_SurveyError; });
__webpack_require__.d(__webpack_exports__, "SurveyElementCore", function() { return /* reexport */ survey_element_SurveyElementCore; });
__webpack_require__.d(__webpack_exports__, "SurveyElement", function() { return /* reexport */ survey_element_SurveyElement; });
__webpack_require__.d(__webpack_exports__, "DragTypeOverMeEnum", function() { return /* reexport */ DragTypeOverMeEnum; });
__webpack_require__.d(__webpack_exports__, "CalculatedValue", function() { return /* reexport */ calculatedValue_CalculatedValue; });
__webpack_require__.d(__webpack_exports__, "CustomError", function() { return /* reexport */ CustomError; });
__webpack_require__.d(__webpack_exports__, "AnswerRequiredError", function() { return /* reexport */ AnswerRequiredError; });
__webpack_require__.d(__webpack_exports__, "OneAnswerRequiredError", function() { return /* reexport */ OneAnswerRequiredError; });
__webpack_require__.d(__webpack_exports__, "RequreNumericError", function() { return /* reexport */ RequreNumericError; });
__webpack_require__.d(__webpack_exports__, "ExceedSizeError", function() { return /* reexport */ error_ExceedSizeError; });
__webpack_require__.d(__webpack_exports__, "LocalizableString", function() { return /* reexport */ localizablestring_LocalizableString; });
__webpack_require__.d(__webpack_exports__, "LocalizableStrings", function() { return /* reexport */ localizablestring_LocalizableStrings; });
__webpack_require__.d(__webpack_exports__, "HtmlConditionItem", function() { return /* reexport */ HtmlConditionItem; });
__webpack_require__.d(__webpack_exports__, "UrlConditionItem", function() { return /* reexport */ UrlConditionItem; });
__webpack_require__.d(__webpack_exports__, "ChoicesRestful", function() { return /* reexport */ choicesRestful_ChoicesRestful; });
__webpack_require__.d(__webpack_exports__, "ChoicesRestfull", function() { return /* reexport */ choicesRestful_ChoicesRestfull; });
__webpack_require__.d(__webpack_exports__, "FunctionFactory", function() { return /* reexport */ functionsfactory_FunctionFactory; });
__webpack_require__.d(__webpack_exports__, "registerFunction", function() { return /* reexport */ registerFunction; });
__webpack_require__.d(__webpack_exports__, "ConditionRunner", function() { return /* reexport */ ConditionRunner; });
__webpack_require__.d(__webpack_exports__, "ExpressionRunner", function() { return /* reexport */ ExpressionRunner; });
__webpack_require__.d(__webpack_exports__, "ExpressionExecutor", function() { return /* reexport */ conditions_ExpressionExecutor; });
__webpack_require__.d(__webpack_exports__, "Operand", function() { return /* reexport */ Operand; });
__webpack_require__.d(__webpack_exports__, "Const", function() { return /* reexport */ expressions_Const; });
__webpack_require__.d(__webpack_exports__, "BinaryOperand", function() { return /* reexport */ BinaryOperand; });
__webpack_require__.d(__webpack_exports__, "Variable", function() { return /* reexport */ expressions_Variable; });
__webpack_require__.d(__webpack_exports__, "FunctionOperand", function() { return /* reexport */ expressions_FunctionOperand; });
__webpack_require__.d(__webpack_exports__, "ArrayOperand", function() { return /* reexport */ ArrayOperand; });
__webpack_require__.d(__webpack_exports__, "UnaryOperand", function() { return /* reexport */ UnaryOperand; });
__webpack_require__.d(__webpack_exports__, "ConditionsParser", function() { return /* reexport */ conditionsParser_ConditionsParser; });
__webpack_require__.d(__webpack_exports__, "ProcessValue", function() { return /* reexport */ conditionProcessValue_ProcessValue; });
__webpack_require__.d(__webpack_exports__, "JsonError", function() { return /* reexport */ JsonError; });
__webpack_require__.d(__webpack_exports__, "JsonIncorrectTypeError", function() { return /* reexport */ JsonIncorrectTypeError; });
__webpack_require__.d(__webpack_exports__, "JsonMetadata", function() { return /* reexport */ JsonMetadata; });
__webpack_require__.d(__webpack_exports__, "JsonMetadataClass", function() { return /* reexport */ jsonobject_JsonMetadataClass; });
__webpack_require__.d(__webpack_exports__, "JsonMissingTypeError", function() { return /* reexport */ JsonMissingTypeError; });
__webpack_require__.d(__webpack_exports__, "JsonMissingTypeErrorBase", function() { return /* reexport */ JsonMissingTypeErrorBase; });
__webpack_require__.d(__webpack_exports__, "JsonObject", function() { return /* reexport */ jsonobject_JsonObject; });
__webpack_require__.d(__webpack_exports__, "JsonObjectProperty", function() { return /* reexport */ jsonobject_JsonObjectProperty; });
__webpack_require__.d(__webpack_exports__, "JsonRequiredPropertyError", function() { return /* reexport */ JsonRequiredPropertyError; });
__webpack_require__.d(__webpack_exports__, "JsonUnknownPropertyError", function() { return /* reexport */ JsonUnknownPropertyError; });
__webpack_require__.d(__webpack_exports__, "Serializer", function() { return /* reexport */ Serializer; });
__webpack_require__.d(__webpack_exports__, "property", function() { return /* reexport */ jsonobject_property; });
__webpack_require__.d(__webpack_exports__, "propertyArray", function() { return /* reexport */ propertyArray; });
__webpack_require__.d(__webpack_exports__, "MatrixDropdownCell", function() { return /* reexport */ question_matrixdropdownbase_MatrixDropdownCell; });
__webpack_require__.d(__webpack_exports__, "MatrixDropdownRowModelBase", function() { return /* reexport */ question_matrixdropdownbase_MatrixDropdownRowModelBase; });
__webpack_require__.d(__webpack_exports__, "QuestionMatrixDropdownModelBase", function() { return /* reexport */ question_matrixdropdownbase_QuestionMatrixDropdownModelBase; });
__webpack_require__.d(__webpack_exports__, "MatrixDropdownColumn", function() { return /* reexport */ question_matrixdropdowncolumn_MatrixDropdownColumn; });
__webpack_require__.d(__webpack_exports__, "matrixDropdownColumnTypes", function() { return /* reexport */ matrixDropdownColumnTypes; });
__webpack_require__.d(__webpack_exports__, "QuestionMatrixDropdownRenderedCell", function() { return /* reexport */ question_matrixdropdownrendered_QuestionMatrixDropdownRenderedCell; });
__webpack_require__.d(__webpack_exports__, "QuestionMatrixDropdownRenderedRow", function() { return /* reexport */ question_matrixdropdownrendered_QuestionMatrixDropdownRenderedRow; });
__webpack_require__.d(__webpack_exports__, "QuestionMatrixDropdownRenderedErrorRow", function() { return /* reexport */ question_matrixdropdownrendered_QuestionMatrixDropdownRenderedErrorRow; });
__webpack_require__.d(__webpack_exports__, "QuestionMatrixDropdownRenderedTable", function() { return /* reexport */ question_matrixdropdownrendered_QuestionMatrixDropdownRenderedTable; });
__webpack_require__.d(__webpack_exports__, "MatrixDropdownRowModel", function() { return /* reexport */ MatrixDropdownRowModel; });
__webpack_require__.d(__webpack_exports__, "QuestionMatrixDropdownModel", function() { return /* reexport */ question_matrixdropdown_QuestionMatrixDropdownModel; });
__webpack_require__.d(__webpack_exports__, "MatrixDynamicRowModel", function() { return /* reexport */ MatrixDynamicRowModel; });
__webpack_require__.d(__webpack_exports__, "QuestionMatrixDynamicModel", function() { return /* reexport */ question_matrixdynamic_QuestionMatrixDynamicModel; });
__webpack_require__.d(__webpack_exports__, "MatrixRowModel", function() { return /* reexport */ question_matrix_MatrixRowModel; });
__webpack_require__.d(__webpack_exports__, "MatrixCells", function() { return /* reexport */ question_matrix_MatrixCells; });
__webpack_require__.d(__webpack_exports__, "QuestionMatrixModel", function() { return /* reexport */ question_matrix_QuestionMatrixModel; });
__webpack_require__.d(__webpack_exports__, "QuestionMatrixBaseModel", function() { return /* reexport */ martixBase_QuestionMatrixBaseModel; });
__webpack_require__.d(__webpack_exports__, "MultipleTextItemModel", function() { return /* reexport */ question_multipletext_MultipleTextItemModel; });
__webpack_require__.d(__webpack_exports__, "MultipleTextCell", function() { return /* reexport */ question_multipletext_MultipleTextCell; });
__webpack_require__.d(__webpack_exports__, "MultipleTextErrorCell", function() { return /* reexport */ question_multipletext_MultipleTextErrorCell; });
__webpack_require__.d(__webpack_exports__, "MutlipleTextErrorRow", function() { return /* reexport */ MutlipleTextErrorRow; });
__webpack_require__.d(__webpack_exports__, "MutlipleTextRow", function() { return /* reexport */ question_multipletext_MutlipleTextRow; });
__webpack_require__.d(__webpack_exports__, "QuestionMultipleTextModel", function() { return /* reexport */ question_multipletext_QuestionMultipleTextModel; });
__webpack_require__.d(__webpack_exports__, "MultipleTextEditorModel", function() { return /* reexport */ MultipleTextEditorModel; });
__webpack_require__.d(__webpack_exports__, "PanelModel", function() { return /* reexport */ panel_PanelModel; });
__webpack_require__.d(__webpack_exports__, "PanelModelBase", function() { return /* reexport */ panel_PanelModelBase; });
__webpack_require__.d(__webpack_exports__, "QuestionRowModel", function() { return /* reexport */ panel_QuestionRowModel; });
__webpack_require__.d(__webpack_exports__, "FlowPanelModel", function() { return /* reexport */ flowpanel_FlowPanelModel; });
__webpack_require__.d(__webpack_exports__, "PageModel", function() { return /* reexport */ page_PageModel; });
__webpack_require__.d(__webpack_exports__, "DefaultTitleModel", function() { return /* reexport */ defaultTitle_DefaultTitleModel; });
__webpack_require__.d(__webpack_exports__, "Question", function() { return /* reexport */ question_Question; });
__webpack_require__.d(__webpack_exports__, "QuestionNonValue", function() { return /* reexport */ QuestionNonValue; });
__webpack_require__.d(__webpack_exports__, "QuestionEmptyModel", function() { return /* reexport */ QuestionEmptyModel; });
__webpack_require__.d(__webpack_exports__, "QuestionCheckboxBase", function() { return /* reexport */ QuestionCheckboxBase; });
__webpack_require__.d(__webpack_exports__, "QuestionSelectBase", function() { return /* reexport */ question_baseselect_QuestionSelectBase; });
__webpack_require__.d(__webpack_exports__, "QuestionCheckboxModel", function() { return /* reexport */ question_checkbox_QuestionCheckboxModel; });
__webpack_require__.d(__webpack_exports__, "QuestionTagboxModel", function() { return /* reexport */ question_tagbox_QuestionTagboxModel; });
__webpack_require__.d(__webpack_exports__, "QuestionRankingModel", function() { return /* reexport */ question_ranking_QuestionRankingModel; });
__webpack_require__.d(__webpack_exports__, "QuestionCommentModel", function() { return /* reexport */ question_comment_QuestionCommentModel; });
__webpack_require__.d(__webpack_exports__, "QuestionDropdownModel", function() { return /* reexport */ question_dropdown_QuestionDropdownModel; });
__webpack_require__.d(__webpack_exports__, "QuestionFactory", function() { return /* reexport */ questionfactory_QuestionFactory; });
__webpack_require__.d(__webpack_exports__, "ElementFactory", function() { return /* reexport */ questionfactory_ElementFactory; });
__webpack_require__.d(__webpack_exports__, "QuestionFileModel", function() { return /* reexport */ question_file_QuestionFileModel; });
__webpack_require__.d(__webpack_exports__, "QuestionFilePage", function() { return /* reexport */ question_file_QuestionFilePage; });
__webpack_require__.d(__webpack_exports__, "QuestionHtmlModel", function() { return /* reexport */ question_html_QuestionHtmlModel; });
__webpack_require__.d(__webpack_exports__, "QuestionRadiogroupModel", function() { return /* reexport */ question_radiogroup_QuestionRadiogroupModel; });
__webpack_require__.d(__webpack_exports__, "QuestionRatingModel", function() { return /* reexport */ question_rating_QuestionRatingModel; });
__webpack_require__.d(__webpack_exports__, "RenderedRatingItem", function() { return /* reexport */ question_rating_RenderedRatingItem; });
__webpack_require__.d(__webpack_exports__, "QuestionExpressionModel", function() { return /* reexport */ question_expression_QuestionExpressionModel; });
__webpack_require__.d(__webpack_exports__, "QuestionTextBase", function() { return /* reexport */ question_textbase_QuestionTextBase; });
__webpack_require__.d(__webpack_exports__, "CharacterCounter", function() { return /* reexport */ question_textbase_CharacterCounter; });
__webpack_require__.d(__webpack_exports__, "QuestionTextModel", function() { return /* reexport */ question_text_QuestionTextModel; });
__webpack_require__.d(__webpack_exports__, "QuestionBooleanModel", function() { return /* reexport */ question_boolean_QuestionBooleanModel; });
__webpack_require__.d(__webpack_exports__, "QuestionImagePickerModel", function() { return /* reexport */ question_imagepicker_QuestionImagePickerModel; });
__webpack_require__.d(__webpack_exports__, "ImageItemValue", function() { return /* reexport */ question_imagepicker_ImageItemValue; });
__webpack_require__.d(__webpack_exports__, "QuestionImageModel", function() { return /* reexport */ question_image_QuestionImageModel; });
__webpack_require__.d(__webpack_exports__, "QuestionSignaturePadModel", function() { return /* reexport */ question_signaturepad_QuestionSignaturePadModel; });
__webpack_require__.d(__webpack_exports__, "QuestionPanelDynamicModel", function() { return /* reexport */ question_paneldynamic_QuestionPanelDynamicModel; });
__webpack_require__.d(__webpack_exports__, "QuestionPanelDynamicItem", function() { return /* reexport */ question_paneldynamic_QuestionPanelDynamicItem; });
__webpack_require__.d(__webpack_exports__, "SurveyTimer", function() { return /* reexport */ surveytimer_SurveyTimer; });
__webpack_require__.d(__webpack_exports__, "SurveyTimerModel", function() { return /* reexport */ surveyTimerModel_SurveyTimerModel; });
__webpack_require__.d(__webpack_exports__, "tryFocusPage", function() { return /* reexport */ tryFocusPage; });
__webpack_require__.d(__webpack_exports__, "createTOCListModel", function() { return /* reexport */ createTOCListModel; });
__webpack_require__.d(__webpack_exports__, "getTocRootCss", function() { return /* reexport */ getTocRootCss; });
__webpack_require__.d(__webpack_exports__, "TOCModel", function() { return /* reexport */ surveyToc_TOCModel; });
__webpack_require__.d(__webpack_exports__, "SurveyProgressModel", function() { return /* reexport */ surveyProgress_SurveyProgressModel; });
__webpack_require__.d(__webpack_exports__, "ProgressButtons", function() { return /* reexport */ progress_buttons_ProgressButtons; });
__webpack_require__.d(__webpack_exports__, "ProgressButtonsResponsivityManager", function() { return /* reexport */ ProgressButtonsResponsivityManager; });
__webpack_require__.d(__webpack_exports__, "SurveyModel", function() { return /* reexport */ survey_SurveyModel; });
__webpack_require__.d(__webpack_exports__, "SurveyTrigger", function() { return /* reexport */ SurveyTrigger; });
__webpack_require__.d(__webpack_exports__, "SurveyTriggerComplete", function() { return /* reexport */ trigger_SurveyTriggerComplete; });
__webpack_require__.d(__webpack_exports__, "SurveyTriggerSetValue", function() { return /* reexport */ SurveyTriggerSetValue; });
__webpack_require__.d(__webpack_exports__, "SurveyTriggerVisible", function() { return /* reexport */ SurveyTriggerVisible; });
__webpack_require__.d(__webpack_exports__, "SurveyTriggerCopyValue", function() { return /* reexport */ SurveyTriggerCopyValue; });
__webpack_require__.d(__webpack_exports__, "SurveyTriggerRunExpression", function() { return /* reexport */ trigger_SurveyTriggerRunExpression; });
__webpack_require__.d(__webpack_exports__, "SurveyTriggerSkip", function() { return /* reexport */ trigger_SurveyTriggerSkip; });
__webpack_require__.d(__webpack_exports__, "Trigger", function() { return /* reexport */ trigger_Trigger; });
__webpack_require__.d(__webpack_exports__, "PopupSurveyModel", function() { return /* reexport */ popup_survey_PopupSurveyModel; });
__webpack_require__.d(__webpack_exports__, "SurveyWindowModel", function() { return /* reexport */ SurveyWindowModel; });
__webpack_require__.d(__webpack_exports__, "TextPreProcessor", function() { return /* reexport */ textPreProcessor_TextPreProcessor; });
__webpack_require__.d(__webpack_exports__, "Notifier", function() { return /* reexport */ notifier_Notifier; });
__webpack_require__.d(__webpack_exports__, "Cover", function() { return /* reexport */ header_Cover; });
__webpack_require__.d(__webpack_exports__, "CoverCell", function() { return /* reexport */ CoverCell; });
__webpack_require__.d(__webpack_exports__, "dxSurveyService", function() { return /* reexport */ dxSurveyService_dxSurveyService; });
__webpack_require__.d(__webpack_exports__, "englishStrings", function() { return /* reexport */ englishStrings; });
__webpack_require__.d(__webpack_exports__, "surveyLocalization", function() { return /* reexport */ surveyLocalization; });
__webpack_require__.d(__webpack_exports__, "surveyStrings", function() { return /* reexport */ surveyStrings; });
__webpack_require__.d(__webpack_exports__, "getLocaleString", function() { return /* reexport */ getLocaleString; });
__webpack_require__.d(__webpack_exports__, "getLocaleStrings", function() { return /* reexport */ getLocaleStrings; });
__webpack_require__.d(__webpack_exports__, "setupLocale", function() { return /* reexport */ setupLocale; });
__webpack_require__.d(__webpack_exports__, "QuestionCustomWidget", function() { return /* reexport */ QuestionCustomWidget; });
__webpack_require__.d(__webpack_exports__, "CustomWidgetCollection", function() { return /* reexport */ questionCustomWidgets_CustomWidgetCollection; });
__webpack_require__.d(__webpack_exports__, "QuestionCustomModel", function() { return /* reexport */ question_custom_QuestionCustomModel; });
__webpack_require__.d(__webpack_exports__, "QuestionCompositeModel", function() { return /* reexport */ question_custom_QuestionCompositeModel; });
__webpack_require__.d(__webpack_exports__, "ComponentQuestionJSON", function() { return /* reexport */ question_custom_ComponentQuestionJSON; });
__webpack_require__.d(__webpack_exports__, "ComponentCollection", function() { return /* reexport */ question_custom_ComponentCollection; });
__webpack_require__.d(__webpack_exports__, "ListModel", function() { return /* reexport */ list_ListModel; });
__webpack_require__.d(__webpack_exports__, "MultiSelectListModel", function() { return /* reexport */ multiSelectListModel_MultiSelectListModel; });
__webpack_require__.d(__webpack_exports__, "PopupModel", function() { return /* reexport */ popup_PopupModel; });
__webpack_require__.d(__webpack_exports__, "createDialogOptions", function() { return /* reexport */ createDialogOptions; });
__webpack_require__.d(__webpack_exports__, "PopupBaseViewModel", function() { return /* reexport */ popup_view_model_PopupBaseViewModel; });
__webpack_require__.d(__webpack_exports__, "PopupDropdownViewModel", function() { return /* reexport */ popup_dropdown_view_model_PopupDropdownViewModel; });
__webpack_require__.d(__webpack_exports__, "PopupModalViewModel", function() { return /* reexport */ PopupModalViewModel; });
__webpack_require__.d(__webpack_exports__, "createPopupViewModel", function() { return /* reexport */ createPopupViewModel; });
__webpack_require__.d(__webpack_exports__, "createPopupModalViewModel", function() { return /* reexport */ createPopupModalViewModel; });
__webpack_require__.d(__webpack_exports__, "DropdownListModel", function() { return /* reexport */ dropdownListModel_DropdownListModel; });
__webpack_require__.d(__webpack_exports__, "DropdownMultiSelectListModel", function() { return /* reexport */ dropdownMultiSelectListModel_DropdownMultiSelectListModel; });
__webpack_require__.d(__webpack_exports__, "QuestionButtonGroupModel", function() { return /* reexport */ QuestionButtonGroupModel; });
__webpack_require__.d(__webpack_exports__, "ButtonGroupItemModel", function() { return /* reexport */ question_buttongroup_ButtonGroupItemModel; });
__webpack_require__.d(__webpack_exports__, "ButtonGroupItemValue", function() { return /* reexport */ question_buttongroup_ButtonGroupItemValue; });
__webpack_require__.d(__webpack_exports__, "IsMobile", function() { return /* reexport */ IsMobile; });
__webpack_require__.d(__webpack_exports__, "IsTouch", function() { return /* reexport */ IsTouch; });
__webpack_require__.d(__webpack_exports__, "_setIsTouch", function() { return /* reexport */ _setIsTouch; });
__webpack_require__.d(__webpack_exports__, "confirmAction", function() { return /* reexport */ confirmAction; });
__webpack_require__.d(__webpack_exports__, "confirmActionAsync", function() { return /* reexport */ confirmActionAsync; });
__webpack_require__.d(__webpack_exports__, "detectIEOrEdge", function() { return /* reexport */ detectIEOrEdge; });
__webpack_require__.d(__webpack_exports__, "doKey2ClickUp", function() { return /* reexport */ doKey2ClickUp; });
__webpack_require__.d(__webpack_exports__, "doKey2ClickDown", function() { return /* reexport */ doKey2ClickDown; });
__webpack_require__.d(__webpack_exports__, "doKey2ClickBlur", function() { return /* reexport */ doKey2ClickBlur; });
__webpack_require__.d(__webpack_exports__, "loadFileFromBase64", function() { return /* reexport */ loadFileFromBase64; });
__webpack_require__.d(__webpack_exports__, "increaseHeightByContent", function() { return /* reexport */ increaseHeightByContent; });
__webpack_require__.d(__webpack_exports__, "createSvg", function() { return /* reexport */ createSvg; });
__webpack_require__.d(__webpack_exports__, "chooseFiles", function() { return /* reexport */ chooseFiles; });
__webpack_require__.d(__webpack_exports__, "sanitizeEditableContent", function() { return /* reexport */ sanitizeEditableContent; });
__webpack_require__.d(__webpack_exports__, "prepareElementForVerticalAnimation", function() { return /* reexport */ prepareElementForVerticalAnimation; });
__webpack_require__.d(__webpack_exports__, "cleanHtmlElementAfterAnimation", function() { return /* reexport */ cleanHtmlElementAfterAnimation; });
__webpack_require__.d(__webpack_exports__, "classesToSelector", function() { return /* reexport */ classesToSelector; });
__webpack_require__.d(__webpack_exports__, "renamedIcons", function() { return /* reexport */ renamedIcons; });
__webpack_require__.d(__webpack_exports__, "getIconNameFromProxy", function() { return /* reexport */ getIconNameFromProxy; });
__webpack_require__.d(__webpack_exports__, "InputMaskBase", function() { return /* reexport */ mask_base_InputMaskBase; });
__webpack_require__.d(__webpack_exports__, "InputMaskPattern", function() { return /* reexport */ mask_pattern_InputMaskPattern; });
__webpack_require__.d(__webpack_exports__, "InputMaskNumeric", function() { return /* reexport */ mask_numeric_InputMaskNumeric; });
__webpack_require__.d(__webpack_exports__, "InputMaskDateTime", function() { return /* reexport */ mask_datetime_InputMaskDateTime; });
__webpack_require__.d(__webpack_exports__, "InputMaskCurrency", function() { return /* reexport */ mask_currency_InputMaskCurrency; });
__webpack_require__.d(__webpack_exports__, "CssClassBuilder", function() { return /* reexport */ CssClassBuilder; });
__webpack_require__.d(__webpack_exports__, "TextAreaModel", function() { return /* reexport */ text_area_TextAreaModel; });
__webpack_require__.d(__webpack_exports__, "surveyCss", function() { return /* reexport */ surveyCss; });
__webpack_require__.d(__webpack_exports__, "defaultV2Css", function() { return /* reexport */ defaultV2Css; });
__webpack_require__.d(__webpack_exports__, "defaultV2ThemeName", function() { return /* reexport */ defaultV2ThemeName; });
__webpack_require__.d(__webpack_exports__, "DragDropCore", function() { return /* reexport */ core_DragDropCore; });
__webpack_require__.d(__webpack_exports__, "DragDropChoices", function() { return /* reexport */ choices_DragDropChoices; });
__webpack_require__.d(__webpack_exports__, "DragDropRankingSelectToRank", function() { return /* reexport */ DragDropRankingSelectToRank; });
__webpack_require__.d(__webpack_exports__, "StylesManager", function() { return /* reexport */ stylesmanager_StylesManager; });
__webpack_require__.d(__webpack_exports__, "defaultStandardCss", function() { return /* reexport */ defaultStandardCss; });
__webpack_require__.d(__webpack_exports__, "modernCss", function() { return /* reexport */ modernCss; });
__webpack_require__.d(__webpack_exports__, "SvgIconRegistry", function() { return /* reexport */ svgbundle_SvgIconRegistry; });
__webpack_require__.d(__webpack_exports__, "SvgRegistry", function() { return /* reexport */ SvgRegistry; });
__webpack_require__.d(__webpack_exports__, "SvgThemeSets", function() { return /* reexport */ SvgThemeSets; });
__webpack_require__.d(__webpack_exports__, "addIconsToThemeSet", function() { return /* reexport */ addIconsToThemeSet; });
__webpack_require__.d(__webpack_exports__, "RendererFactory", function() { return /* reexport */ RendererFactory; });
__webpack_require__.d(__webpack_exports__, "ResponsivityManager", function() { return /* reexport */ responsivity_manager_ResponsivityManager; });
__webpack_require__.d(__webpack_exports__, "VerticalResponsivityManager", function() { return /* reexport */ VerticalResponsivityManager; });
__webpack_require__.d(__webpack_exports__, "unwrap", function() { return /* reexport */ unwrap; });
__webpack_require__.d(__webpack_exports__, "getOriginalEvent", function() { return /* reexport */ getOriginalEvent; });
__webpack_require__.d(__webpack_exports__, "getElement", function() { return /* reexport */ getElement; });
__webpack_require__.d(__webpack_exports__, "activateLazyRenderingChecks", function() { return /* reexport */ activateLazyRenderingChecks; });
__webpack_require__.d(__webpack_exports__, "createDropdownActionModel", function() { return /* reexport */ createDropdownActionModel; });
__webpack_require__.d(__webpack_exports__, "createDropdownActionModelAdvanced", function() { return /* reexport */ createDropdownActionModelAdvanced; });
__webpack_require__.d(__webpack_exports__, "createPopupModelWithListModel", function() { return /* reexport */ createPopupModelWithListModel; });
__webpack_require__.d(__webpack_exports__, "getActionDropdownButtonTarget", function() { return /* reexport */ getActionDropdownButtonTarget; });
__webpack_require__.d(__webpack_exports__, "BaseAction", function() { return /* reexport */ action_BaseAction; });
__webpack_require__.d(__webpack_exports__, "Action", function() { return /* reexport */ action_Action; });
__webpack_require__.d(__webpack_exports__, "ActionDropdownViewModel", function() { return /* reexport */ ActionDropdownViewModel; });
__webpack_require__.d(__webpack_exports__, "AnimationUtils", function() { return /* reexport */ animation_AnimationUtils; });
__webpack_require__.d(__webpack_exports__, "AnimationPropertyUtils", function() { return /* reexport */ AnimationPropertyUtils; });
__webpack_require__.d(__webpack_exports__, "AnimationGroupUtils", function() { return /* reexport */ AnimationGroupUtils; });
__webpack_require__.d(__webpack_exports__, "AnimationProperty", function() { return /* reexport */ animation_AnimationProperty; });
__webpack_require__.d(__webpack_exports__, "AnimationBoolean", function() { return /* reexport */ AnimationBoolean; });
__webpack_require__.d(__webpack_exports__, "AnimationGroup", function() { return /* reexport */ animation_AnimationGroup; });
__webpack_require__.d(__webpack_exports__, "AnimationTab", function() { return /* reexport */ AnimationTab; });
__webpack_require__.d(__webpack_exports__, "AdaptiveActionContainer", function() { return /* reexport */ adaptive_container_AdaptiveActionContainer; });
__webpack_require__.d(__webpack_exports__, "defaultActionBarCss", function() { return /* reexport */ defaultActionBarCss; });
__webpack_require__.d(__webpack_exports__, "ActionContainer", function() { return /* reexport */ container_ActionContainer; });
__webpack_require__.d(__webpack_exports__, "DragOrClickHelper", function() { return /* reexport */ dragOrClickHelper_DragOrClickHelper; });
__webpack_require__.d(__webpack_exports__, "Model", function() { return /* reexport */ survey_SurveyModel; });

// CONCATENATED MODULE: ./packages/survey-core/src/global_variables_utils.ts
/* eslint-disable no-restricted-globals */
var DomWindowHelper = /** @class */ (function () {
    function DomWindowHelper() {
    }
    DomWindowHelper.isAvailable = function () {
        return "undefined" !== typeof window;
    };
    DomWindowHelper.isFileReaderAvailable = function () {
        if (!DomWindowHelper.isAvailable())
            return false;
        return !!window["FileReader"];
    };
    DomWindowHelper.getLocation = function () {
        if (!DomWindowHelper.isAvailable())
            return;
        return window.location;
    };
    DomWindowHelper.getVisualViewport = function () {
        if (!DomWindowHelper.isAvailable())
            return null;
        return window.visualViewport;
    };
    DomWindowHelper.getInnerWidth = function () {
        if (!DomWindowHelper.isAvailable())
            return;
        return window.innerWidth;
    };
    DomWindowHelper.getInnerHeight = function () {
        if (!DomWindowHelper.isAvailable())
            return null;
        return window.innerHeight;
    };
    DomWindowHelper.getWindow = function () {
        if (!DomWindowHelper.isAvailable())
            return;
        return window;
    };
    DomWindowHelper.hasOwn = function (propertyName) {
        if (!DomWindowHelper.isAvailable())
            return;
        return propertyName in window;
    };
    DomWindowHelper.getSelection = function () {
        if (DomWindowHelper.isAvailable() && window.getSelection) {
            return window.getSelection();
        }
    };
    DomWindowHelper.requestAnimationFrame = function (callback) {
        if (DomWindowHelper.isAvailable()) {
            return window.requestAnimationFrame(callback);
        }
    };
    DomWindowHelper.addEventListener = function (type, listener) {
        if (!DomWindowHelper.isAvailable())
            return;
        window.addEventListener(type, listener);
    };
    DomWindowHelper.removeEventListener = function (type, listener) {
        if (!DomWindowHelper.isAvailable())
            return;
        window.removeEventListener(type, listener);
    };
    DomWindowHelper.matchMedia = function (mediaQueryString) {
        if (!DomWindowHelper.isAvailable() || typeof window.matchMedia === "undefined")
            return null;
        return window.matchMedia(mediaQueryString);
    };
    return DomWindowHelper;
}());

var DomDocumentHelper = /** @class */ (function () {
    function DomDocumentHelper() {
    }
    DomDocumentHelper.isAvailable = function () {
        return "undefined" !== typeof document;
    };
    DomDocumentHelper.getBody = function () {
        if (!DomDocumentHelper.isAvailable())
            return;
        return document.body;
    };
    DomDocumentHelper.getDocumentElement = function () {
        if (!DomDocumentHelper.isAvailable())
            return;
        return document.documentElement;
    };
    DomDocumentHelper.getDocument = function () {
        if (!DomDocumentHelper.isAvailable())
            return;
        return document;
    };
    DomDocumentHelper.getCookie = function () {
        if (!DomDocumentHelper.isAvailable())
            return;
        return document.cookie;
    };
    DomDocumentHelper.setCookie = function (newCookie) {
        if (!DomDocumentHelper.isAvailable())
            return;
        document.cookie = newCookie;
    };
    DomDocumentHelper.activeElementBlur = function () {
        if (!DomDocumentHelper.isAvailable())
            return;
        var activeElement = document.activeElement;
        if (!!activeElement && !!activeElement.blur) {
            activeElement.blur();
        }
    };
    DomDocumentHelper.createElement = function (tagName) {
        if (!DomDocumentHelper.isAvailable())
            return;
        return document.createElement(tagName);
    };
    DomDocumentHelper.getComputedStyle = function (elt) {
        if (!DomDocumentHelper.isAvailable())
            return new CSSStyleDeclaration();
        return document.defaultView.getComputedStyle(elt);
    };
    DomDocumentHelper.addEventListener = function (type, listener) {
        if (!DomDocumentHelper.isAvailable())
            return;
        document.addEventListener(type, listener);
    };
    DomDocumentHelper.removeEventListener = function (type, listener) {
        if (!DomDocumentHelper.isAvailable())
            return;
        document.removeEventListener(type, listener);
    };
    return DomDocumentHelper;
}());


// CONCATENATED MODULE: ./packages/survey-core/src/helpers.ts

function createDate(reason, val) {
    if (!val)
        return new Date();
    if (!settings.storeUtcDates && typeof val === "string" && isISODateOnly(val)) {
        val += "T00:00:00";
    }
    var d = new Date(val);
    return settings.onDateCreated(d, reason, val);
}
function isISODateOnly(str) {
    if (str.indexOf("T") > 0)
        return false;
    if (!/\d{4}-\d{2}-\d{2}/.test(str))
        return false;
    return !isNaN(new Date(str).getTime());
}
var helpers_Helpers = /** @class */ (function () {
    function Helpers() {
    }
    /**
     * A static methods that returns true if a value undefined, null, empty string or empty array.
     * @param value
     */
    Helpers.isValueEmpty = function (value) {
        if (Array.isArray(value) && value.length === 0)
            return true;
        if (!!value && Helpers.isValueObject(value) && value.constructor === Object) {
            for (var key in value) {
                if (!Helpers.isValueEmpty(value[key]))
                    return false;
            }
            return true;
        }
        return !value && value !== 0 && value !== false;
    };
    Helpers.isArrayContainsEqual = function (x, y) {
        if (!Array.isArray(x) || !Array.isArray(y))
            return false;
        if (x.length !== y.length)
            return false;
        for (var i = 0; i < x.length; i++) {
            var j = 0;
            for (; j < y.length; j++) {
                if (Helpers.isTwoValueEquals(x[i], y[j]))
                    break;
            }
            if (j === y.length)
                return false;
        }
        return true;
    };
    Helpers.isArraysEqual = function (x, y, ignoreOrder, caseSensitive, trimStrings) {
        if (ignoreOrder === void 0) { ignoreOrder = false; }
        if (!Array.isArray(x) || !Array.isArray(y))
            return false;
        if (x.length !== y.length)
            return false;
        if (ignoreOrder) {
            var xSorted = [];
            var ySorted = [];
            for (var i = 0; i < x.length; i++) {
                xSorted.push(x[i]);
                ySorted.push(y[i]);
            }
            xSorted.sort();
            ySorted.sort();
            x = xSorted;
            y = ySorted;
        }
        for (var i = 0; i < x.length; i++) {
            if (!Helpers.isTwoValueEquals(x[i], y[i], ignoreOrder, caseSensitive, trimStrings))
                return false;
        }
        return true;
    };
    Helpers.compareStrings = function (x, y) {
        var normalize = settings.comparator.normalizeTextCallback;
        if (!!x)
            x = normalize(x, "compare").trim();
        if (!!y)
            y = normalize(y, "compare").trim();
        if (!x && !y)
            return 0;
        if (!x)
            return -1;
        if (!y)
            return 1;
        if (x === y)
            return 0;
        var digitIndex = -1;
        for (var i = 0; i < x.length && i < y.length; i++) {
            if (this.isCharDigit(x[i]) && this.isCharDigit(y[i])) {
                digitIndex = i;
                break;
            }
            if (x[i] !== y[i])
                break;
        }
        if (digitIndex > -1) {
            var nX = this.getNumberFromStr(x, digitIndex);
            var nY = this.getNumberFromStr(y, digitIndex);
            if (!Number.isNaN(nX) && !Number.isNaN(nY) && nX !== nY) {
                return nX > nY ? 1 : -1;
            }
        }
        return x > y ? 1 : -1;
    };
    Helpers.isTwoValueEquals = function (x, y, ignoreOrder, caseSensitive, trimStrings) {
        if (ignoreOrder === void 0) { ignoreOrder = false; }
        if (x === y)
            return true;
        if (Array.isArray(x) && x.length === 0 && typeof y === "undefined")
            return true;
        if (Array.isArray(y) && y.length === 0 && typeof x === "undefined")
            return true;
        if ((x === undefined || x === null) && y === "")
            return true;
        if ((y === undefined || y === null) && x === "")
            return true;
        if (trimStrings === undefined)
            trimStrings = settings.comparator.trimStrings;
        if (caseSensitive === undefined)
            caseSensitive = settings.comparator.caseSensitive;
        if (typeof x === "string" && typeof y === "string") {
            var normalize = settings.comparator.normalizeTextCallback;
            x = normalize(x, "compare");
            y = normalize(y, "compare");
            if (trimStrings) {
                x = x.trim();
                y = y.trim();
            }
            if (!caseSensitive) {
                x = x.toLowerCase();
                y = y.toLowerCase();
            }
            return x === y;
        }
        if (x instanceof Date && y instanceof Date)
            return x.getTime() == y.getTime();
        if (Helpers.isConvertibleToNumber(x) && Helpers.isConvertibleToNumber(y)) {
            if (parseInt(x) === parseInt(y) && parseFloat(x) === parseFloat(y)) {
                return true;
            }
        }
        if ((!Helpers.isValueEmpty(x) && Helpers.isValueEmpty(y)) ||
            (Helpers.isValueEmpty(x) && !Helpers.isValueEmpty(y)))
            return false;
        if ((x === true || x === false) && typeof y == "string") {
            return x.toString() === y.toLocaleLowerCase();
        }
        if ((y === true || y === false) && typeof x == "string") {
            return y.toString() === x.toLocaleLowerCase();
        }
        if (!Helpers.isValueObject(x) && !Helpers.isValueObject(y))
            return x == y;
        if (!Helpers.isValueObject(x) || !Helpers.isValueObject(y))
            return false;
        if (x["equals"] && y["equals"])
            return x.equals(y);
        if (Array.isArray(x) && Array.isArray(y)) {
            return Helpers.isArraysEqual(x, y, ignoreOrder, caseSensitive, trimStrings);
        }
        for (var p in x) {
            if (!x.hasOwnProperty(p))
                continue;
            if (!y.hasOwnProperty(p))
                return false;
            if (!this.isTwoValueEquals(x[p], y[p], ignoreOrder, caseSensitive, trimStrings))
                return false;
        }
        for (p in y) {
            if (y.hasOwnProperty(p) && !x.hasOwnProperty(p))
                return false;
        }
        return true;
    };
    Helpers.randomizeArray = function (array) {
        for (var i = array.length - 1; i > 0; i--) {
            var j = Math.floor(Math.random() * (i + 1));
            var temp = array[i];
            array[i] = array[j];
            array[j] = temp;
        }
        return array;
    };
    Helpers.getUnbindValue = function (value) {
        if (Array.isArray(value)) {
            var res = [];
            for (var i = 0; i < value.length; i++) {
                res.push(Helpers.getUnbindValue(value[i]));
            }
            return res;
        }
        if (!!value && Helpers.isValueObject(value) && !(value instanceof Date)) {
            return JSON.parse(JSON.stringify(value));
        }
        return value;
    };
    Helpers.createCopy = function (obj) {
        var res = {};
        if (!obj)
            return res;
        for (var key in obj) {
            res[key] = obj[key];
        }
        return res;
    };
    Helpers.isConvertibleToNumber = function (value) {
        return (value !== undefined &&
            value !== null &&
            !Array.isArray(value) &&
            !isNaN(value));
    };
    Helpers.isValueObject = function (val, excludeArray) {
        return val instanceof Object && (!excludeArray || !Array.isArray(val));
    };
    Helpers.isNumber = function (value) {
        return !isNaN(this.getNumber(value));
    };
    Helpers.getNumber = function (value) {
        var newValue = Helpers.getNumberCore(value);
        return settings.parseNumber(value, newValue);
    };
    Helpers.getNumberCore = function (value) {
        if (typeof value == "string") {
            value = value.trim();
            if (!value)
                return NaN;
            if (value.indexOf("0x") == 0) {
                if (value.length > 32)
                    return NaN;
                return parseInt(value);
            }
            if (value.length > 15 && Helpers.isDigitsOnly(value))
                return NaN;
            if (Helpers.isStringHasOperator(value))
                return NaN;
        }
        value = this.prepareStringToNumber(value);
        var res = parseFloat(value);
        if (isNaN(res) || !isFinite(value))
            return NaN;
        return res;
    };
    Helpers.isStringHasOperator = function (str) {
        if (str.lastIndexOf("-") > 0)
            return false;
        if (str.lastIndexOf("+") > 0)
            return false;
        var operators = "*^/%";
        for (var i = 0; i < operators.length; i++) {
            if (str.indexOf(operators[i]) > -1)
                return true;
        }
        return false;
    };
    Helpers.prepareStringToNumber = function (val) {
        if (typeof val !== "string" || !val)
            return val;
        var i = val.indexOf(",");
        if (i > -1 && val.indexOf(",", i + 1) < 0) {
            return val.replace(",", ".");
        }
        return val;
    };
    Helpers.getMaxLength = function (maxLength, surveyLength) {
        if (maxLength < 0) {
            maxLength = surveyLength;
        }
        return maxLength > 0 ? maxLength : null;
    };
    Helpers.getRemainingCharacterCounterText = function (newValue, maxLength) {
        if (!maxLength || maxLength <= 0 || !settings.showMaxLengthIndicator) {
            return "";
        }
        var value = newValue ? newValue.length : "0";
        return [value, maxLength].join("/");
    };
    Helpers.getNumberByIndex = function (index, startIndexStr, parentIndex) {
        if (index < 0)
            return "";
        var startIndex = 1;
        var prefix = "";
        var postfix = ".";
        var isNumeric = true;
        var strIndex = "A";
        var str = "";
        var hasDigitFunc = function (str) {
            if (!str)
                return false;
            for (var i = 0; i < str.length; i++) {
                if (Helpers.isCharDigit(str[i]))
                    return true;
            }
            return false;
        };
        if (!!startIndexStr) {
            str = startIndexStr;
            var ind = str.length - 1;
            var hasDigit = hasDigitFunc(str);
            var checkLetter = function () {
                return ((hasDigit && !Helpers.isCharDigit(str[ind])) ||
                    Helpers.isCharNotLetterAndDigit(str[ind]));
            };
            while (ind >= 0 && checkLetter())
                ind--;
            var newPostfix = "";
            if (ind < str.length - 1) {
                newPostfix = str.substring(ind + 1);
                str = str.substring(0, ind + 1);
            }
            ind = str.length - 1;
            while (ind >= 0) {
                if (checkLetter())
                    break;
                ind--;
                if (!hasDigit)
                    break;
            }
            strIndex = str.substring(ind + 1);
            prefix = str.substring(0, ind + 1);
            if (parseInt(strIndex))
                startIndex = parseInt(strIndex);
            else if (strIndex.length == 1)
                isNumeric = false;
            if (!!newPostfix || !!prefix) {
                postfix = newPostfix;
            }
        }
        if (parentIndex > -1 && hasDigitFunc(prefix)) {
            prefix = this.getNumberByIndex(parentIndex, prefix);
        }
        if (isNumeric) {
            var val = (index + startIndex).toString();
            while (val.length < strIndex.length)
                val = "0" + val;
            return prefix + val + postfix;
        }
        return (prefix + String.fromCharCode(strIndex.charCodeAt(0) + index) + postfix);
    };
    Helpers.isCharNotLetterAndDigit = function (ch) {
        return ch.toUpperCase() == ch.toLowerCase() && !Helpers.isCharDigit(ch);
    };
    Helpers.isCharDigit = function (ch) {
        return ch >= "0" && ch <= "9";
    };
    Helpers.isDigitsOnly = function (str) {
        if (!str)
            return false;
        for (var i = 0; i < str.length; i++) {
            if (!Helpers.isCharDigit(str[i]))
                return false;
        }
        return true;
    };
    Helpers.getNumberFromStr = function (str, index) {
        if (!this.isCharDigit(str[index]))
            return NaN;
        var nStr = "";
        while (index < str.length && this.isCharDigit(str[index])) {
            nStr += str[index];
            index++;
        }
        if (!nStr)
            return NaN;
        return this.getNumber(nStr);
    };
    Helpers.countDecimals = function (value) {
        if (Helpers.isNumber(value) && Math.floor(value) !== value) {
            var strs = value.toString().split(".");
            return strs.length > 1 && strs[1].length || 0;
        }
        return 0;
    };
    Helpers.correctAfterPlusMinis = function (a, b, res) {
        var digitsA = Helpers.countDecimals(a);
        var digitsB = Helpers.countDecimals(b);
        if (digitsA > 0 || digitsB > 0) {
            var digits = Math.max(digitsA, digitsB);
            res = parseFloat(res.toFixed(digits));
        }
        return res;
    };
    Helpers.sumAnyValues = function (a, b) {
        if (!Helpers.isNumber(a) || !Helpers.isNumber(b)) {
            if (Array.isArray(a) && Array.isArray(b))
                return [].concat(a).concat(b);
            if (Array.isArray(a) || Array.isArray(b)) {
                var arr = Array.isArray(a) ? a : b;
                var val = arr === a ? b : a;
                if (typeof val === "string") {
                    var str = arr.join(", ");
                    return arr === a ? str + val : val + str;
                }
                if (typeof val === "number") {
                    var res = 0;
                    for (var i = 0; i < arr.length; i++) {
                        if (typeof arr[i] === "number") {
                            res = Helpers.correctAfterPlusMinis(res, arr[i], res + arr[i]);
                        }
                    }
                    return Helpers.correctAfterPlusMinis(res, val, res + val);
                }
            }
            return a + b;
        }
        if (typeof a === "string" || typeof b === "string")
            return a + b;
        return Helpers.correctAfterPlusMinis(a, b, a + b);
    };
    Helpers.correctAfterMultiple = function (a, b, res) {
        var digits = Helpers.countDecimals(a) + Helpers.countDecimals(b);
        if (digits > 0) {
            res = parseFloat(res.toFixed(digits));
        }
        return res;
    };
    Helpers.convertArrayValueToObject = function (src, propName, dest) {
        if (dest === void 0) { dest = undefined; }
        var res = new Array();
        if (!src || !Array.isArray(src))
            return res;
        for (var i = 0; i < src.length; i++) {
            var item = void 0;
            if (Array.isArray(dest)) {
                item = Helpers.findObjByPropValue(dest, propName, src[i]);
            }
            if (!item) {
                item = {};
                item[propName] = src[i];
            }
            res.push(item);
        }
        return res;
    };
    Helpers.findObjByPropValue = function (arr, propName, val) {
        for (var i = 0; i < arr.length; i++) {
            if (Helpers.isTwoValueEquals(arr[i][propName], val))
                return arr[i];
        }
        return undefined;
    };
    Helpers.convertArrayObjectToValue = function (src, propName) {
        var res = new Array();
        if (!src || !Array.isArray(src))
            return res;
        for (var i = 0; i < src.length; i++) {
            var itemVal = !!src[i] ? src[i][propName] : undefined;
            if (!Helpers.isValueEmpty(itemVal))
                res.push(itemVal);
        }
        return res;
    };
    Helpers.convertDateToString = function (date) {
        var toStr = function (val) {
            if (val < 10)
                return "0" + val.toString();
            return val.toString();
        };
        return date.getFullYear() + "-" + toStr(date.getMonth() + 1) + "-" + toStr(date.getDate());
    };
    Helpers.convertDateTimeToString = function (date) {
        var toStr = function (val) {
            if (val < 10)
                return "0" + val.toString();
            return val.toString();
        };
        return this.convertDateToString(date) + " " + toStr(date.getHours()) + ":" + toStr(date.getMinutes());
    };
    Helpers.convertValToQuestionVal = function (val, inputType) {
        if (val instanceof Date) {
            if (inputType === "datetime-local")
                return Helpers.convertDateTimeToString(val);
            return Helpers.convertDateToString(val);
        }
        return this.getUnbindValue(val);
    };
    Helpers.compareVerions = function (ver1, ver2) {
        if (!ver1 && !ver2)
            return 0;
        var ver1Ar = ver1.split(".");
        var ver2Ar = ver2.split(".");
        var len1 = ver1Ar.length;
        var len2 = ver2Ar.length;
        for (var i = 0; i < len1 && i < len2; i++) {
            var str1 = ver1Ar[i];
            var str2 = ver2Ar[i];
            if (str1.length === str2.length) {
                if (str1 !== str2) {
                    return str1 < str2 ? -1 : 1;
                }
            }
            else {
                return str1.length < str2.length ? -1 : 1;
            }
        }
        return len1 === len2 ? 0 : (len1 < len2 ? -1 : 1);
    };
    Helpers.isUrlYoutubeVideo = function (url) {
        if (!url)
            return false;
        var youtubeDomains = ["www.youtube.com", "m.youtube.com", "youtube.com", "youtu.be"];
        url = url.toLowerCase();
        url = url.replace(/^https?:\/\//, "");
        for (var i = 0; i < youtubeDomains.length; i++) {
            if (url.indexOf(youtubeDomains[i] + "/") === 0)
                return true;
        }
        return false;
    };
    return Helpers;
}());

if (!String.prototype["format"]) {
    String.prototype["format"] = function () {
        var args = arguments;
        return this.replace(/{(\d+)}/g, function (match, number) {
            return typeof args[number] != "undefined" ? args[number] : match;
        });
    };
}

// CONCATENATED MODULE: ./packages/survey-core/src/localization/english.ts
// Uncomment the line below if you create a custom dictionary
// import { setupLocale } from "survey-core";
var englishStrings = {
    pagePrevText: "Previous",
    pageNextText: "Next",
    completeText: "Complete",
    previewText: "Preview",
    editText: "Edit",
    startSurveyText: "Start",
    otherItemText: "Other (describe)",
    noneItemText: "None",
    refuseItemText: "Refuse to answer",
    dontKnowItemText: "Don't know",
    selectAllItemText: "Select All",
    deselectAllItemText: "Deselect all",
    progressText: "Page {0} of {1}",
    indexText: "{0} of {1}",
    panelDynamicProgressText: "{0} of {1}",
    panelDynamicTabTextFormat: "Panel {panelIndex}",
    questionsProgressText: "Answered {0}/{1} questions",
    emptySurvey: "The survey doesn't contain any visible elements.",
    completingSurvey: "Thank you for completing the survey",
    completingSurveyBefore: "You have already completed this survey.",
    loadingSurvey: "Loading Survey...",
    placeholder: "Select...",
    ratingOptionsCaption: "Select...",
    value: "value",
    requiredError: "Response required.",
    requiredErrorInPanel: "Response required: answer at least one question.",
    requiredInAllRowsError: "Response required: answer questions in all rows.",
    eachRowUniqueError: "Each row must have a unique value.",
    numericError: "The value should be numeric.",
    minError: "The value should not be less than {0}",
    maxError: "The value should not be greater than {0}",
    textNoDigitsAllow: "Numbers are not allowed.",
    textMinLength: "Please enter at least {0} character(s).",
    textMaxLength: "Please enter no more than {0} character(s).",
    textMinMaxLength: "Please enter at least {0} and no more than {1} characters.",
    minRowCountError: "Please fill in at least {0} row(s).",
    minSelectError: "Please select at least {0} option(s).",
    maxSelectError: "Please select no more than {0} option(s).",
    numericMinMax: "The '{0}' should be at least {1} and at most {2}",
    numericMin: "The '{0}' should be at least {1}",
    numericMax: "The '{0}' should be at most {1}",
    invalidEmail: "Please enter a valid e-mail address.",
    invalidExpression: "The expression: {0} should return 'true'.",
    urlRequestError: "The request returned error '{0}'. {1}",
    urlGetChoicesError: "The request returned empty data or the 'path' property is incorrect",
    exceedMaxSize: "The file size should not exceed {0}.",
    noUploadFilesHandler: "Files cannot be uploaded. Please add a handler for the 'onUploadFiles' event.",
    otherRequiredError: "Response required: enter another value.",
    uploadingFile: "Your file is uploading. Please wait several seconds and try again.",
    loadingFile: "Loading...",
    chooseFile: "Choose file(s)...",
    noFileChosen: "No file selected",
    filePlaceholder: "Drag and drop a file here or click the button below to select a file to upload.",
    confirmDelete: "Are you sure you want to delete this record?",
    keyDuplicationError: "This value should be unique.",
    addColumn: "Add Column",
    addRow: "Add Row",
    removeRow: "Remove",
    emptyRowsText: "There are no rows.",
    addPanel: "Add new",
    removePanel: "Remove",
    showDetails: "Show Details",
    hideDetails: "Hide Details",
    choices_Item: "item",
    matrix_column: "Column",
    matrix_row: "Row",
    multipletext_itemname: "text",
    savingData: "The results are being saved on the server...",
    savingDataError: "An error occurred and we could not save the results.",
    savingDataSuccess: "The results were saved successfully!",
    savingExceedSize: "Your response exceeds 64KB. Please reduce the size of your file(s) and try again or contact the survey owner.",
    saveAgainButton: "Try again",
    timerMin: "min",
    timerSec: "sec",
    timerSpentAll: "You have spent {0} on this page and {1} in total.",
    timerSpentPage: "You have spent {0} on this page.",
    timerSpentSurvey: "You have spent {0} in total.",
    timerLimitAll: "You have spent {0} of {1} on this page and {2} of {3} in total.",
    timerLimitPage: "You have spent {0} of {1} on this page.",
    timerLimitSurvey: "You have spent {0} of {1} in total.",
    clearCaption: "Clear",
    signaturePlaceHolder: "Sign here",
    signaturePlaceHolderReadOnly: "No signature",
    chooseFileCaption: "Select File",
    takePhotoCaption: "Take Photo",
    photoPlaceholder: "Click the button below to take a photo using the camera.",
    fileOrPhotoPlaceholder: "Drag and drop or select a file to upload or take a photo using the camera.",
    replaceFileCaption: "Replace file",
    removeFileCaption: "Remove this file",
    booleanCheckedLabel: "Yes",
    booleanUncheckedLabel: "No",
    confirmRemoveFile: "Are you sure that you want to remove this file: {0}?",
    confirmRemoveAllFiles: "Are you sure that you want to remove all files?",
    questionTitlePatternText: "Question Title",
    modalCancelButtonText: "Cancel",
    modalApplyButtonText: "Apply",
    filterStringPlaceholder: "Type to search...",
    emptyMessage: "No data to display",
    noEntriesText: "No entries yet.\nClick the button below to add a new entry.",
    noEntriesReadonlyText: "No entries",
    tabTitlePlaceholder: "New Panel",
    more: "More",
    tagboxDoneButtonCaption: "OK",
    selectToRankEmptyRankedAreaText: "All choices are selected for ranking",
    selectToRankEmptyUnrankedAreaText: "Drag choices here to rank them",
    ok: "OK",
    cancel: "Cancel",
};
// Uncomment the lines below if you create a custom dictionary.
// Replace "en" with a custom locale code (for example, "fr" or "de"),
// Replace `englishStrings` with the name of the variable that contains the custom dictionary.
//setupLocale({ localeCode: "en", strings: englishStrings, nativeName: "English", englishName: "English" });

// CONCATENATED MODULE: ./packages/survey-core/src/surveyStrings.ts

var surveyLocalization = {
    currentLocaleValue: "",
    defaultLocaleValue: "en",
    locales: {},
    localeNames: {},
    localeNamesInEnglish: {},
    localeDirections: {},
    supportedLocales: [],
    useEnglishNames: false,
    //TODO remove on next week
    get showNamesInEnglish() { return this.useEnglishNames; },
    set showNamesInEnglish(val) { this.useEnglishNames = val; },
    setupLocale: function (localeConfig) {
        var loc = localeConfig.localeCode;
        this.locales[loc] = localeConfig.strings;
        this.localeNames[loc] = localeConfig.nativeName;
        this.localeNamesInEnglish[loc] = localeConfig.englishName;
        if (localeConfig.rtl !== undefined) {
            this.localeDirections[loc] = localeConfig.rtl;
        }
    },
    get currentLocale() {
        return this.currentLocaleValue === this.defaultLocaleValue ? "" : this.currentLocaleValue;
    },
    set currentLocale(val) {
        if (val === "cz")
            val = "cs";
        this.currentLocaleValue = val;
    },
    get defaultLocale() {
        return this.defaultLocaleValue;
    },
    set defaultLocale(val) {
        if (val === "cz")
            val = "cs";
        this.defaultLocaleValue = val;
    },
    getLocaleStrings: function (loc) {
        return this.locales[loc];
    },
    getString: function (strName, locale) {
        var _this = this;
        if (locale === void 0) { locale = null; }
        var locs = new Array();
        var addLocaleCore = function (locName) {
            var strs = _this.locales[locName];
            if (!!strs)
                locs.push(strs);
        };
        var addLocale = function (locName) {
            if (!locName)
                return;
            addLocaleCore(locName);
            var index = locName.indexOf("-");
            if (index < 1)
                return;
            locName = locName.substring(0, index);
            addLocaleCore(locName);
        };
        addLocale(locale);
        addLocale(this.currentLocale);
        addLocale(this.defaultLocale);
        if (this.defaultLocale !== "en") {
            addLocaleCore("en");
        }
        for (var i = 0; i < locs.length; i++) {
            var res = locs[i][strName];
            if (res !== undefined)
                return res;
        }
        return this.onGetExternalString(strName, locale);
    },
    getLocaleName: function (loc, inEnglish) {
        if (!loc)
            return "";
        if (inEnglish === undefined)
            inEnglish = this.showNamesInEnglish;
        var firstNames = inEnglish ? this.localeNamesInEnglish : this.localeNames;
        var secondNames = inEnglish ? this.localeNames : this.localeNamesInEnglish;
        return firstNames[loc] || secondNames[loc] || loc;
    },
    getLocales: function (removeDefaultLoc) {
        var _this = this;
        if (removeDefaultLoc === void 0) { removeDefaultLoc = false; }
        var res = [];
        res.push("");
        var locs = this.locales;
        if (this.supportedLocales && this.supportedLocales.length > 0) {
            locs = {};
            for (var i = 0; i < this.supportedLocales.length; i++) {
                locs[this.supportedLocales[i]] = true;
            }
        }
        for (var key in locs) {
            if (removeDefaultLoc && key == this.defaultLocale)
                continue;
            res.push(key);
        }
        var locName = function (loc) {
            return _this.getLocaleName(loc).toLowerCase();
        };
        res.sort(function (a, b) {
            var str1 = locName(a);
            var str2 = locName(b);
            if (str1 === str2)
                return 0;
            return str1 < str2 ? -1 : 1;
        });
        return res;
    },
    onGetExternalString: function (name, locale) { return undefined; }
};
function getLocaleString(strName, locale) {
    if (locale === void 0) { locale = null; }
    return surveyLocalization.getString(strName, locale);
}
function getLocaleStrings(locale) {
    return surveyLocalization.getLocaleStrings(locale);
}
function setupLocale(localeConfig) {
    surveyLocalization.setupLocale(localeConfig);
}
var surveyStrings = englishStrings;
surveyLocalization.locales["en"] = englishStrings;
surveyLocalization.localeNames["en"] = "english";

// CONCATENATED MODULE: ./packages/survey-core/src/jsonobject.ts
var __extends = (undefined && undefined.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __spreadArray = (undefined && undefined.__spreadArray) || function (to, from) {
    for (var i = 0, il = from.length, j = to.length; i < il; i++, j++)
        to[j] = from[i];
    return to;
};



function ensureLocString(target, options, key) {
    var locString = target.getLocalizableString(key);
    if (!locString) {
        var defaultStr = void 0;
        if (typeof options.localizable === "object" && options.localizable.defaultStr) {
            defaultStr = options.localizable.defaultStr;
        }
        locString = target.createLocalizableString(key, target, true, defaultStr);
        if (typeof options.localizable === "object" &&
            typeof options.localizable.onGetTextCallback === "function") {
            locString.onGetTextCallback = options.localizable.onGetTextCallback;
        }
    }
}
function getLocStringValue(target, options, key) {
    ensureLocString(target, options, key);
    var res = target.getLocalizableStringText(key);
    if (!!res)
        return res;
    if (typeof options.localizable === "object" && options.localizable.defaultStr) {
        var loc = !!target.getLocale ? target.getLocale() : "";
        return getLocaleString(options.localizable.defaultStr, loc);
    }
    return "";
}
function jsonobject_property(options) {
    if (options === void 0) { options = {}; }
    // eslint-disable-next-line @typescript-eslint/explicit-module-boundary-types
    return function (target, key) {
        var processComputedUpdater = function (obj, val) {
            if (!!val && typeof val === "object" && val.type === ComputedUpdater.ComputedUpdaterType) {
                base_Base.startCollectDependencies(function () { return obj[key] = val.updater(); }, obj, key);
                var result = val.updater();
                var dependencies = base_Base.finishCollectDependencies();
                val.setDependencies(dependencies);
                if (obj.dependencies[key]) {
                    obj.dependencies[key].dispose();
                }
                obj.dependencies[key] = val;
                return result;
            }
            return val;
        };
        if (!options || !options.localizable) {
            Object.defineProperty(target, key, {
                get: function () {
                    // const serializationProperty = Serializer.getProperty(target.getType(), key);
                    // if(!!serializationProperty && options.defaultValue !== undefined) {
                    //   ConsoleWarnings.error("remove defaultValue from @property for class " + target.getType() + " property name is " + key);
                    // }
                    var defaultVal = null;
                    if (!!options) {
                        if (typeof options.getDefaultValue === "function") {
                            defaultVal = options.getDefaultValue(this);
                        }
                        if (options.defaultValue !== undefined) {
                            defaultVal = options.defaultValue;
                        }
                    }
                    return this.getPropertyValue(key, defaultVal);
                },
                set: function (val) {
                    var newValue = processComputedUpdater(this, val);
                    var prevValue = this.getPropertyValue(key);
                    if (newValue !== prevValue) {
                        this.setPropertyValue(key, newValue);
                        if (!!options && options.onSet) {
                            options.onSet(newValue, this, prevValue);
                        }
                    }
                },
            });
        }
        else {
            Object.defineProperty(target, key, {
                get: function () {
                    return getLocStringValue(this, options, key);
                },
                set: function (val) {
                    ensureLocString(this, options, key);
                    var newValue = processComputedUpdater(this, val);
                    this.setLocalizableStringText(key, newValue);
                    if (!!options && options.onSet) {
                        options.onSet(newValue, this);
                    }
                },
            });
            Object.defineProperty(target, typeof options.localizable === "object" && !!options.localizable.name ?
                options.localizable.name : "loc" + key.charAt(0).toUpperCase() + key.slice(1), {
                get: function () {
                    ensureLocString(this, options, key);
                    return this.getLocalizableString(key);
                },
            });
        }
    };
}
function ensureArray(target, options, key) {
    target.ensureArray(key, function (item, index) {
        var handler = !!options ? options.onPush : null;
        handler && handler(item, index, target);
    }, function (item, index) {
        var handler = !!options ? options.onRemove : null;
        handler && handler(item, index, target);
    });
}
function propertyArray(options) {
    return function (target, key) {
        Object.defineProperty(target, key, {
            get: function () {
                ensureArray(this, options, key);
                return this.getPropertyValue(key);
            },
            set: function (val) {
                ensureArray(this, options, key);
                var arr = this.getPropertyValue(key);
                if (val === arr) {
                    return;
                }
                if (arr) {
                    arr.splice.apply(arr, __spreadArray([0, arr.length], (val || [])));
                }
                else {
                    this.setPropertyValue(key, val);
                }
                if (!!options && options.onSet) {
                    options.onSet(val, this);
                }
            },
        });
    };
}
/**
 * Contains information about a property of a survey element (page, panel, questions, and etc).
 * @see addProperty
 * @see removeProperty
 * @see [Add Properties](https://surveyjs.io/Documentation/Survey-Creator#addproperties)
 * @see [Remove Properties](https://surveyjs.io/Documentation/Survey-Creator#removeproperties)
 */
var jsonobject_JsonObjectProperty = /** @class */ (function () {
    function JsonObjectProperty(classInfo, name, isRequired) {
        if (isRequired === void 0) { isRequired = false; }
        this.name = name;
        this.isRequiredValue = false;
        this.isUniqueValue = false;
        this.isSerializable = true;
        this.isLightSerializable = true;
        this.isCustom = false;
        this.isDynamicChoices = false; //TODO obsolete, use dependsOn attribute
        this.isBindable = false;
        this.category = "";
        this.categoryIndex = -1;
        this.visibleIndex = -1;
        this.maxLength = -1;
        this.isArray = false;
        this.classInfoValue = classInfo;
        this.isRequiredValue = isRequired;
        this.idValue = JsonObjectProperty.Index++;
    }
    Object.defineProperty(JsonObjectProperty.prototype, "id", {
        get: function () {
            return this.idValue;
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(JsonObjectProperty.prototype, "classInfo", {
        get: function () {
            return this.classInfoValue;
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(JsonObjectProperty.prototype, "type", {
        get: function () {
            return this.typeValue ? this.typeValue : "string";
        },
        set: function (value) {
            if (value === "itemvalues")
                value = "itemvalue[]";
            if (value === "textitems")
                value = "textitem[]";
            this.typeValue = value;
            if (this.typeValue.indexOf("[]") === this.typeValue.length - 2) {
                this.isArray = true;
                this.className = this.typeValue.substring(0, this.typeValue.length - 2);
            }
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(JsonObjectProperty.prototype, "isRequired", {
        get: function () {
            return this.isRequiredValue;
        },
        set: function (val) {
            if (val !== this.isRequired) {
                this.isRequiredValue = val;
                if (!!this.classInfo) {
                    this.classInfo.resetAllProperties();
                }
            }
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(JsonObjectProperty.prototype, "isUnique", {
        get: function () {
            return this.isUniqueValue;
        },
        set: function (val) {
            this.isUniqueValue = val;
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(JsonObjectProperty.prototype, "uniquePropertyName", {
        get: function () {
            return this.uniquePropertyValue;
        },
        set: function (val) {
            this.uniquePropertyValue = val;
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(JsonObjectProperty.prototype, "hasToUseGetValue", {
        get: function () {
            return this.onGetValue || this.serializationProperty;
        },
        enumerable: false,
        configurable: true
    });
    JsonObjectProperty.prototype.getDefaultValue = function (obj) {
        var result = !!this.defaultValueFunc ? this.defaultValueFunc(obj) : this.defaultValueValue;
        if (!!JsonObjectProperty.getItemValuesDefaultValue &&
            Serializer.isDescendantOf(this.className, "itemvalue")) {
            result = JsonObjectProperty.getItemValuesDefaultValue(this.defaultValueValue || [], this.className);
        }
        return result;
    };
    Object.defineProperty(JsonObjectProperty.prototype, "defaultValue", {
        get: function () {
            return this.getDefaultValue(undefined);
        },
        set: function (newValue) {
            this.defaultValueValue = newValue;
        },
        enumerable: false,
        configurable: true
    });
    JsonObjectProperty.prototype.isDefaultValue = function (value) {
        return this.isDefaultValueByObj(undefined, value);
    };
    JsonObjectProperty.prototype.isDefaultValueByObj = function (obj, value) {
        if (this.isLocalizable)
            return value === null || value === undefined;
        var dValue = this.getDefaultValue(obj);
        if (!helpers_Helpers.isValueEmpty(dValue)) {
            return helpers_Helpers.isTwoValueEquals(value, dValue, false, true, false);
        }
        return ((value === false && (this.type == "boolean" || this.type == "switch") && !this.defaultValueFunc) ||
            value === "" || helpers_Helpers.isValueEmpty(value));
    };
    JsonObjectProperty.prototype.getSerializableValue = function (obj, storeDefaults) {
        if (!!this.onSerializeValue)
            return this.onSerializeValue(obj);
        var value = this.getValue(obj);
        if (value === undefined || value === null)
            return undefined;
        if (!storeDefaults && this.isDefaultValueByObj(obj, value))
            return undefined;
        return value;
    };
    JsonObjectProperty.prototype.getValue = function (obj) {
        if (this.onGetValue) {
            obj = this.getOriginalObj(obj);
            return this.onGetValue(obj);
        }
        if (this.serializationProperty && !!obj[this.serializationProperty])
            return obj[this.serializationProperty].getJson();
        return obj[this.name];
    };
    JsonObjectProperty.prototype.getPropertyValue = function (obj) {
        if (this.isLocalizable) {
            return !!obj[this.serializationProperty]
                ? obj[this.serializationProperty].text
                : null;
        }
        return this.getValue(obj);
    };
    Object.defineProperty(JsonObjectProperty.prototype, "hasToUseSetValue", {
        get: function () {
            return this.onSetValue || this.serializationProperty;
        },
        enumerable: false,
        configurable: true
    });
    JsonObjectProperty.prototype.settingValue = function (obj, value) {
        if (!this.onSettingValue || obj.isLoadingFromJson)
            return value;
        return this.onSettingValue(obj, value);
    };
    JsonObjectProperty.prototype.setValue = function (obj, value, jsonConv) {
        if (this.onSetValue) {
            obj = this.getOriginalObj(obj);
            this.onSetValue(obj, value, jsonConv);
        }
        else {
            if (this.serializationProperty && !!obj[this.serializationProperty])
                obj[this.serializationProperty].setJson(value, true);
            else {
                if (value && typeof value === "string") {
                    if (this.type == "number") {
                        value = parseInt(value);
                    }
                    if (this.type == "boolean" || this.type == "switch") {
                        value = value.toLowerCase() === "true";
                    }
                }
                obj[this.name] = value;
            }
        }
    };
    JsonObjectProperty.prototype.validateValue = function (value) {
        var choices = this.choices;
        if (!Array.isArray(choices) || choices.length === 0)
            return true;
        return choices.indexOf(value) > -1;
    };
    JsonObjectProperty.prototype.getObjType = function (objType) {
        if (!this.classNamePart)
            return objType;
        return objType.replace(this.classNamePart, "");
    };
    Object.defineProperty(JsonObjectProperty.prototype, "choices", {
        /**
         * Depricated, please use getChoices
         */
        get: function () {
            return this.getChoices(null);
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(JsonObjectProperty.prototype, "hasChoices", {
        get: function () {
            return !!this.choicesValue || !!this.choicesfunc;
        },
        enumerable: false,
        configurable: true
    });
    JsonObjectProperty.prototype.getChoices = function (obj, choicesCallback) {
        if (choicesCallback === void 0) { choicesCallback = null; }
        if (this.choicesValue != null)
            return this.choicesValue;
        if (this.choicesfunc != null)
            return this.choicesfunc(obj, choicesCallback);
        return null;
    };
    JsonObjectProperty.prototype.setChoices = function (value, valueFunc) {
        if (valueFunc === void 0) { valueFunc = null; }
        this.choicesValue = value;
        this.choicesfunc = valueFunc;
    };
    JsonObjectProperty.prototype.getBaseValue = function () {
        if (!this.baseValue)
            return "";
        if (typeof this.baseValue == "function")
            return this.baseValue();
        return this.baseValue;
    };
    JsonObjectProperty.prototype.setBaseValue = function (val) {
        this.baseValue = val;
    };
    Object.defineProperty(JsonObjectProperty.prototype, "readOnly", {
        get: function () {
            return this.readOnlyValue != null ? this.readOnlyValue : false;
        },
        set: function (val) {
            this.readOnlyValue = val;
        },
        enumerable: false,
        configurable: true
    });
    JsonObjectProperty.prototype.isEnable = function (obj) {
        if (this.readOnly)
            return false;
        if (!obj || !this.enableIf)
            return true;
        return this.enableIf(this.getOriginalObj(obj));
    };
    JsonObjectProperty.prototype.isVisible = function (layout, obj) {
        if (obj === void 0) { obj = null; }
        var isLayout = !this.layout || !layout || this.layout === layout;
        if (!this.visible || !isLayout)
            return false;
        if (!!this.visibleIf && !!obj) {
            return this.visibleIf(this.getOriginalObj(obj));
        }
        return true;
    };
    JsonObjectProperty.prototype.getOriginalObj = function (obj) {
        if (obj && obj.getOriginalObj) {
            var orjObj = obj.getOriginalObj();
            if (orjObj && Serializer.findProperty(orjObj.getType(), this.name)) {
                return orjObj;
            }
        }
        return obj;
    };
    Object.defineProperty(JsonObjectProperty.prototype, "visible", {
        get: function () {
            return this.visibleValue != null ? this.visibleValue : true;
        },
        set: function (val) {
            this.visibleValue = val;
        },
        enumerable: false,
        configurable: true
    });
    JsonObjectProperty.prototype.isAvailableInVersion = function (ver) {
        if (!!this.alternativeName || this.oldName)
            return true;
        return this.isAvailableInVersionCore(ver);
    };
    JsonObjectProperty.prototype.getSerializedName = function (ver) {
        if (!this.alternativeName)
            return this.name;
        return this.isAvailableInVersionCore(ver) ? this.name : this.alternativeName || this.oldName;
    };
    JsonObjectProperty.prototype.getSerializedProperty = function (obj, ver) {
        if (!this.oldName || this.isAvailableInVersionCore(ver))
            return this;
        if (!obj || !obj.getType)
            return null;
        return Serializer.findProperty(obj.getType(), this.oldName);
    };
    JsonObjectProperty.prototype.isAvailableInVersionCore = function (ver) {
        if (!ver || !this.version)
            return true;
        return helpers_Helpers.compareVerions(this.version, ver) <= 0;
    };
    Object.defineProperty(JsonObjectProperty.prototype, "isLocalizable", {
        get: function () {
            return this.isLocalizableValue != null ? this.isLocalizableValue : false;
        },
        set: function (val) {
            this.isLocalizableValue = val;
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(JsonObjectProperty.prototype, "dataList", {
        get: function () {
            return Array.isArray(this.dataListValue) ? this.dataListValue : [];
        },
        set: function (val) {
            this.dataListValue = val;
        },
        enumerable: false,
        configurable: true
    });
    JsonObjectProperty.prototype.mergeWith = function (prop) {
        var valuesNames = JsonObjectProperty.mergableValues;
        for (var i = 0; i < valuesNames.length; i++) {
            this.mergeValue(prop, valuesNames[i]);
        }
    };
    JsonObjectProperty.prototype.addDependedProperty = function (name) {
        if (!this.dependedProperties) {
            this.dependedProperties = [];
        }
        if (this.dependedProperties.indexOf(name) < 0) {
            this.dependedProperties.push(name);
        }
    };
    JsonObjectProperty.prototype.getDependedProperties = function () {
        return !!this.dependedProperties ? this.dependedProperties : [];
    };
    JsonObjectProperty.prototype.schemaType = function () {
        if (this.className === "choicesByUrl")
            return undefined;
        if (this.className === "string")
            return this.className;
        if (!!this.className)
            return "array";
        if (!!this.baseClassName)
            return "array";
        if (this.type == "switch")
            return "boolean";
        if (this.type == "boolean" || this.type == "number")
            return this.type;
        return "string";
    };
    JsonObjectProperty.prototype.schemaRef = function () {
        if (!!this.className)
            return this.className;
        return undefined;
    };
    JsonObjectProperty.prototype.mergeValue = function (prop, valueName) {
        if (this[valueName] == null && prop[valueName] != null) {
            this[valueName] = prop[valueName];
        }
    };
    JsonObjectProperty.Index = 1;
    JsonObjectProperty.mergableValues = [
        "typeValue",
        "choicesValue",
        "baseValue",
        "readOnlyValue",
        "visibleValue",
        "isSerializable",
        "isLightSerializable",
        "isCustom",
        "isBindable",
        "isUnique",
        "uniquePropertyName",
        "isDynamicChoices",
        "isLocalizableValue",
        "className",
        "alternativeName",
        "oldName",
        "layout",
        "version",
        "classNamePart",
        "baseClassName",
        "defaultValue",
        "defaultValueFunc",
        "serializationProperty",
        "onGetValue",
        "onSetValue",
        "onSettingValue",
        "displayName",
        "category",
        "categoryIndex",
        "visibleIndex",
        "nextToProperty",
        "overridingProperty",
        "showMode",
        "dependedProperties",
        "visibleIf",
        "enableIf",
        "onExecuteExpression",
        "onPropertyEditorUpdate",
        "maxLength",
        "maxValue",
        "minValue",
        "dataListValue",
    ];
    return JsonObjectProperty;
}());

var CustomPropertiesCollection = /** @class */ (function () {
    function CustomPropertiesCollection() {
    }
    CustomPropertiesCollection.addProperty = function (className, property) {
        className = className.toLowerCase();
        var props = CustomPropertiesCollection.properties;
        if (!props[className]) {
            props[className] = [];
        }
        props[className].push(property);
    };
    CustomPropertiesCollection.removeProperty = function (className, propertyName) {
        className = className.toLowerCase();
        var props = CustomPropertiesCollection.properties;
        if (!props[className])
            return;
        var properties = props[className];
        for (var i = 0; i < properties.length; i++) {
            if (properties[i].name == propertyName) {
                props[className].splice(i, 1);
                break;
            }
        }
    };
    CustomPropertiesCollection.removeAllProperties = function (className) {
        className = className.toLowerCase();
        delete CustomPropertiesCollection.properties[className];
    };
    CustomPropertiesCollection.addClass = function (className, parentClassName) {
        className = className.toLowerCase();
        if (parentClassName) {
            parentClassName = parentClassName.toLowerCase();
        }
        CustomPropertiesCollection.parentClasses[className] = parentClassName;
    };
    CustomPropertiesCollection.getProperties = function (className) {
        className = className.toLowerCase();
        var res = [];
        var props = CustomPropertiesCollection.properties;
        while (className) {
            var properties = props[className];
            if (properties) {
                for (var i = 0; i < properties.length; i++) {
                    res.push(properties[i]);
                }
            }
            className = CustomPropertiesCollection.parentClasses[className];
        }
        return res;
    };
    CustomPropertiesCollection.createProperties = function (obj) {
        if (!obj || !obj.getType)
            return;
        CustomPropertiesCollection.createPropertiesCore(obj, obj.getType());
    };
    CustomPropertiesCollection.createPropertiesCore = function (obj, className) {
        var props = CustomPropertiesCollection.properties;
        if (props[className]) {
            CustomPropertiesCollection.createPropertiesInObj(obj, props[className]);
        }
        var parentClass = CustomPropertiesCollection.parentClasses[className];
        if (parentClass) {
            CustomPropertiesCollection.createPropertiesCore(obj, parentClass);
        }
    };
    CustomPropertiesCollection.createPropertiesInObj = function (obj, properties) {
        for (var i = 0; i < properties.length; i++) {
            CustomPropertiesCollection.createPropertyInObj(obj, properties[i]);
        }
    };
    CustomPropertiesCollection.createPropertyInObj = function (obj, prop) {
        if (CustomPropertiesCollection.checkIsPropertyExists(obj, prop.name))
            return;
        if (!!prop.serializationProperty && CustomPropertiesCollection.checkIsPropertyExists(obj, prop.serializationProperty))
            return;
        if (prop.isLocalizable &&
            prop.serializationProperty &&
            obj.createCustomLocalizableObj) {
            var locStr = obj.createCustomLocalizableObj(prop.name);
            locStr.defaultValue = prop.getDefaultValue(obj);
            var locDesc = {
                get: function () {
                    return obj.getLocalizableString(prop.name);
                },
            };
            Object.defineProperty(obj, prop.serializationProperty, locDesc);
            var desc = {
                get: function () {
                    return obj.getLocalizableStringText(prop.name);
                },
                set: function (v) {
                    obj.setLocalizableStringText(prop.name, v);
                },
            };
            Object.defineProperty(obj, prop.name, desc);
        }
        else {
            var isArrayProp = prop.isArray || prop.type === "multiplevalues";
            if (typeof obj.createNewArray === "function") {
                if (Serializer.isDescendantOf(prop.className, "itemvalue")) {
                    obj.createNewArray(prop.name, function (item) {
                        item.locOwner = obj;
                        item.ownerPropertyName = prop.name;
                    });
                    isArrayProp = true;
                }
                else {
                    //It is a simple array property
                    if (isArrayProp) {
                        obj.createNewArray(prop.name);
                    }
                }
                if (isArrayProp) {
                    var defaultValue = prop.getDefaultValue(obj);
                    if (Array.isArray(defaultValue)) {
                        obj.setPropertyValue(prop.name, defaultValue);
                    }
                }
            }
            if (!!obj.getPropertyValue && !!obj.setPropertyValue) {
                var desc = {
                    get: function () {
                        if (!!prop.onGetValue) {
                            return prop.onGetValue(obj);
                        }
                        return obj.getPropertyValue(prop.name, undefined);
                    },
                    set: function (v) {
                        if (!!prop.onSetValue) {
                            prop.onSetValue(obj, v, null);
                        }
                        else {
                            obj.setPropertyValue(prop.name, v);
                        }
                    },
                };
                Object.defineProperty(obj, prop.name, desc);
            }
        }
        if (prop.type === "condition" || prop.type === "expression") {
            if (!!prop.onExecuteExpression) {
                obj.addExpressionProperty(prop.name, prop.onExecuteExpression);
            }
        }
    };
    CustomPropertiesCollection.checkIsPropertyExists = function (obj, name) {
        return obj.hasOwnProperty(name) || obj[name];
    };
    CustomPropertiesCollection.properties = {};
    CustomPropertiesCollection.parentClasses = {};
    return CustomPropertiesCollection;
}());

var jsonobject_JsonMetadataClass = /** @class */ (function () {
    function JsonMetadataClass(name, properties, creator, parentName) {
        if (creator === void 0) { creator = null; }
        if (parentName === void 0) { parentName = null; }
        this.name = name;
        this.creator = creator;
        this.parentName = parentName;
        name = name.toLowerCase();
        this.isCustomValue = !creator && name !== "survey";
        if (this.parentName) {
            this.parentName = this.parentName.toLowerCase();
            CustomPropertiesCollection.addClass(name, this.parentName);
            if (!!creator) {
                this.makeParentRegularClass();
            }
        }
        this.properties = new Array();
        for (var i = 0; i < properties.length; i++) {
            this.createProperty(properties[i], this.isCustom);
        }
    }
    //Obsolete
    JsonMetadataClass.prototype.find = function (name) {
        for (var i = 0; i < this.properties.length; i++) {
            if (this.properties[i].name == name)
                return this.properties[i];
        }
        return null;
    };
    JsonMetadataClass.prototype.findProperty = function (name) {
        this.fillAllProperties();
        return this.hashProperties[name];
    };
    JsonMetadataClass.prototype.getAllProperties = function () {
        this.fillAllProperties();
        return this.allProperties;
    };
    JsonMetadataClass.prototype.getRequiredProperties = function () {
        if (!!this.requiredProperties)
            return this.requiredProperties;
        this.requiredProperties = [];
        var props = this.getAllProperties();
        for (var i = 0; i < props.length; i++) {
            if (props[i].isRequired)
                this.requiredProperties.push(props[i]);
        }
        return this.requiredProperties;
    };
    JsonMetadataClass.prototype.resetAllProperties = function () {
        this.allProperties = undefined;
        this.requiredProperties = undefined;
        this.hashProperties = undefined;
        var childClasses = Serializer.getChildrenClasses(this.name);
        for (var i = 0; i < childClasses.length; i++) {
            childClasses[i].resetAllProperties();
        }
    };
    Object.defineProperty(JsonMetadataClass.prototype, "isCustom", {
        get: function () { return this.isCustomValue; },
        enumerable: false,
        configurable: true
    });
    JsonMetadataClass.prototype.fillAllProperties = function () {
        var _this = this;
        if (!!this.allProperties)
            return;
        this.allProperties = [];
        this.hashProperties = {};
        var localProperties = {};
        this.properties.forEach(function (prop) { return localProperties[prop.name] = prop; });
        var parentClass = !!this.parentName ? Serializer.findClass(this.parentName) : null;
        if (!!parentClass) {
            var parentProperties = parentClass.getAllProperties();
            parentProperties.forEach(function (prop) {
                var overridedProp = localProperties[prop.name];
                if (!!overridedProp) {
                    overridedProp.mergeWith(prop);
                    _this.addPropCore(overridedProp);
                }
                else {
                    _this.addPropCore(prop);
                }
            });
        }
        this.properties.forEach(function (prop) {
            if (!_this.hashProperties[prop.name]) {
                _this.addPropCore(prop);
            }
        });
    };
    JsonMetadataClass.prototype.addPropCore = function (prop) {
        this.allProperties.push(prop);
        this.hashProperties[prop.name] = prop;
        if (!!prop.alternativeName) {
            this.hashProperties[prop.alternativeName] = prop;
        }
    };
    JsonMetadataClass.prototype.isOverridedProp = function (propName) {
        return !!this.parentName && !!Serializer.findProperty(this.parentName, propName);
    };
    JsonMetadataClass.prototype.hasRegularChildClass = function () {
        if (!this.isCustom)
            return;
        this.isCustomValue = false;
        for (var i = 0; i < this.properties.length; i++) {
            this.properties[i].isCustom = false;
        }
        CustomPropertiesCollection.removeAllProperties(this.name);
        this.makeParentRegularClass();
    };
    JsonMetadataClass.prototype.makeParentRegularClass = function () {
        if (!this.parentName)
            return;
        var parent = Serializer.findClass(this.parentName);
        if (!!parent) {
            parent.hasRegularChildClass();
        }
    };
    JsonMetadataClass.prototype.createProperty = function (propInfo, isCustom) {
        if (isCustom === void 0) { isCustom = false; }
        var propertyName = typeof propInfo === "string" ? propInfo : propInfo.name;
        if (!propertyName)
            return;
        var propertyType = null;
        var typeIndex = propertyName.indexOf(JsonMetadataClass.typeSymbol);
        if (typeIndex > -1) {
            propertyType = propertyName.substring(typeIndex + 1);
            propertyName = propertyName.substring(0, typeIndex);
        }
        var isRequired = this.getIsPropertyNameRequired(propertyName) || !!propInfo.isRequired;
        propertyName = this.getPropertyName(propertyName);
        var prop = new jsonobject_JsonObjectProperty(this, propertyName, isRequired);
        if (propertyType) {
            prop.type = propertyType;
        }
        if (typeof propInfo === "object") {
            if (propInfo.type) {
                prop.type = propInfo.type;
            }
            if (propInfo.default !== undefined) {
                prop.defaultValue = propInfo.default;
            }
            if (propInfo.defaultFunc !== undefined) {
                prop.defaultValueFunc = propInfo.defaultFunc;
            }
            if (!helpers_Helpers.isValueEmpty(propInfo.isSerializable)) {
                prop.isSerializable = propInfo.isSerializable;
            }
            if (!helpers_Helpers.isValueEmpty(propInfo.isLightSerializable)) {
                prop.isLightSerializable = propInfo.isLightSerializable;
            }
            if (!helpers_Helpers.isValueEmpty(propInfo.maxLength)) {
                prop.maxLength = propInfo.maxLength;
            }
            if (propInfo.displayName !== undefined) {
                prop.displayName = propInfo.displayName;
            }
            if (!helpers_Helpers.isValueEmpty(propInfo.category)) {
                prop.category = propInfo.category;
            }
            if (!helpers_Helpers.isValueEmpty(propInfo.categoryIndex)) {
                prop.categoryIndex = propInfo.categoryIndex;
            }
            if (!helpers_Helpers.isValueEmpty(propInfo.nextToProperty)) {
                prop.nextToProperty = propInfo.nextToProperty;
            }
            if (!helpers_Helpers.isValueEmpty(propInfo.overridingProperty)) {
                prop.overridingProperty = propInfo.overridingProperty;
            }
            if (!helpers_Helpers.isValueEmpty(propInfo.visibleIndex)) {
                prop.visibleIndex = propInfo.visibleIndex;
            }
            if (!helpers_Helpers.isValueEmpty(propInfo.showMode)) {
                prop.showMode = propInfo.showMode;
            }
            if (!helpers_Helpers.isValueEmpty(propInfo.maxValue)) {
                prop.maxValue = propInfo.maxValue;
            }
            if (!helpers_Helpers.isValueEmpty(propInfo.minValue)) {
                prop.minValue = propInfo.minValue;
            }
            if (!helpers_Helpers.isValueEmpty(propInfo.dataList)) {
                prop.dataList = propInfo.dataList;
            }
            if (!helpers_Helpers.isValueEmpty(propInfo.isDynamicChoices)) {
                prop.isDynamicChoices = propInfo.isDynamicChoices;
            }
            if (!helpers_Helpers.isValueEmpty(propInfo.isBindable)) {
                prop.isBindable = propInfo.isBindable;
            }
            if (!helpers_Helpers.isValueEmpty(propInfo.isUnique)) {
                prop.isUnique = propInfo.isUnique;
            }
            if (!helpers_Helpers.isValueEmpty(propInfo.uniqueProperty)) {
                prop.uniquePropertyName = propInfo.uniqueProperty;
            }
            if (!helpers_Helpers.isValueEmpty(propInfo.isArray)) {
                prop.isArray = propInfo.isArray;
            }
            if (propInfo.visible === true || propInfo.visible === false) {
                prop.visible = propInfo.visible;
            }
            if (!!propInfo.visibleIf) {
                prop.visibleIf = propInfo.visibleIf;
            }
            if (!!propInfo.enableIf) {
                prop.enableIf = propInfo.enableIf;
            }
            if (!!propInfo.onExecuteExpression) {
                prop.onExecuteExpression = propInfo.onExecuteExpression;
            }
            if (!!propInfo.onPropertyEditorUpdate) {
                prop.onPropertyEditorUpdate = propInfo.onPropertyEditorUpdate;
            }
            if (propInfo.readOnly === true) {
                prop.readOnly = true;
            }
            if (propInfo.availableInMatrixColumn === true) {
                prop.availableInMatrixColumn = true;
            }
            if (propInfo.choices) {
                var choicesFunc = typeof propInfo.choices === "function" ? propInfo.choices : null;
                var choicesValue = typeof propInfo.choices !== "function" ? propInfo.choices : null;
                prop.setChoices(choicesValue, choicesFunc);
            }
            if (!!propInfo.baseValue) {
                prop.setBaseValue(propInfo.baseValue);
            }
            if (propInfo.onSerializeValue) {
                prop.onSerializeValue = propInfo.onSerializeValue;
            }
            if (propInfo.onGetValue) {
                prop.onGetValue = propInfo.onGetValue;
            }
            if (propInfo.onSetValue) {
                prop.onSetValue = propInfo.onSetValue;
            }
            if (propInfo.onSettingValue) {
                prop.onSettingValue = propInfo.onSettingValue;
            }
            if (propInfo.isLocalizable) {
                propInfo.serializationProperty = "loc" + prop.name;
            }
            if (propInfo.serializationProperty) {
                prop.serializationProperty = propInfo.serializationProperty;
                var s;
                if (prop.serializationProperty &&
                    prop.serializationProperty.indexOf("loc") == 0) {
                    prop.isLocalizable = true;
                }
            }
            if (propInfo.isLocalizable) {
                prop.isLocalizable = propInfo.isLocalizable;
            }
            if (propInfo.className) {
                prop.className = propInfo.className;
            }
            if (propInfo.baseClassName) {
                prop.baseClassName = propInfo.baseClassName;
                prop.isArray = true;
            }
            if (prop.isArray === true) {
                prop.isArray = true;
            }
            if (propInfo.classNamePart) {
                prop.classNamePart = propInfo.classNamePart;
            }
            if (propInfo.alternativeName) {
                prop.alternativeName = propInfo.alternativeName;
            }
            if (propInfo.oldName) {
                prop.oldName = propInfo.oldName;
            }
            if (propInfo.layout) {
                prop.layout = propInfo.layout;
            }
            if (propInfo.version) {
                prop.version = propInfo.version;
            }
            if (propInfo.dependsOn) {
                this.addDependsOnProperties(prop, propInfo.dependsOn);
            }
        }
        this.properties.push(prop);
        if (isCustom && !this.isOverridedProp(prop.name)) {
            prop.isCustom = true;
            CustomPropertiesCollection.addProperty(this.name, prop);
        }
        return prop;
    };
    JsonMetadataClass.prototype.addDependsOnProperties = function (prop, dependsOn) {
        var dArray = Array.isArray(dependsOn) ? dependsOn : [dependsOn];
        prop.dependsOn = dArray;
        for (var i = 0; i < dArray.length; i++) {
            this.addDependsOnProperty(prop, dArray[i]);
        }
    };
    JsonMetadataClass.prototype.addDependsOnProperty = function (prop, dependsOn) {
        var property = this.find(dependsOn);
        if (!property) {
            property = Serializer.findProperty(this.parentName, dependsOn);
        }
        if (!property)
            return;
        property.addDependedProperty(prop.name);
    };
    JsonMetadataClass.prototype.getIsPropertyNameRequired = function (propertyName) {
        return (propertyName.length > 0 &&
            propertyName[0] == JsonMetadataClass.requiredSymbol);
    };
    JsonMetadataClass.prototype.getPropertyName = function (propertyName) {
        if (!this.getIsPropertyNameRequired(propertyName))
            return propertyName;
        propertyName = propertyName.slice(1);
        return propertyName;
    };
    JsonMetadataClass.requiredSymbol = "!";
    JsonMetadataClass.typeSymbol = ":";
    return JsonMetadataClass;
}());

/**
 * The metadata object. It contains object properties' runtime information and allows you to modify it.
 */
var JsonMetadata = /** @class */ (function () {
    function JsonMetadata() {
        this.classes = {};
        this.alternativeNames = {};
        this.childrenClasses = {};
        this.dynamicPropsCache = {};
    }
    JsonMetadata.prototype.getObjPropertyValue = function (obj, name) {
        if (this.isObjWrapper(obj) && this.isNeedUseObjWrapper(obj, name)) {
            var orignalObj = obj.getOriginalObj();
            var prop_1 = Serializer.findProperty(orignalObj.getType(), name);
            if (!!prop_1)
                return this.getObjPropertyValueCore(orignalObj, prop_1);
        }
        var prop = Serializer.findProperty(obj.getType(), name);
        if (!prop)
            return obj[name];
        return this.getObjPropertyValueCore(obj, prop);
    };
    JsonMetadata.prototype.setObjPropertyValue = function (obj, name, val) {
        if (obj[name] === val)
            return;
        if (!!obj[name] && !!obj[name].setJson) {
            obj[name].setJson(val, true);
        }
        else {
            if (Array.isArray(val)) {
                var newVal = [];
                for (var i = 0; i < val.length; i++)
                    newVal.push(val[i]);
                val = newVal;
            }
            obj[name] = val;
        }
    };
    JsonMetadata.prototype.getObjPropertyValueCore = function (obj, prop) {
        if (!prop.isSerializable)
            return obj[prop.name];
        if (prop.isLocalizable) {
            if (prop.isArray)
                return obj[prop.name];
            if (!!prop.serializationProperty)
                return obj[prop.serializationProperty].text;
        }
        return obj.getPropertyValue(prop.name);
    };
    JsonMetadata.prototype.isObjWrapper = function (obj) {
        return !!obj.getOriginalObj && !!obj.getOriginalObj();
    };
    JsonMetadata.prototype.isNeedUseObjWrapper = function (obj, name) {
        if (!obj.getDynamicProperties)
            return true;
        var props = obj.getDynamicProperties();
        if (!Array.isArray(props))
            return false;
        for (var i = 0; i < props.length; i++) {
            if (props[i].name === name)
                return true;
        }
        return false;
    };
    JsonMetadata.prototype.addClass = function (name, properties, creator, parentName) {
        if (creator === void 0) { creator = null; }
        if (parentName === void 0) { parentName = null; }
        name = name.toLowerCase();
        var metaDataClass = new jsonobject_JsonMetadataClass(name, properties, creator, parentName);
        this.classes[name] = metaDataClass;
        if (parentName) {
            parentName = parentName.toLowerCase();
            var children = this.childrenClasses[parentName];
            if (!children) {
                this.childrenClasses[parentName] = [];
            }
            this.childrenClasses[parentName].push(metaDataClass);
        }
        return metaDataClass;
    };
    JsonMetadata.prototype.removeClass = function (name) {
        var metaClass = this.findClass(name);
        if (!metaClass)
            return;
        delete this.classes[metaClass.name];
        if (!!metaClass.parentName) {
            var index = this.childrenClasses[metaClass.parentName].indexOf(metaClass);
            if (index > -1) {
                this.childrenClasses[metaClass.parentName].splice(index, 1);
            }
        }
    };
    JsonMetadata.prototype.overrideClassCreatore = function (name, creator) {
        this.overrideClassCreator(name, creator);
    };
    JsonMetadata.prototype.overrideClassCreator = function (name, creator) {
        name = name.toLowerCase();
        var metaDataClass = this.findClass(name);
        if (metaDataClass) {
            metaDataClass.creator = creator;
        }
    };
    JsonMetadata.prototype.getProperties = function (className) {
        var metaClass = this.findClass(className);
        if (!metaClass)
            return [];
        return metaClass.getAllProperties();
    };
    JsonMetadata.prototype.getPropertiesByObj = function (obj) {
        var type = !!obj && !!obj.getType ? obj.getType() : undefined;
        if (!type)
            return [];
        var props = this.getProperties(type);
        var dynamicProps = this.getDynamicPropertiesByObj(obj);
        for (var i = dynamicProps.length - 1; i >= 0; i--) {
            if (this.findProperty(type, dynamicProps[i].name)) {
                dynamicProps.splice(i, 1);
            }
        }
        if (dynamicProps.length === 0)
            return props;
        return [].concat(props).concat(dynamicProps);
    };
    JsonMetadata.prototype.addDynamicPropertiesIntoObj = function (dest, src, props) {
        var _this = this;
        props.forEach(function (prop) {
            _this.addDynamicPropertyIntoObj(dest, src, prop.name, false);
            if (prop.serializationProperty) {
                _this.addDynamicPropertyIntoObj(dest, src, prop.serializationProperty, true);
            }
            if (prop.alternativeName) {
                _this.addDynamicPropertyIntoObj(dest, src, prop.alternativeName, false);
            }
        });
    };
    JsonMetadata.prototype.addDynamicPropertyIntoObj = function (dest, src, propName, isReadOnly) {
        var desc = {
            configurable: true,
            get: function () {
                return src[propName];
            },
        };
        if (!isReadOnly) {
            desc["set"] = function (v) {
                src[propName] = v;
            };
        }
        Object.defineProperty(dest, propName, desc);
    };
    JsonMetadata.prototype.getDynamicPropertiesByObj = function (obj, dynamicType) {
        if (dynamicType === void 0) { dynamicType = null; }
        if (!obj || !obj.getType)
            return [];
        if (!!obj.getDynamicProperties)
            return obj.getDynamicProperties();
        if (!obj.getDynamicType && !dynamicType)
            return [];
        var dType = !!dynamicType ? dynamicType : obj.getDynamicType();
        return this.getDynamicPropertiesByTypes(obj.getType(), dType);
    };
    JsonMetadata.prototype.getDynamicPropertiesByTypes = function (objType, dynamicType, invalidNames) {
        if (!dynamicType)
            return [];
        var cacheType = dynamicType + "-" + objType;
        if (this.dynamicPropsCache[cacheType])
            return this.dynamicPropsCache[cacheType];
        var dynamicProps = this.getProperties(dynamicType);
        if (!dynamicProps || dynamicProps.length == 0)
            return [];
        var hash = {};
        var props = this.getProperties(objType);
        for (var i = 0; i < props.length; i++) {
            hash[props[i].name] = props[i];
        }
        var res = [];
        if (!invalidNames)
            invalidNames = [];
        for (var i_1 = 0; i_1 < dynamicProps.length; i_1++) {
            var dProp = dynamicProps[i_1];
            if (invalidNames.indexOf(dProp.name) < 0 && this.canAddDybamicProp(dProp, hash[dProp.name])) {
                res.push(dProp);
            }
        }
        this.dynamicPropsCache[cacheType] = res;
        return res;
    };
    JsonMetadata.prototype.canAddDybamicProp = function (dProp, orgProp) {
        if (!orgProp)
            return true;
        if (dProp === orgProp)
            return false;
        var classInfo = dProp.classInfo;
        while (classInfo && classInfo.parentName) {
            dProp = this.findProperty(classInfo.parentName, dProp.name);
            if (dProp && dProp === orgProp)
                return true;
            classInfo = !!dProp ? dProp.classInfo : undefined;
        }
        return false;
    };
    JsonMetadata.prototype.hasOriginalProperty = function (obj, propName) {
        return !!this.getOriginalProperty(obj, propName);
    };
    JsonMetadata.prototype.getOriginalProperty = function (obj, propName) {
        var res = this.findProperty(obj.getType(), propName);
        if (!!res)
            return res;
        if (this.isObjWrapper(obj))
            return this.findProperty(obj.getOriginalObj().getType(), propName);
        return null;
    };
    JsonMetadata.prototype.getProperty = function (className, propertyName) {
        var prop = this.findProperty(className, propertyName);
        if (!prop)
            return prop;
        var classInfo = this.findClass(className);
        if (prop.classInfo === classInfo)
            return prop;
        var newProp = new jsonobject_JsonObjectProperty(classInfo, prop.name, prop.isRequired);
        newProp.mergeWith(prop);
        newProp.isArray = prop.isArray;
        classInfo.properties.push(newProp);
        classInfo.resetAllProperties();
        return newProp;
    };
    JsonMetadata.prototype.findProperty = function (className, propertyName) {
        var cl = this.findClass(className);
        return !!cl ? cl.findProperty(propertyName) : null;
    };
    JsonMetadata.prototype.findProperties = function (className, propertyNames) {
        var result = new Array();
        var cl = this.findClass(className);
        if (!cl)
            return result;
        for (var i = 0; i < propertyNames.length; i++) {
            var prop = cl.findProperty(propertyNames[i]);
            if (prop) {
                result.push(prop);
            }
        }
        return result;
    };
    JsonMetadata.prototype.getAllPropertiesByName = function (propertyName) {
        var res = new Array();
        var classes = this.getAllClasses();
        for (var i = 0; i < classes.length; i++) {
            var classInfo = this.findClass(classes[i]);
            for (var j = 0; j < classInfo.properties.length; j++) {
                if (classInfo.properties[j].name == propertyName) {
                    res.push(classInfo.properties[j]);
                    break;
                }
            }
        }
        return res;
    };
    JsonMetadata.prototype.getAllClasses = function () {
        var res = new Array();
        for (var name in this.classes) {
            res.push(name);
        }
        return res;
    };
    JsonMetadata.prototype.createClass = function (name, json) {
        if (json === void 0) { json = undefined; }
        name = name.toLowerCase();
        var metaDataClass = this.findClass(name);
        if (!metaDataClass)
            return null;
        if (metaDataClass.creator)
            return metaDataClass.creator(json);
        var parentName = metaDataClass.parentName;
        while (parentName) {
            metaDataClass = this.findClass(parentName);
            if (!metaDataClass)
                return null;
            parentName = metaDataClass.parentName;
            if (metaDataClass.creator)
                return this.createCustomType(name, metaDataClass.creator, json);
        }
        return null;
    };
    JsonMetadata.prototype.createCustomType = function (name, creator, json) {
        if (json === void 0) { json = undefined; }
        name = name.toLowerCase();
        var res = creator(json);
        var customTypeName = name;
        var customTemplateName = res.getTemplate
            ? res.getTemplate()
            : res.getType();
        res.getType = function () {
            return customTypeName;
        };
        res.getTemplate = function () {
            return customTemplateName;
        };
        CustomPropertiesCollection.createProperties(res);
        return res;
    };
    JsonMetadata.prototype.getChildrenClasses = function (name, canBeCreated) {
        if (canBeCreated === void 0) { canBeCreated = false; }
        name = name.toLowerCase();
        var result = [];
        this.fillChildrenClasses(name, canBeCreated, result);
        return result;
    };
    JsonMetadata.prototype.getRequiredProperties = function (name) {
        var metaClass = this.findClass(name);
        if (!metaClass)
            return [];
        var props = metaClass.getRequiredProperties();
        var res = [];
        for (var i = 0; i < props.length; i++) {
            res.push(props[i].name);
        }
        return res;
    };
    JsonMetadata.prototype.addProperties = function (className, propertiesInfos) {
        className = className.toLowerCase();
        var metaDataClass = this.findClass(className);
        for (var i = 0; i < propertiesInfos.length; i++) {
            this.addCustomPropertyCore(metaDataClass, propertiesInfos[i]);
        }
    };
    JsonMetadata.prototype.addProperty = function (className, propertyInfo) {
        return this.addCustomPropertyCore(this.findClass(className), propertyInfo);
    };
    JsonMetadata.prototype.addCustomPropertyCore = function (metaDataClass, propertyInfo) {
        if (!metaDataClass)
            return null;
        var property = metaDataClass.createProperty(propertyInfo, true);
        if (property) {
            this.clearDynamicPropsCache(metaDataClass);
            metaDataClass.resetAllProperties();
        }
        return property;
    };
    JsonMetadata.prototype.removeProperty = function (className, propertyName) {
        var metaDataClass = this.findClass(className);
        if (!metaDataClass)
            return false;
        var property = metaDataClass.find(propertyName);
        if (property) {
            this.clearDynamicPropsCache(metaDataClass);
            this.removePropertyFromClass(metaDataClass, property);
            metaDataClass.resetAllProperties();
            CustomPropertiesCollection.removeProperty(metaDataClass.name, propertyName);
        }
    };
    JsonMetadata.prototype.clearDynamicPropsCache = function (metaDataClass) {
        this.dynamicPropsCache = {};
    };
    JsonMetadata.prototype.removePropertyFromClass = function (metaDataClass, property) {
        var index = metaDataClass.properties.indexOf(property);
        if (index < 0)
            return;
        metaDataClass.properties.splice(index, 1);
    };
    JsonMetadata.prototype.fillChildrenClasses = function (name, canBeCreated, result) {
        var children = this.childrenClasses[name];
        if (!children)
            return;
        for (var i = 0; i < children.length; i++) {
            if (!canBeCreated || children[i].creator) {
                result.push(children[i]);
            }
            this.fillChildrenClasses(children[i].name, canBeCreated, result);
        }
    };
    JsonMetadata.prototype.findClass = function (name) {
        name = name.toLowerCase();
        var res = this.classes[name];
        if (!res) {
            var newName = this.alternativeNames[name];
            if (!!newName && newName != name)
                return this.findClass(newName);
        }
        return res;
    };
    JsonMetadata.prototype.isDescendantOf = function (className, ancestorClassName) {
        if (!className || !ancestorClassName) {
            return false;
        }
        className = className.toLowerCase();
        ancestorClassName = ancestorClassName.toLowerCase();
        var class_ = this.findClass(className);
        if (!class_) {
            return false;
        }
        var parentClass = class_;
        do {
            if (parentClass.name === ancestorClassName) {
                return true;
            }
            parentClass = this.classes[parentClass.parentName];
        } while (!!parentClass);
        return false;
    };
    JsonMetadata.prototype.addAlterNativeClassName = function (name, alternativeName) {
        this.alternativeNames[alternativeName.toLowerCase()] = name.toLowerCase();
    };
    JsonMetadata.prototype.generateSchema = function (className) {
        if (className === void 0) { className = undefined; }
        if (!className)
            className = "survey";
        var classInfo = this.findClass(className);
        if (!classInfo)
            return null;
        var res = {
            $schema: "http://json-schema.org/draft-07/schema#",
            title: "SurveyJS Library json schema",
            type: "object",
            properties: {},
            definitions: { locstring: this.generateLocStrClass() },
        };
        this.generateSchemaProperties(classInfo, res, res.definitions, true);
        return res;
    };
    JsonMetadata.prototype.generateLocStrClass = function () {
        var props = {};
        var locProp = Serializer.findProperty("survey", "locale");
        if (!!locProp) {
            var choices = locProp.getChoices(null);
            if (Array.isArray(choices)) {
                if (choices.indexOf("en") < 0) {
                    choices.splice(0, 0, "en");
                }
                choices.splice(0, 0, "default");
                choices.forEach(function (l) { if (!!l) {
                    props[l] = { type: "string" };
                } });
            }
        }
        return {
            $id: "locstring",
            type: "object",
            properties: props
        };
    };
    JsonMetadata.prototype.generateSchemaProperties = function (classInfo, classSchema, schemaDef, isRoot) {
        if (!classInfo)
            return;
        var schemaProperties = classSchema.properties;
        var requiredProps = [];
        if (classInfo.name === "question" || classInfo.name === "panel") {
            schemaProperties.type = { type: "string" };
            requiredProps.push("type");
        }
        for (var i = 0; i < classInfo.properties.length; i++) {
            var prop = classInfo.properties[i];
            if (!!classInfo.parentName && !!Serializer.findProperty(classInfo.parentName, prop.name))
                continue;
            schemaProperties[prop.name] = this.generateSchemaProperty(prop, schemaDef, isRoot);
            if (prop.isRequired)
                requiredProps.push(prop.name);
        }
        if (requiredProps.length > 0) {
            classSchema.required = requiredProps;
        }
    };
    JsonMetadata.prototype.generateSchemaProperty = function (prop, schemaDef, isRoot) {
        if (prop.isLocalizable) {
            return {
                oneOf: [
                    { "type": "string" },
                    { "$ref": this.getChemeRefName("locstring", isRoot) }
                ]
            };
        }
        var propType = prop.schemaType();
        var refType = prop.schemaRef();
        var res = {};
        if (!!propType) {
            res.type = propType;
        }
        if (prop.hasChoices) {
            var enumRes = prop.getChoices(null);
            if (Array.isArray(enumRes) && enumRes.length > 0) {
                res.enum = this.getChoicesValues(enumRes);
            }
        }
        if (!!refType) {
            if (propType === "array") {
                if (prop.className === "string") {
                    res.items = { type: prop.className };
                }
                else {
                    res.items = { $ref: this.getChemeRefName(prop.className, isRoot) };
                }
            }
            else {
                res["$ref"] = this.getChemeRefName(refType, isRoot);
            }
            this.generateChemaClass(prop.className, schemaDef, false);
        }
        if (!!prop.baseClassName) {
            var usedClasses = this.getChildrenClasses(prop.baseClassName, true);
            if (prop.baseClassName == "question") {
                usedClasses.push(this.findClass("panel"));
            }
            res.items = { anyOf: [] };
            for (var i = 0; i < usedClasses.length; i++) {
                var className = usedClasses[i].name;
                res.items.anyOf.push({ $ref: this.getChemeRefName(className, isRoot) });
                this.generateChemaClass(className, schemaDef, false);
            }
        }
        return res;
    };
    JsonMetadata.prototype.getChemeRefName = function (className, isRoot) {
        //Fix for #6486, according to https://niem.github.io/json/reference/json-schema/references/#:~:text=In%20a%20JSON%20schema%2C%20a,%2C%20an%20in%2Dschema%20reference
        //Checked by https://www.jsonschemavalidator.net/
        return isRoot ? "#/definitions/" + className : className;
    };
    JsonMetadata.prototype.generateChemaClass = function (className, schemaDef, isRoot) {
        if (!!schemaDef[className])
            return;
        var classInfo = this.findClass(className);
        if (!classInfo)
            return;
        var hasParent = !!classInfo.parentName && classInfo.parentName != "base";
        if (hasParent) {
            this.generateChemaClass(classInfo.parentName, schemaDef, isRoot);
        }
        var res = { type: "object", $id: className };
        schemaDef[className] = res;
        var chemaProps = { properties: {} };
        this.generateSchemaProperties(classInfo, chemaProps, schemaDef, isRoot);
        if (hasParent) {
            res.allOf = [
                { $ref: this.getChemeRefName(classInfo.parentName, isRoot) },
                { properties: chemaProps.properties },
            ];
        }
        else {
            res.properties = chemaProps.properties;
        }
        if (Array.isArray(chemaProps.required)) {
            res.required = chemaProps.required;
        }
    };
    JsonMetadata.prototype.getChoicesValues = function (enumRes) {
        var res = new Array();
        enumRes.forEach(function (item) {
            if (typeof item === "object" && item.value !== undefined) {
                res.push(item.value);
            }
            else {
                res.push(item);
            }
        });
        return res;
    };
    return JsonMetadata;
}());

var JsonError = /** @class */ (function () {
    function JsonError(type, message) {
        this.type = type;
        this.message = message;
        this.description = "";
        this.at = -1;
        this.end = -1;
    }
    JsonError.prototype.getFullDescription = function () {
        return this.message + (this.description ? "\n" + this.description : "");
    };
    return JsonError;
}());

var JsonUnknownPropertyError = /** @class */ (function (_super) {
    __extends(JsonUnknownPropertyError, _super);
    function JsonUnknownPropertyError(propertyName, className) {
        var _this = _super.call(this, "unknownproperty", "Unknown property in class '" + className + "': '" + propertyName + "'.") || this;
        _this.propertyName = propertyName;
        _this.className = className;
        return _this;
    }
    return JsonUnknownPropertyError;
}(JsonError));

var JsonMissingTypeErrorBase = /** @class */ (function (_super) {
    __extends(JsonMissingTypeErrorBase, _super);
    function JsonMissingTypeErrorBase(baseClassName, type, message) {
        var _this = _super.call(this, type, message) || this;
        _this.baseClassName = baseClassName;
        _this.type = type;
        _this.message = message;
        return _this;
    }
    return JsonMissingTypeErrorBase;
}(JsonError));

var JsonMissingTypeError = /** @class */ (function (_super) {
    __extends(JsonMissingTypeError, _super);
    function JsonMissingTypeError(propertyName, baseClassName) {
        var _this = _super.call(this, baseClassName, "missingtypeproperty", "The property type is missing in the object. Please take a look at property: '" +
            propertyName +
            "'.") || this;
        _this.propertyName = propertyName;
        _this.baseClassName = baseClassName;
        return _this;
    }
    return JsonMissingTypeError;
}(JsonMissingTypeErrorBase));

var JsonIncorrectTypeError = /** @class */ (function (_super) {
    __extends(JsonIncorrectTypeError, _super);
    function JsonIncorrectTypeError(propertyName, baseClassName) {
        var _this = _super.call(this, baseClassName, "incorrecttypeproperty", "The property type is incorrect in the object. Please take a look at property: '" +
            propertyName +
            "'.") || this;
        _this.propertyName = propertyName;
        _this.baseClassName = baseClassName;
        return _this;
    }
    return JsonIncorrectTypeError;
}(JsonMissingTypeErrorBase));

var JsonRequiredPropertyError = /** @class */ (function (_super) {
    __extends(JsonRequiredPropertyError, _super);
    function JsonRequiredPropertyError(propertyName, className) {
        var _this = _super.call(this, "requiredproperty", "The property '" +
            propertyName +
            "' is required in class '" +
            className +
            "'.") || this;
        _this.propertyName = propertyName;
        _this.className = className;
        return _this;
    }
    return JsonRequiredPropertyError;
}(JsonError));

var JsonRequiredArrayPropertyError = /** @class */ (function (_super) {
    __extends(JsonRequiredArrayPropertyError, _super);
    function JsonRequiredArrayPropertyError(propertyName, className) {
        var _this = _super.call(this, "arrayproperty", "The property '" + propertyName + "' should be an array in '" + className + "'.") || this;
        _this.propertyName = propertyName;
        _this.className = className;
        return _this;
    }
    return JsonRequiredArrayPropertyError;
}(JsonError));

var JsonIncorrectPropertyValueError = /** @class */ (function (_super) {
    __extends(JsonIncorrectPropertyValueError, _super);
    function JsonIncorrectPropertyValueError(property, value) {
        var _this = _super.call(this, "incorrectvalue", "The property value: '" + value + "' is incorrect for property '" + property.name + "'.") || this;
        _this.property = property;
        _this.value = value;
        return _this;
    }
    return JsonIncorrectPropertyValueError;
}(JsonError));

var jsonobject_JsonObject = /** @class */ (function () {
    function JsonObject() {
        this.errors = new Array();
        this.lightSerializing = false;
    }
    Object.defineProperty(JsonObject, "metaData", {
        get: function () {
            return JsonObject.metaDataValue;
        },
        enumerable: false,
        configurable: true
    });
    JsonObject.prototype.toJsonObject = function (obj, options) {
        return this.toJsonObjectCore(obj, null, options);
    };
    JsonObject.prototype.toObject = function (jsonObj, obj, options) {
        this.toObjectCore(jsonObj, obj, options);
        var error = this.getRequiredError(obj, jsonObj);
        if (!!error) {
            this.addNewError(error, jsonObj, obj);
        }
    };
    JsonObject.prototype.toObjectCore = function (jsonObj, obj, options) {
        if (!jsonObj)
            return;
        var properties = null;
        var objType = undefined;
        var needAddErrors = true;
        if (obj.getType) {
            objType = obj.getType();
            properties = Serializer.getProperties(objType);
            needAddErrors =
                !!objType && !Serializer.isDescendantOf(objType, "itemvalue");
        }
        if (!properties)
            return;
        if (obj.startLoadingFromJson) {
            obj.startLoadingFromJson(jsonObj);
        }
        properties = this.addDynamicProperties(obj, jsonObj, properties);
        this.options = options;
        var processedProps = {};
        processedProps[JsonObject.typePropertyName] = true;
        var parentProps = {};
        for (var key in jsonObj) {
            this.setPropertyValueToObj(jsonObj, obj, key, properties, processedProps, parentProps, objType, needAddErrors, options);
        }
        this.options = undefined;
        if (obj.endLoadingFromJson) {
            obj.endLoadingFromJson();
        }
    };
    JsonObject.prototype.setPropertyValueToObj = function (jsonObj, obj, key, properties, processedProps, parentProps, objType, needAddErrors, options) {
        var _this = this;
        if (processedProps[key])
            return;
        if (key === JsonObject.positionPropertyName) {
            obj[key] = jsonObj[key];
            return;
        }
        var property = this.findProperty(properties, key);
        if (!property && needAddErrors) {
            this.addNewError(new JsonUnknownPropertyError(key.toString(), objType), jsonObj, obj);
        }
        if (property) {
            var dProps = property.dependsOn;
            if (Array.isArray(dProps)) {
                parentProps[key] = true;
                dProps.forEach(function (propKey) {
                    if (!parentProps[propKey]) {
                        _this.setPropertyValueToObj(jsonObj, obj, propKey, properties, processedProps, parentProps, objType, false, options);
                    }
                });
            }
            this.valueToObj(jsonObj[key], obj, property, jsonObj, options);
            processedProps[key] = true;
        }
    };
    JsonObject.prototype.toJsonObjectCore = function (obj, property, options) {
        if (!obj || !obj.getType)
            return obj;
        if (!obj.isSurvey && typeof obj.getData === "function")
            return obj.getData();
        var result = {};
        if (property != null && !property.className) {
            result[JsonObject.typePropertyName] = property.getObjType(obj.getType());
        }
        var storeDefaults = options === true;
        if (!options || options === true) {
            options = {};
        }
        if (storeDefaults) {
            options.storeDefaults = storeDefaults;
        }
        this.propertiesToJson(obj, Serializer.getProperties(obj.getType()), result, options);
        this.propertiesToJson(obj, this.getDynamicProperties(obj), result, options);
        return result;
    };
    JsonObject.prototype.getDynamicProperties = function (obj) {
        return Serializer.getDynamicPropertiesByObj(obj);
    };
    JsonObject.prototype.addDynamicProperties = function (obj, jsonObj, props) {
        if (!obj.getDynamicPropertyName && !obj.getDynamicProperties)
            return props;
        if (obj.getDynamicPropertyName) {
            var dynamicPropName = obj.getDynamicPropertyName();
            if (!dynamicPropName)
                return props;
            if (dynamicPropName && jsonObj[dynamicPropName]) {
                obj[dynamicPropName] = jsonObj[dynamicPropName];
            }
        }
        var dynamicProps = this.getDynamicProperties(obj);
        return dynamicProps.length === 0 ? props : [].concat(props).concat(dynamicProps);
    };
    JsonObject.prototype.propertiesToJson = function (obj, properties, json, options) {
        for (var i = 0; i < properties.length; i++) {
            this.valueToJson(obj, json, properties[i], options);
        }
    };
    JsonObject.prototype.valueToJson = function (obj, result, prop, options) {
        if (!options)
            options = {};
        if (prop.isSerializable === false || (prop.isLightSerializable === false && this.lightSerializing))
            return;
        if (options.version && !prop.isAvailableInVersion(options.version))
            return;
        this.valueToJsonCore(obj, result, prop, options);
    };
    JsonObject.prototype.valueToJsonCore = function (obj, result, prop, options) {
        var serProp = prop.getSerializedProperty(obj, options.version);
        if (serProp && serProp !== prop) {
            this.valueToJsonCore(obj, result, serProp, options);
            return;
        }
        var value = prop.getSerializableValue(obj, options.storeDefaults);
        if (value === undefined)
            return;
        if (this.isValueArray(value)) {
            var arrValue = [];
            for (var i = 0; i < value.length; i++) {
                arrValue.push(this.toJsonObjectCore(value[i], prop, options));
            }
            value = arrValue.length > 0 ? arrValue : null;
        }
        else {
            value = this.toJsonObjectCore(value, prop, options);
        }
        if (value === undefined || value === null)
            return;
        var name = prop.getSerializedName(options.version);
        var hasValue = typeof obj["getPropertyValue"] === "function" &&
            obj["getPropertyValue"](name, null) !== null;
        if ((options.storeDefaults && hasValue) || !prop.isDefaultValueByObj(obj, value)) {
            if (!Serializer.onSerializingProperty || !Serializer.onSerializingProperty(obj, prop, value, result)) {
                result[name] = this.removePosOnValueToJson(prop, value);
            }
        }
    };
    JsonObject.prototype.valueToObj = function (value, obj, property, jsonObj, options) {
        if (value === null || value === undefined)
            return;
        this.removePos(property, value);
        if (property != null && property.hasToUseSetValue) {
            property.setValue(obj, value, this);
            return;
        }
        if (property.isArray && !Array.isArray(value) && !!value) {
            value = [value];
            var propName = !!jsonObj && property.alternativeName && !!jsonObj[property.alternativeName] ? property.alternativeName : property.name;
            this.addNewError(new JsonRequiredArrayPropertyError(propName, obj.getType()), !!jsonObj ? jsonObj : value, obj);
        }
        if (this.isValueArray(value)) {
            this.valueToArray(value, obj, property.name, property, options);
            return;
        }
        var newObj = this.createNewObj(value, property);
        if (newObj.newObj) {
            this.toObjectCore(value, newObj.newObj, options);
            value = newObj.newObj;
        }
        if (!newObj.error) {
            if (property != null) {
                property.setValue(obj, value, this);
                if (!!options && options.validatePropertyValues) {
                    if (!property.validateValue(value)) {
                        this.addNewError(new JsonIncorrectPropertyValueError(property, value), jsonObj, obj);
                    }
                }
            }
            else {
                obj[property.name] = value;
            }
        }
    };
    JsonObject.prototype.removePosOnValueToJson = function (property, value) {
        if (!property.isCustom || !value)
            return value;
        this.removePosFromObj(value);
        return value;
    };
    JsonObject.prototype.removePos = function (property, value) {
        if (!property || !property.type || property.type.indexOf("value") < 0)
            return;
        this.removePosFromObj(value);
    };
    JsonObject.prototype.removePosFromObj = function (obj) {
        if (!obj || typeof obj.getType === "function")
            return;
        if (Array.isArray(obj)) {
            for (var i = 0; i < obj.length; i++) {
                this.removePosFromObj(obj[i]);
            }
        }
        if (typeof obj !== "object")
            return;
        if (!!obj[JsonObject.positionPropertyName]) {
            delete obj[JsonObject.positionPropertyName];
        }
        for (var key in obj) {
            this.removePosFromObj(obj[key]);
        }
    };
    JsonObject.prototype.isValueArray = function (value) {
        return value && Array.isArray(value);
    };
    JsonObject.prototype.createNewObj = function (value, property) {
        var result = { newObj: null, error: null };
        var className = this.getClassNameForNewObj(value, property);
        result.newObj = className
            ? Serializer.createClass(className, value)
            : null;
        result.error = this.checkNewObjectOnErrors(result.newObj, value, property, className);
        return result;
    };
    JsonObject.prototype.getClassNameForNewObj = function (value, property) {
        var res = property != null && property.className ? property.className : undefined;
        if (!res) {
            res = value[JsonObject.typePropertyName];
        }
        if (!res)
            return res;
        res = res.toLowerCase();
        var classNamePart = property.classNamePart;
        if (classNamePart && res.indexOf(classNamePart) < 0) {
            res += classNamePart;
        }
        return res;
    };
    JsonObject.prototype.checkNewObjectOnErrors = function (newObj, value, property, className) {
        var error = null;
        if (newObj) {
            error = this.getRequiredError(newObj, value);
        }
        else {
            if (property.baseClassName) {
                if (!className) {
                    error = new JsonMissingTypeError(property.name, property.baseClassName);
                }
                else {
                    error = new JsonIncorrectTypeError(property.name, property.baseClassName);
                }
            }
        }
        if (error) {
            this.addNewError(error, value, newObj);
        }
        return error;
    };
    JsonObject.prototype.getRequiredError = function (obj, jsonValue) {
        if (!obj.getType || typeof obj.getData === "function")
            return null;
        var metaClass = Serializer.findClass(obj.getType());
        if (!metaClass)
            return null;
        var props = metaClass.getRequiredProperties();
        if (!Array.isArray(props))
            return null;
        for (var i = 0; i < props.length; i++) {
            var prop = props[i];
            if (!helpers_Helpers.isValueEmpty(prop.defaultValue))
                continue;
            if (!jsonValue[prop.name]) {
                return new JsonRequiredPropertyError(prop.name, obj.getType());
            }
        }
        return null;
    };
    JsonObject.prototype.addNewError = function (error, jsonObj, element) {
        error.jsonObj = jsonObj;
        error.element = element;
        this.errors.push(error);
        if (!jsonObj)
            return;
        var posObj = jsonObj[JsonObject.positionPropertyName];
        if (!posObj)
            return;
        error.at = posObj.start;
        error.end = posObj.end;
    };
    JsonObject.prototype.valueToArray = function (value, obj, key, property, options) {
        if (obj[key] && !this.isValueArray(obj[key]))
            return;
        if (obj[key] && value.length > 0)
            obj[key].splice(0, obj[key].length);
        var valueRes = obj[key] ? obj[key] : [];
        this.addValuesIntoArray(value, valueRes, property, options);
        if (!obj[key])
            obj[key] = valueRes;
    };
    JsonObject.prototype.addValuesIntoArray = function (value, result, property, options) {
        for (var i = 0; i < value.length; i++) {
            var newValue = this.createNewObj(value[i], property);
            if (newValue.newObj) {
                if (!!value[i].name) {
                    newValue.newObj.name = value[i].name;
                }
                if (!!value[i].valueName) {
                    newValue.newObj.valueName = value[i].valueName.toString();
                }
                result.push(newValue.newObj);
                this.toObjectCore(value[i], newValue.newObj, options);
            }
            else {
                if (!newValue.error) {
                    result.push(value[i]);
                }
            }
        }
    };
    JsonObject.prototype.findProperty = function (properties, key) {
        if (!properties)
            return null;
        for (var i = 0; i < properties.length; i++) {
            var prop = properties[i];
            if (prop.name == key || prop.alternativeName == key)
                return prop;
        }
        return null;
    };
    JsonObject.typePropertyName = "type";
    JsonObject.positionPropertyName = "pos";
    JsonObject.metaDataValue = new JsonMetadata();
    return JsonObject;
}());

/**
 * An alias for the metadata object. It contains object properties' runtime information and allows you to modify it.
 * @see JsonMetadata
 */
var Serializer = jsonobject_JsonObject.metaData;

// CONCATENATED MODULE: ./packages/survey-core/src/conditionProcessValue.ts

var surveyBuiltInVarible = "@survey";
var conditionProcessValue_ProcessValue = /** @class */ (function () {
    function ProcessValue() {
        this.values = null;
        this.properties = null;
        this.asyncValues = {};
    }
    ProcessValue.prototype.getFirstName = function (text, obj) {
        if (obj === void 0) { obj = null; }
        if (!text)
            return text;
        var res = "";
        if (!!obj) {
            res = this.getFirstPropertyName(text, obj);
            if (!!res)
                return res;
        }
        for (var i = 0; i < text.length; i++) {
            var ch = text[i];
            if (ch == "." || ch == "[")
                break;
            res += ch;
        }
        return res;
    };
    ProcessValue.prototype.hasValue = function (text, values) {
        if (values === void 0) { values = null; }
        if (!values)
            values = this.values;
        var res = this.getValueCore(text, values);
        return res.hasValue;
    };
    ProcessValue.prototype.getValue = function (text, values) {
        if (values === void 0) { values = null; }
        if (!values)
            values = this.values;
        var res = this.getValueCore(text, values);
        return res.value;
    };
    ProcessValue.prototype.setValue = function (obj, text, value) {
        if (!text)
            return;
        var nonNestedObj = this.getNonNestedObject(obj, text, true);
        if (!nonNestedObj)
            return;
        obj = nonNestedObj.value;
        text = nonNestedObj.text;
        if (!!obj && !!text) {
            obj[text] = value;
        }
    };
    ProcessValue.prototype.getValueInfo = function (valueInfo) {
        if (!!valueInfo.path) {
            valueInfo.value = this.getValueFromPath(valueInfo.path, this.values);
            valueInfo.hasValue =
                valueInfo.value !== null && !helpers_Helpers.isValueEmpty(valueInfo.value);
            if (!valueInfo.hasValue &&
                valueInfo.path.length > 1 &&
                valueInfo.path[valueInfo.path.length - 1] == "length") {
                valueInfo.hasValue = true;
                valueInfo.value = 0;
            }
            return;
        }
        var res = this.getValueCore(valueInfo.name, this.values);
        valueInfo.value = res.value;
        valueInfo.hasValue = res.hasValue;
        valueInfo.path = res.hasValue ? res.path : null;
        valueInfo.sctrictCompare = res.sctrictCompare;
    };
    ProcessValue.prototype.isAnyKeyChanged = function (keys, usedNames) {
        for (var i = 0; i < usedNames.length; i++) {
            var name_1 = usedNames[i];
            if (!name_1)
                continue;
            var lowerName = name_1.toLowerCase();
            if (keys.hasOwnProperty(name_1))
                return true;
            if (name_1 !== lowerName && keys.hasOwnProperty(lowerName))
                return true;
            var firstName = this.getFirstName(name_1);
            if (!keys.hasOwnProperty(firstName))
                continue;
            if (name_1 === firstName)
                return true;
            var keyValue = keys[firstName];
            if (keyValue == undefined)
                continue;
            if (!keyValue.hasOwnProperty("oldValue") ||
                !keyValue.hasOwnProperty("newValue"))
                return true;
            var v = {};
            v[firstName] = keyValue["oldValue"];
            var oldValue = this.getValue(name_1, v);
            v[firstName] = keyValue["newValue"];
            var newValue = this.getValue(name_1, v);
            if (!helpers_Helpers.isTwoValueEquals(oldValue, newValue, false, false, false))
                return true;
        }
        return false;
    };
    ProcessValue.prototype.getValueFromPath = function (path, values) {
        if (path.length === 2 && path[0] === surveyBuiltInVarible) {
            return this.getValueFromSurvey(path[1]);
        }
        var index = 0;
        while (!!values && index < path.length) {
            var ind_name = path[index];
            if (helpers_Helpers.isNumber(ind_name) &&
                Array.isArray(values) &&
                ind_name >= values.length)
                return null;
            values = values[ind_name];
            index++;
        }
        return values;
    };
    ProcessValue.prototype.getValueCore = function (text, values) {
        var question = this.getQuestionDirectly(text);
        if (question) {
            return { hasValue: true, value: question.value, path: [text], sctrictCompare: question.requireStrictCompare };
        }
        var res = this.getValueFromValues(text, values);
        if (!!text && !res.hasValue) {
            var val = this.getValueFromSurvey(text);
            if (val !== undefined) {
                res.hasValue = true;
                res.value = val;
                res.path = [surveyBuiltInVarible, text];
            }
        }
        return res;
    };
    ProcessValue.prototype.getQuestionDirectly = function (name) {
        if (!!this.properties && !!this.properties.survey)
            return this.properties.survey.getQuestionByValueName(name);
        return undefined;
    };
    ProcessValue.prototype.getValueFromSurvey = function (name) {
        if (!!this.properties && !!this.properties.survey)
            return this.properties.survey.getBuiltInVariableValue(name.toLocaleLowerCase());
        return undefined;
    };
    ProcessValue.prototype.getValueFromValues = function (text, values) {
        var res = { hasValue: false, value: null, path: null };
        var curValue = values;
        if (!curValue && curValue !== 0 && curValue !== false)
            return res;
        if (text &&
            text.lastIndexOf(".length") > -1 &&
            text.lastIndexOf(".length") === text.length - ".length".length) {
            res.value = 0;
            res.hasValue = true;
        }
        var nonNestedObj = this.getNonNestedObject(curValue, text, false);
        if (!nonNestedObj)
            return res;
        res.path = nonNestedObj.path;
        res.value = !!nonNestedObj.text
            ? this.getObjectValue(nonNestedObj.value, nonNestedObj.text)
            : nonNestedObj.value;
        res.hasValue = !helpers_Helpers.isValueEmpty(res.value);
        return res;
    };
    ProcessValue.prototype.getNonNestedObject = function (obj, text, createPath) {
        var checkedKeys = new Array();
        var len = 0;
        var res = this.getNonNestedObjectCore(obj, text, createPath, checkedKeys);
        while (!res && len < checkedKeys.length) {
            len = checkedKeys.length;
            res = this.getNonNestedObjectCore(obj, text, createPath, checkedKeys);
        }
        return res;
    };
    ProcessValue.prototype.getNonNestedObjectCore = function (obj, text, createPath, checkedKeys) {
        var curName = this.getFirstPropertyName(text, obj, createPath, checkedKeys);
        if (!!curName) {
            checkedKeys.push(curName);
        }
        var path = !!curName ? [curName] : null;
        while (text != curName && !!obj) {
            var isArray = text[0] == "[";
            if (!isArray) {
                if (!curName && text == this.getFirstName(text))
                    return { value: obj, text: text, path: path };
                obj = this.getObjectValue(obj, curName);
                if (helpers_Helpers.isValueEmpty(obj) && !createPath)
                    return null;
                text = text.substring(curName.length);
            }
            else {
                var objInArray = this.getObjInArray(obj, text);
                if (!objInArray)
                    return null;
                obj = objInArray.value;
                text = objInArray.text;
                path.push(objInArray.index);
            }
            if (!!text && text[0] == ".") {
                text = text.substring(1);
            }
            curName = this.getFirstPropertyName(text, obj, createPath, checkedKeys);
            if (!!curName) {
                path.push(curName);
            }
        }
        return { value: obj, text: text, path: path };
    };
    ProcessValue.prototype.getObjInArray = function (curValue, text) {
        if (!Array.isArray(curValue))
            return null;
        var index = 1;
        var str = "";
        while (index < text.length && text[index] != "]") {
            str += text[index];
            index++;
        }
        text = index < text.length ? text.substring(index + 1) : "";
        index = this.getIntValue(str);
        if (index < 0 || index >= curValue.length)
            return null;
        return { value: curValue[index], text: text, index: index };
    };
    ProcessValue.prototype.getFirstPropertyName = function (name, obj, createProp, checkedKeys) {
        if (createProp === void 0) { createProp = false; }
        if (checkedKeys === void 0) { checkedKeys = undefined; }
        if (!name)
            return name;
        if (!obj)
            obj = {};
        if (obj.hasOwnProperty(name))
            return name;
        var nameInLow = name.toLowerCase();
        var A = nameInLow[0];
        var a = A.toUpperCase();
        for (var key in obj) {
            if (Array.isArray(checkedKeys) && checkedKeys.indexOf(key) > -1)
                continue;
            var first = key[0];
            if (first === a || first === A) {
                var keyName = key.toLowerCase();
                if (keyName == nameInLow)
                    return key;
                if (nameInLow.length <= keyName.length)
                    continue;
                var ch = nameInLow[keyName.length];
                if (ch != "." && ch != "[")
                    continue;
                if (keyName == nameInLow.substring(0, keyName.length))
                    return key;
            }
        }
        if (createProp && name[0] !== "[") {
            var ind = name.indexOf(".");
            if (ind > -1) {
                name = name.substring(0, ind);
                obj[name] = {};
            }
            return name;
        }
        return "";
    };
    ProcessValue.prototype.getObjectValue = function (obj, name) {
        if (!name)
            return null;
        return obj[name];
    };
    ProcessValue.prototype.getIntValue = function (str) {
        if (str == "0" || ((str | 0) > 0 && str % 1 == 0))
            return Number(str);
        return -1;
    };
    return ProcessValue;
}());


// CONCATENATED MODULE: ./packages/survey-core/src/console-warnings.ts
var ConsoleWarnings = /** @class */ (function () {
    function ConsoleWarnings() {
    }
    ConsoleWarnings.disposedObjectChangedProperty = function (propName, objType) {
        ConsoleWarnings.warn("An attempt to set a property \"" + propName + "\" of a disposed object \"" + objType + "\"");
    };
    ConsoleWarnings.inCorrectQuestionValue = function (questionName, val) {
        var valStr = JSON.stringify(val, null, 3);
        ConsoleWarnings.warn("An attempt to assign an incorrect value" + valStr + " to the following question: \"" + questionName + "\"");
    };
    ConsoleWarnings.warn = function (text) {
        // eslint-disable-next-line no-console
        console.warn(text);
    };
    ConsoleWarnings.error = function (text) {
        // eslint-disable-next-line no-console
        console.error(text);
    };
    return ConsoleWarnings;
}());


// CONCATENATED MODULE: ./packages/survey-core/src/functionsfactory.ts




var functionsfactory_FunctionFactory = /** @class */ (function () {
    function FunctionFactory() {
        this.functionHash = {};
        this.isAsyncHash = {};
    }
    FunctionFactory.prototype.register = function (name, func, isAsync) {
        if (isAsync === void 0) { isAsync = false; }
        this.functionHash[name] = func;
        if (isAsync)
            this.isAsyncHash[name] = true;
    };
    FunctionFactory.prototype.unregister = function (name) {
        delete this.functionHash[name];
        delete this.isAsyncHash[name];
    };
    FunctionFactory.prototype.hasFunction = function (name) {
        return !!this.functionHash[name];
    };
    FunctionFactory.prototype.isAsyncFunction = function (name) {
        return !!this.isAsyncHash[name];
    };
    FunctionFactory.prototype.clear = function () {
        this.functionHash = {};
    };
    FunctionFactory.prototype.getAll = function () {
        var result = [];
        for (var key in this.functionHash) {
            result.push(key);
        }
        return result.sort();
    };
    FunctionFactory.prototype.run = function (name, params, properties, originalParams) {
        if (properties === void 0) { properties = null; }
        var func = this.functionHash[name];
        if (!func) {
            ConsoleWarnings.warn("Unknown function name: " + name);
            return null;
        }
        var classRunner = {
            func: func,
        };
        if (properties) {
            for (var key in properties) {
                classRunner[key] = properties[key];
            }
        }
        return classRunner.func(params, originalParams);
    };
    FunctionFactory.Instance = new FunctionFactory();
    return FunctionFactory;
}());

var registerFunction = functionsfactory_FunctionFactory.Instance.register;
function getParamsAsArray(value, arr) {
    if (value === undefined || value === null)
        return;
    if (Array.isArray(value)) {
        for (var i = 0; i < value.length; i++) {
            getParamsAsArray(value[i], arr);
        }
    }
    else {
        if (helpers_Helpers.isNumber(value)) {
            value = helpers_Helpers.getNumber(value);
        }
        arr.push(value);
    }
}
function sum(params) {
    var arr = [];
    getParamsAsArray(params, arr);
    var res = 0;
    for (var i = 0; i < arr.length; i++) {
        res = helpers_Helpers.correctAfterPlusMinis(res, arr[i], res + arr[i]);
    }
    return res;
}
functionsfactory_FunctionFactory.Instance.register("sum", sum);
function min_max(params, isMin) {
    var arr = [];
    getParamsAsArray(params, arr);
    var res = undefined;
    for (var i = 0; i < arr.length; i++) {
        if (res === undefined) {
            res = arr[i];
        }
        if (isMin) {
            if (res > arr[i])
                res = arr[i];
        }
        else {
            if (res < arr[i])
                res = arr[i];
        }
    }
    return res;
}
function functionsfactory_min(params) {
    return min_max(params, true);
}
functionsfactory_FunctionFactory.Instance.register("min", functionsfactory_min);
function functionsfactory_max(params) {
    return min_max(params, false);
}
functionsfactory_FunctionFactory.Instance.register("max", functionsfactory_max);
function count(params) {
    var arr = [];
    getParamsAsArray(params, arr);
    return arr.length;
}
functionsfactory_FunctionFactory.Instance.register("count", count);
function avg(params) {
    var arr = [];
    getParamsAsArray(params, arr);
    var res = sum(params);
    return arr.length > 0 ? res / arr.length : 0;
}
functionsfactory_FunctionFactory.Instance.register("avg", avg);
function getInArrayParams(params, originalParams) {
    if (params.length < 2 || params.length > 3)
        return null;
    var arr = params[0];
    if (!arr)
        return null;
    if (!Array.isArray(arr) && !Array.isArray(Object.keys(arr)))
        return null;
    var name = params[1];
    if (typeof name !== "string" && !(name instanceof String))
        return null;
    var expression = params.length > 2 ? params[2] : undefined;
    if (typeof expression !== "string" && !(expression instanceof String)) {
        expression = undefined;
    }
    if (!expression) {
        var operand = Array.isArray(originalParams) && originalParams.length > 2 ? originalParams[2] : undefined;
        if (operand && !!operand.toString()) {
            expression = operand.toString();
        }
    }
    return { data: arr, name: name, expression: expression };
}
function convertToNumber(val) {
    if (typeof val === "string")
        return helpers_Helpers.isNumber(val) ? helpers_Helpers.getNumber(val) : undefined;
    return val;
}
function processItemInArray(item, name, res, func, needToConvert, condition) {
    if (!item || helpers_Helpers.isValueEmpty(item[name]))
        return res;
    if (condition && !condition.run(item))
        return res;
    var val = needToConvert ? convertToNumber(item[name]) : 1;
    return func(res, val);
}
function calcInArray(params, originalParams, func, needToConvert) {
    if (needToConvert === void 0) { needToConvert = true; }
    var v = getInArrayParams(params, originalParams);
    if (!v)
        return undefined;
    var condition = !!v.expression ? new ConditionRunner(v.expression) : undefined;
    if (condition && condition.isAsync) {
        condition = undefined;
    }
    var res = undefined;
    if (Array.isArray(v.data)) {
        for (var i = 0; i < v.data.length; i++) {
            res = processItemInArray(v.data[i], v.name, res, func, needToConvert, condition);
        }
    }
    else {
        for (var key in v.data) {
            res = processItemInArray(v.data[key], v.name, res, func, needToConvert, condition);
        }
    }
    return res;
}
function sumInArray(params, originalParams) {
    var res = calcInArray(params, originalParams, function (res, val) {
        if (res == undefined)
            res = 0;
        if (val == undefined || val == null)
            return res;
        return helpers_Helpers.correctAfterPlusMinis(res, val, res + val);
    });
    return res !== undefined ? res : 0;
}
functionsfactory_FunctionFactory.Instance.register("sumInArray", sumInArray);
function minInArray(params, originalParams) {
    return calcInArray(params, originalParams, function (res, val) {
        if (res == undefined)
            return val;
        if (val == undefined || val == null)
            return res;
        return res < val ? res : val;
    });
}
functionsfactory_FunctionFactory.Instance.register("minInArray", minInArray);
function maxInArray(params, originalParams) {
    return calcInArray(params, originalParams, function (res, val) {
        if (res == undefined)
            return val;
        if (val == undefined || val == null)
            return res;
        return res > val ? res : val;
    });
}
functionsfactory_FunctionFactory.Instance.register("maxInArray", maxInArray);
function countInArray(params, originalParams) {
    var res = calcInArray(params, originalParams, function (res, val) {
        if (res == undefined)
            res = 0;
        if (val == undefined || val == null)
            return res;
        return res + 1;
    }, false);
    return res !== undefined ? res : 0;
}
functionsfactory_FunctionFactory.Instance.register("countInArray", countInArray);
function avgInArray(params, originalParams) {
    var count = countInArray(params, originalParams);
    if (count == 0)
        return 0;
    return sumInArray(params, originalParams) / count;
}
functionsfactory_FunctionFactory.Instance.register("avgInArray", avgInArray);
function iif(params) {
    if (!params && params.length !== 3)
        return "";
    return params[0] ? params[1] : params[2];
}
functionsfactory_FunctionFactory.Instance.register("iif", iif);
function getDate(params) {
    if (!params && params.length < 1)
        return null;
    if (!params[0])
        return null;
    return createDate("function-getDate", params[0]);
}
functionsfactory_FunctionFactory.Instance.register("getDate", getDate);
function dateDiffMonths(date1Param, date2Param, type) {
    if (type === "days")
        return diffDays([date1Param, date2Param]);
    var date1 = createDate("function-dateDiffMonths", date1Param);
    var date2 = createDate("function-dateDiffMonths", date2Param);
    var age = date2.getFullYear() - date1.getFullYear();
    type = type || "years";
    var ageInMonths = age * 12 + date2.getMonth() - date1.getMonth();
    if (date2.getDate() < date1.getDate()) {
        ageInMonths -= 1;
    }
    return type === "months" ? ageInMonths : ~~(ageInMonths / 12);
}
function functionsfactory_age(params) {
    if (!Array.isArray(params) || params.length < 1 || !params[0])
        return null;
    return dateDiffMonths(params[0], undefined, (params.length > 1 ? params[1] : "") || "years");
}
functionsfactory_FunctionFactory.Instance.register("age", functionsfactory_age);
function dateDiff(params) {
    if (!Array.isArray(params) || params.length < 2 || !params[0] || !params[1])
        return null;
    return dateDiffMonths(params[0], params[1], (params.length > 2 ? params[2] : "") || "days");
}
functionsfactory_FunctionFactory.Instance.register("dateDiff", dateDiff);
function dateAdd(params) {
    if (!Array.isArray(params) || params.length < 2 || !params[0] || !params[1])
        return null;
    var date = createDate("function-dateAdd", params[0]);
    var valToAdd = params[1];
    var interval = params[2] || "days";
    if (interval === "days") {
        date.setDate(date.getDate() + valToAdd);
    }
    if (interval === "months") {
        date.setMonth(date.getMonth() + valToAdd);
    }
    if (interval === "years") {
        date.setFullYear(date.getFullYear() + valToAdd);
    }
    return date;
}
functionsfactory_FunctionFactory.Instance.register("dateAdd", dateAdd);
function isContainerReadyCore(container) {
    if (!container)
        return false;
    var questions = container.questions;
    for (var i = 0; i < questions.length; i++) {
        if (!questions[i].validate(false))
            return false;
    }
    return true;
}
function isContainerReady(params) {
    if (!params && params.length < 1)
        return false;
    if (!params[0] || !this.survey)
        return false;
    var name = params[0];
    var container = this.survey.getPageByName(name);
    if (!container)
        container = this.survey.getPanelByName(name);
    if (!container) {
        var question = this.survey.getQuestionByName(name);
        if (!question || !Array.isArray(question.panels))
            return false;
        if (params.length > 1) {
            if (params[1] < question.panels.length) {
                container = question.panels[params[1]];
            }
        }
        else {
            for (var i = 0; i < question.panels.length; i++) {
                if (!isContainerReadyCore(question.panels[i]))
                    return false;
            }
            return true;
        }
    }
    return isContainerReadyCore(container);
}
functionsfactory_FunctionFactory.Instance.register("isContainerReady", isContainerReady);
function isDisplayMode() {
    return this.survey && this.survey.isDisplayMode;
}
functionsfactory_FunctionFactory.Instance.register("isDisplayMode", isDisplayMode);
function currentDate() {
    return createDate("function-currentDate");
}
functionsfactory_FunctionFactory.Instance.register("currentDate", currentDate);
function today(params) {
    var res = createDate("function-today");
    if (settings.localization.useLocalTimeZone) {
        res.setHours(0, 0, 0, 0);
    }
    else {
        res.setUTCHours(0, 0, 0, 0);
    }
    if (Array.isArray(params) && params.length == 1) {
        res.setDate(res.getDate() + params[0]);
    }
    return res;
}
functionsfactory_FunctionFactory.Instance.register("today", today);
function getYear(params) {
    if (params.length !== 1 || !params[0])
        return undefined;
    return createDate("function-getYear", params[0]).getFullYear();
}
functionsfactory_FunctionFactory.Instance.register("getYear", getYear);
function currentYear() {
    return createDate("function-currentYear").getFullYear();
}
functionsfactory_FunctionFactory.Instance.register("currentYear", currentYear);
function diffDays(params) {
    if (!Array.isArray(params) || params.length !== 2)
        return 0;
    if (!params[0] || !params[1])
        return 0;
    var date1 = createDate("function-diffDays", params[0]);
    var date2 = createDate("function-diffDays", params[1]);
    var diffTime = Math.abs(date2 - date1);
    return Math.ceil(diffTime / (1000 * 60 * 60 * 24));
}
functionsfactory_FunctionFactory.Instance.register("diffDays", diffDays);
function dateFromFirstParameterOrToday(name, params) {
    var date = today(undefined);
    if (params && params[0]) {
        date = createDate("function-" + name, params[0]);
    }
    return date;
}
function functionsfactory_year(params) {
    var date = dateFromFirstParameterOrToday("year", params);
    return date.getFullYear();
}
functionsfactory_FunctionFactory.Instance.register("year", functionsfactory_year);
function functionsfactory_month(params) {
    var date = dateFromFirstParameterOrToday("month", params);
    return date.getMonth() + 1;
}
functionsfactory_FunctionFactory.Instance.register("month", functionsfactory_month);
function day(params) {
    var date = dateFromFirstParameterOrToday("day", params);
    return date.getDate();
}
functionsfactory_FunctionFactory.Instance.register("day", day);
function weekday(params) {
    var date = dateFromFirstParameterOrToday("weekday", params);
    return date.getDay();
}
functionsfactory_FunctionFactory.Instance.register("weekday", weekday);
function getQuestionValueByContext(context, name) {
    if (!context || !name)
        return undefined;
    var q = context.question;
    while (q && q.parent) {
        var res = q.parent.getQuestionByName(name);
        if (!!res)
            return res;
        q = q.parentQuestion;
    }
    var keys = ["row", "panel", "survey"];
    for (var i = 0; i < keys.length; i++) {
        var ctx = context[keys[i]];
        if (ctx && ctx.getQuestionByName) {
            var res = ctx.getQuestionByName(name);
            if (res)
                return res;
        }
    }
    return null;
}
function getDisplayValueReturnResult(q, params) {
    if (params.length > 1 && !helpers_Helpers.isValueEmpty(params[1]))
        return q.getDisplayValue(true, params[1]);
    return q.displayValue;
}
function displayValue(params) {
    var _this = this;
    var q = getQuestionValueByContext(this, params[0]);
    if (!q)
        return "";
    if (q.isReady) {
        this.returnResult(getDisplayValueReturnResult(q, params));
    }
    else {
        var displayValueOnReadyChanged_1 = function (sender, options) {
            if (sender.isReady) {
                sender.onReadyChanged.remove(displayValueOnReadyChanged_1);
                _this.returnResult(getDisplayValueReturnResult(sender, params));
            }
        };
        q.onReadyChanged.add(displayValueOnReadyChanged_1);
    }
    return undefined;
}
functionsfactory_FunctionFactory.Instance.register("displayValue", displayValue, true);
function propertyValue(params) {
    if (params.length !== 2 || !params[0] || !params[1])
        return undefined;
    var q = getQuestionValueByContext(this, params[0]);
    return q ? q[params[1]] : undefined;
}
functionsfactory_FunctionFactory.Instance.register("propertyValue", propertyValue);
function substring_(params) {
    if (params.length < 2)
        return "";
    var s = params[0];
    if (!s || typeof s !== "string")
        return "";
    var start = params[1];
    if (!helpers_Helpers.isNumber(start))
        return "";
    var end = params.length > 2 ? params[2] : undefined;
    if (!helpers_Helpers.isNumber(end))
        return s.substring(start);
    return s.substring(start, end);
}
functionsfactory_FunctionFactory.Instance.register("substring", substring_);

// CONCATENATED MODULE: ./packages/survey-core/src/expressions/expressions.ts
var expressions_extends = (undefined && undefined.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();



var Operand = /** @class */ (function () {
    function Operand() {
        this._id = Operand.counter++;
    }
    Object.defineProperty(Operand.prototype, "id", {
        get: function () { return this._id; },
        enumerable: false,
        configurable: true
    });
    Operand.prototype.toString = function (func) {
        if (func === void 0) { func = undefined; }
        return "";
    };
    Operand.prototype.hasFunction = function () {
        return false;
    };
    Operand.prototype.hasAsyncFunction = function () { return false; };
    Operand.prototype.addToAsyncList = function (list) { };
    Operand.prototype.isEqual = function (op) {
        return !!op && op.getType() === this.getType() && this.isContentEqual(op);
    };
    Operand.prototype.areOperatorsEquals = function (op1, op2) {
        return !op1 && !op2 || !!op1 && op1.isEqual(op2);
    };
    Operand.counter = 1;
    return Operand;
}());

var BinaryOperand = /** @class */ (function (_super) {
    expressions_extends(BinaryOperand, _super);
    function BinaryOperand(operatorName, left, right, isArithmeticOp) {
        if (left === void 0) { left = null; }
        if (right === void 0) { right = null; }
        if (isArithmeticOp === void 0) { isArithmeticOp = false; }
        var _this = _super.call(this) || this;
        _this.operatorName = operatorName;
        _this.left = left;
        _this.right = right;
        _this.isArithmeticValue = isArithmeticOp;
        if (isArithmeticOp) {
            _this.consumer = expressions_OperandMaker.binaryFunctions["arithmeticOp"](operatorName);
        }
        else {
            _this.consumer = expressions_OperandMaker.binaryFunctions[operatorName];
        }
        if (_this.consumer == null) {
            expressions_OperandMaker.throwInvalidOperatorError(operatorName);
        }
        return _this;
    }
    Object.defineProperty(BinaryOperand.prototype, "requireStrictCompare", {
        get: function () {
            return this.getIsOperandRequireStrict(this.left) ||
                this.getIsOperandRequireStrict(this.right);
        },
        enumerable: false,
        configurable: true
    });
    BinaryOperand.prototype.getIsOperandRequireStrict = function (op) {
        return !!op && op.requireStrictCompare;
    };
    BinaryOperand.prototype.getType = function () {
        return "binary";
    };
    Object.defineProperty(BinaryOperand.prototype, "isArithmetic", {
        get: function () {
            return this.isArithmeticValue;
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(BinaryOperand.prototype, "isConjunction", {
        get: function () {
            return this.operatorName == "or" || this.operatorName == "and";
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(BinaryOperand.prototype, "conjunction", {
        get: function () {
            return this.isConjunction ? this.operatorName : "";
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(BinaryOperand.prototype, "operator", {
        get: function () {
            return this.operatorName;
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(BinaryOperand.prototype, "leftOperand", {
        get: function () {
            return this.left;
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(BinaryOperand.prototype, "rightOperand", {
        get: function () {
            return this.right;
        },
        enumerable: false,
        configurable: true
    });
    BinaryOperand.prototype.isContentEqual = function (op) {
        var bOp = op;
        return bOp.operator === this.operator &&
            this.areOperatorsEquals(this.left, bOp.left) &&
            this.areOperatorsEquals(this.right, bOp.right);
    };
    BinaryOperand.prototype.evaluateParam = function (x, processValue) {
        return x == null ? null : x.evaluate(processValue);
    };
    BinaryOperand.prototype.evaluate = function (processValue) {
        return this.consumer.call(this, this.evaluateParam(this.left, processValue), this.evaluateParam(this.right, processValue), this.requireStrictCompare);
    };
    BinaryOperand.prototype.toString = function (func) {
        if (func === void 0) { func = undefined; }
        if (!!func) {
            var res = func(this);
            if (!!res)
                return res;
        }
        return ("(" +
            expressions_OperandMaker.safeToString(this.left, func) +
            " " +
            expressions_OperandMaker.operatorToString(this.operatorName) +
            " " +
            expressions_OperandMaker.safeToString(this.right, func) +
            ")");
    };
    BinaryOperand.prototype.setVariables = function (variables) {
        if (this.left != null)
            this.left.setVariables(variables);
        if (this.right != null)
            this.right.setVariables(variables);
    };
    BinaryOperand.prototype.hasFunction = function () {
        return ((!!this.left && this.left.hasFunction()) ||
            (!!this.right && this.right.hasFunction()));
    };
    BinaryOperand.prototype.hasAsyncFunction = function () {
        return ((!!this.left && this.left.hasAsyncFunction()) ||
            (!!this.right && this.right.hasAsyncFunction()));
    };
    BinaryOperand.prototype.addToAsyncList = function (list) {
        if (!!this.left)
            this.left.addToAsyncList(list);
        if (!!this.right)
            this.right.addToAsyncList(list);
    };
    return BinaryOperand;
}(Operand));

var UnaryOperand = /** @class */ (function (_super) {
    expressions_extends(UnaryOperand, _super);
    function UnaryOperand(expressionValue, operatorName) {
        var _this = _super.call(this) || this;
        _this.expressionValue = expressionValue;
        _this.operatorName = operatorName;
        _this.consumer = expressions_OperandMaker.unaryFunctions[operatorName];
        if (_this.consumer == null) {
            expressions_OperandMaker.throwInvalidOperatorError(operatorName);
        }
        return _this;
    }
    Object.defineProperty(UnaryOperand.prototype, "operator", {
        get: function () {
            return this.operatorName;
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(UnaryOperand.prototype, "expression", {
        get: function () {
            return this.expressionValue;
        },
        enumerable: false,
        configurable: true
    });
    UnaryOperand.prototype.getType = function () {
        return "unary";
    };
    UnaryOperand.prototype.toString = function (func) {
        if (func === void 0) { func = undefined; }
        if (!!func) {
            var res = func(this);
            if (!!res)
                return res;
        }
        return (expressions_OperandMaker.operatorToString(this.operatorName) +
            " " +
            this.expression.toString(func));
    };
    UnaryOperand.prototype.isContentEqual = function (op) {
        var uOp = op;
        return uOp.operator == this.operator && this.areOperatorsEquals(this.expression, uOp.expression);
    };
    UnaryOperand.prototype.hasFunction = function () {
        return this.expression.hasFunction();
    };
    UnaryOperand.prototype.hasAsyncFunction = function () {
        return this.expression.hasAsyncFunction();
    };
    UnaryOperand.prototype.addToAsyncList = function (list) {
        this.expression.addToAsyncList(list);
    };
    UnaryOperand.prototype.evaluate = function (processValue) {
        var value = this.expression.evaluate(processValue);
        return this.consumer.call(this, value);
    };
    UnaryOperand.prototype.setVariables = function (variables) {
        this.expression.setVariables(variables);
    };
    return UnaryOperand;
}(Operand));

var ArrayOperand = /** @class */ (function (_super) {
    expressions_extends(ArrayOperand, _super);
    function ArrayOperand(values) {
        var _this = _super.call(this) || this;
        _this.values = values;
        return _this;
    }
    ArrayOperand.prototype.getType = function () {
        return "array";
    };
    ArrayOperand.prototype.toString = function (func) {
        if (func === void 0) { func = undefined; }
        if (!!func) {
            var res = func(this);
            if (!!res)
                return res;
        }
        return ("[" +
            this.values
                .map(function (el) {
                return el.toString(func);
            })
                .join(", ") +
            "]");
    };
    ArrayOperand.prototype.evaluate = function (processValue) {
        return this.values.map(function (el) {
            return el.evaluate(processValue);
        });
    };
    ArrayOperand.prototype.setVariables = function (variables) {
        this.values.forEach(function (el) {
            el.setVariables(variables);
        });
    };
    ArrayOperand.prototype.hasFunction = function () {
        return this.values.some(function (operand) { return operand.hasFunction(); });
    };
    ArrayOperand.prototype.hasAsyncFunction = function () {
        return this.values.some(function (operand) { return operand.hasAsyncFunction(); });
    };
    ArrayOperand.prototype.addToAsyncList = function (list) {
        this.values.forEach(function (operand) { return operand.addToAsyncList(list); });
    };
    ArrayOperand.prototype.isContentEqual = function (op) {
        var aOp = op;
        if (aOp.values.length !== this.values.length)
            return false;
        for (var i = 0; i < this.values.length; i++) {
            if (!aOp.values[i].isEqual(this.values[i]))
                return false;
        }
        return true;
    };
    return ArrayOperand;
}(Operand));

var expressions_Const = /** @class */ (function (_super) {
    expressions_extends(Const, _super);
    function Const(value) {
        var _this = _super.call(this) || this;
        _this.value = value;
        return _this;
    }
    Const.prototype.getType = function () {
        return "const";
    };
    Const.prototype.toString = function (func) {
        if (func === void 0) { func = undefined; }
        if (!!func) {
            var res = func(this);
            if (!!res)
                return res;
        }
        return this.value.toString();
    };
    Object.defineProperty(Const.prototype, "correctValue", {
        get: function () {
            return this.getCorrectValue(this.value);
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(Const.prototype, "requireStrictCompare", {
        get: function () { return false; },
        enumerable: false,
        configurable: true
    });
    Const.prototype.evaluate = function () {
        return this.getCorrectValue(this.value);
    };
    Const.prototype.setVariables = function (variables) { };
    Const.prototype.getCorrectValue = function (value) {
        if (!value || typeof value != "string")
            return value;
        if (expressions_OperandMaker.isBooleanValue(value))
            return value.toLowerCase() === "true";
        if (value.length > 1 &&
            this.isQuote(value[0]) &&
            this.isQuote(value[value.length - 1]))
            return value.substring(1, value.length - 1);
        if (helpers_Helpers.isNumber(value)) {
            if (value[0] === "0" && value.indexOf("0x") != 0) {
                var len = value.length;
                var hasPoint = len > 1 && (value[1] === "." || value[1] === ",");
                if (!hasPoint && len > 1 || hasPoint && len < 2)
                    return value;
            }
            return helpers_Helpers.getNumber(value);
        }
        return value;
    };
    Const.prototype.isContentEqual = function (op) {
        var cOp = op;
        return cOp.value == this.value;
    };
    Const.prototype.isQuote = function (ch) {
        return ch == "'" || ch == '"';
    };
    return Const;
}(Operand));

var expressions_Variable = /** @class */ (function (_super) {
    expressions_extends(Variable, _super);
    function Variable(variableName) {
        var _this = _super.call(this, variableName) || this;
        _this.variableName = variableName;
        _this.valueInfo = {};
        _this.useValueAsItIs = false;
        if (!!_this.variableName &&
            _this.variableName.length > 1 &&
            _this.variableName[0] === Variable.DisableConversionChar) {
            _this.variableName = _this.variableName.substring(1);
            _this.useValueAsItIs = true;
        }
        return _this;
    }
    Object.defineProperty(Variable, "DisableConversionChar", {
        get: function () { return settings.expressionDisableConversionChar; },
        set: function (val) { settings.expressionDisableConversionChar = val; },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(Variable.prototype, "requireStrictCompare", {
        get: function () {
            return this.valueInfo.sctrictCompare === true;
        },
        enumerable: false,
        configurable: true
    });
    Variable.prototype.getType = function () {
        return "variable";
    };
    Variable.prototype.toString = function (func) {
        if (func === void 0) { func = undefined; }
        if (!!func) {
            var res = func(this);
            if (!!res)
                return res;
        }
        var prefix = this.useValueAsItIs ? Variable.DisableConversionChar : "";
        return "{" + prefix + this.variableName + "}";
    };
    Object.defineProperty(Variable.prototype, "variable", {
        get: function () {
            return this.variableName;
        },
        enumerable: false,
        configurable: true
    });
    Variable.prototype.evaluate = function (processValue) {
        this.valueInfo.name = this.variableName;
        processValue.getValueInfo(this.valueInfo);
        return this.valueInfo.hasValue
            ? this.getCorrectValue(this.valueInfo.value)
            : null;
    };
    Variable.prototype.setVariables = function (variables) {
        variables.push(this.variableName);
    };
    Variable.prototype.getCorrectValue = function (value) {
        if (this.useValueAsItIs)
            return value;
        return _super.prototype.getCorrectValue.call(this, value);
    };
    Variable.prototype.isContentEqual = function (op) {
        var vOp = op;
        return vOp.variable == this.variable;
    };
    return Variable;
}(expressions_Const));

var expressions_FunctionOperand = /** @class */ (function (_super) {
    expressions_extends(FunctionOperand, _super);
    function FunctionOperand(originalValue, parameters) {
        var _this = _super.call(this) || this;
        _this.originalValue = originalValue;
        _this.parameters = parameters;
        if (Array.isArray(parameters) && parameters.length === 0) {
            _this.parameters = new ArrayOperand([]);
        }
        return _this;
    }
    FunctionOperand.prototype.getType = function () {
        return "function";
    };
    FunctionOperand.prototype.evaluate = function (processValue) {
        var asyncVal = this.getAsynValue(processValue);
        if (!!asyncVal)
            return asyncVal.value;
        return this.evaluateCore(processValue);
    };
    FunctionOperand.prototype.evaluateCore = function (processValue) {
        var properties = processValue.properties;
        if (this.isAsyncFunction) {
            properties = helpers_Helpers.createCopy(processValue.properties);
            var id_1 = this.id;
            var asyncValues_1 = processValue.asyncValues;
            var onComplete_1 = processValue.onCompleteAsyncFunc;
            var item_1 = this;
            properties.returnResult = function (result) {
                asyncValues_1[id_1] = { value: result };
                onComplete_1(item_1);
            };
        }
        return functionsfactory_FunctionFactory.Instance.run(this.originalValue, this.parameters.evaluate(processValue), properties, this.parameters.values);
    };
    FunctionOperand.prototype.toString = function (func) {
        if (func === void 0) { func = undefined; }
        if (!!func) {
            var res = func(this);
            if (!!res)
                return res;
        }
        return this.originalValue + "(" + this.parameters.toString(func) + ")";
    };
    FunctionOperand.prototype.setVariables = function (variables) {
        this.parameters.setVariables(variables);
    };
    FunctionOperand.prototype.isReady = function (proccessValue) {
        return !!this.getAsynValue(proccessValue);
    };
    FunctionOperand.prototype.getAsynValue = function (proccessValue) {
        return proccessValue.asyncValues[this.id];
    };
    FunctionOperand.prototype.hasFunction = function () { return true; };
    FunctionOperand.prototype.hasAsyncFunction = function () {
        return this.isAsyncFunction() || this.parameters.hasAsyncFunction();
    };
    FunctionOperand.prototype.isAsyncFunction = function () {
        return functionsfactory_FunctionFactory.Instance.isAsyncFunction(this.originalValue);
    };
    FunctionOperand.prototype.addToAsyncList = function (list) {
        var item = undefined;
        if (this.isAsyncFunction()) {
            item = { operand: this };
        }
        if (this.parameters.hasAsyncFunction()) {
            var children = new Array();
            this.parameters.addToAsyncList(children);
            children.forEach(function (child) { return child.parent = item; });
            if (!item) {
                item = {};
            }
            item.children = children;
        }
        if (item) {
            list.push(item);
        }
    };
    FunctionOperand.prototype.isContentEqual = function (op) {
        var fOp = op;
        return fOp.originalValue == this.originalValue && this.areOperatorsEquals(fOp.parameters, this.parameters);
    };
    return FunctionOperand;
}(Operand));

var expressions_OperandMaker = /** @class */ (function () {
    function OperandMaker() {
    }
    OperandMaker.throwInvalidOperatorError = function (op) {
        throw new Error("Invalid operator: '" + op + "'");
    };
    OperandMaker.safeToString = function (operand, func) {
        return operand == null ? "" : operand.toString(func);
    };
    OperandMaker.toOperandString = function (value) {
        if (!!value &&
            !helpers_Helpers.isNumber(value) &&
            !OperandMaker.isBooleanValue(value))
            value = "'" + value + "'";
        return value;
    };
    OperandMaker.isBooleanValue = function (value) {
        return (!!value &&
            (value.toLowerCase() === "true" || value.toLowerCase() === "false"));
    };
    OperandMaker.countDecimals = function (value) {
        if (helpers_Helpers.isNumber(value) && Math.floor(value) !== value) {
            var strs = value.toString().split(".");
            return strs.length > 1 && strs[1].length || 0;
        }
        return 0;
    };
    OperandMaker.plusMinus = function (a, b, res) {
        var digitsA = OperandMaker.countDecimals(a);
        var digitsB = OperandMaker.countDecimals(b);
        if (digitsA > 0 || digitsB > 0) {
            var digits = Math.max(digitsA, digitsB);
            res = parseFloat(res.toFixed(digits));
        }
        return res;
    };
    OperandMaker.isTwoValueEquals = function (x, y, ignoreOrder) {
        if (ignoreOrder === void 0) { ignoreOrder = true; }
        if (x === "undefined")
            x = undefined;
        if (y === "undefined")
            y = undefined;
        return helpers_Helpers.isTwoValueEquals(x, y, ignoreOrder);
    };
    OperandMaker.operatorToString = function (operatorName) {
        var opStr = OperandMaker.signs[operatorName];
        return opStr == null ? operatorName : opStr;
    };
    OperandMaker.convertValForDateCompare = function (val, second) {
        if (second instanceof Date && typeof val === "string") {
            var res = createDate("expression-operand", val);
            res.setHours(0, 0, 0);
            return res;
        }
        return val;
    };
    OperandMaker.unaryFunctions = {
        empty: function (value) {
            return helpers_Helpers.isValueEmpty(value);
        },
        notempty: function (value) {
            return !OperandMaker.unaryFunctions.empty(value);
        },
        negate: function (value) {
            return !value;
        },
    };
    OperandMaker.binaryFunctions = {
        arithmeticOp: function (operatorName) {
            var convertForArithmeticOp = function (val, second) {
                if (!helpers_Helpers.isValueEmpty(val))
                    return val;
                if (typeof second === "number")
                    return 0;
                if (typeof val === "string")
                    return val;
                if (typeof second === "string")
                    return "";
                if (Array.isArray(second))
                    return [];
                return 0;
            };
            return function (a, b) {
                a = convertForArithmeticOp(a, b);
                b = convertForArithmeticOp(b, a);
                var consumer = OperandMaker.binaryFunctions[operatorName];
                return consumer == null ? null : consumer.call(this, a, b);
            };
        },
        and: function (a, b) {
            return a && b;
        },
        or: function (a, b) {
            return a || b;
        },
        plus: function (a, b) {
            return helpers_Helpers.sumAnyValues(a, b);
        },
        minus: function (a, b) {
            return helpers_Helpers.correctAfterPlusMinis(a, b, a - b);
        },
        mul: function (a, b) {
            return helpers_Helpers.correctAfterMultiple(a, b, a * b);
        },
        div: function (a, b) {
            if (!b)
                return null;
            return a / b;
        },
        mod: function (a, b) {
            if (!b)
                return null;
            return a % b;
        },
        power: function (a, b) {
            return Math.pow(a, b);
        },
        greater: function (left, right) {
            if (left == null || right == null)
                return false;
            left = OperandMaker.convertValForDateCompare(left, right);
            right = OperandMaker.convertValForDateCompare(right, left);
            return left > right;
        },
        less: function (left, right) {
            if (left == null || right == null)
                return false;
            left = OperandMaker.convertValForDateCompare(left, right);
            right = OperandMaker.convertValForDateCompare(right, left);
            return left < right;
        },
        greaterorequal: function (left, right) {
            if (OperandMaker.binaryFunctions.equal(left, right))
                return true;
            return OperandMaker.binaryFunctions.greater(left, right);
        },
        lessorequal: function (left, right) {
            if (OperandMaker.binaryFunctions.equal(left, right))
                return true;
            return OperandMaker.binaryFunctions.less(left, right);
        },
        equal: function (left, right, strictCompare) {
            left = OperandMaker.convertValForDateCompare(left, right);
            right = OperandMaker.convertValForDateCompare(right, left);
            return OperandMaker.isTwoValueEquals(left, right, strictCompare !== true);
        },
        notequal: function (left, right, strictCompare) {
            return !OperandMaker.binaryFunctions.equal(left, right, strictCompare);
        },
        contains: function (left, right) {
            return OperandMaker.binaryFunctions.containsCore(left, right, true);
        },
        notcontains: function (left, right) {
            if (!left && !helpers_Helpers.isValueEmpty(right))
                return true;
            return OperandMaker.binaryFunctions.containsCore(left, right, false);
        },
        anyof: function (left, right) {
            if (helpers_Helpers.isValueEmpty(left) && helpers_Helpers.isValueEmpty(right))
                return true;
            if (helpers_Helpers.isValueEmpty(left) ||
                (!Array.isArray(left) && left.length === 0))
                return false;
            if (helpers_Helpers.isValueEmpty(right))
                return true;
            if (!Array.isArray(left))
                return OperandMaker.binaryFunctions.contains(right, left);
            if (!Array.isArray(right))
                return OperandMaker.binaryFunctions.contains(left, right);
            for (var i = 0; i < right.length; i++) {
                if (OperandMaker.binaryFunctions.contains(left, right[i]))
                    return true;
            }
            return false;
        },
        allof: function (left, right) {
            if (!left && !helpers_Helpers.isValueEmpty(right))
                return false;
            if (!Array.isArray(right))
                return OperandMaker.binaryFunctions.contains(left, right);
            for (var i = 0; i < right.length; i++) {
                if (!OperandMaker.binaryFunctions.contains(left, right[i]))
                    return false;
            }
            return true;
        },
        containsCore: function (left, right, isContains) {
            if (!left && left !== 0 && left !== false)
                return false;
            if (!left.length) {
                left = left.toString();
                if (typeof right === "string" || right instanceof String) {
                    left = left.toUpperCase();
                    right = right.toUpperCase();
                }
            }
            if (typeof left === "string" || left instanceof String) {
                if (!right)
                    return false;
                right = right.toString();
                var found = left.indexOf(right) > -1;
                return isContains ? found : !found;
            }
            var rightArray = Array.isArray(right) ? right : [right];
            for (var rIndex = 0; rIndex < rightArray.length; rIndex++) {
                var i = 0;
                right = rightArray[rIndex];
                for (; i < left.length; i++) {
                    if (OperandMaker.isTwoValueEquals(left[i], right))
                        break;
                }
                if (i == left.length)
                    return !isContains;
            }
            return isContains;
        },
    };
    OperandMaker.signs = {
        less: "<",
        lessorequal: "<=",
        greater: ">",
        greaterorequal: ">=",
        equal: "==",
        notequal: "!=",
        plus: "+",
        minus: "-",
        mul: "*",
        div: "/",
        and: "and",
        or: "or",
        power: "^",
        mod: "%",
        negate: "!",
    };
    return OperandMaker;
}());


// CONCATENATED MODULE: ./packages/survey-core/src/expressions/expressionParser.ts
var expressionParser_extends = (undefined && undefined.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
/* eslint-disable */

// Generated by PEG.js v. 0.10.0 (ts-pegjs plugin v. 0.3.1 )
//
// https://pegjs.org/   https://github.com/metadevpro/ts-pegjs
"use strict";
var SyntaxError = /** @class */ (function (_super) {
    expressionParser_extends(SyntaxError, _super);
    function SyntaxError(message, expected, found, location) {
        var _this = _super.call(this) || this;
        _this.message = message;
        _this.expected = expected;
        _this.found = found;
        _this.location = location;
        _this.name = "SyntaxError";
        if (typeof Error.captureStackTrace === "function") {
            Error.captureStackTrace(_this, SyntaxError);
        }
        return _this;
    }
    SyntaxError.buildMessage = function (expected, found) {
        function hex(ch) {
            return ch.charCodeAt(0).toString(16).toUpperCase();
        }
        function literalEscape(s) {
            return s
                .replace(/\\/g, "\\\\")
                .replace(/"/g, "\\\"")
                .replace(/\0/g, "\\0")
                .replace(/\t/g, "\\t")
                .replace(/\n/g, "\\n")
                .replace(/\r/g, "\\r")
                .replace(/[\x00-\x0F]/g, function (ch) { return "\\x0" + hex(ch); })
                .replace(/[\x10-\x1F\x7F-\x9F]/g, function (ch) { return "\\x" + hex(ch); });
        }
        function classEscape(s) {
            return s
                .replace(/\\/g, "\\\\")
                .replace(/\]/g, "\\]")
                .replace(/\^/g, "\\^")
                .replace(/-/g, "\\-")
                .replace(/\0/g, "\\0")
                .replace(/\t/g, "\\t")
                .replace(/\n/g, "\\n")
                .replace(/\r/g, "\\r")
                .replace(/[\x00-\x0F]/g, function (ch) { return "\\x0" + hex(ch); })
                .replace(/[\x10-\x1F\x7F-\x9F]/g, function (ch) { return "\\x" + hex(ch); });
        }
        function describeExpectation(expectation) {
            switch (expectation.type) {
                case "literal":
                    return "\"" + literalEscape(expectation.text) + "\"";
                case "class":
                    var escapedParts = expectation.parts.map(function (part) {
                        return Array.isArray(part)
                            ? classEscape(part[0]) + "-" + classEscape(part[1])
                            : classEscape(part);
                    });
                    return "[" + (expectation.inverted ? "^" : "") + escapedParts + "]";
                case "any":
                    return "any character";
                case "end":
                    return "end of input";
                case "other":
                    return expectation.description;
            }
        }
        function describeExpected(expected1) {
            var descriptions = expected1.map(describeExpectation);
            var i;
            var j;
            descriptions.sort();
            if (descriptions.length > 0) {
                for (i = 1, j = 1; i < descriptions.length; i++) {
                    if (descriptions[i - 1] !== descriptions[i]) {
                        descriptions[j] = descriptions[i];
                        j++;
                    }
                }
                descriptions.length = j;
            }
            switch (descriptions.length) {
                case 1:
                    return descriptions[0];
                case 2:
                    return descriptions[0] + " or " + descriptions[1];
                default:
                    return descriptions.slice(0, -1).join(", ")
                        + ", or "
                        + descriptions[descriptions.length - 1];
            }
        }
        function describeFound(found1) {
            return found1 ? "\"" + literalEscape(found1) + "\"" : "end of input";
        }
        return "Expected " + describeExpected(expected) + " but " + describeFound(found) + " found.";
    };
    return SyntaxError;
}(Error));

function peg$parse(input, options) {
    options = options !== undefined ? options : {};
    var peg$FAILED = {};
    var peg$startRuleFunctions = { Expression: peg$parseExpression };
    var peg$startRuleFunction = peg$parseExpression;
    var peg$c0 = function (head, tail) {
        return buildBinaryOperand(head, tail, true);
    };
    var peg$c1 = "||";
    var peg$c2 = peg$literalExpectation("||", false);
    var peg$c3 = "or";
    var peg$c4 = peg$literalExpectation("or", true);
    var peg$c5 = function () { return "or"; };
    var peg$c6 = "&&";
    var peg$c7 = peg$literalExpectation("&&", false);
    var peg$c8 = "and";
    var peg$c9 = peg$literalExpectation("and", true);
    var peg$c10 = function () { return "and"; };
    var peg$c11 = function (head, tail) {
        return buildBinaryOperand(head, tail);
    };
    var peg$c12 = "<=";
    var peg$c13 = peg$literalExpectation("<=", false);
    var peg$c14 = "lessorequal";
    var peg$c15 = peg$literalExpectation("lessorequal", true);
    var peg$c16 = function () { return "lessorequal"; };
    var peg$c17 = ">=";
    var peg$c18 = peg$literalExpectation(">=", false);
    var peg$c19 = "greaterorequal";
    var peg$c20 = peg$literalExpectation("greaterorequal", true);
    var peg$c21 = function () { return "greaterorequal"; };
    var peg$c22 = "==";
    var peg$c23 = peg$literalExpectation("==", false);
    var peg$c24 = "equal";
    var peg$c25 = peg$literalExpectation("equal", true);
    var peg$c26 = function () { return "equal"; };
    var peg$c27 = "=";
    var peg$c28 = peg$literalExpectation("=", false);
    var peg$c29 = "!=";
    var peg$c30 = peg$literalExpectation("!=", false);
    var peg$c31 = "notequal";
    var peg$c32 = peg$literalExpectation("notequal", true);
    var peg$c33 = function () { return "notequal"; };
    var peg$c34 = "<";
    var peg$c35 = peg$literalExpectation("<", false);
    var peg$c36 = "less";
    var peg$c37 = peg$literalExpectation("less", true);
    var peg$c38 = function () { return "less"; };
    var peg$c39 = ">";
    var peg$c40 = peg$literalExpectation(">", false);
    var peg$c41 = "greater";
    var peg$c42 = peg$literalExpectation("greater", true);
    var peg$c43 = function () { return "greater"; };
    var peg$c44 = "+";
    var peg$c45 = peg$literalExpectation("+", false);
    var peg$c46 = function () { return "plus"; };
    var peg$c47 = "-";
    var peg$c48 = peg$literalExpectation("-", false);
    var peg$c49 = function () { return "minus"; };
    var peg$c50 = "*";
    var peg$c51 = peg$literalExpectation("*", false);
    var peg$c52 = function () { return "mul"; };
    var peg$c53 = "/";
    var peg$c54 = peg$literalExpectation("/", false);
    var peg$c55 = function () { return "div"; };
    var peg$c56 = "%";
    var peg$c57 = peg$literalExpectation("%", false);
    var peg$c58 = function () { return "mod"; };
    var peg$c59 = "^";
    var peg$c60 = peg$literalExpectation("^", false);
    var peg$c61 = "power";
    var peg$c62 = peg$literalExpectation("power", true);
    var peg$c63 = function () { return "power"; };
    var peg$c64 = "*=";
    var peg$c65 = peg$literalExpectation("*=", false);
    var peg$c66 = "contains";
    var peg$c67 = peg$literalExpectation("contains", true);
    var peg$c68 = "contain";
    var peg$c69 = peg$literalExpectation("contain", true);
    var peg$c70 = function () { return "contains"; };
    var peg$c71 = "notcontains";
    var peg$c72 = peg$literalExpectation("notcontains", true);
    var peg$c73 = "notcontain";
    var peg$c74 = peg$literalExpectation("notcontain", true);
    var peg$c75 = function () { return "notcontains"; };
    var peg$c76 = "anyof";
    var peg$c77 = peg$literalExpectation("anyof", true);
    var peg$c78 = function () { return "anyof"; };
    var peg$c79 = "allof";
    var peg$c80 = peg$literalExpectation("allof", true);
    var peg$c81 = function () { return "allof"; };
    var peg$c82 = "(";
    var peg$c83 = peg$literalExpectation("(", false);
    var peg$c84 = ")";
    var peg$c85 = peg$literalExpectation(")", false);
    var peg$c86 = function (expr) { return expr; };
    var peg$c87 = function (name, params) { return new expressions_FunctionOperand(name, params); };
    var peg$c88 = "!";
    var peg$c89 = peg$literalExpectation("!", false);
    var peg$c90 = "negate";
    var peg$c91 = peg$literalExpectation("negate", true);
    var peg$c92 = function (expr) { return new UnaryOperand(expr, "negate"); };
    var peg$c93 = function (expr, op) { return new UnaryOperand(expr, op); };
    var peg$c94 = "empty";
    var peg$c95 = peg$literalExpectation("empty", true);
    var peg$c96 = function () { return "empty"; };
    var peg$c97 = "notempty";
    var peg$c98 = peg$literalExpectation("notempty", true);
    var peg$c99 = function () { return "notempty"; };
    var peg$c100 = "undefined";
    var peg$c101 = peg$literalExpectation("undefined", false);
    var peg$c102 = "null";
    var peg$c103 = peg$literalExpectation("null", false);
    var peg$c104 = function () { return null; };
    var peg$c105 = function (value) { return new expressions_Const(value); };
    var peg$c106 = "{";
    var peg$c107 = peg$literalExpectation("{", false);
    var peg$c108 = "}";
    var peg$c109 = peg$literalExpectation("}", false);
    var peg$c110 = function (value) { return new expressions_Variable(value); };
    var peg$c111 = function (value) { return value; };
    var peg$c112 = "''";
    var peg$c113 = peg$literalExpectation("''", false);
    var peg$c114 = function () { return ""; };
    var peg$c115 = "\"\"";
    var peg$c116 = peg$literalExpectation("\"\"", false);
    var peg$c117 = "'";
    var peg$c118 = peg$literalExpectation("'", false);
    var peg$c119 = function (value) { return "'" + value + "'"; };
    var peg$c120 = "\"";
    var peg$c121 = peg$literalExpectation("\"", false);
    var peg$c122 = "[";
    var peg$c123 = peg$literalExpectation("[", false);
    var peg$c124 = "]";
    var peg$c125 = peg$literalExpectation("]", false);
    var peg$c126 = function (sequence) { return sequence; };
    var peg$c127 = ",";
    var peg$c128 = peg$literalExpectation(",", false);
    var peg$c129 = function (expr, tail) {
        if (expr == null)
            return new ArrayOperand([]);
        var array = [expr];
        if (Array.isArray(tail)) {
            var flatten = flattenArray(tail);
            for (var i = 3; i < flatten.length; i += 4) {
                array.push(flatten[i]);
            }
        }
        return new ArrayOperand(array);
    };
    var peg$c130 = "true";
    var peg$c131 = peg$literalExpectation("true", true);
    var peg$c132 = function () { return true; };
    var peg$c133 = "false";
    var peg$c134 = peg$literalExpectation("false", true);
    var peg$c135 = function () { return false; };
    var peg$c136 = "0x";
    var peg$c137 = peg$literalExpectation("0x", false);
    var peg$c138 = function () { return parseInt(text(), 16); };
    var peg$c139 = /^[\-]/;
    var peg$c140 = peg$classExpectation(["-"], false, false);
    var peg$c141 = function (sign, num) { return sign == null ? num : -num; };
    var peg$c142 = ".";
    var peg$c143 = peg$literalExpectation(".", false);
    var peg$c144 = function () { return parseFloat(text()); };
    var peg$c145 = function () { return parseInt(text(), 10); };
    var peg$c146 = "0";
    var peg$c147 = peg$literalExpectation("0", false);
    var peg$c148 = function () { return 0; };
    var peg$c149 = function (chars) { return chars.join(""); };
    var peg$c150 = "\\'";
    var peg$c151 = peg$literalExpectation("\\'", false);
    var peg$c152 = function () { return "'"; };
    var peg$c153 = "\\\"";
    var peg$c154 = peg$literalExpectation("\\\"", false);
    var peg$c155 = function () { return "\""; };
    var peg$c156 = /^[^"']/;
    var peg$c157 = peg$classExpectation(["\"", "'"], true, false);
    var peg$c158 = function () { return text(); };
    var peg$c159 = /^[^{}]/;
    var peg$c160 = peg$classExpectation(["{", "}"], true, false);
    var peg$c161 = /^[0-9]/;
    var peg$c162 = peg$classExpectation([["0", "9"]], false, false);
    var peg$c163 = /^[1-9]/;
    var peg$c164 = peg$classExpectation([["1", "9"]], false, false);
    var peg$c165 = /^[a-zA-Z_]/;
    var peg$c166 = peg$classExpectation([["a", "z"], ["A", "Z"], "_"], false, false);
    var peg$c167 = peg$otherExpectation("whitespace");
    var peg$c168 = /^[ \t\n\r]/;
    var peg$c169 = peg$classExpectation([" ", "\t", "\n", "\r"], false, false);
    var peg$currPos = 0;
    var peg$savedPos = 0;
    var peg$posDetailsCache = [{ line: 1, column: 1 }];
    var peg$maxFailPos = 0;
    var peg$maxFailExpected = [];
    var peg$silentFails = 0;
    var peg$resultsCache = {};
    var peg$result;
    if (options.startRule !== undefined) {
        if (!(options.startRule in peg$startRuleFunctions)) {
            throw new Error("Can't start parsing from rule \"" + options.startRule + "\".");
        }
        peg$startRuleFunction = peg$startRuleFunctions[options.startRule];
    }
    function text() {
        return input.substring(peg$savedPos, peg$currPos);
    }
    function location() {
        return peg$computeLocation(peg$savedPos, peg$currPos);
    }
    function expected(description, location1) {
        location1 = location1 !== undefined
            ? location1
            : peg$computeLocation(peg$savedPos, peg$currPos);
        throw peg$buildStructuredError([peg$otherExpectation(description)], input.substring(peg$savedPos, peg$currPos), location1);
    }
    function error(message, location1) {
        location1 = location1 !== undefined
            ? location1
            : peg$computeLocation(peg$savedPos, peg$currPos);
        throw peg$buildSimpleError(message, location1);
    }
    function peg$literalExpectation(text1, ignoreCase) {
        return { type: "literal", text: text1, ignoreCase: ignoreCase };
    }
    function peg$classExpectation(parts, inverted, ignoreCase) {
        return { type: "class", parts: parts, inverted: inverted, ignoreCase: ignoreCase };
    }
    function peg$anyExpectation() {
        return { type: "any" };
    }
    function peg$endExpectation() {
        return { type: "end" };
    }
    function peg$otherExpectation(description) {
        return { type: "other", description: description };
    }
    function peg$computePosDetails(pos) {
        var details = peg$posDetailsCache[pos];
        var p;
        if (details) {
            return details;
        }
        else {
            p = pos - 1;
            while (!peg$posDetailsCache[p]) {
                p--;
            }
            details = peg$posDetailsCache[p];
            details = {
                line: details.line,
                column: details.column
            };
            while (p < pos) {
                if (input.charCodeAt(p) === 10) {
                    details.line++;
                    details.column = 1;
                }
                else {
                    details.column++;
                }
                p++;
            }
            peg$posDetailsCache[pos] = details;
            return details;
        }
    }
    function peg$computeLocation(startPos, endPos) {
        var startPosDetails = peg$computePosDetails(startPos);
        var endPosDetails = peg$computePosDetails(endPos);
        return {
            start: {
                offset: startPos,
                line: startPosDetails.line,
                column: startPosDetails.column
            },
            end: {
                offset: endPos,
                line: endPosDetails.line,
                column: endPosDetails.column
            }
        };
    }
    function peg$fail(expected1) {
        if (peg$currPos < peg$maxFailPos) {
            return;
        }
        if (peg$currPos > peg$maxFailPos) {
            peg$maxFailPos = peg$currPos;
            peg$maxFailExpected = [];
        }
        peg$maxFailExpected.push(expected1);
    }
    function peg$buildSimpleError(message, location1) {
        return new SyntaxError(message, [], "", location1);
    }
    function peg$buildStructuredError(expected1, found, location1) {
        return new SyntaxError(SyntaxError.buildMessage(expected1, found), expected1, found, location1);
    }
    function peg$parseExpression() {
        var s0, s1, s2, s3, s4, s5, s6, s7, s8;
        var key = peg$currPos * 34 + 0;
        var cached = peg$resultsCache[key];
        if (cached) {
            peg$currPos = cached.nextPos;
            return cached.result;
        }
        s0 = peg$currPos;
        s1 = peg$parse_();
        if (s1 !== peg$FAILED) {
            s2 = peg$parseLogicOr();
            if (s2 !== peg$FAILED) {
                s3 = [];
                s4 = peg$currPos;
                s5 = peg$parse_();
                if (s5 !== peg$FAILED) {
                    s6 = peg$parseOrSign();
                    if (s6 !== peg$FAILED) {
                        s7 = peg$parse_();
                        if (s7 !== peg$FAILED) {
                            s8 = peg$parseLogicOr();
                            if (s8 !== peg$FAILED) {
                                s5 = [s5, s6, s7, s8];
                                s4 = s5;
                            }
                            else {
                                peg$currPos = s4;
                                s4 = peg$FAILED;
                            }
                        }
                        else {
                            peg$currPos = s4;
                            s4 = peg$FAILED;
                        }
                    }
                    else {
                        peg$currPos = s4;
                        s4 = peg$FAILED;
                    }
                }
                else {
                    peg$currPos = s4;
                    s4 = peg$FAILED;
                }
                while (s4 !== peg$FAILED) {
                    s3.push(s4);
                    s4 = peg$currPos;
                    s5 = peg$parse_();
                    if (s5 !== peg$FAILED) {
                        s6 = peg$parseOrSign();
                        if (s6 !== peg$FAILED) {
                            s7 = peg$parse_();
                            if (s7 !== peg$FAILED) {
                                s8 = peg$parseLogicOr();
                                if (s8 !== peg$FAILED) {
                                    s5 = [s5, s6, s7, s8];
                                    s4 = s5;
                                }
                                else {
                                    peg$currPos = s4;
                                    s4 = peg$FAILED;
                                }
                            }
                            else {
                                peg$currPos = s4;
                                s4 = peg$FAILED;
                            }
                        }
                        else {
                            peg$currPos = s4;
                            s4 = peg$FAILED;
                        }
                    }
                    else {
                        peg$currPos = s4;
                        s4 = peg$FAILED;
                    }
                }
                if (s3 !== peg$FAILED) {
                    s4 = peg$parse_();
                    if (s4 !== peg$FAILED) {
                        peg$savedPos = s0;
                        s1 = peg$c0(s2, s3);
                        s0 = s1;
                    }
                    else {
                        peg$currPos = s0;
                        s0 = peg$FAILED;
                    }
                }
                else {
                    peg$currPos = s0;
                    s0 = peg$FAILED;
                }
            }
            else {
                peg$currPos = s0;
                s0 = peg$FAILED;
            }
        }
        else {
            peg$currPos = s0;
            s0 = peg$FAILED;
        }
        peg$resultsCache[key] = { nextPos: peg$currPos, result: s0 };
        return s0;
    }
    function peg$parseOrSign() {
        var s0, s1;
        var key = peg$currPos * 34 + 1;
        var cached = peg$resultsCache[key];
        if (cached) {
            peg$currPos = cached.nextPos;
            return cached.result;
        }
        s0 = peg$currPos;
        if (input.substr(peg$currPos, 2) === peg$c1) {
            s1 = peg$c1;
            peg$currPos += 2;
        }
        else {
            s1 = peg$FAILED;
            if (peg$silentFails === 0) {
                peg$fail(peg$c2);
            }
        }
        if (s1 === peg$FAILED) {
            if (input.substr(peg$currPos, 2).toLowerCase() === peg$c3) {
                s1 = input.substr(peg$currPos, 2);
                peg$currPos += 2;
            }
            else {
                s1 = peg$FAILED;
                if (peg$silentFails === 0) {
                    peg$fail(peg$c4);
                }
            }
        }
        if (s1 !== peg$FAILED) {
            peg$savedPos = s0;
            s1 = peg$c5();
        }
        s0 = s1;
        peg$resultsCache[key] = { nextPos: peg$currPos, result: s0 };
        return s0;
    }
    function peg$parseLogicOr() {
        var s0, s1, s2, s3, s4, s5, s6, s7;
        var key = peg$currPos * 34 + 2;
        var cached = peg$resultsCache[key];
        if (cached) {
            peg$currPos = cached.nextPos;
            return cached.result;
        }
        s0 = peg$currPos;
        s1 = peg$parseLogicAnd();
        if (s1 !== peg$FAILED) {
            s2 = [];
            s3 = peg$currPos;
            s4 = peg$parse_();
            if (s4 !== peg$FAILED) {
                s5 = peg$parseAndSign();
                if (s5 !== peg$FAILED) {
                    s6 = peg$parse_();
                    if (s6 !== peg$FAILED) {
                        s7 = peg$parseLogicAnd();
                        if (s7 !== peg$FAILED) {
                            s4 = [s4, s5, s6, s7];
                            s3 = s4;
                        }
                        else {
                            peg$currPos = s3;
                            s3 = peg$FAILED;
                        }
                    }
                    else {
                        peg$currPos = s3;
                        s3 = peg$FAILED;
                    }
                }
                else {
                    peg$currPos = s3;
                    s3 = peg$FAILED;
                }
            }
            else {
                peg$currPos = s3;
                s3 = peg$FAILED;
            }
            while (s3 !== peg$FAILED) {
                s2.push(s3);
                s3 = peg$currPos;
                s4 = peg$parse_();
                if (s4 !== peg$FAILED) {
                    s5 = peg$parseAndSign();
                    if (s5 !== peg$FAILED) {
                        s6 = peg$parse_();
                        if (s6 !== peg$FAILED) {
                            s7 = peg$parseLogicAnd();
                            if (s7 !== peg$FAILED) {
                                s4 = [s4, s5, s6, s7];
                                s3 = s4;
                            }
                            else {
                                peg$currPos = s3;
                                s3 = peg$FAILED;
                            }
                        }
                        else {
                            peg$currPos = s3;
                            s3 = peg$FAILED;
                        }
                    }
                    else {
                        peg$currPos = s3;
                        s3 = peg$FAILED;
                    }
                }
                else {
                    peg$currPos = s3;
                    s3 = peg$FAILED;
                }
            }
            if (s2 !== peg$FAILED) {
                peg$savedPos = s0;
                s1 = peg$c0(s1, s2);
                s0 = s1;
            }
            else {
                peg$currPos = s0;
                s0 = peg$FAILED;
            }
        }
        else {
            peg$currPos = s0;
            s0 = peg$FAILED;
        }
        peg$resultsCache[key] = { nextPos: peg$currPos, result: s0 };
        return s0;
    }
    function peg$parseAndSign() {
        var s0, s1;
        var key = peg$currPos * 34 + 3;
        var cached = peg$resultsCache[key];
        if (cached) {
            peg$currPos = cached.nextPos;
            return cached.result;
        }
        s0 = peg$currPos;
        if (input.substr(peg$currPos, 2) === peg$c6) {
            s1 = peg$c6;
            peg$currPos += 2;
        }
        else {
            s1 = peg$FAILED;
            if (peg$silentFails === 0) {
                peg$fail(peg$c7);
            }
        }
        if (s1 === peg$FAILED) {
            if (input.substr(peg$currPos, 3).toLowerCase() === peg$c8) {
                s1 = input.substr(peg$currPos, 3);
                peg$currPos += 3;
            }
            else {
                s1 = peg$FAILED;
                if (peg$silentFails === 0) {
                    peg$fail(peg$c9);
                }
            }
        }
        if (s1 !== peg$FAILED) {
            peg$savedPos = s0;
            s1 = peg$c10();
        }
        s0 = s1;
        peg$resultsCache[key] = { nextPos: peg$currPos, result: s0 };
        return s0;
    }
    function peg$parseLogicAnd() {
        var s0, s1, s2, s3, s4, s5, s6, s7;
        var key = peg$currPos * 34 + 4;
        var cached = peg$resultsCache[key];
        if (cached) {
            peg$currPos = cached.nextPos;
            return cached.result;
        }
        s0 = peg$currPos;
        s1 = peg$parseCompOps();
        if (s1 !== peg$FAILED) {
            s2 = [];
            s3 = peg$currPos;
            s4 = peg$parse_();
            if (s4 !== peg$FAILED) {
                s5 = peg$parseComparableOperators();
                if (s5 !== peg$FAILED) {
                    s6 = peg$parse_();
                    if (s6 !== peg$FAILED) {
                        s7 = peg$parseCompOps();
                        if (s7 !== peg$FAILED) {
                            s4 = [s4, s5, s6, s7];
                            s3 = s4;
                        }
                        else {
                            peg$currPos = s3;
                            s3 = peg$FAILED;
                        }
                    }
                    else {
                        peg$currPos = s3;
                        s3 = peg$FAILED;
                    }
                }
                else {
                    peg$currPos = s3;
                    s3 = peg$FAILED;
                }
            }
            else {
                peg$currPos = s3;
                s3 = peg$FAILED;
            }
            while (s3 !== peg$FAILED) {
                s2.push(s3);
                s3 = peg$currPos;
                s4 = peg$parse_();
                if (s4 !== peg$FAILED) {
                    s5 = peg$parseComparableOperators();
                    if (s5 !== peg$FAILED) {
                        s6 = peg$parse_();
                        if (s6 !== peg$FAILED) {
                            s7 = peg$parseCompOps();
                            if (s7 !== peg$FAILED) {
                                s4 = [s4, s5, s6, s7];
                                s3 = s4;
                            }
                            else {
                                peg$currPos = s3;
                                s3 = peg$FAILED;
                            }
                        }
                        else {
                            peg$currPos = s3;
                            s3 = peg$FAILED;
                        }
                    }
                    else {
                        peg$currPos = s3;
                        s3 = peg$FAILED;
                    }
                }
                else {
                    peg$currPos = s3;
                    s3 = peg$FAILED;
                }
            }
            if (s2 !== peg$FAILED) {
                peg$savedPos = s0;
                s1 = peg$c11(s1, s2);
                s0 = s1;
            }
            else {
                peg$currPos = s0;
                s0 = peg$FAILED;
            }
        }
        else {
            peg$currPos = s0;
            s0 = peg$FAILED;
        }
        peg$resultsCache[key] = { nextPos: peg$currPos, result: s0 };
        return s0;
    }
    function peg$parseComparableOperators() {
        var s0, s1;
        var key = peg$currPos * 34 + 5;
        var cached = peg$resultsCache[key];
        if (cached) {
            peg$currPos = cached.nextPos;
            return cached.result;
        }
        s0 = peg$currPos;
        if (input.substr(peg$currPos, 2) === peg$c12) {
            s1 = peg$c12;
            peg$currPos += 2;
        }
        else {
            s1 = peg$FAILED;
            if (peg$silentFails === 0) {
                peg$fail(peg$c13);
            }
        }
        if (s1 === peg$FAILED) {
            if (input.substr(peg$currPos, 11).toLowerCase() === peg$c14) {
                s1 = input.substr(peg$currPos, 11);
                peg$currPos += 11;
            }
            else {
                s1 = peg$FAILED;
                if (peg$silentFails === 0) {
                    peg$fail(peg$c15);
                }
            }
        }
        if (s1 !== peg$FAILED) {
            peg$savedPos = s0;
            s1 = peg$c16();
        }
        s0 = s1;
        if (s0 === peg$FAILED) {
            s0 = peg$currPos;
            if (input.substr(peg$currPos, 2) === peg$c17) {
                s1 = peg$c17;
                peg$currPos += 2;
            }
            else {
                s1 = peg$FAILED;
                if (peg$silentFails === 0) {
                    peg$fail(peg$c18);
                }
            }
            if (s1 === peg$FAILED) {
                if (input.substr(peg$currPos, 14).toLowerCase() === peg$c19) {
                    s1 = input.substr(peg$currPos, 14);
                    peg$currPos += 14;
                }
                else {
                    s1 = peg$FAILED;
                    if (peg$silentFails === 0) {
                        peg$fail(peg$c20);
                    }
                }
            }
            if (s1 !== peg$FAILED) {
                peg$savedPos = s0;
                s1 = peg$c21();
            }
            s0 = s1;
            if (s0 === peg$FAILED) {
                s0 = peg$currPos;
                if (input.substr(peg$currPos, 2) === peg$c22) {
                    s1 = peg$c22;
                    peg$currPos += 2;
                }
                else {
                    s1 = peg$FAILED;
                    if (peg$silentFails === 0) {
                        peg$fail(peg$c23);
                    }
                }
                if (s1 === peg$FAILED) {
                    if (input.substr(peg$currPos, 5).toLowerCase() === peg$c24) {
                        s1 = input.substr(peg$currPos, 5);
                        peg$currPos += 5;
                    }
                    else {
                        s1 = peg$FAILED;
                        if (peg$silentFails === 0) {
                            peg$fail(peg$c25);
                        }
                    }
                }
                if (s1 !== peg$FAILED) {
                    peg$savedPos = s0;
                    s1 = peg$c26();
                }
                s0 = s1;
                if (s0 === peg$FAILED) {
                    s0 = peg$currPos;
                    if (input.charCodeAt(peg$currPos) === 61) {
                        s1 = peg$c27;
                        peg$currPos++;
                    }
                    else {
                        s1 = peg$FAILED;
                        if (peg$silentFails === 0) {
                            peg$fail(peg$c28);
                        }
                    }
                    if (s1 === peg$FAILED) {
                        if (input.substr(peg$currPos, 5).toLowerCase() === peg$c24) {
                            s1 = input.substr(peg$currPos, 5);
                            peg$currPos += 5;
                        }
                        else {
                            s1 = peg$FAILED;
                            if (peg$silentFails === 0) {
                                peg$fail(peg$c25);
                            }
                        }
                    }
                    if (s1 !== peg$FAILED) {
                        peg$savedPos = s0;
                        s1 = peg$c26();
                    }
                    s0 = s1;
                    if (s0 === peg$FAILED) {
                        s0 = peg$currPos;
                        if (input.substr(peg$currPos, 2) === peg$c29) {
                            s1 = peg$c29;
                            peg$currPos += 2;
                        }
                        else {
                            s1 = peg$FAILED;
                            if (peg$silentFails === 0) {
                                peg$fail(peg$c30);
                            }
                        }
                        if (s1 === peg$FAILED) {
                            if (input.substr(peg$currPos, 8).toLowerCase() === peg$c31) {
                                s1 = input.substr(peg$currPos, 8);
                                peg$currPos += 8;
                            }
                            else {
                                s1 = peg$FAILED;
                                if (peg$silentFails === 0) {
                                    peg$fail(peg$c32);
                                }
                            }
                        }
                        if (s1 !== peg$FAILED) {
                            peg$savedPos = s0;
                            s1 = peg$c33();
                        }
                        s0 = s1;
                        if (s0 === peg$FAILED) {
                            s0 = peg$currPos;
                            if (input.charCodeAt(peg$currPos) === 60) {
                                s1 = peg$c34;
                                peg$currPos++;
                            }
                            else {
                                s1 = peg$FAILED;
                                if (peg$silentFails === 0) {
                                    peg$fail(peg$c35);
                                }
                            }
                            if (s1 === peg$FAILED) {
                                if (input.substr(peg$currPos, 4).toLowerCase() === peg$c36) {
                                    s1 = input.substr(peg$currPos, 4);
                                    peg$currPos += 4;
                                }
                                else {
                                    s1 = peg$FAILED;
                                    if (peg$silentFails === 0) {
                                        peg$fail(peg$c37);
                                    }
                                }
                            }
                            if (s1 !== peg$FAILED) {
                                peg$savedPos = s0;
                                s1 = peg$c38();
                            }
                            s0 = s1;
                            if (s0 === peg$FAILED) {
                                s0 = peg$currPos;
                                if (input.charCodeAt(peg$currPos) === 62) {
                                    s1 = peg$c39;
                                    peg$currPos++;
                                }
                                else {
                                    s1 = peg$FAILED;
                                    if (peg$silentFails === 0) {
                                        peg$fail(peg$c40);
                                    }
                                }
                                if (s1 === peg$FAILED) {
                                    if (input.substr(peg$currPos, 7).toLowerCase() === peg$c41) {
                                        s1 = input.substr(peg$currPos, 7);
                                        peg$currPos += 7;
                                    }
                                    else {
                                        s1 = peg$FAILED;
                                        if (peg$silentFails === 0) {
                                            peg$fail(peg$c42);
                                        }
                                    }
                                }
                                if (s1 !== peg$FAILED) {
                                    peg$savedPos = s0;
                                    s1 = peg$c43();
                                }
                                s0 = s1;
                            }
                        }
                    }
                }
            }
        }
        peg$resultsCache[key] = { nextPos: peg$currPos, result: s0 };
        return s0;
    }
    function peg$parseCompOps() {
        var s0, s1, s2, s3, s4, s5, s6, s7;
        var key = peg$currPos * 34 + 6;
        var cached = peg$resultsCache[key];
        if (cached) {
            peg$currPos = cached.nextPos;
            return cached.result;
        }
        s0 = peg$currPos;
        s1 = peg$parsePlusMinusOps();
        if (s1 !== peg$FAILED) {
            s2 = [];
            s3 = peg$currPos;
            s4 = peg$parse_();
            if (s4 !== peg$FAILED) {
                s5 = peg$parsePlusMinusSigns();
                if (s5 !== peg$FAILED) {
                    s6 = peg$parse_();
                    if (s6 !== peg$FAILED) {
                        s7 = peg$parsePlusMinusOps();
                        if (s7 !== peg$FAILED) {
                            s4 = [s4, s5, s6, s7];
                            s3 = s4;
                        }
                        else {
                            peg$currPos = s3;
                            s3 = peg$FAILED;
                        }
                    }
                    else {
                        peg$currPos = s3;
                        s3 = peg$FAILED;
                    }
                }
                else {
                    peg$currPos = s3;
                    s3 = peg$FAILED;
                }
            }
            else {
                peg$currPos = s3;
                s3 = peg$FAILED;
            }
            while (s3 !== peg$FAILED) {
                s2.push(s3);
                s3 = peg$currPos;
                s4 = peg$parse_();
                if (s4 !== peg$FAILED) {
                    s5 = peg$parsePlusMinusSigns();
                    if (s5 !== peg$FAILED) {
                        s6 = peg$parse_();
                        if (s6 !== peg$FAILED) {
                            s7 = peg$parsePlusMinusOps();
                            if (s7 !== peg$FAILED) {
                                s4 = [s4, s5, s6, s7];
                                s3 = s4;
                            }
                            else {
                                peg$currPos = s3;
                                s3 = peg$FAILED;
                            }
                        }
                        else {
                            peg$currPos = s3;
                            s3 = peg$FAILED;
                        }
                    }
                    else {
                        peg$currPos = s3;
                        s3 = peg$FAILED;
                    }
                }
                else {
                    peg$currPos = s3;
                    s3 = peg$FAILED;
                }
            }
            if (s2 !== peg$FAILED) {
                peg$savedPos = s0;
                s1 = peg$c0(s1, s2);
                s0 = s1;
            }
            else {
                peg$currPos = s0;
                s0 = peg$FAILED;
            }
        }
        else {
            peg$currPos = s0;
            s0 = peg$FAILED;
        }
        peg$resultsCache[key] = { nextPos: peg$currPos, result: s0 };
        return s0;
    }
    function peg$parsePlusMinusSigns() {
        var s0, s1;
        var key = peg$currPos * 34 + 7;
        var cached = peg$resultsCache[key];
        if (cached) {
            peg$currPos = cached.nextPos;
            return cached.result;
        }
        s0 = peg$currPos;
        if (input.charCodeAt(peg$currPos) === 43) {
            s1 = peg$c44;
            peg$currPos++;
        }
        else {
            s1 = peg$FAILED;
            if (peg$silentFails === 0) {
                peg$fail(peg$c45);
            }
        }
        if (s1 !== peg$FAILED) {
            peg$savedPos = s0;
            s1 = peg$c46();
        }
        s0 = s1;
        if (s0 === peg$FAILED) {
            s0 = peg$currPos;
            if (input.charCodeAt(peg$currPos) === 45) {
                s1 = peg$c47;
                peg$currPos++;
            }
            else {
                s1 = peg$FAILED;
                if (peg$silentFails === 0) {
                    peg$fail(peg$c48);
                }
            }
            if (s1 !== peg$FAILED) {
                peg$savedPos = s0;
                s1 = peg$c49();
            }
            s0 = s1;
        }
        peg$resultsCache[key] = { nextPos: peg$currPos, result: s0 };
        return s0;
    }
    function peg$parsePlusMinusOps() {
        var s0, s1, s2, s3, s4, s5, s6, s7;
        var key = peg$currPos * 34 + 8;
        var cached = peg$resultsCache[key];
        if (cached) {
            peg$currPos = cached.nextPos;
            return cached.result;
        }
        s0 = peg$currPos;
        s1 = peg$parseMulDivOps();
        if (s1 !== peg$FAILED) {
            s2 = [];
            s3 = peg$currPos;
            s4 = peg$parse_();
            if (s4 !== peg$FAILED) {
                s5 = peg$parseMulDivSigns();
                if (s5 !== peg$FAILED) {
                    s6 = peg$parse_();
                    if (s6 !== peg$FAILED) {
                        s7 = peg$parseMulDivOps();
                        if (s7 !== peg$FAILED) {
                            s4 = [s4, s5, s6, s7];
                            s3 = s4;
                        }
                        else {
                            peg$currPos = s3;
                            s3 = peg$FAILED;
                        }
                    }
                    else {
                        peg$currPos = s3;
                        s3 = peg$FAILED;
                    }
                }
                else {
                    peg$currPos = s3;
                    s3 = peg$FAILED;
                }
            }
            else {
                peg$currPos = s3;
                s3 = peg$FAILED;
            }
            while (s3 !== peg$FAILED) {
                s2.push(s3);
                s3 = peg$currPos;
                s4 = peg$parse_();
                if (s4 !== peg$FAILED) {
                    s5 = peg$parseMulDivSigns();
                    if (s5 !== peg$FAILED) {
                        s6 = peg$parse_();
                        if (s6 !== peg$FAILED) {
                            s7 = peg$parseMulDivOps();
                            if (s7 !== peg$FAILED) {
                                s4 = [s4, s5, s6, s7];
                                s3 = s4;
                            }
                            else {
                                peg$currPos = s3;
                                s3 = peg$FAILED;
                            }
                        }
                        else {
                            peg$currPos = s3;
                            s3 = peg$FAILED;
                        }
                    }
                    else {
                        peg$currPos = s3;
                        s3 = peg$FAILED;
                    }
                }
                else {
                    peg$currPos = s3;
                    s3 = peg$FAILED;
                }
            }
            if (s2 !== peg$FAILED) {
                peg$savedPos = s0;
                s1 = peg$c0(s1, s2);
                s0 = s1;
            }
            else {
                peg$currPos = s0;
                s0 = peg$FAILED;
            }
        }
        else {
            peg$currPos = s0;
            s0 = peg$FAILED;
        }
        peg$resultsCache[key] = { nextPos: peg$currPos, result: s0 };
        return s0;
    }
    function peg$parseMulDivSigns() {
        var s0, s1;
        var key = peg$currPos * 34 + 9;
        var cached = peg$resultsCache[key];
        if (cached) {
            peg$currPos = cached.nextPos;
            return cached.result;
        }
        s0 = peg$currPos;
        if (input.charCodeAt(peg$currPos) === 42) {
            s1 = peg$c50;
            peg$currPos++;
        }
        else {
            s1 = peg$FAILED;
            if (peg$silentFails === 0) {
                peg$fail(peg$c51);
            }
        }
        if (s1 !== peg$FAILED) {
            peg$savedPos = s0;
            s1 = peg$c52();
        }
        s0 = s1;
        if (s0 === peg$FAILED) {
            s0 = peg$currPos;
            if (input.charCodeAt(peg$currPos) === 47) {
                s1 = peg$c53;
                peg$currPos++;
            }
            else {
                s1 = peg$FAILED;
                if (peg$silentFails === 0) {
                    peg$fail(peg$c54);
                }
            }
            if (s1 !== peg$FAILED) {
                peg$savedPos = s0;
                s1 = peg$c55();
            }
            s0 = s1;
            if (s0 === peg$FAILED) {
                s0 = peg$currPos;
                if (input.charCodeAt(peg$currPos) === 37) {
                    s1 = peg$c56;
                    peg$currPos++;
                }
                else {
                    s1 = peg$FAILED;
                    if (peg$silentFails === 0) {
                        peg$fail(peg$c57);
                    }
                }
                if (s1 !== peg$FAILED) {
                    peg$savedPos = s0;
                    s1 = peg$c58();
                }
                s0 = s1;
            }
        }
        peg$resultsCache[key] = { nextPos: peg$currPos, result: s0 };
        return s0;
    }
    function peg$parseMulDivOps() {
        var s0, s1, s2, s3, s4, s5, s6, s7;
        var key = peg$currPos * 34 + 10;
        var cached = peg$resultsCache[key];
        if (cached) {
            peg$currPos = cached.nextPos;
            return cached.result;
        }
        s0 = peg$currPos;
        s1 = peg$parseBinaryFuncOp();
        if (s1 !== peg$FAILED) {
            s2 = [];
            s3 = peg$currPos;
            s4 = peg$parse_();
            if (s4 !== peg$FAILED) {
                s5 = peg$parsePowerSigns();
                if (s5 !== peg$FAILED) {
                    s6 = peg$parse_();
                    if (s6 !== peg$FAILED) {
                        s7 = peg$parseBinaryFuncOp();
                        if (s7 !== peg$FAILED) {
                            s4 = [s4, s5, s6, s7];
                            s3 = s4;
                        }
                        else {
                            peg$currPos = s3;
                            s3 = peg$FAILED;
                        }
                    }
                    else {
                        peg$currPos = s3;
                        s3 = peg$FAILED;
                    }
                }
                else {
                    peg$currPos = s3;
                    s3 = peg$FAILED;
                }
            }
            else {
                peg$currPos = s3;
                s3 = peg$FAILED;
            }
            while (s3 !== peg$FAILED) {
                s2.push(s3);
                s3 = peg$currPos;
                s4 = peg$parse_();
                if (s4 !== peg$FAILED) {
                    s5 = peg$parsePowerSigns();
                    if (s5 !== peg$FAILED) {
                        s6 = peg$parse_();
                        if (s6 !== peg$FAILED) {
                            s7 = peg$parseBinaryFuncOp();
                            if (s7 !== peg$FAILED) {
                                s4 = [s4, s5, s6, s7];
                                s3 = s4;
                            }
                            else {
                                peg$currPos = s3;
                                s3 = peg$FAILED;
                            }
                        }
                        else {
                            peg$currPos = s3;
                            s3 = peg$FAILED;
                        }
                    }
                    else {
                        peg$currPos = s3;
                        s3 = peg$FAILED;
                    }
                }
                else {
                    peg$currPos = s3;
                    s3 = peg$FAILED;
                }
            }
            if (s2 !== peg$FAILED) {
                peg$savedPos = s0;
                s1 = peg$c0(s1, s2);
                s0 = s1;
            }
            else {
                peg$currPos = s0;
                s0 = peg$FAILED;
            }
        }
        else {
            peg$currPos = s0;
            s0 = peg$FAILED;
        }
        peg$resultsCache[key] = { nextPos: peg$currPos, result: s0 };
        return s0;
    }
    function peg$parsePowerSigns() {
        var s0, s1;
        var key = peg$currPos * 34 + 11;
        var cached = peg$resultsCache[key];
        if (cached) {
            peg$currPos = cached.nextPos;
            return cached.result;
        }
        s0 = peg$currPos;
        if (input.charCodeAt(peg$currPos) === 94) {
            s1 = peg$c59;
            peg$currPos++;
        }
        else {
            s1 = peg$FAILED;
            if (peg$silentFails === 0) {
                peg$fail(peg$c60);
            }
        }
        if (s1 === peg$FAILED) {
            if (input.substr(peg$currPos, 5).toLowerCase() === peg$c61) {
                s1 = input.substr(peg$currPos, 5);
                peg$currPos += 5;
            }
            else {
                s1 = peg$FAILED;
                if (peg$silentFails === 0) {
                    peg$fail(peg$c62);
                }
            }
        }
        if (s1 !== peg$FAILED) {
            peg$savedPos = s0;
            s1 = peg$c63();
        }
        s0 = s1;
        peg$resultsCache[key] = { nextPos: peg$currPos, result: s0 };
        return s0;
    }
    function peg$parseBinaryFuncOp() {
        var s0, s1, s2, s3, s4, s5, s6, s7;
        var key = peg$currPos * 34 + 12;
        var cached = peg$resultsCache[key];
        if (cached) {
            peg$currPos = cached.nextPos;
            return cached.result;
        }
        s0 = peg$currPos;
        s1 = peg$parseFactor();
        if (s1 !== peg$FAILED) {
            s2 = [];
            s3 = peg$currPos;
            s4 = peg$parse_();
            if (s4 !== peg$FAILED) {
                s5 = peg$parseBinFunctions();
                if (s5 !== peg$FAILED) {
                    s6 = peg$parse_();
                    if (s6 !== peg$FAILED) {
                        s7 = peg$parseFactor();
                        if (s7 === peg$FAILED) {
                            s7 = null;
                        }
                        if (s7 !== peg$FAILED) {
                            s4 = [s4, s5, s6, s7];
                            s3 = s4;
                        }
                        else {
                            peg$currPos = s3;
                            s3 = peg$FAILED;
                        }
                    }
                    else {
                        peg$currPos = s3;
                        s3 = peg$FAILED;
                    }
                }
                else {
                    peg$currPos = s3;
                    s3 = peg$FAILED;
                }
            }
            else {
                peg$currPos = s3;
                s3 = peg$FAILED;
            }
            while (s3 !== peg$FAILED) {
                s2.push(s3);
                s3 = peg$currPos;
                s4 = peg$parse_();
                if (s4 !== peg$FAILED) {
                    s5 = peg$parseBinFunctions();
                    if (s5 !== peg$FAILED) {
                        s6 = peg$parse_();
                        if (s6 !== peg$FAILED) {
                            s7 = peg$parseFactor();
                            if (s7 === peg$FAILED) {
                                s7 = null;
                            }
                            if (s7 !== peg$FAILED) {
                                s4 = [s4, s5, s6, s7];
                                s3 = s4;
                            }
                            else {
                                peg$currPos = s3;
                                s3 = peg$FAILED;
                            }
                        }
                        else {
                            peg$currPos = s3;
                            s3 = peg$FAILED;
                        }
                    }
                    else {
                        peg$currPos = s3;
                        s3 = peg$FAILED;
                    }
                }
                else {
                    peg$currPos = s3;
                    s3 = peg$FAILED;
                }
            }
            if (s2 !== peg$FAILED) {
                peg$savedPos = s0;
                s1 = peg$c11(s1, s2);
                s0 = s1;
            }
            else {
                peg$currPos = s0;
                s0 = peg$FAILED;
            }
        }
        else {
            peg$currPos = s0;
            s0 = peg$FAILED;
        }
        peg$resultsCache[key] = { nextPos: peg$currPos, result: s0 };
        return s0;
    }
    function peg$parseBinFunctions() {
        var s0, s1;
        var key = peg$currPos * 34 + 13;
        var cached = peg$resultsCache[key];
        if (cached) {
            peg$currPos = cached.nextPos;
            return cached.result;
        }
        s0 = peg$currPos;
        if (input.substr(peg$currPos, 2) === peg$c64) {
            s1 = peg$c64;
            peg$currPos += 2;
        }
        else {
            s1 = peg$FAILED;
            if (peg$silentFails === 0) {
                peg$fail(peg$c65);
            }
        }
        if (s1 === peg$FAILED) {
            if (input.substr(peg$currPos, 8).toLowerCase() === peg$c66) {
                s1 = input.substr(peg$currPos, 8);
                peg$currPos += 8;
            }
            else {
                s1 = peg$FAILED;
                if (peg$silentFails === 0) {
                    peg$fail(peg$c67);
                }
            }
            if (s1 === peg$FAILED) {
                if (input.substr(peg$currPos, 7).toLowerCase() === peg$c68) {
                    s1 = input.substr(peg$currPos, 7);
                    peg$currPos += 7;
                }
                else {
                    s1 = peg$FAILED;
                    if (peg$silentFails === 0) {
                        peg$fail(peg$c69);
                    }
                }
            }
        }
        if (s1 !== peg$FAILED) {
            peg$savedPos = s0;
            s1 = peg$c70();
        }
        s0 = s1;
        if (s0 === peg$FAILED) {
            s0 = peg$currPos;
            if (input.substr(peg$currPos, 11).toLowerCase() === peg$c71) {
                s1 = input.substr(peg$currPos, 11);
                peg$currPos += 11;
            }
            else {
                s1 = peg$FAILED;
                if (peg$silentFails === 0) {
                    peg$fail(peg$c72);
                }
            }
            if (s1 === peg$FAILED) {
                if (input.substr(peg$currPos, 10).toLowerCase() === peg$c73) {
                    s1 = input.substr(peg$currPos, 10);
                    peg$currPos += 10;
                }
                else {
                    s1 = peg$FAILED;
                    if (peg$silentFails === 0) {
                        peg$fail(peg$c74);
                    }
                }
            }
            if (s1 !== peg$FAILED) {
                peg$savedPos = s0;
                s1 = peg$c75();
            }
            s0 = s1;
            if (s0 === peg$FAILED) {
                s0 = peg$currPos;
                if (input.substr(peg$currPos, 5).toLowerCase() === peg$c76) {
                    s1 = input.substr(peg$currPos, 5);
                    peg$currPos += 5;
                }
                else {
                    s1 = peg$FAILED;
                    if (peg$silentFails === 0) {
                        peg$fail(peg$c77);
                    }
                }
                if (s1 !== peg$FAILED) {
                    peg$savedPos = s0;
                    s1 = peg$c78();
                }
                s0 = s1;
                if (s0 === peg$FAILED) {
                    s0 = peg$currPos;
                    if (input.substr(peg$currPos, 5).toLowerCase() === peg$c79) {
                        s1 = input.substr(peg$currPos, 5);
                        peg$currPos += 5;
                    }
                    else {
                        s1 = peg$FAILED;
                        if (peg$silentFails === 0) {
                            peg$fail(peg$c80);
                        }
                    }
                    if (s1 !== peg$FAILED) {
                        peg$savedPos = s0;
                        s1 = peg$c81();
                    }
                    s0 = s1;
                }
            }
        }
        peg$resultsCache[key] = { nextPos: peg$currPos, result: s0 };
        return s0;
    }
    function peg$parseFactor() {
        var s0, s1, s2, s3, s4, s5;
        var key = peg$currPos * 34 + 14;
        var cached = peg$resultsCache[key];
        if (cached) {
            peg$currPos = cached.nextPos;
            return cached.result;
        }
        s0 = peg$currPos;
        if (input.charCodeAt(peg$currPos) === 40) {
            s1 = peg$c82;
            peg$currPos++;
        }
        else {
            s1 = peg$FAILED;
            if (peg$silentFails === 0) {
                peg$fail(peg$c83);
            }
        }
        if (s1 !== peg$FAILED) {
            s2 = peg$parse_();
            if (s2 !== peg$FAILED) {
                s3 = peg$parseExpression();
                if (s3 !== peg$FAILED) {
                    s4 = peg$parse_();
                    if (s4 !== peg$FAILED) {
                        if (input.charCodeAt(peg$currPos) === 41) {
                            s5 = peg$c84;
                            peg$currPos++;
                        }
                        else {
                            s5 = peg$FAILED;
                            if (peg$silentFails === 0) {
                                peg$fail(peg$c85);
                            }
                        }
                        if (s5 === peg$FAILED) {
                            s5 = null;
                        }
                        if (s5 !== peg$FAILED) {
                            peg$savedPos = s0;
                            s1 = peg$c86(s3);
                            s0 = s1;
                        }
                        else {
                            peg$currPos = s0;
                            s0 = peg$FAILED;
                        }
                    }
                    else {
                        peg$currPos = s0;
                        s0 = peg$FAILED;
                    }
                }
                else {
                    peg$currPos = s0;
                    s0 = peg$FAILED;
                }
            }
            else {
                peg$currPos = s0;
                s0 = peg$FAILED;
            }
        }
        else {
            peg$currPos = s0;
            s0 = peg$FAILED;
        }
        if (s0 === peg$FAILED) {
            s0 = peg$parseFunctionOp();
            if (s0 === peg$FAILED) {
                s0 = peg$parseUnaryFunctionOp();
                if (s0 === peg$FAILED) {
                    s0 = peg$parseAtom();
                    if (s0 === peg$FAILED) {
                        s0 = peg$parseArrayOp();
                    }
                }
            }
        }
        peg$resultsCache[key] = { nextPos: peg$currPos, result: s0 };
        return s0;
    }
    function peg$parseFunctionOp() {
        var s0, s1, s2, s3, s4;
        var key = peg$currPos * 34 + 15;
        var cached = peg$resultsCache[key];
        if (cached) {
            peg$currPos = cached.nextPos;
            return cached.result;
        }
        s0 = peg$currPos;
        s1 = peg$parseLettersAndDigits();
        if (s1 !== peg$FAILED) {
            if (input.charCodeAt(peg$currPos) === 40) {
                s2 = peg$c82;
                peg$currPos++;
            }
            else {
                s2 = peg$FAILED;
                if (peg$silentFails === 0) {
                    peg$fail(peg$c83);
                }
            }
            if (s2 !== peg$FAILED) {
                s3 = peg$parseSequence();
                if (s3 !== peg$FAILED) {
                    if (input.charCodeAt(peg$currPos) === 41) {
                        s4 = peg$c84;
                        peg$currPos++;
                    }
                    else {
                        s4 = peg$FAILED;
                        if (peg$silentFails === 0) {
                            peg$fail(peg$c85);
                        }
                    }
                    if (s4 === peg$FAILED) {
                        s4 = null;
                    }
                    if (s4 !== peg$FAILED) {
                        peg$savedPos = s0;
                        s1 = peg$c87(s1, s3);
                        s0 = s1;
                    }
                    else {
                        peg$currPos = s0;
                        s0 = peg$FAILED;
                    }
                }
                else {
                    peg$currPos = s0;
                    s0 = peg$FAILED;
                }
            }
            else {
                peg$currPos = s0;
                s0 = peg$FAILED;
            }
        }
        else {
            peg$currPos = s0;
            s0 = peg$FAILED;
        }
        peg$resultsCache[key] = { nextPos: peg$currPos, result: s0 };
        return s0;
    }
    function peg$parseUnaryFunctionOp() {
        var s0, s1, s2, s3;
        var key = peg$currPos * 34 + 16;
        var cached = peg$resultsCache[key];
        if (cached) {
            peg$currPos = cached.nextPos;
            return cached.result;
        }
        s0 = peg$currPos;
        if (input.charCodeAt(peg$currPos) === 33) {
            s1 = peg$c88;
            peg$currPos++;
        }
        else {
            s1 = peg$FAILED;
            if (peg$silentFails === 0) {
                peg$fail(peg$c89);
            }
        }
        if (s1 === peg$FAILED) {
            if (input.substr(peg$currPos, 6).toLowerCase() === peg$c90) {
                s1 = input.substr(peg$currPos, 6);
                peg$currPos += 6;
            }
            else {
                s1 = peg$FAILED;
                if (peg$silentFails === 0) {
                    peg$fail(peg$c91);
                }
            }
        }
        if (s1 !== peg$FAILED) {
            s2 = peg$parse_();
            if (s2 !== peg$FAILED) {
                s3 = peg$parseExpression();
                if (s3 !== peg$FAILED) {
                    peg$savedPos = s0;
                    s1 = peg$c92(s3);
                    s0 = s1;
                }
                else {
                    peg$currPos = s0;
                    s0 = peg$FAILED;
                }
            }
            else {
                peg$currPos = s0;
                s0 = peg$FAILED;
            }
        }
        else {
            peg$currPos = s0;
            s0 = peg$FAILED;
        }
        if (s0 === peg$FAILED) {
            s0 = peg$currPos;
            s1 = peg$parseAtom();
            if (s1 !== peg$FAILED) {
                s2 = peg$parse_();
                if (s2 !== peg$FAILED) {
                    s3 = peg$parseUnFunctions();
                    if (s3 !== peg$FAILED) {
                        peg$savedPos = s0;
                        s1 = peg$c93(s1, s3);
                        s0 = s1;
                    }
                    else {
                        peg$currPos = s0;
                        s0 = peg$FAILED;
                    }
                }
                else {
                    peg$currPos = s0;
                    s0 = peg$FAILED;
                }
            }
            else {
                peg$currPos = s0;
                s0 = peg$FAILED;
            }
        }
        peg$resultsCache[key] = { nextPos: peg$currPos, result: s0 };
        return s0;
    }
    function peg$parseUnFunctions() {
        var s0, s1;
        var key = peg$currPos * 34 + 17;
        var cached = peg$resultsCache[key];
        if (cached) {
            peg$currPos = cached.nextPos;
            return cached.result;
        }
        s0 = peg$currPos;
        if (input.substr(peg$currPos, 5).toLowerCase() === peg$c94) {
            s1 = input.substr(peg$currPos, 5);
            peg$currPos += 5;
        }
        else {
            s1 = peg$FAILED;
            if (peg$silentFails === 0) {
                peg$fail(peg$c95);
            }
        }
        if (s1 !== peg$FAILED) {
            peg$savedPos = s0;
            s1 = peg$c96();
        }
        s0 = s1;
        if (s0 === peg$FAILED) {
            s0 = peg$currPos;
            if (input.substr(peg$currPos, 8).toLowerCase() === peg$c97) {
                s1 = input.substr(peg$currPos, 8);
                peg$currPos += 8;
            }
            else {
                s1 = peg$FAILED;
                if (peg$silentFails === 0) {
                    peg$fail(peg$c98);
                }
            }
            if (s1 !== peg$FAILED) {
                peg$savedPos = s0;
                s1 = peg$c99();
            }
            s0 = s1;
        }
        peg$resultsCache[key] = { nextPos: peg$currPos, result: s0 };
        return s0;
    }
    function peg$parseAtom() {
        var s0, s1, s2, s3, s4;
        var key = peg$currPos * 34 + 18;
        var cached = peg$resultsCache[key];
        if (cached) {
            peg$currPos = cached.nextPos;
            return cached.result;
        }
        s0 = peg$currPos;
        s1 = peg$parse_();
        if (s1 !== peg$FAILED) {
            if (input.substr(peg$currPos, 9) === peg$c100) {
                s2 = peg$c100;
                peg$currPos += 9;
            }
            else {
                s2 = peg$FAILED;
                if (peg$silentFails === 0) {
                    peg$fail(peg$c101);
                }
            }
            if (s2 === peg$FAILED) {
                if (input.substr(peg$currPos, 4) === peg$c102) {
                    s2 = peg$c102;
                    peg$currPos += 4;
                }
                else {
                    s2 = peg$FAILED;
                    if (peg$silentFails === 0) {
                        peg$fail(peg$c103);
                    }
                }
            }
            if (s2 !== peg$FAILED) {
                peg$savedPos = s0;
                s1 = peg$c104();
                s0 = s1;
            }
            else {
                peg$currPos = s0;
                s0 = peg$FAILED;
            }
        }
        else {
            peg$currPos = s0;
            s0 = peg$FAILED;
        }
        if (s0 === peg$FAILED) {
            s0 = peg$currPos;
            s1 = peg$parse_();
            if (s1 !== peg$FAILED) {
                s2 = peg$parseConstValue();
                if (s2 !== peg$FAILED) {
                    peg$savedPos = s0;
                    s1 = peg$c105(s2);
                    s0 = s1;
                }
                else {
                    peg$currPos = s0;
                    s0 = peg$FAILED;
                }
            }
            else {
                peg$currPos = s0;
                s0 = peg$FAILED;
            }
            if (s0 === peg$FAILED) {
                s0 = peg$currPos;
                s1 = peg$parse_();
                if (s1 !== peg$FAILED) {
                    if (input.charCodeAt(peg$currPos) === 123) {
                        s2 = peg$c106;
                        peg$currPos++;
                    }
                    else {
                        s2 = peg$FAILED;
                        if (peg$silentFails === 0) {
                            peg$fail(peg$c107);
                        }
                    }
                    if (s2 !== peg$FAILED) {
                        s3 = peg$parseValueInput();
                        if (s3 !== peg$FAILED) {
                            if (input.charCodeAt(peg$currPos) === 125) {
                                s4 = peg$c108;
                                peg$currPos++;
                            }
                            else {
                                s4 = peg$FAILED;
                                if (peg$silentFails === 0) {
                                    peg$fail(peg$c109);
                                }
                            }
                            if (s4 !== peg$FAILED) {
                                peg$savedPos = s0;
                                s1 = peg$c110(s3);
                                s0 = s1;
                            }
                            else {
                                peg$currPos = s0;
                                s0 = peg$FAILED;
                            }
                        }
                        else {
                            peg$currPos = s0;
                            s0 = peg$FAILED;
                        }
                    }
                    else {
                        peg$currPos = s0;
                        s0 = peg$FAILED;
                    }
                }
                else {
                    peg$currPos = s0;
                    s0 = peg$FAILED;
                }
            }
        }
        peg$resultsCache[key] = { nextPos: peg$currPos, result: s0 };
        return s0;
    }
    function peg$parseConstValue() {
        var s0, s1, s2, s3;
        var key = peg$currPos * 34 + 19;
        var cached = peg$resultsCache[key];
        if (cached) {
            peg$currPos = cached.nextPos;
            return cached.result;
        }
        s0 = peg$currPos;
        s1 = peg$parseLogicValue();
        if (s1 !== peg$FAILED) {
            peg$savedPos = s0;
            s1 = peg$c111(s1);
        }
        s0 = s1;
        if (s0 === peg$FAILED) {
            s0 = peg$currPos;
            s1 = peg$parseArithmeticValue();
            if (s1 !== peg$FAILED) {
                peg$savedPos = s0;
                s1 = peg$c111(s1);
            }
            s0 = s1;
            if (s0 === peg$FAILED) {
                s0 = peg$currPos;
                s1 = peg$parseLettersAndDigits();
                if (s1 !== peg$FAILED) {
                    peg$savedPos = s0;
                    s1 = peg$c111(s1);
                }
                s0 = s1;
                if (s0 === peg$FAILED) {
                    s0 = peg$currPos;
                    if (input.substr(peg$currPos, 2) === peg$c112) {
                        s1 = peg$c112;
                        peg$currPos += 2;
                    }
                    else {
                        s1 = peg$FAILED;
                        if (peg$silentFails === 0) {
                            peg$fail(peg$c113);
                        }
                    }
                    if (s1 !== peg$FAILED) {
                        peg$savedPos = s0;
                        s1 = peg$c114();
                    }
                    s0 = s1;
                    if (s0 === peg$FAILED) {
                        s0 = peg$currPos;
                        if (input.substr(peg$currPos, 2) === peg$c115) {
                            s1 = peg$c115;
                            peg$currPos += 2;
                        }
                        else {
                            s1 = peg$FAILED;
                            if (peg$silentFails === 0) {
                                peg$fail(peg$c116);
                            }
                        }
                        if (s1 !== peg$FAILED) {
                            peg$savedPos = s0;
                            s1 = peg$c114();
                        }
                        s0 = s1;
                        if (s0 === peg$FAILED) {
                            s0 = peg$currPos;
                            if (input.charCodeAt(peg$currPos) === 39) {
                                s1 = peg$c117;
                                peg$currPos++;
                            }
                            else {
                                s1 = peg$FAILED;
                                if (peg$silentFails === 0) {
                                    peg$fail(peg$c118);
                                }
                            }
                            if (s1 !== peg$FAILED) {
                                s2 = peg$parseAnyInput();
                                if (s2 !== peg$FAILED) {
                                    if (input.charCodeAt(peg$currPos) === 39) {
                                        s3 = peg$c117;
                                        peg$currPos++;
                                    }
                                    else {
                                        s3 = peg$FAILED;
                                        if (peg$silentFails === 0) {
                                            peg$fail(peg$c118);
                                        }
                                    }
                                    if (s3 !== peg$FAILED) {
                                        peg$savedPos = s0;
                                        s1 = peg$c119(s2);
                                        s0 = s1;
                                    }
                                    else {
                                        peg$currPos = s0;
                                        s0 = peg$FAILED;
                                    }
                                }
                                else {
                                    peg$currPos = s0;
                                    s0 = peg$FAILED;
                                }
                            }
                            else {
                                peg$currPos = s0;
                                s0 = peg$FAILED;
                            }
                            if (s0 === peg$FAILED) {
                                s0 = peg$currPos;
                                if (input.charCodeAt(peg$currPos) === 34) {
                                    s1 = peg$c120;
                                    peg$currPos++;
                                }
                                else {
                                    s1 = peg$FAILED;
                                    if (peg$silentFails === 0) {
                                        peg$fail(peg$c121);
                                    }
                                }
                                if (s1 !== peg$FAILED) {
                                    s2 = peg$parseAnyInput();
                                    if (s2 !== peg$FAILED) {
                                        if (input.charCodeAt(peg$currPos) === 34) {
                                            s3 = peg$c120;
                                            peg$currPos++;
                                        }
                                        else {
                                            s3 = peg$FAILED;
                                            if (peg$silentFails === 0) {
                                                peg$fail(peg$c121);
                                            }
                                        }
                                        if (s3 !== peg$FAILED) {
                                            peg$savedPos = s0;
                                            s1 = peg$c119(s2);
                                            s0 = s1;
                                        }
                                        else {
                                            peg$currPos = s0;
                                            s0 = peg$FAILED;
                                        }
                                    }
                                    else {
                                        peg$currPos = s0;
                                        s0 = peg$FAILED;
                                    }
                                }
                                else {
                                    peg$currPos = s0;
                                    s0 = peg$FAILED;
                                }
                            }
                        }
                    }
                }
            }
        }
        peg$resultsCache[key] = { nextPos: peg$currPos, result: s0 };
        return s0;
    }
    function peg$parseArrayOp() {
        var s0, s1, s2, s3;
        var key = peg$currPos * 34 + 20;
        var cached = peg$resultsCache[key];
        if (cached) {
            peg$currPos = cached.nextPos;
            return cached.result;
        }
        s0 = peg$currPos;
        if (input.charCodeAt(peg$currPos) === 91) {
            s1 = peg$c122;
            peg$currPos++;
        }
        else {
            s1 = peg$FAILED;
            if (peg$silentFails === 0) {
                peg$fail(peg$c123);
            }
        }
        if (s1 !== peg$FAILED) {
            s2 = peg$parseSequence();
            if (s2 !== peg$FAILED) {
                if (input.charCodeAt(peg$currPos) === 93) {
                    s3 = peg$c124;
                    peg$currPos++;
                }
                else {
                    s3 = peg$FAILED;
                    if (peg$silentFails === 0) {
                        peg$fail(peg$c125);
                    }
                }
                if (s3 !== peg$FAILED) {
                    peg$savedPos = s0;
                    s1 = peg$c126(s2);
                    s0 = s1;
                }
                else {
                    peg$currPos = s0;
                    s0 = peg$FAILED;
                }
            }
            else {
                peg$currPos = s0;
                s0 = peg$FAILED;
            }
        }
        else {
            peg$currPos = s0;
            s0 = peg$FAILED;
        }
        peg$resultsCache[key] = { nextPos: peg$currPos, result: s0 };
        return s0;
    }
    function peg$parseSequence() {
        var s0, s1, s2, s3, s4, s5, s6, s7;
        var key = peg$currPos * 34 + 21;
        var cached = peg$resultsCache[key];
        if (cached) {
            peg$currPos = cached.nextPos;
            return cached.result;
        }
        s0 = peg$currPos;
        s1 = peg$parseExpression();
        if (s1 === peg$FAILED) {
            s1 = null;
        }
        if (s1 !== peg$FAILED) {
            s2 = [];
            s3 = peg$currPos;
            s4 = peg$parse_();
            if (s4 !== peg$FAILED) {
                if (input.charCodeAt(peg$currPos) === 44) {
                    s5 = peg$c127;
                    peg$currPos++;
                }
                else {
                    s5 = peg$FAILED;
                    if (peg$silentFails === 0) {
                        peg$fail(peg$c128);
                    }
                }
                if (s5 !== peg$FAILED) {
                    s6 = peg$parse_();
                    if (s6 !== peg$FAILED) {
                        s7 = peg$parseExpression();
                        if (s7 !== peg$FAILED) {
                            s4 = [s4, s5, s6, s7];
                            s3 = s4;
                        }
                        else {
                            peg$currPos = s3;
                            s3 = peg$FAILED;
                        }
                    }
                    else {
                        peg$currPos = s3;
                        s3 = peg$FAILED;
                    }
                }
                else {
                    peg$currPos = s3;
                    s3 = peg$FAILED;
                }
            }
            else {
                peg$currPos = s3;
                s3 = peg$FAILED;
            }
            while (s3 !== peg$FAILED) {
                s2.push(s3);
                s3 = peg$currPos;
                s4 = peg$parse_();
                if (s4 !== peg$FAILED) {
                    if (input.charCodeAt(peg$currPos) === 44) {
                        s5 = peg$c127;
                        peg$currPos++;
                    }
                    else {
                        s5 = peg$FAILED;
                        if (peg$silentFails === 0) {
                            peg$fail(peg$c128);
                        }
                    }
                    if (s5 !== peg$FAILED) {
                        s6 = peg$parse_();
                        if (s6 !== peg$FAILED) {
                            s7 = peg$parseExpression();
                            if (s7 !== peg$FAILED) {
                                s4 = [s4, s5, s6, s7];
                                s3 = s4;
                            }
                            else {
                                peg$currPos = s3;
                                s3 = peg$FAILED;
                            }
                        }
                        else {
                            peg$currPos = s3;
                            s3 = peg$FAILED;
                        }
                    }
                    else {
                        peg$currPos = s3;
                        s3 = peg$FAILED;
                    }
                }
                else {
                    peg$currPos = s3;
                    s3 = peg$FAILED;
                }
            }
            if (s2 !== peg$FAILED) {
                peg$savedPos = s0;
                s1 = peg$c129(s1, s2);
                s0 = s1;
            }
            else {
                peg$currPos = s0;
                s0 = peg$FAILED;
            }
        }
        else {
            peg$currPos = s0;
            s0 = peg$FAILED;
        }
        peg$resultsCache[key] = { nextPos: peg$currPos, result: s0 };
        return s0;
    }
    function peg$parseLogicValue() {
        var s0, s1;
        var key = peg$currPos * 34 + 22;
        var cached = peg$resultsCache[key];
        if (cached) {
            peg$currPos = cached.nextPos;
            return cached.result;
        }
        s0 = peg$currPos;
        if (input.substr(peg$currPos, 4).toLowerCase() === peg$c130) {
            s1 = input.substr(peg$currPos, 4);
            peg$currPos += 4;
        }
        else {
            s1 = peg$FAILED;
            if (peg$silentFails === 0) {
                peg$fail(peg$c131);
            }
        }
        if (s1 !== peg$FAILED) {
            peg$savedPos = s0;
            s1 = peg$c132();
        }
        s0 = s1;
        if (s0 === peg$FAILED) {
            s0 = peg$currPos;
            if (input.substr(peg$currPos, 5).toLowerCase() === peg$c133) {
                s1 = input.substr(peg$currPos, 5);
                peg$currPos += 5;
            }
            else {
                s1 = peg$FAILED;
                if (peg$silentFails === 0) {
                    peg$fail(peg$c134);
                }
            }
            if (s1 !== peg$FAILED) {
                peg$savedPos = s0;
                s1 = peg$c135();
            }
            s0 = s1;
        }
        peg$resultsCache[key] = { nextPos: peg$currPos, result: s0 };
        return s0;
    }
    function peg$parseArithmeticValue() {
        var s0, s1, s2;
        var key = peg$currPos * 34 + 23;
        var cached = peg$resultsCache[key];
        if (cached) {
            peg$currPos = cached.nextPos;
            return cached.result;
        }
        s0 = peg$currPos;
        if (input.substr(peg$currPos, 2) === peg$c136) {
            s1 = peg$c136;
            peg$currPos += 2;
        }
        else {
            s1 = peg$FAILED;
            if (peg$silentFails === 0) {
                peg$fail(peg$c137);
            }
        }
        if (s1 !== peg$FAILED) {
            s2 = peg$parseDigits();
            if (s2 !== peg$FAILED) {
                peg$savedPos = s0;
                s1 = peg$c138();
                s0 = s1;
            }
            else {
                peg$currPos = s0;
                s0 = peg$FAILED;
            }
        }
        else {
            peg$currPos = s0;
            s0 = peg$FAILED;
        }
        if (s0 === peg$FAILED) {
            s0 = peg$currPos;
            if (peg$c139.test(input.charAt(peg$currPos))) {
                s1 = input.charAt(peg$currPos);
                peg$currPos++;
            }
            else {
                s1 = peg$FAILED;
                if (peg$silentFails === 0) {
                    peg$fail(peg$c140);
                }
            }
            if (s1 === peg$FAILED) {
                s1 = null;
            }
            if (s1 !== peg$FAILED) {
                s2 = peg$parseNumber();
                if (s2 !== peg$FAILED) {
                    peg$savedPos = s0;
                    s1 = peg$c141(s1, s2);
                    s0 = s1;
                }
                else {
                    peg$currPos = s0;
                    s0 = peg$FAILED;
                }
            }
            else {
                peg$currPos = s0;
                s0 = peg$FAILED;
            }
        }
        peg$resultsCache[key] = { nextPos: peg$currPos, result: s0 };
        return s0;
    }
    function peg$parseNumber() {
        var s0, s1, s2, s3;
        var key = peg$currPos * 34 + 24;
        var cached = peg$resultsCache[key];
        if (cached) {
            peg$currPos = cached.nextPos;
            return cached.result;
        }
        s0 = peg$currPos;
        s1 = peg$parseDigits();
        if (s1 !== peg$FAILED) {
            if (input.charCodeAt(peg$currPos) === 46) {
                s2 = peg$c142;
                peg$currPos++;
            }
            else {
                s2 = peg$FAILED;
                if (peg$silentFails === 0) {
                    peg$fail(peg$c143);
                }
            }
            if (s2 !== peg$FAILED) {
                s3 = peg$parseDigits();
                if (s3 !== peg$FAILED) {
                    peg$savedPos = s0;
                    s1 = peg$c144();
                    s0 = s1;
                }
                else {
                    peg$currPos = s0;
                    s0 = peg$FAILED;
                }
            }
            else {
                peg$currPos = s0;
                s0 = peg$FAILED;
            }
        }
        else {
            peg$currPos = s0;
            s0 = peg$FAILED;
        }
        if (s0 === peg$FAILED) {
            s0 = peg$currPos;
            s1 = peg$parseNonZeroDigits();
            if (s1 !== peg$FAILED) {
                s2 = peg$parseDigits();
                if (s2 === peg$FAILED) {
                    s2 = null;
                }
                if (s2 !== peg$FAILED) {
                    peg$savedPos = s0;
                    s1 = peg$c145();
                    s0 = s1;
                }
                else {
                    peg$currPos = s0;
                    s0 = peg$FAILED;
                }
            }
            else {
                peg$currPos = s0;
                s0 = peg$FAILED;
            }
            if (s0 === peg$FAILED) {
                s0 = peg$currPos;
                if (input.charCodeAt(peg$currPos) === 48) {
                    s1 = peg$c146;
                    peg$currPos++;
                }
                else {
                    s1 = peg$FAILED;
                    if (peg$silentFails === 0) {
                        peg$fail(peg$c147);
                    }
                }
                if (s1 !== peg$FAILED) {
                    peg$savedPos = s0;
                    s1 = peg$c148();
                }
                s0 = s1;
            }
        }
        peg$resultsCache[key] = { nextPos: peg$currPos, result: s0 };
        return s0;
    }
    function peg$parseValueInput() {
        var s0, s1, s2;
        var key = peg$currPos * 34 + 25;
        var cached = peg$resultsCache[key];
        if (cached) {
            peg$currPos = cached.nextPos;
            return cached.result;
        }
        s0 = peg$currPos;
        s1 = [];
        s2 = peg$parseValueCharacters();
        if (s2 !== peg$FAILED) {
            while (s2 !== peg$FAILED) {
                s1.push(s2);
                s2 = peg$parseValueCharacters();
            }
        }
        else {
            s1 = peg$FAILED;
        }
        if (s1 !== peg$FAILED) {
            peg$savedPos = s0;
            s1 = peg$c149(s1);
        }
        s0 = s1;
        peg$resultsCache[key] = { nextPos: peg$currPos, result: s0 };
        return s0;
    }
    function peg$parseAnyInput() {
        var s0, s1, s2;
        var key = peg$currPos * 34 + 26;
        var cached = peg$resultsCache[key];
        if (cached) {
            peg$currPos = cached.nextPos;
            return cached.result;
        }
        s0 = peg$currPos;
        s1 = [];
        s2 = peg$parseAnyCharacters();
        if (s2 !== peg$FAILED) {
            while (s2 !== peg$FAILED) {
                s1.push(s2);
                s2 = peg$parseAnyCharacters();
            }
        }
        else {
            s1 = peg$FAILED;
        }
        if (s1 !== peg$FAILED) {
            peg$savedPos = s0;
            s1 = peg$c149(s1);
        }
        s0 = s1;
        peg$resultsCache[key] = { nextPos: peg$currPos, result: s0 };
        return s0;
    }
    function peg$parseAnyCharacters() {
        var s0, s1;
        var key = peg$currPos * 34 + 27;
        var cached = peg$resultsCache[key];
        if (cached) {
            peg$currPos = cached.nextPos;
            return cached.result;
        }
        s0 = peg$currPos;
        if (input.substr(peg$currPos, 2) === peg$c150) {
            s1 = peg$c150;
            peg$currPos += 2;
        }
        else {
            s1 = peg$FAILED;
            if (peg$silentFails === 0) {
                peg$fail(peg$c151);
            }
        }
        if (s1 !== peg$FAILED) {
            peg$savedPos = s0;
            s1 = peg$c152();
        }
        s0 = s1;
        if (s0 === peg$FAILED) {
            s0 = peg$currPos;
            if (input.substr(peg$currPos, 2) === peg$c153) {
                s1 = peg$c153;
                peg$currPos += 2;
            }
            else {
                s1 = peg$FAILED;
                if (peg$silentFails === 0) {
                    peg$fail(peg$c154);
                }
            }
            if (s1 !== peg$FAILED) {
                peg$savedPos = s0;
                s1 = peg$c155();
            }
            s0 = s1;
            if (s0 === peg$FAILED) {
                s0 = peg$currPos;
                if (peg$c156.test(input.charAt(peg$currPos))) {
                    s1 = input.charAt(peg$currPos);
                    peg$currPos++;
                }
                else {
                    s1 = peg$FAILED;
                    if (peg$silentFails === 0) {
                        peg$fail(peg$c157);
                    }
                }
                if (s1 !== peg$FAILED) {
                    peg$savedPos = s0;
                    s1 = peg$c158();
                }
                s0 = s1;
            }
        }
        peg$resultsCache[key] = { nextPos: peg$currPos, result: s0 };
        return s0;
    }
    function peg$parseValueCharacters() {
        var s0, s1;
        var key = peg$currPos * 34 + 28;
        var cached = peg$resultsCache[key];
        if (cached) {
            peg$currPos = cached.nextPos;
            return cached.result;
        }
        s0 = peg$currPos;
        if (peg$c159.test(input.charAt(peg$currPos))) {
            s1 = input.charAt(peg$currPos);
            peg$currPos++;
        }
        else {
            s1 = peg$FAILED;
            if (peg$silentFails === 0) {
                peg$fail(peg$c160);
            }
        }
        if (s1 !== peg$FAILED) {
            peg$savedPos = s0;
            s1 = peg$c158();
        }
        s0 = s1;
        peg$resultsCache[key] = { nextPos: peg$currPos, result: s0 };
        return s0;
    }
    function peg$parseLettersAndDigits() {
        var s0, s1, s2, s3, s4, s5, s6;
        var key = peg$currPos * 34 + 29;
        var cached = peg$resultsCache[key];
        if (cached) {
            peg$currPos = cached.nextPos;
            return cached.result;
        }
        s0 = peg$currPos;
        s1 = peg$parseLetters();
        if (s1 !== peg$FAILED) {
            s2 = [];
            s3 = peg$currPos;
            s4 = peg$parseDigits();
            if (s4 !== peg$FAILED) {
                s5 = [];
                s6 = peg$parseLetters();
                while (s6 !== peg$FAILED) {
                    s5.push(s6);
                    s6 = peg$parseLetters();
                }
                if (s5 !== peg$FAILED) {
                    s4 = [s4, s5];
                    s3 = s4;
                }
                else {
                    peg$currPos = s3;
                    s3 = peg$FAILED;
                }
            }
            else {
                peg$currPos = s3;
                s3 = peg$FAILED;
            }
            while (s3 !== peg$FAILED) {
                s2.push(s3);
                s3 = peg$currPos;
                s4 = peg$parseDigits();
                if (s4 !== peg$FAILED) {
                    s5 = [];
                    s6 = peg$parseLetters();
                    while (s6 !== peg$FAILED) {
                        s5.push(s6);
                        s6 = peg$parseLetters();
                    }
                    if (s5 !== peg$FAILED) {
                        s4 = [s4, s5];
                        s3 = s4;
                    }
                    else {
                        peg$currPos = s3;
                        s3 = peg$FAILED;
                    }
                }
                else {
                    peg$currPos = s3;
                    s3 = peg$FAILED;
                }
            }
            if (s2 !== peg$FAILED) {
                peg$savedPos = s0;
                s1 = peg$c158();
                s0 = s1;
            }
            else {
                peg$currPos = s0;
                s0 = peg$FAILED;
            }
        }
        else {
            peg$currPos = s0;
            s0 = peg$FAILED;
        }
        peg$resultsCache[key] = { nextPos: peg$currPos, result: s0 };
        return s0;
    }
    function peg$parseDigits() {
        var s0, s1;
        var key = peg$currPos * 34 + 30;
        var cached = peg$resultsCache[key];
        if (cached) {
            peg$currPos = cached.nextPos;
            return cached.result;
        }
        s0 = [];
        if (peg$c161.test(input.charAt(peg$currPos))) {
            s1 = input.charAt(peg$currPos);
            peg$currPos++;
        }
        else {
            s1 = peg$FAILED;
            if (peg$silentFails === 0) {
                peg$fail(peg$c162);
            }
        }
        if (s1 !== peg$FAILED) {
            while (s1 !== peg$FAILED) {
                s0.push(s1);
                if (peg$c161.test(input.charAt(peg$currPos))) {
                    s1 = input.charAt(peg$currPos);
                    peg$currPos++;
                }
                else {
                    s1 = peg$FAILED;
                    if (peg$silentFails === 0) {
                        peg$fail(peg$c162);
                    }
                }
            }
        }
        else {
            s0 = peg$FAILED;
        }
        peg$resultsCache[key] = { nextPos: peg$currPos, result: s0 };
        return s0;
    }
    function peg$parseNonZeroDigits() {
        var s0, s1;
        var key = peg$currPos * 34 + 31;
        var cached = peg$resultsCache[key];
        if (cached) {
            peg$currPos = cached.nextPos;
            return cached.result;
        }
        s0 = [];
        if (peg$c163.test(input.charAt(peg$currPos))) {
            s1 = input.charAt(peg$currPos);
            peg$currPos++;
        }
        else {
            s1 = peg$FAILED;
            if (peg$silentFails === 0) {
                peg$fail(peg$c164);
            }
        }
        if (s1 !== peg$FAILED) {
            while (s1 !== peg$FAILED) {
                s0.push(s1);
                if (peg$c163.test(input.charAt(peg$currPos))) {
                    s1 = input.charAt(peg$currPos);
                    peg$currPos++;
                }
                else {
                    s1 = peg$FAILED;
                    if (peg$silentFails === 0) {
                        peg$fail(peg$c164);
                    }
                }
            }
        }
        else {
            s0 = peg$FAILED;
        }
        peg$resultsCache[key] = { nextPos: peg$currPos, result: s0 };
        return s0;
    }
    function peg$parseLetters() {
        var s0, s1;
        var key = peg$currPos * 34 + 32;
        var cached = peg$resultsCache[key];
        if (cached) {
            peg$currPos = cached.nextPos;
            return cached.result;
        }
        s0 = [];
        if (peg$c165.test(input.charAt(peg$currPos))) {
            s1 = input.charAt(peg$currPos);
            peg$currPos++;
        }
        else {
            s1 = peg$FAILED;
            if (peg$silentFails === 0) {
                peg$fail(peg$c166);
            }
        }
        if (s1 !== peg$FAILED) {
            while (s1 !== peg$FAILED) {
                s0.push(s1);
                if (peg$c165.test(input.charAt(peg$currPos))) {
                    s1 = input.charAt(peg$currPos);
                    peg$currPos++;
                }
                else {
                    s1 = peg$FAILED;
                    if (peg$silentFails === 0) {
                        peg$fail(peg$c166);
                    }
                }
            }
        }
        else {
            s0 = peg$FAILED;
        }
        peg$resultsCache[key] = { nextPos: peg$currPos, result: s0 };
        return s0;
    }
    function peg$parse_() {
        var s0, s1;
        var key = peg$currPos * 34 + 33;
        var cached = peg$resultsCache[key];
        if (cached) {
            peg$currPos = cached.nextPos;
            return cached.result;
        }
        peg$silentFails++;
        s0 = [];
        if (peg$c168.test(input.charAt(peg$currPos))) {
            s1 = input.charAt(peg$currPos);
            peg$currPos++;
        }
        else {
            s1 = peg$FAILED;
            if (peg$silentFails === 0) {
                peg$fail(peg$c169);
            }
        }
        while (s1 !== peg$FAILED) {
            s0.push(s1);
            if (peg$c168.test(input.charAt(peg$currPos))) {
                s1 = input.charAt(peg$currPos);
                peg$currPos++;
            }
            else {
                s1 = peg$FAILED;
                if (peg$silentFails === 0) {
                    peg$fail(peg$c169);
                }
            }
        }
        peg$silentFails--;
        if (s0 === peg$FAILED) {
            s1 = peg$FAILED;
            if (peg$silentFails === 0) {
                peg$fail(peg$c167);
            }
        }
        peg$resultsCache[key] = { nextPos: peg$currPos, result: s0 };
        return s0;
    }
    function buildBinaryOperand(head, tail, isArithmeticOp) {
        if (isArithmeticOp === void 0) { isArithmeticOp = false; }
        return tail.reduce(function (result, elements) {
            return new BinaryOperand(elements[1], result, elements[3], isArithmeticOp);
        }, head);
    }
    function flattenArray(array) {
        return [].concat.apply([], array);
    }
    peg$result = peg$startRuleFunction();
    if (peg$result !== peg$FAILED && peg$currPos === input.length) {
        return peg$result;
    }
    else {
        if (peg$result !== peg$FAILED && peg$currPos < input.length) {
            peg$fail(peg$endExpectation());
        }
        throw peg$buildStructuredError(peg$maxFailExpected, peg$maxFailPos < input.length ? input.charAt(peg$maxFailPos) : null, peg$maxFailPos < input.length
            ? peg$computeLocation(peg$maxFailPos, peg$maxFailPos + 1)
            : peg$computeLocation(peg$maxFailPos, peg$maxFailPos));
    }
}
var parse = peg$parse;

// CONCATENATED MODULE: ./packages/survey-core/src/conditionsParser.ts

var ConditionsParserError = /** @class */ (function () {
    function ConditionsParserError(at, code) {
        this.at = at;
        this.code = code;
    }
    return ConditionsParserError;
}());

var conditionsParser_ConditionsParser = /** @class */ (function () {
    function ConditionsParser() {
    }
    ConditionsParser.prototype.patchExpression = function (text) {
        return text
            .replace(/=>/g, ">=")
            .replace(/=</g, "<=")
            .replace(/<>/g, "!=")
            .replace(/equals/g, "equal ")
            .replace(/notequals/g, "notequal ");
    };
    ConditionsParser.prototype.createCondition = function (text) {
        return this.parseExpression(text);
    };
    ConditionsParser.prototype.parseExpression = function (text) {
        try {
            var result = ConditionsParser.parserCache[text];
            if (result === undefined) {
                result = parse(this.patchExpression(text));
                if (!result.hasAsyncFunction()) {
                    ConditionsParser.parserCache[text] = result;
                }
            }
            return result;
        }
        catch (e) {
            if (e instanceof SyntaxError) {
                this.conditionError = new ConditionsParserError(e.location.start.offset, e.message);
            }
        }
    };
    Object.defineProperty(ConditionsParser.prototype, "error", {
        get: function () {
            return this.conditionError;
        },
        enumerable: false,
        configurable: true
    });
    ConditionsParser.parserCache = {};
    return ConditionsParser;
}());


// CONCATENATED MODULE: ./packages/survey-core/src/conditions.ts
var conditions_extends = (undefined && undefined.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();




var conditions_ExpressionExecutorRunner = /** @class */ (function () {
    function ExpressionExecutorRunner(operand, id, onComplete, values, properties) {
        this.operand = operand;
        this.id = id;
        this.onComplete = onComplete;
        this.processValue = new conditionProcessValue_ProcessValue();
        this.processValue.values = values;
        this.processValue.properties = properties;
    }
    ExpressionExecutorRunner.prototype.run = function (isAsync) {
        var _this = this;
        if (!isAsync)
            return this.runValues();
        this.processValue.values = helpers_Helpers.createCopy(this.processValue.values);
        this.processValue.onCompleteAsyncFunc = function (op) {
            var item = _this.getAsyncItemByOperand(op, _this.asyncFuncList);
            if (item) {
                _this.doAsyncFunctionReady(item);
            }
        };
        this.asyncFuncList = new Array();
        this.operand.addToAsyncList(this.asyncFuncList);
        for (var i = 0; i < this.asyncFuncList.length; i++) {
            this.runAsyncItem(this.asyncFuncList[i]);
        }
        return false;
    };
    ExpressionExecutorRunner.prototype.getAsyncItemByOperand = function (op, list) {
        if (!Array.isArray(list))
            return null;
        for (var i = 0; i < list.length; i++) {
            if (list[i].operand === op)
                return list[i];
            var res = this.getAsyncItemByOperand(op, list[i].children);
            if (!!res)
                return res;
        }
        return null;
    };
    ExpressionExecutorRunner.prototype.runAsyncItem = function (item) {
        var _this = this;
        if (item.children) {
            item.children.forEach(function (child) { return _this.runAsyncItem(child); });
        }
        else {
            this.runAsyncItemCore(item);
        }
    };
    ExpressionExecutorRunner.prototype.runAsyncItemCore = function (item) {
        if (item.operand) {
            item.operand.evaluate(this.processValue);
        }
        else {
            this.doAsyncFunctionReady(item);
        }
    };
    ExpressionExecutorRunner.prototype.doAsyncFunctionReady = function (item) {
        if (item.parent && this.isAsyncChildrenReady(item)) {
            this.runAsyncItemCore(item.parent);
            return;
        }
        for (var i = 0; i < this.asyncFuncList.length; i++) {
            if (!this.isAsyncFuncReady(this.asyncFuncList[i]))
                return;
        }
        this.runValues();
    };
    ExpressionExecutorRunner.prototype.isAsyncFuncReady = function (item) {
        if (item.operand && !item.operand.isReady(this.processValue))
            return false;
        return this.isAsyncChildrenReady(item);
    };
    ExpressionExecutorRunner.prototype.isAsyncChildrenReady = function (item) {
        if (item.children) {
            for (var i = 0; i < item.children.length; i++) {
                if (!this.isAsyncFuncReady(item.children[i]))
                    return false;
            }
        }
        return true;
    };
    ExpressionExecutorRunner.prototype.runValues = function () {
        var res = this.operand.evaluate(this.processValue);
        if (!!this.onComplete) {
            this.onComplete(res, this.id);
        }
        return res;
    };
    return ExpressionExecutorRunner;
}());

var conditions_ExpressionExecutor = /** @class */ (function () {
    function ExpressionExecutor(expression) {
        this.parser = new conditionsParser_ConditionsParser();
        this.isAsyncValue = false;
        this.hasFunctionValue = false;
        this.setExpression(expression);
    }
    Object.defineProperty(ExpressionExecutor.prototype, "expression", {
        get: function () {
            return this.expressionValue;
        },
        enumerable: false,
        configurable: true
    });
    ExpressionExecutor.prototype.setExpression = function (value) {
        if (this.expression === value)
            return;
        this.expressionValue = value;
        this.operand = this.parser.parseExpression(value);
        this.hasFunctionValue = this.canRun() ? this.operand.hasFunction() : false;
        this.isAsyncValue = this.hasFunction()
            ? this.operand.hasAsyncFunction()
            : false;
    };
    ExpressionExecutor.prototype.getVariables = function () {
        if (!this.operand)
            return [];
        var variables = [];
        this.operand.setVariables(variables);
        return variables;
    };
    ExpressionExecutor.prototype.hasFunction = function () {
        return this.hasFunctionValue;
    };
    Object.defineProperty(ExpressionExecutor.prototype, "isAsync", {
        get: function () {
            return this.isAsyncValue;
        },
        enumerable: false,
        configurable: true
    });
    ExpressionExecutor.prototype.canRun = function () {
        return !!this.operand;
    };
    ExpressionExecutor.prototype.run = function (values, properties, id) {
        if (properties === void 0) { properties = null; }
        if (!this.operand) {
            if (!!this.expression) {
                ConsoleWarnings.warn("Invalid expression: " + this.expression);
            }
            return null;
        }
        var runner = new conditions_ExpressionExecutorRunner(this.operand, id, this.onComplete, values, properties);
        return runner.run(this.isAsync);
    };
    ExpressionExecutor.createExpressionExecutor = function (expression) { return new ExpressionExecutor(expression); };
    return ExpressionExecutor;
}());

var ExpressionRunnerBase = /** @class */ (function () {
    function ExpressionRunnerBase(expression) {
        this.expression = expression;
    }
    Object.defineProperty(ExpressionRunnerBase.prototype, "expression", {
        get: function () {
            return !!this.expressionExecutor ? this.expressionExecutor.expression : "";
        },
        set: function (value) {
            var _this = this;
            if (!!this.expressionExecutor && value === this.expression)
                return;
            this.expressionExecutor = conditions_ExpressionExecutor.createExpressionExecutor(value);
            this.expressionExecutor.onComplete = function (res, id) { _this.doOnComplete(res, id); };
            this.variables = undefined;
            this.containsFunc = undefined;
        },
        enumerable: false,
        configurable: true
    });
    ExpressionRunnerBase.prototype.getVariables = function () {
        if (this.variables === undefined) {
            this.variables = this.expressionExecutor.getVariables();
        }
        return this.variables;
    };
    ExpressionRunnerBase.prototype.hasFunction = function () {
        if (this.containsFunc === undefined) {
            this.containsFunc = this.expressionExecutor.hasFunction();
        }
        return this.containsFunc;
    };
    Object.defineProperty(ExpressionRunnerBase.prototype, "isAsync", {
        get: function () {
            return this.expressionExecutor.isAsync;
        },
        enumerable: false,
        configurable: true
    });
    ExpressionRunnerBase.prototype.canRun = function () {
        return this.expressionExecutor.canRun();
    };
    ExpressionRunnerBase.prototype.runCore = function (values, properties) {
        if (properties === void 0) { properties = null; }
        var id = ExpressionRunnerBase.IdRunnerCounter++;
        if (this.onBeforeAsyncRun && this.isAsync) {
            this.onBeforeAsyncRun(id);
        }
        return this.expressionExecutor.run(values, properties, id);
    };
    ExpressionRunnerBase.prototype.doOnComplete = function (res, id) {
        if (this.onAfterAsyncRun && this.isAsync) {
            this.onAfterAsyncRun(id);
        }
    };
    ExpressionRunnerBase.IdRunnerCounter = 1;
    return ExpressionRunnerBase;
}());

var ConditionRunner = /** @class */ (function (_super) {
    conditions_extends(ConditionRunner, _super);
    function ConditionRunner() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    ConditionRunner.prototype.run = function (values, properties) {
        if (properties === void 0) { properties = null; }
        return this.runCore(values, properties) == true;
    };
    ConditionRunner.prototype.doOnComplete = function (res, id) {
        if (!!this.onRunComplete)
            this.onRunComplete(res == true);
        _super.prototype.doOnComplete.call(this, res, id);
    };
    return ConditionRunner;
}(ExpressionRunnerBase));

var ExpressionRunner = /** @class */ (function (_super) {
    conditions_extends(ExpressionRunner, _super);
    function ExpressionRunner() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    ExpressionRunner.prototype.run = function (values, properties) {
        if (properties === void 0) { properties = null; }
        return this.runCore(values, properties);
    };
    ExpressionRunner.prototype.doOnComplete = function (res, id) {
        if (!!this.onRunComplete)
            this.onRunComplete(res);
        _super.prototype.doOnComplete.call(this, res, id);
    };
    return ExpressionRunner;
}(ExpressionRunnerBase));


// CONCATENATED MODULE: ./packages/survey-core/src/base.ts
var base_extends = (undefined && undefined.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var base_spreadArray = (undefined && undefined.__spreadArray) || function (to, from) {
    for (var i = 0, il = from.length, j = to.length; i < il; i++, j++)
        to[j] = from[i];
    return to;
};







var base_Bindings = /** @class */ (function () {
    function Bindings(obj) {
        this.obj = obj;
        this.properties = null;
        this.values = null;
    }
    Bindings.prototype.getType = function () {
        return "bindings";
    };
    Bindings.prototype.getNames = function () {
        var res = [];
        this.fillProperties();
        for (var i = 0; i < this.properties.length; i++) {
            if (this.properties[i].isVisible("", this.obj)) {
                res.push(this.properties[i].name);
            }
        }
        return res;
    };
    Bindings.prototype.getProperties = function () {
        var res = [];
        this.fillProperties();
        for (var i = 0; i < this.properties.length; i++) {
            res.push(this.properties[i]);
        }
        return res;
    };
    Bindings.prototype.setBinding = function (propertyName, valueName) {
        if (!this.values)
            this.values = {};
        var oldValue = this.getJson();
        if (oldValue === valueName)
            return;
        if (!!valueName) {
            this.values[propertyName] = valueName;
        }
        else {
            delete this.values[propertyName];
            if (Object.keys(this.values).length == 0) {
                this.values = null;
            }
        }
        this.onChangedJSON(oldValue);
    };
    Bindings.prototype.clearBinding = function (propertyName) {
        this.setBinding(propertyName, "");
    };
    Bindings.prototype.isEmpty = function () {
        if (!this.values)
            return true;
        for (var key in this.values)
            return false;
        return true;
    };
    Bindings.prototype.getValueNameByPropertyName = function (propertyName) {
        if (!this.values)
            return undefined;
        return this.values[propertyName];
    };
    Bindings.prototype.getPropertiesByValueName = function (valueName) {
        if (!this.values)
            return [];
        var res = [];
        for (var key in this.values) {
            if (this.values[key] == valueName) {
                res.push(key);
            }
        }
        return res;
    };
    Bindings.prototype.getJson = function () {
        if (this.isEmpty())
            return undefined;
        var res = {};
        for (var key in this.values) {
            res[key] = this.values[key];
        }
        return res;
    };
    Bindings.prototype.setJson = function (value, isLoading) {
        var oldValue = this.getJson();
        this.values = null;
        if (!!value) {
            this.values = {};
            for (var key in value) {
                this.values[key] = value[key];
            }
        }
        if (!isLoading) {
            this.onChangedJSON(oldValue);
        }
    };
    Bindings.prototype.fillProperties = function () {
        if (this.properties !== null)
            return;
        this.properties = [];
        var objProperties = Serializer.getPropertiesByObj(this.obj);
        for (var i = 0; i < objProperties.length; i++) {
            if (objProperties[i].isBindable) {
                this.properties.push(objProperties[i]);
            }
        }
    };
    Bindings.prototype.onChangedJSON = function (oldValue) {
        if (this.obj) {
            this.obj.onBindingChanged(oldValue, this.getJson());
        }
    };
    return Bindings;
}());

var Dependencies = /** @class */ (function () {
    function Dependencies(currentDependency, target, property) {
        this.currentDependency = currentDependency;
        this.target = target;
        this.property = property;
        this.dependencies = [];
        this.id = "" + (++Dependencies.DependenciesCount);
    }
    Dependencies.prototype.addDependency = function (target, property) {
        if (this.target === target && this.property === property)
            return;
        if (this.dependencies.some(function (dependency) { return dependency.obj === target && dependency.prop === property; }))
            return;
        this.dependencies.push({
            obj: target,
            prop: property,
            id: this.id
        });
        target.registerPropertyChangedHandlers([property], this.currentDependency, this.id);
    };
    Dependencies.prototype.dispose = function () {
        this.dependencies.forEach(function (dependency) {
            dependency.obj.unregisterPropertyChangedHandlers([dependency.prop], dependency.id);
        });
        // this.currentDependency = undefined;
    };
    Dependencies.DependenciesCount = 0;
    return Dependencies;
}());

var ComputedUpdater = /** @class */ (function () {
    function ComputedUpdater(_updater) {
        this._updater = _updater;
        this.dependencies = undefined;
        this.type = ComputedUpdater.ComputedUpdaterType;
    }
    Object.defineProperty(ComputedUpdater.prototype, "updater", {
        get: function () {
            return this._updater;
        },
        enumerable: false,
        configurable: true
    });
    ComputedUpdater.prototype.setDependencies = function (dependencies) {
        this.clearDependencies();
        this.dependencies = dependencies;
    };
    ComputedUpdater.prototype.getDependencies = function () {
        return this.dependencies;
    };
    ComputedUpdater.prototype.clearDependencies = function () {
        if (this.dependencies) {
            this.dependencies.dispose();
            this.dependencies = undefined;
        }
    };
    ComputedUpdater.prototype.dispose = function () {
        this.clearDependencies();
        this._updater = undefined;
    };
    ComputedUpdater.ComputedUpdaterType = "__dependency_computed";
    return ComputedUpdater;
}());

/**
 * A base class for all SurveyJS objects.
 */
var base_Base = /** @class */ (function () {
    function Base() {
        this.dependencies = {};
        this.propertyHash = Base.createPropertiesHash();
        this.eventList = [];
        this.isLoadingFromJsonValue = false;
        this.loadingOwner = null;
        /**
         * An event that is raised when a property of this SurveyJS object has changed.
         *
         * Parameters:
         *
         * - `sender`: `this`\
         * A SurveyJS object whose property has changed.
         * - `options.name`: `string`\
         * The name of the changed property.
         * - `options.newValue`: `any`\
         * A new value for the property.
         * - `options.oldValue`: `any`\
         * An old value of the property. If the property is an array, `oldValue` contains the same array as `newValue` does.
         *
         * If you need to add and remove property change event handlers dynamically, use the [`registerPropertyChangedHandlers`](#registerPropertyChangedHandlers) and [`unregisterPropertyChangedHandlers`](#unregisterPropertyChangedHandlers) methods instead.
         */
        this.onPropertyChanged = this.addEvent();
        /**
         * An event that is raised when an [`ItemValue`](https://surveyjs.io/form-library/documentation/itemvalue) property is changed.
         *
         * Parameters:
         *
         * - `sender`: `this`\
         * A SurveyJS object whose property contains an array of `ItemValue` objects.
         * - `options.obj`: [`ItemValue`](https://surveyjs.io/form-library/documentation/itemvalue)\
         * An `ItemValue` object.
         * - `options.propertyName`: `string`\
         * The name of the property to which an array of `ItemValue` objects is assigned (for example, `"choices"` or `"rows"`).
         * - `options.name`: `"text"` | `"value"`\
         * The name of the changed property.
         * - `options.newValue`: `any`\
         * A new value for the property.
         */
        this.onItemValuePropertyChanged = this.addEvent();
        this.isCreating = true;
        this.animationAllowedLock = 0;
        //remove when knockout obsolete
        this.supportOnElementRerenderedEvent = true;
        this.onElementRerenderedEventEnabled = false;
        this._onElementRerendered = new EventBase();
        this.bindingsValue = new base_Bindings(this);
        CustomPropertiesCollection.createProperties(this);
        this.onBaseCreating();
        this.isCreating = false;
    }
    Base.finishCollectDependencies = function () {
        var deps = Base.currentDependencis;
        Base.currentDependencis = undefined;
        return deps;
    };
    Base.startCollectDependencies = function (updater, target, property) {
        if (Base.currentDependencis !== undefined) {
            throw new Error("Attempt to collect nested dependencies. Nested dependencies are not supported.");
        }
        Base.currentDependencis = new Dependencies(updater, target, property);
    };
    Base.collectDependency = function (target, property) {
        if (Base.currentDependencis === undefined)
            return;
        Base.currentDependencis.addDependency(target, property);
    };
    Object.defineProperty(Base, "commentSuffix", {
        get: function () {
            return settings.commentSuffix;
        },
        set: function (val) {
            settings.commentSuffix = val;
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(Base, "commentPrefix", {
        get: function () {
            return Base.commentSuffix;
        },
        set: function (val) {
            Base.commentSuffix = val;
        },
        enumerable: false,
        configurable: true
    });
    /**
     * Returns `true` if a passed `value` is an empty string, array, or object or if it equals to `undefined` or `null`.
     *
     * @param value A value to be checked.
     * @param trimString *(Optional)* When this parameter is `true`, the method ignores whitespace characters at the beginning and end of a string value. Pass `false` to disable this functionality.
     */
    Base.prototype.isValueEmpty = function (value, trimString) {
        if (trimString === void 0) { trimString = true; }
        if (trimString) {
            value = this.trimValue(value);
        }
        return helpers_Helpers.isValueEmpty(value);
    };
    Base.prototype.equals = function (obj) {
        if (!obj)
            return false;
        if (this.isDisposed || obj.isDisposed)
            return false;
        if (this.getType() != obj.getType())
            return false;
        return this.equalsCore(obj);
    };
    Base.prototype.equalsCore = function (obj) {
        if (this.name !== obj.name)
            return false;
        return helpers_Helpers.isTwoValueEquals(this.toJSON(), obj.toJSON(), false, true, false);
    };
    Base.prototype.trimValue = function (value) {
        if (!!value && (typeof value === "string" || value instanceof String))
            return value.trim();
        return value;
    };
    Base.prototype.isPropertyEmpty = function (value) {
        return value !== "" && this.isValueEmpty(value);
    };
    Base.createPropertiesHash = function () {
        return {};
    };
    Base.prototype.dispose = function () {
        var _this = this;
        for (var i = 0; i < this.eventList.length; i++) {
            this.eventList[i].clear();
        }
        this.onPropertyValueChangedCallback = undefined;
        this.isDisposedValue = true;
        Object.keys(this.dependencies).forEach(function (key) { return _this.dependencies[key].dispose(); });
        // this.dependencies = {};
        Object.keys(this.propertyHash).forEach(function (key) {
            var propVal = _this.getPropertyValueCore(_this.propertyHash, key);
            if (!!propVal && propVal.type == ComputedUpdater.ComputedUpdaterType) {
                propVal.dispose();
            }
        });
    };
    Object.defineProperty(Base.prototype, "isDisposed", {
        get: function () {
            return this.isDisposedValue === true;
        },
        enumerable: false,
        configurable: true
    });
    Base.prototype.addEvent = function () {
        var res = new EventBase();
        this.eventList.push(res);
        return res;
    };
    Base.prototype.onBaseCreating = function () { };
    /**
     * Returns the object type as it is used in the JSON schema.
     */
    Base.prototype.getType = function () {
        return "base";
    };
    /**
     * Use this method to find out if the current object is of a given `typeName` or inherited from it.
     *
     * @param typeName One of the values listed in the [getType()](https://surveyjs.io/form-library/documentation/question#getType) description.
     * @returns `true` if the current object is of a given `typeName` or inherited from it.
     * @see getType
     */
    Base.prototype.isDescendantOf = function (typeName) {
        return Serializer.isDescendantOf(this.getType(), typeName);
    };
    Base.prototype.getSurvey = function (isLive) {
        if (isLive === void 0) { isLive = false; }
        return null;
    };
    Object.defineProperty(Base.prototype, "isDesignMode", {
        /**
         * Returns `true` if the survey is being designed in Survey Creator.
         */
        get: function () {
            var survey = this.getSurvey();
            return !!survey && survey.isDesignMode;
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(Base.prototype, "isDesignModeV2", {
        get: function () {
            return settings.supportCreatorV2 && this.isDesignMode;
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(Base.prototype, "inSurvey", {
        /**
         * Returns `true` if the object is included in a survey.
         *
         * This property may return `false`, for example, when you [create a survey model dynamically](https://surveyjs.io/form-library/documentation/design-survey-create-a-simple-survey#create-or-change-a-survey-model-dynamically).
         */
        get: function () {
            return !!this.getSurvey(true);
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(Base.prototype, "bindings", {
        get: function () {
            return this.bindingsValue;
        },
        enumerable: false,
        configurable: true
    });
    Base.prototype.checkBindings = function (valueName, value) { };
    Base.prototype.updateBindings = function (propertyName, value) {
        var valueName = this.bindings.getValueNameByPropertyName(propertyName);
        if (!!valueName) {
            this.updateBindingValue(valueName, value);
        }
    };
    Base.prototype.updateBindingValue = function (valueName, value) { };
    Base.prototype.getTemplate = function () {
        return this.getType();
    };
    Object.defineProperty(Base.prototype, "isLoadingFromJson", {
        /**
         * Returns `true` if the object configuration is being loaded from JSON.
         */
        get: function () {
            return this.isLoadingFromJsonValue || this.getIsLoadingFromJson();
        },
        enumerable: false,
        configurable: true
    });
    Base.prototype.getIsLoadingFromJson = function () {
        if (!!this.loadingOwner && this.loadingOwner.isLoadingFromJson)
            return true;
        return this.isLoadingFromJsonValue;
    };
    Base.prototype.startLoadingFromJson = function (json) {
        this.isLoadingFromJsonValue = true;
        this.jsonObj = json;
    };
    Base.prototype.endLoadingFromJson = function () {
        this.isLoadingFromJsonValue = false;
    };
    /**
     * Returns a JSON object that corresponds to the current SurveyJS object.
     * @see fromJSON
     */
    Base.prototype.toJSON = function (options) {
        return new jsonobject_JsonObject().toJsonObject(this, options);
    };
    /**
     * Assigns a new configuration to the current SurveyJS object. This configuration is taken from a passed JSON object.
     *
     * The JSON object should contain only serializable properties of this SurveyJS object. Event handlers and properties that do not belong to the SurveyJS object are ignored.
     *
     * @param json A JSON object with properties that you want to apply to the current SurveyJS object.
     * @param options An object with configuration options.
     * @param {boolean} options.validatePropertyValues Pass `true` if you want to validate property values. Use the [`jsonErrors`](#jsonErrors) array to access validation errors.
     * @see toJSON
     */
    Base.prototype.fromJSON = function (json, options) {
        new jsonobject_JsonObject().toObject(json, this, options);
        this.onSurveyLoad();
    };
    Base.prototype.onSurveyLoad = function () { };
    /**
     * Creates a new object that has the same type and properties as the current SurveyJS object.
     */
    Base.prototype.clone = function () {
        var clonedObj = Serializer.createClass(this.getType());
        clonedObj.fromJSON(this.toJSON());
        return clonedObj;
    };
    /**
     * Returns a `JsonObjectProperty` object with metadata about a serializable property that belongs to the current SurveyJS object.
     *
     * If the property is not found, this method returns `null`.
     * @param propName A property name.
     */
    Base.prototype.getPropertyByName = function (propName) {
        var type = this.getType();
        if (!this.classMetaData || this.classMetaData.name !== type) {
            this.classMetaData = Serializer.findClass(type);
        }
        return !!this.classMetaData ? this.classMetaData.findProperty(propName) : null;
    };
    Base.prototype.isPropertyVisible = function (propName) {
        var prop = this.getPropertyByName(propName);
        return !!prop ? prop.isVisible("", this) : false;
    };
    Base.createProgressInfo = function () {
        return {
            questionCount: 0,
            answeredQuestionCount: 0,
            requiredQuestionCount: 0,
            requiredAnsweredQuestionCount: 0,
        };
    };
    Base.prototype.getProgressInfo = function () {
        return Base.createProgressInfo();
    };
    Base.prototype.localeChanged = function () { };
    Base.prototype.locStrsChanged = function () {
        if (!!this.arraysInfo) {
            for (var key in this.arraysInfo) {
                var item = this.arraysInfo[key];
                if (item && item.isItemValues) {
                    var arr = this.getPropertyValue(key);
                    if (arr && !!Base.itemValueLocStrChanged)
                        Base.itemValueLocStrChanged(arr);
                }
            }
        }
        if (!!this.localizableStrings) {
            for (var key in this.localizableStrings) {
                var item = this.getLocalizableString(key);
                if (item)
                    item.strChanged();
            }
        }
    };
    /**
     * Returns the value of a property with a specified name.
     *
     * If the property is not found or does not have a value, this method returns either `undefined`, `defaultValue` specified in the property configuration, or a value passed as the `defaultValue` parameter.
     *
     * @param name A property name.
     * @param defaultValue *(Optional)* A value to return if the property is not found or does not have a value.
     */
    Base.prototype.getPropertyValue = function (name, defaultValue, calcFunc) {
        var res = this.getPropertyValueWithoutDefault(name);
        if (this.isPropertyEmpty(res)) {
            var locStr = this.localizableStrings ? this.localizableStrings[name] : undefined;
            if (locStr)
                return locStr.text;
            if (defaultValue !== null && defaultValue !== undefined)
                return defaultValue;
            if (!!calcFunc) {
                var newVal = calcFunc();
                if (newVal !== undefined) {
                    if (Array.isArray(newVal)) {
                        var array = this.createNewArray(name);
                        array.splice.apply(array, base_spreadArray([0, 0], newVal));
                        return array;
                    }
                    else {
                        this.setPropertyValueDirectly(name, newVal);
                        return newVal;
                    }
                }
            }
            var propDefaultValue = this.getDefaultPropertyValue(name);
            if (propDefaultValue !== undefined)
                return propDefaultValue;
        }
        return res;
    };
    Base.prototype.getDefaultPropertyValue = function (name) {
        var prop = this.getPropertyByName(name);
        if (!prop || prop.isCustom && this.isCreating)
            return undefined;
        if (!!prop.defaultValueFunc)
            return prop.defaultValueFunc(this);
        var dValue = prop.getDefaultValue(this);
        if (!this.isPropertyEmpty(dValue) && !Array.isArray(dValue))
            return dValue;
        var locStr = this.localizableStrings ? this.localizableStrings[name] : undefined;
        if (locStr && locStr.localizationName)
            return this.getLocalizationString(locStr.localizationName);
        if (prop.type == "boolean" || prop.type == "switch")
            return false;
        if (prop.isCustom && !!prop.onGetValue)
            return prop.onGetValue(this);
        return undefined;
    };
    Base.prototype.hasDefaultPropertyValue = function (name) {
        return this.getDefaultPropertyValue(name) !== undefined;
    };
    Base.prototype.resetPropertyValue = function (name) {
        var locStr = this.localizableStrings ? this.localizableStrings[name] : undefined;
        if (locStr) {
            this.setLocalizableStringText(name, undefined);
            locStr.clear();
        }
        else {
            this.setPropertyValue(name, undefined);
        }
    };
    Base.prototype.getPropertyValueWithoutDefault = function (name) {
        return this.getPropertyValueCore(this.propertyHash, name);
    };
    Base.prototype.getPropertyValueCore = function (propertiesHash, name) {
        if (!this.isLoadingFromJson) {
            Base.collectDependency(this, name);
        }
        if (this.getPropertyValueCoreHandler)
            return this.getPropertyValueCoreHandler(propertiesHash, name);
        else
            return propertiesHash[name];
    };
    Base.prototype.geValueFromHash = function () {
        return this.propertyHash["value"];
    };
    Base.prototype.setPropertyValueCore = function (propertiesHash, name, val) {
        if (this.setPropertyValueCoreHandler) {
            if (!this.isDisposedValue) {
                this.setPropertyValueCoreHandler(propertiesHash, name, val);
            }
            else {
                ConsoleWarnings.disposedObjectChangedProperty(name, this.getType());
            }
        }
        else
            propertiesHash[name] = val;
    };
    Object.defineProperty(Base.prototype, "isEditingSurveyElement", {
        get: function () {
            var survey = this.getSurvey();
            return !!survey && survey.isEditingSurveyElement;
        },
        enumerable: false,
        configurable: true
    });
    Base.prototype.iteratePropertiesHash = function (func) {
        var _this = this;
        var keys = [];
        for (var key in this.propertyHash) {
            if (key === "value" &&
                this.isEditingSurveyElement &&
                Array.isArray(this.value))
                continue;
            keys.push(key);
        }
        keys.forEach(function (key) { return func(_this.propertyHash, key); });
    };
    /**
     * Assigns a new value to a specified property.
     * @param name A property name.
     * @param val A new value for the property.
     */
    Base.prototype.setPropertyValue = function (name, val) {
        if (this.isDisposedValue)
            return;
        if (!this.isLoadingFromJson) {
            var prop = this.getPropertyByName(name);
            if (!!prop) {
                val = prop.settingValue(this, val);
            }
        }
        var oldValue = this.getPropertyValue(name);
        if (oldValue &&
            Array.isArray(oldValue) &&
            !!this.arraysInfo &&
            (!val || Array.isArray(val))) {
            if (!this.isTwoValueEquals(oldValue, val)) {
                this.setArrayPropertyDirectly(name, val);
            }
        }
        else {
            if (val !== oldValue) {
                this.setPropertyValueDirectly(name, val);
                if (!this.isTwoValueEquals(oldValue, val)) {
                    this.propertyValueChanged(name, oldValue, val);
                }
            }
        }
    };
    Base.prototype.setArrayPropertyDirectly = function (name, val, sendNotification) {
        if (sendNotification === void 0) { sendNotification = true; }
        var arrayInfo = this.arraysInfo[name];
        this.setArray(name, this.getPropertyValue(name), val, arrayInfo ? arrayInfo.isItemValues : false, arrayInfo ? sendNotification && arrayInfo.onPush : null);
    };
    Base.prototype.setPropertyValueDirectly = function (name, val) {
        this.setPropertyValueCore(this.propertyHash, name, val);
    };
    Base.prototype.clearPropertyValue = function (name) {
        this.setPropertyValueCore(this.propertyHash, name, null);
        delete this.propertyHash[name];
    };
    Base.prototype.onPropertyValueChangedCallback = function (name, oldValue, newValue, sender, arrayChanges) { };
    Base.prototype.itemValuePropertyChanged = function (item, name, oldValue, newValue) {
        this.onItemValuePropertyChanged.fire(this, {
            obj: item,
            name: name,
            oldValue: oldValue,
            newValue: newValue,
            propertyName: item.ownerPropertyName,
        });
    };
    Base.prototype.onPropertyValueChanged = function (name, oldValue, newValue) { };
    Base.prototype.propertyValueChanged = function (name, oldValue, newValue, arrayChanges, target) {
        if (this.isLoadingFromJson)
            return;
        this.updateBindings(name, newValue);
        this.onPropertyValueChanged(name, oldValue, newValue);
        this.onPropertyChanged.fire(this, {
            name: name,
            oldValue: oldValue,
            newValue: newValue,
            arrayChanges: arrayChanges,
            target: target
        });
        this.doPropertyValueChangedCallback(name, oldValue, newValue, arrayChanges, this);
        this.checkConditionPropertyChanged(name);
        if (!this.onPropChangeFunctions)
            return;
        for (var i = 0; i < this.onPropChangeFunctions.length; i++) {
            if (this.onPropChangeFunctions[i].name == name)
                this.onPropChangeFunctions[i].func(newValue, arrayChanges);
        }
    };
    Base.prototype.onBindingChanged = function (oldValue, newValue) {
        if (this.isLoadingFromJson)
            return;
        this.doPropertyValueChangedCallback("bindings", oldValue, newValue);
    };
    Object.defineProperty(Base.prototype, "isInternal", {
        get: function () {
            return false;
        },
        enumerable: false,
        configurable: true
    });
    Base.prototype.doPropertyValueChangedCallback = function (name, oldValue, newValue, arrayChanges, target) {
        var fireCallback = function (obj) {
            if (!!obj && !!obj.onPropertyValueChangedCallback) {
                obj.onPropertyValueChangedCallback(name, oldValue, newValue, target, arrayChanges);
            }
        };
        if (this.isInternal) {
            fireCallback(this);
            return;
        }
        if (!target)
            target = this;
        var notifier = this.getSurvey();
        if (!notifier)
            notifier = this;
        fireCallback(notifier);
        if (notifier !== this) {
            fireCallback(this);
        }
    };
    Base.prototype.addExpressionProperty = function (name, onExecute, canRun) {
        if (!this.expressionInfo) {
            this.expressionInfo = {};
        }
        this.expressionInfo[name] = { onExecute: onExecute, canRun: canRun };
    };
    Base.prototype.getDataFilteredValues = function () {
        return {};
    };
    Base.prototype.getDataFilteredProperties = function () {
        return {};
    };
    Base.prototype.runConditionCore = function (values, properties) {
        if (!this.expressionInfo)
            return;
        for (var key in this.expressionInfo) {
            this.runConditionItemCore(key, values, properties);
        }
    };
    Base.prototype.canRunConditions = function () {
        return !this.isDesignMode;
    };
    Base.prototype.checkConditionPropertyChanged = function (propName) {
        if (!this.expressionInfo || !this.expressionInfo[propName])
            return;
        if (!this.canRunConditions())
            return;
        this.runConditionItemCore(propName, this.getDataFilteredValues(), this.getDataFilteredProperties());
    };
    Base.prototype.runConditionItemCore = function (propName, values, properties) {
        var _this = this;
        var info = this.expressionInfo[propName];
        var expression = this.getPropertyValue(propName);
        if (!expression)
            return;
        if (!!info.canRun && !info.canRun(this))
            return;
        if (!info.runner) {
            info.runner = this.createExpressionRunner(expression);
            info.runner.onRunComplete = function (res) {
                info.onExecute(_this, res);
            };
        }
        info.runner.expression = expression;
        info.runner.run(values, properties);
    };
    Base.prototype.doBeforeAsynRun = function (id) {
        if (!this.asynExpressionHash)
            this.asynExpressionHash = {};
        var isChanged = !this.isAsyncExpressionRunning;
        this.asynExpressionHash[id] = true;
        if (isChanged) {
            this.onAsyncRunningChanged();
        }
    };
    Base.prototype.doAfterAsynRun = function (id) {
        if (!!this.asynExpressionHash) {
            delete this.asynExpressionHash[id];
            if (!this.isAsyncExpressionRunning) {
                this.onAsyncRunningChanged();
            }
        }
    };
    Base.prototype.onAsyncRunningChanged = function () { };
    Object.defineProperty(Base.prototype, "isAsyncExpressionRunning", {
        get: function () {
            return !!this.asynExpressionHash && Object.keys(this.asynExpressionHash).length > 0;
        },
        enumerable: false,
        configurable: true
    });
    Base.prototype.createExpressionRunner = function (expression) {
        var _this = this;
        var res = new ExpressionRunner(expression);
        res.onBeforeAsyncRun = function (id) { _this.doBeforeAsynRun(id); };
        res.onAfterAsyncRun = function (id) { _this.doAfterAsynRun(id); };
        return res;
    };
    /**
     * Registers a single value change handler for one or multiple properties.
     *
     * The `registerPropertyChangedHandlers` and [`unregisterPropertyChangedHandlers`](#unregisterPropertyChangedHandlers) methods allow you to manage property change event handlers dynamically. If you only need to attach an event handler without removing it afterwards, you can use the [`onPropertyChanged`](#onPropertyChanged) event instead.
     * @param propertyNames An array of one or multiple property names.
     * @param handler A function to call when one of the listed properties change. Accepts a new property value as an argument.
     * @param key *(Optional)* A key that identifies the current registration. If a function for one of the properties is already registered with the same key, the function will be overwritten. You can also use the key to subsequently unregister handlers.
     * @see unregisterPropertyChangedHandlers
     */
    Base.prototype.registerPropertyChangedHandlers = function (propertyNames, handler, key) {
        if (key === void 0) { key = null; }
        for (var i = 0; i < propertyNames.length; i++) {
            this.registerFunctionOnPropertyValueChanged(propertyNames[i], handler, key);
        }
    };
    /**
     * Unregisters value change event handlers for the specified properties.
     * @param propertyNames An array of one or multiple property names.
     * @param key *(Optional)* A key of the registration that you want to cancel.
     * @see registerPropertyChangedHandlers
     */
    Base.prototype.unregisterPropertyChangedHandlers = function (propertyNames, key) {
        if (key === void 0) { key = null; }
        for (var i = 0; i < propertyNames.length; i++) {
            this.unRegisterFunctionOnPropertyValueChanged(propertyNames[i], key);
        }
    };
    Base.prototype.registerFunctionOnPropertyValueChanged = function (name, func, key) {
        if (key === void 0) { key = null; }
        if (!this.onPropChangeFunctions) {
            this.onPropChangeFunctions = [];
        }
        if (key) {
            for (var i = 0; i < this.onPropChangeFunctions.length; i++) {
                var item = this.onPropChangeFunctions[i];
                if (item.name == name && item.key == key) {
                    item.func = func;
                    return;
                }
            }
        }
        this.onPropChangeFunctions.push({ name: name, func: func, key: key });
    };
    Base.prototype.registerFunctionOnPropertiesValueChanged = function (names, func, key) {
        if (key === void 0) { key = null; }
        this.registerPropertyChangedHandlers(names, func, key);
    };
    Base.prototype.unRegisterFunctionOnPropertyValueChanged = function (name, key) {
        if (key === void 0) { key = null; }
        if (!this.onPropChangeFunctions)
            return;
        for (var i = 0; i < this.onPropChangeFunctions.length; i++) {
            var item = this.onPropChangeFunctions[i];
            if (item.name == name && item.key == key) {
                this.onPropChangeFunctions.splice(i, 1);
                return;
            }
        }
    };
    Base.prototype.unRegisterFunctionOnPropertiesValueChanged = function (names, key) {
        if (key === void 0) { key = null; }
        this.unregisterPropertyChangedHandlers(names, key);
    };
    Base.prototype.createCustomLocalizableObj = function (name) {
        var locStr = this.getLocalizableString(name);
        if (locStr)
            return locStr;
        return this.createLocalizableString(name, this, false, true);
    };
    Base.prototype.getLocale = function () {
        var locOwner = this.getSurvey();
        return !!locOwner ? locOwner.getLocale() : "";
    };
    Base.prototype.getLocalizationString = function (strName) {
        return getLocaleString(strName, this.getLocale());
    };
    Base.prototype.getLocalizationFormatString = function (strName) {
        var args = [];
        for (var _i = 1; _i < arguments.length; _i++) {
            args[_i - 1] = arguments[_i];
        }
        var str = this.getLocalizationString(strName);
        if (!str || !str.format)
            return "";
        return str.format.apply(str, args);
    };
    Base.prototype.createLocalizableString = function (name, owner, useMarkDown, defaultStr) {
        var _this = this;
        if (useMarkDown === void 0) { useMarkDown = false; }
        if (defaultStr === void 0) { defaultStr = false; }
        var locName = undefined;
        if (defaultStr) {
            locName = defaultStr === true ? name : defaultStr;
        }
        var locStr = new localizablestring_LocalizableString(owner, useMarkDown, name, locName);
        locStr.onStrChanged = function (oldValue, newValue) {
            _this.propertyValueChanged(name, oldValue, newValue);
        };
        if (!this.localizableStrings) {
            this.localizableStrings = {};
        }
        this.localizableStrings[name] = locStr;
        var prop = this.getPropertyByName(name);
        locStr.disableLocalization = prop && prop.isLocalizable === false;
        return locStr;
    };
    Base.prototype.getLocalizableString = function (name) {
        return !!this.localizableStrings ? this.localizableStrings[name] : null;
    };
    Base.prototype.getLocalizableStringText = function (name, defaultStr) {
        if (defaultStr === void 0) { defaultStr = ""; }
        Base.collectDependency(this, name);
        var locStr = this.getLocalizableString(name);
        if (!locStr)
            return "";
        var res = locStr.text;
        return res ? res : defaultStr;
    };
    Base.prototype.setLocalizableStringText = function (name, value) {
        var locStr = this.getLocalizableString(name);
        if (!locStr)
            return;
        var oldValue = locStr.text;
        if (oldValue != value) {
            locStr.text = value;
            // this.propertyValueChanged(name, oldValue, value);
        }
    };
    Base.prototype.addUsedLocales = function (locales) {
        if (!!this.localizableStrings) {
            for (var key in this.localizableStrings) {
                var item = this.getLocalizableString(key);
                if (item)
                    this.AddLocStringToUsedLocales(item, locales);
            }
        }
        if (!!this.arraysInfo) {
            for (var key in this.arraysInfo) {
                var prop = this.getPropertyByName(key);
                if (!prop || !prop.isSerializable)
                    continue;
                var items = this.getPropertyValue(key);
                if (!items || !items.length)
                    continue;
                for (var i = 0; i < items.length; i++) {
                    var item = items[i];
                    if (item && item.addUsedLocales) {
                        item.addUsedLocales(locales);
                    }
                }
            }
        }
    };
    Base.prototype.searchText = function (text, founded) {
        var strs = [];
        this.getSearchableLocalizedStrings(strs);
        for (var i = 0; i < strs.length; i++) {
            if (strs[i].setFindText(text)) {
                founded.push({ element: this, str: strs[i] });
            }
        }
    };
    Base.prototype.getSearchableLocalizedStrings = function (arr) {
        if (!!this.localizableStrings) {
            var keys_1 = [];
            this.getSearchableLocKeys(keys_1);
            for (var i = 0; i < keys_1.length; i++) {
                var item = this.getLocalizableString(keys_1[i]);
                if (item)
                    arr.push(item);
            }
        }
        if (!this.arraysInfo)
            return;
        var keys = [];
        this.getSearchableItemValueKeys(keys);
        for (var i = 0; i < keys.length; i++) {
            var items = this.getPropertyValue(keys[i]);
            if (!items)
                continue;
            for (var j = 0; j < items.length; j++) {
                arr.push(items[j].locText);
            }
        }
    };
    Base.prototype.getSearchableLocKeys = function (keys) { };
    Base.prototype.getSearchableItemValueKeys = function (keys) { };
    Base.prototype.AddLocStringToUsedLocales = function (locStr, locales) {
        var locs = locStr.getLocales();
        for (var i = 0; i < locs.length; i++) {
            if (locales.indexOf(locs[i]) < 0) {
                locales.push(locs[i]);
            }
        }
    };
    Base.prototype.createItemValues = function (name) {
        var self = this;
        var result = this.createNewArray(name, function (item) {
            item.locOwner = self;
            item.ownerPropertyName = name;
            if (typeof item.getSurvey == "function") {
                var survey = item.getSurvey();
                if (!!survey && typeof survey.makeReactive == "function") {
                    survey.makeReactive(item);
                }
            }
        });
        this.arraysInfo[name].isItemValues = true;
        return result;
    };
    Base.prototype.notifyArrayChanged = function (ar, arrayChanges) {
        !!ar.onArrayChanged && ar.onArrayChanged(arrayChanges);
    };
    Base.prototype.createNewArrayCore = function (name) {
        var res = null;
        if (!!this.createArrayCoreHandler) {
            res = this.createArrayCoreHandler(this.propertyHash, name);
        }
        if (!res) {
            res = new Array();
            this.setPropertyValueCore(this.propertyHash, name, res);
        }
        return res;
    };
    Base.prototype.ensureArray = function (name, onPush, onRemove) {
        if (onPush === void 0) { onPush = null; }
        if (onRemove === void 0) { onRemove = null; }
        if (this.arraysInfo && this.arraysInfo[name]) {
            return;
        }
        return this.createNewArray(name, onPush, onRemove);
    };
    Base.prototype.createNewArray = function (name, onPush, onRemove) {
        if (onPush === void 0) { onPush = null; }
        if (onRemove === void 0) { onRemove = null; }
        var newArray = this.createNewArrayCore(name);
        if (!this.arraysInfo) {
            this.arraysInfo = {};
        }
        this.arraysInfo[name] = { onPush: onPush, isItemValues: false };
        var self = this;
        newArray.push = function (value) {
            var result = Object.getPrototypeOf(newArray).push.call(newArray, value);
            if (!self.isDisposedValue) {
                if (onPush)
                    onPush(value, newArray.length - 1);
                var arrayChanges = new ArrayChanges(newArray.length - 1, 0, [value], []);
                self.propertyValueChanged(name, newArray, newArray, arrayChanges);
                self.notifyArrayChanged(newArray, arrayChanges);
            }
            return result;
        };
        newArray.shift = function () {
            var result = Object.getPrototypeOf(newArray).shift.call(newArray);
            if (!self.isDisposedValue && result) {
                if (onRemove)
                    onRemove(result);
                var arrayChanges = new ArrayChanges(newArray.length - 1, 1, [], []);
                self.propertyValueChanged(name, newArray, newArray, arrayChanges);
                self.notifyArrayChanged(newArray, arrayChanges);
            }
            return result;
        };
        newArray.unshift = function (value) {
            var result = Object.getPrototypeOf(newArray).unshift.call(newArray, value);
            if (!self.isDisposedValue) {
                if (onPush)
                    onPush(value, newArray.length - 1);
                var arrayChanges = new ArrayChanges(0, 0, [value], []);
                self.propertyValueChanged(name, newArray, newArray, arrayChanges);
                self.notifyArrayChanged(newArray, arrayChanges);
            }
            return result;
        };
        newArray.pop = function () {
            var result = Object.getPrototypeOf(newArray).pop.call(newArray);
            if (!self.isDisposedValue) {
                if (onRemove)
                    onRemove(result);
                var arrayChanges = new ArrayChanges(newArray.length - 1, 1, [], []);
                self.propertyValueChanged(name, newArray, newArray, arrayChanges);
                self.notifyArrayChanged(newArray, arrayChanges);
            }
            return result;
        };
        newArray.splice = function (start, deleteCount) {
            var _a;
            var items = [];
            for (var _i = 2; _i < arguments.length; _i++) {
                items[_i - 2] = arguments[_i];
            }
            if (!start)
                start = 0;
            if (!deleteCount)
                deleteCount = 0;
            var result = (_a = Object.getPrototypeOf(newArray).splice).call.apply(_a, base_spreadArray([newArray,
                start,
                deleteCount], items));
            if (!items)
                items = [];
            if (!self.isDisposedValue) {
                if (onRemove && result) {
                    for (var i = 0; i < result.length; i++) {
                        onRemove(result[i]);
                    }
                }
                if (onPush) {
                    for (var i = 0; i < items.length; i++) {
                        onPush(items[i], start + i);
                    }
                }
                var arrayChanges = new ArrayChanges(start, deleteCount, items, result);
                self.propertyValueChanged(name, newArray, newArray, arrayChanges);
                self.notifyArrayChanged(newArray, arrayChanges);
            }
            return result;
        };
        return newArray;
    };
    Base.prototype.getItemValueType = function () {
        return undefined;
    };
    Base.prototype.setArray = function (name, src, dest, isItemValues, onPush) {
        var deletedItems = [].concat(src);
        Object.getPrototypeOf(src).splice.call(src, 0, src.length);
        if (!!dest) {
            for (var i = 0; i < dest.length; i++) {
                var item = dest[i];
                if (isItemValues) {
                    if (!!Base.createItemValue) {
                        item = Base.createItemValue(item, this.getItemValueType());
                    }
                }
                Object.getPrototypeOf(src).push.call(src, item);
                if (onPush)
                    onPush(src[i]);
            }
        }
        var arrayChanges = new ArrayChanges(0, deletedItems.length, src, deletedItems);
        this.propertyValueChanged(name, deletedItems, src, arrayChanges);
        this.notifyArrayChanged(src, arrayChanges);
    };
    Base.prototype.isTwoValueEquals = function (x, y, caseInSensitive, trimString) {
        if (caseInSensitive === void 0) { caseInSensitive = false; }
        if (trimString === void 0) { trimString = false; }
        return helpers_Helpers.isTwoValueEquals(x, y, false, !caseInSensitive, trimString);
    };
    Base.copyObject = function (dst, src) {
        for (var key in src) {
            var source = src[key];
            if (typeof source === "object") {
                source = {};
                this.copyObject(source, src[key]);
            }
            dst[key] = source;
        }
    };
    Base.prototype.copyCssClasses = function (dest, source) {
        if (!source)
            return;
        if (typeof source === "string" || source instanceof String) {
            dest["root"] = source;
        }
        else {
            Base.copyObject(dest, source);
        }
    };
    Base.prototype.getValueInLowCase = function (val) {
        if (!!val && typeof val == "string")
            return val.toLowerCase();
        return val;
    };
    Base.prototype.getElementsInDesign = function (includeHidden) {
        if (includeHidden === void 0) { includeHidden = false; }
        return [];
    };
    Object.defineProperty(Base.prototype, "animationAllowed", {
        get: function () {
            return this.getIsAnimationAllowed();
        },
        enumerable: false,
        configurable: true
    });
    Base.prototype.getIsAnimationAllowed = function () {
        return settings.animationEnabled && this.animationAllowedLock >= 0 && !this.isLoadingFromJson && !this.isDisposed && (!!this.onElementRerendered || !this.supportOnElementRerenderedEvent);
    };
    Base.prototype.blockAnimations = function () {
        this.animationAllowedLock--;
    };
    Base.prototype.releaseAnimations = function () {
        this.animationAllowedLock++;
    };
    Base.prototype.enableOnElementRerenderedEvent = function () {
        this.onElementRerenderedEventEnabled = true;
    };
    Base.prototype.disableOnElementRerenderedEvent = function () {
        var _a;
        (_a = this.onElementRerendered) === null || _a === void 0 ? void 0 : _a.fire(this, { isCancel: true });
        this.onElementRerenderedEventEnabled = false;
    };
    Object.defineProperty(Base.prototype, "onElementRerendered", {
        get: function () {
            return this.supportOnElementRerenderedEvent && this.onElementRerenderedEventEnabled ? this._onElementRerendered : undefined;
        },
        enumerable: false,
        configurable: true
    });
    Base.prototype.afterRerender = function () {
        var _a;
        (_a = this.onElementRerendered) === null || _a === void 0 ? void 0 : _a.fire(this, { isCancel: false });
    };
    Base.currentDependencis = undefined;
    return Base;
}());

var ArrayChanges = /** @class */ (function () {
    function ArrayChanges(index, deleteCount, itemsToAdd, deletedItems) {
        this.index = index;
        this.deleteCount = deleteCount;
        this.itemsToAdd = itemsToAdd;
        this.deletedItems = deletedItems;
    }
    return ArrayChanges;
}());

var Event = /** @class */ (function () {
    function Event() {
    }
    Object.defineProperty(Event.prototype, "isEmpty", {
        get: function () {
            return this.length === 0;
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(Event.prototype, "length", {
        get: function () {
            return !!this.callbacks ? this.callbacks.length : 0;
        },
        enumerable: false,
        configurable: true
    });
    Event.prototype.fireByCreatingOptions = function (sender, createOptions) {
        if (!this.callbacks)
            return;
        for (var i = 0; i < this.callbacks.length; i++) {
            this.callbacks[i](sender, createOptions());
            if (!this.callbacks)
                return;
        }
    };
    Event.prototype.fire = function (sender, options) {
        if (!this.callbacks)
            return;
        var callbacks = [].concat(this.callbacks);
        for (var i = 0; i < callbacks.length; i++) {
            callbacks[i](sender, options);
            if (!this.callbacks)
                return;
        }
    };
    Event.prototype.clear = function () {
        this.callbacks = undefined;
    };
    Event.prototype.add = function (func) {
        if (this.hasFunc(func))
            return;
        if (!this.callbacks) {
            this.callbacks = new Array();
        }
        this.callbacks.push(func);
        this.fireCallbackChanged();
    };
    Event.prototype.remove = function (func) {
        if (this.hasFunc(func)) {
            var index = this.callbacks.indexOf(func, 0);
            this.callbacks.splice(index, 1);
            this.fireCallbackChanged();
        }
    };
    Event.prototype.hasFunc = function (func) {
        if (this.callbacks == null)
            return false;
        return this.callbacks.indexOf(func, 0) > -1;
    };
    Event.prototype.fireCallbackChanged = function () {
        if (!!this.onCallbacksChanged) {
            this.onCallbacksChanged();
        }
    };
    return Event;
}());

var EventBase = /** @class */ (function (_super) {
    base_extends(EventBase, _super);
    function EventBase() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    return EventBase;
}(Event));


// CONCATENATED MODULE: ./packages/survey-core/src/utils/responsivity-manager.ts
var responsivity_manager_extends = (undefined && undefined.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();


var responsivity_manager_ResponsivityManager = /** @class */ (function () {
    function ResponsivityManager(container, model, itemsSelector, dotsItemSize, delayedUpdateFunction) {
        var _this = this;
        if (dotsItemSize === void 0) { dotsItemSize = null; }
        if (delayedUpdateFunction === void 0) { delayedUpdateFunction = function (callback) { if (queueMicrotask)
            queueMicrotask(callback);
        else
            callback(); }; }
        this.container = container;
        this.model = model;
        this.itemsSelector = itemsSelector;
        this.dotsItemSize = dotsItemSize;
        this.delayedUpdateFunction = delayedUpdateFunction;
        this.resizeObserver = undefined;
        this.isInitialized = false;
        this.minDimensionConst = 56;
        this.separatorSize = 17;
        this.separatorAddConst = 1;
        this.paddingSizeConst = 8;
        this.dotsSizeConst = 48;
        this.dotsIconClass = ".sv-dots";
        this.iconClass = ".sv-svg-icon";
        this.recalcMinDimensionConst = true;
        this.getComputedStyle = function (elt) {
            return DomDocumentHelper.getComputedStyle(elt);
        };
        this.model.updateCallback = function (isResetInitialized) {
            if (isResetInitialized) {
                _this.isInitialized = false;
            }
            setTimeout(function () { _this.process(); }, 1);
        };
        if (typeof ResizeObserver !== "undefined") {
            this.resizeObserver = new ResizeObserver(function (entries) {
                DomWindowHelper.requestAnimationFrame(function () {
                    _this.process();
                });
            });
            this.resizeObserver.observe(this.container.parentElement);
        }
    }
    ResponsivityManager.prototype.getDimensions = function (element) {
        return {
            scroll: element.scrollWidth,
            offset: element.offsetWidth,
        };
    };
    ResponsivityManager.prototype.getAvailableSpace = function () {
        var style = this.getComputedStyle(this.container);
        var space = this.container.offsetWidth;
        if (style.boxSizing === "border-box") {
            space -= parseFloat(style.paddingLeft) + parseFloat(style.paddingRight);
        }
        return space;
    };
    ResponsivityManager.prototype.calcItemSize = function (item) {
        return item.offsetWidth || item.getBoundingClientRect().width;
    };
    ResponsivityManager.prototype.calcMinDimension = function (currentAction, item) {
        var iconSize;
        if (!!item && (!currentAction.iconSize || currentAction.iconSize === "auto")) {
            var iconElement = item.querySelector(this.iconClass);
            iconSize = iconElement && this.calcItemSize(iconElement);
        }
        else if (currentAction.iconSize && typeof (currentAction.iconSize) === "number" && this.recalcMinDimensionConst) {
            iconSize = currentAction.iconSize;
        }
        var minDimensionConst = !!iconSize ? (iconSize + 2 * this.paddingSizeConst) : this.minDimensionConst;
        return currentAction.canShrink
            ? minDimensionConst +
                (currentAction.needSeparator ? this.separatorSize : 0)
            : currentAction.maxDimension;
    };
    ResponsivityManager.prototype.calcItemsSizes = function () {
        var _this = this;
        if (!this.container || this.isInitialized)
            return;
        var actions = this.model.actions;
        var _items = this.container.querySelectorAll(this.itemsSelector);
        (_items || []).forEach(function (item, index) {
            var currentAction = actions[index];
            if (!!currentAction) {
                _this.calcActionDimensions(currentAction, item);
            }
        });
    };
    ResponsivityManager.prototype.calcActionDimensions = function (currentAction, item) {
        currentAction.maxDimension = this.calcItemSize(item);
        currentAction.minDimension = this.calcMinDimension(currentAction, item);
    };
    Object.defineProperty(ResponsivityManager.prototype, "isContainerVisible", {
        get: function () {
            return !!this.container && isContainerVisible(this.container);
        },
        enumerable: false,
        configurable: true
    });
    ResponsivityManager.prototype.process = function () {
        var _this = this;
        if (this.isContainerVisible && !this.model.isResponsivenessDisabled) {
            if (!this.isInitialized) {
                this.model.setActionsMode("large");
            }
            var processResponsiveness_1 = function () {
                var _a;
                var dotsItemSize = _this.dotsItemSize;
                if (!_this.dotsItemSize) {
                    var dotsItemElement = (_a = _this.container) === null || _a === void 0 ? void 0 : _a.querySelector(_this.dotsIconClass);
                    dotsItemSize = dotsItemElement && _this.calcItemSize(dotsItemElement) || _this.dotsSizeConst;
                }
                _this.model.fit(_this.getAvailableSpace(), dotsItemSize);
            };
            if (!this.isInitialized) {
                var callback = function () {
                    if (!_this.container) {
                        return;
                    }
                    _this.calcItemsSizes();
                    _this.isInitialized = true;
                    processResponsiveness_1();
                };
                if (this.delayedUpdateFunction) {
                    this.delayedUpdateFunction(callback);
                }
                else {
                    callback();
                }
            }
            else {
                processResponsiveness_1();
            }
        }
    };
    ResponsivityManager.prototype.dispose = function () {
        this.model.updateCallback = undefined;
        if (!!this.resizeObserver) {
            this.resizeObserver.disconnect();
        }
        this.resizeObserver = undefined;
        this.container = undefined;
    };
    return ResponsivityManager;
}());

var VerticalResponsivityManager = /** @class */ (function (_super) {
    responsivity_manager_extends(VerticalResponsivityManager, _super);
    function VerticalResponsivityManager(container, model, itemsSelector, dotsItemSize, minDimension, delayedUpdateFunction) {
        if (minDimension === void 0) { minDimension = 40; }
        var _this = _super.call(this, container, model, itemsSelector, dotsItemSize, delayedUpdateFunction) || this;
        _this.minDimensionConst = minDimension;
        _this.recalcMinDimensionConst = false;
        return _this;
    }
    VerticalResponsivityManager.prototype.getDimensions = function () {
        return {
            scroll: this.container.scrollHeight,
            offset: this.container.offsetHeight,
        };
    };
    VerticalResponsivityManager.prototype.getAvailableSpace = function () {
        var style = this.getComputedStyle(this.container);
        var space = this.container.offsetHeight;
        if (style.boxSizing === "border-box") {
            space -= parseFloat(style.paddingTop) + parseFloat(style.paddingBottom);
        }
        return space;
    };
    VerticalResponsivityManager.prototype.calcItemSize = function (item) {
        return item.offsetHeight;
    };
    VerticalResponsivityManager.prototype.calcActionDimensions = function (currentAction, item) {
        currentAction.maxDimension = this.calcItemSize(item);
        currentAction.minDimension = this.calcItemSize(item);
    };
    return VerticalResponsivityManager;
}(responsivity_manager_ResponsivityManager));


// CONCATENATED MODULE: ./packages/survey-core/src/utils/cssClassBuilder.ts
var CssClassBuilder = /** @class */ (function () {
    function CssClassBuilder() {
        this.classes = [];
    }
    CssClassBuilder.prototype.isEmpty = function () {
        return this.toString() === "";
    };
    CssClassBuilder.prototype.append = function (value, condition) {
        if (condition === void 0) { condition = true; }
        if (!!value && condition) {
            if (typeof value === "string") {
                value = value.trim();
            }
            this.classes.push(value);
        }
        return this;
    };
    CssClassBuilder.prototype.toString = function () {
        return this.classes.join(" ");
    };
    return CssClassBuilder;
}());


// CONCATENATED MODULE: ./packages/survey-core/src/actions/container.ts
var container_extends = (undefined && undefined.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __decorate = (undefined && undefined.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};





var defaultActionBarCss = {
    root: "sv-action-bar",
    defaultSizeMode: "sv-action-bar--default-size-mode",
    smallSizeMode: "sv-action-bar--small-size-mode",
    item: "sv-action-bar-item",
    itemWithTitle: "",
    itemAsIcon: "sv-action-bar-item--icon",
    itemActive: "sv-action-bar-item--active",
    itemPressed: "sv-action-bar-item--pressed",
    itemIcon: "sv-action-bar-item__icon",
    itemTitle: "sv-action-bar-item__title",
    itemTitleWithIcon: "sv-action-bar-item__title--with-icon",
};
var container_ActionContainer = /** @class */ (function (_super) {
    container_extends(ActionContainer, _super);
    function ActionContainer() {
        var _this = _super !== null && _super.apply(this, arguments) || this;
        _this.sizeMode = "default";
        return _this;
    }
    ActionContainer.prototype.getMarkdownHtml = function (text, name) {
        return !!this.locOwner ? this.locOwner.getMarkdownHtml(text, name) : undefined;
    };
    ActionContainer.prototype.getRenderer = function (name) {
        return !!this.locOwner ? this.locOwner.getRenderer(name) : null;
    };
    ActionContainer.prototype.getRendererContext = function (locStr) {
        return !!this.locOwner ? this.locOwner.getRendererContext(locStr) : locStr;
    };
    ActionContainer.prototype.getProcessedText = function (text) {
        return this.locOwner ? this.locOwner.getProcessedText(text) : text;
    };
    ActionContainer.prototype.getLocale = function () {
        return !!this.locOwner ? this.locOwner.getLocale() : "";
    };
    ActionContainer.prototype.getRenderedActions = function () {
        return this.actions;
    };
    ActionContainer.prototype.locStrsChanged = function () {
        _super.prototype.locStrsChanged.call(this);
        this.actions.forEach(function (item) {
            if (item.locTitle)
                item.locTitle.strChanged();
            item.locStrsChanged();
        });
    };
    ActionContainer.prototype.raiseUpdate = function (isResetInitialized) {
        this.isEmpty = !this.actions.some(function (action) { return action.visible; });
        this.updateCallback && this.updateCallback(isResetInitialized);
    };
    ActionContainer.prototype.onSet = function () {
        var _this = this;
        this.actions.forEach(function (item) { _this.setActionCssClasses(item); });
        this.raiseUpdate(true);
    };
    ActionContainer.prototype.onPush = function (item) {
        this.setActionCssClasses(item);
        item.owner = this;
        this.raiseUpdate(true);
    };
    ActionContainer.prototype.onRemove = function (item) {
        item.owner = null;
        this.raiseUpdate(true);
    };
    ActionContainer.prototype.setActionCssClasses = function (item) {
        item.cssClasses = this.cssClasses;
    };
    Object.defineProperty(ActionContainer.prototype, "hasActions", {
        get: function () {
            return (this.actions || []).length > 0;
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(ActionContainer.prototype, "renderedActions", {
        get: function () {
            return this.getRenderedActions();
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(ActionContainer.prototype, "visibleActions", {
        get: function () {
            return this.actions.filter(function (action) { return action.visible !== false; });
        },
        enumerable: false,
        configurable: true
    });
    ActionContainer.prototype.getRootCss = function () {
        var sizeModeClass = this.sizeMode === "small" ? this.cssClasses.smallSizeMode : this.cssClasses.defaultSizeMode;
        return new CssClassBuilder().append(this.cssClasses.root + (!!sizeModeClass ? " " + sizeModeClass : "") + (!!this.containerCss ? " " + this.containerCss : ""))
            .append(this.cssClasses.root + "--empty", this.isEmpty)
            .toString();
    };
    ActionContainer.prototype.getDefaultCssClasses = function () {
        return defaultActionBarCss;
    };
    Object.defineProperty(ActionContainer.prototype, "cssClasses", {
        get: function () {
            if (!this.cssClassesValue) {
                this.cssClassesValue = this.getDefaultCssClasses();
            }
            return this.cssClassesValue;
        },
        set: function (val) {
            var _this = this;
            this.cssClassesValue = {};
            this.copyCssClasses(this.cssClassesValue, this.getDefaultCssClasses());
            mergeValues(val, this.cssClasses);
            this.actions.forEach(function (action) {
                _this.setActionCssClasses(action);
            });
        },
        enumerable: false,
        configurable: true
    });
    ActionContainer.prototype.createAction = function (item) {
        return (item instanceof action_BaseAction ? item : new action_Action(item));
    };
    ActionContainer.prototype.addAction = function (val, sortByVisibleIndex) {
        if (sortByVisibleIndex === void 0) { sortByVisibleIndex = true; }
        var res = this.createAction(val);
        if (sortByVisibleIndex && !this.isActionVisible(res))
            return res;
        var items = [].concat(this.actions, res);
        this.sortItems(items);
        this.actions = items;
        return res;
    };
    ActionContainer.prototype.setItems = function (items, sortByVisibleIndex) {
        var _this = this;
        if (sortByVisibleIndex === void 0) { sortByVisibleIndex = true; }
        var newActions = [];
        items.forEach(function (item) {
            if (!sortByVisibleIndex || _this.isActionVisible(item)) {
                newActions.push(_this.createAction(item));
            }
        });
        if (sortByVisibleIndex) {
            this.sortItems(newActions);
        }
        this.actions = newActions;
    };
    ActionContainer.prototype.sortItems = function (items) {
        if (this.hasSetVisibleIndex(items)) {
            items.sort(this.compareByVisibleIndex);
        }
    };
    ActionContainer.prototype.hasSetVisibleIndex = function (items) {
        for (var i = 0; i < items.length; i++) {
            var index = items[i].visibleIndex;
            if (index !== undefined && index >= 0)
                return true;
        }
        return false;
    };
    ActionContainer.prototype.compareByVisibleIndex = function (first, second) {
        return first.visibleIndex - second.visibleIndex;
    };
    ActionContainer.prototype.isActionVisible = function (item) {
        return item.visibleIndex >= 0 || item.visibleIndex === undefined;
    };
    ActionContainer.prototype.popupAfterShowCallback = function (itemValue) {
    };
    ActionContainer.prototype.mouseOverHandler = function (itemValue) {
        var _this = this;
        itemValue.isHovered = true;
        this.actions.forEach(function (action) {
            if (action === itemValue && !!itemValue.popupModel) {
                itemValue.showPopupDelayed(_this.subItemsShowDelay);
                _this.popupAfterShowCallback(itemValue);
            }
        });
    };
    ActionContainer.prototype.initResponsivityManager = function (container, delayedUpdateFunction) {
        return;
    };
    ActionContainer.prototype.resetResponsivityManager = function () { };
    ActionContainer.prototype.getActionById = function (id) {
        for (var i = 0; i < this.actions.length; i++) {
            if (this.actions[i].id === id)
                return this.actions[i];
        }
        return null;
    };
    ActionContainer.prototype.dispose = function () {
        _super.prototype.dispose.call(this);
        this.resetResponsivityManager();
        this.actions.forEach(function (action) { return action.dispose(); });
        this.actions.length = 0;
    };
    __decorate([
        propertyArray({
            onSet: function (_, target) {
                target.onSet();
            },
            onPush: function (item, i, target) {
                target.onPush(item);
            },
            onRemove: function (item, i, target) {
                target.onRemove(item);
            }
        })
    ], ActionContainer.prototype, "actions", void 0);
    __decorate([
        jsonobject_property({})
    ], ActionContainer.prototype, "containerCss", void 0);
    __decorate([
        jsonobject_property({ defaultValue: false })
    ], ActionContainer.prototype, "isEmpty", void 0);
    __decorate([
        jsonobject_property({ defaultValue: 300 })
    ], ActionContainer.prototype, "subItemsShowDelay", void 0);
    __decorate([
        jsonobject_property({ defaultValue: 300 })
    ], ActionContainer.prototype, "subItemsHideDelay", void 0);
    return ActionContainer;
}(base_Base));


// CONCATENATED MODULE: ./packages/survey-core/src/element-helper.ts

var element_helper_ElementHelper = /** @class */ (function () {
    function ElementHelper() {
    }
    ElementHelper.focusElement = function (element) {
        element && element.focus();
    };
    ElementHelper.visibility = function (node) {
        var style = DomDocumentHelper.getComputedStyle(node);
        if (style.display === "none" || style.visibility === "hidden")
            return false;
        return node.parentElement ? this.visibility(node.parentElement) : true;
    };
    ElementHelper.getNextElementPreorder = function (element) {
        var result = !!element.nextElementSibling ? element.nextElementSibling : element.parentElement.firstElementChild;
        if (this.visibility(result)) {
            return result;
        }
        else {
            return this.getNextElementPreorder(result);
        }
    };
    ElementHelper.getNextElementPostorder = function (element) {
        var result = !!element.previousElementSibling ? element.previousElementSibling : element.parentElement.lastElementChild;
        if (this.visibility(result)) {
            return result;
        }
        else {
            return this.getNextElementPostorder(result);
        }
    };
    ElementHelper.hasHorizontalScroller = function (element) {
        if (!!element) {
            return element.scrollWidth > element.offsetWidth;
        }
        return false;
    };
    ElementHelper.hasVerticalScroller = function (element) {
        if (!!element) {
            return element.scrollHeight > element.offsetHeight;
        }
        return false;
    };
    return ElementHelper;
}());


// CONCATENATED MODULE: ./packages/survey-core/src/list.ts
var list_extends = (undefined && undefined.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var list_decorate = (undefined && undefined.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};







var defaultListCss = {
    root: "sv-list__container",
    item: "sv-list__item",
    searchClearButtonIcon: "sv-list__filter-clear-button",
    loadingIndicator: "sv-list__loading-indicator",
    itemSelected: "sv-list__item--selected",
    itemGroup: "sv-list__item--group",
    itemGroupSelected: "sv-list__item--group-selected",
    itemWithIcon: "sv-list__item--with-icon",
    itemDisabled: "sv-list__item--disabled",
    itemFocused: "sv-list__item--focused",
    itemHovered: "sv-list__item--hovered",
    itemTextWrap: "sv-list__item-text--wrap",
    itemIcon: "sv-list__item-icon",
    itemMarkerIcon: "sv-list-item__marker-icon",
    itemSeparator: "sv-list__item-separator",
    itemBody: "sv-list__item-body",
    itemsContainer: "sv-list",
    itemsContainerFiltering: "sv-list--filtering",
    filter: "sv-list__filter",
    filterIcon: "sv-list__filter-icon",
    filterInput: "sv-list__input",
    emptyContainer: "sv-list__empty-container",
    emptyText: "sv-list__empty-text"
};
var list_ListModel = /** @class */ (function (_super) {
    list_extends(ListModel, _super);
    function ListModel(items, onSelectionChanged, allowSelection, selectedItem, elementId) {
        var _this = _super.call(this) || this;
        _this.onSelectionChanged = onSelectionChanged;
        _this.allowSelection = allowSelection;
        _this.elementId = elementId;
        _this.onItemClick = function (itemValue) {
            if (_this.isItemDisabled(itemValue)) {
                return;
            }
            _this.isExpanded = false;
            if (_this.allowSelection) {
                _this.selectedItem = itemValue;
            }
            if (!!_this.onSelectionChanged) {
                _this.onSelectionChanged(itemValue);
            }
            var action = itemValue.action;
            if (!!action) {
                action(itemValue);
            }
        };
        _this.onItemHover = function (itemValue) {
            _this.mouseOverHandler(itemValue);
        };
        _this.isItemDisabled = function (itemValue) {
            return itemValue.enabled !== undefined && !itemValue.enabled;
        };
        _this.isItemSelected = function (itemValue) {
            return _this.areSameItems(_this.selectedItem, itemValue);
        };
        _this.isItemFocused = function (itemValue) {
            return _this.areSameItems(_this.focusedItem, itemValue);
        };
        _this.getListClass = function () {
            return new CssClassBuilder()
                .append(_this.cssClasses.itemsContainer)
                .append(_this.cssClasses.itemsContainerFiltering, !!_this.filterString && _this.visibleActions.length !== _this.visibleItems.length)
                .toString();
        };
        _this.getItemClass = function (itemValue) {
            var isSelected = _this.isItemSelected(itemValue);
            return new CssClassBuilder()
                .append(_this.cssClasses.item)
                .append(_this.cssClasses.itemWithIcon, !!itemValue.iconName)
                .append(_this.cssClasses.itemDisabled, _this.isItemDisabled(itemValue))
                .append(_this.cssClasses.itemFocused, _this.isItemFocused(itemValue))
                .append(_this.cssClasses.itemSelected, !itemValue.hasSubItems && isSelected)
                .append(_this.cssClasses.itemGroup, itemValue.hasSubItems)
                .append(_this.cssClasses.itemGroupSelected, itemValue.hasSubItems && isSelected)
                .append(_this.cssClasses.itemHovered, itemValue.isHovered)
                .append(_this.cssClasses.itemTextWrap, _this.textWrapEnabled)
                .append(itemValue.css)
                .toString();
        };
        // public getItemIndent = (itemValue: any) => {
        //   const level: number = itemValue.level || 0;
        //   return (level + 1) * ListModel.INDENT + "px";
        // };
        _this.getItemStyle = function (itemValue) {
            var level = itemValue.level || 0;
            return {
                "--sjs-list-item-level": level + 1
            };
        };
        if (Object.keys(items).indexOf("items") !== -1) {
            var options_1 = items;
            Object.keys(options_1).forEach(function (key) {
                switch (key) {
                    case "items":
                        _this.setItems(options_1.items);
                        break;
                    case "onFilterStringChangedCallback":
                        _this.setOnFilterStringChangedCallback(options_1.onFilterStringChangedCallback);
                        break;
                    case "onTextSearchCallback":
                        _this.setOnTextSearchCallback(options_1.onTextSearchCallback);
                        break;
                    default:
                        _this[key] = options_1[key];
                }
            });
            _this.updateActionsIds();
        }
        else {
            _this.setItems(items);
            _this.selectedItem = selectedItem;
        }
        return _this;
    }
    ListModel.prototype.hasText = function (item, filterStringInLow) {
        if (!filterStringInLow)
            return true;
        var text = item.title || "";
        if (this.onTextSearchCallback)
            return this.onTextSearchCallback(item, filterStringInLow);
        var textInLow = text.toLocaleLowerCase();
        textInLow = settings.comparator.normalizeTextCallback(textInLow, "filter");
        return textInLow.indexOf(filterStringInLow.toLocaleLowerCase()) > -1;
    };
    ListModel.prototype.isItemVisible = function (item) {
        return item.visible && (!this.shouldProcessFilter || this.hasText(item, this.filterString));
    };
    ListModel.prototype.getRenderedActions = function () {
        var actions = _super.prototype.getRenderedActions.call(this);
        if (this.filterString) {
            var newActions_1 = [];
            actions.forEach(function (action) {
                newActions_1.push(action);
                if (action.items) {
                    action.items.forEach(function (item) {
                        var a = new action_Action(item);
                        if (!a.iconName) {
                            a.iconName = action.iconName;
                        }
                        newActions_1.push(a);
                    });
                }
            });
            return newActions_1;
        }
        return actions;
    };
    Object.defineProperty(ListModel.prototype, "visibleItems", {
        get: function () {
            var _this = this;
            return this.visibleActions.filter(function (item) { return _this.isItemVisible(item); });
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(ListModel.prototype, "shouldProcessFilter", {
        get: function () {
            return !this.onFilterStringChangedCallback;
        },
        enumerable: false,
        configurable: true
    });
    ListModel.prototype.onFilterStringChanged = function (text) {
        if (!!this.onFilterStringChangedCallback) {
            this.onFilterStringChangedCallback(text);
        }
        this.updateIsEmpty();
    };
    ListModel.prototype.updateIsEmpty = function () {
        var _this = this;
        this.isEmpty = this.renderedActions.filter(function (action) { return _this.isItemVisible(action); }).length === 0;
    };
    ListModel.prototype.scrollToItem = function (classes, ms) {
        var _this = this;
        if (ms === void 0) { ms = 0; }
        setTimeout(function () {
            if (!_this.listContainerHtmlElement)
                return;
            var item = _this.listContainerHtmlElement.querySelector(classesToSelector(classes));
            if (item) {
                setTimeout(function () {
                    item.scrollIntoView({ behavior: "smooth", block: "nearest", inline: "start" });
                }, ms);
            }
        }, ms);
    };
    ListModel.prototype.setOnFilterStringChangedCallback = function (callback) {
        this.onFilterStringChangedCallback = callback;
    };
    ListModel.prototype.setOnTextSearchCallback = function (callback) {
        this.onTextSearchCallback = callback;
    };
    ListModel.prototype.setItems = function (items, sortByVisibleIndex) {
        if (sortByVisibleIndex === void 0) { sortByVisibleIndex = true; }
        _super.prototype.setItems.call(this, items, sortByVisibleIndex);
        this.updateActionsIds();
        if (!this.isAllDataLoaded && !!this.actions.length) {
            this.actions.push(this.loadingIndicator);
        }
    };
    ListModel.prototype.updateActionsIds = function () {
        var _this = this;
        if (this.elementId) {
            this.renderedActions.forEach(function (action) { action.elementId = _this.elementId + action.id; });
        }
    };
    ListModel.prototype.setSearchEnabled = function (newValue) {
        this.searchEnabled = newValue;
        this.showSearchClearButton = newValue;
    };
    ListModel.prototype.onSet = function () {
        this.showFilter = this.searchEnabled && (this.forceShowFilter || (this.actions || []).length > ListModel.MINELEMENTCOUNT);
        _super.prototype.onSet.call(this);
    };
    ListModel.prototype.getDefaultCssClasses = function () {
        return defaultListCss;
    };
    ListModel.prototype.popupAfterShowCallback = function (itemValue) {
        this.addScrollEventListener(function () {
            itemValue.hidePopup();
        });
    };
    ListModel.prototype.onItemLeave = function (itemValue) {
        itemValue.hidePopupDelayed(this.subItemsHideDelay);
    };
    ListModel.prototype.areSameItems = function (item1, item2) {
        if (!!this.areSameItemsCallback)
            return this.areSameItemsCallback(item1, item2);
        return !!item1 && !!item2 && item1.id == item2.id;
    };
    Object.defineProperty(ListModel.prototype, "filterStringPlaceholder", {
        get: function () {
            return this.getLocalizationString("filterStringPlaceholder");
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(ListModel.prototype, "emptyMessage", {
        get: function () {
            return this.isAllDataLoaded ? this.getLocalizationString("emptyMessage") : this.loadingText;
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(ListModel.prototype, "scrollableContainer", {
        get: function () {
            return this.listContainerHtmlElement.querySelector(classesToSelector(this.cssClasses.itemsContainer));
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(ListModel.prototype, "loadingText", {
        get: function () {
            return this.getLocalizationString("loadingFile");
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(ListModel.prototype, "loadingIndicator", {
        get: function () {
            if (!this.loadingIndicatorValue) {
                this.loadingIndicatorValue = (new action_Action({
                    id: "loadingIndicator",
                    title: this.loadingText,
                    action: function () { },
                    css: this.cssClasses.loadingIndicator
                }));
            }
            return this.loadingIndicatorValue;
        },
        enumerable: false,
        configurable: true
    });
    ListModel.prototype.goToItems = function (event) {
        if (event.key === "ArrowDown" || event.keyCode === 40) {
            var currentElement = event.target.parentElement;
            var listElement = currentElement.parentElement.querySelector("ul");
            var firstChild = getFirstVisibleChild(listElement);
            if (!!listElement && !!firstChild) {
                element_helper_ElementHelper.focusElement(firstChild);
                event.preventDefault();
            }
        }
    };
    ListModel.prototype.onMouseMove = function (event) {
        this.resetFocusedItem();
    };
    ListModel.prototype.onKeyDown = function (event) {
        var currentElement = event.target;
        if (event.key === "ArrowDown" || event.keyCode === 40) {
            element_helper_ElementHelper.focusElement(element_helper_ElementHelper.getNextElementPreorder(currentElement));
            event.preventDefault();
        }
        else if (event.key === "ArrowUp" || event.keyCode === 38) {
            element_helper_ElementHelper.focusElement(element_helper_ElementHelper.getNextElementPostorder(currentElement));
            event.preventDefault();
        }
    };
    ListModel.prototype.onPointerDown = function (event, item) { };
    ListModel.prototype.refresh = function () {
        if (this.filterString !== "") {
            this.filterString = "";
        }
        else {
            this.updateIsEmpty();
        }
        this.resetFocusedItem();
    };
    ListModel.prototype.onClickSearchClearButton = function (event) {
        event.currentTarget.parentElement.querySelector("input").focus();
        this.refresh();
    };
    ListModel.prototype.resetFocusedItem = function () {
        this.focusedItem = undefined;
    };
    ListModel.prototype.focusFirstVisibleItem = function () {
        this.focusedItem = this.visibleItems[0];
    };
    ListModel.prototype.focusLastVisibleItem = function () {
        this.focusedItem = this.visibleItems[this.visibleItems.length - 1];
    };
    ListModel.prototype.initFocusedItem = function () {
        var _this = this;
        this.focusedItem = this.visibleItems.filter(function (item) { return item.visible && _this.isItemSelected(item); })[0];
        if (!this.focusedItem) {
            this.focusFirstVisibleItem();
        }
    };
    ListModel.prototype.focusNextVisibleItem = function () {
        if (!this.focusedItem) {
            this.initFocusedItem();
        }
        else {
            var items = this.visibleItems;
            var currentFocusedItemIndex = items.indexOf(this.focusedItem);
            var nextItem = items[currentFocusedItemIndex + 1];
            if (nextItem) {
                this.focusedItem = nextItem;
            }
            else {
                this.focusFirstVisibleItem();
            }
        }
    };
    ListModel.prototype.focusPrevVisibleItem = function () {
        if (!this.focusedItem) {
            this.initFocusedItem();
        }
        else {
            var items = this.visibleItems;
            var currentFocusedItemIndex = items.indexOf(this.focusedItem);
            var prevItem = items[currentFocusedItemIndex - 1];
            if (prevItem) {
                this.focusedItem = prevItem;
            }
            else {
                this.focusLastVisibleItem();
            }
        }
    };
    ListModel.prototype.selectFocusedItem = function () {
        !!this.focusedItem && this.onItemClick(this.focusedItem);
    };
    ListModel.prototype.initListContainerHtmlElement = function (htmlElement) {
        this.listContainerHtmlElement = htmlElement;
    };
    ListModel.prototype.onLastItemRended = function (item) {
        if (this.isAllDataLoaded)
            return;
        if (item === this.actions[this.actions.length - 1] && !!this.listContainerHtmlElement) {
            this.hasVerticalScroller = element_helper_ElementHelper.hasVerticalScroller(this.scrollableContainer);
        }
    };
    ListModel.prototype.scrollToFocusedItem = function () {
        this.scrollToItem(this.cssClasses.itemFocused);
    };
    ListModel.prototype.scrollToSelectedItem = function () {
        if (!!this.selectedItem && this.selectedItem.items && this.selectedItem.items.length > 0) {
            this.scrollToItem(this.cssClasses.itemGroupSelected, 110);
        }
        else {
            this.scrollToItem(this.cssClasses.itemSelected, 110);
        }
    };
    ListModel.prototype.addScrollEventListener = function (handler) {
        if (!!handler) {
            this.removeScrollEventListener();
            this.scrollHandler = handler;
        }
        if (!!this.scrollHandler) {
            this.scrollableContainer.addEventListener("scroll", this.scrollHandler);
        }
    };
    ListModel.prototype.removeScrollEventListener = function () {
        if (!!this.scrollHandler) {
            this.scrollableContainer.removeEventListener("scroll", this.scrollHandler);
        }
    };
    ListModel.prototype.dispose = function () {
        _super.prototype.dispose.call(this);
        if (!!this.loadingIndicatorValue) {
            this.loadingIndicatorValue.dispose();
        }
        this.listContainerHtmlElement = undefined;
    };
    ListModel.INDENT = 16;
    ListModel.MINELEMENTCOUNT = 10;
    list_decorate([
        jsonobject_property({
            defaultValue: true,
            onSet: function (newValue, target) {
                target.onSet();
            }
        })
    ], ListModel.prototype, "searchEnabled", void 0);
    list_decorate([
        jsonobject_property({ defaultValue: false })
    ], ListModel.prototype, "showFilter", void 0);
    list_decorate([
        jsonobject_property({ defaultValue: false })
    ], ListModel.prototype, "forceShowFilter", void 0);
    list_decorate([
        jsonobject_property({ defaultValue: false })
    ], ListModel.prototype, "isExpanded", void 0);
    list_decorate([
        jsonobject_property({})
    ], ListModel.prototype, "selectedItem", void 0);
    list_decorate([
        jsonobject_property()
    ], ListModel.prototype, "focusedItem", void 0);
    list_decorate([
        jsonobject_property({
            onSet: function (_, target) {
                target.onFilterStringChanged(target.filterString);
            }
        })
    ], ListModel.prototype, "filterString", void 0);
    list_decorate([
        jsonobject_property({ defaultValue: false })
    ], ListModel.prototype, "hasVerticalScroller", void 0);
    list_decorate([
        jsonobject_property({ defaultValue: true })
    ], ListModel.prototype, "isAllDataLoaded", void 0);
    list_decorate([
        jsonobject_property({ defaultValue: false })
    ], ListModel.prototype, "showSearchClearButton", void 0);
    list_decorate([
        jsonobject_property({ defaultValue: true })
    ], ListModel.prototype, "renderElements", void 0);
    list_decorate([
        jsonobject_property({ defaultValue: false })
    ], ListModel.prototype, "textWrapEnabled", void 0);
    list_decorate([
        jsonobject_property({ defaultValue: "sv-list-item-content" })
    ], ListModel.prototype, "itemComponent", void 0);
    return ListModel;
}(container_ActionContainer));


// CONCATENATED MODULE: ./packages/survey-core/src/popup.ts
var popup_extends = (undefined && undefined.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var popup_decorate = (undefined && undefined.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};



var popup_PopupModel = /** @class */ (function (_super) {
    popup_extends(PopupModel, _super);
    function PopupModel(contentComponentName, contentComponentData, option1, option2) {
        var _this = _super.call(this) || this;
        _this.focusFirstInputSelector = "";
        _this.onCancel = function () { };
        _this.onApply = function () { return true; };
        _this.onHide = function () { };
        _this.onShow = function () { };
        _this.onDispose = function () { };
        _this.onVisibilityChanged = _this.addEvent();
        _this.onFooterActionsCreated = _this.addEvent();
        _this.onRecalculatePosition = _this.addEvent();
        _this.contentComponentName = contentComponentName;
        _this.contentComponentData = contentComponentData;
        if (!!option1 && typeof option1 === "string") {
            _this.verticalPosition = option1;
            _this.horizontalPosition = option2;
        }
        else if (!!option1) {
            var popupOptions = option1;
            for (var key in popupOptions) {
                _this[key] = popupOptions[key];
            }
        }
        return _this;
    }
    PopupModel.prototype.refreshInnerModel = function () {
        var innerModel = this.contentComponentData["model"];
        innerModel && innerModel.refresh && innerModel.refresh();
    };
    Object.defineProperty(PopupModel.prototype, "isVisible", {
        get: function () {
            return this.getPropertyValue("isVisible", false);
        },
        set: function (value) {
            if (this.isVisible === value) {
                return;
            }
            this.setPropertyValue("isVisible", value);
            this.onVisibilityChanged.fire(this, { model: this, isVisible: value });
        },
        enumerable: false,
        configurable: true
    });
    PopupModel.prototype.toggleVisibility = function () {
        this.isVisible = !this.isVisible;
    };
    PopupModel.prototype.show = function () {
        if (!this.isVisible)
            this.isVisible = true;
    };
    PopupModel.prototype.hide = function () {
        if (this.isVisible)
            this.isVisible = false;
    };
    PopupModel.prototype.recalculatePosition = function (isResetHeight) {
        this.onRecalculatePosition.fire(this, { isResetHeight: isResetHeight });
    };
    PopupModel.prototype.updateFooterActions = function (footerActions) {
        var options = { actions: footerActions };
        this.onFooterActionsCreated.fire(this, options);
        return options.actions;
    };
    PopupModel.prototype.updateDisplayMode = function (menuType) {
        if (this.displayMode !== menuType) {
            this.setWidthByTarget = menuType === "dropdown";
        }
        switch (menuType) {
            case "dropdown": {
                this.displayMode = "popup";
                break;
            }
            case "popup": {
                this.displayMode = "overlay";
                this.overlayDisplayMode = "tablet-dropdown-overlay";
                break;
            }
            case "overlay": {
                this.displayMode = "overlay";
                this.overlayDisplayMode = "dropdown-overlay";
                break;
            }
        }
    };
    PopupModel.prototype.onHiding = function () {
        this.refreshInnerModel();
        this.onHide();
    };
    PopupModel.prototype.dispose = function () {
        _super.prototype.dispose.call(this);
        this.onDispose();
    };
    popup_decorate([
        jsonobject_property()
    ], PopupModel.prototype, "contentComponentName", void 0);
    popup_decorate([
        jsonobject_property()
    ], PopupModel.prototype, "contentComponentData", void 0);
    popup_decorate([
        jsonobject_property({ defaultValue: "bottom" })
    ], PopupModel.prototype, "verticalPosition", void 0);
    popup_decorate([
        jsonobject_property({ defaultValue: "left" })
    ], PopupModel.prototype, "horizontalPosition", void 0);
    popup_decorate([
        jsonobject_property({ defaultValue: true })
    ], PopupModel.prototype, "showPointer", void 0);
    popup_decorate([
        jsonobject_property({ defaultValue: false })
    ], PopupModel.prototype, "isModal", void 0);
    popup_decorate([
        jsonobject_property({ defaultValue: true })
    ], PopupModel.prototype, "canShrink", void 0);
    popup_decorate([
        jsonobject_property({ defaultValue: true })
    ], PopupModel.prototype, "isFocusedContent", void 0);
    popup_decorate([
        jsonobject_property({ defaultValue: true })
    ], PopupModel.prototype, "isFocusedContainer", void 0);
    popup_decorate([
        jsonobject_property({ defaultValue: "" })
    ], PopupModel.prototype, "cssClass", void 0);
    popup_decorate([
        jsonobject_property({ defaultValue: "" })
    ], PopupModel.prototype, "title", void 0);
    popup_decorate([
        jsonobject_property({ defaultValue: "auto" })
    ], PopupModel.prototype, "overlayDisplayMode", void 0);
    popup_decorate([
        jsonobject_property({ defaultValue: "popup" })
    ], PopupModel.prototype, "displayMode", void 0);
    popup_decorate([
        jsonobject_property({ defaultValue: "flex" })
    ], PopupModel.prototype, "positionMode", void 0);
    return PopupModel;
}(base_Base));

function createDialogOptions(componentName, data, onApply, onCancel, onHide, onShow, cssClass, title, displayMode) {
    if (onHide === void 0) { onHide = function () { }; }
    if (onShow === void 0) { onShow = function () { }; }
    if (displayMode === void 0) { displayMode = "popup"; }
    ConsoleWarnings.warn("The `showModal()` and `createDialogOptions()` methods are obsolete. Use the `showDialog()` method instead.");
    return {
        componentName: componentName,
        data: data,
        onApply: onApply,
        onCancel: onCancel,
        onHide: onHide,
        onShow: onShow,
        cssClass: cssClass,
        title: title,
        displayMode: displayMode
    };
}

// CONCATENATED MODULE: ./packages/survey-core/src/actions/action.ts
var action_extends = (undefined && undefined.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var action_decorate = (undefined && undefined.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var action_spreadArray = (undefined && undefined.__spreadArray) || function (to, from) {
    for (var i = 0, il = from.length, j = to.length; i < il; i++, j++)
        to[j] = from[i];
    return to;
};







function createDropdownActionModel(actionOptions, dropdownOptions, locOwner) {
    dropdownOptions.locOwner = locOwner;
    return createDropdownActionModelAdvanced(actionOptions, dropdownOptions, dropdownOptions);
}
function createDropdownActionModelAdvanced(actionOptions, listOptions, popupOptions) {
    var _a;
    var originalSelectionChanged = listOptions.onSelectionChanged;
    listOptions.onSelectionChanged = function (item) {
        var params = [];
        for (var _i = 1; _i < arguments.length; _i++) {
            params[_i - 1] = arguments[_i];
        }
        if (newAction.hasTitle) {
            newAction.title = item.title;
        }
        if (originalSelectionChanged) {
            originalSelectionChanged(item, params);
        }
    };
    var popupModel = createPopupModelWithListModel(listOptions, popupOptions);
    popupModel.getTargetCallback = getActionDropdownButtonTarget;
    var newActionOptions = Object.assign({}, actionOptions, {
        component: "sv-action-bar-item-dropdown",
        popupModel: popupModel,
        action: function (action, isUserAction) {
            !!(actionOptions.action) && actionOptions.action();
            popupModel.isFocusedContent = popupModel.isFocusedContent || !isUserAction;
            popupModel.show();
        },
    });
    var newAction = new action_Action(newActionOptions);
    newAction.data = (_a = popupModel.contentComponentData) === null || _a === void 0 ? void 0 : _a.model;
    return newAction;
}
function createPopupModelWithListModel(listOptions, popupOptions) {
    var listModel = new list_ListModel(listOptions);
    listModel.onSelectionChanged = function (item) {
        if (listOptions.onSelectionChanged) {
            listOptions.onSelectionChanged(item);
        }
        popupModel.hide();
    };
    var _popupOptions = popupOptions || {};
    _popupOptions.onDispose = function () { listModel.dispose(); };
    var popupModel = new popup_PopupModel("sv-list", { model: listModel }, _popupOptions);
    popupModel.isFocusedContent = listModel.showFilter;
    popupModel.onShow = function () {
        if (!!_popupOptions.onShow)
            _popupOptions.onShow();
        listModel.scrollToSelectedItem();
    };
    return popupModel;
}
function getActionDropdownButtonTarget(container) {
    return container === null || container === void 0 ? void 0 : container.previousElementSibling;
}
var action_BaseAction = /** @class */ (function (_super) {
    action_extends(BaseAction, _super);
    function BaseAction() {
        var _this = _super !== null && _super.apply(this, arguments) || this;
        _this.rendredIdValue = BaseAction.getNextRendredId();
        return _this;
    }
    BaseAction.getNextRendredId = function () { return BaseAction.renderedId++; };
    Object.defineProperty(BaseAction.prototype, "renderedId", {
        get: function () { return this.rendredIdValue; },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(BaseAction.prototype, "owner", {
        get: function () { return this.ownerValue; },
        set: function (val) {
            if (val !== this.owner) {
                this.ownerValue = val;
                this.locStrsChanged();
            }
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(BaseAction.prototype, "visible", {
        get: function () {
            return this.getVisible();
        },
        set: function (val) {
            this.setVisible(val);
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(BaseAction.prototype, "enabled", {
        get: function () {
            return this.getEnabled();
        },
        set: function (val) {
            this.setEnabled(val);
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(BaseAction.prototype, "component", {
        get: function () {
            return this.getComponent();
        },
        set: function (val) {
            this.setComponent(val);
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(BaseAction.prototype, "locTitle", {
        get: function () {
            return this.getLocTitle();
        },
        set: function (val) {
            this.setLocTitle(val);
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(BaseAction.prototype, "title", {
        get: function () {
            return this.getTitle();
        },
        set: function (val) {
            this.setTitle(val);
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(BaseAction.prototype, "cssClasses", {
        get: function () {
            return this.cssClassesValue || defaultActionBarCss;
        },
        set: function (val) {
            this.cssClassesValue = val;
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(BaseAction.prototype, "isVisible", {
        get: function () {
            return this.visible && this.mode !== "popup" && this.mode !== "removed";
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(BaseAction.prototype, "disabled", {
        get: function () {
            return this.enabled !== undefined && !this.enabled;
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(BaseAction.prototype, "canShrink", {
        get: function () {
            return !this.disableShrink && !!this.iconName;
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(BaseAction.prototype, "hasTitle", {
        get: function () {
            return (((this.mode != "small" &&
                (this.showTitle || this.showTitle === undefined)) ||
                !this.iconName) &&
                !!this.title);
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(BaseAction.prototype, "hasSubItems", {
        get: function () {
            return !!this.items && this.items.length > 0;
        },
        enumerable: false,
        configurable: true
    });
    BaseAction.prototype.getActionBarItemTitleCss = function () {
        return new CssClassBuilder()
            .append(this.cssClasses.itemTitle)
            .append(this.cssClasses.itemTitleWithIcon, !!this.iconName)
            .toString();
    };
    BaseAction.prototype.getActionBarItemCss = function () {
        return new CssClassBuilder()
            .append(this.cssClasses.item)
            .append(this.cssClasses.itemWithTitle, this.hasTitle)
            .append(this.cssClasses.itemAsIcon, !this.hasTitle)
            .append(this.cssClasses.itemActive, !!this.active)
            .append(this.cssClasses.itemPressed, !!this.pressed)
            .append(this.innerCss)
            .toString();
    };
    BaseAction.prototype.getActionRootCss = function () {
        return new CssClassBuilder()
            .append("sv-action")
            .append(this.css)
            .append("sv-action--space", this.needSpace)
            .append("sv-action--hidden", !this.isVisible)
            .toString();
    };
    BaseAction.prototype.getTooltip = function () {
        return this.tooltip || this.title;
    };
    BaseAction.prototype.getIsTrusted = function (args) {
        if (!!args.originalEvent) {
            return args.originalEvent.isTrusted;
        }
        return args.isTrusted;
    };
    BaseAction.prototype.showPopup = function () {
        if (!!this.popupModel) {
            this.popupModel.show();
        }
    };
    BaseAction.prototype.hidePopup = function () {
        if (!!this.popupModel) {
            this.popupModel.hide();
        }
    };
    BaseAction.prototype.clearPopupTimeouts = function () {
        if (this.showPopupTimeout)
            clearTimeout(this.showPopupTimeout);
        if (this.hidePopupTimeout)
            clearTimeout(this.hidePopupTimeout);
    };
    BaseAction.prototype.showPopupDelayed = function (delay) {
        var _this = this;
        this.clearPopupTimeouts();
        this.showPopupTimeout = setTimeout(function () {
            _this.clearPopupTimeouts();
            _this.showPopup();
        }, delay);
    };
    BaseAction.prototype.hidePopupDelayed = function (delay) {
        var _this = this;
        var _a;
        if ((_a = this.popupModel) === null || _a === void 0 ? void 0 : _a.isVisible) {
            this.clearPopupTimeouts();
            this.hidePopupTimeout = setTimeout(function () {
                _this.clearPopupTimeouts();
                _this.hidePopup();
                _this.isHovered = false;
            }, delay);
        }
        else {
            this.clearPopupTimeouts();
            this.isHovered = false;
        }
    };
    BaseAction.renderedId = 1;
    action_decorate([
        jsonobject_property()
    ], BaseAction.prototype, "tooltip", void 0);
    action_decorate([
        jsonobject_property()
    ], BaseAction.prototype, "showTitle", void 0);
    action_decorate([
        jsonobject_property()
    ], BaseAction.prototype, "innerCss", void 0);
    action_decorate([
        jsonobject_property()
    ], BaseAction.prototype, "active", void 0);
    action_decorate([
        jsonobject_property()
    ], BaseAction.prototype, "pressed", void 0);
    action_decorate([
        jsonobject_property()
    ], BaseAction.prototype, "data", void 0);
    action_decorate([
        jsonobject_property()
    ], BaseAction.prototype, "popupModel", void 0);
    action_decorate([
        jsonobject_property()
    ], BaseAction.prototype, "needSeparator", void 0);
    action_decorate([
        jsonobject_property()
    ], BaseAction.prototype, "template", void 0);
    action_decorate([
        jsonobject_property({ defaultValue: "large" })
    ], BaseAction.prototype, "mode", void 0);
    action_decorate([
        jsonobject_property()
    ], BaseAction.prototype, "visibleIndex", void 0);
    action_decorate([
        jsonobject_property()
    ], BaseAction.prototype, "disableTabStop", void 0);
    action_decorate([
        jsonobject_property()
    ], BaseAction.prototype, "disableShrink", void 0);
    action_decorate([
        jsonobject_property()
    ], BaseAction.prototype, "disableHide", void 0);
    action_decorate([
        jsonobject_property({ defaultValue: false })
    ], BaseAction.prototype, "needSpace", void 0);
    action_decorate([
        jsonobject_property()
    ], BaseAction.prototype, "ariaChecked", void 0);
    action_decorate([
        jsonobject_property()
    ], BaseAction.prototype, "ariaExpanded", void 0);
    action_decorate([
        jsonobject_property({ defaultValue: "button" })
    ], BaseAction.prototype, "ariaRole", void 0);
    action_decorate([
        jsonobject_property()
    ], BaseAction.prototype, "iconName", void 0);
    action_decorate([
        jsonobject_property({ defaultValue: 24 })
    ], BaseAction.prototype, "iconSize", void 0);
    action_decorate([
        jsonobject_property()
    ], BaseAction.prototype, "markerIconName", void 0);
    action_decorate([
        jsonobject_property()
    ], BaseAction.prototype, "css", void 0);
    action_decorate([
        jsonobject_property({ defaultValue: false })
    ], BaseAction.prototype, "isPressed", void 0);
    action_decorate([
        jsonobject_property({ defaultValue: false })
    ], BaseAction.prototype, "isHovered", void 0);
    return BaseAction;
}(base_Base));

var action_Action = /** @class */ (function (_super) {
    action_extends(Action, _super);
    function Action(innerItemData) {
        var _this = _super.call(this) || this;
        _this.locTitleChanged = function () {
            var val = _this.locTitle.renderedHtml;
            _this.setPropertyValue("_title", !!val ? val : undefined);
        };
        var innerItem = (innerItemData instanceof Action) ? innerItemData.innerItem : innerItemData;
        _this.innerItem = innerItem;
        _this.locTitle = !!innerItem ? innerItem["locTitle"] : null;
        //Object.assign(this, item) to support IE11
        if (!!innerItem) {
            for (var key in innerItem) {
                if (key === "locTitle" || key === "title" && !!_this.locTitle && !!_this.title)
                    continue;
                _this[key] = innerItem[key];
            }
        }
        if (!!_this.locTitleName) {
            _this.locTitleChanged();
        }
        _this.registerFunctionOnPropertyValueChanged("_title", function () {
            _this.raiseUpdate(true);
        });
        _this.locStrChangedInPopupModel();
        return _this;
    }
    Action.prototype.raiseUpdate = function (isResetInitialized) {
        if (isResetInitialized === void 0) { isResetInitialized = false; }
        this.updateCallback && this.updateCallback(isResetInitialized);
    };
    Action.prototype.createLocTitle = function () {
        return this.createLocalizableString("title", this, true);
    };
    Action.prototype.setSubItems = function (options) {
        this.markerIconName = "icon-next_16x16";
        this.component = "sv-list-item-group";
        this.items = action_spreadArray([], options.items);
        var listOptions = Object.assign({}, options);
        listOptions.searchEnabled = false;
        var popupModel = createPopupModelWithListModel(listOptions, { horizontalPosition: "right", showPointer: false, canShrink: false });
        popupModel.cssClass = "sv-popup-inner";
        this.popupModel = popupModel;
    };
    Action.prototype.getLocTitle = function () {
        return this.locTitleValue;
    };
    Action.prototype.setLocTitle = function (val) {
        if (!val && !this.locTitleValue) {
            val = this.createLocTitle();
        }
        if (!!this.locTitleValue) {
            this.locTitleValue.onStringChanged.remove(this.locTitleChanged);
        }
        this.locTitleValue = val;
        this.locTitleValue.onStringChanged.add(this.locTitleChanged);
        this.locTitleChanged();
    };
    Action.prototype.getTitle = function () {
        return this._title;
    };
    Action.prototype.setTitle = function (val) {
        this._title = val;
    };
    Object.defineProperty(Action.prototype, "locTitleName", {
        get: function () {
            return this.locTitle.localizationName;
        },
        set: function (val) {
            this.locTitle.localizationName = val;
        },
        enumerable: false,
        configurable: true
    });
    Action.prototype.locStrsChanged = function () {
        _super.prototype.locStrsChanged.call(this);
        this.locTooltipChanged();
        this.locStrChangedInPopupModel();
    };
    Action.prototype.doAction = function (args) {
        var evt = !!args.originalEvent ? args.originalEvent : args;
        this.action(this, evt.isTrusted);
        evt.preventDefault();
        evt.stopPropagation();
        return true;
    };
    Action.prototype.doMouseDown = function (args) {
        this.isMouseDown = true;
    };
    Action.prototype.doFocus = function (args) {
        if (!!this.onFocus) {
            var evt = !!args.originalEvent ? args.originalEvent : args;
            this.onFocus(this.isMouseDown, evt);
        }
        this.isMouseDown = false;
    };
    Action.prototype.locStrChangedInPopupModel = function () {
        if (!this.popupModel || !this.popupModel.contentComponentData || !this.popupModel.contentComponentData.model)
            return;
        var model = this.popupModel.contentComponentData.model;
        if (Array.isArray(model.actions)) {
            var actions = model.actions;
            actions.forEach(function (item) {
                if (!!item.locStrsChanged) {
                    item.locStrsChanged();
                }
            });
        }
    };
    Action.prototype.locTooltipChanged = function () {
        if (!this.locTooltipName)
            return;
        this.tooltip = getLocaleString(this.locTooltipName, this.locTitle.locale);
    };
    //ILocalizableOwner
    Action.prototype.getLocale = function () { return this.owner ? this.owner.getLocale() : ""; };
    Action.prototype.getMarkdownHtml = function (text, name) { return this.owner ? this.owner.getMarkdownHtml(text, name) : undefined; };
    Action.prototype.getProcessedText = function (text) { return this.owner ? this.owner.getProcessedText(text) : text; };
    Action.prototype.getRenderer = function (name) { return this.owner ? this.owner.getRenderer(name) : null; };
    Action.prototype.getRendererContext = function (locStr) { return this.owner ? this.owner.getRendererContext(locStr) : locStr; };
    Action.prototype.setVisible = function (val) {
        if (this.visible !== val) {
            this._visible = val;
        }
    };
    Action.prototype.getVisible = function () {
        return this._visible;
    };
    Action.prototype.setEnabled = function (val) {
        this._enabled = val;
    };
    Action.prototype.getEnabled = function () {
        if (this.enabledIf)
            return this.enabledIf();
        return this._enabled;
    };
    Action.prototype.setComponent = function (val) {
        this._component = val;
    };
    Action.prototype.getComponent = function () {
        return this._component;
    };
    Action.prototype.dispose = function () {
        this.updateCallback = undefined;
        if (!!this.locTitleValue) {
            this.locTitleValue.onStringChanged.remove(this.locTitleChanged);
        }
        this.locTitleChanged = undefined;
        this.action = undefined;
        _super.prototype.dispose.call(this);
        if (this.popupModel) {
            this.popupModel.dispose();
        }
    };
    action_decorate([
        jsonobject_property()
    ], Action.prototype, "id", void 0);
    action_decorate([
        jsonobject_property({
            defaultValue: true,
            onSet: function (_, target) {
                target.raiseUpdate();
            }
        })
    ], Action.prototype, "_visible", void 0);
    action_decorate([
        jsonobject_property({
            onSet: function (_, target) {
                target.locTooltipChanged();
            }
        })
    ], Action.prototype, "locTooltipName", void 0);
    action_decorate([
        jsonobject_property()
    ], Action.prototype, "_enabled", void 0);
    action_decorate([
        jsonobject_property()
    ], Action.prototype, "action", void 0);
    action_decorate([
        jsonobject_property()
    ], Action.prototype, "onFocus", void 0);
    action_decorate([
        jsonobject_property()
    ], Action.prototype, "_component", void 0);
    action_decorate([
        jsonobject_property()
    ], Action.prototype, "items", void 0);
    action_decorate([
        jsonobject_property({
            onSet: function (val, target) {
                if (target.locTitleValue.text === val)
                    return;
                target.locTitleValue.text = val;
            }
        })
    ], Action.prototype, "_title", void 0);
    return Action;
}(action_BaseAction));

var ActionDropdownViewModel = /** @class */ (function () {
    function ActionDropdownViewModel(item) {
        this.item = item;
        this.funcKey = "sv-dropdown-action";
        this.setupPopupCallbacks();
    }
    ActionDropdownViewModel.prototype.setupPopupCallbacks = function () {
        var _this = this;
        var popupModel = this.popupModel = this.item.popupModel;
        if (!popupModel)
            return;
        popupModel.registerPropertyChangedHandlers(["isVisible"], function () {
            if (!popupModel.isVisible) {
                _this.item.pressed = false;
            }
            else {
                _this.item.pressed = true;
            }
        }, this.funcKey);
    };
    ActionDropdownViewModel.prototype.removePopupCallbacks = function () {
        if (!!this.popupModel) {
            this.popupModel.unregisterPropertyChangedHandlers(["isVisible"], this.funcKey);
        }
    };
    ActionDropdownViewModel.prototype.dispose = function () {
        this.removePopupCallbacks();
    };
    return ActionDropdownViewModel;
}());


// CONCATENATED MODULE: ./packages/survey-core/src/actions/adaptive-container.ts
var adaptive_container_extends = (undefined && undefined.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();




var adaptive_container_AdaptiveActionContainer = /** @class */ (function (_super) {
    adaptive_container_extends(AdaptiveActionContainer, _super);
    function AdaptiveActionContainer() {
        var _this = _super.call(this) || this;
        _this.minVisibleItemsCount = 0;
        _this.isResponsivenessDisabled = false;
        _this.dotsItem = createDropdownActionModelAdvanced({
            id: "dotsItem-id" + AdaptiveActionContainer.ContainerID++,
            css: "sv-dots",
            innerCss: "sv-dots__item",
            iconName: "icon-more",
            visible: false,
            tooltip: getLocaleString("more"),
        }, {
            items: [],
            allowSelection: false
        });
        return _this;
    }
    AdaptiveActionContainer.prototype.hideItemsGreaterN = function (visibleItemsCount) {
        var actionsToHide = this.getActionsToHide();
        visibleItemsCount = Math.max(visibleItemsCount, this.minVisibleItemsCount - (this.visibleActions.length - actionsToHide.length));
        var hiddenItems = [];
        actionsToHide.forEach(function (item) {
            if (visibleItemsCount <= 0) {
                if (item.removePriority) {
                    item.mode = "removed";
                }
                else {
                    item.mode = "popup";
                    hiddenItems.push(item.innerItem);
                }
            }
            visibleItemsCount--;
        });
        this.hiddenItemsListModel.setItems(hiddenItems);
    };
    AdaptiveActionContainer.prototype.getActionsToHide = function () {
        return this.visibleActions.filter(function (action) { return !action.disableHide; }).sort(function (a, b) { return a.removePriority || 0 - b.removePriority || 0; });
    };
    AdaptiveActionContainer.prototype.getVisibleItemsCount = function (availableSize) {
        this.visibleActions.filter(function (action) { return action.disableHide; }).forEach(function (action) { return availableSize -= action.minDimension; });
        var itemsSizes = this.getActionsToHide().map(function (item) { return item.minDimension; });
        var currSize = 0;
        for (var i = 0; i < itemsSizes.length; i++) {
            currSize += itemsSizes[i];
            if (currSize > availableSize)
                return i;
        }
        return i;
    };
    AdaptiveActionContainer.prototype.updateItemMode = function (availableSize, itemsSize) {
        var items = this.visibleActions;
        for (var index = items.length - 1; index >= 0; index--) {
            if (itemsSize > availableSize && !items[index].disableShrink) {
                itemsSize -= items[index].maxDimension - items[index].minDimension;
                items[index].mode = "small";
            }
            else {
                items[index].mode = "large";
            }
        }
        if (itemsSize > availableSize) {
            var hidableItems = this.visibleActions.filter(function (a) { return a.removePriority; });
            hidableItems.sort(function (a, b) { return a.removePriority - b.removePriority; });
            for (var index = 0; index < hidableItems.length; index++) {
                if (itemsSize > availableSize) {
                    itemsSize -= items[index].disableShrink ? hidableItems[index].maxDimension : hidableItems[index].minDimension;
                    hidableItems[index].mode = "removed";
                }
            }
        }
    };
    Object.defineProperty(AdaptiveActionContainer.prototype, "hiddenItemsListModel", {
        get: function () {
            return this.dotsItem.data;
        },
        enumerable: false,
        configurable: true
    });
    AdaptiveActionContainer.prototype.onSet = function () {
        var _this = this;
        this.actions.forEach(function (action) { return action.updateCallback = function (isResetInitialized) { return _this.raiseUpdate(isResetInitialized); }; });
        _super.prototype.onSet.call(this);
    };
    AdaptiveActionContainer.prototype.onPush = function (item) {
        var _this = this;
        item.updateCallback = function (isResetInitialized) { return _this.raiseUpdate(isResetInitialized); };
        _super.prototype.onPush.call(this, item);
    };
    AdaptiveActionContainer.prototype.getRenderedActions = function () {
        if (this.actions.length === 1 && !!this.actions[0].iconName)
            return this.actions;
        return this.actions.concat([this.dotsItem]);
    };
    AdaptiveActionContainer.prototype.raiseUpdate = function (isResetInitialized) {
        if (!this.isResponsivenessDisabled) {
            _super.prototype.raiseUpdate.call(this, isResetInitialized);
        }
    };
    AdaptiveActionContainer.prototype.fit = function (dimension, dotsItemSize) {
        if (dimension <= 0)
            return;
        this.dotsItem.visible = false;
        var minSize = 0;
        var maxSize = 0;
        var items = this.visibleActions;
        items.forEach(function (item) {
            minSize += item.minDimension;
            maxSize += item.maxDimension;
        });
        if (dimension >= maxSize) {
            this.setActionsMode("large");
        }
        else if (dimension < minSize) {
            this.setActionsMode("small");
            this.hideItemsGreaterN(this.getVisibleItemsCount(dimension - dotsItemSize));
            this.dotsItem.visible = !!this.hiddenItemsListModel.actions.length;
        }
        else {
            this.updateItemMode(dimension, maxSize);
        }
    };
    AdaptiveActionContainer.prototype.initResponsivityManager = function (container, delayedUpdateFunction) {
        if (!!this.responsivityManager) {
            if (this.responsivityManager.container == container) {
                return;
            }
            this.responsivityManager.dispose();
        }
        this.responsivityManager = new responsivity_manager_ResponsivityManager(container, this, ":scope > .sv-action:not(.sv-dots) > .sv-action__content", null, delayedUpdateFunction);
    };
    AdaptiveActionContainer.prototype.resetResponsivityManager = function () {
        if (!!this.responsivityManager) {
            this.responsivityManager.dispose();
            this.responsivityManager = undefined;
        }
    };
    AdaptiveActionContainer.prototype.setActionsMode = function (mode) {
        this.actions.forEach(function (action) {
            if (mode == "small" && action.disableShrink) {
                action.mode = "large";
            }
            else {
                action.mode = mode;
            }
        });
    };
    AdaptiveActionContainer.prototype.dispose = function () {
        _super.prototype.dispose.call(this);
        this.dotsItem.data.dispose();
        this.dotsItem.dispose();
        this.resetResponsivityManager();
    };
    AdaptiveActionContainer.ContainerID = 1;
    return AdaptiveActionContainer;
}(container_ActionContainer));


// CONCATENATED MODULE: ./packages/survey-core/src/utils/taskmanager.ts
var Task = /** @class */ (function () {
    function Task(func, isMultiple) {
        var _this = this;
        if (isMultiple === void 0) { isMultiple = false; }
        this.func = func;
        this.isMultiple = isMultiple;
        this._isCompleted = false;
        this.execute = function () {
            if (!_this._isCompleted) {
                _this.func();
                _this._isCompleted = !_this.isMultiple;
            }
        };
    }
    Task.prototype.discard = function () {
        this._isCompleted = true;
    };
    Object.defineProperty(Task.prototype, "isCompleted", {
        get: function () {
            return this._isCompleted;
        },
        enumerable: false,
        configurable: true
    });
    return Task;
}());

var TaskManger = /** @class */ (function () {
    function TaskManger(interval) {
        if (interval === void 0) { interval = 100; }
        this.interval = interval;
        setTimeout(TaskManger.Instance().tick, interval);
    }
    // dispose
    TaskManger.Instance = function () {
        if (!TaskManger.instance) {
            TaskManger.instance = new TaskManger();
        }
        return TaskManger.instance;
    };
    TaskManger.prototype.tick = function () {
        try {
            var newTasks = [];
            for (var i = 0; i < TaskManger.tasks.length; i++) {
                var task = TaskManger.tasks[i];
                task.execute();
                if (!task.isCompleted) {
                    newTasks.push(task);
                }
                else {
                    if (typeof task.dispose === "function") {
                        task.dispose();
                    }
                }
            }
            TaskManger.tasks = newTasks;
        }
        finally {
            setTimeout(TaskManger.Instance().tick, this.interval);
        }
    };
    TaskManger.schedule = function (task) {
        TaskManger.tasks.push(task);
    };
    TaskManger.instance = undefined;
    TaskManger.tasks = [];
    return TaskManger;
}());

function debounce(func) {
    var _this = this;
    var isSheduled = false;
    var isCanceled = false;
    var funcArgs;
    return { run: (function () {
            var args = [];
            for (var _i = 0; _i < arguments.length; _i++) {
                args[_i] = arguments[_i];
            }
            isCanceled = false;
            funcArgs = args;
            if (!isSheduled) {
                isSheduled = true;
                queueMicrotask(function () {
                    if (!isCanceled) {
                        func.apply(_this, funcArgs);
                    }
                    isCanceled = false;
                    isSheduled = false;
                });
            }
        }), cancel: function () {
            isCanceled = true;
        } };
}

// CONCATENATED MODULE: ./packages/survey-core/src/utils/animation.ts
var animation_extends = (undefined && undefined.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();



var animation_AnimationUtils = /** @class */ (function () {
    function AnimationUtils() {
        this.cancelQueue = [];
    }
    AnimationUtils.prototype.getMsFromRule = function (value) {
        if (value === "auto")
            return 0;
        return Number(value.slice(0, -1).replace(",", ".")) * 1000;
    };
    AnimationUtils.prototype.reflow = function (element) {
        return element.offsetHeight;
    };
    AnimationUtils.prototype.getAnimationsCount = function (element) {
        var animationName = "";
        if (getComputedStyle) {
            animationName = getComputedStyle(element).animationName;
        }
        return (animationName && animationName != "none" ? animationName.split(", ").length : 0);
    };
    AnimationUtils.prototype.getAnimationDuration = function (element) {
        var style = getComputedStyle(element);
        var delays = style["animationDelay"].split(", ");
        var durations = style["animationDuration"].split(", ");
        var duration = 0;
        for (var i = 0; i < Math.max(durations.length, delays.length); i++) {
            duration = Math.max(duration, this.getMsFromRule(durations[i % durations.length]) + this.getMsFromRule(delays[i % delays.length]));
        }
        return duration;
    };
    AnimationUtils.prototype.addCancelCallback = function (callback) {
        this.cancelQueue.push(callback);
    };
    AnimationUtils.prototype.removeCancelCallback = function (callback) {
        if (this.cancelQueue.indexOf(callback) >= 0) {
            this.cancelQueue.splice(this.cancelQueue.indexOf(callback), 1);
        }
    };
    AnimationUtils.prototype.onAnimationEnd = function (element, callback, options) {
        var _this = this;
        var cancelTimeout;
        var animationsCount = this.getAnimationsCount(element);
        var onEndCallback = function (isCancel) {
            if (isCancel === void 0) { isCancel = true; }
            callback(isCancel);
            clearTimeout(cancelTimeout);
            _this.removeCancelCallback(onEndCallback);
            element.removeEventListener("animationend", onAnimationEndCallback);
        };
        var onAnimationEndCallback = function (event) {
            if (event.target == event.currentTarget && --animationsCount <= 0) {
                onEndCallback(false);
            }
        };
        if (animationsCount > 0) {
            element.addEventListener("animationend", onAnimationEndCallback);
            this.addCancelCallback(onEndCallback);
            cancelTimeout = setTimeout(function () {
                onEndCallback(false);
            }, this.getAnimationDuration(element) + 10);
        }
        else {
            callback(true);
        }
    };
    AnimationUtils.prototype.afterAnimationRun = function (element, options) {
        if (element && options) {
            options.onAfterRunAnimation && options.onAfterRunAnimation(element);
        }
    };
    AnimationUtils.prototype.beforeAnimationRun = function (element, options) {
        if (element && options) {
            options.onBeforeRunAnimation && options.onBeforeRunAnimation(element);
        }
    };
    AnimationUtils.prototype.getCssClasses = function (options) {
        return options.cssClass.replace(/\s+$/, "").split(/\s+/);
    };
    AnimationUtils.prototype.runAnimation = function (element, options, callback) {
        if (element && (options === null || options === void 0 ? void 0 : options.cssClass)) {
            this.reflow(element);
            this.getCssClasses(options).forEach(function (cssClass) {
                element.classList.add(cssClass);
            });
            this.onAnimationEnd(element, callback, options);
        }
        else {
            callback(true);
        }
    };
    AnimationUtils.prototype.clearHtmlElement = function (element, options) {
        if (element && options.cssClass) {
            this.getCssClasses(options).forEach(function (cssClass) {
                element.classList.remove(cssClass);
            });
        }
        this.afterAnimationRun(element, options);
    };
    AnimationUtils.prototype.onNextRender = function (callback, isCancel) {
        var _this = this;
        if (isCancel === void 0) { isCancel = false; }
        if (!isCancel && DomWindowHelper.isAvailable()) {
            var cancelCallback_1 = function () {
                callback(true);
                cancelAnimationFrame(latestRAF_1);
            };
            var latestRAF_1 = DomWindowHelper.requestAnimationFrame(function () {
                latestRAF_1 = DomWindowHelper.requestAnimationFrame(function () {
                    callback(false);
                    _this.removeCancelCallback(cancelCallback_1);
                });
            });
            this.addCancelCallback(cancelCallback_1);
        }
        else {
            callback(true);
        }
    };
    AnimationUtils.prototype.cancel = function () {
        var cancelQueue = [].concat(this.cancelQueue);
        cancelQueue.forEach(function (callback) { return callback(); });
        this.cancelQueue = [];
    };
    return AnimationUtils;
}());

var AnimationPropertyUtils = /** @class */ (function (_super) {
    animation_extends(AnimationPropertyUtils, _super);
    function AnimationPropertyUtils() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    AnimationPropertyUtils.prototype.onEnter = function (options) {
        var _this = this;
        var htmlElement = options.getAnimatedElement();
        var enterOptions = options.getEnterOptions ? options.getEnterOptions() : {};
        this.beforeAnimationRun(htmlElement, enterOptions);
        this.runAnimation(htmlElement, enterOptions, function () {
            _this.clearHtmlElement(htmlElement, enterOptions);
        });
    };
    AnimationPropertyUtils.prototype.onLeave = function (options, callback) {
        var _this = this;
        var htmlElement = options.getAnimatedElement();
        var leaveOptions = options.getLeaveOptions ? options.getLeaveOptions() : {};
        this.beforeAnimationRun(htmlElement, leaveOptions);
        this.runAnimation(htmlElement, leaveOptions, function (isCancel) {
            callback();
            _this.onNextRender(function () {
                _this.clearHtmlElement(htmlElement, leaveOptions);
            }, isCancel);
        });
    };
    return AnimationPropertyUtils;
}(animation_AnimationUtils));

var AnimationGroupUtils = /** @class */ (function (_super) {
    animation_extends(AnimationGroupUtils, _super);
    function AnimationGroupUtils() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    AnimationGroupUtils.prototype.runGroupAnimation = function (options, addedItems, removedItems, reorderedItems, callback) {
        var _this = this;
        var info = {
            isAddingRunning: addedItems.length > 0,
            isDeletingRunning: removedItems.length > 0,
            isReorderingRunning: reorderedItems.length > 0
        };
        var addedHtmlElements = addedItems.map(function (el) { return options.getAnimatedElement(el); });
        var enterOptions = addedItems.map(function (el) { return options.getEnterOptions ? options.getEnterOptions(el, info) : {}; });
        var removedHtmlElements = removedItems.map(function (el) { return options.getAnimatedElement(el); });
        var leaveOptions = removedItems.map(function (el) { return options.getLeaveOptions ? options.getLeaveOptions(el, info) : {}; });
        var reorderedHtmlElements = reorderedItems.map(function (el) { return options.getAnimatedElement(el.item); });
        var reorderedOptions = reorderedItems.map(function (el) { return options.getReorderOptions ? options.getReorderOptions(el.item, el.movedForward, info) : {}; });
        addedItems.forEach(function (_, i) {
            _this.beforeAnimationRun(addedHtmlElements[i], enterOptions[i]);
        });
        removedItems.forEach(function (_, i) {
            _this.beforeAnimationRun(removedHtmlElements[i], leaveOptions[i]);
        });
        reorderedItems.forEach(function (_, i) {
            _this.beforeAnimationRun(reorderedHtmlElements[i], reorderedOptions[i]);
        });
        var counter = addedItems.length + removedItems.length + reorderedHtmlElements.length;
        var onAnimationEndCallback = function (isCancel) {
            if (--counter <= 0) {
                callback && callback();
                _this.onNextRender(function () {
                    addedItems.forEach(function (_, i) {
                        _this.clearHtmlElement(addedHtmlElements[i], enterOptions[i]);
                    });
                    removedItems.forEach(function (_, i) {
                        _this.clearHtmlElement(removedHtmlElements[i], leaveOptions[i]);
                    });
                    reorderedItems.forEach(function (_, i) {
                        _this.clearHtmlElement(reorderedHtmlElements[i], reorderedOptions[i]);
                    });
                }, isCancel);
            }
        };
        addedItems.forEach(function (_, i) {
            _this.runAnimation(addedHtmlElements[i], enterOptions[i], onAnimationEndCallback);
        });
        removedItems.forEach(function (_, i) {
            _this.runAnimation(removedHtmlElements[i], leaveOptions[i], onAnimationEndCallback);
        });
        reorderedItems.forEach(function (_, i) {
            _this.runAnimation(reorderedHtmlElements[i], reorderedOptions[i], onAnimationEndCallback);
        });
    };
    return AnimationGroupUtils;
}(animation_AnimationUtils));

var animation_AnimationProperty = /** @class */ (function () {
    function AnimationProperty(animationOptions, update, getCurrentValue) {
        var _this = this;
        this.animationOptions = animationOptions;
        this.update = update;
        this.getCurrentValue = getCurrentValue;
        this._debouncedSync = debounce(function (newValue) {
            _this.cancelAnimations();
            try {
                _this._sync(newValue);
            }
            catch (_a) {
                _this.update(newValue);
            }
        });
    }
    AnimationProperty.prototype.onNextRender = function (callback, onCancel) {
        var _this = this;
        var rerenderEvent = this.animationOptions.getRerenderEvent();
        if (!rerenderEvent) {
            if (DomWindowHelper.isAvailable()) {
                var raf_1 = DomWindowHelper.requestAnimationFrame(function () {
                    callback();
                    _this.cancelCallback = undefined;
                });
                this.cancelCallback = function () {
                    onCancel && onCancel();
                    cancelAnimationFrame(raf_1);
                    _this.cancelCallback = undefined;
                };
            }
            else {
                throw new Error("Can't get next render");
            }
        }
        else {
            var clear_1 = function () {
                rerenderEvent.remove(nextRenderCallback_1);
                _this.cancelCallback = undefined;
            };
            var nextRenderCallback_1 = function (_, options) {
                if (options.isCancel) {
                    onCancel && onCancel();
                }
                else {
                    callback();
                }
                clear_1();
            };
            this.cancelCallback = function () {
                onCancel && onCancel();
                clear_1();
            };
            rerenderEvent.add(nextRenderCallback_1);
        }
    };
    AnimationProperty.prototype.sync = function (newValue) {
        if (this.animationOptions.isAnimationEnabled()) {
            this._debouncedSync.run(newValue);
        }
        else {
            this.cancel();
            this.update(newValue);
        }
    };
    AnimationProperty.prototype.cancel = function () {
        this._debouncedSync.cancel();
        this.cancelAnimations();
    };
    AnimationProperty.prototype.cancelAnimations = function () {
        this.cancelCallback && this.cancelCallback();
        this.animation.cancel();
    };
    return AnimationProperty;
}());

var AnimationBoolean = /** @class */ (function (_super) {
    animation_extends(AnimationBoolean, _super);
    function AnimationBoolean() {
        var _this = _super !== null && _super.apply(this, arguments) || this;
        _this.animation = new AnimationPropertyUtils();
        return _this;
    }
    AnimationBoolean.prototype._sync = function (newValue) {
        var _this = this;
        if (newValue !== this.getCurrentValue()) {
            if (newValue) {
                this.onNextRender(function () {
                    _this.animation.onEnter(_this.animationOptions);
                });
                this.update(newValue);
            }
            else {
                this.animation.onLeave(this.animationOptions, function () {
                    _this.update(newValue);
                });
            }
        }
        else {
            this.update(newValue);
        }
    };
    return AnimationBoolean;
}(animation_AnimationProperty));

var animation_AnimationGroup = /** @class */ (function (_super) {
    animation_extends(AnimationGroup, _super);
    function AnimationGroup() {
        var _this = _super !== null && _super.apply(this, arguments) || this;
        _this.animation = new AnimationGroupUtils();
        return _this;
    }
    AnimationGroup.prototype._sync = function (newValue) {
        var _this = this;
        var _a, _b;
        newValue = [].concat(newValue);
        var oldValue = [].concat(this.getCurrentValue());
        var allowSyncRemovalAddition = (_a = this.animationOptions.allowSyncRemovalAddition) !== null && _a !== void 0 ? _a : true;
        var compareResult = compareArrays(oldValue, newValue, (_b = this.animationOptions.getKey) !== null && _b !== void 0 ? _b : (function (item) { return item; }));
        if (!allowSyncRemovalAddition && (compareResult.reorderedItems.length > 0 || compareResult.addedItems.length > 0)) {
            compareResult.deletedItems = [];
            compareResult.mergedItems = newValue;
        }
        if (!!this.animationOptions.onCompareArrays) {
            this.animationOptions.onCompareArrays(compareResult);
        }
        var addedItems = compareResult.addedItems, reorderedItems = compareResult.reorderedItems, deletedItems = compareResult.deletedItems, mergedItems = compareResult.mergedItems;
        var runAnimationCallback = function () {
            _this.animation.runGroupAnimation(_this.animationOptions, addedItems, deletedItems, reorderedItems, function () {
                if (deletedItems.length > 0) {
                    _this.update(newValue);
                }
            });
        };
        if ([addedItems, deletedItems, reorderedItems].some(function (arr) { return arr.length > 0; })) {
            if (deletedItems.length <= 0 || reorderedItems.length > 0 || addedItems.length > 0) {
                this.onNextRender(runAnimationCallback, function () {
                    _this.update(newValue);
                });
                this.update(mergedItems);
            }
            else {
                runAnimationCallback();
            }
        }
        else {
            this.update(newValue);
        }
    };
    return AnimationGroup;
}(animation_AnimationProperty));

var AnimationTab = /** @class */ (function (_super) {
    animation_extends(AnimationTab, _super);
    function AnimationTab(animationOptions, update, getCurrentValue, mergeValues) {
        var _this = _super.call(this, animationOptions, update, getCurrentValue) || this;
        _this.mergeValues = mergeValues;
        _this.animation = new AnimationGroupUtils();
        return _this;
    }
    AnimationTab.prototype._sync = function (newValue) {
        var _this = this;
        var oldValue = [].concat(this.getCurrentValue());
        if (oldValue[0] !== newValue[0]) {
            var tempValue = !!this.mergeValues ? this.mergeValues(newValue, oldValue) : [].concat(oldValue, newValue);
            this.onNextRender(function () {
                _this.animation.runGroupAnimation(_this.animationOptions, newValue, oldValue, [], function () {
                    _this.update(newValue);
                });
            }, function () { return _this.update(newValue); });
            this.update(tempValue, true);
        }
        else {
            this.update(newValue);
        }
    };
    return AnimationTab;
}(animation_AnimationProperty));


// CONCATENATED MODULE: ./packages/survey-core/src/survey-element.ts
var survey_element_extends = (undefined && undefined.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var survey_element_decorate = (undefined && undefined.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};










/**
 * A base class for the [`SurveyElement`](https://surveyjs.io/form-library/documentation/surveyelement) and [`SurveyModel`](https://surveyjs.io/form-library/documentation/surveymodel) classes.
 */
var survey_element_SurveyElementCore = /** @class */ (function (_super) {
    survey_element_extends(SurveyElementCore, _super);
    function SurveyElementCore() {
        var _this = _super.call(this) || this;
        _this.createLocTitleProperty();
        return _this;
    }
    SurveyElementCore.prototype.createLocTitleProperty = function () {
        return this.createLocalizableString("title", this, true);
    };
    Object.defineProperty(SurveyElementCore.prototype, "isPage", {
        /**
         * Returns `true` if the survey element is a page.
         *
         * This property returns `false` for [`PageModel`](https://surveyjs.io/form-library/documentation/api-reference/page-model) objects in the following cases:
         *
         * - `SurveyModel`'s [`questionsOnPageMode`](https://surveyjs.io/form-library/documentation/api-reference/survey-data-model#questionsOnPageMode) is set to `"singlePage"`.
         * - The page is included in a [preview of given answers](https://surveyjs.io/form-library/documentation/design-survey/create-a-multi-page-survey#preview-page).
         *
         * In those cases, the survey creates an internal `PageModel` object to show all questions on one page, and all regular pages become panels.
         */
        get: function () { return false; },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(SurveyElementCore.prototype, "isPanel", {
        /**
         * Returns `true` if the survey element is a panel or acts as one.
         *
         * This property returns `true` for `PageModel` objects in the following cases:
         *
         * - `SurveyModel`'s [`questionsOnPageMode`](https://surveyjs.io/form-library/documentation/api-reference/survey-data-model#questionsOnPageMode) is set to `"singlePage"`.
         * - The page is included in a [preview of given answers](https://surveyjs.io/form-library/documentation/design-survey/create-a-multi-page-survey#preview-page).
         *
         * In those cases, the survey creates an internal `PageModel` object to show all questions on one page, and all regular pages become panels.
         */
        get: function () { return false; },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(SurveyElementCore.prototype, "isQuestion", {
        /**
         * Returns `true` if the survey element is a question.
         */
        get: function () { return false; },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(SurveyElementCore.prototype, "isSurvey", {
        /**
         * Returns `true` if the element is a survey.
         */
        get: function () { return false; },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(SurveyElementCore.prototype, "title", {
        /**
         * A title for the survey element. If `title` is undefined, the `name` property value is displayed instead.
         *
         * Empty pages and panels do not display their titles or names.
         *
         * @see [Configure Question Titles](https://surveyjs.io/form-library/documentation/design-survey-question-titles)
        */
        get: function () {
            return this.getLocalizableStringText("title", this.getDefaultTitleValue());
        },
        set: function (val) {
            this.setTitleValue(val);
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(SurveyElementCore.prototype, "locTitle", {
        get: function () {
            return this.getLocalizableString("title");
        },
        enumerable: false,
        configurable: true
    });
    SurveyElementCore.prototype.getDefaultTitleValue = function () { return undefined; };
    SurveyElementCore.prototype.setTitleValue = function (val) {
        this.setLocalizableStringText("title", val);
    };
    SurveyElementCore.prototype.updateDescriptionVisibility = function (newDescription) {
        var showPlaceholder = false;
        if (this.isDesignMode) {
            var property_1 = Serializer.findProperty(this.getType(), "description");
            showPlaceholder = !!(property_1 === null || property_1 === void 0 ? void 0 : property_1.placeholder);
        }
        this.hasDescription = !!newDescription || (showPlaceholder && this.isDesignMode);
    };
    Object.defineProperty(SurveyElementCore.prototype, "locDescription", {
        get: function () {
            return this.getLocalizableString("description");
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(SurveyElementCore.prototype, "titleTagName", {
        get: function () {
            var titleTagName = this.getDefaultTitleTagName();
            var survey = this.getSurvey();
            return !!survey ? survey.getElementTitleTagName(this, titleTagName) : titleTagName;
        },
        enumerable: false,
        configurable: true
    });
    SurveyElementCore.prototype.getDefaultTitleTagName = function () {
        return settings.titleTags[this.getType()];
    };
    Object.defineProperty(SurveyElementCore.prototype, "hasTitle", {
        get: function () { return this.title.length > 0; },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(SurveyElementCore.prototype, "hasTitleActions", {
        get: function () { return false; },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(SurveyElementCore.prototype, "hasTitleEvents", {
        get: function () {
            return this.hasTitleActions;
        },
        enumerable: false,
        configurable: true
    });
    SurveyElementCore.prototype.getTitleToolbar = function () { return null; };
    SurveyElementCore.prototype.getTitleOwner = function () { return undefined; };
    Object.defineProperty(SurveyElementCore.prototype, "isTitleOwner", {
        get: function () { return !!this.getTitleOwner(); },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(SurveyElementCore.prototype, "isTitleRenderedAsString", {
        get: function () { return this.getIsTitleRenderedAsString(); },
        enumerable: false,
        configurable: true
    });
    SurveyElementCore.prototype.toggleState = function () { return undefined; };
    Object.defineProperty(SurveyElementCore.prototype, "cssClasses", {
        get: function () { return {}; },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(SurveyElementCore.prototype, "cssTitle", {
        get: function () { return ""; },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(SurveyElementCore.prototype, "ariaTitleId", {
        get: function () { return undefined; },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(SurveyElementCore.prototype, "ariaDescriptionId", {
        get: function () { return undefined; },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(SurveyElementCore.prototype, "titleTabIndex", {
        get: function () { return undefined; },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(SurveyElementCore.prototype, "titleAriaExpanded", {
        get: function () { return undefined; },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(SurveyElementCore.prototype, "titleAriaRole", {
        get: function () { return undefined; },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(SurveyElementCore.prototype, "ariaLabel", {
        get: function () {
            return this.locTitle.renderedHtml;
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(SurveyElementCore.prototype, "titleAriaLabel", {
        get: function () {
            return this.ariaLabel;
        },
        enumerable: false,
        configurable: true
    });
    SurveyElementCore.prototype.getIsTitleRenderedAsString = function () { return !this.isTitleOwner; };
    survey_element_decorate([
        jsonobject_property({})
    ], SurveyElementCore.prototype, "hasDescription", void 0);
    survey_element_decorate([
        jsonobject_property({
            localizable: true,
            onSet: function (newDescription, self) {
                self.updateDescriptionVisibility(newDescription);
            }
        })
    ], SurveyElementCore.prototype, "description", void 0);
    return SurveyElementCore;
}(base_Base));

// TODO: rename
var DragTypeOverMeEnum;
(function (DragTypeOverMeEnum) {
    DragTypeOverMeEnum[DragTypeOverMeEnum["InsideEmptyPanel"] = 1] = "InsideEmptyPanel";
    DragTypeOverMeEnum[DragTypeOverMeEnum["MultilineRight"] = 2] = "MultilineRight";
    DragTypeOverMeEnum[DragTypeOverMeEnum["MultilineLeft"] = 3] = "MultilineLeft";
    DragTypeOverMeEnum[DragTypeOverMeEnum["Top"] = 4] = "Top";
    DragTypeOverMeEnum[DragTypeOverMeEnum["Right"] = 5] = "Right";
    DragTypeOverMeEnum[DragTypeOverMeEnum["Bottom"] = 6] = "Bottom";
    DragTypeOverMeEnum[DragTypeOverMeEnum["Left"] = 7] = "Left";
})(DragTypeOverMeEnum || (DragTypeOverMeEnum = {}));
/**
 * A base class for all survey elements.
 */
var survey_element_SurveyElement = /** @class */ (function (_super) {
    survey_element_extends(SurveyElement, _super);
    function SurveyElement(name) {
        var _this = _super.call(this) || this;
        _this.selectedElementInDesignValue = _this;
        _this.disableDesignActions = SurveyElement.CreateDisabledDesignElements;
        _this.parentQuestionValue = null;
        _this.isContentElement = false;
        _this.isEditableTemplateElement = false;
        _this.isInteractiveDesignElement = true;
        _this.isSingleInRow = true;
        _this._renderedIsExpanded = true;
        _this._isAnimatingCollapseExpand = false;
        _this.animationCollapsed = new AnimationBoolean(_this.getExpandCollapseAnimationOptions(), function (val) {
            _this._renderedIsExpanded = val;
            if (_this.animationAllowed) {
                if (val) {
                    _this.isAnimatingCollapseExpand = true;
                }
                else {
                    _this.updateElementCss(false);
                }
            }
        }, function () { return _this.renderedIsExpanded; });
        _this.onAfterRenderElement = _this.addEvent();
        _this.name = name;
        _this.createNewArray("errors");
        _this.createNewArray("titleActions");
        _this.registerPropertyChangedHandlers(["isReadOnly"], function () { _this.onReadOnlyChanged(); });
        _this.registerPropertyChangedHandlers(["errors"], function () { _this.updateVisibleErrors(); });
        _this.registerPropertyChangedHandlers(["isSingleInRow"], function () { _this.updateElementCss(false); });
        _this.registerPropertyChangedHandlers(["minWidth", "maxWidth", "renderWidth", "allowRootStyle", "parent"], function () { _this.updateRootStyle(); });
        return _this;
    }
    SurveyElement.getProgressInfoByElements = function (children, isRequired) {
        var info = base_Base.createProgressInfo();
        for (var i = 0; i < children.length; i++) {
            if (!children[i].isVisible)
                continue;
            var childInfo = children[i].getProgressInfo();
            info.questionCount += childInfo.questionCount;
            info.answeredQuestionCount += childInfo.answeredQuestionCount;
            info.requiredQuestionCount += childInfo.requiredQuestionCount;
            info.requiredAnsweredQuestionCount +=
                childInfo.requiredAnsweredQuestionCount;
        }
        if (isRequired && info.questionCount > 0) {
            if (info.requiredQuestionCount == 0)
                info.requiredQuestionCount = 1;
            if (info.answeredQuestionCount > 0)
                info.requiredAnsweredQuestionCount = 1;
        }
        return info;
    };
    SurveyElement.IsNeedScrollIntoView = function (el, checkLeft, scrollIfVisible) {
        var elTop = scrollIfVisible ? -1 : el.getBoundingClientRect().top;
        var needScroll = elTop < 0;
        var elLeft = -1;
        if (!needScroll && checkLeft) {
            elLeft = el.getBoundingClientRect().left;
            needScroll = elLeft < 0;
        }
        if (!needScroll && DomWindowHelper.isAvailable()) {
            var height = DomWindowHelper.getInnerHeight();
            needScroll = height > 0 && height < elTop;
            if (!needScroll && checkLeft) {
                var width = DomWindowHelper.getInnerWidth();
                needScroll = width > 0 && width < elLeft;
            }
        }
        return needScroll;
    };
    SurveyElement.ScrollIntoView = function (el, scrollIntoViewOptions, doneCallback) {
        el.scrollIntoView(scrollIntoViewOptions);
        if (typeof doneCallback === "function") {
            var lastPos_1 = null;
            var same_1 = 0;
            var checkPos_1 = function () {
                var newPos = el.getBoundingClientRect().top;
                if (newPos === lastPos_1) {
                    if (same_1++ > 2) {
                        doneCallback();
                        return;
                    }
                }
                else {
                    lastPos_1 = newPos;
                    same_1 = 0;
                }
                requestAnimationFrame(checkPos_1);
            };
            DomWindowHelper.requestAnimationFrame(checkPos_1);
        }
    };
    SurveyElement.ScrollElementToTop = function (elementId, scrollIfVisible, scrollIntoViewOptions, doneCallback) {
        var root = settings.environment.root;
        if (!elementId || typeof root === "undefined")
            return false;
        var el = root.getElementById(elementId);
        return SurveyElement.ScrollElementToViewCore(el, false, scrollIfVisible, scrollIntoViewOptions, doneCallback);
    };
    SurveyElement.ScrollElementToViewCore = function (el, checkLeft, scrollIfVisible, scrollIntoViewOptions, doneCallback) {
        if (!el || !el.scrollIntoView) {
            doneCallback && doneCallback();
            return false;
        }
        var needScroll = SurveyElement.IsNeedScrollIntoView(el, checkLeft, scrollIfVisible);
        if (needScroll) {
            SurveyElement.ScrollIntoView(el, scrollIntoViewOptions, doneCallback);
        }
        else {
            doneCallback && doneCallback();
        }
        return needScroll;
    };
    SurveyElement.GetFirstNonTextElement = function (elements, removeSpaces) {
        if (removeSpaces === void 0) { removeSpaces = false; }
        if (!elements || !elements.length || elements.length == 0)
            return null;
        if (removeSpaces) {
            var tEl = elements[0];
            if (tEl.nodeName === "#text")
                tEl.data = "";
            tEl = elements[elements.length - 1];
            if (tEl.nodeName === "#text")
                tEl.data = "";
        }
        for (var i = 0; i < elements.length; i++) {
            if (elements[i].nodeName != "#text" && elements[i].nodeName != "#comment")
                return elements[i];
        }
        return null;
    };
    SurveyElement.FocusElement = function (elementId, isTimeOut, containerEl) {
        if (!elementId || !DomDocumentHelper.isAvailable())
            return false;
        var res = !isTimeOut ? SurveyElement.focusElementCore(elementId, containerEl) : false;
        if (!res) {
            setTimeout(function () {
                SurveyElement.focusElementCore(elementId, containerEl);
            }, isTimeOut ? 100 : 10);
        }
        return res;
    };
    SurveyElement.focusElementCore = function (elementId, containerEl) {
        var root = settings.environment.root;
        if (!root && !containerEl)
            return false;
        var el = containerEl ? containerEl.querySelector("#" + CSS.escape(elementId)) : root.getElementById(elementId);
        // https://stackoverflow.com/questions/19669786/check-if-element-is-visible-in-dom
        if (el && !el["disabled"] && el.style.display !== "none" && el.offsetParent !== null) {
            SurveyElement.ScrollElementToViewCore(el, true, false);
            el.focus();
            return true;
        }
        return false;
    };
    Object.defineProperty(SurveyElement.prototype, "colSpan", {
        get: function () {
            return this.getPropertyValue("colSpan", 1);
        },
        set: function (val) {
            this.setPropertyValue("colSpan", val);
        },
        enumerable: false,
        configurable: true
    });
    SurveyElement.prototype.onPropertyValueChanged = function (name, oldValue, newValue) {
        _super.prototype.onPropertyValueChanged.call(this, name, oldValue, newValue);
        if (name === "state") {
            this.updateElementCss(false);
            this.notifyStateChanged(oldValue);
            if (this.stateChangedCallback)
                this.stateChangedCallback();
        }
    };
    SurveyElement.prototype.getSkeletonComponentNameCore = function () {
        if (this.survey) {
            return this.survey.getSkeletonComponentName(this);
        }
        return "";
    };
    Object.defineProperty(SurveyElement.prototype, "parentQuestion", {
        /**
         * A Dynamic Panel, Dynamic Matrix, or Dropdown Matrix that includes the current question.
         *
         * This property is `null` for standalone questions.
         */
        get: function () {
            return this.parentQuestionValue;
        },
        enumerable: false,
        configurable: true
    });
    SurveyElement.prototype.setParentQuestion = function (val) {
        this.parentQuestionValue = val;
        this.onParentQuestionChanged();
    };
    SurveyElement.prototype.onParentQuestionChanged = function () { };
    SurveyElement.prototype.updateElementVisibility = function () {
        this.setPropertyValue("isVisible", this.isVisible);
    };
    Object.defineProperty(SurveyElement.prototype, "skeletonComponentName", {
        get: function () {
            return this.getSkeletonComponentNameCore();
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(SurveyElement.prototype, "state", {
        /**
         * Gets and sets the survey element's expand state.
         *
         * Possible values:
         *
         * - `"default"` (default) - The survey element is displayed in full and cannot be collapsed in the UI.
         * - `"expanded"` - The survey element is displayed in full and can be collapsed in the UI.
         * - `"collapsed"` - The survey element displays only `title` and `description` and can be expanded in the UI.
         *
         * @see toggleState
         * @see collapse
         * @see expand
         * @see isCollapsed
         * @see isExpanded
         */
        get: function () {
            return this.getPropertyValue("state");
        },
        set: function (val) {
            this.setPropertyValue("state", val);
            this.renderedIsExpanded = !(this.state === "collapsed" && !this.isDesignMode);
        },
        enumerable: false,
        configurable: true
    });
    SurveyElement.prototype.notifyStateChanged = function (prevState) {
        if (this.survey) {
            this.survey.elementContentVisibilityChanged(this);
        }
    };
    Object.defineProperty(SurveyElement.prototype, "isCollapsed", {
        /**
         * Returns `true` if the survey element is collapsed.
         * @see state
         * @see toggleState
         * @see collapse
         * @see expand
         * @see isExpanded
         */
        get: function () {
            return this.state === "collapsed" && !this.isDesignMode;
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(SurveyElement.prototype, "isExpanded", {
        /**
         * Returns `true` if the survey element is expanded.
         * @see state
         * @see toggleState
         * @see collapse
         * @see expand
         * @see isCollapsed
         */
        get: function () {
            return this.state === "expanded";
        },
        enumerable: false,
        configurable: true
    });
    /**
     * Collapses the survey element.
     *
     * In collapsed state, the element displays only `title` and `description`.
     * @see title
     * @see description
     * @see state
     * @see toggleState
     * @see expand
     * @see isCollapsed
     * @see isExpanded
     */
    SurveyElement.prototype.collapse = function () {
        if (this.isDesignMode)
            return;
        this.state = "collapsed";
    };
    /**
     * Expands the survey element.
     * @see state
     * @see toggleState
     * @see collapse
     * @see isCollapsed
     * @see isExpanded
     */
    SurveyElement.prototype.expand = function () {
        this.state = "expanded";
    };
    /**
     * Toggles the survey element's `state` between collapsed and expanded.
     * @see state
     * @see collapse
     * @see expand
     * @see isCollapsed
     * @see isExpanded
     */
    SurveyElement.prototype.toggleState = function () {
        if (this.isCollapsed) {
            this.expand();
            return true;
        }
        if (this.isExpanded) {
            this.collapse();
            return false;
        }
        return true;
    };
    Object.defineProperty(SurveyElement.prototype, "hasStateButton", {
        get: function () {
            return this.isExpanded || this.isCollapsed;
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(SurveyElement.prototype, "shortcutText", {
        get: function () {
            return this.title || this.name;
        },
        enumerable: false,
        configurable: true
    });
    SurveyElement.prototype.getTitleToolbar = function () {
        if (!this.titleToolbarValue) {
            this.titleToolbarValue = this.createActionContainer(true);
            this.titleToolbarValue.locOwner = this;
            this.titleToolbarValue.containerCss = (this.isPanel ? this.cssClasses.panel.titleBar : this.cssClasses.titleBar) || "sv-action-title-bar";
            this.titleToolbarValue.setItems(this.getTitleActions());
        }
        return this.titleToolbarValue;
    };
    SurveyElement.prototype.createActionContainer = function (allowAdaptiveActions) {
        var actionContainer = allowAdaptiveActions ? new adaptive_container_AdaptiveActionContainer() : new container_ActionContainer();
        if (this.survey && !!this.survey.getCss().actionBar) {
            actionContainer.cssClasses = this.survey.getCss().actionBar;
        }
        return actionContainer;
    };
    Object.defineProperty(SurveyElement.prototype, "titleActions", {
        get: function () {
            return this.getPropertyValue("titleActions");
        },
        enumerable: false,
        configurable: true
    });
    SurveyElement.prototype.getTitleActions = function () {
        if (!this.isTitleActionRequested) {
            this.updateTitleActions();
            this.isTitleActionRequested = true;
        }
        return this.titleActions;
    };
    SurveyElement.prototype.getDefaultTitleActions = function () {
        return [];
    };
    SurveyElement.prototype.updateTitleActions = function () {
        var actions = this.getDefaultTitleActions();
        if (!!this.survey) {
            actions = this.survey.getUpdatedElementTitleActions(this, actions);
        }
        this.setPropertyValue("titleActions", actions);
    };
    SurveyElement.prototype.locStrsChanged = function () {
        _super.prototype.locStrsChanged.call(this);
        if (!!this.titleToolbarValue) {
            this.titleToolbarValue.locStrsChanged();
        }
    };
    Object.defineProperty(SurveyElement.prototype, "hasTitleActions", {
        get: function () {
            return this.getTitleActions().length > 0;
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(SurveyElement.prototype, "hasTitleEvents", {
        get: function () {
            return this.state !== undefined && this.state !== "default";
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(SurveyElement.prototype, "titleTabIndex", {
        get: function () {
            return !this.isPage && this.state !== "default" ? 0 : undefined;
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(SurveyElement.prototype, "titleAriaExpanded", {
        get: function () {
            if (this.isPage || this.state === "default")
                return undefined;
            return this.state === "expanded" ? "true" : "false";
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(SurveyElement.prototype, "titleAriaRole", {
        get: function () {
            if (this.isPage || this.state === "default")
                return undefined;
            return "button";
        },
        enumerable: false,
        configurable: true
    });
    SurveyElement.prototype.setSurveyImpl = function (value, isLight) {
        this.surveyImplValue = value;
        if (!this.surveyImplValue) {
            this.setSurveyCore(null);
            this.surveyDataValue = null;
        }
        else {
            this.surveyDataValue = this.surveyImplValue.getSurveyData();
            this.setSurveyCore(this.surveyImplValue.getSurvey());
            this.textProcessorValue = this.surveyImplValue.getTextProcessor();
            this.onSetData();
        }
        if (!!this.survey /* && !this.isLoadingFromJson*/) {
            this.updateDescriptionVisibility(this.description);
            this.clearCssClasses();
        }
    };
    SurveyElement.prototype.canRunConditions = function () {
        return _super.prototype.canRunConditions.call(this) && !!this.data;
    };
    SurveyElement.prototype.getDataFilteredValues = function () {
        return !!this.data ? this.data.getFilteredValues() : {};
    };
    SurveyElement.prototype.getDataFilteredProperties = function () {
        var props = !!this.data ? this.data.getFilteredProperties() : {};
        props.question = this;
        return props;
    };
    Object.defineProperty(SurveyElement.prototype, "surveyImpl", {
        get: function () {
            return this.surveyImplValue;
        },
        enumerable: false,
        configurable: true
    });
    /* You shouldn't use this method ever */
    SurveyElement.prototype.__setData = function (data) {
        if (settings.supportCreatorV2) {
            this.surveyDataValue = data;
        }
    };
    Object.defineProperty(SurveyElement.prototype, "data", {
        get: function () {
            return this.surveyDataValue;
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(SurveyElement.prototype, "survey", {
        /**
         * Returns the survey object.
         */
        get: function () {
            return this.getSurvey();
        },
        enumerable: false,
        configurable: true
    });
    SurveyElement.prototype.getSurvey = function (live) {
        if (live === void 0) { live = false; }
        if (!!this.surveyValue)
            return this.surveyValue;
        if (!!this.surveyImplValue) {
            this.setSurveyCore(this.surveyImplValue.getSurvey());
        }
        return this.surveyValue;
    };
    SurveyElement.prototype.setSurveyCore = function (value) {
        this.surveyValue = value;
        if (!!this.surveyChangedCallback) {
            this.surveyChangedCallback();
        }
    };
    Object.defineProperty(SurveyElement.prototype, "skeletonHeight", {
        get: function () {
            var skeletonHeight = undefined;
            if (!!this.survey && this.survey.skeletonHeight) {
                skeletonHeight = this.survey.skeletonHeight + "px";
            }
            return skeletonHeight;
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(SurveyElement.prototype, "isInternal", {
        get: function () {
            return this.isContentElement;
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(SurveyElement.prototype, "areInvisibleElementsShowing", {
        get: function () {
            return (!!this.survey &&
                this.survey.areInvisibleElementsShowing &&
                !this.isContentElement);
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(SurveyElement.prototype, "isVisible", {
        get: function () {
            return true;
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(SurveyElement.prototype, "isReadOnly", {
        /**
         * Returns `true` if the survey element or its parent element is read-only.
         *
         * If you want to switch a survey element to the read-only state based on a condition, specify the [`enableIf`](https://surveyjs.io/form-library/documentation/question#enableIf) property. Refer to the following help topic for information: [Conditional Visibility](https://surveyjs.io/form-library/documentation/design-survey-conditional-logic#conditional-visibility).
         * @see readOnly
         */
        get: function () {
            return this.readOnly;
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(SurveyElement.prototype, "readOnly", {
        /**
         * Makes the survey element read-only.
         *
         * If you want to switch a survey element to the read-only state based on a condition, specify the [`enableIf`](https://surveyjs.io/form-library/documentation/question#enableIf) property. Refer to the following help topic for information: [Conditional Visibility](https://surveyjs.io/form-library/documentation/design-survey-conditional-logic#conditional-visibility).
         * @see isReadOnly
         */
        get: function () {
            return this.getPropertyValue("readOnly");
        },
        set: function (val) {
            if (this.readOnly == val)
                return;
            this.setPropertyValue("readOnly", val);
            if (!this.isLoadingFromJson) {
                this.setPropertyValue("isReadOnly", this.isReadOnly);
            }
        },
        enumerable: false,
        configurable: true
    });
    SurveyElement.prototype.onReadOnlyChanged = function () {
        if (!!this.readOnlyChangedCallback) {
            this.readOnlyChangedCallback();
        }
    };
    Object.defineProperty(SurveyElement.prototype, "css", {
        get: function () {
            return !!this.survey ? this.survey.getCss() : {};
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(SurveyElement.prototype, "cssClassesValue", {
        get: function () {
            var res = this.getPropertyValueWithoutDefault("cssClassesValue");
            if (!res && !this.isCssValueCalculating) {
                this.isCssValueCalculating = true;
                res = this.createCssClassesValue();
                this.isCssValueCalculating = false;
            }
            return res;
        },
        enumerable: false,
        configurable: true
    });
    SurveyElement.prototype.ensureCssClassesValue = function () {
        if (!this.cssClassesValue) {
            this.createCssClassesValue();
        }
    };
    SurveyElement.prototype.createCssClassesValue = function () {
        var res = this.calcCssClasses(this.css);
        this.setPropertyValue("cssClassesValue", res);
        this.onCalcCssClasses(res);
        this.updateElementCssCore(this.cssClassesValue);
        return res;
    };
    SurveyElement.prototype.onCalcCssClasses = function (classes) { };
    Object.defineProperty(SurveyElement.prototype, "cssClasses", {
        /**
         * Returns an object in which keys are UI elements and values are CSS classes applied to them.
         *
         * Use the following events of the [`SurveyModel`](https://surveyjs.io/form-library/documentation/surveymodel) object to override CSS classes:
         *
         * - [`onUpdateQuestionCssClasses`](https://surveyjs.io/form-library/documentation/surveymodel#onUpdateQuestionCssClasses)
         * - [`onUpdatePanelCssClasses`](https://surveyjs.io/form-library/documentation/surveymodel#onUpdatePanelCssClasses)
         * - [`onUpdatePageCssClasses`](https://surveyjs.io/form-library/documentation/surveymodel#onUpdatePageCssClasses)
         * - [`onUpdateChoiceItemCss`](https://surveyjs.io/form-library/documentation/api-reference/survey-data-model#onUpdateChoiceItemCss)
         */
        get: function () {
            var _dummy = this.cssClassesValue;
            if (!this.survey)
                return this.calcCssClasses(this.css);
            this.ensureCssClassesValue();
            return this.cssClassesValue;
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(SurveyElement.prototype, "cssTitleNumber", {
        get: function () {
            var css = this.cssClasses;
            if (css.number)
                return css.number;
            return css.panel ? css.panel.number : undefined;
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(SurveyElement.prototype, "cssRequiredText", {
        get: function () {
            var css = this.cssClasses;
            return css.requiredText || (css.panel && css.panel.requiredText);
        },
        enumerable: false,
        configurable: true
    });
    SurveyElement.prototype.getCssTitleExpandableSvg = function () {
        if (this.state === "default")
            return null;
        return this.cssClasses.titleExpandableSvg;
    };
    SurveyElement.prototype.calcCssClasses = function (css) { return undefined; };
    SurveyElement.prototype.updateElementCssCore = function (cssClasses) { };
    Object.defineProperty(SurveyElement.prototype, "cssError", {
        get: function () { return ""; },
        enumerable: false,
        configurable: true
    });
    SurveyElement.prototype.updateElementCss = function (reNew) {
        this.clearCssClasses();
    };
    SurveyElement.prototype.clearCssClasses = function () {
        this.resetPropertyValue("cssClassesValue");
    };
    SurveyElement.prototype.getIsLoadingFromJson = function () {
        if (_super.prototype.getIsLoadingFromJson.call(this))
            return true;
        return this.surveyValue ? this.surveyValue.isLoadingFromJson : false;
    };
    Object.defineProperty(SurveyElement.prototype, "name", {
        /**
         * A survey element identifier.
         *
         * > Question names must be unique.
         */
        get: function () {
            return this.getPropertyValue("name", "");
        },
        set: function (val) {
            var oldValue = this.name;
            this.setPropertyValue("name", this.getValidName(val));
            if (!this.isLoadingFromJson && !!oldValue) {
                this.onNameChanged(oldValue);
            }
        },
        enumerable: false,
        configurable: true
    });
    SurveyElement.prototype.getValidName = function (name) {
        return name;
    };
    SurveyElement.prototype.onNameChanged = function (oldValue) { };
    SurveyElement.prototype.updateBindingValue = function (valueName, value) {
        if (!!this.data &&
            !this.isTwoValueEquals(value, this.data.getValue(valueName))) {
            this.data.setValue(valueName, value, false);
        }
    };
    Object.defineProperty(SurveyElement.prototype, "errors", {
        /**
         * Validation errors. Call the `validate()` method to validate survey element data.
         * @see validate
         */
        get: function () {
            return this.getPropertyValue("errors");
        },
        set: function (val) {
            this.setPropertyValue("errors", val);
        },
        enumerable: false,
        configurable: true
    });
    SurveyElement.prototype.updateVisibleErrors = function () {
        var counter = 0;
        for (var i = 0; i < this.errors.length; i++) {
            if (this.errors[i].visible)
                counter++;
        }
        this.hasVisibleErrors = counter > 0;
    };
    Object.defineProperty(SurveyElement.prototype, "containsErrors", {
        /**
         * Returns `true` if the survey element or its child elements have validation errors.
         *
         * This property contains the result of the most recent validation. This result may be outdated. Call the `validate` method to get an up-to-date value.
         * @see errors
         */
        get: function () {
            return this.getPropertyValue("containsErrors", false);
        },
        enumerable: false,
        configurable: true
    });
    SurveyElement.prototype.updateContainsErrors = function () {
        this.setPropertyValue("containsErrors", this.getContainsErrors());
    };
    SurveyElement.prototype.getContainsErrors = function () {
        return this.errors.length > 0;
    };
    Object.defineProperty(SurveyElement.prototype, "selectedElementInDesign", {
        get: function () {
            return this.selectedElementInDesignValue;
        },
        set: function (val) {
            this.selectedElementInDesignValue = val;
        },
        enumerable: false,
        configurable: true
    });
    SurveyElement.prototype.updateCustomWidgets = function () { };
    SurveyElement.prototype.onSurveyLoad = function () { };
    Object.defineProperty(SurveyElement.prototype, "wasRendered", {
        get: function () { return !!this.wasRenderedValue; },
        enumerable: false,
        configurable: true
    });
    SurveyElement.prototype.onFirstRendering = function () {
        if (!this.wasRendered) {
            this.wasRenderedValue = true;
            this.onFirstRenderingCore();
        }
    };
    SurveyElement.prototype.onFirstRenderingCore = function () {
        this.ensureCssClassesValue();
    };
    SurveyElement.prototype.endLoadingFromJson = function () {
        _super.prototype.endLoadingFromJson.call(this);
        if (!this.survey) {
            this.onSurveyLoad();
        }
        this.updateDescriptionVisibility(this.description);
    };
    SurveyElement.prototype.setVisibleIndex = function (index) {
        return 0;
    };
    SurveyElement.prototype.delete = function (doDispose) { };
    /**
     * Returns the survey's [locale](https://surveyjs.io/form-library/documentation/surveymodel#locale).
     *
     * If a default locale is used, this method returns an empty string. To get the applied locale in this case, use the following code:
     *
     * ```js
     * import { surveyLocalization } from 'survey-core';
     * const defaultLocale = surveyLocalization.defaultLocale;
     * ```
     *
     * @see [Localization & Globalization](https://surveyjs.io/form-library/documentation/localization)
     */
    SurveyElement.prototype.getLocale = function () {
        return this.survey
            ? this.survey.getLocale()
            : this.locOwner
                ? this.locOwner.getLocale()
                : "";
    };
    SurveyElement.prototype.getMarkdownHtml = function (text, name) {
        return this.survey
            ? this.survey.getSurveyMarkdownHtml(this, text, name)
            : this.locOwner
                ? this.locOwner.getMarkdownHtml(text, name)
                : undefined;
    };
    SurveyElement.prototype.getRenderer = function (name) {
        return this.survey && typeof this.survey.getRendererForString === "function"
            ? this.survey.getRendererForString(this, name)
            : this.locOwner && typeof this.locOwner.getRenderer === "function"
                ? this.locOwner.getRenderer(name)
                : null;
    };
    SurveyElement.prototype.getRendererContext = function (locStr) {
        return this.survey && typeof this.survey.getRendererContextForString === "function"
            ? this.survey.getRendererContextForString(this, locStr)
            : this.locOwner && typeof this.locOwner.getRendererContext === "function"
                ? this.locOwner.getRendererContext(locStr)
                : locStr;
    };
    SurveyElement.prototype.getProcessedText = function (text) {
        if (this.isLoadingFromJson)
            return text;
        if (this.textProcessor)
            return this.textProcessor.processText(text, this.getUseDisplayValuesInDynamicTexts());
        if (this.locOwner)
            return this.locOwner.getProcessedText(text);
        return text;
    };
    SurveyElement.prototype.getUseDisplayValuesInDynamicTexts = function () { return true; };
    SurveyElement.prototype.removeSelfFromList = function (list) {
        if (!list || !Array.isArray(list))
            return;
        var index = list.indexOf(this);
        if (index > -1) {
            list.splice(index, 1);
        }
    };
    Object.defineProperty(SurveyElement.prototype, "textProcessor", {
        get: function () {
            return this.textProcessorValue;
        },
        enumerable: false,
        configurable: true
    });
    SurveyElement.prototype.getProcessedHtml = function (html) {
        if (!html || !this.textProcessor)
            return html;
        return this.textProcessor.processText(html, true);
    };
    SurveyElement.prototype.onSetData = function () { };
    Object.defineProperty(SurveyElement.prototype, "parent", {
        get: function () {
            return this.getPropertyValue("parent", null);
        },
        set: function (val) {
            this.setPropertyValue("parent", val);
        },
        enumerable: false,
        configurable: true
    });
    SurveyElement.prototype.getPage = function (parent) {
        while (parent && parent.parent)
            parent = parent.parent;
        if (parent && parent.isPage)
            return parent;
        return null;
    };
    SurveyElement.prototype.moveToBase = function (parent, container, insertBefore) {
        if (insertBefore === void 0) { insertBefore = null; }
        if (!container)
            return false;
        parent.removeElement(this);
        var index = -1;
        if (helpers_Helpers.isNumber(insertBefore)) {
            index = parseInt(insertBefore);
        }
        if (index == -1 && !!insertBefore && !!insertBefore.getType) {
            index = container.indexOf(insertBefore);
        }
        container.addElement(this, index);
        return true;
    };
    SurveyElement.prototype.setPage = function (parent, newPage) {
        var oldPage = this.getPage(parent);
        this.prevSurvey = this.survey;
        //fix for the creator v1: https://github.com/surveyjs/survey-creator/issues/1744
        if (typeof newPage === "string") {
            var survey = this.getSurvey();
            survey.pages.forEach(function (page) {
                if (newPage === page.name)
                    newPage = page;
            });
        }
        if (oldPage === newPage)
            return;
        if (parent)
            parent.removeElement(this);
        if (newPage) {
            newPage.addElement(this, -1);
        }
        this.prevSurvey = undefined;
    };
    SurveyElement.prototype.getSearchableLocKeys = function (keys) {
        keys.push("title");
        keys.push("description");
    };
    Object.defineProperty(SurveyElement.prototype, "isDefaultV2Theme", {
        get: function () {
            return this.survey && this.survey.getCss().root.indexOf("sd-root-modern") !== -1;
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(SurveyElement.prototype, "hasParent", {
        get: function () {
            return (this.parent && !this.parent.isPage) || (this.parent === undefined);
        },
        enumerable: false,
        configurable: true
    });
    SurveyElement.prototype.shouldAddRunnerStyles = function () {
        return !this.isDesignMode && this.isDefaultV2Theme;
    };
    Object.defineProperty(SurveyElement.prototype, "isCompact", {
        get: function () {
            return this.survey && this.survey["isCompact"];
        },
        enumerable: false,
        configurable: true
    });
    SurveyElement.prototype.canHaveFrameStyles = function () {
        return (this.parent !== undefined && (!this.hasParent || this.parent && this.parent.showPanelAsPage));
    };
    SurveyElement.prototype.getHasFrameV2 = function () {
        return this.shouldAddRunnerStyles() && this.canHaveFrameStyles();
    };
    SurveyElement.prototype.getIsNested = function () {
        return this.shouldAddRunnerStyles() && !this.canHaveFrameStyles();
    };
    SurveyElement.prototype.getCssRoot = function (cssClasses) {
        var isExpanadable = !!this.isCollapsed || !!this.isExpanded;
        return new CssClassBuilder()
            .append(cssClasses.withFrame, this.getHasFrameV2() && !this.isCompact)
            .append(cssClasses.compact, this.isCompact && this.getHasFrameV2())
            .append(cssClasses.collapsed, !!this.isCollapsed)
            .append(cssClasses.expandableAnimating, isExpanadable && this.isAnimatingCollapseExpand)
            .append(cssClasses.expanded, !!this.isExpanded && this.renderedIsExpanded)
            .append(cssClasses.expandable, isExpanadable)
            .append(cssClasses.nested, this.getIsNested())
            .toString();
    };
    Object.defineProperty(SurveyElement.prototype, "width", {
        /**
         * Sets survey element width in CSS values.
         *
         * Default value: ""
         * @see minWidth
         * @see maxWidth
        */
        get: function () {
            return this.getPropertyValue("width", "");
        },
        set: function (val) {
            this.setPropertyValue("width", val);
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(SurveyElement.prototype, "minWidth", {
        /**
         * Gets or sets minimum survey element width in CSS values.
         *
         * Default value: "300px" (taken from [`settings.minWidth`](https://surveyjs.io/form-library/documentation/settings#minWidth))
         * @see maxWidth
         * @see renderWidth
         * @see width
         */
        get: function () {
            return this.getPropertyValue("minWidth");
        },
        set: function (val) {
            this.setPropertyValue("minWidth", val);
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(SurveyElement.prototype, "maxWidth", {
        /**
         * Gets or sets maximum survey element width in CSS values.
         *
         * Default value: "100%" (taken from [`settings.maxWidth`](https://surveyjs.io/form-library/documentation/settings#maxWidth))
         * @see minWidth
         * @see renderWidth
         * @see width
         */
        get: function () {
            return this.getPropertyValue("maxWidth");
        },
        set: function (val) {
            this.setPropertyValue("maxWidth", val);
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(SurveyElement.prototype, "renderWidth", {
        /**
         * Returns a calculated width of the rendered survey element in CSS values.
         * @see width
         * @see minWidth
         * @see maxWidth
         */
        get: function () {
            return this.getPropertyValue("renderWidth", "");
        },
        set: function (val) {
            this.setPropertyValue("renderWidth", val);
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(SurveyElement.prototype, "indent", {
        /**
         * Increases or decreases an indent of survey element content from the left edge. Accepts positive integer values and 0. Does not apply in the Default V2 theme.
         * @see rightIndent
         */
        get: function () {
            return this.getPropertyValue("indent");
        },
        set: function (val) {
            this.setPropertyValue("indent", val);
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(SurveyElement.prototype, "rightIndent", {
        /**
         * Increases or decreases an indent of survey element content from the right edge. Accepts positive integer values and 0. Does not apply in the Default V2 theme.
         * @see indent
         */
        get: function () {
            return this.getPropertyValue("rightIndent", 0);
        },
        set: function (val) {
            this.setPropertyValue("rightIndent", val);
        },
        enumerable: false,
        configurable: true
    });
    SurveyElement.prototype.getRootStyle = function () {
        var style = {};
        if (!!this.paddingLeft) {
            style["--sv-element-add-padding-left"] = this.paddingLeft;
        }
        if (!!this.paddingRight) {
            style["--sv-element-add-padding-right"] = this.paddingRight;
        }
        return style;
    };
    Object.defineProperty(SurveyElement.prototype, "paddingLeft", {
        get: function () {
            var _this = this;
            return this.getPropertyValue("paddingLeft", undefined, function () { return _this.calcPaddingLeft(); });
        },
        enumerable: false,
        configurable: true
    });
    SurveyElement.prototype.calcPaddingLeft = function () {
        return "";
    };
    Object.defineProperty(SurveyElement.prototype, "paddingRight", {
        get: function () {
            var _this = this;
            return this.getPropertyValue("paddingRight", undefined, function () { return _this.calcPaddingRight(); });
        },
        set: function (val) {
            this.setPropertyValue("paddingRight", val);
        },
        enumerable: false,
        configurable: true
    });
    SurveyElement.prototype.calcPaddingRight = function () {
        return "";
    };
    SurveyElement.prototype.resetIndents = function () {
        this.resetPropertyValue("paddingLeft");
        this.resetPropertyValue("paddingRight");
    };
    SurveyElement.prototype.updateRootStyle = function () {
        var style = {};
        var _width;
        if (!!this.parent) {
            var columns = this.parent.getColumsForElement(this);
            _width = columns.reduce(function (sum, col) { return col.effectiveWidth + sum; }, 0);
            if (!!_width && _width !== 100) {
                style["flexGrow"] = 1;
                style["flexShrink"] = 0;
                style["flexBasis"] = _width + "%";
                style["minWidth"] = undefined;
                style["maxWidth"] = this.maxWidth;
            }
        }
        if (Object.keys(style).length == 0) {
            var minWidth = "" + this.minWidth;
            if (!!minWidth && minWidth != "auto") {
                if (minWidth.indexOf("px") != -1 && this.survey) {
                    minWidth = minWidth.replace("px", "");
                    var minWidthNum = parseFloat(minWidth);
                    if (!isNaN(minWidthNum)) {
                        minWidth = minWidthNum * this.survey.widthScale / 100;
                        minWidth = "" + minWidth + "px";
                    }
                }
                minWidth = "min(100%, " + minWidth + ")";
            }
            if (this.allowRootStyle && this.renderWidth) {
                // style["width"] = this.renderWidth;
                style["flexGrow"] = 1;
                style["flexShrink"] = 1;
                style["flexBasis"] = this.renderWidth;
                style["minWidth"] = minWidth;
                style["maxWidth"] = this.maxWidth;
            }
        }
        this.rootStyle = style;
    };
    SurveyElement.prototype.isContainsSelection = function (el) {
        var elementWithSelection = undefined;
        var _document = DomDocumentHelper.getDocument();
        if (DomDocumentHelper.isAvailable() && !!_document && _document["selection"]) {
            elementWithSelection = _document["selection"].createRange().parentElement();
        }
        else {
            var selection = DomWindowHelper.getSelection();
            if (!!selection && selection.rangeCount > 0) {
                var range = selection.getRangeAt(0);
                if (range.startOffset !== range.endOffset) {
                    elementWithSelection = range.startContainer.parentNode;
                }
            }
        }
        return elementWithSelection == el;
    };
    Object.defineProperty(SurveyElement.prototype, "clickTitleFunction", {
        get: function () {
            var _this = this;
            if (this.needClickTitleFunction()) {
                return function (event) {
                    if (!!event && _this.isContainsSelection(event.target)) {
                        return;
                    }
                    return _this.processTitleClick();
                };
            }
            return undefined;
        },
        enumerable: false,
        configurable: true
    });
    SurveyElement.prototype.needClickTitleFunction = function () {
        return this.state !== "default";
    };
    SurveyElement.prototype.processTitleClick = function () {
        if (this.state !== "default") {
            this.toggleState();
        }
    };
    Object.defineProperty(SurveyElement.prototype, "hasAdditionalTitleToolbar", {
        get: function () {
            return false;
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(SurveyElement.prototype, "additionalTitleToolbar", {
        get: function () {
            return this.getAdditionalTitleToolbar();
        },
        enumerable: false,
        configurable: true
    });
    SurveyElement.prototype.getAdditionalTitleToolbar = function () {
        return null;
    };
    SurveyElement.prototype.getCssTitle = function (cssClasses) {
        if (!cssClasses)
            return "";
        var isExpandable = this.state !== "default";
        var numInlineLimit = 4;
        return new CssClassBuilder()
            .append(cssClasses.title)
            .append(cssClasses.titleNumInline, (this.no || "").length > numInlineLimit || isExpandable)
            .append(cssClasses.titleExpandable, isExpandable)
            .append(cssClasses.titleExpanded, this.isExpanded)
            .append(cssClasses.titleCollapsed, this.isCollapsed)
            .append(cssClasses.titleDisabled, this.isDisabledStyle)
            .append(cssClasses.titleReadOnly, this.isReadOnly)
            .append(cssClasses.titleOnError, this.containsErrors).toString();
    };
    Object.defineProperty(SurveyElement.prototype, "isDisabledStyle", {
        get: function () {
            return this.getIsDisableAndReadOnlyStyles(false)[1];
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(SurveyElement.prototype, "isReadOnlyStyle", {
        get: function () {
            return this.getIsDisableAndReadOnlyStyles(false)[0];
        },
        enumerable: false,
        configurable: true
    });
    SurveyElement.prototype.getIsDisableAndReadOnlyStyles = function (itemReadOnly) {
        var isPreview = this.isPreviewStyle;
        var isReadOnly = itemReadOnly || this.isReadOnly;
        var isReadOnlyStyle = isReadOnly && !isPreview;
        var isDisableStyle = !this.isDefaultV2Theme && (isReadOnly || isPreview);
        return [isReadOnlyStyle, isDisableStyle];
    };
    Object.defineProperty(SurveyElement.prototype, "isPreviewStyle", {
        get: function () {
            return !!this.survey && this.survey.state === "preview";
        },
        enumerable: false,
        configurable: true
    });
    SurveyElement.prototype.localeChanged = function () {
        _super.prototype.localeChanged.call(this);
        this.updateDescriptionVisibility(this.description);
        if (this.errors.length > 0) {
            this.errors.forEach(function (err) {
                err.updateText();
            });
        }
    };
    SurveyElement.prototype.setWrapperElement = function (element) {
        this.wrapperElement = element;
    };
    SurveyElement.prototype.getWrapperElement = function () {
        return this.wrapperElement;
    };
    Object.defineProperty(SurveyElement.prototype, "isAnimatingCollapseExpand", {
        get: function () {
            return this._isAnimatingCollapseExpand || this._renderedIsExpanded != this.isExpanded;
        },
        set: function (val) {
            if (val !== this._isAnimatingCollapseExpand) {
                this._isAnimatingCollapseExpand = val;
                this.updateElementCss(false);
            }
        },
        enumerable: false,
        configurable: true
    });
    SurveyElement.prototype.onElementExpanded = function (elementIsRendered) {
    };
    SurveyElement.prototype.getExpandCollapseAnimationOptions = function () {
        var _this = this;
        var beforeRunAnimation = function (el) {
            _this.isAnimatingCollapseExpand = true;
            prepareElementForVerticalAnimation(el);
        };
        var afterRunAnimation = function (el) {
            _this.isAnimatingCollapseExpand = false;
            cleanHtmlElementAfterAnimation(el);
        };
        return {
            getRerenderEvent: function () { return _this.onElementRerendered; },
            getEnterOptions: function () {
                var cssClasses = _this.isPanel ? _this.cssClasses.panel : _this.cssClasses;
                return {
                    cssClass: cssClasses.contentEnter,
                    onBeforeRunAnimation: beforeRunAnimation,
                    onAfterRunAnimation: function (el) {
                        afterRunAnimation(el);
                        _this.onElementExpanded(true);
                    },
                };
            },
            getLeaveOptions: function () {
                var cssClasses = _this.isPanel ? _this.cssClasses.panel : _this.cssClasses;
                return {
                    cssClass: cssClasses.contentLeave,
                    onBeforeRunAnimation: beforeRunAnimation,
                    onAfterRunAnimation: afterRunAnimation
                };
            },
            getAnimatedElement: function () {
                var _a;
                var cssClasses = _this.isPanel ? _this.cssClasses.panel : _this.cssClasses;
                if (cssClasses.content) {
                    var selector = classesToSelector(cssClasses.content);
                    if (selector) {
                        return (_a = _this.getWrapperElement()) === null || _a === void 0 ? void 0 : _a.querySelector(":scope " + selector);
                    }
                }
                return undefined;
            },
            isAnimationEnabled: function () { return _this.isExpandCollapseAnimationEnabled; }
        };
    };
    Object.defineProperty(SurveyElement.prototype, "isExpandCollapseAnimationEnabled", {
        get: function () {
            return this.animationAllowed && !this.isDesignMode;
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(SurveyElement.prototype, "renderedIsExpanded", {
        get: function () {
            return !!this._renderedIsExpanded;
        },
        set: function (val) {
            var oldValue = this._renderedIsExpanded;
            this.animationCollapsed.sync(val);
            if (!this.isExpandCollapseAnimationEnabled && !oldValue && this.renderedIsExpanded) {
                this.onElementExpanded(false);
            }
        },
        enumerable: false,
        configurable: true
    });
    SurveyElement.prototype.getIsAnimationAllowed = function () {
        return _super.prototype.getIsAnimationAllowed.call(this) && !!this.survey && !this.survey["isEndLoadingFromJson"];
    };
    SurveyElement.prototype.afterRenderCore = function (element) {
        this.onAfterRenderElement.fire(this, { htmlElement: element });
    };
    SurveyElement.prototype.dispose = function () {
        _super.prototype.dispose.call(this);
        if (this.titleToolbarValue) {
            this.titleToolbarValue.dispose();
        }
    };
    // TODO V2: get rid of this flag
    SurveyElement.CreateDisabledDesignElements = false;
    survey_element_decorate([
        jsonobject_property({ defaultValue: null })
    ], SurveyElement.prototype, "dragTypeOverMe", void 0);
    survey_element_decorate([
        jsonobject_property({ defaultValue: false })
    ], SurveyElement.prototype, "isDragMe", void 0);
    survey_element_decorate([
        jsonobject_property({
            onSet: function (newValue, target) {
                target.colSpan = newValue;
            }
        })
    ], SurveyElement.prototype, "effectiveColSpan", void 0);
    survey_element_decorate([
        jsonobject_property({ defaultValue: false })
    ], SurveyElement.prototype, "hasVisibleErrors", void 0);
    survey_element_decorate([
        jsonobject_property({ defaultValue: true })
    ], SurveyElement.prototype, "isSingleInRow", void 0);
    survey_element_decorate([
        jsonobject_property({ defaultValue: true })
    ], SurveyElement.prototype, "allowRootStyle", void 0);
    survey_element_decorate([
        jsonobject_property()
    ], SurveyElement.prototype, "rootStyle", void 0);
    survey_element_decorate([
        jsonobject_property()
    ], SurveyElement.prototype, "_renderedIsExpanded", void 0);
    return SurveyElement;
}(survey_element_SurveyElementCore));

var RenderingCompletedAwaiter = /** @class */ (function () {
    function RenderingCompletedAwaiter(_elements, _renderedHandler, waitingTimeout) {
        var _this = this;
        if (waitingTimeout === void 0) { waitingTimeout = 100; }
        this._elements = _elements;
        this._renderedHandler = _renderedHandler;
        this._elementsToRenderCount = 0;
        this._elementsToRenderTimer = undefined;
        this._elementRenderedHandler = function (s, o) {
            var _a;
            (_a = s.onAfterRenderElement) === null || _a === void 0 ? void 0 : _a.remove(_this._elementRenderedHandler);
            _this._elementsToRenderCount--;
            if (_this._elementsToRenderCount <= 0) {
                _this.visibleElementsRendered();
            }
        };
        this._elements.forEach(function (element) {
            if (element.onAfterRenderElement) {
                element.onAfterRenderElement.add(_this._elementRenderedHandler);
                _this._elementsToRenderCount++;
            }
        });
        if (this._elementsToRenderCount > 0) {
            this._elementsToRenderTimer = setTimeout(function () {
                if (_this._elementsToRenderCount > 0) {
                    _this.visibleElementsRendered();
                }
            }, waitingTimeout);
        }
        else {
            this.visibleElementsRendered();
        }
    }
    RenderingCompletedAwaiter.prototype.stopWaitingForElementsRendering = function () {
        var _this = this;
        if (this._elementsToRenderTimer) {
            clearTimeout(this._elementsToRenderTimer);
            this._elementsToRenderTimer = undefined;
        }
        this._elements.forEach(function (element) {
            var _a;
            (_a = element.onAfterRenderElement) === null || _a === void 0 ? void 0 : _a.remove(_this._elementRenderedHandler);
        });
        this._elementsToRenderCount = 0;
    };
    RenderingCompletedAwaiter.prototype.visibleElementsRendered = function () {
        var renderedHandler = this._renderedHandler;
        this.dispose();
        if (typeof renderedHandler == "function") {
            renderedHandler();
        }
    };
    RenderingCompletedAwaiter.prototype.dispose = function () {
        this.stopWaitingForElementsRendering();
        this._elements = undefined;
        this._renderedHandler = undefined;
    };
    return RenderingCompletedAwaiter;
}());


// CONCATENATED MODULE: ./packages/survey-core/src/localizablestring.ts






/**
 * The class represents the string that supports multi-languages and markdown.
 * It uses in all objects where support for multi-languages and markdown is required.
 */
var localizablestring_LocalizableString = /** @class */ (function () {
    function LocalizableString(owner, useMarkdown, name, locName) {
        if (useMarkdown === void 0) { useMarkdown = false; }
        this.owner = owner;
        this.useMarkdown = useMarkdown;
        this.name = name;
        this.values = {};
        this.htmlValues = {};
        this.onStringChanged = new EventBase();
        this._localizationName = locName;
        this.onCreating();
    }
    Object.defineProperty(LocalizableString, "defaultLocale", {
        get: function () {
            return settings.localization.defaultLocaleName;
        },
        set: function (val) {
            settings.localization.defaultLocaleName = val;
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(LocalizableString.prototype, "localizationName", {
        get: function () {
            return this._localizationName;
        },
        set: function (val) {
            if (this._localizationName != val) {
                this._localizationName = val;
                this.strChanged();
            }
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(LocalizableString.prototype, "allowLineBreaks", {
        get: function () {
            var _a;
            if (this._allowLineBreaks === undefined) {
                this._allowLineBreaks = false;
                if (!!this.name && this.owner instanceof survey_element_SurveyElementCore) {
                    this._allowLineBreaks = ((_a = Serializer.findProperty(this.owner.getType(), this.name)) === null || _a === void 0 ? void 0 : _a.type) == "text";
                }
            }
            return this._allowLineBreaks;
        },
        enumerable: false,
        configurable: true
    });
    LocalizableString.prototype.getIsMultiple = function () { return false; };
    Object.defineProperty(LocalizableString.prototype, "locale", {
        get: function () {
            if (this.owner && this.owner.getLocale) {
                var res = this.owner.getLocale();
                if (!!res || !this.sharedData)
                    return res;
            }
            if (!!this.sharedData)
                return this.sharedData.locale;
            return "";
        },
        enumerable: false,
        configurable: true
    });
    LocalizableString.prototype.strChanged = function () {
        this.searchableText = undefined;
        if (this.renderedText === undefined && this.isEmpty && !this.onGetTextCallback && !this.localizationName)
            return;
        this.calculatedTextValue = this.calcText();
        if (this.renderedText !== this.calculatedTextValue) {
            this.renderedText = undefined;
            this.calculatedTextValue = undefined;
        }
        this.htmlValues = {};
        this.onChanged();
        this.onStringChanged.fire(this, {});
    };
    Object.defineProperty(LocalizableString.prototype, "text", {
        get: function () {
            return this.pureText;
        },
        set: function (value) {
            this.setLocaleText(this.locale, value);
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(LocalizableString.prototype, "calculatedText", {
        get: function () {
            this.renderedText =
                this.calculatedTextValue !== undefined
                    ? this.calculatedTextValue
                    : this.calcText();
            this.calculatedTextValue = undefined;
            return this.renderedText;
        },
        enumerable: false,
        configurable: true
    });
    LocalizableString.prototype.calcText = function () {
        var res = this.pureText;
        if (res &&
            this.owner &&
            this.owner.getProcessedText &&
            res.indexOf("{") > -1) {
            res = this.owner.getProcessedText(res);
        }
        if (this.onGetTextCallback)
            res = this.onGetTextCallback(res);
        return res;
    };
    Object.defineProperty(LocalizableString.prototype, "pureText", {
        get: function () {
            var loc = this.locale;
            if (!loc)
                loc = this.defaultLoc;
            var res = this.getValue(loc);
            if (this.isValueEmpty(res) && loc === this.defaultLoc) {
                res = this.getValue(surveyLocalization.defaultLocale);
            }
            if (this.isValueEmpty(res)) {
                var dialect = this.getRootDialect(loc);
                if (!!dialect) {
                    res = this.getValue(dialect);
                }
            }
            if (this.isValueEmpty(res) && loc !== this.defaultLoc) {
                res = this.getValue(this.defaultLoc);
            }
            if (this.isValueEmpty(res) && !!this.getLocalizationName()) {
                res = this.getLocalizationStr();
                if (!!this.onGetLocalizationTextCallback) {
                    res = this.onGetLocalizationTextCallback(res);
                }
            }
            if (!res)
                res = this.defaultValue || "";
            return res;
        },
        enumerable: false,
        configurable: true
    });
    LocalizableString.prototype.getRootDialect = function (loc) {
        if (!loc)
            return loc;
        var index = loc.indexOf("-");
        return index > -1 ? loc.substring(0, index) : "";
    };
    LocalizableString.prototype.getLocalizationName = function () {
        return !!this.sharedData ? this.sharedData.localizationName : this.localizationName;
    };
    LocalizableString.prototype.getLocalizationStr = function () {
        var name = this.getLocalizationName();
        return !!name ? getLocaleString(name, this.locale) : "";
    };
    Object.defineProperty(LocalizableString.prototype, "hasHtml", {
        get: function () {
            return this.hasHtmlValue();
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(LocalizableString.prototype, "html", {
        get: function () {
            if (!this.hasHtml)
                return "";
            return this.getHtmlValue();
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(LocalizableString.prototype, "isEmpty", {
        get: function () {
            return this.getValuesKeys().length == 0;
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(LocalizableString.prototype, "textOrHtml", {
        get: function () {
            return this.hasHtml ? this.getHtmlValue() : this.calculatedText;
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(LocalizableString.prototype, "renderedHtml", {
        get: function () {
            return this.textOrHtml;
        },
        enumerable: false,
        configurable: true
    });
    LocalizableString.prototype.getLocaleText = function (loc) {
        var res = this.getLocaleTextCore(loc);
        return res ? res : "";
    };
    LocalizableString.prototype.getLocaleTextCore = function (loc) {
        if (!loc)
            loc = this.defaultLoc;
        return this.getValue(loc);
    };
    LocalizableString.prototype.isLocaleTextEqualsWithDefault = function (loc, val) {
        var res = this.getLocaleTextCore(loc);
        if (res === val)
            return true;
        return this.isValueEmpty(res) && this.isValueEmpty(val);
    };
    LocalizableString.prototype.clear = function () {
        this.setJson(undefined);
    };
    LocalizableString.prototype.clearLocale = function (loc) {
        this.setLocaleText(loc, undefined);
    };
    LocalizableString.prototype.setLocaleText = function (loc, value) {
        loc = this.getValueLoc(loc);
        if (!!loc && value === undefined) {
            var oldValue_1 = this.getValue(loc);
            if (oldValue_1 !== undefined) {
                this.deleteValue(loc);
                this.fireStrChanged(loc, oldValue_1);
            }
            return;
        }
        if (!this.storeDefaultText && this.isLocaleTextEqualsWithDefault(loc, value)) {
            if (!this.isValueEmpty(value) || !!loc && loc !== this.defaultLoc)
                return;
            var dl = surveyLocalization.defaultLocale;
            var oldValue_2 = this.getValue(dl);
            if (!!dl && !this.isValueEmpty(oldValue_2)) {
                this.setValue(dl, value);
                this.fireStrChanged(dl, oldValue_2);
            }
            return;
        }
        if (!settings.localization.storeDuplicatedTranslations &&
            !this.isValueEmpty(value) && loc && loc != this.defaultLoc &&
            !this.getValue(loc) &&
            value == this.getLocaleText(this.defaultLoc))
            return;
        var curLoc = this.curLocale;
        if (!loc)
            loc = this.defaultLoc;
        var oldValue = this.onStrChanged && loc === curLoc ? this.pureText : undefined;
        delete this.htmlValues[loc];
        if (this.isValueEmpty(value)) {
            this.deleteValue(loc);
        }
        else {
            if (typeof value === "string") {
                if (this.canRemoveLocValue(loc, value)) {
                    this.setLocaleText(loc, null);
                }
                else {
                    this.setValue(loc, value);
                    if (loc == this.defaultLoc) {
                        this.deleteValuesEqualsToDefault(value);
                    }
                }
            }
        }
        this.fireStrChanged(loc, oldValue);
    };
    LocalizableString.prototype.isValueEmpty = function (val) {
        if (val === undefined || val === null)
            return true;
        if (this.localizationName)
            return false;
        return val === "";
    };
    Object.defineProperty(LocalizableString.prototype, "curLocale", {
        get: function () {
            return !!this.locale ? this.locale : this.defaultLoc;
        },
        enumerable: false,
        configurable: true
    });
    LocalizableString.prototype.canRemoveLocValue = function (loc, val) {
        if (settings.localization.storeDuplicatedTranslations)
            return false;
        if (loc === this.defaultLoc)
            return false;
        var dialect = this.getRootDialect(loc);
        if (!!dialect) {
            var dialectVal = this.getLocaleText(dialect);
            if (!!dialectVal)
                return dialectVal == val;
            return this.canRemoveLocValue(dialect, val);
        }
        else {
            return val == this.getLocaleText(this.defaultLoc);
        }
    };
    LocalizableString.prototype.fireStrChanged = function (loc, oldValue) {
        this.strChanged();
        if (!this.onStrChanged)
            return;
        var value = this.pureText;
        if (loc !== this.curLocale || oldValue !== value) {
            this.onStrChanged(oldValue, value);
        }
    };
    LocalizableString.prototype.hasNonDefaultText = function () {
        var keys = this.getValuesKeys();
        if (keys.length == 0)
            return false;
        return keys.length > 1 || keys[0] != this.defaultLoc;
    };
    LocalizableString.prototype.getLocales = function () {
        var keys = this.getValuesKeys();
        if (keys.length == 0)
            return [];
        return keys;
    };
    LocalizableString.prototype.getJson = function () {
        if (!!this.sharedData)
            return this.sharedData.getJson();
        var keys = this.getValuesKeys();
        if (keys.length == 0) {
            if (this.serializeCallBackText) {
                var text = this.calcText();
                if (!!text)
                    return text;
            }
            return null;
        }
        if (keys.length == 1 &&
            keys[0] == settings.localization.defaultLocaleName &&
            !settings.serialization.localizableStringSerializeAsObject)
            return this.values[keys[0]];
        var res = {};
        for (var key in this.values) {
            res[key] = this.values[key];
        }
        return res;
    };
    LocalizableString.prototype.setJson = function (value, isLoading) {
        if (!!this.sharedData) {
            this.sharedData.setJson(value, isLoading);
            return;
        }
        this.values = {};
        this.htmlValues = {};
        if (value === null || value === undefined)
            return;
        if (isLoading) {
            if (typeof value === "string") {
                this.values[settings.defaultLocaleName] = value;
            }
            else {
                this.values = value;
                delete this.values["pos"];
            }
        }
        else {
            if (typeof value === "string") {
                this.setLocaleText(null, value);
            }
            else {
                for (var key in value) {
                    this.setLocaleText(key, value[key]);
                }
            }
            this.strChanged();
        }
    };
    Object.defineProperty(LocalizableString.prototype, "renderAs", {
        get: function () {
            if (!this.owner || typeof this.owner.getRenderer !== "function") {
                return LocalizableString.defaultRenderer;
            }
            return this.owner.getRenderer(this.name) || LocalizableString.defaultRenderer;
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(LocalizableString.prototype, "renderAsData", {
        get: function () {
            if (!this.owner || typeof this.owner.getRendererContext !== "function") {
                return this;
            }
            return this.owner.getRendererContext(this) || this;
        },
        enumerable: false,
        configurable: true
    });
    LocalizableString.prototype.equals = function (obj) {
        if (!!this.sharedData)
            return this.sharedData.equals(obj);
        if (!obj || !obj.values)
            return false;
        return helpers_Helpers.isTwoValueEquals(this.values, obj.values, false, true, false);
    };
    LocalizableString.prototype.setFindText = function (text) {
        if (this.searchText == text)
            return;
        this.searchText = text;
        if (!this.searchableText) {
            var textOrHtml = this.textOrHtml;
            this.searchableText = !!textOrHtml ? textOrHtml.toLowerCase() : "";
        }
        var str = this.searchableText;
        var index = !!str && !!text ? str.indexOf(text) : undefined;
        if (index < 0)
            index = undefined;
        if (index != undefined || this.searchIndex != index) {
            this.searchIndex = index;
            if (!!this.onSearchChanged) {
                this.onSearchChanged();
            }
        }
        return this.searchIndex != undefined;
    };
    LocalizableString.prototype.onChanged = function () { };
    LocalizableString.prototype.onCreating = function () { };
    LocalizableString.prototype.hasHtmlValue = function () {
        if (!this.owner || !this.useMarkdown)
            return false;
        var loc = this.locale;
        if (!loc)
            loc = this.defaultLoc;
        if (this.htmlValues[loc] !== undefined)
            return !!this.htmlValues[loc];
        var renderedText = this.calculatedText;
        if (!renderedText) {
            this.setHtmlValue(loc, "");
            return false;
        }
        if (!!this.getLocalizationName() && renderedText === this.getLocalizationStr()) {
            this.setHtmlValue(loc, "");
            return false;
        }
        var res = this.owner.getMarkdownHtml(renderedText, this.name);
        this.setHtmlValue(loc, res);
        return !!res;
    };
    LocalizableString.prototype.setHtmlValue = function (loc, val) {
        this.htmlValues[loc] = val;
    };
    LocalizableString.prototype.getHtmlValue = function () {
        var loc = this.locale;
        if (!loc)
            loc = this.defaultLoc;
        return this.htmlValues[loc];
    };
    LocalizableString.prototype.deleteValuesEqualsToDefault = function (defaultValue) {
        if (settings.localization.storeDuplicatedTranslations)
            return;
        var keys = this.getValuesKeys();
        for (var i = 0; i < keys.length; i++) {
            if (keys[i] == this.defaultLoc)
                continue;
            if (this.getValue(keys[i]) == defaultValue) {
                this.deleteValue(keys[i]);
            }
        }
    };
    LocalizableString.prototype.getValue = function (loc) {
        if (!!this.sharedData)
            return this.sharedData.getValue(loc);
        return this.values[this.getValueLoc(loc)];
    };
    LocalizableString.prototype.setValue = function (loc, value) {
        if (!!this.sharedData)
            this.sharedData.setValue(loc, value);
        else
            this.values[this.getValueLoc(loc)] = value;
    };
    LocalizableString.prototype.deleteValue = function (loc) {
        if (!!this.sharedData)
            this.sharedData.deleteValue(loc);
        else
            delete this.values[this.getValueLoc(loc)];
    };
    LocalizableString.prototype.getValueLoc = function (loc) {
        if (this.disableLocalization)
            return settings.localization.defaultLocaleName;
        return loc;
    };
    LocalizableString.prototype.getValuesKeys = function () {
        if (!!this.sharedData)
            return this.sharedData.getValuesKeys();
        return Object.keys(this.values);
    };
    Object.defineProperty(LocalizableString.prototype, "defaultLoc", {
        get: function () {
            return settings.localization.defaultLocaleName;
        },
        enumerable: false,
        configurable: true
    });
    LocalizableString.SerializeAsObject = false;
    LocalizableString.defaultRenderer = "sv-string-viewer";
    LocalizableString.editableRenderer = "sv-string-editor";
    return LocalizableString;
}());

/**
 * The class represents the list of strings that supports multi-languages.
 */
var localizablestring_LocalizableStrings = /** @class */ (function () {
    function LocalizableStrings(owner) {
        this.owner = owner;
        this.values = {};
    }
    LocalizableStrings.prototype.getIsMultiple = function () { return true; };
    Object.defineProperty(LocalizableStrings.prototype, "locale", {
        get: function () {
            return this.owner && this.owner.getLocale ? this.owner.getLocale() : "";
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(LocalizableStrings.prototype, "value", {
        get: function () {
            return this.getValue("");
        },
        set: function (val) {
            this.setValue("", val);
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(LocalizableStrings.prototype, "text", {
        get: function () {
            return Array.isArray(this.value) ? this.value.join("\n") : "";
        },
        set: function (val) {
            this.value = !!val ? val.split("\n") : [];
        },
        enumerable: false,
        configurable: true
    });
    LocalizableStrings.prototype.getLocaleText = function (loc) {
        var res = this.getValueCore(loc, !loc || loc === this.locale);
        if (!res || !Array.isArray(res) || res.length == 0)
            return "";
        return res.join("\n");
    };
    LocalizableStrings.prototype.setLocaleText = function (loc, newValue) {
        var val = !!newValue ? newValue.split("\n") : null;
        this.setValue(loc, val);
    };
    LocalizableStrings.prototype.getValue = function (loc) {
        return this.getValueCore(loc);
    };
    LocalizableStrings.prototype.getValueCore = function (loc, useDefault) {
        if (useDefault === void 0) { useDefault = true; }
        loc = this.getLocale(loc);
        if (this.values[loc])
            return this.values[loc];
        if (useDefault) {
            var defLoc = settings.localization.defaultLocaleName;
            if (loc !== defLoc && this.values[defLoc])
                return this.values[defLoc];
        }
        return [];
    };
    LocalizableStrings.prototype.setValue = function (loc, val) {
        loc = this.getLocale(loc);
        var oldValue = helpers_Helpers.createCopy(this.values);
        if (!val || val.length == 0) {
            delete this.values[loc];
        }
        else {
            this.values[loc] = val;
        }
        if (!!this.onValueChanged) {
            this.onValueChanged(oldValue, this.values);
        }
    };
    LocalizableStrings.prototype.hasValue = function (loc) {
        if (loc === void 0) { loc = ""; }
        return !this.isEmpty && this.getValue(loc).length > 0;
    };
    Object.defineProperty(LocalizableStrings.prototype, "isEmpty", {
        get: function () {
            return this.getValuesKeys().length == 0;
        },
        enumerable: false,
        configurable: true
    });
    LocalizableStrings.prototype.getLocale = function (loc) {
        if (!!loc)
            return loc;
        loc = this.locale;
        return !!loc ? loc : settings.localization.defaultLocaleName;
    };
    LocalizableStrings.prototype.getLocales = function () {
        var keys = this.getValuesKeys();
        if (keys.length == 0)
            return [];
        return keys;
    };
    LocalizableStrings.prototype.getJson = function () {
        var keys = this.getValuesKeys();
        if (keys.length == 0)
            return null;
        if (keys.length == 1 &&
            keys[0] == settings.localization.defaultLocaleName &&
            !settings.serialization.localizableStringSerializeAsObject)
            return this.values[keys[0]];
        return helpers_Helpers.createCopy(this.values);
    };
    LocalizableStrings.prototype.setJson = function (value) {
        this.values = {};
        if (!value)
            return;
        if (Array.isArray(value)) {
            this.setValue(null, value);
        }
        else {
            for (var key in value) {
                this.setValue(key, value[key]);
            }
        }
    };
    LocalizableStrings.prototype.getValuesKeys = function () {
        return Object.keys(this.values);
    };
    return LocalizableStrings;
}());


// CONCATENATED MODULE: ./packages/survey-core/src/utils/utils.ts




function compareVersions(a, b) {
    var regExStrip0 = /(\.0+)+$/;
    var segmentsA = a.replace(regExStrip0, "").split(".");
    var segmentsB = b.replace(regExStrip0, "").split(".");
    var len = Math.min(segmentsA.length, segmentsB.length);
    for (var i = 0; i < len; i++) {
        var diff = parseInt(segmentsA[i], 10) - parseInt(segmentsB[i], 10);
        if (diff) {
            return diff;
        }
    }
    return segmentsA.length - segmentsB.length;
}
function confirmAction(message) {
    if (!!settings && !!settings.confirmActionFunc)
        return settings.confirmActionFunc(message);
    return confirm(message);
}
function confirmActionAsync(options) {
    var callbackFunc = function (res) {
        if (res)
            options.funcOnYes();
        else if (!!options.funcOnNo)
            options.funcOnNo();
    };
    if (!!settings && !!settings.confirmActionAsync) {
        if (settings.confirmActionAsync(options.message, callbackFunc, options))
            return;
    }
    callbackFunc(confirmAction(options.message));
}
function detectIEBrowser() {
    var ua = navigator.userAgent;
    var oldIe = ua.indexOf("MSIE ");
    var elevenIe = ua.indexOf("Trident/");
    return oldIe > -1 || elevenIe > -1;
}
function detectIEOrEdge() {
    if (typeof detectIEOrEdge.isIEOrEdge === "undefined") {
        var ua = navigator.userAgent;
        var msie = ua.indexOf("MSIE ");
        var trident = ua.indexOf("Trident/");
        var edge = ua.indexOf("Edge/");
        detectIEOrEdge.isIEOrEdge = edge > 0 || trident > 0 || msie > 0;
    }
    return detectIEOrEdge.isIEOrEdge;
}
function loadFileFromBase64(b64Data, fileName) {
    try {
        var byteString = atob(b64Data.split(",")[1]);
        // separate out the mime component
        var mimeString = b64Data
            .split(",")[0]
            .split(":")[1]
            .split(";")[0];
        // write the bytes of the string to an ArrayBuffer
        var ab = new ArrayBuffer(byteString.length);
        var ia = new Uint8Array(ab);
        for (var i = 0; i < byteString.length; i++) {
            ia[i] = byteString.charCodeAt(i);
        }
        // write the ArrayBuffer to a blob, and you're done
        var bb = new Blob([ab], { type: mimeString });
        if (!!navigator && navigator["msSaveBlob"]) {
            navigator["msSaveOrOpenBlob"](bb, fileName);
        }
    }
    catch (err) { }
}
function isMobile() {
    return (DomWindowHelper.isAvailable() && DomWindowHelper.hasOwn("orientation"));
}
var isShadowDOM = function (rootElement) {
    return !!rootElement && !!("host" in rootElement && rootElement.host);
};
var getElement = function (element) {
    var root = settings.environment.root;
    return typeof element === "string" ? root.getElementById(element) : element;
};
function isElementVisible(element, threshold) {
    if (threshold === void 0) { threshold = 0; }
    if (typeof settings.environment === "undefined") {
        return false;
    }
    var root = settings.environment.root;
    var clientHeight = isShadowDOM(root)
        ? root.host.clientHeight
        : root.documentElement.clientHeight;
    var elementRect = element.getBoundingClientRect();
    var viewHeight = Math.max(clientHeight, DomWindowHelper.getInnerHeight());
    var topWin = -threshold;
    var bottomWin = viewHeight + threshold;
    var topEl = elementRect.top;
    var bottomEl = elementRect.bottom;
    var maxTop = Math.max(topWin, topEl);
    var minBottom = Math.min(bottomWin, bottomEl);
    return maxTop <= minBottom;
}
function findScrollableParent(element) {
    var root = settings.environment.root;
    if (!element) {
        return isShadowDOM(root)
            ? root.host
            : root.documentElement;
    }
    if (element.scrollHeight > element.clientHeight &&
        (getComputedStyle(element).overflowY === "scroll" ||
            getComputedStyle(element).overflowY === "auto")) {
        return element;
    }
    if (element.scrollWidth > element.clientWidth &&
        (getComputedStyle(element).overflowX === "scroll" ||
            getComputedStyle(element).overflowX === "auto")) {
        return element;
    }
    return findScrollableParent(element.parentElement);
}
function activateLazyRenderingChecks(id) {
    var environment = settings.environment;
    if (!environment)
        return;
    var root = environment.root;
    var el = root.getElementById(id);
    if (!el)
        return;
    var scrollableEl = findScrollableParent(el);
    if (!!scrollableEl) {
        setTimeout(function () { return scrollableEl.dispatchEvent(new CustomEvent("scroll")); }, 10);
    }
}
function navigateToUrl(url) {
    var location = DomWindowHelper.getLocation();
    if (!url || !location)
        return;
    location.href = getSafeUrl(url);
}
function wrapUrlForBackgroundImage(url) {
    return !!url ? ["url(", url, ")"].join("") : "";
}
function isBase64URL(url) {
    if (typeof url == "string") {
        return /^data:((?:\w+\/(?:(?!;).)+)?)((?:;[^;]+?)*),(.+)$/.test(url);
    }
    return null;
}
// old-name: new-name
var renamedIcons = {
    "changecamera": "flip-24x24",
    "clear": "clear-24x24",
    "cancel": "cancel-24x24",
    "closecamera": "close-24x24",
    "defaultfile": "file-72x72",
    "choosefile": "folder-24x24",
    "file": "toolbox-file-24x24",
    "left": "chevronleft-16x16",
    "modernbooleancheckchecked": "plus-32x32",
    "modernbooleancheckunchecked": "minus-32x32",
    "more": "more-24x24",
    "navmenu_24x24": "navmenu-24x24",
    "removefile": "error-24x24",
    "takepicture": "camera-32x32",
    "takepicture_24x24": "camera-24x24",
    "v2check": "check-16x16",
    "checked": "check-16x16",
    "v2check_24x24": "check-24x24",
    "back-to-panel_16x16": "restoredown-16x16",
    "clear_16x16": "clear-16x16",
    "close_16x16": "close-16x16",
    "collapsedetail": "collapsedetails-16x16",
    "expanddetail": "expanddetails-16x16",
    "full-screen_16x16": "maximize-16x16",
    "loading": "loading-48x48",
    "minimize_16x16": "minimize-16x16",
    "next_16x16": "chevronright-16x16",
    "previous_16x16": "chevronleft-16x16",
    "no-image": "noimage-48x48",
    "ranking-dash": "rankingundefined-16x16",
    "drag-n-drop": "drag-24x24",
    "ranking-arrows": "reorder-24x24",
    "restore_16x16": "fullsize-16x16",
    "reset": "restore-24x24",
    "search": "search-24x24",
    "average": "smiley-rate5-24x24",
    "excellent": "smiley-rate9-24x24",
    "good": "smiley-rate7-24x24",
    "normal": "smiley-rate6-24x24",
    "not-good": "smiley-rate4-24x24",
    "perfect": "smiley-rate10-24x24",
    "poor": "smiley-rate3-24x24",
    "terrible": "smiley-rate1-24x24",
    "very-good": "smiley-rate8-24x24",
    "very-poor": "smiley-rate2-24x24",
    "add_16x16": "add-16x16",
    "add_24x24": "add-24x24",
    "alert_24x24": "warning-24x24",
    "apply": "apply-24x24",
    "arrow-down": "arrowdown-24x24",
    "arrow-left": "arrowleft-24x24",
    "arrow-left_16x16": "arrowleft-16x16",
    "arrowleft": "arrowleft-16x16",
    "arrow-right": "arrowright-24x24",
    "arrow-right_16x16": "arrowright-16x16",
    "arrowright": "arrowright-16x16",
    "arrow-up": "arrowup-24x24",
    "boolean": "toolbox-boolean-24x24",
    "change-question-type_16x16": "speechbubble-16x16",
    "checkbox": "toolbox-checkbox-24x24",
    "collapse-detail_16x16": "minusbox-16x16",
    "collapse-panel": "collapse-pg-24x24",
    "collapse_16x16": "collapse-16x16",
    "color-picker": "dropper-16x16",
    "comment": "toolbox-longtext-24x24",
    "config": "wrench-24x24",
    "copy": "copy-24x24",
    "default": "toolbox-customquestion-24x24",
    "delete_16x16": "delete-16x16",
    "delete_24x24": "delete-24x24",
    "delete": "delete-24x24",
    "description-hide": "hidehint-16x16",
    "description": "hint-16x16",
    "device-desktop": "desktop-24x24",
    "device-phone": "phone-24x24",
    "device-rotate": "rotate-24x24",
    "device-tablet": "tablet-24x24",
    "download": "download-24x24",
    "drag-area-indicator": "drag-24x24",
    "drag-area-indicator_24x16": "draghorizontal-24x16",
    "v2dragelement_16x16": "draghorizontal-24x16",
    "drop-down-arrow": "chevrondown-24x24",
    "drop-down-arrow_16x16": "chevrondown-16x16",
    "chevron_16x16": "chevrondown-16x16",
    "dropdown": "toolbox-dropdown-24x24",
    "duplicate_16x16": "copy-16x16",
    "edit": "edit-24x24",
    "edit_16x16": "edit-16x16",
    "editing-finish": "finishedit-24x24",
    "error": "error-16x16",
    "expand-detail_16x16": "plusbox-16x16",
    "expand-panel": "expand-pg-24x24",
    "expand_16x16": "expand-16x16",
    "expression": "toolbox-expression-24x24",
    "fast-entry": "textedit-24x24",
    "fix": "fix-24x24",
    "html": "toolbox-html-24x24",
    "image": "toolbox-image-24x24",
    "imagepicker": "toolbox-imagepicker-24x24",
    "import": "import-24x24",
    "invisible-items": "invisible-24x24",
    "language": "language-24x24",
    "load": "import-24x24",
    "logic-collapse": "collapse-24x24",
    "logic-expand": "expand-24x24",
    "logo": "image-48x48",
    "matrix": "toolbox-matrix-24x24",
    "matrixdropdown": "toolbox-multimatrix-24x24",
    "matrixdynamic": "toolbox-dynamicmatrix-24x24",
    "multipletext": "toolbox-multipletext-24x24",
    "panel": "toolbox-panel-24x24",
    "paneldynamic": "toolbox-dynamicpanel-24x24",
    "preview": "preview-24x24",
    "radiogroup": "toolbox-radiogroup-24x24",
    "ranking": "toolbox-ranking-24x24",
    "rating": "toolbox-rating-24x24",
    "redo": "redo-24x24",
    "remove_16x16": "remove-16x16",
    "required": "required-16x16",
    "save": "save-24x24",
    "select-page": "selectpage-24x24",
    "settings": "settings-24x24",
    "settings_16x16": "settings-16x16",
    "signaturepad": "toolbox-signature-24x24",
    "switch-active_16x16": "switchon-16x16",
    "switch-inactive_16x16": "switchoff-16x16",
    "tagbox": "toolbox-tagbox-24x24",
    "text": "toolbox-singleline-24x24",
    "theme": "theme-24x24",
    "toolbox": "toolbox-24x24",
    "undo": "undo-24x24",
    "visible": "visible-24x24",
    "wizard": "wand-24x24",
    "searchclear": "clear-16x16",
    "chevron-16x16": "chevrondown-16x16",
    "chevron": "chevrondown-24x24",
    "progressbuttonv2": "arrowleft-16x16",
    "right": "chevronright-16x16",
    "add-lg": "add-24x24",
    "add": "add-24x24",
};
function getIconNameFromProxy(iconName) {
    var customIconName = getCustomNewIconNameIfExists(iconName);
    return customIconName || getNewIconName(iconName);
}
function getNewIconName(iconName) {
    var prefix = "icon-";
    var nameWithoutPrefix = iconName.replace(prefix, "");
    var result = renamedIcons[nameWithoutPrefix] || nameWithoutPrefix;
    return prefix + result;
}
function getCustomNewIconNameIfExists(iconName) {
    // only for settings.customIcons["icon-import"] = "icon-export"; feature
    var result = settings.customIcons[iconName];
    if (result)
        return getNewIconName(result);
    iconName = getNewIconName(iconName);
    result = settings.customIcons[iconName];
    if (result)
        return result;
    return null;
}
function createSvg(size, width, height, iconName, svgElem, title) {
    if (!svgElem)
        return;
    if (size !== "auto") {
        svgElem.style.width = (size || width || 16) + "px";
        svgElem.style.height = (size || height || 16) + "px";
    }
    var node = svgElem.childNodes[0];
    var realIconName = getIconNameFromProxy(iconName);
    node.setAttributeNS("http://www.w3.org/1999/xlink", "xlink:href", "#" + realIconName);
    var titleElement = svgElem.getElementsByTagName("title")[0];
    if (!title) {
        if (!!titleElement) {
            svgElem.removeChild(titleElement);
        }
        return;
    }
    else {
        if (!titleElement) {
            titleElement = DomDocumentHelper.getDocument().createElementNS("http://www.w3.org/2000/svg", "title");
            svgElem.appendChild(titleElement);
        }
    }
    titleElement.textContent = title;
}
function getSafeUrl(url) {
    if (!url)
        return url;
    if (url.toLocaleLowerCase().indexOf("javascript:") > -1)
        return encodeURIComponent(url);
    return url;
}
function unwrap(value) {
    if (typeof value !== "function") {
        return value;
    }
    else {
        return value();
    }
}
// export function getSize(value: any): number {
//   if (typeof value === "number") {
//     return value;
//   }
//   if (typeof value === "string" && value.includes("px")) {
//     return parseInt(value);
//   }
//   if (!!value && typeof value === "string" && value.length > 0) {
//     const lastSymbol: string = value[value.length - 1];
//     if ((lastSymbol >= "0" && lastSymbol <= "9") || lastSymbol == ".") {
//       try {
//         const num: number = parseInt(value);
//         return num;
//       } catch { }
//     }
//   }
//   return value;
// }
function getRenderedSize(val) {
    if (typeof val == "string") {
        if (!isNaN(Number(val))) {
            return Number(val);
        }
        else if (val.includes("px")) {
            return parseFloat(val);
        }
    }
    if (typeof val == "number") {
        return val;
    }
    return undefined;
}
function getRenderedStyleSize(val) {
    if (getRenderedSize(val) !== undefined) {
        return undefined;
    }
    return val;
}
var keyFocusedClassName = "sv-focused--by-key";
function doKey2ClickBlur(evt) {
    var element = evt.target;
    if (!element || !element.classList)
        return;
    element.classList.remove(keyFocusedClassName);
}
function doKey2ClickUp(evt, options) {
    if (!!evt.target && evt.target["contentEditable"] === "true") {
        return;
    }
    var element = evt.target;
    if (!element)
        return;
    var char = evt.which || evt.keyCode;
    if (char === 9) {
        if (!!element.classList && !element.classList.contains(keyFocusedClassName)) {
            element.classList.add(keyFocusedClassName);
        }
        return;
    }
    if (options) {
        if (!options.__keyDownReceived)
            return;
        options.__keyDownReceived = false;
    }
    if (char === 13 || char === 32) {
        if (element.click)
            element.click();
    }
    else if ((!options || options.processEsc) && char === 27) {
        if (element.blur)
            element.blur();
    }
}
function doKey2ClickDown(evt, options) {
    if (options === void 0) { options = { processEsc: true }; }
    if (options)
        options.__keyDownReceived = true;
    if (!!evt.target && evt.target["contentEditable"] === "true") {
        return;
    }
    var char = evt.which || evt.keyCode;
    var supportedCodes = [13, 32];
    if (options.processEsc) {
        supportedCodes.push(27);
    }
    if (supportedCodes.indexOf(char) !== -1) {
        evt.preventDefault();
    }
}
function increaseHeightByContent(element, getComputedStyle) {
    if (!element)
        return;
    if (!getComputedStyle)
        getComputedStyle = function (elt) { return DomDocumentHelper.getComputedStyle(elt); };
    var style = getComputedStyle(element);
    element.style.height = "auto";
    if (!!element.scrollHeight) {
        element.style.height = (element.scrollHeight + parseFloat(style.borderTopWidth) + parseFloat(style.borderBottomWidth)) + "px";
    }
}
function getOriginalEvent(event) {
    return event.originalEvent || event;
}
function preventDefaults(event) {
    event.preventDefault();
    event.stopPropagation();
}
function classesToSelector(str) {
    if (!str)
        return str;
    var re = /\s*?([\w-]+)\s*?/g;
    return str.replace(re, ".$1");
}
function getElementWidth(el) {
    return !!getComputedStyle ? Number.parseFloat(getComputedStyle(el).width) : el.offsetWidth;
}
function isContainerVisible(el) {
    return !!(el.offsetWidth ||
        el.offsetHeight ||
        el.getClientRects().length);
}
function getFirstVisibleChild(el) {
    var result;
    for (var index = 0; index < el.children.length; index++) {
        if (!result && getComputedStyle(el.children[index]).display !== "none") {
            result = el.children[index];
        }
    }
    return result;
}
function findParentByClassNames(element, classNames) {
    if (!!element) {
        if (classNames.every(function (className) { return !className || element.classList.contains(className); })) {
            return element;
        }
        else {
            return findParentByClassNames(element.parentElement, classNames);
        }
    }
}
function sanitizeEditableContent(element, cleanLineBreaks) {
    if (cleanLineBreaks === void 0) { cleanLineBreaks = true; }
    if (DomWindowHelper.isAvailable() && DomDocumentHelper.isAvailable() && element.childNodes.length > 0) {
        var selection = DomWindowHelper.getSelection();
        if (selection.rangeCount == 0) {
            return;
        }
        var range = selection.getRangeAt(0);
        range.setStart(range.endContainer, range.endOffset);
        range.setEndAfter(element.lastChild);
        selection.removeAllRanges();
        selection.addRange(range);
        var tail = selection.toString();
        var innerText = element.innerText;
        tail = tail.replace(/\r/g, "");
        if (cleanLineBreaks) {
            tail = tail.replace(/\n/g, "");
            innerText = innerText.replace(/\n/g, "");
        }
        var tail_len = tail.length;
        element.innerText = innerText;
        range = DomDocumentHelper.getDocument().createRange();
        range.setStart(element.firstChild, 0);
        range.setEnd(element.firstChild, 0);
        selection.removeAllRanges();
        selection.addRange(range);
        while (selection.toString().length < innerText.length - tail_len) {
            var selLen = selection.toString().length;
            selection.modify("extend", "forward", "character");
            if (selection.toString().length == selLen)
                break;
        }
        range = selection.getRangeAt(0);
        range.setStart(range.endContainer, range.endOffset);
    }
}
function mergeValues(src, dest) {
    if (!dest || !src)
        return;
    if (typeof dest !== "object")
        return;
    for (var key in src) {
        var value = src[key];
        if (!Array.isArray(value) && value && typeof value === "object") {
            if (!dest[key] || typeof dest[key] !== "object")
                dest[key] = {};
            mergeValues(value, dest[key]);
        }
        else {
            dest[key] = value;
        }
    }
}
function updateListCssValues(res, css) {
    var listCssClasses = {};
    mergeValues(css.list, listCssClasses);
    mergeValues(res.list, listCssClasses);
    res["list"] = listCssClasses;
}
var Logger = /** @class */ (function () {
    function Logger() {
        this._result = "";
    }
    Logger.prototype.log = function (action) {
        this._result += "->" + action;
    };
    Object.defineProperty(Logger.prototype, "result", {
        get: function () {
            return this._result;
        },
        enumerable: false,
        configurable: true
    });
    return Logger;
}());

function showConfirmDialog(message, callback, options) {
    var locStr = new localizablestring_LocalizableString(undefined);
    var popupViewModel = settings.showDialog({
        componentName: "sv-string-viewer",
        data: { locStr: locStr, locString: locStr, model: locStr },
        onApply: function () {
            callback(true);
            return true;
        },
        onCancel: function () {
            callback(false);
            return false;
        },
        title: message || options.message,
        displayMode: "popup",
        isFocusedContent: false,
        cssClass: options.cssClass || "sv-popup--confirm"
    }, options.rootElement);
    var toolbar = popupViewModel.footerToolbar;
    var applyBtn = toolbar.getActionById("apply");
    var cancelBtn = toolbar.getActionById("cancel");
    cancelBtn.title = getLocaleString("cancel", options.locale);
    cancelBtn.innerCss = "sv-popup__body-footer-item sv-popup__button sd-btn sd-btn--small";
    applyBtn.title = options.applyTitle || getLocaleString("ok", options.locale);
    applyBtn.innerCss = "sv-popup__body-footer-item sv-popup__button sv-popup__button--danger sd-btn sd-btn--small sd-btn--danger";
    configConfirmDialog(popupViewModel);
    return true;
}
function configConfirmDialog(popupViewModel) {
    popupViewModel.width = "min-content";
}
function chooseFiles(input, callback) {
    if (!DomWindowHelper.isFileReaderAvailable())
        return;
    input.value = "";
    input.onchange = function (event) {
        if (!DomWindowHelper.isFileReaderAvailable())
            return;
        if (!input || !input.files || input.files.length < 1)
            return;
        var files = [];
        for (var i = 0; i < input.files.length; i++) {
            files.push(input.files[i]);
        }
        callback(files);
    };
    input.click();
}
function compareArrays(oldValue, newValue, getKey) {
    var oldItemsMap = new Map();
    var newItemsMap = new Map();
    var commonItemsInNewMap = new Map();
    var commonItemsInOldMap = new Map();
    oldValue.forEach(function (item) {
        var itemKey = getKey(item);
        if (!oldItemsMap.has(itemKey)) {
            oldItemsMap.set(getKey(item), item);
        }
        else {
            //if keys are set incorrectly do not process comparing
            throw new Error("keys must be unique");
        }
    });
    newValue.forEach(function (item) {
        var itemKey = getKey(item);
        if (!newItemsMap.has(itemKey)) {
            newItemsMap.set(itemKey, item);
        }
        else {
            //if keys are set incorrectly do not process comparing
            throw new Error("keys must be unique");
        }
    });
    var addedItems = [];
    var deletedItems = [];
    //calculating addedItems and items that exist in both arrays
    newItemsMap.forEach(function (item, key) {
        if (!oldItemsMap.has(key)) {
            addedItems.push(item);
        }
        else {
            commonItemsInNewMap.set(key, commonItemsInNewMap.size);
        }
    });
    //calculating deletedItems and items that exist in both arrays
    oldItemsMap.forEach(function (item, key) {
        if (!newItemsMap.has(key)) {
            deletedItems.push(item);
        }
        else {
            commonItemsInOldMap.set(key, commonItemsInOldMap.size);
        }
    });
    //calculating reordered items
    var reorderedItems = [];
    commonItemsInNewMap.forEach(function (index, key) {
        var oldIndex = commonItemsInOldMap.get(key);
        var item = newItemsMap.get(key);
        if (oldIndex !== index)
            reorderedItems.push({ item: item, movedForward: oldIndex < index });
    });
    //calculating merged array if multiple operations are applied at once
    var oldItemsWithCorrectOrder = new Array(oldValue.length);
    var commonItemsIndex = 0;
    var commonItemsKeysOrder = Array.from(commonItemsInNewMap.keys());
    oldValue.forEach(function (item, index) {
        if (commonItemsInNewMap.has(getKey(item))) {
            oldItemsWithCorrectOrder[index] = newItemsMap.get(commonItemsKeysOrder[commonItemsIndex]);
            commonItemsIndex++;
        }
        else {
            oldItemsWithCorrectOrder[index] = item;
        }
    });
    var valuesToInsertBeforeKey = new Map();
    var tempValuesArray = [];
    oldItemsWithCorrectOrder.forEach(function (item) {
        var itemKey = getKey(item);
        if (newItemsMap.has(itemKey)) {
            if (tempValuesArray.length > 0) {
                valuesToInsertBeforeKey.set(itemKey, tempValuesArray);
                tempValuesArray = [];
            }
        }
        else {
            tempValuesArray.push(item);
        }
    });
    var mergedItems = new Array();
    newItemsMap.forEach(function (item, key) {
        if (valuesToInsertBeforeKey.has(key)) {
            valuesToInsertBeforeKey.get(key).forEach(function (item) {
                mergedItems.push(item);
            });
        }
        mergedItems.push(item);
    });
    tempValuesArray.forEach(function (item) {
        mergedItems.push(item);
    });
    return { reorderedItems: reorderedItems, deletedItems: deletedItems, addedItems: addedItems, mergedItems: mergedItems };
}
function getVerticalDimensions(el) {
    if (DomDocumentHelper.isAvailable()) {
        var _a = DomDocumentHelper.getComputedStyle(el), paddingTop = _a.paddingTop, paddingBottom = _a.paddingBottom, borderTopWidth = _a.borderTopWidth, borderBottomWidth = _a.borderBottomWidth, marginTop = _a.marginTop, marginBottom = _a.marginBottom, boxSizing = _a.boxSizing;
        var heightTo = el.offsetHeight + "px";
        if (boxSizing == "content-box") {
            var heightPx_1 = el.offsetHeight;
            [borderBottomWidth, borderTopWidth, paddingBottom, paddingTop].forEach(function (style) {
                heightPx_1 -= parseFloat(style);
            });
            heightTo = heightPx_1 + "px";
        }
        return {
            paddingTop: paddingTop,
            paddingBottom: paddingBottom,
            borderTopWidth: borderTopWidth,
            borderBottomWidth: borderBottomWidth,
            marginTop: marginTop,
            marginBottom: marginBottom,
            heightFrom: "0px",
            heightTo: heightTo
        };
    }
    else {
        return undefined;
    }
}
function setPropertiesOnElementForAnimation(el, styles, prefix) {
    var _a;
    if (prefix === void 0) { prefix = "--animation-"; }
    el["__sv_created_properties"] = (_a = el["__sv_created_properties"]) !== null && _a !== void 0 ? _a : [];
    Object.keys(styles).forEach(function (key) {
        var propertyName = "" + prefix + key.split(/\.?(?=[A-Z])/).join("-").toLowerCase();
        el.style.setProperty(propertyName, styles[key]);
        el["__sv_created_properties"].push(propertyName);
    });
}
function prepareElementForVerticalAnimation(el) {
    setPropertiesOnElementForAnimation(el, getVerticalDimensions(el));
}
function cleanHtmlElementAfterAnimation(el) {
    if (Array.isArray(el["__sv_created_properties"])) {
        el["__sv_created_properties"].forEach(function (propertyName) {
            el.style.removeProperty(propertyName);
        });
        delete el["__sv_created_properties"];
    }
}
function floorTo2Decimals(number) {
    return Math.floor(number * 100) / 100;
}


// CONCATENATED MODULE: ./packages/survey-core/src/settings.ts


var settings_document = typeof globalThis !== "undefined" ? globalThis.document : undefined.document;
var defaultEnvironment = (!!settings_document ? {
    root: settings_document,
    _rootElement: DomDocumentHelper.getBody(),
    get rootElement() {
        var _a;
        return (_a = this._rootElement) !== null && _a !== void 0 ? _a : DomDocumentHelper.getBody();
    },
    set rootElement(rootElement) {
        this._rootElement = rootElement;
    },
    _popupMountContainer: DomDocumentHelper.getBody(),
    get popupMountContainer() {
        var _a;
        return (_a = this._popupMountContainer) !== null && _a !== void 0 ? _a : DomDocumentHelper.getBody();
    },
    set popupMountContainer(popupMountContainer) {
        this._popupMountContainer = popupMountContainer;
    },
    svgMountContainer: settings_document.head,
    stylesSheetsMountContainer: settings_document.head,
} : undefined);
var columnWidthsByType = {
    "file": { minWidth: "240px" },
    "comment": { minWidth: "200px" }
};
/**
 * Global settings that apply to all surveys on the page. To specify one of the settings, use the code below:
 *
 * ```js
 * import { settings } from "survey-core";
 *
 * settings.settingName = "value";
 * ```
 */
var settings = {
    version: "",
    /**
     * An object that configures survey appearance when the survey is being designed in Survey Creator.
     *
     * Nested properties:
     *
     * - `showEmptyDescriptions`: `boolean`\
     * Specifies whether to display an empty description for pages and panels. Default value: `true`.
     *
     * - `showEmptyTitles`: `boolean`\
     * Specifies whether to display an empty title for pages and panels. Default value: `true`.
     */
    designMode: {
        showEmptyDescriptions: true,
        showEmptyTitles: true
    },
    //#region designMode section, Obsolete properties
    get allowShowEmptyDescriptionInDesignMode() { return this.designMode.showEmptyDescriptions; },
    set allowShowEmptyDescriptionInDesignMode(val) { this.designMode.showEmptyDescriptions = val; },
    get allowShowEmptyTitleInDesignMode() { return this.designMode.showEmptyTitles; },
    set allowShowEmptyTitleInDesignMode(val) { this.designMode.showEmptyTitles = val; },
    //#endregion
    /**
     * An object that contains properties related to localization.
     *
     * Nested properties:
     *
     * - `useLocalTimeZone`: `boolean`\
     * Disable this property if you want internal SurveyJS functions to use methods that work with UTC date and time (`setUTCDate()` `setUTCHours()`, etc.) instead of methods that work with local date and time (`setYear()`, `setHours()`, etc.). Default value: `true`.
     *
     * - `defaultLocaleName`: `string`\
     * A property key that stores a translation for the default locale. Default value: `"default"`.
     *
     * - `storeDuplicatedTranslations`: `boolean`\
     * Specifies whether surveys should store translation strings that equal the translation strings in the default locale. Default value: `false`.
     */
    localization: {
        useLocalTimeZone: true,
        storeDuplicatedTranslations: false,
        defaultLocaleName: "default"
    },
    //#region localization section, obsolete properties
    get useLocalTimeZone() { return this.localization.useLocalTimeZone; },
    set useLocalTimeZone(val) { this.localization.useLocalTimeZone = val; },
    get storeDuplicatedTranslations() { return this.localization.storeDuplicatedTranslations; },
    set storeDuplicatedTranslations(val) { this.localization.storeDuplicatedTranslations = val; },
    get defaultLocaleName() { return this.localization.defaultLocaleName; },
    set defaultLocaleName(val) { this.localization.defaultLocaleName = val; },
    //#endregion
    /**
     * An object with properties that configure surveys when they work with a web service.
     *
     * Nested properties:
     *
     * - `encodeUrlParams`: `boolean`\
     * Specifies whether to encode URL parameters when you access a web service. Default value: `true`.
     *
     * - `cacheLoadedChoices`: `boolean`\
     * Specifies whether to cache [choices loaded from a web service](https://surveyjs.io/form-library/documentation/api-reference/questionselectbase#choicesByUrl). Default value: `true`.
     *
     * - `disableQuestionWhileLoadingChoices`: `boolean`\
     * Disables a question while its choices are being loaded from a web service. Default value: `false`.
     *
     * - `surveyServiceUrl`: `string`\
     * The URL of the SurveyJS Service API endpoint.
     *
     * - `onBeforeRequestChoices`: `(sender: ChoicesRestful, options: { request: XMLHttpRequest })`\
     * An event that is raised before a request for choices is send. Applies to questions with a specified [`choiceByUrl`](https://surveyjs.io/form-library/documentation/api-reference/questionselectbase#choicesByUrl) property. Use the `options.request` parameter to access and modify the `XMLHttpRequest` object. For instance, you can add authentication headers to it:
     *
     *     ```js
     *     import { settings } from "survey-core";
     *
     *     settings.web.onBeforeSendRequest = (sender, options) => {
     *       options.request.setRequestHeader('RequestVerificationToken', requestVerificationToken);
     *     };
     *     ```
     */
    web: {
        onBeforeRequestChoices: function (sender, options) { },
        encodeUrlParams: true,
        cacheLoadedChoices: true,
        disableQuestionWhileLoadingChoices: false,
        surveyServiceUrl: "https://api.surveyjs.io/public/v1/Survey"
    },
    //#region web section, obsolete properties
    get webserviceEncodeParameters() { return this.web.encodeUrlParams; },
    set webserviceEncodeParameters(val) { this.web.encodeUrlParams = val; },
    get useCachingForChoicesRestful() { return this.web.cacheLoadedChoices; },
    set useCachingForChoicesRestful(val) { this.web.cacheLoadedChoices = val; },
    get useCachingForChoicesRestfull() { return this.web.cacheLoadedChoices; },
    set useCachingForChoicesRestfull(val) { this.web.cacheLoadedChoices = val; },
    get disableOnGettingChoicesFromWeb() { return this.web.disableQuestionWhileLoadingChoices; },
    set disableOnGettingChoicesFromWeb(val) { this.web.disableQuestionWhileLoadingChoices = val; },
    get surveyServiceUrl() { return this.web.surveyServiceUrl; },
    set surveyServiceUrl(val) { this.web.surveyServiceUrl = val; },
    //#endregion
    /**
     * An object that contains properties related to [triggers](https://surveyjs.io/form-library/documentation/design-survey/conditional-logic#conditional-survey-logic-triggers).
     *
     * Nested properties:
     *
     * - `changeNavigationButtonsOnComplete`: `boolean`\
     * Specifies whether to re-evaluate an expression associated with the [Complete trigger](https://surveyjs.io/form-library/documentation/design-survey/conditional-logic#complete) immediately when a question value changes. If the expression evaluates to `true`, the trigger is executed. Default value: `false`.\
     * Keep this property set to `false` if you want to re-evaluate the Complete trigger's expression only when the respondents navigate to another page.
     *
     * - `executeCompleteOnValueChanged`: `boolean`\
     * Specifies whether to replace the Next button with the Complete button when the [Complete trigger](https://surveyjs.io/form-library/documentation/design-survey/conditional-logic#complete) is going to be executed. Default value: `true`.
     *
     * - `executeSkipOnValueChanged`: `boolean`\
     * Specifies whether to re-evaluate an expression associated with the [Skip trigger](https://surveyjs.io/form-library/documentation/design-survey/conditional-logic#skip) immediately when a question value changes. If the expression evaluates to `true`, the trigger is executed. Default value: `true`.\
     * Disable this property if you want to re-evaluate the Skip trigger's expression only when respondents navigate to another page.
     */
    triggers: {
        changeNavigationButtonsOnComplete: true,
        executeCompleteOnValueChanged: false,
        executeSkipOnValueChanged: true
    },
    //#region triggers section, Obsolete properties
    get executeCompleteTriggerOnValueChanged() { return this.triggers.executeCompleteOnValueChanged; },
    set executeCompleteTriggerOnValueChanged(val) { this.triggers.executeCompleteOnValueChanged = val; },
    get changeNavigationButtonsOnCompleteTrigger() { return this.triggers.changeNavigationButtonsOnComplete; },
    set changeNavigationButtonsOnCompleteTrigger(val) { this.triggers.changeNavigationButtonsOnComplete = val; },
    get executeSkipTriggerOnValueChanged() { return this.triggers.executeSkipOnValueChanged; },
    set executeSkipTriggerOnValueChanged(val) { this.triggers.executeSkipOnValueChanged = val; },
    //#endregion
    /**
     * An object that contains properties related to JSON serialization.
     *
     * Nested properties:
     *
     * - `itemValueSerializeAsObject`: `boolean`\
     * Enable this property if you want to serialize [`ItemValue`](https://surveyjs.io/form-library/documentation/api-reference/itemvalue) instances (choice options, matrix rows, columns in a [Single-Select Matrix](https://surveyjs.io/form-library/documentation/api-reference/matrix-table-question-model)) as objects even when they include only the `value` property. Default value: `false`.
     *
     * - `itemValueSerializeDisplayText`: `boolean`\
     * Enable this property if you want to serialize the `text` property of [`ItemValue`](https://surveyjs.io/form-library/documentation/api-reference/itemvalue) objects even when it is empty or equal to the `value` property. Default value: `false`.
     *
     * - `localizableStringSerializeAsObject`: `boolean`\
     * Enable this property if you want to serialize [`LocalizableString`](https://surveyjs.io/form-library/documentation/api-reference/localizablestring) instances as objects even when they include only a translation string for the default locale. For example, `"Custom String"` will be serialized as `{ default: "Custom String" }`. Default value: `false`.
     *
     * - `matrixDropdownColumnSerializeTitle`: `boolean`\
     * Enable this property if you want to serialize the `title` property of [`MatrixDropdownColumn`](https://surveyjs.io/form-library/documentation/api-reference/multi-select-matrix-column-values) objects even when it is empty or equal to the `name` property. Default value: `false`.
     * @see [settings.parseNumber](https://surveyjs.io/form-library/documentation/api-reference/settings#parseNumber)
     */
    serialization: {
        itemValueSerializeAsObject: false,
        itemValueSerializeDisplayText: false,
        localizableStringSerializeAsObject: false,
        matrixDropdownColumnSerializeTitle: false
    },
    //#region serialization section, Obsolete properties
    get itemValueAlwaysSerializeAsObject() { return this.serialization.itemValueSerializeAsObject; },
    set itemValueAlwaysSerializeAsObject(val) { this.serialization.itemValueSerializeAsObject = val; },
    get itemValueAlwaysSerializeText() { return this.serialization.itemValueSerializeDisplayText; },
    set itemValueAlwaysSerializeText(val) { this.serialization.itemValueSerializeDisplayText = val; },
    get serializeLocalizableStringAsObject() { return this.serialization.localizableStringSerializeAsObject; },
    set serializeLocalizableStringAsObject(val) { this.serialization.localizableStringSerializeAsObject = val; },
    //#endregion
    /**
     * An object that configures lazy rendering.
     *
     * Nested properties:
     *
     * - `enabled`: `boolean`\
     * Specifies whether to add questions to the DOM only when they get into the viewport. Default value: `false`.
     *
     * [View Demo](https://surveyjs.io/form-library/examples/survey-lazy/ (linkStyle))
     * @see [SurveyModel.lazyRendering](https://surveyjs.io/form-library/documentation/api-reference/survey-data-model#lazyRendering)
     */
    lazyRender: {
        enabled: false,
        firstBatchSize: 3
    },
    //#region lazyRender section, Obsolete properties
    get lazyRowsRendering() { return this.lazyRender.enabled; },
    set lazyRowsRendering(val) { this.lazyRender.enabled = val; },
    get lazyRowsRenderingStartRow() { return this.lazyRender.firstBatchSize; },
    set lazyRowsRenderingStartRow(val) { this.lazyRender.firstBatchSize = val; },
    //#endregion
    /**
     * An object with properties that apply to [Single-Choice](https://surveyjs.io/form-library/documentation/api-reference/matrix-table-question-model), [Multiple-Choice](https://surveyjs.io/form-library/documentation/api-reference/matrix-table-with-dropdown-list), and [Dynamic Matrix](https://surveyjs.io/form-library/documentation/api-reference/dynamic-matrix-table-question-model) questions.
     *
     * Nested properties:
     *
     * - `defaultRowName`: `string`\
     * A property key that stores an object with default cell values. Default value: "default".
     *
     * - `defaultCellType`: `string`\
     * The default type of matrix cells. Default value: `"dropdown"`.\
     * You can specify this setting for individual questions or matrix columns: [`cellType`](https://surveyjs.io/form-library/documentation/api-reference/dynamic-matrix-table-question-model#cellType). Refer to the `cellType` property description for information on possible values.
     *
     * - `totalsSuffix`: `string`\
     * A suffix added to the name of the property that stores total values. The resulting property name consists of the matrix name and the suffix. Default value: `"-total"`.
     *
     * - `maxRowCount`: `number`\
     * A maximum number of rows in a Dynamic Matrix. Default value: 1000.\
     * You can specify this setting for an individual Dynamic Matrix: [`maxRowCount`](https://surveyjs.io/form-library/documentation/api-reference/dynamic-matrix-table-question-model#maxRowCount).
     *
     * - `maxRowCountInCondition`: `number`\
     * A maximum number of matrix rows included in the Condition drop-down menu in Survey Creator. This menu is used to configure conditional survey logic. Default value: 1.\
     * If you set this property to 0, the Condition menu does not include any matrix rows. Users still can specify conditions that use matrix rows but only with Manual Entry.
     *
     * - `renderRemoveAsIcon`: `boolean`\
     * Disable this property if you want to render the Remove action in Dynamic Matrix as a button. Otherwise, the action is rendered as an icon. Default value: `true`.
     *
     * - `columnWidthsByType`: `object`\
     * An object that specifies fixed and minimum column width based on the column type.\
     * Example: `settings.matrix.columnWidthsByType = { "tagbox": { minWidth: "240px", width: "300px" } }`
     *
     * - `rateSize`: `"small"` (default) | `"normal"`\
     * Specifies the size of rate values. Applies to [Rating Scale](https://surveyjs.io/form-library/examples/rating-scale/) questions within matrixes.
     */
    matrix: {
        defaultCellType: "dropdown",
        defaultRowName: "default",
        totalsSuffix: "-total",
        maxRowCount: 1000,
        maxRowCountInCondition: 1,
        renderRemoveAsIcon: true,
        columnWidthsByType: columnWidthsByType,
        rateSize: "small",
    },
    //#region matrix section, Obsolete properties
    get matrixDefaultRowName() { return this.matrix.defaultRowName; },
    set matrixDefaultRowName(val) { this.matrix.defaultRowName = val; },
    get matrixDefaultCellType() { return this.matrix.defaultCellType; },
    set matrixDefaultCellType(val) { this.matrix.defaultCellType = val; },
    get matrixTotalValuePostFix() { return this.matrix.totalsSuffix; },
    set matrixTotalValuePostFix(val) { this.matrix.totalsSuffix = val; },
    get matrixMaximumRowCount() { return this.matrix.maxRowCount; },
    set matrixMaximumRowCount(val) { this.matrix.maxRowCount = val; },
    get matrixMaxRowCountInCondition() { return this.matrix.maxRowCountInCondition; },
    set matrixMaxRowCountInCondition(val) { this.matrix.maxRowCountInCondition = val; },
    get matrixRenderRemoveAsIcon() { return this.matrix.renderRemoveAsIcon; },
    set matrixRenderRemoveAsIcon(val) { this.matrix.renderRemoveAsIcon = val; },
    //#endregion
    /**
     * An object with properties that apply to [Dynamic Panel](https://surveyjs.io/form-library/documentation/api-reference/dynamic-panel-model) questions.
     *
     * Nested properties:
     *
     * - `maxPanelCount`: `number`\
     * A maximum number of panels in Dynamic Panel. Default value: 100.\
     * You can specify this setting for an individual Dynamic Panel: [`maxPanelCount`](https://surveyjs.io/form-library/documentation/api-reference/dynamic-panel-model#maxPanelCount).
     *
     * - `maxPanelCountInCondition`: `number`\
     * A maximum number of Dynamic Panel panels included in the Condition drop-down menu in Survey Creator. This menu is used to configure conditional survey logic. Default value: 1.\
     * If you set this property to 0, the Condition menu does not include any panel questions. Users still can specify conditions that use panel questions but only with Manual Entry.
     */
    panel: {
        maxPanelCount: 100,
        maxPanelCountInCondition: 1
    },
    //#region panel section, Obsolete properties
    get panelDynamicMaxPanelCountInCondition() { return this.panel.maxPanelCountInCondition; },
    set panelDynamicMaxPanelCountInCondition(val) { this.panel.maxPanelCountInCondition = val; },
    get panelMaximumPanelCount() { return this.panel.maxPanelCount; },
    set panelMaximumPanelCount(val) { this.panel.maxPanelCount = val; },
    //#endregion
    /**
     * An object with properties that configure questions in read-only mode.
     *
     * Nested properties:
     *
     * - `commentRenderMode`: `"textarea"` (default) | `"div"`\
     * Specifies how to render the input field of [Comment](https://surveyjs.io/form-library/documentation/api-reference/comment-field-model) questions in [read-only](https://surveyjs.io/form-library/documentation/api-reference/comment-field-model#readOnly) mode: as a disabled `<textarea>` element or as a `<div>` element with a non-editable question value within it.
     *
     * - `textRenderMode`: `"input"` (default) | `"div"`\
     * Specifies how to render the input field of [Text](https://surveyjs.io/form-library/documentation/api-reference/text-entry-question-model) questions in [read-only](https://surveyjs.io/form-library/documentation/api-reference/text-entry-question-model#readOnly) mode: as a disabled `<input>` element or as a `<div>` element with a non-editable question value within it.
     */
    readOnly: {
        enableValidation: false,
        commentRenderMode: "textarea",
        textRenderMode: "input"
    },
    //#region readOnly section, Obsolete properties
    get readOnlyCommentRenderMode() { return this.readOnly.commentRenderMode; },
    set readOnlyCommentRenderMode(val) { this.readOnly.commentRenderMode = val; },
    get readOnlyTextRenderMode() { return this.readOnly.textRenderMode; },
    set readOnlyTextRenderMode(val) { this.readOnly.textRenderMode = val; },
    //#endregion
    /**
     * An object with properties that configure question numbering.
     *
     * Nested properties:
     *
     * - `includeQuestionsWithHiddenNumber`: `boolean`\
     * Specifies whether to number questions whose [`hideNumber`](https://surveyjs.io/form-library/documentation/api-reference/question#hideNumber) property is enabled. Default value: `false`.
     *
     * - `includeQuestionsWithHiddenTitle`: `boolean`\
     * Specifies whether to number questions whose [`titleLocation`](https://surveyjs.io/form-library/documentation/api-reference/question#titleLocation) property is set to `"hidden"`. Default value: `false`.
     */
    numbering: {
        includeQuestionsWithHiddenNumber: false,
        includeQuestionsWithHiddenTitle: false
    },
    //#region numbering section, Obsolete properties
    get setQuestionVisibleIndexForHiddenTitle() { return this.numbering.includeQuestionsWithHiddenTitle; },
    set setQuestionVisibleIndexForHiddenTitle(val) { this.numbering.includeQuestionsWithHiddenTitle = val; },
    get setQuestionVisibleIndexForHiddenNumber() { return this.numbering.includeQuestionsWithHiddenNumber; },
    set setQuestionVisibleIndexForHiddenNumber(val) { this.numbering.includeQuestionsWithHiddenNumber = val; },
    //#endregion
    /**
     * Specifies an action to perform when users press the Enter key within a survey.
     *
     * Possible values:
     *
     * - `"moveToNextEditor"` - Moves focus to the next editor.
     * - `"loseFocus"` - Removes focus from the current editor.
     * - `"default"` - Behaves as a standard `<input>` element.
     */
    enterKeyAction: "default",
    /**
     * An object that configures string comparison.
     *
     * Nested properties:
     *
     * - `trimStrings`: `boolean`\
     * Specifies whether to remove whitespace from both ends of a string before the comparison. Default value: `true`.
     *
     * - `caseSensitive`: `boolean`\
     * Specifies whether to differentiate between capital and lower-case letters. Default value: `false`.
     */
    comparator: {
        trimStrings: true,
        caseSensitive: false,
        normalizeTextCallback: function (str, reason) { return str; }
    },
    expressionDisableConversionChar: "#",
    get commentPrefix() { return settings.commentSuffix; },
    set commentPrefix(val) { settings.commentSuffix = val; },
    /**
     * A suffix added to the name of the property that stores comments.
     *
     * Default value: "-Comment"
     *
     * You can specify this setting for an individual survey: [`commentSuffix`](https://surveyjs.io/form-library/documentation/api-reference/survey-data-model#commentSuffix).
     */
    commentSuffix: "-Comment",
    /**
     * A separator used in a shorthand notation that specifies a value and display text for an [`ItemValue`](https://surveyjs.io/form-library/documentation/api-reference/itemvalue) object: `"value|text"`.
     *
     * Default value: `"|"`
     * @see [settings.choicesSeparator](https://surveyjs.io/form-library/documentation/api-reference/settings#choicesSeparator)
     */
    itemValueSeparator: "|",
    /**
     * A maximum number of rate values in a [Rating](https://surveyjs.io/form-library/documentation/api-reference/rating-scale-question-model) question.
     *
     * Default value: 20
     */
    ratingMaximumRateValueCount: 20,
    /**
     * Specifies whether to close the drop-down menu of a [Multi-Select Dropdown (Tag Box)](https://surveyjs.io/form-library/examples/how-to-create-multiselect-tag-box/) question after a user selects a value.
     *
     * This setting applies to all Multi-Select Dropdown questions on a web page. You can use the [`closeOnSelect`](https://surveyjs.io/form-library/documentation/api-reference/dropdown-tag-box-model#closeOnSelect) property to specify the same setting for an individual Multi-Select Dropdown question.
     */
    tagboxCloseOnSelect: false,
    /**
     * A time interval in milliseconds between the last entered character and the beginning of search in [Single-](https://surveyjs.io/form-library/examples/create-dropdown-menu-in-javascript/) and [Multi-Select Dropdown](https://surveyjs.io/form-library/examples/how-to-create-multiselect-tag-box/) questions. Applies only to questions with the [`choicesLazyLoadEnabled`](https://surveyjs.io/form-library/documentation/api-reference/dropdown-menu-model#choicesLazyLoadEnabled) property set to `true`.
     *
     * Default value: 500
     *
     * [View Demo](https://surveyjs.io/form-library/examples/lazy-loading-dropdown/ (linkStyle))
     */
    dropdownSearchDelay: 500,
    /**
     * A function that activates a browser confirm dialog.
     *
     * Use the following code to execute this function:
     *
     * ```js
     * import { settings } from "survey-core";
     *
     * // `result` contains `true` if the action was confirmed or `false` otherwise
     * const result = settings.confirmActionFunc("Are you sure?");
     * ```
     *
     * You can redefine the `confirmActionFunc` function if you want to display a custom dialog window. Your function should return `true` if a user confirms an action or `false` otherwise.
     * @param message A message to be displayed in the confirm dialog window.
     */
    confirmActionFunc: function (message) {
        return confirm(message);
    },
    /**
     * A function that activates a proprietary SurveyJS confirm dialog.
     *
     * Use the following code to execute this function:
     *
     * ```js
     * import { settings } from "survey-core";
     *
     * settings.confirmActionAsync("Are you sure?", (confirmed) => {
     *   if (confirmed) {
     *     // ...
     *     // Proceed with the action
     *     // ...
     *   } else {
     *     // ...
     *     // Cancel the action
     *     // ...
     *   }
     * });
     * ```
     *
     * You can redefine the `confirmActionAsync` function if you want to display a custom dialog window. Your function should return `true` to be enabled; otherwise, a survey executes the [`confirmActionFunc`](#confirmActionFunc) function. Pass the dialog result as the `callback` parameter: `true` if a user confirms an action, `false` otherwise.
     * @param message A message to be displayed in the confirm dialog window.
     * @param callback A callback function that should be called with `true` if a user confirms an action or `false` otherwise.
     */
    confirmActionAsync: function (message, callback, options) {
        return showConfirmDialog(message, callback, options);
    },
    /**
     * A minimum width value for all survey elements.
     *
     * Default value: `"300px"`
     *
     * You can override this setting for individual elements: [`minWidth`](https://surveyjs.io/form-library/documentation/api-reference/surveyelement#minWidth).
     */
    minWidth: "300px",
    /**
     * A maximum width value for all survey elements.
     *
     * Default value: `"100%"`
     *
     * You can override this setting for individual elements: [`maxWidth`](https://surveyjs.io/form-library/documentation/api-reference/surveyelement#maxWidth).
     */
    maxWidth: "100%",
    /**
     * Specifies how many times surveys can re-evaluate expressions when a question value changes. This limit helps avoid recursions in expressions.
     *
     * Default value: 10
     */
    maxConditionRunCountOnValueChanged: 10,
    /**
     * An object that configures notifications.
     *
     * Nested properties:
     *
     * - `lifetime`: `number`\
     * Specifies a time period during which a notification is displayed; measured in milliseconds. Default value: 2000.
     */
    notifications: {
        lifetime: 2000
    },
    /**
     * Specifies how many milliseconds a survey should wait before it automatically switches to the next page. Applies only when [auto-advance](https://surveyjs.io/form-library/documentation/api-reference/survey-data-model#goNextPageAutomatic) is enabled.
     *
     * Default value: 300
     */
    autoAdvanceDelay: 300,
    /**
     * Specifies the direction in which to lay out Checkbox and Radiogroup items. This setting affects the resulting UI when items are arranged in [more than one column](https://surveyjs.io/form-library/documentation/api-reference/checkbox-question-model#colCount).
     *
     * Possible values:
     *
     * - `"row"` (default) - Items fill the current row, then move on to the next row.
     * - `"column"` - Items fill the current column, then move on to the next column.
     */
    showItemsInOrder: "default",
    /**
     * A value to save in survey results when respondents select the "None" choice item.
     *
     * Default value: `"none"`
     */
    noneItemValue: "none",
    /**
     * A value to save in survey results when respondents select the "Refuse to answer" choice item.
     *
     * Default value: `"refused"`
     */
    refuseItemValue: "refused",
    /**
     * A value to save in survey results when respondents select the "Don't know" choice item.
     *
     * Default value: `"dontknow"`
     */
    dontKnowItemValue: "dontknow",
    /**
     * An object whose properties specify the order of the special choice items ("None", "Other", "Select All", "Refuse to answer", "Don't know") in select-based questions.
     *
     * Default value: `{ selectAllItem: [-1], noneItem: [1], otherItem: [2], dontKnowItem: [3], otherItem: [4] }`
     *
     * Use this object to reorder special choices. Each property accepts an array of integer numbers. Negative numbers place a special choice item above regular choice items, positive numbers place it below them. For instance, the code below specifies the following order of choices: None, Select All, regular choices, Other.
     *
     * ```js
     * import { settings } from "survey-core";
     *
     * settings.specialChoicesOrder.noneItem = [-2];
     * settings.specialChoicesOrder.selectAllItem = [-1];
     * settings.specialChoicesOrder.otherItem = [1];
     * ```
     *
     * If you want to duplicate a special choice item above and below other choices, add two numbers to the corresponding array:
     *
     * ```js
     * settings.specialChoicesOrder.selectAllItem = [-1, 3] // Displays Select All above and below other choices
     * ```
     */
    specialChoicesOrder: {
        selectAllItem: [-1],
        noneItem: [1],
        refuseItem: [2],
        dontKnowItem: [3],
        otherItem: [4]
    },
    /**
     * One or several characters used to separate choice options in a list.
     *
     * Default value: `", "`
     * @see [settings.itemValueSeparator](https://surveyjs.io/form-library/documentation/api-reference/settings#itemValueSeparator)
     */
    choicesSeparator: ", ",
    /**
     * A list of supported validators by question type.
     */
    supportedValidators: {
        question: ["expression"],
        comment: ["text", "regex"],
        text: ["numeric", "text", "regex", "email"],
        checkbox: ["answercount"],
        imagepicker: ["answercount"],
    },
    /**
     * Specifies a minimum date that users can enter into a [Text](https://surveyjs.io/form-library/documentation/api-reference/text-entry-question-model) question with [`inputType`](https://surveyjs.io/form-library/documentation/api-reference/text-entry-question-model#inputType) set to `"date"` or `"datetime-local"`. Set this property to a string with the folllowing format: `"yyyy-mm-dd"`.
     */
    minDate: "",
    /**
     * Specifies a maximum date that users can enter into a [Text](https://surveyjs.io/form-library/documentation/api-reference/text-entry-question-model) question with [`inputType`](https://surveyjs.io/form-library/documentation/api-reference/text-entry-question-model#inputType) set to `"date"` or `"datetime-local"`. Set this property to a string with the folllowing format: `"yyyy-mm-dd"`.
     */
    maxDate: "",
    showModal: undefined,
    showDialog: undefined,
    supportCreatorV2: false,
    showDefaultItemsInCreatorV2: true,
    /**
     * An object that specifies icon replacements. Object keys are built-in icon names. To use a custom icon, assign its name to the key of the icon you want to replace:
     *
     * ```js
     * import { settings } from "survey-core";
     *
     * settings.customIcons["icon-redo"] = "custom-redo-icon";
     * ```
     *
     * For more information about icons in SurveyJS, refer to the following help topic: [UI Icons](https://surveyjs.io/form-library/documentation/icons).
     */
    customIcons: {},
    /**
     * Specifies which part of a choice item responds to a drag gesture in Ranking questions.
     *
     * Possible values:
     *
     * - `"entireItem"` (default) - Users can use the entire choice item as a drag handle.
     * - `"icon"` - Users can only use the choice item icon as a drag handle.
     */
    rankingDragHandleArea: "entireItem",
    environment: defaultEnvironment,
    /**
     * Allows you to hide the maximum length indicator in text input questions.
     *
     * If you specify a question's [`maxLength`](https://surveyjs.io/form-library/documentation/api-reference/text-entry-question-model#maxLength) property or a survey's [`maxTextLength`](https://surveyjs.io/form-library/documentation/api-reference/survey-data-model#maxTextLength) property, text input questions indicate the number of entered characters and the character limit. Assign `false` to the `settings.showMaxLengthIndicator` property if you want to hide this indicator.
     *
     * Default value: `true`
     */
    showMaxLengthIndicator: true,
    /**
     * Specifies whether to animate survey elements.
     *
     * Default value: `true`
    */
    animationEnabled: true,
    /**
     * An object that specifies heading levels (`<h1>`, `<h2>`, etc.) to use when rendering survey, page, panel, and question titles.
     *
     * Default value: `{ survey: "h3", page: "h4", panel: "h4", question: "h5" }`
     *
     * If you want to modify heading levels for individual titles, handle `SurveyModel`'s [`onGetTitleTagName`](https://surveyjs.io/form-library/documentation/api-reference/survey-data-model#onGetTitleTagName) event.
     */
    titleTags: {
        survey: "h3",
        page: "h4",
        panel: "h4",
        question: "h5",
    },
    questions: {
        inputTypes: [
            "color",
            "date",
            "datetime-local",
            "email",
            "month",
            "number",
            "password",
            "range",
            "tel",
            "text",
            "time",
            "url",
            "week",
        ],
        dataList: [
            "",
            "name",
            "honorific-prefix",
            "given-name",
            "additional-name",
            "family-name",
            "honorific-suffix",
            "nickname",
            "organization-title",
            "username",
            "new-password",
            "current-password",
            "organization",
            "street-address",
            "address-line1",
            "address-line2",
            "address-line3",
            "address-level4",
            "address-level3",
            "address-level2",
            "address-level1",
            "country",
            "country-name",
            "postal-code",
            "cc-name",
            "cc-given-name",
            "cc-additional-name",
            "cc-family-name",
            "cc-number",
            "cc-exp",
            "cc-exp-month",
            "cc-exp-year",
            "cc-csc",
            "cc-type",
            "transaction-currency",
            "transaction-amount",
            "language",
            "bday",
            "bday-day",
            "bday-month",
            "bday-year",
            "sex",
            "url",
            "photo",
            "tel",
            "tel-country-code",
            "tel-national",
            "tel-area-code",
            "tel-local",
            "tel-local-prefix",
            "tel-local-suffix",
            "tel-extension",
            "email",
            "impp",
        ]
    },
    legacyProgressBarView: false,
    /**
     * An object with properties that configure input masks.
     *
     * Nested properties:
     *
     * - `patternPlaceholderChar`: `string`\
     * A symbol used as a placeholder for characters to be entered in [pattern masks](https://surveyjs.io/form-library/documentation/api-reference/inputmaskpattern). Default value: `"_"`.
     *
     * - `patternEscapeChar`: `string`\
     * A symbol used to insert literal representations of special characters in [pattern masks](https://surveyjs.io/form-library/documentation/api-reference/inputmaskpattern). Default value: `"\\"`.
     *
     * - `patternDefinitions`: `<{ [key: string]: RegExp }>`\
     * An object that maps placeholder symbols to regular expressions in [pattern masks](https://surveyjs.io/form-library/documentation/api-reference/inputmaskpattern). Default value: `{ "9": /[0-9]/, "a": /[a-zA-Z]/, "#": /[a-zA-Z0-9]/ }`.
     */
    maskSettings: {
        patternPlaceholderChar: "_",
        patternEscapeChar: "\\",
        patternDefinitions: {
            "9": /[0-9]/,
            "a": /[a-zA-Z]/,
            "#": /[a-zA-Z0-9]/
        }
    },
    /**
     * Specifies whether to store date-time values in the following format: `"YYYY-MM-DDThh:mm:ss.sssZ"`. Applies only to form fields with [`inputType`](https://surveyjs.io/form-library/documentation/api-reference/text-entry-question-model#inputType) set to `"datetime-local"`.
     *
     * Default value: `false`
     *
     * If you enable this setting, date-time values are converted from local time to UTC when they are saved to the survey's [`data`](https://surveyjs.io/form-library/documentation/api-reference/survey-data-model#data) object, while the question values remain in local time. Therefore, when you specify default values using a question's [`defaultValue`](https://surveyjs.io/form-library/documentation/api-reference/text-entry-question-model#defaultValue) property, you need to use local time, but if you specify them using the `data` object, use a UTC date-time value in the following format: `"YYYY-MM-DDThh:mm:ss.sssZ"`.
     *
     * ```js
     * const surveyJson = {
     *   "elements": [{
     *     "name": "datetime",
     *     "type": "text",
     *     "title": "Select a date and time",
     *     "inputType": "datetime-local",
     *     "defaultValue": "2024-07-16T12:15:00" // Local date-time value
     *   }]
     * }
     * ```
     *
     * ```js
     * import { Model } from "survey-core";
     * const surveyJson = { ... }
     * const survey = new Model(surveyJson);
     *
     * survey.data = {
     *   datetime: "2024-07-16T12:15:00.000Z" // UTC date-time value
     * }
     * ```
     */
    storeUtcDates: false,
    // @param reason "function-[functionname]", "question-[questionname]", "expression-operand"
    onDateCreated: function (newDate, reason, val) {
        return newDate;
    },
    /**
     * A function that allows you to define custom parsing rules for numbers represented as string values.
     *
     * The following code shows a template that you can use to implement the `parseNumber` function:
     *
     * ```js
     * import { settings } from "survey-core";
     *
     * settings.parseNumber = (stringValue, numericValue) => {
     *   if (typeof stringValue !== "string" || !stringValue)
     *     return numericValue;
     *   let parsedNumber = numericValue;
     *   // ...
     *   // Parsing the number according to custom parsing rules
     *   // ...
     *   return parsedNumber;
     * };
     * ```
     * @param stringValue A number represented as a string value.
     * @param numericValue A number parsed using a default parsing function. `NaN` if the original string is not a number.
     * @returns A number that results from parsing the string value.
     * @see [settings.serialization](https://surveyjs.io/form-library/documentation/api-reference/settings#serialization)
     */
    parseNumber: function (stringValue, numericValue) { return numericValue; },
};

// CONCATENATED MODULE: ./packages/survey-core/src/survey-error.ts


var survey_error_SurveyError = /** @class */ (function () {
    function SurveyError(text, errorOwner) {
        if (text === void 0) { text = null; }
        if (errorOwner === void 0) { errorOwner = null; }
        this.text = text;
        this.errorOwner = errorOwner;
        this.visible = true;
        this.onUpdateErrorTextCallback = undefined;
    }
    SurveyError.prototype.equals = function (error) {
        if (!error || !error.getErrorType)
            return false;
        if (this.getErrorType() !== error.getErrorType())
            return false;
        return this.text === error.text && this.visible === error.visible;
    };
    Object.defineProperty(SurveyError.prototype, "locText", {
        get: function () {
            if (!this.locTextValue) {
                this.locTextValue = new localizablestring_LocalizableString(this.errorOwner, true);
                this.locTextValue.storeDefaultText = true;
                this.locTextValue.text = this.getText();
            }
            return this.locTextValue;
        },
        enumerable: false,
        configurable: true
    });
    SurveyError.prototype.getText = function () {
        var res = this.text;
        if (!res)
            res = this.getDefaultText();
        if (!!this.errorOwner) {
            res = this.errorOwner.getErrorCustomText(res, this);
        }
        return res;
    };
    SurveyError.prototype.getErrorType = function () {
        return "base";
    };
    SurveyError.prototype.getDefaultText = function () {
        return "";
    };
    SurveyError.prototype.getLocale = function () {
        return !!this.errorOwner ? this.errorOwner.getLocale() : "";
    };
    SurveyError.prototype.getLocalizationString = function (locStrName) {
        return getLocaleString(locStrName, this.getLocale());
    };
    SurveyError.prototype.updateText = function () {
        if (this.onUpdateErrorTextCallback) {
            this.onUpdateErrorTextCallback(this);
        }
        this.locText.text = this.getText();
    };
    return SurveyError;
}());


// CONCATENATED MODULE: ./packages/survey-core/src/error.ts
var error_extends = (undefined && undefined.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();


var AnswerRequiredError = /** @class */ (function (_super) {
    error_extends(AnswerRequiredError, _super);
    function AnswerRequiredError(text, errorOwner) {
        if (text === void 0) { text = null; }
        if (errorOwner === void 0) { errorOwner = null; }
        var _this = _super.call(this, text, errorOwner) || this;
        _this.text = text;
        return _this;
    }
    AnswerRequiredError.prototype.getErrorType = function () {
        return "required";
    };
    AnswerRequiredError.prototype.getDefaultText = function () {
        return this.getLocalizationString("requiredError");
    };
    return AnswerRequiredError;
}(survey_error_SurveyError));

var OneAnswerRequiredError = /** @class */ (function (_super) {
    error_extends(OneAnswerRequiredError, _super);
    function OneAnswerRequiredError(text, errorOwner) {
        if (text === void 0) { text = null; }
        if (errorOwner === void 0) { errorOwner = null; }
        var _this = _super.call(this, text, errorOwner) || this;
        _this.text = text;
        return _this;
    }
    OneAnswerRequiredError.prototype.getErrorType = function () {
        return "requireoneanswer";
    };
    OneAnswerRequiredError.prototype.getDefaultText = function () {
        return this.getLocalizationString("requiredErrorInPanel");
    };
    return OneAnswerRequiredError;
}(survey_error_SurveyError));

var RequreNumericError = /** @class */ (function (_super) {
    error_extends(RequreNumericError, _super);
    function RequreNumericError(text, errorOwner) {
        if (text === void 0) { text = null; }
        if (errorOwner === void 0) { errorOwner = null; }
        var _this = _super.call(this, text, errorOwner) || this;
        _this.text = text;
        return _this;
    }
    RequreNumericError.prototype.getErrorType = function () {
        return "requirenumeric";
    };
    RequreNumericError.prototype.getDefaultText = function () {
        return this.getLocalizationString("numericError");
    };
    return RequreNumericError;
}(survey_error_SurveyError));

var error_ExceedSizeError = /** @class */ (function (_super) {
    error_extends(ExceedSizeError, _super);
    function ExceedSizeError(maxSize, errorOwner) {
        if (errorOwner === void 0) { errorOwner = null; }
        var _this = _super.call(this, null, errorOwner) || this;
        _this.maxSize = maxSize;
        _this.locText.text = _this.getText();
        return _this;
    }
    ExceedSizeError.prototype.getErrorType = function () {
        return "exceedsize";
    };
    ExceedSizeError.prototype.getDefaultText = function () {
        return getLocaleString("exceedMaxSize")["format"](this.getTextSize());
    };
    ExceedSizeError.prototype.getTextSize = function () {
        var sizes = ["Bytes", "KB", "MB", "GB", "TB"];
        var fixed = [0, 0, 2, 3, 3];
        if (this.maxSize === 0) {
            return "0 Byte";
        }
        var i = Math.floor(Math.log(this.maxSize) / Math.log(1024));
        var value = this.maxSize / Math.pow(1024, i);
        return value.toFixed(fixed[i]) + " " + sizes[i];
    };
    return ExceedSizeError;
}(survey_error_SurveyError));

var WebRequestError = /** @class */ (function (_super) {
    error_extends(WebRequestError, _super);
    function WebRequestError(status, response, errorOwner) {
        if (errorOwner === void 0) { errorOwner = null; }
        var _this = _super.call(this, null, errorOwner) || this;
        _this.status = status;
        _this.response = response;
        return _this;
    }
    WebRequestError.prototype.getErrorType = function () {
        return "webrequest";
    };
    WebRequestError.prototype.getDefaultText = function () {
        var str = this.getLocalizationString("urlRequestError");
        return !!str ? str["format"](this.status, this.response) : "";
    };
    return WebRequestError;
}(survey_error_SurveyError));

var WebRequestEmptyError = /** @class */ (function (_super) {
    error_extends(WebRequestEmptyError, _super);
    function WebRequestEmptyError(text, errorOwner) {
        if (errorOwner === void 0) { errorOwner = null; }
        var _this = _super.call(this, text, errorOwner) || this;
        _this.text = text;
        return _this;
    }
    WebRequestEmptyError.prototype.getErrorType = function () {
        return "webrequestempty";
    };
    WebRequestEmptyError.prototype.getDefaultText = function () {
        return this.getLocalizationString("urlGetChoicesError");
    };
    return WebRequestEmptyError;
}(survey_error_SurveyError));

var OtherEmptyError = /** @class */ (function (_super) {
    error_extends(OtherEmptyError, _super);
    function OtherEmptyError(text, errorOwner) {
        if (errorOwner === void 0) { errorOwner = null; }
        var _this = _super.call(this, text, errorOwner) || this;
        _this.text = text;
        return _this;
    }
    OtherEmptyError.prototype.getErrorType = function () {
        return "otherempty";
    };
    OtherEmptyError.prototype.getDefaultText = function () {
        return this.getLocalizationString("otherRequiredError");
    };
    return OtherEmptyError;
}(survey_error_SurveyError));

var UploadingFileError = /** @class */ (function (_super) {
    error_extends(UploadingFileError, _super);
    function UploadingFileError(text, errorOwner) {
        if (errorOwner === void 0) { errorOwner = null; }
        var _this = _super.call(this, text, errorOwner) || this;
        _this.text = text;
        return _this;
    }
    UploadingFileError.prototype.getErrorType = function () {
        return "uploadingfile";
    };
    UploadingFileError.prototype.getDefaultText = function () {
        return this.getLocalizationString("uploadingFile");
    };
    return UploadingFileError;
}(survey_error_SurveyError));

var RequiredInAllRowsError = /** @class */ (function (_super) {
    error_extends(RequiredInAllRowsError, _super);
    function RequiredInAllRowsError(text, errorOwner) {
        if (errorOwner === void 0) { errorOwner = null; }
        var _this = _super.call(this, text, errorOwner) || this;
        _this.text = text;
        return _this;
    }
    RequiredInAllRowsError.prototype.getErrorType = function () {
        return "requiredinallrowserror";
    };
    RequiredInAllRowsError.prototype.getDefaultText = function () {
        return this.getLocalizationString("requiredInAllRowsError");
    };
    return RequiredInAllRowsError;
}(survey_error_SurveyError));

var EachRowUniqueError = /** @class */ (function (_super) {
    error_extends(EachRowUniqueError, _super);
    function EachRowUniqueError(text, errorOwner) {
        if (errorOwner === void 0) { errorOwner = null; }
        var _this = _super.call(this, text, errorOwner) || this;
        _this.text = text;
        return _this;
    }
    EachRowUniqueError.prototype.getErrorType = function () {
        return "eachrowuniqueeerror";
    };
    EachRowUniqueError.prototype.getDefaultText = function () {
        return this.getLocalizationString("eachRowUniqueError");
    };
    return EachRowUniqueError;
}(survey_error_SurveyError));

var error_MinRowCountError = /** @class */ (function (_super) {
    error_extends(MinRowCountError, _super);
    function MinRowCountError(minRowCount, errorOwner) {
        if (errorOwner === void 0) { errorOwner = null; }
        var _this = _super.call(this, null, errorOwner) || this;
        _this.minRowCount = minRowCount;
        return _this;
    }
    MinRowCountError.prototype.getErrorType = function () {
        return "minrowcounterror";
    };
    MinRowCountError.prototype.getDefaultText = function () {
        return getLocaleString("minRowCountError")["format"](this.minRowCount);
    };
    return MinRowCountError;
}(survey_error_SurveyError));

var KeyDuplicationError = /** @class */ (function (_super) {
    error_extends(KeyDuplicationError, _super);
    function KeyDuplicationError(text, errorOwner) {
        if (errorOwner === void 0) { errorOwner = null; }
        var _this = _super.call(this, text, errorOwner) || this;
        _this.text = text;
        return _this;
    }
    KeyDuplicationError.prototype.getErrorType = function () {
        return "keyduplicationerror";
    };
    KeyDuplicationError.prototype.getDefaultText = function () {
        return this.getLocalizationString("keyDuplicationError");
    };
    return KeyDuplicationError;
}(survey_error_SurveyError));

var CustomError = /** @class */ (function (_super) {
    error_extends(CustomError, _super);
    function CustomError(text, errorOwner) {
        if (errorOwner === void 0) { errorOwner = null; }
        var _this = _super.call(this, text, errorOwner) || this;
        _this.text = text;
        return _this;
    }
    CustomError.prototype.getErrorType = function () {
        return "custom";
    };
    return CustomError;
}(survey_error_SurveyError));


// CONCATENATED MODULE: ./packages/survey-core/src/validator.ts
var validator_extends = (undefined && undefined.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();





var ValidatorResult = /** @class */ (function () {
    function ValidatorResult(value, error) {
        if (error === void 0) { error = null; }
        this.value = value;
        this.error = error;
    }
    return ValidatorResult;
}());

/**
 * A base class for all classes that implement validators.
 *
 * [View Demo](https://surveyjs.io/form-library/examples/javascript-form-validation/ (linkStyle))
 */
var validator_SurveyValidator = /** @class */ (function (_super) {
    validator_extends(SurveyValidator, _super);
    function SurveyValidator() {
        var _this = _super.call(this) || this;
        _this.createLocalizableString("text", _this, true);
        return _this;
    }
    Object.defineProperty(SurveyValidator.prototype, "isValidator", {
        get: function () { return true; },
        enumerable: false,
        configurable: true
    });
    SurveyValidator.prototype.getSurvey = function (live) {
        if (live === void 0) { live = false; }
        return !!this.errorOwner && !!this.errorOwner["getSurvey"]
            ? this.errorOwner.getSurvey()
            : null;
    };
    Object.defineProperty(SurveyValidator.prototype, "text", {
        /**
         * An error message to display when a value fails validation.
         */
        get: function () {
            return this.getLocalizableStringText("text");
        },
        set: function (value) {
            this.setLocalizableStringText("text", value);
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(SurveyValidator.prototype, "isValidateAllValues", {
        get: function () {
            return false;
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(SurveyValidator.prototype, "locText", {
        get: function () {
            return this.getLocalizableString("text");
        },
        enumerable: false,
        configurable: true
    });
    SurveyValidator.prototype.getErrorText = function (name) {
        if (this.text)
            return this.text;
        return this.getDefaultErrorText(name);
    };
    SurveyValidator.prototype.getDefaultErrorText = function (name) {
        return "";
    };
    SurveyValidator.prototype.validate = function (value, name, values, properties) {
        if (name === void 0) { name = null; }
        if (values === void 0) { values = null; }
        if (properties === void 0) { properties = null; }
        return null;
    };
    Object.defineProperty(SurveyValidator.prototype, "isRunning", {
        get: function () {
            return false;
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(SurveyValidator.prototype, "isAsync", {
        get: function () {
            return false;
        },
        enumerable: false,
        configurable: true
    });
    SurveyValidator.prototype.getLocale = function () {
        return !!this.errorOwner ? this.errorOwner.getLocale() : "";
    };
    SurveyValidator.prototype.getMarkdownHtml = function (text, name) {
        return !!this.errorOwner
            ? this.errorOwner.getMarkdownHtml(text, name)
            : undefined;
    };
    SurveyValidator.prototype.getRenderer = function (name) {
        return !!this.errorOwner ? this.errorOwner.getRenderer(name) : null;
    };
    SurveyValidator.prototype.getRendererContext = function (locStr) {
        return !!this.errorOwner ? this.errorOwner.getRendererContext(locStr) : locStr;
    };
    SurveyValidator.prototype.getProcessedText = function (text) {
        return !!this.errorOwner ? this.errorOwner.getProcessedText(text) : text;
    };
    SurveyValidator.prototype.createCustomError = function (name) {
        var _this = this;
        var err = new CustomError(this.getErrorText(name), this.errorOwner);
        err.onUpdateErrorTextCallback = (function (err) { return err.text = _this.getErrorText(name); });
        return err;
    };
    SurveyValidator.prototype.toString = function () {
        var res = this.getType().replace("validator", "");
        if (!!this.text) {
            res += ", " + this.text;
        }
        return res;
    };
    return SurveyValidator;
}(base_Base));

var ValidatorRunner = /** @class */ (function () {
    function ValidatorRunner() {
    }
    ValidatorRunner.prototype.run = function (owner) {
        var _this = this;
        var res = [];
        var values = null;
        var properties = null;
        this.prepareAsyncValidators();
        var asyncResults = [];
        var validators = owner.getValidators();
        for (var i = 0; i < validators.length; i++) {
            var validator = validators[i];
            if (!values && validator.isValidateAllValues) {
                values = owner.getDataFilteredValues();
                properties = owner.getDataFilteredProperties();
            }
            if (validator.isAsync) {
                this.asyncValidators.push(validator);
                validator.onAsyncCompleted = function (result) {
                    if (!!result && !!result.error)
                        asyncResults.push(result.error);
                    if (!_this.onAsyncCompleted)
                        return;
                    for (var i = 0; i < _this.asyncValidators.length; i++) {
                        if (_this.asyncValidators[i].isRunning)
                            return;
                    }
                    _this.onAsyncCompleted(asyncResults);
                };
            }
        }
        validators = owner.getValidators();
        for (var i = 0; i < validators.length; i++) {
            var validator = validators[i];
            var validatorResult = validator.validate(owner.validatedValue, owner.getValidatorTitle(), values, properties);
            if (!!validatorResult && !!validatorResult.error) {
                res.push(validatorResult.error);
            }
        }
        if (this.asyncValidators.length == 0 && !!this.onAsyncCompleted)
            this.onAsyncCompleted([]);
        return res;
    };
    ValidatorRunner.prototype.prepareAsyncValidators = function () {
        if (!!this.asyncValidators) {
            for (var i = 0; i < this.asyncValidators.length; i++) {
                this.asyncValidators[i].onAsyncCompleted = null;
            }
        }
        this.asyncValidators = [];
    };
    return ValidatorRunner;
}());

/**
 * A class that implements a validator for numeric values.
 *
 * [View Demo](https://surveyjs.io/form-library/examples/javascript-form-validation/ (linkStyle))
 */
var validator_NumericValidator = /** @class */ (function (_super) {
    validator_extends(NumericValidator, _super);
    function NumericValidator(minValue, maxValue) {
        if (minValue === void 0) { minValue = null; }
        if (maxValue === void 0) { maxValue = null; }
        var _this = _super.call(this) || this;
        _this.minValue = minValue;
        _this.maxValue = maxValue;
        return _this;
    }
    NumericValidator.prototype.getType = function () {
        return "numericvalidator";
    };
    NumericValidator.prototype.validate = function (value, name, values, properties) {
        if (name === void 0) { name = null; }
        if (values === void 0) { values = null; }
        if (properties === void 0) { properties = null; }
        if (this.isValueEmpty(value))
            return null;
        if (!helpers_Helpers.isNumber(value)) {
            return new ValidatorResult(null, new RequreNumericError(this.text, this.errorOwner));
        }
        var result = new ValidatorResult(helpers_Helpers.getNumber(value));
        if (this.minValue !== null && this.minValue > result.value) {
            result.error = this.createCustomError(name);
            return result;
        }
        if (this.maxValue !== null && this.maxValue < result.value) {
            result.error = this.createCustomError(name);
            return result;
        }
        return typeof value === "number" ? null : result;
    };
    NumericValidator.prototype.getDefaultErrorText = function (name) {
        var vName = name ? name : this.getLocalizationString("value");
        if (this.minValue !== null && this.maxValue !== null) {
            return this.getLocalizationFormatString("numericMinMax", vName, this.minValue, this.maxValue);
        }
        else {
            if (this.minValue !== null) {
                return this.getLocalizationFormatString("numericMin", vName, this.minValue);
            }
            return this.getLocalizationFormatString("numericMax", vName, this.maxValue);
        }
    };
    Object.defineProperty(NumericValidator.prototype, "minValue", {
        /**
         * A minimum allowed numeric value.
         *
         * [View Demo](https://surveyjs.io/form-library/examples/javascript-form-validation/ (linkStyle))
         */
        get: function () {
            return this.getPropertyValue("minValue");
        },
        set: function (val) {
            this.setPropertyValue("minValue", val);
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(NumericValidator.prototype, "maxValue", {
        /**
         * A maximum allowed numeric value.
         *
         * [View Demo](https://surveyjs.io/form-library/examples/javascript-form-validation/ (linkStyle))
         */
        get: function () {
            return this.getPropertyValue("maxValue");
        },
        set: function (val) {
            this.setPropertyValue("maxValue", val);
        },
        enumerable: false,
        configurable: true
    });
    return NumericValidator;
}(validator_SurveyValidator));

/**
 * A class that implements a validator for text values.
 *
 * [View Demo](https://surveyjs.io/form-library/examples/javascript-form-validation/ (linkStyle))
 */
var TextValidator = /** @class */ (function (_super) {
    validator_extends(TextValidator, _super);
    function TextValidator() {
        return _super.call(this) || this;
    }
    TextValidator.prototype.getType = function () {
        return "textvalidator";
    };
    TextValidator.prototype.validate = function (value, name, values, properties) {
        if (name === void 0) { name = null; }
        if (values === void 0) { values = null; }
        if (properties === void 0) { properties = null; }
        if (this.isValueEmpty(value))
            return null;
        if (!this.allowDigits) {
            var reg = /\d+$/;
            if (reg.test(value)) {
                return new ValidatorResult(null, this.createCustomError("textNoDigitsAllow"));
            }
        }
        if (this.minLength > 0 && value.length < this.minLength) {
            return new ValidatorResult(null, this.createCustomError(name));
        }
        if (this.maxLength > 0 && value.length > this.maxLength) {
            return new ValidatorResult(null, this.createCustomError(name));
        }
        return null;
    };
    TextValidator.prototype.getDefaultErrorText = function (name) {
        if (name === "textNoDigitsAllow")
            return this.getLocalizationString(name);
        if (this.minLength > 0 && this.maxLength > 0)
            return this.getLocalizationFormatString("textMinMaxLength", this.minLength, this.maxLength);
        if (this.minLength > 0)
            return this.getLocalizationFormatString("textMinLength", this.minLength);
        return this.getLocalizationFormatString("textMaxLength", this.maxLength);
    };
    Object.defineProperty(TextValidator.prototype, "minLength", {
        /**
         * The minimum length of a text value measured in characters.
         *
         * Default value: 0
         *
         * [View Demo](https://surveyjs.io/form-library/examples/javascript-form-validation/ (linkStyle))
         */
        get: function () {
            return this.getPropertyValue("minLength");
        },
        set: function (val) {
            this.setPropertyValue("minLength", val);
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(TextValidator.prototype, "maxLength", {
        /**
         * The maximum length of a text value measured in characters.
         *
         * Default value: 0 (unlimited)
         *
         * [View Demo](https://surveyjs.io/form-library/examples/javascript-form-validation/ (linkStyle))
         */
        get: function () {
            return this.getPropertyValue("maxLength");
        },
        set: function (val) {
            this.setPropertyValue("maxLength", val);
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(TextValidator.prototype, "allowDigits", {
        /**
         * Specifies whether a text value can include numerical digits.
         *
         * Default value: `true`
         */
        get: function () {
            return this.getPropertyValue("allowDigits");
        },
        set: function (val) {
            this.setPropertyValue("allowDigits", val);
        },
        enumerable: false,
        configurable: true
    });
    return TextValidator;
}(validator_SurveyValidator));

/**
 * A class that implements answer count validation in the question types that can have multiple values (for instance, [Checkboxes](https://surveyjs.io/form-library/documentation/api-reference/checkbox-question-model)).
 *
 * [View Demo](https://surveyjs.io/form-library/examples/javascript-form-validation/ (linkStyle))
 */
var AnswerCountValidator = /** @class */ (function (_super) {
    validator_extends(AnswerCountValidator, _super);
    function AnswerCountValidator(minCount, maxCount) {
        if (minCount === void 0) { minCount = null; }
        if (maxCount === void 0) { maxCount = null; }
        var _this = _super.call(this) || this;
        _this.minCount = minCount;
        _this.maxCount = maxCount;
        return _this;
    }
    AnswerCountValidator.prototype.getType = function () {
        return "answercountvalidator";
    };
    AnswerCountValidator.prototype.validate = function (value, name, values, properties) {
        if (name === void 0) { name = null; }
        if (values === void 0) { values = null; }
        if (properties === void 0) { properties = null; }
        if (value == null || value.constructor != Array)
            return null;
        var count = value.length;
        if (count == 0)
            return null;
        if (this.minCount && count < this.minCount) {
            return new ValidatorResult(null, this.createCustomError(this.getLocalizationFormatString("minSelectError", this.minCount)));
        }
        if (this.maxCount && count > this.maxCount) {
            return new ValidatorResult(null, this.createCustomError(this.getLocalizationFormatString("maxSelectError", this.maxCount)));
        }
        return null;
    };
    AnswerCountValidator.prototype.getDefaultErrorText = function (name) {
        return name;
    };
    Object.defineProperty(AnswerCountValidator.prototype, "minCount", {
        /**
         * A minimum number of selected answers.
         *
         * [View Demo](https://surveyjs.io/form-library/examples/javascript-form-validation/ (linkStyle))
         */
        get: function () {
            return this.getPropertyValue("minCount");
        },
        set: function (val) {
            this.setPropertyValue("minCount", val);
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(AnswerCountValidator.prototype, "maxCount", {
        /**
         * A maximum number of selected answers.
         *
         * [View Demo](https://surveyjs.io/form-library/examples/javascript-form-validation/ (linkStyle))
         */
        get: function () {
            return this.getPropertyValue("maxCount");
        },
        set: function (val) {
            this.setPropertyValue("maxCount", val);
        },
        enumerable: false,
        configurable: true
    });
    return AnswerCountValidator;
}(validator_SurveyValidator));

/**
 * A class that implements validation using regular expressions.
 *
 * [View Demo](https://surveyjs.io/form-library/examples/javascript-form-validation/ (linkStyle))
 */
var RegexValidator = /** @class */ (function (_super) {
    validator_extends(RegexValidator, _super);
    function RegexValidator(regex) {
        if (regex === void 0) { regex = null; }
        var _this = _super.call(this) || this;
        _this.regex = regex;
        return _this;
    }
    RegexValidator.prototype.getType = function () {
        return "regexvalidator";
    };
    RegexValidator.prototype.validate = function (value, name, values, properties) {
        if (name === void 0) { name = null; }
        if (values === void 0) { values = null; }
        if (properties === void 0) { properties = null; }
        if (!this.regex || this.isValueEmpty(value))
            return null;
        var re = this.createRegExp();
        if (Array.isArray(value)) {
            for (var i = 0; i < value.length; i++) {
                var res = this.hasError(re, value[i], name);
                if (res)
                    return res;
            }
        }
        return this.hasError(re, value, name);
    };
    RegexValidator.prototype.hasError = function (re, value, name) {
        if (re.test(value))
            return null;
        return new ValidatorResult(value, this.createCustomError(name));
    };
    Object.defineProperty(RegexValidator.prototype, "regex", {
        /**
         * A regular expression used to validate values.
         *
         * [View Demo](https://surveyjs.io/form-library/examples/javascript-form-validation/ (linkStyle))
         */
        get: function () {
            return this.getPropertyValue("regex");
        },
        set: function (val) {
            this.setPropertyValue("regex", val);
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(RegexValidator.prototype, "caseInsensitive", {
        /**
         * Specifies whether uppercase and lowercase letters must be treated as distinct or equivalent when validating values.
         *
         * Default value: `false` (uppercase and lowercase letters are treated as distinct)
         */
        get: function () {
            return this.getPropertyValue("caseInsensitive");
        },
        set: function (val) {
            this.setPropertyValue("caseInsensitive", val);
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(RegexValidator.prototype, "insensitive", {
        get: function () { return this.caseInsensitive; },
        set: function (val) {
            this.caseInsensitive = val;
        },
        enumerable: false,
        configurable: true
    });
    RegexValidator.prototype.createRegExp = function () {
        return new RegExp(this.regex, this.caseInsensitive ? "i" : "");
    };
    return RegexValidator;
}(validator_SurveyValidator));

/**
 * A class that implements a validator for e-mail addresses.
 *
 * [View Demo](https://surveyjs.io/form-library/examples/javascript-form-validation/ (linkStyle))
 */
var EmailValidator = /** @class */ (function (_super) {
    validator_extends(EmailValidator, _super);
    function EmailValidator() {
        var _this = _super.call(this) || this;
        _this.re = /^(([^<>()\[\]\.,;:\s@\"]+(\.[^<>()\[\]\.,;:\s@\"]+)*)|(\".+\"))@(([^<>()=[\]\.,;:\s@\"]+\.)+[^<>()=[\]\.,;:\s@\"]{2,})$/i;
        return _this;
    }
    EmailValidator.prototype.getType = function () {
        return "emailvalidator";
    };
    EmailValidator.prototype.validate = function (value, name, values, properties) {
        if (name === void 0) { name = null; }
        if (values === void 0) { values = null; }
        if (properties === void 0) { properties = null; }
        if (!value)
            return null;
        if (this.re.test(value))
            return null;
        return new ValidatorResult(value, this.createCustomError(name));
    };
    EmailValidator.prototype.getDefaultErrorText = function (name) {
        return this.getLocalizationString("invalidEmail");
    };
    return EmailValidator;
}(validator_SurveyValidator));

/**
 * A class that implements validation using [expressions](https://surveyjs.io/form-library/documentation/design-survey/conditional-logic#expressions).
 *
 * [View Demo](https://surveyjs.io/form-library/examples/javascript-form-validation/ (linkStyle))
 */
var validator_ExpressionValidator = /** @class */ (function (_super) {
    validator_extends(ExpressionValidator, _super);
    function ExpressionValidator(expression) {
        if (expression === void 0) { expression = null; }
        var _this = _super.call(this) || this;
        _this.conditionRunner = null;
        _this.isRunningValue = false;
        _this.expression = expression;
        return _this;
    }
    ExpressionValidator.prototype.getType = function () {
        return "expressionvalidator";
    };
    Object.defineProperty(ExpressionValidator.prototype, "isValidateAllValues", {
        get: function () {
            return true;
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(ExpressionValidator.prototype, "isAsync", {
        get: function () {
            if (!this.ensureConditionRunner(false))
                return false;
            return this.conditionRunner.isAsync;
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(ExpressionValidator.prototype, "isRunning", {
        get: function () {
            return this.isRunningValue;
        },
        enumerable: false,
        configurable: true
    });
    ExpressionValidator.prototype.validate = function (value, name, values, properties) {
        var _this = this;
        if (name === void 0) { name = null; }
        if (values === void 0) { values = null; }
        if (properties === void 0) { properties = null; }
        if (!this.expression)
            return null;
        if (!!this.conditionRunner) {
            this.conditionRunner.onRunComplete = null;
        }
        this.ensureConditionRunner(true);
        this.conditionRunner.onRunComplete = function (res) {
            _this.isRunningValue = false;
            if (!!_this.onAsyncCompleted) {
                _this.onAsyncCompleted(_this.generateError(res, value, name));
            }
        };
        this.isRunningValue = true;
        var res = this.conditionRunner.run(values, properties);
        if (this.conditionRunner.isAsync)
            return null;
        this.isRunningValue = false;
        return this.generateError(res, value, name);
    };
    ExpressionValidator.prototype.generateError = function (res, value, name) {
        if (!res) {
            return new ValidatorResult(value, this.createCustomError(name));
        }
        return null;
    };
    ExpressionValidator.prototype.getDefaultErrorText = function (name) {
        return this.getLocalizationFormatString("invalidExpression", this.expression);
    };
    ExpressionValidator.prototype.ensureConditionRunner = function (reNew) {
        if (!this.expression)
            return false;
        if (reNew || !this.conditionRunner) {
            this.conditionRunner = new ConditionRunner(this.expression);
        }
        else {
            this.conditionRunner.expression = this.expression;
        }
        return true;
    };
    Object.defineProperty(ExpressionValidator.prototype, "expression", {
        /**
         * A Boolean [expression](https://surveyjs.io/form-library/documentation/design-survey/conditional-logic#expressions). If it evaluates to `false`, validation fails.
         *
         * [View Demo](https://surveyjs.io/form-library/examples/javascript-form-validation/ (linkStyle))
         */
        get: function () {
            return this.getPropertyValue("expression");
        },
        set: function (val) {
            this.setPropertyValue("expression", val);
        },
        enumerable: false,
        configurable: true
    });
    return ExpressionValidator;
}(validator_SurveyValidator));

Serializer.addClass("surveyvalidator", [
    { name: "text", serializationProperty: "locText" },
]);
Serializer.addClass("numericvalidator", ["minValue:number", "maxValue:number"], function () {
    return new validator_NumericValidator();
}, "surveyvalidator");
Serializer.addClass("textvalidator", [{ name: "minLength:number", default: 0 },
    { name: "maxLength:number", default: 0 },
    { name: "allowDigits:boolean", default: true }], function () {
    return new TextValidator();
}, "surveyvalidator");
Serializer.addClass("answercountvalidator", ["minCount:number", "maxCount:number"], function () {
    return new AnswerCountValidator();
}, "surveyvalidator");
Serializer.addClass("regexvalidator", ["regex", { name: "caseInsensitive:boolean", alternativeName: "insensitive" }], function () {
    return new RegexValidator();
}, "surveyvalidator");
Serializer.addClass("emailvalidator", [], function () {
    return new EmailValidator();
}, "surveyvalidator");
Serializer.addClass("expressionvalidator", ["expression:condition"], function () {
    return new validator_ExpressionValidator();
}, "surveyvalidator");

// CONCATENATED MODULE: ./packages/survey-core/src/questionCustomWidgets.ts

var QuestionCustomWidget = /** @class */ (function () {
    function QuestionCustomWidget(name, widgetJson) {
        this.name = name;
        this.widgetJson = widgetJson;
        this.htmlTemplate = widgetJson.htmlTemplate ? widgetJson.htmlTemplate : "";
    }
    QuestionCustomWidget.prototype.afterRender = function (question, el) {
        var _this = this;
        if (!this.widgetJson.afterRender)
            return;
        question.localeChangedCallback = function () {
            if (_this.widgetJson.willUnmount) {
                _this.widgetJson.willUnmount(question, el);
            }
            _this.widgetJson.afterRender(question, el);
        };
        this.widgetJson.afterRender(question, el);
    };
    QuestionCustomWidget.prototype.willUnmount = function (question, el) {
        if (this.widgetJson.willUnmount)
            this.widgetJson.willUnmount(question, el);
    };
    QuestionCustomWidget.prototype.getDisplayValue = function (question, value) {
        if (value === void 0) { value = undefined; }
        if (this.widgetJson.getDisplayValue)
            return this.widgetJson.getDisplayValue(question, value);
        return null;
    };
    QuestionCustomWidget.prototype.validate = function (question) {
        if (this.widgetJson.validate)
            return this.widgetJson.validate(question);
        return undefined;
    };
    QuestionCustomWidget.prototype.isFit = function (question) {
        if (this.isLibraryLoaded() && this.widgetJson.isFit)
            return this.widgetJson.isFit(question);
        return false;
    };
    Object.defineProperty(QuestionCustomWidget.prototype, "canShowInToolbox", {
        get: function () {
            if (this.widgetJson.showInToolbox === false)
                return false;
            if (questionCustomWidgets_CustomWidgetCollection.Instance.getActivatedBy(this.name) != "customtype")
                return false;
            return !this.widgetJson.widgetIsLoaded || this.widgetJson.widgetIsLoaded();
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(QuestionCustomWidget.prototype, "showInToolbox", {
        get: function () {
            return this.widgetJson.showInToolbox !== false;
        },
        set: function (val) {
            this.widgetJson.showInToolbox = val;
        },
        enumerable: false,
        configurable: true
    });
    QuestionCustomWidget.prototype.init = function () {
        if (this.widgetJson.init) {
            this.widgetJson.init();
        }
    };
    QuestionCustomWidget.prototype.activatedByChanged = function (activatedBy) {
        if (this.isLibraryLoaded() && this.widgetJson.activatedByChanged) {
            this.widgetJson.activatedByChanged(activatedBy);
        }
    };
    QuestionCustomWidget.prototype.isLibraryLoaded = function () {
        if (this.widgetJson.widgetIsLoaded)
            return this.widgetJson.widgetIsLoaded() == true;
        return true;
    };
    Object.defineProperty(QuestionCustomWidget.prototype, "isDefaultRender", {
        get: function () {
            return this.widgetJson.isDefaultRender;
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(QuestionCustomWidget.prototype, "pdfQuestionType", {
        get: function () {
            return this.widgetJson.pdfQuestionType;
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(QuestionCustomWidget.prototype, "pdfRender", {
        get: function () {
            return this.widgetJson.pdfRender;
        },
        enumerable: false,
        configurable: true
    });
    return QuestionCustomWidget;
}());

var questionCustomWidgets_CustomWidgetCollection = /** @class */ (function () {
    function CustomWidgetCollection() {
        this.widgetsValues = [];
        this.widgetsActivatedBy = {};
        this.onCustomWidgetAdded = new Event();
    }
    Object.defineProperty(CustomWidgetCollection.prototype, "widgets", {
        get: function () {
            return this.widgetsValues;
        },
        enumerable: false,
        configurable: true
    });
    CustomWidgetCollection.prototype.add = function (widgetJson, activatedBy) {
        if (activatedBy === void 0) { activatedBy = "property"; }
        this.addCustomWidget(widgetJson, activatedBy);
    };
    CustomWidgetCollection.prototype.addCustomWidget = function (widgetJson, activatedBy) {
        if (activatedBy === void 0) { activatedBy = "property"; }
        var name = widgetJson.name;
        if (!name) {
            name = "widget_" + this.widgets.length + 1;
        }
        var customWidget = new QuestionCustomWidget(name, widgetJson);
        this.widgetsValues.push(customWidget);
        customWidget.init();
        this.widgetsActivatedBy[name] = activatedBy;
        customWidget.activatedByChanged(activatedBy);
        this.onCustomWidgetAdded.fire(customWidget, null);
        return customWidget;
    };
    /**
     * Returns the way the custom wiget is activated. It can be activated by a property ("property"), question type ("type") or by new/custom question type ("customtype").
     * @param widgetName the custom widget name
     * @see setActivatedBy
     */
    CustomWidgetCollection.prototype.getActivatedBy = function (widgetName) {
        var res = this.widgetsActivatedBy[widgetName];
        return res ? res : "property";
    };
    /**
     * Sets the way the custom wiget is activated. The activation types are: property ("property"), question type ("type") or new/custom question type ("customtype"). A custom wiget may support all or only some of this activation types.
     * @param widgetName
     * @param activatedBy there are three possible variants: "property", "type" and "customtype"
     */
    CustomWidgetCollection.prototype.setActivatedBy = function (widgetName, activatedBy) {
        if (!widgetName || !activatedBy)
            return;
        var widget = this.getCustomWidgetByName(widgetName);
        if (!widget)
            return;
        this.widgetsActivatedBy[widgetName] = activatedBy;
        widget.activatedByChanged(activatedBy);
    };
    CustomWidgetCollection.prototype.clear = function () {
        this.widgetsValues = [];
    };
    CustomWidgetCollection.prototype.getCustomWidgetByName = function (name) {
        for (var i = 0; i < this.widgets.length; i++) {
            if (this.widgets[i].name == name)
                return this.widgets[i];
        }
        return null;
    };
    CustomWidgetCollection.prototype.getCustomWidget = function (question) {
        for (var i = 0; i < this.widgetsValues.length; i++) {
            if (this.widgetsValues[i].isFit(question))
                return this.widgetsValues[i];
        }
        return null;
    };
    CustomWidgetCollection.Instance = new CustomWidgetCollection();
    return CustomWidgetCollection;
}());


// CONCATENATED MODULE: ./packages/survey-core/src/rendererFactory.ts
var RendererFactory = /** @class */ (function () {
    function RendererFactory() {
        this.renderersHash = {};
        this.defaultHash = {};
    }
    RendererFactory.prototype.unregisterRenderer = function (questionType, rendererAs) {
        delete this.renderersHash[questionType][rendererAs];
        if (this.defaultHash[questionType] === rendererAs) {
            delete this.defaultHash[questionType];
        }
    };
    RendererFactory.prototype.registerRenderer = function (questionType, renderAs, renderer, useAsDefault) {
        if (useAsDefault === void 0) { useAsDefault = false; }
        if (!this.renderersHash[questionType]) {
            this.renderersHash[questionType] = {};
        }
        this.renderersHash[questionType][renderAs] = renderer;
        if (useAsDefault) {
            this.defaultHash[questionType] = renderAs;
        }
    };
    RendererFactory.prototype.getRenderer = function (questionType, renderAs) {
        var qHash = this.renderersHash[questionType];
        if (!!qHash) {
            if (!!renderAs && qHash[renderAs])
                return qHash[renderAs];
            var dVal = this.defaultHash[questionType];
            if (!!dVal && qHash[dVal])
                return qHash[dVal];
        }
        return "default";
    };
    RendererFactory.prototype.getRendererByQuestion = function (question) {
        return this.getRenderer(question.getType(), question.renderAs);
    };
    RendererFactory.prototype.clear = function () {
        this.renderersHash = {};
    };
    RendererFactory.Instance = new RendererFactory();
    return RendererFactory;
}());


// CONCATENATED MODULE: ./packages/survey-core/src/utils/text-area.ts

var text_area_TextAreaModel = /** @class */ (function () {
    function TextAreaModel(options) {
        var _this = this;
        this.options = options;
        this.onPropertyChangedCallback = function () {
            if (_this.element) {
                _this.element.value = _this.getTextValue();
                _this.updateElement();
            }
        };
        this.question.registerFunctionOnPropertyValueChanged(this.options.propertyName, this.onPropertyChangedCallback, "__textarea");
    }
    TextAreaModel.prototype.updateElement = function () {
        var _this = this;
        if (this.element && this.autoGrow) {
            setTimeout(function () { return increaseHeightByContent(_this.element); }, 1);
        }
    };
    TextAreaModel.prototype.setElement = function (element) {
        if (!!element) {
            this.element = element;
            this.updateElement();
        }
    };
    TextAreaModel.prototype.resetElement = function () {
        this.element = undefined;
    };
    TextAreaModel.prototype.getTextValue = function () {
        if (!!this.options.getTextValue)
            return this.options.getTextValue() || "";
        return "";
    };
    TextAreaModel.prototype.onTextAreaChange = function (event) {
        if (!!this.options.onTextAreaChange)
            this.options.onTextAreaChange(event);
    };
    TextAreaModel.prototype.onTextAreaInput = function (event) {
        if (!!this.options.onTextAreaInput)
            this.options.onTextAreaInput(event);
        if (this.element && this.autoGrow) {
            increaseHeightByContent(this.element);
        }
    };
    TextAreaModel.prototype.onTextAreaKeyDown = function (event) {
        if (!!this.options.onTextAreaKeyDown)
            this.options.onTextAreaKeyDown(event);
    };
    TextAreaModel.prototype.onTextAreaBlur = function (event) {
        this.onTextAreaChange(event);
        if (!!this.options.onTextAreaBlur)
            this.options.onTextAreaBlur(event);
    };
    TextAreaModel.prototype.onTextAreaFocus = function (event) {
        if (!!this.options.onTextAreaFocus)
            this.options.onTextAreaFocus(event);
    };
    Object.defineProperty(TextAreaModel.prototype, "question", {
        get: function () {
            return this.options.question;
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(TextAreaModel.prototype, "id", {
        get: function () {
            return this.options.id();
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(TextAreaModel.prototype, "placeholder", {
        get: function () {
            return this.options.placeholder();
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(TextAreaModel.prototype, "className", {
        get: function () {
            return this.options.className();
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(TextAreaModel.prototype, "maxLength", {
        get: function () {
            if (this.options.maxLength)
                return this.options.maxLength();
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(TextAreaModel.prototype, "autoGrow", {
        get: function () {
            if (this.options.autoGrow)
                return this.options.autoGrow();
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(TextAreaModel.prototype, "rows", {
        get: function () {
            if (this.options.rows)
                return this.options.rows();
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(TextAreaModel.prototype, "cols", {
        get: function () {
            if (this.options.cols)
                return this.options.cols();
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(TextAreaModel.prototype, "isDisabledAttr", {
        get: function () {
            return this.options.isDisabledAttr();
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(TextAreaModel.prototype, "isReadOnlyAttr", {
        get: function () {
            if (this.options.isReadOnlyAttr)
                return this.options.isReadOnlyAttr();
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(TextAreaModel.prototype, "ariaRequired", {
        get: function () {
            if (this.options.ariaRequired)
                return this.options.ariaRequired();
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(TextAreaModel.prototype, "ariaLabel", {
        get: function () {
            if (this.options.ariaLabel)
                return this.options.ariaLabel();
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(TextAreaModel.prototype, "ariaInvalid", {
        get: function () {
            if (this.options.ariaInvalid)
                return this.options.ariaInvalid();
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(TextAreaModel.prototype, "ariaLabelledBy", {
        get: function () {
            if (this.options.ariaLabelledBy)
                return this.options.ariaLabelledBy();
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(TextAreaModel.prototype, "ariaDescribedBy", {
        get: function () {
            if (this.options.ariaDescribedBy)
                return this.options.ariaDescribedBy();
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(TextAreaModel.prototype, "ariaErrormessage", {
        get: function () {
            if (this.options.ariaErrormessage)
                return this.options.ariaErrormessage();
        },
        enumerable: false,
        configurable: true
    });
    TextAreaModel.prototype.dispose = function () {
        if (this.question) {
            this.question.unRegisterFunctionOnPropertyValueChanged(this.options.propertyName, "__textarea");
        }
        this.resetElement();
    };
    return TextAreaModel;
}());


// CONCATENATED MODULE: ./packages/survey-core/src/question.ts
var question_extends = (undefined && undefined.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var question_decorate = (undefined && undefined.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
















var TriggerExpressionInfo = /** @class */ (function () {
    function TriggerExpressionInfo(name, canRun, doComplete) {
        this.name = name;
        this.canRun = canRun;
        this.doComplete = doComplete;
        this.runSecondCheck = function (keys) { return false; };
    }
    return TriggerExpressionInfo;
}());
/**
 * A base class for all questions.
 */
var question_Question = /** @class */ (function (_super) {
    question_extends(Question, _super);
    function Question(name) {
        var _this = _super.call(this, name) || this;
        _this.customWidgetData = { isNeedRender: true };
        _this.hasCssErrorCallback = function () { return false; };
        _this.isReadyValue = true;
        _this.dependedQuestions = [];
        /**
         * An event that is raised when the question's ready state has changed (expressions are evaluated, choices are loaded from a web resource specified by the `choicesByUrl` property, etc.).
         *
         * Parameters:
         *
         * - `sender`: `SurveyModel`\
         * A survey instance that contains the question whose ready state has changed.
         * - `options.isReady`: `boolean`\
         * Indicates whether the question is ready.
         * - `options.oldIsReady`: `boolean`\
         * Indicates the previous ready state.
         */
        _this.onReadyChanged = _this.addEvent();
        _this.triggersInfo = [];
        _this.isRunningValidatorsValue = false;
        _this.isValueChangedInSurvey = false;
        _this.allowNotifyValueChanged = true;
        _this.id = Question.getQuestionId();
        _this.onCreating();
        _this.createNewArray("validators", function (validator) {
            validator.errorOwner = _this;
        });
        _this.addExpressionProperty("visibleIf", function (obj, res) { _this.visible = res === true; });
        _this.addExpressionProperty("enableIf", function (obj, res) { _this.readOnly = res === false; });
        _this.addExpressionProperty("requiredIf", function (obj, res) { _this.isRequired = res === true; });
        _this.createLocalizableString("commentText", _this, true, "otherItemText");
        _this.createLocalizableString("requiredErrorText", _this);
        _this.addTriggerInfo("resetValueIf", function () { return !_this.isEmpty(); }, function () {
            _this.startSetValueOnExpression();
            _this.clearValue();
            _this.updateValueWithDefaults();
            _this.finishSetValueOnExpression();
        });
        var setValueIfInfo = _this.addTriggerInfo("setValueIf", function () { return true; }, function () { return _this.runSetValueExpression(); });
        setValueIfInfo.runSecondCheck = function (keys) { return _this.checkExpressionIf(keys); };
        _this.registerPropertyChangedHandlers(["width"], function () {
            _this.updateQuestionCss();
            if (!!_this.parent) {
                _this.parent.elementWidthChanged(_this);
            }
        });
        _this.registerPropertyChangedHandlers(["isRequired"], function () {
            if (!_this.isRequired && _this.errors.length > 0) {
                _this.validate();
            }
            _this.locTitle.strChanged();
            _this.clearCssClasses();
        });
        _this.registerPropertyChangedHandlers(["indent", "rightIndent"], function () {
            _this.resetIndents();
        });
        _this.registerPropertyChangedHandlers(["showCommentArea", "showOtherItem"], function () {
            _this.initCommentFromSurvey();
        });
        _this.registerFunctionOnPropertiesValueChanged(["no", "readOnly", "hasVisibleErrors", "containsErrors"], function () {
            _this.updateQuestionCss();
        });
        _this.registerPropertyChangedHandlers(["_isMobile"], function () { _this.onMobileChanged(); });
        _this.registerPropertyChangedHandlers(["colSpan"], function () { var _a; (_a = _this.parent) === null || _a === void 0 ? void 0 : _a.updateColumns(); });
        return _this;
    }
    Question.getQuestionId = function () {
        return "sq_" + Question.questionCounter++;
    };
    Question.prototype.isReadOnlyRenderDiv = function () {
        return this.isReadOnly && settings.readOnly.commentRenderMode === "div";
    };
    Question.prototype.allowMobileInDesignMode = function () {
        return false;
    };
    Question.prototype.updateIsMobileFromSurvey = function () {
        this.setIsMobile(this.survey._isMobile);
    };
    Question.prototype.setIsMobile = function (val) {
        var newVal = val && (this.allowMobileInDesignMode() || !this.isDesignMode);
        this.isMobile = newVal;
    };
    Question.prototype.getIsMobile = function () {
        return this._isMobile;
    };
    Object.defineProperty(Question.prototype, "isMobile", {
        get: function () {
            return this.getIsMobile();
        },
        set: function (val) {
            this._isMobile = val;
        },
        enumerable: false,
        configurable: true
    });
    Question.prototype.themeChanged = function (theme) { };
    Question.prototype.getDefaultTitle = function () { return this.name; };
    Question.prototype.createLocTitleProperty = function () {
        var _this = this;
        var locTitleValue = _super.prototype.createLocTitleProperty.call(this);
        locTitleValue.storeDefaultText = true;
        locTitleValue.onGetTextCallback = function (text) {
            if (!text) {
                text = _this.getDefaultTitle();
            }
            if (!_this.survey)
                return text;
            return _this.survey.getUpdatedQuestionTitle(_this, text);
        };
        this.locProcessedTitle = new localizablestring_LocalizableString(this, true);
        this.locProcessedTitle.sharedData = locTitleValue;
        return locTitleValue;
    };
    Object.defineProperty(Question.prototype, "commentTextAreaModel", {
        get: function () {
            if (!this.commentTextAreaModelValue) {
                this.commentTextAreaModelValue = new text_area_TextAreaModel(this.getCommentTextAreaOptions());
            }
            return this.commentTextAreaModelValue;
        },
        enumerable: false,
        configurable: true
    });
    Question.prototype.getCommentTextAreaOptions = function () {
        var _this = this;
        var options = {
            question: this,
            id: function () { return _this.commentId; },
            propertyName: "comment",
            className: function () { return _this.cssClasses.comment; },
            placeholder: function () { return _this.renderedCommentPlaceholder; },
            isDisabledAttr: function () { return _this.isInputReadOnly || false; },
            rows: function () { return _this.commentAreaRows; },
            autoGrow: function () { return _this.autoGrowComment; },
            maxLength: function () { return _this.getOthersMaxLength(); },
            ariaRequired: function () { return _this.a11y_input_ariaRequired; },
            ariaLabel: function () { return _this.a11y_input_ariaLabel; },
            getTextValue: function () { return _this.comment; },
            onTextAreaChange: function (e) { _this.onCommentChange(e); },
            onTextAreaInput: function (e) { _this.onCommentInput(e); },
        };
        return options;
    };
    Question.prototype.getSurvey = function (live) {
        if (live === void 0) { live = false; }
        if (live) {
            return !!this.parent ? this.parent.getSurvey(live) : null;
        }
        if (!!this.onGetSurvey)
            return this.onGetSurvey();
        return _super.prototype.getSurvey.call(this);
    };
    Question.prototype.getValueName = function () {
        if (!!this.valueName)
            return this.valueName.toString();
        return this.name;
    };
    Object.defineProperty(Question.prototype, "valueName", {
        /**
         * Specifies an object property that should store the question value.
         *
         * Refer to the [Merge Question Values](https://surveyjs.io/form-library/documentation/design-survey-merge-question-values) help topic for more information.
         */
        get: function () {
            return this.getPropertyValue("valueName", "");
        },
        set: function (val) {
            var oldValueName = this.getValueName();
            this.setPropertyValue("valueName", val);
            this.onValueNameChanged(oldValueName);
        },
        enumerable: false,
        configurable: true
    });
    Question.prototype.onValueNameChanged = function (oldValue) {
        if (!this.survey)
            return;
        this.survey.questionRenamed(this, this.name, !!oldValue ? oldValue : this.name);
        this.initDataFromSurvey();
    };
    Question.prototype.onNameChanged = function (oldValue) {
        this.locTitle.strChanged();
        if (!this.survey)
            return;
        this.survey.questionRenamed(this, oldValue, this.valueName ? this.valueName : oldValue);
    };
    Object.defineProperty(Question.prototype, "isReady", {
        get: function () {
            return this.isReadyValue;
        },
        enumerable: false,
        configurable: true
    });
    Question.prototype.onAsyncRunningChanged = function () {
        this.updateIsReady();
    };
    Question.prototype.updateIsReady = function () {
        var res = this.getIsQuestionReady();
        if (res) {
            var questions = this.getIsReadyDependsOn();
            for (var i = 0; i < questions.length; i++) {
                if (!questions[i].getIsQuestionReady()) {
                    res = false;
                    break;
                }
            }
        }
        this.setIsReady(res);
    };
    Question.prototype.getIsQuestionReady = function () {
        return !this.isAsyncExpressionRunning && this.getAreNestedQuestionsReady();
    };
    Question.prototype.getAreNestedQuestionsReady = function () {
        var questions = this.getIsReadyNestedQuestions();
        if (!Array.isArray(questions))
            return true;
        for (var i = 0; i < questions.length; i++) {
            if (!questions[i].isReady)
                return false;
        }
        return true;
    };
    Question.prototype.getIsReadyNestedQuestions = function () {
        return this.getNestedQuestions();
    };
    Question.prototype.setIsReady = function (val) {
        var oldIsReady = this.isReadyValue;
        this.isReadyValue = val;
        if (oldIsReady != val) {
            this.getIsReadyDependends().forEach(function (q) { return q.updateIsReady(); });
            this.onReadyChanged.fire(this, {
                question: this,
                isReady: val,
                oldIsReady: oldIsReady,
            });
        }
    };
    Question.prototype.getIsReadyDependsOn = function () {
        return this.getIsReadyDependendCore(true);
    };
    Question.prototype.getIsReadyDependends = function () {
        return this.getIsReadyDependendCore(false);
    };
    Question.prototype.getIsReadyDependendCore = function (isDependOn) {
        var _this = this;
        if (!this.survey)
            return [];
        var questions = this.survey.questionsByValueName(this.getValueName());
        var res = new Array();
        questions.forEach(function (q) { if (q !== _this)
            res.push(q); });
        if (!isDependOn) {
            if (this.parentQuestion) {
                res.push(this.parentQuestion);
            }
            if (this.dependedQuestions.length > 0) {
                this.dependedQuestions.forEach(function (q) { return res.push(q); });
            }
        }
        return res;
    };
    Question.prototype.choicesLoaded = function () { };
    Object.defineProperty(Question.prototype, "page", {
        /**
         * Returns a page to which the question belongs and allows you to move this question to a different page.
         */
        get: function () {
            if (!!this.parentQuestion)
                return this.parentQuestion.page;
            return this.getPage(this.parent);
        },
        set: function (val) {
            this.setPage(this.parent, val);
        },
        enumerable: false,
        configurable: true
    });
    Question.prototype.getPanel = function () {
        return null;
    };
    Question.prototype.delete = function (doDispose) {
        if (doDispose === void 0) { doDispose = true; }
        this.removeFromParent();
        if (doDispose) {
            this.dispose();
        }
        else {
            this.resetDependedQuestions();
        }
    };
    Question.prototype.removeFromParent = function () {
        if (!!this.parent) {
            this.removeSelfFromList(this.parent.elements);
        }
    };
    Question.prototype.addDependedQuestion = function (question) {
        if (!question || this.dependedQuestions.indexOf(question) > -1)
            return;
        this.dependedQuestions.push(question);
    };
    Question.prototype.removeDependedQuestion = function (question) {
        if (!question)
            return;
        var index = this.dependedQuestions.indexOf(question);
        if (index > -1) {
            this.dependedQuestions.splice(index, 1);
        }
    };
    Question.prototype.updateDependedQuestions = function () {
        for (var i = 0; i < this.dependedQuestions.length; i++) {
            this.dependedQuestions[i].updateDependedQuestion();
        }
    };
    Question.prototype.updateDependedQuestion = function () { };
    Question.prototype.resetDependedQuestion = function () { };
    Object.defineProperty(Question.prototype, "isFlowLayout", {
        get: function () {
            return this.getLayoutType() === "flow";
        },
        enumerable: false,
        configurable: true
    });
    Question.prototype.getLayoutType = function () {
        if (!!this.parent)
            return this.parent.getChildrenLayoutType();
        return "row";
    };
    Question.prototype.isLayoutTypeSupported = function (layoutType) {
        return layoutType !== "flow";
    };
    Object.defineProperty(Question.prototype, "visible", {
        /**
         * Gets or sets question visibility.
         *
         * If you want to display or hide a question based on a condition, specify the [`visibleIf`](https://surveyjs.io/form-library/documentation/question#visibleIf) property. Refer to the following help topic for information: [Conditional Visibility](https://surveyjs.io/form-library/documentation/design-survey-conditional-logic#conditional-visibility).
         * @see isVisible
         * @see visibleIf
         */
        get: function () {
            return this.getPropertyValue("visible", true);
        },
        set: function (val) {
            if (val == this.visible)
                return;
            this.setPropertyValue("visible", val);
            this.onVisibleChanged();
            this.notifySurveyVisibilityChanged();
        },
        enumerable: false,
        configurable: true
    });
    Question.prototype.onVisibleChanged = function () {
        this.updateIsVisibleProp();
        if (!this.isVisible && this.errors && this.errors.length > 0) {
            this.errors = [];
        }
    };
    Question.prototype.notifyStateChanged = function (prevState) {
        _super.prototype.notifyStateChanged.call(this, prevState);
        if (this.isCollapsed) {
            this.onHidingContent();
        }
    };
    Question.prototype.updateElementVisibility = function () {
        this.updateIsVisibleProp();
    };
    Question.prototype.updateIsVisibleProp = function () {
        var prev = this.getPropertyValue("isVisible");
        var val = this.isVisible;
        if (prev !== val) {
            this.setPropertyValue("isVisible", val);
            if (!val) {
                this.onHidingContent();
            }
        }
        if (val !== this.visible && this.areInvisibleElementsShowing) {
            this.updateQuestionCss(true);
        }
    };
    Object.defineProperty(Question.prototype, "useDisplayValuesInDynamicTexts", {
        /**
         * Specifies whether to use display names for question values in placeholders.
         *
         * Default value: `true`
         *
         * This property applies to questions whose values are defined as objects with the `value` and `text` properties (for example, [choice items](https://surveyjs.io/form-library/documentation/questionradiogroupmodel#choices) in Radiogroup, Checkbox, and Dropdown questions).
         *
         * You can use question values as placeholders in the following places:
         *
         * - Survey element titles and descriptions
         * - The [`html`](https://surveyjs.io/form-library/documentation/questionhtmlmodel#html) property of the [HTML](https://surveyjs.io/form-library/documentation/questionhtmlmodel) question
         *
         * To use a question value as a placeholder, specify the question `name` in curly brackets: `{questionName}`. Refer to the following help topic for more information: [Dynamic Texts - Question Values](https://surveyjs.io/form-library/documentation/design-survey-conditional-logic#question-values).
         */
        get: function () {
            return this.getPropertyValue("useDisplayValuesInDynamicTexts");
        },
        set: function (val) {
            this.setPropertyValue("useDisplayValuesInDynamicTexts", val);
        },
        enumerable: false,
        configurable: true
    });
    Question.prototype.getUseDisplayValuesInDynamicTexts = function () { return this.useDisplayValuesInDynamicTexts; };
    Object.defineProperty(Question.prototype, "visibleIf", {
        /**
         * A Boolean expression. If it evaluates to `false`, this question becomes hidden.
         *
         * A survey parses and runs all expressions on startup. If any values used in the expression change, the survey re-evaluates it.
         *
         * Refer to the following help topic for more information: [Conditional Visibility](https://surveyjs.io/form-library/documentation/design-survey-conditional-logic#conditional-visibility).
         * @see visible
         * @see isVisible
         */
        get: function () {
            return this.getPropertyValue("visibleIf", "");
        },
        set: function (val) {
            this.setPropertyValue("visibleIf", val);
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(Question.prototype, "isVisible", {
        /**
         * Returns `true` if the question is visible or the survey is currently in design mode.
         *
         * If you want to display or hide a question based on a condition, specify the [`visibleIf`](https://surveyjs.io/form-library/documentation/question#visibleIf) property. Refer to the following help topic for information: [Conditional Visibility](https://surveyjs.io/form-library/documentation/design-survey-conditional-logic#conditional-visibility).
         * @see visibleIf
         * @see visible
         * @see isParentVisible
         */
        get: function () {
            if (this.survey && this.survey.areEmptyElementsHidden && this.isEmpty())
                return false;
            if (this.areInvisibleElementsShowing)
                return true;
            return this.isVisibleCore();
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(Question.prototype, "isVisibleInSurvey", {
        get: function () {
            return this.isVisible && this.isParentVisible;
        },
        enumerable: false,
        configurable: true
    });
    Question.prototype.isVisibleCore = function () {
        return this.visible;
    };
    Object.defineProperty(Question.prototype, "visibleIndex", {
        /**
         * Returns the visible index of the question in the survey. It can be from 0 to all visible questions count - 1
         * The visibleIndex is -1 if the title is 'hidden' or hideNumber is true
         * @see titleLocation
         * @see hideNumber
         */
        get: function () {
            return this.getPropertyValue("visibleIndex", -1);
        },
        enumerable: false,
        configurable: true
    });
    Question.prototype.onHidingContent = function () { };
    Object.defineProperty(Question.prototype, "hideNumber", {
        /**
         * Hides the question number from the title and excludes the question from numbering.
         *
         * If you want to disable question numbering in the entire survey, set `SurveyModel`'s `showQuestionNumbers` property to `false`.
         * @see SurveyModel.showQuestionNumbers
         */
        get: function () {
            return this.getPropertyValue("hideNumber");
        },
        set: function (val) {
            this.setPropertyValue("hideNumber", val);
            this.notifySurveyVisibilityChanged();
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(Question.prototype, "isAllowTitleLeft", {
        /**
         * Returns `true` if the question can display its title to the left of the input field.
         * @see titleLocation
         * @see getTitleLocation
         * @see hasTitle
         */
        get: function () {
            return true;
        },
        enumerable: false,
        configurable: true
    });
    /**
     * Returns the question type.
     * Possible values:
     * - [*"boolean"*](https://surveyjs.io/Documentation/Library?id=questionbooleanmodel)
     * - [*"checkbox"*](https://surveyjs.io/Documentation/Library?id=questioncheckboxmodel)
     * - [*"comment"*](https://surveyjs.io/Documentation/Library?id=questioncommentmodel)
     * - [*"dropdown"*](https://surveyjs.io/Documentation/Library?id=questiondropdownmodel)
     * - [*"tagbox"*](https://surveyjs.io/form-library/documentation/questiontagboxmodel)
     * - [*"expression"*](https://surveyjs.io/Documentation/Library?id=questionexpressionmodel)
     * - [*"file"*](https://surveyjs.io/Documentation/Library?id=questionfilemodel)
     * - [*"html"*](https://surveyjs.io/Documentation/Library?id=questionhtmlmodel)
     * - [*"image"*](https://surveyjs.io/Documentation/Library?id=questionimagemodel)
     * - [*"imagepicker"*](https://surveyjs.io/Documentation/Library?id=questionimagepickermodel)
     * - [*"matrix"*](https://surveyjs.io/Documentation/Library?id=questionmatrixmodel)
     * - [*"matrixdropdown"*](https://surveyjs.io/Documentation/Library?id=questionmatrixdropdownmodel)
     * - [*"matrixdynamic"*](https://surveyjs.io/Documentation/Library?id=questionmatrixdynamicmodel)
     * - [*"multipletext"*](https://surveyjs.io/Documentation/Library?id=questionmultipletextmodel)
     * - [*"panel"*](https://surveyjs.io/Documentation/Library?id=panelmodel)
     * - [*"paneldynamic"*](https://surveyjs.io/Documentation/Library?id=questionpaneldynamicmodel)
     * - [*"radiogroup"*](https://surveyjs.io/Documentation/Library?id=questionradiogroupmodel)
     * - [*"rating"*](https://surveyjs.io/Documentation/Library?id=questionratingmodel)
     * - [*"ranking"*](https://surveyjs.io/Documentation/Library?id=questionrankingmodel)
     * - [*"signaturepad"*](https://surveyjs.io/Documentation/Library?id=questionsignaturepadmodel)
     * - [*"text"*](https://surveyjs.io/Documentation/Library?id=questiontextmodel)
     */
    Question.prototype.getType = function () {
        return "question";
    };
    Object.defineProperty(Question.prototype, "isQuestion", {
        get: function () {
            return true;
        },
        enumerable: false,
        configurable: true
    });
    Question.prototype.moveTo = function (container, insertBefore) {
        if (insertBefore === void 0) { insertBefore = null; }
        return this.moveToBase(this.parent, container, insertBefore);
    };
    Question.prototype.getProgressInfo = function () {
        if (!this.hasInput)
            return _super.prototype.getProgressInfo.call(this);
        return {
            questionCount: 1,
            answeredQuestionCount: !this.isEmpty() ? 1 : 0,
            requiredQuestionCount: this.isRequired ? 1 : 0,
            requiredAnsweredQuestionCount: !this.isEmpty() && this.isRequired ? 1 : 0,
        };
    };
    Question.prototype.ensureSetValueExpressionRunner = function () {
        var _this = this;
        if (!this.setValueExpressionRunner) {
            this.setValueExpressionRunner = new ExpressionRunner(this.setValueExpression);
            this.setValueExpressionRunner.onRunComplete = function (res) {
                _this.runExpressionSetValue(res);
            };
        }
        else {
            this.setValueExpressionRunner.expression = this.setValueExpression;
        }
    };
    Question.prototype.runSetValueExpression = function () {
        if (!this.setValueExpression) {
            this.clearValue();
        }
        else {
            this.ensureSetValueExpressionRunner();
            this.setValueExpressionRunner.run(this.getDataFilteredValues(), this.getDataFilteredProperties());
        }
    };
    Question.prototype.checkExpressionIf = function (keys) {
        this.ensureSetValueExpressionRunner();
        if (!this.setValueExpressionRunner)
            return false;
        return this.canExecuteTriggerByKeys(keys, this.setValueExpressionRunner);
    };
    Question.prototype.addTriggerInfo = function (name, canRun, doComplete) {
        var info = new TriggerExpressionInfo(name, canRun, doComplete);
        this.triggersInfo.push(info);
        return info;
    };
    Question.prototype.runTriggerInfo = function (info, keys) {
        var expression = this[info.name];
        if (!expression || info.isRunning || !info.canRun()) {
            if (info.runSecondCheck(keys)) {
                info.doComplete();
            }
            return;
        }
        if (!info.runner) {
            info.runner = new ExpressionRunner(expression);
            info.runner.onRunComplete = function (res) {
                if (res === true) {
                    info.doComplete();
                }
                info.isRunning = false;
            };
        }
        else {
            info.runner.expression = expression;
        }
        if (!this.canExecuteTriggerByKeys(keys, info.runner) && !info.runSecondCheck(keys))
            return;
        info.isRunning = true;
        info.runner.run(this.getDataFilteredValues(), this.getDataFilteredProperties());
    };
    Question.prototype.canExecuteTriggerByKeys = function (keys, runner) {
        var vars = runner.getVariables();
        if ((!vars || vars.length === 0) && runner.hasFunction())
            return true;
        return new conditionProcessValue_ProcessValue().isAnyKeyChanged(keys, vars);
    };
    Question.prototype.runTriggers = function (name, value, keys) {
        var _this = this;
        if (this.isSettingQuestionValue || (this.parentQuestion && this.parentQuestion.getValueName() === name))
            return;
        if (!keys) {
            keys = {};
            keys[name] = value;
        }
        this.triggersInfo.forEach(function (info) {
            _this.runTriggerInfo(info, keys);
        });
    };
    Question.prototype.runConditions = function () {
        if (this.data && !this.isLoadingFromJson) {
            if (!this.isDesignMode) {
                this.runCondition(this.getDataFilteredValues(), this.getDataFilteredProperties());
            }
            this.locStrsChanged();
        }
    };
    Question.prototype.setSurveyImpl = function (value, isLight) {
        _super.prototype.setSurveyImpl.call(this, value);
        if (!this.survey)
            return;
        this.survey.questionCreated(this);
        if (isLight !== true) {
            this.runConditions();
        }
        if (!this.visible) {
            this.updateIsVisibleProp();
        }
        this.updateIsMobileFromSurvey();
    };
    Object.defineProperty(Question.prototype, "parent", {
        /**
         * Returns a survey element (panel or page) that contains the question and allows you to move this question to a different survey element.
         */
        get: function () {
            return this.getPropertyValue("parent", null);
        },
        set: function (val) {
            if (this.parent === val)
                return;
            this.removeFromParent();
            this.setPropertyValue("parent", val);
            if (!!val) {
                this.updateQuestionCss();
            }
            this.onParentChanged();
        },
        enumerable: false,
        configurable: true
    });
    Question.prototype.onParentChanged = function () { };
    Object.defineProperty(Question.prototype, "hasTitle", {
        /**
         * Returns `false` if the `titleLocation` property is set to `"hidden"` or if the question cannot have a title (for example, an [HTML](https://surveyjs.io/form-library/documentation/questionhtmlmodel) question).
         *
         * If the `title` property is `undefined` or set to an empty string, the `hasTitle` property returns `true`, because the question uses its `name` as a title in this case.
         * @see title
         * @see titleLocation
         */
        get: function () {
            return this.getTitleLocation() !== "hidden";
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(Question.prototype, "titleLocation", {
        /**
         * Sets question title location relative to the input field. Overrides the `questionTitleLocation` property specified for the question's container (survey, page, or panel).
         *
         * Possible values:
         *
         * - `"default"` (default) - Inherits the setting from the `questionTitleLocation` property specified for the question's container.
         * - `"top"` - Displays the title above the input field.
         * - `"bottom"` - Displays the title below the input field.
         * - `"left"` - Displays the title to the left of the input field.
         * - `"hidden"` - Hides the question title.
         *
         * > Certain question types (Matrix, Multiple Text) do not support the `"left"` value. For them, the `"top"` value is used.
         * @see SurveyModel.questionTitleLocation
         * @see getTitleLocation
         * @see isAllowTitleLeft
         */
        get: function () {
            return this.getPropertyValue("titleLocation");
        },
        set: function (value) {
            var isVisibilityChanged = this.titleLocation == "hidden" || value == "hidden";
            this.setPropertyValue("titleLocation", value.toLowerCase());
            this.updateQuestionCss();
            if (isVisibilityChanged) {
                this.notifySurveyVisibilityChanged();
            }
        },
        enumerable: false,
        configurable: true
    });
    Question.prototype.getTitleOwner = function () { return this; };
    Question.prototype.getIsTitleRenderedAsString = function () { return this.titleLocation === "hidden"; };
    Question.prototype.notifySurveyOnChildrenVisibilityChanged = function () { return false; };
    Question.prototype.notifySurveyVisibilityChanged = function () {
        if (!this.survey || this.isLoadingFromJson)
            return;
        this.survey.questionVisibilityChanged(this, this.isVisible, !this.parentQuestion || this.parentQuestion.notifySurveyOnChildrenVisibilityChanged());
        var isClearOnHidden = this.isClearValueOnHidden;
        if (!this.visible) {
            this.clearValueOnHidding(isClearOnHidden);
        }
        if (isClearOnHidden && this.isVisibleInSurvey) {
            this.updateValueWithDefaults();
        }
    };
    Question.prototype.clearValueOnHidding = function (isClearOnHidden) {
        if (isClearOnHidden) {
            this.clearValueIfInvisible();
        }
    };
    Object.defineProperty(Question.prototype, "titleWidth", {
        get: function () {
            if (this.parent && this.getTitleLocation() === "left") {
                var columns = this.parent.getColumsForElement(this);
                var columnCount = columns.length;
                if (columnCount !== 0 && !!columns[0].questionTitleWidth)
                    return columns[0].questionTitleWidth;
                var percentWidth = this.getPercentQuestionTitleWidth();
                if (!percentWidth && !!this.parent) {
                    var width = this.parent.getQuestionTitleWidth();
                    if (width && !isNaN(width))
                        width = width + "px";
                    return width;
                }
                return (percentWidth / (columnCount || 1)) + "%";
            }
            return undefined;
        },
        enumerable: false,
        configurable: true
    });
    Question.prototype.getPercentQuestionTitleWidth = function () {
        var width = !!this.parent && this.parent.getQuestionTitleWidth();
        if (!!width && width[width.length - 1] === "%") {
            return parseInt(width);
        }
        return undefined;
    };
    /**
     * Returns title location calculated based on the question's `titleLocation` property and the `questionTitleLocation` property of the question's containers (survey, page, or panel).
     * @see titleLocation
     * @see SurveyModel.questionTitleLocation
     */
    Question.prototype.getTitleLocation = function () {
        if (this.isFlowLayout)
            return "hidden";
        var location = this.getTitleLocationCore();
        if (location === "left" && !this.isAllowTitleLeft)
            location = "top";
        return location;
    };
    Question.prototype.getTitleLocationCore = function () {
        if (this.titleLocation !== "default")
            return this.titleLocation;
        if (!!this.parent)
            return this.parent.getQuestionTitleLocation();
        if (!!this.survey)
            return this.survey.questionTitleLocation;
        return "top";
    };
    Object.defineProperty(Question.prototype, "hasTitleOnLeft", {
        get: function () {
            return this.hasTitle && this.getTitleLocation() === "left";
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(Question.prototype, "hasTitleOnTop", {
        get: function () {
            return this.hasTitle && this.getTitleLocation() === "top";
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(Question.prototype, "hasTitleOnBottom", {
        get: function () {
            return this.hasTitle && this.getTitleLocation() === "bottom";
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(Question.prototype, "hasTitleOnLeftTop", {
        get: function () {
            if (!this.hasTitle)
                return false;
            var location = this.getTitleLocation();
            return location === "left" || location === "top";
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(Question.prototype, "errorLocation", {
        /**
         * Specifies the error message position. Overrides the `questionErrorLocation` property specified for the question's container ([survey](https://surveyjs.io/form-library/documentation/api-reference/survey-data-model#questionErrorLocation), [page](https://surveyjs.io/form-library/documentation/api-reference/page-model#questionErrorLocation), or [panel](https://surveyjs.io/form-library/documentation/api-reference/panel-model#questionErrorLocation)).
         *
         * Possible values:
         *
         * - `"default"` (default) - Inherits the setting from the `questionErrorLocation` property specified for the question's container.
         * - `"top"` - Displays error messages above questions.
         * - `"bottom"` - Displays error messages below questions.
         */
        get: function () {
            return this.getPropertyValue("errorLocation");
        },
        set: function (val) {
            this.setPropertyValue("errorLocation", val);
        },
        enumerable: false,
        configurable: true
    });
    Question.prototype.getErrorLocation = function () {
        if (this.errorLocation !== "default")
            return this.errorLocation;
        if (this.parentQuestion)
            return this.parentQuestion.getChildErrorLocation(this);
        if (this.parent)
            return this.parent.getQuestionErrorLocation();
        return this.survey ? this.survey.questionErrorLocation : "top";
    };
    Question.prototype.getChildErrorLocation = function (child) {
        return this.getErrorLocation();
    };
    Object.defineProperty(Question.prototype, "hasInput", {
        /**
         * Returns `false` if the question has no input fields ([HTML](https://surveyjs.io/form-library/documentation/questionhtmlmodel), [Image](https://surveyjs.io/form-library/documentation/questionimagemodel), and similar question types).
         * @see hasSingleInput
         */
        get: function () {
            return true;
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(Question.prototype, "hasSingleInput", {
        /**
         * Returns `false` if the question has no input fields ([HTML](https://surveyjs.io/form-library/documentation/questionhtmlmodel), [Image](https://surveyjs.io/form-library/documentation/questionimagemodel)) or has multiple input fields ([Matrix](https://surveyjs.io/form-library/documentation/questionmatrixmodel), [Multiple Text](https://surveyjs.io/form-library/documentation/questionmultipletextmodel)).
         * @see hasInput
         */
        get: function () {
            return this.hasInput;
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(Question.prototype, "inputId", {
        get: function () {
            return this.id + "i";
        },
        enumerable: false,
        configurable: true
    });
    Question.prototype.getDefaultTitleValue = function () { return this.name; };
    Question.prototype.getDefaultTitleTagName = function () {
        return settings.titleTags.question;
    };
    Object.defineProperty(Question.prototype, "descriptionLocation", {
        /**
         * Specifies where to display a question description.
         *
         * Possible values:
         *
         * - `"default"` (default) - Inherits the setting from the Survey's [`questionDescriptionLocation`](https://surveyjs.io/form-library/documentation/surveymodel#questionDescriptionLocation) property.
         * - `"underTitle"` - Displays the description under the question title.
         * - `"underInput"` - Displays the description under the interactive area.
         * @see description
         * @see hasDescription
         */
        get: function () {
            return this.getPropertyValue("descriptionLocation");
        },
        set: function (val) {
            this.setPropertyValue("descriptionLocation", val);
            this.updateQuestionCss();
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(Question.prototype, "hasDescriptionUnderTitle", {
        get: function () {
            return this.getDescriptionLocation() == "underTitle" && this.hasDescription;
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(Question.prototype, "hasDescriptionUnderInput", {
        get: function () {
            return this.getDescriptionLocation() == "underInput" && this.hasDescription;
        },
        enumerable: false,
        configurable: true
    });
    Question.prototype.getDescriptionLocation = function () {
        if (this.descriptionLocation !== "default")
            return this.descriptionLocation;
        return !!this.survey
            ? this.survey.questionDescriptionLocation
            : "underTitle";
    };
    Question.prototype.needClickTitleFunction = function () {
        return _super.prototype.needClickTitleFunction.call(this) || this.hasInput;
    };
    Question.prototype.processTitleClick = function () {
        var _this = this;
        _super.prototype.processTitleClick.call(this);
        if (this.isCollapsed)
            return;
        setTimeout(function () {
            _this.focus();
        }, 1);
        return true;
    };
    Object.defineProperty(Question.prototype, "requiredErrorText", {
        /**
         * Specifies a custom error message for a required form field.
         * @see isRequired
         */
        get: function () {
            return this.getLocalizableStringText("requiredErrorText");
        },
        set: function (val) {
            this.setLocalizableStringText("requiredErrorText", val);
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(Question.prototype, "locRequiredErrorText", {
        get: function () {
            return this.getLocalizableString("requiredErrorText");
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(Question.prototype, "commentText", {
        /**
         * Specifies a caption displayed above the comment area. Applies when the `showCommentArea` property is `true`.
         * @see showCommentArea
         * @see comment
         */
        get: function () {
            return this.getLocalizableStringText("commentText");
        },
        set: function (val) {
            this.setLocalizableStringText("commentText", val);
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(Question.prototype, "locCommentText", {
        get: function () {
            return this.getLocalizableString("commentText");
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(Question.prototype, "commentPlaceHolder", {
        get: function () {
            return this.commentPlaceholder;
        },
        set: function (newValue) {
            this.commentPlaceholder = newValue;
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(Question.prototype, "renderedCommentPlaceholder", {
        get: function () {
            var _this = this;
            var func = function () {
                return !_this.isReadOnly ? _this.commentPlaceHolder : undefined;
            };
            return this.getPropertyValue("renderedCommentPlaceholder", undefined, func);
        },
        enumerable: false,
        configurable: true
    });
    Question.prototype.resetRenderedCommentPlaceholder = function () {
        this.resetPropertyValue("renderedCommentPlaceholder");
    };
    Question.prototype.getAllErrors = function () {
        return this.errors.slice();
    };
    Question.prototype.getErrorByType = function (errorType) {
        for (var i = 0; i < this.errors.length; i++) {
            if (this.errors[i].getErrorType() === errorType)
                return this.errors[i];
        }
        return null;
    };
    Object.defineProperty(Question.prototype, "customWidget", {
        get: function () {
            if (!this.isCustomWidgetRequested && !this.customWidgetValue) {
                this.isCustomWidgetRequested = true;
                this.updateCustomWidget();
            }
            return this.customWidgetValue;
        },
        enumerable: false,
        configurable: true
    });
    Question.prototype.updateCustomWidget = function () {
        this.customWidgetValue = questionCustomWidgets_CustomWidgetCollection.Instance.getCustomWidget(this);
    };
    Question.prototype.localeChanged = function () {
        _super.prototype.localeChanged.call(this);
        this.resetRenderedCommentPlaceholder();
        if (!!this.localeChangedCallback) {
            this.localeChangedCallback();
        }
    };
    Object.defineProperty(Question.prototype, "isCompositeQuestion", {
        get: function () {
            return false;
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(Question.prototype, "isContainer", {
        get: function () { return false; },
        enumerable: false,
        configurable: true
    });
    Question.prototype.updateCommentElements = function () {
    };
    Question.prototype.onCommentInput = function (event) {
        if (this.isInputTextUpdate) {
            if (event.target) {
                this.comment = event.target.value;
            }
        }
        else {
            this.updateCommentElements();
        }
    };
    Question.prototype.onCommentChange = function (event) {
        this.comment = event.target.value;
        if (this.comment !== event.target.value) {
            event.target.value = this.comment;
        }
    };
    Question.prototype.afterRenderQuestionElement = function (el) {
        if (!this.survey || !this.hasSingleInput)
            return;
        this.survey.afterRenderQuestionInput(this, el);
    };
    Question.prototype.afterRender = function (el) {
        var _this = this;
        this.afterRenderCore(el);
        if (!this.survey)
            return;
        this.survey.afterRenderQuestion(this, el);
        if (!!this.afterRenderQuestionCallback) {
            this.afterRenderQuestionCallback(this, el);
        }
        if (this.supportComment() || this.supportOther()) {
            this.commentElements = [];
            this.getCommentElementsId().forEach(function (id) {
                var root = settings.environment.root;
                var el = root.getElementById(id);
                if (el)
                    _this.commentElements.push(el);
            });
            this.updateCommentElements();
        }
        this.checkForResponsiveness(el);
    };
    Question.prototype.afterRenderCore = function (element) {
        _super.prototype.afterRenderCore.call(this, element);
    };
    Question.prototype.getCommentElementsId = function () {
        return [this.commentId];
    };
    Question.prototype.beforeDestroyQuestionElement = function (el) {
        this.commentElements = undefined;
    };
    Object.defineProperty(Question.prototype, "processedTitle", {
        get: function () {
            var res = this.locProcessedTitle.textOrHtml;
            return res ? res : this.name;
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(Question.prototype, "fullTitle", {
        get: function () {
            return this.locTitle.renderedHtml;
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(Question.prototype, "titlePattern", {
        get: function () {
            return !!this.survey ? this.survey.questionTitlePattern : "numTitleRequire";
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(Question.prototype, "isRequireTextOnStart", {
        get: function () {
            return this.isRequired && this.titlePattern == "requireNumTitle";
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(Question.prototype, "isRequireTextBeforeTitle", {
        get: function () {
            return this.isRequired && this.titlePattern == "numRequireTitle" && this.requiredText !== "";
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(Question.prototype, "isRequireTextAfterTitle", {
        get: function () {
            return this.isRequired && this.titlePattern == "numTitleRequire" && this.requiredText !== "";
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(Question.prototype, "startWithNewLine", {
        /**
         * Disable this property if you want to render the current question on the same line or row with the previous question or panel.
         */
        get: function () {
            return this.getPropertyValue("startWithNewLine");
        },
        set: function (val) {
            if (this.startWithNewLine == val)
                return;
            this.setPropertyValue("startWithNewLine", val);
        },
        enumerable: false,
        configurable: true
    });
    Question.prototype.calcCssClasses = function (css) {
        var classes = { error: {} };
        this.copyCssClasses(classes, css.question);
        this.copyCssClasses(classes.error, css.error);
        this.updateCssClasses(classes, css);
        return classes;
    };
    Question.prototype.onCalcCssClasses = function (classes) {
        _super.prototype.onCalcCssClasses.call(this, classes);
        if (this.survey) {
            this.survey.updateQuestionCssClasses(this, classes);
        }
        if (this.onUpdateCssClassesCallback) {
            this.onUpdateCssClassesCallback(classes);
        }
    };
    Object.defineProperty(Question.prototype, "cssRoot", {
        get: function () {
            this.ensureElementCss();
            return this.getPropertyValue("cssRoot", "");
        },
        enumerable: false,
        configurable: true
    });
    Question.prototype.setCssRoot = function (val) {
        this.setPropertyValue("cssRoot", val);
    };
    Question.prototype.getCssRoot = function (cssClasses) {
        var hasError = this.hasCssError();
        return new CssClassBuilder()
            .append(_super.prototype.getCssRoot.call(this, cssClasses))
            .append(this.isFlowLayout && !this.isDesignMode
            ? cssClasses.flowRoot
            : cssClasses.mainRoot)
            .append(cssClasses.titleLeftRoot, !this.isFlowLayout && this.hasTitleOnLeft)
            .append(cssClasses.titleTopRoot, !this.isFlowLayout && this.hasTitleOnTop)
            .append(cssClasses.titleBottomRoot, !this.isFlowLayout && this.hasTitleOnBottom)
            .append(cssClasses.descriptionUnderInputRoot, !this.isFlowLayout && this.hasDescriptionUnderInput)
            .append(cssClasses.hasError, hasError)
            .append(cssClasses.hasErrorTop, hasError && this.getErrorLocation() == "top")
            .append(cssClasses.hasErrorBottom, hasError && this.getErrorLocation() == "bottom")
            .append(cssClasses.small, !this.width)
            .append(cssClasses.answered, this.isAnswered)
            .append(cssClasses.noPointerEventsMode, this.isReadOnlyAttr)
            .toString();
    };
    Object.defineProperty(Question.prototype, "cssHeader", {
        get: function () {
            this.ensureElementCss();
            return this.getPropertyValue("cssHeader", "");
        },
        enumerable: false,
        configurable: true
    });
    Question.prototype.setCssHeader = function (val) {
        this.setPropertyValue("cssHeader", val);
    };
    Question.prototype.getCssHeader = function (cssClasses) {
        return new CssClassBuilder()
            .append(cssClasses.header)
            .append(cssClasses.headerTop, this.hasTitleOnTop)
            .append(cssClasses.headerLeft, this.hasTitleOnLeft)
            .append(cssClasses.headerBottom, this.hasTitleOnBottom)
            .toString();
    };
    Question.prototype.supportContainerQueries = function () {
        return false;
    };
    Object.defineProperty(Question.prototype, "cssContent", {
        get: function () {
            this.ensureElementCss();
            return this.getPropertyValue("cssContent", "");
        },
        enumerable: false,
        configurable: true
    });
    Question.prototype.setCssContent = function (val) {
        this.setPropertyValue("cssContent", val);
    };
    Question.prototype.getCssContent = function (cssClasses) {
        return new CssClassBuilder()
            .append(cssClasses.content)
            .append(cssClasses.contentSupportContainerQueries, this.supportContainerQueries())
            .append(cssClasses.contentLeft, this.hasTitleOnLeft)
            .toString();
    };
    Object.defineProperty(Question.prototype, "cssTitle", {
        get: function () {
            this.ensureElementCss();
            return this.getPropertyValue("cssTitle", "");
        },
        enumerable: false,
        configurable: true
    });
    Question.prototype.setCssTitle = function (val) {
        this.setPropertyValue("cssTitle", val);
    };
    Question.prototype.getCssTitle = function (cssClasses) {
        return new CssClassBuilder()
            .append(_super.prototype.getCssTitle.call(this, cssClasses))
            .append(cssClasses.titleOnAnswer, !this.containsErrors && this.isAnswered)
            .append(cssClasses.titleEmpty, !this.title.trim())
            .toString();
    };
    Object.defineProperty(Question.prototype, "cssDescription", {
        get: function () {
            this.ensureElementCss();
            return this.getPropertyValue("cssDescription", "");
        },
        enumerable: false,
        configurable: true
    });
    Question.prototype.setCssDescription = function (val) {
        this.setPropertyValue("cssDescription", val);
    };
    Question.prototype.getCssDescription = function (cssClasses) {
        return new CssClassBuilder()
            .append(cssClasses.description)
            .append(cssClasses.descriptionUnderInput, this.getDescriptionLocation() == "underInput")
            .toString();
    };
    Question.prototype.showErrorOnCore = function (location) {
        return !this.showErrorsAboveQuestion && !this.showErrorsBelowQuestion && this.getErrorLocation() === location;
    };
    Object.defineProperty(Question.prototype, "showErrorOnTop", {
        get: function () {
            return this.showErrorOnCore("top");
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(Question.prototype, "showErrorOnBottom", {
        get: function () {
            return this.showErrorOnCore("bottom");
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(Question.prototype, "showErrorsOutsideQuestion", {
        get: function () {
            return this.isDefaultV2Theme;
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(Question.prototype, "showErrorsAboveQuestion", {
        get: function () {
            return this.showErrorsOutsideQuestion && this.getErrorLocation() === "top";
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(Question.prototype, "showErrorsBelowQuestion", {
        get: function () {
            return this.showErrorsOutsideQuestion && this.getErrorLocation() === "bottom";
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(Question.prototype, "cssError", {
        get: function () {
            this.ensureElementCss();
            return this.getPropertyValue("cssError", "");
        },
        enumerable: false,
        configurable: true
    });
    Question.prototype.setCssError = function (val) {
        this.setPropertyValue("cssError", val);
    };
    Question.prototype.getCssError = function (cssClasses) {
        return new CssClassBuilder()
            .append(cssClasses.error.root)
            .append(cssClasses.errorsContainer, this.showErrorsBelowQuestion || this.showErrorsAboveQuestion)
            .append(cssClasses.errorsContainerTop, this.showErrorsAboveQuestion)
            .append(cssClasses.errorsContainerBottom, this.showErrorsBelowQuestion)
            .append(cssClasses.error.locationTop, this.showErrorOnTop)
            .append(cssClasses.error.locationBottom, this.showErrorOnBottom)
            .toString();
    };
    Question.prototype.hasCssError = function () {
        return this.errors.length > 0 || this.hasCssErrorCallback();
    };
    Question.prototype.getRootCss = function () {
        return new CssClassBuilder()
            .append(this.cssRoot)
            .append(this.cssClasses.mobile, this.isMobile)
            .append(this.cssClasses.readOnly, this.isReadOnlyStyle)
            .append(this.cssClasses.disabled, this.isDisabledStyle)
            .append(this.cssClasses.preview, this.isPreviewStyle)
            .append(this.cssClasses.invisible, !this.isDesignMode && this.areInvisibleElementsShowing && !this.visible)
            .toString();
    };
    Question.prototype.getQuestionRootCss = function () {
        return new CssClassBuilder()
            .append(this.cssClasses.root)
            .append(this.cssClasses.rootMobile, this.isMobile)
            .toString();
    };
    Question.prototype.updateElementCss = function (reNew) {
        if (this.wasRendered) {
            _super.prototype.updateElementCss.call(this, reNew);
            if (reNew) {
                this.updateQuestionCss(true);
            }
        }
        else {
            this.isRequireUpdateElements = true;
        }
        this.resetIndents();
    };
    Question.prototype.onFirstRenderingCore = function () {
        if (this.isRequireUpdateElements) {
            this.isRequireUpdateElements = false;
            this.updateElementCss(true);
        }
        _super.prototype.onFirstRenderingCore.call(this);
    };
    Question.prototype.updateQuestionCss = function (reNew) {
        if (this.isLoadingFromJson || !this.survey)
            return;
        if (this.wasRendered) {
            this.updateElementCssCore(this.cssClasses);
        }
        else {
            this.isRequireUpdateElements = true;
        }
    };
    Question.prototype.ensureElementCss = function () {
        if (!this.cssClassesValue) {
            this.updateQuestionCss(true);
        }
    };
    Question.prototype.updateElementCssCore = function (cssClasses) {
        this.setCssRoot(this.getCssRoot(cssClasses));
        this.setCssHeader(this.getCssHeader(cssClasses));
        this.setCssContent(this.getCssContent(cssClasses));
        this.setCssTitle(this.getCssTitle(cssClasses));
        this.setCssDescription(this.getCssDescription(cssClasses));
        this.setCssError(this.getCssError(cssClasses));
    };
    Question.prototype.updateCssClasses = function (res, css) {
        if (!css.question)
            return;
        var objCss = css[this.getCssType()];
        var titleBuilder = new CssClassBuilder().append(res.title)
            .append(css.question.titleRequired, this.isRequired);
        res.title = titleBuilder.toString();
        var rootBuilder = new CssClassBuilder().append(res.root)
            .append(objCss, this.isRequired && !!css.question.required);
        if (objCss === undefined || objCss === null) {
            res.root = rootBuilder.toString();
        }
        else if (typeof objCss === "string" || objCss instanceof String) {
            res.root = rootBuilder.append(objCss.toString()).toString();
        }
        else {
            res.root = rootBuilder.toString();
            for (var key in objCss) {
                res[key] = objCss[key];
            }
        }
    };
    Question.prototype.getCssType = function () {
        return this.getType();
    };
    Object.defineProperty(Question.prototype, "renderCssRoot", {
        get: function () {
            return this.cssClasses.root || undefined;
        },
        enumerable: false,
        configurable: true
    });
    Question.prototype.calcPaddingLeft = function () {
        return this.getIndentSize(this.indent);
    };
    Question.prototype.calcPaddingRight = function () {
        return this.getIndentSize(this.rightIndent);
    };
    Question.prototype.getIndentSize = function (indent) {
        if (indent < 1 || !this.getSurvey() || !this.cssClasses || !this.cssClasses.indent)
            return "";
        return indent * this.cssClasses.indent + "px";
    };
    /**
     * Moves focus to the input field of this question.
     * @param onError Pass `true` if you want to focus an input field with the first validation error. Default value: `false` (focuses the first input field). Applies to question types with multiple input fields.
     */
    Question.prototype.focus = function (onError, scrollIfVisible) {
        var _this = this;
        if (onError === void 0) { onError = false; }
        if (this.isDesignMode || !this.isVisible || !this.survey)
            return;
        var page = this.page;
        var shouldChangePage = !!page && this.survey.activePage !== page;
        if (shouldChangePage) {
            this.survey.focusQuestionByInstance(this, onError);
        }
        else {
            if (!!this.survey) {
                this.expandAllParents();
                var scrollOptions = this.survey["isSmoothScrollEnabled"] ? { behavior: "smooth" } : undefined;
                this.survey.scrollElementToTop(this, this, null, this.id, scrollIfVisible, scrollOptions, undefined, function () {
                    _this.focusInputElement(onError);
                });
            }
            else {
                this.focusInputElement(onError);
            }
        }
    };
    Question.prototype.focusInputElement = function (onError) {
        var _a;
        var id = !onError ? this.getFirstInputElementId() : this.getFirstErrorInputElementId();
        var surveyRoot = (_a = this.survey) === null || _a === void 0 ? void 0 : _a.rootElement;
        if (survey_element_SurveyElement.FocusElement(id, false, surveyRoot)) {
            this.fireCallback(this.focusCallback);
        }
    };
    Object.defineProperty(Question.prototype, "isValidateVisitedEmptyFields", {
        get: function () {
            return this.supportEmptyValidation() && !!this.survey && this.survey.getValidateVisitedEmptyFields() && this.isEmpty();
        },
        enumerable: false,
        configurable: true
    });
    Question.prototype.supportEmptyValidation = function () { return false; };
    Question.prototype.onBlur = function (event) {
        this.onBlurCore(event);
    };
    Question.prototype.onFocus = function (event) {
        this.onFocusCore(event);
    };
    Question.prototype.onBlurCore = function (event) {
        if (this.isFocusEmpty && this.isEmpty()) {
            this.validate(true);
        }
    };
    Question.prototype.onFocusCore = function (event) {
        this.isFocusEmpty = this.isValidateVisitedEmptyFields;
    };
    Question.prototype.expandAllParents = function () {
        this.expandAllParentsCore(this);
    };
    Question.prototype.expandAllParentsCore = function (element) {
        if (!element)
            return;
        if (element.isCollapsed) {
            element.expand();
        }
        this.expandAllParentsCore(element.parent);
        this.expandAllParentsCore(element.parentQuestion);
    };
    Question.prototype.focusIn = function () {
        if (!this.survey || this.isDisposed || this.isContainer)
            return;
        this.survey.whenQuestionFocusIn(this);
    };
    Question.prototype.fireCallback = function (callback) {
        if (callback)
            callback();
    };
    Question.prototype.getOthersMaxLength = function () {
        if (!this.survey)
            return null;
        return this.survey.maxOthersLength > 0 ? this.survey.maxOthersLength : null;
    };
    Question.prototype.onCreating = function () { };
    Question.prototype.getFirstQuestionToFocus = function (withError) {
        return this.hasInput && (!withError || this.currentErrorCount > 0) ? this : null;
    };
    Question.prototype.getFirstInputElementId = function () {
        return this.inputId;
    };
    Question.prototype.getFirstErrorInputElementId = function () {
        return this.getFirstInputElementId();
    };
    Question.prototype.getProcessedTextValue = function (textValue) {
        var name = textValue.name.toLocaleLowerCase();
        textValue.isExists =
            Object.keys(Question.TextPreprocessorValuesMap).indexOf(name) !== -1 ||
                this[textValue.name] !== undefined;
        textValue.value = this[Question.TextPreprocessorValuesMap[name] || textValue.name];
    };
    Question.prototype.supportComment = function () {
        var prop = this.getPropertyByName("showCommentArea");
        return !prop || prop.visible;
    };
    Question.prototype.supportOther = function () {
        return false;
    };
    Object.defineProperty(Question.prototype, "isRequired", {
        /**
         * Makes the question required. If a respondent skips a required question, the survey displays a validation error.
         * @see requiredIf
         * @see [Data Validation](https://surveyjs.io/form-library/documentation/data-validation)
         */
        get: function () {
            return this.getPropertyValue("isRequired");
        },
        set: function (val) {
            this.setPropertyValue("isRequired", val);
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(Question.prototype, "requiredIf", {
        /**
         * A Boolean expression. If it evaluates to `true`, this question becomes required.
         *
         * A survey parses and runs all expressions on startup. If any values used in the expression change, the survey re-evaluates it.
         *
         * Refer to the following help topic for more information: [Conditional Visibility](https://surveyjs.io/form-library/documentation/design-survey-conditional-logic#conditional-visibility).
         * @see isRequired
         */
        get: function () {
            return this.getPropertyValue("requiredIf", "");
        },
        set: function (val) {
            this.setPropertyValue("requiredIf", val);
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(Question.prototype, "showCommentArea", {
        /**
         * Specifies whether to display a comment area. Incompatible with the `showOtherItem` property.
         * @see comment
         * @see commentText
         * @see showOtherItem
         */
        get: function () {
            return this.getPropertyValue("showCommentArea", false);
        },
        set: function (val) {
            if (!this.supportComment())
                return;
            this.setPropertyValue("showCommentArea", val);
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(Question.prototype, "hasComment", {
        get: function () {
            return this.showCommentArea;
        },
        set: function (val) {
            this.showCommentArea = val;
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(Question.prototype, "id", {
        /**
         * A value to assign to the `id` attribute of the rendered HTML element. A default `id` is generated automatically.
         */
        get: function () {
            return this.getPropertyValue("id");
        },
        set: function (val) {
            this.setPropertyValue("id", val);
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(Question.prototype, "ariaTitleId", {
        get: function () {
            return this.id + "_ariaTitle";
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(Question.prototype, "ariaDescriptionId", {
        get: function () {
            return this.id + "_ariaDescription";
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(Question.prototype, "commentId", {
        get: function () {
            return this.id + "_comment";
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(Question.prototype, "showOtherItem", {
        /**
         * Specifies whether to display the "Other" choice item. Incompatible with the `showCommentArea` property.
         *
         * @see otherText
         * @see otherItem
         * @see otherErrorText
         * @see showCommentArea
         * @see [settings.specialChoicesOrder](https://surveyjs.io/form-library/documentation/api-reference/settings#specialChoicesOrder)
         */
        get: function () {
            return this.getPropertyValue("showOtherItem", false);
        },
        set: function (val) {
            if (!this.supportOther() || this.showOtherItem == val)
                return;
            this.setPropertyValue("showOtherItem", val);
            this.hasOtherChanged();
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(Question.prototype, "hasOther", {
        get: function () {
            return this.showOtherItem;
        },
        set: function (val) {
            this.showOtherItem = val;
        },
        enumerable: false,
        configurable: true
    });
    Question.prototype.hasOtherChanged = function () { };
    Object.defineProperty(Question.prototype, "requireUpdateCommentValue", {
        get: function () {
            return this.hasComment || this.hasOther;
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(Question.prototype, "isReadOnly", {
        get: function () {
            var isParentReadOnly = !!this.parent && this.parent.isReadOnly;
            var isPareQuestionReadOnly = !!this.parentQuestion && this.parentQuestion.isReadOnly;
            var isSurveyReadOnly = !!this.survey && this.survey.isDisplayMode;
            var callbackVal = !!this.readOnlyCallback && this.readOnlyCallback();
            return this.readOnly || isParentReadOnly || isSurveyReadOnly || isPareQuestionReadOnly || callbackVal;
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(Question.prototype, "isInputReadOnly", {
        get: function () {
            if (this.forceIsInputReadOnly !== undefined) {
                return this.forceIsInputReadOnly;
            }
            return this.isReadOnly || this.isDesignModeV2;
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(Question.prototype, "renderedInputReadOnly", {
        get: function () {
            return this.isInputReadOnly ? "" : undefined;
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(Question.prototype, "renderedInputDisabled", {
        get: function () {
            return this.isInputReadOnly ? "" : undefined;
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(Question.prototype, "isReadOnlyAttr", {
        get: function () {
            return this.isReadOnly;
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(Question.prototype, "isDisabledAttr", {
        get: function () {
            return this.isDesignModeV2 || (!!this.readOnlyCallback && this.readOnlyCallback());
        },
        enumerable: false,
        configurable: true
    });
    Question.prototype.onReadOnlyChanged = function () {
        this.setPropertyValue("isInputReadOnly", this.isInputReadOnly);
        _super.prototype.onReadOnlyChanged.call(this);
        if (this.isReadOnly) {
            this.clearErrors();
        }
        this.updateQuestionCss();
        this.resetRenderedCommentPlaceholder();
    };
    Object.defineProperty(Question.prototype, "enableIf", {
        /**
         * A Boolean expression. If it evaluates to `false`, this question becomes read-only.
         *
         * A survey parses and runs all expressions on startup. If any values used in the expression change, the survey re-evaluates it.
         *
         * Refer to the following help topic for more information: [Conditional Visibility](https://surveyjs.io/form-library/documentation/design-survey-conditional-logic#conditional-visibility).
         *
         * [View Demo](https://surveyjs.io/form-library/examples/how-to-conditionally-make-input-field-read-only/ (linkStyle))
         * @see readOnly
         * @see isReadOnly
         */
        get: function () {
            return this.getPropertyValue("enableIf", "");
        },
        set: function (val) {
            this.setPropertyValue("enableIf", val);
        },
        enumerable: false,
        configurable: true
    });
    Question.prototype.surveyChoiceItemVisibilityChange = function () { };
    Question.prototype.runCondition = function (values, properties) {
        if (this.isDesignMode)
            return;
        if (!properties)
            properties = {};
        properties["question"] = this;
        this.runConditionCore(values, properties);
        if (!this.isValueChangedDirectly && (!this.isClearValueOnHidden || this.isVisibleInSurvey)) {
            this.defaultValueRunner = this.getDefaultRunner(this.defaultValueRunner, this.defaultValueExpression);
            this.runDefaultValueExpression(this.defaultValueRunner, values, properties);
        }
    };
    Object.defineProperty(Question.prototype, "isInDesignMode", {
        get: function () {
            return !this.isContentElement && this.isDesignMode;
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(Question.prototype, "isInDesignModeV2", {
        get: function () {
            return !this.isContentElement && this.isDesignModeV2;
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(Question.prototype, "no", {
        /**
         * A question number or letter (depends on the `questionStartIndex` property of the question container (panel, page, or survey)).
         *
         * When the question number, title, or the entire question is invisible, this property returns an empty string.
         * @see SurveyModel.questionStartIndex
         * @see hideNumber
         * @see titleLocation
         * @see visibleIf
         */
        get: function () {
            return this.getPropertyValue("no");
        },
        enumerable: false,
        configurable: true
    });
    Question.prototype.calcNo = function () {
        var _a;
        if (!this.hasTitle || this.hideNumber)
            return "";
        var parentIndex = (_a = this.parent) === null || _a === void 0 ? void 0 : _a.visibleIndex;
        var no = helpers_Helpers.getNumberByIndex(this.visibleIndex, this.getStartIndex(), parentIndex);
        if (!!this.survey) {
            no = this.survey.getUpdatedQuestionNo(this, no);
        }
        return no;
    };
    Question.prototype.getStartIndex = function () {
        if (!!this.parent)
            return this.parent.getQuestionStartIndex();
        if (!!this.survey)
            return this.survey.questionStartIndex;
        return "";
    };
    Question.prototype.onSurveyLoad = function () {
        this.isCustomWidgetRequested = false;
        this.fireCallback(this.surveyLoadCallback);
        this.updateValueWithDefaults();
        if (this.isEmpty()) {
            this.initDataFromSurvey();
        }
    };
    Question.prototype.onSetData = function () {
        _super.prototype.onSetData.call(this);
        if (!this.isDesignMode && !!this.survey && !this.isLoadingFromJson) {
            this.initDataFromSurvey();
            this.onSurveyValueChanged(this.value);
            this.updateValueWithDefaults();
            this.updateIsAnswered();
        }
    };
    Question.prototype.initDataFromSurvey = function () {
        if (!!this.data) {
            var val = this.data.getValue(this.getValueName());
            if (!helpers_Helpers.isValueEmpty(val) || !this.isLoadingFromJson) {
                this.updateValueFromSurvey(val);
            }
            this.initCommentFromSurvey();
        }
    };
    Question.prototype.initCommentFromSurvey = function () {
        if (!!this.data && this.requireUpdateCommentValue) {
            this.updateCommentFromSurvey(this.data.getComment(this.getValueName()));
        }
        else {
            this.updateCommentFromSurvey("");
        }
    };
    Question.prototype.runExpression = function (expression) {
        if (!this.survey || !expression)
            return undefined;
        return this.survey.runExpression(expression);
    };
    Object.defineProperty(Question.prototype, "commentAreaRows", {
        get: function () {
            return this.survey && this.survey.commentAreaRows;
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(Question.prototype, "autoGrowComment", {
        get: function () {
            return this.survey && this.survey.autoGrowComment;
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(Question.prototype, "allowResizeComment", {
        get: function () {
            return this.survey && this.survey.allowResizeComment;
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(Question.prototype, "questionValue", {
        get: function () {
            return this.getPropertyValueWithoutDefault("value");
        },
        set: function (val) {
            this.setPropertyValue("value", val);
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(Question.prototype, "questionComment", {
        get: function () {
            return this.getPropertyValueWithoutDefault("comment");
        },
        set: function (val) {
            this.setPropertyValue("comment", val);
            this.fireCallback(this.commentChangedCallback);
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(Question.prototype, "isValueArray", {
        get: function () { return false; },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(Question.prototype, "value", {
        /**
         * Gets or sets the question value.
         *
         * The following table illustrates how the value type depends on the question type:
         *
         * | Question type | Value type(s) |
         * | ------------- | ------------- |
         * | Checkboxes | <code>Array&lt;string &#124; number&gt;</code> |
         * | Dropdown | `string` \| `number` |
         * | Dynamic Matrix | `Array<object>` |
         * | Dynamic Panel | `Array<object>` |
         * | Expression | `string` \| `number` \| `boolean` |
         * | File Upload | `File` \| `Array<File>` |
         * | HTML | (no value) |
         * | Image | (no value) |
         * | Image Picker | <code>Array&lt;string &#124; number&gt;</code> |
         * | Long Text | `string` |
         * | Multi-Select Dropdown | `object` |
         * | Multi-Select Matrix | `object` |
         * | Multiple Textboxes | `Array<string>` |
         * | Panel | (no value) |
         * | Radio Button Group | `string` \| `number` |
         * | Ranking | <code>Array&lt;string &#124; number&gt;</code> |
         * | Rating Scale | `number` \| `string` |
         * | Signature | `string` (base64-encoded image) |
         * | Single-Line Input | `string` \| `number` \| `Date` |
         * | Single-Select Matrix | `object` |
         * | Yes/No (Boolean) | `boolean` \| `string` |
         */
        get: function () {
            return this.getValueCore();
        },
        set: function (newValue) {
            this.setNewValue(newValue);
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(Question.prototype, "hasFilteredValue", {
        get: function () { return false; },
        enumerable: false,
        configurable: true
    });
    Question.prototype.getFilteredValue = function () { return this.value; };
    Question.prototype.getFilteredName = function () { return this.getValueName(); };
    Object.defineProperty(Question.prototype, "valueForSurvey", {
        get: function () {
            return this.valueForSurveyCore(this.value);
        },
        enumerable: false,
        configurable: true
    });
    Question.prototype.valueForSurveyCore = function (val) {
        if (!!this.valueToDataCallback) {
            return this.valueToDataCallback(val);
        }
        return val;
    };
    Question.prototype.valueFromDataCore = function (val) {
        if (!!this.valueFromDataCallback) {
            return this.valueFromDataCallback(val);
        }
        return val;
    };
    /**
     * Sets the question's `value` and `comment` properties to `undefined`.
     * @see value
     * @see comment
     */
    Question.prototype.clearValue = function (keepComment) {
        if (this.value !== undefined) {
            this.value = undefined;
        }
        if (!!this.comment && keepComment !== true) {
            this.comment = undefined;
        }
        this.setValueChangedDirectly(false);
    };
    Question.prototype.clearValueOnly = function () {
        this.clearValue(true);
    };
    Question.prototype.unbindValue = function () {
        this.clearValue();
    };
    Question.prototype.createValueCopy = function () {
        return this.getUnbindValue(this.value);
    };
    Question.prototype.initDataUI = function () { };
    Question.prototype.getUnbindValue = function (value) {
        if (this.isValueSurveyElement(value))
            return value;
        return helpers_Helpers.getUnbindValue(value);
    };
    Question.prototype.isValueSurveyElement = function (val) {
        if (!val)
            return false;
        if (Array.isArray(val))
            return val.length > 0 ? this.isValueSurveyElement(val[0]) : false;
        return !!val.getType && !!val.onPropertyChanged;
    };
    Question.prototype.canClearValueAsInvisible = function (reason) {
        if (reason === "onHiddenContainer" && !this.isParentVisible)
            return true;
        if (this.isVisibleInSurvey)
            return false;
        if (!!this.page && this.page.isStartPage)
            return false;
        if (!this.survey)
            return true;
        return !this.survey.hasVisibleQuestionByValueName(this.getValueName());
    };
    Object.defineProperty(Question.prototype, "isParentVisible", {
        /**
         * Returns `true` if a parent element (page or panel) is visible.
         */
        get: function () {
            if (this.parentQuestion && !this.parentQuestion.isVisible)
                return false;
            var parent = this.parent;
            while (parent) {
                if (!parent.isVisible)
                    return false;
                parent = parent.parent;
            }
            return true;
        },
        enumerable: false,
        configurable: true
    });
    Question.prototype.clearValueIfInvisible = function (reason) {
        if (reason === void 0) { reason = "onHidden"; }
        var clearIf = this.getClearIfInvisible();
        if (clearIf === "none")
            return;
        if (reason === "onHidden" && clearIf === "onComplete")
            return;
        if (reason === "onHiddenContainer" && clearIf !== reason)
            return;
        this.clearValueIfInvisibleCore(reason);
    };
    Question.prototype.clearValueIfInvisibleCore = function (reason) {
        if (this.canClearValueAsInvisible(reason)) {
            this.clearValue();
        }
    };
    Object.defineProperty(Question.prototype, "clearIfInvisible", {
        /**
         * Specifies when to clear the question value if the question becomes invisible.
         *
         * Possible values:
         *
         * - `"default"` (default) - Inherits the setting from the Survey's [`clearInvisibleValues`](https://surveyjs.io/form-library/documentation/surveymodel#clearInvisibleValues) property.
         * - `"onHidden"` - Clears the value when the question becomes invisible. If a question is invisible on startup and has an initial value, this value will be cleared when the survey is complete.
         * - `"onHiddenContainer"` - Clears the value when the question or its container (page or panel) becomes invisible. If a question is invisible on startup and has an initial value, this value will be cleared when the survey is complete.
         * - `"onComplete"` - Clears the value when the survey is complete.
         * - `"none"` - Never clears the value of an invisible question.
         * @see SurveyModel.clearInvisibleValues
         * @see visible
         * @see SurveyModel.onComplete
         */
        get: function () {
            return this.getPropertyValue("clearIfInvisible");
        },
        set: function (val) {
            this.setPropertyValue("clearIfInvisible", val);
        },
        enumerable: false,
        configurable: true
    });
    Question.prototype.getClearIfInvisible = function () {
        var res = this.clearIfInvisible;
        if (!!this.survey)
            return this.survey.getQuestionClearIfInvisible(res);
        return res !== "default" ? res : "onComplete";
    };
    Object.defineProperty(Question.prototype, "displayValue", {
        get: function () {
            if (this.isLoadingFromJson)
                return "";
            return this.getDisplayValue(true);
        },
        enumerable: false,
        configurable: true
    });
    /**
     * Returns a display text that corresponds to the question value. For example, if you call this method for a Dropdown question, it returns an item text instead of an item value.
     * @param keysAsText Applies when the question value is an object (in Matrix, Multiple Text, and similar questions). Pass `true` if not only values in the object should be display texts, but also keys. Default value: `false`.
     * @param value Specify this parameter to get a display text for a specific value, not for the current question value. If the question value is an object, this parameter should be a similar object.
     */
    Question.prototype.getDisplayValue = function (keysAsText, value) {
        if (value === void 0) { value = undefined; }
        var res = this.calcDisplayValue(keysAsText, value);
        if (this.survey) {
            res = this.survey.getQuestionDisplayValue(this, res);
        }
        return !!this.displayValueCallback ? this.displayValueCallback(res) : res;
    };
    Question.prototype.calcDisplayValue = function (keysAsText, value) {
        if (value === void 0) { value = undefined; }
        if (this.customWidget) {
            var res = this.customWidget.getDisplayValue(this, value);
            if (res)
                return res;
        }
        value = value == undefined ? this.createValueCopy() : value;
        if (this.isValueEmpty(value, !this.allowSpaceAsAnswer))
            return this.getDisplayValueEmpty();
        return this.getDisplayValueCore(keysAsText, value);
    };
    Question.prototype.getDisplayValueCore = function (keyAsText, value) {
        return value;
    };
    Question.prototype.getDisplayValueEmpty = function () {
        return "";
    };
    Object.defineProperty(Question.prototype, "defaultValue", {
        /**
         * A default value for the question. Ignored for question types that cannot have a [value](https://surveyjs.io/form-library/documentation/question#value) (for example, HTML).
         *
         * The default value is used as a question value in the following cases:
         *
         * - While the survey is being loaded from JSON.
         * - The question is just added to the survey and does not yet have an answer.
         * - The respondent left the answer empty.
         * @see defaultValueExpression
         */
        get: function () {
            return this.getPropertyValue("defaultValue");
        },
        set: function (val) {
            if (this.isValueExpression(val)) {
                this.defaultValueExpression = val.substring(1);
                return;
            }
            this.setPropertyValue("defaultValue", this.convertDefaultValue(val));
            this.updateValueWithDefaults();
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(Question.prototype, "defaultValueExpression", {
        /**
         * An expression used to calculate the [defaultValue](https://surveyjs.io/form-library/documentation/question#defaultValue).
         *
         * This expression applies until the question [value](https://surveyjs.io/form-library/documentation/question#value) is specified by an end user or programmatically.
         *
         * An expression can reference other questions as follows:
         *
         * - `{other_question_name}`
         * - `{panel.other_question_name}` (to access questions inside the same dynamic panel)
         * - `{row.other_question_name}` (to access questions inside the same dynamic matrix or multi-column dropdown)
         *
         * An expression can also include built-in and custom functions for advanced calculations. For example, if the `defaultValue` should be today's date, set the `defaultValueExpression` to `"today()"`, and the corresponding built-in function will be executed each time the survey is loaded. Refer to the following help topic for more information: [Built-In Functions](https://surveyjs.io/form-library/documentation/design-survey-conditional-logic#built-in-functions).
         *
         * [View Demo](https://surveyjs.io/form-library/examples/specify-default-question-value-dynamically (linkStyle))
         * @see defaultValue
         * @see setValueExpression
         */
        get: function () {
            return this.getPropertyValue("defaultValueExpression");
        },
        set: function (val) {
            this.setPropertyValue("defaultValueExpression", val);
            this.defaultValueRunner = undefined;
            this.updateValueWithDefaults();
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(Question.prototype, "resetValueIf", {
        /**
         * A Boolean [expression](https://surveyjs.io/form-library/documentation/design-survey/conditional-logic#expressions). If it evaluates to `true`, the question value is reset to [default](#defaultValue).
         *
         * A survey parses and runs all expressions on startup. If any values used in the expression change, the survey re-evaluates it.
         *
         * [View Demo](https://surveyjs.io/form-library/examples/set-question-value-dynamically/ (linkStyle))
         * @see setValueIf
         */
        get: function () {
            return this.getPropertyValue("resetValueIf");
        },
        set: function (val) {
            this.setPropertyValue("resetValueIf", val);
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(Question.prototype, "setValueIf", {
        /**
         * A Boolean [expression](https://surveyjs.io/form-library/documentation/design-survey/conditional-logic#expressions). If it evaluates to `true`, the question value is set to a value calculated using the [`setValueExpression`](#setValueExpression).
         *
         * A survey parses and runs all expressions on startup. If any values used in the expression change, the survey re-evaluates it.
         *
         * [View Demo](https://surveyjs.io/form-library/examples/set-question-value-dynamically/ (linkStyle))
         * @see resetValueIf
         */
        get: function () {
            return this.getPropertyValue("setValueIf");
        },
        set: function (val) {
            this.setPropertyValue("setValueIf", val);
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(Question.prototype, "setValueExpression", {
        /**
         * An [expression](https://surveyjs.io/form-library/documentation/design-survey/conditional-logic#expressions) used to calculate the question value.
         *
         * You can use `setValueExpression` as a standalone property or in conjunction with the [`setValueIf`](#setValueIf) expression, in which case the calculated question value applies only when `setValueIf` evaluates to `true`.
         *
         * [View Demo](https://surveyjs.io/form-library/examples/set-question-value-dynamically/ (linkStyle))
         * @see defaultValueExpression
         * @see resetValueIf
         */
        get: function () {
            return this.getPropertyValue("setValueExpression");
        },
        set: function (val) {
            this.setPropertyValue("setValueExpression", val);
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(Question.prototype, "resizeStyle", {
        get: function () {
            return this.allowResizeComment ? "both" : "none";
        },
        enumerable: false,
        configurable: true
    });
    /**
     * Returns the question value as an object in which the question name, title, value, and other parameters are stored as individual properties.
     *
     * If the question can have more than one value (Matrix, Multiple Text), the object enables the `isNode` flag and stores information about these values in the `data` property. Refer to the following help topic for more information: [Access Full Survey Results](https://surveyjs.io/form-library/documentation/handle-survey-results-access#access-full-survey-results).
     *
     * Pass an object with the `includeEmpty` property set to `false` if you want to skip empty answers.
     */
    Question.prototype.getPlainData = function (options) {
        var _this = this;
        if (!options) {
            options = { includeEmpty: true, includeQuestionTypes: false };
        }
        if (options.includeEmpty || !this.isEmpty()) {
            var questionPlainData = {
                name: this.name,
                title: this.locTitle.renderedHtml,
                value: this.value,
                displayValue: this.displayValue,
                isNode: false,
                getString: function (val) {
                    return typeof val === "object" ? JSON.stringify(val) : val;
                },
            };
            if (options.includeQuestionTypes === true) {
                questionPlainData.questionType = this.getType();
            }
            (options.calculations || []).forEach(function (calculation) {
                questionPlainData[calculation.propertyName] = _this.getPlainDataCalculatedValue(calculation.propertyName);
            });
            if (this.hasComment) {
                questionPlainData.isNode = true;
                questionPlainData.data = [
                    {
                        name: 0,
                        isComment: true,
                        title: "Comment",
                        value: settings.commentSuffix,
                        displayValue: this.comment,
                        getString: function (val) {
                            return typeof val === "object" ? JSON.stringify(val) : val;
                        },
                        isNode: false,
                    },
                ];
            }
            return questionPlainData;
        }
        return undefined;
    };
    Question.prototype.getPlainDataCalculatedValue = function (propName) {
        return this[propName];
    };
    Object.defineProperty(Question.prototype, "correctAnswer", {
        /**
         * A correct answer to this question. Specify this property if you want to [create a quiz](https://surveyjs.io/form-library/documentation/design-survey-create-a-quiz).
         * @see SurveyModel.getCorrectAnswerCount
         * @see SurveyModel.getIncorrectAnswerCount
         */
        get: function () {
            return this.getPropertyValue("correctAnswer");
        },
        set: function (val) {
            this.setPropertyValue("correctAnswer", this.convertDefaultValue(val));
        },
        enumerable: false,
        configurable: true
    });
    Question.prototype.convertDefaultValue = function (val) {
        return val;
    };
    Object.defineProperty(Question.prototype, "quizQuestionCount", {
        /**
         * The number of quiz questions. A question counts if it is visible, has an input field, and specifies `correctAnswer`.
         * @see [Create a Quiz](https://surveyjs.io/form-library/documentation/design-survey-create-a-quiz)
         * @see correctAnswer
         * @see SurveyModel.getQuizQuestions
         */
        get: function () {
            if (this.isVisible &&
                this.hasInput &&
                !this.isValueEmpty(this.correctAnswer))
                return this.getQuizQuestionCount();
            return 0;
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(Question.prototype, "correctAnswerCount", {
        get: function () {
            if (!this.isEmpty() && !this.isValueEmpty(this.correctAnswer))
                return this.getCorrectAnswerCount();
            return 0;
        },
        enumerable: false,
        configurable: true
    });
    Question.prototype.getQuizQuestionCount = function () {
        return 1;
    };
    Question.prototype.getCorrectAnswerCount = function () {
        return this.checkIfAnswerCorrect() ? 1 : 0;
    };
    Question.prototype.checkIfAnswerCorrect = function () {
        var isEqual = helpers_Helpers.isTwoValueEquals(this.value, this.correctAnswer, this.getAnswerCorrectIgnoreOrder(), settings.comparator.caseSensitive, true);
        var correct = isEqual ? 1 : 0;
        var incorrect = this.quizQuestionCount - correct;
        var options = {
            result: isEqual,
            correctAnswers: correct,
            correctAnswerCount: correct,
            incorrectAnswers: incorrect,
            incorrectAnswerCount: incorrect,
        };
        if (!!this.survey) {
            this.survey.onCorrectQuestionAnswer(this, options);
        }
        return options.result;
    };
    Question.prototype.getAnswerCorrectIgnoreOrder = function () { return false; };
    /**
    * Returns `true` if a question answer matches the `correctAnswer` property value.
    *
    * [View Demo](https://surveyjs.io/form-library/examples/create-a-scored-quiz (linkStyle))
    * @see correctAnswer
    * @see SurveyModel.getQuizQuestions
    */
    Question.prototype.isAnswerCorrect = function () {
        return this.correctAnswerCount == this.quizQuestionCount;
    };
    Question.prototype.updateValueWithDefaults = function () {
        if (this.isLoadingFromJson || (!this.isDesignMode && this.isDefaultValueEmpty()))
            return;
        if (!this.isDesignMode && !this.isEmpty())
            return;
        if (this.isEmpty() && this.isDefaultValueEmpty())
            return;
        if (this.isClearValueOnHidden && !this.isVisible)
            return;
        if (this.isDesignMode && this.isContentElement && this.isDefaultValueEmpty())
            return;
        this.setDefaultValue();
    };
    Object.defineProperty(Question.prototype, "isValueDefault", {
        get: function () {
            return !this.isEmpty() && (this.isTwoValueEquals(this.defaultValue, this.value) || !this.isValueChangedDirectly && !!this.defaultValueExpression);
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(Question.prototype, "isClearValueOnHidden", {
        get: function () {
            var clearIf = this.getClearIfInvisible();
            if (clearIf === "none" || clearIf === "onComplete")
                return false;
            return clearIf === "onHidden" || clearIf === "onHiddenContainer";
        },
        enumerable: false,
        configurable: true
    });
    Question.prototype.getQuestionFromArray = function (name, index) {
        return null;
    };
    Question.prototype.getDefaultValue = function () {
        return this.defaultValue;
    };
    Question.prototype.isDefaultValueEmpty = function () {
        return !this.defaultValueExpression && this.isValueEmpty(this.defaultValue, !this.allowSpaceAsAnswer);
    };
    Question.prototype.getDefaultRunner = function (runner, expression) {
        if (!runner && !!expression) {
            runner = this.createExpressionRunner(expression);
        }
        if (!!runner) {
            runner.expression = expression;
        }
        return runner;
    };
    Question.prototype.setDefaultValue = function () {
        var _this = this;
        this.setDefaultValueCore(function (val) {
            if (!_this.isTwoValueEquals(_this.value, val)) {
                _this.value = val;
            }
        });
    };
    Question.prototype.setDefaultValueCore = function (func) {
        this.defaultValueRunner = this.getDefaultRunner(this.defaultValueRunner, this.defaultValueExpression);
        this.setValueAndRunExpression(this.defaultValueRunner, this.getUnbindValue(this.defaultValue), function (val) { return func(val); });
    };
    Question.prototype.isValueExpression = function (val) {
        return !!val && typeof val == "string" && val.length > 0 && val[0] == "=";
    };
    Question.prototype.setValueAndRunExpression = function (runner, defaultValue, setFunc, values, properties) {
        var _this = this;
        if (values === void 0) { values = null; }
        if (properties === void 0) { properties = null; }
        var func = function (val) {
            _this.runExpressionSetValueCore(val, setFunc);
        };
        if (!this.runDefaultValueExpression(runner, values, properties, func)) {
            func(defaultValue);
        }
    };
    Question.prototype.convertFuncValuetoQuestionValue = function (val) {
        return helpers_Helpers.convertValToQuestionVal(val);
    };
    Question.prototype.runExpressionSetValueCore = function (val, setFunc) {
        setFunc(this.convertFuncValuetoQuestionValue(val));
    };
    Question.prototype.runExpressionSetValue = function (val) {
        var _this = this;
        this.runExpressionSetValueCore(val, function (val) {
            if (!_this.isTwoValueEquals(_this.value, val)) {
                _this.startSetValueOnExpression();
                _this.value = val;
                _this.finishSetValueOnExpression();
            }
        });
    };
    Question.prototype.startSetValueOnExpression = function () {
        var _a;
        (_a = this.survey) === null || _a === void 0 ? void 0 : _a.startSetValueOnExpression();
    };
    Question.prototype.finishSetValueOnExpression = function () {
        var _a;
        (_a = this.survey) === null || _a === void 0 ? void 0 : _a.finishSetValueOnExpression();
    };
    Question.prototype.runDefaultValueExpression = function (runner, values, properties, setFunc) {
        var _this = this;
        if (values === void 0) { values = null; }
        if (properties === void 0) { properties = null; }
        if (!runner || !this.data)
            return false;
        if (!setFunc) {
            setFunc = function (val) {
                _this.runExpressionSetValue(val);
            };
        }
        if (!values)
            values = this.defaultValueExpression ? this.data.getFilteredValues() : {};
        if (!properties)
            properties = this.defaultValueExpression ? this.data.getFilteredProperties() : {};
        if (!!runner && runner.canRun) {
            runner.onRunComplete = function (res) {
                if (res == undefined)
                    res = _this.defaultValue;
                _this.isChangingViaDefaultValue = true;
                setFunc(res);
                _this.isChangingViaDefaultValue = false;
            };
            runner.run(values, properties);
        }
        return true;
    };
    Object.defineProperty(Question.prototype, "comment", {
        /**
         * A comment to the selected question value. Enable the `showCommentArea` property to allow users to leave comments.
         * @see showCommentArea
         * @see commentText
         */
        get: function () {
            return this.getQuestionComment();
        },
        set: function (newValue) {
            if (!!newValue) {
                var trimmedValue = newValue.toString().trim();
                if (trimmedValue !== newValue) {
                    newValue = trimmedValue;
                    if (newValue === this.comment) {
                        this.setPropertyValueDirectly("comment", newValue);
                    }
                }
            }
            if (this.comment == newValue)
                return;
            this.setQuestionComment(newValue);
            this.updateCommentElements();
        },
        enumerable: false,
        configurable: true
    });
    Question.prototype.getCommentAreaCss = function (isOther) {
        if (isOther === void 0) { isOther = false; }
        return new CssClassBuilder()
            .append("form-group", isOther)
            .append(this.cssClasses.formGroup, !isOther)
            .append(this.cssClasses.commentArea)
            .toString();
    };
    Question.prototype.getQuestionComment = function () {
        return this.questionComment;
    };
    Question.prototype.setQuestionComment = function (newValue) {
        this.setNewComment(newValue);
    };
    /**
     * Returns `true` if the question value is an empty string, array, or object or if it equals `undefined` or `null`.
     */
    Question.prototype.isEmpty = function () {
        return this.isValueEmpty(this.value, !this.allowSpaceAsAnswer);
    };
    Object.defineProperty(Question.prototype, "isAnswered", {
        get: function () {
            return this.getPropertyValue("isAnswered") || false;
        },
        set: function (val) {
            this.setPropertyValue("isAnswered", val);
        },
        enumerable: false,
        configurable: true
    });
    Question.prototype.updateIsAnswered = function () {
        var oldVal = this.isAnswered;
        this.setPropertyValue("isAnswered", this.getIsAnswered());
        if (oldVal !== this.isAnswered) {
            this.updateQuestionCss();
        }
    };
    Question.prototype.getIsAnswered = function () {
        return !this.isEmpty();
    };
    Object.defineProperty(Question.prototype, "validators", {
        /**
         * Question validators.
         *
         * [Data Validation](https://surveyjs.io/form-library/documentation/data-validation (linkStyle))
         */
        get: function () {
            return this.getPropertyValue("validators");
        },
        set: function (val) {
            this.setPropertyValue("validators", val);
        },
        enumerable: false,
        configurable: true
    });
    Question.prototype.getValidators = function () {
        return this.validators;
    };
    Question.prototype.getSupportedValidators = function () {
        var res = [];
        var className = this.getType();
        while (!!className) {
            var classValidators = settings.supportedValidators[className];
            if (!!classValidators) {
                for (var i = classValidators.length - 1; i >= 0; i--) {
                    res.splice(0, 0, classValidators[i]);
                }
            }
            var classInfo = Serializer.findClass(className);
            className = classInfo.parentName;
        }
        return res;
    };
    Question.prototype.addConditionObjectsByContext = function (objects, context) {
        objects.push({
            name: this.getFilteredName(),
            text: this.processedTitle,
            question: this,
        });
    };
    /**
     * Returns an array of questions nested within the current question. Use this method to obtain questions within [Multiple Text](https://surveyjs.io/form-library/documentation/api-reference/multiple-text-entry-question-model), [Dynamic Panel](https://surveyjs.io/form-library/documentation/api-reference/dynamic-panel-model), and [Matrix](https://surveyjs.io/form-library/documentation/api-reference/matrix-table-question-model)-like questions.
     * @param visibleOnly A Boolean value that specifies whether to include only visible nested questions.
     * @returns An array of nested questions.
     */
    Question.prototype.getNestedQuestions = function (visibleOnly) {
        if (visibleOnly === void 0) { visibleOnly = false; }
        var res = [];
        this.collectNestedQuestions(res, visibleOnly);
        if (res.length === 1 && res[0] === this)
            return [];
        return res;
    };
    Question.prototype.collectNestedQuestions = function (questions, visibleOnly) {
        if (visibleOnly === void 0) { visibleOnly = false; }
        if (visibleOnly && !this.isVisible)
            return;
        this.collectNestedQuestionsCore(questions, visibleOnly);
    };
    Question.prototype.collectNestedQuestionsCore = function (questions, visibleOnly) {
        questions.push(this);
    };
    Question.prototype.getConditionJson = function (operator, path) {
        if (operator === void 0) { operator = null; }
        if (path === void 0) { path = null; }
        var json = new jsonobject_JsonObject().toJsonObject(this);
        json["type"] = this.getType();
        return json;
    };
    Question.prototype.hasErrors = function (fireCallback, rec) {
        if (fireCallback === void 0) { fireCallback = true; }
        if (rec === void 0) { rec = null; }
        var errors = this.checkForErrors(!!rec && rec.isOnValueChanged === true, fireCallback);
        if (fireCallback) {
            if (!!this.survey) {
                this.survey.beforeSettingQuestionErrors(this, errors);
            }
            this.errors = errors;
            if (this.errors !== errors) {
                this.errors.forEach(function (er) { return er.locText.strChanged(); });
            }
        }
        this.updateContainsErrors();
        if (this.isCollapsed && rec && fireCallback && errors.length > 0) {
            this.expand();
        }
        return errors.length > 0;
    };
    /**
     * Validates this question and returns `false` if the validation fails.
     * @param fireCallback *(Optional)* Pass `false` if you do not want to show validation errors in the UI.
     * @see [Data Validation](https://surveyjs.io/form-library/documentation/data-validation)
     */
    Question.prototype.validate = function (fireCallback, rec) {
        if (fireCallback === void 0) { fireCallback = true; }
        if (rec === void 0) { rec = null; }
        if (!!rec && rec.isOnValueChanged) {
            if (!!this.parent) {
                this.parent.validateContainerOnly();
            }
        }
        return !this.hasErrors(fireCallback, rec);
    };
    Object.defineProperty(Question.prototype, "currentErrorCount", {
        get: function () {
            return this.errors.length;
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(Question.prototype, "requiredText", {
        /**
         * Returns a character or text string that indicates a required question.
         * @see SurveyModel.requiredText
         * @see isRequired
         */
        get: function () {
            return this.survey != null && this.isRequired
                ? this.survey.requiredText
                : "";
        },
        enumerable: false,
        configurable: true
    });
    Question.prototype.addError = function (error) {
        if (!error)
            return;
        var newError = null;
        if (typeof error === "string" || error instanceof String) {
            newError = this.addCustomError(error);
        }
        else {
            newError = error;
        }
        this.errors.push(newError);
    };
    Question.prototype.addCustomError = function (error) {
        return new CustomError(error, this.survey);
    };
    Question.prototype.removeError = function (error) {
        if (!error)
            return false;
        var errors = this.errors;
        var index = errors.indexOf(error);
        if (index !== -1)
            errors.splice(index, 1);
        return index !== -1;
    };
    Question.prototype.checkForErrors = function (isOnValueChanged, fireCallback) {
        var qErrors = new Array();
        if (this.isVisible && this.canCollectErrors()) {
            this.collectErrors(qErrors, isOnValueChanged, fireCallback);
        }
        return qErrors;
    };
    Question.prototype.canCollectErrors = function () {
        return !this.isReadOnly || settings.readOnly.enableValidation;
    };
    Question.prototype.collectErrors = function (qErrors, isOnValueChanged, fireCallback) {
        this.onCheckForErrors(qErrors, isOnValueChanged, fireCallback);
        if (qErrors.length > 0 || !this.canRunValidators(isOnValueChanged))
            return;
        var errors = this.runValidators();
        if (errors.length > 0) {
            //validators may change the question value.
            qErrors.length = 0;
            for (var i = 0; i < errors.length; i++) {
                qErrors.push(errors[i]);
            }
        }
        if (this.survey && qErrors.length == 0) {
            var error = this.fireSurveyValidation();
            if (error) {
                qErrors.push(error);
            }
        }
    };
    Question.prototype.canRunValidators = function (isOnValueChanged) {
        return true;
    };
    Question.prototype.fireSurveyValidation = function () {
        if (this.validateValueCallback)
            return this.validateValueCallback();
        return this.survey ? this.survey.validateQuestion(this) : null;
    };
    Question.prototype.onCheckForErrors = function (errors, isOnValueChanged, fireCallback) {
        var _this = this;
        if ((!isOnValueChanged || this.isOldAnswered) && this.hasRequiredError()) {
            var err = new AnswerRequiredError(this.requiredErrorText, this);
            err.onUpdateErrorTextCallback = function (err) { err.text = _this.requiredErrorText; };
            errors.push(err);
        }
        if (!this.isEmpty() && this.customWidget) {
            var text = this.customWidget.validate(this);
            if (!!text) {
                errors.push(this.addCustomError(text));
            }
        }
    };
    Question.prototype.hasRequiredError = function () {
        return this.isRequired && this.isEmpty();
    };
    Object.defineProperty(Question.prototype, "isRunningValidators", {
        get: function () {
            return this.getIsRunningValidators();
        },
        enumerable: false,
        configurable: true
    });
    Question.prototype.getIsRunningValidators = function () {
        return this.isRunningValidatorsValue;
    };
    Question.prototype.runValidators = function () {
        var _this = this;
        if (!!this.validatorRunner) {
            this.validatorRunner.onAsyncCompleted = null;
        }
        this.validatorRunner = new ValidatorRunner();
        this.isRunningValidatorsValue = true;
        this.validatorRunner.onAsyncCompleted = function (errors) {
            _this.doOnAsyncCompleted(errors);
        };
        return this.validatorRunner.run(this);
    };
    Question.prototype.doOnAsyncCompleted = function (errors) {
        for (var i = 0; i < errors.length; i++) {
            this.errors.push(errors[i]);
        }
        this.isRunningValidatorsValue = false;
        this.raiseOnCompletedAsyncValidators();
    };
    Question.prototype.raiseOnCompletedAsyncValidators = function () {
        if (!!this.onCompletedAsyncValidators && !this.isRunningValidators) {
            this.onCompletedAsyncValidators(this.getAllErrors().length > 0);
            this.onCompletedAsyncValidators = null;
        }
    };
    Question.prototype.setNewValue = function (newValue) {
        if (this.isNewValueEqualsToValue(newValue))
            return;
        if (!this.checkIsValueCorrect(newValue))
            return;
        this.isOldAnswered = this.isAnswered;
        this.isSettingQuestionValue = true;
        this.setNewValueInData(newValue);
        this.allowNotifyValueChanged && this.onValueChanged();
        this.isSettingQuestionValue = false;
        if (this.isAnswered !== this.isOldAnswered) {
            this.updateQuestionCss();
        }
        this.isOldAnswered = undefined;
        if (this.parent) {
            this.parent.onQuestionValueChanged(this);
        }
    };
    Question.prototype.checkIsValueCorrect = function (val) {
        var res = this.isValueEmpty(val, !this.allowSpaceAsAnswer) || this.isNewValueCorrect(val);
        if (!res) {
            ConsoleWarnings.inCorrectQuestionValue(this.name, val);
        }
        return res;
    };
    Question.prototype.isNewValueCorrect = function (val) {
        return true;
    };
    Question.prototype.isNewValueEqualsToValue = function (newValue) {
        var val = this.value;
        if (!this.isTwoValueEquals(newValue, val, false, false))
            return false;
        var isObj = newValue === val && !!val && (Array.isArray(val) || typeof val === "object");
        return !isObj;
    };
    Question.prototype.isTextValue = function () {
        return false;
    };
    Question.prototype.getIsInputTextUpdate = function () {
        return !!this.survey ? this.survey.isUpdateValueTextOnTyping : false;
    };
    Object.defineProperty(Question.prototype, "requireStrictCompare", {
        get: function () { return false; },
        enumerable: false,
        configurable: true
    });
    Question.prototype.getDataLocNotification = function () {
        return this.isInputTextUpdate ? "text" : false;
    };
    Object.defineProperty(Question.prototype, "isInputTextUpdate", {
        get: function () {
            return this.getIsInputTextUpdate() && this.isTextValue();
        },
        enumerable: false,
        configurable: true
    });
    Question.prototype.setNewValueInData = function (newValue) {
        newValue = this.valueToData(newValue);
        if (!this.isValueChangedInSurvey) {
            this.setValueCore(newValue);
        }
    };
    Question.prototype.getValueCore = function () {
        return this.questionValue;
    };
    Question.prototype.setValueCore = function (newValue) {
        this.setQuestionValue(newValue);
        if (this.data != null && this.canSetValueToSurvey()) {
            newValue = this.valueForSurvey;
            this.data.setValue(this.getValueName(), newValue, this.getDataLocNotification(), this.allowNotifyValueChanged, this.name);
        }
        this.isMouseDown = false;
    };
    Question.prototype.canSetValueToSurvey = function () {
        return true;
    };
    Question.prototype.valueFromData = function (val) { return val; };
    Question.prototype.valueToData = function (val) { return val; };
    Question.prototype.convertToCorrectValue = function (val) { return val; };
    Question.prototype.onValueChanged = function () { };
    Question.prototype.onMouseDown = function () {
        this.isMouseDown = true;
    };
    Question.prototype.setNewComment = function (newValue) {
        if (this.questionComment === newValue)
            return;
        this.questionComment = newValue;
        this.setCommentIntoData(newValue);
    };
    Question.prototype.setCommentIntoData = function (newValue) {
        if (this.data != null) {
            this.data.setComment(this.getValueName(), newValue, this.getIsInputTextUpdate() ? "text" : false);
        }
    };
    Question.prototype.getValidName = function (name) {
        return makeNameValid(name);
    };
    //IQuestion
    Question.prototype.updateValueFromSurvey = function (newValue, clearData) {
        var _this = this;
        if (clearData === void 0) { clearData = false; }
        newValue = this.getUnbindValue(newValue);
        newValue = this.valueFromDataCore(newValue);
        if (!this.checkIsValueCorrect(newValue))
            return;
        var isEmpty = this.isValueEmpty(newValue);
        if (!isEmpty && this.defaultValueExpression) {
            this.setDefaultValueCore(function (val) {
                _this.updateValueFromSurveyCore(newValue, _this.isTwoValueEquals(newValue, val));
            });
        }
        else {
            this.updateValueFromSurveyCore(newValue, this.data !== this.getSurvey());
            if (clearData && isEmpty) {
                this.isValueChangedDirectly = false;
            }
        }
        this.updateDependedQuestions();
        this.updateIsAnswered();
    };
    Question.prototype.updateValueFromSurveyCore = function (newValue, viaDefaultVal) {
        this.isChangingViaDefaultValue = viaDefaultVal;
        this.setQuestionValue(this.valueFromData(newValue));
        this.isChangingViaDefaultValue = false;
    };
    Question.prototype.updateCommentFromSurvey = function (newValue) {
        this.questionComment = newValue;
    };
    Question.prototype.onChangeQuestionValue = function (newValue) { };
    Question.prototype.setValueChangedDirectly = function (val) {
        this.isValueChangedDirectly = val;
        if (!!this.setValueChangedDirectlyCallback) {
            this.setValueChangedDirectlyCallback(val);
        }
    };
    Question.prototype.setQuestionValue = function (newValue, updateIsAnswered) {
        if (updateIsAnswered === void 0) { updateIsAnswered = true; }
        newValue = this.convertToCorrectValue(newValue);
        var isEqual = this.isTwoValueEquals(this.questionValue, newValue);
        if (!isEqual && !this.isChangingViaDefaultValue && !this.isParentChangingViaDefaultValue) {
            this.setValueChangedDirectly(true);
        }
        this.questionValue = newValue;
        if (!isEqual) {
            this.onChangeQuestionValue(newValue);
        }
        !isEqual && this.allowNotifyValueChanged &&
            this.fireCallback(this.valueChangedCallback);
        if (updateIsAnswered)
            this.updateIsAnswered();
    };
    Object.defineProperty(Question.prototype, "isParentChangingViaDefaultValue", {
        get: function () {
            var _a;
            return ((_a = this.data) === null || _a === void 0 ? void 0 : _a.isChangingViaDefaultValue) === true;
        },
        enumerable: false,
        configurable: true
    });
    Question.prototype.onSurveyValueChanged = function (newValue) { };
    Question.prototype.setVisibleIndex = function (val) {
        if (!this.isVisible ||
            (!this.hasTitle && !settings.numbering.includeQuestionsWithHiddenTitle) ||
            (this.hideNumber && !settings.numbering.includeQuestionsWithHiddenNumber)) {
            val = -1;
        }
        this.setPropertyValue("visibleIndex", val);
        this.setPropertyValue("no", this.calcNo());
        return val < 0 ? 0 : 1;
    };
    Question.prototype.removeElement = function (element) {
        return false;
    };
    Question.prototype.supportGoNextPageAutomatic = function () {
        return false;
    };
    Question.prototype.supportGoNextPageError = function () {
        return true;
    };
    /**
     * Removes values that cannot be assigned to this question, for example, choices unlisted in the `choices` array.
     *
     * Call this method after you assign new question values in code to ensure that they are acceptable.
     *
     * > This method does not remove values that fail validation. Call the `validate()` method to validate newly assigned values.
     *
     * @see validate
     */
    Question.prototype.clearIncorrectValues = function () { };
    Question.prototype.clearOnDeletingContainer = function () { };
    /**
     * Empties the `errors` array.
     * @see errors
     */
    Question.prototype.clearErrors = function () {
        this.errors = [];
    };
    Question.prototype.clearUnusedValues = function () { };
    Question.prototype.onAnyValueChanged = function (name, questionName) { };
    Question.prototype.checkBindings = function (valueName, value) {
        if (this.bindings.isEmpty() || !this.data)
            return;
        var props = this.bindings.getPropertiesByValueName(valueName);
        for (var i = 0; i < props.length; i++) {
            var propName = props[i];
            if (this.isValueEmpty(value) && helpers_Helpers.isNumber(this[propName])) {
                value = 0;
            }
            this.updateBindingProp(propName, value);
        }
    };
    Question.prototype.updateBindingProp = function (propName, value) {
        this[propName] = value;
    };
    Question.prototype.getComponentName = function () {
        return RendererFactory.Instance.getRendererByQuestion(this);
    };
    Question.prototype.isDefaultRendering = function () {
        return (!!this.customWidget ||
            this.getComponentName() === "default");
    };
    //ISurveyErrorOwner
    Question.prototype.getErrorCustomText = function (text, error) {
        if (!!this.survey)
            return this.survey.getSurveyErrorCustomText(this, text, error);
        return text;
    };
    //IValidatorOwner
    Question.prototype.getValidatorTitle = function () {
        return null;
    };
    Object.defineProperty(Question.prototype, "validatedValue", {
        get: function () {
            return this.value;
        },
        set: function (val) {
            this.value = val;
        },
        enumerable: false,
        configurable: true
    });
    Question.prototype.getAllValues = function () {
        return !!this.data ? this.data.getAllValues() : null;
    };
    Question.prototype.processPopupVisiblilityChanged = function (popupModel, visible) {
        this.survey.processPopupVisiblityChanged(this, popupModel, visible);
    };
    Question.prototype.processOpenDropdownMenu = function (options) {
        this.survey.processOpenDropdownMenu(this, options);
    };
    Question.prototype.onTextKeyDownHandler = function (event) {
        if (event.keyCode === 13) {
            this.survey.questionEditFinishCallback(this, event);
        }
    };
    Question.prototype.transformToMobileView = function () { };
    Question.prototype.transformToDesktopView = function () { };
    Question.prototype.needResponsiveWidth = function () {
        return false;
    };
    //responsiveness methods
    Question.prototype.supportResponsiveness = function () {
        return false;
    };
    Question.prototype.needResponsiveness = function () {
        return this.supportResponsiveness() && this.isDefaultV2Theme && !this.isDesignMode;
    };
    Question.prototype.checkForResponsiveness = function (el) {
        var _this = this;
        if (this.needResponsiveness()) {
            if (this.isCollapsed) {
                var onStateChanged = function () {
                    if (_this.isExpanded) {
                        _this.initResponsiveness(el);
                        _this.unregisterPropertyChangedHandlers(["state"], "for-responsiveness");
                    }
                };
                this.registerPropertyChangedHandlers(["state"], onStateChanged, "for-responsiveness");
            }
            else {
                this.initResponsiveness(el);
            }
        }
    };
    Question.prototype.getObservedElementSelector = function () {
        return ".sd-scrollable-container";
    };
    Question.prototype.onMobileChanged = function () {
        this.onMobileChangedCallback && this.onMobileChangedCallback();
    };
    Question.prototype.triggerResponsiveness = function (hard) {
        if (hard === void 0) { hard = true; }
        if (this.triggerResponsivenessCallback) {
            this.triggerResponsivenessCallback(hard);
        }
    };
    Question.prototype.initResponsiveness = function (el) {
        var _this = this;
        this.destroyResizeObserver();
        if (!!el && this.isDefaultRendering()) {
            var scrollableSelector_1 = this.getObservedElementSelector();
            if (!scrollableSelector_1)
                return;
            var defaultRootEl = el.querySelector(scrollableSelector_1);
            if (!defaultRootEl)
                return;
            var isProcessed_1 = false;
            var requiredWidth_1 = undefined;
            this.triggerResponsivenessCallback = function (hard) {
                if (hard) {
                    requiredWidth_1 = undefined;
                    _this.renderAs = "default";
                    isProcessed_1 = false;
                }
                var callback = function () {
                    var rootEl = el.querySelector(scrollableSelector_1);
                    if (!requiredWidth_1 && _this.isDefaultRendering()) {
                        requiredWidth_1 = rootEl.scrollWidth;
                    }
                    if (isProcessed_1 || !isContainerVisible(rootEl)) {
                        isProcessed_1 = false;
                    }
                    else {
                        isProcessed_1 = _this.processResponsiveness(requiredWidth_1, getElementWidth(rootEl));
                    }
                };
                if (hard) {
                    setTimeout(callback, 1);
                }
                else {
                    callback();
                }
            };
            this.resizeObserver = new ResizeObserver(function (entries) {
                DomWindowHelper.requestAnimationFrame(function () {
                    _this.triggerResponsiveness(false);
                });
            });
            this.onMobileChangedCallback = function () {
                setTimeout(function () {
                    var rootEl = el.querySelector(scrollableSelector_1);
                    _this.processResponsiveness(requiredWidth_1, getElementWidth(rootEl));
                }, 0);
            };
            this.resizeObserver.observe(el);
        }
    };
    Question.prototype.getCompactRenderAs = function () {
        return "default";
    };
    Question.prototype.getDesktopRenderAs = function () {
        return "default";
    };
    Question.prototype.onBeforeSetCompactRenderer = function () { };
    Question.prototype.onBeforeSetDesktopRenderer = function () { };
    Question.prototype.processResponsiveness = function (requiredWidth, availableWidth) {
        availableWidth = Math.round(availableWidth);
        if (Math.abs(requiredWidth - availableWidth) > 2) {
            var oldRenderAs = this.renderAs;
            if (requiredWidth > availableWidth) {
                this.onBeforeSetCompactRenderer();
                this.renderAs = this.getCompactRenderAs();
            }
            else {
                this.onBeforeSetDesktopRenderer();
                this.renderAs = this.getDesktopRenderAs();
            }
            return oldRenderAs !== this.renderAs;
        }
        return false;
    };
    Question.prototype.destroyResizeObserver = function () {
        if (!!this.resizeObserver) {
            this.resizeObserver.disconnect();
            this.resizeObserver = undefined;
            this.onMobileChangedCallback = undefined;
            this.triggerResponsivenessCallback = undefined;
            this.renderAs = this.getDesktopRenderAs();
        }
    };
    Question.prototype.dispose = function () {
        _super.prototype.dispose.call(this);
        this.resetDependedQuestions();
        this.destroyResizeObserver();
    };
    Question.prototype.resetDependedQuestions = function () {
        for (var i = 0; i < this.dependedQuestions.length; i++) {
            this.dependedQuestions[i].resetDependedQuestion();
        }
    };
    Object.defineProperty(Question.prototype, "isNewA11yStructure", {
        //a11y
        get: function () {
            return false;
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(Question.prototype, "ariaLabel", {
        get: function () {
            if (this.isNewA11yStructure)
                return null;
            return this.locTitle.renderedHtml;
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(Question.prototype, "ariaRole", {
        get: function () {
            if (this.isNewA11yStructure)
                return null;
            return "textbox";
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(Question.prototype, "ariaRequired", {
        get: function () {
            if (this.isNewA11yStructure)
                return null;
            return this.isRequired ? "true" : "false";
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(Question.prototype, "ariaInvalid", {
        get: function () {
            if (this.isNewA11yStructure)
                return null;
            return this.hasCssError() ? "true" : "false";
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(Question.prototype, "ariaLabelledBy", {
        get: function () {
            if (this.isNewA11yStructure)
                return null;
            if (this.hasTitle) {
                return this.ariaTitleId;
            }
            else {
                return null;
            }
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(Question.prototype, "ariaDescribedBy", {
        get: function () {
            if (this.isNewA11yStructure)
                return null;
            if (this.hasTitle && this.hasDescription) {
                return this.ariaDescriptionId;
            }
            else {
                return null;
            }
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(Question.prototype, "ariaErrormessage", {
        get: function () {
            if (this.isNewA11yStructure)
                return null;
            return this.hasCssError() ? this.id + "_errors" : null;
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(Question.prototype, "a11y_input_ariaRole", {
        //EO a11y
        //new a11y
        get: function () {
            return null;
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(Question.prototype, "a11y_input_ariaRequired", {
        get: function () {
            return this.isRequired ? "true" : "false";
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(Question.prototype, "a11y_input_ariaInvalid", {
        get: function () {
            return this.hasCssError() ? "true" : "false";
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(Question.prototype, "a11y_input_ariaLabel", {
        get: function () {
            if (this.hasTitle && !this.parentQuestion) {
                return null;
            }
            else {
                return this.locTitle.renderedHtml;
            }
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(Question.prototype, "a11y_input_ariaLabelledBy", {
        get: function () {
            if (this.hasTitle && !this.parentQuestion) {
                return this.ariaTitleId;
            }
            else {
                return null;
            }
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(Question.prototype, "a11y_input_ariaDescribedBy", {
        get: function () {
            if (this.hasTitle && !this.parentQuestion && this.hasDescription) {
                return this.ariaDescriptionId;
            }
            else {
                return null;
            }
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(Question.prototype, "a11y_input_ariaErrormessage", {
        get: function () {
            return this.hasCssError() ? this.id + "_errors" : null;
        },
        enumerable: false,
        configurable: true
    });
    Question.TextPreprocessorValuesMap = {
        title: "processedTitle",
        require: "requiredText",
    };
    Question.questionCounter = 100;
    question_decorate([
        jsonobject_property({ defaultValue: false })
    ], Question.prototype, "_isMobile", void 0);
    question_decorate([
        jsonobject_property()
    ], Question.prototype, "forceIsInputReadOnly", void 0);
    question_decorate([
        jsonobject_property()
    ], Question.prototype, "ariaExpanded", void 0);
    question_decorate([
        jsonobject_property({ localizable: true, onSet: function (val, target) { return target.resetRenderedCommentPlaceholder(); } })
    ], Question.prototype, "commentPlaceholder", void 0);
    question_decorate([
        jsonobject_property()
    ], Question.prototype, "renderAs", void 0);
    question_decorate([
        jsonobject_property({ defaultValue: false })
    ], Question.prototype, "inMatrixMode", void 0);
    return Question;
}(survey_element_SurveyElement));

function makeNameValid(str) {
    if (!str)
        return str;
    str = str.trim().replace(/[\{\}]+/g, "");
    while (!!str && str[0] === settings.expressionDisableConversionChar) {
        str = str.substring(1);
    }
    return str;
}
Serializer.addClass("question", [
    { name: "!name", onSettingValue: function (obj, val) { return makeNameValid(val); } },
    {
        name: "state",
        default: "default",
        choices: ["default", "collapsed", "expanded"],
    },
    { name: "visible:switch", default: true, overridingProperty: "visibleIf" },
    { name: "useDisplayValuesInDynamicTexts:boolean", alternativeName: "useDisplayValuesInTitle", default: true, layout: "row" },
    "visibleIf:condition",
    { name: "width" },
    { name: "minWidth", defaultFunc: function () { return settings.minWidth; } },
    { name: "maxWidth", defaultFunc: function () { return settings.maxWidth; } },
    {
        name: "colSpan:number", visible: false,
        onSerializeValue: function (obj) { return obj.getPropertyValue("colSpan"); },
    },
    {
        name: "effectiveColSpan:number", minValue: 1, isSerializable: false,
        visibleIf: function (obj) { return !!obj && !!obj.survey && obj.survey.gridLayoutEnabled; }
    },
    { name: "startWithNewLine:boolean", default: true, layout: "row" },
    { name: "indent:number", default: 0, choices: [0, 1, 2, 3], layout: "row" },
    {
        name: "page",
        isSerializable: false,
        visibleIf: function (obj) {
            var survey = obj ? obj.survey : null;
            return !survey || !survey.pages || survey.pages.length > 1;
        },
        choices: function (obj) {
            var survey = obj ? obj.survey : null;
            return survey
                ? survey.pages.map(function (p) {
                    return { value: p.name, text: p.title };
                })
                : [];
        },
    },
    {
        name: "title:text", serializationProperty: "locTitle", layout: "row", dependsOn: "name",
        onPropertyEditorUpdate: function (obj, editor) {
            if (!!obj && !!editor) {
                editor.placeholder = obj.getDefaultTitle();
            }
        }
    },
    {
        name: "titleLocation",
        default: "default",
        choices: ["default", "top", "bottom", "left", "hidden"],
        layout: "row",
    },
    {
        name: "description:text",
        serializationProperty: "locDescription",
        layout: "row",
    },
    {
        name: "descriptionLocation",
        default: "default",
        choices: ["default", "underInput", "underTitle"],
    },
    {
        name: "hideNumber:boolean",
        dependsOn: "titleLocation",
        visibleIf: function (obj) {
            if (!obj) {
                return true;
            }
            if (obj.titleLocation === "hidden") {
                return false;
            }
            var parent = obj ? obj.parent : null;
            var numberingAllowedByParent = !parent || parent.showQuestionNumbers !== "off";
            if (!numberingAllowedByParent) {
                return false;
            }
            var survey = obj ? obj.survey : null;
            return (!survey ||
                survey.showQuestionNumbers !== "off" ||
                (!!parent && parent.showQuestionNumbers === "onpanel"));
        },
    },
    { name: "valueName", onSettingValue: function (obj, val) { return makeNameValid(val); } },
    "enableIf:condition",
    "resetValueIf:condition",
    "setValueIf:condition",
    "setValueExpression:expression",
    "defaultValue:value",
    {
        name: "defaultValueExpression:expression",
        category: "logic",
    },
    "correctAnswer:value",
    {
        name: "clearIfInvisible",
        default: "default",
        choices: ["default", "none", "onComplete", "onHidden", "onHiddenContainer"],
    },
    { name: "isRequired:switch", overridingProperty: "requiredIf" },
    "requiredIf:condition",
    {
        name: "requiredErrorText:text",
        serializationProperty: "locRequiredErrorText",
    },
    { name: "errorLocation", default: "default", choices: ["default", "top", "bottom"] },
    { name: "readOnly:switch", overridingProperty: "enableIf" },
    {
        name: "validators:validators",
        baseClassName: "surveyvalidator",
        classNamePart: "validator",
    },
    {
        name: "bindings:bindings",
        serializationProperty: "bindings",
        visibleIf: function (obj) {
            return obj.bindings.getNames().length > 0;
        },
    },
    { name: "renderAs", default: "default", visible: false },
    { name: "showCommentArea", visible: false, default: false, alternativeName: "hasComment", category: "general" },
    {
        name: "commentText",
        dependsOn: "showCommentArea",
        visibleIf: function (obj) {
            return obj.showCommentArea;
        },
        serializationProperty: "locCommentText"
    },
    {
        name: "commentPlaceholder",
        alternativeName: "commentPlaceHolder",
        serializationProperty: "locCommentPlaceholder",
        dependsOn: "showCommentArea",
        visibleIf: function (obj) {
            return obj.hasComment;
        }
    }
]);
Serializer.addAlterNativeClassName("question", "questionbase");

// CONCATENATED MODULE: ./packages/survey-core/src/itemvalue.ts
var itemvalue_extends = (undefined && undefined.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var itemvalue_decorate = (undefined && undefined.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};








/**
 * Array of ItemValue is used in checkbox, dropdown and radiogroup choices, matrix columns and rows.
 * It has two main properties: value and text. If text is empty, value is used for displaying.
 * The text property is localizable and support markdown.
 */
var itemvalue_ItemValue = /** @class */ (function (_super) {
    itemvalue_extends(ItemValue, _super);
    function ItemValue(value, text, typeName) {
        if (text === void 0) { text = null; }
        if (typeName === void 0) { typeName = "itemvalue"; }
        var _this = _super.call(this) || this;
        _this.typeName = typeName;
        _this.ownerPropertyName = "";
        _this.locTextValue = new localizablestring_LocalizableString(_this, true, "text");
        _this.locTextValue.onStrChanged = function (oldValue, newValue) {
            if (newValue == _this.value) {
                newValue = undefined;
            }
            _this.propertyValueChanged("text", oldValue, newValue);
        };
        _this.locTextValue.onGetTextCallback = function (txt) {
            return txt
                ? txt
                : !helpers_Helpers.isValueEmpty(_this.value)
                    ? _this.value.toString()
                    : null;
        };
        if (text)
            _this.locText.text = text;
        if (!!value && typeof value === "object") {
            _this.setData(value, true);
        }
        else {
            _this.setValue(value, true);
        }
        if (_this.getType() != "itemvalue") {
            CustomPropertiesCollection.createProperties(_this);
        }
        _this.data = _this;
        _this.onCreating();
        return _this;
    }
    ItemValue.prototype.getMarkdownHtml = function (text, name) {
        return !!this.locOwner ? this.locOwner.getMarkdownHtml(text, name) : undefined;
    };
    ItemValue.prototype.getRenderer = function (name) {
        return !!this.locOwner ? this.locOwner.getRenderer(name) : null;
    };
    ItemValue.prototype.getRendererContext = function (locStr) {
        return !!this.locOwner ? this.locOwner.getRendererContext(locStr) : locStr;
    };
    ItemValue.prototype.getProcessedText = function (text) {
        return this.locOwner ? this.locOwner.getProcessedText(text) : text;
    };
    Object.defineProperty(ItemValue, "Separator", {
        get: function () {
            return settings.itemValueSeparator;
        },
        set: function (val) {
            settings.itemValueSeparator = val;
        },
        enumerable: false,
        configurable: true
    });
    /**
     * Resets the input array and fills it with values from the values array
     */
    ItemValue.setData = function (items, values, type) {
        items.length = 0;
        for (var i = 0; i < values.length; i++) {
            var value = values[i];
            var itemType = !!value && typeof value.getType === "function" ? value.getType() : (type !== null && type !== void 0 ? type : "itemvalue");
            var item = Serializer.createClass(itemType);
            item.setData(value);
            if (!!value.originalItem) {
                item.originalItem = value.originalItem;
            }
            items.push(item);
        }
    };
    ItemValue.getData = function (items) {
        var result = [];
        for (var i = 0; i < items.length; i++) {
            result.push(items[i].getData());
        }
        return result;
    };
    ItemValue.getItemByValue = function (items, val) {
        if (!Array.isArray(items))
            return null;
        var valIsEmpty = helpers_Helpers.isValueEmpty(val);
        for (var i = 0; i < items.length; i++) {
            if (valIsEmpty && helpers_Helpers.isValueEmpty(items[i].value))
                return items[i];
            if (helpers_Helpers.isTwoValueEquals(items[i].value, val, false, true, false))
                return items[i];
        }
        return null;
    };
    ItemValue.getTextOrHtmlByValue = function (items, val) {
        var item = ItemValue.getItemByValue(items, val);
        return item !== null ? item.locText.textOrHtml : "";
    };
    ItemValue.locStrsChanged = function (items) {
        for (var i = 0; i < items.length; i++) {
            items[i].locStrsChanged();
        }
    };
    ItemValue.runConditionsForItems = function (items, filteredItems, runner, values, properties, useItemExpression, onItemCallBack) {
        if (useItemExpression === void 0) { useItemExpression = true; }
        return ItemValue.runConditionsForItemsCore(items, filteredItems, runner, values, properties, true, useItemExpression, onItemCallBack);
    };
    ItemValue.runEnabledConditionsForItems = function (items, runner, values, properties, onItemCallBack) {
        return ItemValue.runConditionsForItemsCore(items, null, runner, values, properties, false, true, onItemCallBack);
    };
    ItemValue.runConditionsForItemsCore = function (items, filteredItems, runner, values, properties, isVisible, useItemExpression, onItemCallBack) {
        if (useItemExpression === void 0) { useItemExpression = true; }
        if (!values) {
            values = {};
        }
        var itemValue = values["item"];
        var choiceValue = values["choice"];
        var hasChanded = false;
        for (var i = 0; i < items.length; i++) {
            var item = items[i];
            values["item"] = item.value;
            values["choice"] = item.value;
            var itemRunner = useItemExpression && !!item.getConditionRunner
                ? item.getConditionRunner(isVisible)
                : false;
            if (!itemRunner) {
                itemRunner = runner;
            }
            var newValue = true;
            if (itemRunner) {
                newValue = itemRunner.run(values, properties);
            }
            if (!!onItemCallBack) {
                newValue = onItemCallBack(item, newValue);
            }
            if (!!filteredItems && newValue) {
                filteredItems.push(item);
            }
            var oldValue = isVisible ? item.isVisible : item.isEnabled;
            if (newValue != oldValue) {
                hasChanded = true;
                if (isVisible) {
                    if (!!item.setIsVisible)
                        item.setIsVisible(newValue);
                }
                else {
                    if (!!item.setIsEnabled)
                        item.setIsEnabled(newValue);
                }
            }
        }
        if (itemValue) {
            values["item"] = itemValue;
        }
        else {
            delete values["item"];
        }
        if (choiceValue) {
            values["choice"] = choiceValue;
        }
        else {
            delete values["choice"];
        }
        return hasChanded;
    };
    ItemValue.prototype.onCreating = function () { };
    ItemValue.prototype.getType = function () {
        return !!this.typeName ? this.typeName : "itemvalue";
    };
    ItemValue.prototype.getSurvey = function (live) {
        if (live === void 0) { live = false; }
        return !!this.locOwner && !!this.locOwner["getSurvey"]
            ? this.locOwner.getSurvey()
            : null;
    };
    ItemValue.prototype.getLocale = function () {
        return !!this.locOwner && this.locOwner.getLocale ? this.locOwner.getLocale() : "";
    };
    Object.defineProperty(ItemValue.prototype, "isInternal", {
        get: function () {
            return this.isGhost === true;
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(ItemValue.prototype, "locText", {
        get: function () {
            return this.locTextValue;
        },
        enumerable: false,
        configurable: true
    });
    ItemValue.prototype.setLocText = function (locText) {
        this.locTextValue = locText;
    };
    Object.defineProperty(ItemValue.prototype, "locOwner", {
        get: function () {
            return this._locOwner;
        },
        set: function (value) {
            this._locOwner = value;
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(ItemValue.prototype, "value", {
        get: function () {
            return this.getPropertyValue("value");
        },
        set: function (newValue) {
            this.setValue(newValue, false);
        },
        enumerable: false,
        configurable: true
    });
    ItemValue.prototype.setValue = function (newValue, newItem) {
        var text = undefined;
        if (!helpers_Helpers.isValueEmpty(newValue)) {
            var str = newValue.toString();
            var index = str.indexOf(settings.itemValueSeparator);
            if (index > -1) {
                newValue = str.slice(0, index);
                text = str.slice(index + 1);
            }
        }
        if (newItem) {
            this.setPropertyValueDirectly("value", newValue);
        }
        else {
            this.setPropertyValue("value", newValue);
        }
        if (!!text) {
            this.text = text;
        }
        this.id = this.value;
    };
    Object.defineProperty(ItemValue.prototype, "hasText", {
        get: function () {
            return this.locText.pureText ? true : false;
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(ItemValue.prototype, "pureText", {
        get: function () {
            return this.locText.pureText;
        },
        set: function (val) {
            this.text = val;
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(ItemValue.prototype, "text", {
        get: function () {
            return this.locText.calculatedText; //TODO: it will be correct to use this.locText.text, however it would require a lot of rewriting in Creator
        },
        set: function (newText) {
            this.locText.text = newText;
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(ItemValue.prototype, "calculatedText", {
        get: function () {
            return this.locText.calculatedText;
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(ItemValue.prototype, "shortcutText", {
        get: function () {
            return this.text;
        },
        enumerable: false,
        configurable: true
    });
    ItemValue.prototype.canSerializeValue = function () {
        var val = this.value;
        if (val === undefined || val === null)
            return false;
        return !Array.isArray(val) && typeof val !== "object";
    };
    ItemValue.prototype.getData = function () {
        var json = this.toJSON();
        if (!!json["value"] && !!json["value"]["pos"]) {
            delete json["value"]["pos"];
        }
        if (helpers_Helpers.isValueEmpty(json.value))
            return json;
        var canSerializeVal = this.canSerializeValue();
        var canSerializeAsContant = !canSerializeVal || !settings.serialization.itemValueSerializeAsObject && !settings.serialization.itemValueSerializeDisplayText;
        if (canSerializeAsContant && Object.keys(json).length == 1)
            return this.value;
        if (settings.serialization.itemValueSerializeDisplayText && json.text === undefined && canSerializeVal) {
            json.text = this.value.toString();
        }
        return json;
    };
    ItemValue.prototype.toJSON = function () {
        var res = {};
        var properties = Serializer.getProperties(this.getType());
        if (!properties || properties.length == 0) {
            properties = Serializer.getProperties("itemvalue");
        }
        var jsoObj = new jsonobject_JsonObject();
        for (var i = 0; i < properties.length; i++) {
            var prop = properties[i];
            if (prop.name === "text" && !this.locText.hasNonDefaultText() &&
                helpers_Helpers.isTwoValueEquals(this.value, this.text, false, true, false))
                continue;
            jsoObj.valueToJson(this, res, prop);
        }
        return res;
    };
    ItemValue.prototype.setData = function (value, isNewItem) {
        if (helpers_Helpers.isValueEmpty(value))
            return;
        if (typeof value.value === "undefined" && typeof value.text !== "undefined" && Object.keys(value).length === 1) {
            value.value = value.text;
        }
        if (typeof value.value !== "undefined") {
            var json = void 0;
            if (typeof value.toJSON === "function") {
                json = value.toJSON();
            }
            else {
                json = value;
            }
            new jsonobject_JsonObject().toObject(json, this);
        }
        else {
            this.setValue(value, isNewItem);
        }
        if (!isNewItem) {
            this.locText.strChanged();
        }
    };
    Object.defineProperty(ItemValue.prototype, "visibleIf", {
        get: function () {
            return this.getPropertyValueWithoutDefault("visibleIf") || "";
        },
        set: function (val) {
            this.setPropertyValue("visibleIf", val);
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(ItemValue.prototype, "enableIf", {
        get: function () {
            return this.getPropertyValueWithoutDefault("enableIf") || "";
        },
        set: function (val) {
            this.setPropertyValue("enableIf", val);
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(ItemValue.prototype, "isVisible", {
        get: function () {
            var res = this.getPropertyValueWithoutDefault("isVisible");
            return res !== undefined ? res : true;
        },
        enumerable: false,
        configurable: true
    });
    ItemValue.prototype.setIsVisible = function (val) {
        this.setPropertyValue("isVisible", val);
    };
    Object.defineProperty(ItemValue.prototype, "isEnabled", {
        get: function () {
            var res = this.getPropertyValueWithoutDefault("isEnabled");
            return res !== undefined ? res : true;
        },
        enumerable: false,
        configurable: true
    });
    ItemValue.prototype.setIsEnabled = function (val) {
        this.setPropertyValue("isEnabled", val);
    };
    ItemValue.prototype.addUsedLocales = function (locales) {
        this.AddLocStringToUsedLocales(this.locTextValue, locales);
    };
    ItemValue.prototype.locStrsChanged = function () {
        _super.prototype.locStrsChanged.call(this);
        this.locText.strChanged();
    };
    ItemValue.prototype.onPropertyValueChanged = function (name, oldValue, newValue) {
        if (name === "value" && !this.hasText) {
            this.locText.strChanged();
        }
        var funcName = "itemValuePropertyChanged";
        if (!this.locOwner || !this.locOwner[funcName])
            return;
        this.locOwner[funcName](this, name, oldValue, newValue);
    };
    ItemValue.prototype.getConditionRunner = function (isVisible) {
        if (isVisible)
            return this.getVisibleConditionRunner();
        return this.getEnableConditionRunner();
    };
    ItemValue.prototype.getVisibleConditionRunner = function () {
        if (!this.visibleIf)
            return null;
        if (!this.visibleConditionRunner)
            this.visibleConditionRunner = new ConditionRunner(this.visibleIf);
        this.visibleConditionRunner.expression = this.visibleIf;
        return this.visibleConditionRunner;
    };
    ItemValue.prototype.getEnableConditionRunner = function () {
        if (!this.enableIf)
            return null;
        if (!this.enableConditionRunner)
            this.enableConditionRunner = new ConditionRunner(this.enableIf);
        this.enableConditionRunner.expression = this.enableIf;
        return this.enableConditionRunner;
    };
    Object.defineProperty(ItemValue.prototype, "selected", {
        get: function () {
            var _this = this;
            var locOwner = this._locOwner;
            if (locOwner instanceof question_Question && locOwner.isItemSelected && this.selectedValue === undefined) {
                this.selectedValue = (new ComputedUpdater(function () { return locOwner.isItemSelected(_this); }));
            }
            return this.selectedValue;
        },
        enumerable: false,
        configurable: true
    });
    ItemValue.prototype.getComponent = function () {
        if (this._locOwner instanceof question_Question) {
            return this.componentValue || this._locOwner.itemComponent;
        }
        return this.componentValue;
    };
    ItemValue.prototype.setComponent = function (val) {
        this.componentValue = val;
    };
    ItemValue.prototype.setRootElement = function (val) {
        this._htmlElement = val;
    };
    ItemValue.prototype.getRootElement = function () {
        return this._htmlElement;
    };
    ItemValue.prototype.getEnabled = function () {
        return this.isEnabled;
    };
    ItemValue.prototype.setEnabled = function (val) {
        this.setIsEnabled(val);
    };
    ItemValue.prototype.getVisible = function () {
        var isVisible = this.isVisible === undefined ? true : this.isVisible;
        var visible = this._visible === undefined ? true : this._visible;
        return isVisible && visible;
    };
    ItemValue.prototype.setVisible = function (val) {
        if (this.visible !== val) {
            this._visible = val;
        }
    };
    ItemValue.prototype.getLocTitle = function () {
        return this.locText;
    };
    ItemValue.prototype.getTitle = function () {
        return this.text;
    };
    ItemValue.prototype.setLocTitle = function (val) { };
    ItemValue.prototype.setTitle = function (val) { };
    itemvalue_decorate([
        jsonobject_property({ defaultValue: true })
    ], ItemValue.prototype, "_visible", void 0);
    itemvalue_decorate([
        jsonobject_property()
    ], ItemValue.prototype, "selectedValue", void 0);
    itemvalue_decorate([
        jsonobject_property()
    ], ItemValue.prototype, "icon", void 0);
    return ItemValue;
}(action_BaseAction));

base_Base.createItemValue = function (source, type) {
    var item = null;
    if (!!type) {
        item = jsonobject_JsonObject.metaData.createClass(type, {});
    }
    else if (typeof source.getType === "function") {
        item = new itemvalue_ItemValue(null, undefined, source.getType());
    }
    else {
        item = new itemvalue_ItemValue(null);
    }
    item.setData(source);
    return item;
};
base_Base.itemValueLocStrChanged = function (arr) {
    itemvalue_ItemValue.locStrsChanged(arr);
};
jsonobject_JsonObjectProperty.getItemValuesDefaultValue = function (val, type) {
    var res = new Array();
    itemvalue_ItemValue.setData(res, Array.isArray(val) ? val : [], type);
    return res;
};
Serializer.addClass("itemvalue", [
    { name: "!value", isUnique: true },
    {
        name: "text",
        serializationProperty: "locText",
    },
    { name: "visibleIf:condition", showMode: "form" },
    {
        name: "enableIf:condition",
        showMode: "form",
        visibleIf: function (obj) {
            return !obj || obj.ownerPropertyName !== "rateValues";
        },
    }
], function (value) { return new itemvalue_ItemValue(value); });

// CONCATENATED MODULE: ./packages/survey-core/src/calculatedValue.ts
var calculatedValue_extends = (undefined && undefined.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();




/**
 * The calculated value is a way to define the variable in Survey Creator.
 * It has two main properties: name and expression. Based on expression the value read-only property is automatically calculated.
 * The name property should be unique though all calculated values.
 * It uses survey.getVariable/seruvey.setVariable functions to get/set its value. The class do not store its value internally.
 * You may set includeIntoResult property to true to store this calculated value into survey result.
 */
var calculatedValue_CalculatedValue = /** @class */ (function (_super) {
    calculatedValue_extends(CalculatedValue, _super);
    function CalculatedValue(name, expression) {
        if (name === void 0) { name = null; }
        if (expression === void 0) { expression = null; }
        var _this = _super.call(this) || this;
        _this.expressionIsRunning = false;
        _this.isCalculated = false;
        if (!!name) {
            _this.name = name;
        }
        if (!!expression) {
            _this.expression = expression;
        }
        return _this;
    }
    CalculatedValue.prototype.setOwner = function (data) {
        this.data = data;
        this.rerunExpression();
    };
    CalculatedValue.prototype.getType = function () {
        return "calculatedvalue";
    };
    CalculatedValue.prototype.getSurvey = function (live) {
        if (live === void 0) { live = false; }
        return !!this.data && !!this.data["getSurvey"]
            ? this.data.getSurvey()
            : null;
    };
    Object.defineProperty(CalculatedValue.prototype, "owner", {
        get: function () {
            return this.data;
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(CalculatedValue.prototype, "name", {
        /**
         * The calculated value name. It should be non empty and unique.
         */
        get: function () {
            return this.getPropertyValue("name") || "";
        },
        set: function (val) {
            this.setPropertyValue("name", val);
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(CalculatedValue.prototype, "includeIntoResult", {
        /**
         * Set this property to true to include the non-empty calculated value into survey result, survey.data property.
         */
        get: function () {
            return this.getPropertyValue("includeIntoResult");
        },
        set: function (val) {
            this.setPropertyValue("includeIntoResult", val);
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(CalculatedValue.prototype, "expression", {
        /**
         * The Expression that used to calculate the value. You may use standard operators like +, -, * and /, squares (). Here is the example of accessing the question value {questionname}.
         * Example: "({quantity} * {price}) * (100 - {discount}) / 100"
         */
        get: function () {
            return this.getPropertyValue("expression") || "";
        },
        set: function (val) {
            this.setPropertyValue("expression", val);
            this.rerunExpression();
        },
        enumerable: false,
        configurable: true
    });
    CalculatedValue.prototype.locCalculation = function () {
        this.expressionIsRunning = true;
    };
    CalculatedValue.prototype.unlocCalculation = function () {
        this.expressionIsRunning = false;
    };
    CalculatedValue.prototype.resetCalculation = function () {
        this.isCalculated = false;
    };
    CalculatedValue.prototype.doCalculation = function (calculatedValues, values, properties) {
        if (this.isCalculated)
            return;
        this.runExpressionCore(calculatedValues, values, properties);
        this.isCalculated = true;
    };
    CalculatedValue.prototype.runExpression = function (values, properties) {
        this.runExpressionCore(null, values, properties);
    };
    Object.defineProperty(CalculatedValue.prototype, "value", {
        get: function () {
            if (!this.data)
                return undefined;
            return this.data.getVariable(this.name);
        },
        enumerable: false,
        configurable: true
    });
    CalculatedValue.prototype.setValue = function (val) {
        if (!this.data)
            return;
        this.data.setVariable(this.name, val);
    };
    Object.defineProperty(CalculatedValue.prototype, "canRunExpression", {
        get: function () {
            return (!!this.data &&
                !this.isLoadingFromJson &&
                !!this.expression &&
                !this.expressionIsRunning &&
                !!this.name);
        },
        enumerable: false,
        configurable: true
    });
    CalculatedValue.prototype.rerunExpression = function () {
        if (!this.canRunExpression)
            return;
        this.runExpression(this.data.getFilteredValues(), this.data.getFilteredProperties());
    };
    CalculatedValue.prototype.runExpressionCore = function (calculatedValues, values, properties) {
        if (!this.canRunExpression)
            return;
        this.ensureExpression(values);
        this.locCalculation();
        if (!!calculatedValues) {
            this.runDependentExpressions(calculatedValues, values, properties);
        }
        this.expressionRunner.run(values, properties);
    };
    CalculatedValue.prototype.runDependentExpressions = function (calculatedValues, values, properties) {
        var variables = this.expressionRunner.getVariables();
        if (!variables)
            return;
        for (var i = 0; i < calculatedValues.length; i++) {
            var calcItem = calculatedValues[i];
            if (calcItem === this || variables.indexOf(calcItem.name) < 0)
                continue;
            calcItem.doCalculation(calculatedValues, values, properties);
            values[calcItem.name] = calcItem.value;
        }
    };
    CalculatedValue.prototype.ensureExpression = function (values) {
        var _this = this;
        if (!!this.expressionRunner)
            return;
        this.expressionRunner = new ExpressionRunner(this.expression);
        this.expressionRunner.onRunComplete = function (newValue) {
            if (!helpers_Helpers.isTwoValueEquals(newValue, _this.value, false, true, false)) {
                _this.setValue(newValue);
            }
            _this.unlocCalculation();
        };
    };
    return CalculatedValue;
}(base_Base));

Serializer.addClass("calculatedvalue", [
    { name: "!name", isUnique: true },
    "expression:expression",
    "includeIntoResult:boolean",
], function () {
    return new calculatedValue_CalculatedValue();
}, "base");

// CONCATENATED MODULE: ./packages/survey-core/src/expressionItems.ts
var expressionItems_extends = (undefined && undefined.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();



/**
 * Base class for HtmlConditionItem and UrlConditionItem classes.
 */
var expressionItems_ExpressionItem = /** @class */ (function (_super) {
    expressionItems_extends(ExpressionItem, _super);
    function ExpressionItem(expression) {
        if (expression === void 0) { expression = null; }
        var _this = _super.call(this) || this;
        _this.expression = expression;
        return _this;
    }
    ExpressionItem.prototype.getType = function () {
        return "expressionitem";
    };
    ExpressionItem.prototype.runCondition = function (values, properties) {
        if (!this.expression)
            return false;
        return new ConditionRunner(this.expression).run(values, properties);
    };
    Object.defineProperty(ExpressionItem.prototype, "expression", {
        /**
         * The expression property. If this expression returns true, then survey will use html property to show on complete page.
         */
        get: function () {
            return this.getPropertyValue("expression", "");
        },
        set: function (val) {
            this.setPropertyValue("expression", val);
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(ExpressionItem.prototype, "locHtml", {
        get: function () {
            return this.getLocalizableString("html");
        },
        enumerable: false,
        configurable: true
    });
    ExpressionItem.prototype.getLocale = function () {
        return !!this.locOwner ? this.locOwner.getLocale() : "";
    };
    ExpressionItem.prototype.getMarkdownHtml = function (text, name) {
        return !!this.locOwner ? this.locOwner.getMarkdownHtml(text, name) : undefined;
    };
    ExpressionItem.prototype.getRenderer = function (name) {
        return !!this.locOwner ? this.locOwner.getRenderer(name) : null;
    };
    ExpressionItem.prototype.getRendererContext = function (locStr) {
        return !!this.locOwner ? this.locOwner.getRendererContext(locStr) : locStr;
    };
    ExpressionItem.prototype.getProcessedText = function (text) {
        return this.locOwner ? this.locOwner.getProcessedText(text) : text;
    };
    ExpressionItem.prototype.getSurvey = function (isLive) {
        if (isLive === void 0) { isLive = false; }
        return this.locOwner;
    };
    return ExpressionItem;
}(base_Base));

/**
 * A class that contains expression and html propeties. It uses in survey.completedHtmlOnCondition array.
 * If the expression returns true then html of this item uses instead of survey.completedHtml property
 * @see SurveyModel.completedHtmlOnCondition
 * @see SurveyModel.completedHtml
 */
var HtmlConditionItem = /** @class */ (function (_super) {
    expressionItems_extends(HtmlConditionItem, _super);
    function HtmlConditionItem(expression, html) {
        if (expression === void 0) { expression = null; }
        if (html === void 0) { html = null; }
        var _this = _super.call(this, expression) || this;
        _this.createLocalizableString("html", _this);
        _this.html = html;
        return _this;
    }
    HtmlConditionItem.prototype.getType = function () {
        return "htmlconditionitem";
    };
    Object.defineProperty(HtmlConditionItem.prototype, "html", {
        /**
         * The html that shows on completed ('Thank you') page. The expression should return true
         * @see expression
         */
        get: function () {
            return this.getLocalizableStringText("html");
        },
        set: function (value) {
            this.setLocalizableStringText("html", value);
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(HtmlConditionItem.prototype, "locHtml", {
        get: function () {
            return this.getLocalizableString("html");
        },
        enumerable: false,
        configurable: true
    });
    return HtmlConditionItem;
}(expressionItems_ExpressionItem));

/**
 * A class that contains expression and url propeties. It uses in survey.navigateToUrlOnCondition array.
 * If the expression returns true then url of this item uses instead of survey.navigateToUrl property
 * @see SurveyModel.navigateToUrl
 */
var UrlConditionItem = /** @class */ (function (_super) {
    expressionItems_extends(UrlConditionItem, _super);
    function UrlConditionItem(expression, url) {
        if (expression === void 0) { expression = null; }
        if (url === void 0) { url = null; }
        var _this = _super.call(this, expression) || this;
        _this.createLocalizableString("url", _this);
        _this.url = url;
        return _this;
    }
    UrlConditionItem.prototype.getType = function () {
        return "urlconditionitem";
    };
    Object.defineProperty(UrlConditionItem.prototype, "url", {
        /**
         * The url that survey navigates to on completing the survey. The expression should return true
         * @see expression
         */
        get: function () {
            return this.getLocalizableStringText("url");
        },
        set: function (value) {
            this.setLocalizableStringText("url", value);
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(UrlConditionItem.prototype, "locUrl", {
        get: function () {
            return this.getLocalizableString("url");
        },
        enumerable: false,
        configurable: true
    });
    return UrlConditionItem;
}(expressionItems_ExpressionItem));

Serializer.addClass("expressionitem", ["expression:condition"], function () {
    return new expressionItems_ExpressionItem();
}, "base");
Serializer.addClass("htmlconditionitem", [{ name: "html:html", serializationProperty: "locHtml" }], function () {
    return new HtmlConditionItem();
}, "expressionitem");
Serializer.addClass("urlconditionitem", [{ name: "url:string", serializationProperty: "locUrl" }], function () {
    return new UrlConditionItem();
}, "expressionitem");

// CONCATENATED MODULE: ./packages/survey-core/src/choicesRestful.ts
var choicesRestful_extends = (undefined && undefined.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();





var XmlParser = /** @class */ (function () {
    function XmlParser() {
        this.parser = new DOMParser();
    }
    XmlParser.prototype.assignValue = function (target, name, value) {
        if (Array.isArray(target[name])) {
            target[name].push(value);
        }
        else if (target[name] !== undefined) {
            target[name] = [target[name]].concat(value);
        }
        else if (typeof value === "object" &&
            Object.keys(value).length === 1 &&
            Object.keys(value)[0] === name) {
            target[name] = value[name];
        }
        else {
            target[name] = value;
        }
    };
    XmlParser.prototype.xml2Json = function (xmlNode, result) {
        if (xmlNode.children && xmlNode.children.length > 0) {
            for (var i = 0; i < xmlNode.children.length; i++) {
                var childNode = xmlNode.children[i];
                var childObject = {};
                this.xml2Json(childNode, childObject);
                this.assignValue(result, childNode.nodeName, childObject);
            }
        }
        else {
            this.assignValue(result, xmlNode.nodeName, xmlNode.textContent);
        }
    };
    XmlParser.prototype.parseXmlString = function (xmlString) {
        var xmlRoot = this.parser.parseFromString(xmlString, "text/xml");
        var json = {};
        this.xml2Json(xmlRoot, json);
        return json;
    };
    return XmlParser;
}());
/**
 * Configures access to a RESTful service that returns choices for [Checkbox](https://surveyjs.io/Examples/Library?id=questiontype-checkbox), [Dropdown](https://surveyjs.io/Examples/Library?id=questiontype-dropdown), [Radiogroup](https://surveyjs.io/Examples/Library?id=questiontype-radiogroup), and other multiple-choice question types.
 *
 * Use the following properties to configure this object:
 *
 * ```js
 * {
 *   url: "http://...", // A RESTful service's URL.
 *   valueName: "value", // Specifies which field contains choice values.
 *   titleName: "title", // Specifies which field contains display texts for choice values.
 *   imageLinkName: "imageUrl", // Specifies which field contains image URLs. Used in Image Picker questions.
 *   // Path to the array of choices. Specify `path` only if the array of choices is nested within the object returned by the service.
 *   // The following path separators are allowed: semicolon `;`, comma `,`.
 *   path: "myNestedArray"
 * }
 * ```
 *
 * Typically, you should assign this object to a question's [`choicesByUrl`](https://surveyjs.io/Documentation/Library?id=QuestionSelectBase#choicesByUrl) property. You can also specify additional application-wide settings using the [`settings.web`](https://surveyjs.io/form-library/documentation/api-reference/settings#web) object.
 */
var choicesRestful_ChoicesRestful = /** @class */ (function (_super) {
    choicesRestful_extends(ChoicesRestful, _super);
    function ChoicesRestful() {
        var _this = _super.call(this) || this;
        _this.lastObjHash = "";
        _this.isRunningValue = false;
        _this.processedUrl = "";
        _this.processedPath = "";
        _this.isUsingCacheFromUrl = undefined;
        _this.error = null;
        _this.createItemValue = function (value) {
            return new itemvalue_ItemValue(value);
        };
        _this.registerPropertyChangedHandlers(["url"], function () {
            if (_this.owner)
                _this.owner.setPropertyValue("isUsingRestful", !!_this.url);
        });
        return _this;
    }
    Object.defineProperty(ChoicesRestful, "EncodeParameters", {
        get: function () {
            return settings.web.encodeUrlParams;
        },
        set: function (val) {
            settings.web.encodeUrlParams = val;
        },
        enumerable: false,
        configurable: true
    });
    ChoicesRestful.clearCache = function () {
        ChoicesRestful.itemsResult = {};
        ChoicesRestful.sendingSameRequests = {};
    };
    ChoicesRestful.addSameRequest = function (obj) {
        if (!obj.isUsingCache)
            return false;
        var hash = obj.objHash;
        var res = ChoicesRestful.sendingSameRequests[hash];
        if (!res) {
            ChoicesRestful.sendingSameRequests[obj.objHash] = [];
            return false;
        }
        res.push(obj);
        obj.isRunningValue = true;
        return true;
    };
    ChoicesRestful.unregisterSameRequests = function (obj, items) {
        if (!obj.isUsingCache)
            return;
        var res = ChoicesRestful.sendingSameRequests[obj.objHash];
        delete ChoicesRestful.sendingSameRequests[obj.objHash];
        if (!res)
            return;
        for (var i = 0; i < res.length; i++) {
            res[i].isRunningValue = false;
            if (!!res[i].getResultCallback) {
                res[i].getResultCallback(items);
            }
        }
    };
    Object.defineProperty(ChoicesRestful, "onBeforeSendRequest", {
        get: function () {
            return settings.web.onBeforeRequestChoices;
        },
        set: function (val) {
            settings.web.onBeforeRequestChoices = val;
        },
        enumerable: false,
        configurable: true
    });
    ChoicesRestful.getCachedItemsResult = function (obj) {
        var hash = obj.objHash;
        var res = ChoicesRestful.itemsResult[hash];
        if (!res)
            return false;
        if (obj.getResultCallback) {
            obj.getResultCallback(res);
        }
        return true;
    };
    ChoicesRestful.prototype.getSurvey = function (live) {
        if (live === void 0) { live = false; }
        return !!this.owner ? this.owner.survey : null;
    };
    ChoicesRestful.prototype.run = function (textProcessor) {
        if (textProcessor === void 0) { textProcessor = null; }
        if (!this.url || !this.getResultCallback)
            return;
        this.processedText(textProcessor);
        if (!this.processedUrl) {
            this.doEmptyResultCallback({});
            this.lastObjHash = this.objHash;
            return;
        }
        if (this.lastObjHash === this.objHash)
            return;
        this.lastObjHash = this.objHash;
        this.error = null;
        if (this.useChangedItemsResults())
            return;
        if (ChoicesRestful.addSameRequest(this))
            return;
        this.sendRequest();
    };
    Object.defineProperty(ChoicesRestful.prototype, "isUsingCache", {
        get: function () {
            if (this.isUsingCacheFromUrl === true)
                return true;
            if (this.isUsingCacheFromUrl === false)
                return false;
            return settings.web.cacheLoadedChoices;
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(ChoicesRestful.prototype, "isRunning", {
        get: function () {
            return this.getIsRunning();
        },
        enumerable: false,
        configurable: true
    });
    ChoicesRestful.prototype.getIsRunning = function () {
        return this.isRunningValue;
    };
    Object.defineProperty(ChoicesRestful.prototype, "isWaitingForParameters", {
        get: function () {
            return this.url && !this.processedUrl;
        },
        enumerable: false,
        configurable: true
    });
    ChoicesRestful.prototype.useChangedItemsResults = function () {
        return ChoicesRestful.getCachedItemsResult(this);
    };
    ChoicesRestful.prototype.doEmptyResultCallback = function (serverResult) {
        var items = [];
        if (this.updateResultCallback) {
            items = this.updateResultCallback(items, serverResult);
        }
        this.getResultCallback(items);
    };
    ChoicesRestful.prototype.processedText = function (textProcessor) {
        var urlText = this.url;
        if (!!urlText) {
            urlText = urlText
                .replace(ChoicesRestful.cacheText, "")
                .replace(ChoicesRestful.noCacheText, "");
        }
        if (textProcessor) {
            var pUrl = textProcessor.processTextEx({ text: urlText, runAtDesign: true });
            var pPath = textProcessor.processTextEx({ text: this.path, runAtDesign: true });
            if (!pUrl.hasAllValuesOnLastRun || !pPath.hasAllValuesOnLastRun) {
                this.processedUrl = "";
                this.processedPath = "";
            }
            else {
                this.processedUrl = pUrl.text;
                this.processedPath = pPath.text;
            }
        }
        else {
            this.processedUrl = urlText;
            this.processedPath = this.path;
        }
        if (this.onProcessedUrlCallback) {
            this.onProcessedUrlCallback(this.processedUrl, this.processedPath);
        }
    };
    ChoicesRestful.prototype.parseResponse = function (response) {
        var parsedResponse;
        if (!!response &&
            typeof response.indexOf === "function" &&
            response.indexOf("<") === 0) {
            var parser = new XmlParser();
            parsedResponse = parser.parseXmlString(response);
        }
        else {
            try {
                parsedResponse = JSON.parse(response);
            }
            catch (_a) {
                parsedResponse = (response || "")
                    .split("\n")
                    .map(function (s) { return s.trim(" "); })
                    .filter(function (s) { return !!s; });
            }
        }
        return parsedResponse;
    };
    ChoicesRestful.prototype.sendRequest = function () {
        var xhr = new XMLHttpRequest();
        xhr.open("GET", this.processedUrl);
        xhr.setRequestHeader("Content-Type", "application/x-www-form-urlencoded");
        var self = this;
        var loadingObjHash = this.objHash;
        xhr.onload = function () {
            self.beforeLoadRequest();
            if (xhr.status === 200) {
                self.onLoad(self.parseResponse(xhr.response), loadingObjHash);
            }
            else {
                self.onError(xhr.statusText, xhr.responseText);
            }
        };
        var options = { request: xhr };
        if (!!settings.web.onBeforeRequestChoices) {
            settings.web.onBeforeRequestChoices(this, options);
        }
        this.beforeSendRequest();
        options.request.send();
    };
    ChoicesRestful.prototype.getType = function () {
        return "choicesByUrl";
    };
    Object.defineProperty(ChoicesRestful.prototype, "isEmpty", {
        get: function () {
            return !this.url && !this.path;
        },
        enumerable: false,
        configurable: true
    });
    ChoicesRestful.prototype.getCustomPropertiesNames = function () {
        var properties = this.getCustomProperties();
        var res = new Array();
        for (var i = 0; i < properties.length; i++) {
            res.push(this.getCustomPropertyName(properties[i].name));
        }
        return res;
    };
    ChoicesRestful.prototype.getCustomPropertyName = function (propertyName) {
        return propertyName + "Name";
    };
    ChoicesRestful.prototype.getCustomProperties = function () {
        var properties = Serializer.getProperties(this.itemValueType);
        var res = [];
        for (var i = 0; i < properties.length; i++) {
            if (properties[i].name === "value" ||
                properties[i].name === "text" ||
                properties[i].name === "visibleIf" ||
                properties[i].name === "enableIf")
                continue;
            res.push(properties[i]);
        }
        return res;
    };
    ChoicesRestful.prototype.getAllPropertiesNames = function () {
        var res = new Array();
        Serializer.getPropertiesByObj(this).forEach(function (prop) { return res.push(prop.name); });
        this.getCustomPropertiesNames().forEach(function (prop) { return res.push(prop); });
        return res;
    };
    ChoicesRestful.prototype.setData = function (json) {
        var _this = this;
        if (!json)
            json = {};
        this.getAllPropertiesNames().forEach(function (name) {
            _this[name] = json[name];
        });
    };
    ChoicesRestful.prototype.getData = function () {
        var _this = this;
        var res = {};
        var hasValue = false;
        this.getAllPropertiesNames().forEach(function (name) {
            var val = _this[name];
            if (!_this.isValueEmpty(val) && val !== _this.getDefaultPropertyValue(name)) {
                res[name] = val;
                hasValue = true;
            }
        });
        return hasValue ? res : null;
    };
    Object.defineProperty(ChoicesRestful.prototype, "url", {
        /**
         * A RESTful service's URL.
         *
         * This property supports [dynamic URLs](https://surveyjs.io/Documentation/Library?id=design-survey-conditional-logic#dynamic-texts). For example, the URL below depends on the `region` question's value. When the value changes, the survey automatically loads a new dataset that corresponds to the selected region.
         *
         * ```js
         * url: "https://surveyjs.io/api/CountriesExample?region={region}"
         * ```
         *
         * [View Demo](https://surveyjs.io/Examples/Library/?id=questiontype-dropdownrestfull (linkStyle))
         * @see path
         * @see valueName
         * @see titleName
         */
        get: function () {
            return this.getPropertyValue("url") || "";
        },
        set: function (val) {
            this.setPropertyValue("url", val);
            this.isUsingCacheFromUrl = undefined;
            if (!val)
                return;
            if (val.indexOf(ChoicesRestful.cacheText) > -1) {
                this.isUsingCacheFromUrl = true;
            }
            else {
                if (val.indexOf(ChoicesRestful.noCacheText) > -1) {
                    this.isUsingCacheFromUrl = false;
                }
            }
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(ChoicesRestful.prototype, "path", {
        /**
         * Path to the array of choices. The following path separators are allowed: semicolon `;`, comma `,`.
         *
         * Specify this property only if the array of choices is nested within the object returned by the service. For example, the service returns the following object:
         *
         * ```js
         * {
         *   countries: [ ... ],
         *   capitals: [ ... ]
         * }
         * ```
         *
         * To populate choices with values from the `countries` array, set the `path` property to `"countries"`. To use the `capitals` array, set this property to `"capitals"`.
         * @see url
         * @see valueName
         * @see titleName
         */
        get: function () {
            return this.getPropertyValue("path") || "";
        },
        set: function (val) {
            this.setPropertyValue("path", val);
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(ChoicesRestful.prototype, "valueName", {
        /**
         * Specifies which property in the obtained data object contains choice values.
         *
         * [View Demo](https://surveyjs.io/Examples/Library/?id=questiontype-dropdownrestfull (linkStyle))
         *
         * @see url
         * @see path
         * @see titleName
         */
        get: function () {
            return this.getPropertyValue("valueName", "");
        },
        set: function (val) {
            this.setPropertyValue("valueName", val);
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(ChoicesRestful.prototype, "titleName", {
        /**
         * Specifies which property in the obtained data object contains display texts for choices.
         *
         * @see url
         * @see path
         * @see valueName
         */
        get: function () {
            return this.getPropertyValue("titleName", "");
        },
        set: function (val) {
            this.setPropertyValue("titleName", val);
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(ChoicesRestful.prototype, "imageLinkName", {
        /**
         * Specifies which property in the obtained data object contains image URLs. Used only in [Image Picker](https://surveyjs.io/Examples/Library?id=questiontype-imagepicker) questions.
         *
         * @see url
         * @see path
         * @see valueName
         */
        get: function () {
            return this.getPropertyValue("imageLinkName", "");
        },
        set: function (val) {
            this.setPropertyValue("imageLinkName", val);
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(ChoicesRestful.prototype, "allowEmptyResponse", {
        /**
         * Specifies whether the service is allowed to return an empty response or an empty array in a response.
         *
         * Default value: `false`
         */
        get: function () {
            return this.getPropertyValue("allowEmptyResponse");
        },
        set: function (val) {
            this.setPropertyValue("allowEmptyResponse", val);
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(ChoicesRestful.prototype, "attachOriginalItems", {
        get: function () {
            return this.getPropertyValue("attachOriginalItems");
        },
        set: function (val) {
            this.setPropertyValue("attachOriginalItems", val);
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(ChoicesRestful.prototype, "itemValueType", {
        get: function () {
            if (!this.owner)
                return "itemvalue";
            var prop = Serializer.findProperty(this.owner.getType(), "choices");
            if (!prop)
                return "itemvalue";
            if (prop.type == "itemvalue[]")
                return "itemvalue";
            return prop.type;
        },
        enumerable: false,
        configurable: true
    });
    ChoicesRestful.prototype.clear = function () {
        this.setData(undefined);
    };
    ChoicesRestful.prototype.beforeSendRequest = function () {
        this.isRunningValue = true;
        if (!!this.beforeSendRequestCallback) {
            this.beforeSendRequestCallback();
        }
    };
    ChoicesRestful.prototype.beforeLoadRequest = function () {
        this.isRunningValue = false;
    };
    ChoicesRestful.prototype.onLoad = function (result, loadingObjHash) {
        if (loadingObjHash === void 0) { loadingObjHash = null; }
        if (!loadingObjHash) {
            loadingObjHash = this.objHash;
        }
        var items = new Array();
        var updatedResult = this.getResultAfterPath(result);
        if (updatedResult && updatedResult["length"]) {
            for (var i = 0; i < updatedResult.length; i++) {
                var itemValue = updatedResult[i];
                if (!itemValue)
                    continue;
                var value = !!this.getItemValueCallback
                    ? this.getItemValueCallback(itemValue)
                    : this.getValue(itemValue);
                var item = this.createItemValue(value);
                this.setTitle(item, itemValue);
                this.setCustomProperties(item, itemValue);
                if (this.attachOriginalItems) {
                    item.originalItem = itemValue;
                }
                var imageLink = this.getImageLink(itemValue);
                if (!!imageLink) {
                    item.imageLink = imageLink;
                }
                items.push(item);
            }
        }
        else {
            if (!this.allowEmptyResponse) {
                this.error = new WebRequestEmptyError(null, this.owner);
            }
        }
        if (this.updateResultCallback) {
            items = this.updateResultCallback(items, result);
        }
        if (this.isUsingCache) {
            ChoicesRestful.itemsResult[loadingObjHash] = items;
        }
        this.callResultCallback(items, loadingObjHash);
        ChoicesRestful.unregisterSameRequests(this, items);
    };
    ChoicesRestful.prototype.callResultCallback = function (items, loadingObjHash) {
        if (loadingObjHash != this.objHash)
            return;
        this.getResultCallback(items);
    };
    ChoicesRestful.prototype.setCustomProperties = function (item, itemValue) {
        var properties = this.getCustomProperties();
        for (var i = 0; i < properties.length; i++) {
            var prop = properties[i];
            var val = this.getValueCore(itemValue, this.getPropertyBinding(prop.name));
            if (!this.isValueEmpty(val)) {
                item[prop.name] = val;
            }
        }
    };
    ChoicesRestful.prototype.getPropertyBinding = function (propertyName) {
        if (this[this.getCustomPropertyName(propertyName)])
            return this[this.getCustomPropertyName(propertyName)];
        if (this[propertyName])
            return this[propertyName];
        return propertyName;
    };
    ChoicesRestful.prototype.onError = function (status, response) {
        this.error = new WebRequestError(status, response, this.owner);
        this.doEmptyResultCallback(response);
        ChoicesRestful.unregisterSameRequests(this, []);
    };
    ChoicesRestful.prototype.getResultAfterPath = function (result) {
        if (!result)
            return result;
        if (!this.processedPath)
            return result;
        var pathes = this.getPathes();
        for (var i = 0; i < pathes.length; i++) {
            result = result[pathes[i]];
            if (!result)
                return null;
        }
        return result;
    };
    ChoicesRestful.prototype.getPathes = function () {
        var pathes = [];
        if (this.processedPath.indexOf(";") > -1) {
            pathes = this.path.split(";");
        }
        else if (this.processedPath.indexOf(",") > -1) {
            pathes = this.processedPath.split(",");
        }
        else {
            pathes = this.processedPath.split(".");
        }
        if (pathes.length == 0)
            pathes.push(this.processedPath);
        return pathes;
    };
    ChoicesRestful.prototype.getValue = function (item) {
        if (!item)
            return null;
        if (this.valueName)
            return this.getValueCore(item, this.valueName);
        if (!(item instanceof Object))
            return item;
        var len = Object.keys(item).length;
        if (len < 1)
            return null;
        return item[Object.keys(item)[0]];
    };
    ChoicesRestful.prototype.setTitle = function (item, itemValue) {
        var title = this.titleName ? this.titleName : "title";
        var val = this.getValueCore(itemValue, title);
        if (!val)
            return;
        if (typeof val === "string") {
            item.text = val;
        }
        else {
            item.locText.setJson(val);
        }
    };
    ChoicesRestful.prototype.getImageLink = function (item) {
        var imageLink = this.imageLinkName ? this.imageLinkName : "imageLink";
        return this.getValueCore(item, imageLink);
    };
    ChoicesRestful.prototype.getValueCore = function (item, property) {
        if (!item)
            return null;
        if (property.indexOf(".") < 0)
            return item[property];
        var properties = property.split(".");
        for (var i = 0; i < properties.length; i++) {
            item = item[properties[i]];
            if (!item)
                return null;
        }
        return item;
    };
    Object.defineProperty(ChoicesRestful.prototype, "objHash", {
        get: function () {
            return (this.processedUrl +
                ";" +
                this.processedPath +
                ";" +
                this.valueName +
                ";" +
                this.titleName +
                ";" +
                this.imageLinkName);
        },
        enumerable: false,
        configurable: true
    });
    ChoicesRestful.cacheText = "{CACHE}";
    ChoicesRestful.noCacheText = "{NOCACHE}";
    ChoicesRestful.itemsResult = {};
    ChoicesRestful.sendingSameRequests = {};
    return ChoicesRestful;
}(base_Base));

/**
 * Obsolete, please use ChoicesRestful
 */
var choicesRestful_ChoicesRestfull = /** @class */ (function (_super) {
    choicesRestful_extends(ChoicesRestfull, _super);
    function ChoicesRestfull() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    Object.defineProperty(ChoicesRestfull, "EncodeParameters", {
        get: function () {
            return choicesRestful_ChoicesRestful.EncodeParameters;
        },
        set: function (val) {
            choicesRestful_ChoicesRestful.EncodeParameters = val;
        },
        enumerable: false,
        configurable: true
    });
    ChoicesRestfull.clearCache = function () {
        choicesRestful_ChoicesRestful.clearCache();
    };
    Object.defineProperty(ChoicesRestfull, "onBeforeSendRequest", {
        get: function () {
            return settings.web.onBeforeRequestChoices;
        },
        set: function (val) {
            settings.web.onBeforeRequestChoices = val;
        },
        enumerable: false,
        configurable: true
    });
    return ChoicesRestfull;
}(choicesRestful_ChoicesRestful));

Serializer.addClass("choicesByUrl", [
    "url",
    "path",
    "valueName",
    "titleName",
    {
        name: "imageLinkName",
        visibleIf: function (obj) {
            return !!obj && !!obj.owner && obj.owner.getType() == "imagepicker";
        },
    },
    { name: "allowEmptyResponse:boolean" },
    { name: "attachOriginalItems:boolean", visible: false },
], function () {
    return new choicesRestful_ChoicesRestful();
});

// CONCATENATED MODULE: ./packages/survey-core/src/martixBase.ts
var martixBase_extends = (undefined && undefined.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var martixBase_decorate = (undefined && undefined.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};





/**
 * A base class for all matrix question types.
 */
var martixBase_QuestionMatrixBaseModel = /** @class */ (function (_super) {
    martixBase_extends(QuestionMatrixBaseModel, _super);
    function QuestionMatrixBaseModel(name) {
        var _this = _super.call(this, name) || this;
        _this.generatedVisibleRows = null;
        _this.generatedTotalRow = null;
        _this.filteredRows = null;
        _this.columns = _this.createColumnValues();
        _this.rows = _this.createItemValues("rows");
        return _this;
    }
    QuestionMatrixBaseModel.prototype.createColumnValues = function () {
        return this.createItemValues("columns");
    };
    QuestionMatrixBaseModel.prototype.getType = function () {
        return "matrixbase";
    };
    QuestionMatrixBaseModel.prototype.endLoadingFromJson = function () {
        _super.prototype.endLoadingFromJson.call(this);
        this.updateVisibilityBasedOnRows();
    };
    Object.defineProperty(QuestionMatrixBaseModel.prototype, "isCompositeQuestion", {
        get: function () {
            return true;
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(QuestionMatrixBaseModel.prototype, "showHeader", {
        /**
         * Specifies whether to display the table header that contains column captions.
         *
         * Default value: `true`
         */
        get: function () {
            return this.getPropertyValue("showHeader");
        },
        set: function (val) {
            this.setPropertyValue("showHeader", val);
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(QuestionMatrixBaseModel.prototype, "columns", {
        /**
         * An array of matrix columns.
         *
         * For a Single-Select Matrix, the `columns` array can contain configuration objects with the `text` (display value) and `value` (value to be saved in survey results) properties. Alternatively, the array can contain primitive values that will be used as both the display values and values to be saved in survey results.
         *
         * [View "Single-Select Matrix" Demo](https://surveyjs.io/form-library/examples/single-selection-matrix-table-question/ (linkStyle))
         *
         * For a Multi-Select Matrix or Dynamic Matrix, the `columns` array should contain configuration objects with properties described in the [`MatrixDropdownColumn`](https://surveyjs.io/form-library/documentation/api-reference/multi-select-matrix-column-values) API Reference section.
         *
         * [View "Multi-Select Matrix" Demo](https://surveyjs.io/form-library/examples/questiontype-matrixdropdown/ (linkStyle))
         */
        get: function () {
            return this.getPropertyValue("columns");
        },
        set: function (newValue) {
            this.setPropertyValue("columns", newValue);
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(QuestionMatrixBaseModel.prototype, "visibleColumns", {
        get: function () {
            var _this = this;
            var res = [];
            this.columns.forEach(function (col) { if (_this.isColumnVisible(col)) {
                res.push(col);
            } });
            return res;
        },
        enumerable: false,
        configurable: true
    });
    QuestionMatrixBaseModel.prototype.isColumnVisible = function (column) {
        return column.isVisible;
    };
    Object.defineProperty(QuestionMatrixBaseModel.prototype, "rows", {
        /**
         * An array of matrix rows.
         *
         * This array can contain primitive values or objects with the `text` (display value) and `value` (value to be saved in survey results) properties.
         *
         * [View Demo](https://surveyjs.io/form-library/examples/single-selection-matrix-table-question/ (linkStyle))
         */
        get: function () {
            return this.getPropertyValue("rows");
        },
        set: function (newValue) {
            var newRows = this.processRowsOnSet(newValue);
            this.setPropertyValue("rows", newRows);
        },
        enumerable: false,
        configurable: true
    });
    QuestionMatrixBaseModel.prototype.processRowsOnSet = function (newRows) {
        return newRows;
    };
    QuestionMatrixBaseModel.prototype.getVisibleRows = function () {
        return [];
    };
    Object.defineProperty(QuestionMatrixBaseModel.prototype, "visibleRows", {
        /**
         * Returns an array of visible matrix rows.
         * @see rowsVisibleIf
         */
        get: function () {
            return this.getVisibleRows();
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(QuestionMatrixBaseModel.prototype, "rowsVisibleIf", {
        /**
         * A Boolean expression that is evaluated against each matrix row. If the expression evaluates to `false`, the row becomes hidden.
         *
         * A survey parses and runs all expressions on startup. If any values used in the expression change, the survey re-evaluates it.
         *
         * Use the `{item}` placeholder to reference the current row in the expression.
         *
         * Refer to the following help topic for more information: [Conditional Visibility](https://surveyjs.io/form-library/documentation/design-survey-conditional-logic#conditional-visibility).
         * @see visibleRows
         * @see columnsVisibleIf
         */
        get: function () {
            return this.getPropertyValue("rowsVisibleIf", "");
        },
        set: function (val) {
            this.setPropertyValue("rowsVisibleIf", val);
            if (!this.isLoadingFromJsonValue) {
                this.runCondition(this.getDataFilteredValues(), this.getDataFilteredProperties());
            }
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(QuestionMatrixBaseModel.prototype, "columnsVisibleIf", {
        /**
         * A Boolean expression that is evaluated against each matrix column. If the expression evaluates to `false`, the column becomes hidden.
         *
         * A survey parses and runs all expressions on startup. If any values used in the expression change, the survey re-evaluates it.
         *
         * Use the `{item}` placeholder to reference the current column in the expression.
         *
         * Refer to the following help topic for more information: [Conditional Visibility](https://surveyjs.io/form-library/documentation/design-survey-conditional-logic#conditional-visibility).
         * @see rowsVisibleIf
         */
        get: function () {
            return this.getPropertyValue("columnsVisibleIf", "");
        },
        set: function (val) {
            this.setPropertyValue("columnsVisibleIf", val);
            if (!this.isLoadingFromJson) {
                this.runCondition(this.getDataFilteredValues(), this.getDataFilteredProperties());
            }
        },
        enumerable: false,
        configurable: true
    });
    QuestionMatrixBaseModel.prototype.runCondition = function (values, properties) {
        _super.prototype.runCondition.call(this, values, properties);
        this.runItemsCondition(values, properties);
    };
    QuestionMatrixBaseModel.prototype.onColumnsChanged = function () { };
    QuestionMatrixBaseModel.prototype.onRowsChanged = function () {
        this.updateVisibilityBasedOnRows();
        this.fireCallback(this.visibleRowsChangedCallback);
    };
    QuestionMatrixBaseModel.prototype.updateVisibilityBasedOnRows = function () {
        if (this.hideIfRowsEmpty) {
            this.onVisibleChanged();
        }
    };
    QuestionMatrixBaseModel.prototype.isVisibleCore = function () {
        var _a;
        var res = _super.prototype.isVisibleCore.call(this);
        if (!res || !this.hideIfRowsEmpty)
            return res;
        return ((_a = this.visibleRows) === null || _a === void 0 ? void 0 : _a.length) > 0;
    };
    QuestionMatrixBaseModel.prototype.shouldRunColumnExpression = function () {
        return !this.survey || !this.survey.areInvisibleElementsShowing;
    };
    QuestionMatrixBaseModel.prototype.hasRowsAsItems = function () {
        return true;
    };
    QuestionMatrixBaseModel.prototype.runItemsCondition = function (values, properties) {
        var hasChanges = this.hasRowsAsItems() && this.runConditionsForRows(values, properties);
        var hasColumnsChanged = this.runConditionsForColumns(values, properties);
        hasChanges = hasColumnsChanged || hasChanges;
        if (hasChanges) {
            if (this.isClearValueOnHidden && hasColumnsChanged) {
                this.clearInvisibleColumnValues();
            }
            this.clearGeneratedRows();
            if (hasColumnsChanged) {
                this.onColumnsChanged();
            }
            this.onRowsChanged();
        }
    };
    QuestionMatrixBaseModel.prototype.isRowsFiltered = function () { return !!this.filteredRows; };
    QuestionMatrixBaseModel.prototype.clearGeneratedRows = function () {
        this.generatedVisibleRows = null;
    };
    QuestionMatrixBaseModel.prototype.createRowsVisibleIfRunner = function () { return null; };
    QuestionMatrixBaseModel.prototype.runConditionsForRows = function (values, properties) {
        var showInvisibile = !!this.survey && this.survey.areInvisibleElementsShowing;
        var runner = !showInvisibile ? this.createRowsVisibleIfRunner() : null;
        this.filteredRows = [];
        var hasChanged = itemvalue_ItemValue.runConditionsForItems(this.rows, this.filteredRows, runner, values, properties, !showInvisibile);
        itemvalue_ItemValue.runEnabledConditionsForItems(this.rows, undefined, values, properties);
        if (this.filteredRows.length === this.rows.length) {
            this.filteredRows = null;
        }
        return hasChanged;
    };
    QuestionMatrixBaseModel.prototype.runConditionsForColumns = function (values, properties) {
        var useColumnsExpression = !!this.survey && !this.survey.areInvisibleElementsShowing;
        var runner = useColumnsExpression && !!this.columnsVisibleIf ? new ConditionRunner(this.columnsVisibleIf) : null;
        return itemvalue_ItemValue.runConditionsForItems(this.columns, undefined, runner, values, properties, this.shouldRunColumnExpression());
    };
    QuestionMatrixBaseModel.prototype.clearInvisibleColumnValues = function () { };
    QuestionMatrixBaseModel.prototype.clearInvisibleValuesInRows = function () { };
    QuestionMatrixBaseModel.prototype.needResponsiveWidth = function () {
        //TODO: make it mor intelligent
        return true;
    };
    Object.defineProperty(QuestionMatrixBaseModel.prototype, "columnsAutoWidth", {
        get: function () {
            return !this.isMobile && !this.columns.some(function (col) { return !!col.width; });
        },
        enumerable: false,
        configurable: true
    });
    QuestionMatrixBaseModel.prototype.getTableCss = function () {
        var _a;
        return new CssClassBuilder()
            .append(this.cssClasses.root)
            .append(this.cssClasses.columnsAutoWidth, this.columnsAutoWidth)
            .append(this.cssClasses.noHeader, !this.showHeader)
            .append(this.cssClasses.hasFooter, !!((_a = this.renderedTable) === null || _a === void 0 ? void 0 : _a.showAddRowOnBottom))
            .append(this.cssClasses.rootAlternateRows, this.alternateRows)
            .append(this.cssClasses.rootVerticalAlignTop, (this.verticalAlign === "top"))
            .append(this.cssClasses.rootVerticalAlignMiddle, (this.verticalAlign === "middle")).toString();
    };
    Object.defineProperty(QuestionMatrixBaseModel.prototype, "columnMinWidth", {
        /**
         * Minimum column width in CSS values.
         *
         * @see width
         */
        get: function () {
            return this.getPropertyValue("columnMinWidth") || "";
        },
        set: function (val) {
            this.setPropertyValue("columnMinWidth", val);
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(QuestionMatrixBaseModel.prototype, "rowTitleWidth", {
        /**
         * A width for the column that displays row titles (first column). Accepts CSS values.
         */
        get: function () {
            return this.getPropertyValue("rowTitleWidth") || "";
        },
        set: function (val) {
            this.setPropertyValue("rowTitleWidth", val);
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(QuestionMatrixBaseModel.prototype, "displayMode", {
        get: function () {
            return this.getPropertyValue("displayMode");
        },
        /**
         * Specifies how to arrange matrix questions.
         *
         * Possible values:
         *
         * - `"table"` - Displays matrix questions in a table.
         * - `"list"` - Displays matrix questions one under another as a list.
         * - `"auto"` (default) - Uses the `"table"` mode if the survey has sufficient width to fit the table or the `"list"` mode otherwise.
         */
        set: function (val) {
            this.setPropertyValue("displayMode", val);
        },
        enumerable: false,
        configurable: true
    });
    //a11y
    QuestionMatrixBaseModel.prototype.getCellAriaLabel = function (rowTitle, columnTitle) {
        var row = (this.getLocalizationString("matrix_row") || "row").toLocaleLowerCase();
        var column = (this.getLocalizationString("matrix_column") || "column").toLocaleLowerCase();
        return row + " " + rowTitle + ", " + column + " " + columnTitle;
    };
    Object.defineProperty(QuestionMatrixBaseModel.prototype, "isNewA11yStructure", {
        get: function () {
            return true;
        },
        enumerable: false,
        configurable: true
    });
    // EO a11y
    QuestionMatrixBaseModel.prototype.getIsMobile = function () {
        if (this.displayMode == "auto")
            return _super.prototype.getIsMobile.call(this);
        return this.displayMode === "list";
    };
    martixBase_decorate([
        jsonobject_property()
    ], QuestionMatrixBaseModel.prototype, "verticalAlign", void 0);
    martixBase_decorate([
        jsonobject_property()
    ], QuestionMatrixBaseModel.prototype, "alternateRows", void 0);
    return QuestionMatrixBaseModel;
}(question_Question));

Serializer.addClass("matrixbase", [
    { name: "showCommentArea:switch", layout: "row", visible: true, category: "general" },
    "columnsVisibleIf:condition",
    "rowsVisibleIf:condition",
    "columnMinWidth",
    { name: "showHeader:boolean", default: true },
    {
        name: "verticalAlign",
        choices: ["top", "middle"],
        default: "middle",
    },
    { name: "alternateRows:boolean", default: false },
    {
        name: "displayMode",
        default: "auto",
        choices: ["auto", "table", "list"],
        visible: false
    },
], undefined, "question");

// CONCATENATED MODULE: ./packages/survey-core/src/textPreProcessor.ts


var TextPreProcessorItem = /** @class */ (function () {
    function TextPreProcessorItem() {
    }
    return TextPreProcessorItem;
}());

var TextPreProcessorValue = /** @class */ (function () {
    function TextPreProcessorValue(name, returnDisplayValue) {
        this.name = name;
        this.returnDisplayValue = returnDisplayValue;
        this.isExists = false;
        this.canProcess = true;
    }
    return TextPreProcessorValue;
}());

var textPreProcessor_TextPreProcessor = /** @class */ (function () {
    function TextPreProcessor() {
        this._unObservableValues = [undefined];
    }
    Object.defineProperty(TextPreProcessor.prototype, "hasAllValuesOnLastRunValue", {
        get: function () {
            return this._unObservableValues[0];
        },
        set: function (val) {
            this._unObservableValues[0] = val;
        },
        enumerable: false,
        configurable: true
    });
    TextPreProcessor.prototype.process = function (text, returnDisplayValue, doEncoding) {
        if (returnDisplayValue === void 0) { returnDisplayValue = false; }
        if (doEncoding === void 0) { doEncoding = false; }
        this.hasAllValuesOnLastRunValue = true;
        if (!text)
            return text;
        if (!this.onProcess)
            return text;
        var items = this.getItems(text);
        for (var i = items.length - 1; i >= 0; i--) {
            var item = items[i];
            var name = this.getName(text.substring(item.start + 1, item.end));
            if (!name)
                continue;
            var textValue = new TextPreProcessorValue(name, returnDisplayValue);
            this.onProcess(textValue);
            if (!textValue.isExists) {
                if (textValue.canProcess) {
                    this.hasAllValuesOnLastRunValue = false;
                }
                continue;
            }
            if (helpers_Helpers.isValueEmpty(textValue.value)) {
                this.hasAllValuesOnLastRunValue = false;
            }
            var replacedValue = !helpers_Helpers.isValueEmpty(textValue.value)
                ? textValue.value
                : "";
            if (doEncoding) {
                replacedValue = encodeURIComponent(replacedValue);
            }
            text =
                text.substring(0, item.start) + replacedValue + text.substring(item.end + 1);
        }
        return text;
    };
    TextPreProcessor.prototype.processValue = function (name, returnDisplayValue) {
        var textValue = new TextPreProcessorValue(name, returnDisplayValue);
        if (!!this.onProcess) {
            this.onProcess(textValue);
        }
        return textValue;
    };
    Object.defineProperty(TextPreProcessor.prototype, "hasAllValuesOnLastRun", {
        get: function () {
            return !!this.hasAllValuesOnLastRunValue;
        },
        enumerable: false,
        configurable: true
    });
    TextPreProcessor.prototype.getItems = function (text) {
        var items = [];
        var length = text.length;
        var start = -1;
        var ch = "";
        for (var i = 0; i < length; i++) {
            ch = text[i];
            if (ch == "{")
                start = i;
            if (ch == "}") {
                if (start > -1) {
                    var item = new TextPreProcessorItem();
                    item.start = start;
                    item.end = i;
                    if (this.isValidItemName(text.substring(start + 1, i - 1))) {
                        items.push(item);
                    }
                }
                start = -1;
            }
        }
        return items;
    };
    TextPreProcessor.prototype.isValidItemName = function (name) {
        return !!name && name.indexOf(":") < 0;
    };
    TextPreProcessor.prototype.getName = function (name) {
        if (!name)
            return;
        return name.trim();
    };
    return TextPreProcessor;
}());

var textPreProcessor_QuestionTextProcessor = /** @class */ (function () {
    function QuestionTextProcessor(variableName) {
        var _this = this;
        this.variableName = variableName;
        this.textPreProcessor = new textPreProcessor_TextPreProcessor();
        this.textPreProcessor.onProcess = function (textValue) {
            _this.getProcessedTextValue(textValue);
        };
    }
    QuestionTextProcessor.prototype.processValue = function (name, returnDisplayValue) {
        return this.textPreProcessor.processValue(name, returnDisplayValue);
    };
    Object.defineProperty(QuestionTextProcessor.prototype, "survey", {
        get: function () {
            return null;
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(QuestionTextProcessor.prototype, "panel", {
        get: function () {
            return null;
        },
        enumerable: false,
        configurable: true
    });
    QuestionTextProcessor.prototype.getValues = function () {
        return !!this.panel ? this.panel.getValue() : null;
    };
    QuestionTextProcessor.prototype.getQuestionByName = function (name) {
        return !!this.panel
            ? this.panel.getQuestionByValueName(name)
            : null;
    };
    QuestionTextProcessor.prototype.getParentTextProcessor = function () { return null; };
    QuestionTextProcessor.prototype.onCustomProcessText = function (textValue) {
        return false;
    };
    QuestionTextProcessor.prototype.getQuestionDisplayText = function (question) {
        return question.displayValue;
    };
    //ITextProcessor
    QuestionTextProcessor.prototype.getProcessedTextValue = function (textValue) {
        if (!textValue)
            return;
        if (this.onCustomProcessText(textValue))
            return;
        var firstName = new conditionProcessValue_ProcessValue().getFirstName(textValue.name);
        textValue.isExists = firstName == this.variableName;
        textValue.canProcess = textValue.isExists;
        if (!textValue.canProcess)
            return;
        //name should start with the variable name
        textValue.name = textValue.name.replace(this.variableName + ".", "");
        var firstName = new conditionProcessValue_ProcessValue().getFirstName(textValue.name);
        var question = this.getQuestionByName(firstName);
        var values = {};
        if (question) {
            values[firstName] = textValue.returnDisplayValue
                ? this.getQuestionDisplayText(question)
                : question.value;
        }
        else {
            var allValues = !!this.panel ? this.getValues() : null;
            if (allValues) {
                values[firstName] = allValues[firstName];
            }
        }
        textValue.value = new conditionProcessValue_ProcessValue().getValue(textValue.name, values);
    };
    QuestionTextProcessor.prototype.processText = function (text, returnDisplayValue) {
        if (this.survey && this.survey.isDesignMode)
            return text;
        text = this.textPreProcessor.process(text, returnDisplayValue);
        text = this.processTextCore(this.getParentTextProcessor(), text, returnDisplayValue);
        return this.processTextCore(this.survey, text, returnDisplayValue);
    };
    QuestionTextProcessor.prototype.processTextEx = function (params) {
        params.text = this.processText(params.text, params.returnDisplayValue);
        var hasAllValuesOnLastRun = this.textPreProcessor.hasAllValuesOnLastRun;
        var res = { hasAllValuesOnLastRun: true, text: params.text };
        if (this.survey) {
            res = this.survey.processTextEx(params);
        }
        res.hasAllValuesOnLastRun =
            res.hasAllValuesOnLastRun && hasAllValuesOnLastRun;
        return res;
    };
    QuestionTextProcessor.prototype.processTextCore = function (textProcessor, text, returnDisplayValue) {
        if (!textProcessor)
            return text;
        return textProcessor.processText(text, returnDisplayValue);
    };
    return QuestionTextProcessor;
}());


// CONCATENATED MODULE: ./packages/survey-core/src/question_custom.ts
var question_custom_extends = (undefined && undefined.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();









var question_custom_ComponentQuestionJSON = /** @class */ (function () {
    function ComponentQuestionJSON(name, json) {
        this.name = name;
        this.json = json;
        var self = this;
        Serializer.addClass(name, [], function (json) {
            return question_custom_ComponentCollection.Instance.createQuestion(!!json ? json.name : "", self);
        }, "question");
        this.onInit();
    }
    ComponentQuestionJSON.prototype.onInit = function () {
        if (!this.json.onInit)
            return;
        this.json.onInit();
    };
    ComponentQuestionJSON.prototype.onCreated = function (question) {
        if (!this.json.onCreated)
            return;
        this.json.onCreated(question);
    };
    ComponentQuestionJSON.prototype.onLoaded = function (question) {
        if (!this.json.onLoaded)
            return;
        this.json.onLoaded(question);
    };
    ComponentQuestionJSON.prototype.onAfterRender = function (question, htmlElement) {
        if (!this.json.onAfterRender)
            return;
        this.json.onAfterRender(question, htmlElement);
    };
    ComponentQuestionJSON.prototype.onAfterRenderContentElement = function (question, element, htmlElement) {
        if (!this.json.onAfterRenderContentElement)
            return;
        this.json.onAfterRenderContentElement(question, element, htmlElement);
    };
    ComponentQuestionJSON.prototype.onUpdateQuestionCssClasses = function (question, element, css) {
        if (!this.json.onUpdateQuestionCssClasses)
            return;
        this.json.onUpdateQuestionCssClasses(question, element, css);
    };
    ComponentQuestionJSON.prototype.onSetQuestionValue = function (question, newValue) {
        if (this.json.onSetQuestionValue) {
            this.json.onSetQuestionValue(question, newValue);
        }
        if (this.json.onValueSet) {
            this.json.onValueSet(question, newValue);
        }
    };
    ComponentQuestionJSON.prototype.onPropertyChanged = function (question, propertyName, newValue) {
        if (!this.json.onPropertyChanged)
            return;
        this.json.onPropertyChanged(question, propertyName, newValue);
    };
    ComponentQuestionJSON.prototype.onValueChanged = function (question, name, newValue) {
        if (!this.json.onValueChanged)
            return;
        this.json.onValueChanged(question, name, newValue);
    };
    ComponentQuestionJSON.prototype.onValueChanging = function (question, name, newValue) {
        if (!this.json.onValueChanging)
            return newValue;
        return this.json.onValueChanging(question, name, newValue);
    };
    ComponentQuestionJSON.prototype.onGetErrorText = function (question) {
        if (!this.json.getErrorText)
            return undefined;
        return this.json.getErrorText(question);
    };
    ComponentQuestionJSON.prototype.onItemValuePropertyChanged = function (question, item, propertyName, name, newValue) {
        if (!this.json.onItemValuePropertyChanged)
            return;
        this.json.onItemValuePropertyChanged(question, {
            obj: item,
            propertyName: propertyName,
            name: name,
            newValue: newValue,
        });
    };
    ComponentQuestionJSON.prototype.getDisplayValue = function (keyAsText, value, question) {
        if (!this.json.getDisplayValue)
            return question.getDisplayValue(keyAsText, value);
        return this.json.getDisplayValue(question);
    };
    Object.defineProperty(ComponentQuestionJSON.prototype, "defaultQuestionTitle", {
        get: function () {
            return this.json.defaultQuestionTitle;
        },
        enumerable: false,
        configurable: true
    });
    ComponentQuestionJSON.prototype.setValueToQuestion = function (val) {
        var converter = this.json.valueToQuestion || this.json.setValue;
        return !!converter ? converter(val) : val;
    };
    ComponentQuestionJSON.prototype.getValueFromQuestion = function (val) {
        var converter = this.json.valueFromQuestion || this.json.getValue;
        return !!converter ? converter(val) : val;
    };
    Object.defineProperty(ComponentQuestionJSON.prototype, "isComposite", {
        get: function () {
            return !!this.json.elementsJSON || !!this.json.createElements;
        },
        enumerable: false,
        configurable: true
    });
    ComponentQuestionJSON.prototype.getDynamicProperties = function () {
        if (!Array.isArray(this.dynamicProperties)) {
            this.dynamicProperties = this.calcDynamicProperties();
        }
        return this.dynamicProperties;
    };
    ComponentQuestionJSON.prototype.calcDynamicProperties = function () {
        var baseProps = this.json.inheritBaseProps;
        if (!baseProps || !this.json.questionJSON)
            return [];
        var type = this.json.questionJSON.type;
        if (!type)
            return [];
        if (Array.isArray(baseProps)) {
            var props_1 = [];
            baseProps.forEach(function (name) {
                var prop = Serializer.findProperty(type, name);
                if (prop) {
                    props_1.push(prop);
                }
            });
            return props_1;
        }
        var invalidNames = [];
        for (var key in this.json.questionJSON) {
            invalidNames.push(key);
        }
        return Serializer.getDynamicPropertiesByTypes(this.name, type, invalidNames);
    };
    return ComponentQuestionJSON;
}());

var question_custom_ComponentCollection = /** @class */ (function () {
    function ComponentCollection() {
        this.customQuestionValues = [];
    }
    ComponentCollection.prototype.add = function (json) {
        if (!json)
            return;
        var name = json.name;
        if (!name) {
            throw "Attribute name is missed";
        }
        name = name.toLowerCase();
        if (!!this.getCustomQuestionByName(name)) {
            throw "There is already registered custom question with name '" +
                name +
                "'";
        }
        if (!!Serializer.findClass(name)) {
            throw "There is already class with name '" + name + "'";
        }
        var customQuestion = new question_custom_ComponentQuestionJSON(name, json);
        if (!!this.onAddingJson)
            this.onAddingJson(name, customQuestion.isComposite);
        this.customQuestionValues.push(customQuestion);
    };
    ComponentCollection.prototype.remove = function (componentName) {
        if (!componentName)
            return false;
        var index = this.getCustomQuestionIndex(componentName.toLowerCase());
        if (index < 0)
            return false;
        this.removeByIndex(index);
        return true;
    };
    Object.defineProperty(ComponentCollection.prototype, "items", {
        get: function () {
            return this.customQuestionValues;
        },
        enumerable: false,
        configurable: true
    });
    ComponentCollection.prototype.getCustomQuestionByName = function (name) {
        var index = this.getCustomQuestionIndex(name);
        return index >= 0 ? this.customQuestionValues[index] : undefined;
    };
    ComponentCollection.prototype.getCustomQuestionIndex = function (name) {
        for (var i = 0; i < this.customQuestionValues.length; i++) {
            if (this.customQuestionValues[i].name === name)
                return i;
        }
        return -1;
    };
    ComponentCollection.prototype.removeByIndex = function (index) {
        Serializer.removeClass(this.customQuestionValues[index].name);
        this.customQuestionValues.splice(index, 1);
    };
    ComponentCollection.prototype.clear = function (includeInternal) {
        for (var i = this.customQuestionValues.length - 1; i >= 0; i--) {
            if (includeInternal || !this.customQuestionValues[i].json.internal) {
                this.removeByIndex(i);
            }
        }
    };
    ComponentCollection.prototype.createQuestion = function (name, questionJSON) {
        if (!!questionJSON.isComposite)
            return this.createCompositeModel(name, questionJSON);
        return this.createCustomModel(name, questionJSON);
    };
    ComponentCollection.prototype.createCompositeModel = function (name, questionJSON) {
        if (!!this.onCreateComposite)
            return this.onCreateComposite(name, questionJSON);
        return new question_custom_QuestionCompositeModel(name, questionJSON);
    };
    ComponentCollection.prototype.createCustomModel = function (name, questionJSON) {
        if (!!this.onCreateCustom)
            return this.onCreateCustom(name, questionJSON);
        return new question_custom_QuestionCustomModel(name, questionJSON);
    };
    ComponentCollection.Instance = new ComponentCollection();
    return ComponentCollection;
}());

var question_custom_QuestionCustomModelBase = /** @class */ (function (_super) {
    question_custom_extends(QuestionCustomModelBase, _super);
    function QuestionCustomModelBase(name, customQuestion) {
        var _this = _super.call(this, name) || this;
        _this.customQuestion = customQuestion;
        CustomPropertiesCollection.createProperties(_this);
        survey_element_SurveyElement.CreateDisabledDesignElements = true;
        _this.locQuestionTitle = _this.createLocalizableString("questionTitle", _this);
        _this.locQuestionTitle.setJson(_this.customQuestion.defaultQuestionTitle);
        _this.createWrapper();
        survey_element_SurveyElement.CreateDisabledDesignElements = false;
        if (!!_this.customQuestion) {
            _this.customQuestion.onCreated(_this);
        }
        return _this;
    }
    QuestionCustomModelBase.prototype.getType = function () {
        return !!this.customQuestion ? this.customQuestion.name : "custom";
    };
    QuestionCustomModelBase.prototype.locStrsChanged = function () {
        _super.prototype.locStrsChanged.call(this);
        if (!!this.getElement()) {
            this.getElement().locStrsChanged();
        }
    };
    QuestionCustomModelBase.prototype.localeChanged = function () {
        _super.prototype.locStrsChanged.call(this);
        if (!!this.getElement()) {
            this.getElement().localeChanged();
        }
    };
    QuestionCustomModelBase.prototype.getDefaultTitle = function () {
        if (!this.locQuestionTitle.isEmpty) {
            return this.getProcessedText(this.locQuestionTitle.textOrHtml);
        }
        return _super.prototype.getDefaultTitle.call(this);
    };
    QuestionCustomModelBase.prototype.addUsedLocales = function (locales) {
        _super.prototype.addUsedLocales.call(this, locales);
        if (!!this.getElement()) {
            this.getElement().addUsedLocales(locales);
        }
    };
    QuestionCustomModelBase.prototype.needResponsiveWidth = function () {
        var el = this.getElement();
        return !!el ? el.needResponsiveWidth() : false;
    };
    QuestionCustomModelBase.prototype.createWrapper = function () { };
    QuestionCustomModelBase.prototype.onPropertyValueChanged = function (name, oldValue, newValue) {
        _super.prototype.onPropertyValueChanged.call(this, name, oldValue, newValue);
        if (!!this.customQuestion && !this.isLoadingFromJson) {
            this.customQuestion.onPropertyChanged(this, name, newValue);
        }
    };
    QuestionCustomModelBase.prototype.itemValuePropertyChanged = function (item, name, oldValue, newValue) {
        _super.prototype.itemValuePropertyChanged.call(this, item, name, oldValue, newValue);
        if (!!this.customQuestion && !this.isLoadingFromJson) {
            this.customQuestion.onItemValuePropertyChanged(this, item, item.ownerPropertyName, name, newValue);
        }
    };
    QuestionCustomModelBase.prototype.onFirstRenderingCore = function () {
        _super.prototype.onFirstRenderingCore.call(this);
        var el = this.getElement();
        if (!!el) {
            el.onFirstRendering();
        }
    };
    QuestionCustomModelBase.prototype.onHidingContent = function () {
        _super.prototype.onHidingContent.call(this);
        var el = this.getElement();
        if (!!el) {
            el.onHidingContent();
        }
    };
    QuestionCustomModelBase.prototype.getProgressInfo = function () {
        var res = _super.prototype.getProgressInfo.call(this);
        if (!!this.getElement()) {
            res = this.getElement().getProgressInfo();
        }
        if (this.isRequired && res.requiredQuestionCount == 0) {
            res.requiredQuestionCount = 1;
            if (!this.isEmpty()) {
                res.answeredQuestionCount = 1;
            }
        }
        return res;
    };
    QuestionCustomModelBase.prototype.initElement = function (el) {
        if (!el)
            return;
        el.setSurveyImpl(this);
        el.disableDesignActions = true;
    };
    QuestionCustomModelBase.prototype.setSurveyImpl = function (value, isLight) {
        this.isSettingValOnLoading = true;
        _super.prototype.setSurveyImpl.call(this, value, isLight);
        this.initElement(this.getElement());
        this.isSettingValOnLoading = false;
    };
    QuestionCustomModelBase.prototype.onSurveyLoad = function () {
        _super.prototype.onSurveyLoad.call(this);
        if (!!this.getElement()) {
            this.getElement().onSurveyLoad();
            this.customQuestion.onLoaded(this);
        }
    };
    QuestionCustomModelBase.prototype.afterRenderQuestionElement = function (el) {
        //Do nothing
    };
    QuestionCustomModelBase.prototype.afterRenderCore = function (el) {
        _super.prototype.afterRenderCore.call(this, el);
        if (!!this.customQuestion) {
            this.customQuestion.onAfterRender(this, el);
        }
    };
    QuestionCustomModelBase.prototype.onUpdateQuestionCssClasses = function (element, css) {
        if (!!this.customQuestion) {
            this.customQuestion.onUpdateQuestionCssClasses(this, element, css);
        }
    };
    QuestionCustomModelBase.prototype.setQuestionValue = function (newValue, updateIsAnswered) {
        if (updateIsAnswered === void 0) { updateIsAnswered = true; }
        _super.prototype.setQuestionValue.call(this, newValue, updateIsAnswered);
        this.updateElementCss();
        if (!!this.customQuestion) {
            this.customQuestion.onSetQuestionValue(this, newValue);
        }
    };
    QuestionCustomModelBase.prototype.setNewValue = function (newValue) {
        _super.prototype.setNewValue.call(this, newValue);
        this.updateElementCss();
    };
    QuestionCustomModelBase.prototype.onCheckForErrors = function (errors, isOnValueChanged, fireCallback) {
        _super.prototype.onCheckForErrors.call(this, errors, isOnValueChanged, fireCallback);
        if (!!this.customQuestion) {
            var text = this.customQuestion.onGetErrorText(this);
            if (!!text) {
                errors.push(new CustomError(text, this));
            }
        }
    };
    //ISurveyImpl
    QuestionCustomModelBase.prototype.getSurveyData = function () {
        return this;
    };
    QuestionCustomModelBase.prototype.getTextProcessor = function () {
        return this.textProcessor;
    };
    //ISurveyData
    QuestionCustomModelBase.prototype.getValue = function (name) {
        return this.value;
    };
    QuestionCustomModelBase.prototype.setValue = function (name, newValue, locNotification, allowNotifyValueChanged) {
        if (!this.data)
            return;
        if (!!this.customQuestion) {
            this.customQuestion.onValueChanged(this, name, newValue);
        }
        var newName = this.convertDataName(name);
        var valueForSurvey = this.convertDataValue(name, newValue);
        if (this.valueToDataCallback) {
            valueForSurvey = this.valueToDataCallback(valueForSurvey);
        }
        this.data.setValue(newName, valueForSurvey, locNotification, allowNotifyValueChanged);
        this.updateIsAnswered();
        this.updateElementCss();
    };
    QuestionCustomModelBase.prototype.getQuestionByName = function (name) {
        return undefined;
    };
    QuestionCustomModelBase.prototype.isValueChanging = function (name, newValue) {
        if (!!this.customQuestion) {
            var qValue = newValue;
            newValue = this.customQuestion.onValueChanging(this, name, newValue);
            if (!helpers_Helpers.isTwoValueEquals(newValue, qValue)) {
                var q = this.getQuestionByName(name);
                if (!!q) {
                    q.value = newValue;
                    return true;
                }
            }
        }
        return false;
    };
    QuestionCustomModelBase.prototype.convertDataName = function (name) {
        return this.getValueName();
    };
    QuestionCustomModelBase.prototype.convertDataValue = function (name, newValue) {
        return newValue;
    };
    QuestionCustomModelBase.prototype.getVariable = function (name) {
        return !!this.data ? this.data.getVariable(name) : null;
    };
    QuestionCustomModelBase.prototype.setVariable = function (name, newValue) {
        if (!this.data)
            return;
        this.data.setVariable(name, newValue);
    };
    QuestionCustomModelBase.prototype.getComment = function (name) {
        return !!this.data ? this.data.getComment(this.getValueName()) : "";
    };
    QuestionCustomModelBase.prototype.setComment = function (name, newValue, locNotification) {
        if (!this.data)
            return;
        this.data.setComment(this.getValueName(), newValue, locNotification);
    };
    QuestionCustomModelBase.prototype.getAllValues = function () {
        return !!this.data ? this.data.getAllValues() : {};
    };
    QuestionCustomModelBase.prototype.getFilteredValues = function () {
        return !!this.data ? this.data.getFilteredValues() : {};
    };
    QuestionCustomModelBase.prototype.getFilteredProperties = function () {
        return !!this.data ? this.data.getFilteredProperties() : {};
    };
    QuestionCustomModelBase.prototype.findQuestionByName = function (name) {
        return !!this.data ? this.data.findQuestionByName(name) : null;
    };
    QuestionCustomModelBase.prototype.getEditingSurveyElement = function () {
        return undefined;
    };
    //IPanel
    QuestionCustomModelBase.prototype.addElement = function (element, index) { };
    QuestionCustomModelBase.prototype.removeElement = function (element) {
        return false;
    };
    QuestionCustomModelBase.prototype.getQuestionTitleLocation = function () {
        return "left";
    };
    QuestionCustomModelBase.prototype.getQuestionTitleWidth = function () {
        return undefined;
    };
    QuestionCustomModelBase.prototype.getColumsForElement = function (el) {
        return [];
    };
    QuestionCustomModelBase.prototype.updateColumns = function () { };
    QuestionCustomModelBase.prototype.getQuestionStartIndex = function () {
        return this.getStartIndex();
    };
    QuestionCustomModelBase.prototype.getChildrenLayoutType = function () {
        return "row";
    };
    QuestionCustomModelBase.prototype.elementWidthChanged = function (el) { };
    Object.defineProperty(QuestionCustomModelBase.prototype, "elements", {
        get: function () {
            return [];
        },
        enumerable: false,
        configurable: true
    });
    QuestionCustomModelBase.prototype.indexOf = function (el) {
        return -1;
    };
    QuestionCustomModelBase.prototype.ensureRowsVisibility = function () {
        // do nothing
    };
    QuestionCustomModelBase.prototype.validateContainerOnly = function () {
        // do nothing
    };
    QuestionCustomModelBase.prototype.onQuestionValueChanged = function (el) {
        // do nothing
    };
    QuestionCustomModelBase.prototype.getQuestionErrorLocation = function () {
        return this.getErrorLocation();
    };
    QuestionCustomModelBase.prototype.getContentDisplayValueCore = function (keyAsText, value, question) {
        if (!question)
            return _super.prototype.getDisplayValueCore.call(this, keyAsText, value);
        return this.customQuestion.getDisplayValue(keyAsText, value, question);
    };
    return QuestionCustomModelBase;
}(question_Question));

var question_custom_QuestionCustomModel = /** @class */ (function (_super) {
    question_custom_extends(QuestionCustomModel, _super);
    function QuestionCustomModel() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    QuestionCustomModel.prototype.getTemplate = function () {
        return "custom";
    };
    QuestionCustomModel.prototype.getDynamicProperties = function () {
        return this.customQuestion.getDynamicProperties() || [];
    };
    QuestionCustomModel.prototype.getDynamicType = function () {
        return this.questionWrapper ? this.questionWrapper.getType() : "question";
    };
    QuestionCustomModel.prototype.getOriginalObj = function () {
        return this.questionWrapper;
    };
    QuestionCustomModel.prototype.createWrapper = function () {
        var _this = this;
        this.questionWrapper = this.createQuestion();
        this.createDynamicProperties(this.questionWrapper);
        if (this.getDynamicProperties().length > 0) {
            this.questionWrapper.onPropertyValueChangedCallback = function (name, oldValue, newValue, sender, arrayChanges) {
                var prop = _this.getDynamicProperty(name);
                if (prop) {
                    _this.propertyValueChanged(name, oldValue, newValue, arrayChanges);
                }
            };
        }
    };
    QuestionCustomModel.prototype.getDynamicProperty = function (name) {
        var props = this.getDynamicProperties();
        for (var i = 0; i < props.length; i++) {
            if (props[i].name === name)
                return props[i];
        }
        return null;
    };
    QuestionCustomModel.prototype.getElement = function () {
        return this.contentQuestion;
    };
    QuestionCustomModel.prototype.onAnyValueChanged = function (name, questionName) {
        _super.prototype.onAnyValueChanged.call(this, name, questionName);
        if (!!this.contentQuestion) {
            this.contentQuestion.onAnyValueChanged(name, questionName);
        }
    };
    QuestionCustomModel.prototype.getQuestionByName = function (name) {
        return this.contentQuestion;
    };
    QuestionCustomModel.prototype.getDefaultTitle = function () {
        if (this.hasJSONTitle && this.contentQuestion) {
            return this.getProcessedText(this.contentQuestion.title);
        }
        return _super.prototype.getDefaultTitle.call(this);
    };
    QuestionCustomModel.prototype.setValue = function (name, newValue, locNotification, allowNotifyValueChanged) {
        if (this.isValueChanging(name, newValue))
            return;
        _super.prototype.setValue.call(this, name, newValue, locNotification, allowNotifyValueChanged);
    };
    QuestionCustomModel.prototype.onSetData = function () {
        _super.prototype.onSetData.call(this);
        if (!!this.survey && !this.isEmpty()) {
            this.setValue(this.name, this.value, false, this.allowNotifyValueChanged);
        }
    };
    QuestionCustomModel.prototype.hasErrors = function (fireCallback, rec) {
        if (fireCallback === void 0) { fireCallback = true; }
        if (rec === void 0) { rec = null; }
        if (!this.contentQuestion)
            return false;
        var res = this.contentQuestion.hasErrors(fireCallback, rec);
        this.errors = [];
        for (var i = 0; i < this.contentQuestion.errors.length; i++) {
            this.errors.push(this.contentQuestion.errors[i]);
        }
        if (!res) {
            res = _super.prototype.hasErrors.call(this, fireCallback, rec);
        }
        this.updateElementCss();
        return res;
    };
    QuestionCustomModel.prototype.focus = function (onError) {
        if (onError === void 0) { onError = false; }
        if (!!this.contentQuestion) {
            this.contentQuestion.focus(onError);
        }
        else {
            _super.prototype.focus.call(this, onError);
        }
    };
    QuestionCustomModel.prototype.afterRenderCore = function (el) {
        _super.prototype.afterRenderCore.call(this, el);
        if (!!this.contentQuestion) {
            this.contentQuestion.afterRender(el);
        }
    };
    Object.defineProperty(QuestionCustomModel.prototype, "contentQuestion", {
        get: function () {
            return this.questionWrapper;
        },
        enumerable: false,
        configurable: true
    });
    QuestionCustomModel.prototype.createQuestion = function () {
        var _this = this;
        var json = this.customQuestion.json;
        var res = null;
        if (!!json.questionJSON) {
            this.hasJSONTitle = !!json.questionJSON.title;
            var qType = json.questionJSON.type;
            if (!qType || !Serializer.findClass(qType))
                throw "type attribute in questionJSON is empty or incorrect";
            res = Serializer.createClass(qType);
            res.fromJSON(json.questionJSON);
            res = this.checkCreatedQuestion(res);
        }
        else {
            if (!!json.createQuestion) {
                res = this.checkCreatedQuestion(json.createQuestion());
            }
        }
        this.initElement(res);
        if (!!res) {
            res.isContentElement = true;
            if (!res.name) {
                res.name = "question";
            }
            res.onUpdateCssClassesCallback = function (css) {
                _this.onUpdateQuestionCssClasses(res, css);
            };
            res.hasCssErrorCallback = function () { return _this.errors.length > 0; };
            res.setValueChangedDirectlyCallback = function (val) { _this.setValueChangedDirectly(val); };
        }
        return res;
    };
    QuestionCustomModel.prototype.checkCreatedQuestion = function (res) {
        if (!res)
            return res;
        if (!res.isQuestion) {
            if (Array.isArray(res.questions) && res.questions.length > 0) {
                res = res.questions[0];
            }
            else {
                res = Serializer.createClass("text");
            }
            ConsoleWarnings.error("Could not create component: '" + this.getType() + "'. questionJSON should be a question.");
        }
        return res;
    };
    QuestionCustomModel.prototype.onSurveyLoad = function () {
        _super.prototype.onSurveyLoad.call(this);
        if (!this.contentQuestion)
            return;
        if (this.isEmpty() && !this.contentQuestion.isEmpty()) {
            this.value = this.getContentQuestionValue();
        }
    };
    QuestionCustomModel.prototype.runCondition = function (values, properties) {
        _super.prototype.runCondition.call(this, values, properties);
        if (!!this.contentQuestion) {
            this.contentQuestion.runCondition(values, properties);
        }
    };
    QuestionCustomModel.prototype.convertDataName = function (name) {
        var q = this.contentQuestion;
        if (!q || name === this.getValueName())
            return _super.prototype.convertDataName.call(this, name);
        var newName = name.replace(q.getValueName(), this.getValueName());
        return newName.indexOf(this.getValueName()) == 0
            ? newName
            : _super.prototype.convertDataName.call(this, name);
    };
    QuestionCustomModel.prototype.convertDataValue = function (name, newValue) {
        return this.convertDataName(name) == _super.prototype.convertDataName.call(this, name)
            ? this.getContentQuestionValue()
            : newValue;
    };
    QuestionCustomModel.prototype.getContentQuestionValue = function () {
        if (!this.contentQuestion)
            return undefined;
        var val = this.contentQuestion.value;
        if (!!this.customQuestion)
            val = this.customQuestion.getValueFromQuestion(val);
        return val;
    };
    QuestionCustomModel.prototype.setContentQuestionValue = function (val) {
        if (!this.contentQuestion)
            return;
        if (!!this.customQuestion)
            val = this.customQuestion.setValueToQuestion(val);
        this.contentQuestion.value = val;
    };
    QuestionCustomModel.prototype.canSetValueToSurvey = function () {
        return false;
    };
    QuestionCustomModel.prototype.setQuestionValue = function (newValue, updateIsAnswered) {
        if (updateIsAnswered === void 0) { updateIsAnswered = true; }
        _super.prototype.setQuestionValue.call(this, newValue, updateIsAnswered);
        if (!this.isLoadingFromJson && !!this.contentQuestion &&
            !this.isTwoValueEquals(this.getContentQuestionValue(), newValue)) {
            this.setContentQuestionValue(this.getUnbindValue(newValue));
        }
    };
    QuestionCustomModel.prototype.onSurveyValueChanged = function (newValue) {
        _super.prototype.onSurveyValueChanged.call(this, newValue);
        if (!!this.contentQuestion) {
            this.contentQuestion.onSurveyValueChanged(newValue);
        }
    };
    QuestionCustomModel.prototype.getValueCore = function () {
        if (!!this.contentQuestion)
            return this.getContentQuestionValue();
        return _super.prototype.getValueCore.call(this);
    };
    QuestionCustomModel.prototype.setValueChangedDirectly = function (val) {
        if (this.isSettingValueChanged)
            return;
        this.isSettingValueChanged = true;
        _super.prototype.setValueChangedDirectly.call(this, val);
        if (!!this.contentQuestion) {
            this.contentQuestion.setValueChangedDirectly(val);
        }
        this.isSettingValueChanged = false;
    };
    QuestionCustomModel.prototype.createDynamicProperties = function (el) {
        if (!el)
            return;
        var props = this.getDynamicProperties();
        if (Array.isArray(props)) {
            Serializer.addDynamicPropertiesIntoObj(this, el, props);
        }
    };
    QuestionCustomModel.prototype.initElement = function (el) {
        var _this = this;
        _super.prototype.initElement.call(this, el);
        if (!!el) {
            el.parent = this;
            el.afterRenderQuestionCallback = function (question, element) {
                if (!!_this.customQuestion) {
                    _this.customQuestion.onAfterRenderContentElement(_this, question, element);
                }
            };
        }
    };
    QuestionCustomModel.prototype.updateElementCss = function (reNew) {
        if (!!this.contentQuestion) {
            this.questionWrapper.updateElementCss(reNew);
        }
        _super.prototype.updateElementCss.call(this, reNew);
    };
    QuestionCustomModel.prototype.updateElementCssCore = function (cssClasses) {
        if (!!this.contentQuestion) {
            cssClasses = this.contentQuestion.cssClasses;
        }
        _super.prototype.updateElementCssCore.call(this, cssClasses);
    };
    QuestionCustomModel.prototype.getDisplayValueCore = function (keyAsText, value) {
        return _super.prototype.getContentDisplayValueCore.call(this, keyAsText, value, this.contentQuestion);
    };
    return QuestionCustomModel;
}(question_custom_QuestionCustomModelBase));

var QuestionCompositeTextProcessor = /** @class */ (function (_super) {
    question_custom_extends(QuestionCompositeTextProcessor, _super);
    function QuestionCompositeTextProcessor(composite, variableName) {
        var _this = _super.call(this, variableName) || this;
        _this.composite = composite;
        _this.variableName = variableName;
        return _this;
    }
    Object.defineProperty(QuestionCompositeTextProcessor.prototype, "survey", {
        get: function () {
            return this.composite.survey;
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(QuestionCompositeTextProcessor.prototype, "panel", {
        get: function () {
            return this.composite.contentPanel;
        },
        enumerable: false,
        configurable: true
    });
    return QuestionCompositeTextProcessor;
}(textPreProcessor_QuestionTextProcessor));
var question_custom_QuestionCompositeModel = /** @class */ (function (_super) {
    question_custom_extends(QuestionCompositeModel, _super);
    function QuestionCompositeModel(name, customQuestion) {
        var _this = _super.call(this, name, customQuestion) || this;
        _this.customQuestion = customQuestion;
        _this.settingNewValue = false;
        _this.textProcessing = new QuestionCompositeTextProcessor(_this, QuestionCompositeModel.ItemVariableName);
        return _this;
    }
    QuestionCompositeModel.prototype.createWrapper = function () {
        this.panelWrapper = this.createPanel();
    };
    QuestionCompositeModel.prototype.getTemplate = function () {
        return "composite";
    };
    QuestionCompositeModel.prototype.getElement = function () {
        return this.contentPanel;
    };
    QuestionCompositeModel.prototype.getCssRoot = function (cssClasses) {
        return new CssClassBuilder().append(_super.prototype.getCssRoot.call(this, cssClasses)).append(cssClasses.composite).toString();
    };
    Object.defineProperty(QuestionCompositeModel.prototype, "contentPanel", {
        get: function () {
            return this.panelWrapper;
        },
        enumerable: false,
        configurable: true
    });
    QuestionCompositeModel.prototype.hasErrors = function (fireCallback, rec) {
        if (fireCallback === void 0) { fireCallback = true; }
        if (rec === void 0) { rec = null; }
        var res = _super.prototype.hasErrors.call(this, fireCallback, rec);
        if (!this.contentPanel)
            return res;
        return this.contentPanel.hasErrors(fireCallback, false, rec) || res;
    };
    QuestionCompositeModel.prototype.updateElementCss = function (reNew) {
        _super.prototype.updateElementCss.call(this, reNew);
        if (this.contentPanel) {
            this.contentPanel.updateElementCss(reNew);
        }
    };
    QuestionCompositeModel.prototype.dispose = function () {
        this.unConnectEditingObj();
        _super.prototype.dispose.call(this);
    };
    QuestionCompositeModel.prototype.updateEditingObj = function () {
        var _this = this;
        var _a;
        var obj = (_a = this.data) === null || _a === void 0 ? void 0 : _a.getEditingSurveyElement();
        if (!obj)
            return undefined;
        var newObj = obj[this.getValueName()];
        if (!!newObj && !newObj.onPropertyChanged) {
            newObj = undefined;
        }
        if (newObj !== this.editingObjValue) {
            this.unConnectEditingObj();
            this.editingObjValue = newObj;
            if (!!newObj) {
                this.onEditingObjPropertyChanged = function (sender, options) {
                    _this.setNewValueIntoQuestion(options.name, _this.editingObjValue[options.name]);
                };
                newObj.onPropertyChanged.add(this.onEditingObjPropertyChanged);
            }
        }
        return this.editingObjValue;
    };
    QuestionCompositeModel.prototype.unConnectEditingObj = function () {
        if (!!this.editingObjValue && !this.editingObjValue.isDisposed) {
            this.editingObjValue.onPropertyChanged.remove(this.onEditingObjPropertyChanged);
        }
    };
    QuestionCompositeModel.prototype.getEditingSurveyElement = function () {
        return this.editingObjValue;
    };
    QuestionCompositeModel.prototype.getTextProcessor = function () {
        return this.textProcessing;
    };
    QuestionCompositeModel.prototype.findQuestionByName = function (name) {
        var res = this.getQuestionByName(name);
        if (!!res)
            return res;
        return _super.prototype.findQuestionByName.call(this, name);
    };
    QuestionCompositeModel.prototype.clearValueIfInvisibleCore = function (reason) {
        _super.prototype.clearValueIfInvisibleCore.call(this, reason);
        var questions = this.contentPanel.questions;
        for (var i = 0; i < questions.length; i++) {
            questions[i].clearValueIfInvisible(reason);
        }
    };
    QuestionCompositeModel.prototype.onAnyValueChanged = function (name, questionName) {
        _super.prototype.onAnyValueChanged.call(this, name, questionName);
        var questions = this.contentPanel.questions;
        for (var i = 0; i < questions.length; i++) {
            questions[i].onAnyValueChanged(name, questionName);
        }
    };
    Object.defineProperty(QuestionCompositeModel.prototype, "hasSingleInput", {
        get: function () { return false; },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(QuestionCompositeModel.prototype, "isContainer", {
        get: function () { return true; },
        enumerable: false,
        configurable: true
    });
    QuestionCompositeModel.prototype.createPanel = function () {
        var _this = this;
        var res = Serializer.createClass("panel");
        res.showQuestionNumbers = "off";
        res.renderWidth = "100%";
        var json = this.customQuestion.json;
        if (!!json.elementsJSON) {
            res.fromJSON({ elements: json.elementsJSON });
        }
        if (!!json.createElements) {
            json.createElements(res, this);
        }
        this.initElement(res);
        res.readOnly = this.isReadOnly;
        res.questions.forEach(function (q) { return q.onUpdateCssClassesCallback = function (css) {
            _this.onUpdateQuestionCssClasses(q, css);
        }; });
        this.setAfterRenderCallbacks(res);
        return res;
    };
    QuestionCompositeModel.prototype.onReadOnlyChanged = function () {
        if (!!this.contentPanel) {
            this.contentPanel.readOnly = this.isReadOnly;
        }
        _super.prototype.onReadOnlyChanged.call(this);
    };
    QuestionCompositeModel.prototype.updateValueFromSurvey = function (newValue, clearData) {
        if (clearData === void 0) { clearData = false; }
        this.updateEditingObj();
        _super.prototype.updateValueFromSurvey.call(this, newValue, clearData);
    };
    QuestionCompositeModel.prototype.onSurveyLoad = function () {
        this.isSettingValOnLoading = true;
        if (!!this.contentPanel) {
            this.contentPanel.readOnly = this.isReadOnly;
            this.setIsContentElement(this.contentPanel);
        }
        _super.prototype.onSurveyLoad.call(this);
        if (!!this.contentPanel) {
            var val = this.getContentPanelValue();
            if (!helpers_Helpers.isValueEmpty(val)) {
                this.value = val;
            }
        }
        this.isSettingValOnLoading = false;
    };
    QuestionCompositeModel.prototype.setIsContentElement = function (panel) {
        panel.isContentElement = true;
        var elements = panel.elements;
        for (var i = 0; i < elements.length; i++) {
            var el = elements[i];
            if (el.isPanel) {
                this.setIsContentElement(el);
            }
            else {
                el.isContentElement = true;
            }
        }
    };
    QuestionCompositeModel.prototype.setVisibleIndex = function (val) {
        var res = _super.prototype.setVisibleIndex.call(this, val);
        if (this.isVisible && !!this.contentPanel) {
            res += this.contentPanel.setVisibleIndex(val);
        }
        return res;
    };
    QuestionCompositeModel.prototype.runCondition = function (values, properties) {
        _super.prototype.runCondition.call(this, values, properties);
        if (!!this.contentPanel) {
            var oldComposite = values[QuestionCompositeModel.ItemVariableName];
            values[QuestionCompositeModel.ItemVariableName] = this.contentPanel.getValue();
            this.contentPanel.runCondition(values, properties);
            delete values[QuestionCompositeModel.ItemVariableName];
            if (!!oldComposite) {
                values[QuestionCompositeModel.ItemVariableName] = oldComposite;
            }
        }
    };
    QuestionCompositeModel.prototype.onSurveyValueChanged = function (newValue) {
        _super.prototype.onSurveyValueChanged.call(this, newValue);
        var val = !!newValue ? newValue : {};
        if (!!this.contentPanel) {
            this.contentPanel.questions.forEach(function (q) {
                q.onSurveyValueChanged(val[q.getValueName()]);
            });
        }
    };
    QuestionCompositeModel.prototype.getValue = function (name) {
        var val = this.value;
        return !!val ? val[name] : null;
    };
    QuestionCompositeModel.prototype.getQuestionByName = function (name) {
        return !!this.contentPanel ? this.contentPanel.getQuestionByName(name) : undefined;
    };
    QuestionCompositeModel.prototype.setValue = function (name, newValue, locNotification, allowNotifyValueChanged) {
        if (this.settingNewValue) {
            this.setNewValueIntoQuestion(name, newValue);
            return;
        }
        if (this.isValueChanging(name, newValue))
            return;
        this.settingNewValue = true;
        if (!this.isEditingSurveyElement && !!this.contentPanel) {
            var index = 0;
            var maxTimes = this.contentPanel.questions.length + 1;
            while (index < maxTimes && this.updateValueCoreWithPanelValue())
                index++;
        }
        this.setNewValueIntoQuestion(name, newValue);
        _super.prototype.setValue.call(this, name, newValue, locNotification, allowNotifyValueChanged);
        this.settingNewValue = false;
        this.runPanelTriggers(QuestionCompositeModel.ItemVariableName + "." + name, newValue);
    };
    QuestionCompositeModel.prototype.setComment = function (name, newValue, locNotification) {
        var val = this.getUnbindValue(this.value);
        var commentName = this.getCommentName(name);
        if (!val && !newValue || !!newValue && !!val && val[commentName] === newValue)
            return;
        if (!!newValue) {
            if (!val) {
                val = {};
            }
            val[commentName] = newValue;
        }
        else {
            delete val[commentName];
        }
        var q = this.getQuestionByName(name);
        if (!!q && q.comment !== newValue) {
            q.comment = newValue;
        }
        this.value = val;
    };
    QuestionCompositeModel.prototype.getComment = function (name) {
        var q = this.getQuestionByName(name);
        if (!!q)
            return q.comment;
        var val = this.value;
        return !!val && val[this.getCommentName(name)] || "";
    };
    QuestionCompositeModel.prototype.getCommentName = function (name) {
        return name + settings.commentSuffix;
    };
    QuestionCompositeModel.prototype.runPanelTriggers = function (name, value) {
        if (!!this.contentPanel) {
            this.contentPanel.questions.forEach(function (q) {
                q.runTriggers(name, value);
            });
        }
    };
    QuestionCompositeModel.prototype.getFilteredValues = function () {
        var values = !!this.data ? this.data.getFilteredValues() : {};
        if (!!this.contentPanel) {
            values[QuestionCompositeModel.ItemVariableName] = this.contentPanel.getValue();
        }
        return values;
    };
    QuestionCompositeModel.prototype.updateValueCoreWithPanelValue = function () {
        var panelValue = this.getContentPanelValue();
        if (this.isTwoValueEquals(this.getValueCore(), panelValue))
            return false;
        this.setValueCore(panelValue);
        return true;
    };
    QuestionCompositeModel.prototype.getContentPanelValue = function (val) {
        if (!val)
            val = this.contentPanel.getValue();
        return this.customQuestion.setValueToQuestion(val);
    };
    QuestionCompositeModel.prototype.getValueForContentPanel = function (val) {
        return this.customQuestion.getValueFromQuestion(val);
    };
    QuestionCompositeModel.prototype.setNewValueIntoQuestion = function (name, newValue) {
        var q = this.getQuestionByName(name);
        if (!!q && !this.isTwoValueEquals(newValue, q.value)) {
            q.value = newValue;
        }
    };
    QuestionCompositeModel.prototype.addConditionObjectsByContext = function (objects, context) {
        if (!this.contentPanel)
            return;
        var questions = this.contentPanel.questions;
        var prefixName = this.name;
        var prefixText = this.title;
        for (var i = 0; i < questions.length; i++) {
            objects.push({
                name: prefixName + "." + questions[i].name,
                text: prefixText + "." + questions[i].title,
                question: questions[i],
            });
        }
    };
    QuestionCompositeModel.prototype.collectNestedQuestionsCore = function (questions, visibleOnly) {
        if (!this.contentPanel)
            return;
        this.contentPanel.questions.forEach(function (q) { return q.collectNestedQuestions(questions, visibleOnly); });
    };
    QuestionCompositeModel.prototype.convertDataValue = function (name, newValue) {
        var val = !!this.contentPanel && !this.isEditingSurveyElement ?
            this.contentPanel.getValue() : this.getValueForContentPanel(this.value);
        if (!val)
            val = {};
        if (!val.getType) {
            val = helpers_Helpers.getUnbindValue(val);
        }
        if (this.isValueEmpty(newValue) && !this.isEditingSurveyElement) {
            delete val[name];
        }
        else {
            val[name] = newValue;
        }
        return this.getContentPanelValue(val);
    };
    QuestionCompositeModel.prototype.setQuestionValue = function (newValue, updateIsAnswered) {
        if (updateIsAnswered === void 0) { updateIsAnswered = true; }
        this.setValuesIntoQuestions(newValue);
        if (!this.isEditingSurveyElement && !!this.contentPanel) {
            newValue = this.getContentPanelValue();
        }
        _super.prototype.setQuestionValue.call(this, newValue, updateIsAnswered);
    };
    QuestionCompositeModel.prototype.setValuesIntoQuestions = function (newValue) {
        if (!this.contentPanel || this.settingNewValue)
            return;
        newValue = this.getValueForContentPanel(newValue);
        var oldSettingNewValue = this.settingNewValue;
        this.settingNewValue = true;
        var questions = this.contentPanel.questions;
        for (var i = 0; i < questions.length; i++) {
            var q = questions[i];
            var key = q.getValueName();
            var commentKey = this.getCommentName(key);
            var val = !!newValue ? newValue[key] : undefined;
            var commentVal = !!newValue && newValue[commentKey] || "";
            if (!this.isTwoValueEquals(q.value, val) && (val !== undefined || !q.isEmpty())) {
                q.value = val;
            }
            if (q.comment !== commentVal) {
                q.comment = commentVal;
            }
        }
        this.settingNewValue = oldSettingNewValue;
    };
    QuestionCompositeModel.prototype.getDisplayValueCore = function (keyAsText, value) {
        return _super.prototype.getContentDisplayValueCore.call(this, keyAsText, value, this.contentPanel);
    };
    QuestionCompositeModel.prototype.setAfterRenderCallbacks = function (panel) {
        var _this = this;
        if (!panel || !this.customQuestion)
            return;
        var questions = panel.questions;
        for (var i = 0; i < questions.length; i++) {
            questions[i].afterRenderQuestionCallback = function (question, element) {
                _this.customQuestion.onAfterRenderContentElement(_this, question, element);
            };
        }
    };
    Object.defineProperty(QuestionCompositeModel.prototype, "ariaRole", {
        get: function () {
            return "group";
        },
        enumerable: false,
        configurable: true
    });
    QuestionCompositeModel.ItemVariableName = "composite";
    return QuestionCompositeModel;
}(question_custom_QuestionCustomModelBase));


// CONCATENATED MODULE: ./packages/survey-core/src/questionfactory.ts



var questionfactory_QuestionFactory = /** @class */ (function () {
    function QuestionFactory() {
    }
    Object.defineProperty(QuestionFactory, "DefaultChoices", {
        get: function () {
            var choice = getLocaleString("choices_Item");
            return [choice + "1", choice + "2", choice + "3"];
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(QuestionFactory, "DefaultColums", {
        get: function () {
            var colName = getLocaleString("matrix_column") + " ";
            return [colName + "1", colName + "2", colName + "3"];
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(QuestionFactory, "DefaultRows", {
        get: function () {
            var rowName = getLocaleString("matrix_row") + " ";
            return [rowName + "1", rowName + "2"];
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(QuestionFactory, "DefaultMutlipleTextItems", {
        get: function () {
            var itemName = getLocaleString("multipletext_itemname");
            return [itemName + "1", itemName + "2"];
        },
        enumerable: false,
        configurable: true
    });
    QuestionFactory.prototype.registerQuestion = function (questionType, questionCreator, showInToolbox) {
        if (showInToolbox === void 0) { showInToolbox = true; }
        questionfactory_ElementFactory.Instance.registerElement(questionType, questionCreator, showInToolbox);
    };
    QuestionFactory.prototype.registerCustomQuestion = function (questionType) {
        questionfactory_ElementFactory.Instance.registerCustomQuestion(questionType);
    };
    QuestionFactory.prototype.unregisterElement = function (elementType, removeFromSerializer) {
        if (removeFromSerializer === void 0) { removeFromSerializer = false; }
        questionfactory_ElementFactory.Instance.unregisterElement(elementType, removeFromSerializer);
    };
    QuestionFactory.prototype.clear = function () {
        questionfactory_ElementFactory.Instance.clear();
    };
    QuestionFactory.prototype.getAllTypes = function () {
        return questionfactory_ElementFactory.Instance.getAllTypes();
    };
    QuestionFactory.prototype.createQuestion = function (questionType, name) {
        return questionfactory_ElementFactory.Instance.createElement(questionType, name);
    };
    QuestionFactory.Instance = new QuestionFactory();
    return QuestionFactory;
}());

var questionfactory_ElementFactory = /** @class */ (function () {
    function ElementFactory() {
        var _this = this;
        this.creatorHash = {};
        this.registerCustomQuestion = function (questionType, showInToolbox) {
            if (showInToolbox === void 0) { showInToolbox = true; }
            var creator = function (name) {
                var el = Serializer.createClass(questionType);
                if (!!el)
                    el.name = name;
                return el;
            };
            _this.registerElement(questionType, creator, showInToolbox);
        };
    }
    ElementFactory.prototype.registerElement = function (elementType, elementCreator, showInToolbox) {
        if (showInToolbox === void 0) { showInToolbox = true; }
        this.creatorHash[elementType] = { showInToolbox: showInToolbox, creator: elementCreator };
    };
    ElementFactory.prototype.clear = function () {
        this.creatorHash = {};
    };
    ElementFactory.prototype.unregisterElement = function (elementType, removeFromSerializer) {
        if (removeFromSerializer === void 0) { removeFromSerializer = false; }
        delete this.creatorHash[elementType];
        if (removeFromSerializer) {
            Serializer.removeClass(elementType);
        }
    };
    ElementFactory.prototype.getAllToolboxTypes = function () {
        return this.getAllTypesCore(true);
    };
    ElementFactory.prototype.getAllTypes = function () {
        return this.getAllTypesCore(false);
    };
    ElementFactory.prototype.createElement = function (elementType, name) {
        var item = this.creatorHash[elementType];
        if (!!item && !!item.creator)
            return item.creator(name);
        var compJSON = question_custom_ComponentCollection.Instance.getCustomQuestionByName(elementType);
        if (!!compJSON)
            return question_custom_ComponentCollection.Instance.createQuestion(name, compJSON);
        return null;
    };
    ElementFactory.prototype.getAllTypesCore = function (showInToolboxOnly) {
        var result = new Array();
        for (var key in this.creatorHash) {
            if (!showInToolboxOnly || this.creatorHash[key].showInToolbox) {
                result.push(key);
            }
        }
        return result.sort();
    };
    ElementFactory.Instance = new ElementFactory();
    return ElementFactory;
}());


// CONCATENATED MODULE: ./packages/survey-core/src/question_expression.ts
var question_expression_extends = (undefined && undefined.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();




/**
 * A class that describes the Expression question type. It is a read-only question type that calculates a value based on a specified expression.
 *
 * [View Demo](https://surveyjs.io/form-library/examples/questiontype-expression/ (linkStyle))
 */
var question_expression_QuestionExpressionModel = /** @class */ (function (_super) {
    question_expression_extends(QuestionExpressionModel, _super);
    function QuestionExpressionModel(name) {
        var _this = _super.call(this, name) || this;
        _this.createLocalizableString("format", _this);
        _this.registerPropertyChangedHandlers(["expression"], function () {
            if (_this.expressionRunner) {
                _this.expressionRunner = _this.createRunner();
            }
        });
        _this.registerPropertyChangedHandlers(["format", "currency", "displayStyle"], function () {
            _this.updateFormatedValue();
        });
        return _this;
    }
    QuestionExpressionModel.prototype.getType = function () {
        return "expression";
    };
    Object.defineProperty(QuestionExpressionModel.prototype, "hasInput", {
        get: function () {
            return false;
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(QuestionExpressionModel.prototype, "format", {
        /**
         * A string that formats a question value. Use `{0}` to reference the question value in the format string.
         * @see displayStyle
         */
        get: function () {
            return this.getLocalizableStringText("format", "");
        },
        set: function (val) {
            this.setLocalizableStringText("format", val);
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(QuestionExpressionModel.prototype, "locFormat", {
        get: function () {
            return this.getLocalizableString("format");
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(QuestionExpressionModel.prototype, "expression", {
        /**
         * An expression used to calculate the question value.
         *
         * Refer to the following help topic for more information: [Expressions](https://surveyjs.io/form-library/documentation/design-survey-conditional-logic#expressions).
         */
        get: function () {
            return this.getPropertyValue("expression", "");
        },
        set: function (val) {
            this.setPropertyValue("expression", val);
        },
        enumerable: false,
        configurable: true
    });
    QuestionExpressionModel.prototype.locCalculation = function () {
        this.expressionIsRunning = true;
    };
    QuestionExpressionModel.prototype.unlocCalculation = function () {
        this.expressionIsRunning = false;
    };
    QuestionExpressionModel.prototype.runCondition = function (values, properties) {
        _super.prototype.runCondition.call(this, values, properties);
        if (!this.expression ||
            this.expressionIsRunning ||
            (!this.runIfReadOnly && this.isReadOnly))
            return;
        this.locCalculation();
        if (!this.expressionRunner) {
            this.expressionRunner = this.createRunner();
        }
        this.expressionRunner.run(values, properties);
    };
    QuestionExpressionModel.prototype.canCollectErrors = function () {
        return true;
    };
    QuestionExpressionModel.prototype.hasRequiredError = function () {
        return false;
    };
    QuestionExpressionModel.prototype.createRunner = function () {
        var _this = this;
        var res = this.createExpressionRunner(this.expression);
        res.onRunComplete = function (newValue) {
            _this.value = _this.roundValue(newValue);
            _this.unlocCalculation();
        };
        return res;
    };
    Object.defineProperty(QuestionExpressionModel.prototype, "maximumFractionDigits", {
        /**
         * The maximum number of fraction digits. Applies only if the `displayStyle` property is not `"none"`. Accepts values in the range from -1 to 20, where -1 disables the property.
         *
         * Default value: -1
         * @see displayStyle
         * @see minimumFractionDigits
         * @see precision
         */
        get: function () {
            return this.getPropertyValue("maximumFractionDigits");
        },
        set: function (val) {
            if (val < -1 || val > 20)
                return;
            this.setPropertyValue("maximumFractionDigits", val);
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(QuestionExpressionModel.prototype, "minimumFractionDigits", {
        /**
         * The minimum number of fraction digits. Applies only if the `displayStyle` property is not `"none"`. Accepts values in the range from -1 to 20, where -1 disables the property.
         *
         * Default value: -1
         * @see displayStyle
         * @see maximumFractionDigits
         */
        get: function () {
            return this.getPropertyValue("minimumFractionDigits");
        },
        set: function (val) {
            if (val < -1 || val > 20)
                return;
            this.setPropertyValue("minimumFractionDigits", val);
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(QuestionExpressionModel.prototype, "runIfReadOnly", {
        get: function () {
            return this.runIfReadOnlyValue === true;
        },
        set: function (val) {
            this.runIfReadOnlyValue = val;
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(QuestionExpressionModel.prototype, "formatedValue", {
        get: function () {
            return this.getPropertyValue("formatedValue", "");
        },
        enumerable: false,
        configurable: true
    });
    QuestionExpressionModel.prototype.updateFormatedValue = function () {
        this.setPropertyValue("formatedValue", this.getDisplayValueCore(false, this.value));
    };
    QuestionExpressionModel.prototype.onValueChanged = function () {
        this.updateFormatedValue();
    };
    QuestionExpressionModel.prototype.updateValueFromSurvey = function (newValue, clearData) {
        _super.prototype.updateValueFromSurvey.call(this, newValue, clearData);
        this.updateFormatedValue();
    };
    QuestionExpressionModel.prototype.getDisplayValueCore = function (keysAsText, value) {
        var val = value === undefined || value === null ? this.defaultValue : value;
        var res = "";
        if (!this.isValueEmpty(val)) {
            var str = this.getValueAsStr(val);
            res = !this.format ? str : this.format["format"](str);
        }
        if (!!this.survey) {
            res = this.survey.getExpressionDisplayValue(this, val, res);
        }
        return res;
    };
    Object.defineProperty(QuestionExpressionModel.prototype, "displayStyle", {
        /**
         * Specifies a display style for the question value.
         *
         * Possible values:
         *
         * - `"decimal"`
         * - `"currency"`
         * - `"percent"`
         * - `"date"`
         * - `"none"` (default)
         *
         * If you use the `"currency"` display style, you can also set the `currency` property to specify a currency other than USD.
         * @see currency
         * @see minimumFractionDigits
         * @see maximumFractionDigits
         * @see format
         */
        get: function () {
            return this.getPropertyValue("displayStyle");
        },
        set: function (val) {
            this.setPropertyValue("displayStyle", val);
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(QuestionExpressionModel.prototype, "currency", {
        /**
         * A three-letter currency code. Applies only if the `displayStyle` property is set to `"currency"`.
         *
         * Default value: "USD".
         * @see displayStyle
         * @see minimumFractionDigits
         * @see maximumFractionDigits
         * @see format
         */
        get: function () {
            return this.getPropertyValue("currency");
        },
        set: function (val) {
            if (getCurrecyCodes().indexOf(val) < 0)
                return;
            this.setPropertyValue("currency", val);
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(QuestionExpressionModel.prototype, "useGrouping", {
        /**
         * Specifies whether to use grouping separators in number representation. Separators depend on the selected [locale](https://surveyjs.io/form-library/documentation/surveymodel#locale).
         *
         * Default value: `true`
         */
        get: function () {
            return this.getPropertyValue("useGrouping");
        },
        set: function (val) {
            this.setPropertyValue("useGrouping", val);
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(QuestionExpressionModel.prototype, "precision", {
        /**
         * Specifies how many decimal digits to keep in the expression value.
         *
         * Default value: -1 (unlimited)
         * @see maximumFractionDigits
         */
        get: function () {
            return this.getPropertyValue("precision");
        },
        set: function (val) {
            this.setPropertyValue("precision", val);
        },
        enumerable: false,
        configurable: true
    });
    QuestionExpressionModel.prototype.roundValue = function (val) {
        if (val === Infinity)
            return undefined;
        if (this.precision < 0)
            return val;
        if (!helpers_Helpers.isNumber(val))
            return val;
        return parseFloat(val.toFixed(this.precision));
    };
    QuestionExpressionModel.prototype.getValueAsStr = function (val) {
        if (this.displayStyle == "date") {
            var d = createDate("question-expression", val);
            if (!!d && !!d.toLocaleDateString)
                return d.toLocaleDateString();
        }
        if (this.displayStyle != "none" && helpers_Helpers.isNumber(val)) {
            var locale = this.getLocale();
            if (!locale)
                locale = "en";
            var options = {
                style: this.displayStyle,
                currency: this.currency,
                useGrouping: this.useGrouping,
            };
            if (this.maximumFractionDigits > -1) {
                options["maximumFractionDigits"] = this.maximumFractionDigits;
            }
            if (this.minimumFractionDigits > -1) {
                options["minimumFractionDigits"] = this.minimumFractionDigits;
            }
            return val.toLocaleString(locale, options);
        }
        return val.toString();
    };
    return QuestionExpressionModel;
}(question_Question));

function getCurrecyCodes() {
    return [
        "AED",
        "AFN",
        "ALL",
        "AMD",
        "ANG",
        "AOA",
        "ARS",
        "AUD",
        "AWG",
        "AZN",
        "BAM",
        "BBD",
        "BDT",
        "BGN",
        "BHD",
        "BIF",
        "BMD",
        "BND",
        "BOB",
        "BOV",
        "BRL",
        "BSD",
        "BTN",
        "BWP",
        "BYN",
        "BZD",
        "CAD",
        "CDF",
        "CHE",
        "CHF",
        "CHW",
        "CLF",
        "CLP",
        "CNY",
        "COP",
        "COU",
        "CRC",
        "CUC",
        "CUP",
        "CVE",
        "CZK",
        "DJF",
        "DKK",
        "DOP",
        "DZD",
        "EGP",
        "ERN",
        "ETB",
        "EUR",
        "FJD",
        "FKP",
        "GBP",
        "GEL",
        "GHS",
        "GIP",
        "GMD",
        "GNF",
        "GTQ",
        "GYD",
        "HKD",
        "HNL",
        "HRK",
        "HTG",
        "HUF",
        "IDR",
        "ILS",
        "INR",
        "IQD",
        "IRR",
        "ISK",
        "JMD",
        "JOD",
        "JPY",
        "KES",
        "KGS",
        "KHR",
        "KMF",
        "KPW",
        "KRW",
        "KWD",
        "KYD",
        "KZT",
        "LAK",
        "LBP",
        "LKR",
        "LRD",
        "LSL",
        "LYD",
        "MAD",
        "MDL",
        "MGA",
        "MKD",
        "MMK",
        "MNT",
        "MOP",
        "MRO",
        "MUR",
        "MVR",
        "MWK",
        "MXN",
        "MXV",
        "MYR",
        "MZN",
        "NAD",
        "NGN",
        "NIO",
        "NOK",
        "NPR",
        "NZD",
        "OMR",
        "PAB",
        "PEN",
        "PGK",
        "PHP",
        "PKR",
        "PLN",
        "PYG",
        "QAR",
        "RON",
        "RSD",
        "RUB",
        "RWF",
        "SAR",
        "SBD",
        "SCR",
        "SDG",
        "SEK",
        "SGD",
        "SHP",
        "SLL",
        "SOS",
        "SRD",
        "SSP",
        "STD",
        "SVC",
        "SYP",
        "SZL",
        "THB",
        "TJS",
        "TMT",
        "TND",
        "TOP",
        "TRY",
        "TTD",
        "TWD",
        "TZS",
        "UAH",
        "UGX",
        "USD",
        "USN",
        "UYI",
        "UYU",
        "UZS",
        "VEF",
        "VND",
        "VUV",
        "WST",
        "XAF",
        "XAG",
        "XAU",
        "XBA",
        "XBB",
        "XBC",
        "XBD",
        "XCD",
        "XDR",
        "XOF",
        "XPD",
        "XPF",
        "XPT",
        "XSU",
        "XTS",
        "XUA",
        "XXX",
        "YER",
        "ZAR",
        "ZMW",
        "ZWL",
    ];
}
Serializer.addClass("expression", [
    "expression:expression",
    { name: "format", serializationProperty: "locFormat" },
    {
        name: "displayStyle",
        default: "none",
        choices: ["none", "decimal", "currency", "percent", "date"],
    },
    {
        name: "currency",
        choices: function () {
            return getCurrecyCodes();
        },
        default: "USD",
        visibleIf: function (obj) {
            return obj.displayStyle === "currency";
        }
    },
    { name: "maximumFractionDigits:number", default: -1 },
    { name: "minimumFractionDigits:number", default: -1 },
    { name: "useGrouping:boolean", default: true },
    { name: "precision:number", default: -1, category: "data" },
    { name: "enableIf", visible: false },
    { name: "isRequired", visible: false },
    { name: "readOnly", visible: false },
    { name: "requiredErrorText", visible: false },
    { name: "resetValueIf", visible: false },
    { name: "setValueIf", visible: false },
    { name: "setValueExpression", visible: false },
    { name: "defaultValueExpression", visible: false },
    { name: "defaultValue", visible: false },
    { name: "correctAnswer", visible: false },
    { name: "requiredIf", visible: false }
], function () {
    return new question_expression_QuestionExpressionModel("");
}, "question");
questionfactory_QuestionFactory.Instance.registerQuestion("expression", function (name) {
    return new question_expression_QuestionExpressionModel(name);
});

// CONCATENATED MODULE: ./packages/survey-core/src/question_matrixdropdowncolumn.ts
var question_matrixdropdowncolumn_extends = (undefined && undefined.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();




function onUpdateSelectBaseCellQuestion(cellQuestion, column, question, data) {
    cellQuestion.storeOthersAsComment = !!question
        ? question.storeOthersAsComment
        : false;
    if ((!cellQuestion.choices || cellQuestion.choices.length == 0) &&
        cellQuestion.choicesByUrl.isEmpty) {
        cellQuestion.choices = question.choices;
    }
    if (!cellQuestion.choicesByUrl.isEmpty) {
        cellQuestion.choicesByUrl.run(data.getTextProcessor());
    }
}
function onUpdateSelectDropdownCellQuestion(cellQuestion, column, question, data) {
    onUpdateSelectBaseCellQuestion(cellQuestion, column, question, data);
    if (!!cellQuestion.locPlaceholder && cellQuestion.locPlaceholder.isEmpty && !question.locPlaceholder.isEmpty) {
        cellQuestion.optionsCaption = question.optionsCaption;
    }
}
var matrixDropdownColumnTypes = {
    dropdown: {
        onCellQuestionUpdate: function (cellQuestion, column, question, data) {
            onUpdateSelectDropdownCellQuestion(cellQuestion, column, question, data);
        }
    },
    checkbox: {
        onCellQuestionUpdate: function (cellQuestion, column, question, data) {
            onUpdateSelectBaseCellQuestion(cellQuestion, column, question, data);
            cellQuestion.colCount =
                column.colCount > -1 ? column.colCount : question.columnColCount;
        },
    },
    radiogroup: {
        onCellQuestionUpdate: function (cellQuestion, column, question, data) {
            onUpdateSelectBaseCellQuestion(cellQuestion, column, question, data);
            cellQuestion.colCount =
                column.colCount > -1 ? column.colCount : question.columnColCount;
        },
    },
    tagbox: {
        onCellQuestionUpdate: function (cellQuestion, column, question, data) {
            onUpdateSelectBaseCellQuestion(cellQuestion, column, question, data);
        }
    },
    text: {},
    comment: {},
    boolean: {
        onCellQuestionUpdate: function (cellQuestion, column, question, data) {
            cellQuestion.renderAs = column.renderAs;
        },
    },
    expression: {},
    rating: {},
};
/**
 * An auxiliary class that describes a column in a [Multi-Select Matrix](https://surveyjs.io/form-library/documentation/api-reference/matrix-table-with-dropdown-list) or [Dynamic Matrix](https://surveyjs.io/form-library/documentation/api-reference/dynamic-matrix-table-question-model).
 *
 * You can get an object of this class from the [`columns`](https://surveyjs.io/form-library/documentation/api-reference/matrix-table-with-dropdown-list#columns) array or by calling the [`getColumnByName()`](https://surveyjs.io/form-library/documentation/api-reference/matrix-table-with-dropdown-list#getColumnByName) method on a matrix instance.
 */
var question_matrixdropdowncolumn_MatrixDropdownColumn = /** @class */ (function (_super) {
    question_matrixdropdowncolumn_extends(MatrixDropdownColumn, _super);
    function MatrixDropdownColumn(name, title, colOwner) {
        var _this = _super.call(this) || this;
        _this.indexValue = -1;
        _this._hasVisibleCell = true;
        _this.isColumnsVisibleIf = true;
        _this.previousChoicesId = undefined;
        _this.colOwnerValue = colOwner;
        _this.createLocalizableString("totalFormat", _this);
        _this.createLocalizableString("cellHint", _this);
        _this.registerPropertyChangedHandlers(["showInMultipleColumns"], function () { _this.doShowInMultipleColumnsChanged(); });
        _this.registerPropertyChangedHandlers(["visible"], function () { _this.doColumnVisibilityChanged(); });
        _this.updateTemplateQuestion(undefined, name, title);
        return _this;
    }
    MatrixDropdownColumn.getColumnTypes = function () {
        var res = [];
        for (var key in matrixDropdownColumnTypes) {
            res.push(key);
        }
        return res;
    };
    MatrixDropdownColumn.prototype.getOriginalObj = function () {
        return this.templateQuestion;
    };
    MatrixDropdownColumn.prototype.getClassNameProperty = function () {
        return "cellType";
    };
    MatrixDropdownColumn.prototype.getSurvey = function (live) {
        if (live === void 0) { live = false; }
        return !!this.colOwner ? this.colOwner.survey : null;
    };
    MatrixDropdownColumn.prototype.endLoadingFromJson = function () {
        var _this = this;
        _super.prototype.endLoadingFromJson.call(this);
        this.templateQuestion.autoOtherMode = this.isShowInMultipleColumns;
        this.templateQuestion.endLoadingFromJson();
        this.templateQuestion.onGetSurvey = function () {
            return _this.getSurvey();
        };
    };
    MatrixDropdownColumn.prototype.getDynamicPropertyName = function () {
        return "cellType";
    };
    MatrixDropdownColumn.prototype.getDynamicType = function () {
        if (this.cellType === "default")
            return "question";
        return this.calcCellQuestionType(null);
    };
    Object.defineProperty(MatrixDropdownColumn.prototype, "colOwner", {
        get: function () {
            return this.colOwnerValue;
        },
        set: function (value) {
            this.colOwnerValue = value;
            if (!!value) {
                this.updateTemplateQuestion();
                this.setParentQuestionToTemplate(this.templateQuestion);
            }
        },
        enumerable: false,
        configurable: true
    });
    MatrixDropdownColumn.prototype.locStrsChanged = function () {
        _super.prototype.locStrsChanged.call(this);
        this.locTitle.strChanged();
    };
    MatrixDropdownColumn.prototype.addUsedLocales = function (locales) {
        _super.prototype.addUsedLocales.call(this, locales);
        this.templateQuestion.addUsedLocales(locales);
    };
    Object.defineProperty(MatrixDropdownColumn.prototype, "index", {
        get: function () {
            return this.indexValue;
        },
        enumerable: false,
        configurable: true
    });
    MatrixDropdownColumn.prototype.setIndex = function (val) {
        this.indexValue = val;
    };
    MatrixDropdownColumn.prototype.getType = function () {
        return "matrixdropdowncolumn";
    };
    Object.defineProperty(MatrixDropdownColumn.prototype, "cellType", {
        /**
         * Specifies the type of column cells.
         *
         * Possible values:
         *
         * - [`"dropdown"`](https://surveyjs.io/form-library/documentation/api-reference/dropdown-menu-model)
         * - [`"checkbox"`](https://surveyjs.io/form-library/documentation/api-reference/checkbox-question-model)
         * - [`"radiogroup"`](https://surveyjs.io/form-library/documentation/api-reference/radio-button-question-model)
         * - [`"tagbox"`](https://surveyjs.io/form-library/documentation/api-reference/dropdown-tag-box-model)
         * - [`"text"`](https://surveyjs.io/form-library/documentation/api-reference/text-entry-question-model)
         * - [`"comment"`](https://surveyjs.io/form-library/documentation/api-reference/comment-field-model)
         * - [`"boolean"`](https://surveyjs.io/form-library/documentation/api-reference/boolean-question-model)
         * - [`"expression"`](https://surveyjs.io/form-library/documentation/api-reference/expression-model)
         * - [`"rating"`](https://surveyjs.io/form-library/documentation/api-reference/rating-scale-question-model)
         * - `"default"` (default) - Inherits the input type from the [`cellType`](https://surveyjs.io/form-library/documentation/api-reference/matrix-table-with-dropdown-list#cellType) property specified for the parent matrix.
         *
         * The input types are based upon standalone question types. Depending on the selected input type, the matrix column can have additional configuration properties inherited from the corresponding question type. For instance, Dropdown, Checkboxes, Radio Button Group, and Tag Box columns can specify the [`choices`](https://surveyjs.io/form-library/documentation/api-reference/radio-button-question-model#choices) array, similar to the question types upon which they are based. Refer to the API Reference of these question types for a full list of available properties.
         *
         * [View Demo](https://surveyjs.io/form-library/examples/aggregate-data-within-form/ (linkStyle))
         */
        get: function () {
            return this.getPropertyValue("cellType");
        },
        set: function (val) {
            val = val.toLocaleLowerCase();
            this.updateTemplateQuestion(val);
            this.setPropertyValue("cellType", val);
            if (!!this.colOwner) {
                this.colOwner.onColumnCellTypeChanged(this);
            }
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(MatrixDropdownColumn.prototype, "templateQuestion", {
        get: function () {
            return this.templateQuestionValue;
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(MatrixDropdownColumn.prototype, "value", {
        get: function () {
            return this.templateQuestion.name;
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(MatrixDropdownColumn.prototype, "isVisible", {
        //For filtering columns
        get: function () {
            return true;
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(MatrixDropdownColumn.prototype, "isColumnVisible", {
        get: function () {
            if (this.isDesignMode)
                return true;
            return this.visible && this.hasVisibleCell;
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(MatrixDropdownColumn.prototype, "visible", {
        /**
         * Gets or sets column visibility.
         *
         * If you want to display or hide a column based on a condition, specify the [`visibleIf`](#visibleIf) property.
         * @see isRequired
         * @see readOnly
         */
        get: function () { return this.templateQuestion.visible; },
        set: function (val) {
            this.templateQuestion.visible = val;
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(MatrixDropdownColumn.prototype, "hasVisibleCell", {
        get: function () {
            return this._hasVisibleCell;
        },
        set: function (newVal) {
            this._hasVisibleCell = newVal;
        },
        enumerable: false,
        configurable: true
    });
    MatrixDropdownColumn.prototype.getVisibleMultipleChoices = function () {
        var choices = this.templateQuestion.visibleChoices;
        if (!Array.isArray(choices))
            return [];
        if (!Array.isArray(this._visiblechoices))
            return choices;
        var res = new Array();
        for (var i = 0; i < choices.length; i++) {
            var item = choices[i];
            if (this._visiblechoices.indexOf(item.value) > -1)
                res.push(item);
        }
        return res;
    };
    Object.defineProperty(MatrixDropdownColumn.prototype, "getVisibleChoicesInCell", {
        get: function () {
            if (Array.isArray(this._visiblechoices))
                return this._visiblechoices;
            var res = this.templateQuestion.visibleChoices;
            return Array.isArray(res) ? res : [];
        },
        enumerable: false,
        configurable: true
    });
    MatrixDropdownColumn.prototype.setVisibleChoicesInCell = function (val) {
        this._visiblechoices = val;
    };
    Object.defineProperty(MatrixDropdownColumn.prototype, "isFilteredMultipleColumns", {
        get: function () {
            if (!this.showInMultipleColumns)
                return false;
            var choices = this.templateQuestion.choices;
            if (!Array.isArray(choices))
                return false;
            for (var i = 0; i < choices.length; i++) {
                if (choices[i].visibleIf)
                    return true;
            }
            return false;
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(MatrixDropdownColumn.prototype, "name", {
        /**
         * A column ID that is not visible to respondents.
         *
         * > Column IDs must be unique.
         * @see title
         */
        get: function () {
            return this.templateQuestion.name;
        },
        set: function (val) {
            this.templateQuestion.name = val;
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(MatrixDropdownColumn.prototype, "title", {
        /**
         * A user-friendly column caption to display. If `title` is undefined, [`name`](#name) is displayed instead.
         */
        get: function () {
            return this.templateQuestion.title;
        },
        set: function (val) {
            this.templateQuestion.title = val;
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(MatrixDropdownColumn.prototype, "locTitle", {
        get: function () {
            return this.templateQuestion.locTitle;
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(MatrixDropdownColumn.prototype, "fullTitle", {
        get: function () {
            return this.locTitle.textOrHtml;
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(MatrixDropdownColumn.prototype, "isRequired", {
        /**
         * Marks the column as required. If a respondent skips any cell in a required column, the matrix displays a [validation error](#requiredErrorText).
         *
         * If you want to mark the column as required based on a condition, specify the [`requiredIf`](#requiredIf) property.
         * @see visible
         * @see readOnly
         */
        get: function () {
            return this.templateQuestion.isRequired;
        },
        set: function (val) {
            this.templateQuestion.isRequired = val;
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(MatrixDropdownColumn.prototype, "isRenderedRequired", {
        get: function () {
            return this.getPropertyValue("isRenderedRequired", this.isRequired);
        },
        set: function (val) {
            this.setPropertyValue("isRenderedRequired", val);
        },
        enumerable: false,
        configurable: true
    });
    MatrixDropdownColumn.prototype.updateIsRenderedRequired = function (val) {
        this.isRenderedRequired = val || this.isRequired;
    };
    Object.defineProperty(MatrixDropdownColumn.prototype, "requiredText", {
        get: function () {
            return this.isRenderedRequired && this.getSurvey() ? this.getSurvey().requiredText : this.templateQuestion.requiredText;
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(MatrixDropdownColumn.prototype, "requiredErrorText", {
        /**
         * Specifies a custom error message for a required column.
         * @see isRequired
         */
        get: function () {
            return this.templateQuestion.requiredErrorText;
        },
        set: function (val) {
            this.templateQuestion.requiredErrorText = val;
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(MatrixDropdownColumn.prototype, "locRequiredErrorText", {
        get: function () {
            return this.templateQuestion.locRequiredErrorText;
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(MatrixDropdownColumn.prototype, "readOnly", {
        /**
         * Makes the column read-only.
         *
         * If you want to switch the column to the read-only state based on a condition, specify the [`enableIf`](#enableIf) property.
         * @see visible
         * @see isRequired
   