import { SurveyModel } from "../survey";
import { EventBase } from "../base";
import { IShortcutText, ISurvey } from "../base-interfaces";
import { IDragDropEngine } from "./engine";
import { IDragDropDOMAdapter } from "./dom-adapter";
export declare abstract class DragDropCore<T> implements IDragDropEngine {
    private surveyValue?;
    private creator?;
    private _isBottom;
    isBottom: boolean;
    onGhostPositionChanged: EventBase<{}>;
    protected ghostPositionChanged(): void;
    onDragStart: EventBase<DragDropCore<T>>;
    onDragEnd: EventBase<DragDropCore<T>>;
    onDragClear: EventBase<DragDropCore<T>>;
    onBeforeDrop: EventBase<DragDropCore<T>, any>;
    onAfterDrop: EventBase<DragDropCore<T>, any>;
    draggedElement: any;
    protected abstract readonly draggedElementType: string;
    protected parentElement: T;
    dropTarget: any;
    protected readonly dropTargetDataAttributeName: string;
    protected readonly survey: SurveyModel;
    prevDropTarget: any;
    protected allowDropHere: boolean;
    protected domAdapter: IDragDropDOMAdapter;
    constructor(surveyValue?: ISurvey, creator?: any, longTap?: boolean, domAdapter?: IDragDropDOMAdapter);
    startDrag(event: PointerEvent, draggedElement: any, parentElement?: any, draggedElementNode?: HTMLElement, preventSaveTargetNode?: boolean): void;
    private getRootElement;
    dragInit(event: PointerEvent, draggedElement: any, parentElement?: any, draggedElementNode?: HTMLElement): void;
    protected onStartDrag(event?: PointerEvent): void;
    protected isDropTargetDoesntChanged(newIsBottom: boolean): boolean;
    protected getShortcutText(draggedElement: IShortcutText): string;
    protected createDraggedElementShortcut(text: string, draggedElementNode?: HTMLElement, event?: PointerEvent): HTMLElement;
    protected getDraggedElementClass(): string;
    protected doDragOver(): void;
    protected afterDragOver(dropTargetNode: HTMLElement): void;
    protected abstract isDropTargetValid(dropTarget: any, dropTargetNode?: HTMLElement): boolean;
    protected banDropHere: () => void;
    protected doBanDropHere: () => void;
    protected findDropTargetNodeFromPoint(clientX: number, clientY: number): HTMLElement;
    protected getDataAttributeValueByNode(node: HTMLElement): string;
    protected getDropTargetByNode(dropTargetNode: HTMLElement, event: PointerEvent): any;
    private capitalizeFirstLetter;
    protected abstract getDropTargetByDataAttributeValue(dataAttributeValue: string, dropTargetNode?: HTMLElement, event?: PointerEvent): any;
    protected calculateVerticalMiddleOfHTMLElement(HTMLElement: HTMLElement): number;
    protected calculateHorizontalMiddleOfHTMLElement(HTMLElement: HTMLElement): number;
    protected calculateIsBottom(clientY: number, dropTargetNode?: HTMLElement): boolean;
    protected findDropTargetNodeByDragOverNode(dragOverNode: HTMLElement): HTMLElement;
    dragOver(event: PointerEvent): void;
    protected abstract doDrop(): any;
    drop(): void;
    clear(): void;
}
