import { Question } from "./question";
import { Base } from "./base";
import { ItemValue } from "./itemvalue";
import { LocalizableString } from "./localizablestring";
import { PanelModel } from "./panel";
import { IAction } from "./actions/action";
import { MatrixDropdownColumn } from "./question_matrixdropdowncolumn";
import { MatrixDropdownCell, MatrixDropdownRowModelBase, QuestionMatrixDropdownModelBase } from "./question_matrixdropdownbase";
export declare class QuestionMatrixDropdownRenderedCell {
    private static counter;
    private idValue;
    private itemValue;
    minWidth: string;
    width: string;
    locTitle: LocalizableString;
    cell: MatrixDropdownCell;
    column: MatrixDropdownColumn;
    row: MatrixDropdownRowModelBase;
    question: Question;
    isRemoveRow: boolean;
    choiceIndex: number;
    isOtherChoice: boolean;
    matrix: QuestionMatrixDropdownModelBase;
    isEmpty: boolean;
    colSpans: number;
    panel: PanelModel;
    isShowHideDetail: boolean;
    isActionsCell: boolean;
    isErrorsCell: boolean;
    isDragHandlerCell: boolean;
    isDetailRowCell: boolean;
    private classNameValue;
    constructor();
    readonly requiredText: string;
    readonly hasQuestion: boolean;
    readonly hasTitle: boolean;
    readonly hasPanel: boolean;
    readonly id: number;
    item: ItemValue;
    readonly isChoice: boolean;
    readonly isItemChoice: boolean;
    readonly choiceValue: any;
    readonly isCheckbox: boolean;
    readonly isRadio: boolean;
    readonly isFirstChoice: boolean;
    className: string;
    readonly cellQuestionWrapperClassName: string;
    readonly showResponsiveTitle: boolean;
    readonly responsiveTitleCss: string;
    readonly responsiveLocTitle: LocalizableString;
    readonly headers: string;
    getTitle(): string;
    calculateFinalClassName(matrixCssClasses: any): string;
    focusIn(): void;
}
export declare class QuestionMatrixDropdownRenderedRow extends Base {
    cssClasses: any;
    isDetailRow: boolean;
    isGhostRow: boolean;
    isAdditionalClasses: boolean;
    visible: boolean;
    onVisibilityChangedCallback: () => void;
    hasEndActions: boolean;
    row: MatrixDropdownRowModelBase;
    isErrorsRow: boolean;
    private static counter;
    private idValue;
    cells: Array<QuestionMatrixDropdownRenderedCell>;
    constructor(cssClasses: any, isDetailRow?: boolean);
    readonly id: number;
    readonly attributes: {
        "data-sv-drop-target-matrix-row"?: undefined;
    } | {
        "data-sv-drop-target-matrix-row": string;
    };
    readonly className: string;
    private rootElement;
    setRootElement(val: HTMLTableRowElement): void;
    getRootElement(): HTMLTableRowElement;
}
export declare class QuestionMatrixDropdownRenderedErrorRow extends QuestionMatrixDropdownRenderedRow {
    isErrorsRow: boolean;
    constructor(cssClasses: any);
    readonly attributes: {};
    readonly className: string;
    onAfterCreated(): void;
}
export declare class QuestionMatrixDropdownRenderedTable extends Base {
    matrix: QuestionMatrixDropdownModelBase;
    private headerRowValue;
    private footerRowValue;
    private hasRemoveRowsValue;
    private rowsActions;
    private cssClasses;
    rows: Array<QuestionMatrixDropdownRenderedRow>;
    protected getIsAnimationAllowed(): boolean;
    private getRenderedRowsAnimationOptions;
    private _renderedRows;
    updateRenderedRows(): void;
    private renderedRowsAnimation;
    renderedRows: Array<QuestionMatrixDropdownRenderedRow>;
    constructor(matrix: QuestionMatrixDropdownModelBase);
    readonly showTable: boolean;
    readonly showHeader: boolean;
    readonly showAddRow: boolean;
    readonly showAddRowOnTop: boolean;
    readonly showAddRowOnBottom: boolean;
    readonly showFooter: boolean;
    readonly hasFooter: boolean;
    readonly hasRemoveRows: boolean;
    isRequireReset(): boolean;
    readonly headerRow: QuestionMatrixDropdownRenderedRow;
    readonly footerRow: QuestionMatrixDropdownRenderedRow;
    readonly isRowsDragAndDrop: boolean;
    private readonly showCellErrorsTop: any;
    private readonly showCellErrorsBottom: any;
    protected build(): void;
    updateShowTableAndAddRow(): void;
    onAddedRow(row: MatrixDropdownRowModelBase, index: number): void;
    private getRenderedRowIndexByIndex;
    private getRenderedDataRowCount;
    onRemovedRow(row: MatrixDropdownRowModelBase): void;
    onDetailPanelChangeVisibility(row: MatrixDropdownRowModelBase, isShowing: boolean): void;
    private getRenderedRowIndex;
    protected buildRowsActions(): void;
    protected createRenderedRow(cssClasses: any, isDetailRow?: boolean): QuestionMatrixDropdownRenderedRow;
    protected createErrorRenderedRow(cssClasses: any): QuestionMatrixDropdownRenderedErrorRow;
    protected buildHeader(): void;
    protected buildFooter(): void;
    protected buildRows(): void;
    private hasActionCellInRowsValues;
    private hasActionCellInRows;
    private hasActionsCellInLocaltion;
    private canRemoveRow;
    private buildHorizontalRows;
    private addHorizontalRow;
    private getRowDragCell;
    private getActionsCellClassName;
    private getRowActionsCell;
    private getRowActions;
    private buildRowActions;
    private readonly showRemoveButtonAsIcon: any;
    protected setDefaultRowActions(row: MatrixDropdownRowModelBase, actions: Array<IAction>): void;
    private createErrorRow;
    private createHorizontalRow;
    private addRowActionsCell;
    private createDetailPanelRow;
    private buildVerticalRows;
    private createMutlipleVerticalRows;
    private createVerticalRow;
    private createEndVerticalActionRow;
    private createMutlipleEditCells;
    private setItemCellCssClasses;
    private createEditCell;
    private createErrorCell;
    private createMutlipleColumnsFooter;
    private createMutlipleColumnsHeader;
    private getMultipleColumnChoices;
    private setHeaderCellCssClasses;
    private createHeaderCell;
    private setHeaderCell;
    private setHeaderCellWidth;
    private createTextCell;
    private createEmptyCell;
}
