export declare var Version: string;
export declare var ReleaseDate: string;
export declare function checkLibraryVersion(ver: string, libraryName: string): void;
export declare function setLicenseKey(key: string): void;
export declare function slk(key: string): void;
export declare function hasLicense(index: number): boolean;
export { settings, ISurveyEnvironment } from "../../src/settings";
export { Helpers, HashTable } from "../../src/helpers";
export { AnswerCountValidator, EmailValidator, NumericValidator, RegexValidator, SurveyValidator, TextValidator, ValidatorResult, ExpressionValidator, ValidatorRunner } from "../../src/validator";
export { ItemValue } from "../../src/itemvalue";
export { Base, Event, EventBase, ArrayChanges, ComputedUpdater } from "../../src/base";
export { ISurvey, ISurveyElement, IElement, IQuestion, IPage, IPanel, ISurveyData, ITitleOwner, ISurveyLayoutElement, IPlainDataOptions as IPlainData, IShortcutText, ILoadFromJSONOptions, ISaveToJSONOptions, HorizontalAlignment, VerticalAlignment } from "../../src/base-interfaces";
export { SurveyError } from "../../src/survey-error";
export { SurveyElementCore, SurveyElement, DragTypeOverMeEnum } from "../../src/survey-element";
export { CalculatedValue } from "../../src/calculatedValue";
export { CustomError, AnswerRequiredError, OneAnswerRequiredError, RequreNumericError, ExceedSizeError } from "../../src/error";
export { ILocalizableOwner, ILocalizableString, LocalizableString, LocalizableStrings } from "../../src/localizablestring";
export { HtmlConditionItem, UrlConditionItem } from "../../src/expressionItems";
export { ChoicesRestful, ChoicesRestfull } from "../../src/choicesRestful";
export { FunctionFactory, registerFunction } from "../../src/functionsfactory";
export { ConditionRunner, ExpressionRunner, IExpresionExecutor, ExpressionExecutor } from "../../src/conditions";
export { Operand, Const, BinaryOperand, Variable, FunctionOperand, ArrayOperand, UnaryOperand } from "../../src/expressions/expressions";
export { ConditionsParser } from "../../src/conditionsParser";
export { ProcessValue } from "../../src/conditionProcessValue";
export { JsonError, JsonIncorrectTypeError, JsonMetadata, JsonMetadataClass, JsonMissingTypeError, JsonMissingTypeErrorBase, JsonObject, IJsonPropertyInfo, JsonObjectProperty, JsonRequiredPropertyError, JsonUnknownPropertyError, Serializer, property, propertyArray } from "../../src/jsonobject";
export { IMatrixDropdownData, MatrixDropdownCell, MatrixDropdownRowModelBase, QuestionMatrixDropdownModelBase } from "../../src/question_matrixdropdownbase";
export { MatrixDropdownColumn, matrixDropdownColumnTypes } from "../../src/question_matrixdropdowncolumn";
export { QuestionMatrixDropdownRenderedCell, QuestionMatrixDropdownRenderedRow, QuestionMatrixDropdownRenderedErrorRow, QuestionMatrixDropdownRenderedTable } from "../../src/question_matrixdropdownrendered";
export { MatrixDropdownRowModel, QuestionMatrixDropdownModel } from "../../src/question_matrixdropdown";
export { MatrixDynamicRowModel, QuestionMatrixDynamicModel } from "../../src/question_matrixdynamic";
export { MatrixRowModel, MatrixCells, QuestionMatrixModel, IMatrixData } from "../../src/question_matrix";
export { QuestionMatrixBaseModel } from "../../src/martixBase";
export { MultipleTextItemModel, MultipleTextCell, MultipleTextErrorCell, MutlipleTextErrorRow, MutlipleTextRow, QuestionMultipleTextModel, MultipleTextEditorModel } from "../../src/question_multipletext";
export { PanelModel, PanelModelBase, QuestionRowModel } from "../../src/panel";
export { FlowPanelModel } from "../../src/flowpanel";
export { PageModel } from "../../src/page";
export * from "../../src/template-renderer";
export { DefaultTitleModel } from "../../src/defaultTitle";
export { Question } from "../../src/question";
export { QuestionNonValue } from "../../src/questionnonvalue";
export { QuestionEmptyModel } from "../../src/question_empty";
export { QuestionCheckboxBase, QuestionSelectBase } from "../../src/question_baseselect";
export { QuestionCheckboxModel } from "../../src/question_checkbox";
export { QuestionTagboxModel } from "../../src/question_tagbox";
export { QuestionRankingModel } from "../../src/question_ranking";
export { QuestionCommentModel } from "../../src/question_comment";
export { QuestionDropdownModel } from "../../src/question_dropdown";
export { QuestionFactory, ElementFactory } from "../../src/questionfactory";
export { QuestionFileModel, QuestionFilePage } from "../../src/question_file";
export { QuestionHtmlModel } from "../../src/question_html";
export { QuestionRadiogroupModel } from "../../src/question_radiogroup";
export { QuestionRatingModel, RenderedRatingItem } from "../../src/question_rating";
export { QuestionExpressionModel } from "../../src/question_expression";
export { QuestionTextBase, CharacterCounter } from "../../src/question_textbase";
export { QuestionTextModel } from "../../src/question_text";
export { QuestionBooleanModel } from "../../src/question_boolean";
export { QuestionImagePickerModel, ImageItemValue } from "../../src/question_imagepicker";
export { QuestionImageModel } from "../../src/question_image";
export { QuestionSignaturePadModel } from "../../src/question_signaturepad";
export { QuestionPanelDynamicModel, QuestionPanelDynamicItem } from "../../src/question_paneldynamic";
export { SurveyTimer } from "../../src/surveytimer";
export { SurveyTimerModel } from "../../src/surveyTimerModel";
export * from "../../src/surveyToc";
export { SurveyProgressModel } from "../../src/surveyProgress";
export { ProgressButtons, ProgressButtonsResponsivityManager, IProgressButtonsViewModel } from "../../src/progress-buttons";
export * from "../../src/themes";
export { SurveyModel } from "../../src/survey";
export * from "../../src/survey-events-api";
export { SurveyTrigger, SurveyTriggerComplete, SurveyTriggerSetValue, SurveyTriggerVisible, SurveyTriggerCopyValue, SurveyTriggerRunExpression, SurveyTriggerSkip, Trigger } from "../../src/trigger";
export { PopupSurveyModel, SurveyWindowModel } from "../../src/popup-survey";
export { TextPreProcessor } from "../../src/textPreProcessor";
export { Notifier } from "../../src/notifier";
export { Cover, CoverCell } from "../../src/header";
export { dxSurveyService } from "../../src/dxSurveyService";
export { englishStrings } from "../../src/localization/english";
export { surveyLocalization, surveyStrings, getLocaleString, getLocaleStrings, setupLocale } from "../../src/surveyStrings";
export { QuestionCustomWidget, CustomWidgetCollection, } from "../../src/questionCustomWidgets";
export { QuestionCustomModel, QuestionCompositeModel, ComponentQuestionJSON, ComponentCollection, ICustomQuestionTypeConfiguration } from "../../src/question_custom";
export { ListModel } from "../../src/list";
export { MultiSelectListModel } from "../../src/multiSelectListModel";
export { PopupModel, IDialogOptions } from "../../src/popup";
export { PopupBaseViewModel } from "../../src/popup-view-model";
export { PopupDropdownViewModel } from "../../src/popup-dropdown-view-model";
export { PopupModalViewModel } from "../../src/popup-modal-view-model";
export { createPopupViewModel, createPopupModalViewModel } from "../../src/popup-utils";
export { DropdownListModel } from "../../src/dropdownListModel";
export { DropdownMultiSelectListModel } from "../../src/dropdownMultiSelectListModel";
export { QuestionButtonGroupModel, ButtonGroupItemModel, ButtonGroupItemValue } from "../../src/question_buttongroup";
export { IsMobile, IsTouch, _setIsTouch } from "../../src/utils/devices";
export { confirmAction, confirmActionAsync, detectIEOrEdge, doKey2ClickUp, doKey2ClickDown, doKey2ClickBlur, loadFileFromBase64, increaseHeightByContent, createSvg, chooseFiles, sanitizeEditableContent, prepareElementForVerticalAnimation, cleanHtmlElementAfterAnimation, classesToSelector, IAttachKey2clickOptions, renamedIcons, getIconNameFromProxy } from "../../src/utils/utils";
export { InputMaskBase } from "../../src/mask/mask_base";
export { InputMaskPattern } from "../../src/mask/mask_pattern";
export { InputMaskNumeric } from "../../src/mask/mask_numeric";
export { InputMaskDateTime } from "../../src/mask/mask_datetime";
export { InputMaskCurrency } from "../../src/mask/mask_currency";
export * from "../../src/utils/cssClassBuilder";
export * from "../../src/utils/text-area";
export { surveyCss, defaultCss, defaultThemeName } from "../../src/defaultCss/defaultCss";
export { DragDropCore } from "../../src/dragdrop/core";
export { DragDropChoices } from "../../src/dragdrop/choices";
export { DragDropRankingSelectToRank } from "../../src/dragdrop/ranking-select-to-rank";
