import { Base, EventBase } from "./base";
import { PopupModel } from "./popup";
import { CssClassBuilder } from "./utils/cssClassBuilder";
import { ActionContainer } from "./actions/container";
import { AnimationOptions, IAnimationConsumer } from "./utils/animation";
export declare const FOCUS_INPUT_SELECTOR = "input:not(:disabled):not([readonly]):not([type=hidden]),select:not(:disabled):not([readonly]),textarea:not(:disabled):not([readonly]), button:not(:disabled):not([readonly]), [tabindex]:not([tabindex^=\"-\"])";
export declare class PopupBaseViewModel extends Base implements IAnimationConsumer {
    protected popupSelector: string;
    protected fixedPopupContainer: string;
    protected containerSelector: string;
    protected scrollingContentSelector: string;
    protected prevActiveElement: HTMLElement;
    protected footerToolbarValue: ActionContainer;
    top: string;
    left: string;
    height: string;
    width: string;
    minWidth: string;
    _isVisible: boolean;
    locale: string;
    private updateIsVisible;
    private updateBeforeShowing;
    private updateAfterHiding;
    private visibilityAnimation;
    getLeaveOptions(): AnimationOptions;
    getEnterOptions(): AnimationOptions;
    getAnimatedElement(): HTMLElement;
    isAnimationEnabled(): boolean;
    getRerenderEvent(): EventBase<Base>;
    private getAnimationContainer;
    get isVisible(): boolean;
    set isVisible(val: boolean);
    onVisibilityChanged: EventBase<PopupBaseViewModel, any>;
    get container(): HTMLElement;
    private containerElement;
    private createdContainer;
    getLocale(): string;
    protected hidePopup(): void;
    protected getStyleClass(): CssClassBuilder;
    protected getShowFooter(): boolean;
    protected getShowHeader(): boolean;
    protected getPopupHeaderTemplate(): string;
    protected createFooterActionBar(): void;
    protected resetDimensionsAndPositionStyleProperties(): void;
    protected onModelChanging(newModel: PopupModel): void;
    private onModelIsVisibleChangedCallback;
    private setupModel;
    private _model;
    get model(): PopupModel;
    set model(model: PopupModel);
    constructor(model: PopupModel);
    get title(): string;
    get contentComponentName(): string;
    get contentComponentData(): any;
    get isModal(): boolean;
    get isFocusedContent(): boolean;
    get isFocusedContainer(): boolean;
    get showFooter(): boolean;
    get showHeader(): boolean;
    get popupHeaderTemplate(): string;
    get isOverlay(): boolean;
    get styleClass(): string;
    get cancelButtonText(): string;
    get footerToolbar(): ActionContainer;
    onKeyDown(event: any): void;
    private trapFocus;
    switchFocus(): void;
    protected _isPositionSetValue: boolean;
    get isPositionSet(): boolean;
    updateOnShowing(): void;
    updateOnHiding(): void;
    private focusContainer;
    private focusFirstInput;
    clickOutside(event?: Event): void;
    cancel(): void;
    dispose(): void;
    initializePopupContainer(): void;
    setComponentElement(componentRoot: HTMLElement, targetElement?: HTMLElement | null, areaElement?: HTMLElement | null): void;
    resetComponentElement(): void;
    protected preventScrollOuside(event: any, deltaY: number): void;
}
