import { Question } from "./question";
import { Base } from "./base";
import { ItemValue } from "./itemvalue";
import { LocalizableString } from "./localizablestring";
import { PanelModel } from "./panel";
import { IAction } from "./actions/action";
import { MatrixDropdownColumn } from "./question_matrixdropdowncolumn";
import { MatrixDropdownCell, MatrixDropdownRowModelBase, QuestionMatrixDropdownModelBase } from "./question_matrixdropdownbase";
export declare class QuestionMatrixDropdownRenderedCell {
    private static counter;
    private idValue;
    private itemValue;
    minWidth: string;
    width: string;
    locTitle: LocalizableString;
    cell: MatrixDropdownCell;
    column: MatrixDropdownColumn;
    row: MatrixDropdownRowModelBase;
    question: Question;
    isRemoveRow: boolean;
    choiceIndex: number;
    isOtherChoice: boolean;
    matrix: QuestionMatrixDropdownModelBase;
    isEmpty: boolean;
    colSpans: number;
    panel: PanelModel;
    isShowHideDetail: boolean;
    isActionsCell: boolean;
    isErrorsCell: boolean;
    isDragHandlerCell: boolean;
    isDetailRowCell: boolean;
    private classNameValue;
    constructor();
    get requiredMark(): string;
    get hasQuestion(): boolean;
    get hasTitle(): boolean;
    get hasPanel(): boolean;
    get id(): string;
    get item(): ItemValue;
    set item(val: ItemValue);
    get isChoice(): boolean;
    get isItemChoice(): boolean;
    get choiceValue(): any;
    get isCheckbox(): boolean;
    get isRadio(): boolean;
    get isFirstChoice(): boolean;
    set className(val: string);
    get className(): string;
    get cellQuestionWrapperClassName(): string;
    get isVisible(): boolean;
    get showResponsiveTitle(): boolean;
    get responsiveTitleCss(): string;
    get responsiveLocTitle(): LocalizableString;
    get headers(): string;
    getTitle(): string;
    calculateFinalClassName(matrixCssClasses: any): string;
    focusIn(): void;
}
export declare class QuestionMatrixDropdownRenderedRow extends Base {
    cssClasses: any;
    isDetailRow: boolean;
    isGhostRow: boolean;
    isAdditionalClasses: boolean;
    visible: boolean;
    onVisibilityChangedCallback: () => void;
    hasEndActions: boolean;
    row: MatrixDropdownRowModelBase;
    isErrorsRow: boolean;
    private static counter;
    private idValue;
    cells: Array<QuestionMatrixDropdownRenderedCell>;
    constructor(cssClasses: any, isDetailRow?: boolean);
    get id(): string;
    get attributes(): {
        "data-sv-drop-target-matrix-row"?: undefined;
    } | {
        "data-sv-drop-target-matrix-row": string;
    };
    get className(): string;
    private rootElement;
    setRootElement(val: HTMLTableRowElement): void;
    getRootElement(): HTMLTableRowElement;
    focusCell(cellIndex: number): void;
}
export declare class QuestionMatrixDropdownRenderedErrorRow extends QuestionMatrixDropdownRenderedRow {
    isErrorsRow: boolean;
    constructor(cssClasses: any);
    get attributes(): {};
    get className(): string;
    onAfterCreated(): void;
}
export declare class QuestionMatrixDropdownRenderedTable extends Base {
    matrix: QuestionMatrixDropdownModelBase;
    private headerRowValue;
    private footerRowValue;
    private hasRemoveRowsValue;
    private rowsActions;
    private cssClasses;
    rows: Array<QuestionMatrixDropdownRenderedRow>;
    protected getIsAnimationAllowed(): boolean;
    private getRenderedRowsAnimationOptions;
    private _renderedRows;
    updateRenderedRows(): void;
    private renderedRowsAnimation;
    get renderedRows(): Array<QuestionMatrixDropdownRenderedRow>;
    set renderedRows(val: Array<QuestionMatrixDropdownRenderedRow>);
    constructor(matrix: QuestionMatrixDropdownModelBase);
    get showTable(): boolean;
    get showHeader(): boolean;
    get showAddRow(): boolean;
    get showAddRowOnTop(): boolean;
    get showAddRowOnBottom(): boolean;
    get showFooter(): boolean;
    get hasFooter(): boolean;
    get hasRemoveRows(): boolean;
    isRequireReset(): boolean;
    get headerRow(): QuestionMatrixDropdownRenderedRow;
    get footerRow(): QuestionMatrixDropdownRenderedRow;
    get isRowsDragAndDrop(): boolean;
    private get showCellErrorsTop();
    private get showCellErrorsBottom();
    protected build(): void;
    updateShowTableAndAddRow(): void;
    onAddedRow(row: MatrixDropdownRowModelBase, index: number): void;
    private getRenderedRowIndexByIndex;
    private getRenderedDataRowCount;
    onRemovedRow(row: MatrixDropdownRowModelBase): void;
    onDetailPanelChangeVisibility(row: MatrixDropdownRowModelBase, isShowing: boolean): void;
    focusActionCell(row: MatrixDropdownRowModelBase, actionCellIndex: number): void;
    private getRenderedRowIndex;
    protected buildRowsActions(): void;
    protected createRenderedRow(cssClasses: any, isDetailRow?: boolean): QuestionMatrixDropdownRenderedRow;
    protected createErrorRenderedRow(cssClasses: any): QuestionMatrixDropdownRenderedErrorRow;
    protected buildHeader(): void;
    protected buildFooter(): void;
    protected buildRows(): void;
    private hasActionCellInRowsValues;
    private hasActionCellInRows;
    private hasActionsCellInLocaltion;
    private canRemoveRow;
    private buildHorizontalRows;
    private addHorizontalRow;
    private getRowDragCell;
    private getActionsCellClassName;
    private getRowActionsCell;
    private getRowActions;
    private buildRowActions;
    private get showRemoveButtonAsIcon();
    protected setDefaultRowActions(row: MatrixDropdownRowModelBase, actions: Array<IAction>): void;
    private createErrorRow;
    private createHorizontalRow;
    private addRowActionsCell;
    private createDetailPanelRow;
    private buildVerticalRows;
    private createMutlipleVerticalRows;
    private createVerticalRow;
    private createEndVerticalActionRow;
    private createMutlipleEditCells;
    private setItemCellCssClasses;
    private createEditCell;
    private createErrorCell;
    private createMutlipleColumnsFooter;
    private createMutlipleColumnsHeader;
    private getMultipleColumnChoices;
    private setHeaderCellCssClasses;
    private createHeaderCell;
    private setHeaderCell;
    private setCellWidth;
    private createTextCell;
    private createEmptyCell;
}
