import { JsonError } from "./jsonobject";
import { Base, EventBase } from "./base";
import { ISurvey, ISurveyData, ISurveyImpl, ITextProcessor, IQuestion, IPanel, IElement, IPage, ISurveyErrorOwner, ISurveyElement, IProgressInfo, IFindElement, ISurveyLayoutElement, IPlainDataOptions, LayoutElementContainer, IValueItemCustomPropValues, ILoadFromJSONOptions, IDropdownMenuOptions, ITextProcessorProp, ITextProcessorResult } from "./base-interfaces";
import { SurveyElementCore } from "./survey-element";
import { ISurveyTriggerOwner, SurveyTrigger, Trigger } from "./trigger";
import { CalculatedValue } from "./calculatedValue";
import { PageModel } from "./page";
import { dxSurveyService } from "./dxSurveyService";
import { LocalizableString } from "./localizablestring";
import { SurveyTimerModel, ISurveyTimerText } from "./surveyTimerModel";
import { IQuestionPlainData, Question } from "./question";
import { QuestionSelectBase } from "./question_baseselect";
import { ItemValue } from "./itemvalue";
import { PanelModel, QuestionRowModel } from "./panel";
import { HtmlConditionItem, UrlConditionItem } from "./expressionItems";
import { SurveyError } from "./survey-error";
import { IAction, Action } from "./actions/action";
import { ActionContainer } from "./actions/container";
import { QuestionPanelDynamicModel } from "./question_paneldynamic";
import { Notifier } from "./notifier";
import { TriggerExecutedEvent, CompletingEvent, CompleteEvent, ShowingPreviewEvent, NavigateToUrlEvent, CurrentPageChangingEvent, CurrentPageChangedEvent, ValueChangingEvent, ValueChangedEvent, VariableChangedEvent, QuestionVisibleChangedEvent, PageVisibleChangedEvent, PanelVisibleChangedEvent, QuestionCreatedEvent, QuestionAddedEvent, QuestionRemovedEvent, PanelAddedEvent, PanelRemovedEvent, PageAddedEvent, ValidateQuestionEvent, SettingQuestionErrorsEvent, ValidatePanelEvent, ErrorCustomTextEvent, ValidatePageEvent, ValidatedErrorsOnCurrentPageEvent, ProcessHtmlEvent, GetQuestionTitleEvent, GetTitleTagNameEvent, GetQuestionNumberEvent, GetPageNumberEvent, GetPanelNumberEvent, GetProgressTextEvent, TextMarkdownEvent, SendResultEvent, GetResultEvent, UploadFilesEvent, DownloadFileEvent, ClearFilesEvent, ChoicesLoadedEvent, ProcessDynamicTextEvent, UpdateQuestionCssClassesEvent, UpdatePanelCssClassesEvent, UpdatePageCssClassesEvent, UpdateChoiceItemCssEvent, AfterRenderSurveyEvent, AfterRenderPageEvent, AfterRenderQuestionEvent, AfterRenderQuestionInputEvent, AfterRenderPanelEvent, FocusInQuestionEvent, FocusInPanelEvent, ShowingChoiceItemEvent, ChoicesLazyLoadEvent, GetChoiceDisplayValueEvent, MatrixRowAddedEvent, MatrixBeforeRowAddedEvent, MatrixRowRemovingEvent, MatrixRowRemovedEvent, MatrixAllowRemoveRowEvent, MatrixDetailPanelVisibleChangedEvent, MatrixCellCreatingEvent, MatrixCellCreatedEvent, MatrixAfterCellRenderEvent, MatrixCellValueChangedEvent, MatrixCellValueChangingEvent, MatrixCellValidateEvent, DynamicPanelModifiedEvent, DynamicPanelRemovingEvent, DynamicPanelItemValueChangedEvent, DynamicPanelValueChangingEvent, DynamicPanelGetTabTitleEvent, DynamicPanelCurrentIndexChangedEvent, CheckAnswerCorrectEvent, DragDropAllowEvent, ScrollToTopEvent, GetQuestionTitleActionsEvent, GetPanelTitleActionsEvent, GetPageTitleActionsEvent, GetPanelFooterActionsEvent, GetMatrixRowActionsEvent, GetExpressionDisplayValueEvent, ServerValidateQuestionsEvent, MultipleTextItemAddedEvent, MatrixColumnAddedEvent, GetQuestionDisplayValueEvent, PopupVisibleChangedEvent, ChoicesSearchEvent, OpenFileChooserEvent, OpenDropdownMenuEvent, ResizeEvent, ProgressTextEvent, ScrollingElementToTopEvent, IsAnswerCorrectEvent, LoadChoicesFromServerEvent, ProcessTextValueEvent } from "./survey-events-api";
import { QuestionMatrixDropdownModelBase } from "./question_matrixdropdownbase";
import { QuestionMatrixDynamicModel } from "./question_matrixdynamic";
import { QuestionFileModel } from "./question_file";
import { QuestionMultipleTextModel } from "./question_multipletext";
import { ITheme, ImageFit, ImageAttachment } from "./themes";
import { PopupModel } from "./popup";
import { Cover } from "./header";
import { QuestionSignaturePadModel } from "./question_signaturepad";
/**
 * The `SurveyModel` object contains properties and methods that allow you to control the survey and access its elements.
 *
 * [View Demo](https://surveyjs.io/form-library/examples/nps-question/ (linkStyle))
 */
export declare class SurveyModel extends SurveyElementCore implements ISurvey, ISurveyData, ISurveyImpl, ISurveyTriggerOwner, ISurveyErrorOwner, ISurveyTimerText {
    static readonly TemplateRendererComponentName: string;
    [index: string]: any;
    static platform: string;
    get platformName(): string;
    notifier: Notifier;
    rootElement: HTMLElement;
    /**
     * A suffix added to the name of the property that stores comments.
     *
     * Default value: "-Comment"
     *
     * Many question types allow respondents to leave comments. To enable this functionality, set a question's [`showCommentArea`](https://surveyjs.io/form-library/documentation/api-reference/checkbox-question-model#showCommentArea) property to `true`. Comment values are saved in a separate property. The property name is composed of the question `name` and `commentSuffix`.
     *
     * Respondents can also leave comments when they select "Other" in choice-based questions, such as Dropdown or Checkboxes. The property name for the comment value is composed according to the same rules. However, you can use the question `name` as a key to store the comment value instead. Disable the [`storeOthersAsComment`](https://surveyjs.io/form-library/documentation/api-reference/survey-data-model#storeOthersAsComment) property in this case.
     *
     * [View Demo](https://surveyjs.io/form-library/examples/create-checkboxes-question-in-javascript/ (linkStyle))
     */
    get commentSuffix(): string;
    set commentSuffix(val: string);
    get commentPrefix(): string;
    set commentPrefix(val: string);
    private valuesHash;
    private variablesHash;
    private editingObjValue;
    private timerModelValue;
    private navigationBarValue;
    /**
     * An event that is raised after a [trigger](https://surveyjs.io/form-library/documentation/api-reference/survey-data-model#triggers) is executed.
     *
     * For information on event handler parameters, refer to descriptions within the interface.
     *
     * [Conditional Survey Logic (Triggers)](https://surveyjs.io/form-library/documentation/design-survey/conditional-logic#conditional-survey-logic-triggers (linkStyle))
     * @see triggers
     * @see runTriggers
     */
    onTriggerExecuted: EventBase<SurveyModel, TriggerExecutedEvent>;
    /**
     * An event that is raised before the survey is completed. Use this event to prevent survey completion.
     * @see onComplete
     * @see doComplete
     * @see autoAdvanceAllowComplete
     */
    onCompleting: EventBase<SurveyModel, CompletingEvent>;
    /**
     * An event that is raised after the survey is completed. Use this event to send survey results to the server.
     *
     * For information on event handler parameters, refer to descriptions within the interface.
     *
     * For an example of how to use the methods described above, refer to the following help topic: [Store Survey Results in Your Own Database](https://surveyjs.io/form-library/documentation/handle-survey-results-store#store-survey-results-in-your-own-database).
     *
     * > Do not disable the [`showCompletePage`](https://surveyjs.io/form-library/documentation/surveymodel#showCompletePage) property if you call one of the `options.showSave...` methods. This is required because the UI that indicates data saving progress is integrated into the complete page. If you hide the complete page, the UI also becomes invisible.
     * @see onPartialSend
     * @see doComplete
     * @see autoAdvanceAllowComplete
     */
    onComplete: EventBase<SurveyModel, CompleteEvent>;
    /**
     * An event that is raised before the survey displays a [preview of given answers](https://surveyjs.io/form-library/documentation/design-survey/create-a-multi-page-survey#preview-page). Use this event to cancel the preview.
     * @see showPreviewBeforeComplete
     * @see previewMode
     * @see showPreview
     * @see cancelPreview
     */
    onShowingPreview: EventBase<SurveyModel, ShowingPreviewEvent>;
    /**
     * An event that is raised before the survey navigates to a specified URL. Use this event to change the URL or cancel the navigation.
     * @see navigateToUrl
     * @see navigateToUrlOnCondition
     */
    onNavigateToUrl: EventBase<SurveyModel, NavigateToUrlEvent>;
    /**
     * An event that is raised when the survey [`state`](https://surveyjs.io/form-library/documentation/api-reference/survey-data-model#state) changes to `"running"`.
     * @see firstPageIsStartPage
     */
    onStarted: EventBase<SurveyModel, {}>;
    /**
     * An event that is raised to save incomplete survey results. Enable the [`partialSendEnabled`](https://surveyjs.io/form-library/documentation/api-reference/survey-data-model#partialSendEnabled) property for this event to occur.
     *
     * For information on event handler parameters, refer to descriptions within the interface.
     *
     * Alternatively, you can handle the [`onCurrentPageChanged`](#onCurrentPageChanged) and [`onValueChanged`](#onValueChanged) events, as shown in the following demo: [Continue an Incomplete Survey](https://surveyjs.io/form-library/examples/survey-editprevious/).
     */
    onPartialSend: EventBase<SurveyModel, {}>;
    /**
     * An event that is raised before the current page is switched.
     *
     * @see currentPageNo
     * @see nextPage
     * @see prevPage
     **/
    onCurrentPageChanging: EventBase<SurveyModel, CurrentPageChangingEvent>;
    /**
     * An event that is raised after the current page is switched.
     *
     * @see currentPageNo
     * @see nextPage
     * @see prevPage
     */
    onCurrentPageChanged: EventBase<SurveyModel, CurrentPageChangedEvent>;
    /**
     * An event that is raised before a question value is changed.
     * @see setValue
     */
    onValueChanging: EventBase<SurveyModel, ValueChangingEvent>;
    /**
     * An event that is raised after a question value is changed.
     *
     * For information on event handler parameters, refer to descriptions within the interface.
     *
     * To handle value changes in matrix cells or panels within a [Dynamic Panel](https://surveyjs.io/form-library/documentation/api-reference/dynamic-panel-model), use the [`onMatrixCellValueChanged`](https://surveyjs.io/form-library/documentation/api-reference/survey-data-model#onMatrixCellValueChanged) or [`onDynamicPanelValueChanged`](https://surveyjs.io/form-library/documentation/api-reference/survey-data-model#onDynamicPanelValueChanged) event.
     * @see setValue
     */
    onValueChanged: EventBase<SurveyModel, ValueChangedEvent>;
    /**
     * An event that is raised after a [variable](https://surveyjs.io/form-library/documentation/design-survey/conditional-logic#variables) or [calculated value](https://surveyjs.io/form-library/documentation/design-survey/conditional-logic#calculated-values) is changed.
     *
     * @see setVariable
     * @see calculatedValues
     */
    onVariableChanged: EventBase<SurveyModel, VariableChangedEvent>;
    /**
     * An event that is raised after question visibility is changed.
     *
     * For information on event handler parameters, refer to descriptions within the interface.
     *
     * Refer to the following help topic for information on how to implement conditional visibility: [Conditional Visibility](https://surveyjs.io/form-library/documentation/design-survey/conditional-logic#conditional-visibility).
     */
    onQuestionVisibleChanged: EventBase<SurveyModel, QuestionVisibleChangedEvent>;
    onVisibleChanged: EventBase<SurveyModel, any>;
    /**
     * An event that is raised after page visibility is changed.
     *
     * For information on event handler parameters, refer to descriptions within the interface.
     *
     * Refer to the following help topic for information on how to implement conditional visibility: [Conditional Visibility](https://surveyjs.io/form-library/documentation/design-survey/conditional-logic#conditional-visibility).
     */
    onPageVisibleChanged: EventBase<SurveyModel, PageVisibleChangedEvent>;
    /**
     * An event that is raised after panel visibility is changed.
     *
     * For information on event handler parameters, refer to descriptions within the interface.
     *
     * Refer to the following help topic for information on how to implement conditional visibility: [Conditional Visibility](https://surveyjs.io/form-library/documentation/design-survey/conditional-logic#conditional-visibility).
     */
    onPanelVisibleChanged: EventBase<SurveyModel, PanelVisibleChangedEvent>;
    /**
     * An event that is raised when the survey creates any new object derived from [`Question`](https://surveyjs.io/form-library/documentation/api-reference/question).
     *
     * In a survey, complex elements ([Dynamic Matrix](https://surveyjs.io/form-library/examples/questiontype-matrixdynamic/), [Multiple Text](https://surveyjs.io/form-library/examples/questiontype-multipletext/), and [Dynamic Panel](https://surveyjs.io/form-library/examples/questiontype-paneldynamic/)) are composed of questions. Use this event to customize any question regardless of which survey element it belongs to.
     *
     * For information on event handler parameters, refer to descriptions within the interface.
     *
     * To use this event for questions loaded from JSON, create an empty survey model, add an event handler, and only then populate the model from the JSON object:
     *
     * ```js
     * import { Model } from "survey-core";
     *
     * const surveyJson = {
     *    // ...
     * };
     * // Create an empty model
     * const survey = new Model();
     * // Add an event handler
     * survey.onQuestionCreated.add((sender, options) => {
     *   //...
     * });
     * // Load the survey JSON schema
     * survey.fromJSON(surveyJson);
     * ```
     * @see onQuestionAdded
     */
    onQuestionCreated: EventBase<SurveyModel, QuestionCreatedEvent>;
    /**
     * An event that is raised when a new question is added to a panel or page.
     *
     * For information on event handler parameters, refer to descriptions within the interface.
     *
     * To use this event for questions loaded from JSON, create an empty survey model, add an event handler, and only then populate the model from the JSON object:
     *
     * ```js
     * import { Model } from "survey-core";
     *
     * const surveyJson = {
     *    // ...
     * };
     * // Create an empty model
     * const survey = new Model();
     * // Add an event handler
     * survey.onQuestionAdded.add((sender, options) => {
     *   //...
     * });
     * // Load the survey JSON schema
     * survey.fromJSON(surveyJson);
     * ```
     * @see onQuestionCreated
     */
    onQuestionAdded: EventBase<SurveyModel, QuestionAddedEvent>;
    /**
     * An event that is raised after a question is deleted from the survey.
     */
    onQuestionRemoved: EventBase<SurveyModel, QuestionRemovedEvent>;
    /**
     * An event that is raised when a new panel is added to a page.
     */
    onPanelAdded: EventBase<SurveyModel, PanelAddedEvent>;
    /**
     * An event that is raised after a panel is deleted from the survey.
     */
    onPanelRemoved: EventBase<SurveyModel, PanelRemovedEvent>;
    /**
     * An event that is raised when a new page is added to the survey.
     * @see PanelModel
     */
    onPageAdded: EventBase<SurveyModel, PageAddedEvent>;
    /**
     * An event that is raised when a question value is being validated. Use this event to add/remove/modify errors or specify a custom error message.
     *
     * For information on event handler parameters, refer to descriptions within the interface.
     *
     * [View Demo](https://surveyjs.io/form-library/examples/add-custom-input-validation/ (linkStyle))
     * @see onServerValidateQuestions
     * @see onValidatePanel
     * @see onMatrixCellValidate
     * @see onSettingQuestionErrors
     */
    onValidateQuestion: EventBase<SurveyModel, ValidateQuestionEvent>;
    /**
     * @deprecated Use the [`onValidateQuestion`](https://surveyjs.io/form-library/documentation/api-reference/survey-data-model#onValidateQuestion) property instead.
     */
    onSettingQuestionErrors: EventBase<SurveyModel, SettingQuestionErrorsEvent>;
    /**
     * Use this event to validate data on your server.
     *
     * For information on event handler parameters, refer to descriptions within the interface.
     *
     * [View Demo](https://surveyjs.io/form-library/examples/javascript-server-side-form-validation/ (linkStyle))
     * @see onValidateQuestion
     * @see onValidatePanel
     * @see isValidatingOnServer
     */
    onServerValidateQuestions: EventBase<SurveyModel, ServerValidateQuestionsEvent>;
    /**
     * An event that is raised when a panel is being validated. Use this event to add/remove/modify errors or specify a custom error message.
     *
     * For information on event handler parameters, refer to descriptions within the interface.
     *
     * [View Demo](https://surveyjs.io/form-library/examples/add-custom-input-validation/ (linkStyle))
     * @see onValidateQuestion
     * @see onServerValidateQuestions
     */
    onValidatePanel: EventBase<SurveyModel, ValidatePanelEvent>;
    /**
     * @deprecated Use the [`onValidateQuestion`](https://surveyjs.io/form-library/documentation/api-reference/survey-data-model#onValidateQuestion), [`onValidatePanel`](https://surveyjs.io/form-library/documentation/api-reference/survey-data-model#onValidatePanel), and [`onValidatePage`](https://surveyjs.io/form-library/documentation/api-reference/survey-data-model#onValidatePage) events instead.
     */
    onErrorCustomText: EventBase<SurveyModel, ErrorCustomTextEvent>;
    /**
     * An event that is raised when a survey page is being validated. Use this event to add/remove/modify errors.
     */
    onValidatePage: EventBase<SurveyModel, ValidatePageEvent>;
    /**
     * @deprecated Use the [`onValidatePage`](https://surveyjs.io/form-library/documentation/api-reference/survey-data-model#onValidatePage) event instead.
     */
    onValidatedErrorsOnCurrentPage: EventBase<SurveyModel, ValidatedErrorsOnCurrentPageEvent>;
    /**
     * An event that is raised when the survey processes HTML content. Handle this event to modify HTML content before displaying.
     * @see completedHtml
     * @see loadingHtml
     * @see QuestionHtmlModel.html
     */
    onProcessHtml: EventBase<SurveyModel, ProcessHtmlEvent>;
    /**
     * Use this event to change a question's display text.
     */
    onGetQuestionDisplayValue: EventBase<SurveyModel, GetQuestionDisplayValueEvent>;
    /**
     * An event that is raised before the survey displays a question title. Handle this event to modify question titles.
     *
     * For information on event handler parameters, refer to descriptions within the interface.
     *
     * If you want to modify question numbers, handle the [`onGetQuestionNumber`](https://surveyjs.io/form-library/documentation/api-reference/survey-data-model#onGetQuestionNumber) event.
     * @see requiredMark
     */
    onGetQuestionTitle: EventBase<SurveyModel, GetQuestionTitleEvent>;
    /**
     * An event that is raised when the survey applies HTML tags to a survey, page, panel, and question title. Handle this event to change the HTML tag of individual titles.
     *
     * For information on event handler parameters, refer to descriptions within the interface.
     *
     * If you want to specify HTML tags for all titles, use the [`titleTags`](https://surveyjs.io/form-library/documentation/api-reference/settings#titleTags) object in [global settings](https://surveyjs.io/form-library/documentation/api-reference/settings).
     *
     * [View Demo](https://surveyjs.io/form-library/examples/survey-titletagnames/ (linkStyle))
     * @see onGetQuestionTitle
     * @see onGetQuestionNumber
     */
    onGetTitleTagName: EventBase<SurveyModel, GetTitleTagNameEvent>;
    /**
     * An event that is raised before the survey calculates a question number. Handle this event to modify question numbers.
     *
     * For information on event handler parameters, refer to descriptions within the interface.
     *
     * If you want to hide question numbers, disable the [`showQuestionNumbers`](https://surveyjs.io/form-library/documentation/api-reference/survey-data-model#showQuestionNumbers) property.
     * @see onGetQuestionTitle
     * @see questionStartIndex
     */
    onGetQuestionNumber: EventBase<SurveyModel, GetQuestionNumberEvent>;
    /**
     * @deprecated Use the [`onGetQuestionNumber`](https://surveyjs.io/form-library/documentation/api-reference/survey-data-model#onGetQuestionNumber) event instead.
     */
    onGetQuestionNo: EventBase<SurveyModel, GetQuestionNumberEvent>;
    /**
     * An event that is raised before the survey calculates a panel number. Handle this event to modify panel numbers.
     *
     * This event is raised only for the panels with a [specified title](https://surveyjs.io/form-library/documentation/api-reference/panel-model#title) and [visible number](https://surveyjs.io/form-library/documentation/api-reference/panel-model#showNumber).
     */
    onGetPanelNumber: EventBase<SurveyModel, GetPanelNumberEvent>;
    /**
     * An event that is raised before the survey calculates a page number. Handle this event to modify page numbers.
     *
     * This event is raised only if the [`showPageNumbers`](https://surveyjs.io/form-library/documentation/api-reference/survey-data-model#showPageNumbers) property is enabled.
     *
     * For information on event handler parameters, refer to descriptions within the interface.
     * @see onGetQuestionTitle
     * @see questionStartIndex
     */
    onGetPageNumber: EventBase<SurveyModel, GetPageNumberEvent>;
    /**
     * An event that is raised before the survey displays progress text. Handle this event to change the progress text in code.
     * @see showProgressBar
     * @see progressBarLocation
     * @see progressBarType
     */
    onGetProgressText: EventBase<SurveyModel, GetProgressTextEvent>;
    /**
     * @deprecated Use the [`onGetProgressText`](https://surveyjs.io/form-library/documentation/api-reference/survey-data-model#onGetProgressText) event instead.
     */
    onProgressText: EventBase<SurveyModel, ProgressTextEvent>;
    /**
     * An event that is raised to convert Markdown content to HTML.
     *
     * For information on event handler parameters, refer to descriptions within the interface.
     *
     * [View Demo](https://surveyjs.io/form-library/examples/edit-survey-questions-markdown/ (linkStyle))
     */
    onTextMarkdown: EventBase<SurveyModel, TextMarkdownEvent>;
    onTextRenderAs: EventBase<SurveyModel, any>;
    /**
     * An event that is raised after a request to save survey results on [SurveyJS Service](https://api.surveyjs.io/) has been completed. Use this event to find out if the results have been saved successfully.
     */
    onSendResult: EventBase<SurveyModel, SendResultEvent>;
    /**
     * An event that is raised when the [`getResult(resultId, questionName)`](https://surveyjs.io/form-library/documentation/api-reference/survey-data-model#getResult) method is called. Use this event to obtain answers to an individual question from [SurveyJS Service](https://api.surveyjs.io/).
     * @see getResult
     */
    onGetResult: EventBase<SurveyModel, GetResultEvent>;
    /**
     * An event that is raised when a respondent opens a dialog window to select files.
     * @see chooseFiles
     */
    onOpenFileChooser: EventBase<SurveyModel, OpenFileChooserEvent>;
    /**
     * An event that is raised when a File Upload or Signature Pad question starts to upload a file. Applies only if [`storeDataAsText`](https://surveyjs.io/form-library/documentation/api-reference/file-model#storeDataAsText) is `false`. Use this event to upload files to your server.
     *
     * For information on event handler parameters, refer to descriptions within the interface.
     *
     * [View Demo](https://surveyjs.io/form-library/examples/file-upload/ (linkStyle))
     * @see uploadFiles
     * @see onDownloadFile
     * @see onClearFiles
     */
    onUploadFiles: EventBase<SurveyModel, UploadFilesEvent>;
    /**
     * An event that is raised when a File Upload question starts to download a file. Use this event to implement file preview when your server stores only file names.
     *
     * For information on event handler parameters, refer to descriptions within the interface.
     *
     * [View Demo](https://surveyjs.io/form-library/examples/store-file-names-in-survey-results/ (linkStyle))
     * @see downloadFile
     * @see onClearFiles
     * @see onUploadFiles
     */
    onDownloadFile: EventBase<SurveyModel, DownloadFileEvent>;
    /**
     * An event that is raised when users clear files in a [File Upload](https://surveyjs.io/form-library/documentation/api-reference/file-model) question or clear signature in a [Signature Pad](https://surveyjs.io/form-library/documentation/api-reference/signature-pad-model) question. Use this event to delete files from your server.
     *
     * For information on event handler parameters, refer to descriptions within the interface.
     *
     * [View Demo](https://surveyjs.io/form-library/examples/file-delayed-upload/ (linkStyle))
     * @see clearFiles
     * @see onDownloadFile
     * @see onUploadFiles
     */
    onClearFiles: EventBase<SurveyModel, ClearFilesEvent>;
    /**
     * An event that is raised after choices are loaded from a server but before they are assigned to a choice-based question, such as [Dropdown](https://surveyjs.io/form-library/documentation/api-reference/dropdown-menu-model) or [Checkboxes](https://surveyjs.io/form-library/documentation/api-reference/checkbox-question-model). Handle this event if you need to modify the loaded choices.
     */
    onChoicesLoaded: EventBase<SurveyModel, ChoicesLoadedEvent>;
    /**
     * @deprecated Use the [`onChoicesLoaded`](https://surveyjs.io/form-library/documentation/api-reference/survey-data-model#onChoicesLoaded) event instead.
     */
    onLoadChoicesFromServer: EventBase<SurveyModel, LoadChoicesFromServerEvent>;
    /**
     * An event that is raised after a survey JSON schema is loaded from the [SurveyJS Service](https://api.surveyjs.io). Use this event to modify the loaded schema.
     * @see surveyId
     * @see clientId
     * @see loadSurveyFromService
     */
    onLoadedSurveyFromService: EventBase<SurveyModel, {}>;
    /**
     * An event that is raised when the survey processes [dynamic texts](https://surveyjs.io/form-library/documentation/design-survey/conditional-logic#dynamic-texts) and any text in curly brackets. Use this event, for instance, to substitute parameters in a RESTful URL with real values when you [load choices by URL](https://surveyjs.io/form-library/documentation/api-reference/checkbox-question-model#choicesByUrl).
     */
    onProcessDynamicText: EventBase<SurveyModel, ProcessDynamicTextEvent>;
    /**
     * @deprecated Use the [`onProcessDynamicText`](https://surveyjs.io/form-library/documentation/api-reference/survey-data-model#onProcessDynamicText) event instead.
     */
    onProcessTextValue: EventBase<SurveyModel, ProcessTextValueEvent>;
    /**
     * An event that is raised before rendering a question. Use it to override default question CSS classes.
     *
     * For information on event handler parameters, refer to descriptions within the interface.
     *
     * [View Demo](https://surveyjs.io/form-library/examples/customize-survey-with-css/ (linkStyle))
     * @see css
     */
    onUpdateQuestionCssClasses: EventBase<SurveyModel, UpdateQuestionCssClassesEvent>;
    /**
     * An event that is raised before rendering a standalone panel and panels within [Dynamic Panel](https://surveyjs.io/form-library/examples/duplicate-group-of-fields-in-form/). Use it to override default panel CSS classes.
     *
     * For information on event handler parameters, refer to descriptions within the interface.
     *
     * [View Demo](https://surveyjs.io/form-library/examples/customize-survey-with-css/ (linkStyle))
     * @see css
     */
    onUpdatePanelCssClasses: EventBase<SurveyModel, UpdatePanelCssClassesEvent>;
    /**
     * An event that is raised before rendering a page. Use it to override default page CSS classes.
     *
     * For information on event handler parameters, refer to descriptions within the interface.
     *
     * [View Demo](https://surveyjs.io/form-library/examples/customize-survey-with-css/ (linkStyle))
     * @see css
     */
    onUpdatePageCssClasses: EventBase<SurveyModel, UpdatePageCssClassesEvent>;
    /**
     * An event that is raised before rendering a choice item in Radio Button Group and Checkboxes questions. Use it to override default CSS classes applied to choice items.
     *
     * For information on event handler parameters, refer to descriptions within the interface.
     *
     * [View Demo](https://surveyjs.io/form-library/examples/customize-survey-with-css/ (linkStyle))
     * @see css
     */
    onUpdateChoiceItemCss: EventBase<SurveyModel, UpdateChoiceItemCssEvent>;
    /**
     * An event that is raised after the survey is rendered to the DOM. Use this event to modify survey markup.
     *
     * For information on event handler parameters, refer to descriptions within the interface.
     *
     * [View Demo](https://surveyjs.io/form-library/examples/survey-animation/ (linkStyle))
     */
    onAfterRenderSurvey: EventBase<SurveyModel, AfterRenderSurveyEvent>;
    onAfterRenderHeader: EventBase<SurveyModel, any>;
    /**
     * An event that is raised after a page is rendered to the DOM. Use it to modify page markup.
     *
     * For information on event handler parameters, refer to descriptions within the interface.
     *
     * [View Demo](https://surveyjs.io/form-library/examples/survey-afterrender/ (linkStyle))
     */
    onAfterRenderPage: EventBase<SurveyModel, AfterRenderPageEvent>;
    /**
     * An event that is raised after a question is rendered to the DOM. Use it to modify question markup.
     *
     * For information on event handler parameters, refer to descriptions within the interface.
     *
     * [View Demo](https://surveyjs.io/form-library/examples/survey-afterrender/ (linkStyle))
     */
    onAfterRenderQuestion: EventBase<SurveyModel, AfterRenderQuestionEvent>;
    /**
     * An event that is raised after a question with a single input field is rendered to the DOM. Use it to modify question markup.
     *
     * For information on event handler parameters, refer to descriptions within the interface.
     *
     * > This event is not raised for questions without input fields ([HTML](https://surveyjs.io/form-library/documentation/questionhtmlmodel), [Image](https://surveyjs.io/form-library/documentation/questionimagemodel)) or questions with multiple input fields ([Matrix](https://surveyjs.io/form-library/documentation/questionmatrixmodel), [Multiple Text](https://surveyjs.io/form-library/documentation/questionmultipletextmodel)).
     */
    onAfterRenderQuestionInput: EventBase<SurveyModel, AfterRenderQuestionInputEvent>;
    /**
     * An event that is raised after a panel is rendered to the DOM. Use it to modify panel markup.
     *
     * For information on event handler parameters, refer to descriptions within the interface.
     *
     * > This event is raised for static [Panels](https://surveyjs.io/form-library/examples/set-properties-on-multiple-questions-using-panel/) as well as panels within a [Dynamic Panel](https://surveyjs.io/form-library/examples/duplicate-group-of-fields-in-form/).
     */
    onAfterRenderPanel: EventBase<SurveyModel, AfterRenderPanelEvent>;
    /**
     * An event that is raised when an element (input field, checkbox, radio button) within a question gets focus.
     * @see onFocusInPanel
     * @see autoFocusFirstQuestion
     * @see focusQuestion
     */
    onFocusInQuestion: EventBase<SurveyModel, FocusInQuestionEvent>;
    /**
     * An event that is raised when an element within a panel gets focus.
     * @see onFocusInQuestion
     * @see autoFocusFirstQuestion
     * @see focusQuestion
     */
    onFocusInPanel: EventBase<SurveyModel, FocusInPanelEvent>;
    /**
     * An event that is raised before a [choice item](https://surveyjs.io/form-library/documentation/api-reference/questionselectbase#choices) is displayed. Use this event to change the visibility of individual choice items in [Checkboxes](https://surveyjs.io/form-library/documentation/api-reference/checkbox-question-model), [Dropdown](https://surveyjs.io/form-library/documentation/api-reference/dropdown-menu-model), [Radio Button Group](https://surveyjs.io/form-library/documentation/api-reference/radio-button-question-model), and other similar question types.
     */
    onShowingChoiceItem: EventBase<SurveyModel, ShowingChoiceItemEvent>;
    /**
     * Use this event to load choice items in [Dropdown](https://surveyjs.io/form-library/documentation/questiondropdownmodel) and [Tag Box](https://surveyjs.io/form-library/documentation/questiontagboxmodel) questions on demand.
     *
     * This event is raised only for those questions that have the [`choicesLazyLoadEnabled`](https://surveyjs.io/form-library/documentation/questiondropdownmodel#choicesLazyLoadEnabled) property set to `true`.
     *
     * For information on event handler parameters, refer to descriptions within the interface.
     *
     * [View Demo](https://surveyjs.io/form-library/examples/lazy-loading-dropdown/ (linkStyle))
     */
    onChoicesLazyLoad: EventBase<SurveyModel, ChoicesLazyLoadEvent>;
    /**
     * An event that is raised each time a search string in a [Dropdown](https://surveyjs.io/form-library/documentation/api-reference/dropdown-menu-model) or [Tag Box](https://surveyjs.io/form-library/documentation/api-reference/dropdown-tag-box-model) question changes. Use this event to implement custom filtering of choice options.
     * @see [QuestionDropdownModel.searchEnabled](https://surveyjs.io/form-library/documentation/api-reference/dropdown-menu-model#searchEnabled)
     * @see [QuestionDropdownModel.searchMode](https://surveyjs.io/form-library/documentation/api-reference/dropdown-menu-model#searchMode)
     */
    onChoicesSearch: EventBase<SurveyModel, ChoicesSearchEvent>;
    /**
     * Use this event to load a display text for the [default choice item](https://surveyjs.io/form-library/documentation/questiondropdownmodel#defaultValue) in [Dropdown](https://surveyjs.io/form-library/documentation/questiondropdownmodel) and [Tag Box](https://surveyjs.io/form-library/documentation/questiontagboxmodel) questions.
     *
     * If you load choices from a server (use [`choicesByUrl`](https://surveyjs.io/form-library/documentation/questiondropdownmodel#choicesByUrl) or [`onChoicesLazyLoad`](https://surveyjs.io/form-library/documentation/surveymodel#onChoicesLazyLoad)), display texts become available only when data is loaded, which does not happen until a user opens the drop-down menu. However, a display text for a default choice item is required before that. In this case, you can load data individually for the default item within the `onGetChoiceDisplayValue` event handler.
     *
     * For information on event handler parameters, refer to descriptions within the interface.
     *
     * [View Demo](https://surveyjs.io/form-library/examples/lazy-loading-dropdown/ (linkStyle))
     */
    onGetChoiceDisplayValue: EventBase<SurveyModel, GetChoiceDisplayValueEvent>;
    /**
     * An event that is raised after a new row is added to a [Dynamic Matrix](https://surveyjs.io/form-library/examples/questiontype-matrixdynamic/).
     */
    onMatrixRowAdded: EventBase<SurveyModel, MatrixRowAddedEvent>;
    /**
     * An event that is raised before a new row is added to a [Dynamic Matrix](https://surveyjs.io/form-library/examples/questiontype-matrixdynamic/).
     */
    onMatrixRowAdding: EventBase<SurveyModel, MatrixBeforeRowAddedEvent>;
    /**
     * @deprecated Use the [`onMatrixRowAdding`](https://surveyjs.io/form-library/documentation/api-reference/survey-data-model#onMatrixRowAdding) event instead.
     */
    onMatrixBeforeRowAdded: EventBase<SurveyModel, MatrixBeforeRowAddedEvent>;
    /**
     * An event that is raised before a row is deleted from a [Dynamic Matrix](https://surveyjs.io/form-library/examples/questiontype-matrixdynamic/). You can cancel row deletion and clear row data instead.
     * @see onMatrixRenderRemoveButton
     */
    onMatrixRowRemoving: EventBase<SurveyModel, MatrixRowRemovingEvent>;
    /**
     * An event that is raised after a row is deleted from a [Dynamic Matrix](https://surveyjs.io/form-library/examples/questiontype-matrixdynamic/).
     * @see onMatrixRenderRemoveButton
     */
    onMatrixRowRemoved: EventBase<SurveyModel, MatrixRowRemovedEvent>;
    /**
     * An event that is raised before rendering the Remove button in a row of a [Dynamic Matrix](https://surveyjs.io/form-library/examples/questiontype-matrixdynamic/). Use this event to hide the Remove button for individual matrix rows.
     * @see onMatrixRowRemoving
     * @see onMatrixRowRemoved
     */
    onMatrixRenderRemoveButton: EventBase<SurveyModel, MatrixAllowRemoveRowEvent>;
    /**
     * @deprecated Use the [`onMatrixRenderRemoveButton`](https://surveyjs.io/form-library/documentation/api-reference/survey-data-model#onMatrixRenderRemoveButton) event instead.
     */
    onMatrixAllowRemoveRow: EventBase<SurveyModel, MatrixAllowRemoveRowEvent>;
    /**
     * An event that is raised after the visibility of an [expandable detail section](https://surveyjs.io/form-library/examples/add-expandable-details-section-under-matrix-rows/) is changed. This event can be raised for [Multi-Select](https://surveyjs.io/form-library/documentation/api-reference/matrix-table-with-dropdown-list) and [Dynamic Matrix](https://surveyjs.io/form-library/documentation/api-reference/dynamic-matrix-table-question-model) questions.
     */
    onMatrixDetailPanelVisibleChanged: EventBase<SurveyModel, MatrixDetailPanelVisibleChangedEvent>;
    /**
     * An event that is raised before a cell in a [Multi-Select Matrix](https://surveyjs.io/form-library/examples/questiontype-matrixdropdown/) or [Dynamic Matrix](https://surveyjs.io/form-library/examples/questiontype-matrixdynamic/) is created. Use this event to change the type of individual matrix cells.
     * @see onAfterRenderMatrixCell
     */
    onMatrixCellCreating: EventBase<SurveyModel, MatrixCellCreatingEvent>;
    /**
      * An event that is raised after a cell in a [Multi-Select Matrix](https://surveyjs.io/form-library/examples/questiontype-matrixdropdown/) or [Dynamic Matrix](https://surveyjs.io/form-library/examples/questiontype-matrixdynamic/) is created.
      * @see onAfterRenderMatrixCell
      */
    onMatrixCellCreated: EventBase<SurveyModel, MatrixCellCreatedEvent>;
    /**
     * An event that is raised for every matrix cell after it is rendered to the DOM.
     * @see onMatrixCellCreated
     */
    onAfterRenderMatrixCell: EventBase<SurveyModel, MatrixAfterCellRenderEvent>;
    /**
     * @deprecated Use the [`onAfterRenderMatrixCell`](https://surveyjs.io/form-library/documentation/api-reference/survey-data-model#onAfterRenderMatrixCell) event instead.
     */
    onMatrixAfterCellRender: EventBase<SurveyModel, MatrixAfterCellRenderEvent>;
    /**
     * An event that is raised after a cell value is changed in a [Multi-Select Matrix](https://surveyjs.io/form-library/examples/questiontype-matrixdropdown/) or [Dynamic Matrix](https://surveyjs.io/form-library/examples/questiontype-matrixdynamic/).
     * @see onMatrixRowAdding
     */
    onMatrixCellValueChanged: EventBase<SurveyModel, MatrixCellValueChangedEvent>;
    /**
     * An event that is raised before a cell value is changed in a [Multi-Select Matrix](https://surveyjs.io/form-library/examples/questiontype-matrixdropdown/) or [Dynamic Matrix](https://surveyjs.io/form-library/examples/questiontype-matrixdynamic/). Use this event to change the cell value.
     * @see onMatrixRowAdding
     */
    onMatrixCellValueChanging: EventBase<SurveyModel, MatrixCellValueChangingEvent>;
    /**
     * An event that is raised for [Multi-Select Matrix](https://surveyjs.io/form-library/examples/questiontype-matrixdropdown/) and [Dynamic Matrix](https://surveyjs.io/form-library/examples/questiontype-matrixdynamic/) questions when they validate a cell value. Use this event to display a custom error message based on a condition.
     * @see onMatrixRowAdding
     */
    onMatrixCellValidate: EventBase<SurveyModel, MatrixCellValidateEvent>;
    /**
     * An event that is raised after a new column is added to a [Multi-Select Matrix](https://surveyjs.io/form-library/examples/questiontype-matrixdropdown/) or [Dynamic Matrix](https://surveyjs.io/form-library/examples/questiontype-matrixdynamic/).
     */
    onMatrixColumnAdded: EventBase<SurveyModel, MatrixColumnAddedEvent>;
    /**
     * An event that is raised on adding a new item in Multiple Text question.
     */
    onMultipleTextItemAdded: EventBase<SurveyModel, MultipleTextItemAddedEvent>;
    /**
     * An event that is raised after a new panel is added to a [Dynamic Panel](https://surveyjs.io/form-library/examples/questiontype-paneldynamic/) question.
     */
    onDynamicPanelAdded: EventBase<SurveyModel, DynamicPanelModifiedEvent>;
    /**
     * An event that is raised after a panel is deleted from a [Dynamic Panel](https://surveyjs.io/form-library/examples/questiontype-paneldynamic/) question.
     */
    onDynamicPanelRemoved: EventBase<SurveyModel, DynamicPanelModifiedEvent>;
    /**
     * An event that is raised before a panel is deleted from a [Dynamic Panel](https://surveyjs.io/form-library/examples/questiontype-paneldynamic/) question. Use this event to cancel the deletion.
     */
    onDynamicPanelRemoving: EventBase<SurveyModel, DynamicPanelRemovingEvent>;
    /**
    * An event that is raised every second while the timer is running.
    *
    * Use the [`timeSpent`](https://surveyjs.io/form-library/documentation/api-reference/survey-data-model#timeSpent) property to find out how many seconds have elapsed.
    * @see timeLimit
    * @see timeLimitPerPage
    * @see showTimer
    * @see timerLocation
    * @see startTimer
    */
    onTimerTick: EventBase<SurveyModel, {}>;
    /**
     * @deprecated Use the [`onTimerTick`](https://surveyjs.io/form-library/documentation/api-reference/survey-data-model#onTimerTick) event instead.
     */
    onTimer: EventBase<SurveyModel, {}>;
    onTimerPanelInfoText: EventBase<SurveyModel, any>;
    /**
     * An event that is raised after a value is changed in a panel within a [Dynamic Panel](https://surveyjs.io/form-library/examples/questiontype-paneldynamic/) question.
     */
    onDynamicPanelValueChanged: EventBase<SurveyModel, DynamicPanelItemValueChangedEvent>;
    /**
     * @deprecated Use the [`onDynamicPanelValueChanged`](https://surveyjs.io/form-library/documentation/api-reference/survey-data-model#onDynamicPanelValueChanged) event instead.
     */
    onDynamicPanelItemValueChanged: EventBase<SurveyModel, DynamicPanelItemValueChangedEvent>;
    /**
     * An event that is raised before a value is changed in a panel within a [Dynamic Panel](https://surveyjs.io/form-library/examples/questiontype-paneldynamic/) question.
     */
    onDynamicPanelValueChanging: EventBase<SurveyModel, DynamicPanelValueChangingEvent>;
    /**
     * An event that is raised before a [Dynamic Panel](https://surveyjs.io/form-library/examples/questiontype-paneldynamic/) renders [tab titles](https://surveyjs.io/form-library/documentation/api-reference/dynamic-panel-model#templateTabTitle). Use this event to change individual tab titles.
     *
     * For information on event handler parameters, refer to descriptions within the interface.
     *
     * [View Demo](https://surveyjs.io/form-library/examples/tabbed-interface-for-duplicate-group-option/ (linkStyle))
     */
    onGetDynamicPanelTabTitle: EventBase<SurveyModel, DynamicPanelGetTabTitleEvent>;
    /**
     * An event that is raised after the current panel is changed in a [Dynamic Panel](https://surveyjs.io/form-library/examples/questiontype-paneldynamic/) question.
     */
    onDynamicPanelCurrentIndexChanged: EventBase<SurveyModel, DynamicPanelCurrentIndexChangedEvent>;
    /**
     * An event that is raised to define whether a question answer is correct. Applies only to [quiz surveys](https://surveyjs.io/form-library/documentation/design-survey/create-a-quiz).
     */
    onCheckAnswerCorrect: EventBase<SurveyModel, CheckAnswerCorrectEvent>;
    /**
     * @deprecated Use the [`onCheckAnswerCorrect`](https://surveyjs.io/form-library/documentation/api-reference/survey-data-model#onCheckAnswerCorrect) event instead.
     */
    onIsAnswerCorrect: EventBase<SurveyModel, IsAnswerCorrectEvent>;
    /**
     * An event that is raised when users drag and drop survey elements while designing the survey in [Survey Creator](https://surveyjs.io/survey-creator/documentation/overview). Use this event to control drag and drop operations.
     * @see isDesignMode
     */
    onDragDropAllow: EventBase<SurveyModel, DragDropAllowEvent>;
    /**
     * An event this is raised before a survey element (usually page) is scrolled to the top. Use this event to cancel the scroll operation.
     */
    onScrollToTop: EventBase<SurveyModel, ScrollToTopEvent>;
    /**
     * @deprecated Use the [`onScrollToTop`](https://surveyjs.io/form-library/documentation/api-reference/survey-data-model#onScrollToTop) event instead.
     */
    onScrollingElementToTop: EventBase<SurveyModel, ScrollingElementToTopEvent>;
    onLocaleChangedEvent: EventBase<SurveyModel, {}>;
    /**
     * An event that allows you to add, delete, or modify actions in a question title.
     *
     * For information on event handler parameters, refer to descriptions within the interface.
     *
     * [View Demo](https://surveyjs.io/form-library/examples/survey-titleactions/ (linkStyle))
     * @see [IAction](https://surveyjs.io/form-library/documentation/api-reference/iaction)
    */
    onGetQuestionTitleActions: EventBase<SurveyModel, GetQuestionTitleActionsEvent>;
    /**
     * An event that allows you to add, delete, or modify actions in a panel title.
     * @see [IAction](https://surveyjs.io/form-library/documentation/api-reference/iaction)
     */
    onGetPanelTitleActions: EventBase<SurveyModel, GetPanelTitleActionsEvent>;
    /**
     * An event that allows you to add, delete, or modify actions in a page title.
     *
     * For information on event handler parameters, refer to descriptions within the interface.
     *
     * [View Demo](https://surveyjs.io/form-library/examples/modify-titles-of-survey-elements/ (linkStyle))
     * @see [IAction](https://surveyjs.io/form-library/documentation/api-reference/iaction)
     */
    onGetPageTitleActions: EventBase<SurveyModel, GetPageTitleActionsEvent>;
    /**
     * An event that allows you to add, delete, or modify actions in the footer of a [Panel](https://surveyjs.io/form-library/documentation/panelmodel). This panel may belong to a [Dynamic Panel](https://surveyjs.io/form-library/documentation/api-reference/dynamic-panel-model) or be a standalone survey element.
     * @see [IAction](https://surveyjs.io/form-library/documentation/api-reference/iaction)
     */
    onGetPanelFooterActions: EventBase<SurveyModel, GetPanelFooterActionsEvent>;
    /**
     * An event that allows you to add, delete, or modify actions in rows of a [Dynamic Matrix](https://surveyjs.io/form-library/examples/questiontype-matrixdynamic/).
     *
     * For information on event handler parameters, refer to descriptions within the interface.
     *
     * [View Demo](https://surveyjs.io/form-library/examples/employee-information-form/ (linkStyle))
     * @see [IAction](https://surveyjs.io/form-library/documentation/api-reference/iaction)
     */
    onGetMatrixRowActions: EventBase<SurveyModel, GetMatrixRowActionsEvent>;
    onElementContentVisibilityChanged: EventBase<SurveyModel, any>;
    /**
     * An event that is raised before an [Expression](https://surveyjs.io/form-library/documentation/api-reference/expression-model) question displays a value. Use this event to override the display value.
     */
    onGetExpressionDisplayValue: EventBase<SurveyModel, GetExpressionDisplayValueEvent>;
    /**
     * An event that is raised after the visibility of a popup is changed.
     *
     * This event can be raised for [Single-](https://surveyjs.io/form-library/documentation/api-reference/dropdown-menu-model) and [Multi-Select Dropdown](https://surveyjs.io/form-library/documentation/api-reference/dropdown-tag-box-model) questions and [Rating Scale](https://surveyjs.io/form-library/documentation/api-reference/rating-scale-question-model) questions [rendered as drop-down menus](https://surveyjs.io/form-library/documentation/api-reference/rating-scale-question-model#displayMode), and [Multi-Select Matrix](https://surveyjs.io/form-library/documentation/api-reference/matrix-table-with-dropdown-list) questions that contain columns of the `"dropdown"` or `"tagbox"` [`cellType`](https://surveyjs.io/form-library/documentation/api-reference/matrix-table-with-dropdown-list#cellType).
     */
    onPopupVisibleChanged: EventBase<SurveyModel, PopupVisibleChangedEvent>;
    /**
     * An event that is raised when users open a drop-down menu.
     *
     * This event can be raised for [Single-](https://surveyjs.io/form-library/documentation/api-reference/dropdown-menu-model) and [Multi-Select Dropdown](https://surveyjs.io/form-library/documentation/api-reference/dropdown-tag-box-model) questions, [Rating Scale](https://surveyjs.io/form-library/documentation/api-reference/rating-scale-question-model) questions [rendered as drop-down menus](https://surveyjs.io/form-library/documentation/api-reference/rating-scale-question-model#displayMode), and [Multi-Select Matrix](https://surveyjs.io/form-library/documentation/api-reference/matrix-table-with-dropdown-list) questions that contain columns of the `"dropdown"` or `"tagbox"` [`cellType`](https://surveyjs.io/form-library/documentation/api-reference/matrix-table-with-dropdown-list#cellType). Handle this event to change the drop-down menu type for specific questions or device types.
     */
    onOpenDropdownMenu: EventBase<SurveyModel, OpenDropdownMenuEvent>;
    onElementWrapperComponentName: EventBase<SurveyModel, any>;
    onElementWrapperComponentData: EventBase<SurveyModel, any>;
    constructor(jsonObj?: any, renderedElement?: any);
    get sjsVersion(): string;
    set sjsVersion(val: string);
    processClosedPopup(question: IQuestion, popupModel: PopupModel<any>): void;
    protected createTryAgainAction(): IAction;
    private createHtmlLocString;
    /**
     * A list of errors in a survey JSON schema.
     * @see ensureUniqueNames
     */
    jsonErrors: Array<JsonError>;
    getType(): string;
    protected onPropertyValueChanged(name: string, oldValue: any, newValue: any): void;
    /**
     * Returns an array of all pages in the survey.
     *
     * To get an array of only visible pages, use the [`visiblePages`](https://surveyjs.io/form-library/documentation/api-reference/survey-data-model#visiblePages) array.
     * @see PageModel
     */
    get pages(): Array<PageModel>;
    renderCallback: () => void;
    render(element?: any): void;
    updateSurvey(newProps: any, oldProps?: any): void;
    getCss(): any;
    private cssValue;
    private updateCompletedPageCss;
    private updateCss;
    /**
     * Gets or sets an object in which keys are UI elements and values are CSS classes applied to them.
     *
     * [View Demo](https://surveyjs.io/form-library/examples/customize-survey-with-css/ (linkStyle))
     */
    get css(): any;
    set css(value: any);
    setCss(value: any, needMerge?: boolean): void;
    get cssTitle(): string;
    get cssNavigationComplete(): string;
    get cssNavigationPreview(): string;
    get cssNavigationEdit(): string;
    get cssNavigationPrev(): string;
    get cssNavigationStart(): string;
    get cssNavigationNext(): string;
    private get cssSurveyNavigationButton();
    get bodyCss(): string;
    get bodyContainerCss(): string;
    completedCss: string;
    completedBeforeCss: string;
    loadingBodyCss: string;
    containerCss: string;
    fitToContainer: boolean;
    /**
     * @deprecated Use the [`headerView`](https://surveyjs.io/form-library/documentation/api-reference/itheme#headerView) property within a theme instead.
     */
    headerView: "advanced" | "basic";
    protected insertAdvancedHeader(advHeader: Cover): void;
    /**
     * Specifies whether the [Complete page](https://surveyjs.io/form-library/documentation/design-survey/create-a-multi-page-survey#complete-page) should display the [survey header](https://surveyjs.io/form-library/examples/brand-your-survey-header/).
     *
     * Possible values:
     *
     * - `true` - Displays the survey header on the Complete page.
     * - `false` - Hides the header when users reach the Complete page.
     * - `"auto"` (default) - Displays a header with the basic view, but hides a header with the advanced view (see the [`headerView`](https://surveyjs.io/form-library/documentation/api-reference/itheme#headerView) property description).
     *
     * > This property cannot be specified in the survey JSON schema. Use dot notation to specify it.
     */
    showHeaderOnCompletePage: true | false | "auto";
    private getNavigationCss;
    private lazyRenderEnabledValue;
    showBrandInfo: boolean;
    enterKeyAction: "moveToNextEditor" | "loseFocus" | "default";
    /**
     * Specifies whether to enable lazy rendering.
     *
     * In default mode, a survey renders the entire current page. With lazy rendering, the survey renders the page gradually as a user scrolls it. This helps reduce survey startup time and optimizes large surveys for low-end devices.
     *
     * Default value: `false`
     *
     * [View Demo](https://surveyjs.io/form-library/examples/survey-lazy/ (linkStyle))
     * @see [settings.lazyRender](https://surveyjs.io/form-library/documentation/api-reference/settings#lazyRender)
     */
    get lazyRenderEnabled(): boolean;
    set lazyRenderEnabled(val: boolean);
    /**
     * @deprecated Use the [`lazyRenderEnabled`](https://surveyjs.io/form-library/documentation/api-reference/survey-data-model#lazyRenderEnabled) property instead.
     */
    get lazyRendering(): boolean;
    set lazyRendering(val: boolean);
    get isLazyRendering(): boolean;
    lazyRenderFirstBatchSizeValue: number;
    get lazyRenderFirstBatchSize(): number;
    set lazyRenderFirstBatchSize(val: number);
    protected _isLazyRenderingSuspended: boolean;
    get isLazyRenderingSuspended(): boolean;
    protected suspendLazyRendering(): void;
    protected releaseLazyRendering(): void;
    private updateLazyRenderingRowsOnRemovingElements;
    /**
     * A list of triggers in the survey.
     *
     * [Conditional Survey Logic (Triggers)](https://surveyjs.io/form-library/documentation/design-survey/conditional-logic#conditional-survey-logic-triggers (linkStyle))
     * @see runTriggers
     * @see onTriggerExecuted
     */
    get triggers(): Array<SurveyTrigger>;
    set triggers(val: Array<SurveyTrigger>);
    /**
     * An array of [calculated values](https://surveyjs.io/form-library/documentation/design-survey-conditional-logic#calculated-values).
     */
    get calculatedValues(): Array<CalculatedValue>;
    set calculatedValues(val: Array<CalculatedValue>);
    /**
     * The identifier of a survey JSON schema to load from [SurveyJS Service](https://api.surveyjs.io).
     *
     * Refer to the following help topic for more information: [Store Survey Results in the SurveyJS Service](https://surveyjs.io/form-library/documentation/handle-survey-results-store#store-survey-results-in-the-surveyjs-service).
     * @see loadSurveyFromService
     * @see onLoadedSurveyFromService
     */
    get surveyId(): string;
    set surveyId(val: string);
    /**
     * An identifier used to save survey results to [SurveyJS Service](https://api.surveyjs.io).
     *
     * Refer to the following help topic for more information: [Store Survey Results in the SurveyJS Service](https://surveyjs.io/form-library/documentation/handle-survey-results-store#store-survey-results-in-the-surveyjs-service).
     * @see onComplete
     * @see surveyShowDataSaving
     */
    get surveyPostId(): string;
    set surveyPostId(val: string);
    /**
     * A user identifier (e-mail or other unique ID).
     *
     * If your application works with [SurveyJS Service](https://api.surveyjs.io), the ID ensures that users do not pass the same survey twice. On the second run, they will see the [Completed Before page](https://surveyjs.io/form-library/documentation/api-reference/survey-data-model#completedBeforeHtml).
     * @see cookieName
     */
    get clientId(): string;
    set clientId(val: string);
    /**
     * A cookie name used to save information about survey completion.
     *
     * When this property has a value, the survey creates a cookie with the specified name on completion. This cookie helps ensure that users do not pass the same survey twice. On the second run, they will see the [Completed Before page](https://surveyjs.io/form-library/documentation/api-reference/survey-data-model#completedBeforeHtml).
     * @see clientId
     */
    get cookieName(): string;
    set cookieName(val: string);
    /**
     * Specifies whether to save survey results when respondents switch between pages. Handle the [`onPartialSend`](https://surveyjs.io/form-library/documentation/api-reference/survey-data-model#onPartialSend) event to implement the save operation.
     *
     * Alternatively, you can handle the [`onCurrentPageChanged`](#onCurrentPageChanged) and [`onValueChanged`](#onValueChanged) events, as shown in the following demo: [Continue an Incomplete Survey](https://surveyjs.io/form-library/examples/survey-editprevious/).
     */
    get partialSendEnabled(): boolean;
    set partialSendEnabled(val: boolean);
    /**
     * @deprecated Use the [`partialSend`](https://surveyjs.io/form-library/documentation/api-reference/survey-data-model#partialSend) property instead.
     */
    get sendResultOnPageNext(): boolean;
    set sendResultOnPageNext(val: boolean);
    /**
     * Specifies whether to show progress when the survey sends data to [SurveyJS Service](https://api.surveyjs.io).
     *
     * [View Demo](https://surveyjs.io/form-library/examples/save-survey-results-and-load-surveys-from-surveyjs-service/ (linkStyle))
     * @see surveyPostId
     */
    get surveyShowDataSaving(): boolean;
    set surveyShowDataSaving(val: boolean);
    /**
     * Specifies whether to focus the first question on the page on survey startup or when users switch between pages.
     *
     * Default value: `false` in v1.9.114 and later, `true` in earlier versions
     * @see autoFocusFirstError
     * @see focusFirstQuestion
     * @see focusQuestion
     */
    get autoFocusFirstQuestion(): boolean;
    set autoFocusFirstQuestion(val: boolean);
    /**
     * @deprecated Use the [`autoFocusFirstQuestion`](https://surveyjs.io/form-library/documentation/api-reference/survey-data-model#autoFocusFirstQuestion) property instead.
     */
    get focusFirstQuestionAutomatic(): boolean;
    set focusFirstQuestionAutomatic(val: boolean);
    /**
     * Specifies whether to focus the first question with a validation error on the current page.
     *
     * Default value: `true`
     * @see validate
     * @see autoFocusFirstQuestion
     */
    get autoFocusFirstError(): boolean;
    set autoFocusFirstError(val: boolean);
    /**
     * @deprecated Use the [`autoFocusFirstError`](https://surveyjs.io/form-library/documentation/api-reference/survey-data-model#autoFocusFirstError) property instead.
     */
    get focusOnFirstError(): boolean;
    set focusOnFirstError(val: boolean);
    /**
     * Gets or sets the visibility of the Start, Next, Previous, and Complete navigation buttons.
     *
     * Possible values:
     *
     * - `true` (default) - Displays the navigation buttons.
     * - `false` - Hides the navigation buttons. This setting may be useful if you [implement custom external navigation](https://surveyjs.io/form-library/examples/external-form-navigation-system/).
     * @see navigationButtonsLocation
     * @see autoAdvanceEnabled
     * @see showPrevButton
     * @see showCompleteButton
     */
    get showNavigationButtons(): boolean | any;
    set showNavigationButtons(val: boolean | any);
    /**
     * Gets or sets the position of the Start, Next, Previous, and Complete navigation buttons. Applies only if the [`showNavigationButtons`](https://surveyjs.io/form-library/documentation/api-reference/survey-data-model#showNavigationButtons) property is `true`.
     *
     * Possible values:
     *
     * - `"bottom"` (default) - Displays the navigation buttons below survey content.
     * - `"top"` - Displays the navigation buttons above survey content.
     * - `"topBottom"` - Displays the navigation buttons above and below survey content.
     * @see autoAdvanceEnabled
     * @see showPrevButton
     * @see showCompleteButton
     */
    get navigationButtonsLocation(): string | any;
    set navigationButtonsLocation(val: string | any);
    /**
     * Specifies whether to display the Previous button. Set this property to `false` if respondents should not move backward along the survey.
     * @see showNavigationButtons
     * @see showCompleteButton
     */
    get showPrevButton(): boolean;
    set showPrevButton(val: boolean);
    /**
     * Specifies whether to display the Complete button. Set this property to `false` if respondents should not complete the survey.
     * @see showNavigationButtons
     * @see showPrevButton
     */
    get showCompleteButton(): boolean;
    set showCompleteButton(val: boolean);
    /**
     * Gets or sets the visibility of the table of contents.
     *
     * Default value: `false`
     *
     * [View Demo](https://surveyjs.io/form-library/examples/toc-feature/ (linkStyle))
     * @see tocLocation
     */
    get showTOC(): boolean;
    set showTOC(val: boolean);
    /**
     * Gets or sets the position of the table of contents. Applies only when the table of contents is visible.
     *
     * Possible values:
     *
     * - `"left"` (default)
     * - `"right"`
     *
     * [View Demo](https://surveyjs.io/form-library/examples/toc-feature/ (linkStyle))
     * @see showTOC
     */
    get tocLocation(): "left" | "right";
    set tocLocation(val: "left" | "right");
    /**
     * Specifies whether to display the [survey title](https://surveyjs.io/form-library/documentation/api-reference/survey-data-model#title).
     *
     * [View Demo](https://surveyjs.io/form-library/examples/brand-your-survey-header/ (linkStyle))
     * @see title
     */
    get showTitle(): boolean;
    set showTitle(val: boolean);
    /**
     * Specifies whether to display [page titles](https://surveyjs.io/form-library/documentation/api-reference/page-model#title).
     */
    get showPageTitles(): boolean;
    set showPageTitles(val: boolean);
    /**
     * Specifies whether to show the [complete page](https://surveyjs.io/form-library/documentation/design-survey/create-a-multi-page-survey#complete-page).
     * @see onComplete
     * @see navigateToUrl
     */
    get showCompletePage(): boolean;
    set showCompletePage(val: boolean);
    /**
     * @deprecated Use the [`showCompletePage`](https://surveyjs.io/form-library/documentation/api-reference/survey-data-model#showCompletePage) property instead.
     */
    get showCompletedPage(): boolean;
    set showCompletedPage(val: boolean);
    /**
     * A URL to which respondents should be navigated after survey completion.
     * @see onNavigateToUrl
     * @see navigateToUrlOnCondition
     */
    get navigateToUrl(): string;
    set navigateToUrl(val: string);
    /**
     * An array of objects that allows you to navigate respondents to different URLs after survey completion.
     *
     * Each object should include the [`expression`](https://surveyjs.io/form-library/documentation/api-reference/urlconditionitem#url) and [`url`](https://surveyjs.io/form-library/documentation/api-reference/urlconditionitem#expression) properties. When `expression` evaluates to `true`, the survey navigates to the corresponding `url`. Refer to the following help topic for more information about expressions: [Expressions](https://surveyjs.io/form-library/documentation/design-survey/conditional-logic#expressions).
     * @see onNavigateToUrl
     * @see navigateToUrl
     */
    get navigateToUrlOnCondition(): Array<UrlConditionItem>;
    set navigateToUrlOnCondition(val: Array<UrlConditionItem>);
    getNavigateToUrl(): string;
    private navigateTo;
    /**
     * Specifies one or multiple characters that designate required questions.
     *
     * Default value: `*`
     *
     * [View Demo](https://surveyjs.io/form-library/examples/modify-question-title/ (linkStyle))
     */
    get requiredMark(): string;
    set requiredMark(val: string);
    /**
     * @deprecated Use the [`requiredMark`](https://surveyjs.io/form-library/documentation/api-reference/survey-data-model#requiredMark) property instead.
     */
    get requiredText(): string;
    set requiredText(val: string);
    /**
     * Specifies whether to hide validation errors thrown by the Required validation in the UI.
     *
     * [Built-In Client-Side Validators](https://surveyjs.io/form-library/documentation/data-validation#built-in-client-side-validators (linkStyle))
     * @see validationEnabled
     * @see validationAllowSwitchPages
     */
    hideRequiredErrors: boolean;
    private beforeSettingQuestionErrors;
    private makeRequiredErrorsInvisible;
    /**
     * Specifies the initial number or letter from which to start question numbering.
     *
     * [Question Numbers](https://surveyjs.io/form-library/documentation/design-survey/configure-question-titles#question-numbers (linkStyle))
     */
    get questionStartIndex(): string;
    set questionStartIndex(val: string);
    /**
     * Specifies whether to store the "Other" option response in a separate property.
     *
     * Default value: `true`
     *
     * Respondents can leave comments when they select "Other" in choice-based questions, such as Dropdown or Checkboxes. Comment values are saved in a separate property. The property name is composed of the question `name` and [`commentSuffix`](#commentSuffix). However, you can use the question `name` as a key to store the comment value instead. Disable the `storeOthersAsComment` property in this case.
     * @see maxCommentLength
     */
    get storeOthersAsComment(): boolean;
    set storeOthersAsComment(val: boolean);
    /**
     * Specifies the maximum text length in textual questions ([Single-Line Input](https://surveyjs.io/form-library/examples/text-entry-question/), [Long Text](https://surveyjs.io/form-library/examples/add-open-ended-question-to-a-form/), [Multiple Textboxes](https://surveyjs.io/form-library/examples/multiple-text-box-question/)), measured in characters.
     *
     * Default value: 0 (unlimited)
     *
     * You can override this setting for individual questions if you specify their [`maxLength`](https://surveyjs.io/form-library/documentation/api-reference/text-entry-question-model#maxLength) property.
     * @see maxCommentLength
     */
    get maxTextLength(): number;
    set maxTextLength(val: number);
    /**
     * Specifies the maximum text length for question comments. Applies to questions with the [`showCommentArea`](https://surveyjs.io/form-library/documentation/api-reference/question#showCommentArea) or [`showOtherItem`](https://surveyjs.io/form-library/documentation/api-reference/question#showOtherItem) property set to `true`.
     *
     * Default value: 0 (unlimited)
     * @see maxTextLength
     */
    get maxCommentLength(): number;
    set maxCommentLength(val: number);
    /**
     * @deprecated Use the [`maxCommentLength`](https://surveyjs.io/form-library/documentation/api-reference/survey-data-model#maxCommentLength) property instead.
     */
    get maxOthersLength(): number;
    set maxOthersLength(val: number);
    /**
     * Specifies whether the survey switches to the next page automatically after a user answers all questions on the current page.
     *
     * Default value: `false`
     *
     * If you enable this property, the survey is also completed automatically. Set the [`autoAdvanceAllowComplete`](https://surveyjs.io/form-library/documentation/api-reference/survey-data-model#autoAdvanceAllowComplete) property to `false` if you want to disable this behavior.
     *
     * > If any of the following questions is answered last, the survey does not switch to the next page: Checkboxes, Yes/No (Boolean) (rendered as Checkbox), Long Text, Signature, Image Picker (with Multi Select), File Upload, Single-Select Matrix (not all rows are answered), Dynamic Matrix, Dynamic Panel.
     *
     * [View Demo](https://surveyjs.io/form-library/examples/automatically-move-to-next-page-if-answer-selected/ (linkStyle))
     * @see [`settings.autoAdvanceDelay`](https://surveyjs.io/form-library/documentation/api-reference/settings#autoAdvanceDelay)
     */
    get autoAdvanceEnabled(): boolean;
    set autoAdvanceEnabled(val: boolean);
    /**
     * @deprecated Use the [`autoAdvanceEnabled`](https://surveyjs.io/form-library/documentation/api-reference/survey-data-model#autoAdvanceEnabled) property instead.
     */
    get goNextPageAutomatic(): boolean;
    set goNextPageAutomatic(val: boolean);
    /**
     * Specifies whether to complete the survey automatically after a user answers all questions on the last page. Applies only if the [`autoAdvanceEnabled`](https://surveyjs.io/form-library/documentation/api-reference/survey-data-model#autoAdvanceEnabled) property is `true`.
     *
     * Default value: `true`
     * @see [`settings.autoAdvanceDelay`](https://surveyjs.io/form-library/documentation/api-reference/settings#autoAdvanceDelay)
     */
    get autoAdvanceAllowComplete(): boolean;
    set autoAdvanceAllowComplete(val: boolean);
    /**
     * @deprecated Use the [`autoAdvanceAllowComplete`](https://surveyjs.io/form-library/documentation/api-reference/survey-data-model#autoAdvanceAllowComplete) property instead.
     */
    get allowCompleteSurveyAutomatic(): boolean;
    set allowCompleteSurveyAutomatic(val: boolean);
    /**
     * Specifies when the survey validates answers.
     *
     * Possible values:
     *
     * - `"onNextPage"` (default) - Triggers validation before the survey is switched to the next page or completed.
     * - `"onValueChanged"` - Triggers validation each time a question value is changed.
     * - `"onComplete"` - Triggers validation when a user clicks the Complete button. If previous pages contain errors, the survey switches to the page with the first error.
     *
     * > In SurveyJS Form Library v1.12.5 and earlier, the `"onValueChanged"` mode doesn't work with date input fields because of the way browsers process date values. In most browsers, the value is considered changed as soon as a user starts entering the date in a text input field. This means that a user may only enter the day without having the chance to enter the month and year before validation is triggered. For this reason, date input fields are validated before the survey is switched to the next page or completed. Starting with v1.12.6, `"onValueChanged"` works for date input fields as well as for input fields of other types.
     *
     * Refer to the following help topic for more information: [Data Validation](https://surveyjs.io/form-library/documentation/data-validation).
     * @see validationEnabled
     * @see validationAllowSwitchPages
     * @see validationAllowComplete
     * @see validate
     */
    get checkErrorsMode(): string;
    set checkErrorsMode(val: string);
    /**
     * Specifies whether to trigger validation when a user focuses on an empty input field and then leaves it without making any changes. Applies only if [`checkErrorsMode`](https://surveyjs.io/form-library/documentation/api-reference/survey-data-model#checkErrorsMode) is set to `"onValueChanged"`.
     *
     * Default value: `false`
     *
     * This property changes validation behavior for the following question types:
     *
     * - [Single-Line Input](https://surveyjs.io/form-library/documentation/api-reference/text-entry-question-model)
     * - [Long Text](https://surveyjs.io/form-library/documentation/api-reference/comment-field-model)
     * - [Dropdown](https://surveyjs.io/form-library/documentation/api-reference/dropdown-menu-model)
     * @see validationEnabled
     * @see validationAllowSwitchPages
     * @see validationAllowComplete
     * @see validate
     */
    get validateVisitedEmptyFields(): boolean;
    set validateVisitedEmptyFields(val: boolean);
    getValidateVisitedEmptyFields(): boolean;
    /**
     * Specifies whether to increase the height of [Long Text](https://surveyjs.io/form-library/examples/add-open-ended-question-to-a-form/) questions and other text areas to accommodate multi-line text content.
     *
     * Default value: `false`
     *
     * You can override this property for individual Long Text questions: [`autoGrow`](https://surveyjs.io/form-library/documentation/api-reference/comment-field-model#autoGrow).
     * @see allowResizeComment
     * @see commentAreaRows
     */
    get autoGrowComment(): boolean;
    set autoGrowComment(val: boolean);
    /**
     * Specifies whether to display a resize handle for [Long Text](https://surveyjs.io/form-library/examples/add-open-ended-question-to-a-form/) questions and other text areas intended for multi-line text content.
     *
     * Default value: `true`
     *
     * You can override this property for individual Long Text questions: [`allowResize`](https://surveyjs.io/form-library/documentation/api-reference/comment-field-model#allowResize).
     * @see autoGrowComment
     * @see commentAreaRows
     */
    get allowResizeComment(): boolean;
    set allowResizeComment(val: boolean);
    /**
     * Specifies the visible height of comment areas, measured in lines. Applies to the questions with the [`showCommentArea`](https://surveyjs.io/form-library/documentation/api-reference/question#showCommentArea) or [`showOtherItem`](https://surveyjs.io/form-library/documentation/api-reference/question#showOtherItem) property enabled.
     *
     * Default value: 2
     *
     * The value of this property is passed on to the `rows` attribute of the underlying `<textarea>` element.
     * @see autoGrowComment
     * @see allowResizeComment
     */
    get commentAreaRows(): number;
    set commentAreaRows(val: number);
    /**
     * Specifies when to update the question value in questions with a text input field.
     *
     * Possible values:
     *
     * - `"onBlur"` (default) - Updates the value after the input field loses focus.
     * - `"onTyping"` - Updates the value on every key press.
     *
     * > Do not use the `"onTyping"` mode if your survey contains many expressions. Expressions are reevaluated each time a question value is changed. In `"onTyping"` mode, the question value changes frequently. This may cause performance degradation.
     *
     * You can override this setting for individual questions: [`textUpdateMode`](https://surveyjs.io/form-library/documentation/api-reference/text-entry-question-model#textUpdateMode).
     */
    get textUpdateMode(): string;
    set textUpdateMode(val: string);
    /**
     * Specifies when to remove values of invisible questions from [survey results](https://surveyjs.io/form-library/documentation/api-reference/survey-data-model#data).
     *
     * Possible values:
     *
     * - `"onComplete"` (default) - Clears invisible question values when the survey is complete.
     * - `"onHidden"` - Clears a question value when the question becomes invisible. If the question is invisible initially, its value is removed on survey completion.
     * - `"onHiddenContainer"` - Clears a question value when the question or its containter (page or panel) becomes invisible. If the question is invisible initially, its value is removed on survey completion.
     * - `"none"` - Keeps invisible values in survey results.
     * - `true` - Equivalent to `"onComplete"`.
     * - `false` - Equivalent to `"none"`.
     * @see [Conditional Visibility](https://surveyjs.io/form-library/documentation/design-survey/conditional-logic#conditional-visibility)
     * @see onComplete
     */
    get clearInvisibleValues(): any;
    set clearInvisibleValues(val: any);
    /**
     * Removes values that cannot be assigned to a question, for example, choices unlisted in the `choices` array.
     *
     * Call this method after you assign new question values in code to ensure that they are acceptable.
     *
     * > This method does not remove values that fail validation. Call the [`validate()`](https://surveyjs.io/form-library/documentation/api-reference/survey-data-model#validate) method to validate newly assigned values.
     * @param removeNonExistingRootKeys Pass `true` to remove values that do not correspond to any question or [calculated value](https://surveyjs.io/form-library/documentation/design-survey/conditional-logic#calculated-values).
     */
    clearIncorrectValues(removeNonExistingRootKeys?: boolean): void;
    private iscorrectValueWithPostPrefix;
    /**
     * Specifies whether to keep values that cannot be assigned to questions, for example, choices unlisted in the `choices` array.
     *
     * > This property cannot be specified in the survey JSON schema. Use dot notation to specify it.
     * @see clearIncorrectValues
     */
    get keepIncorrectValues(): boolean;
    set keepIncorrectValues(val: boolean);
    /**
     * Specifies the survey's locale.
     *
     * Default value: `""` (a default locale is used)
     *
     * [Localization & Globalization help topic](https://surveyjs.io/form-library/documentation/survey-localization (linkStyle))
     *
     * [Survey Localization demo](https://surveyjs.io/form-library/examples/survey-localization/ (linkStyle))
     */
    get locale(): string;
    set locale(value: string);
    private onSurveyLocaleChanged;
    get localeDir(): string;
    /**
     * Returns an array of locales whose translations are used in the survey.
     *
     * [Localization & Globalization help topic](https://surveyjs.io/form-library/documentation/survey-localization (linkStyle))
     *
     * [Survey Localization demo](https://surveyjs.io/form-library/examples/survey-localization/ (linkStyle))
     */
    getUsedLocales(): Array<string>;
    localeChanged(): void;
    getLocale(): string;
    locStrsChanged(): void;
    getMarkdownHtml(text: string, name: string): string;
    getRenderer(name: string): string;
    getRendererContext(locStr: LocalizableString): any;
    getRendererForString(element: Question | PanelModel | PageModel | SurveyModel, name: string): string;
    getRendererContextForString(element: Base, locStr: LocalizableString): any;
    getExpressionDisplayValue(question: Question, value: any, displayValue: string): string;
    private getBuiltInRendererForString;
    getProcessedText(text: string): string;
    getLocString(str: string): string;
    getErrorCustomText(text: string, error: SurveyError): string;
    getSurveyErrorCustomText(obj: PanelModel | Question | SurveyModel, text: string, error: SurveyError): string;
    getQuestionDisplayValue(question: Question, displayValue: any): any;
    /**
     * A message that is displayed when a survey does not contain visible pages or questions.
     * @see [Localization & Globalization](https://surveyjs.io/form-library/documentation/survey-localization)
     */
    get emptySurveyText(): string;
    set emptySurveyText(val: string);
    /**
     * An image URL or a Base64-encoded image to use as a survey logo.
     *
     * [View Demo](https://surveyjs.io/form-library/examples/survey-logo/ (linkStyle))
     * @see logoPosition
     * @see logoFit
     */
    get logo(): string;
    set logo(value: string);
    get locLogo(): LocalizableString;
    /**
     * A logo width in CSS-accepted values.
     *
     * Default value: `auto` (the width is calculated automatically based on the [`logoHeight`](https://surveyjs.io/form-library/documentation/api-reference/survey-data-model#logoHeight) value to keep the original aspect ratio)
     *
     * [View Demo](https://surveyjs.io/form-library/examples/survey-logo/ (linkStyle))
     * @see logo
     * @see logoPosition
     * @see logoFit
     */
    get logoWidth(): any;
    set logoWidth(value: any);
    get renderedLogoWidth(): number;
    get renderedStyleLogoWidth(): string;
    /**
     * A logo height in CSS-accepted values.
     *
     * Default value: `40px`
     *
     * [View Demo](https://surveyjs.io/form-library/examples/survey-logo/ (linkStyle))
     * @see logoWidth
     * @see logo
     * @see logoPosition
     * @see logoFit
     */
    get logoHeight(): any;
    set logoHeight(value: any);
    get renderedLogoHeight(): number;
    get renderedStyleLogoHeight(): string;
    /**
     * A logo position relative to the [survey title](https://surveyjs.io/form-library/documentation/api-reference/survey-data-model#title).
     *
     * Possible values:
     *
     * - `"left"` (default) - Places the logo to the left of the survey title.
     * - `"right"` - Places the logo to the right of the survey title.
     * - `"none"` - Hides the logo.
     *
     * [View Demo](https://surveyjs.io/form-library/examples/survey-logo/ (linkStyle))
     * @see logo
     * @see logoFit
     */
    get logoPosition(): string;
    set logoPosition(value: string);
    get hasLogo(): boolean;
    private updateHasLogo;
    get isLogoBefore(): boolean;
    get isLogoAfter(): boolean;
    get logoClassNames(): string;
    private titleIsEmpty;
    get renderedHasTitle(): boolean;
    get renderedHasDescription(): boolean;
    get hasTitle(): boolean;
    get renderedHasLogo(): boolean;
    get renderedHasHeader(): boolean;
    /**
     * Specifies how to resize a logo to fit it into its container.
     *
     * Possible values:
     *
     * - `"contain"` (default)
     * - `"cover"`
     * - `"fill"`
     * - `"none"`
     *
     * Refer to the [`object-fit`](https://developer.mozilla.org/en-US/docs/Web/CSS/object-fit) CSS property description for information on the possible values.
     *
     * [View Demo](https://surveyjs.io/form-library/examples/survey-logo/ (linkStyle))
     * @see logo
     * @see logoPosition
     */
    get logoFit(): string;
    set logoFit(val: string);
    private cssVariables;
    get themeVariables(): {
        [index: string]: string;
    };
    _isMobile: boolean;
    setIsMobile(newVal?: boolean): void;
    get isMobile(): boolean;
    private _isCompact;
    set isCompact(newVal: boolean);
    get isCompact(): boolean;
    protected isLogoImageChoosen(): string;
    get titleMaxWidth(): string;
    /**
     * An image to display in the background of the survey or form. Accepts a base64 or URL string value.
     * @see backgroundOpacity
     */
    backgroundImage: string;
    renderBackgroundImage: string;
    private updateRenderBackgroundImage;
    backgroundImageFit: ImageFit;
    backgroundImageAttachment: ImageAttachment;
    /**
     * A value from 0 to 1 that specifies how transparent the [background image](https://surveyjs.io/form-library/documentation/api-reference/survey-data-model#backgroundImage) should be: 0 makes the image completely transparent, and 1 makes it opaque.
     */
    get backgroundOpacity(): number;
    set backgroundOpacity(val: number);
    backgroundImageStyle: any;
    updateBackgroundImageStyle(): void;
    wrapperFormCss: string;
    updateWrapperFormCss(): void;
    /**
     * HTML content displayed on the [complete page](https://surveyjs.io/form-library/documentation/design-survey/create-a-multi-page-survey#complete-page).
     *
     * [View Demo](https://surveyjs.io/form-library/examples/modify-survey-navigation-settings/ (linkStyle))
     * @see showCompletePage
     * @see completedHtmlOnCondition
     */
    get completedHtml(): string;
    set completedHtml(value: string);
    get locCompletedHtml(): LocalizableString;
    /**
     * An array of objects that allows you to specify different HTML content for the [complete page](https://surveyjs.io/form-library/documentation/design-survey/create-a-multi-page-survey#complete-page).
     *
     * Each object should include the [`expression`](https://surveyjs.io/form-library/documentation/api-reference/htmlconditionitem#expression) and [`html`](https://surveyjs.io/form-library/documentation/api-reference/htmlconditionitem#html) properties. When `expression` evaluates to `true`, the survey uses the corresponding HTML markup instead of [`completedHtml`](https://surveyjs.io/form-library/documentation/api-reference/survey-data-model#completedHtml). Refer to the following help topic for more information about expressions: [Expressions](https://surveyjs.io/form-library/documentation/design-survey/conditional-logic#expressions).
     *
     * [View Demo](https://surveyjs.io/form-library/examples/nps-question/ (linkStyle))
     */
    get completedHtmlOnCondition(): Array<HtmlConditionItem>;
    set completedHtmlOnCondition(val: Array<HtmlConditionItem>);
    /**
     * Calculates a given [expression](https://surveyjs.io/form-library/documentation/design-survey/conditional-logic#expressions) and returns a result value.
     * @param expression An expression to calculate.
     * @param callback A callback function that you can use to access the calculation result if the expression uses asynchronous functions.
     */
    runExpression(expression: string, callback?: (res: any) => void): any;
    private setValueOnExpressionCounter;
    get isSettingValueOnExpression(): boolean;
    startSetValueOnExpression(): void;
    finishSetValueOnExpression(): void;
    /**
     * Calculates a given [expression](https://surveyjs.io/form-library/documentation/design-survey/conditional-logic#expressions) and returns `true` or `false`.
     * @param expression An expression to calculate.
     */
    runCondition(expression: string): boolean;
    /**
     * Executes [all triggers](https://surveyjs.io/form-library/documentation/api-reference/survey-data-model#triggers), except ["complete"](https://surveyjs.io/form-library/documentation/design-survey/conditional-logic#complete).
     *
     * [Conditional Survey Logic (Triggers)](https://surveyjs.io/form-library/documentation/design-survey/conditional-logic#conditional-survey-logic-triggers (linkStyle))
     * @see onTriggerExecuted
     */
    runTriggers(): void;
    get renderedCompletedHtml(): string;
    private getExpressionItemOnRunCondition;
    /**
     * HTML content displayed to a user who has completed the survey before. To identify such users, the survey uses a [cookie name](#cookieName) or [client ID](#clientId).
     * @see processedCompletedBeforeHtml
     */
    get completedBeforeHtml(): string;
    set completedBeforeHtml(value: string);
    get locCompletedBeforeHtml(): LocalizableString;
    /**
     * HTML content displayed while a survey JSON schema is being loaded from [SurveyJS Service](https://api.surveyjs.io).
     * @see surveyId
     * @see processedLoadingHtml
     */
    get loadingHtml(): string;
    set loadingHtml(value: string);
    get locLoadingHtml(): LocalizableString;
    get defaultLoadingHtml(): string;
    get navigationBar(): ActionContainer;
    /**
     * Adds a custom navigation item similar to the Previous Page, Next Page, and Complete buttons.
     * Accepts an object described in the [IAction](https://surveyjs.io/Documentation/Library?id=IAction) help section.
     *
     * [View Demo](https://surveyjs.io/form-library/examples/survey-changenavigation/ (linkStyle))
    */
    addNavigationItem(val: IAction): Action;
    /**
     * Gets or sets a caption for the Start button.
     * @see firstPageIsStartPage
     * @see [Localization & Globalization](https://surveyjs.io/form-library/documentation/survey-localization)
     */
    get startSurveyText(): string;
    set startSurveyText(newValue: string);
    get locStartSurveyText(): LocalizableString;
    /**
     * Gets or sets a caption for the Previous button.
     * @see [Localization & Globalization](https://surveyjs.io/form-library/documentation/survey-localization)
     */
    get pagePrevText(): string;
    set pagePrevText(newValue: string);
    get locPagePrevText(): LocalizableString;
    /**
     * Gets or sets a caption for the Next button.
     * @see [Localization & Globalization](https://surveyjs.io/form-library/documentation/survey-localization)
     */
    get pageNextText(): string;
    set pageNextText(newValue: string);
    get locPageNextText(): LocalizableString;
    /**
     * Gets or sets a caption for the Complete button.
     * @see [Localization & Globalization](https://surveyjs.io/form-library/documentation/survey-localization)
     */
    get completeText(): string;
    set completeText(newValue: string);
    get locCompleteText(): LocalizableString;
    /**
     * Gets or sets a caption for the Preview button.
     * @see showPreviewBeforeComplete
     * @see showPreview
     * @see editText
     */
    get previewText(): string;
    set previewText(newValue: string);
    get locPreviewText(): LocalizableString;
    /**
     * Gets or sets a caption for the Edit button displayed when the survey shows a [preview of given answers](https://surveyjs.io/form-library/documentation/design-survey/create-a-multi-page-survey#preview-page).
     * @see showPreviewBeforeComplete
     * @see cancelPreview
     * @see previewText
     */
    get editText(): string;
    set editText(newValue: string);
    get locEditText(): LocalizableString;
    getElementTitleTagName(element: Base, tagName: string): string;
    /**
     * Specifies a pattern for question titles.
     *
     * Refer to the following help topic for more information: [Title Pattern](https://surveyjs.io/form-library/documentation/design-survey/configure-question-titles#title-pattern).
     */
    get questionTitlePattern(): string;
    set questionTitlePattern(val: string);
    getQuestionTitlePatternOptions(): Array<any>;
    get questionTitleTemplate(): string;
    set questionTitleTemplate(value: string);
    private getNewTitlePattern;
    private getNewQuestionTitleElement;
    get locQuestionTitleTemplate(): LocalizableString;
    getUpdatedQuestionTitle(question: Question, title: string): string;
    getUpdatedQuestionNo(question: Question, no: string): string;
    getUpdatedPanelNo(panel: PanelModel, no: string): string;
    getUpdatedPageNo(page: PageModel, no: string): string;
    /**
     * Specifies whether page titles contain page numbers.
     *
     * [View Demo](https://surveyjs.io/form-library/examples/how-to-number-pages-and-questions/ (linkStyle))
     * @see onGetPageNumber
     */
    get showPageNumbers(): boolean;
    set showPageNumbers(value: boolean);
    /**
     * Specifies whether to display question numbers and how to calculate them.
     *
     * Possible values:
     *
     * - `true` or `"on"` - Displays question numbers.
     * - `"onpage"` - Displays question numbers and starts numbering on each page from scratch.
     * - `false` or `"off"` - Hides question numbers.
     *
     * [View Demo](https://surveyjs.io/form-library/examples/how-to-number-pages-and-questions/ (linkStyle))
     *
     * If you want to hide the number of an individual question, disable its [`showNumber`](https://surveyjs.io/form-library/documentation/api-reference/question#showNumber) property.
     * @see onGetQuestionNumber
     */
    get showQuestionNumbers(): string | boolean;
    set showQuestionNumbers(value: string | boolean);
    private progressBarValue;
    get progressBar(): any;
    /**
     * Specifies the visibility of the progress bar.
     *
     * Default value: `false`
     *
     * [View Demo](https://surveyjs.io/form-library/examples/navigation-default/ (linkStyle))
     * @see progressBarLocation
     * @see progressBarType
     * @see progressValue
     */
    get showProgressBar(): boolean;
    set showProgressBar(newValue: boolean | string);
    protected setShowProgressBar(newValue: boolean | string): void;
    /**
     * Specifies the alignment of the progress bar. Applies only if the [`showProgressBar`](https://surveyjs.io/form-library/documentation/api-reference/survey-data-model#showProgressBar) property is `true`.
     *
     * Possible values:
     *
     * - `"aboveHeader"` - Displays the progress bar above the survey header.
     * - `"belowHeader"` - Displays the progress bar below the survey header.
     * - `"bottom"` - Displays the progress bar below survey content.
     * - `"topBottom"` - Displays the progress bar above and below survey content.
     * - `"auto"` (default) - Displays the progress bar below the survey header if the header has a [background image](https://surveyjs.io/form-library/documentation/api-reference/iheader#backgroundImage) or color. Otherwise, the progress bar is displayed above the header.
     *
     * [View Demo](https://surveyjs.io/form-library/examples/navigation-default/ (linkStyle))
     * @see showProgressBar
     * @see progressBarType
     * @see progressValue
     */
    get progressBarLocation(): string;
    set progressBarLocation(newValue: string);
    /**
     * Specifies the type of information displayed by the progress bar. Applies only when [`showProgressBar`](#showProgressBar) is `true`.
     *
     * Possible values:
     *
     * - `"pages"` (default) - The number of completed pages.
     * - `"questions"` - The number of answered questions.
     * - `"requiredQuestions"` - The number of answered [required questions](https://surveyjs.io/form-library/documentation/api-reference/question#isRequired).
     * - `"correctQuestions"` - The number of correct questions in a [quiz](https://surveyjs.io/form-library/documentation/design-survey/create-a-quiz).
     * - `"buttons"` - *(Obsolete)* Use the `"pages"` property value with the [`progressBarShowPageTitles`](https://surveyjs.io/form-library/documentation/api-reference/survey-data-model#progressBarShowPageTitles) property set to `true` instead.
     *
     * > When `progressBarType` is set to `"pages"`, you can also enable the [`progressBarShowPageNumbers`](https://surveyjs.io/form-library/documentation/api-reference/survey-data-model#progressBarShowPageNumbers) and [`progressBarShowPageTitles`](https://surveyjs.io/form-library/documentation/api-reference/survey-data-model#progressBarShowPageTitles) properties if you want to display page numbers and titles in the progress bar.
     *
     * [View Demo](https://surveyjs.io/form-library/examples/navigation-buttons/ (linkStyle))
     * @see progressValue
     */
    get progressBarType(): string;
    set progressBarType(newValue: string);
    private get progressBarComponentName();
    /**
     * Specifies whether the progress bar displays page titles. Applies only when the [progress bar is visible](https://surveyjs.io/form-library/documentation/api-reference/survey-data-model#showProgressBar) and [`progressBarType`](https://surveyjs.io/form-library/documentation/api-reference/survey-data-model#progressBarType) is `"pages"`.
     *
     * Default value: `false`
     * @see progressBarShowPageNumbers
     * @see progressBarInheritWidthFrom
     */
    progressBarShowPageTitles: boolean;
    /**
     * Specifies whether the progress bar displays page numbers. Applies only when the [progress bar is visible](https://surveyjs.io/form-library/documentation/api-reference/survey-data-model#showProgressBar) and [`progressBarType`](https://surveyjs.io/form-library/documentation/api-reference/survey-data-model#progressBarType) is `"pages"`.
     *
     * Default value: `false`
     * @see progressBarShowPageTitles
     * @see progressBarInheritWidthFrom
     */
    progressBarShowPageNumbers: boolean;
    /**
     * Specifies whether the progress bar spans the width of the survey or that of the survey container. Applies only when the [progress bar is visible](https://surveyjs.io/form-library/documentation/api-reference/survey-data-model#showProgressBar) and [`progressBarType`](https://surveyjs.io/form-library/documentation/api-reference/survey-data-model#progressBarType) is `"pages"`.
     *
     * Possible values:
     *
     * - `"survey"`\
     * The progress bar width is the same as the survey width.
     * - `"container"` (default)\
     * The progress bar width is the same as the survey container width.
     * @see progressBarShowPageTitles
     * @see progressBarShowPageNumbers
     */
    progressBarInheritWidthFrom: "survey" | "container";
    get isShowProgressBarOnTop(): boolean;
    get isShowProgressBarOnBottom(): boolean;
    getProgressTypeComponent(): string;
    getProgressCssClasses(container?: string): string;
    private canShowProgressBar;
    get processedTitle(): string;
    /**
     * Gets or sets question title location relative to the input field: `"top"`, `"bottom"`, or `"left"`.
     *
     * > Certain question types (Matrix, Multiple Text) do not support the `"left"` value. For them, the `"top"` value is used.
     *
     * You can override this setting if you specify the `questionTitleLocation` property for an [individual page](https://surveyjs.io/form-library/documentation/pagemodel#questionTitleLocation) or [panel](https://surveyjs.io/form-library/documentation/panelmodel#questionTitleLocation) or set the `titleLocation` property for a [specific question](https://surveyjs.io/form-library/documentation/question#titleLocation).
     */
    get questionTitleLocation(): string;
    set questionTitleLocation(value: string);
    updateElementCss(reNew?: boolean): void;
    /**
     * Specifies the error message position.
     *
     * Possible values:
     *
     * - `"top"` (default) - Displays error messages above questions.
     * - `"bottom"` - Displays error messages below questions.
     *
     * You can override this setting if you specify the `questionErrorLocation` property for an [individual page](https://surveyjs.io/form-library/documentation/pagemodel#questionErrorLocation) or [panel](https://surveyjs.io/form-library/documentation/panelmodel#questionErrorLocation) or set the `errorLocation` property for a [specific question](https://surveyjs.io/form-library/documentation/question#errorLocation).
     */
    get questionErrorLocation(): string;
    set questionErrorLocation(value: string);
    /**
     * Specifies where to display question descriptions.
     *
     * Possible values:
     *
     * - `"underTitle"` (default) - Displays descriptions under question titles.
     * - `"underInput"` - Displays descriptions under the interactive area.
     *
     * You can override this setting for individual questions if you specify their [`descriptionLocation`](https://surveyjs.io/form-library/documentation/api-reference/question#descriptionLocation) property.
     *
     */
    get questionDescriptionLocation(): string;
    set questionDescriptionLocation(value: string);
    /**
     * @deprecated Use the [`readOnly`](https://surveyjs.io/form-library/documentation/api-reference/survey-data-model#readOnly) property.
     */
    get mode(): string;
    set mode(value: string);
    /**
     * Enables the read-only mode. If you set this property to `true`, users cannot take the survey.
     *
     * Default value: `false`
     *
     * [View Demo](https://surveyjs.io/form-library/examples/prevent-form-editing-with-read-only-mode/ (linkStyle))
     */
    get readOnly(): boolean;
    set readOnly(val: boolean);
    private onReadOnlyChanged;
    /**
     * Gets or sets an object with survey results. You can set this property with an object of the following structure:
     *
     * ```js
     * {
     *   question1Name: question1Value,
     *   question2Name: question2Value,
     *   // ...
     * }
     * ```
     *
     * When you set this property in code, the new object overrides the old object that may contain default question values and entered data. If you want to *merge* the new and old objects, call the [`mergeData(newDataObj)`](https://surveyjs.io/form-library/documentation/surveymodel#mergeData) method.
     *
     * If you assign a new object while a respondent takes the survey, set the [`currentPageNo`](https://surveyjs.io/form-library/documentation/api-reference/survey-data-model#currentPageNo) property to 0 to start the survey from the beginning. This will also cause the survey to re-evaluate the [`visibleIf`](https://surveyjs.io/form-library/documentation/api-reference/question#visibleIf), [`enableIf`](https://surveyjs.io/form-library/documentation/api-reference/question#enableIf), and other [expressions](https://surveyjs.io/form-library/documentation/design-survey/conditional-logic#expressions).
     * @see setValue
     * @see getValue
     */
    get data(): any;
    set data(data: any);
    /**
     * Merges a specified data object with the object from the [`data`](https://surveyjs.io/form-library/documentation/api-reference/survey-data-model#data) property.
     *
     * Refer to the following help topic for more information: [Populate Form Fields | Multiple Question Values](https://surveyjs.io/form-library/documentation/design-survey/pre-populate-form-fields#multiple-question-values).
     *
     * @param data A data object to merge. It should have the following structure: `{ questionName: questionValue, ... }`
     * @see setValue
     */
    mergeData(data: any): void;
    setDataCore(data: any, clearData?: boolean): void;
    get isSurvey(): boolean;
    /**
     * Returns an object with survey results.
     *
     * If you want to get a survey results object that mirrors the survey structure, call the `getData()` method with an object that has the `includePages` and `includePanels` properties enabled. Without this object, the `getData()` method returns the [`data`](https://surveyjs.io/form-library/documentation/api-reference/survey-data-model#data) property value.
     *
     * ```js
     * import { Model } from "survey-core";
     *
     * const surveyJson = { ... };
     * const survey = new Model(surveyJson);
     * survey.getData({ includePages: true, includePanels: true });
     * ```
     */
    getData(options?: {
        includePages?: boolean;
        includePanels?: boolean;
    }): any;
    getStructuredData(includePages?: boolean, level?: number): any;
    setStructuredData(data: any, doMerge?: boolean): void;
    private collectDataFromPanel;
    private onEditingObjPropertyChanged;
    get editingObj(): Base;
    set editingObj(val: Base);
    private unConnectEditingObj;
    get isEditingSurveyElement(): boolean;
    private setCalculatedValuesIntoResult;
    getAllValues(): any;
    /**
     * Returns survey results as an array of objects in which the question name, title, value, and other parameters are stored as individual properties.
     *
     * If a question can have more than one value (Matrix, Multiple Text), its object enables the `isNode` flag and stores information about these values in the `data` property. Refer to the following help topic for more information: [Access Full Survey Results](https://surveyjs.io/form-library/documentation/handle-survey-results-access#access-full-survey-results).
     *
     * If you want to skip empty answers, pass an object with the `includeEmpty` property set to `false`.
     */
    getPlainData(options?: IPlainDataOptions): Array<IQuestionPlainData>;
    getFilteredValues(): any;
    private addCalculatedValuesIntoFilteredValues;
    getFilteredProperties(): any;
    private getValuesKeys;
    getDataValueCore(valuesHash: any, key: string): any;
    setDataValueCore(valuesHash: any, key: string, value: any): void;
    deleteDataValueCore(valuesHash: any, key: string): void;
    valueHashGetDataCallback: (valuesHash: any, key: string) => any;
    valueHashSetDataCallback: (valuesHash: any, key: string, value: any) => void;
    valueHashDeleteDataCallback: (valuesHash: any, key: string) => void;
    private getDataFromValueHash;
    private setDataToValueHash;
    private deleteDataFromValueHash;
    /**
     * An object with all comment values.
     * @see Question.showCommentArea
     * @see storeOthersAsComment
     */
    get comments(): any;
    /**
     * Returns an array of visible pages without the start page.
     *
     * To get an array of all pages, use the [`pages`](https://surveyjs.io/form-library/documentation/api-reference/survey-data-model#pages) property. If all pages are visible, the `pages` and `visiblePages` arrays are identical.
     * @see [Conditional Visibility](https://surveyjs.io/form-library/documentation/design-survey/conditional-logic#conditional-visibility)
     */
    get visiblePages(): Array<PageModel>;
    private isPageInVisibleList;
    /**
     * Returns `true` if the survey contains zero pages.
     * @see emptySurveyText
     */
    get isEmpty(): boolean;
    get PageCount(): number;
    /**
     * Returns a total number of survey pages.
     *
     * To get the number of visible pages, use the [`visiblePageCount`](https://surveyjs.io/form-library/documentation/api-reference/survey-data-model#visiblePageCount) property.
     * @see pages
     */
    get pageCount(): number;
    /**
     * Returns the number of visible survey pages.
     *
     * To get a total number of survey pages, use the [`pageCount`](https://surveyjs.io/form-library/documentation/api-reference/survey-data-model#pageCount) property.
     * @see visiblePages
     * @see [Conditional Visibility](https://surveyjs.io/form-library/documentation/design-survey/conditional-logic#conditional-visibility)
     */
    get visiblePageCount(): number;
    /**
     * Returns the start page. Applies only if the [`firstPageIsStartPage`](https://surveyjs.io/form-library/documentation/api-reference/survey-data-model#firstPageIsStartPage) property is set to `true`.
     *
     * Refer to the following help topic for more information: [Start Page](https://surveyjs.io/form-library/documentation/design-survey/create-a-multi-page-survey#start-page).
     * @see firstPageIsStartPage
     * @see activePage
     */
    get startPage(): PageModel;
    /**
     * @deprecated Use the [`startPage`](https://surveyjs.io/form-library/documentation/api-reference/survey-data-model#startPage) property instead.
     */
    get startedPage(): PageModel;
    /**
     * Gets or sets the current page.
     *
     * If you want to change the current page, set this property to a `PageModel` object. You can get this object in different ways. For example, you can call the [`getPageByName()`](https://surveyjs.io/form-library/documentation/api-reference/survey-data-model#getPageByName) method to obtain a `PageModel` object with a specific name:
     *
     * ```js
     * survey.currentPage = survey.getPageByName("my-page-name");
     * ```
     *
     * Alternatively, you can change the current page if you set the [`currentPageNo`](https://surveyjs.io/form-library/documentation/api-reference/survey-data-model#currentPageNo) property to the index of the required page.
     *
     * The `currentPage` property does not return the start page even if it is current. Use the [`activePage`](https://surveyjs.io/form-library/documentation/api-reference/survey-data-model#activePage) property instead if your survey contains a start page.
     */
    get currentPage(): any;
    set currentPage(value: any);
    tryNavigateToPage(page: PageModel): boolean;
    private performValidationOnPageChanging;
    private updateCurrentPage;
    private get isCurrentPageAvailable();
    private isPageExistsInSurvey;
    /**
     * Returns [`startPage`](https://surveyjs.io/form-library/documentation/api-reference/survey-data-model#startPage) if the survey currently displays a start page; otherwise, returns [`currentPage`](https://surveyjs.io/form-library/documentation/api-reference/survey-data-model#currentPage).
     * @see startPage
     * @see currentPage
     * @see firstPageIsStartPage
     */
    get activePage(): any;
    /**
     * A Boolean value that indicates whether the [start page](https://surveyjs.io/form-library/documentation/design-survey/create-a-multi-page-survey#start-page) is currently displayed.
     */
    get isStartPageActive(): boolean;
    /**
     * @deprecated Use the [`isStartPageActive`](https://surveyjs.io/form-library/documentation/api-reference/survey-data-model#isStartPageActive) property instead.
     */
    get isShowStartingPage(): boolean;
    /**
     * Specifies which part of a matrix row responds to a drag gesture in [Dynamic Matrix](https://surveyjs.io/form-library/examples/questiontype-matrixdynamic/) questions.
     *
     * Possible values:
     *
     * - `"entireItem"` (default) - Users can use the entire matrix row as a drag handle.
     * - `"icon"` - Users can only use a drag icon as a drag handle.
     */
    get matrixDragHandleArea(): string;
    set matrixDragHandleArea(val: string);
    get isShowingPage(): boolean;
    private updateActivePage;
    private onStateAndCurrentPageChanged;
    private getPageByObject;
    /**
     * A zero-based index of the current page in the [`visiblePages`](https://surveyjs.io/form-library/documentation/api-reference/survey-data-model#visiblePages) array.
     *
     * [View Demo](https://surveyjs.io/form-library/examples/survey-editprevious/ (linkStyle))
     * @see visiblePages
     */
    get currentPageNo(): number;
    set currentPageNo(value: number);
    /**
     * Specifies the sort order of questions in the survey.
     *
     * Possible values:
     *
     * - `"initial"` (default) - Preserves the original order of questions.
     * - `"random"` - Displays questions in random order.
     *
     * You can override this property for individual pages and panels.
     * @see PageModel.questionOrder
     * @see PanelModel.questionOrder
     */
    get questionOrder(): string;
    set questionOrder(val: string);
    /**
     * @deprecated Use the [`questionOrder`](#questionOrder) property instead.
     */
    get questionsOrder(): string;
    set questionsOrder(val: string);
    /**
     * Focuses the first question on the current page.
     * @see focusQuestion
     * @see autoFocusFirstQuestion
     */
    focusFirstQuestion(): void;
    scrollToTopOnPageChange(doScroll?: boolean): void;
    /**
     * Returns the current survey state.
     *
     * Possible values:
     *
     * - `"loading"` - The survey is being loaded from a JSON schema.
     * - `"empty"` - The survey has no elements to display.
     * - `"starting"` - The survey displays a [start page](https://surveyjs.io/form-library/documentation/design-survey/create-a-multi-page-survey#start-page).
     * - `"running"` - A respondent is taking the survey.
     * - `"preview"` - A respondent is [previewing](https://surveyjs.io/form-library/examples/survey-showpreview/) answers before submitting them.
     * - `"completed"` - A respondent has completed the survey and submitted the results.
     */
    get state(): string;
    private updateState;
    private calcState;
    private get isCompleted();
    private set isCompleted(value);
    private get isShowingPreview();
    private set isShowingPreview(value);
    private get isStartedState();
    private set isStartedState(value);
    private get isCompletedBefore();
    private set isCompletedBefore(value);
    private get isLoading();
    private set isLoading(value);
    get completedState(): string;
    get completedStateText(): string;
    protected setCompletedState(value: string, text: string): void;
    /**
     * Displays a toast notification with a specified message.
     *
     * Depending on the `type` argument, a survey can display the following notification types:
     *
     * ![Toast notification types in SurveyJS Form Library](https://surveyjs.io//Content/Images/docs/notification-types.png)
     * @param message A message to display.
     * @param type A notification type: `"info"` (default), `"success"`, or `"error"`.
     * @param showActions For internal use.
     */
    notify(message: string, type: string, showActions?: boolean): void;
    /**
     * Resets the survey [`state`](https://surveyjs.io/form-library/documentation/api-reference/survey-data-model#state) and, optionally, [`data`](https://surveyjs.io/form-library/documentation/api-reference/survey-data-model#data). If `state` is `"completed"`, it becomes `"running"`.
     * @param clearData *(Optional)* Specifies whether to clear survey data. Default value: `true`.
     * @param goToFirstPage *(Optional)* Specifies whether to switch the survey to the first page. Default value: `true`.
     */
    clear(clearData?: boolean, goToFirstPage?: boolean): void;
    mergeValues(src: any, dest: any): void;
    private updateValuesWithDefaults;
    protected updateCustomWidgets(page: PageModel): void;
    protected currentPageChanging(newValue: PageModel, oldValue: PageModel): boolean;
    protected currentPageChanged(newValue: PageModel, oldValue: PageModel): void;
    private notifyQuestionsOnHidingContent;
    private createPageChangeEventOptions;
    getProgress(): number;
    /**
     * Returns a percentage value that indicates user progress in the survey.
     * @see showProgressBar
     * @see progressBarType
     * @see progressText
     */
    get progressValue(): number;
    get isNavigationButtonsShowing(): string;
    get isNavigationButtonsShowingOnTop(): boolean;
    get isNavigationButtonsShowingOnBottom(): boolean;
    private getIsNavigationButtonsShowingOn;
    get isEditMode(): boolean;
    get isDisplayMode(): boolean;
    get isUpdateValueTextOnTyping(): boolean;
    /**
     * Indicates whether the survey is being designed in [Survey Creator](https://surveyjs.io/survey-creator/documentation/overview).
     */
    get isDesignMode(): boolean;
    private _isDesignMode;
    setDesignMode(value: boolean): void;
    /**
     * Specifies whether to show all survey elements, regardless of their visibility.
     *
     * Default value: `false`
     */
    get showInvisibleElements(): boolean;
    set showInvisibleElements(val: boolean);
    private updateAllElementsVisibility;
    get areInvisibleElementsShowing(): boolean;
    get areEmptyElementsHidden(): boolean;
    private get isAnyQuestionAnswered();
    /**
     * Indicates whether the browser has a cookie with a specified [`cookieName`](https://surveyjs.io/form-library/documentation/api-reference/survey-data-model#cookieName). If this property's value is `true`, the respondent has passed the survey previously.
     * @see setCookie
     * @see deleteCookie
     */
    get hasCookie(): boolean;
    /**
     * Sets a cookie with a specified [`cookieName`](https://surveyjs.io/form-library/documentation/api-reference/survey-data-model#cookieName) in the browser. If the `cookieName` property value is defined, this method is automatically called on survey completion.
     * @see hasCookie
     * @see deleteCookie
     */
    setCookie(): void;
    /**
     * Deletes a cookie with a specified [`cookieName`](https://surveyjs.io/form-library/documentation/api-reference/survey-data-model#cookieName) from the browser.
     * @see hasCookie
     * @see setCookie
     */
    deleteCookie(): void;
    /**
     * @deprecated Use the [`validationEnabled`](https://surveyjs.io/form-library/documentation/api-reference/survey-data-model#validationEnabled) property instead.
     */
    get ignoreValidation(): boolean;
    set ignoreValidation(val: boolean);
    /**
     * Specifies whether data validation is enabled.
     *
     * Default value: `true`
     * @see checkErrorsMode
     * @see hideRequiredErrors
     */
    validationEnabled: boolean;
    /**
     * Specifies whether respondents can switch the current page even if it contains validation errors.
     *
     * Default value: `false`
     * @see checkErrorsMode
     */
    validationAllowSwitchPages: boolean;
    /**
     * Specifies whether respondents can end a survey with validation errors.
     *
     * Default value: `false`
     * @see checkErrorsMode
     */
    validationAllowComplete: boolean;
    /**
     * Switches the survey to the next page.
     *
     * This method returns a Boolean value that indicates whether the page was successfully switched. `false` is returned if the current page is the last page or if it contains validation errors.
     * @returns `true` if the page was successfully switched; `false` otherwise.
     * @see isLastPage
     * @see prevPage
     * @see completeLastPage
     */
    nextPage(): boolean;
    performNext(): boolean;
    performPrevious(): boolean;
    private hasErrorsOnNavigate;
    private canGoTroughValidation;
    private asyncValidationQuesitons;
    private checkForAsyncQuestionValidation;
    private clearAsyncValidationQuesitons;
    private onCompletedAsyncQuestionValidators;
    get isCurrentPageHasErrors(): boolean;
    /**
     * Returns `true` if the current page does not contain errors.
     * @see currentPage
     */
    get isCurrentPageValid(): boolean;
    hasCurrentPageErrors(onAsyncValidation?: (hasErrors: boolean) => void): boolean;
    /**
     * Validates all questions on the current page and returns `false` if the validation fails.
     *
     * If you use validation expressions and at least one of them calls an async function, the `validateCurrentPage` method returns `undefined`. In this case, you should pass a callback function as the `onAsyncValidation` parameter. The function's `hasErrors` Boolean parameter will contain the validation result.
     * @param onAsyncValidation *(Optional)* Pass a callback function. It accepts a Boolean `hasErrors` parameter that equals `true` if the validation fails or `false` otherwise.
     * @see currentPage
     * @see validate
     * @see validateCurrentPage
     */
    validateCurrentPage(onAsyncValidation?: (hasErrors: boolean) => void): boolean;
    hasPageErrors(page?: PageModel, onAsyncValidation?: (hasErrors: boolean) => void): boolean;
    /**
     * Validates all questions on a specified page and returns `false` if the validation fails.
     *
     * If you use validation expressions and at least one of them calls an async function, the `validatePage` method returns `undefined`. In this case, you should pass a callback function as the `onAsyncValidation` parameter. The function's `hasErrors` Boolean parameter will contain the validation result.
     * @param page Pass the `PageModel` that you want to validate. You can pass `undefined` to validate the [`activePage`](https://surveyjs.io/form-library/documentation/api-reference/survey-data-model#activePage).
     * @param onAsyncValidation *(Optional)* Pass a callback function. It accepts a Boolean `hasErrors` parameter that equals `true` if the validation fails or `false` otherwise.
     * @see validate
     * @see validateCurrentPage
     */
    validatePage(page?: PageModel, onAsyncValidation?: (hasErrors: boolean) => void): boolean;
    hasErrors(fireCallback?: boolean, focusOnFirstError?: boolean, onAsyncValidation?: (hasErrors: boolean) => void): boolean;
    /**
     * Validates all questions and returns `false` if the validation fails.
     *
     * If you use validation expressions and at least one of them calls an async function, the `validate` method returns `undefined`. In this case, you should pass a callback function as the `onAsyncValidation` parameter. The function's `hasErrors` Boolean parameter will contain the validation result.
     * @param fireCallback *(Optional)* Pass `false` if you do not want to show validation errors in the UI.
     * @param focusFirstError *(Optional)* Pass `true` if you want to focus the first question with a validation error. The survey will be switched to the page that contains this question if required.
     * @param onAsyncValidation *(Optional)* Pass a callback function. It accepts a Boolean `hasErrors` parameter that equals `true` if the validation fails or `false` otherwise.
     * @see validateCurrentPage
     * @see validatePage
     */
    validate(fireCallback?: boolean, focusFirstError?: boolean, onAsyncValidation?: (hasErrors: boolean) => void, changeCurrentPage?: boolean): boolean;
    ensureUniqueNames(element?: ISurveyElement): void;
    private ensureUniqueName;
    private ensureUniquePageName;
    private ensureUniquePanelName;
    private ensureUniqueQuestionName;
    private ensureUniqueElementName;
    private getNewName;
    private checkIsCurrentPageHasErrors;
    private checkIsPageHasErrors;
    private fireValidatedErrorsOnPage;
    /**
     * Switches the survey to the previous page.
     *
     * This method returns a Boolean value that indicates whether the page was successfully switched. `false` is returned if the current page is the first page.
     * @returns `true` if the page was successfully switched; `false` otherwise.
     * @see isFirstPage
     * @see nextPage
     */
    prevPage(): boolean;
    /**
     * Completes the survey if it currently displays the last page and the page contains no validation errors. If both these conditions are met, this method returns `true`; otherwise, `false`.
     *
     * If you want to complete the survey regardless of the current page and validation errors, use the [`doComplete()`](https://surveyjs.io/form-library/documentation/api-reference/survey-data-model#completeLastPage) event.
     * @see isCurrentPageValid
     * @see nextPage
     */
    tryComplete(): boolean;
    /**
     * @deprecated Use the [`tryComplete`](https://surveyjs.io/form-library/documentation/api-reference/survey-data-model#tryComplete) method instead.
     */
    completeLastPage(): boolean;
    private isNavigationButtonPressed;
    navigationMouseDown(): boolean;
    private resetNavigationButton;
    private mouseDownPage;
    nextPageUIClick(): boolean;
    nextPageMouseDown(): boolean;
    /**
     * Displays a [preview of given answers](https://surveyjs.io/form-library/documentation/design-survey/create-a-multi-page-survey#preview-page). Returns `false` if the preview cannot be displayed because of validation errors.
     * @see cancelPreview
     * @see showPreviewBeforeComplete
     * @see onShowingPreview
     * @see state
     */
    showPreview(): boolean;
    private showPreviewCore;
    /**
     * Cancels a [preview of given answers](https://surveyjs.io/form-library/documentation/design-survey/create-a-multi-page-survey#preview-page) and switches the survey to the page specified by the `currentPage` parameter.
     * @param currentPage A new current page. If you do not specify this parameter, the survey displays the last page.
     * @see showPreview
     * @see showPreviewBeforeComplete
     * @see state
     */
    cancelPreview(currentPage?: any): void;
    private gotoPageFromPreview;
    cancelPreviewByPage(panel: IPanel): any;
    protected doCurrentPageComplete(doComplete: boolean): boolean;
    private doCurrentPageCompleteCore;
    get isSinglePage(): boolean;
    set isSinglePage(val: boolean);
    get isSingleVisibleQuestion(): boolean;
    private isSingleVisibleQuestionVal;
    /**
     * Specifies how to distribute survey elements between pages.
     *
     * Possible values:
     *
     * - `"singlePage"` - Combines all survey pages into a single page.
     * - `"questionPerPage"` - Creates a separate page for every question.
     * - `"standard"` (default) - Retains the original structure specified in the JSON schema.
     */
    get questionsOnPageMode(): string;
    set questionsOnPageMode(val: string);
    /**
     * Gets or sets a Boolean value that specifies whether the first page is a start page.
     *
     * Refer to the following help topic for more information: [Start Page](https://surveyjs.io/form-library/documentation/design-survey/create-a-multi-page-survey#start-page).
     * @see startPage
     * @see activePage
     */
    get firstPageIsStartPage(): boolean;
    set firstPageIsStartPage(val: boolean);
    /**
     * @deprecated Use the [`firstPageIsStartPage`](https://surveyjs.io/form-library/documentation/api-reference/survey-data-model#firstPageIsStartPage) property instead.
     */
    get firstPageIsStarted(): boolean;
    set firstPageIsStarted(val: boolean);
    isPageStarted(page: IPage): boolean;
    /**
     * Specifies whether to show a preview of given answers before they are submitted.
     *
     * Default value: `false`
     *
     * [View Demo](https://surveyjs.io/form-library/examples/survey-preview/ (linkStyle))
     * @see previewMode
     * @see showPreview
     * @see cancelPreview
     */
    get showPreviewBeforeComplete(): boolean | any;
    set showPreviewBeforeComplete(val: boolean | any);
    setShowPreviewBeforeComplete(val: boolean | any): void;
    /**
     * Specifies whether the [preview of given answers](https://surveyjs.io/form-library/documentation/design-survey/create-a-multi-page-survey#preview-page) includes all or only answered questions.
     *
     * Possible values:
     *
     * - `"allQuestions"` (default)
     * - `"answeredQuestions"`
     *
     * [View Demo](https://surveyjs.io/form-library/examples/survey-preview/ (linkStyle))
     */
    get previewMode(): string;
    set previewMode(val: string);
    protected onFirstPageIsStartedChanged(): void;
    private runningPages;
    private pageContainerValue;
    private onShowingPreviewChanged;
    private createRootPage;
    private disposeContainerPage;
    private updatePagesContainer;
    private currentSingleQuestionValue;
    get currentSingleQuestion(): Question;
    set currentSingleQuestion(val: Question);
    private changeCurrentPageFromPreview;
    protected onQuestionsOnPageModeChanged(oldValue: string): void;
    private getPageStartIndex;
    /**
     * Indicates whether the [current page](#currentPage) is the first page.
     *
     * > If the survey displays the [start page](https://surveyjs.io/form-library/documentation/design-survey/create-a-multi-page-survey#start-page), this property contains `false`. Use the [`isStartPageActive`](#isStartPageActive) property to find out whether the start page is currently displayed.
     */
    get isFirstPage(): boolean;
    /**
     * Indicates whether the [current page](#currentPage) is the last page.
     */
    get isLastPage(): boolean;
    private updateButtonsVisibility;
    get isShowPrevButton(): boolean;
    get isShowNextButton(): boolean;
    get isCompleteButtonVisible(): boolean;
    get isPreviewButtonVisible(): boolean;
    get isCancelPreviewButtonVisible(): boolean;
    get isFirstElement(): boolean | undefined;
    get isLastElement(): boolean | undefined;
    private updateIsFirstLastPageState;
    private get isLastPageOrElement();
    private get isFirstPageOrElement();
    private calcIsShowPrevButton;
    private calcIsShowNextButton;
    calcIsCompleteButtonVisible(): boolean;
    private calcIsPreviewButtonVisible;
    private calcIsCancelPreviewButtonVisible;
    private get firstVisiblePage();
    private get lastVisiblePage();
    /**
     * Completes the survey.
     *
     * When you call this method, Form Library performs the following actions:
     *
     * 1. Saves a cookie if the [`cookieName`](https://surveyjs.io/form-library/documentation/api-reference/survey-data-model#cookieName) property is set.
     * 1. Switches the survey [`state`](https://surveyjs.io/form-library/documentation/api-reference/survey-data-model#state) to `"completed"`.
     * 1. Raises the [`onComplete`](https://surveyjs.io/form-library/documentation/api-reference/survey-data-model#onComplete) event.
     * 1. Navigates the user to a URL specified by the [`navigateToUrl`](https://surveyjs.io/form-library/documentation/api-reference/survey-data-model#navigateToUrl) or [`navigateToUrlOnCondition`](https://surveyjs.io/form-library/documentation/api-reference/survey-data-model#navigateToUrlOnCondition) property.
     * 1. Calls the [`sendResult()`](https://surveyjs.io/form-library/documentation/api-reference/survey-data-model#sendResult) method if Form Library works with [SurveyJS Service](https://api.surveyjs.io/).
     *
     * The `doComplete()` method completes the survey regardless of validation errors and the current page. If you need to ensure that survey results are valid and full, call the [`completeLastPage()`](https://surveyjs.io/form-library/documentation/api-reference/survey-data-model#completeLastPage) method instead.
     *
     * @param isCompleteOnTrigger For internal use.
     * @param completeTrigger For internal use.
     * @returns `false` if survey completion is cancelled within the [`onCompleting`](https://surveyjs.io/form-library/documentation/api-reference/survey-data-model#onCompleting) event handler; otherwise, `true`.
     * @see surveyPostId
     */
    doComplete(isCompleteOnTrigger?: boolean, completeTrigger?: Trigger): boolean;
    private saveDataOnComplete;
    private checkOnCompletingEvent;
    /**
     * Starts the survey. Applies only if the survey has a [start page](https://surveyjs.io/form-library/documentation/design-survey/create-a-multi-page-survey#start-page).
     * @see firstPageIsStartPage
     * @see completeLastPage
     */
    start(): boolean;
    /**
     * Indicates whether the current page is being [validated on a server](#onServerValidateQuestions).
     */
    get isValidatingOnServer(): boolean;
    private serverValidationEventCount;
    private setIsValidatingOnServer;
    private createServerValidationOptions;
    protected onIsValidatingOnServerChanged(): void;
    protected doServerValidation(doComplete: boolean, isPreview?: boolean, page?: PageModel): boolean;
    private completeServerValidation;
    protected doNextPage(): void;
    setCompleted(trigger: Trigger): void;
    canBeCompleted(trigger: Trigger, isCompleted: boolean): void;
    private completedByTriggers;
    private get canBeCompletedByTrigger();
    private get completedTrigger();
    /**
     * Returns HTML content displayed on the [complete page](https://surveyjs.io/form-library/documentation/design-survey/create-a-multi-page-survey#complete-page).
     *
     * To specify HTML content, use the [`completedHtml`](#completedHtml) property.
     */
    get processedCompletedHtml(): string;
    /**
     * Returns HTML content displayed to a user who has completed the survey before. To identify such users, the survey uses a [cookie name](#cookieName) or [client ID](#clientId).
     *
     * To specify HTML content, use the [`completedBeforeHtml`](#completedBeforeHtml) property.
     */
    get processedCompletedBeforeHtml(): string;
    /**
     * Returns HTML content displayed while a survey JSON schema is being loaded from [SurveyJS Service](https://api.surveyjs.io).
     *
     * To specify HTML content, use the [`loadingHtml`](#loadingHtml) property.
     */
    get processedLoadingHtml(): string;
    getProgressInfo(): IProgressInfo;
    /**
     * Returns text displayed by the progress bar (for instance, "Page 2 of 3" or "Answered 3/8 questions"). Handle the [`onGetProgressText`](https://surveyjs.io/form-library/documentation/api-reference/survey-data-model#onGetProgressText) event to change this text.
     * @see progressValue
     * @see showProgressBar
     * @see progressBarType
     */
    get progressText(): string;
    private isCalculatingProgressText;
    updateProgressText(onValueChanged?: boolean): void;
    getProgressText(): string;
    private getProgressTextCore;
    rootCss: string;
    getRootCss(): string;
    private isSmoothScrollEnabled;
    private resizeObserver;
    afterRenderSurvey(htmlElement: any): void;
    beforeDestroySurveyElement(): void;
    /**
     * An event that is raised when the survey's width or height is changed.
     */
    onResize: EventBase<SurveyModel, ResizeEvent>;
    private processResponsiveness;
    triggerResponsiveness(hard: boolean): void;
    destroyResizeObserver(): void;
    updateQuestionCssClasses(question: Question, cssClasses: any): void;
    updatePanelCssClasses(panel: PanelModel, cssClasses: any): void;
    updatePageCssClasses(page: PageModel, cssClasses: any): void;
    updateChoiceItemCss(question: IQuestion, options: any): void;
    private isCurrentPageRendering;
    private isCurrentPageRendered;
    afterRenderPage(htmlElement: HTMLElement): void;
    afterRenderHeader(htmlElement: HTMLElement): void;
    afterRenderQuestion(question: Question, htmlElement: HTMLElement): void;
    afterRenderQuestionInput(question: Question, htmlElement: HTMLElement): void;
    afterRenderPanel(panel: IElement, htmlElement: HTMLElement): void;
    whenQuestionFocusIn(question: Question): void;
    whenPanelFocusIn(panel: PanelModel): void;
    private rebuildQuestionChoices;
    canChangeChoiceItemsVisibility(): boolean;
    getChoiceItemVisibility(question: Question, item: any, val: boolean): boolean;
    loadQuestionChoices(options: {
        question: Question;
        filter: string;
        skip: number;
        take: number;
        setItems: (items: Array<any>, totalCount: number) => void;
    }): void;
    getChoiceDisplayValue(options: {
        question: Question;
        values: Array<any>;
        setItems: (displayValues: Array<string>, ...customValues: Array<IValueItemCustomPropValues>) => void;
    }): void;
    matrixBeforeRowAdded(options: any): void;
    matrixRowAdded(question: QuestionMatrixDynamicModel, row: any): void;
    matrixColumnAdded(question: Question, column: any): void;
    multipleTextItemAdded(question: QuestionMultipleTextModel, item: any): void;
    getQuestionByValueNameFromArray(valueName: string, name: string, index: number): IQuestion;
    matrixRowRemoved(question: QuestionMatrixDynamicModel, rowIndex: number, row: any): void;
    matrixRowRemoving(question: QuestionMatrixDynamicModel, rowIndex: number, row: any): boolean;
    matrixAllowRemoveRow(question: QuestionMatrixDynamicModel, rowIndex: number, row: any): boolean;
    matrixDetailPanelVisibleChanged(question: QuestionMatrixDropdownModelBase, rowIndex: number, row: any, visible: boolean): void;
    matrixCellCreating(question: QuestionMatrixDropdownModelBase, options: any): void;
    matrixCellCreated(question: QuestionMatrixDropdownModelBase, options: any): void;
    matrixAfterCellRender(question: QuestionMatrixDropdownModelBase, options: any): void;
    matrixCellValueChanged(question: QuestionMatrixDropdownModelBase, options: any): void;
    matrixCellValueChanging(question: QuestionMatrixDropdownModelBase, options: MatrixCellValueChangingEvent): void;
    get isValidateOnValueChanging(): boolean;
    get isValidateOnValueChanged(): boolean;
    private get isValidateOnValueChange();
    private get isValidateOnComplete();
    matrixCellValidate(question: QuestionMatrixDropdownModelBase, options: MatrixCellValidateEvent): SurveyError;
    dynamicPanelAdded(question: QuestionPanelDynamicModel, panelIndex?: number, panel?: PanelModel): void;
    dynamicPanelRemoved(question: QuestionPanelDynamicModel, panelIndex: number, panel: PanelModel): void;
    private hasQuestionVisibleIndeces;
    dynamicPanelRemoving(question: QuestionPanelDynamicModel, panelIndex: number, panel: PanelModel): boolean;
    dynamicPanelItemValueChanged(question: IQuestion, options: any): void;
    dynamicPanelItemValueChanging(question: IQuestion, options: any): void;
    dynamicPanelGetTabTitle(question: IQuestion, options: any): void;
    dynamicPanelCurrentIndexChanged(question: IQuestion, options: any): void;
    dragAndDropAllow(options: DragDropAllowEvent): boolean;
    elementContentVisibilityChanged(element: ISurveyElement): void;
    getUpdatedPanelFooterActions(panel: PanelModel, actions: Array<IAction>, question?: QuestionPanelDynamicModel): Array<IAction>;
    getUpdatedElementTitleActions(element: ISurveyElement, titleActions: Array<IAction>): Array<IAction>;
    private getTitleActionsResult;
    private getUpdatedQuestionTitleActions;
    private getUpdatedPanelTitleActions;
    private getUpdatedPageTitleActions;
    getUpdatedMatrixRowActions(question: QuestionMatrixDropdownModelBase, row: any, actions: Array<IAction>): IAction[];
    skeletonHeight: number;
    scrollElementToTop(element: ISurveyElement, question: Question, page: PageModel, id: string, scrollIfVisible?: boolean, scrollIntoViewOptions?: ScrollIntoViewOptions, passedRootElement?: HTMLElement, onScolledCallback?: () => void): any;
    /**
     * Opens a dialog window for users to select files.
     * @param input A [file input HTML element](https://developer.mozilla.org/en-US/docs/Web/API/HTMLInputElement).
     * @param callback A callback function that you can use to process selected files. Accepts an array of JavaScript <a href="https://developer.mozilla.org/en-US/docs/Web/API/File" target="_blank">File</a> objects.
     * @see onOpenFileChooser
     * @see onUploadFile
     */
    chooseFiles(input: HTMLInputElement, callback: (files: File[]) => void, context?: {
        element: Base;
        item?: any;
        elementType?: string;
        propertyName?: string;
    }): void;
    /**
     * Uploads files to a server.
     *
     * The following code shows how to call this method:
     *
     * ```js
     * const question = survey.getQuestionByName("myFileQuestion");
     * survey.uploadFiles(
     *   question,
     *   question.name,
     *   question.value,
     *   (data, errors) => {
     *     // ...
     *   }
     * );
     * ```
     * @param question A [File Upload question instance](https://surveyjs.io/form-library/documentation/api-reference/file-model) or [Signature Pad question instance](https://surveyjs.io/form-library/documentation/api-reference/signature-pad-model).
     * @param name The File Upload question's [`name`](https://surveyjs.io/form-library/documentation/api-reference/file-model#name) or Signature Pad question's [`name`](https://surveyjs.io/form-library/documentation/api-reference/signature-pad-model#name).
     * @param files An array of JavaScript <a href="https://developer.mozilla.org/en-US/docs/Web/API/File" target="_blank">File</a> objects that represent files to upload.
     * @param callback A callback function that allows you to access successfully uploaded files as the first argument. If any files fail to upload, the second argument contains an array of error messages.
     * @see onUploadFiles
     * @see downloadFile
     */
    uploadFiles(question: QuestionFileModel | QuestionSignaturePadModel, name: string, files: File[], callback: (data: any | Array<any>, errors?: any | Array<any>) => any): void;
    downloadFile(question: QuestionFileModel, questionName: string, fileValue: any, callback: (status: string, data: any) => any): void;
    clearFiles(question: QuestionFileModel | QuestionSignaturePadModel, name: string, value: any, fileName: string, callback: (status: string, data: any) => any): void;
    updateChoicesFromServer(question: QuestionSelectBase, choices: Array<ItemValue>, serverResult: any): Array<ItemValue>;
    loadedChoicesFromServer(question: IQuestion): void;
    protected createSurveyService(): dxSurveyService;
    protected uploadFilesCore(name: string, files: File[], uploadingCallback: (data: any | Array<any>, errors?: any | Array<any>) => any): void;
    getPage(index: number): PageModel;
    /**
     * Adds an existing page to the survey.
     * @param page A page to add.
     * @param index An index at which to insert the page. If you do not specify this parameter, the page will be added to the end.
     * @see addNewPage
     * @see createNewPage
     */
    addPage(page: PageModel, index?: number): void;
    /**
     * Creates a new page and adds it to the survey.
     *
     * If you want to switch a survey to the newly added page, assign its index to the [`currentPageNo`](https://surveyjs.io/form-library/documentation/api-reference/survey-data-model#currentPageNo) property or assign the entire page to the [`currentPage`](https://surveyjs.io/form-library/documentation/api-reference/survey-data-model#currentPage) property.
     *
     * @param name A page name. If you do not specify this parameter, it will be generated automatically.
     * @param index An index at which to insert the page. If you do not specify this parameter, the page will be added to the end.
     * @returns The created and added page.
     * @see addPage
     * @see createNewPage
     */
    addNewPage(name?: string, index?: number): PageModel;
    /**
     * Removes a page from the survey.
     *
     * Pass a `PageModel` object to this method. You can get this object in different ways. For example, you can call the [`getPageByName()`](#getPageByName) method to obtain a `PageModel` object with a specific name or use the [`currentPage`](#currentPage) property to access and delete the current page, as shown in the code below.
     *
     * ```js
     * // Delete the current page
     * survey.removePage(survey.currentPage);
     * ```
     * @param page A page to remove.
     * @see addNewPage
     */
    removePage(page: PageModel): void;
    /**
     * Returns a question with a specified [`name`](https://surveyjs.io/form-library/documentation/api-reference/question#name).
     * @param name A question name
     * @param caseInsensitive *(Optional)* A Boolean value that specifies case sensitivity when searching for the question. Default value: `false` (uppercase and lowercase letters are treated as distinct).
     * @returns A question with a specified name.
     * @see getAllQuestions
     * @see getQuestionByValueName
     */
    getQuestionByName(name: string, caseInsensitive?: boolean): Question;
    findQuestionByName(name: string): IQuestion;
    getEditingSurveyElement(): Base;
    /**
     * Returns a question with a specified [`valueName`](https://surveyjs.io/form-library/documentation/api-reference/question#valueName).
     *
     * > Since `valueName` does not have to be unique, multiple questions can have the same `valueName` value. In this case, the `getQuestionByValueName()` method returns the first such question. If you need to get all questions with the same `valueName`, call the `getQuestionsByValueName()` method.
     * @param valueName A question's `valueName` property value.
     * @param caseInsensitive *(Optional)* A Boolean value that specifies case sensitivity when searching for the question. Default value: `false` (uppercase and lowercase letters are treated as distinct).
     * @returns A question with a specified `valueName`.
     * @see getAllQuestions
     * @see getQuestionByName
     */
    getQuestionByValueName(valueName: string, caseInsensitive?: boolean): Question;
    /**
     * Returns all questions with a specified [`valueName`](https://surveyjs.io/form-library/documentation/api-reference/question#valueName). If a question's `valueName` is undefined, its [`name`](https://surveyjs.io/form-library/documentation/api-reference/question#name) property is used.
     * @param valueName A question's `valueName` property value.
     * @param caseInsensitive *(Optional)* A Boolean value that specifies case sensitivity when searching for the questions. Default value: `false` (uppercase and lowercase letters are treated as distinct).
     * @returns An array of questions with a specified `valueName`.
     * @see getAllQuestions
     * @see getQuestionByName
     */
    getQuestionsByValueName(valueName: string, caseInsensitive?: boolean): Array<Question>;
    getCalculatedValueByName(name: string): CalculatedValue;
    getQuestionsByNames(names: string[], caseInsensitive?: boolean): IQuestion[];
    /**
     * Returns a page to which a specified survey element (question or panel) belongs.
     * @param element A question or panel instance.
     */
    getPageByElement(element: IElement): PageModel;
    /**
     * Returns a page to which a specified question belongs.
     * @param question A question instance.
     */
    getPageByQuestion(question: IQuestion): PageModel;
    /**
     * Returns a page with a specified name.
     * @param name A page [name](https://surveyjs.io/form-library/documentation/api-reference/page-model#name).
     */
    getPageByName(name: string): PageModel;
    getPagesByNames(names: string[]): PageModel[];
    /**
     * Returns a list of all [questions](https://surveyjs.io/form-library/documentation/api-reference/question) in the survey.
     * @param visibleOnly A Boolean value that specifies whether to include only visible questions.
     * @param includeDesignTime For internal use.
     * @param includeNested A Boolean value that specifies whether to include nested questions, such as questions within matrix cells.
     * @returns An array of questions.
     * @see getQuestionByName
     */
    getAllQuestions(visibleOnly?: boolean, includeDesignTime?: boolean, includeNested?: boolean): Array<Question>;
    /**
     * Returns an array of quiz questions. A question counts if it is visible, has an input field, and specifies [`correctAnswer`](https://surveyjs.io/form-library/documentation/api-reference/checkbox-question-model#correctAnswer).
     *
     * For more information about quizzes, refer to the following tutorial: [Create a Quiz](https://surveyjs.io/form-library/documentation/design-survey/create-a-quiz).
     * @returns An array of quiz questions.
     * @see getQuizQuestionCount
     */
    getQuizQuestions(): Array<IQuestion>;
    /**
     * Returns a [panel](https://surveyjs.io/form-library/documentation/api-reference/panel-model) with a specified [`name`](https://surveyjs.io/form-library/documentation/api-reference/panel-model#name).
     * @param name A panel name.
     * @param caseInsensitive *(Optional)* A Boolean value that specifies case sensitivity when searching for the panel. Default value: `false` (uppercase and lowercase letters are treated as distinct).
     * @returns A panel with a specified name.
     * @see getAllPanels
     */
    getPanelByName(name: string, caseInsensitive?: boolean): PanelModel;
    /**
     * Returns a list of all [panels](https://surveyjs.io/form-library/documentation/api-reference/panel-model) in the survey.
     * @param visibleOnly A Boolean value that specifies whether to include only visible panels.
     * @param includeDesignTime For internal use.
     * @returns An array of panels.
     * @see getPanelByName
     */
    getAllPanels(visibleOnly?: boolean, includeDesignTime?: boolean): Array<IPanel>;
    /**
     * Creates and returns a new page but does not add it to the survey.
     *
     * Call the [`addPage(page)`](https://surveyjs.io/form-library/documentation/api-reference/survey-data-model#addPage) method to add the created page to the survey later or the [`addNewPage(name, index)`](https://surveyjs.io/form-library/documentation/api-reference/survey-data-model#addNewPage) method to create _and_ add a page to the survey.
     * @see addPage
     * @see addNewPage
     */
    createNewPage(name: string): PageModel;
    private getValueChangeReason;
    protected questionOnValueChanging(valueName: string, newValue: any, questionValueName?: string): any;
    protected updateQuestionValue(valueName: string, newValue: any): void;
    private checkQuestionErrorOnValueChanged;
    private checkQuestionErrorOnValueChangedCore;
    private checkErrorsOnValueChanging;
    private fireOnValueChanged;
    protected notifyQuestionOnValueChanged(valueName: string, newValue: any, questionName: string): void;
    private isRunningElementsBindings;
    private updateVisibleIndexAfterBindings;
    private checkElementsBindings;
    private notifyElementsOnAnyValueOrVariableChanged;
    private updateAllQuestionsValue;
    private notifyAllQuestionsOnValueChanged;
    private checkOnPageTriggers;
    private getCurrentPageQuestions;
    private isTriggerIsRunning;
    private triggerValues;
    private triggerKeys;
    private checkTriggers;
    private checkTriggersAndRunConditions;
    private get hasRequiredValidQuestionTrigger();
    private doElementsOnLoad;
    private conditionValues;
    private get isRunningConditions();
    private isValueChangedOnRunningCondition;
    private conditionRunnerCounter;
    private conditionUpdateVisibleIndexes;
    private conditionNotifyElementsOnAnyValueOrVariableChanged;
    /**
     * Recalculates all [expressions](https://surveyjs.io/form-library/documentation/design-survey/conditional-logic#expressions) in the survey.
     */
    runExpressions(): void;
    private runConditions;
    private questionTriggersKeys;
    private runConditionOnValueChanged;
    private runConditionsCore;
    private runQuestionsTriggers;
    private checkIfNewPagesBecomeVisible;
    /**
     * Posts a survey result to [SurveyJS Service](https://api.surveyjs.io/).
     * @param postId An identifier used to save survey results. You can find it on the [My Surveys](https://surveyjs.io/service/mysurveys) page. If you do not specify this parameter, the survey uses the [`surveyPostId`](https://surveyjs.io/form-library/documentation/api-reference/survey-data-model#surveyPostId) property value.
     * @param clientId A respondent identifier (e-mail or other unique ID). This ID ensures that the respondent does not pass the same survey twice.
     * @param isPartial Pass `true` to save partial survey results (see [Continue an Incomplete Survey](https://surveyjs.io/form-library/documentation/handle-survey-results-continue-incomplete)).
     */
    sendResult(postId?: string, clientId?: string, isPartial?: boolean): void;
    /**
     * Requests [SurveyJS Service](https://api.surveyjs.io/) to retrieve all answers to a specified question. Handle the [`onGetResult`](https://surveyjs.io/form-library/documentation/api-reference/survey-data-model#onGetResult) event to access the answers.
     * @param resultId A result ID that identifies the required survey. You can find it on the [My Surveys](https://surveyjs.io/service/mysurveys) page.
     * @param questionName A question name.
     */
    getResult(resultId: string, questionName: string): void;
    /**
     * Loads a survey JSON schema from the [SurveyJS Service](https://api.surveyjs.io). You can handle the [`onLoadedSurveyFromService`](#onLoadedSurveyFromService) event to modify the schema after loading if required.
     * @param surveyId The identifier of a survey JSON schema to load. Refer to the following help topic for more information: [Store Survey Results in the SurveyJS Service](https://surveyjs.io/form-library/documentation/handle-survey-results-store#store-survey-results-in-the-surveyjs-service).
     * @param clientId A user identifier (e-mail or other unique ID) used to determine whether the user has already taken the survey.
     */
    loadSurveyFromService(surveyId?: string, clientId?: string): void;
    private loadSurveyFromServiceJson;
    protected onLoadingSurveyFromService(): void;
    protected onLoadSurveyFromService(): void;
    private resetVisibleIndexes;
    private updateVisibleIndexes;
    private updatePageElementsVisibleIndexes;
    private getStartVisibleIndex;
    private updatePageVisibleIndexes;
    fromJSON(json: any, options?: ILoadFromJSONOptions): void;
    startLoadingFromJson(json?: any): void;
    setJsonObject(jsonObj: any): void;
    private isEndLoadingFromJson;
    endLoadingFromJson(): void;
    private updateNavigationCss;
    private updateNavigationItemCssCallback;
    private updateNavigationBarCss;
    protected createNavigationBar(): ActionContainer;
    protected createNavigationActions(): Array<IAction>;
    protected onBeforeRunConstructor(): void;
    protected onBeforeCreating(): void;
    protected onCreating(): void;
    private getProcessedTextValue;
    getBuiltInVariableValue(name: string): number;
    private getProcessedTextValueCore;
    private getProcessedValuesWithoutQuestion;
    private getFirstName;
    private reduceFirstName;
    private isClearingUnsedValues;
    private clearUnusedValues;
    hasVisibleQuestionByValueName(valueName: string): boolean;
    questionsByValueName(valueName: string): Array<IQuestion>;
    private clearInvisibleQuestionValues;
    /**
     * Returns a variable value.
     *
     * [Variables help topic](https://surveyjs.io/form-library/documentation/design-survey/conditional-logic#variables (linkStyle))
     * @param name A variable name.
     * @return A variable value.
     * @see setVariable
     * @see getVariableNames
     */
    getVariable(name: string): any;
    /**
     * Sets a variable value.
     *
     * [Variables help topic](https://surveyjs.io/form-library/documentation/design-survey/conditional-logic#variables (linkStyle))
     * @param name A variable name.
     * @param newValue A new variable value.
     * @see getVariable
     * @see getVariableNames
     */
    setVariable(name: string, newValue: any): void;
    /**
     * Returns the names of all variables in the survey.
     *
     * [Variables help topic](https://surveyjs.io/form-library/documentation/design-survey/conditional-logic#variables (linkStyle))
     * @returns An array of variable names.
     * @see getVariable
     * @see setVariable
     */
    getVariableNames(): Array<string>;
    protected getUnbindValue(value: any): any;
    /**
     * Returns a value (answer) for a question with a specified `name`.
     * @param name A question name.
     * @returns A question value (answer).
     * @see data
     * @see setValue
     */
    getValue(name: string): any;
    /**
     * Sets a question value (answer).
     *
     * > This method executes all triggers and reevaluates conditions (`visibleIf`, `requiredId`, and others). It also switches the survey to the next page if the [`autoAdvanceEnabled`](https://surveyjs.io/form-library/documentation/api-reference/survey-data-model#autoAdvanceEnabled) property is enabled and all questions on the current page have correct answers.
     * @param name A question name.
     * @param newValue A new question value.
     * @param locNotification For internal use.
     * @param allowNotifyValueChanged For internal use.
     * @see data
     * @see getValue
     */
    setValue(name: string, newQuestionValue: any, locNotification?: any, allowNotifyValueChanged?: boolean, questionName?: string): void;
    private isValueEmpyOnSetValue;
    private updateOnSetValue;
    private isValueEqual;
    protected doOnPageAdded(page: PageModel): void;
    protected doOnPageRemoved(page: PageModel): void;
    private generateNewName;
    protected tryGoNextPageAutomatic(name: string): void;
    private tryCompleteOrShowPreview;
    /**
     * Returns a comment value from a question with a specified `name`.
     * @param name A question name.
     * @returns A comment.
     * @see setComment
     */
    getComment(name: string): string;
    /**
     * Sets a comment value to a question with a specified `name`.
     * @param name A question name.
     * @param newValue A new comment value.
     * @param locNotification For internal use.
     * @see getComment
     */
    setComment(name: string, newValue: string, locNotification?: any): void;
    /**
     * Deletes an answer from survey results.
     * @param {string} name An object property that stores the answer to delete. Pass a question's [`valueName`](https://surveyjs.io/form-library/documentation/api-reference/question#valueName) or [`name`](https://surveyjs.io/form-library/documentation/api-reference/question#name).
     */
    clearValue(name: string): void;
    /**
     * Specifies whether to remove disabled choices from the value in [Dropdown](https://surveyjs.io/form-library/documentation/api-reference/dropdown-menu-model), [Checkboxes](https://surveyjs.io/form-library/documentation/api-reference/checkbox-question-model), and [Radio Button Group](https://surveyjs.io/form-library/documentation/api-reference/radio-button-question-model) questions.
     *
     * Default value: `false`
     *
     * > This property cannot be specified in the survey JSON schema. Use dot notation to specify it.
     */
    get clearDisabledChoices(): boolean;
    set clearDisabledChoices(val: boolean);
    /**
     * @deprecated Use the [`clearDisabledChoices`](https://surveyjs.io/form-library/documentation/api-reference/survey-data-model#clearDisabledChoices) property instead.
     */
    get clearValueOnDisableItems(): boolean;
    set clearValueOnDisableItems(val: boolean);
    getQuestionClearIfInvisible(questionClearIf: string): string;
    questionVisibilityChanged(question: Question, newValue: boolean, resetIndexes: boolean): void;
    pageVisibilityChanged(page: PageModel, newValue: boolean): void;
    panelVisibilityChanged(panel: PanelModel, newValue: boolean): void;
    questionCreated(question: Question): any;
    questionAdded(question: Question, index: number, parentPanel: any, rootPanel: any): void;
    private canFireAddElement;
    questionRemoved(question: Question): void;
    questionRenamed(question: IQuestion, oldName: string, oldValueName: string): any;
    private questionHashes;
    private questionHashesClear;
    private questionHashesPanelAdded;
    private questionHashesAdded;
    private questionHashesRemoved;
    private questionHashAddedCore;
    private questionHashRemovedCore;
    panelAdded(panel: PanelModel, index: number, parentPanel: any, rootPanel: any): void;
    panelRemoved(panel: PanelModel): void;
    validateQuestion(question: Question, errors: Array<SurveyError>, fireCallback: boolean): void;
    validatePanel(panel: PanelModel, errors: Array<SurveyError>, fireCallback: boolean): void;
    processHtml(html: string, reason?: string): string;
    processText(text: string, returnDisplayValue: boolean): string;
    processTextEx(params: ITextProcessorProp): ITextProcessorResult;
    private textPreProcessorValue;
    private get textPreProcessor();
    getSurveyMarkdownHtml(element: Question | PanelModel | PageModel | SurveyModel, text: string, name: string): string;
    getCorrectedAnswerCount(): number;
    /**
     * Returns the number of correct answers in a quiz.
     *
     * For more information about quizzes, refer to the following tutorial: [Create a Quiz](https://surveyjs.io/form-library/documentation/design-survey/create-a-quiz).
     * @returns The number of correct answers in a quiz.
     * @see getQuizQuestionCount
     * @see getIncorrectAnswerCount
     */
    getCorrectAnswerCount(): number;
    /**
     * Returns the number of quiz questions. A question counts if it is visible, has an input field, and specifies [`correctAnswer`](https://surveyjs.io/form-library/documentation/api-reference/checkbox-question-model#correctAnswer).
     *
     * This number may be different from `getQuizQuestions().length` because certain question types (for instance, matrix-like types) include more than one question.
     *
     * For more information about quizzes, refer to the following tutorial: [Create a Quiz](https://surveyjs.io/form-library/documentation/design-survey/create-a-quiz).
     * @returns The number of quiz questions.
     * @see getQuizQuestions
     */
    getQuizQuestionCount(): number;
    getInCorrectedAnswerCount(): number;
    getInCorrectAnswerCount(): number;
    /**
     * Returns the number of incorrect answers in a quiz.
     *
     * For more information about quizzes, refer to the following tutorial: [Create a Quiz](https://surveyjs.io/form-library/documentation/design-survey/create-a-quiz).
     * @returns The number of incorrect answers in a quiz.
     * @see getCorrectAnswerCount
     */
    getIncorrectAnswerCount(): number;
    onCorrectQuestionAnswer(question: IQuestion, options: any): void;
    private getCorrectedAnswerCountCore;
    getCorrectedAnswers(): number;
    getInCorrectedAnswers(): number;
    /**
     * @deprecated Use the [`showTimer`](https://surveyjs.io/form-library/documentation/api-reference/survey-data-model#showTimer) and [`timerLocation`](https://surveyjs.io/form-library/documentation/api-reference/survey-data-model#timerLocation) properties instead.
     */
    get showTimerPanel(): string;
    set showTimerPanel(val: string);
    /**
     * Specifies the timer's visibility. Applies only to [quiz surveys](https://surveyjs.io/form-library/documentation/design-survey-create-a-quiz).
     *
     * Default value: `false`
     *
     * If you set this property to `true`, the timer starts automatically when the survey begins. To specify time limits, use the [`timeLimit`](https://surveyjs.io/form-library/documentation/api-reference/survey-data-model#timeLimit) and [`timeLimitPerPage`](https://surveyjs.io/form-library/documentation/api-reference/survey-data-model#timeLimitPerPage) properties.
     *
     * The timer displays information about time spent on an individual page and the entire survey. If you want to display only the page timer or the survey timer, set the [`timerInfoMode`](https://surveyjs.io/form-library/documentation/api-reference/survey-data-model#timerInfoMode) property to `"page"` or `"survey"`.
     *
     * You can enable the timer without displaying it. In this case, you need to specify the required time limits and use the [`startTimer()`](https://surveyjs.io/form-library/documentation/api-reference/survey-data-model#startTimer) and [`stopTimer()`](https://surveyjs.io/form-library/documentation/api-reference/survey-data-model#stopTimer) methods to control the timer.
     * @see timerLocation
     * @see timeSpent
     * @see onTimerTick
     */
    get showTimer(): boolean;
    set showTimer(val: boolean);
    /**
     * Specifies the timer's position relative to the survey. Applies only if the [`showTimer`](https://surveyjs.io/form-library/documentation/api-reference/survey-data-model#showTimer) property is set to `true`.
     *
     * Possible values:
     *
     * - `"top"` (default) - Displays the timer at the top of the survey.
     * - `"bottom"` - Displays the timer at the bottom of the survey.
     * @see onTimerTick
     */
    get timerLocation(): string;
    set timerLocation(val: string);
    get isTimerPanelShowingOnTop(): boolean;
    get isTimerPanelShowingOnBottom(): boolean;
    /**
     * Specifies whether the timer panel displays timers for the current page, the entire survey, or both. Applies only if the timer panel is [visible](https://surveyjs.io/form-library/documentation/api-reference/survey-data-model#showTimer).
     *
     * Possible values:
     *
     * - `"survey"` - Displays only the survey timer.
     * - `"page"` - Displays only the page timer.
     * - `"combined"` (default) - Displays both the survey and page timers.
     * @see timeSpent
     * @see onTimerTick
     * @see startTimer
     * @see stopTimer
     */
    get timerInfoMode(): string;
    set timerInfoMode(val: string);
    private getTimerInfoVal;
    /**
     * @deprecated Use the [`timerInfoMode`](https://surveyjs.io/form-library/documentation/api-reference/survey-data-model#timerInfoMode) property instead.
     */
    get showTimerPanelMode(): string;
    set showTimerPanelMode(val: string);
    /**
     * Enables the grid layout, which structures form elements using a column-based system.
     *
     * Default value: `false`
     *
     * Specify the [`gridLayoutColumns`](https://surveyjs.io/form-library/documentation/api-reference/page-model#gridLayoutColumns) property for pages and panels to configure layout columns. Set the [`colSpan`](https://surveyjs.io/form-library/documentation/api-reference/question#colSpan) property for an individual question or panel to adjust how many columns this survey element spans.
     */
    gridLayoutEnabled: boolean;
    updateGridColumns(): void;
    /**
      * Specifies how to calculate the survey width.
      *
      * Possible values:
      *
      * - `"static"` - A survey has a [fixed width](#width).
      * - `"responsive"` - A survey occupies all available horizontal space and stretches or shrinks horizontally to fit in the screen size.
      * - `"auto"` (default) - Survey width depends on a question type and corresponds to the `"static"` or `"responsive"` mode.
    */
    get widthMode(): string;
    set widthMode(val: string);
    private calculatedWidthModeUpdater;
    setCalculatedWidthModeUpdater(): void;
    calculatedWidthMode: string;
    calculateWidthMode(): string;
    /**
     * A survey width in CSS values.
     *
     * Default value: `undefined` (the survey inherits the width from its container)
     * @see onResize
     */
    get width(): string;
    set width(val: string);
    get renderedWidth(): string;
    widthScale: number;
    staticStartWidth: number;
    setStaticStartWidth(width: number): void;
    responsiveStartWidth: number;
    setResponsiveStartWidth(width: number): void;
    get isScaled(): boolean;
    get timerInfo(): {
        spent: number;
        limit?: number;
    };
    get timerClock(): {
        majorText: string;
        minorText?: string;
    };
    get timerInfoText(): string;
    private getTimerInfo;
    private getTimerInfoText;
    private getTimerInfoPageText;
    private getTimerInfoSurveyText;
    private getDisplayClockTime;
    private getDisplayTime;
    get timerModel(): SurveyTimerModel;
    /**
     * Starts a timer that calculates how many seconds a respondent has spent on the survey. Applies only to [quiz surveys](https://surveyjs.io/form-library/documentation/design-survey-create-a-quiz).
     * @see stopTimer
     * @see timeLimit
     * @see timeLimitPerPage
     * @see timeSpent
     * @see onTimerTick
     */
    startTimer(): void;
    startTimerFromUI(): void;
    /**
     * Stops the timer. Applies only to [quiz surveys](https://surveyjs.io/form-library/documentation/design-survey-create-a-quiz).
     * @see startTimer
     * @see timeLimit
     * @see timeLimitPerPage
     * @see timeSpent
     * @see onTimerTick
     */
    stopTimer(): void;
    /**
     * A time period that a respondent has spent on the survey so far; measured in seconds. Applies only to [quiz surveys](https://surveyjs.io/form-library/documentation/design-survey-create-a-quiz).
     *
     * Assign a number to this property if you need to start the quiz timer from a specific time (for instance, if you want to continue an interrupted quiz).
     *
     * You can also find out how many seconds a respondent has spent on an individual survey page. To do this, use the [`timeSpent`](https://surveyjs.io/form-library/documentation/api-reference/page-model#timeSpent) property of a [`PageModel`](https://surveyjs.io/form-library/documentation/api-reference/page-model) object.
     * @see timeLimit
     * @see timeLimitPerPage
     * @see startTimer
     */
    get timeSpent(): number;
    set timeSpent(val: number);
    /**
     * A time period that a respondent has to complete the survey; measured in seconds. Applies only to [quiz surveys](https://surveyjs.io/form-library/documentation/design-survey-create-a-quiz).
     *
     * Default value: 0 (time is unlimited)
     *
     * [View Demo](https://surveyjs.io/form-library/examples/make-quiz-javascript/ (linkStyle))
     * @see timeLimitPerPage
     * @see startTimer
     * @see timeSpent
     */
    get timeLimit(): number;
    set timeLimit(val: number);
    /**
     * @deprecated Use the [`timeLimit`](https://surveyjs.io/form-library/documentation/api-reference/survey-data-model#timeLimit) property instead.
     */
    get maxTimeToFinish(): number;
    set maxTimeToFinish(val: number);
    /**
     * A time period that a respondent has to complete each survey page; measured in seconds. Applies only to [quiz surveys](https://surveyjs.io/form-library/documentation/design-survey-create-a-quiz).
     *
     * Default value: 0 (time is unlimited)
     *
     * You can also use `PageModel`'s [`timeLimit`](https://surveyjs.io/form-library/documentation/api-reference/page-model#timeLimit) property to specify a time period for an individual survey page.
     *
     * [View Demo](https://surveyjs.io/form-library/examples/make-quiz-javascript/ (linkStyle))
     * @see timeLimit
     * @see startTimer
     * @see timeSpent
     */
    get timeLimitPerPage(): number;
    set timeLimitPerPage(val: number);
    /**
     * @deprecated Use the [`timeLimitPerPage`](https://surveyjs.io/form-library/documentation/api-reference/survey-data-model#timeLimitPerPage) property instead.
     */
    get maxTimeToFinishPage(): number;
    set maxTimeToFinishPage(val: number);
    private doTimer;
    get inSurvey(): boolean;
    getSurveyData(): ISurveyData;
    getSurvey(): ISurvey;
    getTextProcessor(): ITextProcessor;
    getObjects(pages: string[], questions: string[]): any[];
    setTriggerValue(name: string, value: any, isVariable: boolean): void;
    copyTriggerValue(name: string, fromName: string, copyDisplayValue: boolean): void;
    triggerExecuted(trigger: Trigger): void;
    private setValueFromTriggerCounter;
    get isSettingValueFromTrigger(): boolean;
    private startSetValueFromTrigger;
    private finishSetValueFromTrigger;
    private focusingQuestionInfo;
    private isMovingQuestion;
    startMovingQuestion(): void;
    stopMovingQuestion(): void;
    get isQuestionDragging(): boolean;
    needRenderIcons: boolean;
    private skippedPages;
    /**
     * Focuses a question with a specified name. Switches the current page if needed.
     * @param name A question name.
     * @returns `false` if the survey does not contain a question with a specified name or this question is hidden; otherwise, `true`.
     * @see focusFirstQuestion
     * @see autoFocusFirstQuestion
     */
    focusQuestion(name: string): boolean;
    focusQuestionByInstance(question: Question, onError?: boolean): boolean;
    private focusQuestionInfo;
    questionEditFinishCallback(question: Question, event: any): void;
    private elementWrapperComponentNameCore;
    private elementWrapperDataCore;
    getElementWrapperComponentName(element: any, reason?: string): string;
    getQuestionContentWrapperComponentName(element: any): string;
    getRowWrapperComponentName(row: QuestionRowModel): string;
    getItemValueWrapperComponentName(item: ItemValue, question: QuestionSelectBase): string;
    getElementWrapperComponentData(element: any, reason?: string): any;
    getRowWrapperComponentData(row: QuestionRowModel): any;
    getItemValueWrapperComponentData(item: ItemValue, question: QuestionSelectBase): any;
    getMatrixCellTemplateData(cell: any): any;
    searchText(text: string): Array<IFindElement>;
    skeletonComponentName: string;
    getSkeletonComponentName(element: ISurveyElement): string;
    private layoutElements;
    /**
     * Adds an element to the survey layout.
     *
     * This method accepts an object with the following layout element properties:
     *
     * - `id`: `string` | `"timerpanel"` | `"progress-buttons"` | `"progress-questions"` | `"progress-pages"` | `"progress-correctquestions"` | `"progress-requiredquestions"` | `"toc-navigation"` | `"buttons-navigation"`\
     * A layout element identifier. You can use possible values to access and relocate or customize predefined layout elements.
     *
     * - `container`: `"header"` | `"footer"` | `"left"` | `"right"` | `"contentTop"` | `"contentBottom"`\
     * A layout container that holds the element. If you want to display the element within multiple containers, set this property to an array of possible values.
     *
     * - `component`: `string`\
     * The name of the component that renders the layout element.
     *
     * - `data`: `any`\
     * Data passed as props to `component`.
     *
     * [View Demo](https://surveyjs.io/form-library/examples/progress-bar-with-percentage/ (linkStyle))
     * @param layoutElement A layout element configuration.
     * @returns The configuration of the previous layout element with the same `id`.
     */
    addLayoutElement(layoutElement: ISurveyLayoutElement): ISurveyLayoutElement;
    findLayoutElement(layoutElementId: string): ISurveyLayoutElement;
    removeLayoutElement(layoutElementId: string): ISurveyLayoutElement;
    getContainerContent(container: LayoutElementContainer): any[];
    processPopupVisiblityChanged(question: Question, popup: PopupModel<any>, visible: boolean): void;
    processOpenDropdownMenu(question: Question, options: IDropdownMenuOptions): void;
    getCssTitleExpandableSvg(): string;
    /**
     * Applies a specified theme to the survey.
     *
     * [Themes & Styles](https://surveyjs.io/form-library/documentation/manage-default-themes-and-styles (linkStyle))
     * @param theme An [`ITheme`](https://surveyjs.io/form-library/documentation/api-reference/itheme) object with theme settings.
     */
    applyTheme(theme: ITheme): void;
    themeChanged(theme: ITheme): void;
    private taskManager;
    /**
     * Disposes of the survey model.
     *
     * Call this method to release resources if your application contains multiple survey models or if you re-create a survey model at runtime.
     */
    dispose(): void;
    disposeCallback: () => void;
    private onScrollCallback;
    _isElementShouldBeSticky(selector: string): boolean;
    onScroll(): void;
    addScrollEventListener(): void;
    removeScrollEventListener(): void;
    questionErrorComponent: string;
}
