/*!
 * surveyjs - Survey JavaScript library v1.9.19
 * Copyright (c) 2015-2022 Devsoft Baltic OÜ  - http://surveyjs.io/
 * License: MIT (http://www.opensource.org/licenses/mit-license.php)
 */
(function webpackUniversalModuleDefinition(root, factory) {
	if(typeof exports === 'object' && typeof module === 'object')
		module.exports = factory(require("knockout"));
	else if(typeof define === 'function' && define.amd)
		define("survey-ko", ["knockout"], factory);
	else if(typeof exports === 'object')
		exports["survey-ko"] = factory(require("knockout"));
	else
		root["Survey"] = factory(root["ko"]);
})(this, function(__WEBPACK_EXTERNAL_MODULE_knockout__) {
return /******/ (function(modules) { // webpackBootstrap
/******/ 	// The module cache
/******/ 	var installedModules = {};
/******/
/******/ 	// The require function
/******/ 	function __webpack_require__(moduleId) {
/******/
/******/ 		// Check if module is in cache
/******/ 		if(installedModules[moduleId]) {
/******/ 			return installedModules[moduleId].exports;
/******/ 		}
/******/ 		// Create a new module (and put it into the cache)
/******/ 		var module = installedModules[moduleId] = {
/******/ 			i: moduleId,
/******/ 			l: false,
/******/ 			exports: {}
/******/ 		};
/******/
/******/ 		// Execute the module function
/******/ 		modules[moduleId].call(module.exports, module, module.exports, __webpack_require__);
/******/
/******/ 		// Flag the module as loaded
/******/ 		module.l = true;
/******/
/******/ 		// Return the exports of the module
/******/ 		return module.exports;
/******/ 	}
/******/
/******/
/******/ 	// expose the modules object (__webpack_modules__)
/******/ 	__webpack_require__.m = modules;
/******/
/******/ 	// expose the module cache
/******/ 	__webpack_require__.c = installedModules;
/******/
/******/ 	// define getter function for harmony exports
/******/ 	__webpack_require__.d = function(exports, name, getter) {
/******/ 		if(!__webpack_require__.o(exports, name)) {
/******/ 			Object.defineProperty(exports, name, { enumerable: true, get: getter });
/******/ 		}
/******/ 	};
/******/
/******/ 	// define __esModule on exports
/******/ 	__webpack_require__.r = function(exports) {
/******/ 		if(typeof Symbol !== 'undefined' && Symbol.toStringTag) {
/******/ 			Object.defineProperty(exports, Symbol.toStringTag, { value: 'Module' });
/******/ 		}
/******/ 		Object.defineProperty(exports, '__esModule', { value: true });
/******/ 	};
/******/
/******/ 	// create a fake namespace object
/******/ 	// mode & 1: value is a module id, require it
/******/ 	// mode & 2: merge all properties of value into the ns
/******/ 	// mode & 4: return value when already ns object
/******/ 	// mode & 8|1: behave like require
/******/ 	__webpack_require__.t = function(value, mode) {
/******/ 		if(mode & 1) value = __webpack_require__(value);
/******/ 		if(mode & 8) return value;
/******/ 		if((mode & 4) && typeof value === 'object' && value && value.__esModule) return value;
/******/ 		var ns = Object.create(null);
/******/ 		__webpack_require__.r(ns);
/******/ 		Object.defineProperty(ns, 'default', { enumerable: true, value: value });
/******/ 		if(mode & 2 && typeof value != 'string') for(var key in value) __webpack_require__.d(ns, key, function(key) { return value[key]; }.bind(null, key));
/******/ 		return ns;
/******/ 	};
/******/
/******/ 	// getDefaultExport function for compatibility with non-harmony modules
/******/ 	__webpack_require__.n = function(module) {
/******/ 		var getter = module && module.__esModule ?
/******/ 			function getDefault() { return module['default']; } :
/******/ 			function getModuleExports() { return module; };
/******/ 		__webpack_require__.d(getter, 'a', getter);
/******/ 		return getter;
/******/ 	};
/******/
/******/ 	// Object.prototype.hasOwnProperty.call
/******/ 	__webpack_require__.o = function(object, property) { return Object.prototype.hasOwnProperty.call(object, property); };
/******/
/******/ 	// __webpack_public_path__
/******/ 	__webpack_require__.p = "";
/******/
/******/
/******/ 	// Load entry module and return exports
/******/ 	return __webpack_require__(__webpack_require__.s = "./src/entries/knockout.ts");
/******/ })
/************************************************************************/
/******/ ({

/***/ "./node_modules/html-loader/index.js?interpolate!./node_modules/val-loader/index.js!./src/knockout/components/panel/panel.html":
/*!*******************************************************************************************************************!*\
  !*** ./node_modules/html-loader?interpolate!./node_modules/val-loader!./src/knockout/components/panel/panel.html ***!
  \*******************************************************************************************************************/
/*! no static exports found */
/***/ (function(module, exports) {

module.exports = "<!-- ko template: { name: 'survey-panel', data: question, as: 'question', afterRender: question.koPanelAfterRender } --><!-- /ko -->";

/***/ }),

/***/ "./node_modules/html-loader/index.js?interpolate!./node_modules/val-loader/index.js!./src/knockout/components/popup/popup.html":
/*!*******************************************************************************************************************!*\
  !*** ./node_modules/html-loader?interpolate!./node_modules/val-loader!./src/knockout/components/popup/popup.html ***!
  \*******************************************************************************************************************/
/*! no static exports found */
/***/ (function(module, exports) {

module.exports = "<div class=\"sv-popup\" tabindex=\"-1\"\n  data-bind=\"visible: isVisible, click: clickOutside, class: styleClass, event: { keydown: function(data, event) { onKeyDown(event); return true; } }\">\n  <div class=\"sv-popup__container\"\n    data-bind=\"style: { left: left, top: top, height: height },  click: function() { return true; }, clickBubble: false\">\n    <div class=\"sv-popup_shadow\">\n      <!-- ko if: showPointer  -->\n      <span data-bind=\"style: {left: pointerTarget.left, top: pointerTarget.top }\" class=\"sv-popup__pointer\"></span>\n      <!-- /ko -->\n      <!-- ko if: !!title  -->\n      <div class=\"sv-popup__header\" data-bind=\"text: title\"></div>\n      <!-- /ko -->\n      <div class=\"sv-popup__scrolling-content\">\n        <div class=\"sv-popup__content\"\n          data-bind=\"component: { name: contentComponentName, params: contentComponentData }\"></div>\n      </div>\n      <!-- ko if: showFooter  -->\n      <div class=\"sv-popup__footer\">\n        <button type=\"button\" class=\"sv-popup__footer-item sv-popup__button sv-popup__button--cancel\"\n          data-bind=\"click: cancel, text: cancelButtonText\"> Cancel </button>\n        <!-- ko if: isModal  -->\n        <button type=\"button\" class=\"sv-popup__footer-item sv-popup__button sv-popup__button--apply\"\n          data-bind=\"click: apply, text: applyButtonText\"> Apply </button>\n        <!-- /ko -->\n      </div>\n      <!-- /ko -->\n    </div>\n  </div>\n</div>";

/***/ }),

/***/ "./node_modules/html-loader/index.js?interpolate!./node_modules/val-loader/index.js!./src/knockout/components/progress/buttons.html":
/*!************************************************************************************************************************!*\
  !*** ./node_modules/html-loader?interpolate!./node_modules/val-loader!./src/knockout/components/progress/buttons.html ***!
  \************************************************************************************************************************/
/*! no static exports found */
/***/ (function(module, exports) {

module.exports = "<div data-bind=\"css: survey.css.progressButtonsContainerCenter\">\n    <div data-bind=\"css: survey.css.progressButtonsContainer\">\n        <div data-bind=\"css: getScrollButtonCss(true), click: clickScrollButton.bind($data, $element.nextElementSibling, true)\" role=\"button\"></div>\n        <div data-bind=\"css: survey.css.progressButtonsListContainer\">\n            <ul data-bind=\"foreach: survey.visiblePages, css: survey.css.progressButtonsList\">\n                <li data-bind=\"css: $parent.getListElementCss($index), click: $parent.isListElementClickable($index) ? $parent.clickListElement.bind($parent, $index) : null\">\n                    <div data-bind=\"css: css.progressButtonsPageTitle, text: locNavigationTitle.koRenderedHtml() || name, attr: { title: locNavigationTitle.koRenderedHtml() || name }\"></div>\n                    <div data-bind=\"css: css.progressButtonsPageDescription, text: locNavigationDescription.koRenderedHtml(), attr: { title: locNavigationDescription.koRenderedHtml() }\"></div>\n                </li>\n            </ul>\n        </div>\n        <div data-bind=\"css: getScrollButtonCss(false), click: clickScrollButton.bind($data, $element.previousElementSibling, false)\" role=\"button\"></div>\n    </div>\n</div>";

/***/ }),

/***/ "./node_modules/html-loader/index.js?interpolate!./node_modules/val-loader/index.js!./src/knockout/components/progress/progress.html":
/*!*************************************************************************************************************************!*\
  !*** ./node_modules/html-loader?interpolate!./node_modules/val-loader!./src/knockout/components/progress/progress.html ***!
  \*************************************************************************************************************************/
/*! no static exports found */
/***/ (function(module, exports) {

module.exports = "<div data-bind=\"css: model.css.progress\">\n    <div data-bind=\"css: model.css.progressBar, style: { width: model.progressValue + '%' }\"\n        role=\"progressbar\" aria-valuemin=\"0\" aria-valuemax=\"100\">\n        <span data-bind=\"text: model.progressText, css: getProgressTextInBarCss(model.css)\"></span>\n    </div>\n    <span data-bind=\"text: model.progressText, css: getProgressTextUnderBarCss(model.css)\"></span>\n</div>";

/***/ }),

/***/ "./node_modules/html-loader/index.js?interpolate!./node_modules/val-loader/index.js!./src/knockout/components/tooltip-error/tooltip-error.html":
/*!***********************************************************************************************************************************!*\
  !*** ./node_modules/html-loader?interpolate!./node_modules/val-loader!./src/knockout/components/tooltip-error/tooltip-error.html ***!
  \***********************************************************************************************************************************/
/*! no static exports found */
/***/ (function(module, exports) {

module.exports = "<!-- ko if: question.hasVisibleErrors -->\n  <!-- ko template: { name: 'survey-question-errors', data: question, afterRender: afterRender } -->\n  <!-- /ko -->\n<!-- /ko -->";

/***/ }),

/***/ "./node_modules/html-loader/index.js?interpolate!./node_modules/val-loader/index.js!./src/knockout/templates/entry.html":
/*!************************************************************************************************************!*\
  !*** ./node_modules/html-loader?interpolate!./node_modules/val-loader!./src/knockout/templates/entry.html ***!
  \************************************************************************************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

module.exports = "" + __webpack_require__(/*! ./comment.html */ "./src/knockout/templates/comment.html") + "\n" + __webpack_require__(/*! ./flowpanel.html */ "./src/knockout/templates/flowpanel.html") + "\n" + __webpack_require__(/*! ./header.html */ "./src/knockout/templates/header.html") + "\n" + __webpack_require__(/*! ./index.html */ "./src/knockout/templates/index.html") + "\n" + __webpack_require__(/*! ./page.html */ "./src/knockout/templates/page.html") + "\n" + __webpack_require__(/*! ./panel.html */ "./src/knockout/templates/panel.html") + "\n" + __webpack_require__(/*! ./rows.html */ "./src/knockout/templates/rows.html") + "\n" + __webpack_require__(/*! ./row.html */ "./src/knockout/templates/row.html") + "\n" + __webpack_require__(/*! ./string.html */ "./src/knockout/templates/string.html") + "\n" + __webpack_require__(/*! ./timerpanel.html */ "./src/knockout/templates/timerpanel.html") + "\n" + __webpack_require__(/*! ./question.html */ "./src/knockout/templates/question.html") + "\n" + __webpack_require__(/*! ./questioncontent.html */ "./src/knockout/templates/questioncontent.html") + "\n" + __webpack_require__(/*! ./questiontitle.html */ "./src/knockout/templates/questiontitle.html") + "\n" + __webpack_require__(/*! ./question-boolean.html */ "./src/knockout/templates/question-boolean.html") + "\n" + __webpack_require__(/*! ./question-checkbox.html */ "./src/knockout/templates/question-checkbox.html") + "\n" + __webpack_require__(/*! ./question-ranking.html */ "./src/knockout/templates/question-ranking.html") + "\n" + __webpack_require__(/*! ./question-comment.html */ "./src/knockout/templates/question-comment.html") + "\n" + __webpack_require__(/*! ./question-composite.html */ "./src/knockout/templates/question-composite.html") + "\n" + __webpack_require__(/*! ./question-custom.html */ "./src/knockout/templates/question-custom.html") + "\n" + __webpack_require__(/*! ./question-dropdown.html */ "./src/knockout/templates/question-dropdown.html") + "\n" + __webpack_require__(/*! ./question-empty.html */ "./src/knockout/templates/question-empty.html") + "\n" + __webpack_require__(/*! ./question-errors.html */ "./src/knockout/templates/question-errors.html") + "\n" + __webpack_require__(/*! ./question-expression.html */ "./src/knockout/templates/question-expression.html") + "\n" + __webpack_require__(/*! ./question-file.html */ "./src/knockout/templates/question-file.html") + "\n" + __webpack_require__(/*! ./question-html.html */ "./src/knockout/templates/question-html.html") + "\n" + __webpack_require__(/*! ./question-image.html */ "./src/knockout/templates/question-image.html") + "\n" + __webpack_require__(/*! ./question-imagepicker.html */ "./src/knockout/templates/question-imagepicker.html") + "\n" + __webpack_require__(/*! ./question-matrix.html */ "./src/knockout/templates/question-matrix.html") + "\n" + __webpack_require__(/*! ./question-matrixdynamic.html */ "./src/knockout/templates/question-matrixdynamic.html") + "\n" + __webpack_require__(/*! ./question-multipletext.html */ "./src/knockout/templates/question-multipletext.html") + "\n" + __webpack_require__(/*! ./question-paneldynamic.html */ "./src/knockout/templates/question-paneldynamic.html") + "\n" + __webpack_require__(/*! ./question-paneldynamic-navigator.html */ "./src/knockout/templates/question-paneldynamic-navigator.html") + "\n" + __webpack_require__(/*! ./question-radiogroup.html */ "./src/knockout/templates/question-radiogroup.html") + "\n" + __webpack_require__(/*! ./question-rating.html */ "./src/knockout/templates/question-rating.html") + "\n" + __webpack_require__(/*! ./question-signaturepad.html */ "./src/knockout/templates/question-signaturepad.html") + "\n" + __webpack_require__(/*! ./question-text.html */ "./src/knockout/templates/question-text.html") + "\n" + __webpack_require__(/*! ./question-buttongroup.html */ "./src/knockout/templates/question-buttongroup.html") + "";

/***/ }),

/***/ "./node_modules/html-loader/index.js?interpolate!./node_modules/val-loader/index.js!./src/knockout/templates/window/window.html":
/*!********************************************************************************************************************!*\
  !*** ./node_modules/html-loader?interpolate!./node_modules/val-loader!./src/knockout/templates/window/window.html ***!
  \********************************************************************************************************************/
/*! no static exports found */
/***/ (function(module, exports) {

module.exports = "<div style=\"position: fixed; bottom: 3px; right: 10px; max-width: 60%;\" data-bind=\"css: cssRoot\">\n    <div data-bind=\"css: cssHeaderRoot\">\n        <span data-bind=\"click:doExpand\" style=\"width: 100%; cursor: pointer;\">\n            <span style=\"padding-right:10px\" data-bind=\"css: cssHeaderTitle, text: locTitle.koRenderedHtml\"></span>\n            <span aria-hidden=\"true\" data-bind=\"css: cssButton\"></span>\n        </span>\n        <span data-bind=\"visible:isExpanded, click:doExpand\" style=\"float: right; cursor: pointer;\">\n            <span style=\"padding-right:10px\" data-bind=\"css: cssHeaderTitle\">X</span>\n        </span>\n    </div>\n    <div data-bind=\"visible:isExpanded, css: cssBody\">\n        <div id=\"windowSurveyJS\"></div>\n    </div>\n</div>";

/***/ }),

/***/ "./node_modules/html-loader/index.js?interpolate!./node_modules/val-loader/index.js!./src/svgbundle.html":
/*!*********************************************************************************************!*\
  !*** ./node_modules/html-loader?interpolate!./node_modules/val-loader!./src/svgbundle.html ***!
  \*********************************************************************************************/
/*! no static exports found */
/***/ (function(module, exports) {

module.exports = "<svg style=\"display:none;\"><defs><clipPath id=\"defaultfile-a\"> <path fill=\"#fff\" d=\"M0 0h56v68H0z\"></path></clipPath></defs><symbol viewBox=\"0 0 10 10\" id=\"icon-arrow_downgrey_10x10\"><style><![CDATA[.st0{fill:#6d7072}]]></style><path class=\"st0\" d=\"M2 2L0 4l5 5 5-5-2-2-3 3z\"></path></symbol><symbol viewBox=\"0 0 34 34\" id=\"icon-arrowdown_34x34\"><style><![CDATA[.st0{fill:#fff}]]></style><path class=\"st0\" d=\"M12 16l2-2 3 3 3-3 2 2-5 5z\"></path></symbol><symbol viewBox=\"0 0 16 16\" id=\"icon-arrowleft\"><path d=\"M15 9H4.4l4.3 4.3-1.4 1.4L.6 8l6.7-6.7 1.4 1.4L4.4 7H15v2z\"></path></symbol><symbol viewBox=\"0 0 16 16\" id=\"icon-arrowright\"><path d=\"M1 7h10.6L7.3 2.7l1.4-1.4L15.4 8l-6.7 6.7-1.4-1.4L11.6 9H1V7z\"></path></symbol><symbol viewBox=\"0 0 24 24\" id=\"icon-choosefile\"><path d=\"M22 9V7c0-1.1-.9-2-2-2h-8l-2-2H4c-1.1 0-2 .9-2 2v16h20l2-12h-2zM4 5h5.2l1.4 1.4.6.6H20v2H4V5zm16.3 14H4v-8h17.6l-1.3 8z\"></path></symbol><symbol viewBox=\"0 0 24 24\" id=\"icon-clear\"><path d=\"M22.6 8.6l-6.2-6.2c-.4-.4-.9-.6-1.4-.6-.5 0-1 .2-1.4.6L1.4 14.6c-.8.8-.8 2 0 2.8L6 22h6l10.6-10.6c.7-.8.7-2.1 0-2.8zM11.1 20H6.8l-4-4 3.4-3.4 6.2 6.2-1.3 1.2zm2.7-2.6l-6.2-6.2L15 3.8l6.2 6.2-7.4 7.4zM16 20h7v2h-9l2-2z\"></path></symbol><symbol viewBox=\"0 0 16 16\" id=\"icon-collapsedetail\"><path d=\"M13 7H3v2h10V7z\"></path></symbol><symbol viewBox=\"0 0 56 68\" id=\"icon-defaultfile\"><g clip-path=\"url(#defaultfile-a)\"><path d=\"M54.83 10.83l-9.66-9.66A4 4 0 0 0 42.34 0H6a6 6 0 0 0-6 6v56a6 6 0 0 0 6 6h44a6 6 0 0 0 6-6V13.66a4 4 0 0 0-1.17-2.83zM44 2.83L53.17 12H48a4 4 0 0 1-4-4V2.83zM54 62a4 4 0 0 1-4 4H6a4 4 0 0 1-4-4V6a4 4 0 0 1 4-4h36v6a6 6 0 0 0 6 6h6v48zM14 24h28v2H14v-2zm0 6h28v2H14v-2zm0 6h28v2H14v-2zm0 6h28v2H14v-2z\" fill=\"#909090\"></path></g></symbol><symbol viewBox=\"0 0 24 24\" id=\"icon-delete\"><path d=\"M22 4h-6V2c0-1.1-.9-2-2-2h-4C8.9 0 8 .9 8 2v2H2v2h2v14c0 1.1.9 2 2 2h12c1.1 0 2-.9 2-2V6h2V4zM10 2h4v2h-4V2zm8 18H6V6h12v14zM14 8h2v10h-2V8zm-3 0h2v10h-2V8zM8 8h2v10H8V8z\"></path></symbol><symbol viewBox=\"0 0 34 34\" id=\"icon-down_34x34\"><style><![CDATA[.st0{fill:#1ab394}.st1{fill:#fff}]]></style><path class=\"st0\" d=\"M33 34H0V0h33c.6 0 1 .4 1 1v32c0 .6-.4 1-1 1z\"></path><path class=\"st1\" d=\"M12 16l2-2 3 3 3-3 2 2-5 5z\"></path></symbol><symbol viewBox=\"0 0 16 16\" id=\"icon-expanddetail\"><path d=\"M13 7H9V3H7v4H3v2h4v4h2V9h4V7z\"></path></symbol><symbol viewBox=\"0 0 16 16\" id=\"icon-left\"><path d=\"M11 12l-2 2-6-6 6-6 2 2-4 4z\"></path></symbol><symbol viewBox=\"0 0 24 24\" id=\"icon-moderncheck\"><path d=\"M5 13l2-2 3 3 7-7 2 2-9 9-5-5z\"></path></symbol><symbol viewBox=\"-12 -12 24 24\" id=\"icon-modernradio\"><circle r=\"6\"></circle></symbol><symbol viewBox=\"0 0 24 24\" id=\"icon-more\"><path d=\"M6 12c0 1.1-.9 2-2 2s-2-.9-2-2 .9-2 2-2 2 .9 2 2zm6-2c-1.1 0-2 .9-2 2s.9 2 2 2 2-.9 2-2-.9-2-2-2zm8 0c-1.1 0-2 .9-2 2s.9 2 2 2 2-.9 2-2-.9-2-2-2z\"></path></symbol><symbol viewBox=\"0 0 10 10\" id=\"icon-progressbutton\"><path d=\"M2 2L0 4l5 5 5-5-2-2-3 3z\"></path></symbol><symbol viewBox=\"0 0 16 16\" id=\"icon-progressbuttonv2\"><path d=\"M15 9H4.4l4.3 4.3-1.4 1.4L.6 8l6.7-6.7 1.4 1.4L4.4 7H15v2z\"></path></symbol><symbol viewBox=\"0 0 16 16\" id=\"icon-removefile\"><path d=\"M8 2C4.7 2 2 4.7 2 8s2.7 6 6 6 6-2.7 6-6-2.7-6-6-6zm3 8l-1 1-2-2-2 2-1-1 2-2-2-2 1-1 2 2 2-2 1 1-2 2 2 2z\"></path></symbol><symbol viewBox=\"0 0 16 16\" id=\"icon-right\"><path d=\"M5 4l2-2 6 6-6 6-2-2 4-4z\"></path></symbol><symbol viewBox=\"0 0 20 20\" id=\"icon-v2check\"><path d=\"M8 15.8l-5.4-5.4L4 9l4 4 8-8 1.4 1.4L8 15.8z\"></path></symbol></svg>";

/***/ }),

/***/ "./node_modules/signature_pad/dist/signature_pad.mjs":
/*!***********************************************************!*\
  !*** ./node_modules/signature_pad/dist/signature_pad.mjs ***!
  \***********************************************************/
/*! exports provided: default */
/***/ (function(__webpack_module__, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/*!
 * Signature Pad v2.3.2
 * https://github.com/szimek/signature_pad
 *
 * Copyright 2017 Szymon Nowak
 * Released under the MIT license
 *
 * The main idea and some parts of the code (e.g. drawing variable width Bézier curve) are taken from:
 * http://corner.squareup.com/2012/07/smoother-signatures.html
 *
 * Implementation of interpolation using cubic Bézier curves is taken from:
 * http://benknowscode.wordpress.com/2012/09/14/path-interpolation-using-cubic-bezier-and-control-point-estimation-in-javascript
 *
 * Algorithm for approximated length of a Bézier curve is taken from:
 * http://www.lemoda.net/maths/bezier-length/index.html
 *
 */

function Point(x, y, time) {
  this.x = x;
  this.y = y;
  this.time = time || new Date().getTime();
}

Point.prototype.velocityFrom = function (start) {
  return this.time !== start.time ? this.distanceTo(start) / (this.time - start.time) : 1;
};

Point.prototype.distanceTo = function (start) {
  return Math.sqrt(Math.pow(this.x - start.x, 2) + Math.pow(this.y - start.y, 2));
};

Point.prototype.equals = function (other) {
  return this.x === other.x && this.y === other.y && this.time === other.time;
};

function Bezier(startPoint, control1, control2, endPoint) {
  this.startPoint = startPoint;
  this.control1 = control1;
  this.control2 = control2;
  this.endPoint = endPoint;
}

// Returns approximated length.
Bezier.prototype.length = function () {
  var steps = 10;
  var length = 0;
  var px = void 0;
  var py = void 0;

  for (var i = 0; i <= steps; i += 1) {
    var t = i / steps;
    var cx = this._point(t, this.startPoint.x, this.control1.x, this.control2.x, this.endPoint.x);
    var cy = this._point(t, this.startPoint.y, this.control1.y, this.control2.y, this.endPoint.y);
    if (i > 0) {
      var xdiff = cx - px;
      var ydiff = cy - py;
      length += Math.sqrt(xdiff * xdiff + ydiff * ydiff);
    }
    px = cx;
    py = cy;
  }

  return length;
};

/* eslint-disable no-multi-spaces, space-in-parens */
Bezier.prototype._point = function (t, start, c1, c2, end) {
  return start * (1.0 - t) * (1.0 - t) * (1.0 - t) + 3.0 * c1 * (1.0 - t) * (1.0 - t) * t + 3.0 * c2 * (1.0 - t) * t * t + end * t * t * t;
};

/* eslint-disable */

// http://stackoverflow.com/a/27078401/815507
function throttle(func, wait, options) {
  var context, args, result;
  var timeout = null;
  var previous = 0;
  if (!options) options = {};
  var later = function later() {
    previous = options.leading === false ? 0 : Date.now();
    timeout = null;
    result = func.apply(context, args);
    if (!timeout) context = args = null;
  };
  return function () {
    var now = Date.now();
    if (!previous && options.leading === false) previous = now;
    var remaining = wait - (now - previous);
    context = this;
    args = arguments;
    if (remaining <= 0 || remaining > wait) {
      if (timeout) {
        clearTimeout(timeout);
        timeout = null;
      }
      previous = now;
      result = func.apply(context, args);
      if (!timeout) context = args = null;
    } else if (!timeout && options.trailing !== false) {
      timeout = setTimeout(later, remaining);
    }
    return result;
  };
}

function SignaturePad(canvas, options) {
  var self = this;
  var opts = options || {};

  this.velocityFilterWeight = opts.velocityFilterWeight || 0.7;
  this.minWidth = opts.minWidth || 0.5;
  this.maxWidth = opts.maxWidth || 2.5;
  this.throttle = 'throttle' in opts ? opts.throttle : 16; // in miliseconds
  this.minDistance = 'minDistance' in opts ? opts.minDistance : 5;

  if (this.throttle) {
    this._strokeMoveUpdate = throttle(SignaturePad.prototype._strokeUpdate, this.throttle);
  } else {
    this._strokeMoveUpdate = SignaturePad.prototype._strokeUpdate;
  }

  this.dotSize = opts.dotSize || function () {
    return (this.minWidth + this.maxWidth) / 2;
  };
  this.penColor = opts.penColor || 'black';
  this.backgroundColor = opts.backgroundColor || 'rgba(0,0,0,0)';
  this.onBegin = opts.onBegin;
  this.onEnd = opts.onEnd;

  this._canvas = canvas;
  this._ctx = canvas.getContext('2d');
  this.clear();

  // We need add these inline so they are available to unbind while still having
  // access to 'self' we could use _.bind but it's not worth adding a dependency.
  this._handleMouseDown = function (event) {
    if (event.which === 1) {
      self._mouseButtonDown = true;
      self._strokeBegin(event);
    }
  };

  this._handleMouseMove = function (event) {
    if (self._mouseButtonDown) {
      self._strokeMoveUpdate(event);
    }
  };

  this._handleMouseUp = function (event) {
    if (event.which === 1 && self._mouseButtonDown) {
      self._mouseButtonDown = false;
      self._strokeEnd(event);
    }
  };

  this._handleTouchStart = function (event) {
    if (event.targetTouches.length === 1) {
      var touch = event.changedTouches[0];
      self._strokeBegin(touch);
    }
  };

  this._handleTouchMove = function (event) {
    // Prevent scrolling.
    event.preventDefault();

    var touch = event.targetTouches[0];
    self._strokeMoveUpdate(touch);
  };

  this._handleTouchEnd = function (event) {
    var wasCanvasTouched = event.target === self._canvas;
    if (wasCanvasTouched) {
      event.preventDefault();
      self._strokeEnd(event);
    }
  };

  // Enable mouse and touch event handlers
  this.on();
}

// Public methods
SignaturePad.prototype.clear = function () {
  var ctx = this._ctx;
  var canvas = this._canvas;

  ctx.fillStyle = this.backgroundColor;
  ctx.clearRect(0, 0, canvas.width, canvas.height);
  ctx.fillRect(0, 0, canvas.width, canvas.height);

  this._data = [];
  this._reset();
  this._isEmpty = true;
};

SignaturePad.prototype.fromDataURL = function (dataUrl) {
  var _this = this;

  var options = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};

  var image = new Image();
  var ratio = options.ratio || window.devicePixelRatio || 1;
  var width = options.width || this._canvas.width / ratio;
  var height = options.height || this._canvas.height / ratio;

  this._reset();
  image.src = dataUrl;
  image.onload = function () {
    _this._ctx.drawImage(image, 0, 0, width, height);
  };
  this._isEmpty = false;
};

SignaturePad.prototype.toDataURL = function (type) {
  var _canvas;

  switch (type) {
    case 'image/svg+xml':
      return this._toSVG();
    default:
      for (var _len = arguments.length, options = Array(_len > 1 ? _len - 1 : 0), _key = 1; _key < _len; _key++) {
        options[_key - 1] = arguments[_key];
      }

      return (_canvas = this._canvas).toDataURL.apply(_canvas, [type].concat(options));
  }
};

SignaturePad.prototype.on = function () {
  this._handleMouseEvents();
  this._handleTouchEvents();
};

SignaturePad.prototype.off = function () {
  this._canvas.removeEventListener('mousedown', this._handleMouseDown);
  this._canvas.removeEventListener('mousemove', this._handleMouseMove);
  document.removeEventListener('mouseup', this._handleMouseUp);

  this._canvas.removeEventListener('touchstart', this._handleTouchStart);
  this._canvas.removeEventListener('touchmove', this._handleTouchMove);
  this._canvas.removeEventListener('touchend', this._handleTouchEnd);
};

SignaturePad.prototype.isEmpty = function () {
  return this._isEmpty;
};

// Private methods
SignaturePad.prototype._strokeBegin = function (event) {
  this._data.push([]);
  this._reset();
  this._strokeUpdate(event);

  if (typeof this.onBegin === 'function') {
    this.onBegin(event);
  }
};

SignaturePad.prototype._strokeUpdate = function (event) {
  var x = event.clientX;
  var y = event.clientY;

  var point = this._createPoint(x, y);
  var lastPointGroup = this._data[this._data.length - 1];
  var lastPoint = lastPointGroup && lastPointGroup[lastPointGroup.length - 1];
  var isLastPointTooClose = lastPoint && point.distanceTo(lastPoint) < this.minDistance;

  // Skip this point if it's too close to the previous one
  if (!(lastPoint && isLastPointTooClose)) {
    var _addPoint = this._addPoint(point),
        curve = _addPoint.curve,
        widths = _addPoint.widths;

    if (curve && widths) {
      this._drawCurve(curve, widths.start, widths.end);
    }

    this._data[this._data.length - 1].push({
      x: point.x,
      y: point.y,
      time: point.time,
      color: this.penColor
    });
  }
};

SignaturePad.prototype._strokeEnd = function (event) {
  var canDrawCurve = this.points.length > 2;
  var point = this.points[0]; // Point instance

  if (!canDrawCurve && point) {
    this._drawDot(point);
  }

  if (point) {
    var lastPointGroup = this._data[this._data.length - 1];
    var lastPoint = lastPointGroup[lastPointGroup.length - 1]; // plain object

    // When drawing a dot, there's only one point in a group, so without this check
    // such group would end up with exactly the same 2 points.
    if (!point.equals(lastPoint)) {
      lastPointGroup.push({
        x: point.x,
        y: point.y,
        time: point.time,
        color: this.penColor
      });
    }
  }

  if (typeof this.onEnd === 'function') {
    this.onEnd(event);
  }
};

SignaturePad.prototype._handleMouseEvents = function () {
  this._mouseButtonDown = false;

  this._canvas.addEventListener('mousedown', this._handleMouseDown);
  this._canvas.addEventListener('mousemove', this._handleMouseMove);
  document.addEventListener('mouseup', this._handleMouseUp);
};

SignaturePad.prototype._handleTouchEvents = function () {
  // Pass touch events to canvas element on mobile IE11 and Edge.
  this._canvas.style.msTouchAction = 'none';
  this._canvas.style.touchAction = 'none';

  this._canvas.addEventListener('touchstart', this._handleTouchStart);
  this._canvas.addEventListener('touchmove', this._handleTouchMove);
  this._canvas.addEventListener('touchend', this._handleTouchEnd);
};

SignaturePad.prototype._reset = function () {
  this.points = [];
  this._lastVelocity = 0;
  this._lastWidth = (this.minWidth + this.maxWidth) / 2;
  this._ctx.fillStyle = this.penColor;
};

SignaturePad.prototype._createPoint = function (x, y, time) {
  var rect = this._canvas.getBoundingClientRect();

  return new Point(x - rect.left, y - rect.top, time || new Date().getTime());
};

SignaturePad.prototype._addPoint = function (point) {
  var points = this.points;
  var tmp = void 0;

  points.push(point);

  if (points.length > 2) {
    // To reduce the initial lag make it work with 3 points
    // by copying the first point to the beginning.
    if (points.length === 3) points.unshift(points[0]);

    tmp = this._calculateCurveControlPoints(points[0], points[1], points[2]);
    var c2 = tmp.c2;
    tmp = this._calculateCurveControlPoints(points[1], points[2], points[3]);
    var c3 = tmp.c1;
    var curve = new Bezier(points[1], c2, c3, points[2]);
    var widths = this._calculateCurveWidths(curve);

    // Remove the first element from the list,
    // so that we always have no more than 4 points in points array.
    points.shift();

    return { curve: curve, widths: widths };
  }

  return {};
};

SignaturePad.prototype._calculateCurveControlPoints = function (s1, s2, s3) {
  var dx1 = s1.x - s2.x;
  var dy1 = s1.y - s2.y;
  var dx2 = s2.x - s3.x;
  var dy2 = s2.y - s3.y;

  var m1 = { x: (s1.x + s2.x) / 2.0, y: (s1.y + s2.y) / 2.0 };
  var m2 = { x: (s2.x + s3.x) / 2.0, y: (s2.y + s3.y) / 2.0 };

  var l1 = Math.sqrt(dx1 * dx1 + dy1 * dy1);
  var l2 = Math.sqrt(dx2 * dx2 + dy2 * dy2);

  var dxm = m1.x - m2.x;
  var dym = m1.y - m2.y;

  var k = l2 / (l1 + l2);
  var cm = { x: m2.x + dxm * k, y: m2.y + dym * k };

  var tx = s2.x - cm.x;
  var ty = s2.y - cm.y;

  return {
    c1: new Point(m1.x + tx, m1.y + ty),
    c2: new Point(m2.x + tx, m2.y + ty)
  };
};

SignaturePad.prototype._calculateCurveWidths = function (curve) {
  var startPoint = curve.startPoint;
  var endPoint = curve.endPoint;
  var widths = { start: null, end: null };

  var velocity = this.velocityFilterWeight * endPoint.velocityFrom(startPoint) + (1 - this.velocityFilterWeight) * this._lastVelocity;

  var newWidth = this._strokeWidth(velocity);

  widths.start = this._lastWidth;
  widths.end = newWidth;

  this._lastVelocity = velocity;
  this._lastWidth = newWidth;

  return widths;
};

SignaturePad.prototype._strokeWidth = function (velocity) {
  return Math.max(this.maxWidth / (velocity + 1), this.minWidth);
};

SignaturePad.prototype._drawPoint = function (x, y, size) {
  var ctx = this._ctx;

  ctx.moveTo(x, y);
  ctx.arc(x, y, size, 0, 2 * Math.PI, false);
  this._isEmpty = false;
};

SignaturePad.prototype._drawCurve = function (curve, startWidth, endWidth) {
  var ctx = this._ctx;
  var widthDelta = endWidth - startWidth;
  var drawSteps = Math.floor(curve.length());

  ctx.beginPath();

  for (var i = 0; i < drawSteps; i += 1) {
    // Calculate the Bezier (x, y) coordinate for this step.
    var t = i / drawSteps;
    var tt = t * t;
    var ttt = tt * t;
    var u = 1 - t;
    var uu = u * u;
    var uuu = uu * u;

    var x = uuu * curve.startPoint.x;
    x += 3 * uu * t * curve.control1.x;
    x += 3 * u * tt * curve.control2.x;
    x += ttt * curve.endPoint.x;

    var y = uuu * curve.startPoint.y;
    y += 3 * uu * t * curve.control1.y;
    y += 3 * u * tt * curve.control2.y;
    y += ttt * curve.endPoint.y;

    var width = startWidth + ttt * widthDelta;
    this._drawPoint(x, y, width);
  }

  ctx.closePath();
  ctx.fill();
};

SignaturePad.prototype._drawDot = function (point) {
  var ctx = this._ctx;
  var width = typeof this.dotSize === 'function' ? this.dotSize() : this.dotSize;

  ctx.beginPath();
  this._drawPoint(point.x, point.y, width);
  ctx.closePath();
  ctx.fill();
};

SignaturePad.prototype._fromData = function (pointGroups, drawCurve, drawDot) {
  for (var i = 0; i < pointGroups.length; i += 1) {
    var group = pointGroups[i];

    if (group.length > 1) {
      for (var j = 0; j < group.length; j += 1) {
        var rawPoint = group[j];
        var point = new Point(rawPoint.x, rawPoint.y, rawPoint.time);
        var color = rawPoint.color;

        if (j === 0) {
          // First point in a group. Nothing to draw yet.

          // All points in the group have the same color, so it's enough to set
          // penColor just at the beginning.
          this.penColor = color;
          this._reset();

          this._addPoint(point);
        } else if (j !== group.length - 1) {
          // Middle point in a group.
          var _addPoint2 = this._addPoint(point),
              curve = _addPoint2.curve,
              widths = _addPoint2.widths;

          if (curve && widths) {
            drawCurve(curve, widths, color);
          }
        } else {
          // Last point in a group. Do nothing.
        }
      }
    } else {
      this._reset();
      var _rawPoint = group[0];
      drawDot(_rawPoint);
    }
  }
};

SignaturePad.prototype._toSVG = function () {
  var _this2 = this;

  var pointGroups = this._data;
  var canvas = this._canvas;
  var ratio = Math.max(window.devicePixelRatio || 1, 1);
  var minX = 0;
  var minY = 0;
  var maxX = canvas.width / ratio;
  var maxY = canvas.height / ratio;
  var svg = document.createElementNS('http://www.w3.org/2000/svg', 'svg');

  svg.setAttributeNS(null, 'width', canvas.width);
  svg.setAttributeNS(null, 'height', canvas.height);

  this._fromData(pointGroups, function (curve, widths, color) {
    var path = document.createElement('path');

    // Need to check curve for NaN values, these pop up when drawing
    // lines on the canvas that are not continuous. E.g. Sharp corners
    // or stopping mid-stroke and than continuing without lifting mouse.
    if (!isNaN(curve.control1.x) && !isNaN(curve.control1.y) && !isNaN(curve.control2.x) && !isNaN(curve.control2.y)) {
      var attr = 'M ' + curve.startPoint.x.toFixed(3) + ',' + curve.startPoint.y.toFixed(3) + ' ' + ('C ' + curve.control1.x.toFixed(3) + ',' + curve.control1.y.toFixed(3) + ' ') + (curve.control2.x.toFixed(3) + ',' + curve.control2.y.toFixed(3) + ' ') + (curve.endPoint.x.toFixed(3) + ',' + curve.endPoint.y.toFixed(3));

      path.setAttribute('d', attr);
      path.setAttribute('stroke-width', (widths.end * 2.25).toFixed(3));
      path.setAttribute('stroke', color);
      path.setAttribute('fill', 'none');
      path.setAttribute('stroke-linecap', 'round');

      svg.appendChild(path);
    }
  }, function (rawPoint) {
    var circle = document.createElement('circle');
    var dotSize = typeof _this2.dotSize === 'function' ? _this2.dotSize() : _this2.dotSize;
    circle.setAttribute('r', dotSize);
    circle.setAttribute('cx', rawPoint.x);
    circle.setAttribute('cy', rawPoint.y);
    circle.setAttribute('fill', rawPoint.color);

    svg.appendChild(circle);
  });

  var prefix = 'data:image/svg+xml;base64,';
  var header = '<svg' + ' xmlns="http://www.w3.org/2000/svg"' + ' xmlns:xlink="http://www.w3.org/1999/xlink"' + (' viewBox="' + minX + ' ' + minY + ' ' + maxX + ' ' + maxY + '"') + (' width="' + maxX + '"') + (' height="' + maxY + '"') + '>';
  var body = svg.innerHTML;

  // IE hack for missing innerHTML property on SVGElement
  if (body === undefined) {
    var dummy = document.createElement('dummy');
    var nodes = svg.childNodes;
    dummy.innerHTML = '';

    for (var i = 0; i < nodes.length; i += 1) {
      dummy.appendChild(nodes[i].cloneNode(true));
    }

    body = dummy.innerHTML;
  }

  var footer = '</svg>';
  var data = header + body + footer;

  return prefix + btoa(data);
};

SignaturePad.prototype.fromData = function (pointGroups) {
  var _this3 = this;

  this.clear();

  this._fromData(pointGroups, function (curve, widths) {
    return _this3._drawCurve(curve, widths.start, widths.end);
  }, function (rawPoint) {
    return _this3._drawDot(rawPoint);
  });

  this._data = pointGroups;
};

SignaturePad.prototype.toData = function () {
  return this._data;
};

/* harmony default export */ __webpack_exports__["default"] = (SignaturePad);


/***/ }),

/***/ "./node_modules/webpack/buildin/global.js":
/*!***********************************!*\
  !*** (webpack)/buildin/global.js ***!
  \***********************************/
/*! no static exports found */
/***/ (function(module, exports) {

var g;

// This works in non-strict mode
g = (function() {
	return this;
})();

try {
	// This works if eval is allowed (see CSP)
	g = g || new Function("return this")();
} catch (e) {
	// This works if the window reference is available
	if (typeof window === "object") g = window;
}

// g can still be undefined, but nothing to do about it...
// We return undefined, instead of nothing here, so it's
// easier to handle this case. if(!global) { ...}

module.exports = g;


/***/ }),

/***/ "./src/actions/action.ts":
/*!*******************************!*\
  !*** ./src/actions/action.ts ***!
  \*******************************/
/*! exports provided: Action */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "Action", function() { return Action; });
/* harmony import */ var _base__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../base */ "./src/base.ts");
/* harmony import */ var _jsonobject__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../jsonobject */ "./src/jsonobject.ts");
/* harmony import */ var _utils_cssClassBuilder__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../utils/cssClassBuilder */ "./src/utils/cssClassBuilder.ts");
/* harmony import */ var _container__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./container */ "./src/actions/container.ts");
var __extends = (undefined && undefined.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __decorate = (undefined && undefined.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};




var Action = /** @class */ (function (_super) {
    __extends(Action, _super);
    function Action(innerItem) {
        var _this = _super.call(this) || this;
        _this.innerItem = innerItem;
        _this.iconSize = 24;
        //Object.assign(this, item) to support IE11
        if (!!innerItem) {
            for (var key in innerItem) {
                _this[key] = innerItem[key];
            }
        }
        return _this;
    }
    Action.prototype.raiseUpdate = function () {
        this.updateCallback && this.updateCallback();
    };
    Object.defineProperty(Action.prototype, "cssClasses", {
        get: function () {
            return this.cssClassesValue || _container__WEBPACK_IMPORTED_MODULE_3__["defaultActionBarCss"];
        },
        set: function (val) {
            this.cssClassesValue = val;
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(Action.prototype, "disabled", {
        get: function () {
            return this.enabled !== undefined && !this.enabled;
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(Action.prototype, "hasTitle", {
        get: function () {
            return (((this.mode != "small" &&
                (this.showTitle || this.showTitle === undefined)) ||
                !this.iconName) &&
                !!this.title);
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(Action.prototype, "isVisible", {
        get: function () {
            return this.visible && this.mode !== "popup";
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(Action.prototype, "canShrink", {
        get: function () {
            return !!this.iconName;
        },
        enumerable: false,
        configurable: true
    });
    Action.prototype.getActionRootCss = function () {
        return new _utils_cssClassBuilder__WEBPACK_IMPORTED_MODULE_2__["CssClassBuilder"]()
            .append("sv-action")
            .append(this.css)
            .append("sv-action--space", this.needSpace)
            .append("sv-action--hidden", !this.isVisible)
            .toString();
    };
    Action.prototype.getActionBarItemTitleCss = function () {
        return new _utils_cssClassBuilder__WEBPACK_IMPORTED_MODULE_2__["CssClassBuilder"]()
            .append(this.cssClasses.itemTitle)
            .append(this.cssClasses.itemTitleWithIcon, !!this.iconName)
            .toString();
    };
    Action.prototype.getActionBarItemCss = function () {
        return new _utils_cssClassBuilder__WEBPACK_IMPORTED_MODULE_2__["CssClassBuilder"]()
            .append(this.cssClasses.item)
            .append(this.cssClasses.itemAsIcon, !this.hasTitle)
            .append(this.cssClasses.itemActive, !!this.active)
            .append(this.cssClasses.itemPressed, !!this.pressed)
            .append(this.innerCss)
            .toString();
    };
    __decorate([
        Object(_jsonobject__WEBPACK_IMPORTED_MODULE_1__["property"])()
    ], Action.prototype, "id", void 0);
    __decorate([
        Object(_jsonobject__WEBPACK_IMPORTED_MODULE_1__["property"])()
    ], Action.prototype, "iconName", void 0);
    __decorate([
        Object(_jsonobject__WEBPACK_IMPORTED_MODULE_1__["property"])()
    ], Action.prototype, "iconSize", void 0);
    __decorate([
        Object(_jsonobject__WEBPACK_IMPORTED_MODULE_1__["property"])({
            defaultValue: true, onSet: function (_, target) {
                target.raiseUpdate();
            }
        })
    ], Action.prototype, "visible", void 0);
    __decorate([
        Object(_jsonobject__WEBPACK_IMPORTED_MODULE_1__["property"])()
    ], Action.prototype, "title", void 0);
    __decorate([
        Object(_jsonobject__WEBPACK_IMPORTED_MODULE_1__["property"])()
    ], Action.prototype, "tooltip", void 0);
    __decorate([
        Object(_jsonobject__WEBPACK_IMPORTED_MODULE_1__["property"])()
    ], Action.prototype, "enabled", void 0);
    __decorate([
        Object(_jsonobject__WEBPACK_IMPORTED_MODULE_1__["property"])()
    ], Action.prototype, "showTitle", void 0);
    __decorate([
        Object(_jsonobject__WEBPACK_IMPORTED_MODULE_1__["property"])()
    ], Action.prototype, "action", void 0);
    __decorate([
        Object(_jsonobject__WEBPACK_IMPORTED_MODULE_1__["property"])()
    ], Action.prototype, "css", void 0);
    __decorate([
        Object(_jsonobject__WEBPACK_IMPORTED_MODULE_1__["property"])()
    ], Action.prototype, "innerCss", void 0);
    __decorate([
        Object(_jsonobject__WEBPACK_IMPORTED_MODULE_1__["property"])()
    ], Action.prototype, "data", void 0);
    __decorate([
        Object(_jsonobject__WEBPACK_IMPORTED_MODULE_1__["property"])()
    ], Action.prototype, "popupModel", void 0);
    __decorate([
        Object(_jsonobject__WEBPACK_IMPORTED_MODULE_1__["property"])()
    ], Action.prototype, "needSeparator", void 0);
    __decorate([
        Object(_jsonobject__WEBPACK_IMPORTED_MODULE_1__["property"])()
    ], Action.prototype, "active", void 0);
    __decorate([
        Object(_jsonobject__WEBPACK_IMPORTED_MODULE_1__["property"])()
    ], Action.prototype, "pressed", void 0);
    __decorate([
        Object(_jsonobject__WEBPACK_IMPORTED_MODULE_1__["property"])()
    ], Action.prototype, "template", void 0);
    __decorate([
        Object(_jsonobject__WEBPACK_IMPORTED_MODULE_1__["property"])()
    ], Action.prototype, "component", void 0);
    __decorate([
        Object(_jsonobject__WEBPACK_IMPORTED_MODULE_1__["property"])()
    ], Action.prototype, "items", void 0);
    __decorate([
        Object(_jsonobject__WEBPACK_IMPORTED_MODULE_1__["property"])()
    ], Action.prototype, "visibleIndex", void 0);
    __decorate([
        Object(_jsonobject__WEBPACK_IMPORTED_MODULE_1__["property"])({ defaultValue: "large" })
    ], Action.prototype, "mode", void 0);
    __decorate([
        Object(_jsonobject__WEBPACK_IMPORTED_MODULE_1__["property"])()
    ], Action.prototype, "disableTabStop", void 0);
    __decorate([
        Object(_jsonobject__WEBPACK_IMPORTED_MODULE_1__["property"])()
    ], Action.prototype, "disableShrink", void 0);
    __decorate([
        Object(_jsonobject__WEBPACK_IMPORTED_MODULE_1__["property"])({ defaultValue: false })
    ], Action.prototype, "needSpace", void 0);
    return Action;
}(_base__WEBPACK_IMPORTED_MODULE_0__["Base"]));



/***/ }),

/***/ "./src/actions/adaptive-container.ts":
/*!*******************************************!*\
  !*** ./src/actions/adaptive-container.ts ***!
  \*******************************************/
/*! exports provided: AdaptiveActionContainer */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "AdaptiveActionContainer", function() { return AdaptiveActionContainer; });
/* harmony import */ var _utils_responsivity_manager__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../utils/responsivity-manager */ "./src/utils/responsivity-manager.ts");
/* harmony import */ var _list__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../list */ "./src/list.ts");
/* harmony import */ var _popup__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../popup */ "./src/popup.ts");
/* harmony import */ var _action__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./action */ "./src/actions/action.ts");
/* harmony import */ var _container__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./container */ "./src/actions/container.ts");
var __extends = (undefined && undefined.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();





var AdaptiveActionContainer = /** @class */ (function (_super) {
    __extends(AdaptiveActionContainer, _super);
    function AdaptiveActionContainer() {
        var _this = _super.call(this) || this;
        _this.minVisibleItemsCount = 0;
        _this.invisibleItemsListModel = new _list__WEBPACK_IMPORTED_MODULE_1__["ListModel"]([], function (item) {
            _this.invisibleItemSelected(item);
            _this.dotsItemPopupModel.toggleVisibility();
        }, false);
        _this.dotsItemPopupModel = new _popup__WEBPACK_IMPORTED_MODULE_2__["PopupModel"]("sv-list", {
            model: _this.invisibleItemsListModel
        });
        _this.dotsItem = new _action__WEBPACK_IMPORTED_MODULE_3__["Action"]({
            id: "dotsItem-id",
            component: "sv-action-bar-item-dropdown",
            css: "sv-dots",
            innerCss: "sv-dots__item",
            iconName: "icon-more",
            visible: false,
            action: function (item) {
                _this.dotsItemPopupModel.toggleVisibility();
            },
            popupModel: _this.dotsItemPopupModel
        });
        _this.dotsItemPopupModel.onHide = function () {
            _this.dotsItem.pressed = false;
        };
        _this.dotsItemPopupModel.onShow = function () {
            _this.dotsItem.pressed = true;
        };
        return _this;
    }
    AdaptiveActionContainer.prototype.invisibleItemSelected = function (item) {
        if (!!item && typeof item.action === "function") {
            item.action();
        }
    };
    AdaptiveActionContainer.prototype.hideItemsGreaterN = function (visibleItemsCount) {
        visibleItemsCount = Math.max(visibleItemsCount, this.minVisibleItemsCount);
        var invisibleItems = [];
        this.visibleActions.forEach(function (item) {
            if (visibleItemsCount <= 0) {
                item.mode = "popup";
                invisibleItems.push(item.innerItem);
            }
            visibleItemsCount--;
        });
        this.invisibleItemsListModel.setItems(invisibleItems);
    };
    AdaptiveActionContainer.prototype.getVisibleItemsCount = function (availableSize) {
        var itemsSizes = this.visibleActions.map(function (item) { return item.minDimension; });
        var currSize = 0;
        for (var i = 0; i < itemsSizes.length; i++) {
            currSize += itemsSizes[i];
            if (currSize > availableSize)
                return i;
        }
        return i;
    };
    AdaptiveActionContainer.prototype.updateItemMode = function (availableSize, itemsSize) {
        var items = this.visibleActions;
        for (var index = items.length - 1; index >= 0; index--) {
            if (itemsSize > availableSize && !items[index].disableShrink) {
                itemsSize -= items[index].maxDimension - items[index].minDimension;
                items[index].mode = "small";
            }
            else {
                items[index].mode = "large";
            }
        }
    };
    AdaptiveActionContainer.prototype.onSet = function () {
        var _this = this;
        this.actions.forEach(function (action) { return action.updateCallback = function () { return _this.raiseUpdate(false); }; });
        _super.prototype.onSet.call(this);
    };
    AdaptiveActionContainer.prototype.onPush = function (item) {
        var _this = this;
        item.updateCallback = function () { return _this.raiseUpdate(false); };
        _super.prototype.onPush.call(this, item);
    };
    AdaptiveActionContainer.prototype.getRenderedActions = function () {
        if (this.actions.length >= 2)
            return this.actions.concat([this.dotsItem]);
        return this.actions;
    };
    AdaptiveActionContainer.prototype.fit = function (dimension, dotsItemSize) {
        if (dimension <= 0)
            return;
        this.dotsItem.visible = false;
        var minSize = 0;
        var maxSize = 0;
        var items = this.visibleActions;
        items.forEach(function (item) {
            minSize += item.minDimension;
            maxSize += item.maxDimension;
        });
        if (dimension >= maxSize) {
            items.forEach(function (item) { return (item.mode = "large"); });
        }
        else if (dimension < minSize) {
            items.forEach(function (item) { return (item.mode = "small"); });
            this.hideItemsGreaterN(this.getVisibleItemsCount(dimension - dotsItemSize));
            this.dotsItem.visible = true;
        }
        else {
            this.updateItemMode(dimension, maxSize);
        }
    };
    AdaptiveActionContainer.prototype.initResponsivityManager = function (container) {
        this.responsivityManager = new _utils_responsivity_manager__WEBPACK_IMPORTED_MODULE_0__["ResponsivityManager"](container, this, ".sv-action:not(.sv-dots)>.sv-action__content");
    };
    AdaptiveActionContainer.prototype.resetResponsivityManager = function () {
        if (!!this.responsivityManager) {
            this.responsivityManager.dispose();
            this.responsivityManager = undefined;
        }
    };
    AdaptiveActionContainer.prototype.dispose = function () {
        _super.prototype.dispose.call(this);
        this.resetResponsivityManager();
    };
    return AdaptiveActionContainer;
}(_container__WEBPACK_IMPORTED_MODULE_4__["ActionContainer"]));



/***/ }),

/***/ "./src/actions/container.ts":
/*!**********************************!*\
  !*** ./src/actions/container.ts ***!
  \**********************************/
/*! exports provided: defaultActionBarCss, ActionContainer */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "defaultActionBarCss", function() { return defaultActionBarCss; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "ActionContainer", function() { return ActionContainer; });
/* harmony import */ var _jsonobject__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../jsonobject */ "./src/jsonobject.ts");
/* harmony import */ var _base__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../base */ "./src/base.ts");
/* harmony import */ var _action__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./action */ "./src/actions/action.ts");
var __extends = (undefined && undefined.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __decorate = (undefined && undefined.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};



var defaultActionBarCss = {
    root: "sv-action-bar",
    item: "sv-action-bar-item",
    itemActive: "sv-action-bar-item--active",
    itemPressed: "sv-action-bar-item--pressed",
    itemIcon: "sv-action-bar-item__icon",
    itemTitle: "sv-action-bar-item__title",
    itemTitleWithIcon: "sv-action-bar-item__title--with-icon",
};
var ActionContainer = /** @class */ (function (_super) {
    __extends(ActionContainer, _super);
    function ActionContainer() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    ActionContainer.prototype.getRenderedActions = function () {
        return this.actions;
    };
    ActionContainer.prototype.raiseUpdate = function (isResetInitialized) {
        this.updateCallback && this.updateCallback(isResetInitialized);
    };
    ActionContainer.prototype.onSet = function () {
        var _this = this;
        this.actions.forEach(function (item) { _this.setActionCssClasses(item); });
        this.raiseUpdate(true);
    };
    ActionContainer.prototype.onPush = function (item) {
        this.setActionCssClasses(item);
        this.raiseUpdate(true);
    };
    ActionContainer.prototype.onRemove = function (item) {
        this.raiseUpdate(true);
    };
    ActionContainer.prototype.setActionCssClasses = function (item) {
        item.cssClasses = this.cssClasses;
    };
    Object.defineProperty(ActionContainer.prototype, "hasActions", {
        get: function () {
            return (this.actions || []).length > 0;
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(ActionContainer.prototype, "renderedActions", {
        get: function () {
            return this.getRenderedActions();
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(ActionContainer.prototype, "visibleActions", {
        get: function () {
            return this.actions.filter(function (action) { return action.visible !== false; });
        },
        enumerable: false,
        configurable: true
    });
    ActionContainer.prototype.getRootCss = function () {
        return this.cssClasses.root + (!!this.containerCss ? " " + this.containerCss : "");
    };
    Object.defineProperty(ActionContainer.prototype, "cssClasses", {
        get: function () {
            return this.cssClassesValue || defaultActionBarCss;
        },
        set: function (val) {
            this.cssClassesValue = val;
        },
        enumerable: false,
        configurable: true
    });
    ActionContainer.prototype.sortItems = function (items) {
        return []
            .concat(items.filter(function (item) { return item.visibleIndex >= 0 || item.visibleIndex === undefined; }))
            .sort(function (firstItem, secondItem) {
            return firstItem.visibleIndex - secondItem.visibleIndex;
        });
    };
    ActionContainer.prototype.setItems = function (items, sortByVisibleIndex) {
        if (sortByVisibleIndex === void 0) { sortByVisibleIndex = true; }
        var actions = items.map(function (item) { return (item instanceof _action__WEBPACK_IMPORTED_MODULE_2__["Action"] ? item : new _action__WEBPACK_IMPORTED_MODULE_2__["Action"](item)); });
        if (sortByVisibleIndex) {
            this.actions = this.sortItems(actions);
        }
        else {
            this.actions = actions;
        }
    };
    ActionContainer.prototype.initResponsivityManager = function (container) {
        return;
    };
    ActionContainer.prototype.resetResponsivityManager = function () { };
    __decorate([
        Object(_jsonobject__WEBPACK_IMPORTED_MODULE_0__["propertyArray"])({
            onSet: function (_, target) {
                target.onSet();
            },
            onPush: function (item, i, target) {
                target.onPush(item);
            },
            onRemove: function (item, i, target) {
                target.onRemove(item);
            }
        })
    ], ActionContainer.prototype, "actions", void 0);
    return ActionContainer;
}(_base__WEBPACK_IMPORTED_MODULE_1__["Base"]));



/***/ }),

/***/ "./src/base.ts":
/*!*********************!*\
  !*** ./src/base.ts ***!
  \*********************/
/*! exports provided: Bindings, Dependencies, ComputedUpdater, Base, ArrayChanges, Event, EventBase */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "Bindings", function() { return Bindings; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "Dependencies", function() { return Dependencies; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "ComputedUpdater", function() { return ComputedUpdater; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "Base", function() { return Base; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "ArrayChanges", function() { return ArrayChanges; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "Event", function() { return Event; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "EventBase", function() { return EventBase; });
/* harmony import */ var _localizablestring__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./localizablestring */ "./src/localizablestring.ts");
/* harmony import */ var _helpers__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./helpers */ "./src/helpers.ts");
/* harmony import */ var _jsonobject__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./jsonobject */ "./src/jsonobject.ts");
/* harmony import */ var _settings__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./settings */ "./src/settings.ts");
var __extends = (undefined && undefined.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __spreadArray = (undefined && undefined.__spreadArray) || function (to, from, pack) {
    if (pack || arguments.length === 2) for (var i = 0, l = from.length, ar; i < l; i++) {
        if (ar || !(i in from)) {
            if (!ar) ar = Array.prototype.slice.call(from, 0, i);
            ar[i] = from[i];
        }
    }
    return to.concat(ar || Array.prototype.slice.call(from));
};




var Bindings = /** @class */ (function () {
    function Bindings(obj) {
        this.obj = obj;
        this.properties = null;
        this.values = null;
    }
    Bindings.prototype.getType = function () {
        return "bindings";
    };
    Bindings.prototype.getNames = function () {
        var res = [];
        this.fillProperties();
        for (var i = 0; i < this.properties.length; i++) {
            if (this.properties[i].isVisible("", this.obj)) {
                res.push(this.properties[i].name);
            }
        }
        return res;
    };
    Bindings.prototype.getProperties = function () {
        var res = [];
        this.fillProperties();
        for (var i = 0; i < this.properties.length; i++) {
            res.push(this.properties[i]);
        }
        return res;
    };
    Bindings.prototype.setBinding = function (propertyName, valueName) {
        if (!this.values)
            this.values = {};
        if (!!valueName) {
            this.values[propertyName] = valueName;
        }
        else {
            delete this.values[propertyName];
            if (Object.keys(this.values).length == 0) {
                this.values = null;
            }
        }
    };
    Bindings.prototype.clearBinding = function (propertyName) {
        this.setBinding(propertyName, "");
    };
    Bindings.prototype.isEmpty = function () {
        return !this.values;
    };
    Bindings.prototype.getValueNameByPropertyName = function (propertyName) {
        if (!this.values)
            return undefined;
        return this.values[propertyName];
    };
    Bindings.prototype.getPropertiesByValueName = function (valueName) {
        if (!this.values)
            return [];
        var res = [];
        for (var key in this.values) {
            if (this.values[key] == valueName) {
                res.push(key);
            }
        }
        return res;
    };
    Bindings.prototype.getJson = function () {
        if (this.isEmpty())
            return null;
        var res = {};
        for (var key in this.values) {
            res[key] = this.values[key];
        }
        return res;
    };
    Bindings.prototype.setJson = function (value) {
        this.values = null;
        if (!value)
            return;
        this.values = {};
        for (var key in value) {
            this.values[key] = value[key];
        }
    };
    Bindings.prototype.fillProperties = function () {
        if (this.properties !== null)
            return;
        this.properties = [];
        var objProperties = _jsonobject__WEBPACK_IMPORTED_MODULE_2__["Serializer"].getPropertiesByObj(this.obj);
        for (var i = 0; i < objProperties.length; i++) {
            if (objProperties[i].isBindable) {
                this.properties.push(objProperties[i]);
            }
        }
    };
    return Bindings;
}());

var Dependencies = /** @class */ (function () {
    function Dependencies(currentDependency, target, property) {
        this.currentDependency = currentDependency;
        this.target = target;
        this.property = property;
        this.dependencies = [];
        this.id = "" + (++Dependencies.DependenciesCount);
    }
    Dependencies.prototype.addDependency = function (target, property) {
        if (this.target === target && this.property === property)
            return;
        if (this.dependencies.some(function (dependency) { return dependency.obj === target && dependency.prop === property; }))
            return;
        this.dependencies.push({
            obj: target,
            prop: property,
            id: this.id
        });
        target.registerFunctionOnPropertiesValueChanged([property], this.currentDependency, this.id);
    };
    Dependencies.prototype.dispose = function () {
        this.dependencies.forEach(function (dependency) {
            dependency.obj.unRegisterFunctionOnPropertiesValueChanged([dependency.prop], dependency.id);
        });
    };
    Dependencies.DependenciesCount = 0;
    return Dependencies;
}());

var ComputedUpdater = /** @class */ (function () {
    function ComputedUpdater(_updater) {
        this._updater = _updater;
        this.dependencies = undefined;
        this.type = ComputedUpdater.ComputedUpdaterType;
    }
    Object.defineProperty(ComputedUpdater.prototype, "updater", {
        get: function () {
            return this._updater;
        },
        enumerable: false,
        configurable: true
    });
    ComputedUpdater.prototype.setDependencies = function (dependencies) {
        this.clearDependencies();
        this.dependencies = dependencies;
    };
    ComputedUpdater.prototype.getDependencies = function () {
        return this.dependencies;
    };
    ComputedUpdater.prototype.clearDependencies = function () {
        if (this.dependencies) {
            this.dependencies.dispose();
            this.dependencies = undefined;
        }
    };
    ComputedUpdater.prototype.dispose = function () {
        this.clearDependencies();
    };
    ComputedUpdater.ComputedUpdaterType = "__dependency_computed";
    return ComputedUpdater;
}());

/**
 * The base class for SurveyJS objects.
 */
var Base = /** @class */ (function () {
    function Base() {
        this.propertyHash = {};
        this.eventList = [];
        this.isLoadingFromJsonValue = false;
        this.loadingOwner = null;
        /**
         * Event that raise on property change of the sender object
         * sender - the object that owns the property
         * options.name - the property name that has been changed
         * options.oldValue - old value. Please note, it equals to options.newValue if property is an array
         * options.newValue - new value.
         */
        this.onPropertyChanged = this.addEvent();
        /**
         * Event that raised on changing property of the ItemValue object.
         * sender - the object that owns the property
         * options.propertyName - the property name to which ItemValue array is belong. It can be "choices" for dropdown question
         * options.obj - the instance of ItemValue object which property has been changed
         * options.name - the property of ItemObject that has been changed
         * options.oldValue - old value
         * options.newValue - new value
         */
        this.onItemValuePropertyChanged = this.addEvent();
        this.isCreating = true;
        this.bindingsValue = new Bindings(this);
        _jsonobject__WEBPACK_IMPORTED_MODULE_2__["CustomPropertiesCollection"].createProperties(this);
        this.onBaseCreating();
        this.isCreating = false;
    }
    Base.finishCollectDependencies = function () {
        var deps = Base.currentDependencis;
        Base.currentDependencis = undefined;
        return deps;
    };
    Base.startCollectDependencies = function (updater, target, property) {
        if (Base.currentDependencis !== undefined) {
            throw new Error("Attempt to collect nested dependencies. Nested dependencies are not supported.");
        }
        Base.currentDependencis = new Dependencies(updater, target, property);
    };
    Base.collectDependency = function (target, property) {
        if (Base.currentDependencis === undefined)
            return;
        Base.currentDependencis.addDependency(target, property);
    };
    Object.defineProperty(Base, "commentPrefix", {
        get: function () {
            return _settings__WEBPACK_IMPORTED_MODULE_3__["settings"].commentPrefix;
        },
        set: function (val) {
            _settings__WEBPACK_IMPORTED_MODULE_3__["settings"].commentPrefix = val;
        },
        enumerable: false,
        configurable: true
    });
    /**
     * Returns true if a value undefined, null, empty string or empty array.
     *
     * @param value
     * @param trimString a boolean parameter, default value true. If true then it trims the string and functions returns true for a string that contains white spaces only.
     */
    Base.prototype.isValueEmpty = function (value, trimString) {
        if (trimString === void 0) { trimString = true; }
        if (trimString) {
            value = this.trimValue(value);
        }
        return _helpers__WEBPACK_IMPORTED_MODULE_1__["Helpers"].isValueEmpty(value);
    };
    Base.prototype.trimValue = function (value) {
        if (!!value && (typeof value === "string" || value instanceof String))
            return value.trim();
        return value;
    };
    Base.prototype.IsPropertyEmpty = function (value) {
        return value !== "" && this.isValueEmpty(value);
    };
    Base.prototype.dispose = function () {
        for (var i = 0; i < this.eventList.length; i++) {
            this.eventList[i].clear();
        }
        this.onPropertyValueChangedCallback = undefined;
        this.isDisposedValue = true;
    };
    Object.defineProperty(Base.prototype, "isDisposed", {
        get: function () {
            return this.isDisposedValue === true;
        },
        enumerable: false,
        configurable: true
    });
    Base.prototype.addEvent = function () {
        var res = new EventBase();
        this.eventList.push(res);
        return res;
    };
    Base.prototype.onBaseCreating = function () { };
    /**
     * Returns the type of the object as a string as it represents in the json. It should be in lowcase.
     */
    Base.prototype.getType = function () {
        return "base";
    };
    Base.prototype.getSurvey = function (isLive) {
        if (isLive === void 0) { isLive = false; }
        return null;
    };
    Object.defineProperty(Base.prototype, "inSurvey", {
        /**
         * Returns true if the object is inluded into survey, otherwise returns false.
         */
        get: function () {
            return !!this.getSurvey(true);
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(Base.prototype, "bindings", {
        get: function () {
            return this.bindingsValue;
        },
        enumerable: false,
        configurable: true
    });
    Base.prototype.checkBindings = function (valueName, value) { };
    Base.prototype.updateBindings = function (propertyName, value) {
        var valueName = this.bindings.getValueNameByPropertyName(propertyName);
        if (!!valueName) {
            this.updateBindingValue(valueName, value);
        }
    };
    Base.prototype.updateBindingValue = function (valueName, value) { };
    /**
     * Returns the element template name without prefix. Typically it equals to getType().
     * @see getType
     */
    Base.prototype.getTemplate = function () {
        return this.getType();
    };
    Object.defineProperty(Base.prototype, "isLoadingFromJson", {
        /**
         * Returns true if the object is loading from Json at the current moment.
         */
        get: function () {
            return this.isLoadingFromJsonValue || this.getIsLoadingFromJson();
        },
        enumerable: false,
        configurable: true
    });
    Base.prototype.getIsLoadingFromJson = function () {
        if (!!this.loadingOwner && this.loadingOwner.isLoadingFromJson)
            return true;
        return this.isLoadingFromJsonValue;
    };
    Base.prototype.startLoadingFromJson = function () {
        this.isLoadingFromJsonValue = true;
    };
    Base.prototype.endLoadingFromJson = function () {
        this.isLoadingFromJsonValue = false;
    };
    /**
     * Deserialized the current object into JSON
     * @see fromJSON
     */
    Base.prototype.toJSON = function () {
        return new _jsonobject__WEBPACK_IMPORTED_MODULE_2__["JsonObject"]().toJsonObject(this);
    };
    /**
     * Load object properties and elements. It doesn't reset properties that was changed before and they are not defined in the json parameter.
     * @param json the object JSON definition
     * @see toJSON
     */
    Base.prototype.fromJSON = function (json) {
        new _jsonobject__WEBPACK_IMPORTED_MODULE_2__["JsonObject"]().toObject(json, this);
        this.onSurveyLoad();
    };
    Base.prototype.onSurveyLoad = function () { };
    /**
     * Make a clone of the existing object. Create a new object of the same type and load all properties into it.
     */
    Base.prototype.clone = function () {
        var clonedObj = _jsonobject__WEBPACK_IMPORTED_MODULE_2__["Serializer"].createClass(this.getType());
        clonedObj.fromJSON(this.toJSON());
        return clonedObj;
    };
    /**
     * Returns the serializable property that belongs to this instance by property name. It returns null if the property is not exists.
     * @param propName property name
     * @returns
     */
    Base.prototype.getPropertyByName = function (propName) {
        return _jsonobject__WEBPACK_IMPORTED_MODULE_2__["Serializer"].findProperty(this.getType(), propName);
    };
    Base.prototype.isPropertyVisible = function (propName) {
        var prop = this.getPropertyByName(propName);
        return !!prop ? prop.isVisible("", this) : false;
    };
    Base.createProgressInfo = function () {
        return {
            questionCount: 0,
            answeredQuestionCount: 0,
            requiredQuestionCount: 0,
            requiredAnsweredQuestionCount: 0,
        };
    };
    Base.prototype.getProgressInfo = function () {
        return Base.createProgressInfo();
    };
    Base.prototype.localeChanged = function () { };
    Base.prototype.locStrsChanged = function () {
        if (!!this.arraysInfo) {
            for (var key in this.arraysInfo) {
                var item = this.arraysInfo[key];
                if (item && item.isItemValues) {
                    var arr = this.getPropertyValue(key);
                    if (arr && !!Base.itemValueLocStrChanged)
                        Base.itemValueLocStrChanged(arr);
                }
            }
        }
        if (!!this.localizableStrings) {
            for (var key in this.localizableStrings) {
                var item = this.getLocalizableString(key);
                if (item)
                    item.strChanged();
            }
        }
    };
    /**
     * Returns the property value by name
     * @param name property name
     */
    Base.prototype.getPropertyValue = function (name, defaultValue) {
        if (defaultValue === void 0) { defaultValue = null; }
        var res = this.getPropertyValueCore(this.propertyHash, name);
        if (this.IsPropertyEmpty(res)) {
            if (defaultValue != null)
                return defaultValue;
            var prop = _jsonobject__WEBPACK_IMPORTED_MODULE_2__["Serializer"].findProperty(this.getType(), name);
            if (!!prop && (!prop.isCustom || !this.isCreating)) {
                if (!this.IsPropertyEmpty(prop.defaultValue) &&
                    !Array.isArray(prop.defaultValue))
                    return prop.defaultValue;
                if (prop.type == "boolean" || prop.type == "switch")
                    return false;
                if (prop.isCustom && !!prop.onGetValue)
                    return prop.onGetValue(this);
            }
        }
        return res;
    };
    Base.prototype.getPropertyValueCore = function (propertiesHash, name) {
        Base.collectDependency(this, name);
        if (this.getPropertyValueCoreHandler)
            return this.getPropertyValueCoreHandler(propertiesHash, name);
        else
            return propertiesHash[name];
    };
    Base.prototype.geValueFromHash = function () {
        return this.propertyHash["value"];
    };
    Base.prototype.setPropertyValueCore = function (propertiesHash, name, val) {
        if (this.setPropertyValueCoreHandler) {
            if (!this.isDisposedValue) {
                this.setPropertyValueCoreHandler(propertiesHash, name, val);
            }
            else {
                // eslint-disable-next-line no-console
                console.warn("Attempt to set property '" + name + "' of a disposed object '" + this.getType() + "'");
            }
        }
        else
            propertiesHash[name] = val;
    };
    Object.defineProperty(Base.prototype, "isEditingSurveyElement", {
        get: function () {
            var survey = this.getSurvey();
            return !!survey && survey.isEditingSurveyElement;
        },
        enumerable: false,
        configurable: true
    });
    Base.prototype.iteratePropertiesHash = function (func) {
        var _this = this;
        var keys = [];
        for (var key in this.propertyHash) {
            if (key === "value" &&
                this.isEditingSurveyElement &&
                Array.isArray(this.value))
                continue;
            keys.push(key);
        }
        keys.forEach(function (key) { return func(_this.propertyHash, key); });
    };
    /**
     * set property value
     * @param name property name
     * @param val new property value
     */
    Base.prototype.setPropertyValue = function (name, val) {
        var oldValue = this.getPropertyValue(name);
        if (oldValue &&
            Array.isArray(oldValue) &&
            !!this.arraysInfo &&
            (!val || Array.isArray(val))) {
            if (this.isTwoValueEquals(oldValue, val))
                return;
            this.setArrayPropertyDirectly(name, val);
        }
        else {
            this.setPropertyValueDirectly(name, val);
            if (!this.isDisposedValue && !this.isTwoValueEquals(oldValue, val)) {
                this.propertyValueChanged(name, oldValue, val);
            }
        }
    };
    Base.prototype.setArrayPropertyDirectly = function (name, val, sendNotification) {
        if (sendNotification === void 0) { sendNotification = true; }
        var arrayInfo = this.arraysInfo[name];
        this.setArray(name, this.getPropertyValue(name), val, arrayInfo ? arrayInfo.isItemValues : false, arrayInfo ? sendNotification && arrayInfo.onPush : null);
    };
    Base.prototype.setPropertyValueDirectly = function (name, val) {
        this.setPropertyValueCore(this.propertyHash, name, val);
    };
    Base.prototype.clearPropertyValue = function (name) {
        this.setPropertyValueCore(this.propertyHash, name, null);
        delete this.propertyHash[name];
    };
    Base.prototype.onPropertyValueChangedCallback = function (name, oldValue, newValue, sender, arrayChanges) { };
    Base.prototype.itemValuePropertyChanged = function (item, name, oldValue, newValue) {
        this.onItemValuePropertyChanged.fire(this, {
            obj: item,
            name: name,
            oldValue: oldValue,
            newValue: newValue,
            propertyName: item.ownerPropertyName,
        });
    };
    Base.prototype.onPropertyValueChanged = function (name, oldValue, newValue) { };
    Base.prototype.propertyValueChanged = function (name, oldValue, newValue, arrayChanges, target) {
        if (this.isLoadingFromJson)
            return;
        this.updateBindings(name, newValue);
        this.onPropertyValueChanged(name, oldValue, newValue);
        this.onPropertyChanged.fire(this, {
            name: name,
            oldValue: oldValue,
            newValue: newValue,
        });
        this.doPropertyValueChangedCallback(name, oldValue, newValue, arrayChanges, this);
        if (!this.onPropChangeFunctions)
            return;
        for (var i = 0; i < this.onPropChangeFunctions.length; i++) {
            if (this.onPropChangeFunctions[i].name == name)
                this.onPropChangeFunctions[i].func(newValue);
        }
    };
    Object.defineProperty(Base.prototype, "isInternal", {
        get: function () {
            return false;
        },
        enumerable: false,
        configurable: true
    });
    Base.prototype.doPropertyValueChangedCallback = function (name, oldValue, newValue, arrayChanges, target) {
        if (this.isInternal)
            return;
        if (!target)
            target = this;
        var notifier = this.getSurvey();
        if (!notifier)
            notifier = this;
        if (!!notifier.onPropertyValueChangedCallback) {
            notifier.onPropertyValueChangedCallback(name, oldValue, newValue, target, arrayChanges);
        }
        if (notifier !== this && !!this.onPropertyValueChangedCallback) {
            this.onPropertyValueChangedCallback(name, oldValue, newValue, target, arrayChanges);
        }
    };
    /**
     * Register a function that will be called on a property value changed.
     * @param name the property name
     * @param func the function with no parameters that will be called on property changed.
     * @param key an optional parameter. If there is already a registered function for this property with the same key, it will be overwritten.
     */
    Base.prototype.registerFunctionOnPropertyValueChanged = function (name, func, key) {
        if (key === void 0) { key = null; }
        if (!this.onPropChangeFunctions) {
            this.onPropChangeFunctions = [];
        }
        if (key) {
            for (var i = 0; i < this.onPropChangeFunctions.length; i++) {
                var item = this.onPropChangeFunctions[i];
                if (item.name == name && item.key == key) {
                    item.func = func;
                    return;
                }
            }
        }
        this.onPropChangeFunctions.push({ name: name, func: func, key: key });
    };
    /**
     * Register a function that will be called on a property value changed from the names list.
     * @param names the list of properties names
     * @param func the function with no parameters that will be called on property changed.
     * @param key an optional parameter. If there is already a registered function for this property with the same key, it will be overwritten.
     */
    Base.prototype.registerFunctionOnPropertiesValueChanged = function (names, func, key) {
        if (key === void 0) { key = null; }
        for (var i = 0; i < names.length; i++) {
            this.registerFunctionOnPropertyValueChanged(names[i], func, key);
        }
    };
    /**
     * Unregister notification on property value changed
     * @param name the property name
     * @param key the key with which you have registered the notification for this property. It can be null.
     */
    Base.prototype.unRegisterFunctionOnPropertyValueChanged = function (name, key) {
        if (key === void 0) { key = null; }
        if (!this.onPropChangeFunctions)
            return;
        for (var i = 0; i < this.onPropChangeFunctions.length; i++) {
            var item = this.onPropChangeFunctions[i];
            if (item.name == name && item.key == key) {
                this.onPropChangeFunctions.splice(i, 1);
                return;
            }
        }
    };
    /**
     * Unregister notification on property value changed for all properties in the names list.
     * @param names the list of properties names
     * @param key the key with which you have registered the notification for this property. It can be null.
     */
    Base.prototype.unRegisterFunctionOnPropertiesValueChanged = function (names, key) {
        if (key === void 0) { key = null; }
        for (var i = 0; i < names.length; i++) {
            this.unRegisterFunctionOnPropertyValueChanged(names[i], key);
        }
    };
    Base.prototype.createCustomLocalizableObj = function (name) {
        var locStr = this.getLocalizableString(name);
        if (locStr || !this.getLocale)
            return;
        this.createLocalizableString(name, this, false, true);
    };
    Base.prototype.createLocalizableString = function (name, owner, useMarkDown, defaultStr) {
        var _this = this;
        if (useMarkDown === void 0) { useMarkDown = false; }
        if (defaultStr === void 0) { defaultStr = false; }
        var locStr = new _localizablestring__WEBPACK_IMPORTED_MODULE_0__["LocalizableString"](owner, useMarkDown, name);
        if (defaultStr) {
            locStr.localizationName = defaultStr === true ? name : defaultStr;
        }
        locStr.onStrChanged = function (oldValue, newValue) {
            _this.propertyValueChanged(name, oldValue, newValue);
        };
        if (!this.localizableStrings) {
            this.localizableStrings = {};
        }
        this.localizableStrings[name] = locStr;
        return locStr;
    };
    Base.prototype.getLocalizableString = function (name) {
        return !!this.localizableStrings ? this.localizableStrings[name] : null;
    };
    Base.prototype.getLocalizableStringText = function (name, defaultStr) {
        if (defaultStr === void 0) { defaultStr = ""; }
        var locStr = this.getLocalizableString(name);
        if (!locStr)
            return "";
        var res = locStr.text;
        return res ? res : defaultStr;
    };
    Base.prototype.setLocalizableStringText = function (name, value) {
        var locStr = this.getLocalizableString(name);
        if (!locStr)
            return;
        locStr.text = value;
    };
    Base.prototype.addUsedLocales = function (locales) {
        if (!!this.localizableStrings) {
            for (var key in this.localizableStrings) {
                var item = this.getLocalizableString(key);
                if (item)
                    this.AddLocStringToUsedLocales(item, locales);
            }
        }
        if (!!this.arraysInfo) {
            for (var key in this.arraysInfo) {
                var items = this.getPropertyValue(key);
                if (!items || !items.length)
                    continue;
                for (var i = 0; i < items.length; i++) {
                    var item = items[i];
                    if (item && item.addUsedLocales) {
                        item.addUsedLocales(locales);
                    }
                }
            }
        }
    };
    Base.prototype.searchText = function (text, founded) {
        var strs = [];
        this.getSearchableLocalizedStrings(strs);
        for (var i = 0; i < strs.length; i++) {
            if (strs[i].setFindText(text)) {
                founded.push({ element: this, str: strs[i] });
            }
        }
    };
    Base.prototype.getSearchableLocalizedStrings = function (arr) {
        if (!!this.localizableStrings) {
            var keys_1 = [];
            this.getSearchableLocKeys(keys_1);
            for (var i = 0; i < keys_1.length; i++) {
                var item = this.getLocalizableString(keys_1[i]);
                if (item)
                    arr.push(item);
            }
        }
        if (!this.arraysInfo)
            return;
        var keys = [];
        this.getSearchableItemValueKeys(keys);
        for (var i = 0; i < keys.length; i++) {
            var items = this.getPropertyValue(keys[i]);
            if (!items)
                continue;
            for (var j = 0; j < items.length; j++) {
                arr.push(items[j].locText);
            }
        }
    };
    Base.prototype.getSearchableLocKeys = function (keys) { };
    Base.prototype.getSearchableItemValueKeys = function (keys) { };
    Base.prototype.AddLocStringToUsedLocales = function (locStr, locales) {
        var locs = locStr.getLocales();
        for (var i = 0; i < locs.length; i++) {
            if (locales.indexOf(locs[i]) < 0) {
                locales.push(locs[i]);
            }
        }
    };
    Base.prototype.createItemValues = function (name) {
        var self = this;
        var result = this.createNewArray(name, function (item) {
            item.locOwner = self;
            item.ownerPropertyName = name;
        });
        this.arraysInfo[name].isItemValues = true;
        return result;
    };
    Base.prototype.notifyArrayChanged = function (ar, arrayChanges) {
        !!ar.onArrayChanged && ar.onArrayChanged(arrayChanges);
    };
    Base.prototype.createNewArrayCore = function (name) {
        var res = null;
        if (!!this.createArrayCoreHandler) {
            res = this.createArrayCoreHandler(this.propertyHash, name);
        }
        if (!res) {
            res = new Array();
            this.setPropertyValueCore(this.propertyHash, name, res);
        }
        return res;
    };
    Base.prototype.ensureArray = function (name, onPush, onRemove) {
        if (onPush === void 0) { onPush = null; }
        if (onRemove === void 0) { onRemove = null; }
        if (this.arraysInfo && this.arraysInfo[name]) {
            return;
        }
        return this.createNewArray(name, onPush, onRemove);
    };
    Base.prototype.createNewArray = function (name, onPush, onRemove) {
        if (onPush === void 0) { onPush = null; }
        if (onRemove === void 0) { onRemove = null; }
        var newArray = this.createNewArrayCore(name);
        if (!this.arraysInfo) {
            this.arraysInfo = {};
        }
        this.arraysInfo[name] = { onPush: onPush, isItemValues: false };
        var self = this;
        newArray.push = function (value) {
            var result = Object.getPrototypeOf(newArray).push.call(newArray, value);
            if (!self.isDisposedValue) {
                if (onPush)
                    onPush(value, newArray.length - 1);
                var arrayChanges = new ArrayChanges(newArray.length - 1, 0, [value], []);
                self.propertyValueChanged(name, newArray, newArray, arrayChanges);
                self.notifyArrayChanged(newArray, arrayChanges);
            }
            return result;
        };
        newArray.shift = function () {
            var result = Object.getPrototypeOf(newArray).shift.call(newArray);
            if (!self.isDisposedValue && result) {
                if (onRemove)
                    onRemove(result);
                var arrayChanges = new ArrayChanges(newArray.length - 1, 1, [], []);
                self.propertyValueChanged(name, newArray, newArray, arrayChanges);
                self.notifyArrayChanged(newArray, arrayChanges);
            }
            return result;
        };
        newArray.unshift = function (value) {
            var result = Object.getPrototypeOf(newArray).unshift.call(newArray, value);
            if (!self.isDisposedValue) {
                if (onPush)
                    onPush(value, newArray.length - 1);
                var arrayChanges = new ArrayChanges(0, 0, [value], []);
                self.propertyValueChanged(name, newArray, newArray, arrayChanges);
                self.notifyArrayChanged(newArray, arrayChanges);
            }
            return result;
        };
        newArray.pop = function () {
            var result = Object.getPrototypeOf(newArray).pop.call(newArray);
            if (!self.isDisposedValue) {
                if (onRemove)
                    onRemove(result);
                var arrayChanges = new ArrayChanges(newArray.length - 1, 1, [], []);
                self.propertyValueChanged(name, newArray, newArray, arrayChanges);
                self.notifyArrayChanged(newArray, arrayChanges);
            }
            return result;
        };
        newArray.splice = function (start, deleteCount) {
            var _a;
            var items = [];
            for (var _i = 2; _i < arguments.length; _i++) {
                items[_i - 2] = arguments[_i];
            }
            if (!start)
                start = 0;
            if (!deleteCount)
                deleteCount = 0;
            var result = (_a = Object.getPrototypeOf(newArray).splice).call.apply(_a, __spreadArray([newArray,
                start,
                deleteCount], items, false));
            if (!items)
                items = [];
            if (!self.isDisposedValue) {
                if (onRemove && result) {
                    for (var i = 0; i < result.length; i++) {
                        onRemove(result[i]);
                    }
                }
                if (onPush) {
                    for (var i = 0; i < items.length; i++) {
                        onPush(items[i], start + i);
                    }
                }
                var arrayChanges = new ArrayChanges(start, deleteCount, items, result);
                self.propertyValueChanged(name, newArray, newArray, arrayChanges);
                self.notifyArrayChanged(newArray, arrayChanges);
            }
            return result;
        };
        return newArray;
    };
    Base.prototype.getItemValueType = function () {
        return undefined;
    };
    Base.prototype.setArray = function (name, src, dest, isItemValues, onPush) {
        var deletedItems = [].concat(src);
        Object.getPrototypeOf(src).splice.call(src, 0, src.length);
        if (!!dest) {
            for (var i = 0; i < dest.length; i++) {
                var item = dest[i];
                if (isItemValues) {
                    if (!!Base.createItemValue) {
                        item = Base.createItemValue(item, this.getItemValueType());
                    }
                }
                Object.getPrototypeOf(src).push.call(src, item);
                if (onPush)
                    onPush(src[i]);
            }
        }
        var arrayChanges = new ArrayChanges(0, deletedItems.length, src, deletedItems);
        this.propertyValueChanged(name, deletedItems, src, arrayChanges);
        this.notifyArrayChanged(src, arrayChanges);
    };
    Base.prototype.isTwoValueEquals = function (x, y, caseInSensitive, trimString) {
        if (caseInSensitive === void 0) { caseInSensitive = false; }
        if (trimString === void 0) { trimString = false; }
        return _helpers__WEBPACK_IMPORTED_MODULE_1__["Helpers"].isTwoValueEquals(x, y, false, !caseInSensitive, trimString);
    };
    Base.copyObject = function (dst, src) {
        for (var key in src) {
            var source = src[key];
            if (typeof source === "object") {
                source = {};
                this.copyObject(source, src[key]);
            }
            dst[key] = source;
        }
    };
    Base.prototype.copyCssClasses = function (dest, source) {
        if (!source)
            return;
        if (typeof source === "string" || source instanceof String) {
            dest["root"] = source;
        }
        else {
            Base.copyObject(dest, source);
        }
    };
    Base.prototype.getValueInLowCase = function (val) {
        if (!!val && typeof val == "string")
            return val.toLowerCase();
        return val;
    };
    Base.currentDependencis = undefined;
    return Base;
}());

var ArrayChanges = /** @class */ (function () {
    function ArrayChanges(index, deleteCount, itemsToAdd, deletedItems) {
        this.index = index;
        this.deleteCount = deleteCount;
        this.itemsToAdd = itemsToAdd;
        this.deletedItems = deletedItems;
    }
    return ArrayChanges;
}());

var Event = /** @class */ (function () {
    function Event() {
    }
    Object.defineProperty(Event.prototype, "isEmpty", {
        get: function () {
            return !this.callbacks || this.callbacks.length == 0;
        },
        enumerable: false,
        configurable: true
    });
    Event.prototype.fire = function (sender, options) {
        if (!this.callbacks)
            return;
        for (var i = 0; i < this.callbacks.length; i++) {
            this.callbacks[i](sender, options);
            if (!this.callbacks)
                return;
        }
    };
    Event.prototype.clear = function () {
        this.callbacks = undefined;
    };
    Event.prototype.add = function (func) {
        if (this.hasFunc(func))
            return;
        if (!this.callbacks) {
            this.callbacks = new Array();
        }
        this.callbacks.push(func);
        this.fireCallbackChanged();
    };
    Event.prototype.remove = function (func) {
        if (this.hasFunc(func)) {
            var index = this.callbacks.indexOf(func, 0);
            this.callbacks.splice(index, 1);
            this.fireCallbackChanged();
        }
    };
    Event.prototype.hasFunc = function (func) {
        if (this.callbacks == null)
            return false;
        return this.callbacks.indexOf(func, 0) > -1;
    };
    Event.prototype.fireCallbackChanged = function () {
        if (!!this.onCallbacksChanged) {
            this.onCallbacksChanged();
        }
    };
    return Event;
}());

var EventBase = /** @class */ (function (_super) {
    __extends(EventBase, _super);
    function EventBase() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    return EventBase;
}(Event));



/***/ }),

/***/ "./src/calculatedValue.ts":
/*!********************************!*\
  !*** ./src/calculatedValue.ts ***!
  \********************************/
/*! exports provided: CalculatedValue */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "CalculatedValue", function() { return CalculatedValue; });
/* harmony import */ var _helpers__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./helpers */ "./src/helpers.ts");
/* harmony import */ var _base__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./base */ "./src/base.ts");
/* harmony import */ var _conditions__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./conditions */ "./src/conditions.ts");
/* harmony import */ var _jsonobject__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./jsonobject */ "./src/jsonobject.ts");
var __extends = (undefined && undefined.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();




/**
 * The calculated value is a way to define the variable in Survey Creator.
 * It has two main properties: name and expression. Based on expression the value read-only property is automatically calculated.
 * The name property should be unique though all calculated values.
 * It uses survey.getVariable/seruvey.setVariable functions to get/set its value. The class do not store its value internally.
 * You may set includeIntoResult property to true to store this calculated value into survey result.
 */
var CalculatedValue = /** @class */ (function (_super) {
    __extends(CalculatedValue, _super);
    function CalculatedValue(name, expression) {
        if (name === void 0) { name = null; }
        if (expression === void 0) { expression = null; }
        var _this = _super.call(this) || this;
        _this.expressionIsRunning = false;
        _this.isCalculated = false;
        if (!!name) {
            _this.name = name;
        }
        if (!!expression) {
            _this.expression = expression;
        }
        return _this;
    }
    CalculatedValue.prototype.setOwner = function (data) {
        this.data = data;
        this.rerunExpression();
    };
    CalculatedValue.prototype.getType = function () {
        return "calculatedvalue";
    };
    CalculatedValue.prototype.getSurvey = function (live) {
        if (live === void 0) { live = false; }
        return !!this.data && !!this.data["getSurvey"]
            ? this.data.getSurvey()
            : null;
    };
    Object.defineProperty(CalculatedValue.prototype, "owner", {
        get: function () {
            return this.data;
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(CalculatedValue.prototype, "name", {
        /**
         * The calculated value name. It should be non empty and unique.
         */
        get: function () {
            return this.getPropertyValue("name", "");
        },
        set: function (val) {
            this.setPropertyValue("name", val);
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(CalculatedValue.prototype, "includeIntoResult", {
        /**
         * Set this property to true to include the non-empty calculated value into survey result, survey.data property.
         */
        get: function () {
            return this.getPropertyValue("includeIntoResult", false);
        },
        set: function (val) {
            this.setPropertyValue("includeIntoResult", val);
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(CalculatedValue.prototype, "expression", {
        /**
         * The Expression that used to calculate the value. You may use standard operators like +, -, * and /, squares (). Here is the example of accessing the question value {questionname}.
         * <br/>Example: "({quantity} * {price}) * (100 - {discount}) / 100"
         */
        get: function () {
            return this.getPropertyValue("expression", "");
        },
        set: function (val) {
            this.setPropertyValue("expression", val);
            this.rerunExpression();
        },
        enumerable: false,
        configurable: true
    });
    CalculatedValue.prototype.locCalculation = function () {
        this.expressionIsRunning = true;
    };
    CalculatedValue.prototype.unlocCalculation = function () {
        this.expressionIsRunning = false;
    };
    CalculatedValue.prototype.resetCalculation = function () {
        this.isCalculated = false;
    };
    CalculatedValue.prototype.doCalculation = function (calculatedValues, values, properties) {
        if (this.isCalculated)
            return;
        this.runExpressionCore(calculatedValues, values, properties);
        this.isCalculated = true;
    };
    CalculatedValue.prototype.runExpression = function (values, properties) {
        this.runExpressionCore(null, values, properties);
    };
    Object.defineProperty(CalculatedValue.prototype, "value", {
        get: function () {
            if (!this.data)
                return undefined;
            return this.data.getVariable(this.name);
        },
        enumerable: false,
        configurable: true
    });
    CalculatedValue.prototype.setValue = function (val) {
        if (!this.data)
            return;
        this.data.setVariable(this.name, val);
    };
    Object.defineProperty(CalculatedValue.prototype, "canRunExpression", {
        get: function () {
            return (!!this.data &&
                !this.isLoadingFromJson &&
                !!this.expression &&
                !this.expressionIsRunning &&
                !!this.name);
        },
        enumerable: false,
        configurable: true
    });
    CalculatedValue.prototype.rerunExpression = function () {
        if (!this.canRunExpression)
            return;
        this.runExpression(this.data.getFilteredValues(), this.data.getFilteredProperties());
    };
    CalculatedValue.prototype.runExpressionCore = function (calculatedValues, values, properties) {
        if (!this.canRunExpression)
            return;
        this.ensureExpression(values);
        this.locCalculation();
        if (!!calculatedValues) {
            this.runDependentExpressions(calculatedValues, values, properties);
        }
        this.expressionRunner.run(values, properties);
    };
    CalculatedValue.prototype.runDependentExpressions = function (calculatedValues, values, properties) {
        var variables = this.expressionRunner.getVariables();
        if (!variables)
            return;
        for (var i = 0; i < calculatedValues.length; i++) {
            var calcItem = calculatedValues[i];
            if (calcItem === this || variables.indexOf(calcItem.name) < 0)
                continue;
            calcItem.doCalculation(calculatedValues, values, properties);
            values[calcItem.name] = calcItem.value;
        }
    };
    CalculatedValue.prototype.ensureExpression = function (values) {
        var _this = this;
        if (!!this.expressionRunner)
            return;
        this.expressionRunner = new _conditions__WEBPACK_IMPORTED_MODULE_2__["ExpressionRunner"](this.expression);
        this.expressionRunner.onRunComplete = function (newValue) {
            if (!_helpers__WEBPACK_IMPORTED_MODULE_0__["Helpers"].isTwoValueEquals(newValue, _this.value)) {
                _this.setValue(newValue);
            }
            _this.unlocCalculation();
        };
    };
    return CalculatedValue;
}(_base__WEBPACK_IMPORTED_MODULE_1__["Base"]));

_jsonobject__WEBPACK_IMPORTED_MODULE_3__["Serializer"].addClass("calculatedvalue", [
    { name: "!name", isUnique: true },
    "expression:expression",
    "includeIntoResult:boolean",
], function () {
    return new CalculatedValue();
}, "base");


/***/ }),

/***/ "./src/choicesRestful.ts":
/*!*******************************!*\
  !*** ./src/choicesRestful.ts ***!
  \*******************************/
/*! exports provided: ChoicesRestful, ChoicesRestfull */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "ChoicesRestful", function() { return ChoicesRestful; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "ChoicesRestfull", function() { return ChoicesRestfull; });
/* harmony import */ var _base__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./base */ "./src/base.ts");
/* harmony import */ var _itemvalue__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./itemvalue */ "./src/itemvalue.ts");
/* harmony import */ var _jsonobject__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./jsonobject */ "./src/jsonobject.ts");
/* harmony import */ var _error__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./error */ "./src/error.ts");
/* harmony import */ var _settings__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./settings */ "./src/settings.ts");
var __extends = (undefined && undefined.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();





var XmlParser = /** @class */ (function () {
    function XmlParser() {
        this.parser = new DOMParser();
    }
    XmlParser.prototype.assignValue = function (target, name, value) {
        if (Array.isArray(target[name])) {
            target[name].push(value);
        }
        else if (target[name] !== undefined) {
            target[name] = [target[name]].concat(value);
        }
        else if (typeof value === "object" &&
            Object.keys(value).length === 1 &&
            Object.keys(value)[0] === name) {
            target[name] = value[name];
        }
        else {
            target[name] = value;
        }
    };
    XmlParser.prototype.xml2Json = function (xmlNode, result) {
        if (xmlNode.children && xmlNode.children.length > 0) {
            for (var i = 0; i < xmlNode.children.length; i++) {
                var childNode = xmlNode.children[i];
                var childObject = {};
                this.xml2Json(childNode, childObject);
                this.assignValue(result, childNode.nodeName, childObject);
            }
        }
        else {
            this.assignValue(result, xmlNode.nodeName, xmlNode.textContent);
        }
    };
    XmlParser.prototype.parseXmlString = function (xmlString) {
        var xmlRoot = this.parser.parseFromString(xmlString, "text/xml");
        var json = {};
        this.xml2Json(xmlRoot, json);
        return json;
    };
    return XmlParser;
}());
/**
 * A definition for filling choices for checkbox, dropdown and radiogroup questions from resfull services.
 * The run method call a restful service and results can be get on getResultCallback.
 */
var ChoicesRestful = /** @class */ (function (_super) {
    __extends(ChoicesRestful, _super);
    function ChoicesRestful() {
        var _this = _super.call(this) || this;
        _this.lastObjHash = "";
        _this.isRunningValue = false;
        _this.processedUrl = "";
        _this.processedPath = "";
        _this.isUsingCacheFromUrl = undefined;
        _this.error = null;
        _this.createItemValue = function (value) {
            return new _itemvalue__WEBPACK_IMPORTED_MODULE_1__["ItemValue"](value);
        };
        return _this;
    }
    Object.defineProperty(ChoicesRestful, "EncodeParameters", {
        get: function () {
            return _settings__WEBPACK_IMPORTED_MODULE_4__["settings"].webserviceEncodeParameters;
        },
        set: function (val) {
            _settings__WEBPACK_IMPORTED_MODULE_4__["settings"].webserviceEncodeParameters = val;
        },
        enumerable: false,
        configurable: true
    });
    ChoicesRestful.clearCache = function () {
        ChoicesRestful.itemsResult = {};
        ChoicesRestful.sendingSameRequests = {};
    };
    ChoicesRestful.addSameRequest = function (obj) {
        if (!obj.isUsingCache)
            return false;
        var hash = obj.objHash;
        var res = ChoicesRestful.sendingSameRequests[hash];
        if (!res) {
            ChoicesRestful.sendingSameRequests[obj.objHash] = [];
            return false;
        }
        res.push(obj);
        obj.isRunningValue = true;
        return true;
    };
    ChoicesRestful.unregisterSameRequests = function (obj, items) {
        if (!obj.isUsingCache)
            return;
        var res = ChoicesRestful.sendingSameRequests[obj.objHash];
        delete ChoicesRestful.sendingSameRequests[obj.objHash];
        if (!res)
            return;
        for (var i = 0; i < res.length; i++) {
            res[i].isRunningValue = false;
            if (!!res[i].getResultCallback) {
                res[i].getResultCallback(items);
            }
        }
    };
    ChoicesRestful.getCachedItemsResult = function (obj) {
        var hash = obj.objHash;
        var res = ChoicesRestful.itemsResult[hash];
        if (!res)
            return false;
        if (obj.getResultCallback) {
            obj.getResultCallback(res);
        }
        return true;
    };
    ChoicesRestful.prototype.getSurvey = function (live) {
        if (live === void 0) { live = false; }
        return !!this.owner ? this.owner.survey : null;
    };
    ChoicesRestful.prototype.run = function (textProcessor) {
        if (textProcessor === void 0) { textProcessor = null; }
        if (!this.url || !this.getResultCallback)
            return;
        this.processedText(textProcessor);
        if (!this.processedUrl) {
            this.doEmptyResultCallback({});
            this.lastObjHash = this.objHash;
            return;
        }
        if (this.lastObjHash === this.objHash)
            return;
        this.lastObjHash = this.objHash;
        this.error = null;
        if (this.useChangedItemsResults())
            return;
        if (ChoicesRestful.addSameRequest(this))
            return;
        this.sendRequest();
    };
    Object.defineProperty(ChoicesRestful.prototype, "isUsingCache", {
        get: function () {
            if (this.isUsingCacheFromUrl === true)
                return true;
            if (this.isUsingCacheFromUrl === false)
                return false;
            return _settings__WEBPACK_IMPORTED_MODULE_4__["settings"].useCachingForChoicesRestful;
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(ChoicesRestful.prototype, "isRunning", {
        get: function () {
            return this.getIsRunning();
        },
        enumerable: false,
        configurable: true
    });
    ChoicesRestful.prototype.getIsRunning = function () {
        return this.isRunningValue;
    };
    Object.defineProperty(ChoicesRestful.prototype, "isWaitingForParameters", {
        get: function () {
            return this.url && !this.processedUrl;
        },
        enumerable: false,
        configurable: true
    });
    ChoicesRestful.prototype.useChangedItemsResults = function () {
        return ChoicesRestful.getCachedItemsResult(this);
    };
    ChoicesRestful.prototype.doEmptyResultCallback = function (serverResult) {
        var items = [];
        if (this.updateResultCallback) {
            items = this.updateResultCallback(items, serverResult);
        }
        this.getResultCallback(items);
    };
    ChoicesRestful.prototype.processedText = function (textProcessor) {
        var urlText = this.url;
        if (!!urlText) {
            urlText = urlText
                .replace(ChoicesRestful.cacheText, "")
                .replace(ChoicesRestful.noCacheText, "");
        }
        if (textProcessor) {
            var pUrl = textProcessor.processTextEx(urlText, false, _settings__WEBPACK_IMPORTED_MODULE_4__["settings"].webserviceEncodeParameters);
            var pPath = textProcessor.processTextEx(this.path, false, _settings__WEBPACK_IMPORTED_MODULE_4__["settings"].webserviceEncodeParameters);
            if (!pUrl.hasAllValuesOnLastRun || !pPath.hasAllValuesOnLastRun) {
                this.processedUrl = "";
                this.processedPath = "";
            }
            else {
                this.processedUrl = pUrl.text;
                this.processedPath = pPath.text;
            }
        }
        else {
            this.processedUrl = urlText;
            this.processedPath = this.path;
        }
        if (this.onProcessedUrlCallback) {
            this.onProcessedUrlCallback(this.processedUrl, this.processedPath);
        }
    };
    ChoicesRestful.prototype.parseResponse = function (response) {
        var parsedResponse;
        if (!!response &&
            typeof response.indexOf === "function" &&
            response.indexOf("<") === 0) {
            var parser = new XmlParser();
            parsedResponse = parser.parseXmlString(response);
        }
        else {
            try {
                parsedResponse = JSON.parse(response);
            }
            catch (_a) {
                parsedResponse = (response || "")
                    .split("\n")
                    .map(function (s) { return s.trim(" "); })
                    .filter(function (s) { return !!s; });
            }
        }
        return parsedResponse;
    };
    ChoicesRestful.prototype.sendRequest = function () {
        var xhr = new XMLHttpRequest();
        xhr.open("GET", this.processedUrl);
        xhr.setRequestHeader("Content-Type", "application/x-www-form-urlencoded");
        var self = this;
        var loadingObjHash = this.objHash;
        xhr.onload = function () {
            self.beforeLoadRequest();
            if (xhr.status === 200) {
                self.onLoad(self.parseResponse(xhr.response), loadingObjHash);
            }
            else {
                self.onError(xhr.statusText, xhr.responseText);
            }
        };
        var options = { request: xhr };
        if (!!ChoicesRestful.onBeforeSendRequest) {
            ChoicesRestful.onBeforeSendRequest(this, options);
        }
        this.beforeSendRequest();
        options.request.send();
    };
    ChoicesRestful.prototype.getType = function () {
        return "choicesByUrl";
    };
    Object.defineProperty(ChoicesRestful.prototype, "isEmpty", {
        get: function () {
            return (!this.url &&
                !this.path &&
                !this.valueName &&
                !this.titleName &&
                !this.imageLinkName);
        },
        enumerable: false,
        configurable: true
    });
    ChoicesRestful.prototype.getCustomPropertiesNames = function () {
        var properties = this.getCustomProperties();
        var res = new Array();
        for (var i = 0; i < properties.length; i++) {
            res.push(this.getCustomPropertyName(properties[i].name));
        }
        return res;
    };
    ChoicesRestful.prototype.getCustomPropertyName = function (propertyName) {
        return propertyName + "Name";
    };
    ChoicesRestful.prototype.getCustomProperties = function () {
        var properties = _jsonobject__WEBPACK_IMPORTED_MODULE_2__["Serializer"].getProperties(this.itemValueType);
        var res = [];
        for (var i = 0; i < properties.length; i++) {
            if (properties[i].name === "value" ||
                properties[i].name === "text" ||
                properties[i].name === "visibleIf" ||
                properties[i].name === "enableIf")
                continue;
            res.push(properties[i]);
        }
        return res;
    };
    ChoicesRestful.prototype.setData = function (json) {
        this.clear();
        if (json.url)
            this.url = json.url;
        if (json.path)
            this.path = json.path;
        if (json.valueName)
            this.valueName = json.valueName;
        if (json.titleName)
            this.titleName = json.titleName;
        if (json.imageLinkName)
            this.imageLinkName = json.imageLinkName;
        if (json.allowEmptyResponse !== undefined)
            this.allowEmptyResponse = json.allowEmptyResponse;
        if (json.attachOriginalItems !== undefined)
            this.attachOriginalItems = json.attachOriginalItems;
        var properties = this.getCustomPropertiesNames();
        for (var i = 0; i < properties.length; i++) {
            if (json[properties[i]])
                this[properties[i]] = json[properties[i]];
        }
    };
    ChoicesRestful.prototype.getData = function () {
        if (this.isEmpty)
            return null;
        var res = {};
        if (this.url)
            res["url"] = this.url;
        if (this.path)
            res["path"] = this.path;
        if (this.valueName)
            res["valueName"] = this.valueName;
        if (this.titleName)
            res["titleName"] = this.titleName;
        if (this.imageLinkName)
            res["imageLinkName"] = this.imageLinkName;
        if (this.allowEmptyResponse)
            res["allowEmptyResponse"] = this.allowEmptyResponse;
        if (this.attachOriginalItems)
            res["attachOriginalItems"] = this.attachOriginalItems;
        var properties = this.getCustomPropertiesNames();
        for (var i = 0; i < properties.length; i++) {
            if (this[properties[i]])
                res[properties[i]] = this[properties[i]];
        }
        return res;
    };
    Object.defineProperty(ChoicesRestful.prototype, "url", {
        /**
         * Gets or sets a link to a web service. You can use text preprocessing here.
         * For example, the following url: _https://surveyjs.io/api/CountriesExample?region={region}_ is changed based on the _region_ question's value.
         * SurveyJS automatically gets data from the web service when the value of the _region_ question changes.
         * @see path
         * @see valueName
         * @see titleName
         * @see [Example: RESTful Dropdown](https://surveyjs.io/Examples/Library/?id=questiontype-dropdownrestfull)
         * @see [Docs: Fill Choices from a RESTful Service](https://surveyjs.io/Documentation/Library/?id=LibraryOverview#fill-the-choices-from-a-restful-service)
         */
        get: function () {
            return this.getPropertyValue("url", "");
        },
        set: function (val) {
            this.setPropertyValue("url", val);
            this.isUsingCacheFromUrl = undefined;
            if (!val)
                return;
            if (val.indexOf(ChoicesRestful.cacheText) > -1) {
                this.isUsingCacheFromUrl = true;
            }
            else {
                if (val.indexOf(ChoicesRestful.noCacheText) > -1) {
                    this.isUsingCacheFromUrl = false;
                }
            }
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(ChoicesRestful.prototype, "path", {
        /**
         * Use this property, if a web service returns a lot of information and you need only a part of it.
         * For example, a web service returns a list of countries and a list of capitals.
         * If you need a list of countries, set a correct path from which SurveyJS obtains the data, like: _DataList1\DataList2_
         * @see url
         * @see valueName
         * @see titleName
         * @see [Example: RESTful Dropdown](https://surveyjs.io/Examples/Library/?id=questiontype-dropdownrestfull)
         * @see [Docs: Fill Choices from a RESTful Service](https://surveyjs.io/Documentation/Library/?id=LibraryOverview#fill-the-choices-from-a-restful-service)
         */
        get: function () {
            return this.getPropertyValue("path", "");
        },
        set: function (val) {
            this.setPropertyValue("path", val);
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(ChoicesRestful.prototype, "valueName", {
        /**
         * Gets or sets the name of a property (in the obtained data object) to which SurveyJS binds to provide values for choice items.
         * @see url
         * @see path
         * @see titleName
         * @see [Example: RESTful Dropdown](https://surveyjs.io/Examples/Library/?id=questiontype-dropdownrestfull)
         * @see [Docs: Fill Choices from a RESTful Service](https://surveyjs.io/Documentation/Library/?id=LibraryOverview#fill-the-choices-from-a-restful-service)
         */
        get: function () {
            return this.getPropertyValue("valueName", "");
        },
        set: function (val) {
            this.setPropertyValue("valueName", val);
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(ChoicesRestful.prototype, "titleName", {
        /**
         * Gets or sets the name of a property (in the obtained data object) to which SurveyJS binds to provide display texts for choice items.
         * @see url
         * @see path
         * @see valueeName
         * @see [Example: RESTful Dropdown](https://surveyjs.io/Examples/Library/?id=questiontype-dropdownrestfull)
         * @see [Docs: Fill Choices from a RESTful Service](https://surveyjs.io/Documentation/Library/?id=LibraryOverview#fill-the-choices-from-a-restful-service)
         */
        get: function () {
            return this.getPropertyValue("titleName", "");
        },
        set: function (val) {
            this.setPropertyValue("titleName", val);
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(ChoicesRestful.prototype, "imageLinkName", {
        get: function () {
            return this.getPropertyValue("imageLinkName", "");
        },
        set: function (val) {
            this.setPropertyValue("imageLinkName", val);
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(ChoicesRestful.prototype, "allowEmptyResponse", {
        get: function () {
            return this.getPropertyValue("allowEmptyResponse");
        },
        set: function (val) {
            this.setPropertyValue("allowEmptyResponse", val);
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(ChoicesRestful.prototype, "attachOriginalItems", {
        get: function () {
            return this.getPropertyValue("attachOriginalItems");
        },
        set: function (val) {
            this.setPropertyValue("attachOriginalItems", val);
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(ChoicesRestful.prototype, "itemValueType", {
        get: function () {
            if (!this.owner)
                return "itemvalue";
            var prop = _jsonobject__WEBPACK_IMPORTED_MODULE_2__["Serializer"].findProperty(this.owner.getType(), "choices");
            if (!prop)
                return "itemvalue";
            if (prop.type == "itemvalue[]")
                return "itemvalue";
            return prop.type;
        },
        enumerable: false,
        configurable: true
    });
    ChoicesRestful.prototype.clear = function () {
        this.url = "";
        this.path = "";
        this.valueName = "";
        this.titleName = "";
        this.imageLinkName = "";
        var properties = this.getCustomPropertiesNames();
        for (var i = 0; i < properties.length; i++) {
            if (this[properties[i]])
                this[properties[i]] = "";
        }
    };
    ChoicesRestful.prototype.beforeSendRequest = function () {
        this.isRunningValue = true;
        if (!!this.beforeSendRequestCallback) {
            this.beforeSendRequestCallback();
        }
    };
    ChoicesRestful.prototype.beforeLoadRequest = function () {
        this.isRunningValue = false;
    };
    ChoicesRestful.prototype.onLoad = function (result, loadingObjHash) {
        if (loadingObjHash === void 0) { loadingObjHash = null; }
        if (!loadingObjHash) {
            loadingObjHash = this.objHash;
        }
        var items = new Array();
        var updatedResult = this.getResultAfterPath(result);
        if (updatedResult && updatedResult["length"]) {
            for (var i = 0; i < updatedResult.length; i++) {
                var itemValue = updatedResult[i];
                if (!itemValue)
                    continue;
                var value = !!this.getItemValueCallback
                    ? this.getItemValueCallback(itemValue)
                    : this.getValue(itemValue);
                var item = this.createItemValue(value);
                this.setTitle(item, itemValue);
                this.setCustomProperties(item, itemValue);
                if (this.attachOriginalItems) {
                    item.originalItem = itemValue;
                }
                var imageLink = this.getImageLink(itemValue);
                if (!!imageLink) {
                    item.imageLink = imageLink;
                }
                items.push(item);
            }
        }
        else {
            if (!this.allowEmptyResponse) {
                this.error = new _error__WEBPACK_IMPORTED_MODULE_3__["WebRequestEmptyError"](null, this.owner);
            }
        }
        if (this.updateResultCallback) {
            items = this.updateResultCallback(items, result);
        }
        if (this.isUsingCache) {
            ChoicesRestful.itemsResult[loadingObjHash] = items;
        }
        this.callResultCallback(items, loadingObjHash);
        ChoicesRestful.unregisterSameRequests(this, items);
    };
    ChoicesRestful.prototype.callResultCallback = function (items, loadingObjHash) {
        if (loadingObjHash != this.objHash)
            return;
        this.getResultCallback(items);
    };
    ChoicesRestful.prototype.setCustomProperties = function (item, itemValue) {
        var properties = this.getCustomProperties();
        for (var i = 0; i < properties.length; i++) {
            var prop = properties[i];
            var val = this.getValueCore(itemValue, this.getPropertyBinding(prop.name));
            if (!this.isValueEmpty(val)) {
                item[prop.name] = val;
            }
        }
    };
    ChoicesRestful.prototype.getPropertyBinding = function (propertyName) {
        if (this[this.getCustomPropertyName(propertyName)])
            return this[this.getCustomPropertyName(propertyName)];
        if (this[propertyName])
            return this[propertyName];
        return propertyName;
    };
    ChoicesRestful.prototype.onError = function (status, response) {
        this.error = new _error__WEBPACK_IMPORTED_MODULE_3__["WebRequestError"](status, response, this.owner);
        this.doEmptyResultCallback(response);
        ChoicesRestful.unregisterSameRequests(this, []);
    };
    ChoicesRestful.prototype.getResultAfterPath = function (result) {
        if (!result)
            return result;
        if (!this.processedPath)
            return result;
        var pathes = this.getPathes();
        for (var i = 0; i < pathes.length; i++) {
            result = result[pathes[i]];
            if (!result)
                return null;
        }
        return result;
    };
    ChoicesRestful.prototype.getPathes = function () {
        var pathes = [];
        if (this.processedPath.indexOf(";") > -1) {
            pathes = this.path.split(";");
        }
        else {
            pathes = this.processedPath.split(",");
        }
        if (pathes.length == 0)
            pathes.push(this.processedPath);
        return pathes;
    };
    ChoicesRestful.prototype.getValue = function (item) {
        if (!item)
            return null;
        if (this.valueName)
            return this.getValueCore(item, this.valueName);
        if (!(item instanceof Object))
            return item;
        var len = Object.keys(item).length;
        if (len < 1)
            return null;
        return item[Object.keys(item)[0]];
    };
    ChoicesRestful.prototype.setTitle = function (item, itemValue) {
        var title = this.titleName ? this.titleName : "title";
        var val = this.getValueCore(itemValue, title);
        if (!val)
            return;
        if (typeof val === "string") {
            item.text = val;
        }
        else {
            item.locText.setJson(val);
        }
    };
    ChoicesRestful.prototype.getImageLink = function (item) {
        var imageLink = this.imageLinkName ? this.imageLinkName : "imageLink";
        return this.getValueCore(item, imageLink);
    };
    ChoicesRestful.prototype.getValueCore = function (item, property) {
        if (!item)
            return null;
        if (property.indexOf(".") < 0)
            return item[property];
        var properties = property.split(".");
        for (var i = 0; i < properties.length; i++) {
            item = item[properties[i]];
            if (!item)
                return null;
        }
        return item;
    };
    Object.defineProperty(ChoicesRestful.prototype, "objHash", {
        get: function () {
            return (this.processedUrl +
                ";" +
                this.processedPath +
                ";" +
                this.valueName +
                ";" +
                this.titleName +
                ";" +
                this.imageLinkName);
        },
        enumerable: false,
        configurable: true
    });
    ChoicesRestful.cacheText = "{CACHE}";
    ChoicesRestful.noCacheText = "{NOCACHE}";
    ChoicesRestful.itemsResult = {};
    ChoicesRestful.sendingSameRequests = {};
    return ChoicesRestful;
}(_base__WEBPACK_IMPORTED_MODULE_0__["Base"]));

/**
 * Obsolete, please use ChoicesRestful
 */
var ChoicesRestfull = /** @class */ (function (_super) {
    __extends(ChoicesRestfull, _super);
    function ChoicesRestfull() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    Object.defineProperty(ChoicesRestfull, "EncodeParameters", {
        get: function () {
            return ChoicesRestful.EncodeParameters;
        },
        set: function (val) {
            ChoicesRestful.EncodeParameters = val;
        },
        enumerable: false,
        configurable: true
    });
    ChoicesRestfull.clearCache = function () {
        ChoicesRestful.clearCache();
    };
    Object.defineProperty(ChoicesRestfull, "onBeforeSendRequest", {
        get: function () {
            return ChoicesRestful.onBeforeSendRequest;
        },
        set: function (val) {
            ChoicesRestful.onBeforeSendRequest = val;
        },
        enumerable: false,
        configurable: true
    });
    return ChoicesRestfull;
}(ChoicesRestful));

_jsonobject__WEBPACK_IMPORTED_MODULE_2__["Serializer"].addClass("choicesByUrl", [
    "url",
    "path",
    "valueName",
    "titleName",
    {
        name: "imageLinkName",
        visibleIf: function (obj) {
            return !!obj && !!obj.owner && obj.owner.getType() == "imagepicker";
        },
    },
    { name: "allowEmptyResponse:boolean" },
    { name: "attachOriginalItems:boolean", visible: false },
], function () {
    return new ChoicesRestful();
});


/***/ }),

/***/ "./src/conditionProcessValue.ts":
/*!**************************************!*\
  !*** ./src/conditionProcessValue.ts ***!
  \**************************************/
/*! exports provided: ProcessValue */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "ProcessValue", function() { return ProcessValue; });
/* harmony import */ var _helpers__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./helpers */ "./src/helpers.ts");

var surveyBuiltInVarible = "@survey";
var ProcessValue = /** @class */ (function () {
    function ProcessValue() {
        this.values = null;
        this.properties = null;
    }
    ProcessValue.prototype.getFirstName = function (text, obj) {
        if (obj === void 0) { obj = null; }
        if (!text)
            return text;
        var res = "";
        if (!!obj) {
            res = this.getFirstPropertyName(text, obj);
            if (!!res)
                return res;
        }
        for (var i = 0; i < text.length; i++) {
            var ch = text[i];
            if (ch == "." || ch == "[")
                break;
            res += ch;
        }
        return res;
    };
    ProcessValue.prototype.hasValue = function (text, values) {
        if (values === void 0) { values = null; }
        if (!values)
            values = this.values;
        var res = this.getValueCore(text, values);
        return res.hasValue;
    };
    ProcessValue.prototype.getValue = function (text, values) {
        if (values === void 0) { values = null; }
        if (!values)
            values = this.values;
        var res = this.getValueCore(text, values);
        return res.value;
    };
    ProcessValue.prototype.setValue = function (obj, text, value) {
        if (!text)
            return;
        var nonNestedObj = this.getNonNestedObject(obj, text, true);
        if (!nonNestedObj)
            return;
        obj = nonNestedObj.value;
        text = nonNestedObj.text;
        if (!!obj && !!text) {
            obj[text] = value;
        }
    };
    ProcessValue.prototype.getValueInfo = function (valueInfo) {
        if (!!valueInfo.path) {
            valueInfo.value = this.getValueFromPath(valueInfo.path, this.values);
            valueInfo.hasValue =
                valueInfo.value !== null && !_helpers__WEBPACK_IMPORTED_MODULE_0__["Helpers"].isValueEmpty(valueInfo.value);
            if (!valueInfo.hasValue &&
                valueInfo.path.length > 1 &&
                valueInfo.path[valueInfo.path.length - 1] == "length") {
                valueInfo.hasValue = true;
                valueInfo.value = 0;
            }
            return;
        }
        var res = this.getValueCore(valueInfo.name, this.values);
        valueInfo.value = res.value;
        valueInfo.hasValue = res.hasValue;
        valueInfo.path = res.hasValue ? res.path : null;
    };
    ProcessValue.prototype.getValueFromPath = function (path, values) {
        if (path.length === 2 && path[0] === surveyBuiltInVarible) {
            return this.getValueFromSurvey(path[1]);
        }
        var index = 0;
        while (!!values && index < path.length) {
            var ind_name = path[index];
            if (_helpers__WEBPACK_IMPORTED_MODULE_0__["Helpers"].isNumber(ind_name) &&
                Array.isArray(values) &&
                ind_name >= values.length)
                return null;
            values = values[ind_name];
            index++;
        }
        return values;
    };
    ProcessValue.prototype.getValueCore = function (text, values) {
        var res = this.getValueFromValues(text, values);
        if (!!text && !res.hasValue) {
            var val = this.getValueFromSurvey(text);
            if (val !== undefined) {
                res.hasValue = true;
                res.value = val;
                res.path = [surveyBuiltInVarible, text];
            }
        }
        return res;
    };
    ProcessValue.prototype.getValueFromSurvey = function (name) {
        if (!!this.properties && !!this.properties.survey)
            return this.properties.survey.getBuiltInVariableValue(name.toLocaleLowerCase());
        return undefined;
    };
    ProcessValue.prototype.getValueFromValues = function (text, values) {
        var res = { hasValue: false, value: null, path: null };
        var curValue = values;
        if (!curValue && curValue !== 0 && curValue !== false)
            return res;
        if (text &&
            text.lastIndexOf(".length") > -1 &&
            text.lastIndexOf(".length") === text.length - ".length".length) {
            res.value = 0;
            res.hasValue = true;
        }
        var nonNestedObj = this.getNonNestedObject(curValue, text, false);
        if (!nonNestedObj)
            return res;
        res.path = nonNestedObj.path;
        res.value = !!nonNestedObj.text
            ? this.getObjectValue(nonNestedObj.value, nonNestedObj.text)
            : nonNestedObj.value;
        res.hasValue = !_helpers__WEBPACK_IMPORTED_MODULE_0__["Helpers"].isValueEmpty(res.value);
        return res;
    };
    ProcessValue.prototype.getNonNestedObject = function (obj, text, createPath) {
        var curName = this.getFirstPropertyName(text, obj, createPath);
        var path = !!curName ? [curName] : null;
        while (text != curName && !!obj) {
            var isArray = text[0] == "[";
            if (!isArray) {
                if (!curName && text == this.getFirstName(text))
                    return { value: obj, text: text, path: path };
                obj = this.getObjectValue(obj, curName);
                if (_helpers__WEBPACK_IMPORTED_MODULE_0__["Helpers"].isValueEmpty(obj) && !createPath)
                    return null;
                text = text.substr(curName.length);
            }
            else {
                var objInArray = this.getObjInArray(obj, text);
                if (!objInArray)
                    return null;
                obj = objInArray.value;
                text = objInArray.text;
                path.push(objInArray.index);
            }
            if (!!text && text[0] == ".") {
                text = text.substr(1);
            }
            curName = this.getFirstPropertyName(text, obj, createPath);
            if (!!curName) {
                path.push(curName);
            }
        }
        return { value: obj, text: text, path: path };
    };
    ProcessValue.prototype.getObjInArray = function (curValue, text) {
        if (!Array.isArray(curValue))
            return null;
        var index = 1;
        var str = "";
        while (index < text.length && text[index] != "]") {
            str += text[index];
            index++;
        }
        text = index < text.length ? text.substr(index + 1) : "";
        index = this.getIntValue(str);
        if (index < 0 || index >= curValue.length)
            return null;
        return { value: curValue[index], text: text, index: index };
    };
    ProcessValue.prototype.getFirstPropertyName = function (name, obj, createProp) {
        if (createProp === void 0) { createProp = false; }
        if (!name)
            return name;
        if (!obj)
            obj = {};
        if (obj.hasOwnProperty(name))
            return name;
        var nameInLow = name.toLowerCase();
        var A = nameInLow[0];
        var a = A.toUpperCase();
        for (var key in obj) {
            var first = key[0];
            if (first === a || first === A) {
                var keyName = key.toLowerCase();
                if (keyName == nameInLow)
                    return key;
                if (nameInLow.length <= keyName.length)
                    continue;
                var ch = nameInLow[keyName.length];
                if (ch != "." && ch != "[")
                    continue;
                if (keyName == nameInLow.substr(0, keyName.length))
                    return key;
            }
        }
        if (createProp && name[0] !== "[") {
            var ind = name.indexOf(".");
            if (ind > -1) {
                name = name.substr(0, ind);
                obj[name] = {};
            }
            return name;
        }
        return "";
    };
    ProcessValue.prototype.getObjectValue = function (obj, name) {
        if (!name)
            return null;
        return obj[name];
    };
    ProcessValue.prototype.getIntValue = function (str) {
        if (str == "0" || ((str | 0) > 0 && str % 1 == 0))
            return Number(str);
        return -1;
    };
    return ProcessValue;
}());



/***/ }),

/***/ "./src/conditions.ts":
/*!***************************!*\
  !*** ./src/conditions.ts ***!
  \***************************/
/*! exports provided: createExpressionExecutorFactory, ExpressionExecutor, ExpressionRunnerBase, ConditionRunner, ExpressionRunner */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "createExpressionExecutorFactory", function() { return createExpressionExecutorFactory; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "ExpressionExecutor", function() { return ExpressionExecutor; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "ExpressionRunnerBase", function() { return ExpressionRunnerBase; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "ConditionRunner", function() { return ConditionRunner; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "ExpressionRunner", function() { return ExpressionRunner; });
/* harmony import */ var _conditionProcessValue__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./conditionProcessValue */ "./src/conditionProcessValue.ts");
/* harmony import */ var _conditionsParser__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./conditionsParser */ "./src/conditionsParser.ts");
var __extends = (undefined && undefined.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();


var createExpressionExecutorFactory = function () { return new ExpressionExecutor(); };
var ExpressionExecutor = /** @class */ (function () {
    function ExpressionExecutor() {
        this.processValue = new _conditionProcessValue__WEBPACK_IMPORTED_MODULE_0__["ProcessValue"]();
        this.parser = new _conditionsParser__WEBPACK_IMPORTED_MODULE_1__["ConditionsParser"]();
        this.isAsyncValue = false;
        this.hasFunctionValue = false;
    }
    Object.defineProperty(ExpressionExecutor.prototype, "expression", {
        get: function () {
            return this.expressionValue;
        },
        set: function (value) {
            if (this.expression === value)
                return;
            this.expressionValue = value;
            this.operand = this.parser.parseExpression(value);
            this.hasFunctionValue = this.canRun() ? this.operand.hasFunction() : false;
            this.isAsyncValue = this.hasFunction()
                ? this.operand.hasAsyncFunction()
                : false;
        },
        enumerable: false,
        configurable: true
    });
    ExpressionExecutor.prototype.getVariables = function () {
        if (!this.operand)
            return [];
        var variables = [];
        this.operand.setVariables(variables);
        return variables;
    };
    ExpressionExecutor.prototype.hasFunction = function () {
        return this.hasFunctionValue;
    };
    Object.defineProperty(ExpressionExecutor.prototype, "isAsync", {
        get: function () {
            return this.isAsyncValue;
        },
        enumerable: false,
        configurable: true
    });
    ExpressionExecutor.prototype.canRun = function () {
        return !!this.operand;
    };
    ExpressionExecutor.prototype.run = function (values, properties) {
        var _this = this;
        if (properties === void 0) { properties = null; }
        if (!this.operand)
            return null;
        this.processValue.values = values;
        this.processValue.properties = properties;
        if (!this.isAsync)
            return this.runValues();
        this.asyncFuncList = [];
        this.operand.addToAsyncList(this.asyncFuncList);
        for (var i = 0; i < this.asyncFuncList.length; i++) {
            this.asyncFuncList[i].onAsyncReady = function () {
                _this.doAsyncFunctionReady();
            };
        }
        for (var i = 0; i < this.asyncFuncList.length; i++) {
            this.asyncFuncList[i].evaluateAsync(this.processValue);
        }
        return false;
    };
    ExpressionExecutor.prototype.doAsyncFunctionReady = function () {
        for (var i = 0; i < this.asyncFuncList.length; i++) {
            if (!this.asyncFuncList[i].isReady)
                return;
        }
        this.runValues();
    };
    ExpressionExecutor.prototype.runValues = function () {
        var res = this.operand.evaluate(this.processValue);
        if (!!this.onComplete) {
            this.onComplete(res);
        }
        return res;
    };
    return ExpressionExecutor;
}());

var ExpressionRunnerBase = /** @class */ (function () {
    function ExpressionRunnerBase(expression) {
        var _this = this;
        this.expressionExecutor = createExpressionExecutorFactory();
        this.expressionExecutor.onComplete = function (res) { _this.doOnComplete(res); };
        this.expression = expression;
    }
    Object.defineProperty(ExpressionRunnerBase.prototype, "expression", {
        get: function () {
            return this.expressionExecutor.expression;
        },
        set: function (value) {
            this.expressionExecutor.expression = value;
        },
        enumerable: false,
        configurable: true
    });
    ExpressionRunnerBase.prototype.getVariables = function () {
        return this.expressionExecutor.getVariables();
    };
    ExpressionRunnerBase.prototype.hasFunction = function () {
        return this.expressionExecutor.hasFunction();
    };
    Object.defineProperty(ExpressionRunnerBase.prototype, "isAsync", {
        get: function () {
            return this.expressionExecutor.isAsync;
        },
        enumerable: false,
        configurable: true
    });
    ExpressionRunnerBase.prototype.canRun = function () {
        return this.expressionExecutor.canRun();
    };
    ExpressionRunnerBase.prototype.runCore = function (values, properties) {
        if (properties === void 0) { properties = null; }
        return this.expressionExecutor.run(values, properties);
    };
    ExpressionRunnerBase.prototype.doOnComplete = function (res) { };
    return ExpressionRunnerBase;
}());

var ConditionRunner = /** @class */ (function (_super) {
    __extends(ConditionRunner, _super);
    function ConditionRunner() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    ConditionRunner.prototype.run = function (values, properties) {
        if (properties === void 0) { properties = null; }
        return this.runCore(values, properties) == true;
    };
    ConditionRunner.prototype.doOnComplete = function (res) {
        if (!!this.onRunComplete)
            this.onRunComplete(res == true);
    };
    return ConditionRunner;
}(ExpressionRunnerBase));

var ExpressionRunner = /** @class */ (function (_super) {
    __extends(ExpressionRunner, _super);
    function ExpressionRunner() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    ExpressionRunner.prototype.run = function (values, properties) {
        if (properties === void 0) { properties = null; }
        return this.runCore(values, properties);
    };
    ExpressionRunner.prototype.doOnComplete = function (res) {
        if (!!this.onRunComplete)
            this.onRunComplete(res);
    };
    return ExpressionRunner;
}(ExpressionRunnerBase));



/***/ }),

/***/ "./src/conditionsParser.ts":
/*!*********************************!*\
  !*** ./src/conditionsParser.ts ***!
  \*********************************/
/*! exports provided: ConditionsParserError, ConditionsParser */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "ConditionsParserError", function() { return ConditionsParserError; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "ConditionsParser", function() { return ConditionsParser; });
/* harmony import */ var _expressions_expressionParser__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./expressions/expressionParser */ "./src/expressions/expressionParser.ts");

var ConditionsParserError = /** @class */ (function () {
    function ConditionsParserError(at, code) {
        this.at = at;
        this.code = code;
    }
    return ConditionsParserError;
}());

var ConditionsParser = /** @class */ (function () {
    function ConditionsParser() {
    }
    ConditionsParser.prototype.patchExpression = function (text) {
        return text
            .replace(/=>/g, ">=")
            .replace(/=</g, "<=")
            .replace(/<>/g, "!=")
            .replace(/==/g, "= ")
            .replace(/equals/g, "equal ")
            .replace(/notequals/g, "notequal ");
    };
    ConditionsParser.prototype.createCondition = function (text) {
        return this.parseExpression(text);
    };
    ConditionsParser.prototype.parseExpression = function (text) {
        try {
            var result = ConditionsParser.parserCache[text];
            if (result === undefined) {
                result = Object(_expressions_expressionParser__WEBPACK_IMPORTED_MODULE_0__["parse"])(this.patchExpression(text));
                if (!result.hasAsyncFunction()) {
                    ConditionsParser.parserCache[text] = result;
                }
            }
            return result;
        }
        catch (e) {
            if (e instanceof _expressions_expressionParser__WEBPACK_IMPORTED_MODULE_0__["SyntaxError"]) {
                this.conditionError = new ConditionsParserError(e.location.start.offset, e.message);
            }
        }
    };
    Object.defineProperty(ConditionsParser.prototype, "error", {
        get: function () {
            return this.conditionError;
        },
        enumerable: false,
        configurable: true
    });
    ConditionsParser.parserCache = {};
    return ConditionsParser;
}());



/***/ }),

/***/ "./src/defaultCss/cssbootstrap.ts":
/*!****************************************!*\
  !*** ./src/defaultCss/cssbootstrap.ts ***!
  \****************************************/
/*! exports provided: defaultBootstrapCss */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "defaultBootstrapCss", function() { return defaultBootstrapCss; });
/* harmony import */ var _cssstandard__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./cssstandard */ "./src/defaultCss/cssstandard.ts");

var defaultBootstrapCss = {
    root: "sv_main sv_bootstrap_css",
    container: "sv_container",
    header: "panel-heading card-header",
    body: "panel-body card-block mt-4",
    bodyEmpty: "panel-body card-block mt-4 sv_body_empty",
    footer: "panel-footer card-footer",
    title: "",
    description: "",
    logo: "sv_logo",
    logoImage: "sv_logo__image",
    headerText: "sv_header__text",
    navigationButton: "",
    completedPage: "",
    navigation: {
        complete: "btn sv_complete_btn",
        prev: "btn sv_prev_btn",
        next: "btn sv_next_btn",
        start: "btn sv_start_btn",
        preview: "btn sv_preview_btn",
        edit: "btn sv_edit_btn",
    },
    progress: "progress center-block mx-auto mb-4",
    progressBar: "progress-bar",
    progressTextUnderBar: "sv-hidden",
    progressTextInBar: "sv-hidden",
    progressButtonsContainerCenter: "sv_progress-buttons__container-center",
    progressButtonsContainer: "sv_progress-buttons__container",
    progressButtonsImageButtonLeft: "sv_progress-buttons__image-button-left",
    progressButtonsImageButtonRight: "sv_progress-buttons__image-button-right",
    progressButtonsImageButtonHidden: "sv_progress-buttons__image-button--hidden",
    progressButtonsListContainer: "sv_progress-buttons__list-container",
    progressButtonsList: "sv_progress-buttons__list",
    progressButtonsListElementPassed: "sv_progress-buttons__list-element--passed",
    progressButtonsListElementCurrent: "sv_progress-buttons__list-element--current",
    progressButtonsListElementNonClickable: "sv_progress-buttons__list-element--nonclickable",
    progressButtonsPageTitle: "sv_progress-buttons__page-title",
    progressButtonsPageDescription: "sv_progress-buttons__page-description",
    page: {
        root: "",
        title: "",
        description: "small",
    },
    pageTitle: "",
    pageDescription: "small",
    row: "sv_row",
    question: {
        mainRoot: "sv_qstn",
        flowRoot: "sv_q_flow sv_qstn",
        header: "",
        headerLeft: "title-left",
        content: "",
        contentLeft: "content-left",
        titleLeftRoot: "sv_qstn_left",
        title: "",
        titleExpandable: "sv_q_title_expandable",
        titleExpanded: "sv_q_title_expanded",
        titleCollapsed: "sv_q_title_collapsed",
        number: "sv_q_num",
        description: "small",
        descriptionUnderInput: "small",
        requiredText: "sv_q_required_text",
        comment: "form-control",
        required: "",
        titleRequired: "",
        hasError: "has-error",
        indent: 20,
        formGroup: "form-group",
    },
    panel: {
        title: "sv_p_title",
        titleExpandable: "sv_p_title_expandable",
        titleExpanded: "sv_p_title_expanded",
        titleCollapsed: "sv_p_title_collapsed",
        titleOnError: "",
        icon: "sv_panel_icon",
        iconExpanded: "sv_expanded",
        description: "small sv_p_description",
        container: "sv_p_container",
        footer: "sv_p_footer",
        number: "sv_q_num",
        requiredText: "sv_q_required_text",
    },
    error: {
        root: "alert alert-danger",
        icon: "glyphicon glyphicon-exclamation-sign",
        item: "",
        locationTop: "sv_qstn_error_top",
        locationBottom: "sv_qstn_error_bottom",
    },
    boolean: {
        root: "sv_qbln form-inline checkbox",
        rootRadio: "sv_qbln form-inline checkbox",
        item: "sv-boolean",
        control: "sv-visuallyhidden",
        itemChecked: "sv-boolean--checked checked",
        itemIndeterminate: "sv-boolean--indeterminate",
        itemDisabled: "sv-boolean--disabled",
        switch: "sv-boolean__switch",
        slider: "sv-boolean__slider",
        label: "sv-boolean__label ",
        disabledLabel: "sv-boolean__label--disabled",
        materialDecorator: "sv-item__decorator sv-boolean__decorator",
        itemDecorator: "sv-item__svg sv-boolean__svg",
        checkedPath: "sv-boolean__checked-path",
        uncheckedPath: "sv-boolean__unchecked-path",
        indeterminatePath: "sv-boolean__indeterminate-path",
    },
    checkbox: {
        root: "sv_qcbc sv_qcbx form-inline",
        item: "checkbox",
        itemChecked: "checked",
        itemSelectAll: "sv_q_checkbox_selectall",
        itemNone: "sv_q_checkbox_none",
        itemInline: "sv_q_checkbox_inline",
        itemControl: "",
        itemDecorator: "sv-hidden",
        label: "",
        labelChecked: "",
        controlLabel: "",
        materialDecorator: "checkbox-material",
        other: "sv_q_checkbox_other form-control",
        column: "sv_q_select_column",
    },
    ranking: {
        root: "sv-ranking",
        rootMobileMod: "sv-ranking--mobile",
        rootDragMod: "sv-ranking--drag",
        rootDisabled: "sv-ranking--disabled",
        item: "sv-ranking-item",
        itemContent: "sv-ranking-item__content",
        itemIndex: "sv-ranking-item__index",
        // itemText: "sv-ranking-item__text",
        controlLabel: "sv-ranking-item__text",
        itemGhostNode: "sv-ranking-item__ghost",
        itemIconContainer: "sv-ranking-item__icon-container",
        itemIcon: "sv-ranking-item__icon",
        itemIconHoverMod: "sv-ranking-item__icon--hover",
        itemIconFocusMod: "sv-ranking-item__icon--focus",
        itemGhostMod: "sv-ranking-item--ghost",
        itemDragMod: "sv-ranking-item--drag",
    },
    comment: "form-control",
    dropdown: {
        root: "",
        control: "form-control",
        other: "sv_q_dd_other form-control",
    },
    html: { root: "" },
    image: { root: "sv_q_image", image: "sv_image_image" },
    matrix: {
        root: "table sv_q_matrix",
        label: "sv_q_m_label",
        itemChecked: "checked",
        itemDecorator: "sv-hidden",
        cellText: "sv_q_m_cell_text",
        cellTextSelected: "sv_q_m_cell_selected bg-primary",
        cellLabel: "sv_q_m_cell_label",
    },
    matrixdropdown: {
        root: "table",
        cell: "sv_matrix_cell",
        headerCell: "sv_matrix_cell_header",
        row: "sv_matrix_row",
        rowAdditional: "sv-matrix__row--additional",
        detailRow: "sv_matrix_detail_row",
        detailRowText: "sv_matrix_cell_detail_rowtext",
        detailCell: "sv_matrix_cell_detail",
        detailButton: "sv_matrix_cell_detail_button",
        detailButtonExpanded: "sv_matrix_cell_detail_button_expanded",
        detailIcon: "sv_detail_panel_icon",
        detailIconExpanded: "sv_detail_expanded",
        detailPanelCell: "sv_matrix_cell_detail_panel",
        actionsCell: "sv_matrix_cell sv_matrix_cell_actions",
    },
    matrixdynamic: {
        root: "table",
        button: "button",
        buttonAdd: "",
        buttonRemove: "",
        iconAdd: "",
        iconRemove: "",
        iconDrag: "sv-matrixdynamic__drag-icon",
        headerCell: "sv_matrix_cell_header",
        row: "sv_matrix_row",
        detailRow: "sv_matrix_detail_row",
        detailCell: "sv_matrix_cell_detail",
        detailButton: "sv_matrix_cell_detail_button",
        detailButtonExpanded: "sv_matrix_cell_detail_button_expanded",
        detailIcon: "sv_detail_panel_icon",
        detailIconExpanded: "sv_detail_expanded",
        detailPanelCell: "sv_matrix_cell_detail_panel",
        actionsCell: "sv_matrix_cell sv_matrix_cell_actions",
        emptyRowsSection: "sv_matrix_empty_rows_section",
        emptyRowsText: "sv_matrix_empty_rows_text",
        emptyRowsButton: "",
        ghostRow: "sv-matrix-row--drag-drop-ghost-mod"
    },
    paneldynamic: {
        root: "",
        navigation: "sv-paneldynamic__navigation",
        progressTop: "sv-paneldynamic__progress sv-paneldynamic__progress--top",
        progressBottom: "sv-paneldynamic__progress sv-paneldynamic__progress--bottom",
        title: "sv-title sv-question__title",
        button: "button",
        buttonAdd: "button sv-paneldynamic__add-btn",
        buttonRemove: "sv_p_remove_btn",
        buttonRemoveRight: "button sv-paneldynamic__remove-btn--right",
        buttonPrev: "sv-paneldynamic__prev-btn",
        buttonNext: "sv-paneldynamic__next-btn",
        buttonPrevDisabled: "sv-paneldynamic__prev-btn--disabled",
        buttonNextDisabled: "sv-paneldynamic__next-btn--disabled",
        progressContainer: "sv-paneldynamic__progress-container",
        progress: "sv-progress",
        progressBar: "sv-progress__bar",
        progressText: "sv-paneldynamic__progress-text",
        panelWrapper: "sv_p_wrapper",
        panelWrapperInRow: "sv_p_wrapper_in_row",
        footer: "",
        progressBtnIcon: "icon-progressbutton"
    },
    multipletext: {
        root: "sv_q_mt table",
        itemTitle: "sv_q_mt_title",
        item: "sv_q_mt_item",
        itemLabel: "sv_q_mt_label",
        row: "form-group bmd-form-group",
        itemValue: "sv_q_mt_item_value form-control",
    },
    radiogroup: {
        root: "sv_qcbc form-inline",
        item: "radio",
        itemChecked: "checked",
        itemInline: "sv_q_radiogroup_inline",
        label: "",
        labelChecked: "",
        itemControl: "",
        itemDecorator: "sv-hidden",
        controlLabel: "",
        materialDecorator: "circle",
        other: "sv_q_radiogroup_other form-control",
        clearButton: "sv_q_radiogroup_clear button",
        column: "sv_q_select_column",
    },
    buttongroup: {
        root: "sv-button-group",
        item: "sv-button-group__item",
        itemIcon: "sv-button-group__item-icon",
        itemDecorator: "sv-button-group__item-decorator",
        itemCaption: "sv-button-group__item-caption",
        itemHover: "sv-button-group__item--hover",
        itemSelected: "sv-button-group__item--selected",
        itemDisabled: "sv-button-group__item--disabled",
        itemControl: "sv-visuallyhidden",
    },
    imagepicker: {
        root: "sv_imgsel",
        item: "sv_q_imgsel",
        itemChecked: "checked",
        itemInline: "sv_q_imagepicker_inline",
        label: "sv_q_imgsel_label",
        itemControl: "sv_q_imgsel_control_item",
        image: "sv_q_imgsel_image",
        itemText: "sv_q_imgsel_text",
        clearButton: "sv_q_radiogroup_clear",
    },
    rating: {
        root: "btn-group",
        item: "btn btn-default btn-secondary",
        selected: "active",
        minText: "sv_q_rating_min_text",
        itemText: "sv_q_rating_item_text",
        maxText: "sv_q_rating_max_text",
        disabled: "",
    },
    text: "form-control",
    expression: "form-control",
    file: {
        root: "sv_q_file",
        placeholderInput: "sv_q_file_placeholder",
        preview: "sv_q_file_preview",
        removeButton: "sv_q_file_remove_button",
        fileInput: "sv_q_file_input",
        removeFile: "sv_q_file_remove",
        fileDecorator: "sv-hidden",
        fileSign: "sv_q_file_sign",
        removeButtonBottom: "sv-hidden",
        dragAreaPlaceholder: "sv-hidden",
        fileList: "",
    },
    signaturepad: {
        root: "sv_q_signaturepad sjs_sp_container",
        controls: "sjs_sp_controls",
        placeholder: "sjs_sp_placeholder",
        clearButton: "sjs_sp_clear",
    },
    saveData: {
        root: "",
        saving: "alert alert-info",
        error: "alert alert-danger",
        success: "alert alert-success",
        saveAgainButton: "",
    },
    window: {
        root: "modal-content",
        body: "modal-body",
        header: {
            root: "modal-header panel-title",
            title: "pull-left",
            button: "glyphicon pull-right",
            buttonExpanded: "glyphicon pull-right glyphicon-chevron-up",
            buttonCollapsed: "glyphicon pull-right glyphicon-chevron-down",
        },
    },
};
_cssstandard__WEBPACK_IMPORTED_MODULE_0__["surveyCss"]["bootstrap"] = defaultBootstrapCss;


/***/ }),

/***/ "./src/defaultCss/cssbootstrapmaterial.ts":
/*!************************************************!*\
  !*** ./src/defaultCss/cssbootstrapmaterial.ts ***!
  \************************************************/
/*! exports provided: defaultBootstrapMaterialCss */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "defaultBootstrapMaterialCss", function() { return defaultBootstrapMaterialCss; });
/* harmony import */ var _cssstandard__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./cssstandard */ "./src/defaultCss/cssstandard.ts");

var defaultBootstrapMaterialCss = {
    root: "sv_main sv_bootstrapmaterial_css",
    container: "sv_container",
    header: "card-heading",
    body: "card-body",
    bodyEmpty: "card-body sv_body_empty",
    footer: "card-footer",
    title: "",
    description: "",
    logo: "sv_logo",
    logoImage: "sv_logo__image",
    headerText: "sv_header__text",
    navigationButton: "",
    completedPage: "",
    navigation: {
        complete: "btn sv_complete_btn btn-primary",
        prev: "btn sv_prev_btn btn-primary",
        next: "btn sv_next_btn btn-primary",
        start: "btn sv_start_btn btn-primary",
        preview: "btn sv_preview_btn btn-primary",
        edit: "btn sv_edit_btn btn-primary",
    },
    progress: "progress center-block mx-auto mb-4",
    progressBar: "progress-bar",
    progressTextUnderBar: "sv-hidden",
    progressTextInBar: "sv-hidden",
    progressButtonsContainerCenter: "sv_progress-buttons__container-center",
    progressButtonsContainer: "sv_progress-buttons__container",
    progressButtonsImageButtonLeft: "sv_progress-buttons__image-button-left",
    progressButtonsImageButtonRight: "sv_progress-buttons__image-button-right",
    progressButtonsImageButtonHidden: "sv_progress-buttons__image-button--hidden",
    progressButtonsListContainer: "sv_progress-buttons__list-container",
    progressButtonsList: "sv_progress-buttons__list",
    progressButtonsListElementPassed: "sv_progress-buttons__list-element--passed",
    progressButtonsListElementCurrent: "sv_progress-buttons__list-element--current",
    progressButtonsListElementNonClickable: "sv_progress-buttons__list-element--nonclickable",
    progressButtonsPageTitle: "sv_progress-buttons__page-title",
    progressButtonsPageDescription: "sv_progress-buttons__page-description",
    page: {
        root: "",
        title: "",
        description: "small",
    },
    pageTitle: "",
    pageDescription: "small",
    row: "sv_row",
    question: {
        mainRoot: "sv_qstn form-group bmd-form-group",
        flowRoot: "sv_q_flow form-group bmd-form-group",
        header: "",
        headerLeft: "title-left",
        content: "",
        contentLeft: "content-left",
        titleLeftRoot: "sv_qstn_left",
        requiredText: "sv_q_required_text",
        title: "",
        titleExpandable: "sv_q_title_expandable",
        titleExpanded: "sv_q_title_expanded",
        titleCollapsed: "sv_q_title_collapsed",
        number: "sv_q_num",
        description: "small",
        descriptionUnderInput: "small",
        comment: "form-control",
        required: "",
        titleRequired: "",
        hasError: "has-error",
        indent: 20,
        formGroup: "form-group bmd-form-group",
    },
    panel: {
        title: "sv_p_title",
        titleExpandable: "sv_p_title_expandable",
        titleExpanded: "sv_p_title_expanded",
        titleCollapsed: "sv_p_title_collapsed",
        titleOnError: "",
        icon: "sv_panel_icon",
        iconExpanded: "sv_expanded",
        description: "small sv_p_description",
        container: "sv_p_container",
        footer: "sv_p_footer",
        number: "sv_q_num",
        requiredText: "sv_q_required_text",
    },
    error: {
        root: "alert alert-danger",
        icon: "glyphicon glyphicon-exclamation-sign",
        item: "",
        locationTop: "sv_qstn_error_top",
        locationBottom: "sv_qstn_error_bottom",
    },
    boolean: {
        root: "sv_qbln checkbox",
        rootRadio: "sv_qbln form-inline checkbox",
        item: "sv-boolean",
        control: "sv-visuallyhidden",
        itemChecked: "sv-boolean--checked checked",
        itemIndeterminate: "sv-boolean--indeterminate",
        itemDisabled: "sv-boolean--disabled",
        switch: "sv-boolean__switch",
        slider: "sv-boolean__slider",
        label: "sv-boolean__label ",
        disabledLabel: "sv-boolean__label--disabled",
        materialDecorator: "sv-item__decorator sv-boolean__decorator",
        itemDecorator: "sv-item__svg sv-boolean__svg",
        checkedPath: "sv-boolean__checked-path",
        uncheckedPath: "sv-boolean__unchecked-path",
        indeterminatePath: "sv-boolean__indeterminate-path",
    },
    checkbox: {
        root: "sv_qcbx",
        item: "checkbox",
        itemChecked: "checked",
        itemSelectAll: "sv_q_checkbox_selectall",
        itemNone: "sv_q_checkbox_none",
        itemInline: "sv_q_checkbox_inline",
        itemDecorator: "sv-hidden",
        itemControl: "",
        label: "",
        labelChecked: "",
        controlLabel: "",
        materialDecorator: "checkbox-decorator",
        other: "sv_q_checkbox_other form-control",
        column: "sv_q_select_column",
    },
    ranking: {
        root: "sv-ranking",
        rootMobileMod: "sv-ranking--mobile",
        rootDragMod: "sv-ranking--drag",
        rootDisabled: "sv-ranking--disabled",
        item: "sv-ranking-item",
        itemContent: "sv-ranking-item__content",
        itemIndex: "sv-ranking-item__index",
        // itemText: "sv-ranking-item__text",
        controlLabel: "sv-ranking-item__text",
        itemGhostNode: "sv-ranking-item__ghost",
        itemIconContainer: "sv-ranking-item__icon-container",
        itemIcon: "sv-ranking-item__icon",
        itemIconHoverMod: "sv-ranking-item__icon--hover",
        itemIconFocusMod: "sv-ranking-item__icon--focus",
        itemGhostMod: "sv-ranking-item--ghost",
        itemDragMod: "sv-ranking-item--drag",
    },
    comment: "form-control",
    dropdown: {
        root: "",
        control: "form-control",
        other: "sv_q_dd_other form-control",
    },
    html: { root: "" },
    image: { root: "sv_q_image", image: "sv_image_image" },
    matrix: {
        root: "table sv_q_matrix",
        row: "form-group bmd-form-group",
        label: "sv_q_m_label radio-inline",
        cellText: "sv_q_m_cell_text",
        cellTextSelected: "sv_q_m_cell_selected bg-primary",
        cellLabel: "sv_q_m_cell_label",
        itemValue: "form-control",
        itemChecked: "checked",
        itemDecorator: "sv-hidden",
        materialDecorator: "bmd-radio",
    },
    matrixdropdown: {
        root: "table",
        itemValue: "form-group bmd-form-group",
        headerCell: "sv_matrix_cell_header",
        row: "sv_matrix_row",
        rowAdditional: "sv-matrix__row--additional",
        detailRow: "sv_matrix_detail_row",
        detailRowText: "sv_matrix_cell_detail_rowtext",
        detailCell: "sv_matrix_cell_detail",
        detailButton: "sv_matrix_cell_detail_button",
        detailButtonExpanded: "sv_matrix_cell_detail_button_expanded",
        detailIcon: "sv_detail_panel_icon",
        detailIconExpanded: "sv_detail_expanded",
        detailPanelCell: "sv_matrix_cell_detail_panel",
        actionsCell: "sv_matrix_cell sv_matrix_cell_actions",
    },
    matrixdynamic: {
        mainRoot: "sv_qstn",
        flowRoot: "sv_q_flow",
        root: "table",
        button: "btn btn-primary",
        itemValue: "form-group bmd-form-group",
        buttonAdd: "",
        buttonRemove: "",
        iconAdd: "",
        iconRemove: "",
        iconDrag: "sv-matrixdynamic__drag-icon",
        headerCell: "sv_matrix_cell_header",
        row: "sv_matrix_row",
        detailRow: "sv_matrix_detail_row",
        detailCell: "sv_matrix_cell_detail",
        detailButton: "sv_matrix_cell_detail_button",
        detailButtonExpanded: "sv_matrix_cell_detail_button_expanded",
        detailIcon: "sv_detail_panel_icon",
        detailIconExpanded: "sv_detail_expanded",
        detailPanelCell: "sv_matrix_cell_detail_panel",
        actionsCell: "sv_matrix_cell sv_matrix_cell_actions",
        emptyRowsSection: "sv_matrix_empty_rows_section",
        emptyRowsText: "sv_matrix_empty_rows_text",
        emptyRowsButton: "",
        ghostRow: "sv-matrix-row--drag-drop-ghost-mod"
    },
    paneldynamic: {
        root: "",
        navigation: "sv-paneldynamic__navigation",
        progressTop: "sv-paneldynamic__progress sv-paneldynamic__progress--top",
        progressBottom: "sv-paneldynamic__progress sv-paneldynamic__progress--bottom",
        title: "sv-title sv-question__title",
        button: "button",
        buttonAdd: "button sv-paneldynamic__add-btn btn btn-primary",
        buttonRemove: "button sv-paneldynamic__remove-btn btn btn-primary",
        buttonRemoveRight: "sv-paneldynamic__remove-btn--right",
        buttonPrev: "sv-paneldynamic__prev-btn",
        buttonNext: "sv-paneldynamic__next-btn",
        buttonPrevDisabled: "sv-paneldynamic__prev-btn--disabled",
        buttonNextDisabled: "sv-paneldynamic__next-btn--disabled",
        progressContainer: "sv-paneldynamic__progress-container",
        progress: "sv-progress",
        progressBar: "sv-progress__bar",
        progressText: "sv-paneldynamic__progress-text",
        panelWrapper: "sv_p_wrapper",
        panelWrapperInRow: "sv_p_wrapper_in_row",
        progressBtnIcon: "icon-progressbutton",
        footer: ""
    },
    multipletext: {
        root: "sv_q_mt table",
        itemTitle: "sv_q_mt_title",
        item: "sv_q_mt_item",
        itemLabel: "sv_q_mt_label",
        row: "form-group bmd-form-group",
        itemValue: "sv_q_mt_item_value form-control",
    },
    radiogroup: {
        root: "",
        item: "radio",
        itemChecked: "checked",
        itemInline: "sv_q_radiogroup_inline",
        itemDecorator: "sv-hidden",
        label: "",
        labelChecked: "",
        itemControl: "",
        controlLabel: "sv_q_radiogroup_control_label",
        materialDecorator: "bmd-radio",
        other: "sv_q_radiogroup_other form-control",
        clearButton: "sv_q_radiogroup_clear button btn btn-primary",
        column: "sv_q_select_column",
    },
    buttongroup: {
        root: "sv-button-group",
        item: "sv-button-group__item",
        itemIcon: "sv-button-group__item-icon",
        itemDecorator: "sv-button-group__item-decorator",
        itemCaption: "sv-button-group__item-caption",
        itemSelected: "sv-button-group__item--selected",
        itemHover: "sv-button-group__item--hover",
        itemDisabled: "sv-button-group__item--disabled",
        itemControl: "sv-visuallyhidden",
    },
    imagepicker: {
        root: "sv_imgsel",
        item: "sv_q_imgsel",
        itemChecked: "checked",
        itemInline: "sv_q_imagepicker_inline",
        label: "sv_q_imgsel_label",
        itemControl: "sv_q_imgsel_control_item",
        image: "sv_q_imgsel_image",
        itemText: "sv_q_imgsel_text",
        clearButton: "sv_q_radiogroup_clear",
    },
    rating: {
        root: "btn-group",
        item: "btn btn-default btn-secondary",
        selected: "active",
        minText: "sv_q_rating_min_text",
        itemText: "sv_q_rating_item_text",
        maxText: "sv_q_rating_max_text",
        disabled: "",
    },
    text: "form-control",
    expression: "form-control",
    file: {
        root: "form-group bmd-form-group is-fileinput sv_q_file",
        placeholderInput: "",
        preview: "sv_q_file_preview",
        removeButton: "sv_q_file_remove_button",
        fileInput: "sv_q_file_input",
        fileSign: "sv_q_file_sign",
        removeFile: "sv_q_file_remove",
        fileDecorator: "sv-hidden",
        removeButtonBottom: "sv-hidden",
        dragAreaPlaceholder: "sv-hidden",
        fileList: "",
    },
    signaturepad: {
        root: "sv_q_signaturepad sjs_sp_container",
        controls: "sjs_sp_controls",
        placeholder: "sjs_sp_placeholder",
        clearButton: "sjs_sp_clear",
    },
    saveData: {
        root: "",
        saving: "alert alert-info",
        error: "alert alert-danger",
        success: "alert alert-success",
        saveAgainButton: "",
    },
    window: {
        root: "modal-content",
        body: "modal-body",
        header: {
            root: "modal-header card-title",
            title: "pull-left",
            button: "glyphicon pull-right",
            buttonExpanded: "glyphicon pull-right glyphicon-chevron-up",
            buttonCollapsed: "glyphicon pull-right glyphicon-chevron-down",
        },
    },
};
_cssstandard__WEBPACK_IMPORTED_MODULE_0__["surveyCss"]["bootstrapmaterial"] = defaultBootstrapMaterialCss;


/***/ }),

/***/ "./src/defaultCss/cssmodern.ts":
/*!*************************************!*\
  !*** ./src/defaultCss/cssmodern.ts ***!
  \*************************************/
/*! exports provided: modernCss */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "modernCss", function() { return modernCss; });
/* harmony import */ var _cssstandard__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./cssstandard */ "./src/defaultCss/cssstandard.ts");

var modernCss = {
    root: "sv-root-modern",
    container: "sv-container-modern",
    header: "sv-title sv-container-modern__title",
    headerClose: "sv-container-modern__close",
    body: "sv-body",
    bodyEmpty: "sv-body sv-body--empty",
    footer: "sv-footer sv-body__footer sv-clearfix",
    title: "",
    description: "",
    logo: "sv-logo",
    logoImage: "sv-logo__image",
    headerText: "sv-header__text",
    navigationButton: "",
    completedPage: "sv-completedpage",
    navigation: {
        complete: "sv-btn sv-footer__complete-btn",
        prev: "sv-btn sv-footer__prev-btn",
        next: "sv-btn sv-footer__next-btn",
        start: "sv-btn sv-footer__start-btn",
        preview: "sv-btn sv-footer__preview-btn",
        edit: "sv-btn sv-footer__edit-btn",
    },
    panel: {
        title: "sv-title sv-panel__title",
        titleExpandable: "sv-panel__title--expandable",
        titleExpanded: "sv-panel__title--expanded",
        titleCollapsed: "sv-panel__title--collapsed",
        titleOnError: "sv-panel__title--error",
        description: "sv-description sv-panel__description",
        container: "sv-panel sv-row__panel",
        content: "sv-panel__content",
        icon: "sv-panel__icon",
        iconExpanded: "sv-panel__icon--expanded",
        footer: "sv-panel__footer",
        requiredText: "sv-panel__required-text",
        number: "sv-question__num",
    },
    paneldynamic: {
        root: "sv-paneldynamic",
        navigation: "sv-paneldynamic__navigation",
        title: "sv-title sv-question__title",
        button: "sv-btn",
        buttonRemove: "sv-paneldynamic__remove-btn",
        buttonRemoveRight: "sv-paneldynamic__remove-btn--right",
        buttonAdd: "sv-paneldynamic__add-btn",
        progressTop: "sv-paneldynamic__progress sv-paneldynamic__progress--top",
        progressBottom: "sv-paneldynamic__progress sv-paneldynamic__progress--bottom",
        buttonPrev: "sv-paneldynamic__prev-btn",
        buttonNext: "sv-paneldynamic__next-btn",
        buttonPrevDisabled: "sv-paneldynamic__prev-btn--disabled",
        buttonNextDisabled: "sv-paneldynamic__next-btn--disabled",
        progressContainer: "sv-paneldynamic__progress-container",
        progress: "sv-progress",
        progressBar: "sv-progress__bar",
        progressText: "sv-paneldynamic__progress-text",
        separator: "sv-paneldynamic__separator",
        panelWrapper: "sv-paneldynamic__panel-wrapper",
        panelWrapperInRow: "sv-paneldynamic__panel-wrapper--in-row",
        progressBtnIcon: "icon-progressbutton",
        footer: ""
    },
    progress: "sv-progress sv-body__progress",
    progressBar: "sv-progress__bar",
    progressText: "sv-progress__text",
    progressTextInBar: "sv-hidden",
    progressButtonsContainerCenter: "sv_progress-buttons__container-center",
    progressButtonsContainer: "sv_progress-buttons__container",
    progressButtonsImageButtonLeft: "sv_progress-buttons__image-button-left",
    progressButtonsImageButtonRight: "sv_progress-buttons__image-button-right",
    progressButtonsImageButtonHidden: "sv_progress-buttons__image-button--hidden",
    progressButtonsListContainer: "sv_progress-buttons__list-container",
    progressButtonsList: "sv_progress-buttons__list",
    progressButtonsListElementPassed: "sv_progress-buttons__list-element--passed",
    progressButtonsListElementCurrent: "sv_progress-buttons__list-element--current",
    progressButtonsListElementNonClickable: "sv_progress-buttons__list-element--nonclickable",
    progressButtonsPageTitle: "sv_progress-buttons__page-title",
    progressButtonsPageDescription: "sv_progress-buttons__page-description",
    page: {
        root: "sv-page sv-body__page",
        title: "sv-title sv-page__title",
        description: "sv-description sv-page__description",
    },
    pageTitle: "sv-title sv-page__title",
    pageDescription: "sv-description sv-page__description",
    row: "sv-row sv-clearfix",
    question: {
        mainRoot: "sv-question sv-row__question",
        flowRoot: "sv-question sv-row__question sv-row__question--flow",
        asCell: "sv-table__cell",
        header: "sv-question__header",
        headerLeft: "sv-question__header--location--left",
        headerTop: "sv-question__header--location--top",
        headerBottom: "sv-question__header--location--bottom",
        content: "sv-question__content",
        contentLeft: "sv-question__content--left",
        titleLeftRoot: "",
        answered: "sv-question--answered",
        titleOnAnswer: "sv-question__title--answer",
        titleOnError: "sv-question__title--error",
        title: "sv-title sv-question__title",
        titleExpandable: "sv-question__title--expandable",
        titleExpanded: "sv-question__title--expanded",
        titleCollapsed: "sv-question__title--collapsed",
        icon: "sv-question__icon",
        iconExpanded: "sv-question__icon--expanded",
        requiredText: "sv-question__required-text",
        number: "sv-question__num",
        description: "sv-description sv-question__description",
        descriptionUnderInput: "sv-description sv-question__description",
        comment: "sv-comment",
        required: "sv-question--required",
        titleRequired: "sv-question__title--required",
        indent: 20,
        footer: "sv-question__footer",
        formGroup: "sv-question__form-group",
        hasError: "",
        disabled: "sv-question--disabled",
    },
    image: { root: "sv-image", image: "sv_image_image" },
    error: {
        root: "sv-question__erbox",
        icon: "",
        item: "",
        locationTop: "sv-question__erbox--location--top",
        locationBottom: "sv-question__erbox--location--bottom",
    },
    checkbox: {
        root: "sv-selectbase",
        item: "sv-item sv-checkbox sv-selectbase__item",
        itemSelectAll: "sv-checkbox--selectall",
        itemNone: "sv-checkbox--none",
        itemDisabled: "sv-item--disabled sv-checkbox--disabled",
        itemChecked: "sv-checkbox--checked",
        itemHover: "sv-checkbox--allowhover",
        itemInline: "sv-selectbase__item--inline",
        label: "sv-selectbase__label",
        labelChecked: "",
        itemControl: "sv-visuallyhidden sv-item__control",
        itemDecorator: "sv-item__svg sv-checkbox__svg",
        itemSvgIconId: "#icon-moderncheck",
        controlLabel: "sv-item__control-label",
        materialDecorator: "sv-item__decorator sv-selectbase__decorator sv-checkbox__decorator",
        other: "sv-comment sv-question__other",
        column: "sv-selectbase__column",
    },
    ranking: {
        root: "sv-ranking",
        rootMobileMod: "sv-ranking--mobile",
        rootDragMod: "sv-ranking--drag",
        rootDisabled: "sv-ranking--disabled",
        item: "sv-ranking-item",
        itemContent: "sv-ranking-item__content",
        itemIndex: "sv-ranking-item__index",
        // itemText: "sv-ranking-item__text",
        controlLabel: "sv-ranking-item__text",
        itemGhostNode: "sv-ranking-item__ghost",
        itemIconContainer: "sv-ranking-item__icon-container",
        itemIcon: "sv-ranking-item__icon",
        itemIconHoverMod: "sv-ranking-item__icon--hover",
        itemIconFocusMod: "sv-ranking-item__icon--focus",
        itemGhostMod: "sv-ranking-item--ghost",
        itemDragMod: "sv-ranking-item--drag",
    },
    radiogroup: {
        root: "sv-selectbase",
        item: "sv-item sv-radio sv-selectbase__item",
        itemInline: "sv-selectbase__item--inline",
        label: "sv-selectbase__label",
        labelChecked: "",
        itemDisabled: "sv-item--disabled sv-radio--disabled",
        itemChecked: "sv-radio--checked",
        itemHover: "sv-radio--allowhover",
        itemControl: "sv-visuallyhidden sv-item__control",
        itemDecorator: "sv-item__svg sv-radio__svg",
        itemSvgIconId: "#icon-modernradio",
        controlLabel: "sv-item__control-label",
        materialDecorator: "sv-item__decorator sv-selectbase__decorator sv-radio__decorator",
        other: "sv-comment sv-question__other",
        clearButton: "sv-btn sv-selectbase__clear-btn",
        column: "sv-selectbase__column",
    },
    buttongroup: {
        root: "sv-button-group",
        item: "sv-button-group__item",
        itemIcon: "sv-button-group__item-icon",
        itemDecorator: "sv-button-group__item-decorator",
        itemCaption: "sv-button-group__item-caption",
        itemSelected: "sv-button-group__item--selected",
        itemHover: "sv-button-group__item--hover",
        itemDisabled: "sv-button-group__item--disabled",
        itemControl: "sv-visuallyhidden",
    },
    boolean: {
        root: "sv_qbln",
        rootRadio: "sv_qbln",
        small: "sv-row__question--small",
        item: "sv-boolean sv-item",
        control: "sv-visuallyhidden",
        itemChecked: "sv-boolean--checked",
        itemIndeterminate: "sv-boolean--indeterminate",
        itemDisabled: "sv-item--disabled sv-boolean--disabled",
        switch: "sv-boolean__switch",
        slider: "sv-boolean__slider",
        label: "sv-boolean__label ",
        disabledLabel: "sv-boolean__label--disabled",
        materialDecorator: "sv-item__decorator sv-boolean__decorator ",
        itemDecorator: "sv-item__svg  sv-boolean__svg",
        checkedPath: "sv-boolean__checked-path",
        uncheckedPath: "sv-boolean__unchecked-path",
        indeterminatePath: "sv-boolean__indeterminate-path",
    },
    text: {
        root: "sv-text",
        small: "sv-row__question--small",
        onError: "sv-text--error",
    },
    multipletext: {
        root: "sv-multipletext",
        item: "sv-multipletext__item",
        itemLabel: "sv-multipletext__item-label",
        itemTitle: "sv-multipletext__item-title",
        row: "sv-multipletext__row",
        cell: "sv-multipletext__cell",
    },
    dropdown: {
        root: "",
        small: "sv-row__question--small",
        control: "sv-dropdown",
        selectWrapper: "",
        other: "sv-comment sv-question__other",
        onError: "sv-dropdown--error",
    },
    imagepicker: {
        root: "sv-imagepicker",
        item: "sv-imagepicker__item",
        itemInline: "sv-imagepicker__item--inline",
        itemChecked: "sv-imagepicker__item--checked",
        itemDisabled: "sv-imagepicker__item--disabled",
        itemHover: "sv-imagepicker__item--allowhover",
        label: "sv-imagepicker__label",
        itemControl: "sv-imagepicker__control sv-visuallyhidden",
        image: "sv-imagepicker__image",
        itemText: "sv-imagepicker__text",
        clearButton: "sv-btn",
        other: "sv-comment sv-question__other",
    },
    matrix: {
        tableWrapper: "sv-matrix",
        root: "sv-table sv-matrix-root",
        rowError: "sv-matrix__row--error",
        cell: "sv-table__cell sv-matrix__cell",
        headerCell: "sv-table__cell sv-table__cell--header",
        label: "sv-item sv-radio sv-matrix__label",
        itemValue: "sv-visuallyhidden sv-item__control sv-radio__control",
        itemChecked: "sv-radio--checked",
        itemDisabled: "sv-item--disabled sv-radio--disabled",
        itemHover: "sv-radio--allowhover",
        materialDecorator: "sv-item__decorator sv-radio__decorator",
        itemDecorator: "sv-item__svg sv-radio__svg",
        cellText: "sv-matrix__text",
        cellTextSelected: "sv-matrix__text--checked",
        cellTextDisabled: "sv-matrix__text--disabled",
    },
    matrixdropdown: {
        root: "sv-table sv-matrixdropdown",
        cell: "sv-table__cell",
        headerCell: "sv-table__cell sv-table__cell--header",
        row: "sv-table__row",
        rowAdditional: "sv-table__row--additional",
        detailRow: "sv-table__row--detail",
        detailRowText: "sv-table__cell--detail-rowtext",
        detailCell: "sv-table__cell--detail",
        choiceCell: "sv-table__cell--choice",
        detailButton: "sv-table__cell--detail-button",
        detailButtonExpanded: "sv-table__cell--detail-button--expanded",
        detailIcon: "sv-detail-panel__icon",
        detailIconExpanded: "sv-detail-panel__icon--expanded",
        detailPanelCell: "sv-table__cell--detail-panel",
        actionsCell: "sv-table__cell sv-table__cell--actions",
    },
    matrixdynamic: {
        root: "sv-table sv-matrixdynamic",
        cell: "sv-table__cell",
        headerCell: "sv-table__cell sv-table__cell--header",
        button: "sv-btn",
        buttonAdd: "sv-matrixdynamic__add-btn",
        buttonRemove: "sv-matrixdynamic__remove-btn",
        iconAdd: "",
        iconRemove: "",
        iconDrag: "sv-matrixdynamic__drag-icon",
        row: "sv-table__row",
        detailRow: "sv-table__row--detail",
        detailCell: "sv-table__cell--detail",
        choiceCell: "sv-table__cell--choice",
        detailButton: "sv-table__cell--detail-button",
        detailButtonExpanded: "sv-table__cell--detail-button--expanded",
        detailIcon: "sv-detail-panel__icon",
        detailIconExpanded: "sv-detail-panel__icon--expanded",
        detailPanelCell: "sv-table__cell--detail-panel",
        actionsCell: "sv-table__cell sv-table__cell--actions",
        emptyRowsSection: "sv-table__empty--rows--section",
        emptyRowsText: "sv-table__empty--rows--text",
        emptyRowsButton: "",
        ghostRow: "sv-matrix-row--drag-drop-ghost-mod"
    },
    rating: {
        root: "sv-rating",
        item: "sv-rating__item",
        selected: "sv-rating__item--selected",
        minText: "sv-rating__min-text",
        itemText: "sv-rating__item-text",
        maxText: "sv-rating__max-text",
        itemDisabled: "sv-rating--disabled",
    },
    comment: {
        root: "sv-comment",
        small: "sv-row__question--small",
    },
    expression: "",
    file: {
        root: "sv-file",
        other: "sv-comment sv-question__other",
        placeholderInput: "sv-visuallyhidden",
        preview: "sv-file__preview",
        fileSignBottom: "sv-file__sign",
        fileDecorator: "sv-file__decorator",
        fileInput: "sv-visuallyhidden",
        noFileChosen: "sv-description sv-file__no-file-chosen",
        chooseFile: "sv-btn sv-file__choose-btn",
        controlDisabled: "sv-file__choose-btn--disabled",
        removeButton: "sv-hidden",
        removeButtonBottom: "sv-btn sv-file__clean-btn",
        removeFile: "sv-hidden",
        removeFileSvg: "sv-file__remove-svg",
        removeFileSvgIconId: "icon-removefile",
        wrapper: "sv-file__wrapper",
        dragAreaPlaceholder: "sv-hidden",
        fileList: "",
    },
    signaturepad: {
        root: "sv-signaturepad sjs_sp_container",
        small: "sv-row__question--small",
        controls: "sjs_sp_controls",
        placeholder: "sjs_sp_placeholder",
        clearButton: "sjs_sp_clear",
    },
    saveData: {
        root: "",
        saving: "",
        error: "",
        success: "",
        saveAgainButton: "",
    },
    window: {
        root: "sv_window",
        body: "sv_window_content",
        header: {
            root: "sv_window_title",
            title: "",
            button: "",
            buttonExpanded: "",
            buttonCollapsed: "",
        },
    },
};
_cssstandard__WEBPACK_IMPORTED_MODULE_0__["surveyCss"]["modern"] = modernCss;


/***/ }),

/***/ "./src/defaultCss/cssstandard.ts":
/*!***************************************!*\
  !*** ./src/defaultCss/cssstandard.ts ***!
  \***************************************/
/*! exports provided: surveyCss, defaultStandardCss */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "surveyCss", function() { return surveyCss; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "defaultStandardCss", function() { return defaultStandardCss; });
var surveyCss = {
    currentType: "",
    getCss: function () {
        var loc = this.currentType ? this[this.currentType] : defaultStandardCss;
        if (!loc)
            loc = defaultStandardCss;
        return loc;
    }
};
var defaultStandardCss = {
    root: "sv_main sv_default_css",
    container: "sv_container",
    header: "sv_header",
    body: "sv_body",
    bodyEmpty: "sv_body sv_body_empty",
    footer: "sv_nav",
    title: "",
    description: "",
    logo: "sv_logo",
    logoImage: "sv_logo__image",
    headerText: "sv_header__text",
    navigationButton: "",
    completedPage: "sv_completed_page",
    navigation: {
        complete: "sv_complete_btn",
        prev: "sv_prev_btn",
        next: "sv_next_btn",
        start: "sv_start_btn",
        preview: "sv_preview_btn",
        edit: "sv_edit_btn",
    },
    progress: "sv_progress",
    progressBar: "sv_progress_bar",
    progressTextInBar: "sv-hidden",
    progressButtonsContainerCenter: "sv_progress-buttons__container-center",
    progressButtonsContainer: "sv_progress-buttons__container",
    progressButtonsImageButtonLeft: "sv_progress-buttons__image-button-left",
    progressButtonsImageButtonRight: "sv_progress-buttons__image-button-right",
    progressButtonsImageButtonHidden: "sv_progress-buttons__image-button--hidden",
    progressButtonsListContainer: "sv_progress-buttons__list-container",
    progressButtonsList: "sv_progress-buttons__list",
    progressButtonsListElementPassed: "sv_progress-buttons__list-element--passed",
    progressButtonsListElementCurrent: "sv_progress-buttons__list-element--current",
    progressButtonsListElementNonClickable: "sv_progress-buttons__list-element--nonclickable",
    progressButtonsPageTitle: "sv_progress-buttons__page-title",
    progressButtonsPageDescription: "sv_progress-buttons__page-description",
    page: {
        root: "sv_p_root",
        title: "sv_page_title",
        description: "",
    },
    // TODO: move to the page object
    pageTitle: "sv_page_title",
    pageDescription: "",
    row: "sv_row",
    question: {
        mainRoot: "sv_q sv_qstn",
        flowRoot: "sv_q_flow sv_qstn",
        header: "",
        headerLeft: "title-left",
        content: "",
        contentLeft: "content-left",
        titleLeftRoot: "sv_qstn_left",
        requiredText: "sv_q_required_text",
        title: "sv_q_title",
        titleExpandable: "sv_q_title_expandable",
        titleExpanded: "sv_q_title_expanded",
        titleCollapsed: "sv_q_title_collapsed",
        number: "sv_q_num",
        description: "sv_q_description",
        comment: "",
        required: "",
        titleRequired: "",
        hasError: "",
        indent: 20,
        footer: "sv_q_footer",
        formGroup: "form-group",
        asCell: "sv_matrix_cell",
        icon: "sv_question_icon",
        iconExpanded: "sv_expanded",
        disabled: "sv_q--disabled",
    },
    panel: {
        title: "sv_p_title",
        titleExpandable: "sv_p_title_expandable",
        titleExpanded: "sv_p_title_expanded",
        titleCollapsed: "sv_p_title_collapsed",
        titleOnError: "",
        icon: "sv_panel_icon",
        iconExpanded: "sv_expanded",
        description: "sv_p_description",
        container: "sv_p_container",
        footer: "sv_p_footer",
        number: "sv_q_num",
        requiredText: "sv_q_required_text",
    },
    error: {
        root: "sv_q_erbox",
        icon: "",
        item: "",
        locationTop: "sv_qstn_error_top",
        locationBottom: "sv_qstn_error_bottom",
    },
    boolean: {
        root: "sv_qcbc sv_qbln",
        rootRadio: "sv_qcbc sv_qbln",
        item: "sv-boolean",
        control: "sv-visuallyhidden",
        itemChecked: "sv-boolean--checked checked",
        itemIndeterminate: "sv-boolean--indeterminate",
        itemDisabled: "sv-boolean--disabled",
        switch: "sv-boolean__switch",
        slider: "sv-boolean__slider",
        label: "sv-boolean__label ",
        disabledLabel: "sv-boolean__label--disabled",
        materialDecorator: "sv-item__decorator sv-boolean__decorator",
        itemDecorator: "sv-item__svg sv-boolean__svg",
        checkedPath: "sv-boolean__checked-path",
        uncheckedPath: "sv-boolean__unchecked-path",
        indeterminatePath: "sv-boolean__indeterminate-path",
    },
    checkbox: {
        root: "sv_qcbc sv_qcbx",
        item: "sv_q_checkbox",
        itemSelectAll: "sv_q_checkbox_selectall",
        itemNone: "sv_q_checkbox_none",
        itemChecked: "checked",
        itemInline: "sv_q_checkbox_inline",
        label: "sv_q_checkbox_label",
        labelChecked: "",
        itemControl: "sv_q_checkbox_control_item",
        itemDecorator: "sv-hidden",
        controlLabel: "sv_q_checkbox_control_label",
        other: "sv_q_other sv_q_checkbox_other",
        column: "sv_q_select_column",
    },
    ranking: {
        root: "sv-ranking",
        rootMobileMod: "sv-ranking--mobile",
        rootDragMod: "sv-ranking--drag",
        rootDisabled: "sv-ranking--disabled",
        item: "sv-ranking-item",
        itemContent: "sv-ranking-item__content",
        itemIndex: "sv-ranking-item__index",
        // itemText: "sv-ranking-item__text",
        controlLabel: "sv-ranking-item__text",
        itemGhostNode: "sv-ranking-item__ghost",
        itemIconContainer: "sv-ranking-item__icon-container",
        itemIcon: "sv-ranking-item__icon",
        itemIconHoverMod: "sv-ranking-item__icon--hover",
        itemIconFocusMod: "sv-ranking-item__icon--focus",
        itemGhostMod: "sv-ranking-item--ghost",
        itemDragMod: "sv-ranking-item--drag",
    },
    comment: "",
    dropdown: {
        root: "",
        control: "sv_q_dropdown_control",
        selectWrapper: "sv_select_wrapper",
        other: "sv_q_dd_other",
    },
    html: { root: "" },
    image: { root: "sv_q_image", image: "sv_image_image" },
    matrix: {
        root: "sv_q_matrix",
        label: "sv_q_m_label",
        itemChecked: "checked",
        itemDecorator: "sv-hidden",
        cell: "sv_q_m_cell",
        cellText: "sv_q_m_cell_text",
        cellTextSelected: "sv_q_m_cell_selected",
        cellLabel: "sv_q_m_cell_label",
    },
    matrixdropdown: {
        root: "sv_q_matrix_dropdown",
        cell: "sv_matrix_cell",
        headerCell: "sv_matrix_cell_header",
        row: "sv_matrix_row",
        rowAdditional: "sv-matrix__row--additional",
        detailRow: "sv_matrix_detail_row",
        detailRowText: "sv_matrix_cell_detail_rowtext",
        detailCell: "sv_matrix_cell_detail",
        choiceCell: "sv-table__cell--choice",
        detailButton: "sv_matrix_cell_detail_button",
        detailButtonExpanded: "sv_matrix_cell_detail_button_expanded",
        detailIcon: "sv_detail_panel_icon",
        detailIconExpanded: "sv_detail_expanded",
        detailPanelCell: "sv_matrix_cell_detail_panel",
        actionsCell: "sv_matrix_cell sv_matrix_cell_actions",
    },
    matrixdynamic: {
        root: "sv_q_matrix_dynamic",
        button: "sv_matrix_dynamic_button",
        buttonAdd: "",
        buttonRemove: "",
        iconAdd: "",
        iconRemove: "",
        iconDrag: "sv-matrixdynamic__drag-icon",
        cell: "sv_matrix_cell",
        headerCell: "sv_matrix_cell_header",
        row: "sv_matrix_row",
        detailRow: "sv_matrix_detail_row",
        detailCell: "sv_matrix_cell_detail",
        choiceCell: "sv-table__cell--choice",
        detailButton: "sv_matrix_cell_detail_button",
        detailButtonExpanded: "sv_matrix_cell_detail_button_expanded",
        detailIcon: "sv_detail_panel_icon",
        detailIconExpanded: "sv_detail_expanded",
        detailPanelCell: "sv_matrix_cell_detail_panel",
        actionsCell: "sv_matrix_cell sv_matrix_cell_actions",
        emptyRowsSection: "sv_matrix_empty_rows_section",
        emptyRowsText: "sv_matrix_empty_rows_text",
        emptyRowsButton: "",
        ghostRow: "sv-matrix-row--drag-drop-ghost-mod"
    },
    paneldynamic: {
        root: "sv_panel_dynamic",
        title: "sv_p_title",
        button: "",
        buttonAdd: "sv-paneldynamic__add-btn",
        buttonRemove: "sv_p_remove_btn",
        buttonRemoveRight: "sv_p_remove_btn_right",
        buttonPrev: "sv-paneldynamic__prev-btn",
        buttonPrevDisabled: "sv-paneldynamic__prev-btn--disabled",
        buttonNextDisabled: "sv-paneldynamic__next-btn--disabled",
        buttonNext: "sv-paneldynamic__next-btn",
        progressContainer: "sv-paneldynamic__progress-container",
        progress: "sv-progress",
        progressBar: "sv-progress__bar",
        progressText: "sv-paneldynamic__progress-text",
        panelWrapper: "sv_p_wrapper",
        panelWrapperInRow: "sv_p_wrapper_in_row",
        footer: "",
        progressBtnIcon: "icon-progressbutton"
    },
    multipletext: {
        root: "sv_q_mt",
        itemTitle: "sv_q_mt_title",
        item: "sv_q_mt_item",
        row: "sv_q_mt_row",
        itemLabel: "sv_q_mt_label",
        itemValue: "sv_q_mt_item_value sv_q_text_root",
    },
    radiogroup: {
        root: "sv_qcbc",
        item: "sv_q_radiogroup",
        itemChecked: "checked",
        itemInline: "sv_q_radiogroup_inline",
        itemDecorator: "sv-hidden",
        label: "sv_q_radiogroup_label",
        labelChecked: "",
        itemControl: "sv_q_radiogroup_control_item",
        controlLabel: "",
        other: "sv_q_other sv_q_radiogroup_other",
        clearButton: "sv_q_radiogroup_clear",
        column: "sv_q_select_column",
    },
    buttongroup: {
        root: "sv-button-group",
        item: "sv-button-group__item",
        itemIcon: "sv-button-group__item-icon",
        itemDecorator: "sv-button-group__item-decorator",
        itemCaption: "sv-button-group__item-caption",
        itemHover: "sv-button-group__item--hover",
        itemSelected: "sv-button-group__item--selected",
        itemDisabled: "sv-button-group__item--disabled",
        itemControl: "sv-visuallyhidden",
    },
    imagepicker: {
        root: "sv_imgsel",
        item: "sv_q_imgsel",
        itemChecked: "checked",
        label: "sv_q_imgsel_label",
        itemControl: "sv_q_imgsel_control_item",
        image: "sv_q_imgsel_image",
        itemInline: "sv_q_imagepicker_inline",
        itemText: "sv_q_imgsel_text",
        clearButton: "sv_q_radiogroup_clear",
    },
    rating: {
        root: "sv_q_rating",
        item: "sv_q_rating_item",
        selected: "active",
        minText: "sv_q_rating_min_text",
        itemText: "sv_q_rating_item_text",
        maxText: "sv_q_rating_max_text",
    },
    text: "sv_q_text_root",
    expression: "",
    file: {
        root: "sv_q_file",
        placeholderInput: "sv-visuallyhidden",
        preview: "sv_q_file_preview",
        removeButton: "sv_q_file_remove_button",
        fileInput: "sv-visuallyhidden",
        removeFile: "sv_q_file_remove",
        fileDecorator: "sv-file__decorator",
        fileSign: "sv_q_file_sign",
        chooseFile: "sv_q_file_choose_button",
        noFileChosen: "sv_q_file_placeholder",
        dragAreaPlaceholder: "sv-hidden",
        fileList: "",
    },
    signaturepad: {
        root: "sv_q_signaturepad sjs_sp_container",
        controls: "sjs_sp_controls",
        placeholder: "sjs_sp_placeholder",
        clearButton: "sjs_sp_clear",
    },
    saveData: {
        root: "",
        saving: "",
        error: "",
        success: "",
        saveAgainButton: "",
    },
    window: {
        root: "sv_window",
        body: "sv_window_content",
        header: {
            root: "sv_window_title",
            title: "",
            button: "",
            buttonExpanded: "",
            buttonCollapsed: "",
        },
    },
};
surveyCss["standard"] = defaultStandardCss;


/***/ }),

/***/ "./src/defaultCss/defaultV2Css.ts":
/*!****************************************!*\
  !*** ./src/defaultCss/defaultV2Css.ts ***!
  \****************************************/
/*! exports provided: defaultV2Css */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "defaultV2Css", function() { return defaultV2Css; });
/* harmony import */ var _cssstandard__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./cssstandard */ "./src/defaultCss/cssstandard.ts");

var defaultV2Css = {
    root: "sd-root-modern",
    container: "sd-container-modern",
    header: "sd-title sd-container-modern__title",
    body: "sd-body",
    bodyEmpty: "sd-body sd-body--empty",
    footer: "sd-footer sd-body__navigation sd-clearfix",
    title: "sd-title",
    description: "sd-description",
    logo: "sd-logo",
    logoImage: "sd-logo__image",
    headerText: "sd-header__text",
    navigationButton: "",
    completedPage: "sd-completedpage",
    navigation: {
        complete: "sd-btn sd-btn--action sd-navigation__complete-btn",
        prev: "sd-btn sd-navigation__prev-btn",
        next: "sd-btn sd-navigation__next-btn",
        start: "sd-btn sd-navigation__start-btn",
        preview: "sd-btn sd-navigation__preview-btn",
        edit: "sd-btn sd-navigation__edit-btn"
    },
    panel: {
        title: "sd-title sd-element__title sd-panel__title",
        titleExpandable: "sd-element__title--expandable",
        titleExpanded: "sd-element__title--expanded",
        titleCollapsed: "sd-element__title--collapsed",
        titleOnExpand: "sd-panel__title--expanded",
        titleOnError: "sd-panel__title--error",
        description: "sd-description sd-panel__description",
        container: "sd-element sd-element--complex sd-panel sd-row__panel",
        withFrame: "sd-element--with-frame",
        content: "sd-panel__content",
        icon: "sd-panel__icon",
        iconExpanded: "sd-panel__icon--expanded",
        footer: "sd-panel__footer",
        requiredText: "sd-panel__required-text",
        header: "sd-panel__header sd-element__header sd-element__header--location-top",
        collapsed: "sd-element--collapsed",
        nested: "sd-element--nested",
        invisible: "sd-element--invisible"
    },
    paneldynamic: {
        mainRoot: "sd-element  sd-question sd-question--paneldynamic sd-element--complex sd-question--complex sd-row__question",
        empty: "sd-question--empty",
        root: "sd-paneldynamic",
        navigation: "sd-paneldynamic__navigation",
        title: "sd-title sd-element__title sd-question__title",
        button: "sd-action sd-paneldynamic__btn",
        buttonRemove: "sd-action--negative sd-paneldynamic__remove-btn",
        buttonAdd: "sd-paneldynamic__add-btn",
        buttonPrev: "sd-paneldynamic__prev-btn sd-action--icon sd-action",
        buttonPrevDisabled: "sd-action--disabled",
        buttonNextDisabled: "sd-action--disabled",
        buttonNext: "sd-paneldynamic__next-btn sd-action--icon sd-action",
        progressContainer: "sd-paneldynamic__progress-container",
        progress: "sd-progress",
        progressBar: "sd-progress__bar",
        progressText: "sd-paneldynamic__progress-text",
        separator: "sd-paneldynamic__separator",
        panelWrapper: "sd-paneldynamic__panel-wrapper",
        footer: "sd-paneldynamic__footer",
        footerButtonsContainer: "sd-paneldynamic__buttons-container",
        panelWrapperInRow: "sd-paneldynamic__panel-wrapper--in-row",
        progressBtnIcon: "icon-progressbuttonv2",
        noEntriesPlaceholder: "sd-paneldynamic__placeholder sd-question__placeholder"
    },
    progress: "sd-progress sd-body__progress",
    progressBar: "sd-progress__bar",
    progressText: "sd-progress__text",
    progressButtonsContainerCenter: "sd-progress-buttons__container-center",
    progressButtonsContainer: "sd-progress-buttons__container",
    progressButtonsImageButtonLeft: "sd-progress-buttons__image-button-left",
    progressButtonsImageButtonRight: "sd-progress-buttons__image-button-right",
    progressButtonsImageButtonHidden: "sd-progress-buttons__image-button--hidden",
    progressButtonsListContainer: "sd-progress-buttons__list-container",
    progressButtonsList: "sd-progress-buttons__list",
    progressButtonsListElementPassed: "sd-progress-buttons__list-element--passed",
    progressButtonsListElementCurrent: "sd-progress-buttons__list-element--current",
    progressButtonsListElementNonClickable: "sd-progress-buttons__list-element--nonclickable",
    progressButtonsPageTitle: "sd-progress-buttons__page-title",
    progressButtonsPageDescription: "sd-progress-buttons__page-description",
    progressTextInBar: "sd-hidden",
    page: {
        root: "sd-page sd-body__page",
        title: "sd-title sd-page__title",
        description: "sd-description sd-page__description"
    },
    pageTitle: "sd-title sd-page__title",
    pageDescription: "sd-description sd-page__description",
    row: "sd-row sd-clearfix",
    rowMultiple: "sd-row--multiple",
    question: {
        mainRoot: "sd-element sd-question sd-row__question",
        flowRoot: "sd-element sd-question sd-row__question sd-row__question--flow",
        withFrame: "sd-element--with-frame",
        asCell: "sd-table__cell",
        answered: "sd-question--answered",
        header: "sd-question__header sd-element__header",
        headerLeft: "sd-question__header--location--left",
        headerTop: "sd-question__header--location-top sd-element__header--location-top",
        headerBottom: "sd-question__header--location--bottom",
        content: "sd-question__content",
        contentLeft: "sd-question__content--left",
        titleLeftRoot: "sd-question--left",
        titleOnAnswer: "sd-question__title--answer",
        titleOnError: "sd-question__title--error",
        title: "sd-title sd-element__title sd-question__title",
        titleExpandable: "sd-element__title--expandable",
        titleExpanded: "sd-element__title--expanded",
        titleCollapsed: "sd-element__title--collapsed",
        requiredText: "sd-question__required-text",
        number: "sd-element__num",
        description: "sd-description sd-question__description",
        descriptionUnderInput: "sd-description sd-question__description",
        comment: "sd-input sd-comment",
        other: "sd-input sd-comment",
        required: "sd-question--required",
        titleRequired: "sd-question__title--required",
        indent: 20,
        footer: "sd-question__footer",
        formGroup: "sd-question__form-group",
        hasError: "sd-question--error",
        disabled: "sd-question--disabled",
        collapsed: "sd-element--collapsed",
        nested: "sd-element--nested",
        invisible: "sd-element--invisible"
    },
    image: {
        mainRoot: "sd-question sd-question--image",
        root: "sd-image",
        image: "sd-image__image",
        adaptive: "sd-image__image--adaptive",
        withFrame: ""
    },
    html: {
        mainRoot: "sd-question sd-row__question sd-question--html",
        root: "sd-html",
        withFrame: ""
    },
    error: {
        root: "sd-question__erbox",
        icon: "",
        item: "",
        tooltip: "sd-question__erbox--tooltip",
        aboveQuestion: "sd-question__erbox--above-question",
        locationTop: "sd-question__erbox--location--top",
        locationBottom: "sd-question__erbox--location--bottom"
    },
    checkbox: {
        root: "sd-selectbase",
        rootMultiColumn: "sd-selectbase--multi-column",
        item: "sd-item sd-checkbox sd-selectbase__item",
        itemOnError: "sd-item--error",
        itemSelectAll: "sd-checkbox--selectall",
        itemNone: "sd-checkbox--none",
        itemDisabled: "sd-item--disabled sd-checkbox--disabled",
        itemChecked: "sd-item--checked sd-checkbox--checked",
        itemHover: "sd-item--allowhover sd-checkbox--allowhover",
        itemInline: "sd-selectbase__item--inline",
        label: "sd-selectbase__label",
        labelChecked: "",
        itemControl: "sd-visuallyhidden sd-item__control sd-checkbox__control",
        itemDecorator: "sd-item__svg sd-checkbox__svg",
        itemSvgIconId: "#icon-v2check",
        controlLabel: "sd-item__control-label",
        materialDecorator: "sd-item__decorator sd-checkbox__decorator",
        other: "sd-input sd-comment sd-selectbase__other",
        column: "sd-selectbase__column"
    },
    radiogroup: {
        root: "sd-selectbase",
        rootMultiColumn: "sd-selectbase--multi-column",
        item: "sd-item sd-radio sd-selectbase__item",
        itemOnError: "sd-item--error",
        itemInline: "sd-selectbase__item--inline",
        label: "sd-selectbase__label",
        labelChecked: "",
        itemDisabled: "sd-item--disabled sd-radio--disabled",
        itemChecked: "sd-item--checked sd-radio--checked",
        itemHover: "sd-item--allowhover sd-radio--allowhover",
        itemControl: "sd-visuallyhidden sd-item__control sd-radio__control",
        itemDecorator: "sd-item__svg sd-radio__svg",
        controlLabel: "sd-item__control-label",
        materialDecorator: "sd-item__decorator sd-radio__decorator",
        other: "sd-input sd-comment sd-selectbase__other",
        clearButton: "sd-btn sd-selectbase__clear-btn",
        column: "sd-selectbase__column"
    },
    boolean: {
        mainRoot: "sd-element sd-question sd-row__question sd-question--boolean",
        root: "sv_qcbc sv_qbln sd-scrollable-container",
        rootRadio: "sv_qcbc sv_qbln sd-scrollable-container sd-scrollable-container--compact",
        item: "sd-boolean",
        radioItem: "sd-item",
        radioItemChecked: "sd-item--checked sd-radio--checked",
        radioLabel: "sd-selectbase__label",
        radioControlLabel: "sd-item__control-label",
        radioFieldset: "sd-selectbase",
        itemOnError: "sd-boolean--error",
        control: "sd-boolean__control sd-visuallyhidden",
        itemChecked: "sd-boolean--checked",
        itemIndeterminate: "sd-boolean--indeterminate",
        itemDisabled: "sd-boolean--disabled",
        label: "sd-boolean__label",
        switch: "sd-boolean__switch",
        disabledLabel: "sd-checkbox__label--disabled",
        itemDecorator: "sd-checkbox__hidden",
        materialDecorator: "sd-checkbox__rectangle",
        itemRadioDecorator: "sd-item__svg sd-radio__svg",
        materialRadioDecorator: "sd-item__decorator sd-radio__decorator",
        sliderText: "sd-boolean__thumb-text",
        slider: "sd-boolean__thumb",
        itemControl: "sd-visuallyhidden sd-item__control sd-radio__control",
    },
    text: {
        root: "sd-input sd-text",
        small: "sd-row__question--small",
        controlDisabled: "sd-input--disabled",
        onError: "sd-input--error"
    },
    multipletext: {
        root: "sd-multipletext",
        itemLabel: "sd-multipletext__item-container sd-input",
        itemLabelOnError: "sd-multipletext__item-container--error",
        item: "sd-multipletext__item",
        itemTitle: "sd-multipletext__item-title",
        row: "sd-multipletext__row",
        cell: "sd-multipletext__cell"
    },
    dropdown: {
        root: "sd-selectbase",
        small: "sd-row__question--small",
        selectWrapper: "",
        other: "sd-input sd-comment sd-selectbase__other",
        onError: "sd-input--error",
        label: "sd-selectbase__label",
        item: "sd-item sd-radio sd-selectbase__item",
        itemDisabled: "sd-item--disabled sd-radio--disabled",
        itemChecked: "sd-item--checked sd-radio--checked",
        itemHover: "sd-item--allowhover sd-radio--allowhover",
        itemControl: "sd-visuallyhidden sd-item__control sd-radio__control",
        itemDecorator: "sd-item__svg sd-radio__svg",
        control: "sd-input sd-dropdown",
        controlDisabled: "sd-input--disabled",
        controlEmpty: "sd-dropdown--empty",
        controlLabel: "sd-item__control-label",
        materialDecorator: "sd-item__decorator sd-radio__decorator"
    },
    imagepicker: {
        mainRoot: "sd-element sd-question sd-row__question",
        root: "sd-imagepicker",
        item: "sd-imagepicker__item",
        itemOnError: "sd-imagepicker__item--error",
        itemInline: "sd-imagepicker__item--inline",
        itemChecked: "sd-imagepicker__item--checked",
        itemDisabled: "sd-imagepicker__item--disabled",
        itemHover: "sd-imagepicker__item--allowhover",
        label: "sd-imagepicker__label",
        itemDecorator: "sd-imagepicker__item-decorator",
        imageContainer: "sd-imagepicker__image-container",
        itemControl: "sd-imagepicker__control sd-visuallyhidden",
        image: "sd-imagepicker__image",
        itemText: "sd-imagepicker__text",
        clearButton: "sd-btn",
        other: "sd-input sd-comment"
    },
    matrix: {
        mainRoot: "sd-element sd-question sd-row__question sd-element--complex sd-question--complex sd-question--table",
        tableWrapper: "sd-matrix",
        root: "sd-table sd-matrix__table",
        rowError: "sd-matrix__row--error",
        cell: "sd-table__cell sd-matrix__cell",
        headerCell: "sd-table__cell sd-table__cell--header",
        label: "sd-item sd-radio sd-matrix__label",
        itemOnError: "sd-item--error",
        itemValue: "sd-visuallyhidden sd-item__control sd-radio__control",
        itemChecked: "sd-item--checked sd-radio--checked",
        itemDisabled: "sd-item--disabled sd-radio--disabled",
        itemHover: "sd-radio--allowhover",
        materialDecorator: "sd-item__decorator sd-radio__decorator",
        itemDecorator: "sd-item__svg sd-radio__svg",
        cellText: "sd-matrix__text",
        cellTextSelected: "sd-matrix__text--checked",
        cellTextDisabled: "sd-matrix__text--disabled"
    },
    matrixdropdown: {
        mainRoot: "sd-element sd-question sd-row__question sd-element--complex sd-question--complex sd-question--table",
        rootScroll: "sd-question--scroll",
        root: "sd-table sd-matrixdropdown",
        cell: "sd-table__cell",
        headerCell: "sd-table__cell sd-table__cell--header",
        rowTextCell: "sd-table__cell sd-table__cell--row-text",
        detailButton: "sd-table__cell--detail-button",
        detailButtonExpanded: "sd-table__cell--detail-button--expanded",
        detailIcon: "sd-detail-panel__icon",
        detailIconExpanded: "sd-detail-panel__icon--expanded",
        detailIconId: "icon-expanddetail",
        detailIconExpandedId: "icon-collapsedetail",
        actionsCell: "sd-table__cell sd-table__cell--actions",
        emptyCell: "sd-table__cell--empty",
        verticalCell: "sd-table__cell--vertical",
        cellQuestionWrapper: "sd-table__question-wrapper"
    },
    matrixdynamic: {
        mainRoot: "sd-element sd-question sd-row__question sd-element--complex sd-question--complex sd-question--table",
        rootScroll: "sd-question--scroll",
        empty: "sd-question--empty",
        root: "sd-table sd-matrixdynamic",
        cell: "sd-table__cell",
        headerCell: "sd-table__cell sd-table__cell--header",
        rowTextCell: "sd-table__cell sd-table__cell--row-text",
        button: "sd-action sd-matrixdynamic__btn",
        detailRow: "sd-table__row sd-table__row--detail",
        detailButton: "sd-table__cell--detail-button",
        detailButtonExpanded: "sd-table__cell--detail-button--expanded",
        detailIcon: "sd-detail-panel__icon",
        detailIconExpanded: "sd-detail-panel__icon--expanded",
        detailIconId: "icon-expanddetail",
        detailIconExpandedId: "icon-collapsedetail",
        detailPanelCell: "sd-table__cell--detail-panel",
        actionsCell: "sd-table__cell sd-table__cell--actions",
        buttonAdd: "sd-matrixdynamic__add-btn",
        buttonRemove: "sd-action--negative sd-matrixdynamic__remove-btn",
        iconAdd: "",
        iconRemove: "",
        footer: "sd-matrixdynamic__footer",
        emptyRowsSection: "sd-matrixdynamic__placeholder sd-question__placeholder",
        iconDrag: "sv-matrixdynamic__drag-icon",
        ghostRow: "sv-matrix-row--drag-drop-ghost-mod",
        emptyCell: "sd-table__cell--empty",
        verticalCell: "sd-table__cell--vertical",
        cellQuestionWrapper: "sd-table__question-wrapper"
    },
    rating: {
        rootDropdown: "sd-scrollable-container sd-scrollable-container--compact sd-selectbase",
        root: "sd-scrollable-container sd-rating",
        rootWrappable: "sd-scrollable-container sd-rating sd-rating--wrappable",
        item: "sd-rating__item",
        itemOnError: "sd-rating__item--error",
        itemHover: "sd-rating__item--allowhover",
        selected: "sd-rating__item--selected",
        minText: "sd-rating__item-text sd-rating__min-text",
        itemText: "sd-rating__item-text",
        maxText: "sd-rating__item-text sd-rating__max-text",
        itemDisabled: "sd-rating__item--disabled",
        control: "sd-input sd-dropdown",
        controlDisabled: "sd-input--disabled",
        controlEmpty: "sd-dropdown--empty",
        onError: "sd-input--error",
    },
    comment: {
        root: "sd-input sd-comment",
        small: "sd-row__question--small",
        controlDisabled: "sd-input--disabled",
        onError: "sd-input--error"
    },
    expression: "",
    file: {
        root: "sd-file",
        other: "sd-input sd-comment",
        placeholderInput: "sd-visuallyhidden",
        preview: "sd-file__preview",
        fileSign: "",
        fileList: "sd-file__list",
        fileSignBottom: "sd-file__sign",
        fileDecorator: "sd-file__decorator",
        onError: "sd-file__decorator--error",
        fileDecoratorDrag: "sd-file__decorator--drag",
        fileInput: "sd-visuallyhidden",
        noFileChosen: "sd-description sd-file__no-file-chosen",
        chooseFile: "sd-file__choose-btn",
        chooseFileAsText: "sd-action sd-file__choose-btn--text",
        chooseFileAsIcon: "sd-context-btn sd-file__choose-btn--icon",
        chooseFileIconId: "icon-choosefile",
        disabled: "sd-file__choose-btn--disabled",
        removeButton: "",
        removeButtonBottom: "sd-context-btn sd-context-btn--negative sd-file__btn sd-file__clean-btn",
        removeButtonIconId: "icon-clear",
        removeFile: "sd-hidden",
        removeFileSvg: "",
        removeFileSvgIconId: "icon-delete",
        wrapper: "sd-file__wrapper",
        defaultImage: "sd-file__default-image",
        defaultImageIconId: "icon-defaultfile",
        leftIconId: "icon-arrowleft",
        rightIconId: "icon-arrowright",
        removeFileButton: "sd-context-btn sd-context-btn--negative sd-file__remove-file-button",
        dragAreaPlaceholder: "sd-file__drag-area-placeholder",
        imageWrapper: "sd-file__image-wrapper",
        single: "sd-file--single",
        singleImage: "sd-file--single-image",
        mobile: "sd-file--mobile"
    },
    signaturepad: {
        mainRoot: "sd-element sd-question sd-question--signature sd-row__question",
        root: "sd-signaturepad sjs_sp_container",
        small: "sd-row__question--small",
        controls: "sjs_sp_controls sd-signaturepad__controls",
        placeholder: "sjs_sp_placeholder",
        clearButton: "sjs_sp_clear sd-context-btn sd-context-btn--negative sd-signaturepad__clear",
        clearButtonIconId: "icon-clear"
    },
    saveData: {
        root: "",
        saving: "",
        error: "",
        success: "",
        saveAgainButton: ""
    },
    window: {
        root: "sv_window",
        body: "sv_window_content",
        header: {
            root: "sv_window_title",
            title: "",
            button: "",
            buttonExpanded: "",
            buttonCollapsed: ""
        }
    },
    ranking: {
        root: "sv-ranking",
        rootMobileMod: "sv-ranking--mobile",
        rootDragMod: "sv-ranking--drag",
        rootDisabled: "sv-ranking--disabled",
        item: "sv-ranking-item",
        itemContent: "sv-ranking-item__content",
        itemIndex: "sv-ranking-item__index",
        // itemText: "sv-ranking-item__text",
        controlLabel: "sv-ranking-item__text",
        itemGhostNode: "sv-ranking-item__ghost",
        itemIconContainer: "sv-ranking-item__icon-container",
        itemIcon: "sv-ranking-item__icon",
        itemIconHoverMod: "sv-ranking-item__icon--hover",
        itemIconFocusMod: "sv-ranking-item__icon--focus",
        itemGhostMod: "sv-ranking-item--ghost",
        itemDragMod: "sv-ranking--drag",
        itemOnError: "sv-ranking-item--error",
    },
    actionBar: {
        root: "sd-action-bar",
        item: "sd-action",
        itemPressed: "sd-action--pressed",
        itemAsIcon: "sd-action--icon",
        itemIcon: "sd-action__icon",
        itemTitle: "sd-action__title",
    },
};
_cssstandard__WEBPACK_IMPORTED_MODULE_0__["surveyCss"]["defaultV2"] = defaultV2Css;


/***/ }),

/***/ "./src/defaultTitle.ts":
/*!*****************************!*\
  !*** ./src/defaultTitle.ts ***!
  \*****************************/
/*! exports provided: DefaultTitleModel */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "DefaultTitleModel", function() { return DefaultTitleModel; });
/* harmony import */ var _utils_cssClassBuilder__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./utils/cssClassBuilder */ "./src/utils/cssClassBuilder.ts");

var DefaultTitleModel = /** @class */ (function () {
    function DefaultTitleModel() {
    }
    DefaultTitleModel.getIconCss = function (cssClasses, isCollapsed) {
        return new _utils_cssClassBuilder__WEBPACK_IMPORTED_MODULE_0__["CssClassBuilder"]()
            .append(cssClasses.icon)
            .append(cssClasses.iconExpanded, !isCollapsed)
            .toString();
    };
    return DefaultTitleModel;
}());



/***/ }),

/***/ "./src/dragdrop/choices.ts":
/*!*********************************!*\
  !*** ./src/dragdrop/choices.ts ***!
  \*********************************/
/*! exports provided: DragDropChoices */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "DragDropChoices", function() { return DragDropChoices; });
/* harmony import */ var _core__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./core */ "./src/dragdrop/core.ts");
var __extends = (undefined && undefined.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();

var DragDropChoices = /** @class */ (function (_super) {
    __extends(DragDropChoices, _super);
    function DragDropChoices() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    Object.defineProperty(DragDropChoices.prototype, "draggedElementType", {
        get: function () {
            return "item-value";
        },
        enumerable: false,
        configurable: true
    });
    DragDropChoices.prototype.createDraggedElementShortcut = function (text, draggedElementNode, event) {
        if (this.parentElement.getType() === "imagepicker") {
            return this.createImagePickerShortcut(text, draggedElementNode, event);
        }
        var draggedElementShortcut = document.createElement("div");
        // draggedElementShortcut.innerText = text;
        draggedElementShortcut.style.cssText = " \n          cursor: grabbing;\n          position: absolute;\n          z-index: 1000;\n          font-family: \"Open Sans\";\n        ";
        var isDeepClone = true;
        var clone = (draggedElementNode
            .closest("[data-sv-drop-target-item-value]")
            .cloneNode(isDeepClone));
        clone.style.cssText = "\n      min-width: 100px;\n      box-shadow: 0px 8px 16px rgba(0, 0, 0, 0.1);\n      background-color: white;\n      border-radius: 36px;\n      padding-right: 16px;\n    ";
        var dragIcon = clone.querySelector(".svc-item-value-controls__drag-icon");
        dragIcon.style.visibility = "visible";
        var removeIcon = clone.querySelector(".svc-item-value-controls__remove");
        removeIcon.style.backgroundColor = "transparent";
        clone.classList.remove("svc-item-value--moveup");
        clone.classList.remove("svc-item-value--movedown");
        this.draggedElement.isDragDropMoveDown = false;
        this.draggedElement.isDragDropMoveUp = false;
        draggedElementShortcut.appendChild(clone);
        var rect = draggedElementNode.getBoundingClientRect();
        draggedElementShortcut.shortcutXOffset = event.clientX - rect.x;
        draggedElementShortcut.shortcutYOffset = event.clientY - rect.y;
        this.isBottom = null;
        return draggedElementShortcut;
    };
    DragDropChoices.prototype.createImagePickerShortcut = function (text, draggedElementNode, event) {
        var draggedElementShortcut = document.createElement("div");
        draggedElementShortcut.style.cssText = " \n      cursor: grabbing;\n      position: absolute;\n      z-index: 1000;\n      box-shadow: 0px 8px 16px rgba(0, 0, 0, 0.1);\n      padding: 4px;\n      border-radius: 4px;\n      background: white;\n    ";
        var itemValueNode = draggedElementNode.closest("[data-sv-drop-target-item-value]");
        var controlsNode = itemValueNode.querySelector(".svc-image-item-value-controls");
        var imageContainerNode = itemValueNode.querySelector(".sd-imagepicker__image-container");
        var imageNode = itemValueNode.querySelector("img");
        controlsNode.style.display = "none";
        imageContainerNode.style.width = imageNode.width + "px";
        imageContainerNode.style.height = imageNode.height + "px";
        imageNode.style.objectFit = "cover";
        imageNode.style.borderRadius = "4px";
        draggedElementShortcut.appendChild(imageNode);
        return draggedElementShortcut;
    };
    DragDropChoices.prototype.findDropTargetNodeByDragOverNode = function (dragOverNode) {
        var result = dragOverNode.closest(this.dropTargetDataAttributeName);
        return result;
    };
    DragDropChoices.prototype.getDropTargetByDataAttributeValue = function (dataAttributeValue) {
        var dragOverChoice;
        dragOverChoice = this.parentElement.choices.filter(function (choice) { return "" + choice.value == dataAttributeValue; })[0];
        return dragOverChoice;
    };
    DragDropChoices.prototype.getVisibleChoices = function () {
        var parent = this.parentElement;
        if (parent.getType() === "ranking")
            return parent.rankingChoices;
        return parent.visibleChoices;
    };
    DragDropChoices.prototype.isDropTargetValid = function (dropTarget) {
        var choices = this.getVisibleChoices();
        if (this.parentElement.getType() !== "imagepicker") {
            var dropTargetIndex = choices.indexOf(this.dropTarget);
            var draggedElementIndex = choices.indexOf(this.draggedElement);
            if (draggedElementIndex > dropTargetIndex && this.dropTarget.isDragDropMoveUp) {
                this.dropTarget.isDragDropMoveUp = false;
                return false;
            }
            if (draggedElementIndex < dropTargetIndex && this.dropTarget.isDragDropMoveDown) {
                this.dropTarget.isDragDropMoveDown = false;
                return false;
            }
        }
        // shouldn't allow to drop on "adorners" (selectall, none, other)
        if (choices.indexOf(dropTarget) === -1)
            return false;
        return true;
    };
    DragDropChoices.prototype.calculateIsBottom = function (clientY) {
        var choices = this.getVisibleChoices();
        return (choices.indexOf(this.dropTarget) - choices.indexOf(this.draggedElement) >
            0);
    };
    DragDropChoices.prototype.afterDragOver = function (dropTargetNode) {
        if (this.isDropTargetDoesntChanged(this.isBottom))
            return;
        if (this.dropTarget === this.draggedElement)
            return;
        var choices = this.getVisibleChoices();
        var dropTargetIndex = choices.indexOf(this.dropTarget);
        var draggedElementIndex = choices.indexOf(this.draggedElement);
        choices.splice(draggedElementIndex, 1);
        choices.splice(dropTargetIndex, 0, this.draggedElement);
        if (this.parentElement.getType() === "imagepicker")
            return;
        if (draggedElementIndex !== dropTargetIndex) {
            dropTargetNode.classList.remove("svc-item-value--moveup");
            dropTargetNode.classList.remove("svc-item-value--movedown");
            this.dropTarget.isDragDropMoveDown = false;
            this.dropTarget.isDragDropMoveUp = false;
        }
        if (draggedElementIndex > dropTargetIndex) {
            this.dropTarget.isDragDropMoveDown = true;
        }
        if (draggedElementIndex < dropTargetIndex) {
            this.dropTarget.isDragDropMoveUp = true;
        }
        _super.prototype.ghostPositionChanged.call(this);
    };
    DragDropChoices.prototype.doDrop = function () {
        var choices = this.parentElement.choices;
        var filteredChoices = this.getVisibleChoices().filter(function (item) {
            return choices.indexOf(item) !== -1;
        });
        var oldIndex = choices.indexOf(this.draggedElement);
        var newIndex = filteredChoices.indexOf(this.draggedElement);
        choices.splice(oldIndex, 1);
        choices.splice(newIndex, 0, this.draggedElement);
        return this.parentElement;
    };
    DragDropChoices.prototype.doClear = function () {
        this.updateVisibleChoices();
    };
    DragDropChoices.prototype.updateVisibleChoices = function () {
        var parent = this.parentElement;
        this.parentElement.getType() === "ranking" ?
            parent.updateRankingChoices() :
            parent["updateVisibleChoices"]();
    };
    return DragDropChoices;
}(_core__WEBPACK_IMPORTED_MODULE_0__["DragDropCore"]));



/***/ }),

/***/ "./src/dragdrop/core.ts":
/*!******************************!*\
  !*** ./src/dragdrop/core.ts ***!
  \******************************/
/*! exports provided: DragDropCore */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "DragDropCore", function() { return DragDropCore; });
/* harmony import */ var _base__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../base */ "./src/base.ts");
/* harmony import */ var _jsonobject__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../jsonobject */ "./src/jsonobject.ts");
/* harmony import */ var _utils_utils__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../utils/utils */ "./src/utils/utils.ts");
/* harmony import */ var _utils_devices__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../utils/devices */ "./src/utils/devices.ts");
var __extends = (undefined && undefined.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __decorate = (undefined && undefined.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};




// WebKit requires cancelable `touchmove` events to be added as early as possible
// see https://bugs.webkit.org/show_bug.cgi?id=184250
if (typeof window !== "undefined") {
    window.addEventListener("touchmove", function (event) {
        if (!DragDropCore.PreventScrolling) {
            return;
        }
        // Prevent scrolling
        event.preventDefault();
    }, { passive: false });
}
var DragDropCore = /** @class */ (function (_super) {
    __extends(DragDropCore, _super);
    function DragDropCore(surveyValue, creator) {
        var _this = _super.call(this) || this;
        _this.surveyValue = surveyValue;
        _this.creator = creator;
        _this.onGhostPositionChanged = new _base__WEBPACK_IMPORTED_MODULE_0__["EventBase"]();
        _this.onBeforeDrop = new _base__WEBPACK_IMPORTED_MODULE_0__["EventBase"]();
        _this.onAfterDrop = new _base__WEBPACK_IMPORTED_MODULE_0__["EventBase"]();
        _this.draggedElement = null;
        _this.dropTarget = null;
        _this.prevDropTarget = null;
        _this.draggedElementShortcut = null;
        _this.scrollIntervalId = null;
        _this.allowDropHere = false;
        _this.stopLongTapIfMoveEnough = function (pointerMoveEvent) {
            pointerMoveEvent.preventDefault();
            _this.currentX = pointerMoveEvent.pageX;
            _this.currentY = pointerMoveEvent.pageY;
            if (_this.isMicroMovement)
                return;
            document.body.style.setProperty("touch-action", "");
            document.body.style.setProperty("user-select", "");
            document.body.style.setProperty("-webkit-user-select", "");
            _this.stopLongTap();
        };
        _this.stopLongTap = function (e) {
            clearTimeout(_this.timeoutID);
            _this.timeoutID = null;
            document.removeEventListener("pointerup", _this.stopLongTap);
            document.removeEventListener("pointermove", _this.stopLongTapIfMoveEnough);
        };
        _this.onContextMenu = function (event) {
            event.preventDefault();
            event.stopPropagation();
        };
        _this.dragOver = function (event) {
            _this.moveShortcutElement(event);
            _this.draggedElementShortcut.style.cursor = "grabbing";
            var dropTargetNode = _this.findDropTargetNodeFromPoint(event.clientX, event.clientY);
            if (!dropTargetNode) {
                _this.banDropHere();
                return;
            }
            _this.dropTarget = _this.getDropTargetByNode(dropTargetNode, event);
            var isDropTargetValid = _this.isDropTargetValid(_this.dropTarget, dropTargetNode);
            _this.doDragOver(dropTargetNode);
            if (!isDropTargetValid) {
                _this.banDropHere();
                return;
            }
            var isBottom = _this.calculateIsBottom(event.clientY, dropTargetNode);
            _this.allowDropHere = true;
            if (_this.isDropTargetDoesntChanged(isBottom))
                return;
            _this.isBottom = null; //TODO need for property change trigger with guarantee but it would be better not to watch on isBottom property but have some event like onValidTargetDragOver
            _this.isBottom = isBottom;
            _this.afterDragOver(dropTargetNode);
            _this.prevDropTarget = _this.dropTarget;
        };
        _this.drop = function () {
            if (_this.allowDropHere) {
                _this.onBeforeDrop.fire(_this, null);
                var newElement = _this.doDrop();
                _this.onAfterDrop.fire(_this, { draggedElement: newElement });
            }
            _this.clear();
        };
        _this.handlePointerCancel = function (event) {
            _this.clear();
        };
        _this.handleEscapeButton = function (event) {
            if (event.keyCode == 27) {
                _this.clear();
            }
        };
        _this.banDropHere = function () {
            _this.allowDropHere = false;
            _this.doBanDropHere();
            _this.dropTarget = null;
            _this.draggedElementShortcut.style.cursor = "not-allowed";
            _this.isBottom = null;
        };
        _this.doBanDropHere = function () { };
        _this.clear = function () {
            cancelAnimationFrame(_this.scrollIntervalId);
            document.removeEventListener("pointermove", _this.dragOver);
            document.removeEventListener("pointercancel", _this.handlePointerCancel);
            document.removeEventListener("keydown", _this.handleEscapeButton);
            document.removeEventListener("pointerup", _this.drop);
            _this.draggedElementShortcut.removeEventListener("pointerup", _this.drop);
            if (_utils_devices__WEBPACK_IMPORTED_MODULE_3__["IsTouch"]) {
                _this.draggedElementShortcut.removeEventListener("contextmenu", _this.onContextMenu);
            }
            document.body.removeChild(_this.draggedElementShortcut);
            _this.doClear();
            _this.dropTarget = null;
            _this.draggedElementShortcut = null;
            _this.draggedElement = null;
            _this.isBottom = null;
            _this.parentElement = null;
            _this.scrollIntervalId = null;
            if (_utils_devices__WEBPACK_IMPORTED_MODULE_3__["IsTouch"]) {
                _this.savedTargetNode && document.body.removeChild(_this.savedTargetNode);
                DragDropCore.PreventScrolling = false;
            }
            document.body.style.setProperty("touch-action", "");
            document.body.style.setProperty("user-select", "");
            document.body.style.setProperty("-webkit-user-select", "");
        };
        return _this;
    }
    DragDropCore.prototype.ghostPositionChanged = function () {
        this.onGhostPositionChanged.fire({}, {});
    };
    Object.defineProperty(DragDropCore.prototype, "dropTargetDataAttributeName", {
        get: function () {
            return "[data-sv-drop-target-".concat(this.draggedElementType, "]");
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(DragDropCore.prototype, "survey", {
        get: function () {
            return this.surveyValue || this.creator.survey;
        },
        enumerable: false,
        configurable: true
    });
    DragDropCore.prototype.startDrag = function (event, draggedElement, parentElement, draggedElementNode, preventSaveTargetNode) {
        if (preventSaveTargetNode === void 0) { preventSaveTargetNode = false; }
        if (_utils_devices__WEBPACK_IMPORTED_MODULE_3__["IsTouch"]) {
            this.startLongTapProcessing(event, draggedElement, parentElement, draggedElementNode, preventSaveTargetNode);
            return;
        }
        this.doStartDrag(event, draggedElement, parentElement, draggedElementNode);
    };
    DragDropCore.prototype.startLongTapProcessing = function (event, draggedElement, parentElement, draggedElementNode, preventSaveTargetNode) {
        var _this = this;
        if (preventSaveTargetNode === void 0) { preventSaveTargetNode = false; }
        this.startX = event.pageX;
        this.startY = event.pageY;
        document.body.style.setProperty("touch-action", "none", "important");
        document.body.style.setProperty("user-select", "none", "important");
        document.body.style.setProperty("-webkit-user-select", "none", "important");
        this.timeoutID = setTimeout(function () {
            _this.doStartDrag(event, draggedElement, parentElement, draggedElementNode);
            if (!preventSaveTargetNode) {
                _this.savedTargetNode = event.target;
                _this.savedTargetNode.style.cssText =
                    "\n          position: absolute;\n          height: 1px!important;\n          width: 1px!important;\n          overflow: hidden;\n          clip: rect(1px 1px 1px 1px);\n          clip: rect(1px, 1px, 1px, 1px);\n        ";
                document.body.appendChild(_this.savedTargetNode);
            }
            _this.stopLongTap();
        }, 500);
        document.addEventListener("pointerup", this.stopLongTap);
        document.addEventListener("pointermove", this.stopLongTapIfMoveEnough);
    };
    Object.defineProperty(DragDropCore.prototype, "isMicroMovement", {
        // see https://stackoverflow.com/questions/6042202/how-to-distinguish-mouse-click-and-drag
        get: function () {
            var delta = 5;
            var diffX = Math.abs(this.currentX - this.startX);
            var diffY = Math.abs(this.currentY - this.startY);
            return diffX < delta && diffY < delta;
        },
        enumerable: false,
        configurable: true
    });
    // EO long tap
    DragDropCore.prototype.doStartDrag = function (event, draggedElement, parentElement, draggedElementNode) {
        if (_utils_devices__WEBPACK_IMPORTED_MODULE_3__["IsTouch"]) {
            DragDropCore.PreventScrolling = true;
        }
        if (event.which === 3)
            return; //right mouse btn
        this.draggedElement = draggedElement;
        this.parentElement = parentElement;
        this.onStartDrag();
        var shortcutText = this.getShortcutText(this.draggedElement);
        this.draggedElementShortcut = this.createDraggedElementShortcut(shortcutText, draggedElementNode, event);
        document.body.append(this.draggedElementShortcut);
        this.moveShortcutElement(event);
        document.addEventListener("pointermove", this.dragOver);
        document.addEventListener("pointercancel", this.handlePointerCancel);
        document.addEventListener("keydown", this.handleEscapeButton);
        document.addEventListener("pointerup", this.drop);
        if (!_utils_devices__WEBPACK_IMPORTED_MODULE_3__["IsTouch"]) {
            this.draggedElementShortcut.addEventListener("pointerup", this.drop);
        }
        else {
            this.draggedElementShortcut.addEventListener("contextmenu", this.onContextMenu);
        }
    };
    DragDropCore.prototype.isDropTargetDoesntChanged = function (newIsBottom) {
        return (this.dropTarget === this.prevDropTarget && newIsBottom === this.isBottom);
    };
    DragDropCore.prototype.onStartDrag = function () { };
    DragDropCore.prototype.getShortcutText = function (draggedElement) {
        return draggedElement.shortcutText;
    };
    DragDropCore.prototype.createDraggedElementShortcut = function (text, draggedElementNode, event) {
        var draggedElementShortcut = document.createElement("div");
        draggedElementShortcut.innerText = text;
        draggedElementShortcut.className = this.getDraggedElementClass();
        return draggedElementShortcut;
    };
    DragDropCore.prototype.getDraggedElementClass = function () {
        return "sv-dragged-element-shortcut";
    };
    DragDropCore.prototype.doDragOver = function (dropTargetNode) { };
    DragDropCore.prototype.afterDragOver = function (dropTargetNode) { };
    DragDropCore.prototype.getGhostPosition = function (item) {
        if (this.dropTarget !== item)
            return null;
        if (this.isBottom)
            return "bottom";
        return "top";
    };
    DragDropCore.prototype.moveShortcutElement = function (event) {
        this.doScroll(event.clientY, event.clientX);
        var shortcutHeight = this.draggedElementShortcut.offsetHeight;
        var shortcutWidth = this.draggedElementShortcut.offsetWidth;
        var shortcutXOffset = this.draggedElementShortcut.shortcutXOffset || shortcutWidth / 2;
        var shortcutYOffset = this.draggedElementShortcut.shortcutYOffset || shortcutHeight / 2;
        var documentBottom = document.documentElement.clientHeight;
        var documentRight = document.documentElement.clientWidth;
        var shortcutBottomCoordinate = this.getShortcutBottomCoordinate(event.clientY, shortcutHeight, shortcutYOffset);
        var shortcutRightCoordinate = this.getShortcutRightCoordinate(event.clientX, shortcutWidth, shortcutXOffset);
        if (shortcutRightCoordinate >= documentRight) {
            this.draggedElementShortcut.style.left =
                event.pageX -
                    event.clientX +
                    documentRight -
                    shortcutWidth +
                    "px";
            this.draggedElementShortcut.style.top =
                event.pageY - shortcutYOffset + "px";
            return;
        }
        if (event.clientX - shortcutXOffset <= 0) {
            this.draggedElementShortcut.style.left =
                event.pageX - event.clientX + "px";
            this.draggedElementShortcut.style.top =
                event.pageY - shortcutYOffset + "px";
            return;
        }
        if (shortcutBottomCoordinate >= documentBottom) {
            this.draggedElementShortcut.style.left =
                event.pageX - shortcutXOffset + "px";
            this.draggedElementShortcut.style.top =
                event.pageY -
                    event.clientY +
                    documentBottom -
                    shortcutHeight +
                    "px";
            return;
        }
        if (event.clientY - shortcutYOffset <= 0) {
            this.draggedElementShortcut.style.left =
                event.pageX - shortcutXOffset + "px";
            this.draggedElementShortcut.style.top =
                event.pageY - event.clientY + "px";
            return;
        }
        this.draggedElementShortcut.style.left =
            event.pageX - shortcutXOffset + "px";
        this.draggedElementShortcut.style.top =
            event.pageY - shortcutYOffset + "px";
    };
    DragDropCore.prototype.getShortcutBottomCoordinate = function (currentY, shortcutHeight, shortcutYOffset) {
        return currentY + shortcutHeight - shortcutYOffset;
    };
    DragDropCore.prototype.getShortcutRightCoordinate = function (currentX, shortcutWidth, shortcutXOffset) {
        return currentX + shortcutWidth - shortcutXOffset;
    };
    DragDropCore.prototype.doScroll = function (clientY, clientX) {
        var _this = this;
        cancelAnimationFrame(this.scrollIntervalId);
        var startScrollBoundary = 50;
        this.draggedElementShortcut.hidden = true;
        var dragOverNode = document.elementFromPoint(clientX, clientY);
        this.draggedElementShortcut.hidden = false;
        var scrollableParentNode = Object(_utils_utils__WEBPACK_IMPORTED_MODULE_2__["findScrollableParent"])(dragOverNode);
        var top;
        var bottom;
        var left;
        var right;
        if (scrollableParentNode.tagName === "HTML") {
            top = 0;
            bottom = document.documentElement.clientHeight;
            left = 0;
            right = document.documentElement.clientWidth;
        }
        else {
            top = scrollableParentNode.getBoundingClientRect().top;
            bottom = scrollableParentNode.getBoundingClientRect().bottom;
            left = scrollableParentNode.getBoundingClientRect().left;
            right = scrollableParentNode.getBoundingClientRect().right;
        }
        var repeat = function () {
            if (clientY - top <= startScrollBoundary) {
                scrollableParentNode.scrollTop -= 15;
            }
            else if (bottom - clientY <= startScrollBoundary) {
                scrollableParentNode.scrollTop += 15;
            }
            else if (right - clientX <= startScrollBoundary) {
                scrollableParentNode.scrollLeft += 15;
            }
            else if (clientX - left <= startScrollBoundary) {
                scrollableParentNode.scrollLeft -= 15;
            }
            _this.scrollIntervalId = requestAnimationFrame(repeat);
        };
        this.scrollIntervalId = requestAnimationFrame(repeat);
    };
    DragDropCore.prototype.getDataAttributeValueByNode = function (node) {
        var _this = this;
        var datasetName = "svDropTarget";
        var words = this.draggedElementType.split("-");
        words.forEach(function (word) {
            datasetName += _this.capitalizeFirstLetter(word);
        });
        return node.dataset[datasetName];
    };
    DragDropCore.prototype.getDropTargetByNode = function (dropTargetNode, event) {
        var dataAttributeValue = this.getDataAttributeValueByNode(dropTargetNode);
        return this.getDropTargetByDataAttributeValue(dataAttributeValue, dropTargetNode, event);
    };
    DragDropCore.prototype.capitalizeFirstLetter = function (string) {
        return string.charAt(0).toUpperCase() + string.slice(1);
    };
    DragDropCore.prototype.calculateMiddleOfHTMLElement = function (HTMLElement) {
        var rect = HTMLElement.getBoundingClientRect();
        return rect.y + rect.height / 2;
    };
    DragDropCore.prototype.findDropTargetNodeFromPoint = function (clientX, clientY) {
        this.draggedElementShortcut.hidden = true;
        var dragOverNode = document.elementFromPoint(clientX, clientY);
        this.draggedElementShortcut.hidden = false;
        if (!dragOverNode)
            return null;
        return this.findDropTargetNodeByDragOverNode(dragOverNode);
    };
    DragDropCore.prototype.findDropTargetNodeByDragOverNode = function (dragOverNode) {
        var result = dragOverNode.querySelector(this.dropTargetDataAttributeName) ||
            dragOverNode.closest(this.dropTargetDataAttributeName);
        return result;
    };
    DragDropCore.prototype.doClear = function () { };
    DragDropCore.PreventScrolling = false;
    __decorate([
        Object(_jsonobject__WEBPACK_IMPORTED_MODULE_1__["property"])({
            defaultValue: null,
            onSet: function (val, target) {
                target.ghostPositionChanged();
            },
        })
    ], DragDropCore.prototype, "isBottom", void 0);
    return DragDropCore;
}(_base__WEBPACK_IMPORTED_MODULE_0__["Base"]));



/***/ }),

/***/ "./src/dragdrop/matrix-rows.ts":
/*!*************************************!*\
  !*** ./src/dragdrop/matrix-rows.ts ***!
  \*************************************/
/*! exports provided: DragDropMatrixRows */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "DragDropMatrixRows", function() { return DragDropMatrixRows; });
/* harmony import */ var _core__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./core */ "./src/dragdrop/core.ts");
var __extends = (undefined && undefined.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();

var DragDropMatrixRows = /** @class */ (function (_super) {
    __extends(DragDropMatrixRows, _super);
    function DragDropMatrixRows() {
        var _this = _super !== null && _super.apply(this, arguments) || this;
        _this.fromIndex = null;
        _this.toIndex = null;
        _this.doDrop = function () {
            _this.parentElement.moveRowByIndex(_this.fromIndex, _this.toIndex);
            return _this.parentElement;
        };
        return _this;
    }
    Object.defineProperty(DragDropMatrixRows.prototype, "draggedElementType", {
        get: function () {
            return "matrix-row";
        },
        enumerable: false,
        configurable: true
    });
    DragDropMatrixRows.prototype.createDraggedElementShortcut = function (text, draggedElementNode, event) {
        var _this = this;
        var draggedElementShortcut = document.createElement("div");
        // draggedElementShortcut.innerText = text;
        draggedElementShortcut.style.cssText = " \n          cursor: grabbing;\n          position: absolute;\n          z-index: 1000;\n          font-family: \"Open Sans\";\n        ";
        var isDeepClone = true;
        var row = (draggedElementNode
            .closest("[data-sv-drop-target-matrix-row]"));
        var clone = (row.cloneNode(isDeepClone));
        clone.style.cssText = "\n      box-shadow: rgb(0 0 0 / 10%) 0px 8px 16px;\n      background-color: white;\n      display: flex;\n      flex-grow: 0;\n      flex-shrink: 0;\n      align-items: center;\n      line-height: 0;\n      width: ".concat(row.offsetWidth, "px;\n    ");
        clone.classList.remove("sv-matrix__drag-drop--moveup");
        clone.classList.remove("sv-matrix__drag-drop--movedown");
        this.draggedElement.isDragDropMoveDown = false;
        this.draggedElement.isDragDropMoveUp = false;
        draggedElementShortcut.appendChild(clone);
        var rect = draggedElementNode.getBoundingClientRect();
        draggedElementShortcut.shortcutXOffset = event.clientX - rect.x;
        draggedElementShortcut.shortcutYOffset = event.clientY - rect.y;
        //this.isBottom = null;
        var renderedRows = this.parentElement.renderedTable.rows;
        renderedRows.forEach(function (renderedRow, index) {
            if (renderedRow.row === _this.draggedElement) {
                renderedRow.isGhostRow = true;
            }
        });
        this.fromIndex = this.parentElement.visibleRows.indexOf(this.draggedElement);
        return draggedElementShortcut;
    };
    // protected ghostPositionChanged(): void {
    //   let ghostPosition;
    //   this.parentElement.renderedTable.rows.forEach(
    //     (renderedRow: QuestionMatrixDropdownRenderedRow) => {
    //       ghostPosition = this.getGhostPosition(
    //         renderedRow.row
    //       );
    //       renderedRow.isGhostRow = !ghostPosition;
    //     }
    //   );
    //   super.ghostPositionChanged();
    // }
    DragDropMatrixRows.prototype.getDropTargetByDataAttributeValue = function (dataAttributeValue) {
        var matrix = this.parentElement;
        var dropTargetRenderedRow;
        dropTargetRenderedRow = matrix.renderedTable.rows.filter(function (renderedRow) { return renderedRow.row.id === dataAttributeValue; })[0];
        return dropTargetRenderedRow.row;
    };
    DragDropMatrixRows.prototype.isDropTargetValid = function (dropTarget) {
        return true;
    };
    DragDropMatrixRows.prototype.findDropTargetNodeByDragOverNode = function (dragOverNode) {
        var result = dragOverNode.closest(this.dropTargetDataAttributeName);
        return result;
    };
    DragDropMatrixRows.prototype.calculateIsBottom = function (clientY) {
        var rendreredRows = this.parentElement.renderedTable.rows;
        var rows = rendreredRows.map(function (rendredRow) { return rendredRow.row; });
        return (rows.indexOf(this.dropTarget) - rows.indexOf(this.draggedElement) > 0);
    };
    DragDropMatrixRows.prototype.afterDragOver = function (dropTargetNode) {
        var _this = this;
        if (this.isDropTargetDoesntChanged(this.isBottom))
            return;
        if (this.dropTarget === this.draggedElement)
            return;
        var dropTargetIndex;
        var draggedElementIndex;
        var draggedRenderedRow;
        var renderedRows = this.parentElement.renderedTable.rows;
        renderedRows.forEach(function (renderedRow, index) {
            if (renderedRow.row === _this.dropTarget) {
                // renderedRow.isGhostRow = true;
                dropTargetIndex = index;
            }
            if (renderedRow.row === _this.draggedElement) {
                draggedRenderedRow = renderedRow;
                draggedElementIndex = index;
                draggedRenderedRow.isGhostRow = true;
            }
        });
        renderedRows.splice(draggedElementIndex, 1);
        renderedRows.splice(dropTargetIndex, 0, draggedRenderedRow);
        this.toIndex = dropTargetIndex;
        // const matrix = this.parentElement;
        // const fromIndex = matrix.visibleRows.indexOf(this.draggedElement);
        // const toIndex = matrix.visibleRows.indexOf(this.dropTarget);
        // matrix.moveRowByIndex(fromIndex, toIndex);
        // if (draggedElementIndex !== dropTargetIndex) {
        //   dropTargetNode.classList.remove("sv-matrix__drag-drop--moveup");
        //   dropTargetNode.classList.remove("sv-matrix__drag-drop--movedown");
        //   this.dropTarget.isDragDropMoveDown = false;
        //   this.dropTarget.isDragDropMoveUp = false;
        // }
        // if (draggedElementIndex > dropTargetIndex) {
        //   this.dropTarget.isDragDropMoveDown = true;
        // }
        // if (draggedElementIndex < dropTargetIndex) {
        //   this.dropTarget.isDragDropMoveUp = true;
        // }
        _super.prototype.ghostPositionChanged.call(this);
    };
    DragDropMatrixRows.prototype.doClear = function () {
        this.parentElement["resetRenderedTable"]();
        this.fromIndex = null;
        this.toIndex = null;
    };
    return DragDropMatrixRows;
}(_core__WEBPACK_IMPORTED_MODULE_0__["DragDropCore"]));



/***/ }),

/***/ "./src/dragdrop/ranking-choices.ts":
/*!*****************************************!*\
  !*** ./src/dragdrop/ranking-choices.ts ***!
  \*****************************************/
/*! exports provided: DragDropRankingChoices */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "DragDropRankingChoices", function() { return DragDropRankingChoices; });
/* harmony import */ var _choices__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./choices */ "./src/dragdrop/choices.ts");
/* harmony import */ var _utils_cssClassBuilder__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../utils/cssClassBuilder */ "./src/utils/cssClassBuilder.ts");
/* harmony import */ var _utils_devices__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../utils/devices */ "./src/utils/devices.ts");
var __extends = (undefined && undefined.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();



var DragDropRankingChoices = /** @class */ (function (_super) {
    __extends(DragDropRankingChoices, _super);
    function DragDropRankingChoices() {
        var _this = _super !== null && _super.apply(this, arguments) || this;
        _this.isDragOverRootNode = false;
        _this.doDragOver = function () {
            var node = _this.draggedElementShortcut.querySelector(".sv-ranking-item");
            node.style.cursor = "grabbing";
        };
        _this.doBanDropHere = function () {
            if (_this.isDragOverRootNode) {
                _this.allowDropHere = true;
                return;
            }
            var node = _this.draggedElementShortcut.querySelector(".sv-ranking-item");
            node.style.cursor = "not-allowed";
        };
        _this.doDrop = function () {
            _this.parentElement.setValue();
            return _this.parentElement;
        };
        _this.doClear = function () {
            _this.parentElement.dropTargetNodeMove = null;
            _this.parentElement.updateRankingChoices();
        };
        return _this;
    }
    Object.defineProperty(DragDropRankingChoices.prototype, "draggedElementType", {
        get: function () {
            return "ranking-item";
        },
        enumerable: false,
        configurable: true
    });
    DragDropRankingChoices.prototype.createDraggedElementShortcut = function (text, draggedElementNode) {
        var draggedElementShortcut = document.createElement("div");
        draggedElementShortcut.className = this.shortcutClass;
        draggedElementShortcut.style.cssText = " \n          cursor: grabbing;\n          position: absolute;\n          z-index: 1000;\n          border-radius: 36px;\n          min-width: 100px;\n          box-shadow: 0px 8px 16px rgba(0, 0, 0, 0.1);\n          background-color: white;\n          padding-right: 16px;\n          padding-left: 20px;\n          font-family: \"Open Sans\";\n        ";
        var isDeepClone = true;
        var clone = draggedElementNode.cloneNode(isDeepClone);
        draggedElementShortcut.appendChild(clone);
        return draggedElementShortcut;
    };
    Object.defineProperty(DragDropRankingChoices.prototype, "shortcutClass", {
        get: function () {
            return new _utils_cssClassBuilder__WEBPACK_IMPORTED_MODULE_1__["CssClassBuilder"]()
                .append(this.parentElement.cssClasses.root)
                .append(this.parentElement.cssClasses.rootMobileMod, _utils_devices__WEBPACK_IMPORTED_MODULE_2__["IsMobile"])
                .toString();
        },
        enumerable: false,
        configurable: true
    });
    DragDropRankingChoices.prototype.getDropTargetByDataAttributeValue = function (dataAttributeValue) {
        return this.parentElement.rankingChoices[dataAttributeValue];
    };
    DragDropRankingChoices.prototype.findDropTargetNodeByDragOverNode = function (dragOverNode) {
        this.isDragOverRootNode = this.getIsDragOverRootNode(dragOverNode);
        return dragOverNode.closest(this.dropTargetDataAttributeName);
    };
    DragDropRankingChoices.prototype.getIsDragOverRootNode = function (dragOverNode) {
        // dragOverNode might be <path></path> for example and the className prop is obj
        return typeof dragOverNode.className === "string" &&
            dragOverNode.className.indexOf("sv-ranking") !== -1;
    };
    DragDropRankingChoices.prototype.isDropTargetValid = function (dropTarget, dropTargetNode) {
        var choices = this.parentElement.rankingChoices;
        var dropTargetIndex = choices.indexOf(this.dropTarget);
        var draggedElementIndex = choices.indexOf(this.draggedElement);
        if (draggedElementIndex > dropTargetIndex && dropTargetNode.classList.contains("sv-dragdrop-moveup")) {
            this.parentElement.dropTargetNodeMove = null;
            return false;
        }
        if (draggedElementIndex < dropTargetIndex && dropTargetNode.classList.contains("sv-dragdrop-movedown")) {
            this.parentElement.dropTargetNodeMove = null;
            return false;
        }
        if (choices.indexOf(dropTarget) === -1)
            // shouldn't allow to drop on "adorners" (selectall, none, other)
            return false;
        return true;
    };
    DragDropRankingChoices.prototype.calculateIsBottom = function (clientY) {
        var choices = this.parentElement.rankingChoices;
        return (choices.indexOf(this.dropTarget) - choices.indexOf(this.draggedElement) >
            0);
    };
    DragDropRankingChoices.prototype.afterDragOver = function (dropTargetNode) {
        var choices = this.parentElement.rankingChoices;
        var dropTargetIndex = choices.indexOf(this.dropTarget);
        var draggedElementIndex = choices.indexOf(this.draggedElement);
        choices.splice(draggedElementIndex, 1);
        choices.splice(dropTargetIndex, 0, this.draggedElement);
        this.parentElement.setPropertyValue("rankingChoices", choices);
        //return;
        this.updateDraggedElementShortcut(dropTargetIndex + 1);
        if (draggedElementIndex !== dropTargetIndex) {
            dropTargetNode.classList.remove("sv-dragdrop-moveup");
            dropTargetNode.classList.remove("sv-dragdrop-movedown");
            this.parentElement.dropTargetNodeMove = null;
        }
        if (draggedElementIndex > dropTargetIndex) {
            this.parentElement.dropTargetNodeMove = "down";
        }
        if (draggedElementIndex < dropTargetIndex) {
            this.parentElement.dropTargetNodeMove = "up";
        }
    };
    DragDropRankingChoices.prototype.updateDraggedElementShortcut = function (newIndex) {
        var newIndexText = newIndex + "";
        // TODO should avoid direct DOM manipulation, do through the frameworks instead
        var indexNode = this.draggedElementShortcut.querySelector(".sv-ranking-item__index");
        indexNode.innerText = newIndexText;
    };
    DragDropRankingChoices.prototype.ghostPositionChanged = function () {
        this.parentElement.currentDropTarget = this.draggedElement;
        _super.prototype.ghostPositionChanged.call(this);
    };
    return DragDropRankingChoices;
}(_choices__WEBPACK_IMPORTED_MODULE_0__["DragDropChoices"]));



/***/ }),

/***/ "./src/dragdrop/survey-elements.ts":
/*!*****************************************!*\
  !*** ./src/dragdrop/survey-elements.ts ***!
  \*****************************************/
/*! exports provided: DragDropSurveyElements */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "DragDropSurveyElements", function() { return DragDropSurveyElements; });
/* harmony import */ var _survey_element__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../survey-element */ "./src/survey-element.ts");
/* harmony import */ var _jsonobject__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../jsonobject */ "./src/jsonobject.ts");
/* harmony import */ var _core__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./core */ "./src/dragdrop/core.ts");
var __extends = (undefined && undefined.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();



var DragDropSurveyElements = /** @class */ (function (_super) {
    __extends(DragDropSurveyElements, _super);
    function DragDropSurveyElements() {
        var _this = _super !== null && _super.apply(this, arguments) || this;
        _this.isEdge = false;
        _this.prevIsEdge = null;
        _this.ghostSurveyElement = null;
        _this.isDraggedElementSelected = false;
        _this.doBanDropHere = function () {
            _this.removeGhostElementFromSurvey();
            _this.isEdge = null;
        };
        _this.doDrop = function () {
            if (_this.dropTarget) {
                document.activeElement.blur();
                return _this.insertRealElementIntoSurvey();
            }
            return null;
        };
        _this.doClear = function () {
            _this.removeGhostElementFromSurvey();
            _this.isEdge = null;
            _this.ghostSurveyElement = null;
            if (!!_this.draggedElement) {
                _this.draggedElement.isDragMe = false;
            }
        };
        return _this;
    }
    Object.defineProperty(DragDropSurveyElements.prototype, "draggedElementType", {
        get: function () {
            return "survey-element";
        },
        enumerable: false,
        configurable: true
    });
    DragDropSurveyElements.prototype.startDragToolboxItem = function (event, draggedElementJson) {
        var preventSaveTargetNode = true;
        var draggedElement = this.createElementFromJson(draggedElementJson);
        this.startDrag(event, draggedElement, null, null, preventSaveTargetNode);
    };
    DragDropSurveyElements.prototype.startDragSurveyElement = function (event, draggedElement, isElementSelected) {
        this.isDraggedElementSelected = isElementSelected;
        this.startDrag(event, draggedElement);
    };
    DragDropSurveyElements.prototype.createDraggedElementShortcut = function (text, draggedElementNode, event) {
        var draggedElementShortcut = document.createElement("div");
        var textSpan = document.createElement("span");
        textSpan.className = "svc-dragged-element-shortcut__text";
        textSpan.innerText = text;
        draggedElementShortcut.appendChild(this.createDraggedElementIcon());
        draggedElementShortcut.appendChild(textSpan);
        draggedElementShortcut.className = this.getDraggedElementClass();
        return draggedElementShortcut;
    };
    DragDropSurveyElements.prototype.createDraggedElementIcon = function () {
        var span = document.createElement("span");
        var type = this.draggedElement.getType();
        var svgString = "<svg class=\"sv-svg-icon\" role=\"img\" style=\"width: 24px; height: 24px;\"><use xlink:href=\"#icon-".concat(type, "\"></use></svg>");
        span.className = "svc-dragged-element-shortcut__icon";
        span.innerHTML = svgString;
        return span;
    };
    DragDropSurveyElements.prototype.getDraggedElementClass = function () {
        var result = "svc-dragged-element-shortcut";
        if (this.isDraggedElementSelected)
            result += " svc-dragged-element-shortcut--selected";
        return result;
    };
    DragDropSurveyElements.prototype.createElementFromJson = function (json) {
        var element = this.createNewElement(json);
        if (element["setSurveyImpl"]) {
            element["setSurveyImpl"](this.survey);
        }
        else {
            element["setData"](this.survey);
        }
        element.renderWidth = "100%";
        return element;
    };
    DragDropSurveyElements.prototype.createNewElement = function (json) {
        var newElement = _jsonobject__WEBPACK_IMPORTED_MODULE_1__["Serializer"].createClass(json["type"]);
        new _jsonobject__WEBPACK_IMPORTED_MODULE_1__["JsonObject"]().toObject(json, newElement);
        return newElement;
    };
    DragDropSurveyElements.prototype.getDropTargetByDataAttributeValue = function (dataAttributeValue, dropTargetNode, event) {
        this.isEdge = this.calculateIsEdge(dropTargetNode, event.clientY);
        if (!dataAttributeValue) {
            // panel dynamic
            var nearestDropTargetElement = dropTargetNode.parentElement.closest(this.dropTargetDataAttributeName);
            dataAttributeValue = this.getDataAttributeValueByNode(nearestDropTargetElement);
        }
        if (!dataAttributeValue) {
            throw new Error("Can't find drop target survey element name");
        }
        if (dataAttributeValue === DragDropSurveyElements.ghostSurveyElementName) {
            return this.prevDropTarget;
        }
        // drop to new page
        if (dataAttributeValue === "newGhostPage") {
            return DragDropSurveyElements.newGhostPage;
        }
        // drop to page
        var page = this.survey.getPageByName(dataAttributeValue);
        if (page) {
            if (
            // TODO we can't drop on not empty page directly for now
            page.elements.length !== 0) {
                return null;
            }
            return page;
        }
        // drop to question or panel
        var dropTarget;
        var question;
        this.survey.pages.forEach(function (page) {
            question = page.getElementByName(dataAttributeValue);
            if (question)
                dropTarget = question;
        });
        // drop to paneldynamic
        if (dropTarget.getType() === "paneldynamic" && !this.isEdge) {
            dropTarget = dropTarget.template;
        }
        // drop to matrix detail panel
        if ((dropTarget.getType() === "matrixdropdown" || dropTarget.getType() === "matrixdynamic") && dropTarget.detailPanelMode !== "none" && !this.isEdge) {
            dropTarget = dropTarget.detailPanel;
        }
        // drop to panel
        else if (dropTarget.isPanel) {
            dropTarget = this.getPanelDropTarget(dropTargetNode, dropTarget, event);
        }
        // drop to question
        //question inside paneldymanic
        if (!dropTarget.page) {
            var nearestDropTargetPageElement = dropTargetNode.parentElement.closest("[data-sv-drop-target-page]");
            dataAttributeValue = nearestDropTargetPageElement.dataset.svDropTargetPage;
            var page_1 = this.survey.getPageByName(dataAttributeValue);
            dropTarget.__page = page_1;
        }
        return dropTarget;
        // EO drop to question or panel
    };
    DragDropSurveyElements.prototype.isDropTargetValid = function () {
        if (!this.dropTarget)
            return false;
        if (this.dropTarget === this.draggedElement)
            return false;
        if (this.draggedElement.getType() === "paneldynamic" &&
            this.dropTarget === this.draggedElement.template)
            return false;
        if (DragDropSurveyElements.restrictDragQuestionBetweenPages &&
            this.shouldRestricDragQuestionBetweenPages(this.dropTarget)) {
            return false;
        }
        return true;
    };
    DragDropSurveyElements.prototype.calculateIsBottom = function (clientY, dropTargetNode) {
        // we shouldn't reculc isBottom if drag over ghost survey element
        if (this.getDataAttributeValueByNode(dropTargetNode) === DragDropSurveyElements.ghostSurveyElementName) {
            return this.isBottom;
        }
        var middle = this.calculateMiddleOfHTMLElement(dropTargetNode);
        return clientY >= middle;
    };
    DragDropSurveyElements.prototype.isDropTargetDoesntChanged = function (newIsBottom) {
        if (this.dropTarget === this.ghostSurveyElement)
            return true;
        return (this.dropTarget === this.prevDropTarget && newIsBottom === this.isBottom
            && this.isEdge === this.prevIsEdge);
    };
    DragDropSurveyElements.prototype.shouldRestricDragQuestionBetweenPages = function (dropTarget) {
        var oldPage = this.draggedElement["page"];
        var newPage = dropTarget.isPage ? dropTarget : dropTarget["page"];
        // if oldPage === null then it is drop from the toolbox
        return oldPage && oldPage !== newPage;
    };
    DragDropSurveyElements.prototype.getPanelDropTarget = function (HTMLElement, dropTarget, event) {
        var isEdge = this.isEdge;
        if (!isEdge && dropTarget.questions.length !== 0) {
            HTMLElement = this.findDeepestDropTargetChild(HTMLElement);
            dropTarget = this.getDropTargetByNode(HTMLElement, event);
        }
        return dropTarget;
    };
    DragDropSurveyElements.prototype.findDeepestDropTargetChild = function (parent) {
        var selector = this.dropTargetDataAttributeName;
        var result = parent;
        while (!!parent) {
            result = parent;
            parent = parent.querySelector(selector);
        }
        return result;
    };
    DragDropSurveyElements.prototype.calculateIsEdge = function (dropTargetNode, clientY) {
        var rect = dropTargetNode.getBoundingClientRect();
        return clientY - rect.top <= DragDropSurveyElements.edgeHeight || rect.bottom - clientY <= DragDropSurveyElements.edgeHeight;
    };
    DragDropSurveyElements.prototype.calculateIsRight = function () {
        var pageOrPanel = this.dropTarget.parent;
        var srcIndex = pageOrPanel.elements.indexOf(this.draggedElement);
        var destIndex = pageOrPanel.elements.indexOf(this.dropTarget);
        return srcIndex < destIndex;
    };
    DragDropSurveyElements.prototype.afterDragOver = function () {
        this.prevIsEdge = this.isEdge;
        this.insertGhostElementIntoSurvey();
    };
    DragDropSurveyElements.prototype.onStartDrag = function () {
        this.ghostSurveyElement = this.createGhostSurveyElement();
        this.draggedElement.isDragMe = true;
    };
    DragDropSurveyElements.prototype.insertGhostElementIntoSurvey = function () {
        this.removeGhostElementFromSurvey();
        var isTargetRowMultiple = this.calcTargetRowMultiple();
        this.ghostSurveyElement = this.createGhostSurveyElement(isTargetRowMultiple);
        this.ghostSurveyElement.name =
            DragDropSurveyElements.ghostSurveyElementName; // TODO why do we need setup it manually see createGhostSurveyElement method
        this.parentElement = this.dropTarget.isPage
            ? this.dropTarget
            : (this.dropTarget.page || this.dropTarget.__page);
        if (this.isDragOverInsideEmptyPanel()) {
            this.dropTarget.dragTypeOverMe = _survey_element__WEBPACK_IMPORTED_MODULE_0__["DragTypeOverMeEnum"].InsideEmptyPanel;
            return;
        }
        if (!this.isEdge && isTargetRowMultiple) {
            this.dropTarget.dragTypeOverMe = this.calculateIsRight() ?
                _survey_element__WEBPACK_IMPORTED_MODULE_0__["DragTypeOverMeEnum"].MultilineRight :
                _survey_element__WEBPACK_IMPORTED_MODULE_0__["DragTypeOverMeEnum"].MultilineLeft;
            return;
        }
        this.parentElement.dragDropStart(this.draggedElement, this.ghostSurveyElement, DragDropSurveyElements.nestedPanelDepth);
        var result = this.parentElement.dragDropMoveTo(this.dropTarget, isTargetRowMultiple ? this.calculateIsRight() : this.isBottom, this.isEdge);
        return result;
    };
    DragDropSurveyElements.prototype.calcTargetRowMultiple = function () {
        var _this = this;
        var targetParent = this.dropTarget.isPage || this.dropTarget.isPanel ? this.dropTarget : this.dropTarget.parent;
        if (this.dropTarget.getType() === "paneldynamic") {
            targetParent = this.dropTarget.templateValue;
        }
        var targetRow;
        targetParent.rows.forEach(function (row) {
            if (row.elements.indexOf(_this.dropTarget) !== -1) {
                targetRow = row;
            }
        });
        var isTargetRowMultiple = targetRow && targetRow.elements.length > 1;
        if (this.isEdge && isTargetRowMultiple) {
            targetParent.__page = this.dropTarget.page;
            this.dropTarget = targetParent;
            return false;
        }
        return isTargetRowMultiple;
    };
    DragDropSurveyElements.prototype.isDragOverInsideEmptyPanel = function () {
        var isEmptyPanel = this.dropTarget.isPanel && this.dropTarget.questions.length === 0;
        var isDragOverInside = !this.isEdge;
        return isEmptyPanel && isDragOverInside;
    };
    DragDropSurveyElements.prototype.removeGhostElementFromSurvey = function () {
        var dropTarget = this.prevDropTarget || this.dropTarget;
        if (!!dropTarget) {
            dropTarget.dragTypeOverMe = null;
        }
        if (!!this.parentElement)
            this.parentElement.dragDropFinish(true);
    };
    DragDropSurveyElements.prototype.insertRealElementIntoSurvey = function () {
        this.removeGhostElementFromSurvey();
        var isTargetRowMultiple = this.calcTargetRowMultiple();
        // ghost new page
        if (this.dropTarget.isPage && this.dropTarget["_isGhost"]) {
            this.dropTarget["_addGhostPageViewModel"]();
        }
        // EO ghost new page
        // fake target element (need only for "startWithNewLine:false" feature)
        //TODO need for dragDrop helper in library
        var json = new _jsonobject__WEBPACK_IMPORTED_MODULE_1__["JsonObject"]().toJsonObject(this.draggedElement);
        json["type"] = this.draggedElement.getType();
        var fakeTargetElement = this.createFakeTargetElement(this.draggedElement.name, json);
        // EO fake target element
        this.parentElement.dragDropStart(this.draggedElement, fakeTargetElement, DragDropSurveyElements.nestedPanelDepth);
        this.parentElement.dragDropMoveTo(this.dropTarget, isTargetRowMultiple ? this.calculateIsRight() : this.isBottom, this.isEdge);
        var newElement = this.parentElement.dragDropFinish();
        return newElement;
    };
    DragDropSurveyElements.prototype.createFakeTargetElement = function (elementName, json) {
        if (!elementName || !json)
            return null;
        var targetElement = null;
        targetElement = _jsonobject__WEBPACK_IMPORTED_MODULE_1__["Serializer"].createClass(json["type"]);
        new _jsonobject__WEBPACK_IMPORTED_MODULE_1__["JsonObject"]().toObject(json, targetElement);
        targetElement.name = elementName;
        if (targetElement["setSurveyImpl"]) {
            targetElement["setSurveyImpl"](this.survey);
        }
        else {
            targetElement["setData"](this.survey);
        }
        targetElement.renderWidth = "100%";
        return targetElement;
    };
    DragDropSurveyElements.prototype.createGhostSurveyElement = function (isMultipleRowDrag) {
        if (isMultipleRowDrag === void 0) { isMultipleRowDrag = false; }
        var className = "sv-drag-drop-ghost";
        var minWidth = "300px";
        if (isMultipleRowDrag) {
            minWidth = "4px";
            className += " sv-drag-drop-ghost--vertical";
        }
        var json = {
            type: "html",
            minWidth: minWidth,
            name: DragDropSurveyElements.ghostSurveyElementName,
            html: "<div class=\"".concat(className, "\"></div>"),
        };
        var element = this.createElementFromJson(json);
        element.startWithNewLine = !isMultipleRowDrag;
        if (isMultipleRowDrag) {
            element.maxWidth = "4px";
            element.renderWidth = "0px";
            element.paddingRight = "0px";
            element.paddingLeft = "0px";
        }
        return element;
    };
    DragDropSurveyElements.newGhostPage = null;
    DragDropSurveyElements.restrictDragQuestionBetweenPages = false;
    DragDropSurveyElements.edgeHeight = 30;
    DragDropSurveyElements.nestedPanelDepth = -1;
    DragDropSurveyElements.ghostSurveyElementName = "sv-drag-drop-ghost-survey-element-name"; // before renaming use globa search (we have also css selectors)
    return DragDropSurveyElements;
}(_core__WEBPACK_IMPORTED_MODULE_2__["DragDropCore"]));



/***/ }),

/***/ "./src/dxSurveyService.ts":
/*!********************************!*\
  !*** ./src/dxSurveyService.ts ***!
  \********************************/
/*! exports provided: dxSurveyService */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "dxSurveyService", function() { return dxSurveyService; });
/* harmony import */ var _settings__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./settings */ "./src/settings.ts");

/**
 * The class contains methods to work with api.surveyjs.io service.
 */
var dxSurveyService = /** @class */ (function () {
    function dxSurveyService() {
    }
    Object.defineProperty(dxSurveyService, "serviceUrl", {
        get: function () {
            return _settings__WEBPACK_IMPORTED_MODULE_0__["settings"].surveyServiceUrl;
        },
        set: function (val) {
            _settings__WEBPACK_IMPORTED_MODULE_0__["settings"].surveyServiceUrl = val;
        },
        enumerable: false,
        configurable: true
    });
    dxSurveyService.prototype.loadSurvey = function (surveyId, onLoad) {
        var xhr = new XMLHttpRequest();
        xhr.open("GET", dxSurveyService.serviceUrl + "/getSurvey?surveyId=" + surveyId);
        xhr.setRequestHeader("Content-Type", "application/x-www-form-urlencoded");
        xhr.onload = function () {
            var result = JSON.parse(xhr.response);
            onLoad(xhr.status == 200, result, xhr.response);
        };
        xhr.send();
    };
    dxSurveyService.prototype.getSurveyJsonAndIsCompleted = function (surveyId, clientId, onLoad) {
        var xhr = new XMLHttpRequest();
        xhr.open("GET", dxSurveyService.serviceUrl +
            "/getSurveyAndIsCompleted?surveyId=" +
            surveyId +
            "&clientId=" +
            clientId);
        xhr.setRequestHeader("Content-Type", "application/x-www-form-urlencoded");
        xhr.onload = function () {
            var result = JSON.parse(xhr.response);
            var surveyJson = result ? result.survey : null;
            var isCompleted = result ? result.isCompleted : null;
            onLoad(xhr.status == 200, surveyJson, isCompleted, xhr.response);
        };
        xhr.send();
    };
    dxSurveyService.prototype.sendResult = function (postId, result, onSendResult, clientId, isPartialCompleted) {
        if (clientId === void 0) { clientId = null; }
        if (isPartialCompleted === void 0) { isPartialCompleted = false; }
        var xhr = new XMLHttpRequest();
        xhr.open("POST", dxSurveyService.serviceUrl + "/post/");
        xhr.setRequestHeader("Content-Type", "application/json; charset=utf-8");
        var data = { postId: postId, surveyResult: JSON.stringify(result) };
        if (clientId)
            data["clientId"] = clientId;
        if (isPartialCompleted)
            data["isPartialCompleted"] = true;
        var dataStringify = JSON.stringify(data);
        var self = this;
        xhr.onload = xhr.onerror = function () {
            if (!onSendResult)
                return;
            onSendResult(xhr.status === 200, xhr.response, xhr);
        };
        xhr.send(dataStringify);
    };
    dxSurveyService.prototype.sendFile = function (postId, file, onSendFile) {
        var xhr = new XMLHttpRequest();
        xhr.onload = xhr.onerror = function () {
            if (!onSendFile)
                return;
            onSendFile(xhr.status == 200, JSON.parse(xhr.response));
        };
        xhr.open("POST", dxSurveyService.serviceUrl + "/upload/", true);
        var formData = new FormData();
        formData.append("file", file);
        formData.append("postId", postId);
        xhr.send(formData);
    };
    dxSurveyService.prototype.getResult = function (resultId, name, onGetResult) {
        var xhr = new XMLHttpRequest();
        var data = "resultId=" + resultId + "&name=" + name;
        xhr.open("GET", dxSurveyService.serviceUrl + "/getResult?" + data);
        xhr.setRequestHeader("Content-Type", "application/x-www-form-urlencoded");
        var self = this;
        xhr.onload = function () {
            var result = null;
            var list = null;
            if (xhr.status == 200) {
                result = JSON.parse(xhr.response);
                list = [];
                for (var key in result.QuestionResult) {
                    var el = { name: key, value: result.QuestionResult[key] };
                    list.push(el);
                }
            }
            onGetResult(xhr.status == 200, result, list, xhr.response);
        };
        xhr.send();
    };
    dxSurveyService.prototype.isCompleted = function (resultId, clientId, onIsCompleted) {
        var xhr = new XMLHttpRequest();
        var data = "resultId=" + resultId + "&clientId=" + clientId;
        xhr.open("GET", dxSurveyService.serviceUrl + "/isCompleted?" + data);
        xhr.setRequestHeader("Content-Type", "application/x-www-form-urlencoded");
        var self = this;
        xhr.onload = function () {
            var result = null;
            if (xhr.status == 200) {
                result = JSON.parse(xhr.response);
            }
            onIsCompleted(xhr.status == 200, result, xhr.response);
        };
        xhr.send();
    };
    return dxSurveyService;
}());



/***/ }),

/***/ "./src/entries/chunks/localization.ts":
/*!********************************************!*\
  !*** ./src/entries/chunks/localization.ts ***!
  \********************************************/
/*! no exports provided */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _localization_arabic__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../localization/arabic */ "./src/localization/arabic.ts");
/* harmony import */ var _localization_basque__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../localization/basque */ "./src/localization/basque.ts");
/* harmony import */ var _localization_bulgarian__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../localization/bulgarian */ "./src/localization/bulgarian.ts");
/* harmony import */ var _localization_catalan__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../localization/catalan */ "./src/localization/catalan.ts");
/* harmony import */ var _localization_croatian__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../../localization/croatian */ "./src/localization/croatian.ts");
/* harmony import */ var _localization_czech__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../../localization/czech */ "./src/localization/czech.ts");
/* harmony import */ var _localization_danish__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../../localization/danish */ "./src/localization/danish.ts");
/* harmony import */ var _localization_dutch__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ../../localization/dutch */ "./src/localization/dutch.ts");
/* harmony import */ var _localization_nl_BE__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ../../localization/nl-BE */ "./src/localization/nl-BE.ts");
/* harmony import */ var _localization_estonian__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ../../localization/estonian */ "./src/localization/estonian.ts");
/* harmony import */ var _localization_finnish__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! ../../localization/finnish */ "./src/localization/finnish.ts");
/* harmony import */ var _localization_french__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! ../../localization/french */ "./src/localization/french.ts");
/* harmony import */ var _localization_georgian__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! ../../localization/georgian */ "./src/localization/georgian.ts");
/* harmony import */ var _localization_german__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! ../../localization/german */ "./src/localization/german.ts");
/* harmony import */ var _localization_greek__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(/*! ../../localization/greek */ "./src/localization/greek.ts");
/* harmony import */ var _localization_hebrew__WEBPACK_IMPORTED_MODULE_15__ = __webpack_require__(/*! ../../localization/hebrew */ "./src/localization/hebrew.ts");
/* harmony import */ var _localization_hindi__WEBPACK_IMPORTED_MODULE_16__ = __webpack_require__(/*! ../../localization/hindi */ "./src/localization/hindi.ts");
/* harmony import */ var _localization_hungarian__WEBPACK_IMPORTED_MODULE_17__ = __webpack_require__(/*! ../../localization/hungarian */ "./src/localization/hungarian.ts");
/* harmony import */ var _localization_icelandic__WEBPACK_IMPORTED_MODULE_18__ = __webpack_require__(/*! ../../localization/icelandic */ "./src/localization/icelandic.ts");
/* harmony import */ var _localization_indonesian__WEBPACK_IMPORTED_MODULE_19__ = __webpack_require__(/*! ../../localization/indonesian */ "./src/localization/indonesian.ts");
/* harmony import */ var _localization_italian__WEBPACK_IMPORTED_MODULE_20__ = __webpack_require__(/*! ../../localization/italian */ "./src/localization/italian.ts");
/* harmony import */ var _localization_japanese__WEBPACK_IMPORTED_MODULE_21__ = __webpack_require__(/*! ../../localization/japanese */ "./src/localization/japanese.ts");
/* harmony import */ var _localization_kazakh__WEBPACK_IMPORTED_MODULE_22__ = __webpack_require__(/*! ../../localization/kazakh */ "./src/localization/kazakh.ts");
/* harmony import */ var _localization_korean__WEBPACK_IMPORTED_MODULE_23__ = __webpack_require__(/*! ../../localization/korean */ "./src/localization/korean.ts");
/* harmony import */ var _localization_latvian__WEBPACK_IMPORTED_MODULE_24__ = __webpack_require__(/*! ../../localization/latvian */ "./src/localization/latvian.ts");
/* harmony import */ var _localization_lithuanian__WEBPACK_IMPORTED_MODULE_25__ = __webpack_require__(/*! ../../localization/lithuanian */ "./src/localization/lithuanian.ts");
/* harmony import */ var _localization_macedonian__WEBPACK_IMPORTED_MODULE_26__ = __webpack_require__(/*! ../../localization/macedonian */ "./src/localization/macedonian.ts");
/* harmony import */ var _localization_malay__WEBPACK_IMPORTED_MODULE_27__ = __webpack_require__(/*! ../../localization/malay */ "./src/localization/malay.ts");
/* harmony import */ var _localization_norwegian__WEBPACK_IMPORTED_MODULE_28__ = __webpack_require__(/*! ../../localization/norwegian */ "./src/localization/norwegian.ts");
/* harmony import */ var _localization_persian__WEBPACK_IMPORTED_MODULE_29__ = __webpack_require__(/*! ../../localization/persian */ "./src/localization/persian.ts");
/* harmony import */ var _localization_polish__WEBPACK_IMPORTED_MODULE_30__ = __webpack_require__(/*! ../../localization/polish */ "./src/localization/polish.ts");
/* harmony import */ var _localization_portuguese__WEBPACK_IMPORTED_MODULE_31__ = __webpack_require__(/*! ../../localization/portuguese */ "./src/localization/portuguese.ts");
/* harmony import */ var _localization_portuguese_br__WEBPACK_IMPORTED_MODULE_32__ = __webpack_require__(/*! ../../localization/portuguese-br */ "./src/localization/portuguese-br.ts");
/* harmony import */ var _localization_romanian__WEBPACK_IMPORTED_MODULE_33__ = __webpack_require__(/*! ../../localization/romanian */ "./src/localization/romanian.ts");
/* harmony import */ var _localization_russian__WEBPACK_IMPORTED_MODULE_34__ = __webpack_require__(/*! ../../localization/russian */ "./src/localization/russian.ts");
/* harmony import */ var _localization_serbian__WEBPACK_IMPORTED_MODULE_35__ = __webpack_require__(/*! ../../localization/serbian */ "./src/localization/serbian.ts");
/* harmony import */ var _localization_simplified_chinese__WEBPACK_IMPORTED_MODULE_36__ = __webpack_require__(/*! ../../localization/simplified-chinese */ "./src/localization/simplified-chinese.ts");
/* harmony import */ var _localization_slovak__WEBPACK_IMPORTED_MODULE_37__ = __webpack_require__(/*! ../../localization/slovak */ "./src/localization/slovak.ts");
/* harmony import */ var _localization_spanish__WEBPACK_IMPORTED_MODULE_38__ = __webpack_require__(/*! ../../localization/spanish */ "./src/localization/spanish.ts");
/* harmony import */ var _localization_swahili__WEBPACK_IMPORTED_MODULE_39__ = __webpack_require__(/*! ../../localization/swahili */ "./src/localization/swahili.ts");
/* harmony import */ var _localization_swedish__WEBPACK_IMPORTED_MODULE_40__ = __webpack_require__(/*! ../../localization/swedish */ "./src/localization/swedish.ts");
/* harmony import */ var _localization_tajik__WEBPACK_IMPORTED_MODULE_41__ = __webpack_require__(/*! ../../localization/tajik */ "./src/localization/tajik.ts");
/* harmony import */ var _localization_thai__WEBPACK_IMPORTED_MODULE_42__ = __webpack_require__(/*! ../../localization/thai */ "./src/localization/thai.ts");
/* harmony import */ var _localization_traditional_chinese__WEBPACK_IMPORTED_MODULE_43__ = __webpack_require__(/*! ../../localization/traditional-chinese */ "./src/localization/traditional-chinese.ts");
/* harmony import */ var _localization_turkish__WEBPACK_IMPORTED_MODULE_44__ = __webpack_require__(/*! ../../localization/turkish */ "./src/localization/turkish.ts");
/* harmony import */ var _localization_ukrainian__WEBPACK_IMPORTED_MODULE_45__ = __webpack_require__(/*! ../../localization/ukrainian */ "./src/localization/ukrainian.ts");
/* harmony import */ var _localization_vietnamese__WEBPACK_IMPORTED_MODULE_46__ = __webpack_require__(/*! ../../localization/vietnamese */ "./src/localization/vietnamese.ts");
/* harmony import */ var _localization_welsh__WEBPACK_IMPORTED_MODULE_47__ = __webpack_require__(/*! ../../localization/welsh */ "./src/localization/welsh.ts");


















































/***/ }),

/***/ "./src/entries/chunks/model.ts":
/*!*************************************!*\
  !*** ./src/entries/chunks/model.ts ***!
  \*************************************/
/*! exports provided: Version, settings, Helpers, AnswerCountValidator, EmailValidator, NumericValidator, RegexValidator, SurveyValidator, TextValidator, ValidatorResult, ExpressionValidator, ValidatorRunner, ItemValue, Base, Event, ArrayChanges, ComputedUpdater, SurveyError, SurveyElementCore, SurveyElement, DragTypeOverMeEnum, CalculatedValue, CustomError, AnswerRequiredError, OneAnswerRequiredError, RequreNumericError, ExceedSizeError, LocalizableString, LocalizableStrings, HtmlConditionItem, UrlConditionItem, ChoicesRestful, ChoicesRestfull, FunctionFactory, registerFunction, ConditionRunner, ExpressionRunner, Operand, Const, BinaryOperand, Variable, FunctionOperand, ArrayOperand, ConditionsParser, ProcessValue, JsonError, JsonIncorrectTypeError, JsonMetadata, JsonMetadataClass, JsonMissingTypeError, JsonMissingTypeErrorBase, JsonObject, JsonObjectProperty, JsonRequiredPropertyError, JsonUnknownPropertyError, Serializer, property, propertyArray, MatrixDropdownCell, MatrixDropdownRowModelBase, QuestionMatrixDropdownModelBase, MatrixDropdownColumn, matrixDropdownColumnTypes, QuestionMatrixDropdownRenderedCell, QuestionMatrixDropdownRenderedRow, QuestionMatrixDropdownRenderedTable, MatrixDropdownRowModel, QuestionMatrixDropdownModel, MatrixDynamicRowModel, QuestionMatrixDynamicModel, MatrixRowModel, MatrixCells, QuestionMatrixModel, MultipleTextItemModel, QuestionMultipleTextModel, PanelModel, PanelModelBase, QuestionRowModel, FlowPanelModel, PageModel, DefaultTitleModel, Question, QuestionNonValue, QuestionEmptyModel, QuestionCheckboxBase, QuestionSelectBase, QuestionCheckboxModel, QuestionRankingModel, QuestionCommentModel, QuestionDropdownModel, QuestionFactory, ElementFactory, QuestionFileModel, QuestionHtmlModel, QuestionRadiogroupModel, QuestionRatingModel, RenderedRatingItem, QuestionExpressionModel, QuestionTextModel, QuestionBooleanModel, QuestionImagePickerModel, ImageItemValue, QuestionImageModel, QuestionSignaturePadModel, QuestionPanelDynamicModel, QuestionPanelDynamicItem, SurveyTimer, SurveyTimerModel, SurveyProgressModel, SurveyProgressButtonsModel, SurveyModel, Model, SurveyTrigger, SurveyTriggerComplete, SurveyTriggerSetValue, SurveyTriggerVisible, SurveyTriggerCopyValue, SurveyTriggerRunExpression, Trigger, SurveyWindowModel, TextPreProcessor, dxSurveyService, englishStrings, surveyLocalization, surveyStrings, QuestionCustomWidget, CustomWidgetCollection, QuestionCustomModel, QuestionCompositeModel, ComponentQuestionJSON, ComponentCollection, StylesManager, ListModel, PopupModel, PopupBaseViewModel, createPopupModalViewModel, QuestionButtonGroupModel, ButtonGroupItemModel, ButtonGroupItemValue, IsMobile, IsTouch, confirmAction, detectIEOrEdge, doKey2ClickUp, doKey2ClickDown, loadFileFromBase64, increaseHeightByContent, createSvg, CssClassBuilder, surveyCss, DragDropSurveyElements, DragDropChoices */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "Version", function() { return Version; });
/* harmony import */ var _main_scss__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../main.scss */ "./src/main.scss");
/* harmony import */ var _main_scss__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_main_scss__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _settings__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../settings */ "./src/settings.ts");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "settings", function() { return _settings__WEBPACK_IMPORTED_MODULE_1__["settings"]; });

/* harmony import */ var _helpers__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../helpers */ "./src/helpers.ts");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "Helpers", function() { return _helpers__WEBPACK_IMPORTED_MODULE_2__["Helpers"]; });

/* harmony import */ var _validator__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../validator */ "./src/validator.ts");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "AnswerCountValidator", function() { return _validator__WEBPACK_IMPORTED_MODULE_3__["AnswerCountValidator"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "EmailValidator", function() { return _validator__WEBPACK_IMPORTED_MODULE_3__["EmailValidator"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "NumericValidator", function() { return _validator__WEBPACK_IMPORTED_MODULE_3__["NumericValidator"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "RegexValidator", function() { return _validator__WEBPACK_IMPORTED_MODULE_3__["RegexValidator"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "SurveyValidator", function() { return _validator__WEBPACK_IMPORTED_MODULE_3__["SurveyValidator"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "TextValidator", function() { return _validator__WEBPACK_IMPORTED_MODULE_3__["TextValidator"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "ValidatorResult", function() { return _validator__WEBPACK_IMPORTED_MODULE_3__["ValidatorResult"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "ExpressionValidator", function() { return _validator__WEBPACK_IMPORTED_MODULE_3__["ExpressionValidator"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "ValidatorRunner", function() { return _validator__WEBPACK_IMPORTED_MODULE_3__["ValidatorRunner"]; });

/* harmony import */ var _itemvalue__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../../itemvalue */ "./src/itemvalue.ts");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "ItemValue", function() { return _itemvalue__WEBPACK_IMPORTED_MODULE_4__["ItemValue"]; });

/* harmony import */ var _base__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../../base */ "./src/base.ts");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "Base", function() { return _base__WEBPACK_IMPORTED_MODULE_5__["Base"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "Event", function() { return _base__WEBPACK_IMPORTED_MODULE_5__["Event"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "ArrayChanges", function() { return _base__WEBPACK_IMPORTED_MODULE_5__["ArrayChanges"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "ComputedUpdater", function() { return _base__WEBPACK_IMPORTED_MODULE_5__["ComputedUpdater"]; });

/* harmony import */ var _survey_error__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../../survey-error */ "./src/survey-error.ts");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "SurveyError", function() { return _survey_error__WEBPACK_IMPORTED_MODULE_6__["SurveyError"]; });

/* harmony import */ var _survey_element__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ../../survey-element */ "./src/survey-element.ts");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "SurveyElementCore", function() { return _survey_element__WEBPACK_IMPORTED_MODULE_7__["SurveyElementCore"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "SurveyElement", function() { return _survey_element__WEBPACK_IMPORTED_MODULE_7__["SurveyElement"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "DragTypeOverMeEnum", function() { return _survey_element__WEBPACK_IMPORTED_MODULE_7__["DragTypeOverMeEnum"]; });

/* harmony import */ var _calculatedValue__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ../../calculatedValue */ "./src/calculatedValue.ts");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "CalculatedValue", function() { return _calculatedValue__WEBPACK_IMPORTED_MODULE_8__["CalculatedValue"]; });

/* harmony import */ var _error__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ../../error */ "./src/error.ts");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "CustomError", function() { return _error__WEBPACK_IMPORTED_MODULE_9__["CustomError"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "AnswerRequiredError", function() { return _error__WEBPACK_IMPORTED_MODULE_9__["AnswerRequiredError"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "OneAnswerRequiredError", function() { return _error__WEBPACK_IMPORTED_MODULE_9__["OneAnswerRequiredError"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "RequreNumericError", function() { return _error__WEBPACK_IMPORTED_MODULE_9__["RequreNumericError"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "ExceedSizeError", function() { return _error__WEBPACK_IMPORTED_MODULE_9__["ExceedSizeError"]; });

/* harmony import */ var _localizablestring__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! ../../localizablestring */ "./src/localizablestring.ts");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "LocalizableString", function() { return _localizablestring__WEBPACK_IMPORTED_MODULE_10__["LocalizableString"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "LocalizableStrings", function() { return _localizablestring__WEBPACK_IMPORTED_MODULE_10__["LocalizableStrings"]; });

/* harmony import */ var _expressionItems__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! ../../expressionItems */ "./src/expressionItems.ts");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "HtmlConditionItem", function() { return _expressionItems__WEBPACK_IMPORTED_MODULE_11__["HtmlConditionItem"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "UrlConditionItem", function() { return _expressionItems__WEBPACK_IMPORTED_MODULE_11__["UrlConditionItem"]; });

/* harmony import */ var _choicesRestful__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! ../../choicesRestful */ "./src/choicesRestful.ts");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "ChoicesRestful", function() { return _choicesRestful__WEBPACK_IMPORTED_MODULE_12__["ChoicesRestful"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "ChoicesRestfull", function() { return _choicesRestful__WEBPACK_IMPORTED_MODULE_12__["ChoicesRestfull"]; });

/* harmony import */ var _functionsfactory__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! ../../functionsfactory */ "./src/functionsfactory.ts");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "FunctionFactory", function() { return _functionsfactory__WEBPACK_IMPORTED_MODULE_13__["FunctionFactory"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "registerFunction", function() { return _functionsfactory__WEBPACK_IMPORTED_MODULE_13__["registerFunction"]; });

/* harmony import */ var _conditions__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(/*! ../../conditions */ "./src/conditions.ts");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "ConditionRunner", function() { return _conditions__WEBPACK_IMPORTED_MODULE_14__["ConditionRunner"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "ExpressionRunner", function() { return _conditions__WEBPACK_IMPORTED_MODULE_14__["ExpressionRunner"]; });

/* harmony import */ var _expressions_expressions__WEBPACK_IMPORTED_MODULE_15__ = __webpack_require__(/*! ../../expressions/expressions */ "./src/expressions/expressions.ts");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "Operand", function() { return _expressions_expressions__WEBPACK_IMPORTED_MODULE_15__["Operand"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "Const", function() { return _expressions_expressions__WEBPACK_IMPORTED_MODULE_15__["Const"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "BinaryOperand", function() { return _expressions_expressions__WEBPACK_IMPORTED_MODULE_15__["BinaryOperand"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "Variable", function() { return _expressions_expressions__WEBPACK_IMPORTED_MODULE_15__["Variable"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "FunctionOperand", function() { return _expressions_expressions__WEBPACK_IMPORTED_MODULE_15__["FunctionOperand"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "ArrayOperand", function() { return _expressions_expressions__WEBPACK_IMPORTED_MODULE_15__["ArrayOperand"]; });

/* harmony import */ var _conditionsParser__WEBPACK_IMPORTED_MODULE_16__ = __webpack_require__(/*! ../../conditionsParser */ "./src/conditionsParser.ts");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "ConditionsParser", function() { return _conditionsParser__WEBPACK_IMPORTED_MODULE_16__["ConditionsParser"]; });

/* harmony import */ var _conditionProcessValue__WEBPACK_IMPORTED_MODULE_17__ = __webpack_require__(/*! ../../conditionProcessValue */ "./src/conditionProcessValue.ts");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "ProcessValue", function() { return _conditionProcessValue__WEBPACK_IMPORTED_MODULE_17__["ProcessValue"]; });

/* harmony import */ var _jsonobject__WEBPACK_IMPORTED_MODULE_18__ = __webpack_require__(/*! ../../jsonobject */ "./src/jsonobject.ts");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "JsonError", function() { return _jsonobject__WEBPACK_IMPORTED_MODULE_18__["JsonError"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "JsonIncorrectTypeError", function() { return _jsonobject__WEBPACK_IMPORTED_MODULE_18__["JsonIncorrectTypeError"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "JsonMetadata", function() { return _jsonobject__WEBPACK_IMPORTED_MODULE_18__["JsonMetadata"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "JsonMetadataClass", function() { return _jsonobject__WEBPACK_IMPORTED_MODULE_18__["JsonMetadataClass"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "JsonMissingTypeError", function() { return _jsonobject__WEBPACK_IMPORTED_MODULE_18__["JsonMissingTypeError"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "JsonMissingTypeErrorBase", function() { return _jsonobject__WEBPACK_IMPORTED_MODULE_18__["JsonMissingTypeErrorBase"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "JsonObject", function() { return _jsonobject__WEBPACK_IMPORTED_MODULE_18__["JsonObject"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "JsonObjectProperty", function() { return _jsonobject__WEBPACK_IMPORTED_MODULE_18__["JsonObjectProperty"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "JsonRequiredPropertyError", function() { return _jsonobject__WEBPACK_IMPORTED_MODULE_18__["JsonRequiredPropertyError"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "JsonUnknownPropertyError", function() { return _jsonobject__WEBPACK_IMPORTED_MODULE_18__["JsonUnknownPropertyError"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "Serializer", function() { return _jsonobject__WEBPACK_IMPORTED_MODULE_18__["Serializer"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "property", function() { return _jsonobject__WEBPACK_IMPORTED_MODULE_18__["property"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "propertyArray", function() { return _jsonobject__WEBPACK_IMPORTED_MODULE_18__["propertyArray"]; });

/* harmony import */ var _question_matrixdropdownbase__WEBPACK_IMPORTED_MODULE_19__ = __webpack_require__(/*! ../../question_matrixdropdownbase */ "./src/question_matrixdropdownbase.ts");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "MatrixDropdownCell", function() { return _question_matrixdropdownbase__WEBPACK_IMPORTED_MODULE_19__["MatrixDropdownCell"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "MatrixDropdownRowModelBase", function() { return _question_matrixdropdownbase__WEBPACK_IMPORTED_MODULE_19__["MatrixDropdownRowModelBase"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "QuestionMatrixDropdownModelBase", function() { return _question_matrixdropdownbase__WEBPACK_IMPORTED_MODULE_19__["QuestionMatrixDropdownModelBase"]; });

/* harmony import */ var _question_matrixdropdowncolumn__WEBPACK_IMPORTED_MODULE_20__ = __webpack_require__(/*! ../../question_matrixdropdowncolumn */ "./src/question_matrixdropdowncolumn.ts");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "MatrixDropdownColumn", function() { return _question_matrixdropdowncolumn__WEBPACK_IMPORTED_MODULE_20__["MatrixDropdownColumn"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "matrixDropdownColumnTypes", function() { return _question_matrixdropdowncolumn__WEBPACK_IMPORTED_MODULE_20__["matrixDropdownColumnTypes"]; });

/* harmony import */ var _question_matrixdropdownrendered__WEBPACK_IMPORTED_MODULE_21__ = __webpack_require__(/*! ../../question_matrixdropdownrendered */ "./src/question_matrixdropdownrendered.ts");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "QuestionMatrixDropdownRenderedCell", function() { return _question_matrixdropdownrendered__WEBPACK_IMPORTED_MODULE_21__["QuestionMatrixDropdownRenderedCell"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "QuestionMatrixDropdownRenderedRow", function() { return _question_matrixdropdownrendered__WEBPACK_IMPORTED_MODULE_21__["QuestionMatrixDropdownRenderedRow"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "QuestionMatrixDropdownRenderedTable", function() { return _question_matrixdropdownrendered__WEBPACK_IMPORTED_MODULE_21__["QuestionMatrixDropdownRenderedTable"]; });

/* harmony import */ var _question_matrixdropdown__WEBPACK_IMPORTED_MODULE_22__ = __webpack_require__(/*! ../../question_matrixdropdown */ "./src/question_matrixdropdown.ts");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "MatrixDropdownRowModel", function() { return _question_matrixdropdown__WEBPACK_IMPORTED_MODULE_22__["MatrixDropdownRowModel"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "QuestionMatrixDropdownModel", function() { return _question_matrixdropdown__WEBPACK_IMPORTED_MODULE_22__["QuestionMatrixDropdownModel"]; });

/* harmony import */ var _question_matrixdynamic__WEBPACK_IMPORTED_MODULE_23__ = __webpack_require__(/*! ../../question_matrixdynamic */ "./src/question_matrixdynamic.ts");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "MatrixDynamicRowModel", function() { return _question_matrixdynamic__WEBPACK_IMPORTED_MODULE_23__["MatrixDynamicRowModel"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "QuestionMatrixDynamicModel", function() { return _question_matrixdynamic__WEBPACK_IMPORTED_MODULE_23__["QuestionMatrixDynamicModel"]; });

/* harmony import */ var _question_matrix__WEBPACK_IMPORTED_MODULE_24__ = __webpack_require__(/*! ../../question_matrix */ "./src/question_matrix.ts");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "MatrixRowModel", function() { return _question_matrix__WEBPACK_IMPORTED_MODULE_24__["MatrixRowModel"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "MatrixCells", function() { return _question_matrix__WEBPACK_IMPORTED_MODULE_24__["MatrixCells"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "QuestionMatrixModel", function() { return _question_matrix__WEBPACK_IMPORTED_MODULE_24__["QuestionMatrixModel"]; });

/* harmony import */ var _question_multipletext__WEBPACK_IMPORTED_MODULE_25__ = __webpack_require__(/*! ../../question_multipletext */ "./src/question_multipletext.ts");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "MultipleTextItemModel", function() { return _question_multipletext__WEBPACK_IMPORTED_MODULE_25__["MultipleTextItemModel"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "QuestionMultipleTextModel", function() { return _question_multipletext__WEBPACK_IMPORTED_MODULE_25__["QuestionMultipleTextModel"]; });

/* harmony import */ var _panel__WEBPACK_IMPORTED_MODULE_26__ = __webpack_require__(/*! ../../panel */ "./src/panel.ts");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "PanelModel", function() { return _panel__WEBPACK_IMPORTED_MODULE_26__["PanelModel"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "PanelModelBase", function() { return _panel__WEBPACK_IMPORTED_MODULE_26__["PanelModelBase"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "QuestionRowModel", function() { return _panel__WEBPACK_IMPORTED_MODULE_26__["QuestionRowModel"]; });

/* harmony import */ var _flowpanel__WEBPACK_IMPORTED_MODULE_27__ = __webpack_require__(/*! ../../flowpanel */ "./src/flowpanel.ts");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "FlowPanelModel", function() { return _flowpanel__WEBPACK_IMPORTED_MODULE_27__["FlowPanelModel"]; });

/* harmony import */ var _page__WEBPACK_IMPORTED_MODULE_28__ = __webpack_require__(/*! ../../page */ "./src/page.ts");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "PageModel", function() { return _page__WEBPACK_IMPORTED_MODULE_28__["PageModel"]; });

/* harmony import */ var _template_renderer__WEBPACK_IMPORTED_MODULE_29__ = __webpack_require__(/*! ../../template-renderer */ "./src/template-renderer.ts");
/* empty/unused harmony star reexport *//* harmony import */ var _defaultTitle__WEBPACK_IMPORTED_MODULE_30__ = __webpack_require__(/*! ../../defaultTitle */ "./src/defaultTitle.ts");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "DefaultTitleModel", function() { return _defaultTitle__WEBPACK_IMPORTED_MODULE_30__["DefaultTitleModel"]; });

/* harmony import */ var _question__WEBPACK_IMPORTED_MODULE_31__ = __webpack_require__(/*! ../../question */ "./src/question.ts");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "Question", function() { return _question__WEBPACK_IMPORTED_MODULE_31__["Question"]; });

/* harmony import */ var _questionnonvalue__WEBPACK_IMPORTED_MODULE_32__ = __webpack_require__(/*! ../../questionnonvalue */ "./src/questionnonvalue.ts");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "QuestionNonValue", function() { return _questionnonvalue__WEBPACK_IMPORTED_MODULE_32__["QuestionNonValue"]; });

/* harmony import */ var _question_empty__WEBPACK_IMPORTED_MODULE_33__ = __webpack_require__(/*! ../../question_empty */ "./src/question_empty.ts");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "QuestionEmptyModel", function() { return _question_empty__WEBPACK_IMPORTED_MODULE_33__["QuestionEmptyModel"]; });

/* harmony import */ var _question_baseselect__WEBPACK_IMPORTED_MODULE_34__ = __webpack_require__(/*! ../../question_baseselect */ "./src/question_baseselect.ts");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "QuestionCheckboxBase", function() { return _question_baseselect__WEBPACK_IMPORTED_MODULE_34__["QuestionCheckboxBase"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "QuestionSelectBase", function() { return _question_baseselect__WEBPACK_IMPORTED_MODULE_34__["QuestionSelectBase"]; });

/* harmony import */ var _question_checkbox__WEBPACK_IMPORTED_MODULE_35__ = __webpack_require__(/*! ../../question_checkbox */ "./src/question_checkbox.ts");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "QuestionCheckboxModel", function() { return _question_checkbox__WEBPACK_IMPORTED_MODULE_35__["QuestionCheckboxModel"]; });

/* harmony import */ var _question_ranking__WEBPACK_IMPORTED_MODULE_36__ = __webpack_require__(/*! ../../question_ranking */ "./src/question_ranking.ts");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "QuestionRankingModel", function() { return _question_ranking__WEBPACK_IMPORTED_MODULE_36__["QuestionRankingModel"]; });

/* harmony import */ var _question_comment__WEBPACK_IMPORTED_MODULE_37__ = __webpack_require__(/*! ../../question_comment */ "./src/question_comment.ts");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "QuestionCommentModel", function() { return _question_comment__WEBPACK_IMPORTED_MODULE_37__["QuestionCommentModel"]; });

/* harmony import */ var _question_dropdown__WEBPACK_IMPORTED_MODULE_38__ = __webpack_require__(/*! ../../question_dropdown */ "./src/question_dropdown.ts");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "QuestionDropdownModel", function() { return _question_dropdown__WEBPACK_IMPORTED_MODULE_38__["QuestionDropdownModel"]; });

/* harmony import */ var _questionfactory__WEBPACK_IMPORTED_MODULE_39__ = __webpack_require__(/*! ../../questionfactory */ "./src/questionfactory.ts");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "QuestionFactory", function() { return _questionfactory__WEBPACK_IMPORTED_MODULE_39__["QuestionFactory"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "ElementFactory", function() { return _questionfactory__WEBPACK_IMPORTED_MODULE_39__["ElementFactory"]; });

/* harmony import */ var _question_file__WEBPACK_IMPORTED_MODULE_40__ = __webpack_require__(/*! ../../question_file */ "./src/question_file.ts");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "QuestionFileModel", function() { return _question_file__WEBPACK_IMPORTED_MODULE_40__["QuestionFileModel"]; });

/* harmony import */ var _question_html__WEBPACK_IMPORTED_MODULE_41__ = __webpack_require__(/*! ../../question_html */ "./src/question_html.ts");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "QuestionHtmlModel", function() { return _question_html__WEBPACK_IMPORTED_MODULE_41__["QuestionHtmlModel"]; });

/* harmony import */ var _question_radiogroup__WEBPACK_IMPORTED_MODULE_42__ = __webpack_require__(/*! ../../question_radiogroup */ "./src/question_radiogroup.ts");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "QuestionRadiogroupModel", function() { return _question_radiogroup__WEBPACK_IMPORTED_MODULE_42__["QuestionRadiogroupModel"]; });

/* harmony import */ var _question_rating__WEBPACK_IMPORTED_MODULE_43__ = __webpack_require__(/*! ../../question_rating */ "./src/question_rating.ts");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "QuestionRatingModel", function() { return _question_rating__WEBPACK_IMPORTED_MODULE_43__["QuestionRatingModel"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "RenderedRatingItem", function() { return _question_rating__WEBPACK_IMPORTED_MODULE_43__["RenderedRatingItem"]; });

/* harmony import */ var _question_expression__WEBPACK_IMPORTED_MODULE_44__ = __webpack_require__(/*! ../../question_expression */ "./src/question_expression.ts");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "QuestionExpressionModel", function() { return _question_expression__WEBPACK_IMPORTED_MODULE_44__["QuestionExpressionModel"]; });

/* harmony import */ var _question_text__WEBPACK_IMPORTED_MODULE_45__ = __webpack_require__(/*! ../../question_text */ "./src/question_text.ts");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "QuestionTextModel", function() { return _question_text__WEBPACK_IMPORTED_MODULE_45__["QuestionTextModel"]; });

/* harmony import */ var _question_boolean__WEBPACK_IMPORTED_MODULE_46__ = __webpack_require__(/*! ../../question_boolean */ "./src/question_boolean.ts");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "QuestionBooleanModel", function() { return _question_boolean__WEBPACK_IMPORTED_MODULE_46__["QuestionBooleanModel"]; });

/* harmony import */ var _question_imagepicker__WEBPACK_IMPORTED_MODULE_47__ = __webpack_require__(/*! ../../question_imagepicker */ "./src/question_imagepicker.ts");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "QuestionImagePickerModel", function() { return _question_imagepicker__WEBPACK_IMPORTED_MODULE_47__["QuestionImagePickerModel"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "ImageItemValue", function() { return _question_imagepicker__WEBPACK_IMPORTED_MODULE_47__["ImageItemValue"]; });

/* harmony import */ var _question_image__WEBPACK_IMPORTED_MODULE_48__ = __webpack_require__(/*! ../../question_image */ "./src/question_image.ts");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "QuestionImageModel", function() { return _question_image__WEBPACK_IMPORTED_MODULE_48__["QuestionImageModel"]; });

/* harmony import */ var _question_signaturepad__WEBPACK_IMPORTED_MODULE_49__ = __webpack_require__(/*! ../../question_signaturepad */ "./src/question_signaturepad.ts");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "QuestionSignaturePadModel", function() { return _question_signaturepad__WEBPACK_IMPORTED_MODULE_49__["QuestionSignaturePadModel"]; });

/* harmony import */ var _question_paneldynamic__WEBPACK_IMPORTED_MODULE_50__ = __webpack_require__(/*! ../../question_paneldynamic */ "./src/question_paneldynamic.ts");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "QuestionPanelDynamicModel", function() { return _question_paneldynamic__WEBPACK_IMPORTED_MODULE_50__["QuestionPanelDynamicModel"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "QuestionPanelDynamicItem", function() { return _question_paneldynamic__WEBPACK_IMPORTED_MODULE_50__["QuestionPanelDynamicItem"]; });

/* harmony import */ var _surveytimer__WEBPACK_IMPORTED_MODULE_51__ = __webpack_require__(/*! ../../surveytimer */ "./src/surveytimer.ts");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "SurveyTimer", function() { return _surveytimer__WEBPACK_IMPORTED_MODULE_51__["SurveyTimer"]; });

/* harmony import */ var _surveyTimerModel__WEBPACK_IMPORTED_MODULE_52__ = __webpack_require__(/*! ../../surveyTimerModel */ "./src/surveyTimerModel.ts");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "SurveyTimerModel", function() { return _surveyTimerModel__WEBPACK_IMPORTED_MODULE_52__["SurveyTimerModel"]; });

/* harmony import */ var _surveyProgress__WEBPACK_IMPORTED_MODULE_53__ = __webpack_require__(/*! ../../surveyProgress */ "./src/surveyProgress.ts");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "SurveyProgressModel", function() { return _surveyProgress__WEBPACK_IMPORTED_MODULE_53__["SurveyProgressModel"]; });

/* harmony import */ var _surveyProgressButtons__WEBPACK_IMPORTED_MODULE_54__ = __webpack_require__(/*! ../../surveyProgressButtons */ "./src/surveyProgressButtons.ts");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "SurveyProgressButtonsModel", function() { return _surveyProgressButtons__WEBPACK_IMPORTED_MODULE_54__["SurveyProgressButtonsModel"]; });

/* harmony import */ var _survey__WEBPACK_IMPORTED_MODULE_55__ = __webpack_require__(/*! ../../survey */ "./src/survey.ts");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "SurveyModel", function() { return _survey__WEBPACK_IMPORTED_MODULE_55__["SurveyModel"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "Model", function() { return _survey__WEBPACK_IMPORTED_MODULE_55__["SurveyModel"]; });

/* harmony import */ var _trigger__WEBPACK_IMPORTED_MODULE_56__ = __webpack_require__(/*! ../../trigger */ "./src/trigger.ts");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "SurveyTrigger", function() { return _trigger__WEBPACK_IMPORTED_MODULE_56__["SurveyTrigger"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "SurveyTriggerComplete", function() { return _trigger__WEBPACK_IMPORTED_MODULE_56__["SurveyTriggerComplete"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "SurveyTriggerSetValue", function() { return _trigger__WEBPACK_IMPORTED_MODULE_56__["SurveyTriggerSetValue"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "SurveyTriggerVisible", function() { return _trigger__WEBPACK_IMPORTED_MODULE_56__["SurveyTriggerVisible"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "SurveyTriggerCopyValue", function() { return _trigger__WEBPACK_IMPORTED_MODULE_56__["SurveyTriggerCopyValue"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "SurveyTriggerRunExpression", function() { return _trigger__WEBPACK_IMPORTED_MODULE_56__["SurveyTriggerRunExpression"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "Trigger", function() { return _trigger__WEBPACK_IMPORTED_MODULE_56__["Trigger"]; });

/* harmony import */ var _surveyWindow__WEBPACK_IMPORTED_MODULE_57__ = __webpack_require__(/*! ../../surveyWindow */ "./src/surveyWindow.ts");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "SurveyWindowModel", function() { return _surveyWindow__WEBPACK_IMPORTED_MODULE_57__["SurveyWindowModel"]; });

/* harmony import */ var _textPreProcessor__WEBPACK_IMPORTED_MODULE_58__ = __webpack_require__(/*! ../../textPreProcessor */ "./src/textPreProcessor.ts");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "TextPreProcessor", function() { return _textPreProcessor__WEBPACK_IMPORTED_MODULE_58__["TextPreProcessor"]; });

/* harmony import */ var _dxSurveyService__WEBPACK_IMPORTED_MODULE_59__ = __webpack_require__(/*! ../../dxSurveyService */ "./src/dxSurveyService.ts");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "dxSurveyService", function() { return _dxSurveyService__WEBPACK_IMPORTED_MODULE_59__["dxSurveyService"]; });

/* harmony import */ var _localization_english__WEBPACK_IMPORTED_MODULE_60__ = __webpack_require__(/*! ../../localization/english */ "./src/localization/english.ts");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "englishStrings", function() { return _localization_english__WEBPACK_IMPORTED_MODULE_60__["englishStrings"]; });

/* harmony import */ var _surveyStrings__WEBPACK_IMPORTED_MODULE_61__ = __webpack_require__(/*! ../../surveyStrings */ "./src/surveyStrings.ts");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "surveyLocalization", function() { return _surveyStrings__WEBPACK_IMPORTED_MODULE_61__["surveyLocalization"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "surveyStrings", function() { return _surveyStrings__WEBPACK_IMPORTED_MODULE_61__["surveyStrings"]; });

/* harmony import */ var _questionCustomWidgets__WEBPACK_IMPORTED_MODULE_62__ = __webpack_require__(/*! ../../questionCustomWidgets */ "./src/questionCustomWidgets.ts");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "QuestionCustomWidget", function() { return _questionCustomWidgets__WEBPACK_IMPORTED_MODULE_62__["QuestionCustomWidget"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "CustomWidgetCollection", function() { return _questionCustomWidgets__WEBPACK_IMPORTED_MODULE_62__["CustomWidgetCollection"]; });

/* harmony import */ var _question_custom__WEBPACK_IMPORTED_MODULE_63__ = __webpack_require__(/*! ../../question_custom */ "./src/question_custom.ts");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "QuestionCustomModel", function() { return _question_custom__WEBPACK_IMPORTED_MODULE_63__["QuestionCustomModel"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "QuestionCompositeModel", function() { return _question_custom__WEBPACK_IMPORTED_MODULE_63__["QuestionCompositeModel"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "ComponentQuestionJSON", function() { return _question_custom__WEBPACK_IMPORTED_MODULE_63__["ComponentQuestionJSON"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "ComponentCollection", function() { return _question_custom__WEBPACK_IMPORTED_MODULE_63__["ComponentCollection"]; });

/* harmony import */ var _stylesmanager__WEBPACK_IMPORTED_MODULE_64__ = __webpack_require__(/*! ../../stylesmanager */ "./src/stylesmanager.ts");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "StylesManager", function() { return _stylesmanager__WEBPACK_IMPORTED_MODULE_64__["StylesManager"]; });

/* harmony import */ var _list__WEBPACK_IMPORTED_MODULE_65__ = __webpack_require__(/*! ../../list */ "./src/list.ts");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "ListModel", function() { return _list__WEBPACK_IMPORTED_MODULE_65__["ListModel"]; });

/* harmony import */ var _popup__WEBPACK_IMPORTED_MODULE_66__ = __webpack_require__(/*! ../../popup */ "./src/popup.ts");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "PopupModel", function() { return _popup__WEBPACK_IMPORTED_MODULE_66__["PopupModel"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "PopupBaseViewModel", function() { return _popup__WEBPACK_IMPORTED_MODULE_66__["PopupBaseViewModel"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "createPopupModalViewModel", function() { return _popup__WEBPACK_IMPORTED_MODULE_66__["createPopupModalViewModel"]; });

/* harmony import */ var _question_buttongroup__WEBPACK_IMPORTED_MODULE_67__ = __webpack_require__(/*! ../../question_buttongroup */ "./src/question_buttongroup.ts");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "QuestionButtonGroupModel", function() { return _question_buttongroup__WEBPACK_IMPORTED_MODULE_67__["QuestionButtonGroupModel"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "ButtonGroupItemModel", function() { return _question_buttongroup__WEBPACK_IMPORTED_MODULE_67__["ButtonGroupItemModel"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "ButtonGroupItemValue", function() { return _question_buttongroup__WEBPACK_IMPORTED_MODULE_67__["ButtonGroupItemValue"]; });

/* harmony import */ var _utils_devices__WEBPACK_IMPORTED_MODULE_68__ = __webpack_require__(/*! ../../utils/devices */ "./src/utils/devices.ts");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "IsMobile", function() { return _utils_devices__WEBPACK_IMPORTED_MODULE_68__["IsMobile"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "IsTouch", function() { return _utils_devices__WEBPACK_IMPORTED_MODULE_68__["IsTouch"]; });

/* harmony import */ var _utils_utils__WEBPACK_IMPORTED_MODULE_69__ = __webpack_require__(/*! ../../utils/utils */ "./src/utils/utils.ts");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "confirmAction", function() { return _utils_utils__WEBPACK_IMPORTED_MODULE_69__["confirmAction"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "detectIEOrEdge", function() { return _utils_utils__WEBPACK_IMPORTED_MODULE_69__["detectIEOrEdge"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "doKey2ClickUp", function() { return _utils_utils__WEBPACK_IMPORTED_MODULE_69__["doKey2ClickUp"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "doKey2ClickDown", function() { return _utils_utils__WEBPACK_IMPORTED_MODULE_69__["doKey2ClickDown"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "loadFileFromBase64", function() { return _utils_utils__WEBPACK_IMPORTED_MODULE_69__["loadFileFromBase64"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "increaseHeightByContent", function() { return _utils_utils__WEBPACK_IMPORTED_MODULE_69__["increaseHeightByContent"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "createSvg", function() { return _utils_utils__WEBPACK_IMPORTED_MODULE_69__["createSvg"]; });

/* harmony import */ var _utils_cssClassBuilder__WEBPACK_IMPORTED_MODULE_70__ = __webpack_require__(/*! ../../utils/cssClassBuilder */ "./src/utils/cssClassBuilder.ts");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "CssClassBuilder", function() { return _utils_cssClassBuilder__WEBPACK_IMPORTED_MODULE_70__["CssClassBuilder"]; });

/* harmony import */ var _defaultCss_cssstandard__WEBPACK_IMPORTED_MODULE_71__ = __webpack_require__(/*! ../../defaultCss/cssstandard */ "./src/defaultCss/cssstandard.ts");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "surveyCss", function() { return _defaultCss_cssstandard__WEBPACK_IMPORTED_MODULE_71__["surveyCss"]; });

/* harmony import */ var _dragdrop_survey_elements__WEBPACK_IMPORTED_MODULE_72__ = __webpack_require__(/*! ../../dragdrop/survey-elements */ "./src/dragdrop/survey-elements.ts");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "DragDropSurveyElements", function() { return _dragdrop_survey_elements__WEBPACK_IMPORTED_MODULE_72__["DragDropSurveyElements"]; });

/* harmony import */ var _dragdrop_choices__WEBPACK_IMPORTED_MODULE_73__ = __webpack_require__(/*! ../../dragdrop/choices */ "./src/dragdrop/choices.ts");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "DragDropChoices", function() { return _dragdrop_choices__WEBPACK_IMPORTED_MODULE_73__["DragDropChoices"]; });

// styles

//import "../../modern.scss";
var Version;
Version = "".concat("1.9.19");





























































// export { cultureInfo } from "../../cultureInfo";










//Uncomment to include the "date" question type.
//export {default as QuestionDateModel} from "../../plugins/question_date";




/***/ }),

/***/ "./src/entries/core.ts":
/*!*****************************!*\
  !*** ./src/entries/core.ts ***!
  \*****************************/
/*! exports provided: Version, settings, Helpers, AnswerCountValidator, EmailValidator, NumericValidator, RegexValidator, SurveyValidator, TextValidator, ValidatorResult, ExpressionValidator, ValidatorRunner, ItemValue, Base, Event, ArrayChanges, ComputedUpdater, SurveyError, SurveyElementCore, SurveyElement, DragTypeOverMeEnum, CalculatedValue, CustomError, AnswerRequiredError, OneAnswerRequiredError, RequreNumericError, ExceedSizeError, LocalizableString, LocalizableStrings, HtmlConditionItem, UrlConditionItem, ChoicesRestful, ChoicesRestfull, FunctionFactory, registerFunction, ConditionRunner, ExpressionRunner, Operand, Const, BinaryOperand, Variable, FunctionOperand, ArrayOperand, ConditionsParser, ProcessValue, JsonError, JsonIncorrectTypeError, JsonMetadata, JsonMetadataClass, JsonMissingTypeError, JsonMissingTypeErrorBase, JsonObject, JsonObjectProperty, JsonRequiredPropertyError, JsonUnknownPropertyError, Serializer, property, propertyArray, MatrixDropdownCell, MatrixDropdownRowModelBase, QuestionMatrixDropdownModelBase, MatrixDropdownColumn, matrixDropdownColumnTypes, QuestionMatrixDropdownRenderedCell, QuestionMatrixDropdownRenderedRow, QuestionMatrixDropdownRenderedTable, MatrixDropdownRowModel, QuestionMatrixDropdownModel, MatrixDynamicRowModel, QuestionMatrixDynamicModel, MatrixRowModel, MatrixCells, QuestionMatrixModel, MultipleTextItemModel, QuestionMultipleTextModel, PanelModel, PanelModelBase, QuestionRowModel, FlowPanelModel, PageModel, DefaultTitleModel, Question, QuestionNonValue, QuestionEmptyModel, QuestionCheckboxBase, QuestionSelectBase, QuestionCheckboxModel, QuestionRankingModel, QuestionCommentModel, QuestionDropdownModel, QuestionFactory, ElementFactory, QuestionFileModel, QuestionHtmlModel, QuestionRadiogroupModel, QuestionRatingModel, RenderedRatingItem, QuestionExpressionModel, QuestionTextModel, QuestionBooleanModel, QuestionImagePickerModel, ImageItemValue, QuestionImageModel, QuestionSignaturePadModel, QuestionPanelDynamicModel, QuestionPanelDynamicItem, SurveyTimer, SurveyTimerModel, SurveyProgressModel, SurveyProgressButtonsModel, SurveyModel, Model, SurveyTrigger, SurveyTriggerComplete, SurveyTriggerSetValue, SurveyTriggerVisible, SurveyTriggerCopyValue, SurveyTriggerRunExpression, Trigger, SurveyWindowModel, TextPreProcessor, dxSurveyService, englishStrings, surveyLocalization, surveyStrings, QuestionCustomWidget, CustomWidgetCollection, QuestionCustomModel, QuestionCompositeModel, ComponentQuestionJSON, ComponentCollection, StylesManager, ListModel, PopupModel, PopupBaseViewModel, createPopupModalViewModel, QuestionButtonGroupModel, ButtonGroupItemModel, ButtonGroupItemValue, IsMobile, IsTouch, confirmAction, detectIEOrEdge, doKey2ClickUp, doKey2ClickDown, loadFileFromBase64, increaseHeightByContent, createSvg, CssClassBuilder, surveyCss, DragDropSurveyElements, DragDropChoices, defaultStandardCss, defaultBootstrapCss, defaultBootstrapMaterialCss, defaultV2Css, modernCss, SvgIconRegistry, SvgRegistry, SvgBundleViewModel, RendererFactory, ResponsivityManager, VerticalResponsivityManager, unwrap, Action, AdaptiveActionContainer, defaultActionBarCss, ActionContainer, TooltipManager, DragOrClickHelper */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _chunks_model__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./chunks/model */ "./src/entries/chunks/model.ts");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "Version", function() { return _chunks_model__WEBPACK_IMPORTED_MODULE_0__["Version"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "settings", function() { return _chunks_model__WEBPACK_IMPORTED_MODULE_0__["settings"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "Helpers", function() { return _chunks_model__WEBPACK_IMPORTED_MODULE_0__["Helpers"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "AnswerCountValidator", function() { return _chunks_model__WEBPACK_IMPORTED_MODULE_0__["AnswerCountValidator"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "EmailValidator", function() { return _chunks_model__WEBPACK_IMPORTED_MODULE_0__["EmailValidator"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "NumericValidator", function() { return _chunks_model__WEBPACK_IMPORTED_MODULE_0__["NumericValidator"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "RegexValidator", function() { return _chunks_model__WEBPACK_IMPORTED_MODULE_0__["RegexValidator"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "SurveyValidator", function() { return _chunks_model__WEBPACK_IMPORTED_MODULE_0__["SurveyValidator"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "TextValidator", function() { return _chunks_model__WEBPACK_IMPORTED_MODULE_0__["TextValidator"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "ValidatorResult", function() { return _chunks_model__WEBPACK_IMPORTED_MODULE_0__["ValidatorResult"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "ExpressionValidator", function() { return _chunks_model__WEBPACK_IMPORTED_MODULE_0__["ExpressionValidator"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "ValidatorRunner", function() { return _chunks_model__WEBPACK_IMPORTED_MODULE_0__["ValidatorRunner"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "ItemValue", function() { return _chunks_model__WEBPACK_IMPORTED_MODULE_0__["ItemValue"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "Base", function() { return _chunks_model__WEBPACK_IMPORTED_MODULE_0__["Base"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "Event", function() { return _chunks_model__WEBPACK_IMPORTED_MODULE_0__["Event"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "ArrayChanges", function() { return _chunks_model__WEBPACK_IMPORTED_MODULE_0__["ArrayChanges"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "ComputedUpdater", function() { return _chunks_model__WEBPACK_IMPORTED_MODULE_0__["ComputedUpdater"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "SurveyError", function() { return _chunks_model__WEBPACK_IMPORTED_MODULE_0__["SurveyError"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "SurveyElementCore", function() { return _chunks_model__WEBPACK_IMPORTED_MODULE_0__["SurveyElementCore"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "SurveyElement", function() { return _chunks_model__WEBPACK_IMPORTED_MODULE_0__["SurveyElement"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "DragTypeOverMeEnum", function() { return _chunks_model__WEBPACK_IMPORTED_MODULE_0__["DragTypeOverMeEnum"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "CalculatedValue", function() { return _chunks_model__WEBPACK_IMPORTED_MODULE_0__["CalculatedValue"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "CustomError", function() { return _chunks_model__WEBPACK_IMPORTED_MODULE_0__["CustomError"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "AnswerRequiredError", function() { return _chunks_model__WEBPACK_IMPORTED_MODULE_0__["AnswerRequiredError"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "OneAnswerRequiredError", function() { return _chunks_model__WEBPACK_IMPORTED_MODULE_0__["OneAnswerRequiredError"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "RequreNumericError", function() { return _chunks_model__WEBPACK_IMPORTED_MODULE_0__["RequreNumericError"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "ExceedSizeError", function() { return _chunks_model__WEBPACK_IMPORTED_MODULE_0__["ExceedSizeError"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "LocalizableString", function() { return _chunks_model__WEBPACK_IMPORTED_MODULE_0__["LocalizableString"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "LocalizableStrings", function() { return _chunks_model__WEBPACK_IMPORTED_MODULE_0__["LocalizableStrings"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "HtmlConditionItem", function() { return _chunks_model__WEBPACK_IMPORTED_MODULE_0__["HtmlConditionItem"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "UrlConditionItem", function() { return _chunks_model__WEBPACK_IMPORTED_MODULE_0__["UrlConditionItem"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "ChoicesRestful", function() { return _chunks_model__WEBPACK_IMPORTED_MODULE_0__["ChoicesRestful"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "ChoicesRestfull", function() { return _chunks_model__WEBPACK_IMPORTED_MODULE_0__["ChoicesRestfull"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "FunctionFactory", function() { return _chunks_model__WEBPACK_IMPORTED_MODULE_0__["FunctionFactory"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "registerFunction", function() { return _chunks_model__WEBPACK_IMPORTED_MODULE_0__["registerFunction"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "ConditionRunner", function() { return _chunks_model__WEBPACK_IMPORTED_MODULE_0__["ConditionRunner"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "ExpressionRunner", function() { return _chunks_model__WEBPACK_IMPORTED_MODULE_0__["ExpressionRunner"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "Operand", function() { return _chunks_model__WEBPACK_IMPORTED_MODULE_0__["Operand"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "Const", function() { return _chunks_model__WEBPACK_IMPORTED_MODULE_0__["Const"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "BinaryOperand", function() { return _chunks_model__WEBPACK_IMPORTED_MODULE_0__["BinaryOperand"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "Variable", function() { return _chunks_model__WEBPACK_IMPORTED_MODULE_0__["Variable"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "FunctionOperand", function() { return _chunks_model__WEBPACK_IMPORTED_MODULE_0__["FunctionOperand"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "ArrayOperand", function() { return _chunks_model__WEBPACK_IMPORTED_MODULE_0__["ArrayOperand"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "ConditionsParser", function() { return _chunks_model__WEBPACK_IMPORTED_MODULE_0__["ConditionsParser"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "ProcessValue", function() { return _chunks_model__WEBPACK_IMPORTED_MODULE_0__["ProcessValue"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "JsonError", function() { return _chunks_model__WEBPACK_IMPORTED_MODULE_0__["JsonError"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "JsonIncorrectTypeError", function() { return _chunks_model__WEBPACK_IMPORTED_MODULE_0__["JsonIncorrectTypeError"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "JsonMetadata", function() { return _chunks_model__WEBPACK_IMPORTED_MODULE_0__["JsonMetadata"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "JsonMetadataClass", function() { return _chunks_model__WEBPACK_IMPORTED_MODULE_0__["JsonMetadataClass"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "JsonMissingTypeError", function() { return _chunks_model__WEBPACK_IMPORTED_MODULE_0__["JsonMissingTypeError"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "JsonMissingTypeErrorBase", function() { return _chunks_model__WEBPACK_IMPORTED_MODULE_0__["JsonMissingTypeErrorBase"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "JsonObject", function() { return _chunks_model__WEBPACK_IMPORTED_MODULE_0__["JsonObject"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "JsonObjectProperty", function() { return _chunks_model__WEBPACK_IMPORTED_MODULE_0__["JsonObjectProperty"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "JsonRequiredPropertyError", function() { return _chunks_model__WEBPACK_IMPORTED_MODULE_0__["JsonRequiredPropertyError"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "JsonUnknownPropertyError", function() { return _chunks_model__WEBPACK_IMPORTED_MODULE_0__["JsonUnknownPropertyError"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "Serializer", function() { return _chunks_model__WEBPACK_IMPORTED_MODULE_0__["Serializer"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "property", function() { return _chunks_model__WEBPACK_IMPORTED_MODULE_0__["property"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "propertyArray", function() { return _chunks_model__WEBPACK_IMPORTED_MODULE_0__["propertyArray"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "MatrixDropdownCell", function() { return _chunks_model__WEBPACK_IMPORTED_MODULE_0__["MatrixDropdownCell"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "MatrixDropdownRowModelBase", function() { return _chunks_model__WEBPACK_IMPORTED_MODULE_0__["MatrixDropdownRowModelBase"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "QuestionMatrixDropdownModelBase", function() { return _chunks_model__WEBPACK_IMPORTED_MODULE_0__["QuestionMatrixDropdownModelBase"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "MatrixDropdownColumn", function() { return _chunks_model__WEBPACK_IMPORTED_MODULE_0__["MatrixDropdownColumn"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "matrixDropdownColumnTypes", function() { return _chunks_model__WEBPACK_IMPORTED_MODULE_0__["matrixDropdownColumnTypes"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "QuestionMatrixDropdownRenderedCell", function() { return _chunks_model__WEBPACK_IMPORTED_MODULE_0__["QuestionMatrixDropdownRenderedCell"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "QuestionMatrixDropdownRenderedRow", function() { return _chunks_model__WEBPACK_IMPORTED_MODULE_0__["QuestionMatrixDropdownRenderedRow"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "QuestionMatrixDropdownRenderedTable", function() { return _chunks_model__WEBPACK_IMPORTED_MODULE_0__["QuestionMatrixDropdownRenderedTable"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "MatrixDropdownRowModel", function() { return _chunks_model__WEBPACK_IMPORTED_MODULE_0__["MatrixDropdownRowModel"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "QuestionMatrixDropdownModel", function() { return _chunks_model__WEBPACK_IMPORTED_MODULE_0__["QuestionMatrixDropdownModel"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "MatrixDynamicRowModel", function() { return _chunks_model__WEBPACK_IMPORTED_MODULE_0__["MatrixDynamicRowModel"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "QuestionMatrixDynamicModel", function() { return _chunks_model__WEBPACK_IMPORTED_MODULE_0__["QuestionMatrixDynamicModel"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "MatrixRowModel", function() { return _chunks_model__WEBPACK_IMPORTED_MODULE_0__["MatrixRowModel"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "MatrixCells", function() { return _chunks_model__WEBPACK_IMPORTED_MODULE_0__["MatrixCells"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "QuestionMatrixModel", function() { return _chunks_model__WEBPACK_IMPORTED_MODULE_0__["QuestionMatrixModel"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "MultipleTextItemModel", function() { return _chunks_model__WEBPACK_IMPORTED_MODULE_0__["MultipleTextItemModel"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "QuestionMultipleTextModel", function() { return _chunks_model__WEBPACK_IMPORTED_MODULE_0__["QuestionMultipleTextModel"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "PanelModel", function() { return _chunks_model__WEBPACK_IMPORTED_MODULE_0__["PanelModel"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "PanelModelBase", function() { return _chunks_model__WEBPACK_IMPORTED_MODULE_0__["PanelModelBase"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "QuestionRowModel", function() { return _chunks_model__WEBPACK_IMPORTED_MODULE_0__["QuestionRowModel"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "FlowPanelModel", function() { return _chunks_model__WEBPACK_IMPORTED_MODULE_0__["FlowPanelModel"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "PageModel", function() { return _chunks_model__WEBPACK_IMPORTED_MODULE_0__["PageModel"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "DefaultTitleModel", function() { return _chunks_model__WEBPACK_IMPORTED_MODULE_0__["DefaultTitleModel"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "Question", function() { return _chunks_model__WEBPACK_IMPORTED_MODULE_0__["Question"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "QuestionNonValue", function() { return _chunks_model__WEBPACK_IMPORTED_MODULE_0__["QuestionNonValue"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "QuestionEmptyModel", function() { return _chunks_model__WEBPACK_IMPORTED_MODULE_0__["QuestionEmptyModel"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "QuestionCheckboxBase", function() { return _chunks_model__WEBPACK_IMPORTED_MODULE_0__["QuestionCheckboxBase"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "QuestionSelectBase", function() { return _chunks_model__WEBPACK_IMPORTED_MODULE_0__["QuestionSelectBase"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "QuestionCheckboxModel", function() { return _chunks_model__WEBPACK_IMPORTED_MODULE_0__["QuestionCheckboxModel"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "QuestionRankingModel", function() { return _chunks_model__WEBPACK_IMPORTED_MODULE_0__["QuestionRankingModel"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "QuestionCommentModel", function() { return _chunks_model__WEBPACK_IMPORTED_MODULE_0__["QuestionCommentModel"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "QuestionDropdownModel", function() { return _chunks_model__WEBPACK_IMPORTED_MODULE_0__["QuestionDropdownModel"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "QuestionFactory", function() { return _chunks_model__WEBPACK_IMPORTED_MODULE_0__["QuestionFactory"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "ElementFactory", function() { return _chunks_model__WEBPACK_IMPORTED_MODULE_0__["ElementFactory"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "QuestionFileModel", function() { return _chunks_model__WEBPACK_IMPORTED_MODULE_0__["QuestionFileModel"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "QuestionHtmlModel", function() { return _chunks_model__WEBPACK_IMPORTED_MODULE_0__["QuestionHtmlModel"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "QuestionRadiogroupModel", function() { return _chunks_model__WEBPACK_IMPORTED_MODULE_0__["QuestionRadiogroupModel"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "QuestionRatingModel", function() { return _chunks_model__WEBPACK_IMPORTED_MODULE_0__["QuestionRatingModel"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "RenderedRatingItem", function() { return _chunks_model__WEBPACK_IMPORTED_MODULE_0__["RenderedRatingItem"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "QuestionExpressionModel", function() { return _chunks_model__WEBPACK_IMPORTED_MODULE_0__["QuestionExpressionModel"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "QuestionTextModel", function() { return _chunks_model__WEBPACK_IMPORTED_MODULE_0__["QuestionTextModel"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "QuestionBooleanModel", function() { return _chunks_model__WEBPACK_IMPORTED_MODULE_0__["QuestionBooleanModel"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "QuestionImagePickerModel", function() { return _chunks_model__WEBPACK_IMPORTED_MODULE_0__["QuestionImagePickerModel"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "ImageItemValue", function() { return _chunks_model__WEBPACK_IMPORTED_MODULE_0__["ImageItemValue"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "QuestionImageModel", function() { return _chunks_model__WEBPACK_IMPORTED_MODULE_0__["QuestionImageModel"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "QuestionSignaturePadModel", function() { return _chunks_model__WEBPACK_IMPORTED_MODULE_0__["QuestionSignaturePadModel"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "QuestionPanelDynamicModel", function() { return _chunks_model__WEBPACK_IMPORTED_MODULE_0__["QuestionPanelDynamicModel"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "QuestionPanelDynamicItem", function() { return _chunks_model__WEBPACK_IMPORTED_MODULE_0__["QuestionPanelDynamicItem"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "SurveyTimer", function() { return _chunks_model__WEBPACK_IMPORTED_MODULE_0__["SurveyTimer"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "SurveyTimerModel", function() { return _chunks_model__WEBPACK_IMPORTED_MODULE_0__["SurveyTimerModel"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "SurveyProgressModel", function() { return _chunks_model__WEBPACK_IMPORTED_MODULE_0__["SurveyProgressModel"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "SurveyProgressButtonsModel", function() { return _chunks_model__WEBPACK_IMPORTED_MODULE_0__["SurveyProgressButtonsModel"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "SurveyModel", function() { return _chunks_model__WEBPACK_IMPORTED_MODULE_0__["SurveyModel"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "Model", function() { return _chunks_model__WEBPACK_IMPORTED_MODULE_0__["Model"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "SurveyTrigger", function() { return _chunks_model__WEBPACK_IMPORTED_MODULE_0__["SurveyTrigger"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "SurveyTriggerComplete", function() { return _chunks_model__WEBPACK_IMPORTED_MODULE_0__["SurveyTriggerComplete"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "SurveyTriggerSetValue", function() { return _chunks_model__WEBPACK_IMPORTED_MODULE_0__["SurveyTriggerSetValue"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "SurveyTriggerVisible", function() { return _chunks_model__WEBPACK_IMPORTED_MODULE_0__["SurveyTriggerVisible"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "SurveyTriggerCopyValue", function() { return _chunks_model__WEBPACK_IMPORTED_MODULE_0__["SurveyTriggerCopyValue"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "SurveyTriggerRunExpression", function() { return _chunks_model__WEBPACK_IMPORTED_MODULE_0__["SurveyTriggerRunExpression"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "Trigger", function() { return _chunks_model__WEBPACK_IMPORTED_MODULE_0__["Trigger"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "SurveyWindowModel", function() { return _chunks_model__WEBPACK_IMPORTED_MODULE_0__["SurveyWindowModel"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "TextPreProcessor", function() { return _chunks_model__WEBPACK_IMPORTED_MODULE_0__["TextPreProcessor"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "dxSurveyService", function() { return _chunks_model__WEBPACK_IMPORTED_MODULE_0__["dxSurveyService"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "englishStrings", function() { return _chunks_model__WEBPACK_IMPORTED_MODULE_0__["englishStrings"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "surveyLocalization", function() { return _chunks_model__WEBPACK_IMPORTED_MODULE_0__["surveyLocalization"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "surveyStrings", function() { return _chunks_model__WEBPACK_IMPORTED_MODULE_0__["surveyStrings"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "QuestionCustomWidget", function() { return _chunks_model__WEBPACK_IMPORTED_MODULE_0__["QuestionCustomWidget"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "CustomWidgetCollection", function() { return _chunks_model__WEBPACK_IMPORTED_MODULE_0__["CustomWidgetCollection"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "QuestionCustomModel", function() { return _chunks_model__WEBPACK_IMPORTED_MODULE_0__["QuestionCustomModel"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "QuestionCompositeModel", function() { return _chunks_model__WEBPACK_IMPORTED_MODULE_0__["QuestionCompositeModel"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "ComponentQuestionJSON", function() { return _chunks_model__WEBPACK_IMPORTED_MODULE_0__["ComponentQuestionJSON"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "ComponentCollection", function() { return _chunks_model__WEBPACK_IMPORTED_MODULE_0__["ComponentCollection"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "StylesManager", function() { return _chunks_model__WEBPACK_IMPORTED_MODULE_0__["StylesManager"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "ListModel", function() { return _chunks_model__WEBPACK_IMPORTED_MODULE_0__["ListModel"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "PopupModel", function() { return _chunks_model__WEBPACK_IMPORTED_MODULE_0__["PopupModel"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "PopupBaseViewModel", function() { return _chunks_model__WEBPACK_IMPORTED_MODULE_0__["PopupBaseViewModel"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "createPopupModalViewModel", function() { return _chunks_model__WEBPACK_IMPORTED_MODULE_0__["createPopupModalViewModel"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "QuestionButtonGroupModel", function() { return _chunks_model__WEBPACK_IMPORTED_MODULE_0__["QuestionButtonGroupModel"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "ButtonGroupItemModel", function() { return _chunks_model__WEBPACK_IMPORTED_MODULE_0__["ButtonGroupItemModel"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "ButtonGroupItemValue", function() { return _chunks_model__WEBPACK_IMPORTED_MODULE_0__["ButtonGroupItemValue"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "IsMobile", function() { return _chunks_model__WEBPACK_IMPORTED_MODULE_0__["IsMobile"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "IsTouch", function() { return _chunks_model__WEBPACK_IMPORTED_MODULE_0__["IsTouch"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "confirmAction", function() { return _chunks_model__WEBPACK_IMPORTED_MODULE_0__["confirmAction"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "detectIEOrEdge", function() { return _chunks_model__WEBPACK_IMPORTED_MODULE_0__["detectIEOrEdge"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "doKey2ClickUp", function() { return _chunks_model__WEBPACK_IMPORTED_MODULE_0__["doKey2ClickUp"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "doKey2ClickDown", function() { return _chunks_model__WEBPACK_IMPORTED_MODULE_0__["doKey2ClickDown"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "loadFileFromBase64", function() { return _chunks_model__WEBPACK_IMPORTED_MODULE_0__["loadFileFromBase64"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "increaseHeightByContent", function() { return _chunks_model__WEBPACK_IMPORTED_MODULE_0__["increaseHeightByContent"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "createSvg", function() { return _chunks_model__WEBPACK_IMPORTED_MODULE_0__["createSvg"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "CssClassBuilder", function() { return _chunks_model__WEBPACK_IMPORTED_MODULE_0__["CssClassBuilder"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "surveyCss", function() { return _chunks_model__WEBPACK_IMPORTED_MODULE_0__["surveyCss"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "DragDropSurveyElements", function() { return _chunks_model__WEBPACK_IMPORTED_MODULE_0__["DragDropSurveyElements"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "DragDropChoices", function() { return _chunks_model__WEBPACK_IMPORTED_MODULE_0__["DragDropChoices"]; });

/* harmony import */ var _defaultCss_cssstandard__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../defaultCss/cssstandard */ "./src/defaultCss/cssstandard.ts");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "defaultStandardCss", function() { return _defaultCss_cssstandard__WEBPACK_IMPORTED_MODULE_1__["defaultStandardCss"]; });

/* harmony import */ var _defaultCss_cssbootstrap__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../defaultCss/cssbootstrap */ "./src/defaultCss/cssbootstrap.ts");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "defaultBootstrapCss", function() { return _defaultCss_cssbootstrap__WEBPACK_IMPORTED_MODULE_2__["defaultBootstrapCss"]; });

/* harmony import */ var _defaultCss_cssbootstrapmaterial__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../defaultCss/cssbootstrapmaterial */ "./src/defaultCss/cssbootstrapmaterial.ts");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "defaultBootstrapMaterialCss", function() { return _defaultCss_cssbootstrapmaterial__WEBPACK_IMPORTED_MODULE_3__["defaultBootstrapMaterialCss"]; });

/* harmony import */ var _defaultCss_defaultV2Css__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../defaultCss/defaultV2Css */ "./src/defaultCss/defaultV2Css.ts");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "defaultV2Css", function() { return _defaultCss_defaultV2Css__WEBPACK_IMPORTED_MODULE_4__["defaultV2Css"]; });

/* harmony import */ var _defaultCss_cssmodern__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../defaultCss/cssmodern */ "./src/defaultCss/cssmodern.ts");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "modernCss", function() { return _defaultCss_cssmodern__WEBPACK_IMPORTED_MODULE_5__["modernCss"]; });

/* harmony import */ var _svgbundle__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../svgbundle */ "./src/svgbundle.ts");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "SvgIconRegistry", function() { return _svgbundle__WEBPACK_IMPORTED_MODULE_6__["SvgIconRegistry"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "SvgRegistry", function() { return _svgbundle__WEBPACK_IMPORTED_MODULE_6__["SvgRegistry"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "SvgBundleViewModel", function() { return _svgbundle__WEBPACK_IMPORTED_MODULE_6__["SvgBundleViewModel"]; });

/* harmony import */ var _rendererFactory__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ../rendererFactory */ "./src/rendererFactory.ts");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "RendererFactory", function() { return _rendererFactory__WEBPACK_IMPORTED_MODULE_7__["RendererFactory"]; });

/* harmony import */ var _utils_responsivity_manager__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ../utils/responsivity-manager */ "./src/utils/responsivity-manager.ts");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "ResponsivityManager", function() { return _utils_responsivity_manager__WEBPACK_IMPORTED_MODULE_8__["ResponsivityManager"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "VerticalResponsivityManager", function() { return _utils_responsivity_manager__WEBPACK_IMPORTED_MODULE_8__["VerticalResponsivityManager"]; });

/* harmony import */ var _utils_utils__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ../utils/utils */ "./src/utils/utils.ts");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "unwrap", function() { return _utils_utils__WEBPACK_IMPORTED_MODULE_9__["unwrap"]; });

/* harmony import */ var _actions_action__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! ../actions/action */ "./src/actions/action.ts");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "Action", function() { return _actions_action__WEBPACK_IMPORTED_MODULE_10__["Action"]; });

/* harmony import */ var _actions_adaptive_container__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! ../actions/adaptive-container */ "./src/actions/adaptive-container.ts");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "AdaptiveActionContainer", function() { return _actions_adaptive_container__WEBPACK_IMPORTED_MODULE_11__["AdaptiveActionContainer"]; });

/* harmony import */ var _actions_container__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! ../actions/container */ "./src/actions/container.ts");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "defaultActionBarCss", function() { return _actions_container__WEBPACK_IMPORTED_MODULE_12__["defaultActionBarCss"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "ActionContainer", function() { return _actions_container__WEBPACK_IMPORTED_MODULE_12__["ActionContainer"]; });

/* harmony import */ var _utils_tooltip__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! ../utils/tooltip */ "./src/utils/tooltip.ts");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "TooltipManager", function() { return _utils_tooltip__WEBPACK_IMPORTED_MODULE_13__["TooltipManager"]; });

/* harmony import */ var _utils_dragOrClickHelper__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(/*! ../utils/dragOrClickHelper */ "./src/utils/dragOrClickHelper.ts");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "DragOrClickHelper", function() { return _utils_dragOrClickHelper__WEBPACK_IMPORTED_MODULE_14__["DragOrClickHelper"]; });

// model

// css standard classes

// css bootstrap classes

// css bootstrap + material classes


// css modern classes


// utils










/***/ }),

/***/ "./src/entries/knockout-ui-model.ts":
/*!******************************************!*\
  !*** ./src/entries/knockout-ui-model.ts ***!
  \******************************************/
/*! exports provided: Survey, SurveyWindow, ImplementorBase, QuestionRow, Page, Panel, FlowPanel, QuestionImplementor, QuestionSelectBaseImplementor, QuestionCheckboxBaseImplementor, QuestionCheckbox, QuestionRanking, QuestionComment, QuestionDropdown, QuestionFile, QuestionHtml, QuestionMatrix, QuestionMatrixDropdown, QuestionMatrixDynamicImplementor, QuestionMatrixDynamic, QuestionPanelDynamic, MultipleTextItem, QuestionMultipleText, QuestionRadiogroup, QuestionRating, QuestionRatingImplementor, QuestionText, QuestionBoolean, QuestionEmpty, QuestionExpression, QuestionImagePicker, SurveyWindowImplementor, SurveyTemplateText, QuestionImage, QuestionSignaturePad, QuestionCustom, QuestionButtonGroup, ActionBarItemViewModel, ActionBarItemDropdownViewModel, ActionBarSeparatorViewModel, ActionContainerImplementor, CheckboxViewModel, BooleanRadioItemViewModel, BooleanRadioViewModel, PanelViewModel, PopupViewModel, showModal, ProgressButtonsViewModel, ProgressViewModel, TitleElementViewModel, TitleContentViewModel, DefaultTitleViewModel, TitleActionViewModel, StringEditorViewModel, StringViewerViewModel, LogoImageViewModel, Skeleton, RatingDropdownViewModel, DropdownViewModel, ListItemViewComponent, ListViewComponent, SvgIconViewModel, SurveyQuestionMatrixDynamicRemoveButton, SurveyQuestionMatrixDetailButton, SurveyQuestionMatrixDynamicDragDropIcon, ButtonGroupItemViewModel, TooltipErrorViewModel, SurveyQuestionPaneldynamicActioons */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _knockout_kosurvey__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../knockout/kosurvey */ "./src/knockout/kosurvey.ts");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "Survey", function() { return _knockout_kosurvey__WEBPACK_IMPORTED_MODULE_0__["Survey"]; });

/* harmony import */ var _knockout_koSurveyWindow__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../knockout/koSurveyWindow */ "./src/knockout/koSurveyWindow.ts");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "SurveyWindow", function() { return _knockout_koSurveyWindow__WEBPACK_IMPORTED_MODULE_1__["SurveyWindow"]; });

/* harmony import */ var _knockout_kobase__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../knockout/kobase */ "./src/knockout/kobase.ts");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "ImplementorBase", function() { return _knockout_kobase__WEBPACK_IMPORTED_MODULE_2__["ImplementorBase"]; });

/* harmony import */ var _knockout_kopage__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../knockout/kopage */ "./src/knockout/kopage.ts");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "QuestionRow", function() { return _knockout_kopage__WEBPACK_IMPORTED_MODULE_3__["QuestionRow"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "Page", function() { return _knockout_kopage__WEBPACK_IMPORTED_MODULE_3__["Page"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "Panel", function() { return _knockout_kopage__WEBPACK_IMPORTED_MODULE_3__["Panel"]; });

/* harmony import */ var _knockout_koflowpanel__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../knockout/koflowpanel */ "./src/knockout/koflowpanel.ts");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "FlowPanel", function() { return _knockout_koflowpanel__WEBPACK_IMPORTED_MODULE_4__["FlowPanel"]; });

/* harmony import */ var _knockout_koquestion__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../knockout/koquestion */ "./src/knockout/koquestion.ts");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "QuestionImplementor", function() { return _knockout_koquestion__WEBPACK_IMPORTED_MODULE_5__["QuestionImplementor"]; });

/* harmony import */ var _knockout_koquestion_baseselect__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../knockout/koquestion_baseselect */ "./src/knockout/koquestion_baseselect.ts");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "QuestionSelectBaseImplementor", function() { return _knockout_koquestion_baseselect__WEBPACK_IMPORTED_MODULE_6__["QuestionSelectBaseImplementor"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "QuestionCheckboxBaseImplementor", function() { return _knockout_koquestion_baseselect__WEBPACK_IMPORTED_MODULE_6__["QuestionCheckboxBaseImplementor"]; });

/* harmony import */ var _knockout_koquestion_checkbox__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ../knockout/koquestion_checkbox */ "./src/knockout/koquestion_checkbox.ts");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "QuestionCheckbox", function() { return _knockout_koquestion_checkbox__WEBPACK_IMPORTED_MODULE_7__["QuestionCheckbox"]; });

/* harmony import */ var _knockout_koquestion_ranking__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ../knockout/koquestion_ranking */ "./src/knockout/koquestion_ranking.ts");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "QuestionRanking", function() { return _knockout_koquestion_ranking__WEBPACK_IMPORTED_MODULE_8__["QuestionRanking"]; });

/* harmony import */ var _knockout_koquestion_comment__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ../knockout/koquestion_comment */ "./src/knockout/koquestion_comment.ts");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "QuestionComment", function() { return _knockout_koquestion_comment__WEBPACK_IMPORTED_MODULE_9__["QuestionComment"]; });

/* harmony import */ var _knockout_koquestion_dropdown__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! ../knockout/koquestion_dropdown */ "./src/knockout/koquestion_dropdown.ts");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "QuestionDropdown", function() { return _knockout_koquestion_dropdown__WEBPACK_IMPORTED_MODULE_10__["QuestionDropdown"]; });

/* harmony import */ var _knockout_koquestion_file__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! ../knockout/koquestion_file */ "./src/knockout/koquestion_file.ts");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "QuestionFile", function() { return _knockout_koquestion_file__WEBPACK_IMPORTED_MODULE_11__["QuestionFile"]; });

/* harmony import */ var _knockout_koquestion_html__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! ../knockout/koquestion_html */ "./src/knockout/koquestion_html.ts");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "QuestionHtml", function() { return _knockout_koquestion_html__WEBPACK_IMPORTED_MODULE_12__["QuestionHtml"]; });

/* harmony import */ var _knockout_koquestion_matrix__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! ../knockout/koquestion_matrix */ "./src/knockout/koquestion_matrix.ts");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "QuestionMatrix", function() { return _knockout_koquestion_matrix__WEBPACK_IMPORTED_MODULE_13__["QuestionMatrix"]; });

/* harmony import */ var _knockout_koquestion_matrixdropdown__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(/*! ../knockout/koquestion_matrixdropdown */ "./src/knockout/koquestion_matrixdropdown.ts");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "QuestionMatrixDropdown", function() { return _knockout_koquestion_matrixdropdown__WEBPACK_IMPORTED_MODULE_14__["QuestionMatrixDropdown"]; });

/* harmony import */ var _knockout_koquestion_matrixdynamic__WEBPACK_IMPORTED_MODULE_15__ = __webpack_require__(/*! ../knockout/koquestion_matrixdynamic */ "./src/knockout/koquestion_matrixdynamic.ts");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "QuestionMatrixDynamicImplementor", function() { return _knockout_koquestion_matrixdynamic__WEBPACK_IMPORTED_MODULE_15__["QuestionMatrixDynamicImplementor"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "QuestionMatrixDynamic", function() { return _knockout_koquestion_matrixdynamic__WEBPACK_IMPORTED_MODULE_15__["QuestionMatrixDynamic"]; });

/* harmony import */ var _knockout_koquestion_paneldynamic__WEBPACK_IMPORTED_MODULE_16__ = __webpack_require__(/*! ../knockout/koquestion_paneldynamic */ "./src/knockout/koquestion_paneldynamic.ts");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "QuestionPanelDynamic", function() { return _knockout_koquestion_paneldynamic__WEBPACK_IMPORTED_MODULE_16__["QuestionPanelDynamic"]; });

/* harmony import */ var _knockout_koquestion_multipletext__WEBPACK_IMPORTED_MODULE_17__ = __webpack_require__(/*! ../knockout/koquestion_multipletext */ "./src/knockout/koquestion_multipletext.ts");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "MultipleTextItem", function() { return _knockout_koquestion_multipletext__WEBPACK_IMPORTED_MODULE_17__["MultipleTextItem"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "QuestionMultipleText", function() { return _knockout_koquestion_multipletext__WEBPACK_IMPORTED_MODULE_17__["QuestionMultipleText"]; });

/* harmony import */ var _knockout_koquestion_radiogroup__WEBPACK_IMPORTED_MODULE_18__ = __webpack_require__(/*! ../knockout/koquestion_radiogroup */ "./src/knockout/koquestion_radiogroup.ts");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "QuestionRadiogroup", function() { return _knockout_koquestion_radiogroup__WEBPACK_IMPORTED_MODULE_18__["QuestionRadiogroup"]; });

/* harmony import */ var _knockout_koquestion_rating__WEBPACK_IMPORTED_MODULE_19__ = __webpack_require__(/*! ../knockout/koquestion_rating */ "./src/knockout/koquestion_rating.ts");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "QuestionRating", function() { return _knockout_koquestion_rating__WEBPACK_IMPORTED_MODULE_19__["QuestionRating"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "QuestionRatingImplementor", function() { return _knockout_koquestion_rating__WEBPACK_IMPORTED_MODULE_19__["QuestionRatingImplementor"]; });

/* harmony import */ var _knockout_koquestion_text__WEBPACK_IMPORTED_MODULE_20__ = __webpack_require__(/*! ../knockout/koquestion_text */ "./src/knockout/koquestion_text.ts");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "QuestionText", function() { return _knockout_koquestion_text__WEBPACK_IMPORTED_MODULE_20__["QuestionText"]; });

/* harmony import */ var _knockout_koquestion_boolean__WEBPACK_IMPORTED_MODULE_21__ = __webpack_require__(/*! ../knockout/koquestion_boolean */ "./src/knockout/koquestion_boolean.ts");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "QuestionBoolean", function() { return _knockout_koquestion_boolean__WEBPACK_IMPORTED_MODULE_21__["QuestionBoolean"]; });

/* harmony import */ var _knockout_koquestion_empty__WEBPACK_IMPORTED_MODULE_22__ = __webpack_require__(/*! ../knockout/koquestion_empty */ "./src/knockout/koquestion_empty.ts");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "QuestionEmpty", function() { return _knockout_koquestion_empty__WEBPACK_IMPORTED_MODULE_22__["QuestionEmpty"]; });

/* harmony import */ var _knockout_koquestion_expression__WEBPACK_IMPORTED_MODULE_23__ = __webpack_require__(/*! ../knockout/koquestion_expression */ "./src/knockout/koquestion_expression.ts");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "QuestionExpression", function() { return _knockout_koquestion_expression__WEBPACK_IMPORTED_MODULE_23__["QuestionExpression"]; });

/* harmony import */ var _knockout_koquestion_imagepicker__WEBPACK_IMPORTED_MODULE_24__ = __webpack_require__(/*! ../knockout/koquestion_imagepicker */ "./src/knockout/koquestion_imagepicker.ts");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "QuestionImagePicker", function() { return _knockout_koquestion_imagepicker__WEBPACK_IMPORTED_MODULE_24__["QuestionImagePicker"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "SurveyWindowImplementor", function() { return _knockout_koSurveyWindow__WEBPACK_IMPORTED_MODULE_1__["SurveyWindowImplementor"]; });

/* harmony import */ var _knockout_templateText__WEBPACK_IMPORTED_MODULE_25__ = __webpack_require__(/*! ../knockout/templateText */ "./src/knockout/templateText.ts");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "SurveyTemplateText", function() { return _knockout_templateText__WEBPACK_IMPORTED_MODULE_25__["SurveyTemplateText"]; });

/* harmony import */ var _knockout_koquestion_image__WEBPACK_IMPORTED_MODULE_26__ = __webpack_require__(/*! ../knockout/koquestion_image */ "./src/knockout/koquestion_image.ts");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "QuestionImage", function() { return _knockout_koquestion_image__WEBPACK_IMPORTED_MODULE_26__["QuestionImage"]; });

/* harmony import */ var _knockout_koquestion_signaturepad__WEBPACK_IMPORTED_MODULE_27__ = __webpack_require__(/*! ../knockout/koquestion_signaturepad */ "./src/knockout/koquestion_signaturepad.ts");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "QuestionSignaturePad", function() { return _knockout_koquestion_signaturepad__WEBPACK_IMPORTED_MODULE_27__["QuestionSignaturePad"]; });

/* harmony import */ var _knockout_koquestion_custom__WEBPACK_IMPORTED_MODULE_28__ = __webpack_require__(/*! ../knockout/koquestion_custom */ "./src/knockout/koquestion_custom.ts");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "QuestionCustom", function() { return _knockout_koquestion_custom__WEBPACK_IMPORTED_MODULE_28__["QuestionCustom"]; });

/* harmony import */ var _knockout_koquestion_buttongroup__WEBPACK_IMPORTED_MODULE_29__ = __webpack_require__(/*! ../knockout/koquestion_buttongroup */ "./src/knockout/koquestion_buttongroup.ts");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "QuestionButtonGroup", function() { return _knockout_koquestion_buttongroup__WEBPACK_IMPORTED_MODULE_29__["QuestionButtonGroup"]; });

/* harmony import */ var _knockout_components_action_bar_action_bar__WEBPACK_IMPORTED_MODULE_30__ = __webpack_require__(/*! ../knockout/components/action-bar/action-bar */ "./src/knockout/components/action-bar/action-bar.ts");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "ActionBarItemViewModel", function() { return _knockout_components_action_bar_action_bar__WEBPACK_IMPORTED_MODULE_30__["ActionBarItemViewModel"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "ActionBarItemDropdownViewModel", function() { return _knockout_components_action_bar_action_bar__WEBPACK_IMPORTED_MODULE_30__["ActionBarItemDropdownViewModel"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "ActionBarSeparatorViewModel", function() { return _knockout_components_action_bar_action_bar__WEBPACK_IMPORTED_MODULE_30__["ActionBarSeparatorViewModel"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "ActionContainerImplementor", function() { return _knockout_components_action_bar_action_bar__WEBPACK_IMPORTED_MODULE_30__["ActionContainerImplementor"]; });

/* harmony import */ var _knockout_components_boolean_checkbox_boolean_checkbox__WEBPACK_IMPORTED_MODULE_31__ = __webpack_require__(/*! ../knockout/components/boolean-checkbox/boolean-checkbox */ "./src/knockout/components/boolean-checkbox/boolean-checkbox.ts");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "CheckboxViewModel", function() { return _knockout_components_boolean_checkbox_boolean_checkbox__WEBPACK_IMPORTED_MODULE_31__["CheckboxViewModel"]; });

/* harmony import */ var _knockout_components_boolean_radio_boolean_radio__WEBPACK_IMPORTED_MODULE_32__ = __webpack_require__(/*! ../knockout/components/boolean-radio/boolean-radio */ "./src/knockout/components/boolean-radio/boolean-radio.ts");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "BooleanRadioItemViewModel", function() { return _knockout_components_boolean_radio_boolean_radio__WEBPACK_IMPORTED_MODULE_32__["BooleanRadioItemViewModel"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "BooleanRadioViewModel", function() { return _knockout_components_boolean_radio_boolean_radio__WEBPACK_IMPORTED_MODULE_32__["BooleanRadioViewModel"]; });

/* harmony import */ var _knockout_components_panel_panel__WEBPACK_IMPORTED_MODULE_33__ = __webpack_require__(/*! ../knockout/components/panel/panel */ "./src/knockout/components/panel/panel.ts");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "PanelViewModel", function() { return _knockout_components_panel_panel__WEBPACK_IMPORTED_MODULE_33__["PanelViewModel"]; });

/* harmony import */ var _knockout_components_popup_popup__WEBPACK_IMPORTED_MODULE_34__ = __webpack_require__(/*! ../knockout/components/popup/popup */ "./src/knockout/components/popup/popup.ts");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "PopupViewModel", function() { return _knockout_components_popup_popup__WEBPACK_IMPORTED_MODULE_34__["PopupViewModel"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "showModal", function() { return _knockout_components_popup_popup__WEBPACK_IMPORTED_MODULE_34__["showModal"]; });

/* harmony import */ var _knockout_components_progress_buttons__WEBPACK_IMPORTED_MODULE_35__ = __webpack_require__(/*! ../knockout/components/progress/buttons */ "./src/knockout/components/progress/buttons.ts");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "ProgressButtonsViewModel", function() { return _knockout_components_progress_buttons__WEBPACK_IMPORTED_MODULE_35__["ProgressButtonsViewModel"]; });

/* harmony import */ var _knockout_components_progress_progress__WEBPACK_IMPORTED_MODULE_36__ = __webpack_require__(/*! ../knockout/components/progress/progress */ "./src/knockout/components/progress/progress.ts");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "ProgressViewModel", function() { return _knockout_components_progress_progress__WEBPACK_IMPORTED_MODULE_36__["ProgressViewModel"]; });

/* harmony import */ var _knockout_components_template_renderer_template_renderer__WEBPACK_IMPORTED_MODULE_37__ = __webpack_require__(/*! ../knockout/components/template-renderer/template-renderer */ "./src/knockout/components/template-renderer/template-renderer.ts");
/* empty/unused harmony star reexport *//* harmony import */ var _knockout_components_title_title_element__WEBPACK_IMPORTED_MODULE_38__ = __webpack_require__(/*! ../knockout/components/title/title-element */ "./src/knockout/components/title/title-element.ts");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "TitleElementViewModel", function() { return _knockout_components_title_title_element__WEBPACK_IMPORTED_MODULE_38__["TitleElementViewModel"]; });

/* harmony import */ var _knockout_components_title_title_content__WEBPACK_IMPORTED_MODULE_39__ = __webpack_require__(/*! ../knockout/components/title/title-content */ "./src/knockout/components/title/title-content.ts");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "TitleContentViewModel", function() { return _knockout_components_title_title_content__WEBPACK_IMPORTED_MODULE_39__["TitleContentViewModel"]; });

/* harmony import */ var _knockout_components_title_default_title__WEBPACK_IMPORTED_MODULE_40__ = __webpack_require__(/*! ../knockout/components/title/default-title */ "./src/knockout/components/title/default-title.ts");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "DefaultTitleViewModel", function() { return _knockout_components_title_default_title__WEBPACK_IMPORTED_MODULE_40__["DefaultTitleViewModel"]; });

/* harmony import */ var _knockout_components_title_title_actions__WEBPACK_IMPORTED_MODULE_41__ = __webpack_require__(/*! ../knockout/components/title/title-actions */ "./src/knockout/components/title/title-actions.ts");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "TitleActionViewModel", function() { return _knockout_components_title_title_actions__WEBPACK_IMPORTED_MODULE_41__["TitleActionViewModel"]; });

/* harmony import */ var _knockout_components_string_editor_string_editor__WEBPACK_IMPORTED_MODULE_42__ = __webpack_require__(/*! ../knockout/components/string-editor/string-editor */ "./src/knockout/components/string-editor/string-editor.ts");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "StringEditorViewModel", function() { return _knockout_components_string_editor_string_editor__WEBPACK_IMPORTED_MODULE_42__["StringEditorViewModel"]; });

/* harmony import */ var _knockout_components_string_viewer_string_viewer__WEBPACK_IMPORTED_MODULE_43__ = __webpack_require__(/*! ../knockout/components/string-viewer/string-viewer */ "./src/knockout/components/string-viewer/string-viewer.ts");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "StringViewerViewModel", function() { return _knockout_components_string_viewer_string_viewer__WEBPACK_IMPORTED_MODULE_43__["StringViewerViewModel"]; });

/* harmony import */ var _knockout_components_logo_image_logo_image__WEBPACK_IMPORTED_MODULE_44__ = __webpack_require__(/*! ../knockout/components/logo-image/logo-image */ "./src/knockout/components/logo-image/logo-image.ts");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "LogoImageViewModel", function() { return _knockout_components_logo_image_logo_image__WEBPACK_IMPORTED_MODULE_44__["LogoImageViewModel"]; });

/* harmony import */ var _knockout_components_skeleton_skeleton__WEBPACK_IMPORTED_MODULE_45__ = __webpack_require__(/*! ../knockout/components/skeleton/skeleton */ "./src/knockout/components/skeleton/skeleton.ts");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "Skeleton", function() { return _knockout_components_skeleton_skeleton__WEBPACK_IMPORTED_MODULE_45__["Skeleton"]; });

/* harmony import */ var _knockout_components_rating_dropdown_rating_dropdown__WEBPACK_IMPORTED_MODULE_46__ = __webpack_require__(/*! ../knockout/components/rating-dropdown/rating-dropdown */ "./src/knockout/components/rating-dropdown/rating-dropdown.ts");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "RatingDropdownViewModel", function() { return _knockout_components_rating_dropdown_rating_dropdown__WEBPACK_IMPORTED_MODULE_46__["RatingDropdownViewModel"]; });

/* harmony import */ var _knockout_components_dropdown_dropdown__WEBPACK_IMPORTED_MODULE_47__ = __webpack_require__(/*! ../knockout/components/dropdown/dropdown */ "./src/knockout/components/dropdown/dropdown.ts");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "DropdownViewModel", function() { return _knockout_components_dropdown_dropdown__WEBPACK_IMPORTED_MODULE_47__["DropdownViewModel"]; });

/* harmony import */ var _knockout_components_list_list__WEBPACK_IMPORTED_MODULE_48__ = __webpack_require__(/*! ../knockout/components/list/list */ "./src/knockout/components/list/list.ts");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "ListItemViewComponent", function() { return _knockout_components_list_list__WEBPACK_IMPORTED_MODULE_48__["ListItemViewComponent"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "ListViewComponent", function() { return _knockout_components_list_list__WEBPACK_IMPORTED_MODULE_48__["ListViewComponent"]; });

/* harmony import */ var _knockout_components_svg_icon_svg_icon__WEBPACK_IMPORTED_MODULE_49__ = __webpack_require__(/*! ../knockout/components/svg-icon/svg-icon */ "./src/knockout/components/svg-icon/svg-icon.ts");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "SvgIconViewModel", function() { return _knockout_components_svg_icon_svg_icon__WEBPACK_IMPORTED_MODULE_49__["SvgIconViewModel"]; });

/* harmony import */ var _knockout_components_matrix_actions_remove_button_remove_button__WEBPACK_IMPORTED_MODULE_50__ = __webpack_require__(/*! ../knockout/components/matrix-actions/remove-button/remove-button */ "./src/knockout/components/matrix-actions/remove-button/remove-button.ts");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "SurveyQuestionMatrixDynamicRemoveButton", function() { return _knockout_components_matrix_actions_remove_button_remove_button__WEBPACK_IMPORTED_MODULE_50__["SurveyQuestionMatrixDynamicRemoveButton"]; });

/* harmony import */ var _knockout_components_matrix_actions_detail_button_detail_button__WEBPACK_IMPORTED_MODULE_51__ = __webpack_require__(/*! ../knockout/components/matrix-actions/detail-button/detail-button */ "./src/knockout/components/matrix-actions/detail-button/detail-button.ts");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "SurveyQuestionMatrixDetailButton", function() { return _knockout_components_matrix_actions_detail_button_detail_button__WEBPACK_IMPORTED_MODULE_51__["SurveyQuestionMatrixDetailButton"]; });

/* harmony import */ var _knockout_components_matrix_actions_drag_drop_icon_drag_drop_icon__WEBPACK_IMPORTED_MODULE_52__ = __webpack_require__(/*! ../knockout/components/matrix-actions/drag-drop-icon/drag-drop-icon */ "./src/knockout/components/matrix-actions/drag-drop-icon/drag-drop-icon.ts");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "SurveyQuestionMatrixDynamicDragDropIcon", function() { return _knockout_components_matrix_actions_drag_drop_icon_drag_drop_icon__WEBPACK_IMPORTED_MODULE_52__["SurveyQuestionMatrixDynamicDragDropIcon"]; });

/* harmony import */ var _knockout_components_button_group_button_group_item__WEBPACK_IMPORTED_MODULE_53__ = __webpack_require__(/*! ../knockout/components/button-group/button-group-item */ "./src/knockout/components/button-group/button-group-item.ts");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "ButtonGroupItemViewModel", function() { return _knockout_components_button_group_button_group_item__WEBPACK_IMPORTED_MODULE_53__["ButtonGroupItemViewModel"]; });

/* harmony import */ var _knockout_components_tooltip_error_tooltip_error__WEBPACK_IMPORTED_MODULE_54__ = __webpack_require__(/*! ../knockout/components/tooltip-error/tooltip-error */ "./src/knockout/components/tooltip-error/tooltip-error.ts");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "TooltipErrorViewModel", function() { return _knockout_components_tooltip_error_tooltip_error__WEBPACK_IMPORTED_MODULE_54__["TooltipErrorViewModel"]; });

/* harmony import */ var _knockout_components_paneldynamic_actions_paneldynamic_actions__WEBPACK_IMPORTED_MODULE_55__ = __webpack_require__(/*! ../knockout/components/paneldynamic-actions/paneldynamic-actions */ "./src/knockout/components/paneldynamic-actions/paneldynamic-actions.ts");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "SurveyQuestionPaneldynamicActioons", function() { return _knockout_components_paneldynamic_actions_paneldynamic_actions__WEBPACK_IMPORTED_MODULE_55__["SurveyQuestionPaneldynamicActioons"]; });

/* harmony import */ var knockout__WEBPACK_IMPORTED_MODULE_56__ = __webpack_require__(/*! knockout */ "knockout");
/* harmony import */ var knockout__WEBPACK_IMPORTED_MODULE_56___default = /*#__PURE__*/__webpack_require__.n(knockout__WEBPACK_IMPORTED_MODULE_56__);
/* harmony import */ var survey_core__WEBPACK_IMPORTED_MODULE_57__ = __webpack_require__(/*! survey-core */ "./src/entries/core.ts");





























































Object(_knockout_kosurvey__WEBPACK_IMPORTED_MODULE_0__["registerTemplateEngine"])(knockout__WEBPACK_IMPORTED_MODULE_56__, survey_core__WEBPACK_IMPORTED_MODULE_57__["SurveyModel"].platform);


/***/ }),

/***/ "./src/entries/knockout.ts":
/*!*********************************!*\
  !*** ./src/entries/knockout.ts ***!
  \*********************************/
/*! exports provided: Version, settings, Helpers, AnswerCountValidator, EmailValidator, NumericValidator, RegexValidator, SurveyValidator, TextValidator, ValidatorResult, ExpressionValidator, ValidatorRunner, ItemValue, Base, Event, ArrayChanges, ComputedUpdater, SurveyError, SurveyElementCore, SurveyElement, DragTypeOverMeEnum, CalculatedValue, CustomError, AnswerRequiredError, OneAnswerRequiredError, RequreNumericError, ExceedSizeError, LocalizableString, LocalizableStrings, HtmlConditionItem, UrlConditionItem, ChoicesRestful, ChoicesRestfull, FunctionFactory, registerFunction, ConditionRunner, ExpressionRunner, Operand, Const, BinaryOperand, Variable, FunctionOperand, ArrayOperand, ConditionsParser, ProcessValue, JsonError, JsonIncorrectTypeError, JsonMetadata, JsonMetadataClass, JsonMissingTypeError, JsonMissingTypeErrorBase, JsonObject, JsonObjectProperty, JsonRequiredPropertyError, JsonUnknownPropertyError, Serializer, property, propertyArray, MatrixDropdownCell, MatrixDropdownRowModelBase, QuestionMatrixDropdownModelBase, MatrixDropdownColumn, matrixDropdownColumnTypes, QuestionMatrixDropdownRenderedCell, QuestionMatrixDropdownRenderedRow, QuestionMatrixDropdownRenderedTable, MatrixDropdownRowModel, QuestionMatrixDropdownModel, MatrixDynamicRowModel, QuestionMatrixDynamicModel, MatrixRowModel, MatrixCells, QuestionMatrixModel, MultipleTextItemModel, QuestionMultipleTextModel, PanelModel, PanelModelBase, QuestionRowModel, FlowPanelModel, PageModel, DefaultTitleModel, Question, QuestionNonValue, QuestionEmptyModel, QuestionCheckboxBase, QuestionSelectBase, QuestionCheckboxModel, QuestionRankingModel, QuestionCommentModel, QuestionDropdownModel, QuestionFactory, ElementFactory, QuestionFileModel, QuestionHtmlModel, QuestionRadiogroupModel, QuestionRatingModel, RenderedRatingItem, QuestionExpressionModel, QuestionTextModel, QuestionBooleanModel, QuestionImagePickerModel, ImageItemValue, QuestionImageModel, QuestionSignaturePadModel, QuestionPanelDynamicModel, QuestionPanelDynamicItem, SurveyTimer, SurveyTimerModel, SurveyProgressModel, SurveyProgressButtonsModel, SurveyModel, Model, SurveyTrigger, SurveyTriggerComplete, SurveyTriggerSetValue, SurveyTriggerVisible, SurveyTriggerCopyValue, SurveyTriggerRunExpression, Trigger, SurveyWindowModel, TextPreProcessor, dxSurveyService, englishStrings, surveyLocalization, surveyStrings, QuestionCustomWidget, CustomWidgetCollection, QuestionCustomModel, QuestionCompositeModel, ComponentQuestionJSON, ComponentCollection, StylesManager, ListModel, PopupModel, PopupBaseViewModel, createPopupModalViewModel, QuestionButtonGroupModel, ButtonGroupItemModel, ButtonGroupItemValue, IsMobile, IsTouch, confirmAction, detectIEOrEdge, doKey2ClickUp, doKey2ClickDown, loadFileFromBase64, increaseHeightByContent, createSvg, CssClassBuilder, surveyCss, DragDropSurveyElements, DragDropChoices, defaultStandardCss, defaultBootstrapCss, defaultBootstrapMaterialCss, defaultV2Css, modernCss, SvgIconRegistry, SvgRegistry, SvgBundleViewModel, RendererFactory, ResponsivityManager, VerticalResponsivityManager, unwrap, Action, AdaptiveActionContainer, defaultActionBarCss, ActionContainer, TooltipManager, DragOrClickHelper, Survey, SurveyWindow, ImplementorBase, QuestionRow, Page, Panel, FlowPanel, QuestionImplementor, QuestionSelectBaseImplementor, QuestionCheckboxBaseImplementor, QuestionCheckbox, QuestionRanking, QuestionComment, QuestionDropdown, QuestionFile, QuestionHtml, QuestionMatrix, QuestionMatrixDropdown, QuestionMatrixDynamicImplementor, QuestionMatrixDynamic, QuestionPanelDynamic, MultipleTextItem, QuestionMultipleText, QuestionRadiogroup, QuestionRating, QuestionRatingImplementor, QuestionText, QuestionBoolean, QuestionEmpty, QuestionExpression, QuestionImagePicker, SurveyWindowImplementor, SurveyTemplateText, QuestionImage, QuestionSignaturePad, QuestionCustom, QuestionButtonGroup, ActionBarItemViewModel, ActionBarItemDropdownViewModel, ActionBarSeparatorViewModel, ActionContainerImplementor, CheckboxViewModel, BooleanRadioItemViewModel, BooleanRadioViewModel, PanelViewModel, PopupViewModel, showModal, ProgressButtonsViewModel, ProgressViewModel, TitleElementViewModel, TitleContentViewModel, DefaultTitleViewModel, TitleActionViewModel, StringEditorViewModel, StringViewerViewModel, LogoImageViewModel, Skeleton, RatingDropdownViewModel, DropdownViewModel, ListItemViewComponent, ListViewComponent, SvgIconViewModel, SurveyQuestionMatrixDynamicRemoveButton, SurveyQuestionMatrixDetailButton, SurveyQuestionMatrixDynamicDragDropIcon, ButtonGroupItemViewModel, TooltipErrorViewModel, SurveyQuestionPaneldynamicActioons */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _core__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./core */ "./src/entries/core.ts");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "Version", function() { return _core__WEBPACK_IMPORTED_MODULE_0__["Version"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "settings", function() { return _core__WEBPACK_IMPORTED_MODULE_0__["settings"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "Helpers", function() { return _core__WEBPACK_IMPORTED_MODULE_0__["Helpers"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "AnswerCountValidator", function() { return _core__WEBPACK_IMPORTED_MODULE_0__["AnswerCountValidator"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "EmailValidator", function() { return _core__WEBPACK_IMPORTED_MODULE_0__["EmailValidator"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "NumericValidator", function() { return _core__WEBPACK_IMPORTED_MODULE_0__["NumericValidator"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "RegexValidator", function() { return _core__WEBPACK_IMPORTED_MODULE_0__["RegexValidator"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "SurveyValidator", function() { return _core__WEBPACK_IMPORTED_MODULE_0__["SurveyValidator"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "TextValidator", function() { return _core__WEBPACK_IMPORTED_MODULE_0__["TextValidator"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "ValidatorResult", function() { return _core__WEBPACK_IMPORTED_MODULE_0__["ValidatorResult"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "ExpressionValidator", function() { return _core__WEBPACK_IMPORTED_MODULE_0__["ExpressionValidator"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "ValidatorRunner", function() { return _core__WEBPACK_IMPORTED_MODULE_0__["ValidatorRunner"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "ItemValue", function() { return _core__WEBPACK_IMPORTED_MODULE_0__["ItemValue"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "Base", function() { return _core__WEBPACK_IMPORTED_MODULE_0__["Base"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "Event", function() { return _core__WEBPACK_IMPORTED_MODULE_0__["Event"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "ArrayChanges", function() { return _core__WEBPACK_IMPORTED_MODULE_0__["ArrayChanges"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "ComputedUpdater", function() { return _core__WEBPACK_IMPORTED_MODULE_0__["ComputedUpdater"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "SurveyError", function() { return _core__WEBPACK_IMPORTED_MODULE_0__["SurveyError"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "SurveyElementCore", function() { return _core__WEBPACK_IMPORTED_MODULE_0__["SurveyElementCore"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "SurveyElement", function() { return _core__WEBPACK_IMPORTED_MODULE_0__["SurveyElement"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "DragTypeOverMeEnum", function() { return _core__WEBPACK_IMPORTED_MODULE_0__["DragTypeOverMeEnum"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "CalculatedValue", function() { return _core__WEBPACK_IMPORTED_MODULE_0__["CalculatedValue"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "CustomError", function() { return _core__WEBPACK_IMPORTED_MODULE_0__["CustomError"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "AnswerRequiredError", function() { return _core__WEBPACK_IMPORTED_MODULE_0__["AnswerRequiredError"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "OneAnswerRequiredError", function() { return _core__WEBPACK_IMPORTED_MODULE_0__["OneAnswerRequiredError"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "RequreNumericError", function() { return _core__WEBPACK_IMPORTED_MODULE_0__["RequreNumericError"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "ExceedSizeError", function() { return _core__WEBPACK_IMPORTED_MODULE_0__["ExceedSizeError"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "LocalizableString", function() { return _core__WEBPACK_IMPORTED_MODULE_0__["LocalizableString"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "LocalizableStrings", function() { return _core__WEBPACK_IMPORTED_MODULE_0__["LocalizableStrings"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "HtmlConditionItem", function() { return _core__WEBPACK_IMPORTED_MODULE_0__["HtmlConditionItem"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "UrlConditionItem", function() { return _core__WEBPACK_IMPORTED_MODULE_0__["UrlConditionItem"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "ChoicesRestful", function() { return _core__WEBPACK_IMPORTED_MODULE_0__["ChoicesRestful"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "ChoicesRestfull", function() { return _core__WEBPACK_IMPORTED_MODULE_0__["ChoicesRestfull"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "FunctionFactory", function() { return _core__WEBPACK_IMPORTED_MODULE_0__["FunctionFactory"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "registerFunction", function() { return _core__WEBPACK_IMPORTED_MODULE_0__["registerFunction"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "ConditionRunner", function() { return _core__WEBPACK_IMPORTED_MODULE_0__["ConditionRunner"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "ExpressionRunner", function() { return _core__WEBPACK_IMPORTED_MODULE_0__["ExpressionRunner"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "Operand", function() { return _core__WEBPACK_IMPORTED_MODULE_0__["Operand"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "Const", function() { return _core__WEBPACK_IMPORTED_MODULE_0__["Const"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "BinaryOperand", function() { return _core__WEBPACK_IMPORTED_MODULE_0__["BinaryOperand"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "Variable", function() { return _core__WEBPACK_IMPORTED_MODULE_0__["Variable"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "FunctionOperand", function() { return _core__WEBPACK_IMPORTED_MODULE_0__["FunctionOperand"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "ArrayOperand", function() { return _core__WEBPACK_IMPORTED_MODULE_0__["ArrayOperand"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "ConditionsParser", function() { return _core__WEBPACK_IMPORTED_MODULE_0__["ConditionsParser"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "ProcessValue", function() { return _core__WEBPACK_IMPORTED_MODULE_0__["ProcessValue"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "JsonError", function() { return _core__WEBPACK_IMPORTED_MODULE_0__["JsonError"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "JsonIncorrectTypeError", function() { return _core__WEBPACK_IMPORTED_MODULE_0__["JsonIncorrectTypeError"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "JsonMetadata", function() { return _core__WEBPACK_IMPORTED_MODULE_0__["JsonMetadata"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "JsonMetadataClass", function() { return _core__WEBPACK_IMPORTED_MODULE_0__["JsonMetadataClass"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "JsonMissingTypeError", function() { return _core__WEBPACK_IMPORTED_MODULE_0__["JsonMissingTypeError"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "JsonMissingTypeErrorBase", function() { return _core__WEBPACK_IMPORTED_MODULE_0__["JsonMissingTypeErrorBase"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "JsonObject", function() { return _core__WEBPACK_IMPORTED_MODULE_0__["JsonObject"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "JsonObjectProperty", function() { return _core__WEBPACK_IMPORTED_MODULE_0__["JsonObjectProperty"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "JsonRequiredPropertyError", function() { return _core__WEBPACK_IMPORTED_MODULE_0__["JsonRequiredPropertyError"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "JsonUnknownPropertyError", function() { return _core__WEBPACK_IMPORTED_MODULE_0__["JsonUnknownPropertyError"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "Serializer", function() { return _core__WEBPACK_IMPORTED_MODULE_0__["Serializer"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "property", function() { return _core__WEBPACK_IMPORTED_MODULE_0__["property"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "propertyArray", function() { return _core__WEBPACK_IMPORTED_MODULE_0__["propertyArray"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "MatrixDropdownCell", function() { return _core__WEBPACK_IMPORTED_MODULE_0__["MatrixDropdownCell"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "MatrixDropdownRowModelBase", function() { return _core__WEBPACK_IMPORTED_MODULE_0__["MatrixDropdownRowModelBase"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "QuestionMatrixDropdownModelBase", function() { return _core__WEBPACK_IMPORTED_MODULE_0__["QuestionMatrixDropdownModelBase"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "MatrixDropdownColumn", function() { return _core__WEBPACK_IMPORTED_MODULE_0__["MatrixDropdownColumn"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "matrixDropdownColumnTypes", function() { return _core__WEBPACK_IMPORTED_MODULE_0__["matrixDropdownColumnTypes"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "QuestionMatrixDropdownRenderedCell", function() { return _core__WEBPACK_IMPORTED_MODULE_0__["QuestionMatrixDropdownRenderedCell"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "QuestionMatrixDropdownRenderedRow", function() { return _core__WEBPACK_IMPORTED_MODULE_0__["QuestionMatrixDropdownRenderedRow"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "QuestionMatrixDropdownRenderedTable", function() { return _core__WEBPACK_IMPORTED_MODULE_0__["QuestionMatrixDropdownRenderedTable"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "MatrixDropdownRowModel", function() { return _core__WEBPACK_IMPORTED_MODULE_0__["MatrixDropdownRowModel"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "QuestionMatrixDropdownModel", function() { return _core__WEBPACK_IMPORTED_MODULE_0__["QuestionMatrixDropdownModel"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "MatrixDynamicRowModel", function() { return _core__WEBPACK_IMPORTED_MODULE_0__["MatrixDynamicRowModel"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "QuestionMatrixDynamicModel", function() { return _core__WEBPACK_IMPORTED_MODULE_0__["QuestionMatrixDynamicModel"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "MatrixRowModel", function() { return _core__WEBPACK_IMPORTED_MODULE_0__["MatrixRowModel"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "MatrixCells", function() { return _core__WEBPACK_IMPORTED_MODULE_0__["MatrixCells"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "QuestionMatrixModel", function() { return _core__WEBPACK_IMPORTED_MODULE_0__["QuestionMatrixModel"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "MultipleTextItemModel", function() { return _core__WEBPACK_IMPORTED_MODULE_0__["MultipleTextItemModel"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "QuestionMultipleTextModel", function() { return _core__WEBPACK_IMPORTED_MODULE_0__["QuestionMultipleTextModel"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "PanelModel", function() { return _core__WEBPACK_IMPORTED_MODULE_0__["PanelModel"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "PanelModelBase", function() { return _core__WEBPACK_IMPORTED_MODULE_0__["PanelModelBase"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "QuestionRowModel", function() { return _core__WEBPACK_IMPORTED_MODULE_0__["QuestionRowModel"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "FlowPanelModel", function() { return _core__WEBPACK_IMPORTED_MODULE_0__["FlowPanelModel"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "PageModel", function() { return _core__WEBPACK_IMPORTED_MODULE_0__["PageModel"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "DefaultTitleModel", function() { return _core__WEBPACK_IMPORTED_MODULE_0__["DefaultTitleModel"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "Question", function() { return _core__WEBPACK_IMPORTED_MODULE_0__["Question"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "QuestionNonValue", function() { return _core__WEBPACK_IMPORTED_MODULE_0__["QuestionNonValue"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "QuestionEmptyModel", function() { return _core__WEBPACK_IMPORTED_MODULE_0__["QuestionEmptyModel"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "QuestionCheckboxBase", function() { return _core__WEBPACK_IMPORTED_MODULE_0__["QuestionCheckboxBase"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "QuestionSelectBase", function() { return _core__WEBPACK_IMPORTED_MODULE_0__["QuestionSelectBase"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "QuestionCheckboxModel", function() { return _core__WEBPACK_IMPORTED_MODULE_0__["QuestionCheckboxModel"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "QuestionRankingModel", function() { return _core__WEBPACK_IMPORTED_MODULE_0__["QuestionRankingModel"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "QuestionCommentModel", function() { return _core__WEBPACK_IMPORTED_MODULE_0__["QuestionCommentModel"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "QuestionDropdownModel", function() { return _core__WEBPACK_IMPORTED_MODULE_0__["QuestionDropdownModel"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "QuestionFactory", function() { return _core__WEBPACK_IMPORTED_MODULE_0__["QuestionFactory"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "ElementFactory", function() { return _core__WEBPACK_IMPORTED_MODULE_0__["ElementFactory"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "QuestionFileModel", function() { return _core__WEBPACK_IMPORTED_MODULE_0__["QuestionFileModel"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "QuestionHtmlModel", function() { return _core__WEBPACK_IMPORTED_MODULE_0__["QuestionHtmlModel"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "QuestionRadiogroupModel", function() { return _core__WEBPACK_IMPORTED_MODULE_0__["QuestionRadiogroupModel"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "QuestionRatingModel", function() { return _core__WEBPACK_IMPORTED_MODULE_0__["QuestionRatingModel"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "RenderedRatingItem", function() { return _core__WEBPACK_IMPORTED_MODULE_0__["RenderedRatingItem"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "QuestionExpressionModel", function() { return _core__WEBPACK_IMPORTED_MODULE_0__["QuestionExpressionModel"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "QuestionTextModel", function() { return _core__WEBPACK_IMPORTED_MODULE_0__["QuestionTextModel"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "QuestionBooleanModel", function() { return _core__WEBPACK_IMPORTED_MODULE_0__["QuestionBooleanModel"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "QuestionImagePickerModel", function() { return _core__WEBPACK_IMPORTED_MODULE_0__["QuestionImagePickerModel"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "ImageItemValue", function() { return _core__WEBPACK_IMPORTED_MODULE_0__["ImageItemValue"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "QuestionImageModel", function() { return _core__WEBPACK_IMPORTED_MODULE_0__["QuestionImageModel"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "QuestionSignaturePadModel", function() { return _core__WEBPACK_IMPORTED_MODULE_0__["QuestionSignaturePadModel"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "QuestionPanelDynamicModel", function() { return _core__WEBPACK_IMPORTED_MODULE_0__["QuestionPanelDynamicModel"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "QuestionPanelDynamicItem", function() { return _core__WEBPACK_IMPORTED_MODULE_0__["QuestionPanelDynamicItem"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "SurveyTimer", function() { return _core__WEBPACK_IMPORTED_MODULE_0__["SurveyTimer"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "SurveyTimerModel", function() { return _core__WEBPACK_IMPORTED_MODULE_0__["SurveyTimerModel"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "SurveyProgressModel", function() { return _core__WEBPACK_IMPORTED_MODULE_0__["SurveyProgressModel"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "SurveyProgressButtonsModel", function() { return _core__WEBPACK_IMPORTED_MODULE_0__["SurveyProgressButtonsModel"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "SurveyModel", function() { return _core__WEBPACK_IMPORTED_MODULE_0__["SurveyModel"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "Model", function() { return _core__WEBPACK_IMPORTED_MODULE_0__["Model"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "SurveyTrigger", function() { return _core__WEBPACK_IMPORTED_MODULE_0__["SurveyTrigger"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "SurveyTriggerComplete", function() { return _core__WEBPACK_IMPORTED_MODULE_0__["SurveyTriggerComplete"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "SurveyTriggerSetValue", function() { return _core__WEBPACK_IMPORTED_MODULE_0__["SurveyTriggerSetValue"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "SurveyTriggerVisible", function() { return _core__WEBPACK_IMPORTED_MODULE_0__["SurveyTriggerVisible"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "SurveyTriggerCopyValue", function() { return _core__WEBPACK_IMPORTED_MODULE_0__["SurveyTriggerCopyValue"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "SurveyTriggerRunExpression", function() { return _core__WEBPACK_IMPORTED_MODULE_0__["SurveyTriggerRunExpression"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "Trigger", function() { return _core__WEBPACK_IMPORTED_MODULE_0__["Trigger"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "SurveyWindowModel", function() { return _core__WEBPACK_IMPORTED_MODULE_0__["SurveyWindowModel"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "TextPreProcessor", function() { return _core__WEBPACK_IMPORTED_MODULE_0__["TextPreProcessor"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "dxSurveyService", function() { return _core__WEBPACK_IMPORTED_MODULE_0__["dxSurveyService"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "englishStrings", function() { return _core__WEBPACK_IMPORTED_MODULE_0__["englishStrings"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "surveyLocalization", function() { return _core__WEBPACK_IMPORTED_MODULE_0__["surveyLocalization"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "surveyStrings", function() { return _core__WEBPACK_IMPORTED_MODULE_0__["surveyStrings"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "QuestionCustomWidget", function() { return _core__WEBPACK_IMPORTED_MODULE_0__["QuestionCustomWidget"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "CustomWidgetCollection", function() { return _core__WEBPACK_IMPORTED_MODULE_0__["CustomWidgetCollection"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "QuestionCustomModel", function() { return _core__WEBPACK_IMPORTED_MODULE_0__["QuestionCustomModel"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "QuestionCompositeModel", function() { return _core__WEBPACK_IMPORTED_MODULE_0__["QuestionCompositeModel"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "ComponentQuestionJSON", function() { return _core__WEBPACK_IMPORTED_MODULE_0__["ComponentQuestionJSON"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "ComponentCollection", function() { return _core__WEBPACK_IMPORTED_MODULE_0__["ComponentCollection"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "StylesManager", function() { return _core__WEBPACK_IMPORTED_MODULE_0__["StylesManager"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "ListModel", function() { return _core__WEBPACK_IMPORTED_MODULE_0__["ListModel"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "PopupModel", function() { return _core__WEBPACK_IMPORTED_MODULE_0__["PopupModel"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "PopupBaseViewModel", function() { return _core__WEBPACK_IMPORTED_MODULE_0__["PopupBaseViewModel"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "createPopupModalViewModel", function() { return _core__WEBPACK_IMPORTED_MODULE_0__["createPopupModalViewModel"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "QuestionButtonGroupModel", function() { return _core__WEBPACK_IMPORTED_MODULE_0__["QuestionButtonGroupModel"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "ButtonGroupItemModel", function() { return _core__WEBPACK_IMPORTED_MODULE_0__["ButtonGroupItemModel"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "ButtonGroupItemValue", function() { return _core__WEBPACK_IMPORTED_MODULE_0__["ButtonGroupItemValue"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "IsMobile", function() { return _core__WEBPACK_IMPORTED_MODULE_0__["IsMobile"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "IsTouch", function() { return _core__WEBPACK_IMPORTED_MODULE_0__["IsTouch"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "confirmAction", function() { return _core__WEBPACK_IMPORTED_MODULE_0__["confirmAction"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "detectIEOrEdge", function() { return _core__WEBPACK_IMPORTED_MODULE_0__["detectIEOrEdge"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "doKey2ClickUp", function() { return _core__WEBPACK_IMPORTED_MODULE_0__["doKey2ClickUp"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "doKey2ClickDown", function() { return _core__WEBPACK_IMPORTED_MODULE_0__["doKey2ClickDown"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "loadFileFromBase64", function() { return _core__WEBPACK_IMPORTED_MODULE_0__["loadFileFromBase64"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "increaseHeightByContent", function() { return _core__WEBPACK_IMPORTED_MODULE_0__["increaseHeightByContent"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "createSvg", function() { return _core__WEBPACK_IMPORTED_MODULE_0__["createSvg"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "CssClassBuilder", function() { return _core__WEBPACK_IMPORTED_MODULE_0__["CssClassBuilder"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "surveyCss", function() { return _core__WEBPACK_IMPORTED_MODULE_0__["surveyCss"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "DragDropSurveyElements", function() { return _core__WEBPACK_IMPORTED_MODULE_0__["DragDropSurveyElements"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "DragDropChoices", function() { return _core__WEBPACK_IMPORTED_MODULE_0__["DragDropChoices"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "defaultStandardCss", function() { return _core__WEBPACK_IMPORTED_MODULE_0__["defaultStandardCss"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "defaultBootstrapCss", function() { return _core__WEBPACK_IMPORTED_MODULE_0__["defaultBootstrapCss"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "defaultBootstrapMaterialCss", function() { return _core__WEBPACK_IMPORTED_MODULE_0__["defaultBootstrapMaterialCss"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "defaultV2Css", function() { return _core__WEBPACK_IMPORTED_MODULE_0__["defaultV2Css"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "modernCss", function() { return _core__WEBPACK_IMPORTED_MODULE_0__["modernCss"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "SvgIconRegistry", function() { return _core__WEBPACK_IMPORTED_MODULE_0__["SvgIconRegistry"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "SvgRegistry", function() { return _core__WEBPACK_IMPORTED_MODULE_0__["SvgRegistry"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "SvgBundleViewModel", function() { return _core__WEBPACK_IMPORTED_MODULE_0__["SvgBundleViewModel"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "RendererFactory", function() { return _core__WEBPACK_IMPORTED_MODULE_0__["RendererFactory"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "ResponsivityManager", function() { return _core__WEBPACK_IMPORTED_MODULE_0__["ResponsivityManager"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "VerticalResponsivityManager", function() { return _core__WEBPACK_IMPORTED_MODULE_0__["VerticalResponsivityManager"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "unwrap", function() { return _core__WEBPACK_IMPORTED_MODULE_0__["unwrap"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "Action", function() { return _core__WEBPACK_IMPORTED_MODULE_0__["Action"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "AdaptiveActionContainer", function() { return _core__WEBPACK_IMPORTED_MODULE_0__["AdaptiveActionContainer"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "defaultActionBarCss", function() { return _core__WEBPACK_IMPORTED_MODULE_0__["defaultActionBarCss"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "ActionContainer", function() { return _core__WEBPACK_IMPORTED_MODULE_0__["ActionContainer"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "TooltipManager", function() { return _core__WEBPACK_IMPORTED_MODULE_0__["TooltipManager"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "DragOrClickHelper", function() { return _core__WEBPACK_IMPORTED_MODULE_0__["DragOrClickHelper"]; });

/* harmony import */ var _chunks_localization__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./chunks/localization */ "./src/entries/chunks/localization.ts");
/* harmony import */ var _knockout_ui_model__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./knockout-ui-model */ "./src/entries/knockout-ui-model.ts");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "Survey", function() { return _knockout_ui_model__WEBPACK_IMPORTED_MODULE_2__["Survey"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "SurveyWindow", function() { return _knockout_ui_model__WEBPACK_IMPORTED_MODULE_2__["SurveyWindow"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "ImplementorBase", function() { return _knockout_ui_model__WEBPACK_IMPORTED_MODULE_2__["ImplementorBase"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "QuestionRow", function() { return _knockout_ui_model__WEBPACK_IMPORTED_MODULE_2__["QuestionRow"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "Page", function() { return _knockout_ui_model__WEBPACK_IMPORTED_MODULE_2__["Page"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "Panel", function() { return _knockout_ui_model__WEBPACK_IMPORTED_MODULE_2__["Panel"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "FlowPanel", function() { return _knockout_ui_model__WEBPACK_IMPORTED_MODULE_2__["FlowPanel"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "QuestionImplementor", function() { return _knockout_ui_model__WEBPACK_IMPORTED_MODULE_2__["QuestionImplementor"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "QuestionSelectBaseImplementor", function() { return _knockout_ui_model__WEBPACK_IMPORTED_MODULE_2__["QuestionSelectBaseImplementor"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "QuestionCheckboxBaseImplementor", function() { return _knockout_ui_model__WEBPACK_IMPORTED_MODULE_2__["QuestionCheckboxBaseImplementor"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "QuestionCheckbox", function() { return _knockout_ui_model__WEBPACK_IMPORTED_MODULE_2__["QuestionCheckbox"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "QuestionRanking", function() { return _knockout_ui_model__WEBPACK_IMPORTED_MODULE_2__["QuestionRanking"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "QuestionComment", function() { return _knockout_ui_model__WEBPACK_IMPORTED_MODULE_2__["QuestionComment"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "QuestionDropdown", function() { return _knockout_ui_model__WEBPACK_IMPORTED_MODULE_2__["QuestionDropdown"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "QuestionFile", function() { return _knockout_ui_model__WEBPACK_IMPORTED_MODULE_2__["QuestionFile"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "QuestionHtml", function() { return _knockout_ui_model__WEBPACK_IMPORTED_MODULE_2__["QuestionHtml"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "QuestionMatrix", function() { return _knockout_ui_model__WEBPACK_IMPORTED_MODULE_2__["QuestionMatrix"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "QuestionMatrixDropdown", function() { return _knockout_ui_model__WEBPACK_IMPORTED_MODULE_2__["QuestionMatrixDropdown"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "QuestionMatrixDynamicImplementor", function() { return _knockout_ui_model__WEBPACK_IMPORTED_MODULE_2__["QuestionMatrixDynamicImplementor"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "QuestionMatrixDynamic", function() { return _knockout_ui_model__WEBPACK_IMPORTED_MODULE_2__["QuestionMatrixDynamic"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "QuestionPanelDynamic", function() { return _knockout_ui_model__WEBPACK_IMPORTED_MODULE_2__["QuestionPanelDynamic"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "MultipleTextItem", function() { return _knockout_ui_model__WEBPACK_IMPORTED_MODULE_2__["MultipleTextItem"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "QuestionMultipleText", function() { return _knockout_ui_model__WEBPACK_IMPORTED_MODULE_2__["QuestionMultipleText"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "QuestionRadiogroup", function() { return _knockout_ui_model__WEBPACK_IMPORTED_MODULE_2__["QuestionRadiogroup"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "QuestionRating", function() { return _knockout_ui_model__WEBPACK_IMPORTED_MODULE_2__["QuestionRating"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "QuestionRatingImplementor", function() { return _knockout_ui_model__WEBPACK_IMPORTED_MODULE_2__["QuestionRatingImplementor"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "QuestionText", function() { return _knockout_ui_model__WEBPACK_IMPORTED_MODULE_2__["QuestionText"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "QuestionBoolean", function() { return _knockout_ui_model__WEBPACK_IMPORTED_MODULE_2__["QuestionBoolean"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "QuestionEmpty", function() { return _knockout_ui_model__WEBPACK_IMPORTED_MODULE_2__["QuestionEmpty"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "QuestionExpression", function() { return _knockout_ui_model__WEBPACK_IMPORTED_MODULE_2__["QuestionExpression"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "QuestionImagePicker", function() { return _knockout_ui_model__WEBPACK_IMPORTED_MODULE_2__["QuestionImagePicker"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "SurveyWindowImplementor", function() { return _knockout_ui_model__WEBPACK_IMPORTED_MODULE_2__["SurveyWindowImplementor"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "SurveyTemplateText", function() { return _knockout_ui_model__WEBPACK_IMPORTED_MODULE_2__["SurveyTemplateText"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "QuestionImage", function() { return _knockout_ui_model__WEBPACK_IMPORTED_MODULE_2__["QuestionImage"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "QuestionSignaturePad", function() { return _knockout_ui_model__WEBPACK_IMPORTED_MODULE_2__["QuestionSignaturePad"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "QuestionCustom", function() { return _knockout_ui_model__WEBPACK_IMPORTED_MODULE_2__["QuestionCustom"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "QuestionButtonGroup", function() { return _knockout_ui_model__WEBPACK_IMPORTED_MODULE_2__["QuestionButtonGroup"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "ActionBarItemViewModel", function() { return _knockout_ui_model__WEBPACK_IMPORTED_MODULE_2__["ActionBarItemViewModel"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "ActionBarItemDropdownViewModel", function() { return _knockout_ui_model__WEBPACK_IMPORTED_MODULE_2__["ActionBarItemDropdownViewModel"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "ActionBarSeparatorViewModel", function() { return _knockout_ui_model__WEBPACK_IMPORTED_MODULE_2__["ActionBarSeparatorViewModel"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "ActionContainerImplementor", function() { return _knockout_ui_model__WEBPACK_IMPORTED_MODULE_2__["ActionContainerImplementor"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "CheckboxViewModel", function() { return _knockout_ui_model__WEBPACK_IMPORTED_MODULE_2__["CheckboxViewModel"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "BooleanRadioItemViewModel", function() { return _knockout_ui_model__WEBPACK_IMPORTED_MODULE_2__["BooleanRadioItemViewModel"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "BooleanRadioViewModel", function() { return _knockout_ui_model__WEBPACK_IMPORTED_MODULE_2__["BooleanRadioViewModel"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "PanelViewModel", function() { return _knockout_ui_model__WEBPACK_IMPORTED_MODULE_2__["PanelViewModel"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "PopupViewModel", function() { return _knockout_ui_model__WEBPACK_IMPORTED_MODULE_2__["PopupViewModel"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "showModal", function() { return _knockout_ui_model__WEBPACK_IMPORTED_MODULE_2__["showModal"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "ProgressButtonsViewModel", function() { return _knockout_ui_model__WEBPACK_IMPORTED_MODULE_2__["ProgressButtonsViewModel"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "ProgressViewModel", function() { return _knockout_ui_model__WEBPACK_IMPORTED_MODULE_2__["ProgressViewModel"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "TitleElementViewModel", function() { return _knockout_ui_model__WEBPACK_IMPORTED_MODULE_2__["TitleElementViewModel"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "TitleContentViewModel", function() { return _knockout_ui_model__WEBPACK_IMPORTED_MODULE_2__["TitleContentViewModel"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "DefaultTitleViewModel", function() { return _knockout_ui_model__WEBPACK_IMPORTED_MODULE_2__["DefaultTitleViewModel"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "TitleActionViewModel", function() { return _knockout_ui_model__WEBPACK_IMPORTED_MODULE_2__["TitleActionViewModel"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "StringEditorViewModel", function() { return _knockout_ui_model__WEBPACK_IMPORTED_MODULE_2__["StringEditorViewModel"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "StringViewerViewModel", function() { return _knockout_ui_model__WEBPACK_IMPORTED_MODULE_2__["StringViewerViewModel"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "LogoImageViewModel", function() { return _knockout_ui_model__WEBPACK_IMPORTED_MODULE_2__["LogoImageViewModel"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "Skeleton", function() { return _knockout_ui_model__WEBPACK_IMPORTED_MODULE_2__["Skeleton"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "RatingDropdownViewModel", function() { return _knockout_ui_model__WEBPACK_IMPORTED_MODULE_2__["RatingDropdownViewModel"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "DropdownViewModel", function() { return _knockout_ui_model__WEBPACK_IMPORTED_MODULE_2__["DropdownViewModel"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "ListItemViewComponent", function() { return _knockout_ui_model__WEBPACK_IMPORTED_MODULE_2__["ListItemViewComponent"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "ListViewComponent", function() { return _knockout_ui_model__WEBPACK_IMPORTED_MODULE_2__["ListViewComponent"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "SvgIconViewModel", function() { return _knockout_ui_model__WEBPACK_IMPORTED_MODULE_2__["SvgIconViewModel"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "SurveyQuestionMatrixDynamicRemoveButton", function() { return _knockout_ui_model__WEBPACK_IMPORTED_MODULE_2__["SurveyQuestionMatrixDynamicRemoveButton"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "SurveyQuestionMatrixDetailButton", function() { return _knockout_ui_model__WEBPACK_IMPORTED_MODULE_2__["SurveyQuestionMatrixDetailButton"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "SurveyQuestionMatrixDynamicDragDropIcon", function() { return _knockout_ui_model__WEBPACK_IMPORTED_MODULE_2__["SurveyQuestionMatrixDynamicDragDropIcon"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "ButtonGroupItemViewModel", function() { return _knockout_ui_model__WEBPACK_IMPORTED_MODULE_2__["ButtonGroupItemViewModel"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "TooltipErrorViewModel", function() { return _knockout_ui_model__WEBPACK_IMPORTED_MODULE_2__["TooltipErrorViewModel"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "SurveyQuestionPaneldynamicActioons", function() { return _knockout_ui_model__WEBPACK_IMPORTED_MODULE_2__["SurveyQuestionPaneldynamicActioons"]; });


// localization




/***/ }),

/***/ "./src/error.ts":
/*!**********************!*\
  !*** ./src/error.ts ***!
  \**********************/
/*! exports provided: AnswerRequiredError, OneAnswerRequiredError, RequreNumericError, ExceedSizeError, WebRequestError, WebRequestEmptyError, OtherEmptyError, UploadingFileError, RequiredInAllRowsError, MinRowCountError, KeyDuplicationError, CustomError */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "AnswerRequiredError", function() { return AnswerRequiredError; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "OneAnswerRequiredError", function() { return OneAnswerRequiredError; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "RequreNumericError", function() { return RequreNumericError; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "ExceedSizeError", function() { return ExceedSizeError; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "WebRequestError", function() { return WebRequestError; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "WebRequestEmptyError", function() { return WebRequestEmptyError; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "OtherEmptyError", function() { return OtherEmptyError; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "UploadingFileError", function() { return UploadingFileError; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "RequiredInAllRowsError", function() { return RequiredInAllRowsError; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "MinRowCountError", function() { return MinRowCountError; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "KeyDuplicationError", function() { return KeyDuplicationError; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "CustomError", function() { return CustomError; });
/* harmony import */ var _surveyStrings__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./surveyStrings */ "./src/surveyStrings.ts");
/* harmony import */ var _survey_error__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./survey-error */ "./src/survey-error.ts");
var __extends = (undefined && undefined.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();


var AnswerRequiredError = /** @class */ (function (_super) {
    __extends(AnswerRequiredError, _super);
    function AnswerRequiredError(text, errorOwner) {
        if (text === void 0) { text = null; }
        if (errorOwner === void 0) { errorOwner = null; }
        var _this = _super.call(this, text, errorOwner) || this;
        _this.text = text;
        return _this;
    }
    AnswerRequiredError.prototype.getErrorType = function () {
        return "required";
    };
    AnswerRequiredError.prototype.getDefaultText = function () {
        return _surveyStrings__WEBPACK_IMPORTED_MODULE_0__["surveyLocalization"].getString("requiredError");
    };
    return AnswerRequiredError;
}(_survey_error__WEBPACK_IMPORTED_MODULE_1__["SurveyError"]));

var OneAnswerRequiredError = /** @class */ (function (_super) {
    __extends(OneAnswerRequiredError, _super);
    function OneAnswerRequiredError(text, errorOwner) {
        if (text === void 0) { text = null; }
        if (errorOwner === void 0) { errorOwner = null; }
        var _this = _super.call(this, text, errorOwner) || this;
        _this.text = text;
        return _this;
    }
    OneAnswerRequiredError.prototype.getErrorType = function () {
        return "requireoneanswer";
    };
    OneAnswerRequiredError.prototype.getDefaultText = function () {
        return _surveyStrings__WEBPACK_IMPORTED_MODULE_0__["surveyLocalization"].getString("requiredErrorInPanel");
    };
    return OneAnswerRequiredError;
}(_survey_error__WEBPACK_IMPORTED_MODULE_1__["SurveyError"]));

var RequreNumericError = /** @class */ (function (_super) {
    __extends(RequreNumericError, _super);
    function RequreNumericError(text, errorOwner) {
        if (text === void 0) { text = null; }
        if (errorOwner === void 0) { errorOwner = null; }
        var _this = _super.call(this, text, errorOwner) || this;
        _this.text = text;
        return _this;
    }
    RequreNumericError.prototype.getErrorType = function () {
        return "requirenumeric";
    };
    RequreNumericError.prototype.getDefaultText = function () {
        return _surveyStrings__WEBPACK_IMPORTED_MODULE_0__["surveyLocalization"].getString("numericError");
    };
    return RequreNumericError;
}(_survey_error__WEBPACK_IMPORTED_MODULE_1__["SurveyError"]));

var ExceedSizeError = /** @class */ (function (_super) {
    __extends(ExceedSizeError, _super);
    function ExceedSizeError(maxSize, errorOwner) {
        if (errorOwner === void 0) { errorOwner = null; }
        var _this = _super.call(this, null, errorOwner) || this;
        _this.maxSize = maxSize;
        _this.locText.text = _this.getText();
        return _this;
    }
    ExceedSizeError.prototype.getErrorType = function () {
        return "exceedsize";
    };
    ExceedSizeError.prototype.getDefaultText = function () {
        return _surveyStrings__WEBPACK_IMPORTED_MODULE_0__["surveyLocalization"]
            .getString("exceedMaxSize")["format"](this.getTextSize());
    };
    ExceedSizeError.prototype.getTextSize = function () {
        var sizes = ["Bytes", "KB", "MB", "GB", "TB"];
        var fixed = [0, 0, 2, 3, 3];
        if (this.maxSize === 0) {
            return "0 Byte";
        }
        var i = Math.floor(Math.log(this.maxSize) / Math.log(1024));
        var value = this.maxSize / Math.pow(1024, i);
        return value.toFixed(fixed[i]) + " " + sizes[i];
    };
    return ExceedSizeError;
}(_survey_error__WEBPACK_IMPORTED_MODULE_1__["SurveyError"]));

var WebRequestError = /** @class */ (function (_super) {
    __extends(WebRequestError, _super);
    function WebRequestError(status, response, errorOwner) {
        if (errorOwner === void 0) { errorOwner = null; }
        var _this = _super.call(this, null, errorOwner) || this;
        _this.status = status;
        _this.response = response;
        return _this;
    }
    WebRequestError.prototype.getErrorType = function () {
        return "webrequest";
    };
    WebRequestError.prototype.getDefaultText = function () {
        return _surveyStrings__WEBPACK_IMPORTED_MODULE_0__["surveyLocalization"]
            .getString("urlRequestError")["format"](this.status, this.response);
    };
    return WebRequestError;
}(_survey_error__WEBPACK_IMPORTED_MODULE_1__["SurveyError"]));

var WebRequestEmptyError = /** @class */ (function (_super) {
    __extends(WebRequestEmptyError, _super);
    function WebRequestEmptyError(text, errorOwner) {
        if (errorOwner === void 0) { errorOwner = null; }
        var _this = _super.call(this, text, errorOwner) || this;
        _this.text = text;
        return _this;
    }
    WebRequestEmptyError.prototype.getErrorType = function () {
        return "webrequestempty";
    };
    WebRequestEmptyError.prototype.getDefaultText = function () {
        return _surveyStrings__WEBPACK_IMPORTED_MODULE_0__["surveyLocalization"].getString("urlGetChoicesError");
    };
    return WebRequestEmptyError;
}(_survey_error__WEBPACK_IMPORTED_MODULE_1__["SurveyError"]));

var OtherEmptyError = /** @class */ (function (_super) {
    __extends(OtherEmptyError, _super);
    function OtherEmptyError(text, errorOwner) {
        if (errorOwner === void 0) { errorOwner = null; }
        var _this = _super.call(this, text, errorOwner) || this;
        _this.text = text;
        return _this;
    }
    OtherEmptyError.prototype.getErrorType = function () {
        return "otherempty";
    };
    OtherEmptyError.prototype.getDefaultText = function () {
        return _surveyStrings__WEBPACK_IMPORTED_MODULE_0__["surveyLocalization"].getString("otherRequiredError");
    };
    return OtherEmptyError;
}(_survey_error__WEBPACK_IMPORTED_MODULE_1__["SurveyError"]));

var UploadingFileError = /** @class */ (function (_super) {
    __extends(UploadingFileError, _super);
    function UploadingFileError(text, errorOwner) {
        if (errorOwner === void 0) { errorOwner = null; }
        var _this = _super.call(this, text, errorOwner) || this;
        _this.text = text;
        return _this;
    }
    UploadingFileError.prototype.getErrorType = function () {
        return "uploadingfile";
    };
    UploadingFileError.prototype.getDefaultText = function () {
        return _surveyStrings__WEBPACK_IMPORTED_MODULE_0__["surveyLocalization"].getString("uploadingFile");
    };
    return UploadingFileError;
}(_survey_error__WEBPACK_IMPORTED_MODULE_1__["SurveyError"]));

var RequiredInAllRowsError = /** @class */ (function (_super) {
    __extends(RequiredInAllRowsError, _super);
    function RequiredInAllRowsError(text, errorOwner) {
        if (errorOwner === void 0) { errorOwner = null; }
        var _this = _super.call(this, text, errorOwner) || this;
        _this.text = text;
        return _this;
    }
    RequiredInAllRowsError.prototype.getErrorType = function () {
        return "requiredinallrowserror";
    };
    RequiredInAllRowsError.prototype.getDefaultText = function () {
        return _surveyStrings__WEBPACK_IMPORTED_MODULE_0__["surveyLocalization"].getString("requiredInAllRowsError");
    };
    return RequiredInAllRowsError;
}(_survey_error__WEBPACK_IMPORTED_MODULE_1__["SurveyError"]));

var MinRowCountError = /** @class */ (function (_super) {
    __extends(MinRowCountError, _super);
    function MinRowCountError(minRowCount, errorOwner) {
        if (errorOwner === void 0) { errorOwner = null; }
        var _this = _super.call(this, null, errorOwner) || this;
        _this.minRowCount = minRowCount;
        return _this;
    }
    MinRowCountError.prototype.getErrorType = function () {
        return "minrowcounterror";
    };
    MinRowCountError.prototype.getDefaultText = function () {
        return _surveyStrings__WEBPACK_IMPORTED_MODULE_0__["surveyLocalization"]
            .getString("minRowCountError")["format"](this.minRowCount);
    };
    return MinRowCountError;
}(_survey_error__WEBPACK_IMPORTED_MODULE_1__["SurveyError"]));

var KeyDuplicationError = /** @class */ (function (_super) {
    __extends(KeyDuplicationError, _super);
    function KeyDuplicationError(text, errorOwner) {
        if (errorOwner === void 0) { errorOwner = null; }
        var _this = _super.call(this, text, errorOwner) || this;
        _this.text = text;
        return _this;
    }
    KeyDuplicationError.prototype.getErrorType = function () {
        return "keyduplicationerror";
    };
    KeyDuplicationError.prototype.getDefaultText = function () {
        return _surveyStrings__WEBPACK_IMPORTED_MODULE_0__["surveyLocalization"].getString("keyDuplicationError");
    };
    return KeyDuplicationError;
}(_survey_error__WEBPACK_IMPORTED_MODULE_1__["SurveyError"]));

var CustomError = /** @class */ (function (_super) {
    __extends(CustomError, _super);
    function CustomError(text, errorOwner) {
        if (errorOwner === void 0) { errorOwner = null; }
        var _this = _super.call(this, text, errorOwner) || this;
        _this.text = text;
        return _this;
    }
    CustomError.prototype.getErrorType = function () {
        return "custom";
    };
    return CustomError;
}(_survey_error__WEBPACK_IMPORTED_MODULE_1__["SurveyError"]));



/***/ }),

/***/ "./src/expressionItems.ts":
/*!********************************!*\
  !*** ./src/expressionItems.ts ***!
  \********************************/
/*! exports provided: ExpressionItem, HtmlConditionItem, UrlConditionItem */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "ExpressionItem", function() { return ExpressionItem; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "HtmlConditionItem", function() { return HtmlConditionItem; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "UrlConditionItem", function() { return UrlConditionItem; });
/* harmony import */ var _jsonobject__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./jsonobject */ "./src/jsonobject.ts");
/* harmony import */ var _base__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./base */ "./src/base.ts");
/* harmony import */ var _conditions__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./conditions */ "./src/conditions.ts");
var __extends = (undefined && undefined.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();



/**
 * Base class for HtmlConditionItem and UrlConditionItem classes.
 */
var ExpressionItem = /** @class */ (function (_super) {
    __extends(ExpressionItem, _super);
    function ExpressionItem(expression) {
        if (expression === void 0) { expression = null; }
        var _this = _super.call(this) || this;
        _this.createLocalizableString("html", _this);
        _this.expression = expression;
        return _this;
    }
    ExpressionItem.prototype.getType = function () {
        return "expressionitem";
    };
    ExpressionItem.prototype.runCondition = function (values, properties) {
        if (!this.expression)
            return false;
        return new _conditions__WEBPACK_IMPORTED_MODULE_2__["ConditionRunner"](this.expression).run(values, properties);
    };
    Object.defineProperty(ExpressionItem.prototype, "expression", {
        /**
         * The expression property. If this expression returns true, then survey will use html property to show on complete page.
         */
        get: function () {
            return this.getPropertyValue("expression", "");
        },
        set: function (val) {
            this.setPropertyValue("expression", val);
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(ExpressionItem.prototype, "locHtml", {
        get: function () {
            return this.getLocalizableString("html");
        },
        enumerable: false,
        configurable: true
    });
    ExpressionItem.prototype.getLocale = function () {
        return !!this.locOwner ? this.locOwner.getLocale() : "";
    };
    ExpressionItem.prototype.getMarkdownHtml = function (text, name) {
        return !!this.locOwner ? this.locOwner.getMarkdownHtml(text, name) : null;
    };
    ExpressionItem.prototype.getRenderer = function (name) {
        return !!this.locOwner ? this.locOwner.getRenderer(name) : null;
    };
    ExpressionItem.prototype.getRendererContext = function (locStr) {
        return !!this.locOwner ? this.locOwner.getRendererContext(locStr) : locStr;
    };
    ExpressionItem.prototype.getProcessedText = function (text) {
        return this.locOwner ? this.locOwner.getProcessedText(text) : text;
    };
    ExpressionItem.prototype.getSurvey = function (isLive) {
        if (isLive === void 0) { isLive = false; }
        return this.locOwner;
    };
    return ExpressionItem;
}(_base__WEBPACK_IMPORTED_MODULE_1__["Base"]));

/**
 * A class that contains expression and html propeties. It uses in survey.completedHtmlOnCondition array.
 * If the expression returns true then html of this item uses instead of survey.completedHtml property
 * @see SurveyModel.completedHtmlOnCondition
 * @see SurveyModel.completedHtml
 */
var HtmlConditionItem = /** @class */ (function (_super) {
    __extends(HtmlConditionItem, _super);
    function HtmlConditionItem(expression, html) {
        if (expression === void 0) { expression = null; }
        if (html === void 0) { html = null; }
        var _this = _super.call(this, expression) || this;
        _this.createLocalizableString("html", _this);
        _this.html = html;
        return _this;
    }
    HtmlConditionItem.prototype.getType = function () {
        return "htmlconditionitem";
    };
    Object.defineProperty(HtmlConditionItem.prototype, "html", {
        /**
         * The html that shows on completed ('Thank you') page. The expression should return true
         * @see expression
         */
        get: function () {
            return this.getLocalizableStringText("html");
        },
        set: function (value) {
            this.setLocalizableStringText("html", value);
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(HtmlConditionItem.prototype, "locHtml", {
        get: function () {
            return this.getLocalizableString("html");
        },
        enumerable: false,
        configurable: true
    });
    return HtmlConditionItem;
}(ExpressionItem));

/**
 * A class that contains expression and url propeties. It uses in survey.navigateToUrlOnCondition array.
 * If the expression returns true then url of this item uses instead of survey.navigateToUrl property
 * @see SurveyModel.navigateToUrl
 */
var UrlConditionItem = /** @class */ (function (_super) {
    __extends(UrlConditionItem, _super);
    function UrlConditionItem(expression, url) {
        if (expression === void 0) { expression = null; }
        if (url === void 0) { url = null; }
        var _this = _super.call(this, expression) || this;
        _this.createLocalizableString("url", _this);
        _this.url = url;
        return _this;
    }
    UrlConditionItem.prototype.getType = function () {
        return "urlconditionitem";
    };
    Object.defineProperty(UrlConditionItem.prototype, "url", {
        /**
         * The url that survey navigates to on completing the survey. The expression should return true
         * @see expression
         */
        get: function () {
            return this.getLocalizableStringText("url");
        },
        set: function (value) {
            this.setLocalizableStringText("url", value);
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(UrlConditionItem.prototype, "locUrl", {
        get: function () {
            return this.getLocalizableString("url");
        },
        enumerable: false,
        configurable: true
    });
    return UrlConditionItem;
}(ExpressionItem));

_jsonobject__WEBPACK_IMPORTED_MODULE_0__["Serializer"].addClass("expressionitem", ["expression:condition"], function () {
    return new ExpressionItem();
}, "base");
_jsonobject__WEBPACK_IMPORTED_MODULE_0__["Serializer"].addClass("htmlconditionitem", [{ name: "html:html", serializationProperty: "locHtml" }], function () {
    return new HtmlConditionItem();
}, "expressionitem");
_jsonobject__WEBPACK_IMPORTED_MODULE_0__["Serializer"].addClass("urlconditionitem", [{ name: "url:string", serializationProperty: "locUrl" }], function () {
    return new UrlConditionItem();
}, "expressionitem");


/***/ }),

/***/ "./src/expressions/expressionParser.ts":
/*!*********************************************!*\
  !*** ./src/expressions/expressionParser.ts ***!
  \*********************************************/
/*! exports provided: SyntaxError, parse */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "SyntaxError", function() { return SyntaxError; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "parse", function() { return parse; });
/* harmony import */ var _expressions__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./expressions */ "./src/expressions/expressions.ts");
var __extends = (undefined && undefined.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();

// Generated by PEG.js v. 0.10.0 (ts-pegjs plugin v. 0.3.1 )
//
// https://pegjs.org/   https://github.com/metadevpro/ts-pegjs
"use strict";
var SyntaxError = /** @class */ (function (_super) {
    __extends(SyntaxError, _super);
    function SyntaxError(message, expected, found, location) {
        var _this = _super.call(this) || this;
        _this.message = message;
        _this.expected = expected;
        _this.found = found;
        _this.location = location;
        _this.name = "SyntaxError";
        if (typeof Error.captureStackTrace === "function") {
            Error.captureStackTrace(_this, SyntaxError);
        }
        return _this;
    }
    SyntaxError.buildMessage = function (expected, found) {
        function hex(ch) {
            return ch.charCodeAt(0).toString(16).toUpperCase();
        }
        function literalEscape(s) {
            return s
                .replace(/\\/g, "\\\\")
                .replace(/"/g, "\\\"")
                .replace(/\0/g, "\\0")
                .replace(/\t/g, "\\t")
                .replace(/\n/g, "\\n")
                .replace(/\r/g, "\\r")
                // eslint-disable-next-line no-control-regex
                .replace(/[\x00-\x0F]/g, function (ch) { return "\\x0" + hex(ch); })
                // eslint-disable-next-line no-control-regex
                .replace(/[\x10-\x1F\x7F-\x9F]/g, function (ch) { return "\\x" + hex(ch); });
        }
        function classEscape(s) {
            return s
                .replace(/\\/g, "\\\\")
                .replace(/\]/g, "\\]")
                .replace(/\^/g, "\\^")
                .replace(/-/g, "\\-")
                .replace(/\0/g, "\\0")
                .replace(/\t/g, "\\t")
                .replace(/\n/g, "\\n")
                .replace(/\r/g, "\\r")
                // eslint-disable-next-line no-control-regex
                .replace(/[\x00-\x0F]/g, function (ch) { return "\\x0" + hex(ch); })
                // eslint-disable-next-line no-control-regex
                .replace(/[\x10-\x1F\x7F-\x9F]/g, function (ch) { return "\\x" + hex(ch); });
        }
        function describeExpectation(expectation) {
            switch (expectation.type) {
                case "literal":
                    return "\"" + literalEscape(expectation.text) + "\"";
                case "class":
                    var escapedParts = expectation.parts.map(function (part) {
                        return Array.isArray(part)
                            ? classEscape(part[0]) + "-" + classEscape(part[1])
                            : classEscape(part);
                    });
                    return "[" + (expectation.inverted ? "^" : "") + escapedParts + "]";
                case "any":
                    return "any character";
                case "end":
                    return "end of input";
                case "other":
                    return expectation.description;
            }
        }
        function describeExpected(expected1) {
            var descriptions = expected1.map(describeExpectation);
            var i;
            var j;
            descriptions.sort();
            if (descriptions.length > 0) {
                for (i = 1, j = 1; i < descriptions.length; i++) {
                    if (descriptions[i - 1] !== descriptions[i]) {
                        descriptions[j] = descriptions[i];
                        j++;
                    }
                }
                descriptions.length = j;
            }
            switch (descriptions.length) {
                case 1:
                    return descriptions[0];
                case 2:
                    return descriptions[0] + " or " + descriptions[1];
                default:
                    return descriptions.slice(0, -1).join(", ")
                        + ", or "
                        + descriptions[descriptions.length - 1];
            }
        }
        function describeFound(found1) {
            return found1 ? "\"" + literalEscape(found1) + "\"" : "end of input";
        }
        return "Expected " + describeExpected(expected) + " but " + describeFound(found) + " found.";
    };
    return SyntaxError;
}(Error));

function peg$parse(input, options) {
    options = options !== undefined ? options : {};
    var peg$FAILED = {};
    var peg$startRuleFunctions = { Expression: peg$parseExpression };
    var peg$startRuleFunction = peg$parseExpression;
    var peg$c0 = function (head, tail) {
        return buildBinaryOperand(head, tail, true);
    };
    var peg$c1 = "||";
    var peg$c2 = peg$literalExpectation("||", false);
    var peg$c3 = "or";
    var peg$c4 = peg$literalExpectation("or", true);
    var peg$c5 = function () { return "or"; };
    var peg$c6 = "&&";
    var peg$c7 = peg$literalExpectation("&&", false);
    var peg$c8 = "and";
    var peg$c9 = peg$literalExpectation("and", true);
    var peg$c10 = function () { return "and"; };
    var peg$c11 = function (head, tail) {
        return buildBinaryOperand(head, tail);
    };
    var peg$c12 = "<=";
    var peg$c13 = peg$literalExpectation("<=", false);
    var peg$c14 = "lessorequal";
    var peg$c15 = peg$literalExpectation("lessorequal", true);
    var peg$c16 = function () { return "lessorequal"; };
    var peg$c17 = ">=";
    var peg$c18 = peg$literalExpectation(">=", false);
    var peg$c19 = "greaterorequal";
    var peg$c20 = peg$literalExpectation("greaterorequal", true);
    var peg$c21 = function () { return "greaterorequal"; };
    var peg$c22 = "=";
    var peg$c23 = peg$literalExpectation("=", false);
    var peg$c24 = "equal";
    var peg$c25 = peg$literalExpectation("equal", true);
    var peg$c26 = function () { return "equal"; };
    var peg$c27 = "!=";
    var peg$c28 = peg$literalExpectation("!=", false);
    var peg$c29 = "notequal";
    var peg$c30 = peg$literalExpectation("notequal", true);
    var peg$c31 = function () { return "notequal"; };
    var peg$c32 = "<";
    var peg$c33 = peg$literalExpectation("<", false);
    var peg$c34 = "less";
    var peg$c35 = peg$literalExpectation("less", true);
    var peg$c36 = function () { return "less"; };
    var peg$c37 = ">";
    var peg$c38 = peg$literalExpectation(">", false);
    var peg$c39 = "greater";
    var peg$c40 = peg$literalExpectation("greater", true);
    var peg$c41 = function () { return "greater"; };
    var peg$c42 = "+";
    var peg$c43 = peg$literalExpectation("+", false);
    var peg$c44 = function () { return "plus"; };
    var peg$c45 = "-";
    var peg$c46 = peg$literalExpectation("-", false);
    var peg$c47 = function () { return "minus"; };
    var peg$c48 = "*";
    var peg$c49 = peg$literalExpectation("*", false);
    var peg$c50 = function () { return "mul"; };
    var peg$c51 = "/";
    var peg$c52 = peg$literalExpectation("/", false);
    var peg$c53 = function () { return "div"; };
    var peg$c54 = "%";
    var peg$c55 = peg$literalExpectation("%", false);
    var peg$c56 = function () { return "mod"; };
    var peg$c57 = "^";
    var peg$c58 = peg$literalExpectation("^", false);
    var peg$c59 = "power";
    var peg$c60 = peg$literalExpectation("power", true);
    var peg$c61 = function () { return "power"; };
    var peg$c62 = "*=";
    var peg$c63 = peg$literalExpectation("*=", false);
    var peg$c64 = "contains";
    var peg$c65 = peg$literalExpectation("contains", true);
    var peg$c66 = "contain";
    var peg$c67 = peg$literalExpectation("contain", true);
    var peg$c68 = function () { return "contains"; };
    var peg$c69 = "notcontains";
    var peg$c70 = peg$literalExpectation("notcontains", true);
    var peg$c71 = "notcontain";
    var peg$c72 = peg$literalExpectation("notcontain", true);
    var peg$c73 = function () { return "notcontains"; };
    var peg$c74 = "anyof";
    var peg$c75 = peg$literalExpectation("anyof", true);
    var peg$c76 = function () { return "anyof"; };
    var peg$c77 = "allof";
    var peg$c78 = peg$literalExpectation("allof", true);
    var peg$c79 = function () { return "allof"; };
    var peg$c80 = "(";
    var peg$c81 = peg$literalExpectation("(", false);
    var peg$c82 = ")";
    var peg$c83 = peg$literalExpectation(")", false);
    var peg$c84 = function (expr) { return expr; };
    var peg$c85 = function (name, params) { return new _expressions__WEBPACK_IMPORTED_MODULE_0__["FunctionOperand"](name, params); };
    var peg$c86 = "!";
    var peg$c87 = peg$literalExpectation("!", false);
    var peg$c88 = "negate";
    var peg$c89 = peg$literalExpectation("negate", true);
    var peg$c90 = function (expr) { return new _expressions__WEBPACK_IMPORTED_MODULE_0__["UnaryOperand"](expr, "negate"); };
    var peg$c91 = function (expr, op) { return new _expressions__WEBPACK_IMPORTED_MODULE_0__["UnaryOperand"](expr, op); };
    var peg$c92 = "empty";
    var peg$c93 = peg$literalExpectation("empty", true);
    var peg$c94 = function () { return "empty"; };
    var peg$c95 = "notempty";
    var peg$c96 = peg$literalExpectation("notempty", true);
    var peg$c97 = function () { return "notempty"; };
    var peg$c98 = "undefined";
    var peg$c99 = peg$literalExpectation("undefined", false);
    var peg$c100 = "null";
    var peg$c101 = peg$literalExpectation("null", false);
    var peg$c102 = function () { return null; };
    var peg$c103 = function (value) { return new _expressions__WEBPACK_IMPORTED_MODULE_0__["Const"](value); };
    var peg$c104 = "{";
    var peg$c105 = peg$literalExpectation("{", false);
    var peg$c106 = "}";
    var peg$c107 = peg$literalExpectation("}", false);
    var peg$c108 = function (value) { return new _expressions__WEBPACK_IMPORTED_MODULE_0__["Variable"](value); };
    var peg$c109 = function (value) { return value; };
    var peg$c110 = "''";
    var peg$c111 = peg$literalExpectation("''", false);
    var peg$c112 = function () { return ""; };
    var peg$c113 = "\"\"";
    var peg$c114 = peg$literalExpectation("\"\"", false);
    var peg$c115 = "'";
    var peg$c116 = peg$literalExpectation("'", false);
    var peg$c117 = function (value) { return "'" + value + "'"; };
    var peg$c118 = "\"";
    var peg$c119 = peg$literalExpectation("\"", false);
    var peg$c120 = "[";
    var peg$c121 = peg$literalExpectation("[", false);
    var peg$c122 = "]";
    var peg$c123 = peg$literalExpectation("]", false);
    var peg$c124 = function (sequence) { return sequence; };
    var peg$c125 = ",";
    var peg$c126 = peg$literalExpectation(",", false);
    var peg$c127 = function (expr, tail) {
        if (expr == null)
            return new _expressions__WEBPACK_IMPORTED_MODULE_0__["ArrayOperand"]([]);
        var array = [expr];
        if (Array.isArray(tail)) {
            var flatten = flattenArray(tail);
            for (var i = 3; i < flatten.length; i += 4) {
                array.push(flatten[i]);
            }
        }
        return new _expressions__WEBPACK_IMPORTED_MODULE_0__["ArrayOperand"](array);
    };
    var peg$c128 = "true";
    var peg$c129 = peg$literalExpectation("true", true);
    var peg$c130 = function () { return true; };
    var peg$c131 = "false";
    var peg$c132 = peg$literalExpectation("false", true);
    var peg$c133 = function () { return false; };
    var peg$c134 = "0x";
    var peg$c135 = peg$literalExpectation("0x", false);
    var peg$c136 = function () { return parseInt(text(), 16); };
    var peg$c137 = /^[\-]/;
    var peg$c138 = peg$classExpectation(["-"], false, false);
    var peg$c139 = function (sign, num) { return sign == null ? num : -num; };
    var peg$c140 = ".";
    var peg$c141 = peg$literalExpectation(".", false);
    var peg$c142 = function () { return parseFloat(text()); };
    var peg$c143 = function () { return parseInt(text(), 10); };
    var peg$c144 = "0";
    var peg$c145 = peg$literalExpectation("0", false);
    var peg$c146 = function () { return 0; };
    var peg$c147 = function (chars) { return chars.join(""); };
    var peg$c148 = "\\'";
    var peg$c149 = peg$literalExpectation("\\'", false);
    var peg$c150 = function () { return "'"; };
    var peg$c151 = "\\\"";
    var peg$c152 = peg$literalExpectation("\\\"", false);
    var peg$c153 = function () { return "\""; };
    var peg$c154 = /^[^"']/;
    var peg$c155 = peg$classExpectation(["\"", "'"], true, false);
    var peg$c156 = function () { return text(); };
    var peg$c157 = /^[^{}]/;
    var peg$c158 = peg$classExpectation(["{", "}"], true, false);
    var peg$c159 = /^[0-9]/;
    var peg$c160 = peg$classExpectation([["0", "9"]], false, false);
    var peg$c161 = /^[1-9]/;
    var peg$c162 = peg$classExpectation([["1", "9"]], false, false);
    var peg$c163 = /^[a-zA-Z]/;
    var peg$c164 = peg$classExpectation([["a", "z"], ["A", "Z"]], false, false);
    var peg$c165 = peg$otherExpectation("whitespace");
    var peg$c166 = /^[ \t\n\r]/;
    var peg$c167 = peg$classExpectation([" ", "\t", "\n", "\r"], false, false);
    var peg$currPos = 0;
    var peg$savedPos = 0;
    var peg$posDetailsCache = [{ line: 1, column: 1 }];
    var peg$maxFailPos = 0;
    var peg$maxFailExpected = [];
    var peg$silentFails = 0;
    var peg$resultsCache = {};
    var peg$result;
    if (options.startRule !== undefined) {
        if (!(options.startRule in peg$startRuleFunctions)) {
            throw new Error("Can't start parsing from rule \"" + options.startRule + "\".");
        }
        peg$startRuleFunction = peg$startRuleFunctions[options.startRule];
    }
    function text() {
        return input.substring(peg$savedPos, peg$currPos);
    }
    function location() {
        return peg$computeLocation(peg$savedPos, peg$currPos);
    }
    function expected(description, location1) {
        location1 = location1 !== undefined
            ? location1
            : peg$computeLocation(peg$savedPos, peg$currPos);
        throw peg$buildStructuredError([peg$otherExpectation(description)], input.substring(peg$savedPos, peg$currPos), location1);
    }
    function error(message, location1) {
        location1 = location1 !== undefined
            ? location1
            : peg$computeLocation(peg$savedPos, peg$currPos);
        throw peg$buildSimpleError(message, location1);
    }
    function peg$literalExpectation(text1, ignoreCase) {
        return { type: "literal", text: text1, ignoreCase: ignoreCase };
    }
    function peg$classExpectation(parts, inverted, ignoreCase) {
        return { type: "class", parts: parts, inverted: inverted, ignoreCase: ignoreCase };
    }
    function peg$anyExpectation() {
        return { type: "any" };
    }
    function peg$endExpectation() {
        return { type: "end" };
    }
    function peg$otherExpectation(description) {
        return { type: "other", description: description };
    }
    function peg$computePosDetails(pos) {
        var details = peg$posDetailsCache[pos];
        var p;
        if (details) {
            return details;
        }
        else {
            p = pos - 1;
            while (!peg$posDetailsCache[p]) {
                p--;
            }
            details = peg$posDetailsCache[p];
            details = {
                line: details.line,
                column: details.column
            };
            while (p < pos) {
                if (input.charCodeAt(p) === 10) {
                    details.line++;
                    details.column = 1;
                }
                else {
                    details.column++;
                }
                p++;
            }
            peg$posDetailsCache[pos] = details;
            return details;
        }
    }
    function peg$computeLocation(startPos, endPos) {
        var startPosDetails = peg$computePosDetails(startPos);
        var endPosDetails = peg$computePosDetails(endPos);
        return {
            start: {
                offset: startPos,
                line: startPosDetails.line,
                column: startPosDetails.column
            },
            end: {
                offset: endPos,
                line: endPosDetails.line,
                column: endPosDetails.column
            }
        };
    }
    function peg$fail(expected1) {
        if (peg$currPos < peg$maxFailPos) {
            return;
        }
        if (peg$currPos > peg$maxFailPos) {
            peg$maxFailPos = peg$currPos;
            peg$maxFailExpected = [];
        }
        peg$maxFailExpected.push(expected1);
    }
    function peg$buildSimpleError(message, location1) {
        return new SyntaxError(message, [], "", location1);
    }
    function peg$buildStructuredError(expected1, found, location1) {
        return new SyntaxError(SyntaxError.buildMessage(expected1, found), expected1, found, location1);
    }
    function peg$parseExpression() {
        var s0, s1, s2, s3, s4, s5, s6, s7, s8;
        var key = peg$currPos * 34 + 0;
        var cached = peg$resultsCache[key];
        if (cached) {
            peg$currPos = cached.nextPos;
            return cached.result;
        }
        s0 = peg$currPos;
        s1 = peg$parse_();
        if (s1 !== peg$FAILED) {
            s2 = peg$parseLogicOr();
            if (s2 !== peg$FAILED) {
                s3 = [];
                s4 = peg$currPos;
                s5 = peg$parse_();
                if (s5 !== peg$FAILED) {
                    s6 = peg$parseOrSign();
                    if (s6 !== peg$FAILED) {
                        s7 = peg$parse_();
                        if (s7 !== peg$FAILED) {
                            s8 = peg$parseLogicOr();
                            if (s8 !== peg$FAILED) {
                                s5 = [s5, s6, s7, s8];
                                s4 = s5;
                            }
                            else {
                                peg$currPos = s4;
                                s4 = peg$FAILED;
                            }
                        }
                        else {
                            peg$currPos = s4;
                            s4 = peg$FAILED;
                        }
                    }
                    else {
                        peg$currPos = s4;
                        s4 = peg$FAILED;
                    }
                }
                else {
                    peg$currPos = s4;
                    s4 = peg$FAILED;
                }
                while (s4 !== peg$FAILED) {
                    s3.push(s4);
                    s4 = peg$currPos;
                    s5 = peg$parse_();
                    if (s5 !== peg$FAILED) {
                        s6 = peg$parseOrSign();
                        if (s6 !== peg$FAILED) {
                            s7 = peg$parse_();
                            if (s7 !== peg$FAILED) {
                                s8 = peg$parseLogicOr();
                                if (s8 !== peg$FAILED) {
                                    s5 = [s5, s6, s7, s8];
                                    s4 = s5;
                                }
                                else {
                                    peg$currPos = s4;
                                    s4 = peg$FAILED;
                                }
                            }
                            else {
                                peg$currPos = s4;
                                s4 = peg$FAILED;
                            }
                        }
                        else {
                            peg$currPos = s4;
                            s4 = peg$FAILED;
                        }
                    }
                    else {
                        peg$currPos = s4;
                        s4 = peg$FAILED;
                    }
                }
                if (s3 !== peg$FAILED) {
                    s4 = peg$parse_();
                    if (s4 !== peg$FAILED) {
                        peg$savedPos = s0;
                        s1 = peg$c0(s2, s3);
                        s0 = s1;
                    }
                    else {
                        peg$currPos = s0;
                        s0 = peg$FAILED;
                    }
                }
                else {
                    peg$currPos = s0;
                    s0 = peg$FAILED;
                }
            }
            else {
                peg$currPos = s0;
                s0 = peg$FAILED;
            }
        }
        else {
            peg$currPos = s0;
            s0 = peg$FAILED;
        }
        peg$resultsCache[key] = { nextPos: peg$currPos, result: s0 };
        return s0;
    }
    function peg$parseOrSign() {
        var s0, s1;
        var key = peg$currPos * 34 + 1;
        var cached = peg$resultsCache[key];
        if (cached) {
            peg$currPos = cached.nextPos;
            return cached.result;
        }
        s0 = peg$currPos;
        if (input.substr(peg$currPos, 2) === peg$c1) {
            s1 = peg$c1;
            peg$currPos += 2;
        }
        else {
            s1 = peg$FAILED;
            if (peg$silentFails === 0) {
                peg$fail(peg$c2);
            }
        }
        if (s1 === peg$FAILED) {
            if (input.substr(peg$currPos, 2).toLowerCase() === peg$c3) {
                s1 = input.substr(peg$currPos, 2);
                peg$currPos += 2;
            }
            else {
                s1 = peg$FAILED;
                if (peg$silentFails === 0) {
                    peg$fail(peg$c4);
                }
            }
        }
        if (s1 !== peg$FAILED) {
            peg$savedPos = s0;
            s1 = peg$c5();
        }
        s0 = s1;
        peg$resultsCache[key] = { nextPos: peg$currPos, result: s0 };
        return s0;
    }
    function peg$parseLogicOr() {
        var s0, s1, s2, s3, s4, s5, s6, s7;
        var key = peg$currPos * 34 + 2;
        var cached = peg$resultsCache[key];
        if (cached) {
            peg$currPos = cached.nextPos;
            return cached.result;
        }
        s0 = peg$currPos;
        s1 = peg$parseLogicAnd();
        if (s1 !== peg$FAILED) {
            s2 = [];
            s3 = peg$currPos;
            s4 = peg$parse_();
            if (s4 !== peg$FAILED) {
                s5 = peg$parseAndSign();
                if (s5 !== peg$FAILED) {
                    s6 = peg$parse_();
                    if (s6 !== peg$FAILED) {
                        s7 = peg$parseLogicAnd();
                        if (s7 !== peg$FAILED) {
                            s4 = [s4, s5, s6, s7];
                            s3 = s4;
                        }
                        else {
                            peg$currPos = s3;
                            s3 = peg$FAILED;
                        }
                    }
                    else {
                        peg$currPos = s3;
                        s3 = peg$FAILED;
                    }
                }
                else {
                    peg$currPos = s3;
                    s3 = peg$FAILED;
                }
            }
            else {
                peg$currPos = s3;
                s3 = peg$FAILED;
            }
            while (s3 !== peg$FAILED) {
                s2.push(s3);
                s3 = peg$currPos;
                s4 = peg$parse_();
                if (s4 !== peg$FAILED) {
                    s5 = peg$parseAndSign();
                    if (s5 !== peg$FAILED) {
                        s6 = peg$parse_();
                        if (s6 !== peg$FAILED) {
                            s7 = peg$parseLogicAnd();
                            if (s7 !== peg$FAILED) {
                                s4 = [s4, s5, s6, s7];
                                s3 = s4;
                            }
                            else {
                                peg$currPos = s3;
                                s3 = peg$FAILED;
                            }
                        }
                        else {
                            peg$currPos = s3;
                            s3 = peg$FAILED;
                        }
                    }
                    else {
                        peg$currPos = s3;
                        s3 = peg$FAILED;
                    }
                }
                else {
                    peg$currPos = s3;
                    s3 = peg$FAILED;
                }
            }
            if (s2 !== peg$FAILED) {
                peg$savedPos = s0;
                s1 = peg$c0(s1, s2);
                s0 = s1;
            }
            else {
                peg$currPos = s0;
                s0 = peg$FAILED;
            }
        }
        else {
            peg$currPos = s0;
            s0 = peg$FAILED;
        }
        peg$resultsCache[key] = { nextPos: peg$currPos, result: s0 };
        return s0;
    }
    function peg$parseAndSign() {
        var s0, s1;
        var key = peg$currPos * 34 + 3;
        var cached = peg$resultsCache[key];
        if (cached) {
            peg$currPos = cached.nextPos;
            return cached.result;
        }
        s0 = peg$currPos;
        if (input.substr(peg$currPos, 2) === peg$c6) {
            s1 = peg$c6;
            peg$currPos += 2;
        }
        else {
            s1 = peg$FAILED;
            if (peg$silentFails === 0) {
                peg$fail(peg$c7);
            }
        }
        if (s1 === peg$FAILED) {
            if (input.substr(peg$currPos, 3).toLowerCase() === peg$c8) {
                s1 = input.substr(peg$currPos, 3);
                peg$currPos += 3;
            }
            else {
                s1 = peg$FAILED;
                if (peg$silentFails === 0) {
                    peg$fail(peg$c9);
                }
            }
        }
        if (s1 !== peg$FAILED) {
            peg$savedPos = s0;
            s1 = peg$c10();
        }
        s0 = s1;
        peg$resultsCache[key] = { nextPos: peg$currPos, result: s0 };
        return s0;
    }
    function peg$parseLogicAnd() {
        var s0, s1, s2, s3, s4, s5, s6, s7;
        var key = peg$currPos * 34 + 4;
        var cached = peg$resultsCache[key];
        if (cached) {
            peg$currPos = cached.nextPos;
            return cached.result;
        }
        s0 = peg$currPos;
        s1 = peg$parseCompOps();
        if (s1 !== peg$FAILED) {
            s2 = [];
            s3 = peg$currPos;
            s4 = peg$parse_();
            if (s4 !== peg$FAILED) {
                s5 = peg$parseComparableOperators();
                if (s5 !== peg$FAILED) {
                    s6 = peg$parse_();
                    if (s6 !== peg$FAILED) {
                        s7 = peg$parseCompOps();
                        if (s7 !== peg$FAILED) {
                            s4 = [s4, s5, s6, s7];
                            s3 = s4;
                        }
                        else {
                            peg$currPos = s3;
                            s3 = peg$FAILED;
                        }
                    }
                    else {
                        peg$currPos = s3;
                        s3 = peg$FAILED;
                    }
                }
                else {
                    peg$currPos = s3;
                    s3 = peg$FAILED;
                }
            }
            else {
                peg$currPos = s3;
                s3 = peg$FAILED;
            }
            while (s3 !== peg$FAILED) {
                s2.push(s3);
                s3 = peg$currPos;
                s4 = peg$parse_();
                if (s4 !== peg$FAILED) {
                    s5 = peg$parseComparableOperators();
                    if (s5 !== peg$FAILED) {
                        s6 = peg$parse_();
                        if (s6 !== peg$FAILED) {
                            s7 = peg$parseCompOps();
                            if (s7 !== peg$FAILED) {
                                s4 = [s4, s5, s6, s7];
                                s3 = s4;
                            }
                            else {
                                peg$currPos = s3;
                                s3 = peg$FAILED;
                            }
                        }
                        else {
                            peg$currPos = s3;
                            s3 = peg$FAILED;
                        }
                    }
                    else {
                        peg$currPos = s3;
                        s3 = peg$FAILED;
                    }
                }
                else {
                    peg$currPos = s3;
                    s3 = peg$FAILED;
                }
            }
            if (s2 !== peg$FAILED) {
                peg$savedPos = s0;
                s1 = peg$c11(s1, s2);
                s0 = s1;
            }
            else {
                peg$currPos = s0;
                s0 = peg$FAILED;
            }
        }
        else {
            peg$currPos = s0;
            s0 = peg$FAILED;
        }
        peg$resultsCache[key] = { nextPos: peg$currPos, result: s0 };
        return s0;
    }
    function peg$parseComparableOperators() {
        var s0, s1;
        var key = peg$currPos * 34 + 5;
        var cached = peg$resultsCache[key];
        if (cached) {
            peg$currPos = cached.nextPos;
            return cached.result;
        }
        s0 = peg$currPos;
        if (input.substr(peg$currPos, 2) === peg$c12) {
            s1 = peg$c12;
            peg$currPos += 2;
        }
        else {
            s1 = peg$FAILED;
            if (peg$silentFails === 0) {
                peg$fail(peg$c13);
            }
        }
        if (s1 === peg$FAILED) {
            if (input.substr(peg$currPos, 11).toLowerCase() === peg$c14) {
                s1 = input.substr(peg$currPos, 11);
                peg$currPos += 11;
            }
            else {
                s1 = peg$FAILED;
                if (peg$silentFails === 0) {
                    peg$fail(peg$c15);
                }
            }
        }
        if (s1 !== peg$FAILED) {
            peg$savedPos = s0;
            s1 = peg$c16();
        }
        s0 = s1;
        if (s0 === peg$FAILED) {
            s0 = peg$currPos;
            if (input.substr(peg$currPos, 2) === peg$c17) {
                s1 = peg$c17;
                peg$currPos += 2;
            }
            else {
                s1 = peg$FAILED;
                if (peg$silentFails === 0) {
                    peg$fail(peg$c18);
                }
            }
            if (s1 === peg$FAILED) {
                if (input.substr(peg$currPos, 14).toLowerCase() === peg$c19) {
                    s1 = input.substr(peg$currPos, 14);
                    peg$currPos += 14;
                }
                else {
                    s1 = peg$FAILED;
                    if (peg$silentFails === 0) {
                        peg$fail(peg$c20);
                    }
                }
            }
            if (s1 !== peg$FAILED) {
                peg$savedPos = s0;
                s1 = peg$c21();
            }
            s0 = s1;
            if (s0 === peg$FAILED) {
                s0 = peg$currPos;
                if (input.charCodeAt(peg$currPos) === 61) {
                    s1 = peg$c22;
                    peg$currPos++;
                }
                else {
                    s1 = peg$FAILED;
                    if (peg$silentFails === 0) {
                        peg$fail(peg$c23);
                    }
                }
                if (s1 === peg$FAILED) {
                    if (input.substr(peg$currPos, 5).toLowerCase() === peg$c24) {
                        s1 = input.substr(peg$currPos, 5);
                        peg$currPos += 5;
                    }
                    else {
                        s1 = peg$FAILED;
                        if (peg$silentFails === 0) {
                            peg$fail(peg$c25);
                        }
                    }
                }
                if (s1 !== peg$FAILED) {
                    peg$savedPos = s0;
                    s1 = peg$c26();
                }
                s0 = s1;
                if (s0 === peg$FAILED) {
                    s0 = peg$currPos;
                    if (input.substr(peg$currPos, 2) === peg$c27) {
                        s1 = peg$c27;
                        peg$currPos += 2;
                    }
                    else {
                        s1 = peg$FAILED;
                        if (peg$silentFails === 0) {
                            peg$fail(peg$c28);
                        }
                    }
                    if (s1 === peg$FAILED) {
                        if (input.substr(peg$currPos, 8).toLowerCase() === peg$c29) {
                            s1 = input.substr(peg$currPos, 8);
                            peg$currPos += 8;
                        }
                        else {
                            s1 = peg$FAILED;
                            if (peg$silentFails === 0) {
                                peg$fail(peg$c30);
                            }
                        }
                    }
                    if (s1 !== peg$FAILED) {
                        peg$savedPos = s0;
                        s1 = peg$c31();
                    }
                    s0 = s1;
                    if (s0 === peg$FAILED) {
                        s0 = peg$currPos;
                        if (input.charCodeAt(peg$currPos) === 60) {
                            s1 = peg$c32;
                            peg$currPos++;
                        }
                        else {
                            s1 = peg$FAILED;
                            if (peg$silentFails === 0) {
                                peg$fail(peg$c33);
                            }
                        }
                        if (s1 === peg$FAILED) {
                            if (input.substr(peg$currPos, 4).toLowerCase() === peg$c34) {
                                s1 = input.substr(peg$currPos, 4);
                                peg$currPos += 4;
                            }
                            else {
                                s1 = peg$FAILED;
                                if (peg$silentFails === 0) {
                                    peg$fail(peg$c35);
                                }
                            }
                        }
                        if (s1 !== peg$FAILED) {
                            peg$savedPos = s0;
                            s1 = peg$c36();
                        }
                        s0 = s1;
                        if (s0 === peg$FAILED) {
                            s0 = peg$currPos;
                            if (input.charCodeAt(peg$currPos) === 62) {
                                s1 = peg$c37;
                                peg$currPos++;
                            }
                            else {
                                s1 = peg$FAILED;
                                if (peg$silentFails === 0) {
                                    peg$fail(peg$c38);
                                }
                            }
                            if (s1 === peg$FAILED) {
                                if (input.substr(peg$currPos, 7).toLowerCase() === peg$c39) {
                                    s1 = input.substr(peg$currPos, 7);
                                    peg$currPos += 7;
                                }
                                else {
                                    s1 = peg$FAILED;
                                    if (peg$silentFails === 0) {
                                        peg$fail(peg$c40);
                                    }
                                }
                            }
                            if (s1 !== peg$FAILED) {
                                peg$savedPos = s0;
                                s1 = peg$c41();
                            }
                            s0 = s1;
                        }
                    }
                }
            }
        }
        peg$resultsCache[key] = { nextPos: peg$currPos, result: s0 };
        return s0;
    }
    function peg$parseCompOps() {
        var s0, s1, s2, s3, s4, s5, s6, s7;
        var key = peg$currPos * 34 + 6;
        var cached = peg$resultsCache[key];
        if (cached) {
            peg$currPos = cached.nextPos;
            return cached.result;
        }
        s0 = peg$currPos;
        s1 = peg$parsePlusMinusOps();
        if (s1 !== peg$FAILED) {
            s2 = [];
            s3 = peg$currPos;
            s4 = peg$parse_();
            if (s4 !== peg$FAILED) {
                s5 = peg$parsePlusMinusSigns();
                if (s5 !== peg$FAILED) {
                    s6 = peg$parse_();
                    if (s6 !== peg$FAILED) {
                        s7 = peg$parsePlusMinusOps();
                        if (s7 !== peg$FAILED) {
                            s4 = [s4, s5, s6, s7];
                            s3 = s4;
                        }
                        else {
                            peg$currPos = s3;
                            s3 = peg$FAILED;
                        }
                    }
                    else {
                        peg$currPos = s3;
                        s3 = peg$FAILED;
                    }
                }
                else {
                    peg$currPos = s3;
                    s3 = peg$FAILED;
                }
            }
            else {
                peg$currPos = s3;
                s3 = peg$FAILED;
            }
            while (s3 !== peg$FAILED) {
                s2.push(s3);
                s3 = peg$currPos;
                s4 = peg$parse_();
                if (s4 !== peg$FAILED) {
                    s5 = peg$parsePlusMinusSigns();
                    if (s5 !== peg$FAILED) {
                        s6 = peg$parse_();
                        if (s6 !== peg$FAILED) {
                            s7 = peg$parsePlusMinusOps();
                            if (s7 !== peg$FAILED) {
                                s4 = [s4, s5, s6, s7];
                                s3 = s4;
                            }
                            else {
                                peg$currPos = s3;
                                s3 = peg$FAILED;
                            }
                        }
                        else {
                            peg$currPos = s3;
                            s3 = peg$FAILED;
                        }
                    }
                    else {
                        peg$currPos = s3;
                        s3 = peg$FAILED;
                    }
                }
                else {
                    peg$currPos = s3;
                    s3 = peg$FAILED;
                }
            }
            if (s2 !== peg$FAILED) {
                peg$savedPos = s0;
                s1 = peg$c0(s1, s2);
                s0 = s1;
            }
            else {
                peg$currPos = s0;
                s0 = peg$FAILED;
            }
        }
        else {
            peg$currPos = s0;
            s0 = peg$FAILED;
        }
        peg$resultsCache[key] = { nextPos: peg$currPos, result: s0 };
        return s0;
    }
    function peg$parsePlusMinusSigns() {
        var s0, s1;
        var key = peg$currPos * 34 + 7;
        var cached = peg$resultsCache[key];
        if (cached) {
            peg$currPos = cached.nextPos;
            return cached.result;
        }
        s0 = peg$currPos;
        if (input.charCodeAt(peg$currPos) === 43) {
            s1 = peg$c42;
            peg$currPos++;
        }
        else {
            s1 = peg$FAILED;
            if (peg$silentFails === 0) {
                peg$fail(peg$c43);
            }
        }
        if (s1 !== peg$FAILED) {
            peg$savedPos = s0;
            s1 = peg$c44();
        }
        s0 = s1;
        if (s0 === peg$FAILED) {
            s0 = peg$currPos;
            if (input.charCodeAt(peg$currPos) === 45) {
                s1 = peg$c45;
                peg$currPos++;
            }
            else {
                s1 = peg$FAILED;
                if (peg$silentFails === 0) {
                    peg$fail(peg$c46);
                }
            }
            if (s1 !== peg$FAILED) {
                peg$savedPos = s0;
                s1 = peg$c47();
            }
            s0 = s1;
        }
        peg$resultsCache[key] = { nextPos: peg$currPos, result: s0 };
        return s0;
    }
    function peg$parsePlusMinusOps() {
        var s0, s1, s2, s3, s4, s5, s6, s7;
        var key = peg$currPos * 34 + 8;
        var cached = peg$resultsCache[key];
        if (cached) {
            peg$currPos = cached.nextPos;
            return cached.result;
        }
        s0 = peg$currPos;
        s1 = peg$parseMulDivOps();
        if (s1 !== peg$FAILED) {
            s2 = [];
            s3 = peg$currPos;
            s4 = peg$parse_();
            if (s4 !== peg$FAILED) {
                s5 = peg$parseMulDivSigns();
                if (s5 !== peg$FAILED) {
                    s6 = peg$parse_();
                    if (s6 !== peg$FAILED) {
                        s7 = peg$parseMulDivOps();
                        if (s7 !== peg$FAILED) {
                            s4 = [s4, s5, s6, s7];
                            s3 = s4;
                        }
                        else {
                            peg$currPos = s3;
                            s3 = peg$FAILED;
                        }
                    }
                    else {
                        peg$currPos = s3;
                        s3 = peg$FAILED;
                    }
                }
                else {
                    peg$currPos = s3;
                    s3 = peg$FAILED;
                }
            }
            else {
                peg$currPos = s3;
                s3 = peg$FAILED;
            }
            while (s3 !== peg$FAILED) {
                s2.push(s3);
                s3 = peg$currPos;
                s4 = peg$parse_();
                if (s4 !== peg$FAILED) {
                    s5 = peg$parseMulDivSigns();
                    if (s5 !== peg$FAILED) {
                        s6 = peg$parse_();
                        if (s6 !== peg$FAILED) {
                            s7 = peg$parseMulDivOps();
                            if (s7 !== peg$FAILED) {
                                s4 = [s4, s5, s6, s7];
                                s3 = s4;
                            }
                            else {
                                peg$currPos = s3;
                                s3 = peg$FAILED;
                            }
                        }
                        else {
                            peg$currPos = s3;
                            s3 = peg$FAILED;
                        }
                    }
                    else {
                        peg$currPos = s3;
                        s3 = peg$FAILED;
                    }
                }
                else {
                    peg$currPos = s3;
                    s3 = peg$FAILED;
                }
            }
            if (s2 !== peg$FAILED) {
                peg$savedPos = s0;
                s1 = peg$c0(s1, s2);
                s0 = s1;
            }
            else {
                peg$currPos = s0;
                s0 = peg$FAILED;
            }
        }
        else {
            peg$currPos = s0;
            s0 = peg$FAILED;
        }
        peg$resultsCache[key] = { nextPos: peg$currPos, result: s0 };
        return s0;
    }
    function peg$parseMulDivSigns() {
        var s0, s1;
        var key = peg$currPos * 34 + 9;
        var cached = peg$resultsCache[key];
        if (cached) {
            peg$currPos = cached.nextPos;
            return cached.result;
        }
        s0 = peg$currPos;
        if (input.charCodeAt(peg$currPos) === 42) {
            s1 = peg$c48;
            peg$currPos++;
        }
        else {
            s1 = peg$FAILED;
            if (peg$silentFails === 0) {
                peg$fail(peg$c49);
            }
        }
        if (s1 !== peg$FAILED) {
            peg$savedPos = s0;
            s1 = peg$c50();
        }
        s0 = s1;
        if (s0 === peg$FAILED) {
            s0 = peg$currPos;
            if (input.charCodeAt(peg$currPos) === 47) {
                s1 = peg$c51;
                peg$currPos++;
            }
            else {
                s1 = peg$FAILED;
                if (peg$silentFails === 0) {
                    peg$fail(peg$c52);
                }
            }
            if (s1 !== peg$FAILED) {
                peg$savedPos = s0;
                s1 = peg$c53();
            }
            s0 = s1;
            if (s0 === peg$FAILED) {
                s0 = peg$currPos;
                if (input.charCodeAt(peg$currPos) === 37) {
                    s1 = peg$c54;
                    peg$currPos++;
                }
                else {
                    s1 = peg$FAILED;
                    if (peg$silentFails === 0) {
                        peg$fail(peg$c55);
                    }
                }
                if (s1 !== peg$FAILED) {
                    peg$savedPos = s0;
                    s1 = peg$c56();
                }
                s0 = s1;
            }
        }
        peg$resultsCache[key] = { nextPos: peg$currPos, result: s0 };
        return s0;
    }
    function peg$parseMulDivOps() {
        var s0, s1, s2, s3, s4, s5, s6, s7;
        var key = peg$currPos * 34 + 10;
        var cached = peg$resultsCache[key];
        if (cached) {
            peg$currPos = cached.nextPos;
            return cached.result;
        }
        s0 = peg$currPos;
        s1 = peg$parseBinaryFuncOp();
        if (s1 !== peg$FAILED) {
            s2 = [];
            s3 = peg$currPos;
            s4 = peg$parse_();
            if (s4 !== peg$FAILED) {
                s5 = peg$parsePowerSigns();
                if (s5 !== peg$FAILED) {
                    s6 = peg$parse_();
                    if (s6 !== peg$FAILED) {
                        s7 = peg$parseBinaryFuncOp();
                        if (s7 !== peg$FAILED) {
                            s4 = [s4, s5, s6, s7];
                            s3 = s4;
                        }
                        else {
                            peg$currPos = s3;
                            s3 = peg$FAILED;
                        }
                    }
                    else {
                        peg$currPos = s3;
                        s3 = peg$FAILED;
                    }
                }
                else {
                    peg$currPos = s3;
                    s3 = peg$FAILED;
                }
            }
            else {
                peg$currPos = s3;
                s3 = peg$FAILED;
            }
            while (s3 !== peg$FAILED) {
                s2.push(s3);
                s3 = peg$currPos;
                s4 = peg$parse_();
                if (s4 !== peg$FAILED) {
                    s5 = peg$parsePowerSigns();
                    if (s5 !== peg$FAILED) {
                        s6 = peg$parse_();
                        if (s6 !== peg$FAILED) {
                            s7 = peg$parseBinaryFuncOp();
                            if (s7 !== peg$FAILED) {
                                s4 = [s4, s5, s6, s7];
                                s3 = s4;
                            }
                            else {
                                peg$currPos = s3;
                                s3 = peg$FAILED;
                            }
                        }
                        else {
                            peg$currPos = s3;
                            s3 = peg$FAILED;
                        }
                    }
                    else {
                        peg$currPos = s3;
                        s3 = peg$FAILED;
                    }
                }
                else {
                    peg$currPos = s3;
                    s3 = peg$FAILED;
                }
            }
            if (s2 !== peg$FAILED) {
                peg$savedPos = s0;
                s1 = peg$c0(s1, s2);
                s0 = s1;
            }
            else {
                peg$currPos = s0;
                s0 = peg$FAILED;
            }
        }
        else {
            peg$currPos = s0;
            s0 = peg$FAILED;
        }
        peg$resultsCache[key] = { nextPos: peg$currPos, result: s0 };
        return s0;
    }
    function peg$parsePowerSigns() {
        var s0, s1;
        var key = peg$currPos * 34 + 11;
        var cached = peg$resultsCache[key];
        if (cached) {
            peg$currPos = cached.nextPos;
            return cached.result;
        }
        s0 = peg$currPos;
        if (input.charCodeAt(peg$currPos) === 94) {
            s1 = peg$c57;
            peg$currPos++;
        }
        else {
            s1 = peg$FAILED;
            if (peg$silentFails === 0) {
                peg$fail(peg$c58);
            }
        }
        if (s1 === peg$FAILED) {
            if (input.substr(peg$currPos, 5).toLowerCase() === peg$c59) {
                s1 = input.substr(peg$currPos, 5);
                peg$currPos += 5;
            }
            else {
                s1 = peg$FAILED;
                if (peg$silentFails === 0) {
                    peg$fail(peg$c60);
                }
            }
        }
        if (s1 !== peg$FAILED) {
            peg$savedPos = s0;
            s1 = peg$c61();
        }
        s0 = s1;
        peg$resultsCache[key] = { nextPos: peg$currPos, result: s0 };
        return s0;
    }
    function peg$parseBinaryFuncOp() {
        var s0, s1, s2, s3, s4, s5, s6, s7;
        var key = peg$currPos * 34 + 12;
        var cached = peg$resultsCache[key];
        if (cached) {
            peg$currPos = cached.nextPos;
            return cached.result;
        }
        s0 = peg$currPos;
        s1 = peg$parseFactor();
        if (s1 !== peg$FAILED) {
            s2 = [];
            s3 = peg$currPos;
            s4 = peg$parse_();
            if (s4 !== peg$FAILED) {
                s5 = peg$parseBinFunctions();
                if (s5 !== peg$FAILED) {
                    s6 = peg$parse_();
                    if (s6 !== peg$FAILED) {
                        s7 = peg$parseFactor();
                        if (s7 === peg$FAILED) {
                            s7 = null;
                        }
                        if (s7 !== peg$FAILED) {
                            s4 = [s4, s5, s6, s7];
                            s3 = s4;
                        }
                        else {
                            peg$currPos = s3;
                            s3 = peg$FAILED;
                        }
                    }
                    else {
                        peg$currPos = s3;
                        s3 = peg$FAILED;
                    }
                }
                else {
                    peg$currPos = s3;
                    s3 = peg$FAILED;
                }
            }
            else {
                peg$currPos = s3;
                s3 = peg$FAILED;
            }
            while (s3 !== peg$FAILED) {
                s2.push(s3);
                s3 = peg$currPos;
                s4 = peg$parse_();
                if (s4 !== peg$FAILED) {
                    s5 = peg$parseBinFunctions();
                    if (s5 !== peg$FAILED) {
                        s6 = peg$parse_();
                        if (s6 !== peg$FAILED) {
                            s7 = peg$parseFactor();
                            if (s7 === peg$FAILED) {
                                s7 = null;
                            }
                            if (s7 !== peg$FAILED) {
                                s4 = [s4, s5, s6, s7];
                                s3 = s4;
                            }
                            else {
                                peg$currPos = s3;
                                s3 = peg$FAILED;
                            }
                        }
                        else {
                            peg$currPos = s3;
                            s3 = peg$FAILED;
                        }
                    }
                    else {
                        peg$currPos = s3;
                        s3 = peg$FAILED;
                    }
                }
                else {
                    peg$currPos = s3;
                    s3 = peg$FAILED;
                }
            }
            if (s2 !== peg$FAILED) {
                peg$savedPos = s0;
                s1 = peg$c11(s1, s2);
                s0 = s1;
            }
            else {
                peg$currPos = s0;
                s0 = peg$FAILED;
            }
        }
        else {
            peg$currPos = s0;
            s0 = peg$FAILED;
        }
        peg$resultsCache[key] = { nextPos: peg$currPos, result: s0 };
        return s0;
    }
    function peg$parseBinFunctions() {
        var s0, s1;
        var key = peg$currPos * 34 + 13;
        var cached = peg$resultsCache[key];
        if (cached) {
            peg$currPos = cached.nextPos;
            return cached.result;
        }
        s0 = peg$currPos;
        if (input.substr(peg$currPos, 2) === peg$c62) {
            s1 = peg$c62;
            peg$currPos += 2;
        }
        else {
            s1 = peg$FAILED;
            if (peg$silentFails === 0) {
                peg$fail(peg$c63);
            }
        }
        if (s1 === peg$FAILED) {
            if (input.substr(peg$currPos, 8).toLowerCase() === peg$c64) {
                s1 = input.substr(peg$currPos, 8);
                peg$currPos += 8;
            }
            else {
                s1 = peg$FAILED;
                if (peg$silentFails === 0) {
                    peg$fail(peg$c65);
                }
            }
            if (s1 === peg$FAILED) {
                if (input.substr(peg$currPos, 7).toLowerCase() === peg$c66) {
                    s1 = input.substr(peg$currPos, 7);
                    peg$currPos += 7;
                }
                else {
                    s1 = peg$FAILED;
                    if (peg$silentFails === 0) {
                        peg$fail(peg$c67);
                    }
                }
            }
        }
        if (s1 !== peg$FAILED) {
            peg$savedPos = s0;
            s1 = peg$c68();
        }
        s0 = s1;
        if (s0 === peg$FAILED) {
            s0 = peg$currPos;
            if (input.substr(peg$currPos, 11).toLowerCase() === peg$c69) {
                s1 = input.substr(peg$currPos, 11);
                peg$currPos += 11;
            }
            else {
                s1 = peg$FAILED;
                if (peg$silentFails === 0) {
                    peg$fail(peg$c70);
                }
            }
            if (s1 === peg$FAILED) {
                if (input.substr(peg$currPos, 10).toLowerCase() === peg$c71) {
                    s1 = input.substr(peg$currPos, 10);
                    peg$currPos += 10;
                }
                else {
                    s1 = peg$FAILED;
                    if (peg$silentFails === 0) {
                        peg$fail(peg$c72);
                    }
                }
            }
            if (s1 !== peg$FAILED) {
                peg$savedPos = s0;
                s1 = peg$c73();
            }
            s0 = s1;
            if (s0 === peg$FAILED) {
                s0 = peg$currPos;
                if (input.substr(peg$currPos, 5).toLowerCase() === peg$c74) {
                    s1 = input.substr(peg$currPos, 5);
                    peg$currPos += 5;
                }
                else {
                    s1 = peg$FAILED;
                    if (peg$silentFails === 0) {
                        peg$fail(peg$c75);
                    }
                }
                if (s1 !== peg$FAILED) {
                    peg$savedPos = s0;
                    s1 = peg$c76();
                }
                s0 = s1;
                if (s0 === peg$FAILED) {
                    s0 = peg$currPos;
                    if (input.substr(peg$currPos, 5).toLowerCase() === peg$c77) {
                        s1 = input.substr(peg$currPos, 5);
                        peg$currPos += 5;
                    }
                    else {
                        s1 = peg$FAILED;
                        if (peg$silentFails === 0) {
                            peg$fail(peg$c78);
                        }
                    }
                    if (s1 !== peg$FAILED) {
                        peg$savedPos = s0;
                        s1 = peg$c79();
                    }
                    s0 = s1;
                }
            }
        }
        peg$resultsCache[key] = { nextPos: peg$currPos, result: s0 };
        return s0;
    }
    function peg$parseFactor() {
        var s0, s1, s2, s3, s4, s5;
        var key = peg$currPos * 34 + 14;
        var cached = peg$resultsCache[key];
        if (cached) {
            peg$currPos = cached.nextPos;
            return cached.result;
        }
        s0 = peg$currPos;
        if (input.charCodeAt(peg$currPos) === 40) {
            s1 = peg$c80;
            peg$currPos++;
        }
        else {
            s1 = peg$FAILED;
            if (peg$silentFails === 0) {
                peg$fail(peg$c81);
            }
        }
        if (s1 !== peg$FAILED) {
            s2 = peg$parse_();
            if (s2 !== peg$FAILED) {
                s3 = peg$parseExpression();
                if (s3 !== peg$FAILED) {
                    s4 = peg$parse_();
                    if (s4 !== peg$FAILED) {
                        if (input.charCodeAt(peg$currPos) === 41) {
                            s5 = peg$c82;
                            peg$currPos++;
                        }
                        else {
                            s5 = peg$FAILED;
                            if (peg$silentFails === 0) {
                                peg$fail(peg$c83);
                            }
                        }
                        if (s5 === peg$FAILED) {
                            s5 = null;
                        }
                        if (s5 !== peg$FAILED) {
                            peg$savedPos = s0;
                            s1 = peg$c84(s3);
                            s0 = s1;
                        }
                        else {
                            peg$currPos = s0;
                            s0 = peg$FAILED;
                        }
                    }
                    else {
                        peg$currPos = s0;
                        s0 = peg$FAILED;
                    }
                }
                else {
                    peg$currPos = s0;
                    s0 = peg$FAILED;
                }
            }
            else {
                peg$currPos = s0;
                s0 = peg$FAILED;
            }
        }
        else {
            peg$currPos = s0;
            s0 = peg$FAILED;
        }
        if (s0 === peg$FAILED) {
            s0 = peg$parseFunctionOp();
            if (s0 === peg$FAILED) {
                s0 = peg$parseUnaryFunctionOp();
                if (s0 === peg$FAILED) {
                    s0 = peg$parseAtom();
                    if (s0 === peg$FAILED) {
                        s0 = peg$parseArrayOp();
                    }
                }
            }
        }
        peg$resultsCache[key] = { nextPos: peg$currPos, result: s0 };
        return s0;
    }
    function peg$parseFunctionOp() {
        var s0, s1, s2, s3, s4;
        var key = peg$currPos * 34 + 15;
        var cached = peg$resultsCache[key];
        if (cached) {
            peg$currPos = cached.nextPos;
            return cached.result;
        }
        s0 = peg$currPos;
        s1 = peg$parseLettersAndDigits();
        if (s1 !== peg$FAILED) {
            if (input.charCodeAt(peg$currPos) === 40) {
                s2 = peg$c80;
                peg$currPos++;
            }
            else {
                s2 = peg$FAILED;
                if (peg$silentFails === 0) {
                    peg$fail(peg$c81);
                }
            }
            if (s2 !== peg$FAILED) {
                s3 = peg$parseSequence();
                if (s3 !== peg$FAILED) {
                    if (input.charCodeAt(peg$currPos) === 41) {
                        s4 = peg$c82;
                        peg$currPos++;
                    }
                    else {
                        s4 = peg$FAILED;
                        if (peg$silentFails === 0) {
                            peg$fail(peg$c83);
                        }
                    }
                    if (s4 === peg$FAILED) {
                        s4 = null;
                    }
                    if (s4 !== peg$FAILED) {
                        peg$savedPos = s0;
                        s1 = peg$c85(s1, s3);
                        s0 = s1;
                    }
                    else {
                        peg$currPos = s0;
                        s0 = peg$FAILED;
                    }
                }
                else {
                    peg$currPos = s0;
                    s0 = peg$FAILED;
                }
            }
            else {
                peg$currPos = s0;
                s0 = peg$FAILED;
            }
        }
        else {
            peg$currPos = s0;
            s0 = peg$FAILED;
        }
        peg$resultsCache[key] = { nextPos: peg$currPos, result: s0 };
        return s0;
    }
    function peg$parseUnaryFunctionOp() {
        var s0, s1, s2, s3;
        var key = peg$currPos * 34 + 16;
        var cached = peg$resultsCache[key];
        if (cached) {
            peg$currPos = cached.nextPos;
            return cached.result;
        }
        s0 = peg$currPos;
        if (input.charCodeAt(peg$currPos) === 33) {
            s1 = peg$c86;
            peg$currPos++;
        }
        else {
            s1 = peg$FAILED;
            if (peg$silentFails === 0) {
                peg$fail(peg$c87);
            }
        }
        if (s1 === peg$FAILED) {
            if (input.substr(peg$currPos, 6).toLowerCase() === peg$c88) {
                s1 = input.substr(peg$currPos, 6);
                peg$currPos += 6;
            }
            else {
                s1 = peg$FAILED;
                if (peg$silentFails === 0) {
                    peg$fail(peg$c89);
                }
            }
        }
        if (s1 !== peg$FAILED) {
            s2 = peg$parse_();
            if (s2 !== peg$FAILED) {
                s3 = peg$parseExpression();
                if (s3 !== peg$FAILED) {
                    peg$savedPos = s0;
                    s1 = peg$c90(s3);
                    s0 = s1;
                }
                else {
                    peg$currPos = s0;
                    s0 = peg$FAILED;
                }
            }
            else {
                peg$currPos = s0;
                s0 = peg$FAILED;
            }
        }
        else {
            peg$currPos = s0;
            s0 = peg$FAILED;
        }
        if (s0 === peg$FAILED) {
            s0 = peg$currPos;
            s1 = peg$parseAtom();
            if (s1 !== peg$FAILED) {
                s2 = peg$parse_();
                if (s2 !== peg$FAILED) {
                    s3 = peg$parseUnFunctions();
                    if (s3 !== peg$FAILED) {
                        peg$savedPos = s0;
                        s1 = peg$c91(s1, s3);
                        s0 = s1;
                    }
                    else {
                        peg$currPos = s0;
                        s0 = peg$FAILED;
                    }
                }
                else {
                    peg$currPos = s0;
                    s0 = peg$FAILED;
                }
            }
            else {
                peg$currPos = s0;
                s0 = peg$FAILED;
            }
        }
        peg$resultsCache[key] = { nextPos: peg$currPos, result: s0 };
        return s0;
    }
    function peg$parseUnFunctions() {
        var s0, s1;
        var key = peg$currPos * 34 + 17;
        var cached = peg$resultsCache[key];
        if (cached) {
            peg$currPos = cached.nextPos;
            return cached.result;
        }
        s0 = peg$currPos;
        if (input.substr(peg$currPos, 5).toLowerCase() === peg$c92) {
            s1 = input.substr(peg$currPos, 5);
            peg$currPos += 5;
        }
        else {
            s1 = peg$FAILED;
            if (peg$silentFails === 0) {
                peg$fail(peg$c93);
            }
        }
        if (s1 !== peg$FAILED) {
            peg$savedPos = s0;
            s1 = peg$c94();
        }
        s0 = s1;
        if (s0 === peg$FAILED) {
            s0 = peg$currPos;
            if (input.substr(peg$currPos, 8).toLowerCase() === peg$c95) {
                s1 = input.substr(peg$currPos, 8);
                peg$currPos += 8;
            }
            else {
                s1 = peg$FAILED;
                if (peg$silentFails === 0) {
                    peg$fail(peg$c96);
                }
            }
            if (s1 !== peg$FAILED) {
                peg$savedPos = s0;
                s1 = peg$c97();
            }
            s0 = s1;
        }
        peg$resultsCache[key] = { nextPos: peg$currPos, result: s0 };
        return s0;
    }
    function peg$parseAtom() {
        var s0, s1, s2, s3, s4;
        var key = peg$currPos * 34 + 18;
        var cached = peg$resultsCache[key];
        if (cached) {
            peg$currPos = cached.nextPos;
            return cached.result;
        }
        s0 = peg$currPos;
        s1 = peg$parse_();
        if (s1 !== peg$FAILED) {
            if (input.substr(peg$currPos, 9) === peg$c98) {
                s2 = peg$c98;
                peg$currPos += 9;
            }
            else {
                s2 = peg$FAILED;
                if (peg$silentFails === 0) {
                    peg$fail(peg$c99);
                }
            }
            if (s2 === peg$FAILED) {
                if (input.substr(peg$currPos, 4) === peg$c100) {
                    s2 = peg$c100;
                    peg$currPos += 4;
                }
                else {
                    s2 = peg$FAILED;
                    if (peg$silentFails === 0) {
                        peg$fail(peg$c101);
                    }
                }
            }
            if (s2 !== peg$FAILED) {
                peg$savedPos = s0;
                s1 = peg$c102();
                s0 = s1;
            }
            else {
                peg$currPos = s0;
                s0 = peg$FAILED;
            }
        }
        else {
            peg$currPos = s0;
            s0 = peg$FAILED;
        }
        if (s0 === peg$FAILED) {
            s0 = peg$currPos;
            s1 = peg$parse_();
            if (s1 !== peg$FAILED) {
                s2 = peg$parseConstValue();
                if (s2 !== peg$FAILED) {
                    peg$savedPos = s0;
                    s1 = peg$c103(s2);
                    s0 = s1;
                }
                else {
                    peg$currPos = s0;
                    s0 = peg$FAILED;
                }
            }
            else {
                peg$currPos = s0;
                s0 = peg$FAILED;
            }
            if (s0 === peg$FAILED) {
                s0 = peg$currPos;
                s1 = peg$parse_();
                if (s1 !== peg$FAILED) {
                    if (input.charCodeAt(peg$currPos) === 123) {
                        s2 = peg$c104;
                        peg$currPos++;
                    }
                    else {
                        s2 = peg$FAILED;
                        if (peg$silentFails === 0) {
                            peg$fail(peg$c105);
                        }
                    }
                    if (s2 !== peg$FAILED) {
                        s3 = peg$parseValueInput();
                        if (s3 !== peg$FAILED) {
                            if (input.charCodeAt(peg$currPos) === 125) {
                                s4 = peg$c106;
                                peg$currPos++;
                            }
                            else {
                                s4 = peg$FAILED;
                                if (peg$silentFails === 0) {
                                    peg$fail(peg$c107);
                                }
                            }
                            if (s4 !== peg$FAILED) {
                                peg$savedPos = s0;
                                s1 = peg$c108(s3);
                                s0 = s1;
                            }
                            else {
                                peg$currPos = s0;
                                s0 = peg$FAILED;
                            }
                        }
                        else {
                            peg$currPos = s0;
                            s0 = peg$FAILED;
                        }
                    }
                    else {
                        peg$currPos = s0;
                        s0 = peg$FAILED;
                    }
                }
                else {
                    peg$currPos = s0;
                    s0 = peg$FAILED;
                }
            }
        }
        peg$resultsCache[key] = { nextPos: peg$currPos, result: s0 };
        return s0;
    }
    function peg$parseConstValue() {
        var s0, s1, s2, s3;
        var key = peg$currPos * 34 + 19;
        var cached = peg$resultsCache[key];
        if (cached) {
            peg$currPos = cached.nextPos;
            return cached.result;
        }
        s0 = peg$currPos;
        s1 = peg$parseLogicValue();
        if (s1 !== peg$FAILED) {
            peg$savedPos = s0;
            s1 = peg$c109(s1);
        }
        s0 = s1;
        if (s0 === peg$FAILED) {
            s0 = peg$currPos;
            s1 = peg$parseArithmeticValue();
            if (s1 !== peg$FAILED) {
                peg$savedPos = s0;
                s1 = peg$c109(s1);
            }
            s0 = s1;
            if (s0 === peg$FAILED) {
                s0 = peg$currPos;
                s1 = peg$parseLettersAndDigits();
                if (s1 !== peg$FAILED) {
                    peg$savedPos = s0;
                    s1 = peg$c109(s1);
                }
                s0 = s1;
                if (s0 === peg$FAILED) {
                    s0 = peg$currPos;
                    if (input.substr(peg$currPos, 2) === peg$c110) {
                        s1 = peg$c110;
                        peg$currPos += 2;
                    }
                    else {
                        s1 = peg$FAILED;
                        if (peg$silentFails === 0) {
                            peg$fail(peg$c111);
                        }
                    }
                    if (s1 !== peg$FAILED) {
                        peg$savedPos = s0;
                        s1 = peg$c112();
                    }
                    s0 = s1;
                    if (s0 === peg$FAILED) {
                        s0 = peg$currPos;
                        if (input.substr(peg$currPos, 2) === peg$c113) {
                            s1 = peg$c113;
                            peg$currPos += 2;
                        }
                        else {
                            s1 = peg$FAILED;
                            if (peg$silentFails === 0) {
                                peg$fail(peg$c114);
                            }
                        }
                        if (s1 !== peg$FAILED) {
                            peg$savedPos = s0;
                            s1 = peg$c112();
                        }
                        s0 = s1;
                        if (s0 === peg$FAILED) {
                            s0 = peg$currPos;
                            if (input.charCodeAt(peg$currPos) === 39) {
                                s1 = peg$c115;
                                peg$currPos++;
                            }
                            else {
                                s1 = peg$FAILED;
                                if (peg$silentFails === 0) {
                                    peg$fail(peg$c116);
                                }
                            }
                            if (s1 !== peg$FAILED) {
                                s2 = peg$parseAnyInput();
                                if (s2 !== peg$FAILED) {
                                    if (input.charCodeAt(peg$currPos) === 39) {
                                        s3 = peg$c115;
                                        peg$currPos++;
                                    }
                                    else {
                                        s3 = peg$FAILED;
                                        if (peg$silentFails === 0) {
                                            peg$fail(peg$c116);
                                        }
                                    }
                                    if (s3 !== peg$FAILED) {
                                        peg$savedPos = s0;
                                        s1 = peg$c117(s2);
                                        s0 = s1;
                                    }
                                    else {
                                        peg$currPos = s0;
                                        s0 = peg$FAILED;
                                    }
                                }
                                else {
                                    peg$currPos = s0;
                                    s0 = peg$FAILED;
                                }
                            }
                            else {
                                peg$currPos = s0;
                                s0 = peg$FAILED;
                            }
                            if (s0 === peg$FAILED) {
                                s0 = peg$currPos;
                                if (input.charCodeAt(peg$currPos) === 34) {
                                    s1 = peg$c118;
                                    peg$currPos++;
                                }
                                else {
                                    s1 = peg$FAILED;
                                    if (peg$silentFails === 0) {
                                        peg$fail(peg$c119);
                                    }
                                }
                                if (s1 !== peg$FAILED) {
                                    s2 = peg$parseAnyInput();
                                    if (s2 !== peg$FAILED) {
                                        if (input.charCodeAt(peg$currPos) === 34) {
                                            s3 = peg$c118;
                                            peg$currPos++;
                                        }
                                        else {
                                            s3 = peg$FAILED;
                                            if (peg$silentFails === 0) {
                                                peg$fail(peg$c119);
                                            }
                                        }
                                        if (s3 !== peg$FAILED) {
                                            peg$savedPos = s0;
                                            s1 = peg$c117(s2);
                                            s0 = s1;
                                        }
                                        else {
                                            peg$currPos = s0;
                                            s0 = peg$FAILED;
                                        }
                                    }
                                    else {
                                        peg$currPos = s0;
                                        s0 = peg$FAILED;
                                    }
                                }
                                else {
                                    peg$currPos = s0;
                                    s0 = peg$FAILED;
                                }
                            }
                        }
                    }
                }
            }
        }
        peg$resultsCache[key] = { nextPos: peg$currPos, result: s0 };
        return s0;
    }
    function peg$parseArrayOp() {
        var s0, s1, s2, s3;
        var key = peg$currPos * 34 + 20;
        var cached = peg$resultsCache[key];
        if (cached) {
            peg$currPos = cached.nextPos;
            return cached.result;
        }
        s0 = peg$currPos;
        if (input.charCodeAt(peg$currPos) === 91) {
            s1 = peg$c120;
            peg$currPos++;
        }
        else {
            s1 = peg$FAILED;
            if (peg$silentFails === 0) {
                peg$fail(peg$c121);
            }
        }
        if (s1 !== peg$FAILED) {
            s2 = peg$parseSequence();
            if (s2 !== peg$FAILED) {
                if (input.charCodeAt(peg$currPos) === 93) {
                    s3 = peg$c122;
                    peg$currPos++;
                }
                else {
                    s3 = peg$FAILED;
                    if (peg$silentFails === 0) {
                        peg$fail(peg$c123);
                    }
                }
                if (s3 !== peg$FAILED) {
                    peg$savedPos = s0;
                    s1 = peg$c124(s2);
                    s0 = s1;
                }
                else {
                    peg$currPos = s0;
                    s0 = peg$FAILED;
                }
            }
            else {
                peg$currPos = s0;
                s0 = peg$FAILED;
            }
        }
        else {
            peg$currPos = s0;
            s0 = peg$FAILED;
        }
        peg$resultsCache[key] = { nextPos: peg$currPos, result: s0 };
        return s0;
    }
    function peg$parseSequence() {
        var s0, s1, s2, s3, s4, s5, s6, s7;
        var key = peg$currPos * 34 + 21;
        var cached = peg$resultsCache[key];
        if (cached) {
            peg$currPos = cached.nextPos;
            return cached.result;
        }
        s0 = peg$currPos;
        s1 = peg$parseExpression();
        if (s1 === peg$FAILED) {
            s1 = null;
        }
        if (s1 !== peg$FAILED) {
            s2 = [];
            s3 = peg$currPos;
            s4 = peg$parse_();
            if (s4 !== peg$FAILED) {
                if (input.charCodeAt(peg$currPos) === 44) {
                    s5 = peg$c125;
                    peg$currPos++;
                }
                else {
                    s5 = peg$FAILED;
                    if (peg$silentFails === 0) {
                        peg$fail(peg$c126);
                    }
                }
                if (s5 !== peg$FAILED) {
                    s6 = peg$parse_();
                    if (s6 !== peg$FAILED) {
                        s7 = peg$parseExpression();
                        if (s7 !== peg$FAILED) {
                            s4 = [s4, s5, s6, s7];
                            s3 = s4;
                        }
                        else {
                            peg$currPos = s3;
                            s3 = peg$FAILED;
                        }
                    }
                    else {
                        peg$currPos = s3;
                        s3 = peg$FAILED;
                    }
                }
                else {
                    peg$currPos = s3;
                    s3 = peg$FAILED;
                }
            }
            else {
                peg$currPos = s3;
                s3 = peg$FAILED;
            }
            while (s3 !== peg$FAILED) {
                s2.push(s3);
                s3 = peg$currPos;
                s4 = peg$parse_();
                if (s4 !== peg$FAILED) {
                    if (input.charCodeAt(peg$currPos) === 44) {
                        s5 = peg$c125;
                        peg$currPos++;
                    }
                    else {
                        s5 = peg$FAILED;
                        if (peg$silentFails === 0) {
                            peg$fail(peg$c126);
                        }
                    }
                    if (s5 !== peg$FAILED) {
                        s6 = peg$parse_();
                        if (s6 !== peg$FAILED) {
                            s7 = peg$parseExpression();
                            if (s7 !== peg$FAILED) {
                                s4 = [s4, s5, s6, s7];
                                s3 = s4;
                            }
                            else {
                                peg$currPos = s3;
                                s3 = peg$FAILED;
                            }
                        }
                        else {
                            peg$currPos = s3;
                            s3 = peg$FAILED;
                        }
                    }
                    else {
                        peg$currPos = s3;
                        s3 = peg$FAILED;
                    }
                }
                else {
                    peg$currPos = s3;
                    s3 = peg$FAILED;
                }
            }
            if (s2 !== peg$FAILED) {
                peg$savedPos = s0;
                s1 = peg$c127(s1, s2);
                s0 = s1;
            }
            else {
                peg$currPos = s0;
                s0 = peg$FAILED;
            }
        }
        else {
            peg$currPos = s0;
            s0 = peg$FAILED;
        }
        peg$resultsCache[key] = { nextPos: peg$currPos, result: s0 };
        return s0;
    }
    function peg$parseLogicValue() {
        var s0, s1;
        var key = peg$currPos * 34 + 22;
        var cached = peg$resultsCache[key];
        if (cached) {
            peg$currPos = cached.nextPos;
            return cached.result;
        }
        s0 = peg$currPos;
        if (input.substr(peg$currPos, 4).toLowerCase() === peg$c128) {
            s1 = input.substr(peg$currPos, 4);
            peg$currPos += 4;
        }
        else {
            s1 = peg$FAILED;
            if (peg$silentFails === 0) {
                peg$fail(peg$c129);
            }
        }
        if (s1 !== peg$FAILED) {
            peg$savedPos = s0;
            s1 = peg$c130();
        }
        s0 = s1;
        if (s0 === peg$FAILED) {
            s0 = peg$currPos;
            if (input.substr(peg$currPos, 5).toLowerCase() === peg$c131) {
                s1 = input.substr(peg$currPos, 5);
                peg$currPos += 5;
            }
            else {
                s1 = peg$FAILED;
                if (peg$silentFails === 0) {
                    peg$fail(peg$c132);
                }
            }
            if (s1 !== peg$FAILED) {
                peg$savedPos = s0;
                s1 = peg$c133();
            }
            s0 = s1;
        }
        peg$resultsCache[key] = { nextPos: peg$currPos, result: s0 };
        return s0;
    }
    function peg$parseArithmeticValue() {
        var s0, s1, s2;
        var key = peg$currPos * 34 + 23;
        var cached = peg$resultsCache[key];
        if (cached) {
            peg$currPos = cached.nextPos;
            return cached.result;
        }
        s0 = peg$currPos;
        if (input.substr(peg$currPos, 2) === peg$c134) {
            s1 = peg$c134;
            peg$currPos += 2;
        }
        else {
            s1 = peg$FAILED;
            if (peg$silentFails === 0) {
                peg$fail(peg$c135);
            }
        }
        if (s1 !== peg$FAILED) {
            s2 = peg$parseDigits();
            if (s2 !== peg$FAILED) {
                peg$savedPos = s0;
                s1 = peg$c136();
                s0 = s1;
            }
            else {
                peg$currPos = s0;
                s0 = peg$FAILED;
            }
        }
        else {
            peg$currPos = s0;
            s0 = peg$FAILED;
        }
        if (s0 === peg$FAILED) {
            s0 = peg$currPos;
            if (peg$c137.test(input.charAt(peg$currPos))) {
                s1 = input.charAt(peg$currPos);
                peg$currPos++;
            }
            else {
                s1 = peg$FAILED;
                if (peg$silentFails === 0) {
                    peg$fail(peg$c138);
                }
            }
            if (s1 === peg$FAILED) {
                s1 = null;
            }
            if (s1 !== peg$FAILED) {
                s2 = peg$parseNumber();
                if (s2 !== peg$FAILED) {
                    peg$savedPos = s0;
                    s1 = peg$c139(s1, s2);
                    s0 = s1;
                }
                else {
                    peg$currPos = s0;
                    s0 = peg$FAILED;
                }
            }
            else {
                peg$currPos = s0;
                s0 = peg$FAILED;
            }
        }
        peg$resultsCache[key] = { nextPos: peg$currPos, result: s0 };
        return s0;
    }
    function peg$parseNumber() {
        var s0, s1, s2, s3;
        var key = peg$currPos * 34 + 24;
        var cached = peg$resultsCache[key];
        if (cached) {
            peg$currPos = cached.nextPos;
            return cached.result;
        }
        s0 = peg$currPos;
        s1 = peg$parseDigits();
        if (s1 !== peg$FAILED) {
            if (input.charCodeAt(peg$currPos) === 46) {
                s2 = peg$c140;
                peg$currPos++;
            }
            else {
                s2 = peg$FAILED;
                if (peg$silentFails === 0) {
                    peg$fail(peg$c141);
                }
            }
            if (s2 !== peg$FAILED) {
                s3 = peg$parseDigits();
                if (s3 !== peg$FAILED) {
                    peg$savedPos = s0;
                    s1 = peg$c142();
                    s0 = s1;
                }
                else {
                    peg$currPos = s0;
                    s0 = peg$FAILED;
                }
            }
            else {
                peg$currPos = s0;
                s0 = peg$FAILED;
            }
        }
        else {
            peg$currPos = s0;
            s0 = peg$FAILED;
        }
        if (s0 === peg$FAILED) {
            s0 = peg$currPos;
            s1 = peg$parseNonZeroDigits();
            if (s1 !== peg$FAILED) {
                s2 = peg$parseDigits();
                if (s2 === peg$FAILED) {
                    s2 = null;
                }
                if (s2 !== peg$FAILED) {
                    peg$savedPos = s0;
                    s1 = peg$c143();
                    s0 = s1;
                }
                else {
                    peg$currPos = s0;
                    s0 = peg$FAILED;
                }
            }
            else {
                peg$currPos = s0;
                s0 = peg$FAILED;
            }
            if (s0 === peg$FAILED) {
                s0 = peg$currPos;
                if (input.charCodeAt(peg$currPos) === 48) {
                    s1 = peg$c144;
                    peg$currPos++;
                }
                else {
                    s1 = peg$FAILED;
                    if (peg$silentFails === 0) {
                        peg$fail(peg$c145);
                    }
                }
                if (s1 !== peg$FAILED) {
                    peg$savedPos = s0;
                    s1 = peg$c146();
                }
                s0 = s1;
            }
        }
        peg$resultsCache[key] = { nextPos: peg$currPos, result: s0 };
        return s0;
    }
    function peg$parseValueInput() {
        var s0, s1, s2;
        var key = peg$currPos * 34 + 25;
        var cached = peg$resultsCache[key];
        if (cached) {
            peg$currPos = cached.nextPos;
            return cached.result;
        }
        s0 = peg$currPos;
        s1 = [];
        s2 = peg$parseValueCharacters();
        if (s2 !== peg$FAILED) {
            while (s2 !== peg$FAILED) {
                s1.push(s2);
                s2 = peg$parseValueCharacters();
            }
        }
        else {
            s1 = peg$FAILED;
        }
        if (s1 !== peg$FAILED) {
            peg$savedPos = s0;
            s1 = peg$c147(s1);
        }
        s0 = s1;
        peg$resultsCache[key] = { nextPos: peg$currPos, result: s0 };
        return s0;
    }
    function peg$parseAnyInput() {
        var s0, s1, s2;
        var key = peg$currPos * 34 + 26;
        var cached = peg$resultsCache[key];
        if (cached) {
            peg$currPos = cached.nextPos;
            return cached.result;
        }
        s0 = peg$currPos;
        s1 = [];
        s2 = peg$parseAnyCharacters();
        if (s2 !== peg$FAILED) {
            while (s2 !== peg$FAILED) {
                s1.push(s2);
                s2 = peg$parseAnyCharacters();
            }
        }
        else {
            s1 = peg$FAILED;
        }
        if (s1 !== peg$FAILED) {
            peg$savedPos = s0;
            s1 = peg$c147(s1);
        }
        s0 = s1;
        peg$resultsCache[key] = { nextPos: peg$currPos, result: s0 };
        return s0;
    }
    function peg$parseAnyCharacters() {
        var s0, s1;
        var key = peg$currPos * 34 + 27;
        var cached = peg$resultsCache[key];
        if (cached) {
            peg$currPos = cached.nextPos;
            return cached.result;
        }
        s0 = peg$currPos;
        if (input.substr(peg$currPos, 2) === peg$c148) {
            s1 = peg$c148;
            peg$currPos += 2;
        }
        else {
            s1 = peg$FAILED;
            if (peg$silentFails === 0) {
                peg$fail(peg$c149);
            }
        }
        if (s1 !== peg$FAILED) {
            peg$savedPos = s0;
            s1 = peg$c150();
        }
        s0 = s1;
        if (s0 === peg$FAILED) {
            s0 = peg$currPos;
            if (input.substr(peg$currPos, 2) === peg$c151) {
                s1 = peg$c151;
                peg$currPos += 2;
            }
            else {
                s1 = peg$FAILED;
                if (peg$silentFails === 0) {
                    peg$fail(peg$c152);
                }
            }
            if (s1 !== peg$FAILED) {
                peg$savedPos = s0;
                s1 = peg$c153();
            }
            s0 = s1;
            if (s0 === peg$FAILED) {
                s0 = peg$currPos;
                if (peg$c154.test(input.charAt(peg$currPos))) {
                    s1 = input.charAt(peg$currPos);
                    peg$currPos++;
                }
                else {
                    s1 = peg$FAILED;
                    if (peg$silentFails === 0) {
                        peg$fail(peg$c155);
                    }
                }
                if (s1 !== peg$FAILED) {
                    peg$savedPos = s0;
                    s1 = peg$c156();
                }
                s0 = s1;
            }
        }
        peg$resultsCache[key] = { nextPos: peg$currPos, result: s0 };
        return s0;
    }
    function peg$parseValueCharacters() {
        var s0, s1;
        var key = peg$currPos * 34 + 28;
        var cached = peg$resultsCache[key];
        if (cached) {
            peg$currPos = cached.nextPos;
            return cached.result;
        }
        s0 = peg$currPos;
        if (peg$c157.test(input.charAt(peg$currPos))) {
            s1 = input.charAt(peg$currPos);
            peg$currPos++;
        }
        else {
            s1 = peg$FAILED;
            if (peg$silentFails === 0) {
                peg$fail(peg$c158);
            }
        }
        if (s1 !== peg$FAILED) {
            peg$savedPos = s0;
            s1 = peg$c156();
        }
        s0 = s1;
        peg$resultsCache[key] = { nextPos: peg$currPos, result: s0 };
        return s0;
    }
    function peg$parseLettersAndDigits() {
        var s0, s1, s2, s3, s4, s5, s6;
        var key = peg$currPos * 34 + 29;
        var cached = peg$resultsCache[key];
        if (cached) {
            peg$currPos = cached.nextPos;
            return cached.result;
        }
        s0 = peg$currPos;
        s1 = peg$parseLetters();
        if (s1 !== peg$FAILED) {
            s2 = [];
            s3 = peg$currPos;
            s4 = peg$parseDigits();
            if (s4 !== peg$FAILED) {
                s5 = [];
                s6 = peg$parseLetters();
                while (s6 !== peg$FAILED) {
                    s5.push(s6);
                    s6 = peg$parseLetters();
                }
                if (s5 !== peg$FAILED) {
                    s4 = [s4, s5];
                    s3 = s4;
                }
                else {
                    peg$currPos = s3;
                    s3 = peg$FAILED;
                }
            }
            else {
                peg$currPos = s3;
                s3 = peg$FAILED;
            }
            while (s3 !== peg$FAILED) {
                s2.push(s3);
                s3 = peg$currPos;
                s4 = peg$parseDigits();
                if (s4 !== peg$FAILED) {
                    s5 = [];
                    s6 = peg$parseLetters();
                    while (s6 !== peg$FAILED) {
                        s5.push(s6);
                        s6 = peg$parseLetters();
                    }
                    if (s5 !== peg$FAILED) {
                        s4 = [s4, s5];
                        s3 = s4;
                    }
                    else {
                        peg$currPos = s3;
                        s3 = peg$FAILED;
                    }
                }
                else {
                    peg$currPos = s3;
                    s3 = peg$FAILED;
                }
            }
            if (s2 !== peg$FAILED) {
                peg$savedPos = s0;
                s1 = peg$c156();
                s0 = s1;
            }
            else {
                peg$currPos = s0;
                s0 = peg$FAILED;
            }
        }
        else {
            peg$currPos = s0;
            s0 = peg$FAILED;
        }
        peg$resultsCache[key] = { nextPos: peg$currPos, result: s0 };
        return s0;
    }
    function peg$parseDigits() {
        var s0, s1;
        var key = peg$currPos * 34 + 30;
        var cached = peg$resultsCache[key];
        if (cached) {
            peg$currPos = cached.nextPos;
            return cached.result;
        }
        s0 = [];
        if (peg$c159.test(input.charAt(peg$currPos))) {
            s1 = input.charAt(peg$currPos);
            peg$currPos++;
        }
        else {
            s1 = peg$FAILED;
            if (peg$silentFails === 0) {
                peg$fail(peg$c160);
            }
        }
        if (s1 !== peg$FAILED) {
            while (s1 !== peg$FAILED) {
                s0.push(s1);
                if (peg$c159.test(input.charAt(peg$currPos))) {
                    s1 = input.charAt(peg$currPos);
                    peg$currPos++;
                }
                else {
                    s1 = peg$FAILED;
                    if (peg$silentFails === 0) {
                        peg$fail(peg$c160);
                    }
                }
            }
        }
        else {
            s0 = peg$FAILED;
        }
        peg$resultsCache[key] = { nextPos: peg$currPos, result: s0 };
        return s0;
    }
    function peg$parseNonZeroDigits() {
        var s0, s1;
        var key = peg$currPos * 34 + 31;
        var cached = peg$resultsCache[key];
        if (cached) {
            peg$currPos = cached.nextPos;
            return cached.result;
        }
        s0 = [];
        if (peg$c161.test(input.charAt(peg$currPos))) {
            s1 = input.charAt(peg$currPos);
            peg$currPos++;
        }
        else {
            s1 = peg$FAILED;
            if (peg$silentFails === 0) {
                peg$fail(peg$c162);
            }
        }
        if (s1 !== peg$FAILED) {
            while (s1 !== peg$FAILED) {
                s0.push(s1);
                if (peg$c161.test(input.charAt(peg$currPos))) {
                    s1 = input.charAt(peg$currPos);
                    peg$currPos++;
                }
                else {
                    s1 = peg$FAILED;
                    if (peg$silentFails === 0) {
                        peg$fail(peg$c162);
                    }
                }
            }
        }
        else {
            s0 = peg$FAILED;
        }
        peg$resultsCache[key] = { nextPos: peg$currPos, result: s0 };
        return s0;
    }
    function peg$parseLetters() {
        var s0, s1;
        var key = peg$currPos * 34 + 32;
        var cached = peg$resultsCache[key];
        if (cached) {
            peg$currPos = cached.nextPos;
            return cached.result;
        }
        s0 = [];
        if (peg$c163.test(input.charAt(peg$currPos))) {
            s1 = input.charAt(peg$currPos);
            peg$currPos++;
        }
        else {
            s1 = peg$FAILED;
            if (peg$silentFails === 0) {
                peg$fail(peg$c164);
            }
        }
        if (s1 !== peg$FAILED) {
            while (s1 !== peg$FAILED) {
                s0.push(s1);
                if (peg$c163.test(input.charAt(peg$currPos))) {
                    s1 = input.charAt(peg$currPos);
                    peg$currPos++;
                }
                else {
                    s1 = peg$FAILED;
                    if (peg$silentFails === 0) {
                        peg$fail(peg$c164);
                    }
                }
            }
        }
        else {
            s0 = peg$FAILED;
        }
        peg$resultsCache[key] = { nextPos: peg$currPos, result: s0 };
        return s0;
    }
    function peg$parse_() {
        var s0, s1;
        var key = peg$currPos * 34 + 33;
        var cached = peg$resultsCache[key];
        if (cached) {
            peg$currPos = cached.nextPos;
            return cached.result;
        }
        peg$silentFails++;
        s0 = [];
        if (peg$c166.test(input.charAt(peg$currPos))) {
            s1 = input.charAt(peg$currPos);
            peg$currPos++;
        }
        else {
            s1 = peg$FAILED;
            if (peg$silentFails === 0) {
                peg$fail(peg$c167);
            }
        }
        while (s1 !== peg$FAILED) {
            s0.push(s1);
            if (peg$c166.test(input.charAt(peg$currPos))) {
                s1 = input.charAt(peg$currPos);
                peg$currPos++;
            }
            else {
                s1 = peg$FAILED;
                if (peg$silentFails === 0) {
                    peg$fail(peg$c167);
                }
            }
        }
        peg$silentFails--;
        if (s0 === peg$FAILED) {
            s1 = peg$FAILED;
            if (peg$silentFails === 0) {
                peg$fail(peg$c165);
            }
        }
        peg$resultsCache[key] = { nextPos: peg$currPos, result: s0 };
        return s0;
    }
    function buildBinaryOperand(head, tail, isArithmeticOp) {
        if (isArithmeticOp === void 0) { isArithmeticOp = false; }
        return tail.reduce(function (result, elements) {
            return new _expressions__WEBPACK_IMPORTED_MODULE_0__["BinaryOperand"](elements[1], result, elements[3], isArithmeticOp);
        }, head);
    }
    function flattenArray(array) {
        return [].concat.apply([], array);
    }
    peg$result = peg$startRuleFunction();
    if (peg$result !== peg$FAILED && peg$currPos === input.length) {
        return peg$result;
    }
    else {
        if (peg$result !== peg$FAILED && peg$currPos < input.length) {
            peg$fail(peg$endExpectation());
        }
        throw peg$buildStructuredError(peg$maxFailExpected, peg$maxFailPos < input.length ? input.charAt(peg$maxFailPos) : null, peg$maxFailPos < input.length
            ? peg$computeLocation(peg$maxFailPos, peg$maxFailPos + 1)
            : peg$computeLocation(peg$maxFailPos, peg$maxFailPos));
    }
}
var parse = peg$parse;


/***/ }),

/***/ "./src/expressions/expressions.ts":
/*!****************************************!*\
  !*** ./src/expressions/expressions.ts ***!
  \****************************************/
/*! exports provided: Operand, BinaryOperand, UnaryOperand, ArrayOperand, Const, Variable, FunctionOperand, OperandMaker */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "Operand", function() { return Operand; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "BinaryOperand", function() { return BinaryOperand; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "UnaryOperand", function() { return UnaryOperand; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "ArrayOperand", function() { return ArrayOperand; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "Const", function() { return Const; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "Variable", function() { return Variable; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "FunctionOperand", function() { return FunctionOperand; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "OperandMaker", function() { return OperandMaker; });
/* harmony import */ var _helpers__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../helpers */ "./src/helpers.ts");
/* harmony import */ var _functionsfactory__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../functionsfactory */ "./src/functionsfactory.ts");
/* harmony import */ var _conditionProcessValue__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../conditionProcessValue */ "./src/conditionProcessValue.ts");
var __extends = (undefined && undefined.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();



var Operand = /** @class */ (function () {
    function Operand() {
    }
    Operand.prototype.toString = function (func) {
        if (func === void 0) { func = undefined; }
        return "";
    };
    Operand.prototype.hasFunction = function () {
        return false;
    };
    Operand.prototype.hasAsyncFunction = function () {
        return false;
    };
    Operand.prototype.addToAsyncList = function (list) { };
    Operand.prototype.isEqual = function (op) {
        return !!op && op.getType() === this.getType() && this.isContentEqual(op);
    };
    Operand.prototype.areOperatorsEquals = function (op1, op2) {
        return !op1 && !op2 || !!op1 && op1.isEqual(op2);
    };
    return Operand;
}());

var BinaryOperand = /** @class */ (function (_super) {
    __extends(BinaryOperand, _super);
    function BinaryOperand(operatorName, left, right, isArithmeticOp) {
        if (left === void 0) { left = null; }
        if (right === void 0) { right = null; }
        if (isArithmeticOp === void 0) { isArithmeticOp = false; }
        var _this = _super.call(this) || this;
        _this.operatorName = operatorName;
        _this.left = left;
        _this.right = right;
        _this.isArithmeticValue = isArithmeticOp;
        if (isArithmeticOp) {
            _this.consumer = OperandMaker.binaryFunctions["arithmeticOp"](operatorName);
        }
        else {
            _this.consumer = OperandMaker.binaryFunctions[operatorName];
        }
        if (_this.consumer == null) {
            OperandMaker.throwInvalidOperatorError(operatorName);
        }
        return _this;
    }
    BinaryOperand.prototype.getType = function () {
        return "binary";
    };
    Object.defineProperty(BinaryOperand.prototype, "isArithmetic", {
        get: function () {
            return this.isArithmeticValue;
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(BinaryOperand.prototype, "isConjunction", {
        get: function () {
            return this.operatorName == "or" || this.operatorName == "and";
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(BinaryOperand.prototype, "conjunction", {
        get: function () {
            return this.isConjunction ? this.operatorName : "";
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(BinaryOperand.prototype, "operator", {
        get: function () {
            return this.operatorName;
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(BinaryOperand.prototype, "leftOperand", {
        get: function () {
            return this.left;
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(BinaryOperand.prototype, "rightOperand", {
        get: function () {
            return this.right;
        },
        enumerable: false,
        configurable: true
    });
    BinaryOperand.prototype.isContentEqual = function (op) {
        var bOp = op;
        return bOp.operator === this.operator &&
            this.areOperatorsEquals(this.left, bOp.left) &&
            this.areOperatorsEquals(this.right, bOp.right);
    };
    BinaryOperand.prototype.evaluateParam = function (x, processValue) {
        return x == null ? null : x.evaluate(processValue);
    };
    BinaryOperand.prototype.evaluate = function (processValue) {
        return this.consumer.call(this, this.evaluateParam(this.left, processValue), this.evaluateParam(this.right, processValue));
    };
    BinaryOperand.prototype.toString = function (func) {
        if (func === void 0) { func = undefined; }
        if (!!func) {
            var res = func(this);
            if (!!res)
                return res;
        }
        return ("(" +
            OperandMaker.safeToString(this.left, func) +
            " " +
            OperandMaker.operatorToString(this.operatorName) +
            " " +
            OperandMaker.safeToString(this.right, func) +
            ")");
    };
    BinaryOperand.prototype.setVariables = function (variables) {
        if (this.left != null)
            this.left.setVariables(variables);
        if (this.right != null)
            this.right.setVariables(variables);
    };
    BinaryOperand.prototype.hasFunction = function () {
        return ((!!this.left && this.left.hasFunction()) ||
            (!!this.right && this.right.hasFunction()));
    };
    BinaryOperand.prototype.hasAsyncFunction = function () {
        return ((!!this.left && this.left.hasAsyncFunction()) ||
            (!!this.right && this.right.hasAsyncFunction()));
    };
    BinaryOperand.prototype.addToAsyncList = function (list) {
        if (!!this.left)
            this.left.addToAsyncList(list);
        if (!!this.right)
            this.right.addToAsyncList(list);
    };
    return BinaryOperand;
}(Operand));

var UnaryOperand = /** @class */ (function (_super) {
    __extends(UnaryOperand, _super);
    function UnaryOperand(expressionValue, operatorName) {
        var _this = _super.call(this) || this;
        _this.expressionValue = expressionValue;
        _this.operatorName = operatorName;
        _this.consumer = OperandMaker.unaryFunctions[operatorName];
        if (_this.consumer == null) {
            OperandMaker.throwInvalidOperatorError(operatorName);
        }
        return _this;
    }
    Object.defineProperty(UnaryOperand.prototype, "operator", {
        get: function () {
            return this.operatorName;
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(UnaryOperand.prototype, "expression", {
        get: function () {
            return this.expressionValue;
        },
        enumerable: false,
        configurable: true
    });
    UnaryOperand.prototype.getType = function () {
        return "unary";
    };
    UnaryOperand.prototype.toString = function (func) {
        if (func === void 0) { func = undefined; }
        if (!!func) {
            var res = func(this);
            if (!!res)
                return res;
        }
        return (OperandMaker.operatorToString(this.operatorName) +
            " " +
            this.expression.toString(func));
    };
    UnaryOperand.prototype.isContentEqual = function (op) {
        var uOp = op;
        return uOp.operator == this.operator && this.areOperatorsEquals(this.expression, uOp.expression);
    };
    UnaryOperand.prototype.evaluate = function (processValue) {
        var value = this.expression.evaluate(processValue);
        return this.consumer.call(this, value);
    };
    UnaryOperand.prototype.setVariables = function (variables) {
        this.expression.setVariables(variables);
    };
    return UnaryOperand;
}(Operand));

var ArrayOperand = /** @class */ (function (_super) {
    __extends(ArrayOperand, _super);
    function ArrayOperand(values) {
        var _this = _super.call(this) || this;
        _this.values = values;
        return _this;
    }
    ArrayOperand.prototype.getType = function () {
        return "array";
    };
    ArrayOperand.prototype.toString = function (func) {
        if (func === void 0) { func = undefined; }
        if (!!func) {
            var res = func(this);
            if (!!res)
                return res;
        }
        return ("[" +
            this.values
                .map(function (el) {
                return el.toString(func);
            })
                .join(", ") +
            "]");
    };
    ArrayOperand.prototype.evaluate = function (processValue) {
        return this.values.map(function (el) {
            return el.evaluate(processValue);
        });
    };
    ArrayOperand.prototype.setVariables = function (variables) {
        this.values.forEach(function (el) {
            el.setVariables(variables);
        });
    };
    ArrayOperand.prototype.hasFunction = function () {
        return this.values.some(function (operand) { return operand.hasFunction(); });
    };
    ArrayOperand.prototype.hasAsyncFunction = function () {
        return this.values.some(function (operand) { return operand.hasAsyncFunction(); });
    };
    ArrayOperand.prototype.addToAsyncList = function (list) {
        this.values.forEach(function (operand) { return operand.addToAsyncList(list); });
    };
    ArrayOperand.prototype.isContentEqual = function (op) {
        var aOp = op;
        if (aOp.values.length !== this.values.length)
            return false;
        for (var i = 0; i < this.values.length; i++) {
            if (!aOp.values[i].isEqual(this.values[i]))
                return false;
        }
        return true;
    };
    return ArrayOperand;
}(Operand));

var Const = /** @class */ (function (_super) {
    __extends(Const, _super);
    function Const(value) {
        var _this = _super.call(this) || this;
        _this.value = value;
        return _this;
    }
    Const.prototype.getType = function () {
        return "const";
    };
    Const.prototype.toString = function (func) {
        if (func === void 0) { func = undefined; }
        if (!!func) {
            var res = func(this);
            if (!!res)
                return res;
        }
        return this.value.toString();
    };
    Object.defineProperty(Const.prototype, "correctValue", {
        get: function () {
            return this.getCorrectValue(this.value);
        },
        enumerable: false,
        configurable: true
    });
    Const.prototype.evaluate = function () {
        return this.getCorrectValue(this.value);
    };
    Const.prototype.setVariables = function (variables) { };
    Const.prototype.getCorrectValue = function (value) {
        if (!value || typeof value != "string")
            return value;
        if (this.isBooleanValue(value))
            return value.toLowerCase() === "true";
        if (value.length > 1 &&
            this.isQuote(value[0]) &&
            this.isQuote(value[value.length - 1]))
            return value.substr(1, value.length - 2);
        if (OperandMaker.isNumeric(value)) {
            if (value.indexOf("0x") == 0)
                return parseInt(value);
            if (value.length > 1 && value[0] == "0")
                return value;
            return parseFloat(value);
        }
        return value;
    };
    Const.prototype.isContentEqual = function (op) {
        var cOp = op;
        return cOp.value == this.value;
    };
    Const.prototype.isQuote = function (ch) {
        return ch == "'" || ch == '"';
    };
    Const.prototype.isBooleanValue = function (value) {
        return (value &&
            (value.toLowerCase() === "true" || value.toLowerCase() === "false"));
    };
    return Const;
}(Operand));

var Variable = /** @class */ (function (_super) {
    __extends(Variable, _super);
    function Variable(variableName) {
        var _this = _super.call(this, variableName) || this;
        _this.variableName = variableName;
        _this.valueInfo = {};
        _this.useValueAsItIs = false;
        if (!!_this.variableName &&
            _this.variableName.length > 1 &&
            _this.variableName[0] === Variable.DisableConversionChar) {
            _this.variableName = _this.variableName.substr(1);
            _this.useValueAsItIs = true;
        }
        return _this;
    }
    Variable.prototype.getType = function () {
        return "variable";
    };
    Variable.prototype.toString = function (func) {
        if (func === void 0) { func = undefined; }
        if (!!func) {
            var res = func(this);
            if (!!res)
                return res;
        }
        var prefix = this.useValueAsItIs ? Variable.DisableConversionChar : "";
        return "{" + prefix + this.variableName + "}";
    };
    Object.defineProperty(Variable.prototype, "variable", {
        get: function () {
            return this.variableName;
        },
        enumerable: false,
        configurable: true
    });
    Variable.prototype.evaluate = function (processValue) {
        this.valueInfo.name = this.variableName;
        processValue.getValueInfo(this.valueInfo);
        return this.valueInfo.hasValue
            ? this.getCorrectValue(this.valueInfo.value)
            : null;
    };
    Variable.prototype.setVariables = function (variables) {
        variables.push(this.variableName);
    };
    Variable.prototype.getCorrectValue = function (value) {
        if (this.useValueAsItIs)
            return value;
        return _super.prototype.getCorrectValue.call(this, value);
    };
    Variable.prototype.isContentEqual = function (op) {
        var vOp = op;
        return vOp.variable == this.variable;
    };
    Variable.DisableConversionChar = "#";
    return Variable;
}(Const));

var FunctionOperand = /** @class */ (function (_super) {
    __extends(FunctionOperand, _super);
    function FunctionOperand(originalValue, parameters) {
        var _this = _super.call(this) || this;
        _this.originalValue = originalValue;
        _this.parameters = parameters;
        _this.isReadyValue = false;
        if (Array.isArray(parameters) && parameters.length === 0) {
            _this.parameters = new ArrayOperand([]);
        }
        return _this;
    }
    FunctionOperand.prototype.getType = function () {
        return "function";
    };
    FunctionOperand.prototype.evaluateAsync = function (processValue) {
        var _this = this;
        this.isReadyValue = false;
        var asyncProcessValue = new _conditionProcessValue__WEBPACK_IMPORTED_MODULE_2__["ProcessValue"]();
        asyncProcessValue.values = _helpers__WEBPACK_IMPORTED_MODULE_0__["Helpers"].createCopy(processValue.values);
        asyncProcessValue.properties = _helpers__WEBPACK_IMPORTED_MODULE_0__["Helpers"].createCopy(processValue.properties);
        asyncProcessValue.properties.returnResult = function (result) {
            _this.asynResult = result;
            _this.isReadyValue = true;
            _this.onAsyncReady();
        };
        this.evaluateCore(asyncProcessValue);
    };
    FunctionOperand.prototype.evaluate = function (processValue) {
        if (this.isReady)
            return this.asynResult;
        return this.evaluateCore(processValue);
    };
    FunctionOperand.prototype.evaluateCore = function (processValue) {
        return _functionsfactory__WEBPACK_IMPORTED_MODULE_1__["FunctionFactory"].Instance.run(this.originalValue, this.parameters.evaluate(processValue), processValue.properties);
    };
    FunctionOperand.prototype.toString = function (func) {
        if (func === void 0) { func = undefined; }
        if (!!func) {
            var res = func(this);
            if (!!res)
                return res;
        }
        return this.originalValue + "(" + this.parameters.toString(func) + ")";
    };
    FunctionOperand.prototype.setVariables = function (variables) {
        this.parameters.setVariables(variables);
    };
    Object.defineProperty(FunctionOperand.prototype, "isReady", {
        get: function () {
            return this.isReadyValue;
        },
        enumerable: false,
        configurable: true
    });
    FunctionOperand.prototype.hasFunction = function () {
        return true;
    };
    FunctionOperand.prototype.hasAsyncFunction = function () {
        return _functionsfactory__WEBPACK_IMPORTED_MODULE_1__["FunctionFactory"].Instance.isAsyncFunction(this.originalValue);
    };
    FunctionOperand.prototype.addToAsyncList = function (list) {
        if (this.hasAsyncFunction()) {
            list.push(this);
        }
    };
    FunctionOperand.prototype.isContentEqual = function (op) {
        var fOp = op;
        return fOp.originalValue == this.originalValue && this.areOperatorsEquals(fOp.parameters, this.parameters);
    };
    return FunctionOperand;
}(Operand));

var OperandMaker = /** @class */ (function () {
    function OperandMaker() {
    }
    OperandMaker.throwInvalidOperatorError = function (op) {
        throw new Error("Invalid operator: '" + op + "'");
    };
    OperandMaker.safeToString = function (operand, func) {
        return operand == null ? "" : operand.toString(func);
    };
    OperandMaker.toOperandString = function (value) {
        if (!!value &&
            !OperandMaker.isNumeric(value) &&
            !OperandMaker.isBooleanValue(value))
            value = "'" + value + "'";
        return value;
    };
    OperandMaker.isSpaceString = function (str) {
        return !!str && !str.replace(" ", "");
    };
    OperandMaker.isNumeric = function (value) {
        if (!!value &&
            (value.indexOf("-") > -1 ||
                value.indexOf("+") > 1 ||
                value.indexOf("*") > -1 ||
                value.indexOf("^") > -1 ||
                value.indexOf("/") > -1 ||
                value.indexOf("%") > -1))
            return false;
        if (OperandMaker.isSpaceString(value))
            return false;
        return _helpers__WEBPACK_IMPORTED_MODULE_0__["Helpers"].isNumber(value);
    };
    OperandMaker.isBooleanValue = function (value) {
        return (!!value &&
            (value.toLowerCase() === "true" || value.toLowerCase() === "false"));
    };
    OperandMaker.countDecimals = function (value) {
        if (_helpers__WEBPACK_IMPORTED_MODULE_0__["Helpers"].isNumber(value) && Math.floor(value) !== value) {
            var strs = value.toString().split(".");
            return strs.length > 1 && strs[1].length || 0;
        }
        return 0;
    };
    OperandMaker.plusMinus = function (a, b, res) {
        var digitsA = OperandMaker.countDecimals(a);
        var digitsB = OperandMaker.countDecimals(b);
        if (digitsA > 0 || digitsB > 0) {
            var digits = Math.max(digitsA, digitsB);
            res = parseFloat(res.toFixed(digits));
        }
        return res;
    };
    OperandMaker.isTwoValueEquals = function (x, y) {
        if (x === "undefined")
            x = undefined;
        if (y === "undefined")
            y = undefined;
        return _helpers__WEBPACK_IMPORTED_MODULE_0__["Helpers"].isTwoValueEquals(x, y, true);
    };
    OperandMaker.operatorToString = function (operatorName) {
        var opStr = OperandMaker.signs[operatorName];
        return opStr == null ? operatorName : opStr;
    };
    OperandMaker.unaryFunctions = {
        empty: function (value) {
            return _helpers__WEBPACK_IMPORTED_MODULE_0__["Helpers"].isValueEmpty(value);
        },
        notempty: function (value) {
            return !OperandMaker.unaryFunctions.empty(value);
        },
        negate: function (value) {
            return !value;
        },
    };
    OperandMaker.binaryFunctions = {
        arithmeticOp: function (operatorName) {
            return function (a, b) {
                if (_helpers__WEBPACK_IMPORTED_MODULE_0__["Helpers"].isValueEmpty(a) && !OperandMaker.isSpaceString(a)) {
                    a = typeof b === "string" ? "" : 0;
                }
                if (_helpers__WEBPACK_IMPORTED_MODULE_0__["Helpers"].isValueEmpty(b) && !OperandMaker.isSpaceString(b)) {
                    b = typeof a === "string" ? "" : 0;
                }
                var consumer = OperandMaker.binaryFunctions[operatorName];
                return consumer == null ? null : consumer.call(this, a, b);
            };
        },
        and: function (a, b) {
            return a && b;
        },
        or: function (a, b) {
            return a || b;
        },
        plus: function (a, b) {
            if (!_helpers__WEBPACK_IMPORTED_MODULE_0__["Helpers"].isNumber(a) || !_helpers__WEBPACK_IMPORTED_MODULE_0__["Helpers"].isNumber(b)) {
                return a + b;
            }
            return _helpers__WEBPACK_IMPORTED_MODULE_0__["Helpers"].correctAfterPlusMinis(a, b, a + b);
        },
        minus: function (a, b) {
            return _helpers__WEBPACK_IMPORTED_MODULE_0__["Helpers"].correctAfterPlusMinis(a, b, a - b);
        },
        mul: function (a, b) {
            return _helpers__WEBPACK_IMPORTED_MODULE_0__["Helpers"].correctAfterMultiple(a, b, a * b);
        },
        div: function (a, b) {
            if (!b)
                return null;
            return a / b;
        },
        mod: function (a, b) {
            if (!b)
                return null;
            return a % b;
        },
        power: function (a, b) {
            return Math.pow(a, b);
        },
        greater: function (left, right) {
            if (left == null || right == null)
                return false;
            return left > right;
        },
        less: function (left, right) {
            if (left == null || right == null)
                return false;
            return left < right;
        },
        greaterorequal: function (left, right) {
            if (OperandMaker.binaryFunctions.equal(left, right))
                return true;
            return OperandMaker.binaryFunctions.greater(left, right);
        },
        lessorequal: function (left, right) {
            if (OperandMaker.binaryFunctions.equal(left, right))
                return true;
            return OperandMaker.binaryFunctions.less(left, right);
        },
        equal: function (left, right) {
            return OperandMaker.isTwoValueEquals(left, right);
        },
        notequal: function (left, right) {
            return !OperandMaker.binaryFunctions.equal(left, right);
        },
        contains: function (left, right) {
            return OperandMaker.binaryFunctions.containsCore(left, right, true);
        },
        notcontains: function (left, right) {
            if (!left && !_helpers__WEBPACK_IMPORTED_MODULE_0__["Helpers"].isValueEmpty(right))
                return true;
            return OperandMaker.binaryFunctions.containsCore(left, right, false);
        },
        anyof: function (left, right) {
            if (_helpers__WEBPACK_IMPORTED_MODULE_0__["Helpers"].isValueEmpty(left) && _helpers__WEBPACK_IMPORTED_MODULE_0__["Helpers"].isValueEmpty(right))
                return true;
            if (_helpers__WEBPACK_IMPORTED_MODULE_0__["Helpers"].isValueEmpty(left) ||
                (!Array.isArray(left) && left.length === 0))
                return false;
            if (_helpers__WEBPACK_IMPORTED_MODULE_0__["Helpers"].isValueEmpty(right))
                return true;
            if (!Array.isArray(left))
                return OperandMaker.binaryFunctions.contains(right, left);
            if (!Array.isArray(right))
                return OperandMaker.binaryFunctions.contains(left, right);
            for (var i = 0; i < right.length; i++) {
                if (OperandMaker.binaryFunctions.contains(left, right[i]))
                    return true;
            }
            return false;
        },
        allof: function (left, right) {
            if (!left && !_helpers__WEBPACK_IMPORTED_MODULE_0__["Helpers"].isValueEmpty(right))
                return false;
            if (!Array.isArray(right))
                return OperandMaker.binaryFunctions.contains(left, right);
            for (var i = 0; i < right.length; i++) {
                if (!OperandMaker.binaryFunctions.contains(left, right[i]))
                    return false;
            }
            return true;
        },
        containsCore: function (left, right, isContains) {
            if (!left && left !== 0 && left !== false)
                return false;
            if (!left.length) {
                left = left.toString();
                if (typeof right === "string" || right instanceof String) {
                    left = left.toUpperCase();
                    right = right.toUpperCase();
                }
            }
            if (typeof left === "string" || left instanceof String) {
                if (!right)
                    return false;
                right = right.toString();
                var found = left.indexOf(right) > -1;
                return isContains ? found : !found;
            }
            var rightArray = Array.isArray(right) ? right : [right];
            for (var rIndex = 0; rIndex < rightArray.length; rIndex++) {
                var i = 0;
                right = rightArray[rIndex];
                for (; i < left.length; i++) {
                    if (OperandMaker.isTwoValueEquals(left[i], right))
                        break;
                }
                if (i == left.length)
                    return !isContains;
            }
            return isContains;
        },
    };
    OperandMaker.signs = {
        less: "<",
        lessorequal: "<=",
        greater: ">",
        greaterorequal: ">=",
        equal: "==",
        notequal: "!=",
        plus: "+",
        minus: "-",
        mul: "*",
        div: "/",
        and: "and",
        or: "or",
        power: "^",
        mod: "%",
        negate: "!",
    };
    return OperandMaker;
}());



/***/ }),

/***/ "./src/flowpanel.ts":
/*!**************************!*\
  !*** ./src/flowpanel.ts ***!
  \**************************/
/*! exports provided: FlowPanelModel */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "FlowPanelModel", function() { return FlowPanelModel; });
/* harmony import */ var _jsonobject__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./jsonobject */ "./src/jsonobject.ts");
/* harmony import */ var _panel__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./panel */ "./src/panel.ts");
var __extends = (undefined && undefined.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();


/**
 * The flow panel object. It is a container with flow layout where you can mix questions with markdown text.
 *
 */
var FlowPanelModel = /** @class */ (function (_super) {
    __extends(FlowPanelModel, _super);
    function FlowPanelModel(name) {
        if (name === void 0) { name = ""; }
        var _this = _super.call(this, name) || this;
        _this.createLocalizableString("content", _this, true);
        var self = _this;
        _this.registerFunctionOnPropertyValueChanged("content", function () {
            self.onContentChanged();
        });
        return _this;
    }
    FlowPanelModel.prototype.getType = function () {
        return "flowpanel";
    };
    FlowPanelModel.prototype.getChildrenLayoutType = function () {
        return "flow";
    };
    FlowPanelModel.prototype.onSurveyLoad = function () {
        _super.prototype.onSurveyLoad.call(this);
        this.onContentChanged();
    };
    Object.defineProperty(FlowPanelModel.prototype, "content", {
        get: function () {
            return this.getLocalizableStringText("content");
        },
        set: function (val) {
            this.setLocalizableStringText("content", val);
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(FlowPanelModel.prototype, "locContent", {
        get: function () {
            return this.getLocalizableString("content");
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(FlowPanelModel.prototype, "html", {
        get: function () {
            return this.getPropertyValue("html", "");
        },
        set: function (val) {
            this.setPropertyValue("html", val);
        },
        enumerable: false,
        configurable: true
    });
    FlowPanelModel.prototype.onContentChanged = function () {
        var html = "";
        if (!!this.onCustomHtmlProducing) {
            html = this.onCustomHtmlProducing();
        }
        else {
            html = this.produceHtml();
        }
        this.html = html;
        if (!!this.contentChangedCallback)
            this.contentChangedCallback();
    };
    FlowPanelModel.prototype.produceHtml = function () {
        var html = [];
        //contentElementNamePrefix
        var regEx = /{(.*?(element:)[^$].*?)}/g;
        var str = this.content;
        var startIndex = 0;
        var res = null;
        while ((res = regEx.exec(str)) !== null) {
            if (res.index > startIndex) {
                html.push(str.substr(startIndex, res.index - startIndex));
                startIndex = res.index;
            }
            var question = this.getQuestionFromText(res[0]);
            if (!!question) {
                html.push(this.getHtmlForQuestion(question));
            }
            else {
                html.push(str.substr(startIndex, res.index + res[0].length - startIndex));
            }
            startIndex = res.index + res[0].length;
        }
        if (startIndex < str.length) {
            html.push(str.substr(startIndex, str.length - startIndex));
        }
        return html.join("").replace(new RegExp("<br>", "g"), "<br/>");
    };
    FlowPanelModel.prototype.getQuestionFromText = function (str) {
        str = str.substr(1, str.length - 2);
        str = str.replace(FlowPanelModel.contentElementNamePrefix, "").trim();
        return this.getQuestionByName(str);
    };
    FlowPanelModel.prototype.getHtmlForQuestion = function (question) {
        if (!!this.onGetHtmlForQuestion)
            return this.onGetHtmlForQuestion(question);
        return "";
    };
    FlowPanelModel.prototype.getQuestionHtmlId = function (question) {
        return this.name + "_" + question.id;
    };
    FlowPanelModel.prototype.onAddElement = function (element, index) {
        _super.prototype.onAddElement.call(this, element, index);
        this.addElementToContent(element);
        element.renderWidth = "";
    };
    FlowPanelModel.prototype.onRemoveElement = function (element) {
        var searchStr = this.getElementContentText(element);
        this.content = this.content.replace(searchStr, "");
        _super.prototype.onRemoveElement.call(this, element);
    };
    FlowPanelModel.prototype.dragDropMoveElement = function (src, target, targetIndex) { };
    FlowPanelModel.prototype.addElementToContent = function (element) {
        if (this.isLoadingFromJson)
            return;
        var text = this.getElementContentText(element);
        if (!this.insertTextAtCursor(text)) {
            this.content = this.content + text;
        }
    };
    FlowPanelModel.prototype.insertTextAtCursor = function (text, prevName) {
        if (prevName === void 0) { prevName = null; }
        if (!this.isDesignMode ||
            typeof document === "undefined" ||
            !window.getSelection)
            return false;
        var sel = window.getSelection();
        if (sel.getRangeAt && sel.rangeCount) {
            var range = sel.getRangeAt(0);
            range.deleteContents();
            range.insertNode(document.createTextNode(text));
            var self = this;
            if (self.getContent) {
                var str = self.getContent(prevName);
                this.content = str;
            }
            return true;
        }
        return false;
    };
    FlowPanelModel.prototype.getElementContentText = function (element) {
        return "{" + FlowPanelModel.contentElementNamePrefix + element.name + "}";
    };
    FlowPanelModel.contentElementNamePrefix = "element:";
    return FlowPanelModel;
}(_panel__WEBPACK_IMPORTED_MODULE_1__["PanelModel"]));

_jsonobject__WEBPACK_IMPORTED_MODULE_0__["Serializer"].addClass("flowpanel", [{ name: "content:html", serializationProperty: "locContent" }], function () {
    return new FlowPanelModel();
}, "panel");


/***/ }),

/***/ "./src/functionsfactory.ts":
/*!*********************************!*\
  !*** ./src/functionsfactory.ts ***!
  \*********************************/
/*! exports provided: FunctionFactory, registerFunction */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "FunctionFactory", function() { return FunctionFactory; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "registerFunction", function() { return registerFunction; });
/* harmony import */ var _helpers__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./helpers */ "./src/helpers.ts");

var FunctionFactory = /** @class */ (function () {
    function FunctionFactory() {
        this.functionHash = {};
        this.isAsyncHash = {};
    }
    FunctionFactory.prototype.register = function (name, func, isAsync) {
        if (isAsync === void 0) { isAsync = false; }
        this.functionHash[name] = func;
        if (isAsync)
            this.isAsyncHash[name] = true;
    };
    FunctionFactory.prototype.unregister = function (name) {
        delete this.functionHash[name];
        delete this.isAsyncHash[name];
    };
    FunctionFactory.prototype.hasFunction = function (name) {
        return !!this.functionHash[name];
    };
    FunctionFactory.prototype.isAsyncFunction = function (name) {
        return !!this.isAsyncHash[name];
    };
    FunctionFactory.prototype.clear = function () {
        this.functionHash = {};
    };
    FunctionFactory.prototype.getAll = function () {
        var result = [];
        for (var key in this.functionHash) {
            result.push(key);
        }
        return result.sort();
    };
    FunctionFactory.prototype.run = function (name, params, properties) {
        if (properties === void 0) { properties = null; }
        var func = this.functionHash[name];
        if (!func)
            return null;
        var classRunner = {
            func: func,
        };
        if (properties) {
            for (var key in properties) {
                classRunner[key] = properties[key];
            }
        }
        return classRunner.func(params);
    };
    FunctionFactory.Instance = new FunctionFactory();
    return FunctionFactory;
}());

var registerFunction = FunctionFactory.Instance.register;
function getParamsAsArray(value, arr) {
    if (value === undefined || value === null)
        return;
    if (Array.isArray(value)) {
        for (var i = 0; i < value.length; i++) {
            getParamsAsArray(value[i], arr);
        }
    }
    else {
        if (_helpers__WEBPACK_IMPORTED_MODULE_0__["Helpers"].isNumber(value)) {
            value = parseFloat(value);
        }
        arr.push(value);
    }
}
function sum(params) {
    var arr = [];
    getParamsAsArray(params, arr);
    var res = 0;
    for (var i = 0; i < arr.length; i++) {
        res = _helpers__WEBPACK_IMPORTED_MODULE_0__["Helpers"].correctAfterPlusMinis(res, arr[i], res + arr[i]);
    }
    return res;
}
FunctionFactory.Instance.register("sum", sum);
function min_max(params, isMin) {
    var arr = [];
    getParamsAsArray(params, arr);
    var res = undefined;
    for (var i = 0; i < arr.length; i++) {
        if (res === undefined) {
            res = arr[i];
        }
        if (isMin) {
            if (res > arr[i])
                res = arr[i];
        }
        else {
            if (res < arr[i])
                res = arr[i];
        }
    }
    return res;
}
function min(params) {
    return min_max(params, true);
}
FunctionFactory.Instance.register("min", min);
function max(params) {
    return min_max(params, false);
}
FunctionFactory.Instance.register("max", max);
function count(params) {
    var arr = [];
    getParamsAsArray(params, arr);
    return arr.length;
}
FunctionFactory.Instance.register("count", count);
function avg(params) {
    var arr = [];
    getParamsAsArray(params, arr);
    var res = sum(params);
    return arr.length > 0 ? res / arr.length : 0;
}
FunctionFactory.Instance.register("avg", avg);
function getInArrayParams(params) {
    if (params.length != 2)
        return null;
    var arr = params[0];
    if (!arr)
        return null;
    if (!Array.isArray(arr) && !Array.isArray(Object.keys(arr)))
        return null;
    var name = params[1];
    if (typeof name !== "string" && !(name instanceof String))
        return null;
    return { data: arr, name: name };
}
function convertToNumber(val) {
    if (typeof val === "string")
        return _helpers__WEBPACK_IMPORTED_MODULE_0__["Helpers"].isNumber(val) ? parseFloat(val) : undefined;
    return val;
}
function processItemInArray(item, name, res, func, needToConvert) {
    if (!item || _helpers__WEBPACK_IMPORTED_MODULE_0__["Helpers"].isValueEmpty(item[name]))
        return res;
    var val = needToConvert ? convertToNumber(item[name]) : 1;
    return func(res, val);
}
function calcInArray(params, func, needToConvert) {
    if (needToConvert === void 0) { needToConvert = true; }
    var v = getInArrayParams(params);
    if (!v)
        return undefined;
    var res = undefined;
    if (Array.isArray(v.data)) {
        for (var i = 0; i < v.data.length; i++) {
            res = processItemInArray(v.data[i], v.name, res, func, needToConvert);
        }
    }
    else {
        for (var key in v.data) {
            res = processItemInArray(v.data[key], v.name, res, func, needToConvert);
        }
    }
    return res;
}
function sumInArray(params) {
    var res = calcInArray(params, function (res, val) {
        if (res == undefined)
            res = 0;
        if (val == undefined || val == null)
            return res;
        return _helpers__WEBPACK_IMPORTED_MODULE_0__["Helpers"].correctAfterPlusMinis(res, val, res + val);
    });
    return res !== undefined ? res : 0;
}
FunctionFactory.Instance.register("sumInArray", sumInArray);
function minInArray(params) {
    return calcInArray(params, function (res, val) {
        if (res == undefined)
            return val;
        if (val == undefined || val == null)
            return res;
        return res < val ? res : val;
    });
}
FunctionFactory.Instance.register("minInArray", minInArray);
function maxInArray(params) {
    return calcInArray(params, function (res, val) {
        if (res == undefined)
            return val;
        if (val == undefined || val == null)
            return res;
        return res > val ? res : val;
    });
}
FunctionFactory.Instance.register("maxInArray", maxInArray);
function countInArray(params) {
    var res = calcInArray(params, function (res, val) {
        if (res == undefined)
            res = 0;
        if (val == undefined || val == null)
            return res;
        return res + 1;
    }, false);
    return res !== undefined ? res : 0;
}
FunctionFactory.Instance.register("countInArray", countInArray);
function avgInArray(params) {
    var count = countInArray(params);
    if (count == 0)
        return 0;
    return sumInArray(params) / count;
}
FunctionFactory.Instance.register("avgInArray", avgInArray);
function iif(params) {
    if (!params && params.length !== 3)
        return "";
    return params[0] ? params[1] : params[2];
}
FunctionFactory.Instance.register("iif", iif);
function getDate(params) {
    if (!params && params.length < 1)
        return null;
    if (!params[0])
        return null;
    return new Date(params[0]);
}
FunctionFactory.Instance.register("getDate", getDate);
function age(params) {
    if (!params && params.length < 1)
        return null;
    if (!params[0])
        return null;
    var birthDate = new Date(params[0]);
    var today = new Date();
    var age = today.getFullYear() - birthDate.getFullYear();
    var m = today.getMonth() - birthDate.getMonth();
    if (m < 0 || (m === 0 && today.getDate() < birthDate.getDate())) {
        age -= age > 0 ? 1 : 0;
    }
    return age;
}
FunctionFactory.Instance.register("age", age);
function isContainerReadyCore(container) {
    if (!container)
        return false;
    var questions = container.questions;
    for (var i = 0; i < questions.length; i++) {
        if (questions[i].hasErrors(false))
            return false;
    }
    return true;
}
function isContainerReady(params) {
    if (!params && params.length < 1)
        return false;
    if (!params[0] || !this.survey)
        return false;
    var name = params[0];
    var container = this.survey.getPageByName(name);
    if (!container)
        container = this.survey.getPanelByName(name);
    if (!container) {
        var question = this.survey.getQuestionByName(name);
        if (!question || !Array.isArray(question.panels))
            return false;
        if (params.length > 1) {
            if (params[1] < question.panels.length) {
                container = question.panels[params[1]];
            }
        }
        else {
            for (var i = 0; i < question.panels.length; i++) {
                if (!isContainerReadyCore(question.panels[i]))
                    return false;
            }
            return true;
        }
    }
    return isContainerReadyCore(container);
}
FunctionFactory.Instance.register("isContainerReady", isContainerReady);
function isDisplayMode() {
    return this.survey && this.survey.isDisplayMode;
}
FunctionFactory.Instance.register("isDisplayMode", isDisplayMode);
function currentDate() {
    return new Date();
}
FunctionFactory.Instance.register("currentDate", currentDate);
function today(params) {
    var res = new Date();
    res.setUTCHours(0, 0, 0, 0);
    if (Array.isArray(params) && params.length == 1) {
        res.setDate(res.getDate() + params[0]);
    }
    return res;
}
FunctionFactory.Instance.register("today", today);
function getYear(params) {
    if (params.length !== 1 || !params[0])
        return undefined;
    return new Date(params[0]).getFullYear();
}
FunctionFactory.Instance.register("getYear", getYear);
function currentYear() {
    return new Date().getFullYear();
}
FunctionFactory.Instance.register("currentYear", currentYear);
function diffDays(params) {
    if (!Array.isArray(params) || params.length !== 2)
        return 0;
    if (!params[0] || !params[1])
        return 0;
    var date1 = new Date(params[0]);
    var date2 = new Date(params[1]);
    var diffTime = Math.abs(date2 - date1);
    return Math.ceil(diffTime / (1000 * 60 * 60 * 24));
}
FunctionFactory.Instance.register("diffDays", diffDays);


/***/ }),

/***/ "./src/helpers.ts":
/*!************************!*\
  !*** ./src/helpers.ts ***!
  \************************/
/*! exports provided: Helpers */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "Helpers", function() { return Helpers; });
/* harmony import */ var _settings__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./settings */ "./src/settings.ts");

var Helpers = /** @class */ (function () {
    function Helpers() {
    }
    /**
     * A static methods that returns true if a value undefined, null, empty string or empty array.
     * @param value
     */
    Helpers.isValueEmpty = function (value) {
        if (Array.isArray(value) && value.length === 0)
            return true;
        if (!!value && typeof value === "object" && value.constructor === Object) {
            for (var key in value) {
                if (!Helpers.isValueEmpty(value[key]))
                    return false;
            }
            return true;
        }
        return !value && value !== 0 && value !== false;
    };
    Helpers.isArrayContainsEqual = function (x, y) {
        if (!Array.isArray(x) || !Array.isArray(y))
            return false;
        if (x.length !== y.length)
            return false;
        for (var i = 0; i < x.length; i++) {
            var j = 0;
            for (; j < y.length; j++) {
                if (Helpers.isTwoValueEquals(x[i], y[j]))
                    break;
            }
            if (j === y.length)
                return false;
        }
        return true;
    };
    Helpers.isArraysEqual = function (x, y, ignoreOrder, caseSensitive, trimStrings) {
        if (ignoreOrder === void 0) { ignoreOrder = false; }
        if (!Array.isArray(x) || !Array.isArray(y))
            return false;
        if (x.length !== y.length)
            return false;
        if (ignoreOrder) {
            var xSorted = [];
            var ySorted = [];
            for (var i = 0; i < x.length; i++) {
                xSorted.push(x[i]);
                ySorted.push(y[i]);
            }
            xSorted.sort();
            ySorted.sort();
            x = xSorted;
            y = ySorted;
        }
        for (var i = 0; i < x.length; i++) {
            if (!Helpers.isTwoValueEquals(x[i], y[i], ignoreOrder, caseSensitive, trimStrings))
                return false;
        }
        return true;
    };
    Helpers.isTwoValueEquals = function (x, y, ignoreOrder, caseSensitive, trimStrings) {
        if (ignoreOrder === void 0) { ignoreOrder = false; }
        if (x === y)
            return true;
        if (Array.isArray(x) && x.length === 0 && typeof y === "undefined")
            return true;
        if (Array.isArray(y) && y.length === 0 && typeof x === "undefined")
            return true;
        if ((x === undefined || x === null) && y === "")
            return true;
        if ((y === undefined || y === null) && x === "")
            return true;
        if (trimStrings === undefined)
            trimStrings = _settings__WEBPACK_IMPORTED_MODULE_0__["settings"].comparator.trimStrings;
        if (caseSensitive === undefined)
            caseSensitive = _settings__WEBPACK_IMPORTED_MODULE_0__["settings"].comparator.caseSensitive;
        if (typeof x === "string" && typeof y === "string") {
            if (trimStrings) {
                x = x.trim();
                y = y.trim();
            }
            if (!caseSensitive) {
                x = x.toLowerCase();
                y = y.toLowerCase();
            }
            return x === y;
        }
        if (x instanceof Date && y instanceof Date)
            return x.getTime() == y.getTime();
        if (Helpers.isConvertibleToNumber(x) && Helpers.isConvertibleToNumber(y)) {
            if (parseInt(x) === parseInt(y) && parseFloat(x) === parseFloat(y)) {
                return true;
            }
        }
        if ((!Helpers.isValueEmpty(x) && Helpers.isValueEmpty(y)) ||
            (Helpers.isValueEmpty(x) && !Helpers.isValueEmpty(y)))
            return false;
        if ((x === true || x === false) && typeof y == "string") {
            return x.toString() === y.toLocaleLowerCase();
        }
        if ((y === true || y === false) && typeof x == "string") {
            return y.toString() === x.toLocaleLowerCase();
        }
        if (!(x instanceof Object) && !(y instanceof Object))
            return x == y;
        if (!(x instanceof Object) || !(y instanceof Object))
            return false;
        if (x["equals"])
            return x.equals(y);
        if (!!x.toJSON && !!y.toJSON && !!x.getType && !!y.getType) {
            if (x.isDiposed || y.isDiposed)
                return false;
            if (x.getType() !== y.getType())
                return false;
            if (!!x.name && x.name !== y.name)
                return false;
            return this.isTwoValueEquals(x.toJSON(), y.toJSON(), ignoreOrder, caseSensitive, trimStrings);
        }
        if (Array.isArray(x) && Array.isArray(y))
            return Helpers.isArraysEqual(x, y, ignoreOrder, caseSensitive, trimStrings);
        if (!!x.equalsTo && y.equalsTo)
            return x.equalsTo(y);
        for (var p in x) {
            if (!x.hasOwnProperty(p))
                continue;
            if (!y.hasOwnProperty(p))
                return false;
            if (x[p] === y[p])
                continue;
            if (typeof x[p] !== "object")
                return false;
            if (!this.isTwoValueEquals(x[p], y[p]))
                return false;
        }
        for (p in y) {
            if (y.hasOwnProperty(p) && !x.hasOwnProperty(p))
                return false;
        }
        return true;
    };
    Helpers.randomizeArray = function (array) {
        for (var i = array.length - 1; i > 0; i--) {
            var j = Math.floor(Math.random() * (i + 1));
            var temp = array[i];
            array[i] = array[j];
            array[j] = temp;
        }
        return array;
    };
    Helpers.getUnbindValue = function (value) {
        if (!!value && value instanceof Object) {
            //do not return the same object instance!!!
            return JSON.parse(JSON.stringify(value));
        }
        return value;
    };
    Helpers.createCopy = function (obj) {
        var res = {};
        if (!obj)
            return res;
        for (var key in obj) {
            res[key] = obj[key];
        }
        return res;
    };
    Helpers.isConvertibleToNumber = function (value) {
        return (value !== undefined &&
            value !== null &&
            !Array.isArray(value) &&
            !isNaN(value));
    };
    Helpers.isNumber = function (value) {
        if (typeof value == "string" &&
            !!value &&
            value.indexOf("0x") == 0 &&
            value.length > 32)
            return false;
        return !isNaN(parseFloat(value)) && isFinite(value);
    };
    Helpers.getMaxLength = function (maxLength, surveyLength) {
        if (maxLength < 0) {
            maxLength = surveyLength;
        }
        return maxLength > 0 ? maxLength : null;
    };
    Helpers.getNumberByIndex = function (index, startIndexStr) {
        if (index < 0)
            return "";
        var startIndex = 1;
        var prefix = "";
        var postfix = ".";
        var isNumeric = true;
        var strIndex = "A";
        var str = "";
        if (!!startIndexStr) {
            str = startIndexStr;
            var ind = str.length - 1;
            var hasDigit = false;
            for (var i = 0; i < str.length; i++) {
                if (Helpers.isCharDigit(str[i])) {
                    hasDigit = true;
                    break;
                }
            }
            var checkLetter = function () {
                return ((hasDigit && !Helpers.isCharDigit(str[ind])) ||
                    Helpers.isCharNotLetterAndDigit(str[ind]));
            };
            while (ind >= 0 && checkLetter())
                ind--;
            var newPostfix = "";
            if (ind < str.length - 1) {
                newPostfix = str.substr(ind + 1);
                str = str.substr(0, ind + 1);
            }
            ind = str.length - 1;
            while (ind >= 0) {
                if (checkLetter())
                    break;
                ind--;
                if (!hasDigit)
                    break;
            }
            strIndex = str.substr(ind + 1);
            prefix = str.substr(0, ind + 1);
            if (parseInt(strIndex))
                startIndex = parseInt(strIndex);
            else if (strIndex.length == 1)
                isNumeric = false;
            if (!!newPostfix || !!prefix) {
                postfix = newPostfix;
            }
        }
        if (isNumeric)
            return prefix + (index + startIndex).toString() + postfix;
        return (prefix + String.fromCharCode(strIndex.charCodeAt(0) + index) + postfix);
    };
    Helpers.isCharNotLetterAndDigit = function (ch) {
        return ch.toUpperCase() == ch.toLowerCase() && !Helpers.isCharDigit(ch);
    };
    Helpers.isCharDigit = function (ch) {
        return ch >= "0" && ch <= "9";
    };
    Helpers.countDecimals = function (value) {
        if (Helpers.isNumber(value) && Math.floor(value) !== value) {
            var strs = value.toString().split(".");
            return strs.length > 1 && strs[1].length || 0;
        }
        return 0;
    };
    Helpers.correctAfterPlusMinis = function (a, b, res) {
        var digitsA = Helpers.countDecimals(a);
        var digitsB = Helpers.countDecimals(b);
        if (digitsA > 0 || digitsB > 0) {
            var digits = Math.max(digitsA, digitsB);
            res = parseFloat(res.toFixed(digits));
        }
        return res;
    };
    Helpers.correctAfterMultiple = function (a, b, res) {
        var digits = Helpers.countDecimals(a) + Helpers.countDecimals(b);
        if (digits > 0) {
            res = parseFloat(res.toFixed(digits));
        }
        return res;
    };
    return Helpers;
}());

if (!String.prototype["format"]) {
    String.prototype["format"] = function () {
        var args = arguments;
        return this.replace(/{(\d+)}/g, function (match, number) {
            return typeof args[number] != "undefined" ? args[number] : match;
        });
    };
}


/***/ }),

/***/ "./src/itemvalue.ts":
/*!**************************!*\
  !*** ./src/itemvalue.ts ***!
  \**************************/
/*! exports provided: ItemValue */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "ItemValue", function() { return ItemValue; });
/* harmony import */ var _localizablestring__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./localizablestring */ "./src/localizablestring.ts");
/* harmony import */ var _jsonobject__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./jsonobject */ "./src/jsonobject.ts");
/* harmony import */ var _helpers__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./helpers */ "./src/helpers.ts");
/* harmony import */ var _conditions__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./conditions */ "./src/conditions.ts");
/* harmony import */ var _base__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./base */ "./src/base.ts");
/* harmony import */ var _settings__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./settings */ "./src/settings.ts");
var __extends = (undefined && undefined.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __spreadArray = (undefined && undefined.__spreadArray) || function (to, from, pack) {
    if (pack || arguments.length === 2) for (var i = 0, l = from.length, ar; i < l; i++) {
        if (ar || !(i in from)) {
            if (!ar) ar = Array.prototype.slice.call(from, 0, i);
            ar[i] = from[i];
        }
    }
    return to.concat(ar || Array.prototype.slice.call(from));
};






/**
 * Array of ItemValue is used in checkox, dropdown and radiogroup choices, matrix columns and rows.
 * It has two main properties: value and text. If text is empty, value is used for displaying.
 * The text property is localizable and support markdown.
 */
var ItemValue = /** @class */ (function (_super) {
    __extends(ItemValue, _super);
    function ItemValue(value, text, typeName) {
        if (text === void 0) { text = null; }
        if (typeName === void 0) { typeName = "itemvalue"; }
        var _this = _super.call(this) || this;
        _this.typeName = typeName;
        _this.ownerPropertyName = "";
        _this.isVisibleValue = true;
        _this.locTextValue = new _localizablestring__WEBPACK_IMPORTED_MODULE_0__["LocalizableString"](_this, true, "text");
        _this.locTextValue.onStrChanged = function (oldValue, newValue) {
            if (newValue == _this.value) {
                newValue = undefined;
            }
            _this.propertyValueChanged("text", oldValue, newValue);
        };
        _this.locTextValue.onGetTextCallback = function (txt) {
            return txt
                ? txt
                : !_helpers__WEBPACK_IMPORTED_MODULE_2__["Helpers"].isValueEmpty(_this.value)
                    ? _this.value.toString()
                    : null;
        };
        if (text)
            _this.locText.text = text;
        if (!!value && typeof value === "object") {
            _this.setData(value);
        }
        else {
            _this.value = value;
        }
        if (_this.getType() != "itemvalue") {
            _jsonobject__WEBPACK_IMPORTED_MODULE_1__["CustomPropertiesCollection"].createProperties(_this);
        }
        _this.onCreating();
        return _this;
    }
    ItemValue.prototype.getMarkdownHtml = function (text, name) {
        return !!this.locOwner ? this.locOwner.getMarkdownHtml(text, name) : null;
    };
    ItemValue.prototype.getRenderer = function (name) {
        return !!this.locOwner ? this.locOwner.getRenderer(name) : null;
    };
    ItemValue.prototype.getRendererContext = function (locStr) {
        return !!this.locOwner ? this.locOwner.getRendererContext(locStr) : locStr;
    };
    ItemValue.prototype.getProcessedText = function (text) {
        return this.locOwner ? this.locOwner.getProcessedText(text) : text;
    };
    Object.defineProperty(ItemValue, "Separator", {
        get: function () {
            return _settings__WEBPACK_IMPORTED_MODULE_5__["settings"].itemValueSeparator;
        },
        set: function (val) {
            _settings__WEBPACK_IMPORTED_MODULE_5__["settings"].itemValueSeparator = val;
        },
        enumerable: false,
        configurable: true
    });
    ItemValue.createArray = function (locOwner) {
        var items = [];
        ItemValue.setupArray(items, locOwner);
        return items;
    };
    ItemValue.setupArray = function (items, locOwner) {
        items.push = function (value) {
            var result = Array.prototype.push.call(this, value);
            value.locOwner = locOwner;
            return result;
        };
        items.unshift = function (value) {
            var result = Array.prototype.unshift.call(this, value);
            value.locOwner = locOwner;
            return result;
        };
        items.splice = function (start, deleteCount) {
            var _a;
            var items = [];
            for (var _i = 2; _i < arguments.length; _i++) {
                items[_i - 2] = arguments[_i];
            }
            var result = (_a = Array.prototype.splice).call.apply(_a, __spreadArray([this,
                start,
                deleteCount], items, false));
            if (!items)
                items = [];
            for (var i = 0; i < items.length; i++) {
                items[i].locOwner = locOwner;
            }
            return result;
        };
    };
    /**
     * Resets the input array and fills it with values from the values array
     */
    ItemValue.setData = function (items, values, type) {
        items.length = 0;
        for (var i = 0; i < values.length; i++) {
            var value = values[i];
            var itemType = !!value && typeof value.getType === "function" ? value.getType() : (type !== null && type !== void 0 ? type : "itemvalue");
            var item = _jsonobject__WEBPACK_IMPORTED_MODULE_1__["Serializer"].createClass(itemType);
            item.setData(value);
            if (!!value.originalItem) {
                item.originalItem = value.originalItem;
            }
            items.push(item);
        }
    };
    ItemValue.getData = function (items) {
        var result = [];
        for (var i = 0; i < items.length; i++) {
            result.push(items[i].getData());
        }
        return result;
    };
    ItemValue.getItemByValue = function (items, val) {
        if (!Array.isArray(items))
            return null;
        var valIsEmpty = _helpers__WEBPACK_IMPORTED_MODULE_2__["Helpers"].isValueEmpty(val);
        for (var i = 0; i < items.length; i++) {
            if (valIsEmpty && _helpers__WEBPACK_IMPORTED_MODULE_2__["Helpers"].isValueEmpty(items[i].value))
                return items[i];
            if (_helpers__WEBPACK_IMPORTED_MODULE_2__["Helpers"].isTwoValueEquals(items[i].value, val, false, true, false))
                return items[i];
        }
        return null;
    };
    ItemValue.getTextOrHtmlByValue = function (items, val) {
        var item = ItemValue.getItemByValue(items, val);
        return item !== null ? item.locText.textOrHtml : "";
    };
    ItemValue.locStrsChanged = function (items) {
        for (var i = 0; i < items.length; i++) {
            items[i].locStrsChanged();
        }
    };
    ItemValue.runConditionsForItems = function (items, filteredItems, runner, values, properties, useItemExpression, onItemCallBack) {
        if (useItemExpression === void 0) { useItemExpression = true; }
        return ItemValue.runConditionsForItemsCore(items, filteredItems, runner, values, properties, true, useItemExpression, onItemCallBack);
    };
    ItemValue.runEnabledConditionsForItems = function (items, runner, values, properties, onItemCallBack) {
        return ItemValue.runConditionsForItemsCore(items, null, runner, values, properties, false, true, onItemCallBack);
    };
    ItemValue.runConditionsForItemsCore = function (items, filteredItems, runner, values, properties, isVisible, useItemExpression, onItemCallBack) {
        if (useItemExpression === void 0) { useItemExpression = true; }
        if (!values) {
            values = {};
        }
        var itemValue = values["item"];
        var choiceValue = values["choice"];
        var hasChanded = false;
        for (var i = 0; i < items.length; i++) {
            var item = items[i];
            values["item"] = item.value;
            values["choice"] = item.value;
            var itemRunner = useItemExpression && !!item.getConditionRunner
                ? item.getConditionRunner(isVisible)
                : false;
            if (!itemRunner) {
                itemRunner = runner;
            }
            var newValue = true;
            if (itemRunner) {
                newValue = itemRunner.run(values, properties);
            }
            if (!!onItemCallBack) {
                newValue = onItemCallBack(item, newValue);
            }
            if (!!filteredItems && newValue) {
                filteredItems.push(item);
            }
            var oldValue = isVisible ? item.isVisible : item.isEnabled;
            if (newValue != oldValue) {
                hasChanded = true;
                if (isVisible) {
                    if (!!item.setIsVisible)
                        item.setIsVisible(newValue);
                }
                else {
                    if (!!item.setIsEnabled)
                        item.setIsEnabled(newValue);
                }
            }
        }
        if (itemValue) {
            values["item"] = itemValue;
        }
        else {
            delete values["item"];
        }
        if (choiceValue) {
            values["choice"] = choiceValue;
        }
        else {
            delete values["choice"];
        }
        return hasChanded;
    };
    ItemValue.prototype.onCreating = function () { };
    ItemValue.prototype.getType = function () {
        return !!this.typeName ? this.typeName : "itemvalue";
    };
    ItemValue.prototype.getSurvey = function (live) {
        if (live === void 0) { live = false; }
        return !!this.locOwner && !!this.locOwner["getSurvey"]
            ? this.locOwner.getSurvey()
            : null;
    };
    ItemValue.prototype.getLocale = function () {
        return !!this.locOwner && this.locOwner.getLocale ? this.locOwner.getLocale() : "";
    };
    Object.defineProperty(ItemValue.prototype, "locText", {
        get: function () {
            return this.locTextValue;
        },
        enumerable: false,
        configurable: true
    });
    ItemValue.prototype.setLocText = function (locText) {
        this.locTextValue = locText;
    };
    Object.defineProperty(ItemValue.prototype, "locOwner", {
        get: function () {
            return this._locOwner;
        },
        set: function (value) {
            this._locOwner = value;
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(ItemValue.prototype, "value", {
        get: function () {
            return this.getPropertyValue("value");
        },
        set: function (newValue) {
            var text = undefined;
            if (!_helpers__WEBPACK_IMPORTED_MODULE_2__["Helpers"].isValueEmpty(newValue)) {
                var str = newValue.toString();
                var index = str.indexOf(_settings__WEBPACK_IMPORTED_MODULE_5__["settings"].itemValueSeparator);
                if (index > -1) {
                    newValue = str.slice(0, index);
                    text = str.slice(index + 1);
                }
            }
            this.setPropertyValue("value", newValue);
            if (!!text) {
                this.text = text;
            }
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(ItemValue.prototype, "hasText", {
        get: function () {
            return this.locText.pureText ? true : false;
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(ItemValue.prototype, "pureText", {
        get: function () {
            return this.locText.pureText;
        },
        set: function (val) {
            this.text = val;
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(ItemValue.prototype, "text", {
        get: function () {
            return this.locText.calculatedText; //TODO: it will be correct to use this.locText.text, however it would require a lot of rewriting in Creator
        },
        set: function (newText) {
            this.locText.text = newText;
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(ItemValue.prototype, "calculatedText", {
        get: function () {
            return this.locText.calculatedText;
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(ItemValue.prototype, "shortcutText", {
        get: function () {
            return this.text;
        },
        enumerable: false,
        configurable: true
    });
    ItemValue.prototype.getData = function () {
        var json = this.toJSON();
        if (!!json["value"] && !!json["value"]["pos"]) {
            delete json["value"]["pos"];
        }
        if (_helpers__WEBPACK_IMPORTED_MODULE_2__["Helpers"].isValueEmpty(json.value))
            return json;
        var canSerializeAsContant = !_settings__WEBPACK_IMPORTED_MODULE_5__["settings"].itemValueAlwaysSerializeAsObject && !_settings__WEBPACK_IMPORTED_MODULE_5__["settings"].itemValueAlwaysSerializeText;
        if (canSerializeAsContant && Object.keys(json).length == 1)
            return this.value;
        if (_settings__WEBPACK_IMPORTED_MODULE_5__["settings"].itemValueAlwaysSerializeText && json.text === undefined) {
            json.text = this.value.toString();
        }
        return json;
    };
    ItemValue.prototype.toJSON = function () {
        var res = {};
        var properties = _jsonobject__WEBPACK_IMPORTED_MODULE_1__["Serializer"].getProperties(this.getType());
        if (!properties || properties.length == 0) {
            properties = _jsonobject__WEBPACK_IMPORTED_MODULE_1__["Serializer"].getProperties("itemvalue");
        }
        var jsoObj = new _jsonobject__WEBPACK_IMPORTED_MODULE_1__["JsonObject"]();
        for (var i = 0; i < properties.length; i++) {
            var prop = properties[i];
            if (prop.name === "text" && !this.locText.hasNonDefaultText() &&
                _helpers__WEBPACK_IMPORTED_MODULE_2__["Helpers"].isTwoValueEquals(this.value, this.text, false, true, false))
                continue;
            jsoObj.valueToJson(this, res, prop);
        }
        return res;
    };
    ItemValue.prototype.setData = function (value) {
        if (_helpers__WEBPACK_IMPORTED_MODULE_2__["Helpers"].isValueEmpty(value))
            return;
        if (typeof value.value !== "undefined") {
            var json = void 0;
            if (typeof value.toJSON === "function") {
                json = value.toJSON();
            }
            else {
                json = value;
            }
            new _jsonobject__WEBPACK_IMPORTED_MODULE_1__["JsonObject"]().toObject(json, this);
        }
        else {
            this.value = value;
        }
        this.locText.strChanged();
    };
    Object.defineProperty(ItemValue.prototype, "visibleIf", {
        get: function () {
            return this.getPropertyValue("visibleIf", "");
        },
        set: function (val) {
            this.setPropertyValue("visibleIf", val);
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(ItemValue.prototype, "enableIf", {
        get: function () {
            return this.getPropertyValue("enableIf", "");
        },
        set: function (val) {
            this.setPropertyValue("enableIf", val);
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(ItemValue.prototype, "isVisible", {
        get: function () {
            return this.isVisibleValue;
        },
        enumerable: false,
        configurable: true
    });
    ItemValue.prototype.setIsVisible = function (val) {
        this.isVisibleValue = val;
    };
    Object.defineProperty(ItemValue.prototype, "isEnabled", {
        get: function () {
            return this.getPropertyValue("isEnabled", true);
        },
        enumerable: false,
        configurable: true
    });
    ItemValue.prototype.setIsEnabled = function (val) {
        this.setPropertyValue("isEnabled", val);
    };
    ItemValue.prototype.addUsedLocales = function (locales) {
        this.AddLocStringToUsedLocales(this.locTextValue, locales);
    };
    ItemValue.prototype.locStrsChanged = function () {
        _super.prototype.locStrsChanged.call(this);
        this.locText.strChanged();
    };
    ItemValue.prototype.onPropertyValueChanged = function (name, oldValue, newValue) {
        if (name === "value" && !this.hasText) {
            this.locText.onChanged();
        }
        var funcName = "itemValuePropertyChanged";
        if (!this.locOwner || !this.locOwner[funcName])
            return;
        this.locOwner[funcName](this, name, oldValue, newValue);
    };
    ItemValue.prototype.getConditionRunner = function (isVisible) {
        if (isVisible)
            return this.getVisibleConditionRunner();
        return this.getEnableConditionRunner();
    };
    ItemValue.prototype.getVisibleConditionRunner = function () {
        if (!this.visibleIf)
            return null;
        if (!this.visibleConditionRunner)
            this.visibleConditionRunner = new _conditions__WEBPACK_IMPORTED_MODULE_3__["ConditionRunner"](this.visibleIf);
        this.visibleConditionRunner.expression = this.visibleIf;
        return this.visibleConditionRunner;
    };
    ItemValue.prototype.getEnableConditionRunner = function () {
        if (!this.enableIf)
            return null;
        if (!this.enableConditionRunner)
            this.enableConditionRunner = new _conditions__WEBPACK_IMPORTED_MODULE_3__["ConditionRunner"](this.enableIf);
        this.enableConditionRunner.expression = this.enableIf;
        return this.enableConditionRunner;
    };
    return ItemValue;
}(_base__WEBPACK_IMPORTED_MODULE_4__["Base"]));

_base__WEBPACK_IMPORTED_MODULE_4__["Base"].createItemValue = function (source, type) {
    var item = null;
    if (!!type) {
        item = _jsonobject__WEBPACK_IMPORTED_MODULE_1__["JsonObject"].metaData.createClass(type, {});
    }
    else if (typeof source.getType === "function") {
        item = new ItemValue(null, undefined, source.getType());
    }
    else {
        item = new ItemValue(null);
    }
    item.setData(source);
    return item;
};
_base__WEBPACK_IMPORTED_MODULE_4__["Base"].itemValueLocStrChanged = function (arr) {
    ItemValue.locStrsChanged(arr);
};
_jsonobject__WEBPACK_IMPORTED_MODULE_1__["JsonObjectProperty"].getItemValuesDefaultValue = function (val, type) {
    var res = new Array();
    ItemValue.setData(res, Array.isArray(val) ? val : [], type);
    return res;
};
_jsonobject__WEBPACK_IMPORTED_MODULE_1__["Serializer"].addClass("itemvalue", [
    "!value",
    {
        name: "text",
        serializationProperty: "locText",
    },
    { name: "visibleIf:condition", showMode: "form" },
    {
        name: "enableIf:condition",
        showMode: "form",
        visibleIf: function (obj) {
            return !obj || obj.ownerPropertyName !== "rateValues";
        },
    },
], function (value) { return new ItemValue(value); });


/***/ }),

/***/ "./src/jsonobject.ts":
/*!***************************!*\
  !*** ./src/jsonobject.ts ***!
  \***************************/
/*! exports provided: property, propertyArray, JsonObjectProperty, CustomPropertiesCollection, JsonMetadataClass, JsonMetadata, JsonError, JsonUnknownPropertyError, JsonMissingTypeErrorBase, JsonMissingTypeError, JsonIncorrectTypeError, JsonRequiredPropertyError, JsonObject, Serializer */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "property", function() { return property; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "propertyArray", function() { return propertyArray; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "JsonObjectProperty", function() { return JsonObjectProperty; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "CustomPropertiesCollection", function() { return CustomPropertiesCollection; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "JsonMetadataClass", function() { return JsonMetadataClass; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "JsonMetadata", function() { return JsonMetadata; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "JsonError", function() { return JsonError; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "JsonUnknownPropertyError", function() { return JsonUnknownPropertyError; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "JsonMissingTypeErrorBase", function() { return JsonMissingTypeErrorBase; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "JsonMissingTypeError", function() { return JsonMissingTypeError; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "JsonIncorrectTypeError", function() { return JsonIncorrectTypeError; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "JsonRequiredPropertyError", function() { return JsonRequiredPropertyError; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "JsonObject", function() { return JsonObject; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "Serializer", function() { return Serializer; });
/* harmony import */ var _surveyStrings__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./surveyStrings */ "./src/surveyStrings.ts");
/* harmony import */ var _base__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./base */ "./src/base.ts");
/* harmony import */ var _helpers__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./helpers */ "./src/helpers.ts");
var __extends = (undefined && undefined.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __spreadArray = (undefined && undefined.__spreadArray) || function (to, from, pack) {
    if (pack || arguments.length === 2) for (var i = 0, l = from.length, ar; i < l; i++) {
        if (ar || !(i in from)) {
            if (!ar) ar = Array.prototype.slice.call(from, 0, i);
            ar[i] = from[i];
        }
    }
    return to.concat(ar || Array.prototype.slice.call(from));
};



function ensureLocString(target, options, key) {
    var locString = target.getLocalizableString(key);
    if (!locString) {
        locString = target.createLocalizableString(key, target, true);
        if (typeof options.localizable === "object" &&
            typeof options.localizable.onGetTextCallback === "function") {
            locString.onGetTextCallback = options.localizable.onGetTextCallback;
        }
    }
}
function getLocStringValue(target, options, key) {
    ensureLocString(target, options, key);
    var res = target.getLocalizableStringText(key);
    if (!!res)
        return res;
    if (typeof options.localizable === "object" && options.localizable.defaultStr)
        return _surveyStrings__WEBPACK_IMPORTED_MODULE_0__["surveyLocalization"].getString(options.localizable.defaultStr);
    return "";
}
function property(options) {
    return function (target, key) {
        var processComputedUpdater = function (obj, val) {
            if (!!val && typeof val === "object" && val.type === _base__WEBPACK_IMPORTED_MODULE_1__["ComputedUpdater"].ComputedUpdaterType) {
                _base__WEBPACK_IMPORTED_MODULE_1__["Base"].startCollectDependencies(function () { return obj[key] = val.updater(); }, obj, key);
                var result = val.updater();
                var dependencies = _base__WEBPACK_IMPORTED_MODULE_1__["Base"].finishCollectDependencies();
                val.setDependencies(dependencies);
                return result;
            }
            return val;
        };
        if (!options || !options.localizable) {
            Object.defineProperty(target, key, {
                get: function () {
                    var value = this.getPropertyValue(key);
                    if (value !== undefined) {
                        return value;
                    }
                    if (!!options) {
                        if (typeof options.getDefaultValue === "function") {
                            return options.getDefaultValue(this);
                        }
                        if (options.defaultValue !== undefined) {
                            return options.defaultValue;
                        }
                    }
                    return undefined;
                },
                set: function (val) {
                    var newValue = processComputedUpdater(this, val);
                    this.setPropertyValue(key, newValue);
                    if (!!options && options.onSet) {
                        options.onSet(newValue, this);
                    }
                },
            });
        }
        else {
            Object.defineProperty(target, key, {
                get: function () {
                    return getLocStringValue(this, options, key);
                },
                set: function (val) {
                    ensureLocString(this, options, key);
                    var newValue = processComputedUpdater(this, val);
                    this.setLocalizableStringText(key, newValue);
                    if (!!options && options.onSet) {
                        options.onSet(newValue, this);
                    }
                },
            });
            Object.defineProperty(target, typeof options.localizable === "object" && !!options.localizable.name ?
                options.localizable.name : "loc" + key.charAt(0).toUpperCase() + key.slice(1), {
                get: function () {
                    ensureLocString(this, options, key);
                    return this.getLocalizableString(key);
                },
            });
        }
    };
}
function ensureArray(target, options, key) {
    target.ensureArray(key, function (item, index) {
        var handler = !!options ? options.onPush : null;
        handler && handler(item, index, target);
    }, function (item, index) {
        var handler = !!options ? options.onRemove : null;
        handler && handler(item, index, target);
    });
}
function propertyArray(options) {
    return function (target, key) {
        Object.defineProperty(target, key, {
            get: function () {
                ensureArray(this, options, key);
                return this.getPropertyValue(key);
            },
            set: function (val) {
                ensureArray(this, options, key);
                var arr = this.getPropertyValue(key);
                if (val === arr) {
                    return;
                }
                if (arr) {
                    arr.splice.apply(arr, __spreadArray([0, arr.length], (val || []), false));
                }
                else {
                    this.setPropertyValue(key, val);
                }
                if (!!options && options.onSet) {
                    options.onSet(val, this);
                }
            },
        });
    };
}
/**
 * Contains information about a property of a survey element (page, panel, questions, and etc).
 * @see addProperty
 * @see removeProperty
 * @see [Add Properties](https://surveyjs.io/Documentation/Survey-Creator#addproperties)
 * @see [Remove Properties](https://surveyjs.io/Documentation/Survey-Creator#removeproperties)
 */
var JsonObjectProperty = /** @class */ (function () {
    function JsonObjectProperty(classInfo, name, isRequired) {
        if (isRequired === void 0) { isRequired = false; }
        this.name = name;
        this.typeValue = null;
        this.choicesValue = null;
        this.baseValue = null;
        this.isRequiredValue = false;
        this.isUniqueValue = false;
        this.readOnlyValue = null;
        this.visibleValue = null;
        this.isLocalizableValue = null;
        this.choicesfunc = null;
        this.dependedProperties = null;
        this.isSerializable = true;
        this.isLightSerializable = true;
        this.isCustom = false;
        this.isDynamicChoices = false; //TODO obsolete, use dependsOn attribute
        this.isBindable = false;
        this.className = null;
        this.alternativeName = null;
        this.classNamePart = null;
        this.baseClassName = null;
        this.defaultValueValue = null;
        this.serializationProperty = null;
        this.displayName = null;
        this.category = "";
        this.categoryIndex = -1;
        this.visibleIndex = -1;
        this.nextToProperty = null;
        this.showMode = null;
        this.maxLength = -1;
        this.layout = null;
        this.onGetValue = null;
        this.onSetValue = null;
        this.visibleIf = null;
        this.isArray = false;
        this.classInfoValue = classInfo;
        this.isRequiredValue = isRequired;
        this.idValue = JsonObjectProperty.Index++;
    }
    Object.defineProperty(JsonObjectProperty.prototype, "id", {
        get: function () {
            return this.idValue;
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(JsonObjectProperty.prototype, "classInfo", {
        get: function () {
            return this.classInfoValue;
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(JsonObjectProperty.prototype, "type", {
        get: function () {
            return this.typeValue ? this.typeValue : "string";
        },
        set: function (value) {
            if (value === "itemvalues")
                value = "itemvalue[]";
            this.typeValue = value;
            if (this.typeValue.indexOf("[]") === this.typeValue.length - 2) {
                this.isArray = true;
                this.className = this.typeValue.substr(0, this.typeValue.length - 2);
            }
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(JsonObjectProperty.prototype, "isRequired", {
        get: function () {
            return this.isRequiredValue;
        },
        set: function (val) {
            this.isRequiredValue = val;
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(JsonObjectProperty.prototype, "isUnique", {
        get: function () {
            return this.isUniqueValue;
        },
        set: function (val) {
            this.isUniqueValue = val;
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(JsonObjectProperty.prototype, "hasToUseGetValue", {
        get: function () {
            return this.onGetValue || this.serializationProperty;
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(JsonObjectProperty.prototype, "defaultValue", {
        get: function () {
            var result = this.defaultValueValue;
            if (!!JsonObjectProperty.getItemValuesDefaultValue &&
                JsonObject.metaData.isDescendantOf(this.className, "itemvalue")) {
                result = JsonObjectProperty.getItemValuesDefaultValue(this.defaultValueValue || [], this.className);
            }
            return result;
        },
        set: function (newValue) {
            this.defaultValueValue = newValue;
        },
        enumerable: false,
        configurable: true
    });
    JsonObjectProperty.prototype.isDefaultValue = function (value) {
        if (!_helpers__WEBPACK_IMPORTED_MODULE_2__["Helpers"].isValueEmpty(this.defaultValue)) {
            return _helpers__WEBPACK_IMPORTED_MODULE_2__["Helpers"].isTwoValueEquals(value, this.defaultValue, false, true, false);
        }
        return ((value === false && (this.type == "boolean" || this.type == "switch")) ||
            value === "" ||
            _helpers__WEBPACK_IMPORTED_MODULE_2__["Helpers"].isValueEmpty(value));
    };
    JsonObjectProperty.prototype.getValue = function (obj) {
        if (this.onGetValue)
            return this.onGetValue(obj);
        if (this.serializationProperty && !!obj[this.serializationProperty])
            return obj[this.serializationProperty].getJson();
        return obj[this.name];
    };
    JsonObjectProperty.prototype.getPropertyValue = function (obj) {
        if (this.isLocalizable) {
            return !!obj[this.serializationProperty]
                ? obj[this.serializationProperty].text
                : null;
        }
        return this.getValue(obj);
    };
    Object.defineProperty(JsonObjectProperty.prototype, "hasToUseSetValue", {
        get: function () {
            return this.onSetValue || this.serializationProperty;
        },
        enumerable: false,
        configurable: true
    });
    JsonObjectProperty.prototype.setValue = function (obj, value, jsonConv) {
        if (this.onSetValue) {
            this.onSetValue(obj, value, jsonConv);
        }
        else {
            if (this.serializationProperty && !!obj[this.serializationProperty])
                obj[this.serializationProperty].setJson(value);
            else {
                if (value && typeof value === "string") {
                    if (this.type == "number") {
                        value = parseInt(value);
                    }
                    if (this.type == "boolean" || this.type == "switch") {
                        value = value.toLowerCase() === "true";
                    }
                }
                obj[this.name] = value;
            }
        }
    };
    JsonObjectProperty.prototype.getObjType = function (objType) {
        if (!this.classNamePart)
            return objType;
        return objType.replace(this.classNamePart, "");
    };
    JsonObjectProperty.prototype.getClassName = function (className) {
        if (className)
            className = className.toLowerCase();
        return this.classNamePart && className.indexOf(this.classNamePart) < 0
            ? className + this.classNamePart
            : className;
    };
    Object.defineProperty(JsonObjectProperty.prototype, "choices", {
        /**
         * Depricated, please use getChoices
         */
        get: function () {
            return this.getChoices(null);
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(JsonObjectProperty.prototype, "hasChoices", {
        get: function () {
            return !!this.choicesValue || !!this.choicesfunc;
        },
        enumerable: false,
        configurable: true
    });
    JsonObjectProperty.prototype.getChoices = function (obj, choicesCallback) {
        if (choicesCallback === void 0) { choicesCallback = null; }
        if (this.choicesValue != null)
            return this.choicesValue;
        if (this.choicesfunc != null)
            return this.choicesfunc(obj, choicesCallback);
        return null;
    };
    JsonObjectProperty.prototype.setChoices = function (value, valueFunc) {
        if (valueFunc === void 0) { valueFunc = null; }
        this.choicesValue = value;
        this.choicesfunc = valueFunc;
    };
    JsonObjectProperty.prototype.getBaseValue = function () {
        if (!this.baseValue)
            return "";
        if (typeof this.baseValue == "function")
            return this.baseValue();
        return this.baseValue;
    };
    JsonObjectProperty.prototype.setBaseValue = function (val) {
        this.baseValue = val;
    };
    Object.defineProperty(JsonObjectProperty.prototype, "readOnly", {
        get: function () {
            return this.readOnlyValue != null ? this.readOnlyValue : false;
        },
        set: function (val) {
            this.readOnlyValue = val;
        },
        enumerable: false,
        configurable: true
    });
    JsonObjectProperty.prototype.isVisible = function (layout, obj) {
        if (obj === void 0) { obj = null; }
        var isLayout = !this.layout || this.layout == layout;
        if (!this.visible || !isLayout)
            return false;
        if (!!this.visibleIf && !!obj)
            return this.visibleIf(obj);
        return true;
    };
    Object.defineProperty(JsonObjectProperty.prototype, "visible", {
        get: function () {
            return this.visibleValue != null ? this.visibleValue : true;
        },
        set: function (val) {
            this.visibleValue = val;
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(JsonObjectProperty.prototype, "isLocalizable", {
        get: function () {
            return this.isLocalizableValue != null ? this.isLocalizableValue : false;
        },
        set: function (val) {
            this.isLocalizableValue = val;
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(JsonObjectProperty.prototype, "dataList", {
        get: function () {
            return Array.isArray(this.dataListValue) ? this.dataListValue : [];
        },
        set: function (val) {
            this.dataListValue = val;
        },
        enumerable: false,
        configurable: true
    });
    JsonObjectProperty.prototype.mergeWith = function (prop) {
        var valuesNames = JsonObjectProperty.mergableValues;
        for (var i = 0; i < valuesNames.length; i++) {
            this.mergeValue(prop, valuesNames[i]);
        }
    };
    JsonObjectProperty.prototype.addDependedProperty = function (name) {
        if (!this.dependedProperties) {
            this.dependedProperties = [];
        }
        if (this.dependedProperties.indexOf(name) < 0) {
            this.dependedProperties.push(name);
        }
    };
    JsonObjectProperty.prototype.getDependedProperties = function () {
        return !!this.dependedProperties ? this.dependedProperties : [];
    };
    JsonObjectProperty.prototype.schemaType = function () {
        if (!!this.className)
            return "array";
        if (!!this.baseClassName)
            return "array";
        if (this.type == "boolean" || this.type == "number")
            return this.type;
        return "string";
    };
    JsonObjectProperty.prototype.mergeValue = function (prop, valueName) {
        if (this[valueName] == null && prop[valueName] != null) {
            this[valueName] = prop[valueName];
        }
    };
    JsonObjectProperty.Index = 1;
    JsonObjectProperty.mergableValues = [
        "typeValue",
        "choicesValue",
        "baseValue",
        "readOnlyValue",
        "visibleValue",
        "isSerializable",
        "isLightSerializable",
        "isCustom",
        "isBindable",
        "isUnique",
        "isDynamicChoices",
        "isLocalizableValue",
        "className",
        "alternativeName",
        "layout",
        "classNamePart",
        "baseClassName",
        "defaultValue",
        "serializationProperty",
        "onGetValue",
        "onSetValue",
        "displayName",
        "category",
        "categoryIndex",
        "visibleIndex",
        "nextToProperty",
        "showMode",
        "dependedProperties",
        "visibleIf",
        "onPropertyEditorUpdate",
        "maxLength",
        "maxValue",
        "minValue",
        "dataListValue",
    ];
    return JsonObjectProperty;
}());

var CustomPropertiesCollection = /** @class */ (function () {
    function CustomPropertiesCollection() {
    }
    CustomPropertiesCollection.addProperty = function (className, property) {
        className = className.toLowerCase();
        var props = CustomPropertiesCollection.properties;
        if (!props[className]) {
            props[className] = [];
        }
        props[className].push(property);
    };
    CustomPropertiesCollection.removeProperty = function (className, propertyName) {
        className = className.toLowerCase();
        var props = CustomPropertiesCollection.properties;
        if (!props[className])
            return;
        var properties = props[className];
        for (var i = 0; i < properties.length; i++) {
            if (properties[i].name == propertyName) {
                props[className].splice(i, 1);
                break;
            }
        }
    };
    CustomPropertiesCollection.addClass = function (className, parentClassName) {
        className = className.toLowerCase();
        if (parentClassName) {
            parentClassName = parentClassName.toLowerCase();
        }
        CustomPropertiesCollection.parentClasses[className] = parentClassName;
    };
    CustomPropertiesCollection.getProperties = function (className) {
        className = className.toLowerCase();
        var res = [];
        var props = CustomPropertiesCollection.properties;
        while (className) {
            var properties = props[className];
            if (properties) {
                for (var i = 0; i < properties.length; i++) {
                    res.push(properties[i]);
                }
            }
            className = CustomPropertiesCollection.parentClasses[className];
        }
        return res;
    };
    CustomPropertiesCollection.createProperties = function (obj) {
        if (!obj || !obj.getType)
            return;
        CustomPropertiesCollection.createPropertiesCore(obj, obj.getType());
    };
    CustomPropertiesCollection.createPropertiesCore = function (obj, className) {
        var props = CustomPropertiesCollection.properties;
        if (props[className]) {
            CustomPropertiesCollection.createPropertiesInObj(obj, props[className]);
        }
        var parentClass = CustomPropertiesCollection.parentClasses[className];
        if (parentClass) {
            CustomPropertiesCollection.createPropertiesCore(obj, parentClass);
        }
    };
    CustomPropertiesCollection.createPropertiesInObj = function (obj, properties) {
        for (var i = 0; i < properties.length; i++) {
            CustomPropertiesCollection.createPropertyInObj(obj, properties[i]);
        }
    };
    CustomPropertiesCollection.createPropertyInObj = function (obj, prop) {
        if (obj[prop.name] || obj.hasOwnProperty(prop.name))
            return;
        if (prop.isLocalizable &&
            prop.serializationProperty &&
            !obj[prop.serializationProperty] &&
            obj.createCustomLocalizableObj) {
            obj.createCustomLocalizableObj(prop.name);
            var locDesc = {
                get: function () {
                    return obj.getLocalizableString(prop.name);
                },
            };
            Object.defineProperty(obj, prop.serializationProperty, locDesc);
            var desc = {
                get: function () {
                    return obj.getLocalizableStringText(prop.name, prop.defaultValue);
                },
                set: function (v) {
                    obj.setLocalizableStringText(prop.name, v);
                },
            };
            Object.defineProperty(obj, prop.name, desc);
        }
        else {
            var defaultValue = prop.defaultValue;
            var isArrayProp = false;
            if (typeof obj.createNewArray === "function") {
                if (JsonObject.metaData.isDescendantOf(prop.className, "itemvalue")) {
                    obj.createNewArray(prop.name, function (item) {
                        item.locOwner = obj;
                        item.ownerPropertyName = prop.name;
                    });
                    isArrayProp = true;
                }
                //It is a simple array property
                if (prop.type === "multiplevalues") {
                    obj.createNewArray(prop.name);
                    isArrayProp = true;
                }
                if (isArrayProp) {
                    if (Array.isArray(defaultValue)) {
                        obj.setPropertyValue(prop.name, defaultValue);
                    }
                    defaultValue = null;
                }
            }
            if (!!obj.getPropertyValue && !!obj.setPropertyValue) {
                var desc = {
                    get: function () {
                        if (!!prop.onGetValue) {
                            return prop.onGetValue(obj);
                        }
                        return obj.getPropertyValue(prop.name, defaultValue);
                    },
                    set: function (v) {
                        if (!!prop.onSetValue) {
                            prop.onSetValue(obj, v, null);
                        }
                        else {
                            obj.setPropertyValue(prop.name, v);
                        }
                    },
                };
                Object.defineProperty(obj, prop.name, desc);
            }
        }
    };
    CustomPropertiesCollection.properties = {};
    CustomPropertiesCollection.parentClasses = {};
    return CustomPropertiesCollection;
}());

var JsonMetadataClass = /** @class */ (function () {
    function JsonMetadataClass(name, properties, creator, parentName) {
        if (creator === void 0) { creator = null; }
        if (parentName === void 0) { parentName = null; }
        this.name = name;
        this.creator = creator;
        this.parentName = parentName;
        this.properties = null;
        name = name.toLowerCase();
        if (this.parentName) {
            this.parentName = this.parentName.toLowerCase();
            CustomPropertiesCollection.addClass(name, this.parentName);
        }
        this.properties = new Array();
        for (var i = 0; i < properties.length; i++) {
            var prop = this.createProperty(properties[i]);
            if (prop) {
                this.properties.push(prop);
            }
        }
    }
    JsonMetadataClass.prototype.find = function (name) {
        for (var i = 0; i < this.properties.length; i++) {
            if (this.properties[i].name == name)
                return this.properties[i];
        }
        return null;
    };
    JsonMetadataClass.prototype.createProperty = function (propInfo) {
        var propertyName = typeof propInfo === "string" ? propInfo : propInfo.name;
        if (!propertyName)
            return;
        var propertyType = null;
        var typeIndex = propertyName.indexOf(JsonMetadataClass.typeSymbol);
        if (typeIndex > -1) {
            propertyType = propertyName.substring(typeIndex + 1);
            propertyName = propertyName.substring(0, typeIndex);
        }
        var isRequired = this.getIsPropertyNameRequired(propertyName) || !!propInfo.isRequired;
        propertyName = this.getPropertyName(propertyName);
        var prop = new JsonObjectProperty(this, propertyName, isRequired);
        if (propertyType) {
            prop.type = propertyType;
        }
        if (typeof propInfo === "object") {
            if (propInfo.type) {
                prop.type = propInfo.type;
            }
            if (!_helpers__WEBPACK_IMPORTED_MODULE_2__["Helpers"].isValueEmpty(propInfo.default)) {
                prop.defaultValue = propInfo.default;
            }
            if (!_helpers__WEBPACK_IMPORTED_MODULE_2__["Helpers"].isValueEmpty(propInfo.isSerializable)) {
                prop.isSerializable = propInfo.isSerializable;
            }
            if (!_helpers__WEBPACK_IMPORTED_MODULE_2__["Helpers"].isValueEmpty(propInfo.isLightSerializable)) {
                prop.isLightSerializable = propInfo.isLightSerializable;
            }
            if (!_helpers__WEBPACK_IMPORTED_MODULE_2__["Helpers"].isValueEmpty(propInfo.maxLength)) {
                prop.maxLength = propInfo.maxLength;
            }
            if (!_helpers__WEBPACK_IMPORTED_MODULE_2__["Helpers"].isValueEmpty(propInfo.displayName)) {
                prop.displayName = propInfo.displayName;
            }
            if (!_helpers__WEBPACK_IMPORTED_MODULE_2__["Helpers"].isValueEmpty(propInfo.category)) {
                prop.category = propInfo.category;
            }
            if (!_helpers__WEBPACK_IMPORTED_MODULE_2__["Helpers"].isValueEmpty(propInfo.categoryIndex)) {
                prop.categoryIndex = propInfo.categoryIndex;
            }
            if (!_helpers__WEBPACK_IMPORTED_MODULE_2__["Helpers"].isValueEmpty(propInfo.nextToProperty)) {
                prop.nextToProperty = propInfo.nextToProperty;
            }
            if (!_helpers__WEBPACK_IMPORTED_MODULE_2__["Helpers"].isValueEmpty(propInfo.visibleIndex)) {
                prop.visibleIndex = propInfo.visibleIndex;
            }
            if (!_helpers__WEBPACK_IMPORTED_MODULE_2__["Helpers"].isValueEmpty(propInfo.showMode)) {
                prop.showMode = propInfo.showMode;
            }
            if (!_helpers__WEBPACK_IMPORTED_MODULE_2__["Helpers"].isValueEmpty(propInfo.maxValue)) {
                prop.maxValue = propInfo.maxValue;
            }
            if (!_helpers__WEBPACK_IMPORTED_MODULE_2__["Helpers"].isValueEmpty(propInfo.minValue)) {
                prop.minValue = propInfo.minValue;
            }
            if (!_helpers__WEBPACK_IMPORTED_MODULE_2__["Helpers"].isValueEmpty(propInfo.dataList)) {
                prop.dataList = propInfo.dataList;
            }
            if (!_helpers__WEBPACK_IMPORTED_MODULE_2__["Helpers"].isValueEmpty(propInfo.isDynamicChoices)) {
                prop.isDynamicChoices = propInfo.isDynamicChoices;
            }
            if (!_helpers__WEBPACK_IMPORTED_MODULE_2__["Helpers"].isValueEmpty(propInfo.isBindable)) {
                prop.isBindable = propInfo.isBindable;
            }
            if (!_helpers__WEBPACK_IMPORTED_MODULE_2__["Helpers"].isValueEmpty(propInfo.isUnique)) {
                prop.isUnique = propInfo.isUnique;
            }
            if (propInfo.visible === true || propInfo.visible === false) {
                prop.visible = propInfo.visible;
            }
            if (!!propInfo.visibleIf) {
                prop.visibleIf = propInfo.visibleIf;
            }
            if (!!propInfo.onPropertyEditorUpdate) {
                prop.onPropertyEditorUpdate = propInfo.onPropertyEditorUpdate;
            }
            if (propInfo.readOnly === true) {
                prop.readOnly = true;
            }
            if (propInfo.choices) {
                var choicesFunc = typeof propInfo.choices === "function" ? propInfo.choices : null;
                var choicesValue = typeof propInfo.choices !== "function" ? propInfo.choices : null;
                prop.setChoices(choicesValue, choicesFunc);
            }
            if (!!propInfo.baseValue) {
                prop.setBaseValue(propInfo.baseValue);
            }
            if (propInfo.onGetValue) {
                prop.onGetValue = propInfo.onGetValue;
            }
            if (propInfo.onSetValue) {
                prop.onSetValue = propInfo.onSetValue;
            }
            if (propInfo.isLocalizable) {
                propInfo.serializationProperty = "loc" + prop.name;
            }
            if (propInfo.serializationProperty) {
                prop.serializationProperty = propInfo.serializationProperty;
                var s;
                if (prop.serializationProperty &&
                    prop.serializationProperty.indexOf("loc") == 0) {
                    prop.isLocalizable = true;
                }
            }
            if (propInfo.isLocalizable) {
                prop.isLocalizable = propInfo.isLocalizable;
            }
            if (propInfo.className) {
                prop.className = propInfo.className;
            }
            if (propInfo.baseClassName) {
                prop.baseClassName = propInfo.baseClassName;
            }
            if (propInfo.classNamePart) {
                prop.classNamePart = propInfo.classNamePart;
            }
            if (propInfo.alternativeName) {
                prop.alternativeName = propInfo.alternativeName;
            }
            if (propInfo.layout) {
                prop.layout = propInfo.layout;
            }
            if (propInfo.dependsOn) {
                this.addDependsOnProperties(prop, propInfo.dependsOn);
            }
        }
        return prop;
    };
    JsonMetadataClass.prototype.addDependsOnProperties = function (prop, dependsOn) {
        if (Array.isArray(dependsOn)) {
            for (var i = 0; i < dependsOn.length; i++) {
                this.addDependsOnProperty(prop, dependsOn[i]);
            }
        }
        else {
            this.addDependsOnProperty(prop, dependsOn);
        }
    };
    JsonMetadataClass.prototype.addDependsOnProperty = function (prop, dependsOn) {
        var property = this.find(dependsOn);
        if (!property) {
            property = Serializer.findProperty(this.parentName, dependsOn);
        }
        if (!property)
            return;
        property.addDependedProperty(prop.name);
    };
    JsonMetadataClass.prototype.getIsPropertyNameRequired = function (propertyName) {
        return (propertyName.length > 0 &&
            propertyName[0] == JsonMetadataClass.requiredSymbol);
    };
    JsonMetadataClass.prototype.getPropertyName = function (propertyName) {
        if (!this.getIsPropertyNameRequired(propertyName))
            return propertyName;
        propertyName = propertyName.slice(1);
        return propertyName;
    };
    JsonMetadataClass.requiredSymbol = "!";
    JsonMetadataClass.typeSymbol = ":";
    return JsonMetadataClass;
}());

/**
 * The metadata object. It contains object properties' runtime information and allows you to modify it.
 */
var JsonMetadata = /** @class */ (function () {
    function JsonMetadata() {
        this.classes = {};
        this.alternativeNames = {};
        this.childrenClasses = {};
        this.classProperties = {};
        this.classHashProperties = {};
    }
    JsonMetadata.prototype.getObjPropertyValue = function (obj, name) {
        if (this.isObjWrapper(obj)) {
            var orignalObj = obj.getOriginalObj();
            var prop = Serializer.findProperty(orignalObj.getType(), name);
            if (!!prop)
                return this.getObjPropertyValueCore(orignalObj, prop);
        }
        var prop = Serializer.findProperty(obj.getType(), name);
        if (!prop)
            return obj[name];
        return this.getObjPropertyValueCore(obj, prop);
    };
    JsonMetadata.prototype.setObjPropertyValue = function (obj, name, val) {
        if (obj[name] === val)
            return;
        if (!!obj[name] && !!obj[name].setJson) {
            obj[name].setJson(val);
        }
        else {
            obj[name] = val;
        }
    };
    JsonMetadata.prototype.getObjPropertyValueCore = function (obj, prop) {
        if (!prop.isSerializable)
            return obj[prop.name];
        if (prop.isLocalizable) {
            if (prop.isArray)
                return obj[prop.name];
            if (!!prop.serializationProperty)
                return obj[prop.serializationProperty].text;
        }
        return obj.getPropertyValue(prop.name);
    };
    JsonMetadata.prototype.isObjWrapper = function (obj) {
        return !!obj.getOriginalObj && !!obj.getOriginalObj();
    };
    JsonMetadata.prototype.addClass = function (name, properties, creator, parentName) {
        if (creator === void 0) { creator = null; }
        if (parentName === void 0) { parentName = null; }
        name = name.toLowerCase();
        var metaDataClass = new JsonMetadataClass(name, properties, creator, parentName);
        this.classes[name] = metaDataClass;
        if (parentName) {
            parentName = parentName.toLowerCase();
            var children = this.childrenClasses[parentName];
            if (!children) {
                this.childrenClasses[parentName] = [];
            }
            this.childrenClasses[parentName].push(metaDataClass);
        }
        return metaDataClass;
    };
    JsonMetadata.prototype.removeClass = function (name) {
        var metaClass = this.findClass(name);
        if (!metaClass)
            return;
        delete this.classes[metaClass.name];
        if (!!metaClass.parentName) {
            var index = this.childrenClasses[metaClass.parentName].indexOf(metaClass);
            if (index > -1) {
                this.childrenClasses[metaClass.parentName].splice(index, 1);
            }
        }
    };
    JsonMetadata.prototype.overrideClassCreatore = function (name, creator) {
        this.overrideClassCreator(name, creator);
    };
    JsonMetadata.prototype.overrideClassCreator = function (name, creator) {
        name = name.toLowerCase();
        var metaDataClass = this.findClass(name);
        if (metaDataClass) {
            metaDataClass.creator = creator;
        }
    };
    JsonMetadata.prototype.getProperties = function (className) {
        var metaClass = this.findClass(className);
        if (!metaClass)
            return [];
        var properties = this.classProperties[metaClass.name];
        if (!!properties)
            return properties;
        this.fillPropertiesForClass(metaClass.name);
        return this.classProperties[metaClass.name];
    };
    JsonMetadata.prototype.getHashProperties = function (className) {
        var metaClass = this.findClass(className);
        if (!metaClass)
            return {};
        var properties = this.classHashProperties[metaClass.name];
        if (!!properties)
            return properties;
        this.fillPropertiesForClass(metaClass.name);
        return this.classHashProperties[metaClass.name];
    };
    JsonMetadata.prototype.fillPropertiesForClass = function (className) {
        var properties = new Array();
        var hashProperties = {};
        this.fillProperties(className, properties, hashProperties);
        this.classProperties[className] = properties;
        this.classHashProperties[className] = hashProperties;
    };
    JsonMetadata.prototype.getPropertiesByObj = function (obj) {
        if (!obj || !obj.getType)
            return [];
        var res = {};
        var props = this.getProperties(obj.getType());
        for (var i = 0; i < props.length; i++) {
            res[props[i].name] = props[i];
        }
        var dynamicProps = !!obj.getDynamicType
            ? this.getProperties(obj.getDynamicType())
            : null;
        if (dynamicProps && dynamicProps.length > 0) {
            for (var i = 0; i < dynamicProps.length; i++) {
                var dProp = dynamicProps[i];
                if (!!res[dProp.name])
                    continue;
                res[dProp.name] = dProp;
            }
        }
        return Object.keys(res).map(function (key) { return res[key]; });
    };
    JsonMetadata.prototype.getDynamicPropertiesByObj = function (obj, dynamicType) {
        if (dynamicType === void 0) { dynamicType = null; }
        if (!obj || !obj.getType || (!obj.getDynamicType && !dynamicType))
            return [];
        var dType = !!dynamicType ? dynamicType : obj.getDynamicType();
        if (!dType)
            return [];
        var dynamicProps = this.getProperties(dType);
        if (!dynamicProps || dynamicProps.length == 0)
            return [];
        var hash = {};
        var props = this.getProperties(obj.getType());
        for (var i = 0; i < props.length; i++) {
            hash[props[i].name] = props[i];
        }
        var res = [];
        for (var i = 0; i < dynamicProps.length; i++) {
            var dProp = dynamicProps[i];
            if (!hash[dProp.name]) {
                res.push(dProp);
            }
        }
        return res;
    };
    JsonMetadata.prototype.hasOriginalProperty = function (obj, propName) {
        return !!this.getOriginalProperty(obj, propName);
    };
    JsonMetadata.prototype.getOriginalProperty = function (obj, propName) {
        var res = this.findProperty(obj.getType(), propName);
        if (!!res)
            return res;
        if (this.isObjWrapper(obj))
            return this.findProperty(obj.getOriginalObj().getType(), propName);
        return null;
    };
    JsonMetadata.prototype.getProperty = function (className, propertyName) {
        var prop = this.findProperty(className, propertyName);
        if (!prop)
            return prop;
        var classInfo = this.findClass(className);
        if (prop.classInfo === classInfo)
            return prop;
        var newProp = new JsonObjectProperty(classInfo, propertyName, prop.isRequired);
        newProp.mergeWith(prop);
        newProp.isArray = prop.isArray;
        classInfo.properties.push(newProp);
        this.emptyClassPropertiesHash(classInfo);
        return newProp;
    };
    JsonMetadata.prototype.findProperty = function (className, propertyName) {
        var hash = this.getHashProperties(className);
        var res = hash[propertyName];
        return !!res ? res : null;
    };
    JsonMetadata.prototype.findProperties = function (className, propertyNames) {
        var result = [];
        var hash = this.getHashProperties(className);
        for (var i = 0; i < propertyNames.length; i++) {
            var prop = hash[propertyNames[i]];
            if (prop) {
                result.push(prop);
            }
        }
        return result;
    };
    JsonMetadata.prototype.getAllPropertiesByName = function (propertyName) {
        var res = new Array();
        var classes = this.getAllClasses();
        for (var i = 0; i < classes.length; i++) {
            var classInfo = this.findClass(classes[i]);
            for (var j = 0; j < classInfo.properties.length; j++) {
                if (classInfo.properties[j].name == propertyName) {
                    res.push(classInfo.properties[j]);
                    break;
                }
            }
        }
        return res;
    };
    JsonMetadata.prototype.getAllClasses = function () {
        var res = new Array();
        for (var name in this.classes) {
            res.push(name);
        }
        return res;
    };
    JsonMetadata.prototype.createClass = function (name, json) {
        if (json === void 0) { json = undefined; }
        name = name.toLowerCase();
        var metaDataClass = this.findClass(name);
        if (!metaDataClass)
            return null;
        if (metaDataClass.creator)
            return metaDataClass.creator(json);
        var parentName = metaDataClass.parentName;
        while (parentName) {
            metaDataClass = this.findClass(parentName);
            if (!metaDataClass)
                return null;
            parentName = metaDataClass.parentName;
            if (metaDataClass.creator)
                return this.createCustomType(name, metaDataClass.creator, json);
        }
        return null;
    };
    JsonMetadata.prototype.createCustomType = function (name, creator, json) {
        if (json === void 0) { json = undefined; }
        name = name.toLowerCase();
        var res = creator(json);
        var customTypeName = name;
        var customTemplateName = res.getTemplate
            ? res.getTemplate()
            : res.getType();
        res.getType = function () {
            return customTypeName;
        };
        res.getTemplate = function () {
            return customTemplateName;
        };
        CustomPropertiesCollection.createProperties(res);
        return res;
    };
    JsonMetadata.prototype.getChildrenClasses = function (name, canBeCreated) {
        if (canBeCreated === void 0) { canBeCreated = false; }
        name = name.toLowerCase();
        var result = [];
        this.fillChildrenClasses(name, canBeCreated, result);
        return result;
    };
    JsonMetadata.prototype.getRequiredProperties = function (name) {
        var properties = this.getProperties(name);
        var res = [];
        for (var i = 0; i < properties.length; i++) {
            if (properties[i].isRequired) {
                res.push(properties[i].name);
            }
        }
        return res;
    };
    JsonMetadata.prototype.addProperties = function (className, propertiesInfos) {
        className = className.toLowerCase();
        var metaDataClass = this.findClass(className);
        for (var i = 0; i < propertiesInfos.length; i++) {
            this.addCustomPropertyCore(metaDataClass, propertiesInfos[i]);
        }
    };
    JsonMetadata.prototype.addProperty = function (className, propertyInfo) {
        return this.addCustomPropertyCore(this.findClass(className), propertyInfo);
    };
    JsonMetadata.prototype.addCustomPropertyCore = function (metaDataClass, propertyInfo) {
        if (!metaDataClass)
            return null;
        var property = metaDataClass.createProperty(propertyInfo);
        if (property) {
            property.isCustom = true;
            this.addPropertyToClass(metaDataClass, property);
            this.emptyClassPropertiesHash(metaDataClass);
            CustomPropertiesCollection.addProperty(metaDataClass.name, property);
        }
        return property;
    };
    JsonMetadata.prototype.removeProperty = function (className, propertyName) {
        var metaDataClass = this.findClass(className);
        if (!metaDataClass)
            return false;
        var property = metaDataClass.find(propertyName);
        if (property) {
            this.removePropertyFromClass(metaDataClass, property);
            this.emptyClassPropertiesHash(metaDataClass);
            CustomPropertiesCollection.removeProperty(metaDataClass.name, propertyName);
        }
    };
    JsonMetadata.prototype.addPropertyToClass = function (metaDataClass, property) {
        if (metaDataClass.find(property.name) != null)
            return;
        metaDataClass.properties.push(property);
    };
    JsonMetadata.prototype.removePropertyFromClass = function (metaDataClass, property) {
        var index = metaDataClass.properties.indexOf(property);
        if (index < 0)
            return;
        metaDataClass.properties.splice(index, 1);
    };
    JsonMetadata.prototype.emptyClassPropertiesHash = function (metaDataClass) {
        this.classProperties[metaDataClass.name] = null;
        this.classHashProperties[metaDataClass.name] = null;
        var childClasses = this.getChildrenClasses(metaDataClass.name);
        for (var i = 0; i < childClasses.length; i++) {
            this.classProperties[childClasses[i].name] = null;
            this.classHashProperties[childClasses[i].name] = null;
        }
    };
    JsonMetadata.prototype.fillChildrenClasses = function (name, canBeCreated, result) {
        var children = this.childrenClasses[name];
        if (!children)
            return;
        for (var i = 0; i < children.length; i++) {
            if (!canBeCreated || children[i].creator) {
                result.push(children[i]);
            }
            this.fillChildrenClasses(children[i].name, canBeCreated, result);
        }
    };
    JsonMetadata.prototype.findClass = function (name) {
        name = name.toLowerCase();
        var res = this.classes[name];
        if (!res) {
            var newName = this.alternativeNames[name];
            if (!!newName && newName != name)
                return this.findClass(newName);
        }
        return res;
    };
    JsonMetadata.prototype.isDescendantOf = function (className, ancestorClassName) {
        if (!className || !ancestorClassName) {
            return false;
        }
        className = className.toLowerCase();
        ancestorClassName = ancestorClassName.toLowerCase();
        var class_ = this.findClass(className);
        if (!class_) {
            return false;
        }
        var parentClass = class_;
        do {
            if (parentClass.name === ancestorClassName) {
                return true;
            }
            parentClass = this.classes[parentClass.parentName];
        } while (!!parentClass);
        return false;
    };
    JsonMetadata.prototype.addAlterNativeClassName = function (name, alternativeName) {
        this.alternativeNames[alternativeName.toLowerCase()] = name.toLowerCase();
    };
    JsonMetadata.prototype.generateSchema = function (className) {
        if (className === void 0) { className = undefined; }
        if (!className)
            className = "survey";
        var classInfo = this.findClass(className);
        if (!classInfo)
            return null;
        var res = {
            $schema: "http://json-schema.org/draft-07/schema#",
            title: "SurveyJS Library json schema",
            type: "object",
            properties: {},
            definitions: {},
        };
        this.generateSchemaProperties(classInfo, res.properties, res.definitions);
        return res;
    };
    JsonMetadata.prototype.generateSchemaProperties = function (classInfo, schemaProperties, schemaDef) {
        if (!classInfo)
            return;
        for (var i = 0; i < classInfo.properties.length; i++) {
            var prop = classInfo.properties[i];
            schemaProperties[prop.name] = this.generateSchemaProperty(prop, schemaDef);
        }
    };
    JsonMetadata.prototype.generateSchemaProperty = function (prop, schemaDef) {
        var res = { type: prop.schemaType() };
        if (prop.hasChoices) {
            res.enum = prop.getChoices(null);
        }
        if (!!prop.className) {
            res.items = { $ref: "#" + prop.className };
            this.generateChemaClass(prop.className, schemaDef);
        }
        if (!!prop.baseClassName) {
            var usedClasses = this.getChildrenClasses(prop.baseClassName, true);
            if (prop.baseClassName == "question") {
                usedClasses.push(this.findClass("panel"));
            }
            res.items = [];
            for (var i = 0; i < usedClasses.length; i++) {
                var className = usedClasses[i].name;
                res.items.push({ $ref: "#" + className });
                this.generateChemaClass(className, schemaDef);
            }
        }
        return res;
    };
    JsonMetadata.prototype.generateChemaClass = function (className, schemaDef) {
        if (!!schemaDef[className])
            return;
        var classInfo = this.findClass(className);
        if (!classInfo)
            return;
        var hasParent = !!classInfo.parentName && classInfo.parentName != "base";
        if (hasParent) {
            this.generateChemaClass(classInfo.parentName, schemaDef);
        }
        var res = { type: "object", $id: "#" + className };
        schemaDef[className] = res;
        var props = {};
        this.generateSchemaProperties(classInfo, props, schemaDef);
        if (hasParent) {
            res.allOff = [
                { $ref: "#" + classInfo.parentName },
                { properties: props },
            ];
        }
        else {
            res.properties = props;
        }
    };
    JsonMetadata.prototype.fillProperties = function (name, list, hash) {
        var metaDataClass = this.findClass(name);
        if (!metaDataClass)
            return;
        if (metaDataClass.parentName) {
            this.fillProperties(metaDataClass.parentName, list, hash);
        }
        for (var i = 0; i < metaDataClass.properties.length; i++) {
            var prop = metaDataClass.properties[i];
            this.addPropertyCore(prop, list, hash);
            hash[prop.name] = prop;
        }
    };
    JsonMetadata.prototype.addPropertyCore = function (property, list, hash) {
        if (!hash[property.name]) {
            list.push(property);
            return;
        }
        var index = -1;
        for (var i = 0; i < list.length; i++) {
            if (list[i].name == property.name) {
                index = i;
                break;
            }
        }
        property.mergeWith(list[index]);
        list[index] = property;
    };
    return JsonMetadata;
}());

var JsonError = /** @class */ (function () {
    function JsonError(type, message) {
        this.type = type;
        this.message = message;
        this.description = "";
        this.at = -1;
    }
    JsonError.prototype.getFullDescription = function () {
        return this.message + (this.description ? "\n" + this.description : "");
    };
    return JsonError;
}());

var JsonUnknownPropertyError = /** @class */ (function (_super) {
    __extends(JsonUnknownPropertyError, _super);
    function JsonUnknownPropertyError(propertyName, className) {
        var _this = _super.call(this, "unknownproperty", "The property '" +
            propertyName +
            "' in class '" +
            className +
            "' is unknown.") || this;
        _this.propertyName = propertyName;
        _this.className = className;
        var properties = JsonObject.metaData.getProperties(className);
        if (properties) {
            _this.description = "The list of available properties are: ";
            for (var i = 0; i < properties.length; i++) {
                if (i > 0)
                    _this.description += ", ";
                _this.description += properties[i].name;
            }
            _this.description += ".";
        }
        return _this;
    }
    return JsonUnknownPropertyError;
}(JsonError));

var JsonMissingTypeErrorBase = /** @class */ (function (_super) {
    __extends(JsonMissingTypeErrorBase, _super);
    function JsonMissingTypeErrorBase(baseClassName, type, message) {
        var _this = _super.call(this, type, message) || this;
        _this.baseClassName = baseClassName;
        _this.type = type;
        _this.message = message;
        _this.description = "The following types are available: ";
        var types = JsonObject.metaData.getChildrenClasses(baseClassName, true);
        for (var i = 0; i < types.length; i++) {
            if (i > 0)
                _this.description += ", ";
            _this.description += "'" + types[i].name + "'";
        }
        _this.description += ".";
        return _this;
    }
    return JsonMissingTypeErrorBase;
}(JsonError));

var JsonMissingTypeError = /** @class */ (function (_super) {
    __extends(JsonMissingTypeError, _super);
    function JsonMissingTypeError(propertyName, baseClassName) {
        var _this = _super.call(this, baseClassName, "missingtypeproperty", "The property type is missing in the object. Please take a look at property: '" +
            propertyName +
            "'.") || this;
        _this.propertyName = propertyName;
        _this.baseClassName = baseClassName;
        return _this;
    }
    return JsonMissingTypeError;
}(JsonMissingTypeErrorBase));

var JsonIncorrectTypeError = /** @class */ (function (_super) {
    __extends(JsonIncorrectTypeError, _super);
    function JsonIncorrectTypeError(propertyName, baseClassName) {
        var _this = _super.call(this, baseClassName, "incorrecttypeproperty", "The property type is incorrect in the object. Please take a look at property: '" +
            propertyName +
            "'.") || this;
        _this.propertyName = propertyName;
        _this.baseClassName = baseClassName;
        return _this;
    }
    return JsonIncorrectTypeError;
}(JsonMissingTypeErrorBase));

var JsonRequiredPropertyError = /** @class */ (function (_super) {
    __extends(JsonRequiredPropertyError, _super);
    function JsonRequiredPropertyError(propertyName, className) {
        var _this = _super.call(this, "requiredproperty", "The property '" +
            propertyName +
            "' is required in class '" +
            className +
            "'.") || this;
        _this.propertyName = propertyName;
        _this.className = className;
        return _this;
    }
    return JsonRequiredPropertyError;
}(JsonError));

var JsonObject = /** @class */ (function () {
    function JsonObject() {
        this.errors = new Array();
        this.lightSerializing = false;
    }
    Object.defineProperty(JsonObject, "metaData", {
        get: function () {
            return JsonObject.metaDataValue;
        },
        enumerable: false,
        configurable: true
    });
    JsonObject.prototype.toJsonObject = function (obj, storeDefaults) {
        if (storeDefaults === void 0) { storeDefaults = false; }
        return this.toJsonObjectCore(obj, null, storeDefaults);
    };
    JsonObject.prototype.toObject = function (jsonObj, obj) {
        this.toObjectCore(jsonObj, obj);
        var error = this.getRequiredError(obj, jsonObj);
        if (!!error) {
            this.addNewError(error, jsonObj);
        }
    };
    JsonObject.prototype.toObjectCore = function (jsonObj, obj) {
        if (!jsonObj)
            return;
        var properties = null;
        var objType = undefined;
        var needAddErrors = true;
        if (obj.getType) {
            objType = obj.getType();
            properties = JsonObject.metaData.getProperties(objType);
            needAddErrors =
                !!objType && !JsonObject.metaData.isDescendantOf(objType, "itemvalue");
        }
        if (!properties)
            return;
        if (obj.startLoadingFromJson) {
            obj.startLoadingFromJson();
        }
        properties = this.addDynamicProperties(obj, jsonObj, properties);
        for (var key in jsonObj) {
            if (key === JsonObject.typePropertyName)
                continue;
            if (key === JsonObject.positionPropertyName) {
                obj[key] = jsonObj[key];
                continue;
            }
            var property = this.findProperty(properties, key);
            if (!property) {
                if (needAddErrors) {
                    this.addNewError(new JsonUnknownPropertyError(key.toString(), objType), jsonObj);
                }
                continue;
            }
            this.valueToObj(jsonObj[key], obj, property);
        }
        if (obj.endLoadingFromJson) {
            obj.endLoadingFromJson();
        }
    };
    JsonObject.prototype.toJsonObjectCore = function (obj, property, storeDefaults) {
        if (storeDefaults === void 0) { storeDefaults = false; }
        if (!obj || !obj.getType)
            return obj;
        if (typeof obj.getData === "function")
            return obj.getData();
        var result = {};
        if (property != null && !property.className) {
            result[JsonObject.typePropertyName] = property.getObjType(obj.getType());
        }
        this.propertiesToJson(obj, JsonObject.metaData.getProperties(obj.getType()), result, storeDefaults);
        this.propertiesToJson(obj, this.getDynamicProperties(obj), result, storeDefaults);
        return result;
    };
    JsonObject.prototype.getDynamicProperties = function (obj) {
        return Serializer.getDynamicPropertiesByObj(obj);
    };
    JsonObject.prototype.addDynamicProperties = function (obj, jsonObj, properties) {
        if (!obj.getDynamicPropertyName)
            return properties;
        var dynamicPropName = obj.getDynamicPropertyName();
        if (!dynamicPropName)
            return properties;
        if (jsonObj[dynamicPropName]) {
            obj[dynamicPropName] = jsonObj[dynamicPropName];
        }
        var dynamicProperties = this.getDynamicProperties(obj);
        var res = [];
        for (var i = 0; i < properties.length; i++) {
            res.push(properties[i]);
        }
        for (var i = 0; i < dynamicProperties.length; i++) {
            res.push(dynamicProperties[i]);
        }
        return res;
    };
    JsonObject.prototype.propertiesToJson = function (obj, properties, json, storeDefaults) {
        if (storeDefaults === void 0) { storeDefaults = false; }
        for (var i = 0; i < properties.length; i++) {
            this.valueToJson(obj, json, properties[i], storeDefaults);
        }
    };
    JsonObject.prototype.valueToJson = function (obj, result, property, storeDefaults) {
        if (storeDefaults === void 0) { storeDefaults = false; }
        if (property.isSerializable === false ||
            (property.isLightSerializable === false && this.lightSerializing))
            return;
        var value = property.getValue(obj);
        if (!storeDefaults && property.isDefaultValue(value))
            return;
        if (this.isValueArray(value)) {
            var arrValue = [];
            for (var i = 0; i < value.length; i++) {
                arrValue.push(this.toJsonObjectCore(value[i], property, storeDefaults));
            }
            value = arrValue.length > 0 ? arrValue : null;
        }
        else {
            value = this.toJsonObjectCore(value, property, storeDefaults);
        }
        var hasValue = typeof obj["getPropertyValue"] === "function" &&
            obj["getPropertyValue"](property.name, null) !== null;
        if ((storeDefaults && hasValue) || !property.isDefaultValue(value)) {
            result[property.name] = value;
        }
    };
    JsonObject.prototype.valueToObj = function (value, obj, property) {
        if (value == null)
            return;
        this.removePos(property, value);
        if (property != null && property.hasToUseSetValue) {
            property.setValue(obj, value, this);
            return;
        }
        if (this.isValueArray(value)) {
            this.valueToArray(value, obj, property.name, property);
            return;
        }
        var newObj = this.createNewObj(value, property);
        if (newObj.newObj) {
            this.toObjectCore(value, newObj.newObj);
            value = newObj.newObj;
        }
        if (!newObj.error) {
            if (property != null) {
                property.setValue(obj, value, this);
            }
            else {
                obj[property.name] = value;
            }
        }
    };
    JsonObject.prototype.removePos = function (property, value) {
        if (!property || !property.type || property.type.indexOf("value") < 0)
            return;
        this.removePosFromObj(value);
    };
    JsonObject.prototype.removePosFromObj = function (obj) {
        if (!obj)
            return;
        if (Array.isArray(obj)) {
            for (var i = 0; i < obj.length; i++) {
                this.removePosFromObj(obj[i]);
            }
        }
        if (!!obj[JsonObject.positionPropertyName]) {
            delete obj[JsonObject.positionPropertyName];
        }
    };
    JsonObject.prototype.isValueArray = function (value) {
        return value && Array.isArray(value);
    };
    JsonObject.prototype.createNewObj = function (value, property) {
        var result = { newObj: null, error: null };
        var className = value[JsonObject.typePropertyName];
        if (!className && property != null && property.className) {
            className = property.className;
        }
        className = property.getClassName(className);
        result.newObj = className
            ? JsonObject.metaData.createClass(className, value)
            : null;
        result.error = this.checkNewObjectOnErrors(result.newObj, value, property, className);
        return result;
    };
    JsonObject.prototype.checkNewObjectOnErrors = function (newObj, value, property, className) {
        var error = null;
        if (newObj) {
            error = this.getRequiredError(newObj, value);
        }
        else {
            if (property.baseClassName) {
                if (!className) {
                    error = new JsonMissingTypeError(property.name, property.baseClassName);
                }
                else {
                    error = new JsonIncorrectTypeError(property.name, property.baseClassName);
                }
            }
        }
        if (error) {
            this.addNewError(error, value);
        }
        return error;
    };
    JsonObject.prototype.getRequiredError = function (obj, jsonValue) {
        if (!obj.getType || typeof obj.getData === "function")
            return null;
        var className = obj.getType();
        var requiredProperties = JsonObject.metaData.getRequiredProperties(className);
        if (!requiredProperties)
            return null;
        for (var i = 0; i < requiredProperties.length; i++) {
            if (!jsonValue[requiredProperties[i]]) {
                return new JsonRequiredPropertyError(requiredProperties[i], className);
            }
        }
        return null;
    };
    JsonObject.prototype.addNewError = function (error, jsonObj) {
        if (jsonObj && jsonObj[JsonObject.positionPropertyName]) {
            error.at = jsonObj[JsonObject.positionPropertyName].start;
        }
        this.errors.push(error);
    };
    JsonObject.prototype.valueToArray = function (value, obj, key, property) {
        if (obj[key] && value.length > 0)
            obj[key].splice(0, obj[key].length);
        var valueRes = obj[key] ? obj[key] : [];
        this.addValuesIntoArray(value, valueRes, property);
        if (!obj[key])
            obj[key] = valueRes;
    };
    JsonObject.prototype.addValuesIntoArray = function (value, result, property) {
        for (var i = 0; i < value.length; i++) {
            var newValue = this.createNewObj(value[i], property);
            if (newValue.newObj) {
                if (!!value[i].name) {
                    newValue.newObj.name = value[i].name;
                }
                result.push(newValue.newObj);
                this.toObjectCore(value[i], newValue.newObj);
            }
            else {
                if (!newValue.error) {
                    result.push(value[i]);
                }
            }
        }
    };
    JsonObject.prototype.findProperty = function (properties, key) {
        if (!properties)
            return null;
        for (var i = 0; i < properties.length; i++) {
            var prop = properties[i];
            if (prop.name == key || prop.alternativeName == key)
                return prop;
        }
        return null;
    };
    JsonObject.typePropertyName = "type";
    JsonObject.positionPropertyName = "pos";
    JsonObject.metaDataValue = new JsonMetadata();
    return JsonObject;
}());

/**
 * An alias for the metadata object. It contains object properties' runtime information and allows you to modify it.
 * @see JsonMetadata
 */
var Serializer = JsonObject.metaData;


/***/ }),

/***/ "./src/knockout/components/action-bar/action-bar-item-dropdown.html":
/*!**************************************************************************!*\
  !*** ./src/knockout/components/action-bar/action-bar-item-dropdown.html ***!
  \**************************************************************************/
/*! no static exports found */
/***/ (function(module, exports) {

module.exports = "<!-- ko with: $data.item -->\n<button class=\"sv-action-bar-item-dropdown\" type=\"button\"\n  data-bind=\"click: action, key2click: { processEsc: false }, css: getActionBarItemCss(), attr: { disabled: $data.enabled !== undefined && !ko.unwrap($data.enabled), title: $data.tooltip || $data.title }\">\n  <!-- ko if: $data.iconName -->\n  <sv-svg-icon data-bind=\"css: $data.cssClasses.itemIcon\" params=\"iconName: iconName, size: iconSize\"></sv-svg-icon>\n  <!-- /ko -->\n  <!-- ko if: $data.hasTitle -->\n  <span data-bind=\"text: title, css: getActionBarItemTitleCss()\"></span>\n  <!-- /ko -->\n  <sv-popup params=\"model: popupModel\"></sv-popup>\n</button>\n<!-- /ko -->";

/***/ }),

/***/ "./src/knockout/components/action-bar/action-bar-item-dropdown.ts":
/*!************************************************************************!*\
  !*** ./src/knockout/components/action-bar/action-bar-item-dropdown.ts ***!
  \************************************************************************/
/*! exports provided: ActionBarItemDropdownViewModel */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "ActionBarItemDropdownViewModel", function() { return ActionBarItemDropdownViewModel; });
/* harmony import */ var knockout__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! knockout */ "knockout");
/* harmony import */ var knockout__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(knockout__WEBPACK_IMPORTED_MODULE_0__);

var template = __webpack_require__(/*! ./action-bar-item-dropdown.html */ "./src/knockout/components/action-bar/action-bar-item-dropdown.html");
var ActionBarItemDropdownViewModel;
knockout__WEBPACK_IMPORTED_MODULE_0__["components"].register("sv-action-bar-item-dropdown", {
    viewModel: {
        createViewModel: function (params) { return params; }
    },
    template: template
});


/***/ }),

/***/ "./src/knockout/components/action-bar/action-bar-item.html":
/*!*****************************************************************!*\
  !*** ./src/knockout/components/action-bar/action-bar-item.html ***!
  \*****************************************************************/
/*! no static exports found */
/***/ (function(module, exports) {

module.exports = "<!-- ko with: $data.item -->\n<button\n  type=\"button\"\n  data-bind=\"click: action, key2click: { processEsc: false }, disable: $data.disabled, css: getActionBarItemCss(), attr: { title: $data.tooltip || $data.title }\"\n>\n  <!-- ko if: $data.iconName -->\n  <!-- ko component: { name: 'sv-svg-icon', params: { css: $data.cssClasses.itemIcon, iconName: iconName, size: iconSize } } --><!-- /ko -->\n  <!-- /ko -->\n  <!-- ko if: $data.hasTitle -->\n  <span\n    data-bind=\"text: title, css: getActionBarItemTitleCss()\"\n  ></span>\n  <!-- /ko -->\n</button>\n<!-- /ko -->";

/***/ }),

/***/ "./src/knockout/components/action-bar/action-bar-item.ts":
/*!***************************************************************!*\
  !*** ./src/knockout/components/action-bar/action-bar-item.ts ***!
  \***************************************************************/
/*! exports provided: ActionBarItemViewModel */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "ActionBarItemViewModel", function() { return ActionBarItemViewModel; });
/* harmony import */ var knockout__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! knockout */ "knockout");
/* harmony import */ var knockout__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(knockout__WEBPACK_IMPORTED_MODULE_0__);

var template = __webpack_require__(/*! ./action-bar-item.html */ "./src/knockout/components/action-bar/action-bar-item.html");
var ActionBarItemViewModel;
knockout__WEBPACK_IMPORTED_MODULE_0__["components"].register("sv-action-bar-item", {
    viewModel: {
        createViewModel: function (params) {
            return params;
        },
    },
    template: template
});


/***/ }),

/***/ "./src/knockout/components/action-bar/action-bar-separator.html":
/*!**********************************************************************!*\
  !*** ./src/knockout/components/action-bar/action-bar-separator.html ***!
  \**********************************************************************/
/*! no static exports found */
/***/ (function(module, exports) {

module.exports = "<div class=\"sv-action-bar-separator\" data-bind=\"css: $data.css\"></div>";

/***/ }),

/***/ "./src/knockout/components/action-bar/action-bar-separator.ts":
/*!********************************************************************!*\
  !*** ./src/knockout/components/action-bar/action-bar-separator.ts ***!
  \********************************************************************/
/*! exports provided: ActionBarSeparatorViewModel */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "ActionBarSeparatorViewModel", function() { return ActionBarSeparatorViewModel; });
/* harmony import */ var knockout__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! knockout */ "knockout");
/* harmony import */ var knockout__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(knockout__WEBPACK_IMPORTED_MODULE_0__);

var template = __webpack_require__(/*! ./action-bar-separator.html */ "./src/knockout/components/action-bar/action-bar-separator.html");
var ActionBarSeparatorViewModel;
knockout__WEBPACK_IMPORTED_MODULE_0__["components"].register("sv-action-bar-separator", {
    viewModel: {
        createViewModel: function (params, componentInfo) {
            var item = params.item;
            if (!!item) {
                return {
                    css: item.innerCss,
                };
            }
            return {};
        },
    },
    template: template,
});


/***/ }),

/***/ "./src/knockout/components/action-bar/action-bar.html":
/*!************************************************************!*\
  !*** ./src/knockout/components/action-bar/action-bar.html ***!
  \************************************************************/
/*! no static exports found */
/***/ (function(module, exports) {

module.exports = "<!-- ko if: model.hasActions -->\n<div\n  data-bind=\"css: model.getRootCss(), click: handleClick ? function() { return true; } : undefined, clickBubble: handleClick ? false : undefined\"\n>\n  <!-- ko foreach: model.renderedActions -->\n  <!-- ko component: { name: 'sv-action', params: { item: $data } } -->\n  <!-- /ko -->\n  <!--/ko-->\n</div>\n<!--/ko-->\n";

/***/ }),

/***/ "./src/knockout/components/action-bar/action-bar.ts":
/*!**********************************************************!*\
  !*** ./src/knockout/components/action-bar/action-bar.ts ***!
  \**********************************************************/
/*! exports provided: ActionBarItemViewModel, ActionBarItemDropdownViewModel, ActionBarSeparatorViewModel, ActionContainerImplementor */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "ActionContainerImplementor", function() { return ActionContainerImplementor; });
/* harmony import */ var knockout__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! knockout */ "knockout");
/* harmony import */ var knockout__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(knockout__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _kobase__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../kobase */ "./src/knockout/kobase.ts");
/* harmony import */ var _action__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./action */ "./src/knockout/components/action-bar/action.ts");
/* empty/unused harmony star reexport *//* harmony import */ var _action_bar_item__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./action-bar-item */ "./src/knockout/components/action-bar/action-bar-item.ts");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "ActionBarItemViewModel", function() { return _action_bar_item__WEBPACK_IMPORTED_MODULE_3__["ActionBarItemViewModel"]; });

/* harmony import */ var _action_bar_item_dropdown__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./action-bar-item-dropdown */ "./src/knockout/components/action-bar/action-bar-item-dropdown.ts");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "ActionBarItemDropdownViewModel", function() { return _action_bar_item_dropdown__WEBPACK_IMPORTED_MODULE_4__["ActionBarItemDropdownViewModel"]; });

/* harmony import */ var _action_bar_separator__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./action-bar-separator */ "./src/knockout/components/action-bar/action-bar-separator.ts");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "ActionBarSeparatorViewModel", function() { return _action_bar_separator__WEBPACK_IMPORTED_MODULE_5__["ActionBarSeparatorViewModel"]; });

var __extends = (undefined && undefined.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();


var template = __webpack_require__(/*! ./action-bar.html */ "./src/knockout/components/action-bar/action-bar.html");




var ActionContainerImplementor = /** @class */ (function (_super) {
    __extends(ActionContainerImplementor, _super);
    function ActionContainerImplementor(model, handleClick) {
        if (handleClick === void 0) { handleClick = true; }
        var _this = _super.call(this, model) || this;
        _this.model = model;
        _this.handleClick = handleClick;
        _this.itemsSubscription = knockout__WEBPACK_IMPORTED_MODULE_0__["computed"](function () {
            (model.renderedActions || model.items || model.actions).forEach(function (item) {
                if (!!item.stateItem) {
                    new _kobase__WEBPACK_IMPORTED_MODULE_1__["ImplementorBase"](item.stateItem);
                }
                else {
                    new _kobase__WEBPACK_IMPORTED_MODULE_1__["ImplementorBase"](item);
                }
            });
        });
        return _this;
    }
    ActionContainerImplementor.prototype.dispose = function () {
        _super.prototype.dispose.call(this);
        this.itemsSubscription.dispose();
        this.model.resetResponsivityManager();
    };
    return ActionContainerImplementor;
}(_kobase__WEBPACK_IMPORTED_MODULE_1__["ImplementorBase"]));

knockout__WEBPACK_IMPORTED_MODULE_0__["components"].register("sv-action-bar", {
    viewModel: {
        createViewModel: function (params, componentInfo) {
            var handleClick = params.handleClick !== undefined ? params.handleClick : true;
            var model = params.model;
            var container = componentInfo.element.nextElementSibling;
            params.model.initResponsivityManager(container);
            return new ActionContainerImplementor(model, handleClick);
        },
    },
    template: template,
});


/***/ }),

/***/ "./src/knockout/components/action-bar/action.html":
/*!********************************************************!*\
  !*** ./src/knockout/components/action-bar/action.html ***!
  \********************************************************/
/*! no static exports found */
/***/ (function(module, exports) {

module.exports = "<!-- ko with: $data.item -->\r\n<div data-bind=\"class: $data.getActionRootCss(), attr: { id: $data.id }\">\r\n    <!-- ko ifnot: $data.isEmpty -->\r\n    <div class=\"sv-action__content\">\r\n        <!-- ko if: $data.needSeparator -->\r\n        <sv-action-bar-separator></sv-action-bar-separator>\r\n        <!-- /ko -->\r\n        <!-- ko ifnot: $data.template-->\r\n        <!-- ko component: { name: $data.component || 'sv-action-bar-item', params: { item: $data } } -->\r\n        <!-- /ko -->\r\n        <!-- /ko -->\r\n        <!-- ko if: $data.template  -->\r\n        <!-- ko template: { name: $data.template, data: $data.data || $data } -->\r\n        <!-- /ko -->\r\n        <!-- /ko -->\r\n    </div>\r\n    <!-- /ko -->\r\n</div>\r\n<!-- /ko -->";

/***/ }),

/***/ "./src/knockout/components/action-bar/action.ts":
/*!******************************************************!*\
  !*** ./src/knockout/components/action-bar/action.ts ***!
  \******************************************************/
/*! no exports provided */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var knockout__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! knockout */ "knockout");
/* harmony import */ var knockout__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(knockout__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _kobase__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../kobase */ "./src/knockout/kobase.ts");


var template = __webpack_require__(/*! ./action.html */ "./src/knockout/components/action-bar/action.html");
knockout__WEBPACK_IMPORTED_MODULE_0__["components"].register("sv-action", {
    viewModel: {
        createViewModel: function (params) {
            var item = params.item;
            new _kobase__WEBPACK_IMPORTED_MODULE_1__["ImplementorBase"](item);
            return params;
        },
    },
    template: template
});


/***/ }),

/***/ "./src/knockout/components/boolean-checkbox/boolean-checkbox.html":
/*!************************************************************************!*\
  !*** ./src/knockout/components/boolean-checkbox/boolean-checkbox.html ***!
  \************************************************************************/
/*! no static exports found */
/***/ (function(module, exports) {

module.exports = "<div data-bind=\"css: question.koCss().root\">\n  <label data-bind=\"css: question.getItemCss()\">\n    <input\n      type=\"checkbox\"\n      data-bind=\"value: question.checkedValue, css: question.koCss().control, attr: {name: question.name, id: question.inputId, 'aria-required': question.ariaRequired, 'aria-label': question.ariaLabel, 'aria-invalid': question.ariaInvalid, 'aria-describedby': question.ariaDescribedBy}, checked: question.checkedValue, surveyProp: {indeterminate: question.isIndeterminate}, enable: !question.isInputReadOnly\"\n    />\n    <span data-bind=\"css: question.koCss().materialDecorator\">\n      <!-- ko if: question.svgIcon -->\n      <svg data-bind=\"css:question.koCss().itemDecorator\">\n        <use data-bind=\"attr:{'xlink:href':question.svgIcon}\" xlink:href=''></use>\n      </svg>\n      <!-- /ko -->\n      <!-- ko ifnot: question.svgIcon -->\n      <svg viewBox=\"0 0 24 24\" data-bind=\"css:question.koCss().itemDecorator\">\n        <rect\n          data-bind=\"css:question.koCss().uncheckedPath\"\n          x=\"5\"\n          y=\"10\"\n          width=\"14\"\n          height=\"4\"\n        />\n        <polygon\n          data-bind=\"css:question.koCss().checkedPath\"\n          points=\"19,10 14,10 14,5 10,5 10,10 5,10 5,14 10,14 10,19 14,19 14,14 19,14 \"\n        />\n        <path\n          data-bind=\"css:question.koCss().indeterminatePath\"\n          d=\"M22,0H2C0.9,0,0,0.9,0,2v20c0,1.1,0.9,2,2,2h20c1.1,0,2-0.9,2-2V2C24,0.9,23.1,0,22,0z M21,18L6,3h15V18z M3,6l15,15H3V6z\"\n        />\n      </svg>\n      <!-- /ko -->\n      <span class=\"check\"></span>\n    </span>\n    <span\n      data-bind=\"if: question.titleLocation === 'hidden', css: question.koCss().label\"\n    >\n      <!-- ko template: { name: 'survey-string', data: question.locDisplayLabel } -->\n      <!-- /ko -->\n    </span>\n  </label>\n</div>\n";

/***/ }),

/***/ "./src/knockout/components/boolean-checkbox/boolean-checkbox.ts":
/*!**********************************************************************!*\
  !*** ./src/knockout/components/boolean-checkbox/boolean-checkbox.ts ***!
  \**********************************************************************/
/*! exports provided: CheckboxViewModel */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "CheckboxViewModel", function() { return CheckboxViewModel; });
/* harmony import */ var knockout__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! knockout */ "knockout");
/* harmony import */ var knockout__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(knockout__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var survey_core__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! survey-core */ "./src/entries/core.ts");


var template = __webpack_require__(/*! ./boolean-checkbox.html */ "./src/knockout/components/boolean-checkbox/boolean-checkbox.html");
var CheckboxViewModel;
knockout__WEBPACK_IMPORTED_MODULE_0__["components"].register("sv-boolean-checkbox", {
    viewModel: {
        createViewModel: function (params, componentInfo) {
            return { question: params.question };
        },
    },
    template: template,
});
survey_core__WEBPACK_IMPORTED_MODULE_1__["RendererFactory"].Instance.registerRenderer("boolean", "checkbox", "sv-boolean-checkbox");


/***/ }),

/***/ "./src/knockout/components/boolean-radio/boolean-radio-item.html":
/*!***********************************************************************!*\
  !*** ./src/knockout/components/boolean-radio/boolean-radio-item.html ***!
  \***********************************************************************/
/*! no static exports found */
/***/ (function(module, exports) {

module.exports = "  <div role=\"presentation\" data-bind=\"class: question.getRadioItemClass(question.koCss(), $data.value)\">\n    <label data-bind=\"css: question.koCss().radioLabel\">\n      <input\n        type=\"radio\"\n        data-bind=\"event: { change: handleChange }, attr: { name: question.name, 'aria-describedby': question.ariaDescribedBy, value: $data.value?'true':'false', checked:  $data.value === question.value }, enable: !question.isInputReadOnly, css: question.koCss().itemControl\"\n      />\n      <!-- ko if: question.koCss().materialRadioDecorator -->\n      <span data-bind=\"css: question.koCss().materialRadioDecorator\">\n        <!-- ko if: question.itemSvgIcon -->\n        <svg data-bind=\"css:question.koCss().itemRadioDecorator\">\n          <use data-bind=\"attr:{'xlink:href':question.itemSvgIcon}\" xlink:href=''></use>\n        </svg>\n        <!-- /ko -->\n      </span>\n      <!-- /ko -->\n      <span data-bind=\"css: question.koCss().radioControlLabel\">\n        <!-- ko template: { name: 'survey-string', data: $data.locText } -->\n        <!-- /ko -->\n      </span>\n    </label>\n  </div>\n\n";

/***/ }),

/***/ "./src/knockout/components/boolean-radio/boolean-radio-item.ts":
/*!*********************************************************************!*\
  !*** ./src/knockout/components/boolean-radio/boolean-radio-item.ts ***!
  \*********************************************************************/
/*! exports provided: BooleanRadioItemViewModel */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "BooleanRadioItemViewModel", function() { return BooleanRadioItemViewModel; });
/* harmony import */ var knockout__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! knockout */ "knockout");
/* harmony import */ var knockout__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(knockout__WEBPACK_IMPORTED_MODULE_0__);

var template = __webpack_require__(/*! ./boolean-radio-item.html */ "./src/knockout/components/boolean-radio/boolean-radio-item.html");
var BooleanRadioItemViewModel;
knockout__WEBPACK_IMPORTED_MODULE_0__["components"].register("sv-boolean-radio-item", {
    viewModel: {
        createViewModel: function (params) {
            params.handleChange = function () {
                params.question.value = params.value;
            };
            return params;
        },
    },
    template: template,
});


/***/ }),

/***/ "./src/knockout/components/boolean-radio/boolean-radio.html":
/*!******************************************************************!*\
  !*** ./src/knockout/components/boolean-radio/boolean-radio.html ***!
  \******************************************************************/
/*! no static exports found */
/***/ (function(module, exports) {

module.exports = "<div data-bind=\"css: question.koCss().rootRadio\">\n  <fieldset role=\"presentation\" data-bind=\"css: question.koCss().radioFieldset\">\n    <!-- ko component: { name: 'sv-boolean-radio-item', params: { value: false, locText: question.locLabelFalse, question: question } } --><!-- /ko -->\n    <!-- ko component: { name: 'sv-boolean-radio-item', params: { value: true, locText: question.locLabelTrue, question: question } } --><!-- /ko -->  \n  </fieldset>\n</div>\n";

/***/ }),

/***/ "./src/knockout/components/boolean-radio/boolean-radio.ts":
/*!****************************************************************!*\
  !*** ./src/knockout/components/boolean-radio/boolean-radio.ts ***!
  \****************************************************************/
/*! exports provided: BooleanRadioItemViewModel, BooleanRadioViewModel */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "BooleanRadioViewModel", function() { return BooleanRadioViewModel; });
/* harmony import */ var knockout__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! knockout */ "knockout");
/* harmony import */ var knockout__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(knockout__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var survey_core__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! survey-core */ "./src/entries/core.ts");
/* harmony import */ var _boolean_radio_item__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./boolean-radio-item */ "./src/knockout/components/boolean-radio/boolean-radio-item.ts");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "BooleanRadioItemViewModel", function() { return _boolean_radio_item__WEBPACK_IMPORTED_MODULE_2__["BooleanRadioItemViewModel"]; });




var template = __webpack_require__(/*! ./boolean-radio.html */ "./src/knockout/components/boolean-radio/boolean-radio.html");
var BooleanRadioViewModel;
knockout__WEBPACK_IMPORTED_MODULE_0__["components"].register("sv-boolean-radio", {
    viewModel: {
        createViewModel: function (params, componentInfo) {
            return { question: params.question };
        },
    },
    template: template,
});
survey_core__WEBPACK_IMPORTED_MODULE_1__["RendererFactory"].Instance.registerRenderer("boolean", "radio", "sv-boolean-radio");


/***/ }),

/***/ "./src/knockout/components/button-group/button-group-item.html":
/*!*********************************************************************!*\
  !*** ./src/knockout/components/button-group/button-group-item.html ***!
  \*********************************************************************/
/*! no static exports found */
/***/ (function(module, exports) {

module.exports = "<label data-bind=\"css: model.css.label, attr: { title: model.caption.koRenderedHtml }\">\r\n  <input type=\"radio\"\r\n    data-bind=\"attr: { name: model.name, id: model.id, 'aria-required': model.isRequired, 'aria-label': model.caption.koRenderedHtml, role: 'radio', 'aria-invalid': model.hasErrors, 'aria-describedby': model.describeBy}, checkedValue: model.value, checked: model.question.renderedValue, disable: model.readOnly, css: model.css.control\" />\r\n  <div data-bind=\"css: model.css.decorator\">\r\n    <!-- ko if: !!model.iconName-->\r\n    <sv-svg-icon data-bind=\"css: model.css.icon\" params=\"iconName: model.iconName, size: model.iconSize\"></sv-svg-icon>\r\n    <!-- /ko -->\r\n    <!-- ko if: model.showCaption -->\r\n    <span data-bind=\"css: model.css.caption, attr: { title: model.caption.koRenderedHtml }\">\r\n      <!-- ko template: { name: 'survey-string', data: model.caption } -->\r\n      <!-- /ko -->\r\n    </span>\r\n    <!-- /ko -->\r\n  </div>\r\n</label>";

/***/ }),

/***/ "./src/knockout/components/button-group/button-group-item.ts":
/*!*******************************************************************!*\
  !*** ./src/knockout/components/button-group/button-group-item.ts ***!
  \*******************************************************************/
/*! exports provided: ButtonGroupItemViewModel */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "ButtonGroupItemViewModel", function() { return ButtonGroupItemViewModel; });
/* harmony import */ var knockout__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! knockout */ "knockout");
/* harmony import */ var knockout__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(knockout__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var survey_core__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! survey-core */ "./src/entries/core.ts");


var template = __webpack_require__(/*! ./button-group-item.html */ "./src/knockout/components/button-group/button-group-item.html");
var ButtonGroupItemViewModel = /** @class */ (function () {
    function ButtonGroupItemViewModel(model) {
        this.model = model;
    }
    return ButtonGroupItemViewModel;
}());

knockout__WEBPACK_IMPORTED_MODULE_0__["components"].register("sv-button-group-item", {
    viewModel: {
        createViewModel: function (params) {
            var model = new survey_core__WEBPACK_IMPORTED_MODULE_1__["ButtonGroupItemModel"](params.question, params.item, params.index());
            var viewModel = new ButtonGroupItemViewModel(model);
            return viewModel;
        },
    },
    template: template,
});


/***/ }),

/***/ "./src/knockout/components/dropdown/dropdown.html":
/*!********************************************************!*\
  !*** ./src/knockout/components/dropdown/dropdown.html ***!
  \********************************************************/
/*! no static exports found */
/***/ (function(module, exports) {

module.exports = "<div data-bind=\"css: question.koCss().selectWrapper\">\n  <!-- ko ifnot: question.isReadOnly -->\n  <select\n  data-bind=\"options: question.visibleChoices, optionsValue: 'value', optionsText: 'text', optionsCaption: question.showOptionsCaption ? question.locOptionsCaption.koRenderedHtml : undefined, optionsAfterRender: question.koDisableOption, attr: {id: question.inputId, autoComplete: question.autoComplete, required: question.isRequired, 'aria-required': question.ariaRequired, 'aria-label': question.ariaLabel, 'aria-invalid': question.ariaInvalid, 'aria-describedby': question.ariaDescribedBy}, disable: question.isInputReadOnly, value: question.renderedValue, valueAllowUnset: true, css: question.getControlClass()\">\n  </select>\n<!-- /ko -->\n  <!-- ko if: question.isReadOnly -->\n  <div disabled data-bind=\"attr: {id: question.inputId}, text: question.readOnlyText, css: question.getControlClass()\"></div>\n  <!-- /ko -->\n</div>\n";

/***/ }),

/***/ "./src/knockout/components/dropdown/dropdown.ts":
/*!******************************************************!*\
  !*** ./src/knockout/components/dropdown/dropdown.ts ***!
  \******************************************************/
/*! exports provided: DropdownViewModel */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "DropdownViewModel", function() { return DropdownViewModel; });
/* harmony import */ var knockout__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! knockout */ "knockout");
/* harmony import */ var knockout__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(knockout__WEBPACK_IMPORTED_MODULE_0__);

var template = __webpack_require__(/*! ./dropdown.html */ "./src/knockout/components/dropdown/dropdown.html");
var DropdownViewModel;
knockout__WEBPACK_IMPORTED_MODULE_0__["components"].register("sv-dropdown", {
    viewModel: {
        createViewModel: function (params, componentInfo) {
            return { question: params.question };
        },
    },
    template: template,
});


/***/ }),

/***/ "./src/knockout/components/list/list-item.html":
/*!*****************************************************!*\
  !*** ./src/knockout/components/list/list-item.html ***!
  \*****************************************************/
/*! no static exports found */
/***/ (function(module, exports) {

module.exports = "<li\r\n  data-bind=\"style: { paddingLeft: $data.model.getItemIndent($data.item) }, css: $data.model.getItemClass($data.item), click: itemClick, key2click, visible: $data.item.visible, event: { pointerdown: function (model, event) { $data.model.onPointerDown(event, $data.item); } }\">\r\n  <!-- ko ifnot: $data.item.component -->\r\n  <!-- ko if: $data.item.iconName -->\r\n  <sv-svg-icon class=\"sv-list__item-icon\" params=\"iconName: $data.item.iconName, size: 24\"></sv-svg-icon>\r\n  <!-- /ko -->\r\n  <span data-bind=\"text: $data.item.title\"></span>\r\n  <!-- /ko -->\r\n  <!-- ko if: $data.item.component -->\r\n  <!-- ko component: { name: $data.item.component, params: { item: $data.item } } -->\r\n  <!-- /ko -->\r\n  <!-- /ko -->\r\n</li>";

/***/ }),

/***/ "./src/knockout/components/list/list-item.ts":
/*!***************************************************!*\
  !*** ./src/knockout/components/list/list-item.ts ***!
  \***************************************************/
/*! exports provided: ListItemViewComponent */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "ListItemViewComponent", function() { return ListItemViewComponent; });
/* harmony import */ var knockout__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! knockout */ "knockout");
/* harmony import */ var knockout__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(knockout__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _kobase__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../kobase */ "./src/knockout/kobase.ts");


var template = __webpack_require__(/*! ./list-item.html */ "./src/knockout/components/list/list-item.html");
var ListItemViewComponent;
knockout__WEBPACK_IMPORTED_MODULE_0__["components"].register("sv-list-item", {
    viewModel: {
        createViewModel: function (params, componentInfo) {
            new _kobase__WEBPACK_IMPORTED_MODULE_1__["ImplementorBase"](params.item);
            return {
                item: params.item,
                model: params.model,
                itemClick: function (data) { return data.model.selectItem(data.item); }
            };
        },
    },
    template: template,
});


/***/ }),

/***/ "./src/knockout/components/list/list.html":
/*!************************************************!*\
  !*** ./src/knockout/components/list/list.html ***!
  \************************************************/
/*! no static exports found */
/***/ (function(module, exports) {

module.exports = "<div class=\"sv-list__container\">\n  <!-- ko if: $data.model.needFilter -->\n  <div class=\"sv-list__filter\">\n    <sv-svg-icon class=\"sv-list__filter-icon\" params=\"iconName: 'icon-search', size: 24\"></sv-svg-icon>\n    <input type=\"text\" class=\"sv-list__input\"\n      data-bind=\"textInput: model.filteredText, attr: { placeholder: model.filteredTextPlaceholder }\"></input>\n  </div>\n  <!-- /ko -->\n  <ul class=\"sv-list\"\n    data-bind=\"event: { mousedown: function (data, e) { e.preventDefault(); }, keydown: function(data, e) { $data.model.onKeyDown(event); return true; } }\">\n    <!--ko foreach: model.renderedActions -->\n    <!-- ko component: { name: 'sv-list-item', params: { item: $data, model: $parent.model } } -->\n    <!-- /ko -->\n    <!-- /ko -->\n  </ul>\n</div>";

/***/ }),

/***/ "./src/knockout/components/list/list.ts":
/*!**********************************************!*\
  !*** ./src/knockout/components/list/list.ts ***!
  \**********************************************/
/*! exports provided: ListItemViewComponent, ListViewComponent */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "ListViewComponent", function() { return ListViewComponent; });
/* harmony import */ var knockout__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! knockout */ "knockout");
/* harmony import */ var knockout__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(knockout__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _action_bar_action_bar__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../action-bar/action-bar */ "./src/knockout/components/action-bar/action-bar.ts");
/* harmony import */ var _list_item__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./list-item */ "./src/knockout/components/list/list-item.ts");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "ListItemViewComponent", function() { return _list_item__WEBPACK_IMPORTED_MODULE_2__["ListItemViewComponent"]; });



var template = __webpack_require__(/*! ./list.html */ "./src/knockout/components/list/list.html");

var ListViewComponent;
knockout__WEBPACK_IMPORTED_MODULE_0__["components"].register("sv-list", {
    viewModel: {
        createViewModel: function (params, componentInfo) {
            var model = params.model;
            var _implementor = new _action_bar_action_bar__WEBPACK_IMPORTED_MODULE_1__["ActionContainerImplementor"](model);
            return { model: model, dispose: function () { _implementor.dispose(); } };
        },
    },
    template: template,
});


/***/ }),

/***/ "./src/knockout/components/logo-image/logo-image.html":
/*!************************************************************!*\
  !*** ./src/knockout/components/logo-image/logo-image.html ***!
  \************************************************************/
/*! no static exports found */
/***/ (function(module, exports) {

module.exports = "<!-- ko with: survey -->\n<div data-bind=\"css: logoClassNames\">\n  <img data-bind=\"css: css.logoImage, attr: { src: locLogo.koRenderedHtml, width: logoWidth ? logoWidth : undefined, height: logoHeight ? logoHeight : undefined, alt: locTitle.renderedHtml }, style: { objectFit: logoFit }\">\n</div>\n<!-- /ko -->";

/***/ }),

/***/ "./src/knockout/components/logo-image/logo-image.ts":
/*!**********************************************************!*\
  !*** ./src/knockout/components/logo-image/logo-image.ts ***!
  \**********************************************************/
/*! exports provided: LogoImageViewModel */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "LogoImageViewModel", function() { return LogoImageViewModel; });
/* harmony import */ var knockout__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! knockout */ "knockout");
/* harmony import */ var knockout__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(knockout__WEBPACK_IMPORTED_MODULE_0__);

var template = __webpack_require__(/*! ./logo-image.html */ "./src/knockout/components/logo-image/logo-image.html");
var LogoImageViewModel;
knockout__WEBPACK_IMPORTED_MODULE_0__["components"].register("sv-logo-image", {
    viewModel: {
        createViewModel: function (params) {
            return { survey: params };
        },
    },
    template: template
});


/***/ }),

/***/ "./src/knockout/components/matrix-actions/detail-button/detail-button.html":
/*!*********************************************************************************!*\
  !*** ./src/knockout/components/matrix-actions/detail-button/detail-button.html ***!
  \*********************************************************************************/
/*! no static exports found */
/***/ (function(module, exports) {

module.exports = "<button\ntype=\"button\"\ndata-bind=\"css:question.getDetailPanelButtonCss(row), click:row.showHideDetailPanelClick, attr:{ 'aria-expanded': question.getIsDetailPanelShowing($data.row) ? 'true': 'false', 'aria-controls': question.getIsDetailPanelShowing($data.row) ? row.detailPanelId: false}\"\n>\n<span\n  data-bind=\"css: question.getDetailPanelIconCss(row), component: { name: 'sv-svg-icon', params: {iconName: question.getDetailPanelIconId(row)} }\"\n>\n</span>\n</button>\n<!-- ko if: question.detailPanelMode === \"popup\" && question.getKoPopupIsVisible(row) -->\n<sv-popup\nparams=\"contentComponentName: 'sv-panel', contentComponentData: { question: row.detailPanel, onItemSelect: function(){} }, isVisible: question.getKoPopupIsVisible(row), isModal: true, onHide: function() { row.hideDetailPanel() }, verticalPosition: 'top', horizontalPosition: 'right'\"\n></sv-popup>\n<!-- /ko -->";

/***/ }),

/***/ "./src/knockout/components/matrix-actions/detail-button/detail-button.ts":
/*!*******************************************************************************!*\
  !*** ./src/knockout/components/matrix-actions/detail-button/detail-button.ts ***!
  \*******************************************************************************/
/*! exports provided: SurveyQuestionMatrixDetailButton */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "SurveyQuestionMatrixDetailButton", function() { return SurveyQuestionMatrixDetailButton; });
/* harmony import */ var knockout__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! knockout */ "knockout");
/* harmony import */ var knockout__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(knockout__WEBPACK_IMPORTED_MODULE_0__);

var template = __webpack_require__(/*! ./detail-button.html */ "./src/knockout/components/matrix-actions/detail-button/detail-button.html");
var SurveyQuestionMatrixDetailButton;
knockout__WEBPACK_IMPORTED_MODULE_0__["components"].register("sv-matrix-detail-button", {
    viewModel: {
        createViewModel: function (params, componentInfo) {
            return params.item.data;
        },
    },
    template: template,
});


/***/ }),

/***/ "./src/knockout/components/matrix-actions/drag-drop-icon/drag-drop-icon.html":
/*!***********************************************************************************!*\
  !*** ./src/knockout/components/matrix-actions/drag-drop-icon/drag-drop-icon.html ***!
  \***********************************************************************************/
/*! no static exports found */
/***/ (function(module, exports) {

module.exports = "<span\n  data-bind=\"css: question.koCss().iconDrag\"\n></span>\n";

/***/ }),

/***/ "./src/knockout/components/matrix-actions/drag-drop-icon/drag-drop-icon.ts":
/*!*********************************************************************************!*\
  !*** ./src/knockout/components/matrix-actions/drag-drop-icon/drag-drop-icon.ts ***!
  \*********************************************************************************/
/*! exports provided: SurveyQuestionMatrixDynamicDragDropIcon */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "SurveyQuestionMatrixDynamicDragDropIcon", function() { return SurveyQuestionMatrixDynamicDragDropIcon; });
/* harmony import */ var knockout__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! knockout */ "knockout");
/* harmony import */ var knockout__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(knockout__WEBPACK_IMPORTED_MODULE_0__);

var template = __webpack_require__(/*! ./drag-drop-icon.html */ "./src/knockout/components/matrix-actions/drag-drop-icon/drag-drop-icon.html");
var SurveyQuestionMatrixDynamicDragDropIcon;
knockout__WEBPACK_IMPORTED_MODULE_0__["components"].register("sv-matrix-drag-drop-icon", {
    viewModel: {
        createViewModel: function (params, componentInfo) {
            return params.item.data;
        },
    },
    template: template,
});


/***/ }),

/***/ "./src/knockout/components/matrix-actions/remove-button/remove-button.html":
/*!*********************************************************************************!*\
  !*** ./src/knockout/components/matrix-actions/remove-button/remove-button.html ***!
  \*********************************************************************************/
/*! no static exports found */
/***/ (function(module, exports) {

module.exports = "<button\n  type=\"button\"\n  data-bind=\"click: question.koRemoveRowClick, disable: question.isInputReadOnly, css: question.getRemoveRowButtonCss()\"\n>\n  <!-- ko template: { name: 'survey-string', data: question.locRemoveRowText } --><!-- /ko -->\n  <span data-bind=\"css: question.koCss().iconRemove\"></span>\n</button>\n";

/***/ }),

/***/ "./src/knockout/components/matrix-actions/remove-button/remove-button.ts":
/*!*******************************************************************************!*\
  !*** ./src/knockout/components/matrix-actions/remove-button/remove-button.ts ***!
  \*******************************************************************************/
/*! exports provided: SurveyQuestionMatrixDynamicRemoveButton */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "SurveyQuestionMatrixDynamicRemoveButton", function() { return SurveyQuestionMatrixDynamicRemoveButton; });
/* harmony import */ var knockout__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! knockout */ "knockout");
/* harmony import */ var knockout__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(knockout__WEBPACK_IMPORTED_MODULE_0__);

var template = __webpack_require__(/*! ./remove-button.html */ "./src/knockout/components/matrix-actions/remove-button/remove-button.html");
var SurveyQuestionMatrixDynamicRemoveButton;
knockout__WEBPACK_IMPORTED_MODULE_0__["components"].register("sv-matrix-remove-button", {
    viewModel: {
        createViewModel: function (params) {
            return params.item.data;
        },
    },
    template: template
});


/***/ }),

/***/ "./src/knockout/components/panel/panel.ts":
/*!************************************************!*\
  !*** ./src/knockout/components/panel/panel.ts ***!
  \************************************************/
/*! exports provided: PanelViewModel */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "PanelViewModel", function() { return PanelViewModel; });
/* harmony import */ var knockout__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! knockout */ "knockout");
/* harmony import */ var knockout__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(knockout__WEBPACK_IMPORTED_MODULE_0__);

var template = __webpack_require__(/*! html-loader?interpolate!val-loader!./panel.html */ "./node_modules/html-loader/index.js?interpolate!./node_modules/val-loader/index.js!./src/knockout/components/panel/panel.html");
var PanelViewModel = /** @class */ (function () {
    function PanelViewModel(question, targetElement) {
        this.question = question;
        this.targetElement = targetElement;
    }
    return PanelViewModel;
}());

knockout__WEBPACK_IMPORTED_MODULE_0__["components"].register("sv-panel", {
    viewModel: {
        createViewModel: function (params, componentInfo) {
            var viewModel = new PanelViewModel(params.question, componentInfo.element.parentElement);
            return viewModel;
        },
    },
    template: template,
});


/***/ }),

/***/ "./src/knockout/components/paneldynamic-actions/paneldynamic-actions.ts":
/*!******************************************************************************!*\
  !*** ./src/knockout/components/paneldynamic-actions/paneldynamic-actions.ts ***!
  \******************************************************************************/
/*! exports provided: SurveyQuestionPaneldynamicActioons */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "SurveyQuestionPaneldynamicActioons", function() { return SurveyQuestionPaneldynamicActioons; });
/* harmony import */ var knockout__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! knockout */ "knockout");
/* harmony import */ var knockout__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(knockout__WEBPACK_IMPORTED_MODULE_0__);

var addBtnTemplate = __webpack_require__(/*! ./paneldynamic-add-btn.html */ "./src/knockout/components/paneldynamic-actions/paneldynamic-add-btn.html");
var nextBtnTemplate = __webpack_require__(/*! ./paneldynamic-next-btn.html */ "./src/knockout/components/paneldynamic-actions/paneldynamic-next-btn.html");
var prevBtnTemplate = __webpack_require__(/*! ./paneldynamic-prev-btn.html */ "./src/knockout/components/paneldynamic-actions/paneldynamic-prev-btn.html");
var progressTextTemplate = __webpack_require__(/*! ./paneldynamic-progress-text.html */ "./src/knockout/components/paneldynamic-actions/paneldynamic-progress-text.html");
var SurveyQuestionPaneldynamicActioons;
function getPaneldynamicActionViewModel() {
    return {
        createViewModel: function (params, componentInfo) {
            return (!!params.item && params.item.data) || params;
        },
    };
}
knockout__WEBPACK_IMPORTED_MODULE_0__["components"].register("sv-paneldynamic-add-btn", {
    viewModel: getPaneldynamicActionViewModel(),
    template: addBtnTemplate,
});
knockout__WEBPACK_IMPORTED_MODULE_0__["components"].register("sv-paneldynamic-next-btn", {
    viewModel: getPaneldynamicActionViewModel(),
    template: nextBtnTemplate,
});
knockout__WEBPACK_IMPORTED_MODULE_0__["components"].register("sv-paneldynamic-prev-btn", {
    viewModel: getPaneldynamicActionViewModel(),
    template: prevBtnTemplate,
});
knockout__WEBPACK_IMPORTED_MODULE_0__["components"].register("sv-paneldynamic-progress-text", {
    viewModel: getPaneldynamicActionViewModel(),
    template: progressTextTemplate,
});


/***/ }),

/***/ "./src/knockout/components/paneldynamic-actions/paneldynamic-add-btn.html":
/*!********************************************************************************!*\
  !*** ./src/knockout/components/paneldynamic-actions/paneldynamic-add-btn.html ***!
  \********************************************************************************/
/*! no static exports found */
/***/ (function(module, exports) {

module.exports = "<!-- ko if: question.koCanAddPanel -->\n<button type=\"button\" data-bind=\"click: question.koAddPanelClick, css: question.koAddButtonCss, visible: question.koCanAddPanel\">\n  <span data-bind=\"css: question.koCss().buttonAddText, text: question.panelAddText\"></span>\n</button>\n<!-- /ko -->";

/***/ }),

/***/ "./src/knockout/components/paneldynamic-actions/paneldynamic-next-btn.html":
/*!*********************************************************************************!*\
  !*** ./src/knockout/components/paneldynamic-actions/paneldynamic-next-btn.html ***!
  \*********************************************************************************/
/*! no static exports found */
/***/ (function(module, exports) {

module.exports = "<div data-bind=\"attr: { title: question.panelNextText }, click: question.koNextPanelClick, css: question.koNextButtonCss\">\n    <!-- ko component: { name: 'sv-svg-icon', params: { iconName: question.koCss().progressBtnIcon, size: 'auto' } } --><!-- /ko -->\n</div>";

/***/ }),

/***/ "./src/knockout/components/paneldynamic-actions/paneldynamic-prev-btn.html":
/*!*********************************************************************************!*\
  !*** ./src/knockout/components/paneldynamic-actions/paneldynamic-prev-btn.html ***!
  \*********************************************************************************/
/*! no static exports found */
/***/ (function(module, exports) {

module.exports = "<div data-bind=\"attr: { title: question.panelPrevText }, click: question.koPrevPanelClick, css: question.koPrevButtonCss\">\n    <!-- ko component: { name: 'sv-svg-icon', params: { iconName: question.koCss().progressBtnIcon, size: 'auto' } } --><!-- /ko -->\n</div>";

/***/ }),

/***/ "./src/knockout/components/paneldynamic-actions/paneldynamic-progress-text.html":
/*!**************************************************************************************!*\
  !*** ./src/knockout/components/paneldynamic-actions/paneldynamic-progress-text.html ***!
  \**************************************************************************************/
/*! no static exports found */
/***/ (function(module, exports) {

module.exports = "<div data-bind=\"text: question.koProgressText, css: question.koCss().progressText\"></div>";

/***/ }),

/***/ "./src/knockout/components/popup/popup.ts":
/*!************************************************!*\
  !*** ./src/knockout/components/popup/popup.ts ***!
  \************************************************/
/*! exports provided: PopupViewModel, showModal */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "PopupViewModel", function() { return PopupViewModel; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "showModal", function() { return showModal; });
/* harmony import */ var knockout__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! knockout */ "knockout");
/* harmony import */ var knockout__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(knockout__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var survey_core__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! survey-core */ "./src/entries/core.ts");
/* harmony import */ var _kobase__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../kobase */ "./src/knockout/kobase.ts");




var template = __webpack_require__(/*! html-loader?interpolate!val-loader!./popup.html */ "./node_modules/html-loader/index.js?interpolate!./node_modules/val-loader/index.js!./src/knockout/components/popup/popup.html");
var PopupViewModel = /** @class */ (function () {
    function PopupViewModel(popupViewModel) {
        this.popupViewModel = popupViewModel;
        if (!popupViewModel.container)
            popupViewModel.initializePopupContainer();
        new _kobase__WEBPACK_IMPORTED_MODULE_2__["ImplementorBase"](popupViewModel.model);
        new _kobase__WEBPACK_IMPORTED_MODULE_2__["ImplementorBase"](popupViewModel);
        popupViewModel.container.innerHTML = template;
        popupViewModel.model.onVisibilityChanged = function (isVisible) {
            if (isVisible) {
                knockout__WEBPACK_IMPORTED_MODULE_0__["tasks"].runEarly();
                popupViewModel.updateOnShowing();
            }
        };
        knockout__WEBPACK_IMPORTED_MODULE_0__["applyBindings"](popupViewModel, popupViewModel.container);
    }
    PopupViewModel.prototype.dispose = function () {
        knockout__WEBPACK_IMPORTED_MODULE_0__["cleanNode"](this.popupViewModel.container);
        this.popupViewModel.destroyPopupContainer();
    };
    return PopupViewModel;
}());

function showModal(componentName, data, onApply, onCancel, cssClass, title, displayMode) {
    if (displayMode === void 0) { displayMode = "popup"; }
    var popupViewModel = Object(survey_core__WEBPACK_IMPORTED_MODULE_1__["createPopupModalViewModel"])(componentName, data, onApply, onCancel, function () {
        viewModel.dispose();
    }, undefined, cssClass, title, displayMode);
    var viewModel = new PopupViewModel(popupViewModel);
    popupViewModel.model.isVisible = true;
}
survey_core__WEBPACK_IMPORTED_MODULE_1__["settings"].showModal = showModal;
knockout__WEBPACK_IMPORTED_MODULE_0__["components"].register("sv-popup", {
    viewModel: {
        createViewModel: function (params, componentInfo) {
            var viewModel = new survey_core__WEBPACK_IMPORTED_MODULE_1__["PopupBaseViewModel"](knockout__WEBPACK_IMPORTED_MODULE_0__["unwrap"](params.model), componentInfo.element.parentElement);
            return new PopupViewModel(viewModel);
        },
    },
    template: "<div></div>",
});


/***/ }),

/***/ "./src/knockout/components/progress/buttons.ts":
/*!*****************************************************!*\
  !*** ./src/knockout/components/progress/buttons.ts ***!
  \*****************************************************/
/*! exports provided: ProgressButtonsViewModel */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "ProgressButtonsViewModel", function() { return ProgressButtonsViewModel; });
/* harmony import */ var knockout__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! knockout */ "knockout");
/* harmony import */ var knockout__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(knockout__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var survey_core__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! survey-core */ "./src/entries/core.ts");


var template = __webpack_require__(/*! html-loader?interpolate!val-loader!./buttons.html */ "./node_modules/html-loader/index.js?interpolate!./node_modules/val-loader/index.js!./src/knockout/components/progress/buttons.html");
var ProgressButtonsViewModel = /** @class */ (function () {
    function ProgressButtonsViewModel(survey, element) {
        var _this = this;
        this.survey = survey;
        this.scrollButtonCssKo = undefined;
        this.hasScroller = knockout__WEBPACK_IMPORTED_MODULE_0__["observable"](false);
        this.updateScroller = undefined;
        this.progressButtonsModel = new survey_core__WEBPACK_IMPORTED_MODULE_1__["SurveyProgressButtonsModel"](survey);
        this.updateScroller = setInterval(function () {
            var listContainerElement = element.querySelector("." + survey.css.progressButtonsListContainer);
            if (!!listContainerElement) {
                _this.hasScroller(listContainerElement.scrollWidth > listContainerElement.offsetWidth);
            }
        }, 100);
    }
    ProgressButtonsViewModel.prototype.isListElementClickable = function (index) {
        return this.progressButtonsModel.isListElementClickable(index());
    };
    ProgressButtonsViewModel.prototype.getListElementCss = function (index) {
        return this.progressButtonsModel.getListElementCss(index());
    };
    ProgressButtonsViewModel.prototype.clickListElement = function (index) {
        this.progressButtonsModel.clickListElement(index());
    };
    ProgressButtonsViewModel.prototype.getScrollButtonCss = function (isLeftScroll) {
        var _this = this;
        this.scrollButtonCssKo = knockout__WEBPACK_IMPORTED_MODULE_0__["computed"](function () {
            return _this.progressButtonsModel.getScrollButtonCss(_this.hasScroller(), isLeftScroll);
        }, this);
        return this.scrollButtonCssKo;
    };
    ProgressButtonsViewModel.prototype.clickScrollButton = function (listContainerElement, isLeftScroll) {
        listContainerElement.scrollLeft += (isLeftScroll ? -1 : 1) * 70;
    };
    ProgressButtonsViewModel.prototype.dispose = function () {
        if (typeof this.updateScroller !== "undefined") {
            clearInterval(this.updateScroller);
            this.updateScroller = undefined;
        }
        if (typeof this.scrollButtonCssKo !== "undefined") {
            this.scrollButtonCssKo.dispose();
            this.scrollButtonCssKo = undefined;
        }
    };
    return ProgressButtonsViewModel;
}());

knockout__WEBPACK_IMPORTED_MODULE_0__["components"].register("sv-progress-buttons", {
    viewModel: {
        createViewModel: function (params, componentInfo) {
            return new ProgressButtonsViewModel(params.model, componentInfo.element.nextElementSibling);
        },
    },
    template: template
});


/***/ }),

/***/ "./src/knockout/components/progress/progress.ts":
/*!******************************************************!*\
  !*** ./src/knockout/components/progress/progress.ts ***!
  \******************************************************/
/*! exports provided: ProgressViewModel */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "ProgressViewModel", function() { return ProgressViewModel; });
/* harmony import */ var knockout__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! knockout */ "knockout");
/* harmony import */ var knockout__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(knockout__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var survey_core__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! survey-core */ "./src/entries/core.ts");


var template = __webpack_require__(/*! html-loader?interpolate!val-loader!./progress.html */ "./node_modules/html-loader/index.js?interpolate!./node_modules/val-loader/index.js!./src/knockout/components/progress/progress.html");
var ProgressViewModel = /** @class */ (function () {
    function ProgressViewModel(model) {
        this.model = model;
    }
    ProgressViewModel.prototype.getProgressTextInBarCss = function (css) {
        return survey_core__WEBPACK_IMPORTED_MODULE_1__["SurveyProgressModel"].getProgressTextInBarCss(css);
    };
    ProgressViewModel.prototype.getProgressTextUnderBarCss = function (css) {
        return survey_core__WEBPACK_IMPORTED_MODULE_1__["SurveyProgressModel"].getProgressTextUnderBarCss(css);
    };
    return ProgressViewModel;
}());

knockout__WEBPACK_IMPORTED_MODULE_0__["components"].register("sv-progress-progress", {
    viewModel: {
        createViewModel: function (params) {
            return new ProgressViewModel(params.model);
        }
    },
    template: template
});
var templateBridge = "<!-- ko component: { name: 'sv-progress-progress', params: $data } --><!-- /ko -->";
knockout__WEBPACK_IMPORTED_MODULE_0__["components"].register("sv-progress-pages", {
    viewModel: {
        createViewModel: function (params) {
            return new ProgressViewModel(params.model);
        }
    },
    template: templateBridge
});
knockout__WEBPACK_IMPORTED_MODULE_0__["components"].register("sv-progress-questions", {
    viewModel: {
        createViewModel: function (params) {
            return new ProgressViewModel(params.model);
        }
    },
    template: templateBridge
});
knockout__WEBPACK_IMPORTED_MODULE_0__["components"].register("sv-progress-correctQuestions", {
    viewModel: {
        createViewModel: function (params) {
            return new ProgressViewModel(params.model);
        }
    },
    template: templateBridge
});
knockout__WEBPACK_IMPORTED_MODULE_0__["components"].register("sv-progress-requiredQuestions", {
    viewModel: {
        createViewModel: function (params) {
            return new ProgressViewModel(params.model);
        }
    },
    template: templateBridge
});


/***/ }),

/***/ "./src/knockout/components/rating-dropdown/rating-dropdown.html":
/*!**********************************************************************!*\
  !*** ./src/knockout/components/rating-dropdown/rating-dropdown.html ***!
  \**********************************************************************/
/*! no static exports found */
/***/ (function(module, exports) {

module.exports = "<div data-bind=\"css: question.cssClasses.rootDropdown\">\n  <!-- ko component: { name: 'sv-dropdown', params: { question: question } } -->\n  <!-- /ko -->\n</div>\n";

/***/ }),

/***/ "./src/knockout/components/rating-dropdown/rating-dropdown.ts":
/*!********************************************************************!*\
  !*** ./src/knockout/components/rating-dropdown/rating-dropdown.ts ***!
  \********************************************************************/
/*! exports provided: RatingDropdownViewModel */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "RatingDropdownViewModel", function() { return RatingDropdownViewModel; });
/* harmony import */ var knockout__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! knockout */ "knockout");
/* harmony import */ var knockout__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(knockout__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var survey_core__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! survey-core */ "./src/entries/core.ts");


var template = __webpack_require__(/*! ./rating-dropdown.html */ "./src/knockout/components/rating-dropdown/rating-dropdown.html");
var RatingDropdownViewModel;
knockout__WEBPACK_IMPORTED_MODULE_0__["components"].register("sv-rating-dropdown", {
    viewModel: {
        createViewModel: function (params, componentInfo) {
            return { question: params.question };
        },
    },
    template: template,
});
survey_core__WEBPACK_IMPORTED_MODULE_1__["RendererFactory"].Instance.registerRenderer("rating", "dropdown", "sv-rating-dropdown");


/***/ }),

/***/ "./src/knockout/components/skeleton/skeleton.html":
/*!********************************************************!*\
  !*** ./src/knockout/components/skeleton/skeleton.html ***!
  \********************************************************/
/*! no static exports found */
/***/ (function(module, exports) {

module.exports = "<div class=\"sv-skeleton-element\">\n</div>";

/***/ }),

/***/ "./src/knockout/components/skeleton/skeleton.ts":
/*!******************************************************!*\
  !*** ./src/knockout/components/skeleton/skeleton.ts ***!
  \******************************************************/
/*! exports provided: Skeleton */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "Skeleton", function() { return Skeleton; });
/* harmony import */ var knockout__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! knockout */ "knockout");
/* harmony import */ var knockout__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(knockout__WEBPACK_IMPORTED_MODULE_0__);

var template = __webpack_require__(/*! ./skeleton.html */ "./src/knockout/components/skeleton/skeleton.html");
var Skeleton;
knockout__WEBPACK_IMPORTED_MODULE_0__["components"].register("sv-skeleton", {
    viewModel: {
        createViewModel: function (params, componentInfo) {
            return { question: params.question };
        },
    },
    template: template,
});


/***/ }),

/***/ "./src/knockout/components/string-editor/string-editor.html":
/*!******************************************************************!*\
  !*** ./src/knockout/components/string-editor/string-editor.html ***!
  \******************************************************************/
/*! no static exports found */
/***/ (function(module, exports) {

module.exports = "<!-- <input class=\"sv-string-editor\" data-bind=\"value: editValue\" /> -->\n\n<!-- ko ifnot: koHasHtml -->\n<span class=\"sv-string-editor\" style=\"position: static;\" data-bind=\"text: editValue, event: { blur: onInput, click: onClick, clickBubble: false }\" contenteditable=\"true\"></span>\n<!-- /ko -->\n<!-- ko if: koHasHtml -->\n<span class=\"sv-string-editor\" style=\"position: static;\" data-bind=\"html: editValue, event: { blur: onInput, click: onClick, clickBubble: false }\" contenteditable=\"true\"></span>\n<!-- /ko -->";

/***/ }),

/***/ "./src/knockout/components/string-editor/string-editor.ts":
/*!****************************************************************!*\
  !*** ./src/knockout/components/string-editor/string-editor.ts ***!
  \****************************************************************/
/*! exports provided: StringEditorViewModel */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "StringEditorViewModel", function() { return StringEditorViewModel; });
/* harmony import */ var knockout__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! knockout */ "knockout");
/* harmony import */ var knockout__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(knockout__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var survey_core__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! survey-core */ "./src/entries/core.ts");


var template = __webpack_require__(/*! ./string-editor.html */ "./src/knockout/components/string-editor/string-editor.html");
var StringEditorViewModel = /** @class */ (function () {
    function StringEditorViewModel(locString) {
        this.locString = locString;
    }
    Object.defineProperty(StringEditorViewModel.prototype, "koHasHtml", {
        get: function () {
            return this.locString.koHasHtml();
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(StringEditorViewModel.prototype, "editValue", {
        get: function () {
            return this.locString.koRenderedHtml();
        },
        set: function (value) {
            this.locString.searchElement = undefined;
            this.locString.text = value;
        },
        enumerable: false,
        configurable: true
    });
    StringEditorViewModel.prototype.onInput = function (sender, event) {
        sender.editValue = event.target.innerText;
    };
    StringEditorViewModel.prototype.onClick = function (sender, event) {
        event.stopPropagation();
    };
    StringEditorViewModel.prototype.dispose = function () {
        this.locString.onSearchChanged = undefined;
    };
    return StringEditorViewModel;
}());

function getSearchElement(element) {
    while (!!element && element.nodeName !== "SPAN") {
        var elements = element.parentElement.getElementsByClassName("sv-string-editor");
        element = elements.length > 0 ? elements[0] : undefined;
    }
    if (!!element && element.childNodes.length > 0)
        return element;
    return null;
}
function resetLocalizationSpan(element, locStr) {
    while (element.childNodes.length > 1) {
        element.removeChild(element.childNodes[1]);
    }
    element.childNodes[0].textContent = locStr.renderedHtml;
}
function applyLocStrOnSearchChanged(element, locStr) {
    locStr.onSearchChanged = function () {
        if (locStr.searchElement == undefined) {
            locStr.searchElement = getSearchElement(element);
        }
        if (locStr.searchElement == null)
            return;
        var el = locStr.searchElement;
        if (!locStr.highlightDiv) {
            locStr.highlightDiv = document.createElement("span");
            locStr.highlightDiv.style.backgroundColor = "lightgray";
        }
        if (locStr.searchIndex != undefined) {
            resetLocalizationSpan(el, locStr);
            var rng = document.createRange();
            rng.setStart(el.childNodes[0], locStr.searchIndex);
            rng.setEnd(el.childNodes[0], locStr.searchIndex + locStr.searchText.length);
            rng.surroundContents(locStr.highlightDiv);
        }
        else {
            resetLocalizationSpan(el, locStr);
            locStr.searchElement = undefined;
        }
    };
}
knockout__WEBPACK_IMPORTED_MODULE_0__["components"].register(survey_core__WEBPACK_IMPORTED_MODULE_1__["LocalizableString"].editableRenderer, {
    viewModel: {
        createViewModel: function (params, componentInfo) {
            var locStr = params.locString;
            applyLocStrOnSearchChanged(componentInfo.element, locStr);
            return new StringEditorViewModel(locStr);
        },
    },
    template: template
});


/***/ }),

/***/ "./src/knockout/components/string-viewer/string-viewer.html":
/*!******************************************************************!*\
  !*** ./src/knockout/components/string-viewer/string-viewer.html ***!
  \******************************************************************/
/*! no static exports found */
/***/ (function(module, exports) {

module.exports = "<!-- ko ifnot: locString.koHasHtml -->\n<span class=\"sv-string-viewer\" data-bind=\"text: locString.koRenderedHtml\"></span>\n<!-- /ko -->\n<!-- ko if: locString.koHasHtml -->\n<span class=\"sv-string-viewer\" data-bind=\"html: locString.koRenderedHtml\"></span>\n<!-- /ko -->";

/***/ }),

/***/ "./src/knockout/components/string-viewer/string-viewer.ts":
/*!****************************************************************!*\
  !*** ./src/knockout/components/string-viewer/string-viewer.ts ***!
  \****************************************************************/
/*! exports provided: StringViewerViewModel */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "StringViewerViewModel", function() { return StringViewerViewModel; });
/* harmony import */ var knockout__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! knockout */ "knockout");
/* harmony import */ var knockout__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(knockout__WEBPACK_IMPORTED_MODULE_0__);

var template = __webpack_require__(/*! ./string-viewer.html */ "./src/knockout/components/string-viewer/string-viewer.html");
var StringViewerViewModel;
knockout__WEBPACK_IMPORTED_MODULE_0__["components"].register("sv-string-viewer", {
    viewModel: {
        createViewModel: function (params, componentInfo) {
            return {
                locString: params.locString
            };
        },
    },
    template: template
});


/***/ }),

/***/ "./src/knockout/components/svg-icon/svg-icon.html":
/*!********************************************************!*\
  !*** ./src/knockout/components/svg-icon/svg-icon.html ***!
  \********************************************************/
/*! no static exports found */
/***/ (function(module, exports) {

module.exports = "<!-- ko if: hasIcon -->\n<svg class=\"sv-svg-icon\" data-bind=\"css: css, title: title\" role=\"img\"><use></use></svg>\n<!-- /ko -->\n";

/***/ }),

/***/ "./src/knockout/components/svg-icon/svg-icon.ts":
/*!******************************************************!*\
  !*** ./src/knockout/components/svg-icon/svg-icon.ts ***!
  \******************************************************/
/*! exports provided: SvgIconViewModel */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "SvgIconViewModel", function() { return SvgIconViewModel; });
/* harmony import */ var knockout__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! knockout */ "knockout");
/* harmony import */ var knockout__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(knockout__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var survey_core__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! survey-core */ "./src/entries/core.ts");


var template = __webpack_require__(/*! ./svg-icon.html */ "./src/knockout/components/svg-icon/svg-icon.html");
var SvgIconViewModel;
knockout__WEBPACK_IMPORTED_MODULE_0__["components"].register("sv-svg-icon", {
    viewModel: {
        createViewModel: function (params, componentInfo) {
            knockout__WEBPACK_IMPORTED_MODULE_0__["computed"](function () {
                var iconName = knockout__WEBPACK_IMPORTED_MODULE_0__["unwrap"](params.iconName);
                var element = componentInfo.element.querySelector && componentInfo.element.querySelector("svg") || componentInfo.element.nextElementSibling;
                if (iconName) {
                    Object(survey_core__WEBPACK_IMPORTED_MODULE_1__["createSvg"])(knockout__WEBPACK_IMPORTED_MODULE_0__["unwrap"](params.size), knockout__WEBPACK_IMPORTED_MODULE_0__["unwrap"](params.width), knockout__WEBPACK_IMPORTED_MODULE_0__["unwrap"](params.height), iconName, element);
                }
            });
            return {
                hasIcon: params.iconName,
                css: params.css,
                title: params.title
            };
        },
    },
    template: template,
});


/***/ }),

/***/ "./src/knockout/components/template-renderer/template-renderer.html":
/*!**************************************************************************!*\
  !*** ./src/knockout/components/template-renderer/template-renderer.html ***!
  \**************************************************************************/
/*! no static exports found */
/***/ (function(module, exports) {

module.exports = "<!-- ko if: templateData.name -->\n  <!-- ko template: { name: templateData.name, data: templateData.data, afterRender: templateData.afterRender } -->\n  <!-- /ko -->\n<!-- /ko -->\n<!-- ko ifnot: templateData.name -->\n  <!-- ko template: { nodes: templateData.nodes || $componentTemplateNodes, data: templateData.data, afterRender: templateData.afterRender } -->\n  <!-- /ko -->\n<!-- /ko -->\n";

/***/ }),

/***/ "./src/knockout/components/template-renderer/template-renderer.ts":
/*!************************************************************************!*\
  !*** ./src/knockout/components/template-renderer/template-renderer.ts ***!
  \************************************************************************/
/*! no exports provided */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var knockout__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! knockout */ "knockout");
/* harmony import */ var knockout__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(knockout__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var survey_core__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! survey-core */ "./src/entries/core.ts");


var template = __webpack_require__(/*! ./template-renderer.html */ "./src/knockout/components/template-renderer/template-renderer.html");
knockout__WEBPACK_IMPORTED_MODULE_0__["components"].register(survey_core__WEBPACK_IMPORTED_MODULE_1__["SurveyModel"].TemplateRendererComponentName, {
    viewModel: {
        createViewModel: function (params) {
            return params;
        },
    },
    template: template,
});


/***/ }),

/***/ "./src/knockout/components/title/default-title.html":
/*!**********************************************************!*\
  !*** ./src/knockout/components/title/default-title.html ***!
  \**********************************************************/
/*! no static exports found */
/***/ (function(module, exports) {

module.exports = "<!-- ko component: { name: 'survey-element-title-content', params: { element: element } } --><!--/ko-->\n<!-- ko if: element.isCollapsed || element.isExpanded -->\n<span\n    data-bind=\"css: getIconCss(), attr: { 'aria-expanded': element.isCollapsed ? 'false' : 'true' }\"\n    tabindex=\"0\">\n</span>\n<!-- /ko -->";

/***/ }),

/***/ "./src/knockout/components/title/default-title.ts":
/*!********************************************************!*\
  !*** ./src/knockout/components/title/default-title.ts ***!
  \********************************************************/
/*! exports provided: DefaultTitleViewModel */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "DefaultTitleViewModel", function() { return DefaultTitleViewModel; });
/* harmony import */ var knockout__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! knockout */ "knockout");
/* harmony import */ var knockout__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(knockout__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var survey_core__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! survey-core */ "./src/entries/core.ts");


var template = __webpack_require__(/*! ./default-title.html */ "./src/knockout/components/title/default-title.html");
var DefaultTitleViewModel = /** @class */ (function () {
    function DefaultTitleViewModel(element) {
        this.element = element;
    }
    DefaultTitleViewModel.prototype.getIconCss = function () {
        var cssClasses = this.element.isPanel ? this.element.cssClasses.panel : this.element.cssClasses;
        return survey_core__WEBPACK_IMPORTED_MODULE_1__["DefaultTitleModel"].getIconCss(cssClasses, this.element.isCollapsed);
    };
    return DefaultTitleViewModel;
}());

knockout__WEBPACK_IMPORTED_MODULE_0__["components"].register("sv-default-title", {
    viewModel: {
        createViewModel: function (params, componentInfo) {
            return new DefaultTitleViewModel(params.element);
        },
    },
    template: template
});
survey_core__WEBPACK_IMPORTED_MODULE_1__["RendererFactory"].Instance.registerRenderer("element", "default-title", "sv-default-title");


/***/ }),

/***/ "./src/knockout/components/title/title-actions.html":
/*!**********************************************************!*\
  !*** ./src/knockout/components/title/title-actions.html ***!
  \**********************************************************/
/*! no static exports found */
/***/ (function(module, exports) {

module.exports = "<!-- ko ifnot: element.hasTitleActions -->\n  <!-- ko component: { name: 'survey-element-title-content', params: {element: element } } --><!-- /ko -->\n<!-- /ko -->\n<!-- ko if: element.hasTitleActions -->\n<div class=\"sv-title-actions\">\n  <span class=\"sv-title-actions__title\">\n    <!-- ko component: { name: 'survey-element-title-content', params: {element: element } } --><!-- /ko -->\n  </span>\n  <!-- ko component: { name: 'sv-action-bar', params: { model: toolbar } } -->\n  <!-- /ko -->\n</div>\n<!-- /ko -->";

/***/ }),

/***/ "./src/knockout/components/title/title-actions.ts":
/*!********************************************************!*\
  !*** ./src/knockout/components/title/title-actions.ts ***!
  \********************************************************/
/*! exports provided: TitleActionViewModel */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "TitleActionViewModel", function() { return TitleActionViewModel; });
/* harmony import */ var knockout__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! knockout */ "knockout");
/* harmony import */ var knockout__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(knockout__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var survey_core__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! survey-core */ "./src/entries/core.ts");


var template = __webpack_require__(/*! ./title-actions.html */ "./src/knockout/components/title/title-actions.html");
var TitleActionViewModel;
knockout__WEBPACK_IMPORTED_MODULE_0__["components"].register("sv-title-actions", {
    viewModel: {
        createViewModel: function (params, componentInfo) {
            var element = params.element;
            return {
                element: element,
                toolbar: element.getTitleToolbar(),
            };
        },
    },
    template: template,
});
survey_core__WEBPACK_IMPORTED_MODULE_1__["RendererFactory"].Instance.registerRenderer("element", "title-actions", "sv-title-actions");


/***/ }),

/***/ "./src/knockout/components/title/title-content.html":
/*!**********************************************************!*\
  !*** ./src/knockout/components/title/title-content.html ***!
  \**********************************************************/
/*! no static exports found */
/***/ (function(module, exports) {

module.exports = "<!-- ko ifnot: element.isTitleOwner -->\n  <!-- ko template: { name: 'survey-string', data: element.locTitle } --><!-- /ko -->\n<!-- /ko -->\n<!-- ko if: element.isTitleOwner -->\n  <!-- ko if: element.isRequireTextOnStart -->\n  <span\n    data-bind=\"css: element.koCss().requiredText || (element.koCss().panel && element.koCss().panel.requiredText), text: element.requiredText, attr: { 'aria-hidden': true }\"\n  ></span>\n  <!-- /ko -->\n  <!-- ko if: element.no -->\n  <span\n    style=\"position: static;\"\n    data-bind=\"css: element.koCss().number, text: element.no, attr: { 'aria-hidden': true }\"\n  ></span>\n  <span>&nbsp</span>\n  <!-- /ko -->\n  <!-- ko if: element.isRequireTextBeforeTitle -->\n  <span\n    data-bind=\"css: element.koCss().requiredText || (element.koCss().panel && element.koCss().panel.requiredText), text: element.requiredText, attr: { 'aria-hidden': true }\"\n  ></span>\n  <span>&nbsp</span>\n  <!-- /ko -->\n  <!-- ko template: { name: 'survey-string', data: element.locTitle } --><!-- /ko -->\n  <!-- ko if: element.isRequireTextAfterTitle -->\n  <span>&nbsp</span>\n  <span\n    data-bind=\"css: element.koCss().requiredText || (element.koCss().panel && element.koCss().panel.requiredText), text: element.requiredText, attr: { 'aria-hidden': true }\"\n  ></span>\n  <!-- /ko -->\n<!-- /ko -->";

/***/ }),

/***/ "./src/knockout/components/title/title-content.ts":
/*!********************************************************!*\
  !*** ./src/knockout/components/title/title-content.ts ***!
  \********************************************************/
/*! exports provided: TitleContentViewModel */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "TitleContentViewModel", function() { return TitleContentViewModel; });
/* harmony import */ var knockout__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! knockout */ "knockout");
/* harmony import */ var knockout__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(knockout__WEBPACK_IMPORTED_MODULE_0__);

var template = __webpack_require__(/*! ./title-content.html */ "./src/knockout/components/title/title-content.html");
var TitleContentViewModel;
knockout__WEBPACK_IMPORTED_MODULE_0__["components"].register("survey-element-title-content", {
    viewModel: {
        createViewModel: function (params, componentInfo) {
            var element = params.element;
            return { element: element };
        },
    },
    template: template,
});


/***/ }),

/***/ "./src/knockout/components/title/title-element.ts":
/*!********************************************************!*\
  !*** ./src/knockout/components/title/title-element.ts ***!
  \********************************************************/
/*! exports provided: TitleElementViewModel */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "TitleElementViewModel", function() { return TitleElementViewModel; });
/* harmony import */ var knockout__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! knockout */ "knockout");
/* harmony import */ var knockout__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(knockout__WEBPACK_IMPORTED_MODULE_0__);

var TitleElementViewModel;
knockout__WEBPACK_IMPORTED_MODULE_0__["components"].register("survey-element-title", {
    viewModel: {
        createViewModel: function (params, componentInfo) {
            var element = params.element;
            var rootEl = componentInfo.element;
            var titleEl = document.createElement(element.titleTagName);
            var ariaLabelAttr = element.getType() === "radiogroup" ? "" : "'aria-label': element.locTitle.renderedHtml,";
            var bindings = "css: element.cssTitle, attr: { ".concat(ariaLabelAttr, " id: element.ariaTitleId, tabindex: element.titleTabIndex, 'aria-expanded': element.titleAriaExpanded }");
            if (element.hasTitleEvents) {
                bindings += ", click: function() { element.toggleState()}, key2click";
            }
            titleEl.setAttribute("data-bind", bindings);
            titleEl.innerHTML = "<!-- ko component: { name: 'sv-title-actions', params: {element: element } } --><!-- /ko -->";
            var dummyNode = rootEl.nextSibling;
            rootEl.parentNode.insertBefore(document.createComment(" ko if: element.hasTitle "), dummyNode);
            rootEl.parentNode.insertBefore(titleEl, dummyNode);
            rootEl.parentNode.insertBefore(document.createComment(" /ko "), dummyNode);
            rootEl.parentNode.removeChild(dummyNode);
            return { element: element };
        },
    },
    template: "<span></span>",
});


/***/ }),

/***/ "./src/knockout/components/tooltip-error/tooltip-error.ts":
/*!****************************************************************!*\
  !*** ./src/knockout/components/tooltip-error/tooltip-error.ts ***!
  \****************************************************************/
/*! exports provided: TooltipErrorViewModel */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "TooltipErrorViewModel", function() { return TooltipErrorViewModel; });
/* harmony import */ var knockout__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! knockout */ "knockout");
/* harmony import */ var knockout__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(knockout__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var survey_core__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! survey-core */ "./src/entries/core.ts");


var template = __webpack_require__(/*! html-loader?interpolate!val-loader!./tooltip-error.html */ "./node_modules/html-loader/index.js?interpolate!./node_modules/val-loader/index.js!./src/knockout/components/tooltip-error/tooltip-error.html");
var TooltipErrorViewModel = /** @class */ (function () {
    function TooltipErrorViewModel(question) {
        var _this = this;
        this.question = question;
        this.afterRender = function (elements) {
            var tooltipElement = elements.filter(function (el) { return el instanceof HTMLElement; })[0];
            _this.tooltipManager = new survey_core__WEBPACK_IMPORTED_MODULE_1__["TooltipManager"](tooltipElement);
            knockout__WEBPACK_IMPORTED_MODULE_0__["utils"].domNodeDisposal.addDisposeCallback(elements[1], function () {
                _this.tooltipManager.dispose();
            });
        };
    }
    return TooltipErrorViewModel;
}());

knockout__WEBPACK_IMPORTED_MODULE_0__["components"].register("sv-tooltip-error", {
    viewModel: {
        createViewModel: function (params, componentInfo) {
            return new TooltipErrorViewModel(params.question);
        },
    },
    template: template,
});


/***/ }),

/***/ "./src/knockout/koSurveyWindow.ts":
/*!****************************************!*\
  !*** ./src/knockout/koSurveyWindow.ts ***!
  \****************************************/
/*! exports provided: SurveyWindowImplementor, SurveyWindow */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "SurveyWindowImplementor", function() { return SurveyWindowImplementor; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "SurveyWindow", function() { return SurveyWindow; });
/* harmony import */ var knockout__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! knockout */ "knockout");
/* harmony import */ var knockout__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(knockout__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var survey_core__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! survey-core */ "./src/entries/core.ts");
/* harmony import */ var _kobase__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./kobase */ "./src/knockout/kobase.ts");
var __extends = (undefined && undefined.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();



var koTemplate = __webpack_require__(/*! html-loader?interpolate!val-loader!./templates/window/window.html */ "./node_modules/html-loader/index.js?interpolate!./node_modules/val-loader/index.js!./src/knockout/templates/window/window.html");
var SurveyWindowImplementor = /** @class */ (function (_super) {
    __extends(SurveyWindowImplementor, _super);
    function SurveyWindowImplementor(window) {
        var _this = _super.call(this, window) || this;
        _this.window = window;
        _this.window.showingChangedCallback = function () {
            _this.doShowingChanged();
        };
        _this.window["doExpand"] = function () {
            _this.window.changeExpandCollapse();
        };
        return _this;
    }
    SurveyWindowImplementor.prototype.doShowingChanged = function () {
        var windowElement = this.window.windowElement;
        if (this.window.isShowing) {
            windowElement.innerHTML = this.template;
            knockout__WEBPACK_IMPORTED_MODULE_0__["cleanNode"](windowElement);
            knockout__WEBPACK_IMPORTED_MODULE_0__["applyBindings"](this.window, windowElement);
            document.body.appendChild(windowElement);
            this.window.survey.render(survey_core__WEBPACK_IMPORTED_MODULE_1__["SurveyWindowModel"].surveyElementName);
        }
        else {
            document.body.removeChild(windowElement);
            windowElement.innerHTML = "";
        }
    };
    Object.defineProperty(SurveyWindowImplementor.prototype, "template", {
        get: function () {
            return this.window.templateValue ? this.window.templateValue : koTemplate;
        },
        enumerable: false,
        configurable: true
    });
    return SurveyWindowImplementor;
}(_kobase__WEBPACK_IMPORTED_MODULE_2__["ImplementorBase"]));

survey_core__WEBPACK_IMPORTED_MODULE_1__["SurveyWindowModel"].prototype["onCreating"] = function () {
    this.implementor = new SurveyWindowImplementor(this);
};
var SurveyWindow = /** @class */ (function (_super) {
    __extends(SurveyWindow, _super);
    function SurveyWindow(jsonObj, initialModel) {
        if (initialModel === void 0) { initialModel = null; }
        return _super.call(this, jsonObj, initialModel) || this;
    }
    return SurveyWindow;
}(survey_core__WEBPACK_IMPORTED_MODULE_1__["SurveyWindowModel"]));



/***/ }),

/***/ "./src/knockout/kobase.ts":
/*!********************************!*\
  !*** ./src/knockout/kobase.ts ***!
  \********************************/
/*! exports provided: ImplementorBase */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "ImplementorBase", function() { return ImplementorBase; });
/* harmony import */ var knockout__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! knockout */ "knockout");
/* harmony import */ var knockout__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(knockout__WEBPACK_IMPORTED_MODULE_0__);

var ImplementorBase = /** @class */ (function () {
    function ImplementorBase(element) {
        this.element = element;
        this.implementedMark = "__surveyImplementedKo";
        if (element[this.implementedMark]) {
            return;
        }
        element.iteratePropertiesHash(function (hash, key) {
            ImplementorBase.doIterateProperties(element, hash, key);
        });
        element.createArrayCoreHandler = function (hash, key) {
            var res = knockout__WEBPACK_IMPORTED_MODULE_0__["observableArray"]();
            res()["onArrayChanged"] = function () {
                if (element.isLoadingFromJson || element.isDisposed)
                    return;
                res.notifySubscribers();
            };
            hash[key] = res;
            return res();
        };
        element.getPropertyValueCoreHandler = function (hash, key) {
            if (hash[key] === undefined) {
                hash[key] = knockout__WEBPACK_IMPORTED_MODULE_0__["observable"]();
            }
            return typeof hash[key] === "function" ? hash[key]() : hash[key];
        };
        element.setPropertyValueCoreHandler = function (hash, key, val) {
            if (hash[key] !== undefined) {
                if (hash[key]() === val) {
                    hash[key].notifySubscribers();
                }
                hash[key](val);
            }
            else {
                (hash[key] = knockout__WEBPACK_IMPORTED_MODULE_0__["observable"](val));
            }
        };
        element[this.implementedMark] = true;
    }
    ImplementorBase.doIterateProperties = function (element, hash, key) {
        var val = hash[key];
        if (val === "function")
            return;
        if (Array.isArray(val)) {
            hash[key] = knockout__WEBPACK_IMPORTED_MODULE_0__["observableArray"](val);
            val["onArrayChanged"] = function () {
                if (element.isLoadingFromJson || element.isDisposed)
                    return;
                hash[key].notifySubscribers();
            };
        }
        else {
            hash[key] = knockout__WEBPACK_IMPORTED_MODULE_0__["observable"](val);
        }
    };
    ImplementorBase.prototype.dispose = function () {
        this.element.iteratePropertiesHash(function (hash, key) {
            hash[key] = knockout__WEBPACK_IMPORTED_MODULE_0__["unwrap"](hash[key]);
            if (Array.isArray(hash[key])) {
                hash[key]["onArrayChanged"] = undefined;
            }
        });
        this.element.createArrayCoreHandler = undefined;
        this.element.getPropertyValueCoreHandler = undefined;
        this.element.setPropertyValueCoreHandler = undefined;
        delete this.element[this.implementedMark];
    };
    return ImplementorBase;
}());



/***/ }),

/***/ "./src/knockout/koflowpanel.ts":
/*!*************************************!*\
  !*** ./src/knockout/koflowpanel.ts ***!
  \*************************************/
/*! exports provided: FlowPanel */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "FlowPanel", function() { return FlowPanel; });
/* harmony import */ var knockout__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! knockout */ "knockout");
/* harmony import */ var knockout__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(knockout__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var survey_core__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! survey-core */ "./src/entries/core.ts");
/* harmony import */ var _kobase__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./kobase */ "./src/knockout/kobase.ts");
var __extends = (undefined && undefined.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();





var FlowPanel = /** @class */ (function (_super) {
    __extends(FlowPanel, _super);
    function FlowPanel(name) {
        if (name === void 0) { name = ""; }
        var _this = _super.call(this, name) || this;
        _this.koElementType = knockout__WEBPACK_IMPORTED_MODULE_0__["observable"]("survey-flowpanel");
        new _kobase__WEBPACK_IMPORTED_MODULE_2__["ImplementorBase"](_this);
        _this.onCreating();
        var self = _this;
        _this.koElementAfterRender = function (el, con) {
            return self.elementAfterRender(el, con);
        };
        return _this;
    }
    FlowPanel.prototype.onCreating = function () { };
    FlowPanel.prototype.getHtmlForQuestion = function (question) {
        return ('<span question="true" contenteditable="false" id="flowpanel_' +
            question.name +
            '"><!-- ko template: { name: "survey-flowpanel-question", data: "' +
            question.name +
            '"} --><!-- /ko --></span>');
    };
    FlowPanel.prototype.elementAfterRender = function (elements, con) {
        if (!this.survey)
            return;
        var el = survey_core__WEBPACK_IMPORTED_MODULE_1__["SurveyElement"].GetFirstNonTextElement(elements);
        if (!!el) {
            this.survey.afterRenderQuestion(con, el);
        }
    };
    return FlowPanel;
}(survey_core__WEBPACK_IMPORTED_MODULE_1__["FlowPanelModel"]));

survey_core__WEBPACK_IMPORTED_MODULE_1__["Serializer"].overrideClassCreator("flowpanel", function () {
    return new FlowPanel();
});
/*
ElementFactory.Instance.registerElement("flowpanel", name => {
  return new FlowPanel(name);
});
*/
knockout__WEBPACK_IMPORTED_MODULE_0__["components"].register("f-panel", {
    viewModel: {
        createViewModel: function (params, componentInfo) {
            var self = this;
            var question = knockout__WEBPACK_IMPORTED_MODULE_0__["unwrap"](params.question);
            self.element = componentInfo.element;
            self.element.innerHTML = question.html;
            self.isOnFocus = false;
            self.wasChanged = false;
            self.isContentUpdating = false;
            question.contentChangedCallback = function () {
                if (self.isContentUpdating)
                    return;
                knockout__WEBPACK_IMPORTED_MODULE_0__["cleanNode"](self.element);
                self.element.innerHTML = question.html;
                knockout__WEBPACK_IMPORTED_MODULE_0__["applyBindings"]({ question: question }, self.element);
                !!knockout__WEBPACK_IMPORTED_MODULE_0__["tasks"] && knockout__WEBPACK_IMPORTED_MODULE_0__["tasks"].runEarly();
            };
            self.element.onfocus = function () {
                self.isOnFocus = true;
            };
            self.element.onblur = function () {
                if (self.wasChanged)
                    self.updateContent();
                self.isOnFocus = false;
                self.wasChanged = false;
            };
            self.element.ondragend = function (event) {
                var regEx = /{(.*?(element:)[^$].*?)}/g;
                var str = self.element.innerHTML;
                var res = regEx.exec(str);
                if (res !== null) {
                    var q = question.getQuestionFromText(res[0]);
                    if (!!q) {
                        question.content = self.getContent(q.name);
                    }
                }
            };
            self.updateContent = function () {
                self.isContentUpdating = true;
                question.content = self.getContent();
                self.isContentUpdating = false;
            };
            question.getContent = self.getContent = function (deletedName) {
                var content = document.createElement("DIV");
                content.innerHTML = self.element.innerHTML;
                var cps = content.querySelectorAll('span[question="true"]');
                for (var i = 0; i < cps.length; i++) {
                    var name = cps[i].id.replace("flowpanel_", "");
                    var html = "";
                    if (name !== deletedName) {
                        var el = question.getQuestionByName(name);
                        html = !!el ? question.getElementContentText(el) : "";
                    }
                    cps[i].outerHTML = html;
                }
                return content.innerHTML;
            };
            var config = {
                characterData: true,
                attributes: true,
                childList: true,
                subtree: true,
            };
            var callback = function (mutationsList, observer) {
                if (!self.isOnFocus)
                    return;
                self.wasChanged = true;
            };
            var observer = new MutationObserver(callback);
            observer.observe(self.element, config);
            return { question: question };
        },
    },
    template: "<div></div>",
});


/***/ }),

/***/ "./src/knockout/kopage.ts":
/*!********************************!*\
  !*** ./src/knockout/kopage.ts ***!
  \********************************/
/*! exports provided: QuestionRow, PanelImplementorBase, Panel, Page */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "QuestionRow", function() { return QuestionRow; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "PanelImplementorBase", function() { return PanelImplementorBase; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "Panel", function() { return Panel; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "Page", function() { return Page; });
/* harmony import */ var knockout__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! knockout */ "knockout");
/* harmony import */ var knockout__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(knockout__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var survey_core__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! survey-core */ "./src/entries/core.ts");
/* harmony import */ var _kobase__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./kobase */ "./src/knockout/kobase.ts");
var __extends = (undefined && undefined.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();







var QuestionRow = /** @class */ (function (_super) {
    __extends(QuestionRow, _super);
    function QuestionRow(panel) {
        var _this = _super.call(this, panel) || this;
        _this.panel = panel;
        new _kobase__WEBPACK_IMPORTED_MODULE_2__["ImplementorBase"](_this);
        var self = _this;
        _this.koElementAfterRender = function (el, con) {
            return self.elementAfterRender(el, con);
        };
        return _this;
    }
    QuestionRow.prototype.getElementType = function (el) {
        return el.isPanel ? "survey-panel" : "survey-question";
    };
    QuestionRow.prototype.koAfterRender = function (el, con) {
        for (var i = 0; i < el.length; i++) {
            var tEl = el[i];
            var nName = tEl.nodeName;
            if (nName == "#text")
                tEl.data = "";
        }
    };
    QuestionRow.prototype.elementAfterRender = function (elements, con) {
        var _this = this;
        if (!this.panel || !this.panel.survey)
            return;
        setTimeout(function () {
            !!knockout__WEBPACK_IMPORTED_MODULE_0__["tasks"] && knockout__WEBPACK_IMPORTED_MODULE_0__["tasks"].runEarly();
            var el = survey_core__WEBPACK_IMPORTED_MODULE_1__["SurveyElement"].GetFirstNonTextElement(elements);
            if (!el)
                return;
            var element = con;
            if (element.isPanel) {
                _this.panel.survey.afterRenderPanel(con, el);
            }
            else {
                element.afterRender(el);
            }
        }, 0);
    };
    QuestionRow.prototype.rowAfterRender = function (elements, model) {
        if (!model.isNeedRender) {
            var rowContainerDiv = elements[0].parentElement;
            setTimeout(function () { return model.startLazyRendering(rowContainerDiv); }, 1);
            knockout__WEBPACK_IMPORTED_MODULE_0__["utils"].domNodeDisposal.addDisposeCallback(rowContainerDiv, function () {
                model.stopLazyRendering();
                model.isNeedRender = !model.isLazyRendering();
            });
        }
    };
    QuestionRow.prototype.dispose = function () {
        _super.prototype.dispose.call(this);
        this.koElementAfterRender = undefined;
    };
    return QuestionRow;
}(survey_core__WEBPACK_IMPORTED_MODULE_1__["QuestionRowModel"]));

var PanelImplementorBase = /** @class */ (function (_super) {
    __extends(PanelImplementorBase, _super);
    function PanelImplementorBase(panel) {
        var _this = _super.call(this, panel) || this;
        _this.panel = panel;
        return _this;
    }
    return PanelImplementorBase;
}(_kobase__WEBPACK_IMPORTED_MODULE_2__["ImplementorBase"]));

var Panel = /** @class */ (function (_super) {
    __extends(Panel, _super);
    function Panel(name) {
        if (name === void 0) { name = ""; }
        var _this = _super.call(this, name) || this;
        _this.onCreating();
        var self = _this;
        _this.koElementType = knockout__WEBPACK_IMPORTED_MODULE_0__["observable"]("survey-panel");
        _this.koCss = knockout__WEBPACK_IMPORTED_MODULE_0__["pureComputed"](function () {
            return self.cssClasses;
        });
        _this.koErrorClass = knockout__WEBPACK_IMPORTED_MODULE_0__["pureComputed"](function () {
            return self.cssError;
        });
        return _this;
    }
    Panel.prototype.onBaseCreating = function () {
        _super.prototype.onBaseCreating.call(this);
        this._implementor = new PanelImplementorBase(this);
    };
    Panel.prototype.createRow = function () {
        return new QuestionRow(this);
    };
    Panel.prototype.onCreating = function () { };
    Panel.prototype.onNumChanged = function (value) {
        this.locTitle.onChanged();
    };
    Panel.prototype.dispose = function () {
        this.koCss.dispose();
        this.koErrorClass.dispose();
        this._implementor.dispose();
        this._implementor = undefined;
        _super.prototype.dispose.call(this);
    };
    return Panel;
}(survey_core__WEBPACK_IMPORTED_MODULE_1__["PanelModel"]));

var Page = /** @class */ (function (_super) {
    __extends(Page, _super);
    function Page(name) {
        if (name === void 0) { name = ""; }
        var _this = _super.call(this, name) || this;
        _this.onCreating();
        return _this;
    }
    Page.prototype.onBaseCreating = function () {
        _super.prototype.onBaseCreating.call(this);
        this._implementor = new _kobase__WEBPACK_IMPORTED_MODULE_2__["ImplementorBase"](this);
    };
    Page.prototype.createRow = function () {
        return new QuestionRow(this);
    };
    Page.prototype.onCreating = function () { };
    Page.prototype.onNumChanged = function (value) {
        this.locTitle.onChanged();
    };
    Page.prototype.dispose = function () {
        _super.prototype.dispose.call(this);
        this._implementor.dispose();
        this._implementor = undefined;
    };
    return Page;
}(survey_core__WEBPACK_IMPORTED_MODULE_1__["PageModel"]));

survey_core__WEBPACK_IMPORTED_MODULE_1__["Serializer"].overrideClassCreator("panel", function () {
    return new Panel();
});
survey_core__WEBPACK_IMPORTED_MODULE_1__["Serializer"].overrideClassCreator("page", function () {
    return new Page();
});
survey_core__WEBPACK_IMPORTED_MODULE_1__["ElementFactory"].Instance.registerElement("panel", function (name) {
    return new Panel(name);
});


/***/ }),

/***/ "./src/knockout/koquestion.ts":
/*!************************************!*\
  !*** ./src/knockout/koquestion.ts ***!
  \************************************/
/*! exports provided: QuestionImplementor */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "QuestionImplementor", function() { return QuestionImplementor; });
/* harmony import */ var knockout__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! knockout */ "knockout");
/* harmony import */ var knockout__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(knockout__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var survey_core__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! survey-core */ "./src/entries/core.ts");
/* harmony import */ var _kobase__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./kobase */ "./src/knockout/kobase.ts");
var __extends = (undefined && undefined.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();



var QuestionImplementor = /** @class */ (function (_super) {
    __extends(QuestionImplementor, _super);
    function QuestionImplementor(question) {
        var _this = _super.call(this, question) || this;
        _this.question = question;
        _this._koValue = knockout__WEBPACK_IMPORTED_MODULE_0__["observableArray"]();
        _this.disposedObjects = [];
        _this.callBackFunctions = [];
        var isSynchronizing = false;
        _this._koValue.subscribe(function (newValue) {
            if (!isSynchronizing) {
                _this.question.value = newValue;
            }
        });
        Object.defineProperty(_this.question, "koValue", {
            get: function () {
                if (!survey_core__WEBPACK_IMPORTED_MODULE_1__["Helpers"].isTwoValueEquals(_this._koValue(), _this.getKoValue(), false, true, false)) {
                    try {
                        isSynchronizing = true;
                        _this._koValue(_this.getKoValue());
                    }
                    finally {
                        isSynchronizing = false;
                    }
                }
                return _this._koValue;
            },
            enumerable: true,
            configurable: true,
        });
        question.surveyLoadCallback = function () {
            _this.onSurveyLoad();
        };
        _this.setObservaleObj("koTemplateName", knockout__WEBPACK_IMPORTED_MODULE_0__["pureComputed"](function () {
            return _this.getTemplateName();
        }));
        _this.setObservaleObj("koElementType", knockout__WEBPACK_IMPORTED_MODULE_0__["observable"]("survey-question"));
        _this.setObservaleObj("koCss", knockout__WEBPACK_IMPORTED_MODULE_0__["pureComputed"](function () {
            return _this.question.cssClasses;
        }));
        _this.setObservaleObj("koRootCss", knockout__WEBPACK_IMPORTED_MODULE_0__["pureComputed"](function () {
            return _this.question.getRootCss();
        }));
        _this.setObservaleObj("koErrorClass", knockout__WEBPACK_IMPORTED_MODULE_0__["pureComputed"](function () {
            return _this.question.cssError;
        }));
        _this.koDummy = knockout__WEBPACK_IMPORTED_MODULE_0__["observable"](0);
        _this.setCallbackFunc("koQuestionAfterRender", function (el, con) {
            _this.koQuestionAfterRender(el, con);
        });
        return _this;
    }
    QuestionImplementor.prototype.setObservaleObj = function (name, obj, addToQuestion) {
        if (addToQuestion === void 0) { addToQuestion = true; }
        this.disposedObjects.push(name);
        if (addToQuestion) {
            this.question[name] = obj;
        }
        return obj;
    };
    QuestionImplementor.prototype.setCallbackFunc = function (name, func) {
        this.callBackFunctions.push(name);
        this.question[name] = func;
    };
    QuestionImplementor.prototype.getKoValue = function () {
        return this.question.value;
    };
    QuestionImplementor.prototype.onSurveyLoad = function () { };
    QuestionImplementor.prototype.getQuestionTemplate = function () {
        return this.question.getTemplate();
    };
    QuestionImplementor.prototype.getTemplateName = function () {
        if (this.question.customWidget &&
            !this.question.customWidget.widgetJson.isDefaultRender)
            return "survey-widget-" + this.question.customWidget.name;
        return "survey-question-" + this.getQuestionTemplate();
    };
    QuestionImplementor.prototype.getNo = function () {
        return this.question.visibleIndex > -1
            ? this.question.visibleIndex + 1 + ". "
            : "";
    };
    QuestionImplementor.prototype.updateKoDummy = function () {
        if (this.question.isDisposed)
            return;
        this.koDummy(this.koDummy() + 1);
        this.question.locTitle.onChanged();
    };
    QuestionImplementor.prototype.koQuestionAfterRender = function (elements, con) {
        var _this = this;
        setTimeout(function () {
            !!knockout__WEBPACK_IMPORTED_MODULE_0__["tasks"] && knockout__WEBPACK_IMPORTED_MODULE_0__["tasks"].runEarly();
            var el = survey_core__WEBPACK_IMPORTED_MODULE_1__["SurveyElement"].GetFirstNonTextElement(elements, true);
            if (!!el) {
                _this.question.afterRenderQuestionElement(el);
                if (!!_this.question.customWidget) {
                    _this.question.customWidget.afterRender(_this.question, el);
                }
                knockout__WEBPACK_IMPORTED_MODULE_0__["utils"].domNodeDisposal.addDisposeCallback(el, function () {
                    _this.question.beforeDestroyQuestionElement(el);
                    if (!!_this.question.customWidget) {
                        try {
                            _this.question.customWidget.willUnmount(_this.question, el);
                        }
                        catch (_a) {
                            // eslint-disable-next-line no-console
                            console.warn("Custom widget will unmount failed");
                        }
                    }
                });
            }
        }, 0);
    };
    QuestionImplementor.prototype.dispose = function () {
        _super.prototype.dispose.call(this);
        for (var i_1 = 0; i_1 < this.disposedObjects.length; i_1++) {
            var name_1 = this.disposedObjects[i_1];
            var obj = this[name_1] || this.question[name_1];
            if (!obj)
                continue;
            if (this[name_1])
                this[name_1] = undefined;
            if (this.question[name_1])
                this.question[name_1] = undefined;
            if (obj["dispose"])
                obj.dispose();
        }
        this.disposedObjects = [];
        for (var i = 0; i < this.callBackFunctions.length; i++) {
            this.question[this.callBackFunctions[i]] = undefined;
        }
        this.callBackFunctions = [];
        this.question.unRegisterFunctionOnPropertyValueChanged("visibleIndex");
    };
    return QuestionImplementor;
}(_kobase__WEBPACK_IMPORTED_MODULE_2__["ImplementorBase"]));



/***/ }),

/***/ "./src/knockout/koquestion_baseselect.ts":
/*!***********************************************!*\
  !*** ./src/knockout/koquestion_baseselect.ts ***!
  \***********************************************/
/*! exports provided: QuestionSelectBaseImplementor, QuestionCheckboxBaseImplementor */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "QuestionSelectBaseImplementor", function() { return QuestionSelectBaseImplementor; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "QuestionCheckboxBaseImplementor", function() { return QuestionCheckboxBaseImplementor; });
/* harmony import */ var _koquestion__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./koquestion */ "./src/knockout/koquestion.ts");
var __extends = (undefined && undefined.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();

var QuestionSelectBaseImplementor = /** @class */ (function (_super) {
    __extends(QuestionSelectBaseImplementor, _super);
    function QuestionSelectBaseImplementor(question) {
        var _this = _super.call(this, question) || this;
        _this.onCreated();
        return _this;
    }
    QuestionSelectBaseImplementor.prototype.onCreated = function () { };
    Object.defineProperty(QuestionSelectBaseImplementor.prototype, "isOtherSelected", {
        get: function () {
            return this.question.isOtherSelected;
        },
        enumerable: false,
        configurable: true
    });
    return QuestionSelectBaseImplementor;
}(_koquestion__WEBPACK_IMPORTED_MODULE_0__["QuestionImplementor"]));

var QuestionCheckboxBaseImplementor = /** @class */ (function (_super) {
    __extends(QuestionCheckboxBaseImplementor, _super);
    function QuestionCheckboxBaseImplementor(question) {
        var _this = _super.call(this, question) || this;
        _this.setCallbackFunc("koAfterRender", _this.koAfterRender);
        return _this;
    }
    QuestionCheckboxBaseImplementor.prototype.koAfterRender = function (el, con) {
        var tEl = el[0];
        if (tEl.nodeName == "#text")
            tEl.data = "";
        tEl = el[el.length - 1];
        if (tEl.nodeName == "#text")
            tEl.data = "";
    };
    return QuestionCheckboxBaseImplementor;
}(QuestionSelectBaseImplementor));



/***/ }),

/***/ "./src/knockout/koquestion_boolean.ts":
/*!********************************************!*\
  !*** ./src/knockout/koquestion_boolean.ts ***!
  \********************************************/
/*! exports provided: QuestionBoolean */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "QuestionBoolean", function() { return QuestionBoolean; });
/* harmony import */ var survey_core__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! survey-core */ "./src/entries/core.ts");
/* harmony import */ var _koquestion__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./koquestion */ "./src/knockout/koquestion.ts");
/* harmony import */ var _utils_utils__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../utils/utils */ "./src/utils/utils.ts");
var __extends = (undefined && undefined.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();



var QuestionBoolean = /** @class */ (function (_super) {
    __extends(QuestionBoolean, _super);
    function QuestionBoolean(name) {
        return _super.call(this, name) || this;
    }
    QuestionBoolean.prototype.onBaseCreating = function () {
        _super.prototype.onBaseCreating.call(this);
        this._implementor = new _koquestion__WEBPACK_IMPORTED_MODULE_1__["QuestionImplementor"](this);
    };
    QuestionBoolean.prototype.onSwitchClick = function (data, event) {
        return _super.prototype.onSwitchClickModel.call(this, Object(_utils_utils__WEBPACK_IMPORTED_MODULE_2__["getOriginalEvent"])(event));
    };
    QuestionBoolean.prototype.onTrueLabelClick = function (data, event) {
        return this.onLabelClick(event, true);
    };
    QuestionBoolean.prototype.onFalseLabelClick = function (data, event) {
        return this.onLabelClick(event, false);
    };
    QuestionBoolean.prototype.dispose = function () {
        this._implementor.dispose();
        this._implementor = undefined;
        _super.prototype.dispose.call(this);
    };
    return QuestionBoolean;
}(survey_core__WEBPACK_IMPORTED_MODULE_0__["QuestionBooleanModel"]));

survey_core__WEBPACK_IMPORTED_MODULE_0__["Serializer"].overrideClassCreator("boolean", function () {
    return new QuestionBoolean("");
});
survey_core__WEBPACK_IMPORTED_MODULE_0__["QuestionFactory"].Instance.registerQuestion("boolean", function (name) {
    return new QuestionBoolean(name);
});


/***/ }),

/***/ "./src/knockout/koquestion_buttongroup.ts":
/*!************************************************!*\
  !*** ./src/knockout/koquestion_buttongroup.ts ***!
  \************************************************/
/*! exports provided: QuestionButtonGroup */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "QuestionButtonGroup", function() { return QuestionButtonGroup; });
/* harmony import */ var survey_core__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! survey-core */ "./src/entries/core.ts");
/* harmony import */ var _koquestion_baseselect__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./koquestion_baseselect */ "./src/knockout/koquestion_baseselect.ts");
var __extends = (undefined && undefined.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();


var QuestionButtonGroup = /** @class */ (function (_super) {
    __extends(QuestionButtonGroup, _super);
    function QuestionButtonGroup(name) {
        return _super.call(this, name) || this;
    }
    QuestionButtonGroup.prototype.onBaseCreating = function () {
        _super.prototype.onBaseCreating.call(this);
        this._implementor = new _koquestion_baseselect__WEBPACK_IMPORTED_MODULE_1__["QuestionCheckboxBaseImplementor"](this);
    };
    QuestionButtonGroup.prototype.dispose = function () {
        this._implementor.dispose();
        this._implementor = undefined;
        _super.prototype.dispose.call(this);
    };
    return QuestionButtonGroup;
}(survey_core__WEBPACK_IMPORTED_MODULE_0__["QuestionButtonGroupModel"]));

// Serializer.overrideClassCreator("buttongroup", function() {
//   return new QuestionButtonGroup("");
// });
// QuestionFactory.Instance.registerQuestion("buttongroup", name => {
//   var q = new QuestionButtonGroup(name);
//   q.choices = QuestionFactory.DefaultChoices;
//   return q;
// });


/***/ }),

/***/ "./src/knockout/koquestion_checkbox.ts":
/*!*********************************************!*\
  !*** ./src/knockout/koquestion_checkbox.ts ***!
  \*********************************************/
/*! exports provided: QuestionCheckboxImplementor, QuestionCheckbox */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "QuestionCheckboxImplementor", function() { return QuestionCheckboxImplementor; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "QuestionCheckbox", function() { return QuestionCheckbox; });
/* harmony import */ var knockout__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! knockout */ "knockout");
/* harmony import */ var knockout__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(knockout__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _koquestion_baseselect__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./koquestion_baseselect */ "./src/knockout/koquestion_baseselect.ts");
/* harmony import */ var survey_core__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! survey-core */ "./src/entries/core.ts");
var __extends = (undefined && undefined.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();





var QuestionCheckboxImplementor = /** @class */ (function (_super) {
    __extends(QuestionCheckboxImplementor, _super);
    function QuestionCheckboxImplementor(question) {
        return _super.call(this, question) || this;
    }
    QuestionCheckboxImplementor.prototype.getKoValue = function () {
        return this.question.renderedValue;
    };
    return QuestionCheckboxImplementor;
}(_koquestion_baseselect__WEBPACK_IMPORTED_MODULE_1__["QuestionCheckboxBaseImplementor"]));

var QuestionCheckbox = /** @class */ (function (_super) {
    __extends(QuestionCheckbox, _super);
    function QuestionCheckbox(name) {
        var _this = _super.call(this, name) || this;
        _this.isAllSelectedUpdating = false;
        _this.koAllSelected = knockout__WEBPACK_IMPORTED_MODULE_0__["observable"](_this.isAllSelected);
        _this.koAllSelected.subscribe(function (newValue) {
            if (_this.isAllSelectedUpdating)
                return;
            if (newValue)
                _this.selectAll();
            else
                _this.clearValue();
        });
        return _this;
    }
    QuestionCheckbox.prototype.onBaseCreating = function () {
        _super.prototype.onBaseCreating.call(this);
        this._implementor = new QuestionCheckboxImplementor(this);
    };
    QuestionCheckbox.prototype.onSurveyValueChanged = function (newValue) {
        _super.prototype.onSurveyValueChanged.call(this, newValue);
        this.updateAllSelected();
    };
    QuestionCheckbox.prototype.onVisibleChoicesChanged = function () {
        _super.prototype.onVisibleChoicesChanged.call(this);
        this.updateAllSelected();
    };
    QuestionCheckbox.prototype.updateAllSelected = function () {
        this.isAllSelectedUpdating = true;
        this.koAllSelected(this.isAllSelected);
        this.isAllSelectedUpdating = false;
    };
    QuestionCheckbox.prototype.dispose = function () {
        this._implementor.dispose();
        this._implementor = undefined;
        this.koAllSelected = undefined;
        _super.prototype.dispose.call(this);
    };
    return QuestionCheckbox;
}(survey_core__WEBPACK_IMPORTED_MODULE_2__["QuestionCheckboxModel"]));

survey_core__WEBPACK_IMPORTED_MODULE_2__["Serializer"].overrideClassCreator("checkbox", function () {
    return new QuestionCheckbox("");
});
survey_core__WEBPACK_IMPORTED_MODULE_2__["QuestionFactory"].Instance.registerQuestion("checkbox", function (name) {
    var q = new QuestionCheckbox(name);
    q.choices = survey_core__WEBPACK_IMPORTED_MODULE_2__["QuestionFactory"].DefaultChoices;
    return q;
});


/***/ }),

/***/ "./src/knockout/koquestion_comment.ts":
/*!********************************************!*\
  !*** ./src/knockout/koquestion_comment.ts ***!
  \********************************************/
/*! exports provided: QuestionComment */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "QuestionComment", function() { return QuestionComment; });
/* harmony import */ var survey_core__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! survey-core */ "./src/entries/core.ts");
/* harmony import */ var _koquestion__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./koquestion */ "./src/knockout/koquestion.ts");
var __extends = (undefined && undefined.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();




var QuestionComment = /** @class */ (function (_super) {
    __extends(QuestionComment, _super);
    function QuestionComment(name) {
        return _super.call(this, name) || this;
    }
    QuestionComment.prototype.onBaseCreating = function () {
        _super.prototype.onBaseCreating.call(this);
        this._implementor = new _koquestion__WEBPACK_IMPORTED_MODULE_1__["QuestionImplementor"](this);
    };
    QuestionComment.prototype.dispose = function () {
        this._implementor.dispose();
        this._implementor = undefined;
        _super.prototype.dispose.call(this);
    };
    return QuestionComment;
}(survey_core__WEBPACK_IMPORTED_MODULE_0__["QuestionCommentModel"]));

survey_core__WEBPACK_IMPORTED_MODULE_0__["Serializer"].overrideClassCreator("comment", function () {
    return new QuestionComment("");
});
survey_core__WEBPACK_IMPORTED_MODULE_0__["QuestionFactory"].Instance.registerQuestion("comment", function (name) {
    return new QuestionComment(name);
});


/***/ }),

/***/ "./src/knockout/koquestion_custom.ts":
/*!*******************************************!*\
  !*** ./src/knockout/koquestion_custom.ts ***!
  \*******************************************/
/*! exports provided: QuestionCustom, QuestionComposite */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "QuestionCustom", function() { return QuestionCustom; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "QuestionComposite", function() { return QuestionComposite; });
/* harmony import */ var survey_core__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! survey-core */ "./src/entries/core.ts");
/* harmony import */ var _koquestion__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./koquestion */ "./src/knockout/koquestion.ts");
var __extends = (undefined && undefined.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();


var QuestionCustom = /** @class */ (function (_super) {
    __extends(QuestionCustom, _super);
    function QuestionCustom(name, questionJSON) {
        return _super.call(this, name, questionJSON) || this;
    }
    QuestionCustom.prototype.onBaseCreating = function () {
        _super.prototype.onBaseCreating.call(this);
        this._implementor = new _koquestion__WEBPACK_IMPORTED_MODULE_1__["QuestionImplementor"](this);
    };
    QuestionCustom.prototype.dispose = function () {
        this._implementor.dispose();
        this._implementor = undefined;
        _super.prototype.dispose.call(this);
    };
    return QuestionCustom;
}(survey_core__WEBPACK_IMPORTED_MODULE_0__["QuestionCustomModel"]));

var QuestionComposite = /** @class */ (function (_super) {
    __extends(QuestionComposite, _super);
    function QuestionComposite(name, questionJSON) {
        return _super.call(this, name, questionJSON) || this;
    }
    QuestionComposite.prototype.onBaseCreating = function () {
        _super.prototype.onBaseCreating.call(this);
        this._implementor = new _koquestion__WEBPACK_IMPORTED_MODULE_1__["QuestionImplementor"](this);
    };
    QuestionComposite.prototype.dispose = function () {
        this._implementor.dispose();
        this._implementor = undefined;
        _super.prototype.dispose.call(this);
    };
    return QuestionComposite;
}(survey_core__WEBPACK_IMPORTED_MODULE_0__["QuestionCompositeModel"]));

survey_core__WEBPACK_IMPORTED_MODULE_0__["ComponentCollection"].Instance.onCreateCustom = function (name, questionJSON) {
    return new QuestionCustom(name, questionJSON);
};
survey_core__WEBPACK_IMPORTED_MODULE_0__["ComponentCollection"].Instance.onCreateComposite = function (name, questionJSON) {
    return new QuestionComposite(name, questionJSON);
};


/***/ }),

/***/ "./src/knockout/koquestion_dropdown.ts":
/*!*********************************************!*\
  !*** ./src/knockout/koquestion_dropdown.ts ***!
  \*********************************************/
/*! exports provided: QuestionDropdown */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "QuestionDropdown", function() { return QuestionDropdown; });
/* harmony import */ var knockout__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! knockout */ "knockout");
/* harmony import */ var knockout__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(knockout__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var survey_core__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! survey-core */ "./src/entries/core.ts");
/* harmony import */ var _koquestion_baseselect__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./koquestion_baseselect */ "./src/knockout/koquestion_baseselect.ts");
var __extends = (undefined && undefined.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();





var QuestionDropdownImplementor = /** @class */ (function (_super) {
    __extends(QuestionDropdownImplementor, _super);
    function QuestionDropdownImplementor(question) {
        return _super.call(this, question) || this;
    }
    return QuestionDropdownImplementor;
}(_koquestion_baseselect__WEBPACK_IMPORTED_MODULE_2__["QuestionSelectBaseImplementor"]));
var QuestionDropdown = /** @class */ (function (_super) {
    __extends(QuestionDropdown, _super);
    function QuestionDropdown(name) {
        var _this = _super.call(this, name) || this;
        _this.koDisableOption = function (option, item) {
            if (!item)
                return;
            knockout__WEBPACK_IMPORTED_MODULE_0__["applyBindingsToNode"](option, { disable: knockout__WEBPACK_IMPORTED_MODULE_0__["computed"](function () { return !item.isEnabled; }) }, item);
        };
        return _this;
    }
    QuestionDropdown.prototype.onBaseCreating = function () {
        _super.prototype.onBaseCreating.call(this);
        this._implementor = new QuestionDropdownImplementor(this);
    };
    QuestionDropdown.prototype.dispose = function () {
        this._implementor.dispose();
        this._implementor = undefined;
        _super.prototype.dispose.call(this);
    };
    return QuestionDropdown;
}(survey_core__WEBPACK_IMPORTED_MODULE_1__["QuestionDropdownModel"]));

survey_core__WEBPACK_IMPORTED_MODULE_1__["Serializer"].overrideClassCreator("dropdown", function () {
    return new QuestionDropdown("");
});
survey_core__WEBPACK_IMPORTED_MODULE_1__["QuestionFactory"].Instance.registerQuestion("dropdown", function (name) {
    var q = new QuestionDropdown(name);
    q.choices = survey_core__WEBPACK_IMPORTED_MODULE_1__["QuestionFactory"].DefaultChoices;
    return q;
});


/***/ }),

/***/ "./src/knockout/koquestion_empty.ts":
/*!******************************************!*\
  !*** ./src/knockout/koquestion_empty.ts ***!
  \******************************************/
/*! exports provided: QuestionEmpty */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "QuestionEmpty", function() { return QuestionEmpty; });
/* harmony import */ var survey_core__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! survey-core */ "./src/entries/core.ts");
/* harmony import */ var _koquestion__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./koquestion */ "./src/knockout/koquestion.ts");
var __extends = (undefined && undefined.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();



var QuestionEmpty = /** @class */ (function (_super) {
    __extends(QuestionEmpty, _super);
    function QuestionEmpty(name) {
        return _super.call(this, name) || this;
    }
    QuestionEmpty.prototype.onBaseCreating = function () {
        _super.prototype.onBaseCreating.call(this);
        this._implementor = new _koquestion__WEBPACK_IMPORTED_MODULE_1__["QuestionImplementor"](this);
    };
    QuestionEmpty.prototype.dispose = function () {
        this._implementor.dispose();
        this._implementor = undefined;
        _super.prototype.dispose.call(this);
    };
    return QuestionEmpty;
}(survey_core__WEBPACK_IMPORTED_MODULE_0__["QuestionEmptyModel"]));

survey_core__WEBPACK_IMPORTED_MODULE_0__["Serializer"].overrideClassCreator("empty", function () {
    return new QuestionEmpty("");
});


/***/ }),

/***/ "./src/knockout/koquestion_expression.ts":
/*!***********************************************!*\
  !*** ./src/knockout/koquestion_expression.ts ***!
  \***********************************************/
/*! exports provided: QuestionExpression */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "QuestionExpression", function() { return QuestionExpression; });
/* harmony import */ var survey_core__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! survey-core */ "./src/entries/core.ts");
/* harmony import */ var _koquestion__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./koquestion */ "./src/knockout/koquestion.ts");
var __extends = (undefined && undefined.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();




var QuestionExpression = /** @class */ (function (_super) {
    __extends(QuestionExpression, _super);
    function QuestionExpression(name) {
        return _super.call(this, name) || this;
    }
    QuestionExpression.prototype.onBaseCreating = function () {
        _super.prototype.onBaseCreating.call(this);
        this._implementor = new _koquestion__WEBPACK_IMPORTED_MODULE_1__["QuestionImplementor"](this);
    };
    QuestionExpression.prototype.dispose = function () {
        this._implementor.dispose();
        this._implementor = undefined;
        _super.prototype.dispose.call(this);
    };
    return QuestionExpression;
}(survey_core__WEBPACK_IMPORTED_MODULE_0__["QuestionExpressionModel"]));

survey_core__WEBPACK_IMPORTED_MODULE_0__["Serializer"].overrideClassCreator("expression", function () {
    return new QuestionExpression("");
});
survey_core__WEBPACK_IMPORTED_MODULE_0__["QuestionFactory"].Instance.registerQuestion("expression", function (name) {
    return new QuestionExpression(name);
});


/***/ }),

/***/ "./src/knockout/koquestion_file.ts":
/*!*****************************************!*\
  !*** ./src/knockout/koquestion_file.ts ***!
  \*****************************************/
/*! exports provided: QuestionFile */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "QuestionFile", function() { return QuestionFile; });
/* harmony import */ var knockout__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! knockout */ "knockout");
/* harmony import */ var knockout__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(knockout__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var survey_core__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! survey-core */ "./src/entries/core.ts");
/* harmony import */ var _koquestion__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./koquestion */ "./src/knockout/koquestion.ts");
/* harmony import */ var _utils_utils__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../utils/utils */ "./src/utils/utils.ts");
var __extends = (undefined && undefined.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();




var QuestionFileImplementor = /** @class */ (function (_super) {
    __extends(QuestionFileImplementor, _super);
    function QuestionFileImplementor(question) {
        var _this = _super.call(this, question) || this;
        _this.setObservaleObj("koState", knockout__WEBPACK_IMPORTED_MODULE_0__["observable"]("empty"));
        _this.setObservaleObj("koHasValue", knockout__WEBPACK_IMPORTED_MODULE_0__["computed"](function () { return _this.question.koState() === "loaded"; }));
        _this.setObservaleObj("koData", knockout__WEBPACK_IMPORTED_MODULE_0__["computed"](function () {
            if (_this.question.koHasValue()) {
                return _this.question.previewValue;
            }
            return [];
        }));
        _this.setObservaleObj("koInputTitle", knockout__WEBPACK_IMPORTED_MODULE_0__["observable"]());
        _this.setObservaleObj("koChooseFileCss", knockout__WEBPACK_IMPORTED_MODULE_0__["pureComputed"](function () {
            return _this.question.getChooseFileCss();
        }));
        _this.setCallbackFunc("ondrop", function (data, event) {
            _this.question.onDrop(Object(_utils_utils__WEBPACK_IMPORTED_MODULE_3__["getOriginalEvent"])(event));
        });
        _this.setCallbackFunc("ondragover", function (data, event) {
            _this.question.onDragOver(Object(_utils_utils__WEBPACK_IMPORTED_MODULE_3__["getOriginalEvent"])(event));
        });
        _this.setCallbackFunc("ondragleave", function (data, event) {
            _this.question.onDragLeave(Object(_utils_utils__WEBPACK_IMPORTED_MODULE_3__["getOriginalEvent"])(event));
        });
        _this.setCallbackFunc("dochange", function (data, event) {
            _this.question.doChange(Object(_utils_utils__WEBPACK_IMPORTED_MODULE_3__["getOriginalEvent"])(event));
        });
        _this.setCallbackFunc("doclean", function (data, event) {
            _this.question.doClean(Object(_utils_utils__WEBPACK_IMPORTED_MODULE_3__["getOriginalEvent"])(event));
        });
        _this.setCallbackFunc("doremovefile", function (data, event) {
            _this.question.doRemoveFile(data);
        });
        _this.setCallbackFunc("dodownload", function (data, event) {
            _this.question.doDownloadFile(Object(_utils_utils__WEBPACK_IMPORTED_MODULE_3__["getOriginalEvent"])(event), data);
            return true;
        });
        return _this;
    }
    return QuestionFileImplementor;
}(_koquestion__WEBPACK_IMPORTED_MODULE_2__["QuestionImplementor"]));
var QuestionFile = /** @class */ (function (_super) {
    __extends(QuestionFile, _super);
    function QuestionFile(name) {
        var _this = _super.call(this, name) || this;
        var updateState = function (state) {
            _this.koState(state);
            _this.koInputTitle(_this.inputTitle);
        };
        _this.onStateChanged.add(function (sender, options) {
            updateState(options.state);
        });
        return _this;
    }
    QuestionFile.prototype.onBaseCreating = function () {
        _super.prototype.onBaseCreating.call(this);
        this._implementor = new QuestionFileImplementor(this);
    };
    QuestionFile.prototype.dispose = function () {
        this._implementor.dispose();
        this._implementor = undefined;
        _super.prototype.dispose.call(this);
    };
    return QuestionFile;
}(survey_core__WEBPACK_IMPORTED_MODULE_1__["QuestionFileModel"]));

survey_core__WEBPACK_IMPORTED_MODULE_1__["Serializer"].overrideClassCreator("file", function () {
    return new QuestionFile("");
});
survey_core__WEBPACK_IMPORTED_MODULE_1__["QuestionFactory"].Instance.registerQuestion("file", function (name) {
    return new QuestionFile(name);
});


/***/ }),

/***/ "./src/knockout/koquestion_html.ts":
/*!*****************************************!*\
  !*** ./src/knockout/koquestion_html.ts ***!
  \*****************************************/
/*! exports provided: QuestionHtml */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "QuestionHtml", function() { return QuestionHtml; });
/* harmony import */ var survey_core__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! survey-core */ "./src/entries/core.ts");
/* harmony import */ var _koquestion__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./koquestion */ "./src/knockout/koquestion.ts");
var __extends = (undefined && undefined.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();




var QuestionHtml = /** @class */ (function (_super) {
    __extends(QuestionHtml, _super);
    function QuestionHtml(name) {
        return _super.call(this, name) || this;
    }
    QuestionHtml.prototype.onBaseCreating = function () {
        _super.prototype.onBaseCreating.call(this);
        this._implementor = new _koquestion__WEBPACK_IMPORTED_MODULE_1__["QuestionImplementor"](this);
    };
    QuestionHtml.prototype.dispose = function () {
        this._implementor.dispose();
        this._implementor = undefined;
        _super.prototype.dispose.call(this);
    };
    return QuestionHtml;
}(survey_core__WEBPACK_IMPORTED_MODULE_0__["QuestionHtmlModel"]));

survey_core__WEBPACK_IMPORTED_MODULE_0__["Serializer"].overrideClassCreator("html", function () {
    return new QuestionHtml("");
});
survey_core__WEBPACK_IMPORTED_MODULE_0__["QuestionFactory"].Instance.registerQuestion("html", function (name) {
    return new QuestionHtml(name);
});


/***/ }),

/***/ "./src/knockout/koquestion_image.ts":
/*!******************************************!*\
  !*** ./src/knockout/koquestion_image.ts ***!
  \******************************************/
/*! exports provided: QuestionImage */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "QuestionImage", function() { return QuestionImage; });
/* harmony import */ var survey_core__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! survey-core */ "./src/entries/core.ts");
/* harmony import */ var _koquestion__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./koquestion */ "./src/knockout/koquestion.ts");
var __extends = (undefined && undefined.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();




var QuestionImage = /** @class */ (function (_super) {
    __extends(QuestionImage, _super);
    function QuestionImage(name) {
        return _super.call(this, name) || this;
    }
    QuestionImage.prototype.onBaseCreating = function () {
        _super.prototype.onBaseCreating.call(this);
        this._implementor = new _koquestion__WEBPACK_IMPORTED_MODULE_1__["QuestionImplementor"](this);
    };
    QuestionImage.prototype.dispose = function () {
        this._implementor.dispose();
        this._implementor = undefined;
        _super.prototype.dispose.call(this);
    };
    return QuestionImage;
}(survey_core__WEBPACK_IMPORTED_MODULE_0__["QuestionImageModel"]));

survey_core__WEBPACK_IMPORTED_MODULE_0__["Serializer"].overrideClassCreator("image", function () {
    return new QuestionImage("");
});
survey_core__WEBPACK_IMPORTED_MODULE_0__["QuestionFactory"].Instance.registerQuestion("image", function (name) {
    return new QuestionImage(name);
});


/***/ }),

/***/ "./src/knockout/koquestion_imagepicker.ts":
/*!************************************************!*\
  !*** ./src/knockout/koquestion_imagepicker.ts ***!
  \************************************************/
/*! exports provided: QuestionImagePicker */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "QuestionImagePicker", function() { return QuestionImagePicker; });
/* harmony import */ var survey_core__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! survey-core */ "./src/entries/core.ts");
/* harmony import */ var _koquestion_baseselect__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./koquestion_baseselect */ "./src/knockout/koquestion_baseselect.ts");
var __extends = (undefined && undefined.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();




var QuestionImagePickerImplementor = /** @class */ (function (_super) {
    __extends(QuestionImagePickerImplementor, _super);
    function QuestionImagePickerImplementor(question) {
        return _super.call(this, question) || this;
    }
    QuestionImagePickerImplementor.prototype.getKoValue = function () {
        return this.question.renderedValue;
    };
    return QuestionImagePickerImplementor;
}(_koquestion_baseselect__WEBPACK_IMPORTED_MODULE_1__["QuestionCheckboxBaseImplementor"]));
var QuestionImagePicker = /** @class */ (function (_super) {
    __extends(QuestionImagePicker, _super);
    function QuestionImagePicker(name) {
        return _super.call(this, name) || this;
    }
    QuestionImagePicker.prototype.onBaseCreating = function () {
        _super.prototype.onBaseCreating.call(this);
        this._implementor = new QuestionImagePickerImplementor(this);
    };
    QuestionImagePicker.prototype.dispose = function () {
        this._implementor.dispose();
        this._implementor = undefined;
        _super.prototype.dispose.call(this);
    };
    return QuestionImagePicker;
}(survey_core__WEBPACK_IMPORTED_MODULE_0__["QuestionImagePickerModel"]));

survey_core__WEBPACK_IMPORTED_MODULE_0__["Serializer"].overrideClassCreator("imagepicker", function () {
    return new QuestionImagePicker("");
});
survey_core__WEBPACK_IMPORTED_MODULE_0__["QuestionFactory"].Instance.registerQuestion("imagepicker", function (name) {
    var q = new QuestionImagePicker(name);
    //q.choices = QuestionFactory.DefaultChoices;
    return q;
});


/***/ }),

/***/ "./src/knockout/koquestion_matrix.ts":
/*!*******************************************!*\
  !*** ./src/knockout/koquestion_matrix.ts ***!
  \*******************************************/
/*! exports provided: QuestionMatrix */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "QuestionMatrix", function() { return QuestionMatrix; });
/* harmony import */ var knockout__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! knockout */ "knockout");
/* harmony import */ var knockout__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(knockout__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var survey_core__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! survey-core */ "./src/entries/core.ts");
/* harmony import */ var _koquestion__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./koquestion */ "./src/knockout/koquestion.ts");
/* harmony import */ var _kobase__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./kobase */ "./src/knockout/kobase.ts");
var __extends = (undefined && undefined.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();






var QuestionMatrix = /** @class */ (function (_super) {
    __extends(QuestionMatrix, _super);
    function QuestionMatrix(name) {
        var _this = _super.call(this, name) || this;
        _this.koVisibleRows = knockout__WEBPACK_IMPORTED_MODULE_0__["observableArray"]();
        _this.koVisibleColumns = knockout__WEBPACK_IMPORTED_MODULE_0__["observableArray"]();
        _this.koVisibleRows(_this.visibleRows);
        _this.koVisibleColumns(_this.visibleColumns);
        return _this;
    }
    QuestionMatrix.prototype.onBaseCreating = function () {
        _super.prototype.onBaseCreating.call(this);
        this._implementor = new _koquestion__WEBPACK_IMPORTED_MODULE_2__["QuestionImplementor"](this);
    };
    QuestionMatrix.prototype.onColumnsChanged = function () {
        _super.prototype.onColumnsChanged.call(this);
        this.koVisibleColumns(this.visibleColumns);
    };
    QuestionMatrix.prototype.onRowsChanged = function () {
        _super.prototype.onRowsChanged.call(this);
        this.koVisibleRows(this.visibleRows);
    };
    QuestionMatrix.prototype.onSurveyLoad = function () {
        _super.prototype.onSurveyLoad.call(this);
        this.onRowsChanged();
    };
    QuestionMatrix.prototype.onMatrixRowCreated = function (row) {
        new _kobase__WEBPACK_IMPORTED_MODULE_3__["ImplementorBase"](row);
    };
    QuestionMatrix.prototype.getVisibleRows = function () {
        var rows = _super.prototype.getVisibleRows.call(this);
        this.koVisibleRows(rows);
        return rows;
    };
    QuestionMatrix.prototype.dispose = function () {
        this._implementor.dispose();
        this._implementor = undefined;
        this.koVisibleRows = undefined;
        this.koVisibleColumns = undefined;
        _super.prototype.dispose.call(this);
    };
    return QuestionMatrix;
}(survey_core__WEBPACK_IMPORTED_MODULE_1__["QuestionMatrixModel"]));

survey_core__WEBPACK_IMPORTED_MODULE_1__["Serializer"].overrideClassCreator("matrix", function () {
    return new QuestionMatrix("");
});
survey_core__WEBPACK_IMPORTED_MODULE_1__["QuestionFactory"].Instance.registerQuestion("matrix", function (name) {
    var q = new QuestionMatrix(name);
    q.rows = survey_core__WEBPACK_IMPORTED_MODULE_1__["QuestionFactory"].DefaultRows;
    q.columns = survey_core__WEBPACK_IMPORTED_MODULE_1__["QuestionFactory"].DefaultColums;
    return q;
});


/***/ }),

/***/ "./src/knockout/koquestion_matrixdropdown.ts":
/*!***************************************************!*\
  !*** ./src/knockout/koquestion_matrixdropdown.ts ***!
  \***************************************************/
/*! exports provided: QuestionMatrixBaseImplementor, QuestionMatrixDropdown */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "QuestionMatrixBaseImplementor", function() { return QuestionMatrixBaseImplementor; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "QuestionMatrixDropdown", function() { return QuestionMatrixDropdown; });
/* harmony import */ var knockout__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! knockout */ "knockout");
/* harmony import */ var knockout__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(knockout__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var survey_core__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! survey-core */ "./src/entries/core.ts");
/* harmony import */ var _koquestion__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./koquestion */ "./src/knockout/koquestion.ts");
/* harmony import */ var _kobase__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./kobase */ "./src/knockout/kobase.ts");
var __extends = (undefined && undefined.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();








var QuestionMatrixBaseImplementor = /** @class */ (function (_super) {
    __extends(QuestionMatrixBaseImplementor, _super);
    function QuestionMatrixBaseImplementor(question) {
        var _this = _super.call(this, question) || this;
        _this.koRecalc = knockout__WEBPACK_IMPORTED_MODULE_0__["observable"](0);
        (_this.question).onRenderedTableCreatedCallback = function (table) {
            if (!!_this._tableImplementor) {
                _this._tableImplementor.dispose();
            }
            _this._tableImplementor = new _kobase__WEBPACK_IMPORTED_MODULE_3__["ImplementorBase"](table);
        };
        (_this.question).onRenderedTableResetCallback = function () {
            if (_this.question.isDisposed)
                return;
            _this.koRecalc(_this.koRecalc() + 1);
        };
        _this.setObservaleObj("koTable", knockout__WEBPACK_IMPORTED_MODULE_0__["pureComputed"](function () {
            _this.koRecalc();
            return _this.question.renderedTable;
        }));
        _this.setCallbackFunc("koCellAfterRender", function (el, con) {
            return _this.cellAfterRender(el, con);
        });
        _this.setCallbackFunc("koCellQuestionAfterRender", function (el, con) {
            return _this.cellQuestionAfterRender(el, con);
        });
        _this.setCallbackFunc("koAddRowClick", function () {
            _this.addRow();
        });
        _this.setCallbackFunc("koRemoveRowClick", function (data) {
            _this.removeRow(data.row);
        });
        _this.setCallbackFunc("koPanelAfterRender", function (el, con) {
            _this.panelAfterRender(el, con);
        });
        return _this;
    }
    QuestionMatrixBaseImplementor.prototype.getQuestionTemplate = function () {
        return "matrixdynamic";
    };
    QuestionMatrixBaseImplementor.prototype.cellAfterRender = function (elements, con) {
        var _this = this;
        if (!this.question.survey)
            return;
        setTimeout(function () {
            !!knockout__WEBPACK_IMPORTED_MODULE_0__["tasks"] && knockout__WEBPACK_IMPORTED_MODULE_0__["tasks"].runEarly();
            var el = survey_core__WEBPACK_IMPORTED_MODULE_1__["SurveyElement"].GetFirstNonTextElement(elements);
            if (!el)
                return;
            var cell = con;
            var options = {
                cell: cell.cell,
                cellQuestion: cell.question,
                htmlElement: el,
                row: cell.row,
                column: !!cell.cell ? cell.cell.column : null,
            };
            _this.question.survey.matrixAfterCellRender(_this.question, options);
        }, 0);
    };
    QuestionMatrixBaseImplementor.prototype.cellQuestionAfterRender = function (elements, con) {
        if (!this.question.survey)
            return;
        setTimeout(function () {
            !!knockout__WEBPACK_IMPORTED_MODULE_0__["tasks"] && knockout__WEBPACK_IMPORTED_MODULE_0__["tasks"].runEarly();
            var el = survey_core__WEBPACK_IMPORTED_MODULE_1__["SurveyElement"].GetFirstNonTextElement(elements);
            if (!el)
                return;
            var cell = con;
            if (cell.question.customWidget) {
                cell.question.customWidget.afterRender(cell.question, el);
                knockout__WEBPACK_IMPORTED_MODULE_0__["utils"].domNodeDisposal.addDisposeCallback(el, function () {
                    cell.question.customWidget.willUnmount(cell.question, el);
                });
            }
            cell.question.afterRenderQuestionElement(el);
        }, 0);
    };
    QuestionMatrixBaseImplementor.prototype.isAddRowTop = function () {
        return false;
    };
    QuestionMatrixBaseImplementor.prototype.isAddRowBottom = function () {
        return false;
    };
    QuestionMatrixBaseImplementor.prototype.addRow = function () { };
    QuestionMatrixBaseImplementor.prototype.removeRow = function (row) { };
    QuestionMatrixBaseImplementor.prototype.panelAfterRender = function (elements, con) {
        if (!this.question || !this.question.survey)
            return;
        var el = survey_core__WEBPACK_IMPORTED_MODULE_1__["SurveyElement"].GetFirstNonTextElement(elements);
        this.question.survey.afterRenderPanel(con, el);
    };
    QuestionMatrixBaseImplementor.prototype.dispose = function () {
        if (!!this._tableImplementor) {
            this._tableImplementor.dispose();
        }
        (this.question).onRenderedTableCreatedCallback = undefined;
        (this.question).onRenderedTableResetCallback = undefined;
        _super.prototype.dispose.call(this);
    };
    return QuestionMatrixBaseImplementor;
}(_koquestion__WEBPACK_IMPORTED_MODULE_2__["QuestionImplementor"]));

var QuestionMatrixDropdown = /** @class */ (function (_super) {
    __extends(QuestionMatrixDropdown, _super);
    function QuestionMatrixDropdown(name) {
        return _super.call(this, name) || this;
    }
    QuestionMatrixDropdown.prototype.onBaseCreating = function () {
        _super.prototype.onBaseCreating.call(this);
        this._implementor = new QuestionMatrixBaseImplementor(this);
    };
    QuestionMatrixDropdown.prototype.dispose = function () {
        _super.prototype.dispose.call(this);
        this._implementor.dispose();
        this._implementor = undefined;
    };
    return QuestionMatrixDropdown;
}(survey_core__WEBPACK_IMPORTED_MODULE_1__["QuestionMatrixDropdownModel"]));

survey_core__WEBPACK_IMPORTED_MODULE_1__["Serializer"].overrideClassCreator("matrixdropdown", function () {
    return new QuestionMatrixDropdown("");
});
survey_core__WEBPACK_IMPORTED_MODULE_1__["QuestionFactory"].Instance.registerQuestion("matrixdropdown", function (name) {
    var q = new QuestionMatrixDropdown(name);
    q.choices = [1, 2, 3, 4, 5];
    q.rows = survey_core__WEBPACK_IMPORTED_MODULE_1__["QuestionFactory"].DefaultRows;
    survey_core__WEBPACK_IMPORTED_MODULE_1__["QuestionMatrixDropdownModelBase"].addDefaultColumns(q);
    return q;
});


/***/ }),

/***/ "./src/knockout/koquestion_matrixdynamic.ts":
/*!**************************************************!*\
  !*** ./src/knockout/koquestion_matrixdynamic.ts ***!
  \**************************************************/
/*! exports provided: QuestionMatrixDynamicImplementor, QuestionMatrixDynamic */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "QuestionMatrixDynamicImplementor", function() { return QuestionMatrixDynamicImplementor; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "QuestionMatrixDynamic", function() { return QuestionMatrixDynamic; });
/* harmony import */ var knockout__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! knockout */ "knockout");
/* harmony import */ var knockout__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(knockout__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var survey_core__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! survey-core */ "./src/entries/core.ts");
/* harmony import */ var _koquestion_matrixdropdown__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./koquestion_matrixdropdown */ "./src/knockout/koquestion_matrixdropdown.ts");
/* harmony import */ var _kobase__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./kobase */ "./src/knockout/kobase.ts");
var __extends = (undefined && undefined.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();







var QuestionMatrixDynamicImplementor = /** @class */ (function (_super) {
    __extends(QuestionMatrixDynamicImplementor, _super);
    function QuestionMatrixDynamicImplementor(question) {
        var _this = _super.call(this, question) || this;
        _this.question["getKoPopupIsVisible"] = _this.getKoPopupIsVisible;
        return _this;
    }
    QuestionMatrixDynamicImplementor.prototype.addRow = function () {
        this.question.addRowUI();
    };
    QuestionMatrixDynamicImplementor.prototype.removeRow = function (row) {
        this.question.removeRowUI(row);
    };
    QuestionMatrixDynamicImplementor.prototype.getKoPopupIsVisible = function (row) {
        return knockout__WEBPACK_IMPORTED_MODULE_0__["observable"](row.isDetailPanelShowing);
    };
    QuestionMatrixDynamicImplementor.prototype.dispose = function () {
        _super.prototype.dispose.call(this);
        this.question["getKoPopupIsVisible"] = undefined;
    };
    return QuestionMatrixDynamicImplementor;
}(_koquestion_matrixdropdown__WEBPACK_IMPORTED_MODULE_2__["QuestionMatrixBaseImplementor"]));

var QuestionMatrixDynamic = /** @class */ (function (_super) {
    __extends(QuestionMatrixDynamic, _super);
    function QuestionMatrixDynamic(name) {
        return _super.call(this, name) || this;
    }
    QuestionMatrixDynamic.prototype.onBaseCreating = function () {
        _super.prototype.onBaseCreating.call(this);
        this._implementor = new QuestionMatrixDynamicImplementor(this);
    };
    QuestionMatrixDynamic.prototype.dispose = function () {
        this._implementor.dispose();
        this._implementor = undefined;
        _super.prototype.dispose.call(this);
    };
    return QuestionMatrixDynamic;
}(survey_core__WEBPACK_IMPORTED_MODULE_1__["QuestionMatrixDynamicModel"]));

survey_core__WEBPACK_IMPORTED_MODULE_1__["Serializer"].overrideClassCreator("matrixdynamic", function () {
    return new QuestionMatrixDynamic("");
});
survey_core__WEBPACK_IMPORTED_MODULE_1__["QuestionMatrixDropdownRenderedRow"].prototype["onCreating"] = function () {
    new _kobase__WEBPACK_IMPORTED_MODULE_3__["ImplementorBase"](this);
};
survey_core__WEBPACK_IMPORTED_MODULE_1__["QuestionFactory"].Instance.registerQuestion("matrixdynamic", function (name) {
    var q = new QuestionMatrixDynamic(name);
    q.choices = [1, 2, 3, 4, 5];
    q.rowCount = 2;
    survey_core__WEBPACK_IMPORTED_MODULE_1__["QuestionMatrixDropdownModelBase"].addDefaultColumns(q);
    return q;
});


/***/ }),

/***/ "./src/knockout/koquestion_multipletext.ts":
/*!*************************************************!*\
  !*** ./src/knockout/koquestion_multipletext.ts ***!
  \*************************************************/
/*! exports provided: MultipleTextItem, QuestionMultipleTextImplementor, QuestionMultipleText */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "MultipleTextItem", function() { return MultipleTextItem; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "QuestionMultipleTextImplementor", function() { return QuestionMultipleTextImplementor; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "QuestionMultipleText", function() { return QuestionMultipleText; });
/* harmony import */ var knockout__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! knockout */ "knockout");
/* harmony import */ var knockout__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(knockout__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var survey_core__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! survey-core */ "./src/entries/core.ts");
/* harmony import */ var _koquestion__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./koquestion */ "./src/knockout/koquestion.ts");
/* harmony import */ var _koquestion_text__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./koquestion_text */ "./src/knockout/koquestion_text.ts");
var __extends = (undefined && undefined.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();






var MultipleTextItem = /** @class */ (function (_super) {
    __extends(MultipleTextItem, _super);
    function MultipleTextItem(name, title) {
        if (name === void 0) { name = null; }
        if (title === void 0) { title = null; }
        return _super.call(this, name, title) || this;
    }
    MultipleTextItem.prototype.createEditor = function (name) {
        return new _koquestion_text__WEBPACK_IMPORTED_MODULE_3__["QuestionText"](name);
    };
    return MultipleTextItem;
}(survey_core__WEBPACK_IMPORTED_MODULE_1__["MultipleTextItemModel"]));

var QuestionMultipleTextImplementor = /** @class */ (function (_super) {
    __extends(QuestionMultipleTextImplementor, _super);
    function QuestionMultipleTextImplementor(question) {
        var _this = _super.call(this, question) || this;
        _this.koRecalc = knockout__WEBPACK_IMPORTED_MODULE_0__["observable"](0);
        _this.setObservaleObj("koItemCss", knockout__WEBPACK_IMPORTED_MODULE_0__["pureComputed"](function () {
            _this.koRecalc();
            return _this.question.getItemCss();
        }));
        _this.setObservaleObj("koItemTitleCss", knockout__WEBPACK_IMPORTED_MODULE_0__["pureComputed"](function () {
            _this.koRecalc();
            return _this.question.getItemTitleCss();
        }));
        return _this;
    }
    return QuestionMultipleTextImplementor;
}(_koquestion__WEBPACK_IMPORTED_MODULE_2__["QuestionImplementor"]));

var QuestionMultipleText = /** @class */ (function (_super) {
    __extends(QuestionMultipleText, _super);
    function QuestionMultipleText(name) {
        var _this = _super.call(this, name) || this;
        _this.koRows = knockout__WEBPACK_IMPORTED_MODULE_0__["observableArray"](_this.getRows());
        _this.colCountChangedCallback = function () {
            _this.onColCountChanged();
        };
        _this.onColCountChanged();
        return _this;
    }
    QuestionMultipleText.prototype.onBaseCreating = function () {
        _super.prototype.onBaseCreating.call(this);
        this._implementor = new QuestionMultipleTextImplementor(this);
    };
    QuestionMultipleText.prototype.onColCountChanged = function () {
        this.koRows(this.getRows());
    };
    QuestionMultipleText.prototype.createTextItem = function (name, title) {
        return new MultipleTextItem(name, title);
    };
    QuestionMultipleText.prototype.dispose = function () {
        this._implementor.dispose();
        this._implementor = undefined;
        this.koRows = undefined;
        _super.prototype.dispose.call(this);
    };
    return QuestionMultipleText;
}(survey_core__WEBPACK_IMPORTED_MODULE_1__["QuestionMultipleTextModel"]));

survey_core__WEBPACK_IMPORTED_MODULE_1__["Serializer"].overrideClassCreator("multipletextitem", function () {
    return new MultipleTextItem("");
});
survey_core__WEBPACK_IMPORTED_MODULE_1__["Serializer"].overrideClassCreator("multipletext", function () {
    return new QuestionMultipleText("");
});
survey_core__WEBPACK_IMPORTED_MODULE_1__["QuestionFactory"].Instance.registerQuestion("multipletext", function (name) {
    var q = new QuestionMultipleText(name);
    survey_core__WEBPACK_IMPORTED_MODULE_1__["QuestionMultipleTextModel"].addDefaultItems(q);
    return q;
});


/***/ }),

/***/ "./src/knockout/koquestion_paneldynamic.ts":
/*!*************************************************!*\
  !*** ./src/knockout/koquestion_paneldynamic.ts ***!
  \*************************************************/
/*! exports provided: QuestionPanelDynamicImplementor, QuestionPanelDynamic */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "QuestionPanelDynamicImplementor", function() { return QuestionPanelDynamicImplementor; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "QuestionPanelDynamic", function() { return QuestionPanelDynamic; });
/* harmony import */ var knockout__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! knockout */ "knockout");
/* harmony import */ var knockout__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(knockout__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var survey_core__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! survey-core */ "./src/entries/core.ts");
/* harmony import */ var _koquestion__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./koquestion */ "./src/knockout/koquestion.ts");
var __extends = (undefined && undefined.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();



var QuestionPanelDynamicImplementor = /** @class */ (function (_super) {
    __extends(QuestionPanelDynamicImplementor, _super);
    function QuestionPanelDynamicImplementor(question) {
        var _this = _super.call(this, question) || this;
        _this.koRecalc = knockout__WEBPACK_IMPORTED_MODULE_0__["observable"](0);
        _this.setCallbackFunc("koAddPanelClick", function () {
            _this.addPanel();
        });
        _this.setCallbackFunc("koRemovePanelClick", function (data) {
            _this.removePanel(data);
        });
        _this.setCallbackFunc("koPrevPanelClick", function () {
            _this.question.goToPrevPanel();
        });
        _this.setCallbackFunc("koNextPanelClick", function () {
            _this.question.goToNextPanel();
        });
        _this.setObservaleObj("koCanAddPanel", knockout__WEBPACK_IMPORTED_MODULE_0__["pureComputed"](function () {
            _this.koRecalc();
            return _this.question.canAddPanel;
        }));
        _this.setObservaleObj("koCanRemovePanel", knockout__WEBPACK_IMPORTED_MODULE_0__["pureComputed"](function () {
            _this.koRecalc();
            return _this.question.canRemovePanel;
        }));
        _this.setObservaleObj("koIsPrevButton", knockout__WEBPACK_IMPORTED_MODULE_0__["pureComputed"](function () {
            _this.koRecalc();
            return _this.question.isPrevButtonShowing;
        }));
        _this.setObservaleObj("koIsNextButton", knockout__WEBPACK_IMPORTED_MODULE_0__["pureComputed"](function () {
            _this.koRecalc();
            return _this.question.isNextButtonShowing;
        }));
        _this.setObservaleObj("koIsRange", knockout__WEBPACK_IMPORTED_MODULE_0__["pureComputed"](function () {
            _this.koRecalc();
            return _this.question.isRangeShowing;
        }));
        _this.setObservaleObj("koPanel", knockout__WEBPACK_IMPORTED_MODULE_0__["pureComputed"](function () {
            _this.koRecalc();
            return _this.question.currentPanel;
        }));
        _this.setObservaleObj("koIsList", knockout__WEBPACK_IMPORTED_MODULE_0__["pureComputed"](function () {
            _this.koRecalc();
            return _this.question.isRenderModeList;
        }));
        _this.setObservaleObj("koIsProgressTop", knockout__WEBPACK_IMPORTED_MODULE_0__["pureComputed"](function () {
            _this.koRecalc();
            return _this.question.isProgressTopShowing;
        }));
        _this.setObservaleObj("koIsProgressBottom", knockout__WEBPACK_IMPORTED_MODULE_0__["pureComputed"](function () {
            _this.koRecalc();
            return _this.question.isProgressBottomShowing;
        }));
        var koRangeValue = knockout__WEBPACK_IMPORTED_MODULE_0__["observable"](_this.question.currentIndex);
        koRangeValue.subscribe(function (newValue) {
            _this.question.currentIndex = newValue;
        });
        _this.setObservaleObj("koRangeValue", koRangeValue);
        _this.setObservaleObj("koRangeMax", knockout__WEBPACK_IMPORTED_MODULE_0__["pureComputed"](function () {
            _this.koRecalc();
            return _this.question.panelCount - 1;
        }));
        _this.setObservaleObj("koAddButtonCss", knockout__WEBPACK_IMPORTED_MODULE_0__["pureComputed"](function () {
            _this.koRecalc();
            return _this.question.getAddButtonCss();
        }));
        _this.setObservaleObj("koPrevButtonCss", knockout__WEBPACK_IMPORTED_MODULE_0__["pureComputed"](function () {
            _this.koRecalc();
            return _this.question.getPrevButtonCss();
        }));
        _this.setObservaleObj("koNextButtonCss", knockout__WEBPACK_IMPORTED_MODULE_0__["pureComputed"](function () {
            _this.koRecalc();
            return _this.question.getNextButtonCss();
        }));
        _this.setObservaleObj("koProgressText", knockout__WEBPACK_IMPORTED_MODULE_0__["pureComputed"](function () {
            _this.koRecalc();
            return _this.question.progressText;
        }));
        _this.setObservaleObj("koProgress", knockout__WEBPACK_IMPORTED_MODULE_0__["pureComputed"](function () {
            _this.koRecalc();
            return _this.question.progress;
        }));
        _this.setCallbackFunc("koPanelAfterRender", function (el, con) {
            _this.panelAfterRender(el, con);
        });
        _this.question.panelCountChangedCallback = function () {
            _this.onPanelCountChanged();
        };
        _this.question.renderModeChangedCallback = function () {
            _this.onRenderModeChanged();
        };
        _this.question.currentIndexChangedCallback = function () {
            _this.onCurrentIndexChanged();
        };
        return _this;
    }
    QuestionPanelDynamicImplementor.prototype.onPanelCountChanged = function () {
        this.onCurrentIndexChanged();
    };
    QuestionPanelDynamicImplementor.prototype.onRenderModeChanged = function () {
        this.onCurrentIndexChanged();
    };
    QuestionPanelDynamicImplementor.prototype.onCurrentIndexChanged = function () {
        if (this.question.isDisposed)
            return;
        this.koRecalc(this.koRecalc() + 1);
        this.question.koRangeValue(this.question.currentIndex);
    };
    QuestionPanelDynamicImplementor.prototype.addPanel = function () {
        this.question.addPanelUI();
    };
    QuestionPanelDynamicImplementor.prototype.removePanel = function (val) {
        if (!this.question.isRenderModeList) {
            val = this.question.currentPanel;
        }
        this.question.removePanelUI(val);
    };
    QuestionPanelDynamicImplementor.prototype.panelAfterRender = function (elements, con) {
        if (!this.question || !this.question.survey)
            return;
        var el = survey_core__WEBPACK_IMPORTED_MODULE_1__["SurveyElement"].GetFirstNonTextElement(elements);
        this.question.survey.afterRenderPanel(con, el);
    };
    QuestionPanelDynamicImplementor.prototype.dispose = function () {
        this.question.panelCountChangedCallback = undefined;
        this.question.renderModeChangedCallback = undefined;
        this.question.currentIndexChangedCallback = undefined;
        _super.prototype.dispose.call(this);
    };
    return QuestionPanelDynamicImplementor;
}(_koquestion__WEBPACK_IMPORTED_MODULE_2__["QuestionImplementor"]));

var QuestionPanelDynamic = /** @class */ (function (_super) {
    __extends(QuestionPanelDynamic, _super);
    function QuestionPanelDynamic(name) {
        return _super.call(this, name) || this;
    }
    QuestionPanelDynamic.prototype.onBaseCreating = function () {
        _super.prototype.onBaseCreating.call(this);
        this._implementor = new QuestionPanelDynamicImplementor(this);
    };
    QuestionPanelDynamic.prototype.dispose = function () {
        this._implementor.dispose();
        this._implementor = undefined;
        _super.prototype.dispose.call(this);
    };
    return QuestionPanelDynamic;
}(survey_core__WEBPACK_IMPORTED_MODULE_1__["QuestionPanelDynamicModel"]));

survey_core__WEBPACK_IMPORTED_MODULE_1__["Serializer"].overrideClassCreator("paneldynamic", function () {
    return new QuestionPanelDynamic("");
});
survey_core__WEBPACK_IMPORTED_MODULE_1__["QuestionFactory"].Instance.registerQuestion("paneldynamic", function (name) {
    return new QuestionPanelDynamic(name);
});


/***/ }),

/***/ "./src/knockout/koquestion_radiogroup.ts":
/*!***********************************************!*\
  !*** ./src/knockout/koquestion_radiogroup.ts ***!
  \***********************************************/
/*! exports provided: QuestionRadiogroup */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "QuestionRadiogroup", function() { return QuestionRadiogroup; });
/* harmony import */ var survey_core__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! survey-core */ "./src/entries/core.ts");
/* harmony import */ var _koquestion_baseselect__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./koquestion_baseselect */ "./src/knockout/koquestion_baseselect.ts");
var __extends = (undefined && undefined.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();




var QuestionRadiogroup = /** @class */ (function (_super) {
    __extends(QuestionRadiogroup, _super);
    function QuestionRadiogroup(name) {
        return _super.call(this, name) || this;
    }
    QuestionRadiogroup.prototype.onBaseCreating = function () {
        _super.prototype.onBaseCreating.call(this);
        this._implementor = new _koquestion_baseselect__WEBPACK_IMPORTED_MODULE_1__["QuestionCheckboxBaseImplementor"](this);
    };
    QuestionRadiogroup.prototype.dispose = function () {
        this._implementor.dispose();
        this._implementor = undefined;
        _super.prototype.dispose.call(this);
    };
    return QuestionRadiogroup;
}(survey_core__WEBPACK_IMPORTED_MODULE_0__["QuestionRadiogroupModel"]));

survey_core__WEBPACK_IMPORTED_MODULE_0__["Serializer"].overrideClassCreator("radiogroup", function () {
    return new QuestionRadiogroup("");
});
survey_core__WEBPACK_IMPORTED_MODULE_0__["QuestionFactory"].Instance.registerQuestion("radiogroup", function (name) {
    var q = new QuestionRadiogroup(name);
    q.choices = survey_core__WEBPACK_IMPORTED_MODULE_0__["QuestionFactory"].DefaultChoices;
    return q;
});


/***/ }),

/***/ "./src/knockout/koquestion_ranking.ts":
/*!********************************************!*\
  !*** ./src/knockout/koquestion_ranking.ts ***!
  \********************************************/
/*! exports provided: QuestionRanking */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "QuestionRanking", function() { return QuestionRanking; });
/* harmony import */ var survey_core__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! survey-core */ "./src/entries/core.ts");
/* harmony import */ var _koquestion__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./koquestion */ "./src/knockout/koquestion.ts");
var __extends = (undefined && undefined.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();


var QuestionRanking = /** @class */ (function (_super) {
    __extends(QuestionRanking, _super);
    function QuestionRanking() {
        var _this = _super !== null && _super.apply(this, arguments) || this;
        _this.koHandleKeydown = function (data, event) {
            _this.handleKeydown(event, data);
            return true;
        };
        _this.koHandlePointerDown = function (data, event) {
            event.preventDefault();
            _this.handlePointerDown(event, data, event.currentTarget);
            return true;
        };
        return _this;
    }
    QuestionRanking.prototype.onBaseCreating = function () {
        _super.prototype.onBaseCreating.call(this);
        this._implementor = new _koquestion__WEBPACK_IMPORTED_MODULE_1__["QuestionImplementor"](this);
    };
    QuestionRanking.prototype.dispose = function () {
        this._implementor.dispose();
        this._implementor = undefined;
        _super.prototype.dispose.call(this);
    };
    return QuestionRanking;
}(survey_core__WEBPACK_IMPORTED_MODULE_0__["QuestionRankingModel"]));

survey_core__WEBPACK_IMPORTED_MODULE_0__["Serializer"].overrideClassCreator("ranking", function () {
    return new QuestionRanking("");
});
survey_core__WEBPACK_IMPORTED_MODULE_0__["QuestionFactory"].Instance.registerQuestion("ranking", function (name) {
    var q = new QuestionRanking(name);
    q.choices = survey_core__WEBPACK_IMPORTED_MODULE_0__["QuestionFactory"].DefaultChoices;
    return q;
});


/***/ }),

/***/ "./src/knockout/koquestion_rating.ts":
/*!*******************************************!*\
  !*** ./src/knockout/koquestion_rating.ts ***!
  \*******************************************/
/*! exports provided: QuestionRatingImplementor, QuestionRating */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "QuestionRatingImplementor", function() { return QuestionRatingImplementor; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "QuestionRating", function() { return QuestionRating; });
/* harmony import */ var _koquestion__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./koquestion */ "./src/knockout/koquestion.ts");
/* harmony import */ var survey_core__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! survey-core */ "./src/entries/core.ts");
var __extends = (undefined && undefined.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();


var QuestionRatingImplementor = /** @class */ (function (_super) {
    __extends(QuestionRatingImplementor, _super);
    function QuestionRatingImplementor(question) {
        var _this = _super.call(this, question) || this;
        _this.onCreated();
        return _this;
    }
    QuestionRatingImplementor.prototype.onCreated = function () { };
    QuestionRatingImplementor.prototype.dispose = function () {
        this.question.rateValuesChangedCallback = undefined;
        _super.prototype.dispose.call(this);
    };
    return QuestionRatingImplementor;
}(_koquestion__WEBPACK_IMPORTED_MODULE_0__["QuestionImplementor"]));

var QuestionRating = /** @class */ (function (_super) {
    __extends(QuestionRating, _super);
    function QuestionRating(name) {
        return _super.call(this, name) || this;
    }
    QuestionRating.prototype.onBaseCreating = function () {
        _super.prototype.onBaseCreating.call(this);
        this._implementor = new QuestionRatingImplementor(this);
    };
    QuestionRating.prototype.dispose = function () {
        this._implementor.dispose();
        this._implementor = undefined;
        _super.prototype.dispose.call(this);
    };
    return QuestionRating;
}(survey_core__WEBPACK_IMPORTED_MODULE_1__["QuestionRatingModel"]));

survey_core__WEBPACK_IMPORTED_MODULE_1__["Serializer"].overrideClassCreator("rating", function () {
    return new QuestionRating("");
});
survey_core__WEBPACK_IMPORTED_MODULE_1__["QuestionFactory"].Instance.registerQuestion("rating", function (name) {
    return new QuestionRating(name);
});


/***/ }),

/***/ "./src/knockout/koquestion_signaturepad.ts":
/*!*************************************************!*\
  !*** ./src/knockout/koquestion_signaturepad.ts ***!
  \*************************************************/
/*! exports provided: QuestionSignaturePad */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "QuestionSignaturePad", function() { return QuestionSignaturePad; });
/* harmony import */ var survey_core__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! survey-core */ "./src/entries/core.ts");
/* harmony import */ var _koquestion__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./koquestion */ "./src/knockout/koquestion.ts");
var __extends = (undefined && undefined.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();



var QuestionSignaturePad = /** @class */ (function (_super) {
    __extends(QuestionSignaturePad, _super);
    function QuestionSignaturePad(name) {
        return _super.call(this, name) || this;
    }
    QuestionSignaturePad.prototype.onBaseCreating = function () {
        _super.prototype.onBaseCreating.call(this);
        this._implementor = new _koquestion__WEBPACK_IMPORTED_MODULE_1__["QuestionImplementor"](this);
    };
    QuestionSignaturePad.prototype.dispose = function () {
        this._implementor.dispose();
        this._implementor = undefined;
        _super.prototype.dispose.call(this);
    };
    return QuestionSignaturePad;
}(survey_core__WEBPACK_IMPORTED_MODULE_0__["QuestionSignaturePadModel"]));

survey_core__WEBPACK_IMPORTED_MODULE_0__["Serializer"].overrideClassCreator("signaturepad", function () {
    return new QuestionSignaturePad("");
});
survey_core__WEBPACK_IMPORTED_MODULE_0__["QuestionFactory"].Instance.registerQuestion("signaturepad", function (name) {
    return new QuestionSignaturePad(name);
});


/***/ }),

/***/ "./src/knockout/koquestion_text.ts":
/*!*****************************************!*\
  !*** ./src/knockout/koquestion_text.ts ***!
  \*****************************************/
/*! exports provided: QuestionText */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "QuestionText", function() { return QuestionText; });
/* harmony import */ var survey_core__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! survey-core */ "./src/entries/core.ts");
/* harmony import */ var _koquestion__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./koquestion */ "./src/knockout/koquestion.ts");
var __extends = (undefined && undefined.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();




var QuestionText = /** @class */ (function (_super) {
    __extends(QuestionText, _super);
    function QuestionText(name) {
        return _super.call(this, name) || this;
    }
    QuestionText.prototype.onBaseCreating = function () {
        _super.prototype.onBaseCreating.call(this);
        this._implementor = new _koquestion__WEBPACK_IMPORTED_MODULE_1__["QuestionImplementor"](this);
    };
    QuestionText.prototype.dispose = function () {
        this._implementor.dispose();
        this._implementor = undefined;
        _super.prototype.dispose.call(this);
    };
    return QuestionText;
}(survey_core__WEBPACK_IMPORTED_MODULE_0__["QuestionTextModel"]));

survey_core__WEBPACK_IMPORTED_MODULE_0__["Serializer"].overrideClassCreator("text", function () {
    return new QuestionText("");
});
survey_core__WEBPACK_IMPORTED_MODULE_0__["QuestionFactory"].Instance.registerQuestion("text", function (name) {
    return new QuestionText(name);
});


/***/ }),

/***/ "./src/knockout/kosurvey.ts":
/*!**********************************!*\
  !*** ./src/knockout/kosurvey.ts ***!
  \**********************************/
/*! exports provided: SurveyImplementor, Survey, registerTemplateEngine */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "SurveyImplementor", function() { return SurveyImplementor; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "Survey", function() { return Survey; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "registerTemplateEngine", function() { return registerTemplateEngine; });
/* harmony import */ var knockout__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! knockout */ "knockout");
/* harmony import */ var knockout__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(knockout__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var survey_core__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! survey-core */ "./src/entries/core.ts");
/* harmony import */ var _templateText__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./templateText */ "./src/knockout/templateText.ts");
/* harmony import */ var _kobase__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./kobase */ "./src/knockout/kobase.ts");
/* harmony import */ var _utils_utils__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../utils/utils */ "./src/utils/utils.ts");
/* harmony import */ var _surveyTimerModel__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../surveyTimerModel */ "./src/surveyTimerModel.ts");
var __extends = (undefined && undefined.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();










survey_core__WEBPACK_IMPORTED_MODULE_1__["CustomWidgetCollection"].Instance.onCustomWidgetAdded.add(function (customWidget) {
    if (customWidget.widgetJson.isDefaultRender)
        return;
    if (!customWidget.htmlTemplate)
        customWidget.htmlTemplate =
            "<div>'htmlTemplate' attribute is missed.</div>";
    new _templateText__WEBPACK_IMPORTED_MODULE_2__["SurveyTemplateText"]().replaceText(customWidget.htmlTemplate, "widget", customWidget.name);
});
var SurveyImplementor = /** @class */ (function (_super) {
    __extends(SurveyImplementor, _super);
    function SurveyImplementor(survey) {
        var _this = _super.call(this, survey) || this;
        _this.survey = survey;
        _this.survey.valueHashGetDataCallback = function (valuesHash, key) {
            if (valuesHash[key] === undefined) {
                valuesHash[key] = knockout__WEBPACK_IMPORTED_MODULE_0__["observable"]();
            }
            return knockout__WEBPACK_IMPORTED_MODULE_0__["unwrap"](valuesHash[key]);
        };
        _this.survey.valueHashSetDataCallback = function (valuesHash, key, value) {
            if (knockout__WEBPACK_IMPORTED_MODULE_0__["isWriteableObservable"](valuesHash[key])) {
                valuesHash[key](value);
            }
            else {
                valuesHash[key] = knockout__WEBPACK_IMPORTED_MODULE_0__["observable"](value);
            }
        };
        _this.survey.valueHashDeleteDataCallback = function (valuesHash, key) {
            if (knockout__WEBPACK_IMPORTED_MODULE_0__["isWriteableObservable"](valuesHash[key])) {
                valuesHash[key](undefined);
            }
            else {
                delete valuesHash[key];
            }
        };
        _this.survey["koTitleTemplate"] = knockout__WEBPACK_IMPORTED_MODULE_0__["observable"]("survey-header");
        _this.survey["koAfterRenderPage"] = function (elements, con) {
            var el = survey_core__WEBPACK_IMPORTED_MODULE_1__["SurveyElement"].GetFirstNonTextElement(elements);
            if (!el)
                return;
            setTimeout(function () {
                !!knockout__WEBPACK_IMPORTED_MODULE_0__["tasks"] && knockout__WEBPACK_IMPORTED_MODULE_0__["tasks"].runEarly();
                _this.survey.afterRenderPage(el);
            }, 0);
        };
        _this.survey["koAfterRenderHeader"] = function (elements, con) {
            var el = survey_core__WEBPACK_IMPORTED_MODULE_1__["SurveyElement"].GetFirstNonTextElement(elements);
            if (el)
                _this.survey.afterRenderHeader(el);
        };
        _this.survey.disposeCallback = function () {
            _this.dispose();
        };
        return _this;
    }
    SurveyImplementor.prototype.render = function (element) {
        if (element === void 0) { element = null; }
        if (typeof knockout__WEBPACK_IMPORTED_MODULE_0__ === "undefined")
            throw new Error("knockoutjs library is not loaded.");
        var page = this.survey.activePage;
        if (!!page) {
            page.updateCustomWidgets();
        }
        this.survey.updateElementCss(false);
        if (element && typeof element === "string") {
            element = document.getElementById(element);
        }
        if (element) {
            this.renderedElement = element;
        }
        this.survey.startTimerFromUI();
        this.applyBinding();
    };
    SurveyImplementor.prototype.applyBinding = function () {
        if (!this.renderedElement)
            return;
        knockout__WEBPACK_IMPORTED_MODULE_0__["cleanNode"](this.renderedElement);
        knockout__WEBPACK_IMPORTED_MODULE_0__["renderTemplate"]("survey-content", this.survey, {}, this.renderedElement);
    };
    SurveyImplementor.prototype.koEventAfterRender = function (element, survey) {
        survey_core__WEBPACK_IMPORTED_MODULE_1__["SvgRegistry"].renderIcons();
        survey.afterRenderSurvey(element);
    };
    SurveyImplementor.prototype.dispose = function () {
        _super.prototype.dispose.call(this);
        if (!!this.renderedElement) {
            knockout__WEBPACK_IMPORTED_MODULE_0__["cleanNode"](this.renderedElement);
            this.renderedElement.innerHTML = "";
        }
        this.survey["koAfterRenderPage"] = undefined;
        this.survey["koAfterRenderHeader"] = undefined;
        this.survey.iteratePropertiesHash(function (hash, key) {
            delete hash[key];
        });
    };
    return SurveyImplementor;
}(_kobase__WEBPACK_IMPORTED_MODULE_3__["ImplementorBase"]));

survey_core__WEBPACK_IMPORTED_MODULE_1__["SurveyModel"].prototype["onCreating"] = function () {
    this.implementor = new SurveyImplementor(this);
};
survey_core__WEBPACK_IMPORTED_MODULE_1__["SurveyModel"].prototype["render"] = function (element) {
    if (element === void 0) { element = null; }
    this.implementor.render(element);
};
survey_core__WEBPACK_IMPORTED_MODULE_1__["SurveyModel"].prototype["getHtmlTemplate"] = function () {
    return _templateText__WEBPACK_IMPORTED_MODULE_2__["koTemplate"];
};
var Survey = /** @class */ (function (_super) {
    __extends(Survey, _super);
    function Survey(jsonObj, renderedElement) {
        if (jsonObj === void 0) { jsonObj = null; }
        if (renderedElement === void 0) { renderedElement = null; }
        return _super.call(this, jsonObj, renderedElement) || this;
    }
    return Survey;
}(survey_core__WEBPACK_IMPORTED_MODULE_1__["SurveyModel"]));

survey_core__WEBPACK_IMPORTED_MODULE_1__["LocalizableString"].prototype["onCreating"] = function () {
    // var self = this;
    // this.koReRender = ko.observable(0);
    this.koHasHtml = knockout__WEBPACK_IMPORTED_MODULE_0__["observable"](this.hasHtml);
    this.koRenderedHtml = knockout__WEBPACK_IMPORTED_MODULE_0__["observable"](this.renderedHtml);
    // Object.defineProperty(self, "koHasHtml", {
    //   get: () => {
    //     self.koReRender();
    //     return self.hasHtml;
    //   },
    // });
    // this.koRenderedHtml = ko.pureComputed(function() {
    //   self.koReRender();
    //   return self.renderedHtml;
    // });
};
survey_core__WEBPACK_IMPORTED_MODULE_1__["ItemValue"].prototype["onCreating"] = function () {
    new _kobase__WEBPACK_IMPORTED_MODULE_3__["ImplementorBase"](this);
};
survey_core__WEBPACK_IMPORTED_MODULE_1__["LocalizableString"].prototype["onChanged"] = function () {
    // this.koReRender(this.koReRender() + 1);
    var hasHtml = this.hasHtml;
    this.koHasHtml(hasHtml);
    this.koRenderedHtml(hasHtml ? this.getHtmlValue() : this.calculatedText);
};
_surveyTimerModel__WEBPACK_IMPORTED_MODULE_5__["SurveyTimerModel"].prototype["onCreating"] = function () {
    new _kobase__WEBPACK_IMPORTED_MODULE_3__["ImplementorBase"](this);
};
knockout__WEBPACK_IMPORTED_MODULE_0__["components"].register("survey", {
    viewModel: {
        createViewModel: function (params, componentInfo) {
            var survey = knockout__WEBPACK_IMPORTED_MODULE_0__["unwrap"](params.survey);
            setTimeout(function () {
                var surveyRoot = document.createElement("div");
                componentInfo.element.appendChild(surveyRoot);
                survey.render(surveyRoot);
            }, 1);
            // !!ko.tasks && ko.tasks.runEarly();
            return params.survey;
        },
    },
    template: _templateText__WEBPACK_IMPORTED_MODULE_2__["koTemplate"],
});
knockout__WEBPACK_IMPORTED_MODULE_0__["bindingHandlers"]["surveyProp"] = {
    update: function (element, valueAccessor, allBindingsAccessor) {
        var value = knockout__WEBPACK_IMPORTED_MODULE_0__["utils"].unwrapObservable(valueAccessor()) || {};
        for (var propName in value) {
            if (typeof propName == "string") {
                var propValue = knockout__WEBPACK_IMPORTED_MODULE_0__["utils"].unwrapObservable(value[propName]);
                element[propName] = propValue;
            }
        }
    },
};
survey_core__WEBPACK_IMPORTED_MODULE_1__["SurveyModel"].platform = "knockout";
var registerTemplateEngine = function (ko, platform) {
    ko.surveyTemplateEngine = function () { };
    ko.surveyTemplateEngine.prototype = new ko.nativeTemplateEngine();
    ko.surveyTemplateEngine.prototype.makeTemplateSource = function (template, templateDocument) {
        if (typeof template === "string") {
            templateDocument = templateDocument || document;
            var templateElementRoot = templateDocument.getElementById("survey-content-" + platform);
            if (!templateElementRoot) {
                templateElementRoot = document.createElement("div");
                templateElementRoot.id = "survey-content-" + survey_core__WEBPACK_IMPORTED_MODULE_1__["SurveyModel"].platform;
                templateElementRoot.style.display = "none";
                templateElementRoot.innerHTML = _templateText__WEBPACK_IMPORTED_MODULE_2__["koTemplate"];
                document.body.appendChild(templateElementRoot);
            }
            var elem;
            for (var i = 0; i < templateElementRoot.children.length; i++) {
                if (templateElementRoot.children[i].id === template) {
                    elem = templateElementRoot.children[i];
                    break;
                }
            }
            if (!elem) {
                elem = templateDocument.getElementById(template);
            }
            if (!elem) {
                return new ko.nativeTemplateEngine().makeTemplateSource(template, templateDocument);
            }
            return new ko.templateSources.domElement(elem);
        }
        else if (template.nodeType === 1 || template.nodeType === 8) {
            return new ko.templateSources.anonymousTemplate(template);
        }
        else {
            throw new Error("Unknown template type: " + template);
        }
    };
    // (<any>ko).surveyTemplateEngine.prototype.renderTemplateSource = function (templateSource: any, bindingContext: any, options: any, templateDocument: any) {
    //   var useNodesIfAvailable = !((<any>ko.utils).ieVersion < 9),
    //     templateNodesFunc = useNodesIfAvailable ? templateSource["nodes"] : null,
    //     templateNodes = templateNodesFunc ? templateSource["nodes"]() : null;
    //   if (templateNodes) {
    //     return (<any>ko.utils).makeArray(templateNodes.cloneNode(true).childNodes);
    //   } else {
    //     var templateText = templateSource["text"]();
    //     return (<any>ko.utils).parseHtmlFragment(templateText, templateDocument);
    //   }
    // };
    var surveyTemplateEngineInstance = new ko.surveyTemplateEngine();
    ko.setTemplateEngine(surveyTemplateEngineInstance);
};
knockout__WEBPACK_IMPORTED_MODULE_0__["bindingHandlers"]["key2click"] = {
    init: function (element, valueAccessor, allBindingsAccessor, viewModel) {
        var options = valueAccessor() || {
            processEsc: true
        };
        if (viewModel.disableTabStop) {
            element.tabIndex = -1;
            return;
        }
        element.tabIndex = 0;
        element.onkeyup = function (evt) {
            evt.preventDefault();
            evt.stopPropagation();
            Object(_utils_utils__WEBPACK_IMPORTED_MODULE_4__["doKey2ClickUp"])(evt, options);
            return false;
        };
        element.onkeydown = function (evt) { return Object(_utils_utils__WEBPACK_IMPORTED_MODULE_4__["doKey2ClickDown"])(evt, options); };
        element.onblur = function (evt) { return Object(_utils_utils__WEBPACK_IMPORTED_MODULE_4__["doKey2ClickBlur"])(evt); };
    },
};


/***/ }),

/***/ "./src/knockout/templateText.ts":
/*!**************************************!*\
  !*** ./src/knockout/templateText.ts ***!
  \**************************************/
/*! exports provided: koTemplate, SurveyTemplateText */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "koTemplate", function() { return koTemplate; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "SurveyTemplateText", function() { return SurveyTemplateText; });
var koTemplate = __webpack_require__(/*! html-loader?interpolate!val-loader!./templates/entry.html */ "./node_modules/html-loader/index.js?interpolate!./node_modules/val-loader/index.js!./src/knockout/templates/entry.html");
var SurveyTemplateText = /** @class */ (function () {
    function SurveyTemplateText() {
    }
    SurveyTemplateText.prototype.addText = function (newText, id, name) {
        id = this.getId(id, name);
        this.text =
            this.text +
                '<script type="text/html" ' +
                id +
                ">" +
                newText +
                "</script>";
    };
    SurveyTemplateText.prototype.replaceText = function (replaceText, id, questionType) {
        if (questionType === void 0) { questionType = null; }
        var posId = this.getId(id, questionType);
        var pos = this.text.indexOf(posId);
        if (pos < 0) {
            this.addText(replaceText, id, questionType);
            return;
        }
        pos = this.text.indexOf(">", pos);
        if (pos < 0)
            return;
        var startPos = pos + 1;
        var endString = "</script>";
        pos = this.text.indexOf(endString, startPos);
        if (pos < 0)
            return;
        this.text =
            this.text.substr(0, startPos) + replaceText + this.text.substr(pos);
    };
    SurveyTemplateText.prototype.getId = function (id, questionType) {
        var result = 'id="survey-' + id;
        if (questionType) {
            result += "-" + questionType;
        }
        return result + '"';
    };
    Object.defineProperty(SurveyTemplateText.prototype, "text", {
        get: function () {
            return koTemplate;
        },
        set: function (value) {
            koTemplate = value;
        },
        enumerable: false,
        configurable: true
    });
    return SurveyTemplateText;
}());



/***/ }),

/***/ "./src/knockout/templates/comment.html":
/*!*********************************************!*\
  !*** ./src/knockout/templates/comment.html ***!
  \*********************************************/
/*! no static exports found */
/***/ (function(module, exports) {

module.exports = "<script type=\"text/html\" id=\"survey-comment\">\n  <!--ko if: !question.isReadOnlyRenderDiv() -->\n<textarea data-bind=\"attr: { maxLength: question.getOthersMaxLength(), 'aria-required': question.ariaRequired, 'aria-label': question.ariaLabel, placeholder: question.commentOrOtherPlaceHolder }, \n        event: { input: function(s, e) { $data.question.onCommentInput(s, e); } }, \n        value: $data.question.comment, \n        visible: $data.visible,\n        disable: $data.question.isInputReadOnly,\n        style: { resize: question.resizeStyle },\n        css: $data.question.koCss().other\"></textarea>\n<!--/ko-->\n\n<!--ko if: question.isReadOnlyRenderDiv() -->\n<div data-bind=\"text: question.comment\"></div>\n<!--/ko-->\n</script>";

/***/ }),

/***/ "./src/knockout/templates/flowpanel.html":
/*!***********************************************!*\
  !*** ./src/knockout/templates/flowpanel.html ***!
  \***********************************************/
/*! no static exports found */
/***/ (function(module, exports) {

module.exports = "<script type=\"text/html\" id=\"survey-flowpanel\">\n  <div data-bind=\"style: { flexBasis: renderWidth, flexGrow: 1, flexShrink: 1, width: renderWidth, minWidth: $data.minWidth, maxWidth: $data.maxWidth }, attr: { id: id }, css: cssClasses.panel.container\">\n      <h4 data-bind=\"visible: (processedTitle.length > 0), css: question.cssTitle\">\n          <!-- ko template: { name: 'survey-string', data: locTitle } -->\n          <!-- /ko -->\n      </h4>\n      <div data-bind=\"css: cssClasses.panel.description\">\n          <!-- ko template: { name: 'survey-string', data: locDescription } -->\n          <!-- /ko -->\n      </div>\n      <div data-bind=\"style: { paddingLeft: innerPaddingLeft }\"></div>\n      <f-panel params=\"question: question\" data-bind=\"attr: { contenteditable : question.isDesignMode, placeHolder: question.placeHolder }\"></f-panel>\n  </div>\n</script>\n<script type=\"text/html\" id=\"survey-flowpanel-question\">\n  <!-- ko with: $parent.question.getQuestionByName($data) -->\n    <!-- ko template: { name: koElementType(), data: $data, as: 'question', afterRender: parent.koElementAfterRender } --><!-- /ko -->\n  <!-- /ko -->\n</script>\n";

/***/ }),

/***/ "./src/knockout/templates/header.html":
/*!********************************************!*\
  !*** ./src/knockout/templates/header.html ***!
  \********************************************/
/*! no static exports found */
/***/ (function(module, exports) {

module.exports = "<script type=\"text/html\" id=\"survey-header\">\n  <!-- ko if: renderedHasHeader -->\n<div data-bind=\"css: css.header\">\n  <!-- ko if: isLogoBefore -->\n  <!-- ko component: { name: getElementWrapperComponentName($data, 'logo-image'), params: getElementWrapperComponentData($data, 'logo-image') } -->\n  <!-- /ko -->\n  <!-- /ko -->\n\n  <!-- ko if: renderedHasTitle -->\n  <div data-bind=\"css: css.headerText, style: { maxWidth: titleMaxWidth }\">\n    <!-- ko component: { name: 'survey-element-title', params: {element: $data } } -->\n    <!-- /ko -->\n    <!-- ko if: renderedHasDescription -->\n    <h5 data-bind=\"css: css.description\">\n      <!-- ko template: { name: 'survey-string', data: locDescription } -->\n      <!-- /ko -->\n    </h5>\n    <!-- /ko -->\n  </div>\n  <!-- /ko -->\n\n  <!-- ko if: isLogoAfter -->\n  <!-- ko component: { name: getElementWrapperComponentName($data, 'logo-image'), params: getElementWrapperComponentData($data, 'logo-image') } -->\n  <!-- /ko -->\n  <!-- /ko -->\n  <div data-bind=\"css: css.headerClose\"></div>\n</div>\n<!-- /ko -->\n</script>";

/***/ }),

/***/ "./src/knockout/templates/index.html":
/*!*******************************************!*\
  !*** ./src/knockout/templates/index.html ***!
  \*******************************************/
/*! no static exports found */
/***/ (function(module, exports) {

module.exports = "<script type=\"text/html\" id=\"survey-content\">\n    <!-- ko template: { name: \"survey-content-template\", afterRender: $data.implementor.koEventAfterRender } -->\n    <!-- /ko -->\n</script>\n\n<script type=\"text/html\" id=\"survey-content-template\">\n  <div data-bind=\"css: css.root\">\n      <form onsubmit=\"return false;\">\n          <div class=\"sv_custom_header\" data-bind=\"visible: !hasLogo\"></div>\n          <div data-bind=\"css: css.container\">\n              <!-- ko template: { name: koTitleTemplate, afterRender: koAfterRenderHeader } -->\n              <!-- /ko -->\n              <!-- ko if: isShowingPage -->\n              <div data-bind=\"css: bodyCss\">\n                  <!-- ko if: isTimerPanelShowingOnTop && !isShowStartingPage -->\n                  <!-- ko template: { name: 'survey-timerpanel' } -->\n                  <!-- /ko -->\n                  <!-- /ko -->\n                  <!-- ko if: isShowProgressBarOnTop && !isShowStartingPage -->\n                  <!-- ko component: { name: 'sv-progress-' + progressBarType, params: { model: $data } } -->\n                  <!-- /ko -->\n                  <!-- /ko -->\n                  <!-- ko if: isNavigationButtonsShowingOnTop -->\n                  <!-- ko template: { name: 'survey-navigation' } -->\n                  <!-- /ko -->\n                  <!-- /ko -->\n                  <!-- ko if: activePage -->\n                    <div data-bind=\"attr: { id: activePage.id }, template: { name: 'survey-page', data: activePage, afterRender: koAfterRenderPage }\"></div>\n                    <!-- ko if: activePage.rows.length == 0 && $data.emptyPageTemplate -->\n                    <!-- ko template: { name: emptyPageTemplate, data: $data.emptyPageTemplateData || $data } -->\n                    <!-- /ko -->\n                    <!-- /ko -->\n                  <!-- /ko -->\n                  <!-- ko if: isShowProgressBarOnBottom && !isShowStartingPage -->\n                  <!-- ko component: { name: 'sv-progress-' + progressBarType, params: { model: $data } } -->\n                  <!-- /ko -->\n                  <!-- /ko -->\n                  <!-- ko if: isTimerPanelShowingOnBottom && !isShowStartingPage -->\n                  <!-- ko template: { name: 'survey-timerpanel' } -->\n                  <!-- /ko -->\n                  <!-- /ko -->\n                  <!-- ko if: isNavigationButtonsShowingOnBottom -->\n                  <!-- ko template: { name: 'survey-navigation' } -->\n                  <!-- /ko -->\n                  <!-- /ko -->\n              </div>\n              <!-- /ko -->\n              <!-- ko if: state == \"completed\" && showCompletedPage -->\n              <div data-bind=\"html: processedCompletedHtml, css: completedCss\"></div>\n              <div data-bind=\"visible: completedState != '', css: css.saveData.root\">\n                  <div data-bind=\"css: completedStateCss\">\n                      <span data-bind=\"text:completedStateText\"></span>\n                      <input type=\"button\" data-bind=\"visible: completedState == 'error', value: getLocString('saveAgainButton'), click: doComplete, css: css.saveData.saveAgainButton\"/>\n                  </div>\n              </div>\n              <!-- /ko -->\n              <!-- ko if: state == \"completedbefore\" -->\n              <div data-bind=\"html: processedCompletedBeforeHtml, css: css.body\"></div>\n              <!-- /ko -->\n              <!-- ko if: state == \"loading\" -->\n              <div data-bind=\"html: processedLoadingHtml, css: css.body\"></div>\n              <!-- /ko -->\n              <!-- ko if: state == \"empty\" -->\n              <div data-bind=\"text:emptySurveyText, css: css.bodyEmpty\"></div>\n              <!-- /ko -->\n          </div>\n      </form>\n  </div>\n</script>\n<script type=\"text/html\" id=\"survey-navigation\">\n  <div data-bind=\"css: css.footer\">\n      <input type=\"button\" data-bind=\"value: startSurveyText, click: start, visible: isShowStartingPage, css: cssNavigationStart\"/>\n      <input type=\"button\" data-bind=\"event: { mousedown: navigationMouseDown }, value: locPagePrevText.koRenderedHtml, click: prevPage, visible: isShowPrevButton, css: cssNavigationPrev\" />\n      <input type=\"button\" data-bind=\"event: { mousedown: nextPageMouseDown }, value: locPageNextText.koRenderedHtml, click: nextPageUIClick, visible: isShowNextButton, css: cssNavigationNext\" />\n      <input type=\"button\" data-bind=\"event: { mousedown: navigationMouseDown }, value: locPreviewText.koRenderedHtml, click: showPreview, visible: isPreviewButtonVisible, css: cssNavigationPreview\" />\n      <input type=\"button\" data-bind=\"event: { mousedown: navigationMouseDown }, value: locCompleteText.koRenderedHtml, click: completeLastPage, visible: isCompleteButtonVisible, css: cssNavigationComplete\" />\n  </div>\n</script>";

/***/ }),

/***/ "./src/knockout/templates/page.html":
/*!******************************************!*\
  !*** ./src/knockout/templates/page.html ***!
  \******************************************/
/*! no static exports found */
/***/ (function(module, exports) {

module.exports = "<script type=\"text/html\" id=\"survey-page\">\n  <div data-bind=\"css: cssClasses.page.root\">\n    <!-- ko component: { name: 'survey-element-title', params: {element: $data } } --><!-- /ko -->\n    <!-- ko if: _showDescription-->\n    <div\n      data-bind=\"visible: data.showPageTitles, css: cssClasses.page.description\"\n    >\n      <!-- ko template: { name: 'survey-string', data: locDescription } -->\n      <!-- /ko -->\n    </div>\n    <!-- /ko -->\n    <!-- ko template: { name: 'survey-rows', data: $data} -->\n    <!-- /ko -->\n  </div>\n</script>\n";

/***/ }),

/***/ "./src/knockout/templates/panel.html":
/*!*******************************************!*\
  !*** ./src/knockout/templates/panel.html ***!
  \*******************************************/
/*! no static exports found */
/***/ (function(module, exports) {

module.exports = "<script type=\"text/html\" id=\"survey-panel\">\n  <!-- ko if: $data.isVisible -->\n  <div\n    data-bind=\"attr: { id: id }, css: $data.getContainerCss(), event: {focusin: focusIn}\"\n  >\n    <!-- ko if: hasDescription || hasTitle  -->\n    <div data-bind=\"css: cssClasses.panel.header\">\n      <!-- ko component: { name: 'survey-element-title', params: {element: $data } } --><!-- /ko -->\n      <!-- ko if: hasDescription -->\n        <div data-bind=\"css: cssClasses.panel.description\">\n          <!-- ko template: { name: 'survey-string', data: locDescription } -->\n          <!-- /ko -->\n        </div>\n        <!-- /ko -->\n    </div>\n    <!-- /ko -->\n    <!-- ko template: { name: 'survey-question-errors', data: $data } -->\n    <!-- /ko -->\n    <!-- ko if: state != \"collapsed\" -->\n    <div\n      data-bind=\"style: { paddingLeft: innerPaddingLeft }, css: cssClasses.panel.content, attr: {id:contentId}\"\n    >\n      <!-- ko template: { name: 'survey-rows', data: $data} -->\n      <!-- /ko -->\n      <!-- ko component: { name: 'sv-action-bar', params: { model: getFooterToolbar() } } -->\n      <!-- /ko -->\n    </div>\n    <!-- /ko -->\n  </div>\n  <!-- /ko -->\n</script>\n";

/***/ }),

/***/ "./src/knockout/templates/question-boolean.html":
/*!******************************************************!*\
  !*** ./src/knockout/templates/question-boolean.html ***!
  \******************************************************/
/*! no static exports found */
/***/ (function(module, exports) {

module.exports = "<script type=\"text/html\" id=\"survey-question-boolean\">\n  <div data-bind=\"css: question.koCss().root\">\n    <label data-bind=\"css: question.getItemCss()\">\n      <input\n        type=\"checkbox\"\n        data-bind=\"value: question.checkedValue, css: question.koCss().control, attr: {name: question.name, id: question.inputId, 'aria-required': question.ariaRequired, 'aria-label': question.ariaLabel, 'aria-invalid': question.ariaInvalid, 'aria-describedby': question.ariaDescribedBy}, checked: question.checkedValue, surveyProp: {indeterminate: question.isIndeterminate}, enable: !question.isInputReadOnly\"\n      />\n      <span\n        data-bind=\"css: question.getLabelCss(false), click: onFalseLabelClick\"\n        ><!-- ko template: { name: 'survey-string', data: locLabelFalse } --><!-- /ko --></span\n      >\n      <div data-bind=\"css: question.koCss().switch, click: onSwitchClick\">\n        <span data-bind=\"css: question.koCss().slider\">\n            <!-- ko if: question.koCss().sliderText && question.isDeterminated -->\n            <span data-bind=\"css: question.koCss().sliderText\">\n              <!-- ko template: { name: 'survey-string', data: question.getCheckedLabel() } --><!-- /ko -->\n            </span>\n            <!-- /ko -->\n        </span>\n      </div>\n      <span\n        data-bind=\"css: question.getLabelCss(true), click: onTrueLabelClick\"\n        ><!-- ko template: { name: 'survey-string', data: locLabelTrue } --><!-- /ko --></span\n      >\n    </label>\n  </div>\n</script>";

/***/ }),

/***/ "./src/knockout/templates/question-buttongroup.html":
/*!**********************************************************!*\
  !*** ./src/knockout/templates/question-buttongroup.html ***!
  \**********************************************************/
/*! no static exports found */
/***/ (function(module, exports) {

module.exports = "<script type=\"text/html\" id=\"survey-question-buttongroup\">\n  <div role=\"group\" data-bind=\"css: question.koCss().root\">\n      <!-- ko foreach: question.visibleChoices -->\n        <!-- ko component: { name: 'sv-button-group-item', params: { question: question, item: $data, index: $index } } -->\n        <!-- /ko -->\n      <!-- /ko -->\n    </div>\n</script>\n";

/***/ }),

/***/ "./src/knockout/templates/question-checkbox.html":
/*!*******************************************************!*\
  !*** ./src/knockout/templates/question-checkbox.html ***!
  \*******************************************************/
/*! no static exports found */
/***/ (function(module, exports) {

module.exports = "<script type=\"text/html\" id=\"survey-question-checkbox\">\n  <fieldset data-bind=\"css: question.getSelectBaseRootCss()\" role=\"presentation\">\n      <legend role=\"presentation\" class=\"sv-hidden\"></legend>\n      <!-- ko ifnot: question.hasColumns  -->\n        <!-- ko foreach: { data: question.visibleChoices, as: 'item', afterRender: question.koAfterRender }  -->\n          <!-- ko component: { name: question.getItemValueWrapperComponentName(item), params: { componentData:  question.getItemValueWrapperComponentData(item), templateData: { name: 'survey-checkbox-item', data: item } } } -->\n          <!-- /ko -->\n        <!-- /ko -->\n      <!-- /ko -->\n      <!-- ko if: question.hasColumns  -->\n        <!-- ko foreach: question.columns -->\n            <div data-bind=\"css: question.getColumnClass()\" role=\"presentation\">\n            <!-- ko foreach: { data: $data, as: 'item', afterRender: question.koAfterRender }  -->\n              <!-- ko component: { name: question.getItemValueWrapperComponentName(item), params: { componentData:  question.getItemValueWrapperComponentData(item), templateData: { name: 'survey-checkbox-item', data: item } } } -->\n              <!-- /ko -->\n            <!-- /ko -->\n            </div>\n        <!-- /ko -->\n      <!-- /ko -->\n    </fieldset>\n</script>\n<script type=\"text/html\" id=\"survey-checkbox-item\">\n  <div role=\"presentation\" data-bind=\"css: question.getItemClass(item)\">\n      <label data-bind=\"css: question.getLabelClass(item), attr: { 'aria-label': question.getAriaItemLabel(item) }\">\n          <!-- ko if: item == question.selectAllItem -->\n          <input type=\"checkbox\" data-bind=\"attr: {name: question.name, id: question.getItemId(item), 'aria-describedby': question.ariaDescribedBy }, checked: question.koAllSelected, enable: question.getItemEnabled(item), css: question.koCss().itemControl\"/>\n          <!-- /ko -->\n          <!-- ko if: item != question.selectAllItem -->\n          <input type=\"checkbox\" data-bind=\"attr: {name: question.name, id: question.getItemId(item), 'aria-describedby': question.ariaDescribedBy }, checkedValue: item.value, checked: question.koValue, enable: question.getItemEnabled(item), css: question.koCss().itemControl\"/>\n          <!-- /ko -->\n              <!-- ko if: question.koCss().materialDecorator -->\n              <span data-bind=\"css: question.koCss().materialDecorator\">\n                <!-- ko if: question.itemSvgIcon -->\n                <svg data-bind=\"css:question.koCss().itemDecorator\">\n                  <use data-bind=\"attr:{'xlink:href':question.itemSvgIcon}\" xlink:href=''></use>\n                </svg>\n                <!-- /ko -->\n              </span>\n              <!-- /ko -->\n              <span data-bind=\"visible: !item.hideCaption, css: question.koCss().controlLabel\">\n              <!-- ko template: { name: 'survey-string', data: item.locText } -->\n              <!-- /ko -->\n          </span>\n      </label>\n      <!-- ko if: question.isOtherItem(item) -->\n      <div class=\"form-group\" data-bind=\"template: { name: 'survey-comment', data: {'question': question, 'visible': question.isOtherSelected } }\"></div>\n      <!-- /ko -->\n  </div>\n</script>\n";

/***/ }),

/***/ "./src/knockout/templates/question-comment.html":
/*!******************************************************!*\
  !*** ./src/knockout/templates/question-comment.html ***!
  \******************************************************/
/*! no static exports found */
/***/ (function(module, exports) {

module.exports = "<script type=\"text/html\" id=\"survey-question-comment\">\n  <!--ko if: !question.isReadOnlyRenderDiv() -->\n<textarea data-bind=\"attr: {'readonly': question.renderedInputReadOnly, 'disabled': question.renderedInputDisabled, maxLength: question.getMaxLength(), cols: question.cols, rows: question.rows, id: question.inputId, placeholder: question.renderedPlaceHolder, 'aria-required': question.ariaRequired, 'aria-label': question.ariaLabel, 'aria-invalid': question.ariaInvalid, 'aria-describedby': question.ariaDescribedBy}, \n  event: { input: function(s, e) { question.onInput(e); }, keydown: function(s, e) { question.onKeyDown(e); return true; } }, \n  value: question.value, \n  style: { resize: question.resizeStyle },\n  css: question.className\"></textarea>\n<!--/ko-->\n\n<!--ko if: question.isReadOnlyRenderDiv() -->\n<div data-bind=\"text: question.value\"></div>\n<!--/ko-->\n</script>";

/***/ }),

/***/ "./src/knockout/templates/question-composite.html":
/*!********************************************************!*\
  !*** ./src/knockout/templates/question-composite.html ***!
  \********************************************************/
/*! no static exports found */
/***/ (function(module, exports) {

module.exports = "<script type=\"text/html\" id=\"survey-question-composite\">\n  <!-- ko template: { name: 'survey-panel', data: question.contentPanel, as: 'question', afterRender: question.contentPanel.koPanelAfterRender } -->\n  <!-- /ko -->\n</script>\n";

/***/ }),

/***/ "./src/knockout/templates/question-custom.html":
/*!*****************************************************!*\
  !*** ./src/knockout/templates/question-custom.html ***!
  \*****************************************************/
/*! no static exports found */
/***/ (function(module, exports) {

module.exports = "<script type=\"text/html\" id=\"survey-question-custom\">\n  <!-- ko template: { name: question.contentQuestion.koTemplateName(), data: question.contentQuestion, as: 'question', afterRender: question.contentQuestion.koQuestionAfterRender } -->\n  <!-- /ko -->\n</script>\n";

/***/ }),

/***/ "./src/knockout/templates/question-dropdown.html":
/*!*******************************************************!*\
  !*** ./src/knockout/templates/question-dropdown.html ***!
  \*******************************************************/
/*! no static exports found */
/***/ (function(module, exports) {

module.exports = "<script type=\"text/html\" id=\"survey-question-dropdown\">\n  <div data-bind=\"css: question.renderCssRoot\">\n    <!-- ko component: { name: 'sv-dropdown', params: { question: question } } -->\n    <!-- /ko -->\n  <!-- ko if: question.isOtherSelected -->\n  <div class=\"form-group\"\n    data-bind=\"template: { name: 'survey-comment', data: {'question': question, 'visible': question.isOtherSelected } }, style: {display: question.isFlowLayout ? 'inline': ''}\">\n  </div>\n  <!-- /ko -->\n  </div>\n</script>\n";

/***/ }),

/***/ "./src/knockout/templates/question-empty.html":
/*!****************************************************!*\
  !*** ./src/knockout/templates/question-empty.html ***!
  \****************************************************/
/*! no static exports found */
/***/ (function(module, exports) {

module.exports = "<script type=\"text/html\" id=\"survey-question-empty\">\n    <div></div>\n</script>\n";

/***/ }),

/***/ "./src/knockout/templates/question-errors.html":
/*!*****************************************************!*\
  !*** ./src/knockout/templates/question-errors.html ***!
  \*****************************************************/
/*! no static exports found */
/***/ (function(module, exports) {

module.exports = "<script type=\"text/html\" id=\"survey-question-errors\">\n        <!-- ko if: hasVisibleErrors -->\n            <div role=\"alert\" aria-live=\"polite\" data-bind=\"visible: hasVisibleErrors, foreach: { data: errors, as: 'error' }, css: koErrorClass(), attr: { id: question.id + '_errors' }\">\n            <!-- ko if: error.visible -->\n            <div>   \n                <span aria-hidden=\"true\" data-bind=\"css: question.koCss().error.icon\"></span>\n                <span data-bind=\"css: question.koCss().error.item\">\n                    <!-- ko template: { name: 'survey-string', data: error.locText } --><!-- /ko -->\n                </span>\n            </div>\n            <!-- /ko -->\n        </div>\n        <!-- /ko -->\n</script>";

/***/ }),

/***/ "./src/knockout/templates/question-expression.html":
/*!*********************************************************!*\
  !*** ./src/knockout/templates/question-expression.html ***!
  \*********************************************************/
/*! no static exports found */
/***/ (function(module, exports) {

module.exports = "<script type=\"text/html\" id=\"survey-question-expression\">\n  <div data-bind=\"text:question.formatedValue, css: question.koCss().root\"></div>\n</script>\n";

/***/ }),

/***/ "./src/knockout/templates/question-file.html":
/*!***************************************************!*\
  !*** ./src/knockout/templates/question-file.html ***!
  \***************************************************/
/*! no static exports found */
/***/ (function(module, exports) {

module.exports = "<script type=\"text/html\" id=\"survey-question-file\">\n  <div data-bind=\"css: question.fileRootCss\">\n      <!-- ko ifnot: question.isInputReadOnly -->\n      <input type=\"file\" data-bind=\"css: question.cssClasses.fileInput, attr: { id: question.inputId, 'aria-required': question.ariaRequired, 'aria-label': question.ariaLabel, 'aria-invalid': question.ariaInvalid, 'aria-describedby': question.ariaDescribedBy, multiple: question.allowMultiple ? 'multiple' : undefined, title: koInputTitle, accept: question.acceptedTypes }, event: { change: question.dochange }\">\n      <!-- /ko -->\n      <!-- ko if: question.isReadOnly -->\n      <input type=\"file\" disabled data-bind=\"css: question.getReadOnlyFileCss(), attr: { placeholder: question.title, multiple: question.allowMultiple ? 'multiple' : undefined }\" style=\"color: transparent;\"/>\n      <!-- /ko -->\n      <div data-bind=\"css: question.getFileDecoratorCss(), event: { dragover: question.ondragover, drop: question.ondrop, dragleave: question.ondragleave }\">\n        <span data-bind=\"css: question.koCss().dragAreaPlaceholder, text: question.dragAreaPlaceholder\"></span>\n        <div data-bind=\"css: question.koCss().wrapper\">\n          <label role=\"button\" data-bind=\"css: question.koChooseFileCss, attr: { for: question.inputId, 'aria-label': question.chooseButtonCaption }\">\n            <span data-bind=\"text: question.chooseButtonCaption\"></span>\n            <!-- ko if: question.cssClasses.chooseFileIconId -->\n                <!-- ko component: { name: 'sv-svg-icon', params: { title: question.removeFileCaption, iconName: question.cssClasses.chooseFileIconId, size: 'auto' } } --><!-- /ko -->\n            <!-- /ko -->\n          </label>\n          <!-- ko if: !question.koHasValue() -->\n          <span data-bind=\"css: question.koCss().noFileChosen, text: question.noFileChosenCaption\"></span>\n          <!-- /ko -->\n        </div>\n      </div>\n      <!-- ko template: { name: 'survey-question-file-clean-button', data: {question: question, removeButtonCss: question.cssClasses.removeButton} } --><!-- /ko -->\n      <!-- ko if: question.showPreview -->\n      <!-- ko if: question.koHasValue -->\n      <div data-bind=\"css: question.cssClasses.fileList, foreach: question.koData, visible: question.koHasValue\">\n          <span data-bind=\"visible: question.isPreviewVisible($index()), css: question.cssClasses.preview\">\n            <!-- ko template: { name: 'survey-question-file-sign', data: {question: question, item: $data, fileSignCss: question.cssClasses.fileSign} } --><!-- /ko -->\n            <div data-bind=\"css: question.cssClasses.imageWrapper\">\n              <!-- ko if: question.canPreviewImage($data) -->\n              <img data-bind=\"attr: { src: $data.content, height: question.imageHeight, width: question.imageWidth }\" alt=\"File preview\">\n              <!-- /ko -->\n              <!-- ko if: !question.canPreviewImage($data) && question.cssClasses.defaultImageIconId -->\n              <!-- ko component: { name: 'sv-svg-icon', params: { css: question.cssClasses.defaultImage, iconName: question.cssClasses.defaultImageIconId, size: 'auto' } } --><!-- /ko -->\n              <!-- /ko -->\n              <!-- ko if: $data.name -->\n              <!-- ko ifnot: question.isReadOnly -->\n              <div data-bind=\"click: question.doremovefile, css: question.cssClasses.removeFileButton\">\n                  <span data-bind=\"css: question.cssClasses.removeFile, text: question.removeFileCaption\"></span>\n                  <!-- ko if: question.cssClasses.removeFileSvgIconId -->\n                    <!-- ko component: { name: 'sv-svg-icon', params: { css: question.cssClasses.removeFileSvg, title: question.removeFileCaption, iconName: question.cssClasses.removeFileSvgIconId, size: 'auto' } } --><!-- /ko -->\n                  <!-- /ko -->\n              </div>\n              <!-- /ko -->\n              <!-- /ko -->\n            </div>\n            <!-- ko template: { name: 'survey-question-file-sign', data: {question: question, item: $data, fileSignCss: question.cssClasses.fileSignBottom} } --><!-- /ko -->\n          </span>\n      </div>\n      <!-- /ko -->\n      <!-- /ko -->\n      <!-- ko template: { name: 'survey-question-file-clean-button', data: {question: question, removeButtonCss: question.cssClasses.removeButtonBottom} } --><!-- /ko -->\n      <!-- ko if: question.mobileFileNavigatorVisible -->\n      <!-- ko component: { name: 'sv-action-bar', params: { model: question.mobileFileNavigator } } -->\n      <!-- /ko -->\n      <!-- /ko -->\n  </div>\n</script>\n<script type=\"text/html\" id=\"survey-question-file-clean-button\">\n  <!-- ko if: question.koHasValue() && !question.isReadOnly && $data.removeButtonCss-->\n  <button type=\"button\" data-bind=\"css: removeButtonCss, disabled: question.isInputReadOnly, click: question.doclean\">\n      <span data-bind=\"text: question.cleanButtonCaption\"></span>\n      <!-- ko if: question.cssClasses.removeButtonIconId -->\n        <!-- ko component: { name: 'sv-svg-icon', params: { iconName: question.cssClasses.removeButtonIconId, size: 'auto' } } --><!-- /ko -->\n\n      <!-- /ko -->\n  </button>\n  <!-- /ko -->\n</script>\n<script type=\"text/html\" id=\"survey-question-file-sign\">\n  <!-- ko if: item.name && fileSignCss -->\n  <div data-bind=\"css: fileSignCss\">\n    <a data-bind=\"style: { width: question.imageWidth + 'px' }, click: question.dodownload, text: item.name, attr: { href: item.content, title: item.name, download: item.name }\"></a>\n  </div>\n  <!-- /ko -->\n</script>\n";

/***/ }),

/***/ "./src/knockout/templates/question-html.html":
/*!***************************************************!*\
  !*** ./src/knockout/templates/question-html.html ***!
  \***************************************************/
/*! no static exports found */
/***/ (function(module, exports) {

module.exports = "<script type=\"text/html\" id=\"survey-question-html\">\n  <div data-bind=\"html: question.locHtml.koRenderedHtml, css: question.koCss().root\"></div>\n</script>\n";

/***/ }),

/***/ "./src/knockout/templates/question-image.html":
/*!****************************************************!*\
  !*** ./src/knockout/templates/question-image.html ***!
  \****************************************************/
/*! no static exports found */
/***/ (function(module, exports) {

module.exports = "<script type=\"text/html\" id=\"survey-question-image\">\n  <div data-bind=\"css: question.koCss().root\">\n    <!-- ko if: question.renderedMode === \"image\" -->\n    <img data-bind=\"css: question.getImageCss(), attr: { src: $data.locImageLink.koRenderedHtml(), width: question.renderedWidth, height: question.renderedHeight, alt: question.text || question.title }, style: { objectFit: question.imageFit }\"/>\n    <!-- /ko -->\n    <!-- ko if: question.renderedMode === \"video\" -->\n    <video controls data-bind=\"css: question.getImageCss(), attr: { src: $data.locImageLink.koRenderedHtml(), width: question.renderedWidth, height: question.renderedHeight }, style: { objectFit: question.imageFit }\"></video>\n    <!-- /ko -->\n    <!-- ko if: question.renderedMode === \"youtube\" -->\n    <iframe data-bind=\"css: question.getImageCss(), attr: { src: $data.locImageLink.koRenderedHtml(), width: question.renderedWidth, height: question.renderedHeight }, style: { objectFit: question.imageFit }\"></iframe>\n    <!-- /ko -->\n  </div>\n</script>\n";

/***/ }),

/***/ "./src/knockout/templates/question-imagepicker.html":
/*!**********************************************************!*\
  !*** ./src/knockout/templates/question-imagepicker.html ***!
  \**********************************************************/
/*! no static exports found */
/***/ (function(module, exports) {

module.exports = "<script type=\"text/html\" id=\"survey-question-imagepicker\">\n  <fieldset data-bind=\"css: question.koCss().root\">\n      <legend data-bind=\"attr: { 'aria-label': question.locTitle.renderedHtml }\" role=\"radio\"></legend>\n      <!-- ko foreach: { data: question.visibleChoices, as: 'item', afterRender: question.koAfterRender}  -->\n        <!-- ko component: { name: question.getItemValueWrapperComponentName(item), params: { componentData:  question.getItemValueWrapperComponentData(item), templateData: { name: 'survey-imagepicker-item', data: item } } } -->\n        <!-- /ko -->\n      <!-- /ko -->\n  </fieldset>\n</script>\n<script type=\"text/html\" id=\"survey-imagepicker-item\">\n    <div data-bind=\"css: question.getItemClass(item)\">\n        <label data-bind=\"css: question.koCss().label\">\n            <input data-bind=\"attr: {type: question.inputType, name: question.questionName, value: item.value, id: question.getItemId(item), 'aria-required': question.ariaRequired, 'aria-label': question.ariaLabel, 'aria-invalid': question.ariaInvalid, 'aria-describedby': question.ariaDescribedBy}, checked: question.koValue, enable: question.getItemEnabled(item), css: question.koCss().itemControl\"\n            />\n            <div data-bind=\"css: question.koCss().itemDecorator\">\n                <div data-bind=\"css: question.koCss().imageContainer\">\n                  <!-- ko if: question.contentMode === \"image\" -->\n                  <img data-bind=\"css: question.koCss().image, attr: { src: $data.locImageLink.koRenderedHtml, width: question.renderedImageWidth, height: question.renderedImageHeight, alt: item.locText.koRenderedHtml }, style: { objectFit: question.imageFit }\"/>\n                  <!-- /ko -->\n                  <!-- ko if: question.contentMode === \"video\" -->\n                  <video controls data-bind=\"css: question.koCss().image, attr: { src: $data.locImageLink.koRenderedHtml, width: question.renderedImageWidth, height: question.renderedImageHeight }, style: { objectFit: question.imageFit }\"></video>\n                  <!-- /ko -->\n                </div>\n                <!-- ko if: question.showLabel -->\n                <span data-bind=\"css: question.koCss().itemText\">\n                  <!-- ko template: { name: 'survey-string', data: item.locText } -->\n                  <!-- /ko -->\n                </span>\n                <!-- /ko -->\n            </div>\n        </label>\n    </div>\n</script>";

/***/ }),

/***/ "./src/knockout/templates/question-matrix.html":
/*!*****************************************************!*\
  !*** ./src/knockout/templates/question-matrix.html ***!
  \*****************************************************/
/*! no static exports found */
/***/ (function(module, exports) {

module.exports = "<script type=\"text/html\" id=\"survey-question-matrix\">\n  <div data-bind=\"css: question.koCss().tableWrapper\">\n    <fieldset>\n      <legend\n        data-bind=\"attr: { 'aria-label': question.locTitle.renderedHtml }\"\n      ></legend>\n      <table data-bind=\"css: question.koCss().root\">\n        <!-- ko if: question.showHeader -->\n        <thead>\n          <tr>\n            <td data-bind=\"visible: question.hasRows\"></td>\n            <!-- ko foreach: question.koVisibleColumns -->\n            <th data-bind=\"css: question.koCss().headerCell\">\n              <!-- ko component: { name: question.getColumnHeaderWrapperComponentName($data), params: { componentData:  question.getColumnHeaderWrapperComponentData($data), templateData: { data: $data } } } -->\n                <!-- ko template: { name: 'survey-string', data: $data.locText } --><!-- /ko -->\n              <!-- /ko -->\n            </th>\n            <!-- /ko -->\n          </tr>\n        </thead>\n        <!-- /ko -->\n        <tbody>\n          <!-- ko foreach: { data: question.koVisibleRows, as: 'row' } -->\n          <tr data-bind=\"css: row.rowClasses\">\n            <td\n              data-bind=\"visible: question.hasRows, css: question.koCss().cell\"\n            >\n              <!-- ko component: { name: question.getRowHeaderWrapperComponentName($data), params: { componentData:  question.getRowHeaderWrapperComponentData($data), templateData: { data: $data } } } -->\n                <!-- ko template: { name: 'survey-string', data: row.locText } -->\n                <!-- /ko -->\n              <!-- /ko -->\n            </td>\n            <!-- ko foreach: question.koVisibleColumns -->\n            <!-- ko if: question.hasCellText -->\n            <td\n              data-bind=\"css: question.getItemClass(row, $data), click: function() { if (!question.isInputReadOnly) { row.cellClick($data); } }\"\n            >\n              <!-- ko template: { name: 'survey-string', data: question.getCellDisplayLocText(row.name, $data) } -->\n              <!-- /ko -->\n            </td>\n            <!-- /ko -->\n            <!-- ko if: !question.hasCellText -->\n            <td\n              data-bind=\"attr: { 'data-responsive-title': $data.locText.renderedHtml }, css: question.koCss().cell\"\n            >\n              <label data-bind=\"css: question.getItemClass(row, $data)\">\n                <input\n                  type=\"radio\"\n                  data-bind=\"css: question.koCss().itemValue, attr: { name: row.fullName, 'aria-required': question.ariaRequired, 'aria-label': $data.locText.renderedHtml, 'aria-invalid': question.ariaInvalid, 'aria-describedby': question.ariaDescribedBy, id: question.inputId + '_' + row.name + '_' + $index() }, checkedValue: $data.value, checked: row.value, enable: !question.isInputReadOnly\"\n                />\n                <span data-bind=\"css: question.koCss().materialDecorator\">\n                  <svg\n                    data-bind=\"css:question.koCss().itemDecorator\"\n                    viewBox=\"-12 -12 24 24\"\n                  >\n                    <circle r=\"6\" cx=\"0\" cy=\"0\" />\n                  </svg>\n                </span>\n                <span class=\"circle\"></span>\n                <span class=\"check\"></span>\n                <span\n                  style=\"display: none\"\n                  data-bind=\"text: $data.locText.text\"\n                ></span>\n              </label>\n            </td>\n            <!-- /ko -->\n            <!-- /ko -->\n          </tr>\n          <!-- /ko -->\n        </tbody>\n      </table>\n    </fieldset>\n  </div>\n</script>\n<script type=\"text/html\" id=\"survey-text\">\n  <span data-bind=\"text:$data.renderedHtml\"></span>\n</script>\n";

/***/ }),

/***/ "./src/knockout/templates/question-matrixdynamic.html":
/*!************************************************************!*\
  !*** ./src/knockout/templates/question-matrixdynamic.html ***!
  \************************************************************/
/*! no static exports found */
/***/ (function(module, exports) {

module.exports = "﻿<script type=\"text/html\" id=\"survey-question-matrixdynamic\">\n    <div>\n    <!-- ko if: question.koTable().showAddRowOnTop -->\n    <div\n      data-bind=\"css: question.koCss().footer\"\n    >\n      <button\n        type=\"button\"\n        data-bind=\"click: question.isDesignMode ? undefined : question.koAddRowClick, css: question.getAddRowButtonCss(), disable: question.isInputReadOnly\"\n      >\n        <!-- ko template: { name: 'survey-string', data: question.locAddRowText } --><!-- /ko -->\n        <span data-bind=\"css: question.koCss().iconAdd\"></span>\n      </button>\n    </div>\n    <!-- /ko -->\n    <div\n      data-bind=\"visible: question.koTable().showTable, style: { overflowX: question.showHorizontalScroll ? 'scroll': '' }\"\n    >\n      <table data-bind=\"css: question.koCss().root\">\n        <!-- ko if: question.koTable().showHeader -->\n        <thead>\n          <tr>\n            <!-- ko foreach: question.koTable().headerRow.cells -->\n            <th\n              data-bind=\"style: { minWidth: $data.minWidth, width: $data.width }, css: $data.className\"\n            >\n              <!-- ko if: $data.hasTitle -->\n              <!-- ko component: { name: question.getColumnHeaderWrapperComponentName($data), params: { componentData:  question.getColumnHeaderWrapperComponentData($data), templateData: { data: $data } } } -->\n                <!-- ko template: { name: 'survey-string', data: $data.locTitle } --><!-- /ko -->\n                <!-- ko if: $data.requiredText -->\n                <span data-bind=\"text: $data.requiredText\"></span>\n                <!-- /ko -->\n              <!-- /ko -->\n              <!-- /ko -->\n            </th>\n            <!-- /ko -->\n          </tr>\n        </thead>\n        <!-- /ko -->\n        <tbody>\n          <!-- ko foreach: question.koTable().rows -->\n          <!-- ko ifnot: $parent.detailPanelMode === \"popup\" && $data.isDetailRow -->\n          <tr data-bind=\"css: $data.className, attr: attributes, event: { pointerdown: function (model, event) { question.onPointerDown(event, row); return true;} }\">\n            <!-- ko foreach: $data.cells -->\n            <!-- ko if: $data.isDragHandlerCell -->\n            <td data-bind=\"css:$data.className, attr: {colspan: $data.colSpans}\">\n              <!-- ko component: { name: 'sv-matrix-drag-drop-icon', params: { item: { data: { row: row, question: question } } }} -->\n              <!-- /ko -->\n            </td>\n            <!-- /ko -->\n            <!-- ko if: $data.isActionsCell -->\n            <td data-bind=\"css: $data.className, attr: { colspan: $data.colSpans }\">\n              <!-- ko component: { name: 'sv-action-bar', params: { model: $data.item.getData(), handleClick: false } } -->\n              <!-- /ko -->\n            </td>\n            <!-- /ko -->\n            <!-- ko if: $data.isEmpty -->\n            <td data-bind=\"attr: { colspan: $data.colSpans }\"></td>\n            <!-- /ko -->\n            <!-- ko if: $data.hasPanel -->\n            <td data-bind=\"css: $data.className, attr: { colspan: $data.colSpans }\">\n              <!-- ko component: { name: $data.panel.survey.getElementWrapperComponentName($data.panel), \n                params: { componentData:  $data.panel.survey.getElementWrapperComponentData($data.panel), \n                templateData: { name: $data.panel.koElementType, data: $data.panel, afterRender: question.koElementAfterRender } } } \n              -->\n              <!-- /ko -->\n            </td>\n            <!-- /ko -->\n            <!-- ko if: $data.hasQuestion -->\n            <!-- ko template: { name: 'survey-matrixcell', afterRender: function(els) { $data.matrix.koCellAfterRender(els, $data); } } --><!-- /ko -->\n            <!-- /ko -->\n            <!-- ko if: $data.hasTitle -->\n            <td\n              data-bind=\"css: $data.className, style: { minWidth: $data.minWidth, width: $data.width }\"\n            >\n              <!-- ko component: { name: question.getRowHeaderWrapperComponentName($data), params: { componentData:  question.getRowHeaderWrapperComponentData($data), templateData: { data: $data } } } -->\n              <!-- ko template: { name: 'survey-string', data: $data.locTitle } --><!-- /ko -->\n              <!-- ko if: $data.requiredText -->\n              <span data-bind=\"text: $data.requiredText\"></span>\n              <!-- /ko -->\n              <!-- /ko -->\n            </td>\n            <!-- /ko -->\n            <!-- /ko -->\n          </tr>\n\n     