## **SurveyJS** is a JavaScript Survey and Form Library.

**SurveyJS** is a modern way to add surveys and forms to your website. It has versions for Angular, jQuery, knockout, react and vue.

[![Build Status](https://dev.azure.com/SurveyJS/SurveyJS%20Integration%20Tests/_apis/build/status/SurveyJS%20Library?branchName=master)](https://dev.azure.com/SurveyJS/SurveyJS%20Integration%20Tests/_build/latest?definitionId=7&branchName=master)
[![Software License](https://img.shields.io/badge/license-MIT-brightgreen.svg?style=flat)](LICENSE)
<a href="https://github.com/DevExpress/testcafe">
<img alt="Tested with TestCafe" src="https://img.shields.io/badge/tested%20with-TestCafe-2fa4cf.svg">
</a>
<a href="https://github.com/surveyjs/survey-library/issues">
<img alt="Issues" title="Open Issues" src="https://img.shields.io/github/issues/surveyjs/survey-library.svg">
</a>
<a href="https://github.com/surveyjs/survey-library/issues?utf8=%E2%9C%93&q=is%3Aissue+is%3Aclosed+">
<img alt="Closed issues" title="Closed Issues" src="https://img.shields.io/github/issues-closed/surveyjs/survey-library.svg">
</a>

## Documentation

[SurveyJS Library Documentation](https://surveyjs.io/Documentation/Library)

## Live Examples

[SurveyJS Library Live Examples](https://surveyjs.io/Examples/Library)

## Survey Creator / Form Builder

[Create your Survey or Form now](https://surveyjs.io/create-survey)

Survey Creator sources are [here](https://github.com/surveyjs/survey-creator)

## Export Survey to PDF

[Export to PDF overview](https://surveyjs.io/Overview/Survey-Pdf-Export)

Export to PDF sources are [here](https://github.com/surveyjs/survey-pdf)

## More info about SurveyJS

**SurveyJS** is the most feature-rich Survey / Form Library available at the current moment. It can be easily customized and extended to suit your needs.

![alt tag](https://cloud.githubusercontent.com/assets/22315929/22462339/ed33f60a-e7bd-11e6-942b-72882e6bf1db.gif)

## Main Features

### A lot of question types with a lot of built-in functionalities.

* [Text Question](https://surveyjs.io/Examples/Library/?id=questiontype-text)
* [Radigroup Question](https://surveyjs.io/Examples/Library/?id=questiontype-radiogroup)
* [Dropdown Question](https://surveyjs.io/Examples/Library/?id=questiontype-dropdown)
* [Checkboxes Question](https://surveyjs.io/Examples/Library/?id=questiontype-checkbox)
* [Boolean Question](https://surveyjs.io/Examples/Library/?id=questiontype-boolean)
* [Matrix Question](https://surveyjs.io/Examples/Library/?id=questiontype-matrix)
* [Matrix Rubric Question](https://surveyjs.io/Examples/Library/?id=questiontype-matrix-rubric)
* [Matrix Dropdown Question](https://surveyjs.io/Examples/Library/?id=questiontype-matrixdropdown)
* [Matrix Dynamic Question](https://surveyjs.io/Examples/Library/?id=questiontype-matrixdynamic)
* [Multiple Text Question](https://surveyjs.io/Examples/Library/?id=questiontype-multipletext)
* [Rating Question](https://surveyjs.io/Examples/Library/?id=questiontype-rating)
* [Ranking Question](https://surveyjs.io/Examples/Library?id=questiontype-ranking)
* [Comment Question](https://surveyjs.io/Examples/Library/?id=questiontype-comment)
* [Html Question](https://surveyjs.io/Examples/Library/?id=questiontype-html)
* [Files uploading Question](https://surveyjs.io/Examples/Library/?id=questiontype-file)
* [Panel Container](https://surveyjs.io/Examples/Library/?id=questiontype-panel)
* [Panel Dynamic Question](https://surveyjs.io/Examples/Library/?id=questiontype-paneldynamic)
* [Expression Question](https://surveyjs.io/Examples/Library/?id=questiontype-expression)
* [Image Picker Question](https://surveyjs.io/Examples/Library/?id=questiontype-imagepicker)
* [Support for third-party popular UI widgets](https://surveyjs.io/Examples/Library/?id=custom-widget-select2). The custom widgets [GitHub repo](https://github.com/surveyjs/widgets)

### Multiple Pages Support

You may create a very complex forms with a lot of pages, like [this one](https://surveyjs.io/Examples/Library/?id=real-patient-history).

### Dynamically change survey logic and questions content

* [Change questions visibility using logical expressions](https://surveyjs.io/Examples/Library/?id=condition-kids)
* [Create custom functions to use it in expression](https://surveyjs.io/Examples/Library/?id=condition-customfunctions)
* [Filter choices in checkbox, radiogroup and dropdown questions](https://surveyjs.io/Examples/Library/?id=condition-choicesVisibleIf)
* [Filter rows and columns in matrix question](https://surveyjs.io/Examples/Library/?id=condition-matrixVisibleIf)
* [Disabled/enabled questions based on logical expressions](https://surveyjs.io/Examples/Library/?id=condition-enable-kids)
* [Questions value validation](https://surveyjs.io/Examples/Library/?id=validators-standard)

### Localization and Multiple language support

* [Localization for over 20 languages](https://surveyjs.io/Examples/Library/?id=survey-localization&platform)
* [Multiple language support in one survey](https://surveyjs.io/Examples/Library/?id=survey-multilanguages)

### Appearance and custom Rendering

* [Seven built-in Themes](https://surveyjs.io/Examples/Library/?id=darkblue-theme)
* [Bootstrap support](https://surveyjs.io/Examples/Library/?id=bootstrap-theme)
* [CSS styles customization](https://surveyjs.io/Examples/Library/?id=survey-cssclasses)
* [API for adding new or changing existing HTML elements](https://surveyjs.io/Examples/Library/?id=survey-afterrender)
* [Render Questions in one line](https://surveyjs.io/Examples/Library/?id=survey-startwithnewline)
* [Markdown support](https://surveyjs.io/Examples/Library/?id=survey-markdown-radiogroup)

### Frequently used functionalities

* [Quiz creation](https://surveyjs.io/Examples/Library/?id=survey-quiz)
* [Show survey or form in the popup window](https://surveyjs.io/Examples/Library/?id=survey-window)
* [Display mode](https://surveyjs.io/Examples/Library/?id=survey-displaymode)
* [Custom navigation](https://surveyjs.io/Examples/Library/?id=survey-customnavigation)
* [Sharing same data between questions](https://surveyjs.io/Examples/Library/?id=survey-shareddata)

### To find out more about the library

* go to the [SurveyJS Library Site](https://surveyjs.io/Library)
* explore the live [Examples](https://www.surveyjs.io/Examples/Library)
* and create a survey or form using [Survey Creator](https://surveyjs.io/survey/Builder/)

#### You can use our quickstart repos:

* [Angular CLI](https://github.com/surveyjs/surveyjs_angular_cli)
* [React](https://github.com/surveyjs/surveyjs_react_quickstart)
* [Vue](https://github.com/surveyjs/surveyjs_vue_quickstart)

## Getting started

Install the library using npm.

Angular version:

```
npm install survey-angular
```

jQuery version:

```
npm install survey-jquery
```

Knockout version:

```
npm install survey-knockout
```

React version:

```
npm install survey-react
```

Vue version:

```
npm install survey-vue
```

Or use unpkg CDN:

* https://unpkg.com/survey-angular@{version-number}/survey.angular.min.js
* https://unpkg.com/survey-knockout@{version-number}/survey.ko.min.js
* https://unpkg.com/survey-react@{version-number}/survey.react.min.js
* https://unpkg.com/survey-jquery@{version-number}/survey.jquery.min.js
* https://unpkg.com/survey-vue@{version-number}/survey.vue.min.js

You find all versions/builds in the [surveyjs/build repo](https://github.com/surveyjs/builds).

Or dowload a version as zip file from [Releases](https://github.com/surveyjs/survey-library/releases)

If you want to import it in another script:

```javascript
import * as Survey from "survey-jquery";
```

## Building survey.js from sources

To build library yourself:

1.  **Clone the repo from GitHub**

    ```
    git clone https://github.com/surveyjs/survey-library.git
    cd survey-library
    ```

2.  **Acquire build dependencies.** Make sure you have [Node.js](http://nodejs.org/) installed on your workstation. You need a version of Node.js greater than 6.0.0 and npm greater than 2.7.0. This is only needed to _build_ surveyjs from sources.

    ```
    npm install -g karma-cli
    npm install
    ```

3.  **Build the library**

    ```
    npm run build_prod
    ```

    After that you should have the libraries (angular, jquery, knockout, react and vue) at 'packages' directory.

4.  **Run samples**

    ```
    npm start
    ```

    This command will run local http server at the http://localhost:7777
    You can open http://localhost:7777/examples/knockout to view KnockoutJS samples, http://localhost:7777/examples/react to view ReactJS samples and so on

5.  **Run unit tests**
    ```
    karma start
    ```
    This command will run unit tests using [Karma](https://karma-runner.github.io/0.13/index.html)

### WordPress integration

[SurveyJS WordPress plugin](https://wordpress.org/plugins/surveyjs/)

## License

[MIT license](https://github.com/surveyjs/survey-library/blob/master/LICENSE)
